! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE KMATSUB_Cs(IFAIL)
C     
C***********************************************************************
C     
C     KMATSUB deletes unwanted elements of K-matrices: its primary use 
c     is to convert K-matrices calculated in Cs symmetry to C3v where 
c     the latter is the natural symmetry of the system.
c     This program works only for targets with an A1 ground state.

c     !!! The current version is adapted to lmax=4 !!!

C     It is intended to be a self contained module which can be
C     run independantly from the main scattering calculation.
C     On exit, IFAIL=0 indicates succesful termination, else IFAIL=1
C     
C***********************************************************************
C     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (maxch=1000,maxtgt=10,maxern=10)
      PARAMETER (nsym=2)
      PARAMETER (ncha1=7,ncha2=2,nche=8)
      CHARACTER*80 NAME
      DIMENSION IPRNT(6),
     1 ichl(maxch),lchl(maxch),mchl(maxch),echl(maxch),ipoint(maxch),
     2 ip(maxch),inchl(maxch),lnchl(maxch),mnchl(maxch),enchl(maxch),
     3 mtarg(maxtgt),starg(maxtgt),einc(2,maxern),
     4 gtarg(maxtgt),etarg(maxtgt),nescat(maxern),nerep(maxern),
     5 lukmtv(nsym),luchanv(nsym)
      integer, allocatable :: ivtarg(:),ivnu(:),ichst(:)
      double precision, allocatable :: akmat(:),akm(:,:)
      double precision, allocatable :: akmatn(:,:),akmatf(:,:)
      double precision, allocatable :: akmatt(:,:,:)
      CHARACTER*11 KFORM,CFORM,MODDAT
      CHARACTER*9 FORM
      CHARACTER*1 IKFORM,ICFORM
      CHARACTER*20 DAYTIM
      INTEGER STOT,GUTOT,starg,gtarg
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
C     
C***********************************************************************
C     
C     Basic data is input via namelist /SUBKIN/
C     EREQ     = REQUIRED SCATTERING ENERGY 
C     IEUNIT   = UNITS IN WHICH THESE ENERGIES ARE INPUT, 1= RYD, 2= EV
C     ICFORM   = 'F' IF LUCHAN IS FORMATTED, ELSE 'U'
C     IPRNT    = Print switches
C     IKFORM   = 'F' IF LUTMK IS FORMATTED, ELSE 'U'
C     IWRITE   = LOGICAL UNIT FOR PRINTED OUTPUT
C     LUCHNI   = LOGICAL UNIT FOR CHANNEL input
C     LUCHNO   = Logical unit for channel output
C     LUKMTI   = LOGICAL UNIT FOR K-MATRIX input
C     LUKMTO   = LOGICAL UNIT FOR K-MATRIX OUTPUT
c     LUCHANV  = vector containing the logical units for channel input 
c                files
c     LUKMTV   = vector containing the logical units for K-matrix input
c                files
C     MAXI     = LABEL OF HIGHEST INITIAL STATE FOR WHICH K-matrices
C                are required
C     MAXF     = LABEL OF HIGHEST FINAL STATE FOR WHICH K-matrices
C                are required (it is assumed that MAXF.ge.MAXI)
C     MAXV     = size of the partial C3v k-matrix from each Cs symmetry.
C     MAXVT    = size of the final C3v k-matrix.
C                The default values are correct for lmax=4.
C     MREQ     = Required Irreducible Representation of the C3v symmetry
C                0 gives A1; 1 gives A2, and 2 gives E (doubly degenerate).
c     NCHA1, NCHA2, NCHE are the number of C3v channels for each symmetry.
c                 The default values are for lmax=4. 
C     NCSETi   = SET NUMBER OF input CHANNEL DATA 
C     NKSETi   = SET NUMBER FOR K-MATRIX input
C     R        = BOND LENGTHS OF GEOMETRIES TO BE USED IN ADIABATIC
C                AVERAGE
C     NAME     = TITLE FOR ANY OUTPUT
C     
      NAMELIST/subKIN/LUKMTI,IEUNIT,IWRITE,MAXI,MAXF,NAME,r,
     1  LUKMTO,NKSETi,nKSETo,LUCHNI,NCSETi,ncseto,ICFORM,IKFORM,IPRNT,
     2  LUCHANV,LUKMTV,LUCHNO,maxvt,emin,emax,mreq
C     
C***********************************************************************
C     
      DATA LUKMTI/19/,LUKMTO/13/,NKSETi,ncseti/1,1/,
     1     IEUNIT/1/,LUCHNI/10/,LUCHNO/11/,maxvt/0/,
     2     LUCHANv,LUKMTv/nsym*10,nsym*19/,
     3     MAXI,MAXF/1,0/,MREQ/0/,ICFORM,IKFORM/2*'U'/,
     4     IPRNT/6*0/,nKSETo,ncseto/1,1/
      DATA ZERO/0.D0/,eps/1.d-8/,vbig/1.d+8/
      DATA FORM/'FORMATTED'/
      DATA MODDAT/'20-Dec-2001'/
C     
      IFAIL = 0
      IWRITE = 6
      EMIN = ZERO
      EMAX = VBIG
      CFORM = FORM
      KFORM = FORM
c     NKSETi=1
      r = zero
      nvib = 0
      ndis = 0
C     
C---- Read basic data via namelist /SUBKIN/
      READ(5,subKIN)
      IF(ICFORM.EQ.'U') CFORM='UN'//FORM
      IF(IKFORM.EQ.'U') KFORM='UN'//FORM
C     
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,100)MODDAT,NAME
c     
C---- Set size of the final C3v K-matrices
c     !!! Default values adapted to lmax=4 !!!
c
      if (mreq.eq.0) maxvt=ncha1
      if (mreq.eq.1) maxvt=ncha2
      if (mreq.eq.2) maxvt=nche
c
c --- Read the total number of energies from the first K-matrix 
c     (This number and the energy range are assumed to be the same 
c     for each Cs K-matrix). Note that the file lukmti will be rewinded 
c     below by 'call READKH'. 
c
      lukmti=lukmtv(1)
      read(lukmti,*) 
      read(lukmti,*) 
      read(lukmti,*) 
      read(lukmti,*) ntarg,nvib,ndis,nchan,maxne
      nentot=0
      do i=1,maxne
         read(lukmti,*) l,nerep(l),(einc(j,l),j=1,2)
         nentot = nentot+nerep(i)
      enddo
c
C---- Allocate final C3v K-matrices
c
      allocate (akmatt(nentot,maxvt,maxvt))
c     
C---- LOOP over all symmetries
c     
      do js=1,nsym   
c     ! js is the index referring to the Cs symmetries

         write(iwrite,510)js
 510     format(/' ----------------------------------------------------
     &        K-matrix ',i2)
c         
         lukmti=lukmtv(js)
         luchni=luchanv(js)
c
         NKSETi=1
c

         WRITE(IWRITE,11)CFORM,LUCHNI,NCSETi
         WRITE(IWRITE,32)KFORM,LUKMTI,NKSETI
         WRITE(IWRITE,21)CFORM,LUCHNo,NCSETo
         WRITE(IWRITE,33)KFORM,LUKMTO,NKSETO
c
         CALL READKH(LUKMTi,NKSETi,MGVN,STOT,GUTOT,NCHAN,NVIB,NDIS,
     1   NTARG,ION,NERANG,NESCAT,EINC,RR,NAPPR,KFORM,IWRITE,IPRNT(2),
     2   IFAIL)
         IF(IFAIL.NE.0) go to 96
         IF(NCHAN.GT.MAXCH) GO TO 97
c     
c     
C---- DECIDE HOW MANY initial and FINAL STATES ARE REQUIRED
c     
         NVIBD = NVIB+NDIS
         IF(NVIBD.EQ.0) NVIBD = NTARG
         MXI = MAXI
 15      IF(MAXF.EQ.0) THEN
            MXF = NVIBD
         ELSE 
            MXF = MAXF
         ENDIF
C     
c     
C---- CALCULATE TOTAL NUMBER OF SCATTERING ENERGIES
c     
         NETOT = 0
         DO I=1,NERANG
            NETOT = NETOT+NESCAT(I)
         enddo
         if (netot.ne.nentot) then
            write(iwrite,77) nentot, netot
 77         format(/'INPUT PARAMETER NENTOT=',I4,' NOT EQUAL TO
     1           NETOT=',I4)
            stop
         endif
         
C     
C-----Assign storage for energy independant data
c     
         allocate (ivtarg(nvibd),ivnu(nvibd),ichst(nvibd))
C     
C-----READ TARGET AND CHANNEL DATA
         NOCHAN = NCHAN
         NDIS0 = NDIS
         CALL READTC(LUCHNI,NCSETi,NOCHAN,NVIB,NDIS0,NTARG,
     1   ION,ivtARG,IVNU,ichl,lchl,mchl,echl,STARG,MTARG,GTARG,
     2   ETARG,R,RMASS,CFORM,IWRITE,iprnt(2)-1,IFAIL)
         if(ifail.ne.0) go to 196

c     
C---- Determines MAXCHI and MAXCHF
c     
         NVCHAN = NCHAN-NDIS
         NSTAT  = NVIBD-NDIS
         CALL CHSUB(NVCHAN,NSTAT,MXI,MXF,MAXCHI,MAXCHF,ICHL,ichst)
c     
C---- Update all channel data
         CALL CHUPD(NCHAN,ichl,lchl,mchl,echl,maxnj,inchl,lnchl,
     1        mnchl,enchl,ipoint,mreq)
c     
c---- Determines the size of new K-matrix
c 
         if(maxnj.gt.0) then
            NCHAN = maxnj
C     
c     
C---- WRITE NEW CHANNEL FILE
c
            CALL WRITCH(LUCHNO,NCSETo,CFORM,r,RMASS,inchl,lnchl,mnchl,
     1           enchl,NTARG,STARG,MTARG,GTARG,ETARG,ivtARG,IVNU,NAME,
     2           IPRNT(5),IFAIL)
            IF(IFAIL.NE.0) go to 296
C     
C---- Write header to K-matrix file
c
            CALL WRTKH(LUKMTo,NKSETo,KFORM,NAME,MGVN,STOT,GUTOT,ION,R,
     1           RMASS,NCHAN,NVIB,NDIS,NTARG,NERANG,NESCAT,EINC,NETOT,
     2           IPRNT(1),IWRITE,IFAIL)
            IF(IFAIL.NE.0) go to 396
c     
C     
C---- Calculate number of scattering energies in the range [EMIN,EMAX]
C     and adjust NERANG,NESCAT and EINC accordingly
c     
            call NEWE(emin,emax,netot,NERANG,nescat,einc)
c     
C---- Allocate space for all K-matrices 
c     
c     akmat is a (one-dimensional) vector, input for READKM
c     akm is akmat in 2-dimensions
c     akmatn is the new akm
c     akmatf is the resized akmatn, input for WRTKM
c     
            LTMT = MAXCHI*(MAXCHI+1)/2
            allocate (akmat(ltmt))
            allocate (akm(maxchi,maxchi))
            allocate (akmatn(nchan,nchan))
c     
C--   Determine the size -MAXV- of the partial C3v K-matrices 
c     from each Cs symmetry. It supposes that Einc < 1st electronic 
c     threshold which means that maxchi=nopen. In other words, the 
c     excited electronic states can not be included in the current version. 
c     
            maxv=0
            do k=1,maxchi
               if (ipoint(k).ne.0) then
                  maxv=ipoint(k)
               endif
            enddo
c     
            allocate (akmatf(maxv,maxv))
C     
C---- LOOP OVER ENERGIES
C     
            DO 25 i=1,NETOT
c     
               CALL READKM(NOPEN,NDOPEN,NCHAN2,EN,AKMAT)
               IF(EN.LT.Emin-EPS.OR.EN.GT.Emax+EPS) GO TO 25
c     
C---- Calculate dimensions of required submatrix
c     MAXVI = MIN(NOPEN-NDOPEN,MAXCHI)
c     MAXVJ = MIN(NOPEN-NDOPEN,MAXCHF)
c     
               call KMEXP(nchan,maxchi,maxchf,ndis,maxv,maxnj,
     &              nopen,ipoint,akmat,akm,akmatn,akmatf,mnchl)
c     
C---- Ordering of the different C3v symmetries
c     ip(j) is a pointer from the different C3v channels to the ordered
c     (symmetry-adapted) C3v channels.
c
               if (mreq.eq.0) then
                  do j=1,maxv
                     if (lnchl(j).eq.0) ip(j)=1
                     if (lnchl(j).eq.1) ip(j)=2
                     if (lnchl(j).eq.2) ip(j)=3
                     if (lnchl(j).eq.3.and.mnchl(j).eq.0)  ip(j)=4
                     if (lnchl(j).eq.3.and.mnchl(j).eq.-3) ip(j)=5
                     if (lnchl(j).eq.4.and.mnchl(j).eq.0)  ip(j)=6
                     if (lnchl(j).eq.4.and.mnchl(j).eq.-3) ip(j)=7
                  enddo
               elseif (mreq.eq.1) then
                  do j=1,maxv
                     if (lnchl(j).eq.3.and.mnchl(j).eq.3) ip(j)=1
                     if (lnchl(j).eq.4.and.mnchl(j).eq.3) ip(j)=2
                  enddo
               elseif (mreq.eq.2) then
                  do j=1,maxv
                     if (lnchl(j).eq.1) ip(j)=1
                     if (lnchl(j).eq.2.and.mnchl(j).eq.1) ip(j)=2
                     if (lnchl(j).eq.2.and.mnchl(j).eq.2) ip(j)=3
                     if (lnchl(j).eq.3.and.mnchl(j).eq.1)  ip(j)=4
                     if (lnchl(j).eq.3.and.mnchl(j).eq.2) ip(j)=5
                     if (lnchl(j).eq.4.and.mnchl(j).eq.1)  ip(j)=6
                     if (lnchl(j).eq.4.and.mnchl(j).eq.2) ip(j)=7
                     if (lnchl(j).eq.4.and.mnchl(j).eq.4) ip(j)=8
                  enddo
               endif
               do j=1,maxv
                  do k=1,j
                     akmatt(i,ip(k),ip(j))=akmatf(k,j)
c     
C---- Next line to ensure that all elements are included.  
c     Otherwise (42-44) is wrongly set to zero because the order of the 
c     R-matrix channels is 44,42 instead of 42,44.
c
                     akmatt(i,ip(j),ip(k))=akmatf(k,j)
                  enddo
               enddo
c     
C---- Write K-matrices to unit LUKMT
c 
               CALL WRTKM(i,maxvt,NDOPEN,EN,AKMATt,netot)
c
C---- end do loop on energies
c
 25         continue
c
            deallocate (ivtarg,ivnu,ichst)
            deallocate (akmat,akm,akmatn,akmatf)
c
C---- Close files 
c
            if(lukmti.gt.0) CLOSE(UNIT=LUKMTi,STATUS='KEEP')
            if(luchni.gt.0) CLOSE(UNIT=LUCHNI,STATUS='KEEP')
            CLOSE(UNIT=LUCHNO,STATUS='KEEP')
            CLOSE(UNIT=LUKMTO,STATUS='KEEP')           
         else
            write(iwrite,195)  mreq,luchni,ncseti
            deallocate (ivtarg,ivnu,ichst)
            if(lukmti.gt.0) CLOSE(UNIT=LUKMTi,STATUS='KEEP')
            if(luchni.gt.0) CLOSE(UNIT=LUCHNI,STATUS='KEEP')
            CLOSE(UNIT=LUCHNO,STATUS='KEEP')
            CLOSE(UNIT=LUKMTO,STATUS='KEEP')           
         endif
c     
C---- end do loop on symmetries (js)
c
      end do
      
      deallocate (akmatt)
c
      WRITE(IWRITE,110)
C
      RETURN
C
 96   write(iwrite,95) mreq,lukmti,nKSETi
      ifail = 1
      return
 196  write(iwrite,195) mreq,luchni,ncseti
      ifail = 1
      return
 296  write(iwrite,295) mreq,luchno,ncseto
      ifail = 1
      return
 396  write(iwrite,395) mreq,lukmto,nKSETo
      ifail = 1
      return
 97   WRITE(IWRITE,91) NCHAN,MAXCH
      IFAIL = 1
      return
C
 91   FORMAT(/' NUMBER OF INPUT CHANNELS NCHAN =',I3,' EXCEEDS FIXED DIM
     1ENSION MAXCH =',I3)
 95   FORMAT(/' Unable to find K-matrices for symmetry',i3,' on K
     1-matrix file LUKMTI =',I3,'   set ',I3)
 195  FORMAT(/' Unable to find channel data for symmetry',i3,' on
     1 channel file LUCHNI =',I3,'   set ',I3)
 295  FORMAT(/' Unable to write channel data for symmetry',i3,' t
     1o file LUKMTO =',I3,'   set ',I3)
 395  FORMAT(/' Unable to write K-matrices for symmetry',i3,' to
     1file LUKMTO =',I3,'   set ',I3)
 11   FORMAT(/' Input datasets:',33X,'Unit and Set numbers'/
     1' Target and channel data   LUCHNI (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 21   FORMAT(/' Output datasets:',32X,'Unit  Set numbers'/
     1' Target and channel data   LUCHNO (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 32   FORMAT(/' K-matrices',16X,'LUKMTI (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 33   FORMAT(/' K-matrices',16X,'LUKMTO (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 100  FORMAT('1',//' Program KMATSUB  (last modified ',A,' )'//,1X,A/)
 110  FORMAT(/' *** Task successfully completed ***')

 977  FORMAT('the value is ',I5)
      END
!
!
