! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE KMATSUB_Cinfv(IFAIL)
C     
C***********************************************************************
C     
C     KMATSUB deletes unwanted elements of K-matrices: its primary use 
c     is to convert K-matrices calculated in C2v symmetry to C-inf-v where 
c     the latter is the symmetry of the linear molecule without a centre of 
c     inversion.
c     This program works only for targets with an A1 ground state.

c     !!! The current version is adapted to lmax=4 !!!

C     It is intended to be a self contained module which can be
C     run independantly from the main scattering calculation.
C     On exit, IFAIL=0 indicates succesful termination, else IFAIL=1
C     
C***********************************************************************
C     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (maxch=1000,maxtgt=10,maxern=10)
      PARAMETER (nsym=4)
      PARAMETER (nchs=5,nchp=4,nchd=3,nchph=2,nchg=1)
      CHARACTER*80 NAME
      DIMENSION IPRNT(6),
     1 ichl(maxch),lchl(maxch),mchl(maxch),echl(maxch),ipoint(maxch),
     2 ip(maxch),inchl(maxch),lnchl(maxch),mnchl(maxch),enchl(maxch),
     3 mtarg(maxtgt),starg(maxtgt),einc(2,maxern),
     4 gtarg(maxtgt),etarg(maxtgt),nescat(maxern),nerep(maxern),
     5 lukmtv(nsym),luchanv(nsym)
      integer, allocatable :: ivtarg(:),ivnu(:),ichst(:)
      double precision, allocatable :: akmat(:),akm(:,:)
      double precision, allocatable :: akmatn(:,:),akmatf(:,:)
      double precision, allocatable :: akmatt(:,:,:)
      CHARACTER*11 KFORM,CFORM,MODDAT
      CHARACTER*9 FORM
      CHARACTER*1 IKFORM,ICFORM
      CHARACTER*20 DAYTIM
      INTEGER STOT,GUTOT,starg,gtarg
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
C     
C***********************************************************************
C     
C     Basic data is input via namelist /SUBKIN/
C     EREQ     = REQUIRED SCATTERING ENERGY 
C     IEUNIT   = UNITS IN WHICH THESE ENERGIES ARE INPUT, 1= RYD, 2= EV
C     ICFORM   = 'F' IF LUCHAN IS FORMATTED, ELSE 'U'
C     IPRNT    = Print switches
C     IKFORM   = 'F' IF LUTMK IS FORMATTED, ELSE 'U'
C     IWRITE   = LOGICAL UNIT FOR PRINTED OUTPUT
C     LUCHNI   = LOGICAL UNIT FOR CHANNEL input
C     LUCHNO   = Logical unit for channel output
C     LUKMTI   = LOGICAL UNIT FOR K-MATRIX input
C     LUKMTO   = LOGICAL UNIT FOR K-MATRIX OUTPUT
c     LUCHANV  = vector containing the logical units for channel input 
c                files
c     LUKMTV   = vector containing the logical units for K-matrix input
c                files
C     MAXI     = LABEL OF HIGHEST INITIAL STATE FOR WHICH K-matrices
C                are required
C     MAXF     = LABEL OF HIGHEST FINAL STATE FOR WHICH K-matrices
C                are required (it is assumed that MAXF.ge.MAXI)
C     MAXV     = size of the partial Cinfv k-matrix from each C2v symmetry.
C     MAXVT    = size of the final Cinfv k-matrix.
C                The default values are correct for lmax=4.
C     MREQ     = Required Irreducible Representation of the Cinfv symmetry
C                0 gives s; 1 gives p, and 2 gives d.
c     NCHS, NCHPI, NCHD are the number of Cinfv channels for each symmetry.
c                 The default values are for lmax=4. 
C     NCSETi   = SET NUMBER OF input CHANNEL DATA 
C     NKSETi   = SET NUMBER FOR K-MATRIX input
C     R        = BOND LENGTHS OF GEOMETRIES TO BE USED IN ADIABATIC
C                AVERAGE
C     NAME     = TITLE FOR ANY OUTPUT
C     
      NAMELIST/subKIN/LUKMTI,IEUNIT,IWRITE,MAXI,MAXF,NAME,r,
     1  LUKMTO,NKSETi,nKSETo,LUCHNI,NCSETi,ncseto,ICFORM,IKFORM,IPRNT,
     2  LUCHANV,LUKMTV,LUCHNO,maxvt,emin,emax,mreq
C     
C***********************************************************************
C     
      DATA LUKMTI/19/,LUKMTO/13/,NKSETi,ncseti/1,1/,
     1     IEUNIT/1/,LUCHNI/10/,LUCHNO/11/,maxvt/0/,
     2     LUCHANv,LUKMTv/nsym*10,nsym*19/,
     3     MAXI,MAXF/1,0/,MREQ/0/,ICFORM,IKFORM/2*'U'/,
     4     IPRNT/6*0/,nKSETo,ncseto/1,1/
      DATA ZERO/0.D0/,eps/1.d-8/,vbig/1.d+8/
      DATA FORM/'FORMATTED'/
      DATA MODDAT/'20-Dec-2001'/
C     
      IFAIL = 0
      IWRITE = 6
      EMIN = ZERO
      EMAX = VBIG
      CFORM = FORM
      KFORM = FORM
      r = zero
      nvib = 0
      ndis = 0
C     
C---- Read basic data via namelist /SUBKIN/
      READ(5,subKIN)
      IF(ICFORM.EQ.'U') CFORM='UN'//FORM
      IF(IKFORM.EQ.'U') KFORM='UN'//FORM
C     
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,100)MODDAT,NAME
c     
C---- Set size of the final Cinfv K-matrices
c     !!! Default values adapted to lmax=4 !!!
c
      if (mreq.eq.0) maxvt=nchs
      if (mreq.eq.1) maxvt=nchp
      if (mreq.eq.2) maxvt=nchd
      if (mreq.eq.3) maxvt=nchph
      if (mreq.eq.4) maxvt=nchg
c
c     HEMAL: nchs,...,nchg were modified to tally with the channel data HCN.2A1chan2eV.dat 
c --- Read the total number of energies from the first K-matrix 
c     (This number and the energy range are assumed to be the same 
c     for each C2v K-matrix). Note that the file lukmti will be rewinded 
c     below by 'call READKH'. 
c
      lukmti=lukmtv(1)
      read(lukmti,*) 
      read(lukmti,*) 
      read(lukmti,*) 
      read(lukmti,*) ntarg,nvib,ndis,nchan,maxne
      nentot=0
      do i=1,maxne
         read(lukmti,*) l,nerep(l),(einc(j,l),j=1,2)
         nentot = nentot+nerep(i)
      enddo
c
C---- Allocate final Cinfv K-matrices
c
      allocate (akmatt(nentot,maxvt,maxvt))
c     
C---- LOOP over all symmetries
c     
      do js=1,nsym   
c     ! js is the index referring to the C2v symmetries

         write(iwrite,510)js
 510     format(/' ----------------------------------------------------
     &        K-matrix ',i2)
c         
         lukmti=lukmtv(js)
         luchni=luchanv(js)
c
        NKSETi=1
c       HEMAL: Initially, the output from the job-file that appeals to this source code gives
c       'UNABLE TO LOCATE K-MATRIX SET NUMBER 11  ON UNIT 51
c       Unable to find K-matrices for symmetry  0 on K-matrix file LUKMTI = 51   set  11'
c       The code stopped working beyond this.
c       By adding line 148 one is able to overcome this difficulty.
c
         WRITE(IWRITE,11)CFORM,LUCHNI,NCSETi
         WRITE(IWRITE,32)KFORM,LUKMTI,NKSETI
         WRITE(IWRITE,21)CFORM,LUCHNo,NCSETo
         WRITE(IWRITE,33)KFORM,LUKMTO,NKSETO
c
         CALL READKH(LUKMTi,NKSETi,MGVN,STOT,GUTOT,NCHAN,NVIB,NDIS,
     1   NTARG,ION,NERANG,NESCAT,EINC,RR,NAPPR,KFORM,IWRITE,IPRNT(2),
     2   IFAIL)
         IF(IFAIL.NE.0) go to 96
         IF(NCHAN.GT.MAXCH) GO TO 97
c     
c     
C---- DECIDE HOW MANY initial and FINAL STATES ARE REQUIRED
c     
         NVIBD = NVIB+NDIS
         IF(NVIBD.EQ.0) NVIBD = NTARG
         MXI = MAXI
 15      IF(MAXF.EQ.0) THEN
            MXF = NVIBD
         ELSE 
            MXF = MAXF
         ENDIF
C     
c     
C---- CALCULATE TOTAL NUMBER OF SCATTERING ENERGIES
c     
         NETOT = 0
         DO I=1,NERANG
            NETOT = NETOT+NESCAT(I)
         enddo
         if (netot.ne.nentot) then
            write(iwrite,77) nentot, netot
 77         format(/'INPUT PARAMETER NENTOT=',I4,' NOT EQUAL TO
     1           NETOT=',I4)
            stop
         endif
         
C     
C-----Assign storage for energy independant data
c     
         allocate (ivtarg(nvibd),ivnu(nvibd),ichst(nvibd))
C     
C-----READ TARGET AND CHANNEL DATA
         NOCHAN = NCHAN
         NDIS0 = NDIS
         CALL READTC(LUCHNI,NCSETi,NOCHAN,NVIB,NDIS0,NTARG,
     1   ION,ivtARG,IVNU,ichl,lchl,mchl,echl,STARG,MTARG,GTARG,
     2   ETARG,R,RMASS,CFORM,IWRITE,iprnt(2)-1,IFAIL)
         if(ifail.ne.0) go to 196

c     
C---- Determines MAXCHI and MAXCHF
c     
         NVCHAN = NCHAN-NDIS
         NSTAT  = NVIBD-NDIS
         CALL CHSUB(NVCHAN,NSTAT,MXI,MXF,MAXCHI,MAXCHF,ICHL,ichst)
c     
C---- Update all channel data
         CALL CHUPD(NCHAN,ichl,lchl,mchl,echl,maxnj,inchl,lnchl,
     1        mnchl,enchl,ipoint,mreq)
c     
c---- Determines the size of new K-matrix
c
         if(maxnj.gt.0) then
            NCHAN = maxnj
C     
c     
C---- WRITE NEW CHANNEL FILE
c
            CALL WRITCH(LUCHNO,NCSETo,CFORM,r,RMASS,inchl,lnchl,mnchl,
     1           enchl,NTARG,STARG,MTARG,GTARG,ETARG,ivtARG,IVNU,NAME,
     2           IPRNT(5),IFAIL)
            IF(IFAIL.NE.0) go to 296
C     
C---- Write header to K-matrix file
c
            CALL WRTKH(LUKMTo,NKSETo,KFORM,NAME,MGVN,STOT,GUTOT,ION,R,
     1           RMASS,NCHAN,NVIB,NDIS,NTARG,NERANG,NESCAT,EINC,NETOT,
     2           IPRNT(1),IWRITE,IFAIL)
            IF(IFAIL.NE.0) go to 396
c     
C     
C---- Calculate number of scattering energies in the range [EMIN,EMAX]
C     and adjust NERANG,NESCAT and EINC accordingly
c     
            call NEWE(emin,emax,netot,NERANG,nescat,einc)
c     
C---- Allocate space for all K-matrices 
c     
c     akmat is a (one-dimensional) vector, input for READKM
c     akm is akmat in 2-dimensions
c     akmatn is the new akm
c     akmatf is the resized akmatn, input for WRTKM
c     
            LTMT = MAXCHI*(MAXCHI+1)/2
            allocate (akmat(ltmt))
            allocate (akm(maxchi,maxchi))
            allocate (akmatn(nchan,nchan))
c     
C--   Determine the size -MAXV- of the partial Cinfv K-matrices 
c     from each C2v symmetry. It supposes that Einc < 1st electronic 
c     threshold which means that maxchi=nopen. In other words, the 
c     excited electronic states can not be included in the current version. 
c     
            maxv=0
            do k=1,maxchi
               if (ipoint(k).ne.0) then
                  maxv=ipoint(k)
               endif
            enddo
c     
            allocate (akmatf(maxv,maxv))
C     
C---- LOOP OVER ENERGIES
C     
            DO 25 I=1,NETOT
c     
               CALL READKM(NOPEN,NDOPEN,NCHAN2,EN,AKMAT)
               IF(EN.LT.Emin-EPS.OR.EN.GT.Emax+EPS) GO TO 25
c     
C---- Calculate dimensions of required submatrix
c     MAXVI = MIN(NOPEN-NDOPEN,MAXCHI)
c     MAXVJ = MIN(NOPEN-NDOPEN,MAXCHF)
c     
               call KMEXP(nchan,maxchi,maxv,ndis,maxv,maxnj,
     &             nopen,ipoint,akmat,akm,akmatn,akmatf,mnchl)
c     
C---- Ordering of the different C-inf-v symmetries
c     ip(j) is a pointer from the different C-inf-v channels to the ordered
c     (symmetry-adapted) C-inf-v channels. 
c     HEMAL: modified so as to correlate with the rules in the CHUPD sub-routine
c
               if (mreq.eq.0) then
                  do j=1,maxv
                     if (lnchl(j).eq.0.and.mnchl(j).eq.0) ip(j)=1
                     if (lnchl(j).eq.1.and.mnchl(j).eq.0) ip(j)=2
                     if (lnchl(j).eq.2.and.mnchl(j).eq.0) ip(j)=3
                     if (lnchl(j).eq.3.and.mnchl(j).eq.0) ip(j)=4
                     if (lnchl(j).eq.4.and.mnchl(j).eq.0) ip(j)=5
                  enddo
               elseif (mreq.eq.1) then
                  do j=1,maxv
                     if (lnchl(j).eq.1.and.mnchl(j).eq.1) ip(j)=1
                     if (lnchl(j).eq.2.and.mnchl(j).eq.1) ip(j)=2
                     if (lnchl(j).eq.3.and.mnchl(j).eq.1) ip(j)=3
                     if (lnchl(j).eq.4.and.mnchl(j).eq.1) ip(j)=4
                  enddo
               elseif (mreq.eq.2) then
                  do j=1,maxv
                     if (lnchl(j).eq.2.and.mnchl(j).eq.2) ip(j)=1
                     if (lnchl(j).eq.3.and.mnchl(j).eq.2) ip(j)=2
                     if (lnchl(j).eq.4.and.mnchl(j).eq.2) ip(j)=3
                  enddo
               elseif (mreq.eq.3) then
                  do j=1,maxv
                     if (lnchl(j).eq.3.and.mnchl(j).eq.3) ip(j)=1
                     if (lnchl(j).eq.4.and.mnchl(j).eq.3) ip(j)=2
                  enddo
               elseif (mreq.eq.4) then
                  do j=1,maxv
                     if (lnchl(j).eq.4.and.mnchl(j).eq.4) ip(j)=1
                  enddo
               endif
               do j=1,maxv
                  do k=1,j
                     akmatt(i,ip(k),ip(j))=akmatf(k,j)
c     
C---- Next line to ensure that all elements are included.  
c     Otherwise (42-44) is wrongly set to zero because the order of the 
c     R-matrix channels is 44,42 instead of 42,44.
c
                     akmatt(i,ip(j),ip(k))=akmatf(k,j)
                  enddo
               enddo
c     
C---- Write K-matrices to unit LUKMT
c     
               CALL WRTKM(i,maxvt,NDOPEN,EN,AKMATt,netot)
c
C---- end do loop on energies
c
 25         continue
c
            deallocate (ivtarg,ivnu,ichst)
            deallocate (akmat,akm,akmatn,akmatf)
c
C---- Close files 
c
            if(lukmti.gt.0) CLOSE(UNIT=LUKMTi,STATUS='KEEP')
            if(luchni.gt.0) CLOSE(UNIT=LUCHNI,STATUS='KEEP')
            CLOSE(UNIT=LUCHNO,STATUS='KEEP')
            CLOSE(UNIT=LUKMTO,STATUS='KEEP')           
         else
            write(iwrite,195)  mreq,luchni,ncseti
            deallocate (ivtarg,ivnu,ichst)
            if(lukmti.gt.0) CLOSE(UNIT=LUKMTi,STATUS='KEEP')
            if(luchni.gt.0) CLOSE(UNIT=LUCHNI,STATUS='KEEP')
            CLOSE(UNIT=LUCHNO,STATUS='KEEP')
            CLOSE(UNIT=LUKMTO,STATUS='KEEP')           
         endif
c     
C---- end do loop on symmetries (js)
c
      end do
      
      deallocate (akmatt)
c
      WRITE(IWRITE,110)
C
      RETURN
C
 96   write(iwrite,95) mreq,lukmti,nKSETi
      ifail = 1
      return
 196  write(iwrite,195) mreq,luchni,ncseti
      ifail = 1
      return
 296  write(iwrite,295) mreq,luchno,ncseto
      ifail = 1
      return
 396  write(iwrite,395) mreq,lukmto,nKSETo
      ifail = 1
      return
 97   WRITE(IWRITE,91) NCHAN,MAXCH
      IFAIL = 1
      return
C
 91   FORMAT(/' NUMBER OF INPUT CHANNELS NCHAN =',I3,' EXCEEDS FIXED DIM
     1ENSION MAXCH =',I3)
 95   FORMAT(/' Unable to find K-matrices for symmetry',i3,' on K
     1-matrix file LUKMTI =',I3,'   set ',I3)
 195  FORMAT(/' Unable to find channel data for symmetry',i3,' on
     1 channel file LUCHNI =',I3,'   set ',I3)
 295  FORMAT(/' Unable to write channel data for symmetry',i3,' t
     1o file LUKMTO =',I3,'   set ',I3)
 395  FORMAT(/' Unable to write K-matrices for symmetry',i3,' to
     1file LUKMTO =',I3,'   set ',I3)
 11   FORMAT(/' Input datasets:',33X,'Unit and Set numbers'/
     1' Target and channel data   LUCHNI (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 21   FORMAT(/' Output datasets:',32X,'Unit  Set numbers'/
     1' Target and channel data   LUCHNO (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 32   FORMAT(/' K-matrices',16X,'LUKMTI (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 33   FORMAT(/' K-matrices',16X,'LUKMTO (',A11,')',7(3x,i3,1x,I3)/
     235x,7(3x,i3,1x,I3))
 100  FORMAT('1',//' Program KMATSUB  (last modified ',A,' )'//,1X,A/)
 110  FORMAT(/' *** Task successfully completed ***')
      END
      SUBROUTINE CHUPD(NCHAN,ichl,lchl,mchl,echl,maxnj,inchl,
     1 lnchl,mnchl,enchl,ipoint,mreq)
      implicit double precision(a-h,o-z)
C
C***********************************************************************
C
C     CHUPD adds extra channel data
C      IPOINT is pointer from old channels to new
C  HEMAL: Here I modified the rules of transformation C2v =>C-inf-v
C***********************************************************************
C
      DIMENSION ICHL(NCHAN),lchl(nchan),mchl(nchan),echl(nchan),
     1 inchl(*),lnchl(*),mnchl(*),enchl(*),ipoint(*)
C
      j = 0
      do 1 i=1,nchan
         if (mreq.eq.0) then
           if(mchl(i).eq.0) then
              j = j+1
               ipoint(i) = j
               inchl(j)  = ichl(i)
               lnchl(j)  = lchl(i)
               mnchl(j)  = mchl(i)
               enchl(j)  = echl(i)
            else
               ipoint(i) = 0
            endif 
         elseif (mreq.eq.1) then
            if(mchl(i).eq.1) then
               j = j+1
               ipoint(i) = j
               inchl(j)  = ichl(i)
               lnchl(j)  = lchl(i)
               mnchl(j)  = mchl(i)
               enchl(j)  = echl(i)
            else
               ipoint(i) = 0
            endif
         elseif (mreq.eq.2) then
            if(mchl(i).eq.2) then
               j = j+1
               ipoint(i) = j
               inchl(j)  = ichl(i)
               lnchl(j)  = lchl(i)
               mnchl(j)  = mchl(i)
               enchl(j)  = echl(i)
            else
               ipoint(i) = 0
            endif
         elseif (mreq.eq.3) then
            if(mchl(i).eq.3) then
               j = j+1
               ipoint(i) = j
               inchl(j)  = ichl(i)
               lnchl(j)  = lchl(i)
               mnchl(j)  = mchl(i)
               enchl(j)  = echl(i)
            else
               ipoint(i) = 0
            endif
         elseif (mreq.eq.4) then
            if(mchl(i).eq.4) then
               j = j+1
               ipoint(i) = j
               inchl(j)  = ichl(i)
               lnchl(j)  = lchl(i)
               mnchl(j)  = mchl(i)
               enchl(j)  = echl(i)
            else
               ipoint(i) = 0
            endif
         endif
c     
 1    continue
      maxnj = j
c     
      RETURN
      END
      SUBROUTINE KMEXP(nchan,maxchi,maxchf,ndis,maxv,maxnf,
     &     nopen,ipoint,akmat,akm,akmatn,akmatf,mchl)
      implicit double precision(a-h,o-z)
c
C***********************************************************************
C
C     KMEXP expands K-matrices
C      IPOINT is pointer from old channels to new
C    ,rti/0.707106781186547d0/
C***********************************************************************
C
      DIMENSION ipoint(*),mchl(nchan),akmat(maxchi*(maxchi+1)/2),
     1     akm(maxchi,maxchi),akmatn(maxnf,maxnf),
     2     akmatf(maxv,maxv)
      data zero/0.d0/
C
c---- Transform akmat to a 2-D matrix akm
c
      k = 0
      do 11 j=1,nopen
         do 10 i=1,j
            k = k+1
            akm(i,j) = akmat(k)
 10      CONTINUE
 11   continue
c
c     clear space for new K-matrix akmatn
c
      do 21 j=1,maxnf
         do 22 i=1,j
            akmatn(i,j) = zero
 22      continue
 21   continue
c
c     construction of akmatn
c
      do 2 j=1,nopen
         if(ipoint(j).eq.0) go to 2
         do 12 i=1,j
            if(ipoint(i).eq.0) go to 12
            akmatn(ipoint(i),ipoint(j)) = akm(i,j)
 12      continue
 2    continue
c
c     reset actual dimensions to akmatf
c
      do j=1,maxv
         do i=1,j
            akmatf(i,j)=akmatn(i,j)
         enddo
      enddo
c
      RETURN
      END
!#######################################################

      SUBROUTINE WRTKH(LUKMAT,NKSET,KFORM0,TITLE,MGVN0,STOT0,
     1     GUTOT0,ION0,R,RMASS,NCHAN0,NVIB0,NDIS0,NTARG,MAXNE,
     2     NEREP,EINC,NETOT,IPRNT0,IWRIT0,IFAIL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     WRTKH writes header on K-matrix file on unit LUKMT
C     It has been adapted from WRITKH (OUTERIO) by changing the size of 
C     AKMAT.
C      
C     If NKSET = 1 on input then K-matrices are written as the first se
C              = 0 then they are written at end-of-information
C     On output NKSET holds the actual set number
C
C***********************************************************************
C
      INTEGER STOT,GUTOT,netot,STOT0,GUTOT0
      CHARACTER*11 KFORM,KFORM0
      CHARACTER*80 TITLE
!      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
      DIMENSION NEREP(MAXNE),EINC(2,MAXNE)
      DIMENSION AKMAT(netot,NOPEN,NOPEN)
      SAVE
      DATA ZERO/0.D0/,KEY/11/
      IWRITE = IWRIT0
      IPRNT = IPRNT0
      MGVN = MGVN0
      ION = ION0
      NCHAN = NCHAN0
      NVIB = NVIB0
      NDIS = NDIS0
      STOT = STOT0
      GUTOT = GUTOT0
      IPRNT =1
C
C----- Position file at end of information (or end of set number NTSET)
      NSET = NKSET
      LUKMT = LUKMAT
      KFORM = KFORM0
      CALL GETSET(LUKMT,NSET,KEY,KFORM,IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(NKSET.NE.1) NSET = NSET+1
      WRITE(IWRITE,16) NSET,LUKMT  
      NKSET = NSET
C
C---- Calculate number of records to be written to K-matrix set.
C     This is only accurate if LUKMT is unformatted or all channels are
C     open, and the loop over scattering energies terminates normally.
C
      IF(KFORM.EQ.'FORMATTED') THEN
        NDIM = NCHAN*(NCHAN+1)/2
        NDATA = 2+MAXNE+NETOT*(NDIM+3)/4
      ELSE
        NDATA = 2+MAXNE+NETOT
      ENDIF
      NINFO = 1
      NREC = NDATA+NINFO
C
C---- Write header
      IF(KFORM.EQ.'FORMATTED') THEN
        WRITE(LUKMT,10) KEY,NSET,NREC,NINFO,NDATA
        WRITE(LUKMT,13) TITLE
        WRITE(LUKMT,12) MGVN,STOT,GUTOT,ION,R,RMASS
        WRITE(LUKMT,10) NTARG,NVIB,NDIS,NCHAN,MAXNE
        DO 5 I=1,MAXNE
 5      WRITE(LUKMT,15) I,NEREP(I),(EINC(J,I),J=1,2)
      ELSE
        WRITE(LUKMT) KEY,NSET,NREC,NINFO,NDATA
        WRITE(LUKMT) TITLE
        WRITE(LUKMT) MGVN,STOT,GUTOT,ION,R,RMASS
        WRITE(LUKMT) NTARG,NVIB,NDIS,NCHAN,MAXNE
        DO 6 I=1,MAXNE
 6      WRITE(LUKMT) I,NEREP(I),(EINC(J,I),J=1,2)
      ENDIF
C
C---- PRINT HEADER
      IF(IPRNT.GT.0) THEN
        WRITE(IWRITE,14)        
        WRITE(IWRITE,110) KEY,NSET,NREC,NINFO,NDATA
        WRITE(IWRITE,113) TITLE
        WRITE(IWRITE,112) MGVN,STOT,GUTOT,ION,R,RMASS
        WRITE(IWRITE,110) NTARG,NVIB,NDIS,NCHAN,MAXNE
        DO 4 I=1,MAXNE
 4      WRITE(IWRITE,111) I,NEREP(I),(EINC(J,I),J=1,2)
      ENDIF
C
      RETURN
C
      ENTRY WRTKM(ind,NOPEN,NDOPEN,EN,AKMAT,netot)
C
C*******************************************************************
C
C     WRTKM writes K-matrices to unit LUKMT which has previously been
C     positioned correctly via a call to WRTKH
C
C********************************************************************
C 
      NCHSQ = NOPEN*(NOPEN+1)/2
      IF(KFORM.EQ.'FORMATTED') THEN
        WRITE(LUKMT,11) NOPEN,NDOPEN,NCHSQ,EN,
     1                  ((AKMAT(ind,I,J),I=1,J),J=1,NOPEN)
      ELSE
        WRITE(LUKMT) NOPEN,NDOPEN,NCHSQ,EN,
     1               ((AKMAT(ind,I,J),I=1,J),J=1,NOPEN)
      ENDIF
C
      RETURN
 11   FORMAT(3I10,D20.13/(4D20.13))
 10   FORMAT(10I5)
 12   FORMAT(4I5,2D15.6)
 13   FORMAT(A80)
 14   FORMAT(/' Header on LUKMT')
 15   FORMAT(2I10,2D20.13)
 16   FORMAT(/' K-matrices will be written to set',I3,' on unit',I3)
 110  FORMAT(1X,10I5)
 111  FORMAT(1X,2I10,2D20.13)
 112  FORMAT(1X,4I5,2D15.6)
 113  FORMAT(1X,A80)
      END

