! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE KMATADGENERAL(ifail)

c ###################################################################
 
c     KMATADGENERAL converts the triangular k-matrices output from
c     rsolve on fort.50 onwards (depending on number of outer region
c     symmetries), to square matrices needed for polyDCS, output on
c     fort.29 by default. This is symmetry non-dependant in terms of
c     matrix element manipulation. The only thing that depends on
c     symmetry is the namelist variable nsym, which simply is used as
c     a counter to know how many fort files to read in. i.e. nsym = 4
c     for c2v as there are a1,b1,b2,a2 k-matrices from the outer region
c     runs. By default nsym=3.
c ###################################################################

      implicit double precision (a-h,o-z)
      parameter (iwrite=6, maxern=10)
      dimension nerep(maxern), einc(2,maxern)
      double precision, dimension(:,:,:), allocatable :: akm
      integer, dimension(:,:), allocatable :: index
      integer, allocatable, dimension(:) :: lukmtv 
      integer, allocatable, dimension(:) :: nopen,ndopen,nchsq  
      double precision, allocatable, dimension(:) :: en
c      dimension nopen(nsym), ndopen(nsym), nchsq(nsym)
      character(len=11) :: MODDAT
      character(len=80) :: NAME
c     
      NAMELIST/kadIN/NAME,IPRNT,LUKMTo,nsym
c          
      DATA LUKMTo/29/,IPRNT/0/,nsym/3/
      DATA RYD/0.0735D0/
      DATA MODDAT/'13-Jul-2001'/
c
      IFAIL=0
c
c --- Read basic data via namelist /KMATADIN/
c
      READ(5,kadin)
c
      write(iwrite,1) moddat, name
      write(iwrite,11)

      allocate(en(nsym),lukmtv(nsym),nopen(nsym),ndopen(nsym), 
     *nchsq(nsym))
c --- define logical unit numbers
      lukmtv(1) = 50
      DO 23 I=2,nsym
       lukmtv(I)= lukmtv(I-1) + 1 
 23   continue  
c
c --- Position first K-matrix and read the total number of energies
c     (This number and the energy range are assumed to be identical 
c     for each symmetry).
c
      lukmti=lukmtv(1)
      read(lukmti,*) 
      read(lukmti,*)
      read(lukmti,*) 
      read(lukmti,*) ntarg,nvib,ndis,nchan,maxne
      netot=0
      do i=1,maxne
         read(lukmti,*) l,nerep(l),(einc(j,l),j=1,2)
         netot = netot+nerep(i)
         einc(1,i)=einc(1,i)/RYD
         einc(2,i)=einc(2,i)/RYD
         write(lukmto,15) i,nerep(i),(einc(J,i),J=1,2)
      enddo
c
      if (netot.le.0) then
         ifail=1
         stop 'PROBLEM IN READING NETOT IN K-MATRIX HEADER'
      endif
c
c --- Loop over symmetries to position the second and third K-matrices
c
      do k=2,nsym
         lukmti=lukmtv(k)
         read(lukmti,*) 
         read(lukmti,*) 
         read(lukmti,*) 
         read(lukmti,*) 
         read(lukmti,*) 
      enddo
c     
c --- Loop over energies
c     
      do nrj=1,netot
c
c --- Loop over symmetries
c
         do k=1,nsym
            lukmti=lukmtv(k)
c
c --- read the dimension of the K-matrix
c     nchsq=nopen*(nopen+1)/2
c
      write (iwrite,*) 'mark 1'
            read(lukmti,*) nopen(k),ndopen(k),nchsq(k),en(k)
      write (iwrite,*) 'mark 2'
c
c --- convert the energy from Rydbergs to eV
c     
            en(k)=en(k)/RYD
c    
            write(iwrite,2) k,nopen(k),ndopen(k),nchsq(k),en(k)
c
         enddo
c     
 1       FORMAT(//' Program KMATAD (last modified ',A,' )'//,1X,A/)
 11      FORMAT(18X,'NOPEN',5X,'NDOPEN',3X,'NCHSQ',7X,'EN')
 2       FORMAT(' K-matrix',i2,3(i10),e16.8)
c 
      if(nsym.EQ.1) then
          maxn=nopen(1)
      else if(nsym.EQ.2) then
          maxn=maxval((/ nopen(1),nopen(2)/))
      else if (nsym.EQ.3) Then
         maxn=maxval((/ nopen(1),nopen(2),nopen(3)/))
      else if (nsym.EQ.4) then
         maxn=maxval((/ nopen(1),nopen(2),nopen(3),nopen(4)/))
      else if (nsym.EQ.8) then
         maxn=maxval((/ nopen(1),nopen(2),nopen(3),nopen(4),
     &                  nopen(5),nopen(6),nopen(7),nopen(8)/))
      end if
c     
         allocate(akm(nsym,maxn,maxn))
         allocate(index(nsym,maxn))
c     
c --- Read K-matrix elements and construct the symmetric K-matrix akm  
c 
         do k=1,nsym
            lukmti=lukmtv(k)
            read(lukmti,911) ((akm(k,i,j),i=1,j),j=1,nopen(k))
            do i=1,nopen(k)
               index(k,i)=i
               do j=1,nopen(k)
                  akm(k,j,i)=akm(k,i,j)
               enddo
            enddo
         enddo 
c     
c --- Optional printing of all K-matrices
c     
         if (iprnt.eq.1) then
c
            istep=6
            do k=1,nsym
c     
               write(iwrite,510) k
 510  format(/' ----------------------------------------------------
     & K-matrix ',i2)
c     
               ks=nopen(k)
               write(iwrite,3) k, nopen(k), en(k)
               do i=1,ks,istep
                  imin=i
                  imax=i+istep-1
                  if (imax.gt.ks) imax=ks
                  write(iwrite,4) (index(k,l),l=imin,imax)
                  do j=1,ks
                     write(iwrite,5) index(k,j),(akm(k,j,l),l=imin,imax)
                  enddo
               enddo
            enddo
         endif
c     
 3       FORMAT (/2(i10),e16.8/)
 4       FORMAT (8x,6('    i = ',i3))
 5       FORMAT (' i = ',i3,20(2x,f9.5)/)
c     
c --- Write the output K-matrix akm in file lukmto
c
         do k=1,nsym
            write(lukmto,55) k, nopen(k), en(k)
            ks=nopen(k)
            do i=1,ks
               do j=1,ks,4
                  imax=j+3
                  if (imax.GT.ks) imax=ks
                  write(lukmto,6) (akm(k,i,l),l=j,imax)
               enddo
            enddo
         enddo
c
         write(iwrite,16) lukmto
c     
 15      FORMAT(2I10,2D20.13)
 55      FORMAT(2(i10),e16.8)
 6       FORMAT (1x,4(1x,e18.10))  
 16      FORMAT(/' K-matrices will be written on unit',i3/) 
c     
         deallocate(akm)
         deallocate(index)
c     
c --- End do loop over energies
c
      enddo 
c
      write(iwrite,22) netot
      write(iwrite,110)
c     
c --- Close files
c     
      do i=1,nsym
         close(unit=lukmtv(i),status='keep')
      enddo

      deallocate(en,lukmtv,nopen,ndopen,nchsq)
c  
 911  FORMAT(4E20.13)   
 22   FORMAT(' The total number of energies is',i5)
 110  FORMAT(/' *** Task successfully completed ***')
c     
      RETURN
      END 

