! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE I_XSECS(IFAIL)
C
C***********************************************************************
C
C     IXSECS calculates integrated cross sections from T-matrices
C      It is intended to be a self contained module which can be
C      run independantly from the main scattering calculation.
C      The argument X an array, of dimension MCOR, is not used.
C      On exit, IFAIL=0 indicates succesful termination, else IFAIL=1
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXERN=10,MAXCH=5000)
      DIMENSION EINC(2,MAXERN),NESCAT(MAXERN),IPRNT(6),
     1 IVCHL(MAXCH),LVCHL(MAXCH),MVCHL(MAXCH),EVCHL(MAXCH)
      double precision, allocatable :: enscat(:),tmr(:),tmi(:),xs(:,:),
     * etarg(:)
      integer, allocatable :: ivtarg(:),ivnu(:),starg(:),gtarg(:),
     * mtarg(:)
      INTEGER :: ACCEPTED_EN
      CHARACTER(LEN=80) NAME
      CHARACTER(LEN=4) CEUNIT(2)
      CHARACTER(LEN=8) BLANK
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=1) ICFORM,ITFORM
      CHARACTER(LEN=11) CFORM,TFORM,MODDAT
      CHARACTER(LEN=20) DAYTIM
      INTEGER STOT,SYMTYP
C
C***********************************************************************
C
C     Basic data is input via namelist /XSECIN/
C      EMIN     = MINIMUM REQUIRED SCATTERING ENERGY (IN UNITS AS
C                 SPECIFIED BY IEUNIT)
C      EMAX     = MAXIMUM REQUIRED SCATTERING ENERGY
C      ICFORM   = 'F' if channel dataset is formatted, else 'U'
C      ITFORM   = 'F' if T-matrix dataset is formatted, else 'U'
C      IEUNIT   = UNITS IN WHICH INPUT SCATTERING ENERGIES ARE INPUT
C                 1= RYD, 2= EV
C      IXSN     = Units to be used for cross-section output
C                 1=BOHR**2, 2=ANGSTROM**2, 3=PI*BOHR**2
C      IWRITE   = UNIT FOR CROSSECTION OUTPUT
C      LUCHAN   = LOGICAL UNIT FO RCHANNL DATA
C      LUTMT    = LOGICAL UNIT FOR T-MATRIX input
C      LUXSN    = LOGICAL UNIT FOR cross section output
C      MAXI     = LABEL OF HIGHEST INITIAL STATE FOR WHICH CROSS-
C                 SECTIONS ARE REQUIRED
C      MAXF     = LABEL OF HIGHEST FINAL STATE FOR WHICH CROSS-SECTIONS
C                 ARE REQUIRED
C      NVXPRT   = NUMBER OF INITIAL STATES TO BE EXPLICITLY INCLUDED
C                 IN FINAL TABULATION OF CROSS-SECTIONS (DEFAULT=ALL)
C      NAME     = TITLE FOR ANY OUTPUT
C      NCHSET   = SET NUMBER OF CHANNEL DATA
C      NTSET    = SET NUMBER OF T-MATRIX INPUT
C
C      PLOTXSEC = Additional unit containing total cross section data as 
C                  a function of energy in a ready-to-plot file, xsec.dat. 
C                 Also this file can be used as an input for subroutine 
C                 rates without format changes (NV, August 2004).

      NAMELIST/XSECIN/IXSN,NVXPRT,IEUNIT,IWRITE,MAXI,MAXF,NAME,LUCHAN,
     1EMIN,EMAX,LUTMT,NTSET,NCHSET,ICFORM,ITFORM,IPRNT,R,luxsn
C
C***********************************************************************
C
      DATA IXSN/1/,NVXPRT/0/,IWRITE/6/,luxsn/0/,VBIG/1.D+8/,R/0.D0/
     3,LUCHAN,LUTMT/10,12/,NCHSET,NTSET/1,1/,CEUNIT/' RYD',' EV '/
     4,BLANK/'        '/,IEUNIT/1/,IPRNT/6*0/,MAXI,MAXF/1,0/
      DATA ZERO/0.D0/,RYD/0.073500D0/
      DATA CFORM,TFORM,FORM/3*'FORMATTED'/,ICFORM,ITFORM/2*'U'/
      DATA MODDAT/'30-Nov-1998'/,EPS/1.D-8/
C
      IFAIL = 0
      NEXT = 1
      EMIN = ZERO
      EMAX = VBIG
C
C---- Read basic data via namelist /XSECIN/
      READ(*,XSECIN)
      IF(ICFORM.EQ.'U') CFORM='UN'//FORM
      IF(ITFORM.EQ.'U') TFORM='UN'//FORM
C
C---- Date-stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,100)MODDAT,NAME
 100  FORMAT('1',//' Program XSECS  (last modified ',A,' )'//A/)
C
C----- Find required T-matrix set and read dimension information
      CALL READTH(LUTMT,NAME,NTSET,NCHAN,NVIB,NDIS,NTARG,MAXCHI,
     1 MAXCHF,MGVN,STOT,symtyp,NE,NERANG,NESCAT,EINC,IVCHL,LVCHL,MVCHL,
     2 EVCHL,TFORM,IWRITE,IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(NCHAN.GT.MAXCH) GO TO 97
      NETOT = NE
C
C---- Recompute energy parameters NERANG,NESCAT and EINC for energy
C     range [EMIN,EMAX]
      IF(IEUNIT.EQ.2) THEN
        EMIN = RYD*EMIN
        EMAX = RYD*EMAX
      ENDIF
      CALL NEWE(EMIN,EMAX,NE,NERANG,NESCAT,EINC)
C
C---- Print scattering energy range for this run
      IF(IEUNIT.EQ.2) THEN
        EMINP = EMIN/RYD
        EMAXP = EMAX/RYD
      ELSE
        EMINP = EMIN
        EMAXP = EMAX
      ENDIF
      WRITE(IWRITE,104) NE,EMINP,EMAXP,CEUNIT(IEUNIT)
C
C----- Assign storage for energy independant data
      IF(NVIB.EQ.0) NVIB=NTARG
      IF(MAXF.EQ.0) MAXF=NVIB
      NVIBD  = max(NVIB+NDIS,ntarg)
      allocate (ivtarg(nvibd),ivnu(nvibd),starg(nvibd),gtarg(nvibd),
     * mtarg(nvibd),etarg(nvibd))
C      
C---- READ TARGET AND CHANNEL DATA
      NCHN = NCHAN
      NDIS0 = NDIS
      CALL READTC(LUCHAN,NCHSET,NCHN,NVIB,NDIS0,nvibd,ION,IVTARG,
     1 IVNU,IVCHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,GTARG,
     2 ETARG,R,RMASS,CFORM,IWRITE,IPRNT(1)-1,IFAIL)
      IF(NCHN.NE.NCHAN) THEN
        WRITE(IWRITE,92)
        IFAIL = 1
      ENDIF
      IF(IFAIL.NE.0) RETURN
C
C----- ALLOCATE SPACE FOR T-MATRICES AND CROSS-SECTIONS
c
      LTMT = MAXCHI*(MAXCHF+NDIS)
      LXSECS = maxi*(maxf+NDIS)
      allocate (enscat(netot),tmr(ltmt),tmi(ltmt),xs(lxsecs,netot))
C
C---- LOOP OVER ENERGIES
C
      ACCEPTED_EN = 0
      DO 32 I=1,NETOT
C
C---- Read T-matrices for this energy only
      net = 1
      CALL READT(net,MAXCHI,MAXCHF,NDIS,MAXVI,MAXVJ,NDOPEN,TMR,TMI,ENR)
C
C---- ZM: fixed correct determination of energy grid in case some energies have been skipped.
      IF(ENR.LT.EMIN-EPS.OR.ENR.GT.EMAX+EPS.or.net.eq.0) THEN
         IF(IEUNIT.EQ.2) ENR = ENR/RYD
         WRITE(IWRITE,'("Skipping energy:",i0,e25.15)') I,ENR
         IF (NET .eq. 0) THEN
            WRITE(IWRITE,180)
         ELSE
            WRITE(IWRITE,181) EPS
         ENDIF
         GO TO 32
      ELSE
C        ZM: save only those energies for which cross sections have been actually calculated.
         ACCEPTED_EN = ACCEPTED_EN + 1
         ENSCAT(ACCEPTED_EN) = ENR
C
C---- Calculate partial crossections
         if(symtyp.lt.2) then
           CALL XSECD(MGVN,STOT,NVIB,NDIS,MAXI,MAXF,MAXCHI,MAXCHF,
     1                MAXVI,MAXVJ,NDOPEN,IVTARG,IVCHL,EVCHL,STARG,
     2                MTARG,TMR,TMI,ENR,XS(1,i),IXSN)
         else
           CALL XSECP(STOT,NVIB,MAXI,MAXF,MAXCHI,MAXCHF,MAXVI,MAXVJ,
     *                IVTARG,IVCHL,EVCHL,STARG,
     2                mvchl,TMR,TMI,ENR,XS(1,i),IXSN)
         endif
      endif

 32   CONTINUE
C
C---- PRINT DATA IN TABULAR FORM
 33   IF(NVXPRT.EQ.0) THEN
        NPRT = MAXF
      ELSE
        NPRT = MIN(NVXPRT,MAXF)
      ENDIF
C
      CALL XTABLE(IWRITE,LUXSN,MAXI,MAXF,NVIB,NDIS,NAME,ACCEPTED_EN,
     1  XS,ENSCAT,IEUNIT,IXSN,NPRT)
      
C
C---- Close files and return to main routine
 90   CLOSE(UNIT=LUCHAN,STATUS='KEEP')
 91   CLOSE(UNIT=LUTMT,STATUS='KEEP')
      deallocate (ivtarg,ivnu,starg,gtarg,etarg)
      deallocate (enscat,tmr,tmi,xs)
      WRITE(IWRITE,16)
      RETURN
C
 97   WRITE(IWRITE,96) NCHAN,MAXCH
 96   FORMAT(/' NUMBER OF INPUT CHANNELS NCHAN =',I3,' EXCEEDS FIXED DIM
     1ENSION MAXCH =',I3)
      IFAIL = 1
      GO TO 91
C
 99   WRITE(IWRITE,98)MCOR,LAST
 98   FORMAT(/' INSUFFICIENT CORE GIVEN',I6,'  REQUIRED',I6)
      IFAIL = 1
      GO TO 90
C
 16   FORMAT(//' *** Task has been successfully completed ***')
 92   FORMAT(/' *** DATA ON T-MATRIX FILE IS INCOMPATIBLE WITH CHANNEL D
     1ATA ***')
 104  FORMAT(/' Cross-sections will be computed for ',I3,' energies in t
     1he T-matrix file from',F8.4,' to',F8.4,A4)
 105  FORMAT(10A8)
 107  FORMAT(/' Number of target states       =',I4/' Number of scatteri
     1ng channels =',I4)
 180  FORMAT('T-matrix for this energy has not been found on the file.')
 181  FORMAT('Energy lies out of the range [EMIN,EMAX]. EPS = ',e25.15)

      END
      SUBROUTINE XSECD(MGVN,STOT,NVIB,NDIS,MAXI,MAXF,MAXCHI,
     1                 MAXCHF,MAXVI,MAXVJ,NDOPEN,IVTARG,IVCHL,ETHR,
     *                 STARG,MTARG,TR,TI,ENRYD,CSX,IXSN)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     XSEC CALCULATES VIBRATIONAL CROSS-SECTIONS FROM T-MATRIX
C     (SEE PGB'S 1979 NATO NOTES EQ. 74)
C
C     NDIS   = NUMBER OF DISSOCIATING CHANNELS (ASSUMED OPEN)
C     NCHAN  = NUMBER OF OPEN ASYMPTOTIC CHANNELS
C     IVTARG = POINTERS FROM VIBRATIONAL CHANNELS TO TARGET STATES
C     IVCHL  = POINTERS FROM ASYMPTOTIC TO VIBRATIONAL CHANNELS
C     ETHR   = THRESHOLD ENERGIES IN RYDBERGS
C     STARG  = 2*S+1 WHERE S IS SPIN OF TARGET STATES
C     TR     = REAL PART OF T-MATRIX
C     TI     = IMAGINARY PART OF T-MATRIX
C     STOT   = 2*S+1 WHERE S IS TOTAL SPIN OF SYSTEM
C     CSX    = CROSS-SECTIONS 
C     IXSN   = DETERMINES UNITS FOR CROSSSECTIONS
C              ( =1 A0**2; =2 SQUARE ANGSTROMS; ELSE PI*A0**2)
C
C***********************************************************************
C
      INTEGER STARG,STOT
      DIMENSION TR(MAXCHI,MAXCHF+NDIS),TI(MAXCHI,MAXCHF+NDIS),
     1 CSX(maxi,maxf+NDIS),IVTARG(*),IVCHL(*),MTARG(*),STARG(*),ETHR(*)
      DATA ZERO,HALF,TWO/0.D0,0.5D0,2.D0/,PI/3.141592653590D0/,
     1 SQUANG/0.28002D0/
C
      DO 11 NU=1,MAXF+NDIS
      DO 1 MU=1,MAXI
      CSX(MU,NU) = ZERO
 1    continue
 11   continue
C
C---- Calculate unweighted cross-sections
      DO 2 I=1,MAXVI
      MU = IVCHL(I)
      if(mu.gt.maxi) go to 2
      DO 3 J=1,MAXVJ
      NU = IVCHL(J)
      if(nu.gt.maxf) go to 3
      CSX(MU,NU) = CSX(MU,NU)+(TR(I,J)**2+TI(I,J)**2)/(ENRYD-ETHR(I))
 3    continue
      DO 4 J=1,NDOPEN
      CSX(MU,MAXF+J) = CSX(MU,MAXF+J)+(TR(I,MAXVJ+J)**2+TI(I,MAXVJ+J)
     1**2)/(ENRYD-ETHR(I))
 4    continue
 2    CONTINUE
C
C----- SET UP STATISTICAL WEIGHT OF TOTAL SYSTEM
      IF(MGVN.EQ.0) THEN
       SM = HALF*Dble(STOT)
      ELSE
       SM = Dble(STOT)
      ENDIF
C
C----- CONVERT TO REQUIRED UNITS
      IF(IXSN.EQ.1) THEN
        SM = SM*PI
      ELSE IF(IXSN.EQ.2) THEN
        SM = SM*PI*SQUANG
      ENDIF
C
C---- Multiply by statistical weights
      DO 61 MU=1,MAXI
      DO 6 NU=1,MAXF
      IF(NVIB.EQ.0) THEN
        I = MU
        J = NU
      ELSE
        I = IVTARG(MU)
        J = IVTARG(NU)
      ENDIF
      FAC = SM/Dble(STARG(I))
      IF(MGVN.EQ.0.AND.MTARG(J).NE.0) FAC=TWO*FAC
      IF(MTARG(I).NE.0) FAC=HALF*FAC
      CSX(MU,NU) = FAC*CSX(MU,NU)
 6    continue
 61   continue
C
C---- Dissociative attachment cross section
      IF(NDOPEN.GT.0) THEN
        DO 71 MU=1,MAXI
        IF(NVIB.EQ.0) THEN
          I = MU
        ELSE
          I = IVTARG(MU)
        ENDIF
        FAC = SM/Dble(STARG(I))
        DO 7 NU=MAXF+1,MAXF+NDOPEN
        CSX(MU,NU) = FAC*CSX(MU,NU)
 7      continue
 71     continue
      ENDIF
C
      RETURN
      END
      SUBROUTINE XSECP(STOT,NVIB,MAXI,MAXF,MAXCHI,MAXCHF,MAXVI,MAXVJ,
     *                 IVTARG,IVCHL,ETHR,STARG,Mvchl,TR,TI,ENRYD,CSX,
     *                 IXSN)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     XSEC CALCULATES CROSS-SECTIONS FROM T-MATRIX for C2v or D2h
C
C     NCHAN  = NUMBER OF OPEN ASYMPTOTIC CHANNELS
C     IVTARG = POINTERS FROM VIBRATIONAL CHANNELS TO TARGET STATES
C     IVCHL  = POINTERS FROM ASYMPTOTIC TO VIBRATIONAL CHANNELS
C     ETHR   = THRESHOLD ENERGIES IN RYDBERGS
C     STARG  = 2*S+1 WHERE S IS SPIN OF TARGET STATES
C     TR     = REAL PART OF T-MATRIX
C     TI     = IMAGINARY PART OF T-MATRIX
C     STOT   = 2*S+1 WHERE S IS TOTAL SPIN OF SYSTEM
C     CSX    = CROSS-SECTIONS 
C     IXSN   = DETERMINES UNITS FOR CROSSSECTIONS
C              ( =1 A0**2; =2 SQUARE ANGSTROMS; ELSE PI*A0**2)
C
C***********************************************************************
C
      INTEGER STARG,STOT
      DIMENSION TR(MAXCHI,MAXCHF),TI(MAXCHI,MAXCHF),
     1 CSX(maxi,maxf),IVTARG(*),IVCHL(*),Mvchl(*),STARG(*),ETHR(*)
      DATA ZERO,HALF,one,TWO/0.D0,0.5D0,1.d0,2.D0/,
     1 PI/3.141592653590D0/,SQUANG/0.28002D0/
C
C     ZM corrected the order of the loops so it matches the declared dimensions
C
      DO 11 NU=1,maxf
      DO 1 MU=1,maxi
      CSX(MU,NU) = ZERO
 1    continue
 11   continue
C
C---- Calculate unweighted cross-sections but must allow for the fact
c     that T-matrices were computed using real spherical harmonics.
c     We use the fact than in C2v or D2h there is no coupling between 
c     q=-1 and q=+1
c
      DO 2 I=1,MAXVI
      MU = IVCHL(I)
      if(mu.gt.maxi) go to 2
      DO 3 J=1,MAXVJ
      NU = IVCHL(J)
      if(nu.gt.maxf) go to 3
      CSX(MU,NU) = CSX(MU,NU)+(TR(I,J)**2+TI(I,J)**2)/(ENRYD-ETHR(I))
 3    continue
 2    CONTINUE
C
C----- CONVERT TO REQUIRED UNITS
      IF(IXSN.EQ.1) THEN
        SM = PI
      ELSE IF(IXSN.EQ.2) THEN
        SM = PI*SQUANG
      ENDIF
C
C----- SET UP STATISTICAL WEIGHT OF TOTAL SYSTEM
      SM = SM*HALF*Dble(STOT)
C
C---- Multiply by statistical weights
      DO 61 MU=1,MAXI
      DO 6 NU=1,MAXF
      IF(NVIB.EQ.0) THEN
        I = MU
        J = NU
      ELSE
        I = IVTARG(MU)
        J = IVTARG(NU)
      ENDIF
      FAC = SM/Dble(STARG(I))
      CSX(MU,NU) = FAC*CSX(MU,NU)
 6    continue
 61   continue
C
      RETURN
      END
      SUBROUTINE XTABLE(NFTA,nftx,MAXI,MAXF,NVIB,NDIS,TITLE,
     1 NUME,XSN,EN,IEUNIT,IXSN,NPRT)
C
C***********************************************************************
C
C     XTABLE PRINTS TABLES SUMMARIZING CROSS-SECTIONS COMPUTED AT EACH
C            SCATTERING ENERGY :
C
C                    CROSS SECTIONS               XSN
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      CHARACTER(LEN=3) EUNIT(2),EUN
      CHARACTER(LEN=8) XUNIT(3),XUN
      CHARACTER(LEN=80) TITLE
      DIMENSION XSN(maxi,maxf+NDIS,NUME),EN(*)
      integer:: plotxsec
C
      DATA EUNIT/'RYD','EV'/
      DATA XUNIT/'BOHR**2','ANGS**2','PI*A0**2'/
      DATA ZERO/0.D0/,EV/13.6054D0/
C
      EUN = EUNIT(IEUNIT)
      XUN = XUNIT(IXSN)
C
C***********************************************************************
C
      NRECL = 12 + 16*NPRT
      open(NEWUNIT=plotxsec, status='unknown', FILE='xsec.dat',
     * action='write', RECL=NRECL)

      IF(IXSN.NE.0) THEN
C
C     PRINT CROSS SECTION TABLE
C
        DO 306 I=1,MAXI
        NPT2 = MIN(NPRT,6)
        IF(NVIB.EQ.0) THEN
          WRITE(NFTA,301) TITLE,XUN,I,EUN,(J,J=1,NPT2)
          if(nftx.ne.0) WRITE(NFTx,301) TITLE,XUN,I,EUN,(J,J=1,NPT2)
        ELSE
          WRITE(NFTA,301) TITLE,XUN,I-1,EUN,(J-1,J=1,NPT2)
          if(nftx.ne.0) WRITE(NFTx,301)TITLE,XUN,I-1,EUN,(J-1,J=1,NPT2)
        ENDIF
C

!  This additional unit is open in order to write total cross section data as 
!  a function of energy in a ready-to-plot file. Also this file can be used 
!  as an input for subroutine rates without format changes (NV, August 2004).
  
        DO 316 IE=1,NUME
        E = EN(IE)
        IF(IEUNIT.EQ.2) E=E*EV
!
! James Munro 15/5/09
! fixed bug, total cross-section is sum that includes quenching
!
        SUM = ZERO
        DO 307 J=1,MAXF
           SUM = SUM+XSN(I,J,IE)
 307    continue
!
! James Munro 15/5/09
! feature change, plot all cross-sections (include quenching)
!
        write (plotxsec,12336) E,(XSN(I,J,IE),J=1,NPRT)
        WRITE(NFTA,2336) IE,E,SUM,(XSN(I,J,IE),J=1,NPT2)
        if(nftx.ne.0) WRITE(NFTx,1336)IE,E,SUM,(XSN(I,J,IE),J=1,NPT2)
!      
! Here write results for total cross sections on a file-ready to plot      
!

 316    CONTINUE
c
        IF(NPRT.GT.NPT2) THEN
          NTAB = (NPRT-NPT2-1)/7+1
          J1 = NPT2+1
          NLEFT = NPRT-7
          DO 310 IT=1,NTAB
          J2 = J1+MIN(NLEFT,6)
          IF(NVIB.EQ.0) THEN
            WRITE(NFTA,302) TITLE,XUN,I,EUN,(J,J=J1,J2)
            if(nftx.ne.0) WRITE(NFTx,302) TITLE,XUN,I,EUN,(J,J=J1,J2)
          ELSE
            WRITE(NFTA,302) TITLE,XUN,I-1,EUN,(J-1,J=J1,J2)
            if(nftx.ne.0) WRITE(NFTx,302) TITLE,XUN,I-1,EUN,
     *                    (J-1,J=J1,J2)
          ENDIF
          DO 304 IE=1,NUME
          E = EN(IE)
          IF(IEUNIT.EQ.2) E=E*EV
          WRITE(NFTA,2336)IE,E,(XSN(I,J,IE),J=J1,J2)
          if(nftx.ne.0) WRITE(NFTx,1336)IE,E,(XSN(I,J,IE),J=J1,J2)
 304      continue
          NLEFT = NLEFT-7
          J1 = J2+1
 310      continue
        ENDIF
 306    CONTINUE
C
        IF(NDIS.NE.0) THEN
C
C     PRINT DISSOCIATIVE ATTACHMENT CROSS SECTION TABLE
C
          NPT2 = MIN(NPRT,MAXI)
          K = MAXF
          DO 311 ID=1,NDIS
          WRITE(NFTA,312) TITLE,XUN,ID,EUN,(I,I=1,NPT2)
  312     FORMAT(//1X,A,//,30X,'DISSOCIATION CROSS SECTIONS IN ',A,'
     1    FOR DISSOCIATING CHANNEL',I3//,5X,'I',4X,'E(',A,')',7X,
     2    'TOTAL',6I16,(/18X,6I16))
C
          K = K+1
          DO 300 IE=1,NUME
          E = EN(IE)
          IF(IEUNIT.EQ.2) E=E*EV
          SUM = ZERO
          DO 305 I=1,MAXI
          SUM = SUM+XSN(I,K,IE)
 305      continue
          WRITE(NFTA,2336)IE,E,SUM,(XSN(I,K,IE),I=1,NPT2)
          if(nftx.ne.0) WRITE(NFTx,1336)IE,E,SUM,(XSN(I,K,IE),I=1,NPT2)
        write (plotxsec,12336)E,(XSN(I,K,IE),I=1,NPT2)
 300      CONTINUE
 311      continue
        ENDIF
      ENDIF
C      
        close(plotxsec)
      RETURN
C
C ZM added # at the beginning the header lines to enable easy plotting
 301  FORMAT('#1',1X,A,//,'#',30X,'CROSS SECTIONS IN ',A,
     1 ' FOR INITIAL STATE',I3//,'#',5X,'I',4X,'E(',A,')',
     2 9X,'TOTAL',6I16)
 302  FORMAT('#1',1X,A,//,'#',30X,'CROSS SECTIONS IN ',A,
     1 ' FOR INITIAL STATE',I3//,'#',5X,'I',4X,'E(',A,')',
     2 2X,7I16)
 1336 FORMAT(1X,I4,2X,E12.5,7E16.8)
 2336 FORMAT(1X,I4,2X,E12.5,7E16.8)
12336 FORMAT(E12.5,*(E16.8))
!12336 FORMAT(E12.5,10E16.8)
      
      END
