! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE INTERV(X,MCOR,IFAIL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES
C
      PARAMETER (MAXPTS=30,MAXPOL=200,MAXTGT=100,MAXNC=1000)
C
C     MAXPTS = MAXIMUM NUMBER OF GEOMETRIES
C     MAXPOL = MAXIMUM NUMBER OF NONADIABATIC R-MATRIX POLES
C     MAXTGT = MAXIMUM NUMBER OF TARGET VIBRONIC STATES
C     MAXNC = MAXIMUM NUMBER OF SCATTERING CHANNELS
C
      CHARACTER*80 NAME
      CHARACTER*11 RFORM,CHFORM,moddat
      CHARACTER*9 FORM
      CHARACTER*1 IRFORM,ICFORM,type
      CHARACTER*8 BLANK
      CHARACTER*20 DAYTIM
      INTEGER STOT,GUTOT,STARG,GTARG
      DIMENSION X(MCOR),R(MAXPTS),NCHSET(MAXPTS),NRMSET(MAXPTS)
     2,STARG(MAXTGT),GTARG(MAXTGT),MTARG(MAXTGT),ICHL(MAXNC),ivt(maxtgt)
     3,LCHL(MAXNC),MCHL(MAXNC),iprnt(6),istart(maxnc),ivu(maxtgt)
     4,itgord(maxtgt*maxpts),etarg(maxtgt),echl(maxnc)
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
C
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /INTVIN/
C
C      IWRITE   = LOGICAL UNIT FOR PRINTED OUTPUT
C      ICFORM   = Formatted/unformatted switch for unit LICHAN
C      IRFORM   = Formatted/unformatted switch for unit LIRMT
C      ITGORD   = Matrix describing target ordering, if this varies with
C                 geometry
C      IPRNT    = DEBUG PRINT SWITCHES
C                 (1) input data
C                 (6) output data
C      LICHAN   = LOGICAL UNIT HOLDING input CHANNEL AND TARGET DATA
C      LIRMT    = Logical unit holding input R-matrix data
C      LOCHAN   = LOGICAL UNIT HOLDING input CHANNEL AND TARGET DATA
C      LORMT    = Logical unit holding input R-matrix data
C      NGEOM    = NUMBER OF GEOMETRIES
C      NCHSET   = set numbers for channel data
C      NRMSET   = set numbers for R-matrix data
C      TYPE     = I for INTERF input, V for VIBRMT input
C
      NAMELIST/INTVIN/LICHAN,LIRMT,LOCHAN,LORMT,NGEOM,IWRITE,IPRNT,
     2 NCHSET,NRMSET,ICFORM,IRFORM,itgord,name,R,type
C
C***********************************************************************
C
      DATA IREAD,LICHAN,LIRMT,LOCHAN,LORMT/5,10,21,11,22/,ngeom/1/,
     1 IPRNT/6*0/,ZERO/0.D0/,type/'I'/
      DATA FORM,CHFORM,RFORM/3*'FORMATTED'/,ICFORM,IRFORM/2*'U'/
      DATA MODDAT/'24-AUG-1993'/
C
C---- SET UP DEFAULT VALUES OF POINTERS NCHSET AND NRMSET 
      IWRITE = 6
      k = 0
      DO 112 I=1,MAXPTS
      NCHSET(I) = I
      NRMSET(I) = I
      do 112 j=1,maxtgt
      k = k+1
      itgord(k) = 0
 112  continue
C
      IFAIL = 0
      NEXT = 1
C
C---- Read basic data via namelist /INTVIN/
      READ(5,INTVIN)
      IF(NGEOM.GT.MAXPTS) GO TO 96
C
      IF(ICFORM.EQ.'U'.or.icform.eq.'u') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U'.or.irform.eq.'u') RFORM='UN'//FORM
      if(itgord(1).eq.0) then
        ieordr = 1
      else
        ieordr = 0
      endif
      if(type.eq.'V'.or.type.eq.'v') then
        itype = 1
      else
        itype = 0
      endif
C
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,12)MODDAT,NAME
      WRITE(IWRITE,10)ngeom
      WRITE(IWRITE,13)CHFORM,LiCHAN,lochan,(NCHSET(IG),IG=1,NGEOM)
      WRITE(IWRITE,33)RFORM,LiRMT,lormt,(NRMSET(IG),IG=1,NGEOM)
C
C---- Find first R-matrix input set and read dimension information
 25   WRITE(IWRITE,19)
      rr = zero
      CALL READRH(LiRMT,NRMSET(1),RFORM,MGVN,STOT,GUTOT,NCHAN,NVIB,
     1NDIS,NTARG,ION,rr,RMASS,RMATR,NBUT,ISMX,NOCSF,NPLX,IWRITE,
     2IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN

c---- Set up default ordering of electronic states if not already set
      if(itgord(1).eq.0) then
        k = 0
        do 39 i=1,ngeom
        do 39 j=1,ntarg
        k = k+1
 39     itgord(k) = j
      endif
C
C---- Locate reference geometry (the one which is not reordered)
      igref = 0
      do 26 i=1,ngeom
      k = (i-1)*ntarg
      do 27 j=1,ntarg
      k = k+1
      if(itgord(k).ne.j) go to 26
 27   continue
      igref = i
      go to 28
 26   continue
 28   if(igref.eq.0) go to 94
C
C---- Assign storage for fixed nuclei data
      NCHFSQ = NCHAN*(NCHAN+1)/2
      IFNMC  = next
      IEIG   = IFNMC+ISMX*NCHFSQ
      IWAMP  = IEIG+NOCSF
      IBUTT  = IWAMP+NOCSF*NCHAN
      IVEC   = IBUTT+3*NCHAN
      ichord = IVEC+nplx*NOCSF
      iwki   = ichord+nchan
      iwkr   = iwki+max(5*ntarg,3*nchan)
      next   = iwkr+(4+nocsf)*nchan
      LAST   = NEXT-1
      IF(LAST.GT.MCOR) GO TO 97
c
      CALL READTC(LiCHAN,NCHSET(IGref),NCHAN,NVIB,NDIS,NTARG,ION,IVT,
     1 IVU,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GTARG,ETarg,R(IGref),
     2 RMASS,CHFORM,IWRITE,-1,IFAIL)
      IF(IFAIL.NE.0) RETURN
C
c---- Set pointer to first channel corresponding to each target state
      it = ichl(1)
      istart(1) = 1
      do 4 i=2,nchan
      if(it.eq.ichl(i)) go to 4
      it = ichl(i)
      istart(it) = i
 4    continue
C
C---- LOOP OVER GEOMETRIES
      noset = 1
      DO 2 IG=1,NGEOM
C
C---- READ TARGET AND CHANNEL DATA
      CALL READTC(LiCHAN,NCHSET(IG),NCHAN,NVIB,NDIS,NTARG,ION,IVT,
     1IVU,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GTARG,ETARG,R(IG),RMASS,
     2CHFORM,IWRITE,IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C---- Read R-matrix data
      CALL READRH(LiRMT,NRMSET(IG),RFORM,MGVN,STOT,GUTOT,
     1NCHAN,NVIB,NDIS,NTARG,ION,R(IG),RMASS,RMATR,NBUT,ISMX,NOCSF,
     2NPLX,IWRITE,-1,IFAIL)
      CALL READRM(LiRMT,RFORM,NCHAN,NOCSF,ISMX,ISMX,NPLX,nplx,NBUT,
     1X(IFNMC),X(IEIG),X(IWAMP),X(IVEC),X(IBUTT),X(iwkr),IFAIL)
      IF(IFAIL.NE.0) RETURN
c
c---- Determine consistent ordering of channels to match target states
c
      if(ieordr.ne.0) call REORDE(nchan,ntarg,echl,itgord,istart,
     1 x(iwkr),x(iwki))
      call REORDC(ig,nchan,ntarg,itgord,ichl,x(ichord),istart)
c
      call REORDR(ig,nchan,ntarg,itgord,itype,x(ichord),NOCSF,NPLX,nbut,
     1 ismx,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GTARG,ETARG,IVT,IVU,
     2 X(IFNMC),x(iwamp),X(IWAMP),X(IBUTT),x(iwki),X(iwkr),IFAIL)
c
      CALL WRITCH(LoCHAN,noset,CHFORM,R(ig),RMASS,ICHL,LCHL,MCHL,
     2 ECHL,NTARG,STARG,MTARG,GTARG,ETARG,IVT,IVU,NAME,IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C---- Write R-matrix data file
      CALL WRITRM(LoRMT,noset,RFORM,NOCSF,ISMX,NPLX,X(IFNMC),
     1X(IEIG),X(IWAMP),X(IVEC),X(IBUTT),NTARG,R(ig),RMASS,RMATR,NBUT,
     2NAME,IPRNT(6),IFAIL)
C
      noset = 0
 2    CONTINUE
      WRITE(IWRITE,21)
C
C     Close files and return to calling program
      IF(IFAIL.EQ.0) WRITE(IWRITE,18)
      CLOSE(UNIT=LiCHAN)
      CLOSE(UNIT=LiRMT)
      CLOSE(UNIT=LoCHaN)
      CLOSE(UNIT=LoRMT)
      RETURN
C
 94   write(iwrite,95) 
 95   format(/' All geometries reordered, INTERV cannot handle this')
 96   WRITE(IWRITE,98) NGEOM,MAXPTS
 98   FORMAT(/' Number of geometries will exceed fixed dimensions'/
     1' INPUT  ',I5/' MAXIMUM ',I5)
      STOP
 97   WRITE(IWRITE,99)LAST,MCOR
 99   FORMAT(' INSUFFICIENT CORE, REQUIRED',I8,' GIVEN',I8)
      STOP
 10   FORMAT(/' Number of geometries =',I3)
 12   FORMAT(1H1//' Program INTERV ( last modified ',A,' )'//A/)
 13   FORMAT(/' Datasets:',39X,'Unit       Set numbers'/
     1' Target and channel data     LUCHAN (',A11,')',2I3,5X,30I5/
     235X,30I3)
 16   FORMAT(I3,12F10.5/(3X,12F10.5))
 18   FORMAT(/' *** Task successfully completed ***')
 19   FORMAT(/' *** FIXED NUCLEI DATA *** ')
 21   FORMAT(/' *** END OF FIXED NUCLEI DATA *** ')
 33   FORMAT(' Fixed nuclei R-matrix data  LIRMT  (',A11,')',2I3,5X,30I5
     2/35X,30I3)
C
      END
      SUBROUTINE REORDR(ig,nchan,ntarg,itgord,itype,ichord,NOCSF,NPLX,
     1 nbut,ismx,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GTARG,ETARG,ivt,ivu,cf,
     2 WAMP,vamp,BCOEF,iwork,work,IFAIL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     REORDR reorders target and channel data
C
C***********************************************************************
C
      integer gtarg,starg
      DIMENSION WORK(*),ichord(nchan),itgord(ntarg,*),etarg(ntarg),
     2 ICHL(NCHAN),LCHL(nchan),MCHL(nchan),ECHL(nchan),STARG(ntarg),
     1 MTARG(ntarg),GTARG(ntarg),iwork(*),BCOEF(3,nchan),ivt(ntarg),
     2 ivu(ntarg),CF(*),WAMP(NCHAN,NOCSF),vamp(nocsf,nchan)
C
C---- Reorder target data
      do 3 i=1,ntarg
      iwork(itgord(i,ig))         = starg(i)
      iwork(itgord(i,ig)+ntarg)   = mtarg(i)
      iwork(itgord(i,ig)+2*ntarg) = gtarg(i)
      iwork(itgord(i,ig)+3*ntarg) = ivt(i)
      iwork(itgord(i,ig)+4*ntarg) = ivu(i)
      work(itgord(i,ig))          = etarg(i)
 3    continue
      do 4 i=1,ntarg
      starg(i) = iwork(i)
      mtarg(i) = iwork(i+ntarg)
      gtarg(i) = iwork(i+2*ntarg)
      ivt(i)   = iwork(i+3*ntarg)
      ivu(i)   = iwork(i+4*ntarg)
      etarg(i) = work(i)
 4    continue
C
C---- Reorder channel data
      do 1 i=1,nchan
      iwork(ichord(i))         = itgord(ichl(i),ig)
      iwork(ichord(i)+nchan)   = lchl(i)
      iwork(ichord(i)+2*nchan) = mchl(i)
      work(ichord(i))          = echl(i)
      do 10 j=1,3
 10   work(ichord(i)+j*nchan)  = bcoef(j,i)
      if(itype.eq.0) then
        do 11 j=1,nocsf
 11     work(ichord(i)+(3+j)*nchan)  = wamp(i,j)
      else
        do 12 j=1,nocsf
 12     work(ichord(i)+(3+j)*nchan)  = vamp(j,i)
      endif
 1    continue
      do 2 i=1,nchan
      ichl(i) = iwork(i)
      lchl(i) = iwork(i+nchan)
      mchl(i) = iwork(i+2*nchan)
      echl(i) = work(i)
      do 20 j=1,3
 20   bcoef(j,i) = work(i+j*nchan)
      if(itype.eq.0) then
        do 21 j=1,nocsf
 21     wamp(i,j) = work(i+(3+j)*nchan)
      else
        do 22 j=1,nocsf
 22     vamp(j,i) = work(i+(3+j)*nchan)
      endif
 2    continue
c
c---- Reorder multipole coeffients
      nchan2 = nchan*(nchan+1)/2
      do 6 k=1,ismx
      is = (k-1)*nchan2
      do 5 i=1,nchan
      do 5 j=1,i
 5    work(nchan*(max(ichord(i),ichord(j))-1)+min(ichord(i),ichord(j)))
     1 = cf(is+i*(i-1)/2+j)
      do 7 i=1,nchan
      do 7 j=1,i
 7    cf(is+i*(i-1)/2+j) = work(nchan*(i-1)+j)
 6    continue
c
      return
      END
      SUBROUTINE REORDC(ig,nchan,ntarg,itgord,ichl,ichord,istart)
C
C***********************************************************************
C
C     REORDC sets up vector ICHORD which maps channel ordering at
C     geometry IG on to channel ordering of reference geometry. It uses
C     the corresponding vectors, ITGORD, for target data
C
C***********************************************************************
C
      DIMENSION itgord(ntarg,*),ichl(nchan),ichord(nchan),istart(*)
c
      it = ichl(1)
      ichord(1) = istart(itgord(it,ig))
      do 6 i=2,nchan
      if(it.eq.ichl(i)) then
        ichord(i) = ichord(i-1)+1
      else
        it = ichl(i)
        ichord(i) = istart(itgord(it,ig))
      endif
 6    continue
c
      RETURN
C
      END
      SUBROUTINE REORDE(nchan,ntarg,echl,itgord,istart,estart,jstart)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     REORDE sets up vector ICHORD which maps channel ordering at
C     geometry IG on to channel ordering of reference geometry. It uses
C     energy ordering
C
C***********************************************************************
C
      DIMENSION echl(nchan),istart(*),itgord(ntarg),estart(ntarg),
     1 jstart(ntarg)
      data tol/1.d-10/
c
      do 1 i=1,ntarg
      estart(i) = echl(istart(i))
 1    continue
c
c---- sort target energy levels
      call SORT_OUTER(ntarg,jstart,estart)
      do 2 i=1,ntarg
 2    itgord(jstart(i)) = i
c
c---- sort channel energies
      call SORT_OUTER(nchan,jstart,echl)
C
c---- Redefine ISTART
      it = 1
      istart(1) = 1
      elast = echl(jstart(1))
      do 4 i=2,nchan
      et = echl(jstart(i))
      if(abs(et-elast).le.tol) go to 4
      it = it+1
      istart(it) = i
      elast = et
 4    continue
c
      RETURN
C
      END
