! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE INTER_F(IFAIL)
c
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES, EXCEPT
C     CGCOEF
C
      PARAMETER (MAXCH=100,MAXTGT=10,MAXCID=2*maxtgt,MAXM=6)
C
C     MAXCH  = MAXIMUM NUMBER OF FIXED NUCLEI SCATTERING CHANNELS
C     MAXTGT = MAXIMUM NUMBER OF TARGET ELECTRONIC STATES
C     MAXCID = MAXIMUM NUMBER OF QUARTETS LABELLING CSFS
C     MAXM   = MAXIMUM CHANNEL M-VALUE
C
      CHARACTER(LEN=1) IAFORM,IBFORM,ICFORM,IRFORM
      CHARACTER(LEN=8) BLANK
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=11) AFORM,BFORM,CHFORM,CIFORM,RFORM,MODDAT
      CHARACTER(LEN=20) DAYTIM
      CHARACTER(LEN=80) NAME
      INTEGER GUTOT,GTARG,STARG,SYMTYP,STOT
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
      double precision, allocatable :: bcoef(:),wamp(:),pole(:),vec(:),
     * fnmc(:)
      DIMENSION LCHL(MAXCH),MCHL(MAXCH),ICHL(MAXCH),ECHL(MAXCH)
     1,CHARG(20),IDCSF(4,MAXCID),MTARG(MAXTGT),STARG(MAXTGT),IPRNT(6)
     2,ITARG(MAXTGT),GTARG(MAXTGT),GEONUC(20),NMTARG(MAXTGT),nob(20)
     3,ETARG(MAXTGT),NLTARG(MAXTGT,2),IMCSF(2,MAXCID),idtarg(maxtgt)
     4,NORBL(MAXTGT,MAXM+1),eshift(maxtgt),nvo(maxcid),lnm(maxtgt),
     * tmom(2*maxtgt*(maxtgt+1))
C
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /INTFIN/
C
C      GUTOT    = G/U SYMMETRY OF TOTAL SYSTEM +1=G, -1=U
C      IDCSF    = ARRAY OF quartets LABELLING CSFS
C                 IDCSF(1,I) = LABEL OF TARGET STATE ASSOCIATED WITH
C                              CSF IF CONTINUUM  CSF, ELSE 0
C                 IDCSF(2,I) = m value of continuum state
C                 IDCSF(3,I) = LABEL OF BOUNDARY AMPLITUDE TO BE
C                              ASSOCIATED WITH FIRST MEMBER OF THE SET
C                 IDCSF(4,I) = NUMBER OF CSFS IN THIS SET
C      IMCSF    = ARRAY OF doublets LABELLING CSFS (new style MOS file)
C                 IMCSF(1,I) = IDCSF(1,I), IMSCF(2,I) = IDCSF(2,I)
C      ISMAX    = HIGHEST MULTIPOLE TO BE USED IN ASYMPTOTIC EXPANSION
C                 OF STATIC POTENTIALS
C      IWRITE   = LOGICAL UNIT FOR PRINTED OUTPUT
C      IPRNT    = Debug print switches :
C                 (1) exact copy of output to LUCHAN
C                 (2) multipole coefficients of asymptotic potential
C                 (3) input CI eigenvalues and first element of each
C                     eigenvector
C                 (4) input boundary amplitudes
C                 (5) properties data skipped during search for correct
C                     set 
C      LUBUT    = LOGICAL UNIT HOLDING BUTTLE CORRECTIONS, IF ZERO THEN
C                 NO CORRECTION IS MADE TO THE R-MATRIX
C      LUTARG   = LOGICAL UNIT HOLDING TARGET DATA
C      MGVN     = TOTAL SYMMETRY OF SYSTEM
C      NBSET    = BUTTLE CORRECTION ORDERING
C      NELT     = NUMBER OF TARGET ELECTRONS
C      NIDCSF   = NUMBER OF quartets LABELLING CSFS
C      NLTARG   = NUMBER OF CHANNEL L VALUES CORRESPONDING TO
C                 EACH TARGET STATE AND M VALUE
C      NMTARG   = NUMBER OF CHANNEL M VALUES CORRESPONDING TO
C                 EACH TARGET STATE
C      NOCSF    = NUMBER OF INPUT CSFS
C      NPOLE    = NUMBER OF ELECTRONIC R-MATRIX POLES TO BE TREATED
C                 NON-ADIABATICALLY
C      NSTAT    = NUMBER OF INPUT CI EIGENVALUES AND VECTORS (USUALLY
C                 EQUALS NOCSF)
C      NTARG    = NUMBER OF TARGET ELECTRONIC STATES
C      NUCCEN   = LABEL OF 'NUCLEAR' CENTRE ASSOCIATED WITH THE
C                 CONTINUUM ORBITALS
C      R        = INTERNUCLEAR SEPARATION
C      RMATR    = R-MATRIX RADIUS FOR ELECTRONIC MOTION
C      STOT     = SPIN MULTIPLICITY 2*S+1 WHERE S = TOTAL SPIN OF SYSTEM
C      NAME     = Title for any output
C
      NAMELIST/INTFIN/IWRITE,LUTARG,LUBUT,LUCI,LUAMP,LUCHAN,LURMT,IDCSF
     1              ,ISMAX,NUCCEN,NASET,NTSET,NCISET,NCHSET,NRMSET
     2              ,GUTOT,NLTARG,MGVN,NELT,IPRNT,NSTAT,NOCSF,NPOLE,R
     3              ,STOT,RMATR,NBSET,NTARG,NAME,ICFORM,IRFORM,IBFORM
     4              ,IAFORM,NIDCSF,ALPHA0,ALPHA2,NMTARG,IMCSF,idtarg
     5              ,eshift,isgn,nvo
C
C***********************************************************************
C
      DATA
     1 LUTARG,LUBUT,LUAMP,LUCI,LUCHAN,LURMT/24,22,22,25,10,21/,
     1 IPRNT/6*0/,NUCCEN/3/,ALPHA0,ALPHA2/0.D0,0.D0/,
     1 NTSET,NBSET,NASET,NCISET,NCHSET,NRMSET/6*1/,NIDCSF/1/,NOCSF/0/,
     1 IDCSF/MAXCID*0,MAXCID*0,MAXCID*0,MAXCID*0/,ISMAX/2/,NTARG/1/,
     1 NMTARG/MAXTGT*2/,NLTARG/MAXTGT*0,MAXTGT*0/,NPOLE/0/,isgn/1/,
     1 IMCSF/MAXCID*0,MAXCID*0/,idtarg/maxtgt*0/,nvo/maxcid*0/
      DATA ZERO/0.D0/
      DATA BLANK/'        '/,IAFORM,IBFORM,ICFORM,IRFORM/4*'U'/
     1 ,FORM,AFORM,BFORM,CHFORM,RFORM/5*'FORMATTED'/
     2 ,CIFORM/'UNFORMATTED'/
      DATA MODDAT/'16-NOV-1995'/
C
      IFAIL = 0
      IWRITE = 6
      NVIB  = 0
      NDIS  = 0
      NSTAT = 0
      do 5 i=1,maxtgt
      eshift(i) = zero
 5    continue
C
C----- GET DATE STAMP
      CALL DATEST(DAYTIM)
C
C----- READ BASIC INPUT DATA
      NAME = BLANK
      READ(5,INTFIN)
      IF(IAFORM.EQ.'U') AFORM='UN'//FORM
      IF(IBFORM.EQ.'U') BFORM='UN'//FORM
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM
C
      IF(NTARG.GT.MAXTGT) GO TO 96
      if(idtarg(1).eq.0) then
        do 1 i=1,ntarg
        idtarg(i) = i
 1      continue
      endif
      IF(NOCSF.EQ.0) THEN
        call CWBOPN(LUCI)
        READ(LUCI) NT,ND,ND,NOCSF
      ENDIF
      IF(NSTAT.EQ.0) NSTAT=NOCSF
C
C----- PRINT OUT INPUT DATA
      NAME(61:) = DAYTIM
      WRITE(IWRITE,12) MODDAT,NAME
      SYMTYP = ABS(GUTOT)
      WRITE(IWRITE,10) R,MGVN,STOT,GUTOT,SYMTYP
      if (mgvn.eq.0) write(iwrite,110) isgn
      WRITE(IWRITE,11) LUTARG,NTSET,FORM,LUAMP,NASET,AFORM,LUCI,NCISET,
     1CIFORM,LUBUT,NBSET,BFORM
      WRITE(IWRITE,13) LUCHAN,NCHSET,CHFORM,LURMT,NRMSET,RFORM
C
C----- CHECK CONSISTENCY OF IDCSF
      DO 3 I=MAXCID,1,-1
      NID = I
      IF(IDCSF(1,I).NE.0.OR.IMCSF(1,I).NE.0) GO TO 4
 3    CONTINUE
 4    IF(NIDCSF.EQ.1) NIDCSF=NID
      IF(NID.NE.NIDCSF) THEN
        WRITE(IWRITE,17) NIDCSF,NID
        NIDCSF = NID
      ENDIF
      IF(NIDCSF.LT.NTARG) WRITE(IWRITE,18) NIDCSF,NTARG
      IF(IDCSF(1,NID).NE.0) THEN
        WRITE(IWRITE,21) NIDCSF,((IDCSF(I,J),I=1,4),J=1,NIDCSF)
      ELSE
        WRITE(IWRITE,22) NIDCSF,((IMCSF(I,J),I=1,2),J=1,NIDCSF)
      ENDIF
C
C----- READ TARGET DATA
      CALL RDTARG(IWRITE,LUTARG,NTSET,R,NTARG,MTARG,STARG,ITARG,GTARG,
     1 ETARG,NNUC,NUCCEN,CHARG,GEONUC,RMASS,ISMAX,TMOM,idtarg,
     2 eshift,IPRNT(5),IFAIL)
      close(lutarg)
      IF(IFAIL.NE.0) RETURN
c
      IZ1 = MOD(NUCCEN+1,nnuc+1)
      IZ2 = MOD(NUCCEN-1,nnuc+1)
      IF((CHARG(IZ1).EQ.CHARG(IZ2).AND.SYMTYP.EQ.0).OR.
     1   (CHARG(IZ1).NE.CHARG(IZ2).AND.SYMTYP.EQ.1)) GO TO 94
      EBASE = ETARG(1)
C
C----- CALCULATE RESIDUAL CHARGE OF SYSTEM
      ION = -NELT
      DO 2 I=1,NNUC
      ION = ION+CHARG(I)
 2    CONTINUE
C
C---- Read amplitudes file to determine (l,m) pairs
      CALL COUNTL(LNM,LUAMP,NASET,AFORM,IATYPE,MAXTGT,MAXCH,NORBL,
     * NTARG,MTARG,GTARG,MGVN,GUTOT,IWRITE,IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C----- CALCULATE SCATTERING CHANNEL PARAMETERS
      CALL CHANL(NTARG,NLTARG,NMTARG,itarg,GTARG,MTARG,STARG,ETARG,MGVN,
     1 GUTOT,STOT,isgn,SYMTYP,EBASE,LNM,NCHAN,ICHL,LCHL,MCHL,ECHL)
      IF(nchan.gt.maxch) GO TO 96
C
      CALL WRITCH(LUCHAN,NCHSET,CHFORM,R,RMASS,ICHL,LCHL,MCHL,ECHL,NTARG
     1,STARG,MTARG,GTARG,ETARG,IVTARG,IV,NAME,IPRNT(1),IFAIL)
      close(luchan)
      IF(IFAIL.NE.0) RETURN
C
C----- CALCULATE FIXED NUCLEI ASYMPTOTIC POTENTIAL MULTIPOLE COEFFS
      NCHSQ = NCHAN*(NCHAN+1)/2
      allocate (fnmc(ismax*nchsq))
      IF(ISMAX.GT.0) THEN
C
        CALL ASYMC(NCHAN,ISMAX,NTARG,ICHL,LCHL,MCHL,FNMC,
     1  MGVN,TMOM,ALPHA0,ALPHA2)
C
        IF(IPRNT(2).GT.0) THEN
          WRITE(IWRITE,20)
          DO 8 IS=1,ISMAX
          WRITE(IWRITE,27) IS
          ISS = 1+(IS-1)*NCHSQ
          CALL MATTPT(NCHAN,fnmc(ISS),IWRITE)
 8        continue
        ENDIF
      ENDIF
C
C----- Storage allocation for CI data and scattering amplitudes
      WRITE(IWRITE,15) NOCSF,NSTAT,NPOLE,ISMAX
      allocate (pole(nocsf),wamp(nchan*nstat),vec(nstat*nocsf))
C
C---- Read CI eigenvalues and eigenvectors produed by CI code
      CALL READCI(LUCI,IWRITE,NNUC,GEONUC,NSTAT,NOCSF,POLE,
     1 VEC,nob,IPRNT(3),NCISET,IFAIL)
      close(luci)
      IF(IFAIL.NE.0) RETURN
C
C---- Read scattering amplitudes produced by the MOS code
C
      CALL SAMP(NOCSF,NSTAT,VEC,NIDCSF,IDCSF,IMCSF,NCHAN,ICHL,LCHL,
     1 MCHL,WAMP,RMATR,GEONUC,LUAMP,NASET,AFORM,IATYPE,MAXTGT,MAXCH,
     * NORBL,nvo,nob,IWRITE,IPRNT(4),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C----- READ IN BUTTLE CORRECTIONS
C
      IBUT = 1
      allocate (bcoef(3*maxch))
      if(lubut.eq.luamp) then
        ibtype=1
      else
        ibtype=0
      endif
      CALL BUTRD(NCHAN,LCHL,MCHL,ECHL,EBMIN,EBMAX,RMATR,BCOEF,LUBUT,
     * NBSET,BFORM,ibtype,IWRITE,IPRNT(5),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C---- Write R-matrix data file
      CALL WRITRM(LURMT,NRMSET,RFORM,NOCSF,ISMAX,NPOLE,FNMC,
     1 POLE,WAMP,VEC,BCOEF,NTARG,R,RMASS,RMATR,IBUT,NAME,IPRNT(6),IFAIL)
      CLOSE(UNIT=LURMT)
c
      deallocate (bcoef,wamp,pole,vec,fnmc)
      IF(IFAIL.EQ.0) WRITE(IWRITE,16)
      RETURN
C
 96   WRITE(IWRITE,98) NTARG,nchan,maxtgt,maxch
 98   FORMAT(/' INPUT DATA WILL EXCEED FIXED DIMENSIONS'/' INPUT  ',
     12I5/' MAXIMA ',2I5)
      IFAIL = 1
      RETURN
 94   WRITE(IWRITE,93) GUTOT
 93   FORMAT(/' GUTOT =',I2,'   IS INCOMPATIBLE WITH TARGET DATA')
      IFAIL = 1
      RETURN
C
 10   FORMAT(/' Fixed nuclei data for R =',F8.4,//' Symmetry data  MGVN
     1=',I2,' STOT =',I2,' GUTOT =',I2,' SYMTYP =',I2)
 110  FORMAT('                ISGN =',i2)
 11   FORMAT(/' Input datasets:             Unit  Set number'/
     1' Target data          LUTARG ',I3,5X,I3,5X,A11/
     2' Boundary amplitudes  LUAMP  ',I3,5X,I3,5X,A11/
     3' CI data              LUCI   ',I3,5X,I3,5X,A11/
     4' Buttle corrections   LUBUT  ',I3,5X,I3,5X,A11)
 12   FORMAT(//' Program INTERF  ( last modified ',A,' )'//A/)
 13   FORMAT(/' Output datasets:            Unit  Set number'/
     1' Channel data         LUCHAN ',I3,5X,I3,5X,A11/
     2' R-Matrix data        LURMT  ',I3,5X,I3,5X,A11)
 15   FORMAT(/' Dimension of Hamiltonian matrix           NOCSF =',I5
     1       /' Number of CSFs used to construct R-matrix NSTAT =',I5
     2       /' Number of eigenvectors to be retained     NPOLE =',I5
     3       /' Number of multipoles in potential         ISMAX =',I5)
 16   FORMAT(//' *** Task has been successfully completed ***')
 17   FORMAT(/' *** WARNING *** INPUT VALUE OF NIDCSF=',I2,' DOES NOT EQ
     1UAL NUMBER OF NON-ZERO QUARTETS IDCSF ',I2/' INPUT VALUE OF NIDCSF
     2 IS IGNORED')
 18   FORMAT(/' *** WARNING *** INPUT VALUE OF NIDCSF=',I2,' IS LESS THA
     1N NTARG=',I2)
 20   FORMAT(/' Multipole coefficients for asymptotic potentials')
 21   FORMAT(/' Using',I3,' quartets IDCSF'/(8(3X,4I3)))
 22   FORMAT(/' Using',I3,' doublets IMCSF'/(8(3X,2I3)))
 27   FORMAT(/' Lambda',I3)
C
      END
      SUBROUTINE SAMP(NOCSF,NSTAT,CIV,NIDCSF,IDCSF,IMCSF,NCHAN,ICHL,
     1 LCHL,MCHL,WMATP,RMATR,GEON0,LUAMP,NASET,AFORM,
     2 ITYPE,MAXTGT,MAXCH,NORBL,nvo,nobci,IWRITE,NPFLG,IFAIL)
C
C***********************************************************************
C
C     SAMP computes array WMATP of surface amplitudes using the
C          ci eigenvectors given in array CIV and the array of
C          boundary amplitudes AMP which are read in from unit LUAMP
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER SYMTYP
      CHARACTER(LEN=11) AFORM
      CHARACTER(LEN=80) HEAD,OLD
      DIMENSION CIV(NOCSF,NSTAT),MG(MAXTGT),ICHL(NCHAN),LCHL(NCHAN),
     1 MCHL(NCHAN),LSAV(MAXCH),IDCSF(4,NIDCSF),GEONUC(20),NOB(40),
     2 WMATP(NCHAN,NSTAT),IG(MAXTGT),GEON0(*),IMCSF(2,NIDCSF),nobci(*),
     3 NORBL(MAXTGT,*),nvo(nidcsf)
      double precision, allocatable :: amp(:)
      DATA ZERO/0.D0/,TINY/1.D-8/
      DATA OLD/' OLD STYLE AMPLITUDE FILE'/
C
C----- INITIALIZE AMPLITUDE ARRAY (GEOMETRIES MUST BE CONTIGUOUS)
C
      DO 10 J=1,NSTAT
      DO 1 I=1,NCHAN
      WMATP(I,J) = ZERO
 1    continue
 10   continue
C
      ROOTR = SQRT(RMATR)
C
C --- Locate the required dataset and read its header
      IF(ITYPE.EQ.0) THEN
        KEY = 3
      ELSE
        KEY = 22
      ENDIF
      NSET = NASET
      CALL GETSET(LUAMP,NSET,KEY,AFORM,IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(IWRITE,11) NASET,LUAMP
        RETURN
      ELSE
        READ(LUAMP) NKEY,NSET,NREC
        IF(ITYPE.NE.0) THEN
C ---   New style
          READ(LUAMP) HEAD
          READ(LUAMP) SYMTYP,NSYM,NOB,RMATR,NNUC,GEONUC,NUCCEN
          WRITE(IWRITE,200) NASET,LUAMP,HEAD
          DO 3 I=1,NNUC
          IF(ABS(GEONUC(I)-GEON0(I)).GT.TINY) GO TO 99
 3        CONTINUE
          if(symtyp.eq.0) then
            do 13 i=1,nsym
            if(nob(i).ne.nobci(i)) go to 95
 13         continue
          else
            do 14 i=1,nsym
            if((nob(2*i-1)+nob(2*i)).ne.nobci(i)) go to 95
 14         continue
          endif
          IF(IMCSF(1,NIDCSF).EQ.0) THEN
            DO 4 I=1,NIDCSF
            IMCSF(1,I) = IDCSF(1,I)
            IMCSF(2,I) = IDCSF(2,I)
 4          continue
          ENDIF
        ELSE
C ---   OLd style
          WRITE(IWRITE,200) NASET,LUAMP,OLD
          IF(IDCSF(1,NIDCSF).EQ.0) GO TO 97
        ENDIF
      ENDIF
C
      IF(ITYPE.EQ.1) THEN
        READ(LUAMP)NMG,(MG(I),I=1,NMG),(IG(I),I=1,NMG)
      ELSE
        READ(LUAMP)NMG,(MG(I),I=1,NMG)
      ENDIF
      IF(NMG.GT.MAXTGT) GO TO 2020
C
C----- LOOP OVER SYMMETRIES
      DO 20 MI=1,NMG
C
C     M      SYMMETRY OF AMPLITUDES
C     NORB   NUMBER OF CONTINUUM ORBITALS FOR SYMMETRY
C     NL     NUMBER OF ORBITAL ANGULAR MOMENTUM VALUES FOR SYMMETRY
C     NA     NUMBER OF AMPLITUDES FOR SYMMETRY
C     LSAV   ORBITAL A.M. VALUES ( NL ENTRIES )
C     AMP    BOUNDARY AMPLITUDES ( NA VALUES ) .. THE NL AMPLITUDES
C            FOR A GIVEN CONTINUUM ORBITAL ARE GROUPED TOGETHER
C
      READ(LUAMP)M,NORB,NL,NA,(Ldum,J=1,NL),(Adum,J=1,NA)
      backspace luamp
      allocate (amp(na))
      READ(LUAMP)M,NORB,NL,NA,(LSAV(J),J=1,NL),(AMP(J),J=1,NA)
      IF(NL.GT.MAXCH) GO TO 2020
      IF(NPFLG.GT.0) WRITE(IWRITE,19) M,(AMP(J),J=1,NA)
C
C      RENORMALIZE BY MULTIPLYING BY SQRT(RMATR)
      if(itype.eq.0) then
        DO 12 J=1,NA
        AMP(J) = ROOTR*AMP(J)
 12     continue
      endif
C
C----- LOOP OVER CHANNELS WITH CURRENT SYMMETRY
      IF(ITYPE.EQ.0) THEN
        DO 21 IP=1,NCHAN
        IF(ABS(MCHL(IP)).EQ.M) THEN
          LCH = LCHL(IP)
          MCH = ABS(MCHL(IP))
          ICH = ICHL(IP)
          NAMPL = 0
C
C----- LOOP OVER CHANNEL ANGULAR MOMENTA
          DO 22 J=1,NL
          IF(LCH.EQ.LSAV(J)) THEN
C
C------ LOOP OVER SCATTERING CSFS
            K = 0
            DO 23 NC=1,NIDCSF
            ITCSF = IDCSF(1,NC)
            MVAL  = IDCSF(2,NC)
            IOCSF = IDCSF(3,NC)
            NCSF  = IDCSF(4,NC)
            IF(ITCSF.EQ.ICH.AND.MVAL.EQ.MCH) THEN
              IOC = IOCSF+NAMPL
              DO 24 KC=1,NCSF
              K = K+1
              IF(IOC.GT.NA) GO TO 2010
              DO 25 I=1,NSTAT
              WMATP(IP,I) = WMATP(IP,I)+CIV(K,I)*AMP(IOC)
 25           CONTINUE
              IOC = IOC+1
 24           continue
            ELSE
              K = K+NCSF
            ENDIF
 23         CONTINUE
          ENDIF
          NAMPL = NAMPL+NORB
 22       continue
        ENDIF
 21     CONTINUE
      ELSE
C
C --- New style file
C
        DO 31 IP=1,NCHAN
        LCH = LCHL(IP)
        IF(SYMTYP.EQ.1) THEN
          IF(MOD(LCH,2).NE.0) THEN
            IGU = -1
          ELSE
            IGU = 1
          ENDIF
        ELSE
          IGU = 0
        ENDIF
        IF(ABS(MCHL(IP)).EQ.MG(MI).AND.IGU.EQ.IG(MI)) THEN
          MCH = ABS(MCHL(IP))
          ICH = ICHL(IP)
          NAMPL = 0
C
C----- LOOP OVER CHANNEL ANGULAR MOMENTA
          DO 32 J=1,NL
          IF(LCH.EQ.LSAV(J)) THEN
C
C------ LOOP OVER SCATTERING CSFS
            K = 0
            DO 33 NC=1,NIDCSF
            ITCSF = IMCSF(1,NC)
            MVAL  = IMCSF(2,NC)
            k = k+nvo(nc)
            IF(ITCSF.EQ.ICH.AND.MVAL.EQ.MCH) THEN
              IOC = NAMPL+1
              DO 34 KC=1,NORB
              K = K+1
              IF(IOC.GT.NA) GO TO 2010
              DO 35 I=1,NSTAT
              WMATP(IP,I) = WMATP(IP,I)+CIV(K,I)*AMP(IOC)
 35           CONTINUE
              IOC = IOC+1
 34           continue
            ELSE
              K = K+NORBL(itcsf,mval+1)
            ENDIF
 33         CONTINUE
          ENDIF
          NAMPL = NAMPL+NORB
 32       continue
        ENDIF
 31     CONTINUE
      ENDIF
      deallocate (amp)
C
 20   CONTINUE
C
      RETURN
C
 99   WRITE(IWRITE,98) (GEONUC(I),GEON0(I),I=1,NNUC)
 98   FORMAT(/' INCONSISTENCIES IN INPUT DATA DETECTED IN SAMP',/,
     1 ' Geometry data does not match that in CI file'/(6F10.5))
      ifail = 1
      return
c
 95   WRITE(IWRITE,94) (nob(I),nobci(I),I=1,nsym)
 94   FORMAT(/' INCONSISTENCIES IN INPUT DATA DETECTED IN SAMP',/,
     1 ' Orbital numbers do not match those in CI file'/(10i5))
      ifail = 1
      return
c
 97   WRITE(IWRITE,96) 
 96   FORMAT(/' INCONSISTENCIES IN INPUT DATA DETECTED IN SAMP',/,
     1 ' Old style amplitude file, but IDCSF not set')
      ifail = 1
      return
C
 2010 WRITE(IWRITE,2060) IOC,NA,ICH,LCH,MCH,NORB,NC,(IDCSF(I,NC),I=1,4)
 2060 FORMAT(/' INCONSISTENCIES IN INPUT DATA DETECTED IN SAMP',/,
     1       ' Amplitude number',I4,' required, but only',I4,' on file'/
     1       ' ICH =',I6,2X,'LCH =',I6,2X,'MCH =',I6,2X,'NORB =',I6/
     2       ' NC =',I6,2X,'IDCSF =',4I6)
      IFAIL = 1
      RETURN
 2020 WRITE(IWRITE,2070) NMG,NL,MAXTGT,MAXCH
 2070 FORMAT(' AMPLITUDE DATA EXCEEDS FIXED DIMENSIONS IN SAMP',/,
     1       ' Input NMG, NL',2I8,'  but MAXTGT, MAXCH in INTERF',2I8)
      IFAIL = 1
      RETURN
 11   FORMAT(/' BOUNDARY AMPLITUDE DATASET ',I4,' NOT FOUND ON UNIT',I3)
 19   FORMAT(/' Input boundary amplitudes for symmetry',I3/(8E15.6))
 200  FORMAT(/' Boundary amplitudes have been read from set number',I3,
     1' on unit',I3,5X,A)
      END
      SUBROUTINE COUNTL(MAXLM,LUAMP,NASET,AFORM,ITYPE,MAXTGT,
     2 MAXCH,NORBL,NTARG,MTARG,GTARG,MGVN,GUTOT,IWRITE,IFAIL)
C
C***********************************************************************
C
C     COUNTL reads boundary amplitude file in order to discover which
C          l,m pairs have been saved
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER(LEN=11) AFORM
      CHARACTER(LEN=80) HEAD
      DIMENSION MG(MAXTGT),LSAV(MAXTGT,MAXCH),MAXLM(MAXTGT),NOB(40),
     1 GEONUC(20),NORBL(MAXTGT,*),MTARG(NTARG),GTARG(NTARG),IG(MAXTGT)
      INTEGER SYMTYP,GTARG,GUTOT
C
C----- LOCATE THE REQUIRED DATASET
C
      KEY = 22
      NSET = NASET
      CALL GETSET(LUAMP,NSET,KEY,AFORM,IFAIL)
      IF(IFAIL.NE.0) THEN
C ---- General case, GETSET does check KEY
        IF(KEY.EQ.22) THEN
          KEY = 3
          IFAIL = 0
          CALL GETSET(LUAMP,NSET,KEY,AFORM,IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(IWRITE,11) NASET,LUAMP
            RETURN
          ELSE
            ITYPE = 0
            READ(LUAMP) NKEY,NSET,NREC,HEAD
          ENDIF
        ELSE
          WRITE(IWRITE,11) NASET,LUAMP
          IFAIL = 1
          RETURN
        ENDIF
      ELSE
C
C ---- First set on amplitude file, GETSET does not check KEY
        READ(LUAMP) NKEY,NSET,NREC
        IF(NKEY.EQ.KEY) THEN
          ITYPE = 1
          READ(LUAMP) HEAD
          READ(LUAMP) SYMTYP,NSYM,NOB,RMATR,NNUC,GEONUC,NUCCEN
        ELSE IF(NKEY.EQ.3) THEN
          ITYPE = 0
        ELSE
          WRITE(IWRITE,11) NASET,LUAMP
          IFAIL = 1
          RETURN
        ENDIF
      ENDIF
      WRITE(IWRITE,200) NASET,LUAMP
C
C     NMG = NUMBER OF SYMMETRY VALUES
C     MG  = SYMMETRY QUANTUM NUMBER
C
      IF(ITYPE.EQ.0) THEN
        READ(LUAMP)NMG,(MG(I),I=1,NMG)
      ELSE
        READ(LUAMP)NMG,(MG(I),I=1,NMG),(IG(I),I=1,NMG)
      ENDIF
      IF(NMG.GT.MAXTGT) GO TO 2020
C
C----- LOOP OVER SYMMETRIES
      NLTOT = 0
      DO 2 I=1,MAXTGT
      MAXLM(I) = 0
 2    continue
      DO 20 MI=1,NMG
C
C     M      SYMMETRY OF AMPLITUDES
C     NORB   NUMBER OF CONTINUUM ORBITALS FOR SYMMETRY
C     NL     NUMBER OF ORBITAL ANGULAR MOMENTUM VALUES FOR SYMMETRY
C     NA     NUMBER OF AMPLITUDES FOR SYMMETRY
C     LSAV   ORBITAL A.M. VALUES ( NL ENTRIES )
C
      READ(LUAMP)M,NORB,NL,NA,(LSAV(M+1,J),J=1,NL)
      NLTOT = NLTOT+NL
      MAXLM(M+1) = MAX(MAXLM(M+1),LSAV(M+1,NL))
      IF(NLTOT.GT.MAXCH) GO TO 2020
      IF(ITYPE.EQ.1) THEN
        DO 1 I=1,NTARG
        IF(GUTOT.NE.0) THEN
          IGT = 1-ABS(GUTOT-GTARG(I))
        ELSE
          IGT = 0
        ENDIF
        IF(IG(MI).NE.IGT) GO TO 1
        IF(M.EQ.ABS(MGVN-MTARG(I)).OR.M.EQ.MGVN+MTARG(I)) 
     1                                            NORBL(I,M+1)=NORB
 1      CONTINUE
      ENDIF
C
 20   CONTINUE
C
      REWIND LUAMP
      RETURN
C
 2020 WRITE(IWRITE,2070) NMG,NL,MAXTGT,MAXCH
 2070 FORMAT(' AMPLITUDE DATA EXCEEDS FIXED DIMENSIONS IN COUNTL',/,
     1       ' Input NMG, NL',2I8,'  but MAXTGT, MAXCH in INTERF',2I8)
      IFAIL = 1
      RETURN
 11   FORMAT(/' BOUNDARY AMPLITUDE DATASET ',I4,' NOT FOUND ON UNIT',I3)
 200  FORMAT(/' Boundary amplitudes are being read from set number',I3,
     1 ' on unit',I3,5X,A)
      END
      SUBROUTINE READCI(LUCI,IWRITE,NNUC,GEONUC,NSTAT,NKEEP,EIG,EIGV,
     1 nhe,LBUG,NCISET,IFAIL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     READCI READS IN CI VECTORS AND EIGENVECTORS FROM ALCHEMY DUMPFILE
C
C       LUCI  = UNIT NUMBER OF CI DUMPFILE
C       IWRITE  = UNIT NUMBER OF PRINTER
C       NNUC  = NUMBER OF NUCLEAR CENTRES
C       GEONUC= DISTANCE OF NUCLEI FROM CENTRE OF COORDINATES
C       NKEEP = NUMBER OF CSF'S RETAINED
C       NSTAT = NUMBER OF CI STATES
C       EIG   = R-MATRIX POLE POSITIONS
C       EIGV  = CI EIGENVECTORS
C
C***********************************************************************
C
      PARAMETER (MAXN=20)
      CHARACTER(LEN=4) NAME(30)
      DIMENSION EIG(NSTAT),EIGV(NSTAT*NKEEP),GEONUC(3),NHD(10),NHE(20),
     1 DTNUC(2*MAXN)
      DATA EPS/1.D-6/
C
C----- SEARCH ALCHEMY DUMPFILE ON UNIT LUCI FOR THE REQUIRED DATASET
C
      REWIND LUCI
      NPASS = 1
C
 30   READ(LUCI,END=40) NT,NHD,NAME,NHE,EN,DTNUC
      NOCSF = NHD(3)
      IF(LBUG.EQ.1) WRITE(IWRITE,41) NT,NOCSF,(DTNUC(MAXN+I),I=1,3)
     1,NCISET,NKEEP,(GEONUC(I),I=1,3)
 41   FORMAT(' CI header    ',2I5,3D15.6/' Required data',2I5,3D15.6)
C
C---- IS THIS THE REQUIRED FILE ? (Check set number and geometry data)
      IF(NCISET.NE.0.AND.NT.NE.NCISET) GO TO 2
      DO 3 I=1,NNUC
      IF(ABS(DTNUC(MAXN+I)-GEONUC(I)).GT.EPS) GO TO 2
 3    CONTINUE
C
C----- DO WE HAVE THE CORRECT DIMENSION INFORMATION ?
      IF(NOCSF.GT.NKEEP) THEN
        WRITE(IWRITE,26) NKEEP,NOCSF
        GO TO 200
      ELSE IF(NOCSF.LT.NKEEP) THEN
        WRITE(IWRITE,25) NKEEP,NOCSF
        NKEEP = NOCSF
      ENDIF
C
C----- DUMPFILE IS NOW CORRECTLY POSITIONED
      GO TO 52
C
C----- THIS IS NOT THE REQUIRED DATASET, SO SKIP OVER IT
 2    DO 20 K=1,NOCSF+1
      READ (LUCI)
 20   continue
C
      GO TO 30
C
C----- END OF DATASET HAS BEEN REACHED
C      IF THIS IS THE FIRST PASS THROUGH THE DATA, THEN REWIND AND START
C      AGAIN FROM THE BEGINNING, ELSE PRINT ERROR MESSAGE
C
 40   IF(NPASS.EQ.1) THEN
         REWIND LUCI
         NPASS = NPASS+1
         GO TO 30
      ELSE
         WRITE(IWRITE,51) NCISET
         STOP
      ENDIF
C
C---- READ EIGENVALUE DATA (IGNORING DIVERGENCE AND ITERATION DATA)
C
 52   READ (LUCI,ERR=200) (IKEEP,I=1,NOCSF),(EIG(I),I=1,NOCSF)
      DO 1 I=1,NOCSF
      EIG(I) = EIG(I)+EN
 1    continue
C
C---- READ EIGENVECTORS
C
      IE = 0
      DO 21 I=1,NOCSF
      IB = IE+1
      IE = IE+NKEEP
      READ (LUCI,ERR=200) NTH,(EIGV(J),J=IB,IE)
 21   CONTINUE
C
      WRITE(IWRITE,27) NT,LUCI
      IF(LBUG.GT.1) THEN
        WRITE(IWRITE,10)
        WRITE(IWRITE,11)(EIG(I),I=1,NOCSF)
        WRITE(IWRITE,12)
        WRITE(IWRITE,11)(EIGV(I),I=1,NOCSF*NKEEP,NKEEP)
      ENDIF
C
      RETURN
C
 200  WRITE(IWRITE,28)
      IFAIL = 1
      RETURN
 10   FORMAT(/' Input CI eigenvalues ')
 11   FORMAT(8D15.6)
 12   FORMAT(/' Input eigenvectors, first element of each vector only')
 25   FORMAT(/' Fewer CI vectors on file than requested, NKEEP has been 
     1reduced from',I5,' to',I5)
 26   FORMAT(/' Insufficient space allocated for CI vectors, NKEEP =',I5
     1,' but NOCSF =',I5)
 27   FORMAT(/' CI data has been read from set number',I3,' on unit',I3)
 28   FORMAT(/' ERROR DETECTED BY READCI')
 51   FORMAT(/' Unable to find required CI dataset',I3/' Possible mis-ma
     1tch between CI header and properties file'/' Try rerunning with IP
     2RNT(3)=1')
      END
      SUBROUTINE CHANL(NTARG,NLTARG,NMTARG,itarg,GTARG,MTARG,STARG,
     1 ETARG,MGVN,GUTOT,STOT,isgn,SYMTYP,EBASE,MAXLM,NCHAN,ICHL,LCHL,
     2 MCHL,ECHL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     CHANL sets up variables defining asymptotic fixed-nuclei 
C     scattering channels.
C
C***********************************************************************
C
      INTEGER GTARG,STARG,GUTOT,SYMTYP,stot
      DIMENSION NLTARG(NTARG,*),GTARG(NTARG),MTARG(NTARG),STARG(NTARG),
     1 ETARG(NTARG),NMTARG(NTARG),ICHL(*),LCHL(*),MCHL(*),ECHL(*),
     2 itarg(ntarg),MAXLM(*)
      DATA TWO/2.D0/
C
      IX = 0
C
C     Loop over target states
      DO 8 I=1,NTARG
C
      if(abs(stot-starg(i)).ne.1) go to 8
      IF(MTARG(I).EQ.0) then
        if(mgvn.eq.0.and.itarg(i).ne.isgn) go to 8
        NMTARG(I) = MIN(NMTARG(I),1)
      endif
      MCON = MGVN-MTARG(I)
      MABS = ABS(MCON)
      NPTY = -(GTARG(I)*GUTOT-1)/2
C
C---- GET L INCREMENT FROM G/U SYMMETRY
      IF(SYMTYP.EQ.0) THEN
C     (Heteronuclear)
        INCL=1
        INCGU = 0
      ELSE
C     (Homonuclear)
        INCL=2
        INCGU = MOD(MABS+NPTY,2)
      ENDIF
C
C---- CHECK FOR LAMBDA DOUBLING
      IF(MGVN.EQ.0.OR.MTARG(I).EQ.0) THEN
        NM = MIN(NMTARG(I),1)
      ELSE
        NM = MIN(NMTARG(I),2)
      ENDIF
C
C     Loop over m and l
      DO 6 M=1,NM
      MP1 = MABS+1
      IF(NLTARG(I,M).EQ.0) THEN
        NL = (MAXLM(MP1)-MP1-INCGU+INCL+1)/INCL
      ELSE
        NL = NLTARG(I,M)
      ENDIF
      DO 7 L=1,NL
      LCH = MABS+(L-1)*INCL+INCGU
      IX=IX+1
      LCHL(IX) = LCH
      MCHL(IX) = MCON
      ICHL(IX) = I
      ECHL(IX) = TWO*(ETARG(I)-EBASE)
 7    CONTINUE
      MCON = MGVN+MTARG(I)
      MABS = ABS(MCON)
 6    CONTINUE
C
 8    CONTINUE
C
 9    NCHAN = IX
C
      RETURN
      END
      SUBROUTINE ASYMC(NCHAN,ISMAX,NTARG,ICHL,LCHL,MCHL,A,MGVN,
     1 U,ALPHA0,ALPHA2)
C
C***********************************************************************
C
C     ASYMC uses the lower triangular array of transition moments U
C           between each target state obtained in RDTARG to calculate
C           the array of coefficients defining the asymptotic
C           potentials, A .
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DIMENSION A(*),U(*),LCHL(NCHAN),MCHL(NCHAN),ICHL(NCHAN)
      DATA ONE/1.0D0/,TWO/2.0D0/,ZERO/0.0D0/,TINY/1.D-10/
C
C
C     INITIALIZE ARRAY A FOR COEFFICIENT STORAGE
C
      NCHAN2=NCHAN*(NCHAN+1)/2
C
      DO 2 I=1,ISMAX*NCHAN2
      A(I)=ZERO
    2 CONTINUE
C
      IPOL = 0
      IF(ABS(ALPHA0).GT.TINY.OR.ABS(ALPHA2).GT.TINY) IPOL=1
C
      NTG=NTARG*(NTARG+1)
C
C     OBTAIN TRANSITION MOMENTS BETWEEN TARGET STATES
C
C----- Initialize Clebsh-Gordon coeffs
C
      CALL ICGCF
C
C     BEGIN LOOP OVER CHANNELS
C
      DO 50 L1P=1,NCHAN
C
      L1  = LCHL(L1P)
      LL1 = L1+L1+1
      IT1 = ICHL(L1P)
      M1  = MGVN-MCHL(L1P)
      MM1 = 2*MCHL(L1P)+1
C
      DO 40 L2P=1,L1P
C
      L2  = LCHL(L2P)
      LL2 = L2+L2+1
      IT2 = ICHL(L2P)
      M2P = MCHL(L2P)
 10   M2  = MGVN-M2P
      MM2 = 2*M2P+1
C
      M12=M1-M2
      MM3=M12+M12+1
C
      ISM = ABS(L1-L2)
      IF(ISM.EQ.0) ISM=2
      IF(ABS(M12).GT.ISM) ISM=ISM+2*((ABS(M12)-ISM+1)/2)
      ISX = MIN(L1+L2,ISMAX)
C
      I1 = MAX(IT1,IT2)
      I2 = MIN(IT1,IT2)
C
C     RKN MOD : LOWER TRIANGLE OF ELEMENT PAIRS, /M12/ = /M-M'/, M+M'
C               WHERE M = /M1/, M' = /M2/
C
      IQT=I1*(I1-1)+2*I2-1
      IF(M1*M2 .LT. 0) IQT=IQT+1
      LQT = L1P*(L1P-1)/2+L2P
C
      DO 30 IS=ISM,ISX,2
C
      ISS=IS+IS+1
      ISQ=(IS-1)*NTG+IQT
      IQ= (IS-1)*NCHAN2+LQT
C
      CALL CGCOEF(LL1,ISS,LL2,MM1,MM3,MM2,CG1)
      CALL CGCOEF(LL1,ISS,LL2,1,1,1,CG2)
C
      AA = TWO*sqrt(dble(LL1))*CG1*CG2/sqrt(dble(LL2))
      A(IQ) = AA*U(ISQ)
C
   30 CONTINUE
C
C**** BODGE TO ADD POLARIZABILITIES TO GROUND STATE CHANNELS ONLY
C
      IF(IPOL.EQ.1.AND.IT1.EQ.1.AND.IT2.EQ.1) THEN
        IQ = 2*NCHAN2+LQT
        IF(L1.EQ.L2.AND.M1.EQ.M2) THEN
          AA = ONE
        ELSE
          AA = ZERO
        ENDIF
        CALL CGCOEF(LL1,5,LL2,MM1,MM3,MM2,CG1)
        CALL CGCOEF(LL1,5,LL2,1,1,1,CG2)
        BB = sqrt(dble(LL1))*CG1*CG2/sqrt(dble(LL2))
        A(IQ) = A(IQ)-AA*ALPHA0-BB*ALPHA2
      ENDIF
C
C     Extra contribution in case MGVN=0 but M1, M2 non-zero
      IF(MGVN.EQ.0.AND.M1*M2.GT.0) THEN
        M2P = -M2P
        GO TO 10
      ENDIF
C
   40 CONTINUE
C
   50 CONTINUE
C
      RETURN
      END
      SUBROUTINE RDTARG(IWRITE,LUTARG,NTSET,R,NTARG,MTARG,STARG,ITARG,
     1 GTARG,ETARG,NNUC,NUCCEN,CHARG,GEONUC,RMASS,ISMAX,U,idtarg,eshift,
     2 IPRNT,IFAIL)
C
C***********************************************************************
C
C     RDTARG READS TARGET STATE DATA FROM A DUMPFILE ATTACHED TO UNIT
C            LUTARG
C
C     THE DUMPFILE IS DIVIDED INTO DATASETS BY HEADER CARDS BEGINNING
C     WITH KEY = 9
C
C     ALL RECORDS HAVE A FIXED FORMAT ( LRECL = 80 ) :
C
C                   I1, 7I3, D20.12, 2X, A26
C
C     KEY = RECORD KEY = FIRST FIELD (I1)
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER GTARG,STARG
      CHARACTER(LEN=26) HEAD
      DIMENSION MTARG(*),STARG(*),ITARG(*),GTARG(*),ETARG(*),idtarg(*),
     1 U(*),INX(8),RA(20),ZA(20),GEONUC(*),CHARG(*),AMNUC(20),eshift(*),
     2 IP(ntarg),irp(ntarg)
      EQUIVALENCE (INX(1),KEY)
      DATA ZERO,ONE,TWO/0.0D0,1.D0,2.D0/,EPS/1.D-6/
      DATA PI/3.1415926535897932D0/,AMU/1822.832d0/
C
      rewind LUTARG
      TRPI = TWO*SQRT(PI)
C
C----- SEARCH DUMPFILE FOR REQUIRED DATASET
      IPASS = 1
C
C     SET HEADER    ...    KEY = 9 :
C
C     FIELD
C       2   SET NUMBER
C       3   NUMBER OF RECORDS IN SET
C       4   NUMBER OF GEOMETRY RECORDS ( NNUC )
C       5   NUMBER OF RECORDS OF TARGET DATA
C       6   NUMBER OF RECORDS OF MOMENT DATA
C       7   MOMENT TYPE SWITCH, ISW
C       8
C       9   INTERNUCLEAR SEPARATION, RAB  ( DIATOMICS ONLY )
C      10   26-CHARACTER HEADER FIELD
C
   17 READ(LUTARG,11,END=40)(INX(I),I=1,8),DNX,HEAD
      IF(KEY .NE. 9) GO TO 21
C
      RAB = DNX
      iset   = inx(2)
      ntarg1 = inx(5)
      IF(ABS(RAB-R).GT.EPS.OR.NTARG.gt.ntarg1.OR.
     1               (NTSET.NE.0.AND.Iset.NE.NTSET)) THEN
C
C----- THIS IS NOT THE REQUIRED DATA SET SO SKIP REMAINING RECORDS
         IF(IPRNT.NE.0) WRITE(IWRITE,98) NTSET,NTARG,R,Iset,ntarg1,RAB
         DO 19 J=1,inx(3)
         READ(LUTARG,11,END=21) (INX(I),I=1,8),DNX,HEAD
 19      continue
         GO TO 17
      ENDIF
C
C     FILE IS NOW POSITIONED AT REQUIRED GEOMETRY
C
      NNUC=INX(4)
      NMOM=INX(6)
      ISW=INX(7)
C
C     READ DATA DEFINING MOLECULAR GEOMETRY   ...   KEY = 8 :
C
C     FIELD
C       2   NUCLEAR SEQUENCE NUMBER (I)
C       3   SET TO 0 FOR A REAL TARGET NUCLEUS, TO 1 FOR THE SCATTERING
C       4   NUCLEAR CHARGE ( USE NAMELIST INPUT FOR NONINTEGRAL VALUES )
C       5   NUCLEAR MASS ( IN ATOMIC UNITS )
C       6
C       7
C       8
C       9   NUCLEAR POSITION, GEONUC(I)
C      10   26-CHARACTER HEADER FIELD
C
      DO 8 IT=1,NNUC
      READ(LUTARG,11,END=21) (INX(I),I=1,8),DNX,HEAD
      IF(KEY .NE. 8) GO TO 21
      ISEQ=INX(2)
      CHARG(ISEQ)=DBLE(INX(4))
      AMNUC(ISEQ)=DBLE(INX(5))
      GEONUC(ISEQ)=DNX
 8    CONTINUE
      IQ = 0
      DO 41 I=1,NNUC
      IF(I.EQ.NUCCEN) GO TO 41
      IQ = IQ+1
      ZA(IQ) = CHARG(I)
      RA(IQ) = ABS(GEONUC(I)-GEONUC(NUCCEN))
 41   CONTINUE
      if(charg(nnuc).le.zero) nnuc=nnuc-1
C
C     READ TARGET DATA   ...   KEY = 5  :
C
C     FIELD
C       2   STATE INDEX         (I)
C       3   MANIFOLD INDEX
C       4   INDEX WITHIN MANIFOLD
C       5   |M|            MTARG(I)
C       6   2*S+1          STARG(I)
C       7   +/- INDEX      ITARG(I)
C       8   G/U INDEX      GTARG(I)
C       9   E IN AU        ETARG(I)
C
      ik = 0
      DO 10 ITG=1,NTARG1
      READ(LUTARG,11,END=21) (INX(I),I=1,8),DNX,HEAD
   11 FORMAT(I1,7I3,D20.12,2X,A26)
      IF(KEY .NE. 5) GO TO 21
      iset = inx(2)
      do 24 it=1,ntarg
      if(iset.eq.idtarg(it)) go to 25
 24   continue
      go to 10
 25   ik = ik+1
      MTARG(Ik)=INX(5)
      STARG(Ik)=INX(6)
      ITARG(Ik)=INX(7)
      GTARG(Ik)=INX(8)
      ETARG(Ik)=DNX+eshift(ik)
 10   CONTINUE
      if(ik.ne.ntarg) then
        WRITE(IWRITE,98) ik,NTARG,R,ISET,NTARG1,RAB
        go to 21
      endif
C
C---- Sort target energies into ascending order
c     ( use eshift as work space )
      call sort_outer(ntarg,ip,etarg)
      do 31 i=1,ntarg
      irp(ip(i)) = i
      eshift(i) = etarg(i)
 31   continue
      do 32 i=1,ntarg
      etarg(i) = eshift(ip(i))
 32   continue
      call swap(ntarg,ip,mtarg,eshift)
      call swap(ntarg,ip,starg,eshift)
      call swap(ntarg,ip,itarg,eshift)
      call swap(ntarg,ip,gtarg,eshift)
      do 33 i=1,ntarg
      if(ip(i).ne.i) go to 34
 33   continue
      go to 35
 34   write(iwrite,95) (ip(i),i=1,ntarg)
C
C---- CALCULATE REDUCED MASS IN ATOMIC UNITS
 35   SUMM = ZERO
      PRODM = AMU
      DO 2 I=1,NNUC
      AM = AMNUC(I)
      SUMM = SUMM+AM
      IF(AM.GT.ZERO) PRODM=PRODM*AM
 2    CONTINUE
      RMASS = PRODM/SUMM
      WRITE(IWRITE,18)RMASS
C
C     RDTMOM DATA    ...    KEY = 1
C
C     FIELD
C       2   STATE INDEX          (I)
C       3   |M(I)|
C       4   STATE INDEX          (J)
C       5   |M(J)|
C       6   OPERATOR CENTER INDEX  KOP
C       7   OPERATOR L-VALUE       LOP
C       8   OPERATOR |M|-VALUE     MOP
C       9   TRANSITION MOMENT IN AU, ISW CONVENTION DETERMINED BY HEADER
C
      NTG=NTARG*(NTARG+1)
      LU=NTG*ISMAX
      DO 50 I=1,LU
      U(I)=ZERO
 50   continue
C
      WRITE(IWRITE,20)
      DO 60 IM=1,NMOM
      READ(LUTARG,11,END=21)(INX(I),I=1,8),DNX,HEAD
      IF(KEY .NE. 1) GO TO 21
C
      LOP=INX(7)
      IF(LOP .LT. 1 .OR. LOP .GT. ISMAX) GO TO 60
      IF(INX(6) .NE. NUCCEN) GO TO 21
c
c     check that this property corresponds to states being retained
      IT1 = INX(2)
      do 13 it=1,ntarg
      if(it1.eq.idtarg(it)) then
        it1 = it
        go to 14
      endif
 13   continue
      go to 60
 14   IT2 = INX(4)
      do 15 it=1,ntarg
      if(it2.eq.idtarg(it)) then
        it2 = it
        go to 16
      endif
 15   continue
      go to 60
c
 16   MT1 = INX(3)
      MT2 = INX(5)
      it1 = irp(it1)
      it2 = irp(it2)
      IF(MT1.NE.MTARG(IT1) .OR. MT2.NE.MTARG(IT2)) GO TO 21
      MOP=INX(8)
      I1 = MAX(IT1,IT2)
      I2 = MIN(IT1,IT2)
C
C     LOWER TRIANGULAR ARRAY OF ELEMENT PAIRS: |M1-M2|,M1+M2
C
      IQ=(LOP-1)*NTG+I1*(I1-1)+2*I2-1
      IF(INX(8) .NE. IABS(MTARG(I1)-MTARG(I2))) IQ=IQ+1
C
C----- CALCULATE MOMENTS U AS DEFINED BY BURKE,MACKEY AND SHIMAMURA
C      (J.PHYS.B         EQ 29)
C
      UG = DNX
C     The origin of the following 2 lines is mysterious so they have 
C     removed
C      IF(MT1.NE.0) UG=UG/SQRT(TWO)
C      IF(MT2.NE.0) UG=UG/SQRT(TWO)
      IF(ISW.EQ.2) UG=TRPI*UG/SQRT(TWO*DBLE(LOP)+ONE)
      IF(ISW.NE.0.AND.IT1.EQ.IT2.AND.MT1.EQ.MT2)
     1       UG = UG-ZA(1)*(-RA(1))**LOP-ZA(2)*RA(2)**LOP
      U(IQ) = UG
      WRITE(IWRITE,96)IT1,MT1,IT2,MT2,LOP,MOP,UG
 60   CONTINUE
C
      GO TO 22
C
 40   IF(IPASS.EQ.1) THEN
         REWIND LUTARG
         IPASS = IPASS+1
         GO TO 17
      ELSE
         WRITE(IWRITE,23)NTSET,R
 23      FORMAT(' UNABLE TO FIND REQUIRED TARGET DATA SET',I5,F10.3)
         STOP
      ENDIF
C
 22   CONTINUE
C
      RETURN
C
   21 WRITE(IWRITE,66)
   66 FORMAT(' ERROR in target properties data')
      WRITE(IWRITE,111) (INX(I),I=1,8),DNX,HEAD
  111 FORMAT(1X,I1,7I3,D20.12,2X,A26)
      IFAIL = 1
      RETURN
 98   FORMAT(' Required',2I5,F10.6,5X,'Skipped',2I5,F10.6)
 96   FORMAT(6I5,F10.5)
 18   FORMAT(/' Reduced mass',F9.1,' au')
 20   FORMAT(/' Transition moments')
 95   format(/' Warning, target states on properties file were not in en
     1ergy order'/' They have been reordered to',20i3/' Check that IMCSF
     2 uses energy ordered labels')
      END
      SUBROUTINE BUTRD(NCHAN,LCHL,MCHL,ECHL,EBMIN,EBMAX,
     1 RMATR,BUTTL,LUBUT,NBSET,BFORM,ibtype,IWRITE,IPRNT,IFAIL)
C
C***********************************************************************
C
C     BUTRD  READS THE BUTTLE CORRECTION FROM THE DISK FILE ATTACHED TO
C            UNIT LUBUT. THEY ARE STORED IN ARRAY BUTTL.  THIS IS
C            NBSET = SEQUENCE NUMBERS OF REQUIRED BUTTLE SET
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER(LEN=11) BFORM
      CHARACTER(LEN=72) HEAD
      integer, allocatable :: iwork(:)
      double precision, allocatable :: btemp(:,:)
      DIMENSION BUTTL(3,NCHAN),IPT(NCHAN),LCHL(NCHAN),MCHL(NCHAN),
     1 EB(4),ECHL(NCHAN)
      DATA KEY/7/,one/1.d0/,TWO/2.D0/
C
C     READ FIRST SET OF BUTTLE CORRECTIONS CHECKING THAT THE CORRECT
C     DATASET IS BEING USED, SETTING UP POINTERS AND COUNTING HOW
C     MANY ENERGIES ON THE FILE ARE RELEVANT TO THE CURRENT RUN
C
      if(ibtype.eq.0) then
C     Read Alchemy style header of NUMBAS output file
        CALL GETSET(LUBUT,NBSET,KEY,BFORM,IFAIL)
        IF(IFAIL.NE.0) GO TO 22
        READ(LUBUT,END=22)KEY,ISET,NREC,NCHANB,HEAD,
     1  (j,I=1,NCHANB),(j,I=1,NCHANB)
        allocate (iwork(2*nchanb),btemp(4,nchan))
        backspace lubut
        READ(LUBUT,END=22)KEY,ISET,NREC,NCHANB,HEAD,
     1  (IWORK(I),I=1,NCHANB),(IWORK(I+NCHANB),I=1,NCHANB)
        WRITE(IWRITE,20) NBSET,LUBUT
      else
C     Read data from end of amplitude file (always unformatted)
        read(lubut,end=22) nchanb
        allocate (iwork(2*nchanb),btemp(4,nchan))
        do 51 i=1,nchanb
        read(lubut) iwork(i),iwork(i+nchanb),(buttl(j,i),j=1,3)
 51     continue
      endif
C
C     SET UP POINTER ARRAY FOR BUTTLE FILE
C
      DO 40 I=1,NCHAN
      L = LCHL(I)
      M = ABS(MCHL(I))
      DO 41 J=1,NCHANB
      JJ = J
      IF (L.EQ.IWORK(J).AND.M.EQ.IWORK(J+NCHANB)) GO TO 42
 41   CONTINUE
      WRITE(IWRITE,44) L,M
      IFAIL = 1
      RETURN
C
C---- Set up pointers to channels involved in this run
 42   IPT(I)=JJ
 40   CONTINUE
C
      IF(ibtype.eq.0) THEN
        IF(NREC.GT.3) THEN
          WRITE(IWRITE,24)
          IB2 = 1+NREC/4
          IB3 = NREC-NREC/4
          READ(LUBUT) EBMIN,(BTEMP(1,J),J=1,NCHANB)
          EB(1) = EBMIN
          DO 17 I=2,NREC-1
          IF(I.EQ.IB2) THEN
            READ(LUBUT) EB(2),(BTEMP(2,J),J=1,NCHANB)
          ELSE IF(I.EQ.IB3) THEN
            READ(LUBUT) EB(3),(BTEMP(3,J),J=1,NCHANB)
          ELSE
            READ(LUBUT) EBUT
          ENDIF
 17       CONTINUE
          READ(LUBUT) EBMAX,(BTEMP(4,J),J=1,NCHANB)
          EB(4) = EBMAX
C
C---- Fit to parameterized form
          IF(IPRNT.GT.0) WRITE(IWRITE,25) (EB(I),I=1,4),(J,(BTEMP(I,J),
     1    I=1,4),J=1,NCHANB)
          DO 18 J=1,NCHANB
          CALL LSQ(EB,BTEMP(1,J),BUTTL(1,J))
 18       continue
        ELSE
          READ(LUBUT) EBMIN,EBMAX,((BUTTL(I,J),I=1,3),J=1,NCHANB)
          IF(IPRNT.GT.0) WRITE(IWRITE,26) EBMIN,EBMAX,(J,(BUTTL(I,J),
     1     I=1,3),J=1,NCHANB)
        endif
        rfac = rmatr
      else
        rfac = one
      ENDIF
C
C---- MULTIPLY BY RMATR AND ADJUST FOR DIFFERING CHANNEL ENERGIES
      DO 19 J=1,NCHAN
      JJ = IPT(J)
      E = ECHL(J)
      BTEMP(1,J) = Rfac*(BUTTL(1,JJ)-E*BUTTL(2,JJ)+E*E*BUTTL(3,JJ))
      BTEMP(2,J) = Rfac*(BUTTL(2,JJ)-TWO*E*BUTTL(3,JJ))
      BTEMP(3,J) = Rfac*BUTTL(3,JJ)
 19   CONTINUE
      DO 160 J=1,NCHAN
      DO 16 I=1,3
      BUTTL(I,J) = BTEMP(I,J)
 16   continue
 160  continue
C
      IF(IPRNT.GT.0) WRITE(IWRITE,27)(J,(BUTTL(I,J),I=1,3),J=1,NCHAN)
c
      deallocate (iwork,btemp)
C
      RETURN
C
 22   WRITE(IWRITE,23) NBSET,LUBUT
      IFAIL = 1
      RETURN
C
 20   FORMAT(/' Buttle data has been read from set number',I3,' on unit'
     1,I3)
 23   FORMAT(/' UNABLE TO FIND BUTTLE SET',I3,' ON UNIT',I3)
 24   FORMAT(/' Input Buttle data will be fitted to a quadratic form')
 25   FORMAT(/' Input Buttle data'/' Energies used for fitting',2X,
     14F10.5/' Channel',22X,'Corrections'/(I5,4D15.5))
 26   FORMAT(/' Input Buttle data'/2X,F10.5,5X,F10.5/(I5,3D12.4))
 27   FORMAT(/' Parameterized Buttle data'/' Channel',22X,'Coefficients'
     1/(I5,3D15.5))
 44   FORMAT(/,5X,'CONFLICT BETWEEN CHANNEL DATA & BUTTLE HEADER',
     +   5X,' CHANNEL L =',I3,' M =',I3,' NOT FOUND',//)
      END
      SUBROUTINE LSQ(P,Q,A)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION P(4),Q(4),X(3,3),C(3),A(3),WORK1(3),WORK2(3)
      DATA ZERO/0.D0/
C
      N=4
C
      DO 100 I=1,3
         DO 101 J=1,3
            X(I,J)=ZERO
            L=I+J-2
            IF(L.NE.0) GOTO 105
            X(I,J)=N
            GOTO 101
  105       DO 102 K=1,N
               X(I,J)=X(I,J)+P(K)**L
  102       CONTINUE
  101    CONTINUE
  100 CONTINUE
C
      DO 103 J=1,3
         C(J)=ZERO
         L=J-1
         IF(L.NE.0) GOTO 106
         DO 107 K=1,N
            C(J)=C(J)+Q(K)
  107    CONTINUE
         GOTO 103
  106    DO 104 K=1,N
            C(J)=C(J)+(P(K)**L)*Q(K)
  104    CONTINUE
  103 CONTINUE
C
      CALL MA01A(X,B,3,0,1,3,1,WORK1,WORK2)
      DO 20 I=1,3
      A(I) = ZERO
 20   continue
      DO 22 J=1,3
      CJ = C(J)
      DO 21 I=1,3
      A(I) = A(I)+X(I,J)*CJ
 21   continue
 22   continue
C
      RETURN
      END
      SUBROUTINE CWBOPN(LUNIT)
C***********************************************************************
C
C     OPENS UP A SEQUENTIAL UNIT
C
C***********************************************************************
C
      LOGICAL OP
C
      INQUIRE(UNIT=LUNIT,OPENED=OP)
C
      IF (.NOT.OP) OPEN(UNIT=LUNIT,STATUS='UNKNOWN',FORM='UNFORMATTED',
     *     ACCESS='SEQUENTIAL')
C
      REWIND LUNIT
C
      RETURN
      END
