! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE EIGEN_P(ifail)
C
C***********************************************************************
C
C     EIGENP calculates eigen-phases from K-matrices 
C      It is intended to be a self contained module which can be
C      run independantly from the main scattering calculation.
C      The argument X is a large array, of dimension MCOR,  to be used
C      as work space.
C      On exit, IFAIL=0 indicates succesful termination, else IFAIL=1
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXERN=10)
      CHARACTER(LEN=1) ICFORM,IKFORM
      CHARACTER(LEN=80) NAME
      DIMENSION NESCAT(MAXERN),EINC(2*MAXERN),IPRNT(6)
      double precision, allocatable :: en(:),phz(:),evchl(:),etarg(:)
      integer, allocatable :: ivtarg(:),ivu(:),ivchl(:),lvchl(:),
     * mvchl(:),starg(:),mtarg(:),gtarg(:)
      CHARACTER(LEN=11) KFORM,CFORM
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=4) CEUNIT(2)
      CHARACTER(LEN=8) BLANK,SNAME
      CHARACTER(LEN=20) DAYTIM
      INTEGER STOT,GUTOT
C
C***********************************************************************
C
C     Basic data describing the run is input in namelist /PHASIN/
C
C      EMIN     = MINIMUM REQUIRED SCATTERING ENERGY
C      EMAX     = MAXIMUM REQUIRED SCATTERING ENERGY
C      IEUNIT   = UNITS IN WHICH THESE ENERGIES ARE INPUT, 1= RYD, 2= EV
C      ICFORM   = 'F' IF LUCHAN IS FORMATTED, ELSE 'U'
C      IKFORM   = 'F' IF LUKMT IS FORMATTED, ELSE 'U'
C      IWRITE   = LOGICAL UNIT FOR PRINTED OUTPUT
C      LUCHAN   = LOGICAL UNIT FOR CHANNEL AND TARGET DATA
C      LUKMT    = LOGICAL UNIT FOR K-MATRIX input
C      NCHSET   = set number of channel data
C      NEPRNT   = Number of eigenphases to be printed at each energy
C      NKSET    = SET NUMBER OF K-MATRIX INPUT
C      NAME     = TITLE FOR ANY OUTPUT
C
      NAMELIST/PHASIN/LUKMT,IEUNIT,IWRITE,NAME,EMIN,EMAX,LUCHAN,NCHSET,
     1ICFORM,IKFORM,NRESON,ICON,LUPHSI,LUPHSO,SNAME,IPRNT,NEPRNT,NKSET,
     2NPOS
C
C***********************************************************************
C
      DATA IWRITE/6/,LUKMT/19/,NCHSET/1/,IEUNIT/1/,NRESON/0/,
     1CEUNIT/' RYD',' EV '/,NKSET/1/,VBIG/1.D+8/,ICON/0/,
     2BLANK/'        '/,LUCHAN/10/,ICFORM,IKFORM/2*'U'/,LUPHSI/0/,
     3IPRNT/6*0/,NEPRNT/0/,LUPHSO/0/
      DATA ZERO/0.D0/,RYD/0.073500D0/
      DATA FORM,CFORM,KFORM/3*'FORMATTED'/
C
      IFAIL = 0
      NEXT = 1
      R = ZERO
      NPOS = 0
      EMIN = ZERO
      EMAX = VBIG
      SNAME = BLANK
C
C---- Read basic data via namelist /PHASIN/
      READ(5,PHASIN)
      IF(ICFORM.EQ.'U') CFORM='UN'//FORM
      IF(IKFORM.EQ.'U') KFORM='UN'//FORM
      IF(NRESON.GT.0) WRITE(IWRITE,101)
C
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,100)NAME
C
C---- Find K-matrices and read dimension information
      CALL READKH(LUKMT,NKSET,MGVN,STOT,GUTOT,NCHAN,NVIB,NDIS,NTARG,
     1 ION,NERANG,NESCAT,EINC,R,NAPPR,KFORM,IWRITE,IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C----- Assign storage for energy independant data
      nvibd = max(nvib+ndis,ntarg)
      allocate (evchl(nchan),ivtarg(nvibd),ivu(nvibd),ivchl(nchan),
     * lvchl(nchan),mvchl(nchan),starg(nvibd),mtarg(nvibd),gtarg(nvibd),
     * etarg(nvibd))
C
C----- READ TARGET AND CHANNEL DATA
      NCHN = NCHAN
      CALL READTC(LUCHAN,NCHSET,NCHN,NVIB,NDIS,NTARG,ION,IVTARG,IVU,
     * IVCHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,GTARG,ETARG,R,RMASS,CFORM,
     * IWRITE,IPRNT(1),IFAIL)
      IF(NCHN.NE.NCHAN) THEN
        WRITE(IWRITE,92)
        IFAIL = 1
      ENDIF
      IF(IFAIL.NE.0) RETURN
      EBASE = ETARG(1)
C
C----- Set flag to denote approximation used
      IF(NAPPR.EQ.1) THEN
        NAPPR=0
      ELSE
        RR = ZERO
      ENDIF
C
C----- Calculate number of scattering energies in the range [EMIN,EMAX]
      IF(IEUNIT.EQ.2) THEN
        EMIN = EMIN*RYD
        EMAX = EMAX*RYD
      ENDIF
      CALL NEWE(EMIN,EMAX,NE,NERANG,NESCAT,EINC)
C
C----- Print out range of scattering energies
      IF(IEUNIT.EQ.2) THEN
        EMINP = EMIN/RYD
        EMAXP = EMAX/RYD
      ELSE
        EMINP = EMIN
        EMAXP = EMAX
      ENDIF
      WRITE(IWRITE,104) NE,EMINP,EMAXP,CEUNIT(IEUNIT)
C
C----- Allocate space for K-matrix and eigenphases
      allocate (en(ne),phz(ne*nchan))
C
C----- Calculate eigenphases at all energies
      NEK = NE
      CALL KEIGP(NEK,LUKMT,NCHAN,EMIN,EMAX,EN,PHZ,KFORM,iprnt(2),iwrite)
      IF(NEK.NE.NE) THEN
        WRITE(IWRITE,107) NEK,NE
        IF(NEK.LT.NE) NE=NEK
      ENDIF
C
C---- Compute eigenphase sum and print table
      IF(NE.EQ.0) THEN
        IFAIL = 1
        GO TO 90
      ENDIF
      NPRNT = MIN(NCHAN,NEPRNT)
c
      CALL ETABLE(IWRITE,NCHAN,ICON,EVCHL,LUPHSI,LUPHSO,NAME,SNAME,NE,
     * PHZ,EN,IEUNIT,IPRNT(6),NPRNT,NPOS)
C
C----- Close files and return to main routine
 90   CLOSE(UNIT=LUCHAN,STATUS='KEEP')
      CLOSE(UNIT=LUKMT,STATUS='KEEP')
      deallocate (en,phz,evchl,ivtarg,ivu,ivchl,lvchl,mvchl,etarg,starg,
     * mtarg,gtarg)
      IF(IFAIL.EQ.0) WRITE(IWRITE,106)
      RETURN
C
 92   FORMAT(/' *** DATA ON K-MATRIX FILE IS INCOMPATIBLE WITH CHANNEL D
     1ATA ***')
 100  FORMAT(//' Program EIGENP'//A/)
 101  FORMAT(/' RESONANCE FITTING NO LONGER AVAILABLE, USE RESON')
 104  FORMAT(/' Eigenphases will be computed for ',I3,' energies in the
     1 K-matrix file from',F8.4,' to',F8.4,A4)
 105  FORMAT(10A8)
 106  FORMAT(/' *** Task successfully completed ***')
 107  FORMAT(/' NUMBER OF ENERGIES',I4,' READ FROM K-MATRIX FILE IS INCO
     1MPATIBLE WITH NE =',I4,' GIVEN BY HEADER')
      END
      SUBROUTINE KEIGP(NE,LUKMT,NCHAN,EMIN,EMAX,ENRYD,PHZ,KFORM,
     1 iextra,iwrite)
C
C***********************************************************************
C
C     KEIGP reads K-matrices from unit LUKMT and calculates eigenphases
C     for each energy
C
C     Input:
C       NCHAN  = number of scattering channels
C       EMIN   = min energy for which eigenphases are required
C       EMAX   = max energy for which eigenphases are required
C       LUKMT  = unit number of K-matrix file
C       KFORM  = format flag for LUKMT
C       IEXTRA = flag for calculating and printing eigenvalues of K
C       
C     Output:
C       NE    = number of energies for which eigenphases have been
C               computed
C       ENRYD = energies at which eigenphases have been computed
C       PHZ   = eigenphases
C
C     Workspace:
C       AKMAT ( NCHAN*(NCHAN+1)/2 ) holds lower triangle of K-matrix
C       X ( 3*NCHAN*NCHAN+NCHAN ) needed by routine EIGPHA
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER(LEN=11) KFORM
      DIMENSION ENRYD(*),AKMAT(nchan*(nchan+1)/2),PHZ(NCHAN,*),
     * wkp(nchan)
      double precision, allocatable :: v(:),wk(:)
      double precision :: dummy(2)
      DATA ZERO/0.D0/,EPS/1.D-8/
C
      IE = 0
      if(iextra.ne.0) allocate (v(nchan*nchan),wk(nchan))
C
 3    IF(KFORM.EQ.'FORMATTED') THEN
        READ(LUKMT,*,END=1)NOPEN,NDOPEN,NCHAN2,EN
        READ(LUKMT,11)(AKMAT(I),I=1,NCHAN2)
      ELSE
        READ(LUKMT,END=1)NOPEN,NDOPEN,NCHAN2,EN,(AKMAT(I),I=1,NCHAN2)
      ENDIF
      IF(EN.LT.EMIN-EPS.OR.EN.GT.EMAX+EPS) GO TO 3
      IE = IE+1
      ENRYD(IE) = EN
C
C----- CALCULATE EIGENPHASES
      if (iextra.ne.0) then
         CALL EIGPHA(NOPEN,AKMAT,wkp,iextra,v)
      else
         CALL EIGPHA(NOPEN,AKMAT,wkp,iextra,dummy)
      endif
c
      DO 41 I=1,NOPEN
      PHZ(I,IE) = wkp(I)
 41   continue
      DO 42 I=NOPEN+1,NCHAN
      PHZ(I,IE) = ZERO
 42   continue
c
      if(iextra.ne.0) then
        do 43 i=1,nopen
        wk(i) = wkp(nopen-i+1)
 43     continue
        write(iwrite,100) en
        write(iwrite,101)
        CALL WRVCMT(v,wk,nopen,nopen,nopen,nopen,8,IWRITE)
        deallocate (v,wk)
      endif
C
      IF(IE.LT.NE) GO TO 3
C
 1    NE = IE
C
      RETURN
 10   FORMAT(3I5,F20.13)
 11   FORMAT(4D20.13)
 100  format(/' Energy =',f10.5)
 101  format(' Eigenphases and Eigenvectors')
      END
      SUBROUTINE EIGPHA(NCHAN,AKMAT,PHZ,iextra,v)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     EIGPHA COMPUTES EIGENPHASES BY DIAGONALIZING K-MATRIX
C     USED NAG ROUTINE F02AAF or F02ABF.
!NV-03 These routines have  been repalced by LAPACK routine
!NV-03 DSYEV and its LAPACK library subset (NV 15/10/03).
C     NCHAN = DIMENSION OF K-MATRIX
C     AKMAT = K-MATRIX (LOWER TRIANGLE)
C     PHZ   = EIGENPHASES ( IN DESCENDING ORDER)
C     WORK  = WORK SPACE OF DIMENSION NCHAN*NCHAN
C     WORK1 = WORK SPACE OF DIMENSION NCHAN
C     WORK2 = WORK SPACE OF DIMENSION NCHAN
C
C***********************************************************************
C
      DIMENSION PHZ(NCHAN),AKMAT(*),WORK(NCHAN,NCHAN),V(nchan,nchan),
     1WORK1(NCHAN),WORK2(3*NCHAN)
!      DATA IFAIL/0/
      external dsyev
C
      NCH1 = NCHAN+1
      K = 0
      DO 11 I=1,NCHAN
      DO 1 J=1,I
      K = K+1
      WORK(I,J) = AKMAT(K)
 1    continue
 11   continue
C
      if(iextra.eq.0) then
c     only compute eigenvalues
!NV-03        CALL F02AAF(WORK,NCHAN,NCHAN,WORK1,WORK2,IFAIL)
         call dsyev('n','l',nchan,work,nchan,work1,work2,3*nchan,
     *              ifail)
*         write (6,*)
*         write (6,*)'optimal LWORK is',work2(1)
      else
c     compute eigenvectors as well
!NV-03        CALL F02ABF(WORK,NCHAN,NCHAN,WORK1,V,NCHAN,1,WORK2,IFAIL)
!NV-03 Note that line above should have been: 
!NV-03        CALL F02ABF(WORK,NCHAN,NCHAN,WORK1,V,NCHAN,WORK2,IFAIL)
          call dsyev('v','l',nchan,work,nchan,work1,work2,3*nchan,
     *              ifail)
*          write (6,*)
*          write (6,*)'optimal LWORK is',work2(1)
      endif
C
      DO 2 I=1,NCHAN
      PHZ(I) = ATAN(WORK1(NCH1-I))
 2    continue
C
      RETURN
      END
      SUBROUTINE ETABLE(IWRITE,NC,ICON,ETHR,
     1 LUPHSI,LUPHSO,TITLE,STITLE,NUME,PHZ,EN,IEUNIT,IPFLG,NEPRNT,NPOS)
C
C***********************************************************************
C
C     ETABLE PRINTS TABLES SUMMARIZING THE RESULTS COMPUTED AT EACH
C            SCATTERING ENERGY :
C
C                    EIGENPHASES                  PHZ
C
C                    ICON = 0  NO SMOOTHING
C                         = 1  ADD MULTIPLES OF PI SO AS TO MINIMIZE
C                              THE DIFFERENCES BETWEEN SUCCESSIVE ENERGY
C                              POINTS (ONLY WITHIN ONE THRESHOLD)
C                         = 2  USE SECOND-ORDER FINITE DIFFERENCES TO
C                              ENSURE CONTINUITY
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      CHARACTER(LEN=80) TITLE,TITLE1
      CHARACTER(LEN=132) LINE,LINE1
      CHARACTER(LEN=8) STITLE
      CHARACTER(LEN=3) EUNIT(2),EUN
      CHARACTER(LEN=1) BLANK
      DIMENSION QUAD(NC),QUAD1(NC),PHAZE(NC),ETHR(NC),PHZ(NC,NUME),
     1EN(NUME),TOTPH(NUME),HOLD(10)
C
      DATA EUNIT/'RYD','EV'/,BLANK/' '/
      DATA PI/3.1415926535897932D+00/,ZERO/0.D0/,ONE/1.0D0/,
     1 VBIG/1.D+70/,EV/13.6054D0/,TOL/5.D-4/,HALF/0.5D0/
C
      NCQ=NC
      EUN = EUNIT(IEUNIT)
      DO 33 I=1,NCQ
      QUAD(I) = ZERO
 33   continue
c
      IF (LUPHSO .NE. 0) THEN
        REWIND LUPHSO
C
C     POSITION LUPHSI FOR WRITING OF EIGENPHASES
C
        IF(LUPHSI.NE.0) THEN
          REWIND LUPHSI
          READ(LUPHSI,40) TITLE1
          READ(LUPHSI,40) LINE1
          READ(LUPHSI,40) LINE
          BACKSPACE LUPHSI
          DO 41 I=131,1,-1
          J = I+1
          IF(LINE(I:I).NE.BLANK) GO TO 42
 41       CONTINUE
 42       IF(NPOS.EQ.0) NPOS = J/12-1
          IF(NPOS.EQ.10) THEN
            WRITE(IWRITE,440)
            LUPHSO = 0
            GO TO 1
          ENDIF
          WRITE(LUPHSO,40) TITLE1
          LINE  = LINE1
          LINE1 = LINE(:J)//'  '//STITLE
          WRITE(LUPHSO,40) LINE1
        ELSE
          WRITE(LUPHSO,40) TITLE
          LINE1 = '   ENERGY      '//STITLE
          WRITE(LUPHSO,40) LINE1
        ENDIF
      ENDIF
C
    1 IF(ICON.EQ.2) CALL ESMOOV(NC,QUAD,QUAD1,PHZ,EN,NUME,IWRITE)
C
C***********************************************************************
C
C     PRINTOUT OF TABLE HEADER
C     THIS NEEDS TO BE REWRITTEN
C
      NFORM = MIN(6,NEPRNT)
      WRITE(IWRITE,2444) TITLE,EUN,(I,I=1,NFORM)
C      IF (NC .GT. NFORM) WRITE(IWRITE,2445) (I,I=7,NC)
 2444 FORMAT(//1X,A,//,30X,'TABLE OF EIGENPHASES',//,4X,'I',3X,
     1 'E(',A,')',6X,' EIGENPHASE SUM  ','CHANNEL :',I3,5I16)
C 2445 FORMAT(33X,6I16)
C
C     LOOP OVER THRESHOLDS AND SCATTERING ENERGIES
C
      IE1=1
      DO 2400 ICH=1,NCQ
      IF (IE1 .GT. NUME) GOTO 2405
      IF (ICH .LT. NCQ) THEN
        EBIG = ETHR(ICH+1)
      ELSE
        EBIG = VBIG
      ENDIF
C
C     INITIALIZE ARRAY QUAD1 WITH MULTIPLES OF PI TO BE ADDED
C     TO THE EIGENPHASES AT THE FIRST ENERGY ABOVE EACH THRESHOLD
C
      DO 2402 I=1,NCQ
      QUAD1(I)=QUAD(I)
 2402 continue
C     ZM initialize ETAOLD
      ETAOLD = 0.0D0
C
      DO 2334 IE=IE1,NUME
C
      E=EN(IE)
C
C     HAVE CROSSED A THRESHOLD ?
C
      IF (E .GT. EBIG) GOTO 2403
C
C     LOOP OVER CHANNELS
C
      DO 2333 NO=1,NCQ
C
      NOX=NO
      DL=PHZ(NOX,IE)
C
      IF(ICON.NE.1) THEN
        DLX=DL
      ELSE IF(IE.EQ.1) THEN
C
C       USE QUADRANT TABLE FOR FIRST ENERGY
        DLX=DL+QUAD(NOX)*PI
      ELSE
C
C     DETERMINE QUADRANT CORRECTION BY REQUIRING THAT THE DIFFERENCE
C     BETWEEN THE PHASE AT THE CURRENT AND AT THE PREVIOUS ENERGY
C     IS MINIMIZED
C
        DLX=DL+QUAD1(NOX)*PI
        DLM=DLX-PI
        DLP=DLX+PI
C
        DLX1=DABS(DLX-PHAZE(NOX))
        DLX2=DABS(DLM-PHAZE(NOX))
        DLX3=DABS(DLP-PHAZE(NOX))
C
        IF(DLX2.LT.DLX1) GO TO 2332
        IF(DLX3.LT.DLX1) GO TO 2335
C
      ENDIF
C
C     QUADRANT UNCHANGED
C
 2330 PHAZE(NOX)=DLX
      GO TO 2333
C
 2332 IF(DLX3.LT.DLX2) GO TO 2335
C
C     SUBTRACT PI
C
      PHAZE(NOX)=DLM
      QUAD1(NOX)=QUAD1(NOX)-ONE
      GO TO 2333
C
C     ADD PI
C
 2335 PHAZE(NOX)=DLP
      QUAD1(NOX)=QUAD1(NOX)+ONE
C
 2333 CONTINUE
C
C     COMPUTE OVERALL PHASE SHIFT SUM
C
      TOTPHZ=ZERO
      DO 2929 NO=1,NCQ
      TOTPHZ=TOTPHZ+PHAZE(NO)
 2929 CONTINUE
C Smoothing of eigenphase sums.
      IF (ICON.EQ.1) THEN
      d=0.D0
      ETA1=TOTPHZ + d
      IF (ETA1.LE.ETAOLD.AND.ABS(ETA1-ETAOLD).GE.HALF) THEN
      d = d + PI
      ETA1=ETA1 + PI
      ELSE IF (ETA1.GT.ETAOLD.AND.ABS(ETA1-ETAOLD).GE.HALF) THEN
      d = d - PI
      ETA1=ETA1 - PI
      END IF
      TOTPHZ=ETA1
      ETAOLD=TOTPHZ
      END IF
      TOTPH(IE)=TOTPHZ      
C
C
C     PRINT OUT CORRECTED PHASES OR EIGENPHASE SUMS
C
      IF(IEUNIT.EQ.2) E=E*EV
      WRITE(IWRITE,2336)IE,E,TOTPHZ,(PHAZE(NO),NO=1,NFORM)
      IF (NFORM.LT.NEPRNT) WRITE(IWRITE,2337) (PHAZE(NO),NO=7,NEPRNT)
      IF(LUPHSI.NE.0.AND.LUPHSO.NE.0) THEN
        READ(LUPHSI,441) ENH,(HOLD(I),I=1,NPOS)
        IF(ABS((E-ENH)/ENH).GT.TOL) THEN
          WRITE(IWRITE,442) IE,E,ENH
          LUPHSO = 0
        ENDIF
      ENDIF
      IF(LUPHSO.NE.0) WRITE(LUPHSO,441)E,(HOLD(I),I=1,NPOS),TOTPHZ
 2336 FORMAT(1X,I4,2X,E12.5,7E16.8)
 2337 FORMAT(35X,5E16.8)
C
 2334 CONTINUE
      GOTO 2405
 2403 IE1=IE
 2400 CONTINUE
 2405 CONTINUE
C
      RETURN
C ZM added # at the beginning the header lines to enable easy plotting
 40   FORMAT('#',A)
 440  FORMAT(' *** Eigenphase file is already full, nothing will be save
     1d ***')
 441  FORMAT(E12.5,10E16.8)
 442  FORMAT(' *** Mismatch in energies, no more eigenphases will be sav
     1ed ***',I5,2E15.6)
      END
      SUBROUTINE ESMOOV(NC,QUAD,QUAD1,PHZ,EN,NUME,NFTA)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     ESMOOV was formerly part of ETABLE and carries out smoothing
C     of eigenphases using second order finite differences
C
C***********************************************************************
C
      DIMENSION QUAD(NC),QUAD1(NC),PHZ(NC,NUME),EN(NUME)
      DATA PI/3.1415926535897932D+00/,ZERO/0.D0/,ONE/1.0D0/
C
C     INITIALIZE ARRAY QUAD1 WITH THE MULTIPLES OF PI WHICH ARE
C     TO BE ADDED TO THE EIGENPHASES AT THE FIRST ENERGY
C
      scale = one
      ieav = 0
      DO 3 I=1,NC
      QUAD1(I)=QUAD(I)
    3 CONTINUE
C
C     CHECK CONTINUITY OF EIGENPHASE PARAMETERS AS A FUNCTION OF
C     SCATTERING ENERGY BY THE USE OF SECOND-ORDER DIVIDED DIFFERENCES
C
      DO 190 NO=1,NC
C
C     INITIATE SMOOTHING ; CONTINUITY OF FIRST THREE ENERGY POINTS
C     IS ASSUMED
C
      Q1=QUAD1(NO)*PI
C
      II=3
      E1=EN(1)
      E2=EN(2)
      E3=EN(3)
      P1=PHZ(NO,1)+Q1
      P2=PHZ(NO,2)+Q1
      P3=PHZ(NO,3)+Q1
      PHZ(NO,1)=P1
      PHZ(NO,2)=P2
      PHZ(NO,3)=P3
C
C     FORM DIVIDED DIFFERENCES
C
      FD1=(P2-P1)/(E2-E1)
      FD2=(P3-P2)/(E3-E2)
      SD2=(FD2-FD1)/(E3-E1)
C
C     BEGIN ITERATION OVER ENERGY POINTS
C
    5 II=II+1
      IF(II .GT. NUME) GO TO 190
      Q1=QUAD1(NO)*PI
      P2=P3
      P3=PHZ(NO,II)+Q1
C
      E1=E2
      E2=E3
      E3=EN(II)
      FD1=FD2
      FD2=(P3-P2)/(E3-E2)
      SD1=SD2
      SD2=(FD2-FD1)/(E3-E1)
      EPS1=SCALE*DABS(SD1)
C
C     CHECK CONTINUITY
C
      IF(DABS(SD2-SD1) .GT. EPS1) GO TO 7
C
C     CONTINUITY CHECKS CORRECTLY
C
    6 PHZ(NO,II)=P3
      GO TO 5
C
C                     **************************
C
C     CORRECTION SEQUENCE :
C
C     (1) ADD QUADRANT CORRECTION OF PI
C
    7 P3=P3+PI
      FD2=(P3-P2)/(E3-E2)
      SD2=(FD2-FD1)/(E3-E1)
      IF(DABS(SD2-SD1) .GT. EPS1) GO TO 9
C
      QUAD1(NO)=QUAD1(NO)+ONE
      GO TO 6
C
C     (2) SUBTRACT QUADRANT CORRECTION OF PI
C
    9 P3=P3-PI-PI
      FD2=(P3-P2)/(E3-E2)
      SD2=(FD2-FD1)/(E3-E1)
      IF(DABS(SD2-SD1) .GT. EPS1) GO TO 11
C
      QUAD1(NO)=QUAD1(NO)-ONE
      GO TO 6
C
C     (3) CHECK WHETHER CHANNELS HAVE BEEN SWAPPED
C
   11 NO1=NO+1
      IF(NO1 .GT. NC) GO TO 20
C
      DO 18 NOX=NO1,NC
      IPT=1
      NOP=NOX
C
      P3=PHZ(NOP,II)+Q1
   12 FD2=(P3-P2)/(E3-E2)
      SD2=(FD2-FD1)/(E3-E1)
C
C     JUMP OUT IF SEARCH SUCCEEDS
C
      IF(DABS(SD2-SD1) .LE. EPS1) GO TO 25
C
      if(ipt.eq.1) then
C
C     TRY ADDING PI
C
        P3=P3+PI
        IPT=2
        GO TO 12
C
C     TRY SUBTRACTING PI
C
      else if(ipt.eq.2) then
        P3=P3-PI-PI
        IPT=3
        GO TO 12
      endif
C
   18 CONTINUE
C
C     SMOOTHING FAILURE
C
   20 WRITE(NFTA,22)NO,II,E3
   22 FORMAT(' CONTINUITY ERROR ENCOUNTERED IN CHANNEL ',I3,
     1       ' EIGENPHASE AT ENERGY E(',I3,') =',D16.8)
      P3=PHZ(NO,II)+Q1
      GO TO 5
C
C     SWAP EIGENPHASE COLUMNS NO AND NOP BEGINNING AT ENERGY POINT II
C
   25 DO 27 IEP=II,NUME
      SAVE=PHZ(NO,IEP)
      PHZ(NO,IEP)=PHZ(NOP,IEP)
      PHZ(NOP,IEP)=SAVE
   27 CONTINUE
C
C     REVERSE QUAD1 VALUES
C
      SAVE=QUAD1(NOP)
      QUAD1(NOP)=QUAD1(NO)
      QUAD1(NO)=SAVE
      if(ipt.eq.2) then
        QUAD1(NO)=QUAD1(NO)+ONE
      else if(ipt.eq.3) then
        QUAD1(NO)=QUAD1(NO)-ONE
      endif
C
      PHZ(NO,II)=P3
C
      WRITE(NFTA,32)NO,NOP,II
   32 FORMAT(' CHANNELS NO =',I3,' AND NOP =',I3,' SWAPPED BEGINNING',
     1       ' AT ENERGY POINT IEN =',I4)
      GO TO 5
C
  190 CONTINUE
      RETURN
      END

      
