! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE BOUND_F(IFAIL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES, EXCEPT
C     VIBINI
C
      PARAMETER (MAXPTS=30,MAXTGT=20,maxgrd=100000)
C
C     MAXPTS = MAXIMUM NUMBER OF GEOMETRIES        
C     MAXTGT = MAXIMUM NUMBER OF TARGET ELECTRONIC STATES
C
      CHARACTER(LEN=80) NAME
      CHARACTER(LEN=11) RFORM,CHFORM,BCFORM,AIFORM,NRFORM,VCFORM,MODDAT
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=1) IRFORM,ICFORM,IPFORM,IAIFORM,INRFRM,IVCFRM
      CHARACTER(LEN=8) BLANK
      CHARACTER(LEN=20) DAYTIM
      INTEGER STOT,GUTOT
      integer, allocatable :: ichl(:),ivchl(:),lvchl(:),mvchl(:),
     * starg(:),mtarg(:),gtarg(:),ivtarg(:),ivnu(:),ichord(:)
      double precision, allocatable :: evchl(:),etmin(:),evib(:),
     * vibfn(:),ut(:),bmat(:),rhold(:),pnorm(:),etarg(:),epole(:),
     * wamp(:),butc(:),bloch(:),amc(:),adc(:),adm(:),cf(:),rvib(:),
     * ampn(:),eign(:),rquad(:),qwts(:),fx(:),fxp(:),bhold(:)
      DIMENSION RK(MAXPTS+4),R(MAXPTS),IPRNT(6),NVTARG(MAXTGT)
     5,NCHSET(MAXPTS),NRMSET(MAXPTS),ivt0(2),ivu0(2),stvec(maxgrd),
     * grid(maxgrd),DUM1(1),DUM2(1,1)
      EXTERNAL POTL,DISPOT
C
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /BOUNDIN/
C     OTHER DATA IS INPUT VIA NAMELISTS IN ROUTINES VIBINI AND ASYM1
C
C      BBLOCH   = Coefficient in electronic Bloch operator
C      BIGB     = Coefficient in nuclear Bloch operaotR
C      DINC     = The change in energy, in Rydbergs, used to calculate
C                 the derivatives of the R and B matrices
C      GUTOT    = G/U symmetry of total system +1=G, -1=U
C      IAIFORM   = Formatted/unformatted switch for unit LUAI
C      IBC      = 1 if bound state coefficients are required
C      ICFORM   = Formatted/unformatted switch for unit LUCHAN
C      IDGRID   = 1 if dense grid only is required
C      INRFRM   = Formatted/unformatted switch for unit LUNRMT
C      IPFORM   = Formatted/unformatted switch for unit LUBND
C      IPRNT    = Debug print switches
C                 (1) =1 Print all input data
C                 (2) =1 Print vibrational wavefuction data
C                 (3) =1 Debug output in dissociating channels
C                 (4)  not used
C                 (5) =1 Print R-matrices
C                 (6) =1 Print all output data
C      IQDT     = 1, if search over quantum defect is required
C                 otherwise a linear search over energies is performed
C      IRAFNOS  = Number of points used for integration of outer region
C                 functions in asymptotic region
C                 needed for normalisation
C      IRFORM   = Formatted/unformatted switch for unit LURMT
C      ISMAX    = Highest multipole to be used in asymptotic expansion
C                 of asymptotic potentials
C      IWRITE   = Logical unit for printed output
C      LUAI     = Logical unit for asymptotic integration information
C      LUBND    = Logical unit for bound state coefficients
C      LUCHAN   = Logical unit holding fixed nuclei channel and target
C                 data
C      LUNRMT   = Logical unit holding non adiabatic R-matrix data
C      LURMT    = Logical unit holding fixed nuclei R-matrix data
C      LUVCHN   = Logical unit holding vibrational/dissociating
C                 channel data
C      MDMAX    = maximum multipole to be retained in expansion of
C                 asymptotic internuclear (dissociation) potential
C      MGVN     = Total symmetry of system
C      NAISET   = Set number for output of asymptotic integral
C                 information
C      NAME     = Title for output
C      NBOT     = Lowest quantum number, N, requited for bound
C                 state search (IQDT=1)
C      NBOUND   = ABS(NBOUND) gives number of states to be searched for
C      NCHSET   = Set numbers for input fixed nuclei channel/target
C                 data for each geometry
C      NDIS     = Number of dissociating channels
C      NGEOM    = Number of geometries
C      NGRID    = Number of divisions of energy grid for dense grid
C      NBCSET   = Set number for output of bound state coefficients
C      NNEWT    = Number of applications of Newton's method to locate
C                 pole
C      NNRSET   = Set number for input non-adiabatic R-matrix data
C      NPOINTS  = Number of points used for integration of outer region
C                 functions in intermediate region
C                 needed for normalisation
C      NPOLE    = Number of electroniv R-matrix poles to be treated
C                 non-adiabatically
C      NRMSET   = Set numbers for input fixed nuclei R-matrix data for
C                 each geometry
C      NRQUAD   = Number of quadrature points for integrals in adiabatic
C                 approximation (if =0 then code decides)
C      NTOP     = Highest quantum number, N, required for bound
C                 state search (IQDT=1)
C      NVCSET   = Set number for input vibrational/dissociating channel
C                 data
C      NVTARG   = Number of vibrational levels for each target state
C      R        = Array holding internuclear sepatations
C      RAFEND   = End point for integration of outer region
C                 functions in asymptotic region
C                 needed for normalisation
C      STOT     = Spin multiplicity 2*S+1 shere S = total wpin of system
C
      NAMELIST/BOUNDIN/LUCHAN,LURMT,LUVCHN,LUNRMT,LUBND,LUAI,NPOLE,NDIS
     1              ,BBLOCH,BIGB,NBOUND,NGEOM,R,IWRITE,ISMAX,NAME
     2              ,IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NBCSET,NRQUAD
     3              ,NAISET,ICFORM,IRFORM,IVCFRM,INRFRM,IPFORM,IAIFORM
     4              ,MGVN,STOT,GUTOT,NVTARG,MDMAX,IBC,NPOINTS,RAFEND
     5              ,IRAFNOS,DINC,NNEWT,NTOP,NBOT,IQDT,NGRID,IDGRID,
     *              newbut
C
C***********************************************************************
C
      DATA IREAD,IWRITE,LUCHAN,LURMT,LUBND,LUAI/5,6,10,21,11,12/
     1,LUVCHN,LUNRMT/28,29/,IPRNT/6*0/
     2,NBOUND/1/,NKNOT/0/,IVPROP/-1/,IDPROP/-1/,NPOLE/0/,NVIB/0/,NDIS/0/
     3,NVCSET,NNRSET,NBCSET,NAISET/4*1/
     4,ISMAX/-1/,BBLOCH,BIGB/2*0.D0/,NVTARG/MAXTGT*1/,NRQUAD/0/,NGEOM/1/
      DATA DINC/2.D-6/,NNEWT/30/,NTOP/10/,NBOT/1/,IQDT/1/,NGRID/20/
     1,IDGRID/0/,IBC/1/,NPOINTS/240/,RAFEND/200.D0/,IRAFNOS/200/
C ZM: added GUTOT/0/
      DATA ZERO/0.D0/,HALF/0.5D0/,ONE/1.D0/,TWO/2.D0/,MDMAX/-1/
     1,EPS2/1.D-8/,newbut/1/,GUTOT/0/
      DATA FORM,CHFORM,RFORM,VCFORM,NRFORM,BCFORM,AIFORM/7*'FORMATTED'/
     1,ICFORM,IRFORM,IVCFRM,INRFRM,IPFORM,IAIFORM/6*'U'/
      DATA BLANK/'        '/
      DATA MODDAT/'12-MAY-1997'/
C
C---- SET UP DEFAULT VALUES OF POINTERS NCHSET AND NRMSET
      DO 111 I=1,MAXPTS
      NCHSET(I) = I
      NRMSET(I) = I
 111  continue
C
      IFAIL = 0
      NEXT = 1
C
C---- Read basic data via namelist /BOUNDIN/
      READ(5,BOUNDIN)
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM
      IF(INRFRM.EQ.'U') NRFORM='UN'//FORM
      IF(IPFORM.EQ.'U') BCFORM='UN'//FORM
      IF(IAIFORM.EQ.'U') AIFORM='UN'//FORM
      IF(IVCFRM.EQ.'U') VCFORM='UN'//FORM
C
      IF(NGEOM.GT.MAXPTS) GO TO 96
      IF(NPOLE.LT.1.AND.NGEOM.GT.1) GOTO 100
C
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,12)MODDAT,NAME,MGVN,STOT,GUTOT
      IF(NGEOM.EQ.1) THEN
        WRITE(IWRITE,20) R(1)
      ELSE
        WRITE(IWRITE,10)NDIS,(R(I),I=1,NGEOM)
        IF(R(NGEOM).EQ.ZERO.OR.NCHSET(NGEOM).EQ.0.OR.NRMSET(NGEOM).EQ.0)
     1   GO TO 89
      ENDIF
      WRITE(IWRITE,11)CHFORM,LUCHAN,(NCHSET(IG),IG=1,NGEOM)
      WRITE(IWRITE,33)RFORM,LURMT,(NRMSET(IG),IG=1,NGEOM)
      IF(NGEOM.GT.1) WRITE(IWRITE,21)VCFORM,LUVCHN,NVCSET,NRFORM,
     1LUNRMT,NNRSET
      WRITE(IWRITE,32)BCFORM,LUBND,NBCSET
      WRITE(IWRITE,31)AIFORM,LUAI,NAISET
C---- Find first fixed-nuclei R-matrix input set and read dimension
C     information
      WRITE(IWRITE,17)
      CALL READRH(LURMT,NRMSET(1),RFORM,MGVN,STOT,GUTOT,NCHANF,NVIB0,
     1NDIS0,NTARG,ION,R(1),RMASS,RMATR,NFBUT,ISMX,nstat,NOCSF,NPLX,
     2ezero,iex,IWRITE,IPRNT(1),IFAIL)
C 
      IF(IFAIL.NE.0) RETURN
      TWOM = TWO*RMASS
C
C---- Read header on non-adiabatic R-matrix file
      IF(NGEOM.GT.1) THEN
        WRITE(IWRITE,19)
        CALL READRH(LUNRMT,NNRSET,NRFORM,MGVN,STOT,GUTOT,NCHANS,NVIB,
     1  NDISS,NTARGv,ION,ZERO,RMASS,RMATN,NNBUT,ISMVX,nstat,NHD,NPVEC,
     2  ezero, iex, IWRITE,IPRNT(1),IFAIL)
        IF(IFAIL.NE.0) RETURN
        IF(NDISS.NE.NDIS.AND.NDIS.GT.0) THEN
          WRITE(IWRITE,23) NDIS,NDISS
          NDIS = NDISS
        ENDIF
        NCHAN = NCHANS
        RR = ZERO
      ELSE
        NVIB = 0
        NDIS = 0
        NCHAN = NCHANF
        ntargv = ntarg
        RR = R(1)
        ISMVX = ISMX
      ENDIF
      IF(ISMAX.EQ.-1.OR.ISMAX.GT.ISMX) THEN
        ISFMAX = ISMX
      ELSE
        ISFMAX = ISMAX
      ENDIF
      WRITE(IWRITE,34) ISFMAX
      IF(NDIS.NE.0) THEN
        IF(MDMAX.EQ.-1.OR.MDMAX.GT.ISMVX) MDMAX=ISMVX
        WRITE(IWRITE,35) MDMAX
      ENDIF
      ISMAX = MAX(ISFMAX,MDMAX)
C
C---- Assign storage for fixed nuclei data
      ntv = max(ntarg,NTARGv)
      ncf = max(NCHAN,nchanf)
      allocate (ichl(nchanf),ivchl(ncf),lvchl(ncf),mvchl(ncf),
     * evchl(ncf),starg(ntv),gtarg(ntv),mtarg(ntv),etarg(ngeom*ntv),
     * butc(3*NCHANF*NGEOM),amc(ISMAX*NCHAN*NCHAN),
     * adc(MDMAX*NDIS*NDIS),adm(5*ndis),cf(ISMAX*ncf*(ncf+1)/2))   
      allocate (epole(nstat*ngeom),wamp(nstat*NCHANF*NGEOM))
C
C---- LOOP OVER GEOMETRIES
      WRITE(IWRITE,17)
      DO 2 IG=1,NGEOM
C
C---- Storage allocation for current geometry
      IG1 = IG-1
      IET = 1+IG1*NTARG
      IEG = 1+IG1*nstat
      IWA = 1+IG1*nstat*NCHANF
      IBUT =1+IG1*3*NCHANF
C
C---- Read target and channel data
      NCHAN0 = NCHANF
      CALL READTC(LUCHAN,NCHSET(IG),NCHAN0,NVIB0,NDIS0,NTARG0,ION,IVT0,
     1 IVU0,ICHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,GTARG,etarg(IET:),R(IG),
     * RMASS,CHFORM,IWRITE,IPRNT(1),IFAIL)
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read R-matrix header for second and subsequent geometries
      IF(IG.GT.1) CALL READRH(LURMT,NRMSET(IG),RFORM,MGVN,STOT,GUTOT,
     1 NCHAN0,NVIB0,NDIS0,NTARG0,ION,R(IG),RMASS,RMATR,NFBUT,ISMX,nstat,
     2 NOCSF,NPLX,ezero,iex,IWRITE,IPRNT(1),IFAIL)
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read remainder of fixed nuclei R-matrix data
      CALL READRM(LURMT,RFORM,NCHANF, nstat, NOCSF,ISMX,ISFMAX,NPLX,0,
     1 NFBUT,cf,epole(IEG:),wamp(IWA:),DUM2,BUTc(ibut:),DUM1,iex,DUM1,
     2 DUM1,IFAIL)



      IF(IFAIL.NE.0) RETURN
C
 2    CONTINUE
c
      Z=ION
      IF (Z.EQ.zero) IQDT=0
C
      IF(NGEOM.EQ.1) THEN
C
C---- Set up fixed nuclei calculation
        e0 = etarg(1)
      if(iet.gt.1) then
      e1 = etarg(2)
      endif
        NVCHAN = NCHAN
c---- dummy allocation
        allocate (ampn(1),eign(1),vibfn(1),rquad(1),qwts(1),ichord(1))
C
      ELSE
        WRITE(IWRITE,22)
        NVCHAN = NCHAN-NDISS
        IF(NDIS.EQ.0) NCHAN = NVCHAN
C
C---- Read vibrational channel data
        NVIBD = NVIB+NDIS
        allocate (ivtarg(nvibd),ivnu(nvibd),etmin(ntargv))
c
        CALL READTC(LUVCHN,NVCSET,NCHAN,NVIB,NDIS,NTARGv,ION,IVTARG,
     1  IVNU,IVCHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,GTARG,ETMIN,ZERO,
     *  RMASS,VCFORM,IWRITE,IPRNT(1),IFAIL)

c
        deallocate (ivtarg,ivnu,etmin)
C
C
C---- Initialize acquisition of vibrational functions
        EBASE = zero
        CALL VIBINI(IREAD,IWRITE,NTARG,NVTARG,RMASS,ebase,IPRNT(2))
        WRITE(IWRITE,47) EBASE
C
C---- Set up quadrature scheme for integrals in adiabatic nuclei approx
        IF(NRQUAD.EQ.0) THEN
C     THIS IS A BIT ARBITRARY AND NOT THOROUGHLY TESTED
          NQUAD = 15*NVIB+1
          IF(MOD(NQUAD,2).EQ.0) NQUAD=NQUAD+1
        ELSE
          NQUAD = NRQUAD
        ENDIF
        allocate (rquad(nquad),qwts(nquad))
C
        CALL VMESH(R(1),R(NGEOM),NQUAD,RQUAD,QWTS)
C
C---- Initialize spline interpolation
        CALL SPLINI(NKNOT,KNOTS,RK,MAXPTS,NGEOM,R,IWRITE)
C
C----- GET TARGET VIBRATIONAL WAVEFUNCTIONS ON QUADRATURE MESH
        allocate (evib(nvibd),ivtarg(nvibd),ivnu(nvibd),ichord(nvchan),
     *  vibfn(NVIB*NQUAD))
C
        CALL RVIBR(NVIB,NQUAD,EVIB,IVTarg,IVnU,VIBFN,dum,RQUAD)
        deallocate (ivtarg,ivnu)
        e0 = evib(1)
C
c---- Set up pointer from VIBINI ordering to channel ordering
        if(ntarg.gt.1) call REORDI(nvchan,evchl,nvib,evib,ichord)
C
        IF(IPRNT(2).GT.0) CALL CHECKQ(NQUAD,NVIB,QWTS,VIBFN,IWRITE)
C
C---- Storage allocation for non-adiabatic data
        allocate (ampn(NHD*NCHANS),eign(nhd))
C
C---- Read rest of non-adiabatic R-matrix file
C     WARNING! THE FIXED NUCLEI AMPLITUDES ARE STORED AS (NCHAN,NRPOLE)
C              BUT THE NON-ADIABATIC AMPLITUDES ARE STORED
C              AS (NRPOLE,NCHAN)
        CALL READRM(LUNRMT,NRFORM,NCHANS,nstat,NHD,ISMVX,ISMAX,0,0,0,
     1  cf,EIGn,AMPn,DUM1,DUM2,DUM1,iex,DUM1,DUM1,IFAIL)
C
      ENDIF
C
C---- Save multipole coefficients as square matrix
      IF(ISMAX.GT.0) THEN
        CALL SQUARM(NVCHAN,ISMAX,cf,AMC)
        IF(NDIS.GT.0.AND.MDMAX.GT.0) THEN
C---- Unpack dissociation potential data.  This code must match
C     DISINI in VIBRMT
          ITEMPD = 1+ISMAX*NVCHAN*(NVCHAN+1)/2
          ND = NDIS*(NDIS+1)/2+6*NDIS
          CALL SPLITM(NDIS,ND2,MDMAX,cf(ITEMPD),ADC,ADM)
        ENDIF
      ENDIF
c
      EL=ZERO
C*****SET UP LIMITS FOR SEARCH
      IF (NGEOM.EQ.1)THEN
        ELOWER=TWO*(ePOLE(1)-E0)-HALF
      ELSE
        ELOWER=EIGn(1)
        DO 58 I=2,NHD
          IF (EIGn(I).LT.ELOWER) ELOWER=EIGn(I)
 58     CONTINUE
        ELOWER=TWO*(ELOWER-E0)-HALF
      ENDIF
      EUPPER=-0.000011
C
C---- Calculate max and min energies EMIN and EMAX
      NMAX = ABS(NBOUND)
      EMAXR = ZERO
      EMINR = ELOWER
      WRITE(IWRITE,13) EMINR,EMAXR
C
      NOPOLE = 0
      NLPOLE = 1
      NUPOLE = NPOLE
      
      NVCHAN = NCHAN-NDIS
C----- INITIALIZE ASYMPTOTIC ROUTINES FOR VIBRATIONAL CHANNELS
      IF(NVCHAN.GT.0) THEN
        RAFINV = RMATR
        SCALE = ONE
        CALL ASYM1(NVCHAN,LVCHL,ION,ISMAX,AMC,RMATR,RAFINV,
     1  SCALE,BBLOCH,EVCHL,EMINR,EMAXR,IVPROP,POTL,IWRITE)
      ENDIF
C
C----- INITIALIZE ASYMPTOTIC ROUTINES FOR DISSOCIATING CHANNELS
      IF(NDIS.GT.0) THEN
        EMINM = TWOM*EMINR
        EMAXM = TWOM*EMAXR
        IF(IVPROP.EQ.0) IDPROP=0
        RAFIND = RMATN
        SCALE = ONE/TWOM
        CALL ASYM1(NDIS,LVCHL(1+NVCHAN),0,MDMAX,ADC,RMATN,RAFIND,
     1  SCALE,BIGB,EVCHL(1+NVCHAN),EMINM,EMAXM,IDPROP,DISPOT,IWRITE)
        IF(IDPROP.NE.IVPROP) GO TO 94
      ELSE
        IDPROP = 0
      ENDIF
C
C----- INITIALIZE OUTPUT OF BOUND STATE COEFFICIENTS
      IF(LUBND.NE.0) CALL WRITBH(LUBND,NBCSET,BCFORM,NAME,MGVN,
     1 STOT,GUTOT,NCHAN,nstat,NBOUND,RR,IPRNT(6),IWRITE,IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C----- INITIALIZE OUTPUT OF ASYMPTOTIC INTEGRATION DATA
      IF(LUAI.NE.0) then
        CALL WRITAIH(LUAI,NAISET,AIFORM,NAME,NBOUND,
     1  NCHAN,NVCHAN,ISMAX,IPRNT(6),IWRITE,IFAIL)
        IF(IFAIL.NE.0) RETURN
        CALL WRITAI1(LUAI,AIFORM,NBOUND,ION,IASY,
     1  IWRON,MAXPTS,EPS,RAFEND,RAFIN,DEGENY,EWRON,RMATR,HX,TOL,
     1  ETHR,ICHL,LCHL,MCHL,CF,IPFLG,NCHAN,NVCHAN,ISMAX,IPRNT,IWRITE)
      endif
C
C---- Store Bloch coefficients
      allocate (bloch(nvchan+ndis))
      DO 4 I=1,NVCHAN
      BLOCH(I) = BBLOCH
 4    continue
      DO 5 I=1,NDIS
      BLOCH(NVCHAN+I) = BIGB
 5    continue
      if(newbut.eq.0) nfbut=-nfbut
C
C---- Storage allocation for energy loop
      NCHSQ= NCHAN*NCHAN
      NVCHSQ = NVCHAN*NVCHAN
      allocate (ut(nchsq),bmat(nchsq),rhold(nchsq),pnorm(nchsq),
     * rvib(nchsq),fx(2*nchsq),fxp(2*nchsq),bhold(nchsq))

C
C-----------------------------------------------------------------------
C
C     ENERGY LOOP
C
      NCOUNT=0
      ICURV=0
C*****SET UP LIMITS FOR SEARCH
      IES=-1
      IF (IQDT.EQ.1)THEN
C*****FIND LOWEST AND HIGHEST VALUE OF N FOR SEARCH
        IISTVEC=0
        VLOWER=Z/SQRT(EL-ELOWER)
c !!!   NLOWER=VLOWER/1
        nlower = nint(vlower)

        IF (NLOWER.LT.1) NLOWER=1
        AMULOW=dble(NLOWER)-VLOWER
        IF (AMULOW.LE.-half) NLOWER=NLOWER+1
        IF (NBOT.GT.NLOWER)THEN
          VLOWER=dble(NBOT)-half
          NLOWER=NBOT
        ENDIF
        VUPPER=Z/SQRT(EL-EUPPER)
c !!!   NUPPER=VUPPER/1
        NUPPER = nint(VUPPER)
        IF (NUPPER.LT.1) NUPPER=1
        AMUUP=dble(NUPPER)-VUPPER
        IF (AMUUP.LE.-half) NUPPER=NUPPER+1
        IF (NTOP.LT.NUPPER)THEN
          VUPPER=dble(NTOP)+half
          NUPPER=NTOP
        ENDIF
        IE1=NLOWER
        IE2=NUPPER
        IF (IE2.LT.IE1) IE2=IE1
        V=VLOWER
        ERHOLD=EL-Z*Z/V**2
        ELHOLD=E0+HALF*ERHOLD
      ELSE
        IDGRID=1
        IE1=1
        IE2=1
        ERHOLD=ELOWER
        ELHOLD=E0+HALF*ERHOLD
      ENDIF
            
C*****LOOP OVER Q.N. N OR JUST ONCE
      lno = 0
      DO 50 IEL=IE1,IE2
      IF (IQDT.EQ.1)THEN
        IF (NGEOM.EQ.1)THEN
          CALL FINDNO(ICHL,LVCHL,IEL,LNO,NCHAN,NVTARG(1))
        ELSE
          CALL FINDNO(IVCHL,LVCHL,IEL,LNO,NCHAN,NVTARG(1))
        ENDIF
      ENDIF
C      IF (IQDT.NE.1)THEN
        IF (IQDT.EQ.1.and.lno.gt.0)THEN
C*****SET UP GRID FOR GIVEN N
          IF (IEL.EQ.IE1)THEN
            V1=VLOWER
          ELSE
            V1=dble(IEL)-half
          ENDIF
          IF (IEL.EQ.IE2)THEN
            V2=VUPPER
          ELSE
            V2=dble(IEL)+half
          ENDIF
          CALL MKGRID(NGRID,IISTVEC,STVEC,IIGRID,GRID
     1               ,LNO,V1,V2,IDGRID,iel,maxgrd)
          IF (IIGRID.GT.maxgrd)THEN
            WRITE(1111)
 1111 FORMAT(' TOO MANY GRID POINTS')
            GOTO 51
          ENDIF
      ELSEIF(lno.eq.0) THEN
        ERHOLD=ELOWER
        ELHOLD=E0+HALF*ERHOLD
      IIGRID=NGRID
        DE=(EUPPER-ELOWER)/dble(NGRID)
        ELSE
        IIGRID=NGRID
        DE=(EUPPER-ELOWER)/dble(NGRID)
        ENDIF
        NNCOUNT=0
C
C*****LOOP OVER GRID POINTS
        DO 40 IE=1,IIGRID
        IF (IQDT.EQ.1.and.lno.gt.0)THEN
          V=GRID(IE)
          ENRYD=EL-Z*Z/V**2
        ELSE
          ENRYD=ELOWER+dble(IE)*DE
        ENDIF
        ETOT  = E0+HALF*ENRYD
C*****FIND NEAREST R-MATRIX POLE
        IF (NGEOM.EQ.1) THEN
          IEST=-1
          DO 52 I=1,nstat
          IF(IEST.EQ.-1 .AND. ePOLE(I).GT.ETOT) THEN
            IEST=I
        ENDIF
 52       CONTINUE
          IF (IEST.GT.1) then
            if((ePOLE(IEST)-ETOT).GT.(ETOT-ePOLE(IEST-1)))IEST=IEST-1
          endif
        ELSE
          DIFF=1000
          DO 53,I=1,NHD
          DIFO=ABS(EIGn(I)-ETOT)
            IF(DIFO.LT.DIFF)THEN
              IEST=I
              DIFF=DIFO
            ENDIF
 53       CONTINUE
        ENDIF
C*****FOR NEW R-MATRIX POLE, RECALCULATE LOWEST REFERENCE ENERGY
      IF (IEST.NE.IES)THEN
        IES=IEST
        IF (NGEOM.EQ.1) THEN
          NLPOLE=IES
          NUPOLE=IES
          EK=ePOLE(IES)
          CALL MKUTG(NCHAN,nstat,IES,WAMP,ut,G2)
        ELSE
          NOPOLE=IES
          EK=EIGn(IES)
          CALL MKUTGN(NCHAN,NHD,IES,AMPn,ut,G2)
        ENDIF
        CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1  ELHOLD,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1  NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1  WAMP,ePOLE,NFBUT,BUTC,IFAIL,ERHOLD,
     1  ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1  RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1  ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1  RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
c
        DLHOLD=BDET(ELHOLD,NCHAN,EK,ut,FX(1+NCHSQ),FXP(1+NCHSQ),G2,
     *              RVIB)
c
      ENDIF
C*****CALCUATE THE DETERMINANT AT THE NEW ENERGY
      CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1 ETOT,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1 NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1 WAMP,ePOLE,NFBUT,BUTC,IFAIL,ENRYD,
     1 ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1 RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1 ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1 RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
      
      DETH=BDET(ETOT,NCHAN,EK,ut,FX(1+NCHSQ),FXP(1+NCHSQ),G2,RVIB)
      IF (IFAIL.NE.0)THEN
        IFAIL=0
        GOTO 50
      ENDIF
      IF(IPRNT(5).GT.0.OR.IPRNT(6).GT.0) WRITE(IWRITE,28) ENRYD
      
      ELOW=ELHOLD
      DETL=DLHOLD
      ELHOLD=ETOT
      DLHOLD=DETH
      ERHOLD=ENRYD
      DETHH=DETH
      EHIGH=ETOT
C ZM the det values are extremely small: there can be underflows so make the sign
C test robust replacing DETH*DETL by their signs here and in the rest
C of the code:
      sgntest = sign(1.0d0,DETH)*sign(1.0d0,DETL)     
      IF (sgntest.LT.zero)THEN
C*****ONE POLE FOUND
        NII=1
      ELSE
C*****CHECK TO SEE IF TWO POLES HAVE BEEN FOUND
        ETOT=(EHIGH+ELOW)*HALF
        ENRYD=TWO*(ETOT-E0)
c      
        CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1  ETOT,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1  NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1  WAMP,ePOLE,NFBUT,BUTC,IFAIL,ENRYD,
     1  ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1  RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1  ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1  RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
c
        DETH=BDET(ETOT,NCHAN,EK,ut,FX(1+NCHSQ),FXP(1+NCHSQ),G2,RVIB)
        EMID=(ETOT-ELOW)*(DETHH-DETL)-(DETH-DETL)*(EHIGH-ELOW)
        IF (EMID.EQ.zero)THEN
          EMID=EHIGH-EPS2-one
        ELSE
          EMID=((ETOT*ETOT-ELOW*ELOW)*(DETHH-DETL)-(DETH-DETL)*
     1         (EHIGH*EHIGH-ELOW*ELOW))/EMID
        ENDIF
        IF ((EHIGH-EMID).GT.EPS2 .AND. (EMID-ELOW).GT.EPS2)THEN
C*****TWO POLES HAVE BEEN FOUND?
          ENRYD=TWO*(EMID-E0)
          CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1    EMID,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1    NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1    WAMP,ePOLE,NFBUT,BUTC,IFAIL,ENRYD,
     1    ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1    RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1    ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1    RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
c
          DETM=BDET(EMID,NCHAN,EK,ut,FX(1+NCHSQ),FXP(1+NCHSQ),G2,RVIB)
          sgntest = sign(1.0d0,DETL)*sign(1.0d0,DETM)
          IF (sgntest.LT.zero)THEN
            ICURV=1
            NII=2
          ELSE
            NII=0
          ENDIF
        ELSE
C*****NO POLES HAVE BEEN FOUND
          NII=0
        ENDIF
      ENDIF
      DO 55 II=1,NII
      IF (ICURV.EQ.1)THEN
C*****TWO POLES - 1ST TIME ROUND
        EHIGH=EMID
        DETHH=DETM
        ICURV=2
          ELSEIF (ICURV.EQ.2)THEN
C*****TWO POLES - 2ND TIME ROUND
            ELOW=EMID
            DETL=DETM
            EHIGH=ELHOLD
            DETHH=DLHOLD
            ICURV=0
          ENDIF
          ETOT=(EHIGH+ELOW)*HALF
C*****NEWTON SEARCH FOR POLE
c
          DO 56 NEWT=1,NNEWT
            ENRYD=TWO*(ETOT-E0)
            CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1      ETOT,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1      NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1      WAMP,ePOLE,NFBUT,BUTC,IFAIL,ENRYD,
     1      ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1      RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1      ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1      RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
c
            DETH=BDET(ETOT,NCHAN,EK,ut,FX(1+NCHSQ),FXP(1+NCHSQ),G2,
     *                RVIB)
            sgntest = sign(1.0d0,DETL)*sign(1.0d0,DETH)
            IF (sgntest.LT.zero)THEN
              DETHH=DETH
              EHIGH=ETOT
            ELSE
              DETL=DETH
              ELOW=ETOT
            ENDIF
c ZM changed the convergence criterion to relative precision of EHIGH vs ELOW. 
c In the original version the criterion first calculated ETOT which could overflow and then attempted to compare the NaN with EHIGH or ELOW which didn't work. This resulted in stalling COULF.
            WIDTH = abs((EHIGH-ELOW)/EHIGH)
            if (WIDTH .LT.0.2) then
               ETOT=(EHIGH+ELOW)*HALF
c               exit
            else
               ETOT=(ELOW*DETHH-EHIGH*DETL)/(DETHH-DETL)
               WIDTH=EHIGH-ELOW
               IF ((EHIGH-ETOT)/WIDTH.LT.0.2 .OR.
     1            (ETOT-ELOW)/WIDTH.LT.0.2) ETOT=(EHIGH+ELOW)*HALF
            endif
 56       CONTINUE
c
C*****CALCULATE THE DERIVATIVES NUMERICALLY
          ENRYD=TWO*(ETOT-E0)-DINC
          ETOT  = E0+HALF*ENRYD
          CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1    ETOT,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1    NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1    WAMP,ePOLE,NFBUT,BUTC,IFAIL,ENRYD,
     1    ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1    RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1    ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1    RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
c
          CALL MAKEB(NCHAN,EK,ETOT,ut,FX(1+NCHSQ),FXP(1+NCHSQ),G2,
     *               bmat,RVIB)
c
          CALL SEBEQV(NCHAN,rhold,RVIB)
          CALL SEBEQV(NCHAN,bhold,bmat)
c
          ENRYD=ENRYD+DINC
          ETOT  = E0+HALF*ENRYD
          CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1    ETOT,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1    NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1    WAMP,ePOLE,NFBUT,BUTC,IFAIL,ENRYD,
     1    ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1    RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1    ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1    RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
c
C*****SOLVE EXACTLY
          CALL MAKEB(NCHAN,EK,ETOT,ut,FX(1+NCHSQ),FXP(1+NCHSQ),G2,
     *               bmat,RVIB)
c
          CALL MKDTD(NCHAN,bhold,bmat,rhold,RVIB,DINC*HALF)
c
c         (rhold resused here)
          CALL BSOLVE (NCHAN,bmat,ETOT,EPS2,bhold,rhold,IWRITE)
c
C*****FOR VALID EIGENENERGIES CALCULATE THE COEFFICIENTS
          IF ((EHIGH-ETOT).LT.-EPS2 .OR. (ETOT-ELOW).LT.-EPS2)THEN
            WRITE(IWRITE,41) ELOW,EHIGH,ETOT
          ELSE
            IF (IQDT.EQ.1)THEN
              VTEMP=Z/SQRT(EL-TWO*(ETOT-E0))
              AMU=dble(IEL)-VTEMP
              WRITE(IWRITE,29) ETOT,VTEMP,AMU
            if(iet.gt.1) then
            WRITE(6,*) 'RELATIVE TO FIRST EXCITED STATE'
              VTEMP2=Z/SQRT(EL-TWO*(ETOT-E1))
              AMU2=dble(IEL)-VTEMP2
            WRITE(IWRITE,29) ETOT,VTEMP2,AMU2
            endif
              IF (NVIB.GT.1) THEN
                WRITE(IWRITE,61)
                DO 60 I=2,NVIB
                  VTEMP1=Z/SQRT(TWO*(EVIB(I)-ETOT))
                  WRITE(IWRITE,62)I,VTEMP1
 60             CONTINUE
              ENDIF
            ELSE
              WRITE(IWRITE,30) ETOT
            ENDIF
c
          IF (IBC.EQ.1)THEN
c
            ENRYD=TWO*(ETOT-E0)
            CALL NORMP(NCHAN,NVCHAN,LVCHL,ION,ISMAX,AMC,
     1      RAFINV,EVCHL,ENRYD,
     1      NPOINTS,RAFEND,IRAFNOS,PNORM,LUAI,AIFORM,IPRNT(6),IWRITE)
c
            CALL CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1      ETOT,AMPn,EIGn,NOPOLE,IPRNT(5),IWRITE,
     1      NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,NGEOM,
     1      WAMP,ePOLE,NFBUT,BUTC,IFAIL,ENRYD,
     1      ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,
     1      RVIB,NQUAD,RQUAD,QWTS,LVCHL,
     1      ION,ISMAX,AMC,RAFINV,IVPROP,NDIS,RMASS,MDMAX,ADC,adm,
     1      RAFIND,EVCHL,IDPROP,IPRNT(3),FX,FXP,BLOCH,NVIB,ICHORD)
            IF (IFAIL.NE.0)THEN
              IFAIL=0
              GOTO 50
            ENDIF
            IF (NGEOM.EQ.1) THEN
              CALL BCOEFF(NCHAN,nstat,FXP(1+NCHSQ),rhold,WAMP,
     1             ePOLE,ETOT,FX(1+NCHSQ),RVIB,
     2             IES,IWRITE,LUBND,BCFORM,VTEMP,PNORM)
            ELSE
              CALL BCOEFN(NCHAN,NHD,FXP(1+NCHSQ),rhold,AMPn,
     1             EIGn,ETOT,FX(1+NCHSQ),RVIB,
     2             IES,IWRITE,LUBND,BCFORM,VTEMP,PNORM)
              ENDIF
            ENDIF
          IF (IDGRID.NE.1)THEN
            IISTVEC=IISTVEC+1
            STVEC(IISTVEC)=VTEMP+one
          ENDIF
          NCOUNT=NCOUNT+1
          NNCOUNT=NNCOUNT+1
          IF (NCOUNT.EQ.NMAX) GOTO 51
        ENDIF
 55     CONTINUE
 40     CONTINUE
        IF (IQDT.EQ.1) THEN
          WRITE(IWRITE,*)'NUMBER OF POLES FOUND FOR N = ',IEL
     1    ,' IS ',NNCOUNT
          WRITE(IWRITE,*)'EXPECTED NUMBER IS ',LNO
        ENDIF
C      ENDIF
 50   CONTINUE
C
 51   IF (NCOUNT.EQ.0) WRITE(IWRITE,*)'NO POLES FOUND'
C
C     END OF ENERGY LOOP
C
C-----------------------------------------------------------------------
C
      IF(IFAIL.EQ.0) WRITE(IWRITE,18)
      CLOSE(UNIT=LUCHAN)
      CLOSE(UNIT=LURMT)
      CLOSE(UNIT=LUBND)
      CLOSE(UNIT=LUAI)
      IF(NGEOM.GT.1) THEN
        CLOSE(UNIT=LUVCHN)
        CLOSE(UNIT=LUNRMT)
      ENDIF
      RETURN
C
 89   WRITE(IWRITE,91) NGEOM,NCHSET(NGEOM),NRMSET(NGEOM),R(NGEOM)
 91   FORMAT(/' ERROR IN GEOMETRY RELATED DATA'/' NGEOM =',I3,'  NCHSET(
     1NGEOM) =',I3,'  NRMSET(NGEOM) =',I3,'  R(NGEOM) =',F6.3)
      GO TO 90
 92   WRITE(IWRITE,93) NCHAN0,NCHAN,NTARG0,NTARG
 93   FORMAT(' INCONSISTENT DATA ON INPUT FILES'/' NCHAN0 =',I5,5X,'NCHA
     1N =',I5,5X,'NTARG0 =',I5,5X,'NTARG =',I5)
      GO TO 90
 94   WRITE(IWRITE,95)IVPROP,IDPROP
 95   FORMAT(/' INCONSISTENT PROPAGATION FLAGS',2I5)
      GO TO 90
 96   WRITE(IWRITE,98) NTARG,NGEOM,MAXTGT,MAXPTS
 98   FORMAT(/' INPUT DATA WILL EXCEED FIXED DIMENSIONS'/' INPUT  ',
     12I5/' MAXIMA ',2I5)
      GO TO 90
 100  WRITE(IWRITE,98) NPOLE,NGEOM
 101  FORMAT(/' CASE OF NPOLE = ',I5,' AND NGEOM = ',I5,' NOT ALLOWED')
 90   IFAIL = 1
      RETURN
C
 10   FORMAT(/' Vibrationally resolved calculation '//' Number of dissoc
     2iating channels',I3//' Input geometries R =',10F10.5,(/21X,10F10.5
     2))
 11   FORMAT(/' Input datasets:',33X,'Unit  Set numbers'/
     1' Target and channel data     LUCHAN (',A11,')',I3,5X,30I3/(35X,30
     2I3))
 12   FORMAT(//' Program BOUND  (last modified ',A,' )'//A//
     1' Symmetry data  MGVN =',I2,' STOT =',I2,' GUTOT =',I2)
 13   FORMAT(/' Bound state coefficients will be calculated from',F8.4,
     1' to ',F8.4,'Ryd ')
 17   FORMAT(/' *** FIXED NUCLEI DATA ***')
 18   FORMAT(/' *** Task successfully completed ***')
 19   FORMAT(/' *** NON-ADIABATIC DATA ***')
 20   FORMAT(/' Fixed nuclei calculation for R =',F6.3)
 21   FORMAT(/' Vibrational channel data    LUVCHN (',A11,')',I3,5X,I3
     1/' Non-adiabatic R-matrix data LUNRMT (',A11,')',I3,5X,I3)
 22   FORMAT(/' *** END OF FIXED NUCLEI DATA *** ')
 23   FORMAT(/' NDIS =',I2,' IS INCOMPATIBLE WITH DATA FROM VIBRMT',2X,
     1'CHANGED TO ',I2)
 27   FORMAT(10A8)
 28   FORMAT(/100('-')//' INCIDENT ENERGY',F10.5,' RYD')
 29   FORMAT(/' ETOT = ',D20.12,' HARTREES, V = ',F14.6,' MU = ',F10.6)
 30   FORMAT(/' ETOT = ',F12.6,' HARTREES')
 31   FORMAT(/' Output datasets:',34X,'Unit  Set number'/
     1' Asymptotic integral information LUAI (',A11,')',I3,5X,I3)
 32   FORMAT(/' Output datasets:',34X,'Unit  Set number'/
     1' Bound state coefficients LUBND (',A11,')',I3,5X,I3)
 33   FORMAT(' Fixed nuclei R-matrix data  LURMT  (',A11,')',I3,5X,30I3/
     1(35X,30I3))
 34   FORMAT(/' Maximum multipole USED in asymptotic scattering potentia
     1ls   ISMAX =',I3)
 35   FORMAT(/' Maximum multipole USED in asymptotic dissociating potent
     1ials MDMAX =',I3)
 41   FORMAT(/' CANNOT SOLVE FOR POLE BETWEEN E = ',F12.6,' AND ',F12.6
     1,' ETOT = ',F12.6,' (Try increasing NNEWT)')
 47   FORMAT(/' Base energy used in nuclear motion code  EBASE =',F11.5,
     1' au')
 61   FORMAT(' EFFECTIVE QUANTUM NUMBERS FROM HIGHER VIBRATIONAL LEVELS
     1ARE')
 62   FORMAT(I10,F20.6)
 667   FORMAT(/'TEST POINT 1 - BOUND')
C
      END
      SUBROUTINE CALCR(R,MAXPTS,NPOLE,NCHAN,NHD,
     1 ETOT,ANAMP,ANEIG,NOPOLE,IPRNT5,IWRITE,NCHANF,NTARG,ETARG,
     1 NLPOLE,NUPOLE,nstat,NGEOM,AWAMP,POLE,NFBUT,BUTC,IFAIL,
     1 ENRYD,ICHL,NVTARG,VIBFN,KNOTS,RK,NVCHAN,RVIB,NQUAD,
     1 RQUAD,QWTS,LVCHL,ION,ISMAX,AMC,RAFINV,
     1 IVPROP,NDIS,RMASS,MDMAX,ADC,adm,RAFIND,EVCHL,
     1 IDPROP,IPRNT3,FX,FXP,BLOCH,NVIB,iCHORD)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C***********************************************************************
C     CALCR SETS UP THE R-MATRIX AND THE OUTER REGION FUNCTIONS
C     IT IS THE SAME AS THE MAIN BODY OF RSOLVE PLUS AN EXTRA
C     CALL STATEMENT TO MAKEQ
C***********************************************************************
C
      DIMENSION R(MAXPTS),RMN(NCHAN*(NCHAN+1)/2),ANAMP(NHD*NCHAN),
     1 ANEIG(NHD),ETARG(NTARG*NGEOM),AWAMP(NCHANF*nstat*NGEOM),
     1 POLE(nstat*NGEOM),BUTC(3*NCHANF*NGEOM),BLOCH(NCHAN),
     1 RES(NGEOM*NCHANF*(NCHANF+1)/2),ICHL(NCHANF),NVTARG(NTARG),
     1 VIBFN(NVIB*NQUAD),RK(MAXPTS),RVIB(NCHAN*NCHAN),
     1 RQUAD(NQUAD),QWTS(NQUAD),LVCHL(NCHAN),AMC(ISMAX*NCHAN*NCHAN),
     1 CRV(2*NCHan*nchan+NVCHAN),FV(2*NVCHan*nvchan),
     * FVP(2*NVCHan*nvchan),adm(5*ndis),
     1 ADC(ISMAX*NDIS*NDIS),CRD(NDIS*(2*NDIS+1)),EVCHL(NCHAN),
     1 FD(2*NDIS*NDIS),FDP(2*NDIS*NDIS),FX(2*NCHan*nchan),
     * FXP(2*NCHan*nchan),iCHORD(NVCHAN),ncsf(ngeom)
      data ncol/10/
      save
c
      NVOPEN = 0
      NDOPEN = 0
      ifail = 0
      nchsq = nchan*nchan
      ncsf(1) = nstat
C
C---- Calculate contribution to R-matrix from non-adiabatic poles
      IF(NPOLE.GT.0) THEN
        CALL VRMAT2(NCHAN,NOPOLE-1,RMN,ETOT,ANAMP,ANEIG,1)
        CALL VRMAT2(NCHAN,NHD,RMN,ETOT,ANAMP,ANEIG,NOPOLE+1)
C
        IF(IPRNT5.NE.0) THEN
          WRITE(IWRITE,24) NPOLE
          CALL MATTPT(NCHAN,RMN,IWRITE)
        ENDIF
      ENDIF

C
C----- CALCULATE CONTRIBUTIONS TO FIXED NUCLEI R-MATRICES FROM HIGHER
C      POLES
      CALL RESIDR(ETOT,NCHANF,NTARG,ETARG,NLPOLE,NUPOLE,nstat,
     1 NGEOM,ncsf,ichl,AWAMP,POLE,NFBUT,BUTC,RES,ezero,sfac,
     2 iex,ecex,rcex,IWRITE,IFAIL)


      IF(IFAIL.NE.0) THEN
        IF(IFAIL.EQ.1) THEN
          WRITE(IWRITE,38) ENRYD
          IFAIL = 0
          GO TO 50
        ELSE
          WRITE(IWRITE,39) ENRYD
          IFAIL = 0
          GO TO 50
        ENDIF
      ENDIF

C
C----- CALCULATE RESIDUAL R-MATRIX IN THE ADIABATIC NUCLEI APPROX. AND
C      ADD IT TO THE VIBRATIONAL R-MATRIX OBTAINED IN VRMAT2.  A SQUARE
C      MATRIX IS OUTPUT FOR INPUT TO ASYMPTOTIC CODE.
C
      IF(NGEOM.GT.1) THEN
        CALL ADNUC(NGEOM,R,NCHANF,ICHL,NTARG,NVTARG,VIBFN,KNOTS,
     1  RK,NVCHAN,RES,RVIB,dum,1,NQUAD,RQUAD,QWTS)

c
c---- Reorder elements to match channel labels
        if(ntarg.gt.1) call REORDV(nvchan,ichord,rvib)
c
C     Add adiabatic component of R-matrix to the non-adiabatic
        K=0
        DO 70 I=1,NVCHAN
        DO 7 J=1,I
        K = K+1
        RMN(K) = RMN(K)+RVIB(K)
 7      continue
 70     continue
        CALL SQUARM(NCHAN,1,RMN,RVIB)
      ELSE
        CALL SQUARM(NCHAN,1,RES,RVIB)
      ENDIF
C
      IF(IPRNT5.GT.0) THEN
        WRITE(IWRITE,14)
        CALL WRECMT(RVIB,NCHAN,NCHAN,NCHAN,NCHAN,NCOL,IWRITE)
      ENDIF
C
C----- GET SOLUTIONS, DERIVATIVES AND GLOBAL R-MATRIX IN VIBRATIONAL
C      CHANNELS AT R=RAFINV
      IF(NVCHAN.GT.0) THEN
        CALL ASYM2(NVCHAN,NVOPEN,LVCHL,ION,ISMAX,AMC,CRV,
     1  RAFINV,EVCHL,ENRYD,FV,FVP,IVPROP,IFAIL)
        if(ifail.gt.1) go to 50
        ifail = 0
      ENDIF


C
C----- GET SOLUTIONS, DERIVATIVES AND GLOBAL R-MATRIX IN DISSOCIATING
C      CHANNELS AT R=RAFIND
      IF(NDIS.GT.0) THEN
        E2M = RMASS*ENRYD
        CALL ASYM2(NDIS,NDOPEN,LVCHL(1+nvchan),ION,MDMAX,ADC,
     1  CRD,RAFIND,EVCHL(1+nvchan),E2M,FD,FDP,IDPROP,IFAIL)
        if(ifail.gt.1) go to 50
        ifail = 0
C
C----- IF NO PROPAGATION MUST USE NUMERICAL INTEGRATION
        IF(IDPROP.EQ.0.AND.RAFIND.GT.R(NGEOM)) CALL ASYMD(E2M,NDIS,
     1  TWOM,R(NGEOM),RAFIND,EVCHL(1+nvchan),FD,FDP,adm,
     2  IWRITE,IPRNT3)
      ENDIF

C
C----- MERGE SOLUTIONS AND DERIVATIVES
      NOPEN = NVOPEN+NDOPEN
      CALL MERGE(NCHAN,NVCHAN,NDIS,NVOPEN,NDOPEN,FX,FXP,
     1 FV,FVP,FD,FDP)
C
C----- PROPAGATE R-MATRICES IF REQUIRED
      IF(IDPROP.GT.0.OR.IVPROP.GT.0)
     1  CALL RPROPX(NCHAN,NVCHAN,NDIS,CRV,CRD,RVIB,IPRNT5,IWRITE)
 
C*****CHANGE PD TO Q
      CALL MAKEQ(NCHAN,FXP(1+nchsq),FX(1+nchsq),BLOCH)
 50   RETURN
c
 14   FORMAT(/' SUPER R-MATRIX')
 24   FORMAT(/' CONTRIBUTION TO ELECTRONIC R-MATRIX FROM FIRST',I3,
     1' POLES')
 38   FORMAT(/' Adiabatic approximation to contribution to vibrational R
     1-matrix from higher poles failed at E =',F7.4,' Ryd'/' If higher e
     2nergies are required, increase NPOLE')
 39   FORMAT(/' Adiabatic approximation to contribution to vibrational R
     1-matrix from lowest poles failed at E =',F7.4,' Ryd'/' If lower en
     2ergies are required, increase NPOLE')
 668   FORMAT(/'TEST POINT 2 - CALCR in Bound')
      END
      SUBROUTINE MKUTG(NCHAN,NRPOLE,K,F,UT,G2)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     MKUTG MAKES THE GAMMA'S, GAMMA**2 AND THE TRANSPOSE OF
C     THE MATRIX U DEFINED IN THE PAPER BY BURKE AND SEATON (1984),
C     EQUATIONS 15 AND 20 TO 22
C     NCHAN      IS THE NUMBER OF CHANNELS
C     K          IS THE NUMBER OF THE R-MATRIX POLE
C     F          IS THE MATRIX OF R-MATRIX AMPLITUDES
C     UT         IS THE TRANSPOSE OF THE MATRIX U
C     G2         IS THE VALUE OF GAMMA**2
C     TEMPV1     IS THE VECTOR OF VALUES OF GAMMA
C***********************************************************************
C
      DIMENSION F(NCHAN,NRPOLE),UT(NCHAN,NCHAN),TEMPV1(NCHAN)
C*****CREATE GAMMA's
      SUM=0.d0
      DO 6 J=1,NCHAN
      SUM=SUM + F(J,K)*F(J,K)
      TEMPV1(J)=SQRT(SUM)
 6    CONTINUE
C*****CREATE GAMMA**2
      G2=TEMPV1(NCHAN)*TEMPV1(NCHAN)
C
C*****CREATE THE TRANSPOSE OF THE MATRIX U IN UT(NCHAN:NCHAN)
      DO 9 J=1,NCHAN-1
      DO 7 I=1,J
      UT(J,I)=F(I,K)*F(J+1,K)/(TEMPV1(J)*TEMPV1(J+1))
 7    continue
      UT(J,J+1)=-TEMPV1(J)/TEMPV1(J+1)
      DO 8 I=J+2,NCHAN
      UT(J,I)=0.d0
 8    continue
 9    CONTINUE
      DO 10 I=1,NCHAN
      UT(NCHAN,I)=F(I,K)/TEMPV1(NCHAN)
 10   continue
      RETURN
      END
      SUBROUTINE MKUTGN(NCHAN,NRPOLE,K,F,UT,G2)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     MKUTG MAKES THE GAMMA'S, GAMMA**2 AND THE TRANSPOSE OF
C     THE MATRIX U DEFINED IN THE PAPER BY BURKE AND SEATON (1984),
C     EQUATIONS 15 AND 20 TO 22 FOR THE NON-ADIABATIC CASE
C     NCHAN      IS THE NUMBER OF CHANNELS
C     K          IS THE NUMBER OF THE R-MATRIX POLE
C     F          IS THE MATRIX OF R-MATRIX AMPLITUDES
C     UT         IS THE TRANSPOSE OF THE MATRIX U
C     G2         IS THE VALUE OF GAMMA**2
C     TEMPV1     IS THE VECTOR OF VALUES OF GAMMA
C***********************************************************************
C
      DIMENSION F(NRPOLE,NCHAN),UT(NCHAN,NCHAN),TEMPV1(NCHAN)
C*****CREATE GAMMA's
      SUM=0.d0
      DO 6,J=1,NCHAN
      SUM=SUM + F(K,J)*F(K,J)
      TEMPV1(J)=SQRT(SUM)
 6    CONTINUE
C*****CREATE GAMMA**2
      G2=TEMPV1(NCHAN)*TEMPV1(NCHAN)
C
C*****CREATE THE TRANSPOSE OF THE MATRIX U IN UT(NCHAN:NCHAN)
      DO 9 J=1,NCHAN-1
      DO 7 I=1,J
      UT(J,I)=F(K,I)*F(K,J+1)/(TEMPV1(J)*TEMPV1(J+1))
 7    continue
      UT(J,J+1)=-TEMPV1(J)/TEMPV1(J+1)
      DO 8 I=J+2,NCHAN
      UT(J,I)=0.d0
 8    continue
 9    CONTINUE
      DO 10 I=1,NCHAN
      UT(NCHAN,I)=F(K,I)/TEMPV1(NCHAN)
 10   continue
      RETURN
      END
      SUBROUTINE MAKEQ(NCHAN,PD,P,BETA)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     MAKEQ MAKES THE MATRIX Q, OF DIMENSION NCHAN, USING THE
C     EQUATION:
C            Q = PD - BETA*P
C     Q IS THEN RETURNED TO THE MATRIX PD
C***********************************************************************
C
      DIMENSION PD(NCHAN,NCHAN),P(NCHAN,NCHAN),BETA(NCHAN)
      DO 2 I=1,NCHAN
      DO 1 J=1,NCHAN
      PD(I,J)=PD(I,J)-BETA(I)*P(I,J)
 1    continue
 2    continue
      RETURN
      END
      FUNCTION BDET(E,NCHAN,EK,UT,P,Q,G2,T)
C
C***********************************************************************
C     THIS FUNCTION FINDS THE MATRIX B, AT ENERGY E, AND THEN FINDS THE
C     DETERMINANT OF B, WITH COMPLETE PIVOTING
C     PINCHED FROM ATOMIC CODE!
C     WARNING DESTROYS B!
C
C     NCHAN      IS THE NUMBER OF CHANNELS
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION UT(NCHAN,NCHAN),P(NCHAN,NCHAN),Q(NCHAN,NCHAN),
     3  B(NCHAN,NCHAN),T(NCHAN,NCHAN)
      data zero/0.d0/,one/1.d0/
c
C*****MAKE THE MATRIX B FOR ENERGY E
c
      CALL MAKEB(NCHAN,EK,E,UT,P,Q,G2,B,T)
c
C*****CALCULATE THE DETERMINANT
      BDET=one
      bsgn = 1.0d0
      bl10 = 0.0d0
      DO 42 M=1,NCHAN-1
      R=zero
      DO 10 I=M,NCHAN
      DO 1 J=M,NCHAN
      S=ABS(B(I,J))
      IF (S.GT.R)THEN
        R=S
        IP=I
        JP=J
      ENDIF
 1    CONTINUE
 10   continue
      IF (IP.NE.M)THEN
        BDET=-BDET
        bsgn=-bsgn
        DO 2 J=M,NCHAN
        S=B(IP,J)
        B(IP,J)=B(M,J)
        B(M,J)=S
 2      continue
      ENDIF
      IF (JP.NE.M)THEN
        BDET=-BDET
        bsgn=-bsgn
        DO 3 I=M,NCHAN
        S=B(I,JP)
        B(I,JP)=B(I,M)
        B(I,M)=S
 3      continue
      ENDIF
      R=B(M,M)
      BDET=BDET*R
      bsgn=bsgn*sign(1.0d0,R)
      bl10 = bl10 + log10(abs(R))
      R=one/R
      DO 4 I=M+1,NCHAN
      S=B(I,M)*R
      DO 41 J=M+1,NCHAN
      B(I,J)=B(I,J)-B(M,J)*S
 41   continue
 4    continue
 42   continue
c
      BDET=BDET*B(NCHAN,NCHAN)
      bsgn=bsgn*sign(1.0d0,B(NCHAN,NCHAN))
      bl10 = bl10 + log10(abs(B(NCHAN,NCHAN)))
      if (bl10 < -10.0d0) bl10 = bl10/4.0d0
      bdet = bsgn*10**(bl10)
      RETURN
      END
      SUBROUTINE MAKEB (NCHAN,EK,E,UT,P,Q,G2,B,T)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     MAKEB CREATES THE MATRIX B USING THE EQUATIONS
C     5.26 - 5.32
C     UT         IS THE TRANSPOSE OF THE MATRIX U
C     P AND Q    ARE SOLUTIONS IN THE OUTER REGION
C     G2         IS A CONSTANT
C     E          IS THE ENERGY
C     EK         IS THE ENERGY OF THE NEAREST POLE
C***********************************************************************
C
      DIMENSION UT(NCHAN,NCHAN),P(NCHAN,NCHAN),Q(NCHAN,NCHAN),
     3 B(NCHAN,NCHAN),D(NCHAN,NCHAN),T(NCHAN,NCHAN)
C
C*****CALCULATE THE MATRIX B USING EQUATIONS 5.25-5.32
C*****D IS A TEMPORARY MATRIX
      CALL MXM (T,NCHAN,Q,NCHAN,D,NCHAN)
      DO 3 I=1,NCHAN
      DO 30 J=1,NCHAN
      D(I,J)=P(I,J)-D(I,J)
 30   continue
 3    continue
c
      CALL MXM (UT,NCHAN,D,NCHAN,B,NCHAN)
C*****CORRECT LAST ROW
      CALL MXM (UT,NCHAN,Q,NCHAN,D,NCHAN)
      DO 5 J=1,NCHAN
      B(NCHAN,J)=(EK-E)*B(NCHAN,J)-G2*D(NCHAN,J)
 5    continue
      RETURN
      END
      SUBROUTINE MXM (A,NRA,B,NCA,C,NCB)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     MXM MULTIPLIES TWO MATRICES, A AND B, OF DIMENSION
C     NCHAN*NCHAN AND STORES THE RESULT IN THE  NCHAN*NCHAN MATRIX, C
C     NCHAN      IS THE DIMENSION OF THE MATRICES
C     A          IS THE FIRST MATRIX IN THE MULTIPLICATION
C     B          IS THE LAST MATRIX IN THE MULTIPLICATION
C     C          IS THE RESUTLING MATRIX
C***********************************************************************
C
      DIMENSION A(NRA,NCA),B(NCA,NCB),C(NRA,NCB)
      DO 10 K=1,NCB
      DO 1 I=1,NRA
      C(I,K)=0.d0
 1    continue
 10   continue
      SUM=0.d0
      DO 22 K=1,NCB
      DO 21 J=1,NCA
      DO 2  I=1,NRA
      C(I,K)=C(I,K)+A(I,J)*B(J,K)
 2    continue
 21   continue
 22   continue
      RETURN
      END
      SUBROUTINE MKDTD(NCHAN,B1,B2,T1,T2,DINC)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C**********************************************************************
C     MKDTD COMPUTES MINUS THE DERIVATIVE OF B AND THE
C     DERIVATIVE OF T FROM TWO VALUES EACH OF B AND D SEPARATED IN
C     ENERGY BY DINC
C     THE NEGATIVE DERIVATIVE OF B IS RETURNED IN B1 LEAVING B2
C     UNALTERED AND DERIVATIVE OF T IS RETURNED IN T1 LEAVING T2
C     UNALTERED
C     NCHAN IS THE DIMENSION OF ALL THE MATRICES
C**********************************************************************
C
      DIMENSION B1(NCHAN,NCHAN),B2(NCHAN,NCHAN),T1(NCHAN,NCHAN),
     1          T2(NCHAN,NCHAN)
C
      DO 1 I=1,NCHAN
      DO 2 J=1,NCHAN
      B1(I,J)=(B1(I,J)-B2(I,J))/DINC
      T1(I,J)=(T2(I,J)-T1(I,J))/DINC
 2    continue
 1    continue
      RETURN
      END
      SUBROUTINE SEBEQV(NCHAN,A,B)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     SEBEQV SETS MATRIX A EQUAL TO MATRIX B
C***********************************************************************
      DIMENSION A(NCHAN*NCHAN),B(NCHAN*NCHAN)
      DO 1 I=1,NCHAN*NCHAN
      A(I)=B(I)
 1    continue
      RETURN
      END
      SUBROUTINE BSOLVE (NCHAN,B,E,DX,D,XVEC,IWRITE)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     BSOLVE TAKES AN INITIAL ESTIMATE OF THE ENERGY OF THE
C     BOUND STATE POLES AND CALCULATES A MORE EXACT EIGENENERGY AND
C     THE CORRESPONDING EIGENVECTOR USING THE METHOD OF SEATON
C
C     BSOLVE FIRST PERFORMS A TRIANGULAR DECOMPOSITION OF B
C     SUCH THAT:
C                  B=LU
C     WITH COMPLETE PIVOTING
C     WHERE L IS LOWER TRIANGULAR WITH 1'S ON THE DIAGONALS AND U IS
C     UPPER TRIANGULAR.  THE MATRICES L AND U ARE WRITTEN IN MATRIX B
C     IR         IS A VECTOR HOLDING THE ROW CHANGES
C     JC         IS A VECTOR HOLDING THE COLUMN CHANGES
C     D          IS MINUS THE DERIVATIVE OF B
C     ALL THESE MATRICES HAVE DIMENSION NCHAN
C     TAKEN FROM ATOMIC CODE (ALMOST)
C
C     BSOLVE THEN SOLVES THE EIGENVALUE PROBLEM
C        (B-XD)XVEC=0
C     USING THE METHOD DESCRIBED IN APPENDIX 3.  10 ITERATIONS ARE
C     PERFORMED.  THE SUBPROUTINE THEN UNPIVOTS THE VECTOR.
C     B          IS THE MATRIX B
C     C          IS THE MATRIX (B**-1 * D)
C     E          IS THE ESTIMATE OF THE ENERGY
C     DX         IS THE ACCURACY OF E TO BE OBTAINED
C     JC         IS A VECTOR HOLDING THE COLUMN CHANGES
C     ALL THESE MATRICES HAVE DIMENSION NCHAN
C***********************************************************************
C
      DIMENSION B(NCHAN,NCHAN),C(NCHAN,NCHAN),D(NCHAN,NCHAN),
     1 IR(NCHAN),JC(NCHAN),XVEC(NCHAN),YVEC(NCHAN)
      data zero,one/0.d0,1.d0/
c
      IF (NCHAN.EQ.1)THEN
        XVEC(1)=one
        C(1,1)=D(1,1)/B(1,1)
      ELSE
C*****B=LU
        DO 1,I=1,NCHAN
        IR(I)=I
        JC(I)=I
 1      continue
        DO 10 M=1,NCHAN
C*****SEARCH FOR THE LARGEST ELEMENT, M=1
        S=zero
        DO 2 I=M,NCHAN
        DO 25 J=M,NCHAN
        T=ABS(B(I,J))
        IF (T.GT.S)THEN
          S=T
          IS=I
          JS=J
        ENDIF
 25   continue
    2 CONTINUE
C*****ROW AND COLUMN INTERCHANGES TO GIVE LARGSET ELEMENT IN B(M,M)
      IF (IS.NE.M)THEN
        II=IR(M)
        IR(M)=IR(IS)
        IR(IS)=II
        DO 3 J=1,NCHAN
        S=B(M,J)
        B(M,J)=B(IS,J)
        B(IS,J)=S
 3      continue
      ENDIF
      IF (JS.NE.M)THEN
        JJ=JC(M)
        JC(M)=JC(JS)
        JC(JS)=JJ
        DO 4 I=1,NCHAN
        S=B(I,M)
        B(I,M)=B(I,JS)
        B(I,JS)=S
 4      continue
      ENDIF
C*****MODIFICATION OF ROWS AND COLUMNS OF THE BOTTOM-RIGHT M*M MATRIX
       IF (M.EQ.1)THEN
         S=one/B(1,1)
         DO 5 I=2,NCHAN
         B(I,1)=B(I,1)*S
 5       continue
       ELSE
         DO 7 J=M,NCHAN
         S=B(M,J)
         DO 6 L=1,M-1
         S=S-B(M,L)*B(L,J)
 6       continue
         B(M,J)=S
 7       continue
         IF (M.NE.NCHAN)THEN
           T=one/B(M,M)
           DO 9 I=M+1,NCHAN
           S=B(I,M)
           DO 8,L=1,M-1
            S=S-B(I,L)*B(L,M)
 8          continue
            B(I,M)=S*T
 9          continue
          ENDIF
        ENDIF
   10   CONTINUE
C*****THIS COMPLETES THE DECOMPOSITION OF B
C*****THE NEXT SECTION COMPUTES C = B**-1 * D
C
C*****PIVOTING OF D
         DO 11 I=1,NCHAN
         DO 110 J=1,NCHAN
         C(I,J)=D(IR(I),JC(J))
 110     continue
 11      continue
C*****COMPUTATION OF C=L**-1 * D
         DO 131 I=2,NCHAN
         DO 13 J=1,NCHAN
         S=C(I,J)
         DO 12 L=1,I-1
         S=S-B(I,L)*C(L,J)
 12      continue
         C(I,J)=S
 13      continue
 131     continue
C*****COMPUTATION OF C=U**-1 * L**-1 * D
         DO 151 I=NCHAN,1,-1
         T=one/B(I,I)
         DO 15 J=1,NCHAN
         S=C(I,J)
         IF (I.NE.NCHAN)THEN
         DO 14 L=I+1,NCHAN
         S=S-B(I,L)*C(L,J)
 14      continue
       ENDIF
       C(I,J)=S*T
 15    continue
 151   continue
C*****END OF SECTION THAT COMPUTES L AND U
C
C*****CREATE XVEC USING EQUATION A3.5
        XVEC(NCHAN)=one
        DO 17 I=NCHAN-1,1,-1
        S=zero
        DO 16 J=I+1,NCHAN
        S=S-B(I,J)*XVEC(J)
 16     continue
        XVEC(I)=S/B(I,I)
 17     continue
      ENDIF
C*****LOOP FOR 30 ITERATIONS
      XO=zero
      X=one
      DO 23 N=1,30
      IF (ABS(X-XO).GT.DX)THEN
        XO=X
C*****CREATE YVEC = C * XVEC
        DO 19 I=1,NCHAN
        S=zero
        DO 18 J=1,NCHAN
        S=S+C(I,J)*XVEC(J)
 18     continue
        YVEC(I)=S
 19     continue
C*****CREATE X USING EQUATION A3.9
        S=zero
        DO 20 I=1,NCHAN
        S=S+XVEC(I)*YVEC(I)
 20     continue
        T=zero
        DO 21 I=1,NCHAN
        T=T+YVEC(I)*YVEC(I)
 21     continue
        X=S/T
C*****CREATE NEW XVEC USING EQUATION A3.7
        DO 22 I=1,NCHAN
        XVEC(I)=X*YVEC(I)
 22     continue
      ENDIF
   23 CONTINUE
      IF ((X-XO).GT.DX)THEN
         WRITE(IWRITE,99) X-XO
 99      FORMAT('NOT CONVERGED IN BSOLVE, DX= ',F12.6)
      ELSE
         E=E+X
      ENDIF
C*****PERFORM REVERSE INTERCHANGING
      IF (NCHAN.NE.1)THEN
        DO 24 J=1,NCHAN
        YVEC(JC(J))=XVEC(J)
 24     continue
        DO 241 J=1,NCHAN
        XVEC(J)=YVEC(J)
 241    continue
      ENDIF
C*****END OF SECTION THAT PERFORMS THE ITERATION OF APPENDIX 3
      RETURN
      END
      SUBROUTINE MKGRID(NESC,ISTVEC,STVEC,IGRID,GRID,LNO,V1,V2
     1,IDGRID,iel,maxgrd)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     MKGRID SETS UP THE GRID FOR A QUANTUM DEFECT SEARCH
C     IT CHECKS TO SEE IF A DENSE GRID IS NEEDED.
C     IF SO, IT PRODUCES AN EVEN GRID OF QUANTUM DEGECT NUMBERS IN THE
C     VECTOR GRID
C     IF NOT, IT PRODUCES A SPARSE GRID USING THE PREVIOUSLY FOUND
C     SOLUTIONS HELD IN THE VECTOR STVEC.  IT CREATES POINTS JUST EITHER
C     SIDE OF PREVIOUS SOLUTIONS AND FILLS IN ANY LARGE GAPS IN BETWEEN
C***********************************************************************
      DIMENSION STVEC(maxgrd),GRID(maxgrd)
c
      BIT=0.02d0
      BIGBIT=0.10d0
      IGRID=1
      IF ((ISTVEC.GE.LNO-1) .AND. LNO.GT.1 .AND. IDGRID.NE.1 .and. 
     1 iel.le.2) THEN
C*****SPARSE GRID
C*****1ST POINT(S)
        HIGH=STVEC(1)-BIT
        IF (HIGH.GT.V1)THEN
          IF ((HIGH-V1).GT.BIGBIT)THEN
            ngrid = nint((high-v1-bigbit)/bigbit)+1
            v = v1
            DO 1 ig=1,ngrid
            v = v+bigbit
            GRID(IGRID)=V
            IGRID=IGRID+1
 1          continue
          ENDIF
          GRID(IGRID)=HIGH
          IGRID=IGRID+1
        ENDIF
C*****POINTS BETWEEN PREVIOUS SOLUTIONS
         IF (ISTVEC.NE.1)THEN
           DO 3 I=1,ISTVEC-1
           VLOW=STVEC(I)+BIT
           HIGH=STVEC(I+1)-BIT
           IF (VLOW.GE.HIGH)THEN
             GRID(IGRID)=0.5d0*(VLOW+HIGH)
             IGRID=IGRID+1
           ELSE
             ngrid = nint((high-vlow)/bigbit)+1
             v = vlow-bigbit
             DO 20 ig=1,ngrid
             v = v+bigbit
             GRID(IGRID)=V
             IGRID=IGRID+1
 20          continue
             GRID(IGRID)=HIGH
             IGRID=IGRID+1
           ENDIF
 3         CONTINUE
         ENDIF
C*****LAST POINT(S)
         VLOW=STVEC(ISTVEC)+BIT
         HIGH=V2
         IF (VLOW.GE.V2)THEN
           GRID(IGRID)=V2
         ELSE
           ngrid = nint((high-vlow)/bigbit)+1
           v = vlow-bigbit
           DO 4 ig=1,ngrid
           v = v+bigbit
           GRID(IGRID)=V
           IGRID=IGRID+1
 4         continue
           GRID(IGRID)=HIGH
         ENDIF
      ELSE
C*****DENSE GRID
        IF (LNO.EQ.0)THEN
          DV=(V2-V1)/dble(NESC)
          ngrid = nesc
        ELSE
          DV=(V2-V1)/dble(NESC*LNO)
          ngrid = nesc*lno
        ENDIF
        v = v1
        igrid = 0
        DO 50 ig=1,ngrid
        v = v+dv
        igrid = igrid+1
C ZM make sure we don't overflow the array bounds!
        if (igrid > maxgrd) then
           print *,'ERROR: increase maxgrd and recompile',igrid,maxgrd
           stop
        endif
        GRID(IGRID)=V
 50     continue
      ENDIF
      ISTVEC=0
c
      RETURN
      END
      SUBROUTINE FINDNO(ICHL,LCHL,IEL,LNO,NCHAN,NVTARG)
C
C***********************************************************************
C     FINDNO FINDS THE EXPECTED NUMBER OF BOUND STATE POLES FOR A GIVEN
C     QUANTUM NUMBER N
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION LCHL(NCHAN),ICHL(NCHAN)
      LNO=0
      DO 1 I=1,NCHAN
         IF (ICHL(I).EQ.1)THEN
            IF (LCHL(I).LE.IEL) LNO=LNO+1
         ENDIF
 1    CONTINUE
      LNO=LNO*NVTARG
      RETURN
      END
      SUBROUTINE BCOEFF(NCHAN,NRPOLE,Q,XVEC,F,VALUE,ETOT
     1,P,R,IES,NFTA,LUBND,BCFORM,VTEMP,PNORM)
C
C***********************************************************************
C
C     BCOEFF COMPUTES THE COEFFICIENTS NEEDED TO CONSTRUCT THE
C     WAVEFUNCTION
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      CHARACTER(LEN=11) BCFORM
      DIMENSION Q(NCHAN,NCHAN),XVEC(NCHAN),F(NCHAN,NRPOLE),
     1VALUE(NRPOLE),COEFF(NRPOLE),
     1P(NCHAN,NCHAN),R(NCHAN,NCHAN),TEMPM(NCHAN,NCHAN)
     1,RD(NCHAN,NCHAN),TEMPM1(NCHAN,NCHAN),TEMPM2(NCHAN,NCHAN)
     1,TEMPM3(NCHAN,NCHAN),TEMPV1(NCHAN),PNORM(NCHAN,NCHAN)
C
      DATA ZERO/0.0D0/,ONE/1.D0/,EPS/1.D-1/,TINY/1.D-13/
c
C*****CHECK THAT THE ENERGY ISN'T TOO CLOSE TO AN R-MATRIX POLE
      DO 12 I=1,NRPOLE
         IF (ABS(VALUE(I)-ETOT).LT.TINY)THEN
            WRITE(NFTA,104)ETOT,I
            RETURN
         ENDIF
 12   CONTINUE
C*****TEMPM BECOMES THE S MATRIX
      DO 10 I=1,NCHAN
      DO 1 J=1,NCHAN
      TEMPM(I,J)=F(I,IES)*F(J,IES)
 1    continue
 10   continue
C*****CREATE THE WHOLE R-MATRIX
      DO 2 I=1,NCHAN
      DO 20 J=1,NCHAN
      R(I,J)=R(I,J)+TEMPM(I,J)/(VALUE(IES)-ETOT)
 20   continue
 2    continue
C*****CHECK THAT THE SOLUTION IS VALID
      CALL MXM(R,NCHAN,Q,NCHAN,TEMPM,NCHAN)
      DO 3 I=1,NCHAN
      DO 30 J=1,NCHAN
      TEMPM(I,J)=P(I,J)-TEMPM(I,J)
 30   continue
 3    continue
C*****SEBFIX: RENORMALISE XVEC
C*****CREATE THE WHOLE RD-MATRIX
      DO 22 I=1,NCHAN
      DO 221 J=1,NCHAN
      SUM=zero
      DO 23 K=1,NRPOLE
      SUM=SUM+F(I,K)*F(J,K)/(VALUE(K)-ETOT)**2
 23   continue
      RD(I,J)=SUM
 221  continue
 22   continue
      CALL MXM(RD,NCHAN,Q,NCHAN,TEMPM1,NCHAN)
      DO 24 I=1,NCHAN
      DO 241 J=1,NCHAN
      TEMPM2(I,J)=Q(J,I)
 241  continue
 24   continue
      CALL MXM(TEMPM2,NCHAN,TEMPM1,NCHAN,TEMPM3,NCHAN)
      DO 25 I=1,NCHAN
      DO 251 J=1,NCHAN
      TEMPM3(I,J)=PNORM(I,J)+TEMPM3(I,J)
 251  continue
 25   continue
      DO 26 I=1,NCHAN
      SUM=zero
      DO 27 J=1,NCHAN
      SUM=SUM+TEMPM3(I,J)*XVEC(J)
 27   continue
      TEMPV1(I)=SUM
 26   continue
      SUM=zero
      DO 28 I=1,NCHAN
      SUM=SUM+TEMPV1(I)*XVEC(I)
 28   continue
      FAC=one/SQRT(ABS(SUM))
      DO 29 I=1,NCHAN
      XVEC(I)=FAC*XVEC(I)
 29   continue
C*****SEBFIX: XVEC CORRECTLY RENORMALISED
      IERROR=0
      DO 5 I=1,NCHAN
      SUM=zero
      DO 4 J=1,NCHAN
      SUM=SUM+TEMPM(I,J)*XVEC(J)
 4    continue
      IF (ABS(SUM).GT.EPS) IERROR=1
 5    CONTINUE
      IF (IERROR.EQ.1) WRITE(NFTA,100)
C*****CALCULATE EXPANSION COEFFICIENTS
      DO 6 K=1,NRPOLE
      COEFF(K) = ZERO
 6    continue
      DO 9 I=1,NCHAN
      SUM = ZERO
      DO 7 J=1,NCHAN
      SUM = SUM+Q(I,J)*XVEC(J)
 7    continue
      DO 8 K=1,NRPOLE
      COEFF(K) = COEFF(K)+F(I,K)*SUM/(VALUE(K)-ETOT)
 8    continue
 9    CONTINUE
      SUM=zero
      DO 31 I=1,NRPOLE
      SUM=SUM+COEFF(I)*COEFF(I)
 31   continue
      WRITE(NFTA,109)SUM
      WRITE(NFTA,101)
      WRITE(NFTA,102)(COEFF(K),K=1,NRPOLE)
      IF (LUBND.GT.0)THEN
         IF (BCFORM.EQ.'FORMATTED')THEN
            WRITE(LUBND,103)ETOT,VTEMP,(COEFF(K),K=1,NRPOLE)
            WRITE(LUBND,103)(XVEC(K),K=1,NCHAN)
         ELSE
            WRITE(LUBND)ETOT,VTEMP,(COEFF(K),K=1,NRPOLE)
            WRITE(LUBND)(XVEC(K),K=1,NCHAN)
         ENDIF
      ENDIF
c
 100  FORMAT('WARNING: NOT A VALID EIGENVECTOR, COEFFICIENTS MAY NOT BE
     1 ACCURATE, TRY INCREASING NNEWT')
 101  FORMAT(/' BOUND STATE COEFFICIENTS')
 102  FORMAT(8D15.6)
 103  FORMAT(10F20.13)
 104  FORMAT(/'Energy ',F12.8,' is too close to R-matrix pole',I3)
 109  FORMAT(/'C**2 is ',F12.8)
C
      RETURN
      END
      SUBROUTINE BCOEFN(NCHAN,NRPOLE,Q,XVEC,F,VALUE,ETOT
     1,P,R,IES,NFTA,LUBND,BCFORM,VTEMP,PNORM)
C
C***********************************************************************
C
C     BCOEFF COMPUTES THE COEFFICIENTS NEEDED TO CONSTRUCT THE
C     WAVEFUNCTION FOR THE NON-ADIABATIC CASE
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      CHARACTER(LEN=11) BCFORM
      DIMENSION Q(NCHAN,NCHAN),XVEC(NCHAN),F(NRPOLE,NCHAN),
     1 VALUE(NRPOLE),COEFF(NRPOLE),
     1 P(NCHAN,NCHAN),R(NCHAN,NCHAN),TEMPM(NCHAN,NCHAN)
     1,RD(NCHAN,NCHAN),TEMPM1(NCHAN,NCHAN),TEMPM2(NCHAN,NCHAN)
     1,TEMPM3(NCHAN,NCHAN),TEMPV1(NCHAN),PNORM(NCHAN,NCHAN)
C
      DATA ZERO/0.0D0/,ONE/1.D0/,EPS/1.D-1/,TINY/1.D-13/
C*****CHECK THAT THE ENERGY ISN'T TOO CLOSE TO AN R-MATRIX POLE
      DO 12 I=1,NRPOLE
         IF (ABS(VALUE(I)-ETOT).LT.TINY)THEN
            WRITE(NFTA,104)ETOT,I
            RETURN
         ENDIF
 12   CONTINUE
C*****TEMPM BECOMES THE S MATRIX
      DO 1 I=1,NCHAN
      DO 10 J=1,NCHAN
      TEMPM(I,J)=F(IES,I)*F(IES,J)
 10   continue
 1    continue
C*****CREATE THE WHOLE R-MATRIX
      DO 2 I=1,NCHAN
      DO 20 J=1,NCHAN
      R(I,J)=R(I,J)+TEMPM(I,J)/(VALUE(IES)-ETOT)
 20   continue
 2    continue
C*****CHECK THAT THE SOLUTION IS VALID
      CALL MXM(R,NCHAN,Q,NCHAN,TEMPM,NCHAN)
      DO 3 I=1,NCHAN
      DO 30 J=1,NCHAN
      TEMPM(I,J)=P(I,J)-TEMPM(I,J)
 30   continue
 3    continue
C*****SEBFIX: RENORMALISE XVEC
C*****CREATE THE WHOLE RD-MATRIX
      DO 22 I=1,NCHAN
      DO 221 J=1,NCHAN
      SUM=zero
      DO 23 K=1,NRPOLE
      SUM=SUM+F(K,I)*F(K,J)/(VALUE(K)-ETOT)**2
 23   continue
      RD(I,J)=SUM
 221  continue
 22   continue
      CALL MXM(RD,NCHAN,Q,NCHAN,TEMPM1,NCHAN)
      DO 24 I=1,NCHAN
      DO 241 J=1,NCHAN
      TEMPM2(I,J)=Q(J,I)
 241  continue
 24   continue
      CALL MXM(TEMPM2,NCHAN,TEMPM1,NCHAN,TEMPM3,NCHAN)
      DO 25 I=1,NCHAN
      DO 251 J=1,NCHAN
      TEMPM3(I,J)=PNORM(I,J)+TEMPM3(I,J)
 251  continue
 25   continue
      DO 26 I=1,NCHAN
      SUM=zero
      DO 27 J=1,NCHAN
      SUM=SUM+TEMPM3(I,J)*XVEC(J)
 27   continue
      TEMPV1(I)=SUM
 26   continue
      SUM=zero
      DO 28 I=1,NCHAN
      SUM=SUM+TEMPV1(I)*XVEC(I)
 28   continue
      FAC=one/SQRT(ABS(SUM))
      DO 29 I=1,NCHAN
      XVEC(I)=FAC*XVEC(I)
 29   continue
C*****SEBFIX: XVEC CORRECTLY RENORMALISED
      IERROR=0
      DO 5 I=1,NCHAN
      SUM=zero
      DO 4 J=1,NCHAN
      SUM=SUM+TEMPM(I,J)*XVEC(J)
 4    continue
      IF (ABS(SUM).GT.EPS) IERROR=1
 5    CONTINUE
      IF (IERROR.EQ.1) WRITE(NFTA,100)
C*****CALCULATE EXPANSION COEFFICIENTS
      DO 6 K=1,NRPOLE
      COEFF(K) = ZERO
 6    continue
      DO 9 I=1,NCHAN
      SUM = ZERO
      DO 7 J=1,NCHAN
      SUM = SUM+Q(I,J)*XVEC(J)
 7    continue
      DO 8 K=1,NRPOLE
      COEFF(K) = COEFF(K)+F(K,I)*SUM/(VALUE(K)-ETOT)
 8    continue
 9    CONTINUE
      SUM=zero
      DO 31 I=1,NRPOLE
      SUM=SUM+COEFF(I)*COEFF(I)
 31   continue
      WRITE(NFTA,109)SUM
      WRITE(NFTA,101)
      WRITE(NFTA,102)(COEFF(K),K=1,NRPOLE)
      IF (LUBND.GT.0)THEN
         IF (BCFORM.EQ.'FORMATTED')THEN
            WRITE(LUBND,103)ETOT,VTEMP,(COEFF(K),K=1,NRPOLE)
            WRITE(LUBND,103)(XVEC(K),K=1,NCHAN)
         ELSE
            WRITE(LUBND)ETOT,VTEMP,(COEFF(K),K=1,NRPOLE)
            WRITE(LUBND)(XVEC(K),K=1,NCHAN)
         ENDIF
      ENDIF
 100  FORMAT('WARNING: NOT A VALID EIGENVECTOR, COEFFICIENTS MAY NOT BE
     1 ACCURATE, TRY INCREASING NNEWT')
 101  FORMAT(/' BOUND STATE COEFFICIENTS')
 102  FORMAT(8D15.6)
 103  FORMAT(10F20.13)
 104  FORMAT(/'Energy ',F12.8,' is too close to R-matrix pole',I3)
 109  FORMAT(/'C**2 is ',F12.8)
C
      RETURN
      END
      SUBROUTINE NORMP(NCHAN,NVCHAN,LCHL,ION,ISMAX,CF,RAFIN,
     1 ETHR,E,NPOINTS,RAFEND,IRAFNOS,PNORM,LUAI,KFORM,IPRNT,
     * IWRITE)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C***********************************************************************
C     NORMP FINDS THE NORMALISATION FACTOR FOR THE OUTER REGION
C     FUNCTIONS
C***********************************************************************
C
      character(len=11) kform
      DIMENSION LCHL(NCHAN),ETHR(NCHAN),CF(NCHAN,NCHAN,ISMAX),
     1 FX(2*NVCHAN*NVCHAN),FXP(2*NVCHAN*NVCHAN),PNORM(NCHAN,NCHAN),
     1 y(nchan),dy(nchan)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      double precision, allocatable :: pold(:)
      double precision, pointer :: cfnag(:),ennag(:),elnag(:),peigen,
     * pampa
      COMMON/ASYMS/DEGENY,EPS,EWRON,NLEG,IASY,IWRITE0,IPFLG(10),IWRON,
     1 RMATR,HX,TOL,MAXPTS,neigen,nampx,nrange,peigen,pampa,igail
      DATA ZERO/0.D0/,ICOL/6/
C
      IF (NCHAN.NE.NVCHAN) WRITE(IWRITE,92)
c
C*****WRITE DATA FOR INTEGRATION IN OUTER REGION NEEDED IN TRANSITION
C     DIPOLE CODE
c
c *** error : amps1 undefined and not clear what it should be
c     ZM: according to the TDIP code the values in the AMPS1 array are used only
c         to decide which asymptotic method to use (the value IGAIL in GAILIT) when performing 
c         the radial integral in the outer region for a pair of wavefunctions.
c         The values dimension of the E,AMPS1 arrays is NBOUND, i.e. the number of bound states found.
c         However, the pairs of these values are written into LUAI one-by-one, hence AMPS1 should be
c         a single number. We can safely set it to 0.0d0 here.
      AMPS1 = 0.0D0
      IF (LUAI.NE.0) CALL WRITAI2(LUAI,KFORM,E,AMPS1,IPRNT,IWRITE)
C
      NCHSQ = NCHAN*NCHAN
      allocate (ennag(nchan),elnag(nchan),pold(nchan*nchan))
C
C---  CALCULATE CHANNEL ENERGIES
      NOPEN = 0
      ZZNAG = 2*ION
      LAMAX = ISMAX
      DO 31 I=1,NCHAN
      I1=I-1
      ENNAG(I) = E-ETHR(I)
      ELNAG(I) = LCHL(I)*(LCHL(I)+1)
      IF(ENNAG(I) .GT. ZERO) NOPEN=NOPEN+1
   31 CONTINUE
      NSOL = 2-(NCHAN-NOPEN)/NCHAN
C
C*****CALCULATE THE INTEGRAL IN THE ASYMPTOTIC REGION
      RAFDIF=(RAFEND-RAFIN)/FLOAT(IRAFNOS)
      RAFSB=RAFEND
      DO 302 I=1,NCHAN
      DO 301 J=1,NCHAN
      PNORM(I,J)=ZERO
 301  continue
 302  continue
      DO 300 I=1,IRAFNOS+1
C
        IRAD = 0
        IFAIL= 0
        CALL GAILIT(ENNAG,LCHL,NCHAN,ION,CF,LAMAX,RAFSB,IWRITE,
     1  IRAD,IASY,IGAIL,DEGENY,EPS,IPFLG,FX,FXP,dum,idum,idum,IFAIL)
        IF (IFAIL.GT.1) THEN
           WRITE(IWRITE,666)
 666       FORMAT('ERROR IN GAILIT')
        ENDIF
C
C       CHECK WRONSKIAN
C
        IF(IWRON.NE.0) CALL WRONSK(NCHAN,NOPEN,FX,FXP,IWRITE,IPFLG(10),
     1  EWRON)
        CALL SQANDAD(I,FX,NCHAN,NOPEN,PNORM,RAFDIF,pold)
        RAFSB=RAFSB-RAFDIF
 300  CONTINUE
C
      IF(IPFLG(9).NE.0) THEN
C
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 14 K=1,NSOL
         WRITE(IWRITE,17) RAFIN
 17      FORMAT(/' ASYMPTOTIC INTEGRATION: SOLUTIONS AT RAFIN=',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FX(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 14      CONTINUE
         DO 15 K=1,NSOL
         WRITE(IWRITE,18)RAFIN
 18      FORMAT(/' ASYMPTOTIC INTEGRATION: DERIVATIVES AT RAFIN',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FXP(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 15      CONTINUE
      ENDIF
C
C*****CALCULATE THE INTEGRAL IN THE PROPAGATION REGION
C     FUNCTION PROPAGATION
C
      RAFSB=RAFSB+RAFDIF

* if rafsf-rmatr is eq 0, then no propagation inwards required
      qzero=1.d-8
      if (rafsb-rmatr.gt.qzero) then

        RAFDIF=(RAFSB-RMATR)/FLOAT(NPOINTS)
        RAFINN=RAFSB-RAFDIF

        CALL SQANDAD(1,FX,NCHAN,NOPEN,PNORM,RAFDIF,pold)
C
        DO 303 I=2,NPOINTS+1
        CALL INTIN(RAFINN,RAFSB,FX,FXP,NCHAN,NOPEN,Y,DY,
     1  HX,MAXPTS,TOL,IPFLG(10),IWRITE)
        CALL SQANDAD(I,FX,NCHAN,NOPEN,PNORM,RAFDIF,pold)
        RAFSB=RAFINN
        RAFINN=RAFINN-RAFDIF
 303    CONTINUE
C
      endif

      IF(IPFLG(9).NE.0) THEN
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 24 K=1,NSOL
         WRITE(IWRITE,27) RMATR
 27      FORMAT(/' PROPAGATION INTEGRATION: SOLUTIONS AT RMATR =',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FX(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 24      CONTINUE
         DO 25 K=1,NSOL
         WRITE(IWRITE,28)RMATR
 28      FORMAT(/' PROPAGATION INTEGRATION: DERIVATIVES AT RMATR',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FXP(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 25      CONTINUE
      ENDIF
      deallocate (pold)
C
      RETURN
 90   WRITE(IWRITE,91) NEIGEN,NAMPX,NLEG,NRANGE,NCHAN
 91   FORMAT(' INCONSISTENT DATA IN NORMP',5I8)
 92   FORMAT(' *** WARNING: NCHAN.NE.NVCHAN, CASE NO PROPERLY COVERED')
      STOP
      END
      SUBROUTINE SQANDAD(IFIRST,FX,NCHAN,NOPEN,PNORM,RAFDIF,psqold)
C
C***********************************************************************
C     SQANDAD MERGES THE OPEN AND CLOSED OUTER REGION FUNCTION, SQUARES
C     THE OUTER REGION FUNCTION MATRIX AND ADDS THIS ELEMENT TO THE
C     INTEGRAL NEEDED TO NORMALISE THE OUTER REGION FUNCTIONS
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DATA ZERO/0.D0/,TWO/2.D0/
      DIMENSION FX(NCHAN,NCHAN,2),PMAT(NCHAN,NCHAN),PNORM(NCHAN,NCHAN)
     1,PSQOLD(NCHAN,NCHAN),PSQNEW(NCHAN,NCHAN)
c
C*****MERGE OPEN AND CLOSED CHANNEL SOLUTIONS
      DO 11 J=1,NOPEN
      DO 110 I=1,NCHAN
      PMAT(I,J) = FX(I,J,2)
 110  continue
 11   continue
      DO 12 J=1,NCHAN-NOPEN
      DO 120 I=1,NCHAN
      PMAT(I,J+NOPEN) = FX(I,J+NOPEN,1)
 120  continue
 12   continue
c
C*****COMPUTE THE MATRIX P**2
      DO 1 I=1,NCHAN
      DO 10 J=1,NCHAN
      SUM=ZERO
      DO 2 K=1,NCHAN
      SUM=SUM+PMAT(K,I)*PMAT(K,J)
 2    continue
      PSQNEW(I,J)=SUM
 10   continue
 1    continue
c
C*****ADD ELEMENT TO THE NORMALISATION MATRIX
      IF (IFIRST.NE.1) THEN
        DO 3  I=1,NCHAN
        DO 30 J=1,NCHAN
        PNORM(I,J)=PNORM(I,J) + (PSQNEW(I,J)+PSQOLD(I,J))*RAFDIF/TWO
 30     continue
 3      continue
      ENDIF
C*****PREPARE FOR NEXT ELEMENT OF INTEGRATION
      CALL SEBEQV(NCHAN,PSQOLD,PSQNEW)
      RETURN
      END
