! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      subroutine QB_interface(ifail)
C
C     Interface to QB resonance fitting code
C
      IMPLICIT double precision(A-H,O-Z)
      INTEGER STOT,GUTOT,iprnt(6)
      double precision, allocatable :: wmatp(:,:),echl(:),cf(:,:),
     * buttl(:,:),etarg(:),eig(:),vec(:),asp(:,:,:)
      integer, allocatable :: LCHL(:),mchl(:),ichl(:),mtarg(:),starg(:),
     * gutarg(:),nconat(:),ivtarg(:),iv(:)
      character(LEN=1) icform,irform
      character(LEN=6) hfile,qbfile
      character(LEN=11) form,chform,rform
      double precision, parameter  :: sqr2 = sqrt(2.0d0), two = 2.0d0 
c
      namelist /qbint/luchan,lurmt,luh,nchset,nrmset,iprnt,iwrite,
     * icform,irform,luQB,ipert,irad,ac,rone,rr,iopt,xmin,xmax,bdx,
     * nelt,ismax
c
      data zero/0.d0/,luchan,lurmt,luh/10,21,9/,iprnt/6*0/,iwrite/6/,
     * nchset,nrmset/1,1/,luqb/27/,ipert/0/,irad/0/,AC/0.000001d0/,
     * rone,rr/1.d0,0.d0/,iopt/1/,xmin,xmax,bdx/0.d0,10.d0,0.005d0/,
     * nelt/0/,ismax/0/
      data hfile,qbfile/'H.DAT ','QB.INP'/
      DATA FORM,CHFORM,RFORM/3*'FORMATTED'/,ICFORM,IRFORM/2*'U'/

      write (iwrite,101)
c
c --- Read input data via namelist
c
      read(5,qbint)
      if(ipert.ne.0) then
        write(iwrite,90) 
        ipert = 0
        ismax = 0
      endif
      ism = ismax
c
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM

c
C ---- Read R-matrix header first to get dimension information
c
 
      call READRH(LURMT,NRMSET,RFORM,MGVN,STOT,GUTOT,NCHAN,NVIB,
     1 NDIS,NTARG,ION,RR,RMASS,RMATR,IBUT,ISMAX,nstat,NOCSF,NPOLE,
     2 ezero, iex, IWRITE, IPRNT(2),IFAIL)        
c
c --- Allocate arrays
c
      allocate (lchl(nchan),mchl(nchan),ichl(nchan),echl(nchan),
     * cf(nchan*(nchan+1)/2,ismax),buttl(3,nchan))
      allocate (mtarg(ntarg),starg(ntarg),gutarg(ntarg),etarg(ntarg),
     * nconat(ntarg))
      allocate (eig(nocsf),vec(nocsf*npole),wmatp(nchan,nocsf))
      nvd = nvib+ndis
      if(nvd.gt.0) allocate (ivtarg(nvd),iv(nvd))
c
c --- Read target and channel data
c      
      call READTC(LUCHAN,NCHSET,NCHAN,NVIB,NDIS,NTARG,ION,IVTARG,
     1IV,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GUTARG,ETARG,R,RMASS,CHFORM,
     2IWRITE,IPRNT(1),IFAIL)
                  
c
c --- Read R-matrix file
c     
      call READRM(LURMT,RFORM,NCHAN,nstat, NOCSF,ISMaX,ism,NPOLE,0,
     1 IBUT,CF,EIG,wmatp,VEC,buttl,sfac,iex,ecex,rcex,IFAIL)    
     
C
c --- Calculate other data needed by QB
c
      DO I=1,NTARG
        NCONAT(I)=0
        DO J=1,NCHAN
          IF(ICHL(J).EQ.I) NCONAT(I)=NCONAT(I)+1
        END DO
      END DO
 
c      
      bsto = zero
      if(nelt.eq.0) then
        nz=1
        nelt = nz-ion
      else
        nz = nelt+ion
      endif
      more2 = 0
c
c --- Write H-file
c
      
      open(unit=luh,file='hfile',form='unformatted',status='new')
      open(unit=900,file='hfile_f_detail',form='formatted',status='new')
      open(unit=901,file='hfile_formated',form='formatted',status='new')
      
      WRITE(900,*)"NELT = number of electrons (scattering?)" 
      WRITE(900,*)"NZ = "
      WRITE(900,*)"NCHAN = number of scattering channels"
      WRITE(900,*)"ISMAX = maximum multipole in expansion"
      WRITE(900,*)"        of asymptotic potential"
      WRITE(900,*)"NTARG = number of target electronic configurations"
      WRITE(900,*)"Rmatr = R-Matrix boundary radius"
      WRITE(900,*)"BSTO = "      
      WRITE(900,*)"DATA FORMAT: NELT,NZ,NCHAN,ISMAX,NTARG,Rmatr,BSTO"  
      WRITE(900,*)"------------------------------------------------"     
      WRITE(900,*)NELT,NZ,NCHAN,ISMAX,NTARG,Rmatr,BSTO   
      WRITE(901,*)NELT,NZ,NCHAN,ISMAX,NTARG,Rmatr,BSTO   
      WRITE(luh)NELT,NZ,NCHAN,ISMAX,NTARG,Rmatr,BSTO    
      WRITE(900,*)"------------------------------------------------" 
      
      
      WRITE(900,*)"Target Energies for each target state"             
      WRITE(900,*)"DATA FORMAT: (ETARG(I),I=1,NTARG)"
      WRITE(900,*)"------------------------------------------------" 
      WRITE(900,*)(ETARG(I),I=1,NTARG)
      WRITE(901,*)(ETARG(I),I=1,NTARG)
      WRITE(luh)(ETARG(I),I=1,NTARG)
      WRITE(900,*)"------------------------------------------------" 
      
      WRITE(900,*)"Symmerty for each target state"               
      WRITE(900,*)"DATA FORMAT: (MTARG(I),I=1,NTARG)"
      WRITE(900,*)"------------------------------------------------"
      WRITE(900,*)(MTARG(I),I=1,NTARG)
      WRITE(901,*)(MTARG(I),I=1,NTARG)
      WRITE(luh)(MTARG(I),I=1,NTARG)
      WRITE(900,*)"------------------------------------------------" 
        
      WRITE(900,*) "Angular Momentum for each target state"          
      WRITE(900,*)"DATA FORMAT: (STARG(I),I=1,NTARG)"
      WRITE(900,*)"------------------------------------------------"  
      WRITE(900,*)(STARG(I),I=1,NTARG)
      WRITE(901,*)(STARG(I),I=1,NTARG)
      WRITE(luh)(STARG(I),I=1,NTARG)
      WRITE(900,*)"------------------------------------------------" 

      WRITE(900,*) "Explaination/Definition"                 
      WRITE(900,*)"DATA FORMAT: ((BUTTL(I,J),I=1,3),J=1,NCHAN)"
      WRITE(900,*)"------------------------------------------------"
      WRITE(900,*)((BUTTL(I,J),I=1,3),J=1,NCHAN)
      WRITE(901,*)((BUTTL(I,J),I=1,3),J=1,NCHAN)
      WRITE(luh)((BUTTL(I,J),I=1,3),J=1,NCHAN)
      WRITE(900,*)"------------------------------------------------" 
     
      WRITE(900,*) "MGVN = Overall M symmetry of the system"
      WRITE(900,*) "STOT = Spin Multiplicity"
      WRITE(900,*) "GUTOT = g/u symmetry"
      WRITE(900,*) "NCHAN = total number of scattering channels"
      WRITE(900,*) "NOCSF = dimension of Hamiltonian matrix"
      WRITE(900,*) "MORE2 = "             
      WRITE(900,*)"DATA FORMAT: MGVN,STOT,GUTOT,NCHAN,NOCSF,MORE2"
      WRITE(900,*)"------------------------------------------------" 
      WRITE(900,*)MGVN,STOT,GUTOT,NCHAN,NOCSF,MORE2
      WRITE(901,*)MGVN,STOT,GUTOT,NCHAN,NOCSF,MORE2
      WRITE(luh)MGVN,STOT,GUTOT,NCHAN,NOCSF,MORE2
      WRITE(900,*)"------------------------------------------------" 
      
      WRITE(900,*) "Explaination/Definition"
      WRITE(900,*)"DATA FORMAT: (NCONAT(I),I=1,NTARG)"
      WRITE(900,*)"------------------------------------------------"               
      WRITE(900,*)(NCONAT(I),I=1,NTARG)
      WRITE(901,*)(NCONAT(I),I=1,NTARG)
      WRITE(luh)(NCONAT(I),I=1,NTARG)
      WRITE(900,*)"------------------------------------------------" 
      
      WRITE(900,*) "Explaination/Definition"          
      WRITE(900,*)"DATA FORMAT: (LCHL(I),I=1,NCHAN)"
      WRITE(900,*)"------------------------------------------------" 
      WRITE(900,*)(LCHL(I),I=1,NCHAN)
      WRITE(901,*)(LCHL(I),I=1,NCHAN)
      WRITE(luh)(LCHL(I),I=1,NCHAN) 
      WRITE(900,*)"------------------------------------------------" 

c
c *** The current version of the QB code does not read this
      if(ipert.ne.0) then
        allocate (asp(nchan,nchan,ismax))
        DO L=1,ISMAX
          k = 0
          DO i=1,nchan
            DO j=1,i
              k = k + 1
              asp(I,J,l) = cf(k,l)
              asp(j,i,l) = cf(k,l)
            END DO
          END DO
        END DO
        WRITE(luh) (((asp(I,J,L),I=1,NCHAN),J=1,NCHAN),L=1,ismax) 
        deallocate(asp)
      endif
c

      WRITE(900,*) "Explaination/Definition"
      WRITE(900,*)"DATA FORMAT: (EIG(I),I=1,NOCSF)"
      WRITE(900,*)"------------------------------------------------"    
      WRITE(900,*)(EIG(I),I=1,NOCSF)
      WRITE(901,*)(EIG(I),I=1,NOCSF)
      WRITE(luh)(EIG(I),I=1,NOCSF)
      WRITE(900,*)"------------------------------------------------" 
           
      WRITE(900,*) "Explaination/Definition"
      WRITE(900,*)"DATA FORMAT: ((WMATP(I,J),I=1,NCHAN),J=1,NOCSF)"
      WRITE(900,*)"------------------------------------------------" 
      WRITE(900,*)((WMATP(I,J) * sqr2, I=1,NCHAN),J=1,NOCSF)
      WRITE(901,*)((WMATP(I,J) * sqr2, I=1,NCHAN),J=1,NOCSF)
      WRITE(luh)((WMATP(I,J) * sqr2, I=1,NCHAN),J=1,NOCSF)
      WRITE(900,*)"------------------------------------------------" 
c
      deallocate (lchl,mchl,ichl,echl,cf,buttl)
      deallocate (mtarg,starg,gutarg,etarg,nconat)
      deallocate (eig,vec,wmatp)
      if(nvd.gt.0) deallocate (ivtarg,iv)
c
C --- set up input data for QB code on file QB.INP
C
      IPRINT = iprnt(3)
C
      open(unit=luqb,file='qbfile',form='formatted',status='new')
c
      WRITE(luqb,*)IPRINT,IRAD,IPERT
      WRITE(luqb,*)AC
      WRITE(luqb,*)RONE
      WRITE(luqb,*)IOPT
      WRITE(luqb,*)stot,mgvn,gutot
      WRITE(luqb,*)XMIN,XMAX,BDX
c
      write(iwrite,100)
c
      return
c
 90   format(//' !!! IPERT not implemented in current QB code ') 
 100  FORMAT(//' *** Task has been successfully completed ***'//)
 101  format(//' *** Interfacing to QB resonance fitting code ***')
C
      END 
