! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE READSH(LUSCT0,NSSET,NCHAN,MGVN,STOT,GUTOT,NSTAT,
     1NSCAT,NESC,RR,ICHL,LVCHL,MVCHL,EVCHL,SFORM0,IPRNT0,IWRIT0,IFAIL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     READSH locates and reads bound state set NSSET on unit LUSCT
C
C***********************************************************************
C
      INTEGER STOT,GUTOT
      CHARACTER(LEN=11) SFORM,SFORM0
      CHARACTER(LEN=80) TITLE
      DIMENSION AR(NSTAT,nchan,nesc), AI(NSTAT,nchan,nesc)
      DIMENSION escat(nesc),ICHL(nchan)
      DIMENSION LVCHL(nchan),MVCHL(nchan),EVCHL(nchan)
      DATA KEYSC/80/
      SAVE
C
      SFORM = SFORM0
      LUSCT = LUSCT0
      IPRNT = IPRNT0
      IWRITE= IWRIT0
C
C---- Locate set number NTSET on unit LUSCT
      NSET = NSSET
      CALL GETSET(LUSCT,NSET,KEYSC,SFORM,IFAIL)
      IF(IFAIL.NE.0) GO TO 99
C
C---- Read header
      IF(SFORM.EQ.'FORMATTED') THEN
        READ(LUSCT,10)  KEYSC,NSET,NREC,NINFO,NDATA
        READ(LUSCT,13) TITLE
        READ(LUSCT,10) NSCAT,MGVN,STOT,GUTOT,NSTAT,NCHAN,NESC
        READ(LUSCT,11) RR
      ELSE
        READ(LUSCT) KEYSC,NSET,NREC,NINFO,NDATA
        READ(LUSCT) TITLE
        READ(LUSCT) NSCAT,MGVN,STOT,GUTOT,NSTAT,NCHAN,NESC
        READ(LUSCT) RR
        read(LUSCT) ICHL,LVCHL,MVCHL,EVCHL
      ENDIF
C
C---- Print header information
      IF(IPRNT.NE.0)  THEN
        WRITE(IWRITE,14)
        WRITE(IWRITE,100) KEYSC,NSET
        WRITE(IWRITE,130) TITLE
        WRITE(IWRITE,100) NSCAT,MGVN,STOT,GUTOT,NSTAT,NCHAN,NESC
        WRITE(IWRITE,110) RR
        do i=1,nchan
          WRITE(IWRITE,140) ICHL(i),LVCHL(i),MVCHL(i),EVCHL(i)
        end do
      ENDIF
C
      RETURN
C
      ENTRY READSC(NSTAT,ESCAT,NSCAT,NCHAN,NESC,AR,AI)
C

      !DO 146 I=1,NSCAT
        IF(SFORM.EQ.'FORMATTED') THEN
      do n=1,NESC
        do m = 1,nchan
          READ(LUSCT,101) ESCAT(n),J
          READ(LUSCT,103) (AR(K,m,n),K=1,NSTAT)
          READ(LUSCT,102) ESCAT(n),J
          READ(LUSCT,103) (AI(K,m,n),K=1,NSTAT)
        end do
      end do
        ELSE
      do n=1,NESC
        do m=1,nchan
          READ(LUSCT) ESCAT(n),J,(AR(K,m,n),K=1,NSTAT)
          READ(LUSCT) ESCAT(n),J,(AI(K,m,n),K=1,NSTAT)
        end do
      end do
        ENDIF
        IF(IPRNT.NE.0) THEN
        ENDIF
! 146  CONTINUE
C
      RETURN
C
 99   WRITE(IWRITE,98) NSSET,LUSCT
      IFAIL = 1
      RETURN
C
 11   FORMAT(10F20.13)
 10   FORMAT(10I5)
 13   FORMAT(A80)
 14   FORMAT(/' Header on LUSCT')
 100  FORMAT(1X,10I5)
 101  FORMAT(F20.10,I5,'   Real Part')
 102  FORMAT(F20.10,I5,'   Imaginary Part')
 103  FORMAT(10F20.13)
 104  FORMAT(/'Energy ',F12.8,' is too close to R-matrix pole',I3)
 110  FORMAT(1X,4E20.13)
 130  FORMAT(1X,A80)
 140  FORMAT(3I7, F20.10)
 98   FORMAT(/' UNABLE TO FIND SCATTERING STATE SET',I3,' ON UNIT',I3)
      END
