! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      module dipelmio

      contains
     
      subroutine get_state_information(luscat,sform, nsset,ndcomp, nstat, nchan, nesc)
      use dipelmdefs
      implicit none

!     Arguments
      integer :: nesc,ndcomp
      integer,dimension(:) :: luscat, nsset, nstat, nchan
      character(len=11) :: sform

!     Local variables
      integer :: mgvn, stot, gutot, iwrit, ifail, iprnt,nscat,&
     &           key,nset,nrec,ninfo,ndata
      real(kind=idp) :: RR 
      character(len=80) :: title

      integer :: isym

      intent(in) :: luscat, nsset, sform,ndcomp
      intent(out) :: nesc, nstat, nchan

      iwrit=6; iprnt=1; ifail=0

      do isym=1, ndcomp
     
!        Find set
         call getset(luscat(isym),nsset(isym),80,sform,ifail)
         if(ifail.ne.0) then
            write(iwrit,12) nsset(isym),luscat(isym)
            ifail=1
            stop
         end if

!        Read relvant header information
         if(sform.eq.'FORMATTED') then
            read(luscat(isym),10)  key,nset,nrec,ninfo,ndata
            read(luscat(isym),11) title
            read(luscat(isym),10) nscat,mgvn,stot,gutot,nstat(isym),nchan(isym),nesc
         else
            read(luscat(isym)) key,nset,nrec,ninfo,ndata
            read(luscat(isym)) title
            read(luscat(isym)) nscat,mgvn,stot,gutot,nstat(isym),nchan(isym),nesc
         end if

!        Write state information to standard output
         write(iwrit,'(/," Scattering state ",i2," read from unit ",i6)') isym,luscat(isym)
         write(iwrit,'(  "  Symmetry =  ",i2,"   Spin = ",i2)') mgvn,stot
         write(iwrit,'(  "  Basis size =  ",i8)') nstat(isym)
         write(iwrit,'(  "  No. energy points =  ",i8,/)') nesc
      end do

      return

 10   format(10i5)
 11   format(a80)
 12   format(/' UNABLE TO FIND SCATTERING STATE SET',I3,' ON UNIT',I3)

      end subroutine get_state_information      

!     *********************************************************************
!
!     FILE WRITING ROUTINES
!
!     *********************************************************************


      subroutine write_oriented_photo_dcs( lu_photo_dcs, escat, ionization_pot, itarget, & 
     &                                     lab_component,th_grid,ph_grid,temp_photo_dcs )
      use dipelmdefs
      use angmom_procs, only:  tp2i 
      implicit none

!     Argument variables
      integer :: lu_photo_dcs,itarget,lab_component
      real(kind=idp) :: escat(:), ionization_pot, th_grid(:), ph_grid(:), temp_photo_dcs(:,:,:) 

!     Local variables
      integer :: no_energies, no_theta_points, no_phi_points, ienergy, itheta, iphi, iangle
      real(kind=idp) :: photon_energy, x_xsec, y_xsec, z_xsec

      no_energies=size(temp_photo_dcs,3)
      no_theta_points=size(th_grid)
      no_phi_points=size(ph_grid)

      do ienergy=1,no_energies
        photon_energy=escat(ienergy)+ionization_pot
        do itheta =1,no_theta_points
            do iphi=1,no_phi_points
              iangle=tp2i(itheta,iphi,no_phi_points)


              y_xsec = temp_photo_dcs(1, iangle, ienergy)  
              z_xsec = temp_photo_dcs(2, iangle, ienergy)
              x_xsec = temp_photo_dcs(3, iangle, ienergy)

!                     Print x, y or z-components
              select case(lab_component)
              case(1)
!                          write(100+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, ph_grid(iphi)*180/pi, x_xsec
                  write(lu_photo_dcs+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, x_xsec
              case(2)
!                          write(100+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, ph_grid(iphi)*180/pi, y_xsec
                  write(lu_photo_dcs+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, y_xsec
              case(3)
!                          write(100+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, ph_grid(iphi)*180/pi, z_xsec
                  write(lu_photo_dcs+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, z_xsec
              end select


            end do
        end do
        write(lu_photo_dcs+itarget,*) "" !For gnuplot
      end do

      return
 1020 format(8(E20.12,10x))
      end subroutine write_oriented_photo_dcs
      subroutine write_para_or_perp_dcs( lu_photo_dcs, escat, ionization_pot, itarget, & 
     &                                     lab_component,beta,temp_photo_dcs )
      use dipelmdefs
      use angmom_procs, only:  tp2i 
      implicit none

!     Argument variables
      integer :: lu_photo_dcs,itarget,lab_component
      real(kind=idp) :: escat(:), ionization_pot, beta, temp_photo_dcs(:,:,:) 

!     Local variables
      integer :: no_energies, no_theta_points, no_phi_points, ienergy, itheta, iphi, iangle
      real(kind=idp) :: photon_energy, x_xsec, y_xsec, z_xsec

      no_energies=size(temp_photo_dcs,3)


      do ienergy=1,no_energies
              photon_energy=escat(ienergy)+ionization_pot

              iangle=1!tp2i(itheta,iphi,no_phi_points)

              y_xsec = temp_photo_dcs(1, iangle, ienergy)  
              z_xsec = temp_photo_dcs(2, iangle, ienergy)
              x_xsec = temp_photo_dcs(3, iangle, ienergy)

!                     Print x, y or z-components
              select case(lab_component)
              case(1)
!                          write(100+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, ph_grid(iphi)*180/pi, x_xsec
                  write(lu_photo_dcs+itarget,1020) photon_energy*27.211, beta*180/pi, x_xsec
              case(2)
!                          write(100+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, ph_grid(iphi)*180/pi, y_xsec
                  write(lu_photo_dcs+itarget,1020) photon_energy*27.211, beta*180/pi, y_xsec
              case(3)
!                          write(100+itarget,1020) photon_energy*27.211,th_grid(itheta)*180/pi, ph_grid(iphi)*180/pi, z_xsec
                  write(lu_photo_dcs+itarget,1020) photon_energy*27.211, beta*180/pi, z_xsec
              end select

      end do
      write(lu_photo_dcs+itarget,*) "" !For gnuplot


      return
 1020 format(8(E20.12,10x))
      end subroutine write_para_or_perp_dcs

!     Routine to read an experimental alignment distribution
      subroutine read_exp_alignment_distribution(luexpalgn,exp_alignment_distribution)
      use dipelmdefs  
      implicit none

!     arguments
      integer :: luexpalgn

!     Local variables
      integer :: no_angular_points, col_max, iline,icol,iostatus
      character(len=80) :: line   
      real(kind=idp), allocatable :: exp_alignment_distribution(:,:)

      col_max=2
      no_angular_points =0

      do 
         read(luexpalgn,'(A)',iostat=iostatus) line
         if(iostatus .gt. 0) then
            stop 'Problem reading file'
         else if (iostatus .lt. 0) then
            exit
         else 
            no_angular_points=no_angular_points+1
         end if
      end do

      rewind(luexpalgn)
      iostatus=0

      if (no_angular_points .gt. 0) then
         allocate(exp_alignment_distribution(2,no_angular_points))
         exp_alignment_distribution=0._idp

         do iline=1, no_angular_points
            read(luexpalgn,'(A)') line
            read (line, *,iostat=iostatus) ( exp_alignment_distribution(icol,iline), icol=1, col_max)
            if(iostatus .gt. 0) then
               stop 'Problem reading file'
            else if (iostatus .lt. 0) then
               exit
            else 
!                print*, iline,exp_alignment_distribution(1,iline),exp_alignment_distribution(2,iline)
            end if
         end do

      end if

      end subroutine read_exp_alignment_distribution

!     Routine to read an experimental alignment distribution
      subroutine read_extremal_points(luexpoints,extremal_points)
      use dipelmdefs  
      implicit none

!     arguments
      integer :: luexpoints

!     Local variables
      integer :: no_angular_points, col_max, iline,icol,iostatus
      character(len=250) :: line   
      real(kind=idp), allocatable :: extremal_points(:,:)

      col_max=4
      no_angular_points =0

      do 
         read(luexpoints,'(A)',iostat=iostatus) line
         if(iostatus .gt. 0) then
            stop 'Problem reading file'
         else if (iostatus .lt. 0) then
            exit
         else 
            no_angular_points=no_angular_points+1
         end if
      end do

      rewind(luexpoints)
      iostatus=0

      if (no_angular_points .gt. 0) then
         allocate(extremal_points(4,no_angular_points))
         extremal_points=0._idp

         do iline=1, no_angular_points
            read(luexpoints,'(A)') line
            read (line, *,iostat=iostatus) ( extremal_points(icol,iline), icol=1, col_max)
            if(iostatus .gt. 0) then
               stop 'Problem reading file'
            else if (iostatus .lt. 0) then
               exit
            else 
!                 print*, iline,extremal_points(1,iline),extremal_points(2,iline),extremal_points(3,iline),extremal_points(4,iline)
            end if
         end do

      end if

      end subroutine read_extremal_points

      subroutine new_write_dipoles_for_HHG_codes(min_energy,escat,th_grid,ph_grid,iplane,dipoles)
      use dipelmdefs
      use angmom_procs
      implicit none

!     Writes out the dipole components for each child state.
!     Naming convention is 'REI'+component+ionic state+R/I; component = x,y,z, R = Re, I = Im

!     Assumes that 4 phi points are requested so both z-x and z-y planes
!     can be represented.
!     iplane=1 gives z-x plane, iplane =2 gives z-y plane


!     Arguments
      integer :: iplane
      real(kind=idp) :: min_energy
      real(kind=idp),dimension(:) :: escat,th_grid,ph_grid
      complex(kind=icp),dimension(:,:,:,:) :: dipoles

!     Local variables
      integer :: ichild,ien,itheta,iangle,no_child_states,no_scattering_energies,no_theta_points,no_phi_points,luR,luI,imin,&
                 component
      character(len=5) :: str_ichild, str_no_chans
      character(len=1) :: comp_str
      character(len=80) :: pathR, pathI

      intent(in) :: min_energy,escat,th_grid,ph_grid,dipoles,iplane

      no_child_states= size(dipoles,4)
      no_scattering_energies=size(escat,1)
      no_theta_points=size(th_grid)
      no_phi_points=size(ph_grid)
      write(6, *) no_child_states,no_scattering_energies,no_theta_points,no_phi_points

      imin = 1
      do ien=1,no_scattering_energies
         if (escat(ien)*27.211 < min_energy) imin = ien
      enddo

!     Write dipoles to file 

      do ichild =1, no_child_states
         write(str_ichild,'(i5)') ichild

         do component=1,3
            select case(component)
               case (1)
                  comp_str = 'y'
               case (2)
                  comp_str = 'z'
               case (3)
                  comp_str = 'x'
            end select

            pathR = 'REI'//comp_str//'_'//trim(adjustl(str_ichild))//'_R.txt'
            pathI = 'REI'//comp_str//'_'//trim(adjustl(str_ichild))//'_I.txt'

            write(6,'(" Writing dipoles leaving ion in state ",i5," to file",a80)') ichild,pathR
            write(6,'(" Writing dipoles leaving ion in state ",i5," to file",a80)') ichild,pathI

            luR = 100+ichild
            luI = 200+ichild
            open(unit=luR,file=trim(adjustl(pathR)), form='formatted',access='sequential')
            open(unit=luI,file=trim(adjustl(pathI)), form='formatted',access='sequential')

            do itheta=1, no_theta_points
               iangle=tp2i(itheta,iplane,no_phi_points)
               write(luR,'(10000e25.15)') real(dipoles(component,iangle,imin:no_scattering_energies,ichild))
               write(luI,'(10000e25.15)') aimag(dipoles(component,iangle,imin:no_scattering_energies,ichild))
            end do

            do itheta=no_theta_points-1,2,-1
               iangle=tp2i(itheta,iplane+2,no_phi_points)
               write(luR,'(10000e25.15)') real(dipoles(component,iangle,imin:no_scattering_energies,ichild))
               write(luI,'(10000e25.15)') aimag(dipoles(component,iangle,imin:no_scattering_energies,ichild))
            enddo !itheta
         end do !component
      end do

      return 
      end subroutine new_write_dipoles_for_HHG_codes

      subroutine write_dipoles_for_HHG_codes(molecule_name,potionz,escat,th_grid,ph_grid,iplane,dipoles)
      use dipelmdefs
      use angmom_procs
      implicit none

!     Writes out the dipole components for each child state.
!     Naming convention is [inputfilename].[statenumber].dipoles.dat

!     Assumes that 4 phi points are requested so both z-x and z-y planes
!     can be represented.
!     iplane=1 gives z-x plane, iplane =2 gives z-y plane


!     Arguments
      integer :: iplane
      real(kind=idp) :: potionz,pconst
      real(kind=idp),dimension(:) :: escat,th_grid,ph_grid
      complex(kind=icp),dimension(:,:,:,:) :: dipoles
      character(len=80) :: molecule_name

!     Local variables
      integer :: ichild,ien,itheta,iangle,no_child_states,no_scattering_energies,no_theta_points,no_phi_points,ncom_arg_length
      real(kind=idp) :: real_xdip,imag_xdip,real_ydip,imag_ydip,real_zdip,imag_zdip
      character(len=80) :: com_arg_string
      character(len=5) :: str_ichild, str_no_chans
      character(len=80), allocatable, dimension(:) :: output_filename

      intent(in) :: molecule_name,potionz,escat,th_grid,ph_grid,dipoles

      no_child_states= size(dipoles,4)
      no_scattering_energies=size(escat,1)
      no_theta_points=size(th_grid)
      no_phi_points=size(ph_grid)
      write(6, *) no_child_states,no_scattering_energies,no_theta_points,no_phi_points

!     Construct file names for output

      allocate(output_filename(no_child_states)) 

!      call GET_COMMAND_ARGUMENT(1, com_arg_string ,  ncom_arg_length)
!      molecule_name=com_arg_string

      
      write(str_no_chans,'(i5)') no_child_states


      do ichild =1, no_child_states
         write(str_ichild,'(i5)') ichild
         output_filename(ichild)=trim(adjustl(molecule_name))//'.'//trim(adjustl(str_no_chans))//'chan.'//trim(adjustl(str_ichild))&
                                      //'.dipoles.dat'
      end do

!     Write dipoles to file 


      do ichild =1, no_child_states
         write(6,'(" Writing dipoles leaving ion in state ",i5," to file",a80)') ichild,output_filename(ichild)
         open(unit=100+ichild,file=trim(adjustl(output_filename(ichild))), form='formatted',access='sequential')
         !write(100+ichild,'(3i8)'), ichild,no_scattering_energies,2*no_theta_points-2
         do ien =1,no_scattering_energies

!           First half plane
            do itheta=1, no_theta_points
               iangle=tp2i(itheta,iplane,no_phi_points)
               write(700+ichild,1000) escat(ien)*27.211,th_grid(itheta)*180/pi, (dipoles(1,iangle,ien,ichild)) 

!              y dipole 
               real_ydip=real(dipoles(1,iangle,ien,ichild))
               imag_ydip=aimag(dipoles(1,iangle,ien,ichild))
!              z dipole               
               real_zdip=real(dipoles(2,iangle,ien,ichild))
               imag_zdip=aimag(dipoles(2,iangle,ien,ichild))
!              x dipole 
               real_xdip=real(dipoles(3,iangle,ien,ichild))
               imag_xdip=aimag(dipoles(3,iangle,ien,ichild))

!                write(100+ichild,1000)
!                (escat(ien)+potionz)*27.211,th_grid(itheta)*180/pi,
!                real_xdip,imag_xdip,real_ydip,imag_ydip,real_zdip,imag_zdip

               write(100+ichild,1000) escat(ien)*27.211,th_grid(itheta)*180/pi, real_xdip,imag_xdip,real_ydip,imag_ydip,&
                                      real_zdip,imag_zdip

            end do

!           Second half plane

            do itheta=no_theta_points-1,2,-1
               iangle=tp2i(itheta,iplane+2,no_phi_points)
              
!              y dipole 
               real_ydip=real(dipoles(1,iangle,ien,ichild))
               imag_ydip=aimag(dipoles(1,iangle,ien,ichild))
!              z dipole               
               real_zdip=real(dipoles(2,iangle,ien,ichild))
               imag_zdip=aimag(dipoles(2,iangle,ien,ichild))
!              x dipole 
               real_xdip=real(dipoles(3,iangle,ien,ichild))
               imag_xdip=aimag(dipoles(3,iangle,ien,ichild))

!                write(100+ichild,1000)
!                (escat(ien)+potionz)*27.211,th_grid(itheta)*180/pi,
!                real_xdip,imag_xdip,real_ydip,imag_ydip,real_zdip,imag_zdip

               write(100+ichild,1000) escat(ien)*27.211,(360-(th_grid(itheta)*180/pi)), real_xdip,imag_xdip,real_ydip,imag_ydip,&
                                      real_zdip,imag_zdip

            end do
!            write(100+ichild,'("")')

         end do
      end do

      return 
 1000 format(8(E20.12,10x))
      end subroutine write_dipoles_for_HHG_codes

!     For writing smoothed dipoles to file, note: just for case where each component is in a
!     seperate file. Some modification needed if there is more than one component per file.       
      subroutine write_smoothed_pwd_dipoles( lu_pw_dipoles, nset_pw_dipoles, format_pw_dipoles, &
     &                                       lu_smoothed_pw_dipoles, nset_smoothed_pw_dipoles,  &
     &                                       format_smoothed_pw_dipoles, dip_elm)
      use dipelmdefs
      use photo_outerio, only: read_pw_dipoles, write_pw_dipoles
      implicit none

!     Arguments      
      integer :: lu_pw_dipoles(maxprop_par), nset_pw_dipoles(maxprop_par), &
     &           lu_smoothed_pw_dipoles(maxprop_par), nset_smoothed_pw_dipoles(maxprop_par),    &
     &           mgvn, stot, gutot, iprint, iwrite, ifail, lmax_property   
      character(len=11) :: format_pw_dipoles, format_smoothed_pw_dipoles
      character(len=80) ::  title
      integer, allocatable :: ichl(:), lvchl(:), mvchl(:),dip_comp_present(:), starg(:), mtarg(:), &
     &                        gtarg(:)
      real(kind=idp), allocatable :: evchl(:), escat(:), re_pw_dipoles(:,:,:,:), &
     &                               im_pw_dipoles(:,:,:,:), bound_state_energies(:)
      complex(kind=icp):: dip_elm(:,:,:,:)
      
!     Local      
      integer :: icomp, ienergy,no_scattering_energies,no_dipole_components,icomponent
      real(kind=idp) :: target_energy

      intent(in) :: dip_elm
      
!     Read the first dipole file and figure out how many components there are. 
      iprint = 1
      iwrite = 6
 
      call read_pw_dipoles( lu_pw_dipoles(1), nset_pw_dipoles(1), format_pw_dipoles, title, &
     &                      mgvn, stot, gutot, starg, mtarg, gtarg, ichl, lvchl, mvchl,  &
     &                      evchl, escat, lmax_property, dip_comp_present,        &
     &                      bound_state_energies, target_energy, re_pw_dipoles, im_pw_dipoles,  &
     &                      iprint, iwrite, ifail )

      no_dipole_components=lmax_property**2+2*lmax_property 
     
!~       do icomp=2,no_dipole_components
      do icomp=1,no_dipole_components
         call read_pw_dipoles( lu_pw_dipoles(icomp), nset_pw_dipoles(icomp), format_pw_dipoles, title, &
     &                         mgvn, stot, gutot, starg, mtarg, gtarg, ichl, lvchl, mvchl,  &
     &                         evchl, escat, lmax_property, dip_comp_present,        &
     &                         bound_state_energies, target_energy, re_pw_dipoles, im_pw_dipoles,  &
     &                         iprint, iwrite, ifail )

         no_scattering_energies=size(escat)
         print *, 'NO SCATTERING ENERGIES= ',no_scattering_energies
         re_pw_dipoles=0
         im_pw_dipoles=0
         
         do icomponent=1,no_dipole_components
            if(dip_comp_present(icomponent).eq. 1) then         
               do ienergy=1, no_scattering_energies     
                  im_pw_dipoles(:,:,icomponent,ienergy)=transpose(-aimag(dip_elm(:,:,icomponent,ienergy)) )
                  re_pw_dipoles(:,:,icomponent,ienergy)=transpose(  real(dip_elm(:,:,icomponent,ienergy)) )
                  
               end do
               
            end if
            
         end do
     
      call write_pw_dipoles( lu_smoothed_pw_dipoles(icomp), nset_smoothed_pw_dipoles(icomp), format_smoothed_pw_dipoles, title, &
     &                         mgvn, stot, gutot, starg, mtarg, gtarg, ichl, lvchl, mvchl,  &
     &                         evchl, escat, lmax_property, dip_comp_present,        &
     &                         bound_state_energies, target_energy, re_pw_dipoles, im_pw_dipoles,  &
     &                         iprint, iwrite, ifail )    
     

      end do
 
      end subroutine write_smoothed_pwd_dipoles
      
      end module dipelmio

