! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      module dipelmdefs
      implicit none
      !*********************************************************!
      !
      !Module containing parameter and derived type definitions
      !
      !*********************************************************!

      integer, parameter :: idp = kind(1d0) 
      integer, parameter :: icp=idp!selected_real_kind(15)
      real(kind=idp), parameter :: small_int=10d0**(-10)
      real(kind=idp), parameter :: pi=3.1415926535897932_idp
      real(kind=idp),parameter :: alpha=1/137.03599907_idp
      integer, parameter :: maxprop_par=8 !Maximum number of properties (not including overlaps)
      real(kind=idp), parameter :: ryd=0.073500D0 
      complex(kind=idp), parameter :: eye=(0,1.0) !sqrt of minus 1
      real(kind=idp),parameter :: r_bohr=5.2917721092d-11
      real(kind=idp),parameter :: convert_au_to_megabarns=r_bohr**2 * 1.0d22
      integer, parameter :: max_sym=8
      integer, parameter :: ir_max=8 !Maximum no of IR per point group
      integer, parameter :: max_states_for_dipoles=1000

      type CIvect
        integer :: nset, nrec
        CHARACTER(len=120) :: name
        integer :: nnuc,nocsf,nstat,mgvn
        real(kind=idp) :: S, SZ
        integer :: nelt
        real(kind=idp) :: e0
        character(len=8),allocatable, dimension(:) :: cname
        real(kind=idp), allocatable, dimension(:) :: xnuc, ynuc, znuc, charge, ei
        integer , allocatable, dimension (:) :: iphz
        real(kind=idp), allocatable, dimension(:,:) :: CV
      !contains
      !  final :: destroy_CIvect   !Use when intel finally fully implement 2003 standard 
      !   procedure :: destroy => destroy_CIvect
      end type CIvect

      character(len=3) :: point_group_name(8) = (/&
     & "C1 ","Cs ","C2 ","Ci ","C2v","C2h","D2 ","D2h"/) 

!    Maps x, y and z to irreducible representation for each
!    point group (order is the same as in point_group_name)
      integer, parameter :: xyz_irrep(3,8) = RESHAPE( (/&
!            y,z,x     
             1,1,1, &
             1,2,1, &
             2,1,2, &
             2,2,2, &
             3,1,2, &
             3,2,3, &
             3,4,2, &
             3,5,2  &
       /) , (/3, 8/), order = (/2,1/) )
   
!     D2h group multiplication table 
!     Note the change in dimensions from 8,8 to maxsym, maxsym 
!     to achieve consistency via the global parameters.
      integer, dimension(ir_max,ir_max), parameter :: IPD2H=RESHAPE( (/ &
     &        1,2,3,4,5,6,7,8, &
     &        2,1,4,3,6,5,8,7, &
     &        3,4,1,2,7,8,5,6, &
     &        4,3,2,1,8,7,6,5, &
     &        5,6,7,8,1,2,3,4, &
     &        6,5,8,7,2,1,4,3, &
     &        7,8,5,6,3,4,1,2, &
     &        8,7,6,5,4,3,2,1/) , (/ ir_max, ir_max /) )
     
     
!    Accuracy L=21
      real(kind=idp) :: lebedev_oct_31_grid(3,31) =RESHAPE( (/&
     &  0.00000000,  0.00000000, 0.003564681,  &
     &  0.00000000, 20.2288199,  0.020207384,  &
     &  0.00000000, 45.0000000,  0.022867624,  &
     &  0.00000000, 69.7711801,  0.020207384,  &
     &  0.00000000, 90.0000000,  0.003564681,  &
     &  7.52995108, 82.5342479,  0.032854216,  &
     & 10.7708560,  58.3237741,  0.044241991,  &
     & 16.8498911,  33.2761302,  0.044241991,  &
     & 17.5875412,  73.1871458,  0.041265902,  &
     & 20.2288199,  90.0000000,  0.020207384,  &
     & 25.0816830,  47.8327264,  0.044869633,  &
     & 29.7677350,  63.5962810,  0.044150172,  &
     & 32.1331436,  80.8487219,  0.044241991,  &
     & 45.0000000,  10.5884838,  0.032854216,  &
     & 45.0000000,  24.1455738,  0.041265902,  &
     & 45.0000000,  38.9683735,  0.044150172,  &
     & 45.0000000,  54.7356103,  0.044587065,  &
     & 45.0000000,  71.6876561,  0.044869633,  &
     & 45.0000000,  90.0000000,  0.022867624,  &
     & 57.8668563,  80.8487219,  0.044241991,  &
     & 60.2322650,  63.5962810,  0.044150172,  &
     & 64.9183170,  47.8327264,  0.044869633,  &
     & 69.7711801,  90.0000000,  0.020207384,  &
     & 72.4124588,  73.1871458,  0.041265902,  &
     & 73.1501089,  33.2761302,  0.044241991,  &
     & 79.2291440,  58.3237741,  0.044241991,  &
     & 82.4700489,  82.5342479,  0.032854216,  &
     & 90.0000000,  20.2288199,  0.020207384,  &
     & 90.0000000,  45.0000000,  0.022867624,  &
     & 90.0000000,  69.7711801,  0.020207384,  &
     & 90.0000000,  90.0000000,  0.003564681   &
     & /), (/3,31/), order = (/2,1/) )

!    Accuracy L=10
     real(kind=idp) :: lebedev_full_10_grid(3,50) =RESHAPE( (/&
     &  0.000000000000000,    90.000000000000000  ,   0.012698412698413   , &
     & 180.000000000000000,    90.000000000000000 ,    0.012698412698413  , &
     &  90.000000000000000,    90.000000000000000 ,    0.012698412698413  , &
     & -90.000000000000000,    90.000000000000000 ,    0.012698412698413  , &
     &  90.000000000000000,     0.000000000000000 ,    0.012698412698413  , &
     &   90.000000000000000,   180.000000000000000 ,    0.012698412698413 , &
     &   90.000000000000000,    45.000000000000000 ,    0.022574955908289 , &
     &   90.000000000000000,   135.000000000000000 ,    0.022574955908289 , &
     & -90.000000000000000 ,   45.000000000000000  ,   0.022574955908289  , &
     & -90.000000000000000 ,  135.000000000000000  ,   0.022574955908289  , &
     &   0.000000000000000 ,   45.000000000000000 ,    0.022574955908289  , &
     &   0.000000000000000 ,  135.000000000000000 ,    0.022574955908289  , &
     & 180.000000000000000 ,   45.000000000000000 ,    0.022574955908289  , &
     & 180.000000000000000 ,  135.000000000000000 ,    0.022574955908289  , &
     &   45.000000000000000,    90.000000000000000 ,    0.022574955908289  , &
     & -45.000000000000000 ,   90.000000000000000  ,   0.022574955908289  , &
     & 135.000000000000000 ,   90.000000000000000  ,   0.022574955908289  , &
     & -135.000000000000000,    90.000000000000000 ,    0.022574955908289  , &
     &   45.000000000000000,    54.735610317245346 ,    0.021093750000000  , &
     &   45.000000000000000,   125.264389682754654 ,    0.021093750000000  , &
     & -45.000000000000000 ,   54.735610317245346  ,   0.021093750000000  , &
     & -45.000000000000000 ,  125.264389682754654  ,   0.021093750000000  , &
     & 135.000000000000000 ,   54.735610317245346  ,   0.021093750000000  , &
     & 135.000000000000000 ,  125.264389682754654  ,   0.021093750000000  , &
     & -135.000000000000000,    54.735610317245346 ,    0.021093750000000  , &
     & -135.000000000000000,   125.264389682754654 ,    0.021093750000000  , &
     &   45.000000000000000,    25.239401820678911 ,    0.020173335537919  , &
     &   45.000000000000000,   154.760598179321079 ,    0.020173335537919  , &
     & -45.000000000000000 ,   25.239401820678911  ,   0.020173335537919  , &
     & -45.000000000000000 ,  154.760598179321079  ,   0.020173335537919  , &
     & 135.000000000000000 ,   25.239401820678911  ,   0.020173335537919  , &
     & 135.000000000000000 ,  154.760598179321079  ,   0.020173335537919  , &
     & -135.000000000000000,    25.239401820678911 ,    0.020173335537919  , &
     & -135.000000000000000,   154.760598179321079 ,    0.020173335537919  , &
     &   71.565051177077990,    72.451599386207704 ,    0.020173335537919  , &
     & -71.565051177077990 ,   72.451599386207704  ,   0.020173335537919  , &
     &   71.565051177077990,   107.548400613792296 ,    0.020173335537919  , &
     & -71.565051177077990 ,  107.548400613792296  ,   0.020173335537919  , &
     & 108.434948822922010 ,   72.451599386207704  ,   0.020173335537919  , &
     & -108.434948822922010,    72.451599386207704 ,    0.020173335537919  , &
     & 108.434948822922010 ,  107.548400613792296  ,   0.020173335537919  , &
     & -108.434948822922010,   107.548400613792296 ,    0.020173335537919  , &
     &   18.434948822922017,    72.451599386207704 ,    0.020173335537919  , &
     & 161.565051177078004 ,   72.451599386207704  ,   0.020173335537919  , &
     &   18.434948822922017,   107.548400613792296 ,    0.020173335537919  , &
     &  161.565051177078004,   107.548400613792296 ,    0.020173335537919  , &
     & -18.434948822922017 ,   72.451599386207704  ,   0.020173335537919  , &
     & -161.565051177078004,    72.451599386207704 ,    0.020173335537919  , &
     & -18.434948822922017 ,  107.548400613792296  ,   0.020173335537919  , &
     & -161.565051177078004,   107.548400613792296 ,    0.020173335537919   &
     & /), (/3,50/), order = (/2,1/) )

    real(kind=idp) :: lebedev_full_17_grid(3,110) =RESHAPE( (/&
&       0.000000000000000  ,   90.000000000000000 ,    0.003828270494937   ,      & 
&     180.000000000000000  ,   90.000000000000000 ,    0.003828270494937   ,      & 
&       90.000000000000000 ,   90.000000000000000 ,    0.003828270494937   ,     & 
&     -90.000000000000000  ,   90.000000000000000 ,    0.003828270494937   ,      & 
&       90.000000000000000 ,   0.000000000000000  ,   0.003828270494937    ,    & 
&       90.000000000000000 ,   180.000000000000000,     0.003828270494937  ,      & 
&       45.000000000000000 ,    54.735610317245346,     0.009793737512488  ,      & 
&       45.000000000000000 ,   125.264389682754654,     0.009793737512488  ,      & 
&     -45.000000000000000  ,   54.735610317245346 ,    0.009793737512488   ,      & 
&     -45.000000000000000  ,  125.264389682754654 ,    0.009793737512488   ,      & 
&     135.000000000000000  ,   54.735610317245346 ,    0.009793737512488   ,      & 
&     135.000000000000000  ,  125.264389682754654 ,    0.009793737512488   ,      & 
&     -135.000000000000000 ,    54.735610317245346,     0.009793737512488  ,      & 
&     -135.000000000000000 ,   125.264389682754654,     0.009793737512488  ,      & 
&       45.000000000000000 ,    15.176481556075425,     0.008211737283191  ,      & 
&       45.000000000000000 ,   164.823518443924598,     0.008211737283191  ,      & 
&     -45.000000000000000  ,  15.176481556075425  ,   0.008211737283191    ,     & 
&     -45.000000000000000  , 164.823518443924598  ,   0.008211737283191    ,     & 
&     135.000000000000000  ,  15.176481556075425  ,   0.008211737283191    ,     & 
&     135.000000000000000  , 164.823518443924598  ,   0.008211737283191    ,     & 
&     -135.000000000000000 ,   15.176481556075425 ,    0.008211737283191   ,     & 
&     -135.000000000000000 ,  164.823518443924598 ,    0.008211737283191   ,     & 
&       79.142249366142039 ,   79.332125737120890 ,    0.008211737283191   ,     & 
&     -79.142249366142039  ,  79.332125737120890  ,   0.008211737283191    ,     & 
&       79.142249366142039 ,  100.667874262879110 ,    0.008211737283191   ,     & 
&     -79.142249366142039  , 100.667874262879110  ,   0.008211737283191    ,     & 
&     100.857750633857975  ,  79.332125737120890  ,   0.008211737283191    ,     & 
&     -100.857750633857975 ,   79.332125737120890 ,    0.008211737283191   ,     & 
&     100.857750633857975  , 100.667874262879110  ,   0.008211737283191    ,     & 
&     -100.857750633857975 ,  100.667874262879110 ,    0.008211737283191   ,     & 
&       10.857750633857979 ,   79.332125737120890 ,    0.008211737283191   ,     & 
&     169.142249366142011  ,  79.332125737120890  ,   0.008211737283191    ,     & 
&       10.857750633857979 ,  100.667874262879110 ,    0.008211737283191   ,     & 
&     169.142249366142011  , 100.667874262879110  ,   0.008211737283191    ,     & 
&     -10.857750633857979  ,  79.332125737120890  ,   0.008211737283191    ,     & 
&     -169.142249366142011 ,   79.332125737120890 ,    0.008211737283191   ,     & 
&     -10.857750633857979  , 100.667874262879110  ,   0.008211737283191    ,     & 
&     -169.142249366142011 ,  100.667874262879110 ,    0.008211737283191   ,     & 
&       45.000000000000000 ,   77.528304436344783 ,    0.009942814891178   ,     & 
&       45.000000000000000 ,  102.471695563655231 ,    0.009942814891178   ,     & 
&     -45.000000000000000  ,  77.528304436344783  ,   0.009942814891178    ,     & 
&     -45.000000000000000  , 102.471695563655231  ,   0.009942814891178    ,     & 
&     135.000000000000000  ,  77.528304436344783  ,   0.009942814891178    ,     & 
&     135.000000000000000  , 102.471695563655231  ,   0.009942814891178    ,     & 
&     -135.000000000000000 ,   77.528304436344783 ,    0.009942814891178   ,     & 
&     -135.000000000000000 ,  102.471695563655231 ,    0.009942814891178   ,     & 
&       17.369198090442442 ,   46.336552258147378 ,    0.009942814891178   ,     & 
&     -17.369198090442442  ,  46.336552258147378  ,   0.009942814891178    ,     & 
&       17.369198090442442 ,  133.663447741852622 ,    0.009942814891178   ,     & 
&     -17.369198090442442  , 133.663447741852622  ,   0.009942814891178    ,     & 
&     162.630801909557562  ,  46.336552258147378  ,   0.009942814891178    ,     & 
&     -162.630801909557562 ,   46.336552258147378 ,    0.009942814891178   ,     & 
&     162.630801909557562  , 133.663447741852622  ,   0.009942814891178    ,     & 
&     -162.630801909557562 ,  133.663447741852622 ,    0.009942814891178   ,     & 
&       72.630801909557576 ,   46.336552258147378 ,    0.009942814891178   ,     & 
&     107.369198090442438  ,  46.336552258147378  ,  0.009942814891178     ,    & 
&       72.630801909557576 ,  133.663447741852622 ,    0.009942814891178   ,     & 
&     107.369198090442438  , 133.663447741852622  ,   0.009942814891178    ,     & 
&     -72.630801909557576  ,  46.336552258147378  ,   0.009942814891178    ,     & 
&     -107.369198090442438 ,   46.336552258147378 ,    0.009942814891178   ,     & 
&     -72.630801909557576  , 133.663447741852622  ,   0.009942814891178    ,     & 
&     -107.369198090442438 ,  133.663447741852622 ,    0.009942814891178   ,     & 
&       45.000000000000000 ,   34.027408105510005 ,    0.009595471336071   ,     & 
&       45.000000000000000 ,  145.972591894489995 ,    0.009595471336071   ,     & 
&     -45.000000000000000  ,  34.027408105510005  ,   0.009595471336071    ,     & 
&     -45.000000000000000  , 145.972591894489995  ,   0.009595471336071    ,     & 
&     135.000000000000000  ,  34.027408105510005  ,   0.009595471336071    ,     & 
&     135.000000000000000  , 145.972591894489995  ,   0.009595471336071    ,     & 
&     -135.000000000000000 ,   34.027408105510005 ,    0.009595471336071   ,     & 
&     -135.000000000000000 ,  145.972591894489995 ,    0.009595471336071   ,     & 
&       64.478237843366074 ,   66.691018332392488 ,    0.009595471336071   ,     & 
&     -64.478237843366074  ,  66.691018332392488  ,   0.009595471336071    ,     & 
&       64.478237843366074 ,  113.308981667607512 ,    0.009595471336071   ,     & 
&     -64.478237843366074  , 113.308981667607512  ,   0.009595471336071    ,     & 
&     115.521762156633926  ,  66.691018332392488  ,   0.009595471336071    ,     & 
&     -115.521762156633926 ,   66.691018332392488 ,    0.009595471336071   ,     & 
&     115.521762156633926  , 113.308981667607512  ,   0.009595471336071    ,     & 
&     -115.521762156633926 ,  113.308981667607512 ,    0.009595471336071   ,     & 
&       25.521762156633940 ,   66.691018332392488 ,    0.009595471336071   ,     & 
&     154.478237843366060  ,  66.691018332392488  ,   0.009595471336071    ,     & 
&       25.521762156633940 ,  113.308981667607512 ,    0.009595471336071   ,     & 
&     154.478237843366060  , 113.308981667607512  ,   0.009595471336071    ,     & 
&     -25.521762156633940  ,  66.691018332392488  ,   0.009595471336071    ,     & 
&     -154.478237843366060 ,   66.691018332392488 ,    0.009595471336071   ,     & 
&     -25.521762156633940  , 113.308981667607512  ,   0.009595471336071    ,     & 
&     -154.478237843366060 ,  113.308981667607512 ,    0.009595471336071   ,     & 
&       61.421065207205885 ,   90.000000000000000 ,    0.009694996361663   ,     & 
&     -61.421065207205885  ,  90.000000000000000  ,   0.009694996361663    ,     & 
&     118.578934792794129  ,  90.000000000000000  ,   0.009694996361663    ,     & 
&     -118.578934792794129 ,   90.000000000000000 ,    0.009694996361663   ,     & 
&       28.578934792794119 ,   90.000000000000000 ,    0.009694996361663   ,     & 
&     -28.578934792794119  ,  90.000000000000000  ,   0.009694996361663    ,     & 
&     151.421065207205885  ,  90.000000000000000  ,   0.009694996361663    ,     & 
&     -151.421065207205885 ,   90.000000000000000 ,    0.009694996361663   ,     & 
&       0.000000000000000  ,  28.578934792794119  ,   0.009694996361663    ,     & 
&       0.000000000000000  , 151.421065207205885  ,   0.009694996361663    ,     & 
&     180.000000000000000  ,  28.578934792794119  ,   0.009694996361663    ,     & 
&     180.000000000000000  , 151.421065207205885  ,   0.009694996361663    ,     & 
&       0.000000000000000  ,  61.421065207205885  ,   0.009694996361663    ,     & 
&       0.000000000000000  , 118.578934792794129  ,   0.009694996361663    ,     & 
&     180.000000000000000  ,  61.421065207205885  ,   0.009694996361663    ,     & 
&     180.000000000000000  , 118.578934792794129  ,   0.009694996361663    ,     & 
&      90.000000000000000  ,  28.578934792794119  ,   0.009694996361663    ,     &
&      90.000000000000000  , 151.421065207205885  ,   0.009694996361663    ,     &
&    -90.000000000000000   , 28.578934792794119   ,  0.009694996361663     ,     &
&    -90.000000000000000   , 151.421065207205885  ,   0.009694996361663    ,      &
&     90.000000000000000   , 61.421065207205885   ,  0.009694996361663     ,     &
&     90.000000000000000   , 118.578934792794129  ,   0.009694996361663    ,      &
&    -90.000000000000000   , 61.421065207205885   ,  0.009694996361663     ,     &
&    -90.000000000000000   , 118.578934792794129  ,   0.009694996361663          &
&  /), (/3,110/), order = (/2,1/) )
                          
      end module          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                           
