! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      program dipelm
      use dipelmdefs
      use dipelmprocs
!       use dipelm_test
      implicit none

      integer :: ifail, nesc,nbound,ndcomp
      integer,dimension(:) :: nchans(maxprop_par)
      integer, allocatable,dimension(:,:) :: ichl,lvchl,mvchl
      integer, allocatable,dimension(:) :: starg, mtarg, gtarg
      real(kind=idp), allocatable,dimension(:,:) :: evchl
      real(kind=idp), allocatable, dimension(:) :: escat,bound_state_energies 
      real(kind=idp) :: target_energy
      complex(kind=idp), allocatable, dimension(:,:,:,:)  :: dip_elm   
      character(len=1), dimension(:) :: dcomp(maxprop_par)
      integer :: lu_pw_dipoles(maxprop_par), nset_pw_dipoles(maxprop_par)
      character(len=11) :: format_pw_dipoles    
      
      nchans=0

      call print_ukrmol_header(6)
      write(6,1000)


!~ !     Consistency check for input data
!~ !     --------------------------------
!~       ifail=0
!~       call consistency_check(ifail)
!~       if (ifail.ne.0) stop ' ERROR: INPUT DATA INCONSISTENT'


!     Construct molecular frame dipoles
!     ---------------------------------

!~       call dipelm_drv(dip_elm,ichl,evchl,lvchl,mvchl,nchans,escat,nesc,nbound,ndcomp,dcomp,ifail)
      call dipelm_drv( dip_elm, ichl, evchl, lvchl, mvchl, nchans, starg, mtarg, gtarg, escat, ndcomp, dcomp, &
     &                 bound_state_energies, target_energy, lu_pw_dipoles, nset_pw_dipoles, format_pw_dipoles, ifail )
      if (ifail .ne. 0) then
         write(6,1010) ifail
         stop

      end if

      nbound=size(dip_elm,2)     
      nesc=size(dip_elm,4)

!     Smooth resonances.
!     ------------------

      call gaussian_smooth(dip_elm, ichl, evchl, lvchl, mvchl, nchans, escat, nesc, nbound, ndcomp,&
     &                     dcomp, lu_pw_dipoles, nset_pw_dipoles, format_pw_dipoles, ifail)


!     Transform from molecular to lab frame
!     -------------------------------------

      call diptrans_drv(dip_elm,ichl,evchl,lvchl,mvchl,nchans,escat,nesc,nbound,ndcomp,dcomp, bound_state_energies,target_energy,&
                        ifail)
!       call diptrans_drv2(dip_elm,ichl,evchl,lvchl,mvchl,nchans,escat,nesc,nbound,ndcomp,dcomp,ifail)
      if (ifail .ne. 0) then
         write(6,1020) ifail
         stop
      end if
      
      stop

!---- Format Statements

 1000 format(/,20X,'DIPELM (2011) ',//,20X, &
     &       'Dipole matrix elements and photoionization observables ',//)
 1010 format(/,5X,'ERROR CREATING DIPOLES, ERROR CODE',1X,I6,/)
 1020 format(/,5X,'ERROR TRANSFORMING DIPOLES, ERROR CODE',1X,I6,/)

      end program dipelm
