%Test for propylene oxide: HOMO (final state = 1) and HOMO-1 (final state = 2)
clear
d = rmatrix_data({'dipoles_data_matlab'})
d.show_states

theta = 1.5; %electron theta emission angle in radians
phi = 2.0;   %electron phi emission angle in radians
final_state = 1;  %index of the final (cationic) state
initial_state = 1;%index of the initial (bound) state
energy = linspace(0.2,1.0,10); %electron energy grid in Hartree

d.momentum_space_photodipoles(theta,phi,initial_state,final_state,{energy})

d.initial_state_energy(initial_state) %energy of the initial state
d.final_state_energy(final_state) %energy of the final state

d.final_state_dipoles(initial_state,final_state) %dipoles for the pair of final states with indices initial_state,final_state
