%Example for single geometry: interpolation in energy only
clear
d = rmatrix_data({'data_for_trpes/geom1/dipoles_data_matlab'})
d.show_states

theta = 1.5; %electron theta emission angle in radians
phi = 2.0;   %electron phi emission angle in radians
final_state = 1;  %index of the final (cationic) state
initial_state = 1;%index of the initial (bound) state
energy = linspace(0.2,1.0,10); %electron energy grid in Hartree
d.momentum_space_photodipoles(theta,phi,initial_state,final_state,{energy})

d.initial_state_energy(initial_state) %energies of the initial state
d.final_state_energy(final_state) %energies of the final state

d.initial_state_dipoles(initial_state,final_state) %dipoles for the pair of initial states with indices initial_state,final_state
d.final_state_dipoles(initial_state,final_state) %dipoles for the pair of final states with indices initial_state,final_state

d.Dyson_signs(final_state,initial_state) %Dyson orbital signs evaluated for the given pair of final and initial states

%Exaple using multiple geometries: including interpolation in nuclear space
clear
fileID = fopen('list','r');
C = textscan(fileID,'%s','Delimiter','\n'); %read the list of files
fclose(fileID);
str = char(C{1});
files = cellstr(str);
d = rmatrix_data(files,5) %read the R-matrix data for every 5-th energy.
d.show_states

theta = 1.5; %radians
phi = 2.0;   %radians
final_state = 1; %index of the final (cationic) state
initial_state = 1; %index of the initial (bound) state
energy = linspace(0.2,1.0,10); %electron energy in Hartree
gamma = linspace(80,170,15); %gamma in degrees
ra = linspace(0.0,0.15,5);   %ra in Bohr
d.momentum_space_photodipoles(theta,phi,initial_state,final_state,{energy,gamma,ra}) %x,y,z components of the photoelectron dipole for the energy,gamma,ra grid.

d.initial_state_energy(initial_state,{gamma,ra}) %energies of the initial state on the gamma,ra nuclear grid
d.final_state_energy(final_state,{gamma,ra}) %energies of the final state on the gamma,ra nuclear grid

d.initial_state_dipoles(initial_state,final_state,{gamma,ra}) %dipoles for the pair of initial states with indices initial_state,final_state on the gamma,ra nuclear grid
d.final_state_dipoles(initial_state,final_state,{gamma,ra}) %dipoles for the pair of final states with indices initial_state,final_state on the gamma,ra nuclear grid

d.Dyson_signs(final_state,initial_state,{gamma,ra}) %Dyson orbital signs evaluated for the given pair of final and initial states and for all angular points on the gamma,ra nuclear grid
