! Copyright 2019
!
! Alex G. Harvey with contributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
!
!***********************************************************************
!
!Module containing parameter and derived type definitions
!
!***********************************************************************
module dipelm_defs
implicit none

   integer, parameter           :: idp                     = kind(1d0) 
   integer, parameter           :: icp                     = idp!selected_real_kind(15)
   real(kind=idp), parameter    :: small_int               = 10d0**(-10)
   real(kind=idp), parameter    :: pi                      = 3.1415926535897932_idp
   real(kind=idp),parameter     :: alpha                   = 1/137.03599907_idp
   integer, parameter           :: maxprop_par             = 8 !Maximum number of properties (not including overlaps)
   real(kind=idp), parameter    :: ryd                     = 0.073500_idp
   real(kind=idp), parameter    :: Ha2eV                   = 27.211_idp!27.2113860_idp ! note: Use more exact value after testing is completed 
   complex(kind=idp), parameter :: eye                     = (0.0_idp,1.0_idp) !sqrt of minus 1
   real(kind=idp),parameter     :: r_bohr                  = 5.2917721092d-11
   real(kind=idp),parameter     :: convert_au_to_megabarns = r_bohr**2 * 1.0d22
   integer, parameter           :: max_sym                 = 8
   integer, parameter           :: ir_max                  = 8 !Maximum no of IR per point group
   integer, parameter           :: max_states_for_dipoles  = 10000
   integer, parameter           :: max_energies_for_aligned= 100

   character(len=3) :: point_group_name(8) = (/&
   & "C1 ","Cs ","C2 ","Ci ","C2v","C2h","D2 ","D2h"/) 

!   Maps x, y and z to irreducible representation for each
!   point group (order is the same as in point_group_name)
   integer, parameter :: xyz_irrep(3,8) = RESHAPE( (/&
!            y,z,x     
             1,1,1, &
             1,2,1, &
             2,1,2, &
             2,2,2, &
             3,1,2, &
             3,2,3, &
             3,4,2, &
             3,5,2  &
       /) , (/3, 8/), order = (/2,1/) )
   
!     D2h group multiplication table 
!     Note the change in dimensions from 8,8 to maxsym, maxsym 
!     to achieve consistency via the global parameters.
   integer, dimension(ir_max,ir_max), parameter :: IPD2H=RESHAPE( (/ &
   &        1,2,3,4,5,6,7,8, &
   &        2,1,4,3,6,5,8,7, &
   &        3,4,1,2,7,8,5,6, &
   &        4,3,2,1,8,7,6,5, &
   &        5,6,7,8,1,2,3,4, &
   &        6,5,8,7,2,1,4,3, &
   &        7,8,5,6,3,4,1,2, &
   &        8,7,6,5,4,3,2,1/) , (/ ir_max, ir_max /) )



end module          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                          
                           
