! Copyright 2019
!
! Alex G. Harvey with contributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
program dipelm

   use dipelm_procs
   
   implicit none

   integer :: ifail

   ifail  = 0

   call print_ukrmol_header(6)

   write(6,'(/, " DIPELM (2019) ")')
   write(6,'(   " Dipole matrix elements and photoionization observables ", /)')
   
   call dipelm_drv( ifail )  
      
   if (ifail .ne. 0) then
      write(6,'(" ERROR CREATING DIPOLES, ERROR CODE: ", i6)') ifail
      stop

   end if


end program dipelm
