! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      module chiral_procs
      use dipelmdefs
      use angmom_procs
      use blas95_compak
      implicit none

      contains
!     ****************************************     
!     Make dummy dipoles
!     ****************************************      
      subroutine make_dummy_dipoles(trans_dipole, photo_dipole, max_lcontinuum, &
     &                              bound_transition_chiral, continuum_transition_chiral, no_states)    
      USE IFPORT
      implicit none

!     Arguments
      complex(kind=idp) :: trans_dipole(:,:), photo_dipole(:,:,:,:,:)
      integer :: max_lcontinuum, no_states
      logical :: bound_transition_chiral, continuum_transition_chiral

!     Local 
      
      integer :: q2, l, m, ipw
      logical :: bound_transition_parallel

      bound_transition_parallel=.false.

      if  (continuum_transition_chiral) then
!     Chiral continuum transition - dummy dipoles
!     -------------------------------------------      
         do q2=-1, 1
          do l=0, max_lcontinuum
           do m=-l,l
            ipw=lm2i(l,m)
         
            if      ((q2 .gt. 0) .and. (m .gt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*1._idp*(rand()-0.5) +eye*(rand()-0.5) 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.2_idp*(rand()-0.5) +eye*(rand()-0.5)
            else if ((q2 .lt. 0) .and. (m .lt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*2._idp*(rand()-0.5) +eye*(rand()-0.5) 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.1_idp*(rand()-0.5) +eye*(rand()-0.5)    
                                 
            else if ((q2 .gt. 0) .and. (m .lt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*3._idp*(rand()-0.5) +eye*(rand()-0.5) 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.5_idp**(rand()-0.5) +eye*(rand()-0.5)
            else if ((q2 .lt. 0) .and. (m .gt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*4._idp*(rand()-0.5) +eye*(rand()-0.5)
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.6_idp*(rand()-0.5) +eye*(rand()-0.5)      

            else if ((q2 .eq. 0) .and. (m .gt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*5._idp*(rand()-0.5) +eye*(rand()-0.5)
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.3_idp*(rand()-0.5) +eye*(rand()-0.5)
                   
            else if ((q2 .eq. 0) .and. (m .lt. 0)) then
!~              photo_dipole(ipw,q2+2,:,:,1)=(l+1)*6._idp 
!~              if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.4_idp 
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*5._idp*(rand()-0.5) +eye*(rand()-0.5) 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.3_idp*(rand()-0.5) +eye*(rand()-0.5)             
          
            else if ((q2 .lt. 0) .and. (m .eq. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*7._idp*(rand()-0.5) +eye*(rand()-0.5) 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.9_idp*(rand()-0.5) +eye*(rand()-0.5)              
                   
            else if ((q2 .gt. 0) .and. (m .eq. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*8._idp*(rand()-0.5) +eye*(rand()-0.5)
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.7_idp*(rand()-0.5) +eye*(rand()-0.5)
          
            else if ((q2 .eq. 0) .and. (m .eq. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*9._idp*(rand()-0.5) +eye*(rand()-0.5) 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.8_idp*(rand()-0.5) +eye*(rand()-0.5)
                                            
            end if
         
           end do
          end do
         end do
      else
!     Non-chiral continuum transition (but odd and even l) - dummy dipoles
!     --------------------------------------------------------------------      
         do q2=-1, 1
          do l=0, max_lcontinuum
           do m=-l,l
            ipw=lm2i(l,m)
         
            if      ((q2 .gt. 0) .and. (m .gt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*1._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.7_idp 
            else if ((q2 .lt. 0) .and. (m .lt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*1._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.7_idp
                    
            else if ((q2 .gt. 0) .and. (m .lt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*3._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.5_idp                 
            else if ((q2 .lt. 0) .and. (m .gt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*3._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.5_idp        

            else if ((q2 .eq. 0) .and. (m .gt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*5._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.9_idp                    
            else if ((q2 .eq. 0) .and. (m .lt. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*5._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.9_idp
          
            else if ((q2 .lt. 0) .and. (m .eq. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*7._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.3_idp                    
            else if ((q2 .gt. 0) .and. (m .eq. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*7._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.3_idp
          
            else if ((q2 .eq. 0) .and. (m .eq. 0)) then
             photo_dipole(ipw,q2+2,:,:,1)=(l+1)*9._idp 
             if (no_states .eq. 2) photo_dipole(ipw,q2+2,:,:,2)=(l+1)*0.5_idp          
                               
            end if
         
           end do
          end do
         end do           
      end if
       
      if  (bound_transition_chiral) then
!     Chiral continuum transition - dummy dipoles
!     ------------------------------------------- 
         trans_dipole(1,1)=1.4_idp  +eye*2
         trans_dipole(2,1)=0.2_idp
         trans_dipole(3,1)=1.2_idp  +eye*2

!     h2o2 dipoles
!     ------------
         trans_dipole(1,1)=  0.00676396 - eye*0.0818130
         trans_dipole(2,1)=  0.1
         trans_dipole(3,1)= -0.00676396 - eye*0.0818130
         
!~          trans_dipole(1,1)=(1.4_idp  -1.2*eye)
!~          trans_dipole(2,1)=0.2_idp
!~          trans_dipole(3,1)=-(1.4_idp  +1.2*eye)        
         
         
         if (no_states .eq. 2) then
            trans_dipole(1,2)=0.24_idp +eye*2
            trans_dipole(2,2)=0.8_idp
            trans_dipole(3,2)=0.34_idp +eye*2 

!     h2o2 dipoles staet 5 (faked)
!     ---------------------------            
            trans_dipole(1,2)=  0.03 - eye*0.05
            trans_dipole(2,2)=  0.0494886
            trans_dipole(3,2)= -0.03 - eye*0.05

!~             trans_dipole(1,2)=0.34_idp -0.24*eye
!~             trans_dipole(2,2)=0.8_idp
!~             trans_dipole(3,2)=-(0.34_idp + 0.24*eye)             
            
            
            if (bound_transition_parallel) then
               trans_dipole(1,2)=0.14_idp !+0.1*eye*2
               trans_dipole(2,2)=0.02_idp
               trans_dipole(3,2)=0.12_idp !+0.1*eye*2             
            
            end if        
         end if
         
      else      
         trans_dipole(1,1)=1.4_idp  !+eye*2
         trans_dipole(2,1)=0.2_idp
         trans_dipole(3,1)=1.4_idp  !+eye*2
         
         if (no_states .eq. 2) then
            trans_dipole(1,2)=0.34_idp !+eye*2
            trans_dipole(2,2)=0.8_idp
            trans_dipole(3,2)=0.34_idp !+eye*2         
         end if         
         
         
      end if   
      

      
      end subroutine make_dummy_dipoles
      
!     ****************************************     
!     Dipole part 
!     ****************************************
      complex(kind=idp) function dipole_part(trans_dipole, photo_dipole,iint_state,jint_state,itarg,ienergy,&
     &                                       p1,q1,q1p, r,rp,q2,q2p, l,m,lp,mp, Ke,Me,Mep)
      implicit none
!     Arguments
      integer :: iint_state,jint_state,itarg,ienergy, p1,q1,q1p, r,rp,q2,q2p,l,m,lp,mp, Ke,Me,Mep          
      complex(kind=idp) :: trans_dipole(:,:), photo_dipole(:,:,:,:,:)
      
      integer :: ipw,jpw 
      
      ipw=lm2i(l,m)
      jpw=lm2i(lp,mp)
      
!~       no_energies=size(photo_dipole,3)
!~       no_targ_states=size(photo_dipole,4)
      
      dipole_part=photo_dipole(ipw,q2+2,ienergy,itarg,iint_state)*conjg(photo_dipole(jpw,q2p+2,ienergy,itarg,jint_state))*trans_dipole(q1+2,iint_state)*conjg(trans_dipole(q1p+2,jint_state))*eye**(lp-l)
 
      dipole_part=dipole_part*(-1)**(mp+Mep)*sqrt(( 2._idp*l+1._idp)*(2._idp*lp+1._idp)*(2._idp*Ke+1._idp)/(4._idp*pi) )
 
      dipole_part=dipole_part*threej(2*l,2*m,2*lp,-2*mp,2*Ke,-2*Mep)*threej(2*l,0,2*lp,0,2*Ke,0)
      
      end function dipole_part
!     ****************************************
!     Gamma part to be orientationaly averaged
!     ****************************************
      complex(kind=idp) function gamma_part(gamm,q1,q1p,q2,q2p,Mep)
      implicit none
      integer :: q1,q1p,q2,q2p,Mep
      real(kind=idp) :: gamm
      
      gamma_part=exp(-eye*(q1p-q1p+q2p-q2+Mep)*gamm)
         
      end function gamma_part
!     ****************************************
!     Beta part to be orientationaly averaged
!     ****************************************
      real(kind=idp) function beta_part(beta, p1,q1,q1p, r,rp,q2,q2p, Ke,Me,Mep)
      implicit none
      integer :: p1, q1,q1p, r,rp,q2,q2p, Ke, Me, Mep
      real(kind=idp) :: beta
      
      beta_part=red_rot_mat(beta, 1,p1,q1)*red_rot_mat(beta, 1,p1,q1p)*red_rot_mat(beta, 1,r,q2)*red_rot_mat(beta,1,rp,q2p)*red_rot_mat(beta,Ke,Me,Mep)
      
      end function beta_part
!     ****************************************
!     Alpha part to be orientationaly averaged
!     ****************************************
      complex(kind=idp) function alpha_part(alpha,r,rp,Me)
      implicit none
      integer :: r,rp,Me
      real(kind=idp) :: alpha
           
      alpha_part=exp(-eye*(rp-r+Me)*alpha)
      
      end function alpha_part
!     ****************************************
!     Does the angular averaging for a summand
!     ****************************************
      complex(kind=idp) function angular_average_summand(a_grid,b_grid,g_grid, p1,q1,q1p, r,rp,q2,q2p, Ke,Me,Mep)
      implicit none
!     Arguments      
      integer :: p1,q1,q1p, r,rp,q2,q2p, Ke,Me,Mep
      real(kind=idp) :: a_grid(:), b_grid(:), g_grid(:)

!     Local
      integer :: no_alpha_points, no_beta_points, no_gamma_points, ialpha, ibeta, igamma      
      real(kind=idp) :: beta_avg, d_alpha, d_beta, d_gamma
      complex(kind=idp) :: alpha_avg, gamma_avg
      
      !no_alpha_points=size(a_grid)
      no_beta_points=size(b_grid)
      !no_gamma_points=size(g_grid)
      
      !d_alpha=(a_grid(2)-a_grid(1))*1._idp/(2._idp*pi)
      d_beta=(b_grid(2)-b_grid(1))*0.5
      !d_gamma=g_grid(2)-g_grid(1)*1._idp/(2._idp*pi)
      
      alpha_avg=0
      if((rp-r+Me).eq.0) then
         alpha_avg=1
      end if
      
      beta_avg=0._idp
      do ibeta=1,no_beta_points
         beta_avg=beta_avg+beta_part(b_grid(ibeta), p1,q1,q1p, r,rp,q2,q2p, Ke,Me,Mep)*sin(b_grid(ibeta))*d_beta
         
      end do      
      
      gamma_avg=0
      if ((q1p-q1+q2p-q2+Mep) .eq. 0)then
         gamma_avg=1
      end if

      angular_average_summand=alpha_avg*beta_avg*gamma_avg

      end function angular_average_summand
!     ************************
!     Main driving routine
!     ************************      
      subroutine chiral_drv()
      implicit none
      
!     Local
      integer :: p1,q1,q1p, r,rp,q2,q2p, Ke,Me,Mep, l,m,lp,mp, ipw, jpw
      integer :: no_theta_points, nt, no_phi_points, np, no_alpha_points, na, no_beta_points, nb, &
     &           no_gamma_points, ng,no_scattering_angles, no_euler, no_partial_waves, &
     &           no_intermediate_states, no_targ_states, no_scattering_energies, iint_state, jint_state, itarg, ienergy 
      complex(kind=idp), allocatable ::photo_dipole(:,:,:,:,:),trans_dipole(:,:)
      logical :: bound_transition_chiral, continuum_transition_chiral
      character(len=1) :: p2 
                  
!     Namelist variables      
      integer :: max_lcontinuum, ngrdproj(2), ngrdalign(3)
      real(kind=idp) :: euler_angle_limits(6),scat_angle_limits(4)
      real(kind=idp), allocatable, dimension(:) :: th_grid, ph_grid, a_grid, b_grid, g_grid
      complex(kind=idp) :: test_sum  
             
      namelist /CHIRALINP/ &
     &                    max_lcontinuum,&
     &                    ngrdproj,&
     &                    ngrdalign,&
     &                    euler_angle_limits,&
     &                    scat_angle_limits   


!     Namelist defaults
!     -----------------
      max_lcontinuum=2 
      ngrdproj=(/ 1,1 /)
      ngrdalign=(/ 2,51,2 /)
      euler_angle_limits=(/ 0._idp,0._idp,0._idp,360._idp,180._idp,360._idp /)
      scat_angle_limits=(/ 0._idp,0._idp,180._idp,360._idp /)

!     Some user input (for the moment)
!     --------------------------------

      no_scattering_energies=1
      no_targ_states=1 
      itarg=1
      ienergy=1      


          
      no_intermediate_states=2 
      iint_state=1
      jint_state=1      
!~       bound_transition_chiral = .true.
!~       continuum_transition_chiral = .true.
      bound_transition_chiral = .false.
      continuum_transition_chiral = .false.
      p2='x'
      p1=-1

!~       Me=2
!~       q1=0
!~       q1p=0


      
!     Read name list (to be implemented)
!     ----------------------------------

      euler_angle_limits=euler_angle_limits*pi/180._idp
      scat_angle_limits=scat_angle_limits*pi/180._idp

!     Read dipoles (to be implemented)
!     --------------------------------
      !allocate(photo_dipole_i(3,no_partial_waves),photo_dipole_ip(3,no_partial_waves))
      no_partial_waves=(max_lcontinuum+1)**2     
      allocate(trans_dipole(3,no_intermediate_states))
      allocate(photo_dipole(no_partial_waves,3,no_scattering_energies,no_targ_states,no_intermediate_states))      
      photo_dipole=0;  trans_dipole=0



      
      call make_dummy_dipoles(trans_dipole, photo_dipole, max_lcontinuum, bound_transition_chiral, &
     &                        continuum_transition_chiral, no_intermediate_states)

      
!     Construct angular grids.
!     ------------------------------------------------------------------
      nt=ngrdproj(1); np=ngrdproj(2)
      na= ngrdalign(1); nb=ngrdalign(2); ng=ngrdalign(3)

      no_scattering_angles=nt*np
      no_euler=na*nb*ng

      no_theta_points = nt
      no_phi_points   = np
      no_alpha_points = na
      no_beta_points  = nb
      no_gamma_points = ng
      
      write(6,'("Euler grid (alpha,beta,gamma) = ", 3i5)') na,nb,ng
      write(6,'("Photoelectron grid (theta,phi) = ", 2i5)') nt,np
      
      allocate(th_grid(nt),ph_grid(np),a_grid(na),b_grid(nb),g_grid(ng))
      th_grid=0._idp;ph_grid=0._idp;a_grid=0._idp;b_grid=0._idp;g_grid=0._idp


      call grid_theta_phi(th_grid,ph_grid,scat_angle_limits)
      call grid_euler(a_grid,b_grid,g_grid,euler_angle_limits)


!     Calculate oscillator strength
!     -----------------------------
      
      do Ke=0,4
      do Me=-Ke, Ke
      if ( .not. ((abs(Me) .eq. 0) .or. (abs(Me).eq. 2))) cycle
      test_sum=0
      do iint_state=1,no_intermediate_states
      do jint_state=1,no_intermediate_states
      
      do q1=-1,1
      do q1p=-1,1
      do l=0,max_lcontinuum
         do m=-l,l
            do lp=0,max_lcontinuum
               do mp=-lp,lp
                  Mep=m-mp
                  do q2=-1,1
                     do q2p=-1,1           
                        do r=-1,1
                           do rp=-1,1
                              !if ( (abs(r).eq. 1) .and. (abs(rp) .eq.1) ) then !x-polarized light
                              !if ( (r.eq. 0) .and. (rp .eq.0) ) then !z-polarized light
                              if (lab_2nd_photon_polarization(r,rp,p2) .ne. 0) then
                                 test_sum=test_sum+dipole_part(trans_dipole, photo_dipole, iint_state, jint_state, itarg, ienergy,&
     &                                                p1,q1,q1p, r,rp,q2,q2p, l,m,lp,mp, Ke,Me,Mep) &
     &                                            *angular_average_summand(a_grid,b_grid,g_grid, &
     &                                                p1,q1,q1p, r,rp,q2,q2p, Ke,Me,Mep)*lab_2nd_photon_polarization(r,rp,p2)*0.5_idp
                                 
                              end if
                           end do
                        end do
                     end do
                  end do
               end do
            end do
         end do
      end do
      end do
      end do

      end do
      end do
      write(6,'(2i3, 2D20.5)') Ke, Me, test_sum
      end do
      end do
      
      end subroutine chiral_drv

      integer function lab_2nd_photon_polarization(r,rp,p2)
      integer :: r, rp
      character(len=1) :: p2   
      
      lab_2nd_photon_polarization=0
      
      if (p2 .eq. 'x') then
         if ( (abs(r).eq. 1) .and. (abs(rp) .eq.1) ) then
            lab_2nd_photon_polarization=1
            if (sign(1,r) .ne. sign(1,rp)) lab_2nd_photon_polarization=-1
         end if   
      else if (p2 .eq. 'z') then      
         if ( (r.eq. 0) .and. (rp .eq.0) ) lab_2nd_photon_polarization=-2
      end if

      end function lab_2nd_photon_polarization

      end module chiral_procs
