Readme
======

Photoionization observables

Introduction
------------

Dipelm calculates:

 * Photoionization cross sections and asymmetry paramters for randomly oriented molecules.
 * Molecular frame photoionization dipoles (MFDip) and photoelectron angular distributions (MFPAD).
 * Lab frame photoionization dipoles (LFDip) and photoelectron angular distributions (LFPAD). 

Documentation
-------------

To generate the documentation run the following from the UKRmol-out directory

    cd source/dipelm/doc
    doxygen Doxyfile 

which creates the documentation in a subfolder html/. 
The documentation can then be read by pointing a browser at html/index.html

Input
-----

### File input

Dipelm takes partial wave transition moments produced by rsolve (in the routine comppwd) as input

### Namelist Input

Dipelm has one required namelist, DIPELMINP, and two optional namelists SMOOTH and ORIENT.

DIPELMINP controls input file data. 
One can also select a subset of states for randomly oriented molecule observables (default behaviour 
is to use all states).

SMOOTH controls smoothing of the partial wave dipoles prior to calculation of observables. This can 
be useful if one wants to remove narrow unphysical pseudoresonances (narrow real resonances will 
also be removed). For dense energy grids and many partial wave channels this can take some time.
Only the subset of states chosen in DIPELMINP will be smoothed.

ORIENT controls calculation of oriented observables. Default behaviour is to calculate the molecular 
frame photoionization dipoles and angular distributions, which are resolved in initial and final 
state, photon energy, and photoelectron direction. On request, lab frame dipoles and angular 
distributions for a range of orientations will be calculated. File sizes can quickly become very 
large with this last option,  so some restraint with the angular grids 
(alpha, beta, gamma, theta, phi) must be shown.

For specification of all namelist variables see the documentation (recommended), alternatively it is 
clearly described in the source code. For DIPELMINP see dipelm_procs::dipelm_drv().
For SMOOTH see dipelm_smooth::gaussian_smooth(). For ORIENT see see dipelm_procs::oriented_observables.

Output
------

All output files containing observables are prepended with photo_

### Randomly oriented molecules
    
By default the output files generated are:
     
 * photo_total_xsec: Total photoionization cross section for all neutral states. 
 * photo_xsec: Partial photoionization cross sections for all pairs of ion and neutral states
 * photo_beta_1c: Dichroic parameter (circular polarization) for all pairs of ion and neutral states
 * photo_beta_2l: Asymmetry parameter (linear polarization) for all pairs of ion and neutral states
 * photo_beta_2c: Asymmetry parameter (circular polarization) for all pairs of ion and neutral states
 
The first column is the photon energy (eV), following columns correspond to the observable in 
question for each ion state (in energy order by default) for ion state resolved observables. 
Each neutral state starts a new block, again in energy order.
     
Optionally, each state pair can be output to a seperate file, in this case the file names above
are appended with _ion_state_i_neutral_state_j, where i and j index the ion and neutral states
respectively (in energy order by default). Each file then consists of two columns, the photon energy and
the observable. photo_total_xsec is appended with only _neutral_state_j.

### Oriented molecules

If oriented observables are calculated,  the output files generated are:
     
 * photo_MFPAD_ion_state_i_neutral_state_j: The MFPAD (default)
 * photo_MFDip_ion_state_i_neutral_state_j: The MFDip (optional)
 * photo_LFPAD_ion_state_i_neutral_state_j: The LFPAD (optional)
 * photo_LFDip_ion_state_i_neutral_state_j: The LFDip (optional)

Currently the y, z, and x cartesian components of the dipoles are output in the dipoles files (in that order).
These correspond to y, z and x linearly polarized light directions in the PAD files.
Circular polarization is not currently implemented (but will be in a future release).
If it is required it can be obtained by post-processing of the dipole files to transform the cartesian
components to the spherical basis, then taking the modulus squared and multiplying by the photon
energy dependent coefficient (see dipole_procs::calculate_MFPAD). Photon energy is in Hartree, in 
contrast to randomly oriented molecule observables.

The files are in binary stream format, to read and plot them see the following:

[Python read and plot example](python_read.html)
