# Load test ADMs from .mat files.
# Code adapted from N2 case, https://epsproc.readthedocs.io/en/latest/methods/geometric_method_dev_pt3_AFBLM_090620_010920_dev_bk100920.html#Test-compared-to-experimental-N2-AF-results...
#
# To check individual file contents just use `loadmat(file)`
# 
import os 
import numpy as np
# Function for grabbing files or scanning dir for files.
# Note raw string for docstring as one method of keeping raw string in example.
def getFiles(fileIn = None, fileBase = None, fType = '.out', verbose = True):
    r"""
    Read ePS file(s) and return results as Xarray data structures.
    File endings specified by fType, default .out.

    Parameters
    ----------
    fileIn : str, list of strs, optional.
        File(s) to read (file in working dir, or full path).
        Defaults to current working dir if only a file name is supplied.
        For consistent results, pass raw strings, e.g.
        ``fileIn = r"C:\share\code\ePSproc\python_dev\no2_demo_ePS.out"``

    fileBase : str, optional.
        Dir to scan for files.
        Currently only accepts a single dir.
        Defaults to current working dir if no other parameters are passed.

    fType : str, optional
        File ending for ePS output files, default '.out'

    verbose : bool, optional
        Print output details, default True.


    Returns
    -------
    list
        List of Xarray data arrays, containing matrix elements etc. from each file scanned.


    """


    currDir = os.getcwd()

    if fileBase is None:
        fileBase = currDir

    if fileIn is not None:
        # Wrap in list if only single file passed
        if type(fileIn) is not list:
            fileIn = [fileIn]

        fList = []
        for file in fileIn:
            # Check file & path are valid
            fTest = os.path.split(file)
            if not fTest[0]:
                fList.append(os.path.join(currDir, file))
            else:
                fList.append(file)

        # Display message
        if verbose:
            print('\n*** Scanning file(s)')
            print(fList)

    else:
        # Filenames only
        # fList = [f for f in os.listdir(fileBase) if f.endswith(fType)]
        # With full path
        fList = [os.path.join(fileBase, f) for f in os.listdir(fileBase) if f.endswith(fType)]

        # Display message
        if verbose:
            print('\n*** Scanning dir')
            print(fileBase)
            print('Found {0} {1} file(s)\n'.format(len(fList), fType))

    return fList
ADMtype = 'dat'
ADMscaleFactor = 1  # Try quick SF to circumvent thresholding issues in current code - should be renormed out in final Blms
                     # Tested for 100 - still some weird stuff happening, although very different weird stuff!
                     # 10 maybe a bit better? Or 2...?
                     # May also be issue with complex form for ADMs...? Testing setting real part only later

from scipy.io import loadmat
from pathlib import Path
#import epsproc as ep

if ADMtype == 'mat':

    # Original ADMs 14/01/22 - matlab files
    ADMdataDir = Path('/home/masiz4am/molecules/OCS/alignment_VM_28K_4p2TW_070722')
    renorm = True  # Additional renormalisation by (2*K+1)/8*pi^2
    
else:
    # Updated ADMs from dat files
    # Note these are also Matlab hdf5, but different var labels.
    ADMdataDir = Path('/home/masiz4am/molecules/OCS/alignment_VM_28K_4p2TW_070722')
    renorm = False  # Additional renormalisation by (2*K+1)/8*pi^2
    
fList = getFiles(fileBase =  ADMdataDir.expanduser(), fType='.'+ADMtype)

ADMs = []
ADMLabels = []

for f in fList:
    
    if ADMtype == 'mat':
        item = Path(f).name.rstrip('ocs.mat')  # Get & set variable name

    else:
        item = Path(f).name.split('_')[0]  # Get & set variable name
    
        
    if item == 'time':
        if ADMtype == 'mat':
            item = 'timeocs'
            
        t = loadmat(f)[item][0,:]
        print("time")
        print(t)
        with open('time.txt', 'w', encoding="utf-8") as f:
            for i in range(len(t[:])):
                val = str(i)+' '+str(t[i])
                f.write(val+'\n')

        f.close()
        
    elif item == 'c2t':
        c2t = loadmat(f)[item][:,0]
        
    else:
        # Should use re herer!
        if ADMtype == 'mat':
            K = int(item.strip('D'))
            item = item + 'ave'
        else:
#             try:
            K = int(item.strip('A')[0])
#             except:
#                 pass   # For now just skip cos^2 t term
            

#         ADMs.append(np.asarray([K,0,0,loadmat(f)[item][:,0]]))
#         ADMs.append([K,0,0,loadmat(f)[item][:,0]])
#         ADMs.append(loadmat(f)[item][:,0])
        ADMs.append(loadmat(f)[item][:,0]*ADMscaleFactor)
        ADMLabels.append([K,0,0])

#print(len(ADMs))
#print(*ADMs)        

# Add K = 0 (population) term?
# NOTE - may need additional renorm?
addPop = True
if addPop:
    if renorm:
        ADMs.append(np.ones(t.size) * np.sqrt(4*np.pi))
    else:
#         ADMs.append(np.ones(t.size))  # * np.sqrt(4*np.pi))
        ADMs.append(np.ones(t.size) * 1/(8*np.pi**2))
        
    ADMLabels.append([0,0,0])
        
ADMLabels = np.array(ADMLabels)

#ZM: write the results in format expected by DIPELM
print("writing ADM_KQ.inp")
with open('ADM_KQ.inp', 'w', encoding="utf-8") as f:

    print(len(ADMs[0]), len(ADMLabels))
    val = str(len(ADMs[0]))+' '+str(len(ADMLabels))
    f.write(val+'\n')
    for x in ADMLabels:
        print(x[0],"0")
        val = str(x[0])+" 0\n"
        f.write(val)

    #real part of A_KQ
    for x in range(len(ADMs)):
        print(np.real(ADMs[x][:]))
        for i in range(len(ADMs[x][:])):
            val = str(np.real(ADMs[x][i]))
            f.write(val+' ')
        f.write('\n')

    #imaginary part of A_KQ
    for x in range(len(ADMs)):
        print(np.imag(ADMs[x][:]))
        for i in range(len(ADMs[x][:])):
            val = str(np.imag(ADMs[x][i]))
            f.write(val+' ')
        f.write('\n')

    f.close()
