! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE WRITSH(LUSCT,NSSET,SFORM,TITLE,MGVN,STOT,GUTOT,NCHAN,
     1ICHL,LVCHL,MVCHL,EVCHL,NSTAT,NSCAT,nesc,RR,IPRNT,IWRITE,IFAIL)
C
C**********************************************************************
C    WRITSH  writes header of Scattering Coefficients(SC) file on unit 
C    LUSCT.
C     If NSSET=1 on input then SC are written as first set,
C              0 then written at end of information (eoi).
C     On output NSSET holds the actual set number
C**********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER STOT,GUTOT
      CHARACTER(LEN=11)  SFORM
      CHARACTER(LEN=80)  TITLE
      DIMENSION ichl(nchan),LVCHL(nchan),MVCHL(nchan),EVCHL(nchan)
      DATA KEYSC/88/ !Find out if there is a convention for this
      SAVE
C
C     position file at eoi or end of set number NSSET
      NSET=NSSET
      CALL GETSET(LUSCT,NSET,KEYSC,SFORM,IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(IWRITE,666)NSSET,LUSCT
        RETURN
      ENDIF
      IF(NSSET.NE.1)  NSET=NSET+1
      WRITE(IWRITE,16) NSET,LUSCT
      NSSET=NSET
      NINFO = 3
C
C  write header
      IF(SFORM.EQ.'FORMATTED')  THEN
         TEMP=dble(NSTAT+2)/10.0d0 ! need to change
         NDATA1=(NSTAT+2)/10
         IF (TEMP.GT.NDATA1) NDATA1=NDATA1+1
         TEMP=dble(NCHAN)/10.0d0
         NDATA2=NCHAN/10
         IF (TEMP.GT.NDATA2) NDATA2=NDATA2+1
         NDATA = (NDATA1+NDATA2)*NSCAT
         NREC = NDATA+NINFO
         WRITE(LUSCT,10) KEYSC,NSET,NREC,NINFO,NDATA
         WRITE(LUSCT,13) TITLE
         WRITE(LUSCT,10) NSCAT,MGVN,STOT,GUTOT,NSTAT,NCHAN,nesc
         WRITE(LUSCT,11) RR
      ELSE
         NDATA = NSCAT*2 ! need to change
         NREC = NINFO+NDATA
         WRITE(LUSCT) KEYSC,NSET,NREC,NINFO,NDATA
         WRITE(LUSCT) TITLE
         WRITE(LUSCT) NSCAT,MGVN,STOT,GUTOT,NSTAT,NCHAN,nesc
         WRITE(LUSCT) RR
         write(lusct) ichl, lvchl, mvchl, evchl
c         write(lusct) (ICHL(i), i=1,nchan)
c         write(lusct) (LVCHL(i), i=1,nchan)
c         write(lusct) (MVCHL(i), i=1,nchan)
c         write(lusct) (EVCHL(i), i=1,nchan)
      ENDIF
C
      IF(IPRNT.NE.0)  THEN
         WRITE(IWRITE,14)
         WRITE(IWRITE,100) KEYSC,NSET,NREC,NINFO,NDATA
         WRITE(IWRITE,130) TITLE
         WRITE(IWRITE,100) NSCAT,MGVN,STOT,GUTOT,NSTAT,NCHAN,nesc
         WRITE(IWRITE,101) RR
         DO I=1,NCHAN
            WRITE(IWRITE,140) ICHL(i),LVCHL(i),MVCHL(i),EVCHL(i)
         END DO
      ENDIF
C
      RETURN
  10  FORMAT(10I5)
  11  FORMAT(10F20.13)
  13  FORMAT(A80)
 14   FORMAT(/' Header on LUSCT')
  100 FORMAT(1X,10I5)
  101 FORMAT(1X,10F20.6)
  130 FORMAT(1X,A80)
  140  FORMAT(3I7, F20.10)
  666 FORMAT(/' UNABLE TO FIND SCATTERING STATE SET ',I0,' ON UNIT ',I0)
  16  FORMAT(/' Scattering state coefficients will be written to set ',
     1I0,' on unit ',I0)
      END
