! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE WRITSC(LUSCT,SFORM,ESCAT,NCHAN,NSTAT,NESC,AR,AI)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      INTEGER LUSCT,NCHAN,NSTAT, NESC
      CHARACTER(LEN=11) SFORM
      DIMENSION AR(NSTAT,nchan,nesc), AI(NSTAT,nchan,nesc)
      DIMENSION escat(nesc)
      integer I,K,n

      if (SFORM.EQ.'FORMATTED')THEN
      do n=1,NESC
        do I = 1,nchan
          WRITE(LUSCT,101) ESCAT(n),I
          WRITE(LUSCT,103) (AR(K,I,n),K=1,NSTAT)
          WRITE(LUSCT,102) ESCAT(n),I
          WRITE(LUSCT,103) (AI(K,I,n),K=1,NSTAT)
        end do
      end do
      else
      do n=1,NESC
        do I=1,nchan
          WRITE(LUSCT) ESCAT(n),I,(AR(K,I,n),K=1,NSTAT)
          WRITE(LUSCT) ESCAT(n),I,(AI(K,I,n),K=1,NSTAT)
        end do
      end do
      endif
      
      RETURN
c
 101  FORMAT(F20.10,I5,'   Real Part')
 102  FORMAT(F20.10,I5,'   Imaginary Part')
 103  FORMAT(10F20.13)
 104  FORMAT(/'Energy ',F12.8,' is too close to R-matrix pole',I3)

      END
