! Copyright 2019
!
! Modified by Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE R_SOLVE_COMPAK(ifail)
      USE photo_outerio, ONLY: read_transdip2, idp, writsh, writsc, 
     *                         write_pw_dipoles
      USE compak_procs, ONLY: compak
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES, EXCEPT
C     VIBINI 
C
      PARAMETER (MAXPTS=30,MAXTGT=500,MAXENR=10)
C
C     MAXPTS = MAXIMUM NUMBER OF GEOMETRIES
C     MAXTGT = MAXIMUM NUMBER OF TARGET ELECTRONIC STATES
C     MAXENR = MAXIMUM NUMBER OF INPUT SCATTERING ENERGY PAIRS (E0,DE)
C
      CHARACTER(LEN=80) NAME
      CHARACTER(LEN=11) RFORM,CHFORM,WFORM,KFORM,NRFORM,VCFORM,MODDAT
      CHARACTER(LEN=11) sform, form_pw_dipoles  ! -AlexH
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=1) IRFORM,ICFORM,IWFORM,IKFORM,INRFRM,IVCFRM
      CHARACTER(LEN=3) EUNIT(2)
      CHARACTER BLANK*8, daytim*20
      INTEGER STOT,GUTOT 
      INTEGER calcak, calcdip(3),lu_inner_dipoles, nset_lu_inner_dipoles,
     *        lu_pw_dipoles, nset_pw_dipoles, nstat_dip, maxprop,
     *        lmax_property, phase_correction, lu_pw_dipoles_cmplx
      double precision :: smooth !AlexH 2012
      integer LUSCT,NSSET !-AlexH 17/11/10cd
      DIMENSION RK(MAXPTS+4),R(MAXPTS),IPRNT(6),ezero(maxpts),
     3 EINC(2,MAXENR),NESCAT(MAXENR),NVTARG(MAXTGT),EINR(2,MAXENR),
     5 NCHSET(MAXPTS),NRMSET(MAXPTS),ivt0(2),ivu0(2),vec(1)
      integer, allocatable :: ichord(:),ivtarg(:),ivnu(:),starg(:),
     * gtarg(:),mtarg(:),ivchl(:),lvchl(:),mvchl(:),ichl(:),ncsf(:),
     * dip_comp_present(:)
      double precision, allocatable :: rvib(:),rmn(:),fx(:),fxp(:),
     * akmat(:),rres(:),ampn(:),eign(:),cf(:),evib(:),etarg(:),
     * vibfn(:),rquad(:),qwts(:),evchl(:),epole(:),wamp(:),butc(:),
     * adm(:),fv(:),fvp(:),fd(:),fdp(:),crv(:),crd(:),bloch(:),
     * amc(:),adc(:),sfac(:),ecex(:),rcex(:), fkmat(:), !fkmat AlexH 11.11.10
     * ar(:,:,:), ai(:,:,:),ar_temp(:,:), ai_temp(:,:), rvib2(:), !AlexH 17/11/10
     * y_arr(:),dy_arr(:),ar_temp2(:,:,:), ai_temp2(:,:,:),
     * escat(:),escat_temp2(:), fkmat_temp(:),fkmat_temp2(:),
     * fx_test(:),fxp_test(:),akmat_test(:),ampae(:,:) !ZM added ampae
      real(kind=idp), allocatable :: inner_dipoles_temp(:,:,:), 
     *                               inner_dipoles(:,:,:), 
     *                               re_pw_dipoles_temp(:,:,:),
     *                               im_pw_dipoles_temp(:,:,:),
     *                               re_pw_dipoles(:,:,:,:),
     *                               im_pw_dipoles(:,:,:,:),
     *                               bound_state_energies(:)     
      real(kind=16), allocatable :: rmat_quad(:) !AH
      double precision :: dum, dum1(1), dum2(1,1), knots
      logical :: QMOLN, ukrmolp_ints
      
      double precision :: test !AH
      EXTERNAL POTL_compak,DISPOT_compak
C
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /RSLVIN/
C     OTHER DATA IS INPUT VIA NAMELISTS IN ROUTINES VIBINI AND ASYM1
C
C      BBLOCH   = COEFFICIENT IN ELECTRONIC BLOCH OPERATOR
C      BIGB     = COEFFICIENT IN NUCLEAR BLOCH OPERATOR
C      EINC     = Scattering energies relative to lowest (vibrational)
C                 level of target 
C                 EINC(1,I) = initial energy in sub range I
C                 EINC(2,I) = energy increment in this subrange
C                 units are as specified by IEUNIT
C      GUTOT    = G/U SYMMETRY OF TOTAL SYSTEM +1=G, -1=U
C      ICFORM   = Formatted/unformatted switch for unit LUCHAN
C      IEUNIT   = UNITS IN WHICH INPUT SCATTERING ENERGIES ARE INPUT
C                 1= RYD, 2= EV
C      IKFORM   = Formatted/unformatted switch for unit LUKMT
C      IKTYPE   = Write open-open subset of K-matrix (= 0) or full (= 1)
C      INRFRM   = Formatted/unformatted switch for unit LUNRMT
C      IPRNT    = DEBUG PRINT SWITCHES
C                 (1) =1 Print all input data
C                 (2) =1 Print vibrational wavefuction data
C                 (3) =1 Debug output in dissociating channels
C                 (4)  not used
C                 (5) =1 Print R-matrices
C                 (6) =1 Print all output data
C      IRFORM   = Formatted/unformatted switch for unit LURMT
C      ISMAX    = Highest multipole to be used in asymptotic expansion
C                 of asymptotic potentials
C      IWFORM   = Formatted/unformatted switch for unit LUWFN
C      IWRITE   = Logical unit for printed output
C      LUCHAN   = Logical unit holding fixed nuclei channel and target 
C                 data
C      LUKMT    = LOGICAL UNIT FOR K-MATRIX OUTPUT 
C      LUWFN    = Logical unit for R-matrix and wavefunction output
C      LUNRMT   = Logical unit holding non adiabatic R-matrix data
C      LURMT    = Logical unit holding fixed nuclei R-matrix data
C      LUVCHN   = Logical unit holding vibrational/dissociating
C                 channel data
C      LUSCT      = Logical unit for A_k coefficient -AlexH 17/11/10
C      MDMAX    = maximum multipole to be retained in expansion of
C                 asymptotic internuclear (dissociation) potential
C      MGVN     = TOTAL SYMMETRY OF SYSTEM
C      NAME     = TITLE FOR OUTPUT
C      NCHSET   = Set numbers for input fixed nuclei channel/target
C                 data for each geometry
C      NDIS     = NUMBER OF DISSOCIATING CHANNELS
C      NERANG   = Number of subranges of scattering energies
C      NESCAT   = NUMBER OF INPUT SCATTERING ENERGIES in each subrange
C      NEWBUT   = switch on energy parameter in Buttle correction
C      NGEOM    = NUMBER OF GEOMETRIES
C      NKSET    = Set number for output K-matrices 
C      NNRSET   = Set number for input non-adiabatic R-matrix data
C      NPOLE    = NUMBER OF ELECTRONIC R-MATRIX POLES TO BE TREATED
C                 NON-ADIABATICALLY
C      NRMSET   = Set numbers for input fixed nuclei R-matrix data for
C                 each geometry
C      NRQUAD   = NUMBER OF QUADRATURE POINTS FOR INTEGRALS IN ADIABATIC
C                 APPROXIMATION ( IF =0 THEN CODE DECIDES)
C      NVCHSET  = Set number for input vibrational/dissociating channel
C                 data
C      NVTARG   = NUMBER OF VIBRATIONAL LEVELS FOR EACH TARGET STATE
C      NWSET    = Set number for output R-matrices and wavefunctions
C      R        = ARRAY HOLDING INTERNUCLEAR SEPARATIONS
C      STOT     = SPIN MULTIPLICITY 2*S+1 WHERE S = TOTAL SPIN OF SYSTEM
C
      NAMELIST/RSLVIN/LUCHAN,LURMT,LUVCHN,LUNRMT,LUKMT,LUWFN,NPOLE,NDIS,
     1                BBLOCH,BIGB,NGEOM,R,IWRITE,ISMAX,NAME,NESCAT,EINC,
     *                IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NKSET,NRQUAD,
     3                ICFORM,IRFORM,IVCFRM,INRFRM,IKFORM,NERANG,NWSET,
     4                MGVN,STOT,GUTOT,IEUNIT,NVTARG,MDMAX,IWFORM,NLPOLE,
     *                nbigset,newbut,CALCAK,calcdip,smooth,IKTYPE,
     5                lusct, nsset, sform, ifprop2,poleprox,!-AlexH 17/11/10
     6          lu_inner_dipoles,nset_lu_inner_dipoles, lmax_property,
     7          lu_pw_dipoles, nset_lu_pw_dipoles, form_pw_dipoles,
     8          QMOLN, ukrmolp_ints, lu_pw_dipoles_cmplx
C
C***********************************************************************
C
      DATA IREAD,IWRITE,LUCHAN,LURMT,LUKMT,LUWFN/5,6,10,21,19,0/,
     1 LUVCHN,LUNRMT/28,29/,IPRNT/6*0/,NERANG/1/,IEUNIT/1/,newbut/1/,
     2 NKNOT/0/,IVPROP/1/,IDPROP/1/,NPOLE/0/,NVIB/0/,NDIS/0/,LUSCT/88/,
     3 EINC/MAXENR*0.D0,MAXENR*0.D0/,NVCSET,NNRSET,NKSET,NWSET/4*1/,
     4 ISMAX/-1/,BBLOCH,BIGB/2*0.D0/,NVTARG/MAXTGT*1/,NRQUAD/0/,NGEOM/1/
     5,NESCAT/MAXENR*10/,NLPOLE/1/,nbigset/1/,CALCAK/0/,QMOLN/.False./,
     6 NSSET/1/, ifprop2/1/,smooth/0.0/,IKTYPE/0/
      DATA ZERO/0.D0/,HALF/0.5D0/,ONE/1.D0/,TWO/2.D0/,NCOL/6/,MDMAX/-1/
      DATA FORM,CHFORM,RFORM,VCFORM,NRFORM,KFORM,WFORM/7*'FORMATTED'/
     1,ICFORM,IRFORM,IVCFRM,INRFRM,IKFORM,IWFORM/6*'U'/,poleprox/0.D0/
      DATA EUNIT/'RYD','EV'/,RYD/0.073500D0/,BLANK/'        '/
      DATA IBACK/1/
      DATA MODDAT/'05-Jan-2004'/
      DATA sform/'UNFORMATTED'/ ! AlexH 17/11/10
      DATA form_pw_dipoles/'UNFORMATTED'/ ! AlexH 
      DATA ukrmolp_ints/.false./ !ZM
      
      lu_inner_dipoles=624
      nset_lu_inner_dipoles=1
      calcdip=0
      lu_pw_dipoles=142
      lu_pw_dipoles_cmplx=242
      nset_pw_dipoles=1
      lmax_property=1
C
C---- WRITE HEADER
!      WRITE(*,*)
!      WRITE(*,*) ' This is a modified version of the program that'
!      WRITE(*,*) 'allows to automatically propagate inwards or '
!      WRITE(*,*) 'outwards.'
!      WRITE(*,*) ' Modified by Jimena Gorfinkiel.'
C---- SET UP DEFAULT VALUES OF POINTERS NCHSET AND NRMSET 
      DO 111 I=1,MAXPTS
      NCHSET(I) = I
      NRMSET(I) = I
      r(i) = zero
 111  continue
C
      IFAIL = 0
      NEXT = 1
      GUTOT = 0
C
C---- Read basic data via namelist /RSLVIN/
      READ(5,RSLVIN)
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM
      IF(INRFRM.EQ.'U') NRFORM='UN'//FORM
      IF(IKFORM.EQ.'U') KFORM='UN'//FORM
      IF(IWFORM.EQ.'U') WFORM='UN'//FORM
      IF(IVCFRM.EQ.'U') VCFORM='UN'//FORM
C
      IF(NGEOM.GT.MAXPTS) GO TO 96
C
C---- Date stamp run and print title
      CALL DATEST(DAytim)
      NAME(61:) = DAytim
      WRITE(IWRITE,12)MODDAT,NAME,MGVN,STOT,GUTOT
      IF(NGEOM.EQ.1) THEN
        WRITE(IWRITE,20) R(1)
      ELSE
        WRITE(IWRITE,10)NDIS,(R(I),I=1,NGEOM)
      ENDIF
      IF(NCHSET(NGEOM).EQ.0.OR.NRMSET(NGEOM).EQ.0) GO TO 89
      WRITE(IWRITE,11)CHFORM,LUCHAN,(NCHSET(IG),IG=1,NGEOM)
      WRITE(IWRITE,33)RFORM,LURMT,(NRMSET(IG),IG=1,NGEOM)
      IF(NGEOM.GT.1) WRITE(IWRITE,21)VCFORM,LUVCHN,NVCSET,NRFORM,
     1LUNRMT,NNRSET
      WRITE(IWRITE,31)KFORM,LUKMT,NKSET
      IF(LUWFN.NE.0) WRITE(IWRITE,32) WFORM,LUWFN,NWSET
      IF (ukrmolp_ints) then
         WRITE(IWRITE,'(" The dipoles will be multiplied by (-1)**m")')
      endif
C
C---- Calculate total number of scattering energies, NESC and max and 
C     min energies EMIN and EMAX
      EMIN = EINC(1,1)
      EMAX = EMIN
      NESC = 0
      DO 9 IEN=1,NERANG
      NESC = NESC+NESCAT(IEN)
      EMIN = MIN(EMIN,EINC(1,IEN))
      EMAX = MAX(EMAX,EINC(1,IEN)+NESCAT(IEN)*EINC(2,IEN))
 9    CONTINUE
      WRITE(IWRITE,13) NESC,EMIN,EMAX,EUNIT(IEUNIT)
C
C---- Convert scattering energies to Rydbergs
      IF(IEUNIT.EQ.2) THEN
        EMINR = EMIN*RYD
        EMAXR = EMAX*RYD
        DO 36 IEN=1,NERANG
        EINR(1,IEN) = EINC(1,IEN)*RYD
        EINR(2,IEN) = EINC(2,IEN)*RYD
 36     continue
      ELSE
        EMINR = EMIN
        EMAXR = EMAX
        DO 37 IEN=1,NERANG
        EINR(1,IEN) = EINC(1,IEN)
        EINR(2,IEN) = EINC(2,IEN)
 37     continue
      ENDIF
C
C---- Find first fixed-nuclei R-matrix input set and read dimension 
C     information
      WRITE(IWRITE,17)
      CALL READRH(LURMT,NRMSET(nbigset),RFORM,MGVN,STOT,GUTOT,NCHANF,
     1 NVIB0,NDIS0,NTARG,ION,R(1),RMASS,RMATR,NFBUT,ISMX,nstat,NOCSF,
     2 NPLX,ezero(1),iex,IWRITE,IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN
      TWOM = TWO*RMASS
      
      
C
C---- Read header on non-adiabatic R-matrix file
      IF(NGEOM.GT.1) THEN
        WRITE(IWRITE,19)
        CALL READRH(LUNRMT,NNRSET,NRFORM,MGVN,STOT,GUTOT,NCHANS,NVIB,
     1  NDISS,NTARGv,ION,ZERO,RMASS,RMATN,NNBUT,ISMVX,nstat,NHD,
     2  NPVEC,ezero(1),iex,IWRITE,IPRNT(1),IFAIL)
        IF(IFAIL.NE.0) RETURN
        IF(NDISS.NE.NDIS.AND.NDIS.GT.0) THEN
          WRITE(IWRITE,23) NDIS,NDISS
          NDIS = NDISS
        ENDIF
        NCHAN = NCHANS
        RR = ZERO
      ELSE
        NVIB = 0
        NDIS = 0
        NCHAN = NCHANF
        ntargv = ntarg
        RR = R(1)
        ISMVX = ISMX
      ENDIF
      IF(ISMAX.EQ.-1.OR.ISMAX.GT.ISMX) THEN
        ISFMAX = ISMX
      ELSE
        ISFMAX = ISMAX
      ENDIF
      WRITE(IWRITE,34) ISFMAX
      IF(NDIS.NE.0) THEN
        IF(MDMAX.EQ.-1.OR.MDMAX.GT.ISMVX) MDMAX=ISMVX
        WRITE(IWRITE,35) MDMAX
      ENDIF
      ISMAX = MAX(ISFMAX,MDMAX)
C
C---- Assign storage for fixed nuclei data
      ntv = max(ntarg,NTARGv)
      ncf = max(NCHAN,nchanf)
      allocate (etarg(ngeom*ntv),starg(ntv),mtarg(ntv),gtarg(ntv))
      allocate (evchl(ncf),lvchl(ncf),mvchl(ncf),ivchl(ncf))
      allocate (epole(nstat*ngeom),wamp(nstat*NCHANF*NGEOM),
     * ichl(nchanf),butc(3*NCHANF*NGEOM),amc(ISMAX*NCHAN*NCHAN),
     * adc(MDMAX*NDIS*NDIS),adm(5*ndis),cf(ISMAX*ncf*(ncf+1)/2),
     * ncsf(ngeom))
      allocate(rmat_quad(nchan*nchan),akmat_test(nchan*nchan))
      if (abs(nfbut).gt.1) allocate(sfac(nchanf*ngeom),
     * ecex(iex*ngeom),rcex(iex*nchanf*ngeom))
       wamp=0.0d0

C
C---- LOOP OVER GEOMETRIES
      WRITE(IWRITE,17)
      DO 2 IG=1,NGEOM
C
C---- Storage allocation for current geometry
      IG1 = IG-1
      IET = 1+IG1*NTARG
      IEG = 1+IG1*nstat
      IWA = 1+IG1*nstat*NCHANF
      IBUT =1+IG1*3*NCHANF
      isf  =1+IG1*nchanf
      iec  =1+IG1*iex
      irc  =1+IG1*iex*nchanf
C
C
C---- Read target and channel data 
      NCHAN0 = NCHANF
      NTARG0 = NTARG
      CALL READTC(LUCHAN,NCHSET(IG),NCHAN0,NVIB0,NDIS0,NTARG0,ION,IVT0,
     1 IVU0,ICHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,GTARG,etarg(IET:),R(IG),
     * RMASS,CHFORM,IWRITE,IPRNT(1),IFAIL)
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read R-matrix header 
      CALL READRH(LURMT,NRMSET(IG),RFORM,MGVN,STOT,GUTOT,NCHAN0,NVIB0,
     * NDIS0,NTARG0,ION,R(IG),RMASS,RMATR,NFBUT,ISMX,NCSF(ig),nci,
     2 NPLX,ezero(ig),iex,IWRITE,IPRNT(1),IFAIL)
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read remainder of fixed nuclei R-matrix data
      if (abs(nfbut).gt.1) then
      CALL READRM(LURMT,RFORM,NCHANF,NCSF(ig),nci,ISMX,isfmax,NPLX,0,
     1 NFBUT,cf,epole(IEG:),wamp(IWA:),vec,butc(IBUT:),sfac(isf:),
     2 iex,ecex(iec:),rcex(irc:),IFAIL)
      else
      CALL READRM(LURMT,RFORM,NCHANF,NCSF(ig),nci,ISMX,isfmax,NPLX,0,
     1 NFBUT,cf,epole(IEG:),wamp(IWA:),vec,butc(IBUT:),dum1,
     2 iex,dum1,dum1,IFAIL)
      endif
C
      IF(IFAIL.NE.0) RETURN
C
 2    CONTINUE
C
      IF(NGEOM.EQ.1) THEN
C
C---- Set up fixed nuclei calculation
        e0 = etarg(1)
        NVCHAN = NCHAN
C
      ELSE
        WRITE(IWRITE,22)
        NVCHAN = NCHAN-NDISS
        IF(NDIS.EQ.0) NCHAN = NVCHAN
C
C---- Read vibrational channel data 
        NVIBD = NVIB+NDIS
        allocate (evib(ntargv),ivtarg(nvibd),ivnu(nvibd))
c
        CALL READTC(LUVCHN,NVCSET,NCHAN,NVIB,NDIS,NTARGv,ION,IVTARG,
     1  IVNU,IVCHL,LVCHL,MVCHL,EVCHL,STARG,
     2  MTARG,GTARG,Evib,ZERO,RMASS,VCFORM,IWRITE,IPRNT(1),IFAIL)
c
        deallocate(evib,ivtarg,ivnu)
C
C---- Initialize acquisition of vibrational functions
        EBASE = zero
        CALL VIBINI(IREAD,IWRITE,NTARG,NVTARG,RMASS,ebase,IPRNT(2))
        WRITE(IWRITE,47) EBASE
C
C---- Set up quadrature scheme for integrals in adiabatic nuclei approx
        IF(NRQUAD.EQ.0) THEN
C     THIS IS A BIT ARBITRARY AND NOT THOROUGHLY TESTED
          NQUAD = 15*NVIB+1
          IF(MOD(NQUAD,2).EQ.0) NQUAD=NQUAD+1
        ELSE
          NQUAD = NRQUAD
        ENDIF
        allocate (rquad(nquad),qwts(nquad))
C
        CALL VMESH(R(1),R(NGEOM),NQUAD,RQUAD,QWTS)
C
C---- Initialize spline interpolation
        CALL SPLINI(NKNOT,KNOTS,RK,MAXPTS,NGEOM,R,IWRITE)
C
C----- GET TARGET VIBRATIONAL WAVEFUNCTIONS ON QUADRATURE MESH
c
        allocate (evib(nvibd),ivtarg(nvibd),ivnu(nvibd),ichord(nvchan),
     *  vibfn(NVIB*NQUAD))
C
       CALL RVIBR(NVIB,NQUAD,EVIB,IVTarg,IVnU,VIBFN,dum,RQUAD)
       e0 = evib(1)
C
c---- Set up pointer from VIBINI ordering to channel ordering
        if(ntarg.gt.1) call REORDI_compak(nvchan,evchl,nvib,evib,ichord)
C
 
        IF(IPRNT(2).GT.0) CALL CHECKQ(NQUAD,NVIB,QWTS,VIBFN,IWRITE)
C
C---- Storage allocation for non-adiabatic data
        allocate (ampn(nstat*NCHANS),eign(nstat))
C
C---- Read rest of non-adiabatic R-matrix file
        CALL READRM(LUNRMT,NRFORM,NCHANS,nstat,NHD,ISMVX,ISMAX,0,0,0,cf,
     1  EIGn,AMPn,DUM2,DUM2,DUM1,0,DUM1,DUM1,IFAIL)
C
      ENDIF
C
C---- Save multipole coefficients as square matrix
      IF(ISMAX.GT.0) THEN
        CALL SQUARM_compak(NVCHAN,ISMAX,cf,AMC)
        IF(NDIS.GT.0.AND.MDMAX.GT.0) THEN
C---- Unpack dissociation potential data.  This code must match
C     DISINI in VIBRMT
          ITEMPD = ISMAX*NVCHAN*(NVCHAN+1)/2+1
          ND2 = NDIS*(NDIS+1)/2+6*NDIS
          CALL SPLITM_compak(NDIS,ND2,MDMAX,cf(ITEMPD),ADC,ADM)
        ENDIF
      ENDIF
c      deallocate (cf)
C
C----- INITIALIZE ASYMPTOTIC ROUTINES FOR VIBRATIONAL CHANNELS
      IF(NVCHAN.GT.0) THEN
        RAFINV = RMATR
        SCALE = ONE
        CALL ASYM1_compak(NVCHAN,LVCHL,ION,ISMAX,AMC,RMATR,RAFINV,
     1  SCALE,BBLOCH,EVCHL,EMINR,EMAXR,IVPROP,POTL_compak,IWRITE)
      ENDIF
C
C----- INITIALIZE ASYMPTOTIC ROUTINES FOR DISSOCIATING CHANNELS
      IF(NDIS.GT.0) THEN
        EMINM = TWOM*EMINR
        EMAXM = TWOM*EMAXR
        IF(IVPROP.EQ.0) IDPROP=0
        RAFIND = RMATN
        SCALE = ONE/TWOM
        CALL ASYM1_compak(NDIS,LVCHL(1+NVCHAN),0,MDMAX,ADC,RMATN,RAFIND,
     1  SCALE,BIGB,EVCHL(1+NVCHAN),EMINM,EMAXM,IDPROP,DISPOT_compak,
     2  IWRITE)
        IF(IDPROP.NE.IVPROP) GO TO 94
      ELSE
        IDPROP = 0
      ENDIF
C
C----- INITIALIZE OUTPUT OF K-MATRICES 
      IF(LUKMT.NE.0) CALL WRITKH(LUKMT,NKSET,KFORM,NAME,MGVN,STOT,
     1 GUTOT,ION,RR,RMASS,NCHAN,NVIB,NDIS,NTARG,NERANG,NESCAT,EINR,
     2 NESC,IPRNT(6),IWRITE,IFAIL)
C
C----- Initialize output of R-matrices and wavefunctions
      IF(LUWFN.NE.0) CALL WRITWH(LUWFN,NWSET,WFORM,NAME,MGVN,STOT,
     1 GUTOT,ION,RR,RMASS,NCHAN,NVIB,NDIS,NTARG,NERANG,NESCAT,EINR,
     2 NESC,IPRNT(6),IWRITE,IFAIL)
C
C---- Store Bloch coefficients
      allocate (bloch(nvchan+ndis))
      DO 4 I=1,NVCHAN
      BLOCH(I) = BBLOCH
 4    continue
      DO 5 I=1,NDIS
      BLOCH(NVCHAN+I) = BIGB 
5     continue
C
C---- Storage allocation for energy loop
      NCHSQ= NCHAN*NCHAN
      NVCHSQ = NVCHAN*NVCHAN
      allocate (rvib(nchsq),fx(2*nchsq),fxp(2*nchsq),fv(2*nvchsq),
     * fvp(2*nvchsq),fd(2*ndis*ndis),fdp(2*ndis*ndis),akmat(nchsq),
     * rres(NGEOM*NCHANF*(NCHANF+1)/2),crv(2*NVCHSQ+NVCHAN),fkmat(nchsq)
     * ,crd(NDIS*(2*NDIS+1))
     * ,rvib2(nchsq),fkmat_temp(nchsq),fkmat_temp2(nchsq)
     * ,fx_test(2*nchsq),fxp_test(2*nchsq) ) !AlexH 23/11/10
      if(npole.gt.0) allocate (rmn(NCHAN*(NCHAN+1)/2))
C
C-----------------------------------------------------------------------
C
C     ENERGY LOOP
C
      NRK = 0
      NRDIP=0
      IEN = 0

      if (calcak /= 0 .and. calcdip(1) /= 0) then
         if (calcak /= calcdip(3)) then
            print *, 'Error: CALCAK and CALCDIP(3) must be the same'
     *               // ' when calculating both!'
            stop 1
         end if
      end if

      if (calcak.ne.0) then
C        Determine number of channels to keep.
         last_chan_kept=0
         do i=1,nchan
            if(ICHL(i) .gt. calcak) then
               last_chan_kept=i-1
               exit
 
            end if

         end do
         if(last_chan_kept .eq. 0) last_chan_kept=nchan

      end if

!     Read inner region dipoles for constructing the 
!     partial wave dipoles.
!     ---------------------------------------------- 

      if (calcdip(1).ne.0) then

C       Determine number of channels to keep.
        last_chan_kept=0
        do i=1,nchan
          if(ICHL(i) .gt. calcdip(3)) then
            last_chan_kept=i-1
            exit
 
          end if

        end do
        if(last_chan_kept .eq. 0) last_chan_kept=nchan

        nstat_dip=nstat+calcdip(2)
!       ZM The number of neutral states for which I want the dipoles is given in calcdip(2) so I can use this to eliminate overallocation and to read-in only the dipoles that I want.
        nstat_neut = calcdip(2)
        
        maxprop=lmax_property**2+2*lmax_property
        allocate( dip_comp_present(maxprop), 
     *            bound_state_energies(nstat_neut))
        call read_transdip2(iwrite, lu_inner_dipoles, 
     *       nset_lu_inner_dipoles, 
     *       nstat_neut, nstat_dip, lmax_property, inner_dipoles_temp, 
     *       dip_comp_present, bound_state_energies, ifail)
     
!       Pickout the part that we want
        if (calcdip(1).eq.1) then       
           allocate(inner_dipoles(nstat_neut,nstat,maxprop)) !No quads
           inner_dipoles=0
           nbound_dip=merge(nstat_dip-nstat,0,nstat_dip>0) ! No of bound states in the dipole file

           if (nbound_dip > 0) then
              inner_dipoles=inner_dipoles_temp( 1:nstat_neut,
     *                                       nbound_dip+1:,: )
           end if

           !ZM inner_dipoles_temp can be large if nstat_neut is large so get rid of it as soon as possible
           deallocate(inner_dipoles_temp)
                
        else if (calcdip(1).eq.2) then
           stop "Not implemented yet"
        end if
        
!       Allocate space for partial wave dipoles
        allocate( re_pw_dipoles_temp(calcdip(2),nchan,maxprop),
     *            im_pw_dipoles_temp(calcdip(2),nchan,maxprop) )     
        allocate( re_pw_dipoles(calcdip(2),last_chan_kept,maxprop,nesc),
     *            im_pw_dipoles(calcdip(2),last_chan_kept,maxprop,nesc))     
        allocate( escat(nesc) )
        escat=0d0; re_pw_dipoles_temp=0d0; im_pw_dipoles_temp=0d0
        re_pw_dipoles=0d0; im_pw_dipoles=0d0
      end if

      if (CALCAK .ne. 0) then 
         allocate( ar(nocsf,last_chan_kept,nesc), 
     *             ai(nocsf,last_chan_kept,nesc) ) !AlexH 17/11/10
         allocate( ar_temp(nocsf,nchan), ai_temp(nocsf,nchan),  !
     *                escat_temp2(nesc) )
         if ( .not. allocated(escat)) allocate(escat(nesc)) 
         ar=0d0; ai=0d0 !AlexH 17/11/10
         ar_temp=0d0;ai_temp=0d0 !AlexH 17/11/10
         escat_temp2=0d0; escat=0d0
      end if
C
      allocate(y_arr(nchan),dy_arr(nchan)) ! AlexH 23/11/10 for inwards prop.
      y_arr=0d0; dy_Arr=0d0

      DO 50 IES=1,NERANG
      NES = NESCAT(IES)
      ENRYD = EINR(1,IES)
      DE    = EINR(2,IES)
C
C---- ZM: ampae is the space for the energy-dependent auxiliary amplitude
C         used by RESIDR
      if (allocated(AMPAE)) deallocate (AMPAE)
      allocate(AMPAE(NSTAT,NCHANF),stat=ifail)
      if (ifail .ne. 0) stop "AMPAE memory allocation error."
      AMPAE(:,:) = 0.0D0
C
      DO 40 IE=1,NES
      ETOT  = e0+HALF*ENRYD
      IF(IPRNT(5).GT.0.OR.IPRNT(6).GT.0) WRITE(IWRITE,28) ENRYD
C
      NVOPEN = 0
      NDOPEN = 0
      ifail = 0
C
C---- Calculate contribution to R-matrix from non-adiabatic poles
      IF(NPOLE.GT.0) THEN
        CALL VRMAT2_compak(NCHAN,NHD,RMN,ETOT,AMPn,EIGn,NLPOLE)
        IF(IPRNT(5).NE.0) THEN
          WRITE(IWRITE,24) NPOLE
          CALL MATTPT(NCHAN,RMN,IWRITE)
        ENDIF
      ENDIF
C
C----- CALCULATE CONTRIBUTIONS TO FIXED NUCLEI R-MATRICES FROM HIGHER
C      POLES
      if(newbut.eq.0) nfbut=-nfbut
      if (abs(nfbut).gt.1) then
      CALL RESIDR_compak(ETOT,NCHANF,NTARG,ETARG,NLPOLE,NPOLE,nstat,
     1     NGEOM,ncsf,ichl,AMPAE,WAMP,EPOLE,NFBUT,BUTC,RRES,ezero,sfac,
     2     iex,ecex,rcex,IWRITE,IFAIL)
      else
      CALL RESIDR_compak(ETOT,NCHANF,NTARG,ETARG,NLPOLE,NPOLE,nstat,
     1     NGEOM,ncsf,ichl,AMPAE,WAMP,EPOLE,NFBUT,BUTC,RRES,ezero,DUM1,
     2     iex,DUM1,DUM1,IWRITE,IFAIL)
      endif
      IF(IFAIL.NE.0) THEN
        IF(IEUNIT.EQ.2) Entop = Enryd/RYD
        IF(IFAIL.EQ.1) THEN
          WRITE(IWRITE,39) ENtop,eunit(ieunit)
          IFAIL = 0
          GO TO 50
        ELSE
          WRITE(IWRITE,38) ENtop,eunit(ieunit)
          IFAIL = 0
          GO TO 40
        ENDIF
      ELSE
        IEN = IEN+1
      ENDIF
C
C----- CALCULATE RESIDUAL R-MATRIX IN THE ADIABATIC NUCLEI APPROX. AND
C      ADD IT TO THE VIBRATIONAL R-MATRIX OBTAINED IN VRMAT2_compak.  A SQUARE
C      MATRIX IS OUTPUT FOR INPUT TO ASYMPTOTIC CODE.
C
      IF(npole.GT.0) THEN
        CALL ADNUC(NGEOM,R,NCHANF,ICHL,NTARG,NVTARG,VIBFN,KNOTS,
     1  RK,NVCHAN,RRES,RVIB,dum,1,NQUAD,RQUAD,QWTS)
c
c---- Reorder elements to match channel labels
        if(ntarg.gt.1) call REORDV_compak(nvchan,ichord,rvib)
c
C     Add adiabatic component of R-matrix to the non-adiabatic
        K = 0
        IJ = 0
        DO 71 I=1,NVCHAN
        DO 7 J=1,I
        K = K+1
        IJ = IJ+1
        rmn(K) = rmn(K)+rvib(IJ)
 7      continue
 71     continue
        CALL SQUARM_compak(NCHAN,1,RMN,RVIB)
      ELSE
        CALL SQUARM_compak(NCHAN,1,RRES,RVIB)
      ENDIF
C
      IF(IPRNT(5).GT.0) THEN
        WRITE(IWRITE,14)
        CALL WRECMT(RVIB,NCHAN,NCHAN,NCHAN,NCHAN,NCOL,IWRITE)
      ENDIF
C
C----- GET SOLUTIONS, DERIVATIVES AND GLOBAL X IN VIBRATIONAL
C      CHANNELS AT R=RAFINV
      IF(NVCHAN.GT.0) THEN
        CALL ASYM2_compak(NVCHAN,NVOPEN,LVCHL,ION,ISMAX,AMC,CRV,
     1  RAFINV,EVCHL,ENRYD,FV,FVP,IVPROP,ifail)
        if(ifail.gt.1) go to 41
        ifail = 0
      ENDIF
C
C----- GET SOLUTIONS, DERIVATIVES AND GLOBAL R-MATRIX IN DISSOCIATING
C      CHANNELS AT R=RAFIND
      IF(NDIS.GT.0) THEN
        E2M = RMASS*ENRYD
        CALL ASYM2_compak(NDIS,NDOPEN,LVCHL(1+NVCHAN),ION,MDMAX,ADC,
     1  CRD,RAFIND,EVCHL(1+NVCHAN),E2M,FD,FDP,IDPROP,ifail)
        if(ifail.gt.1) go to 41
        ifail = 0

C
C----- IF NO PROPAGATION MUST USE NUMERICAL INTEGRATION
        IF(IDPROP.EQ.0.AND.RAFIND.GT.R(NGEOM)) 
     1  CALL ASYMD_compak(E2M,NDIS,
     2  TWOM,R(NGEOM),RAFIND,EVCHL(1+NVCHAN),FD,FDP,ADM,
     3  IWRITE,IPRNT(3))
      ENDIF
C
C----- MERGE SOLUTIONS AND DERIVATIVES
      NOPEN = NVOPEN+NDOPEN
      if(nopen.eq.0) go to 40
      CALL MERGE_compak(NCHAN,NVCHAN,NDIS,NVOPEN,NDOPEN,FX,FXP,FV,FVP,
     1                  FD,FDP)
C
      rvib2=rvib !Save pre-propagation R-matrix AlexH 23/11/10
      if(RMATR.gt.RAFINV) IBACK=-1
C----- PROPAGATE R-MATRICES IF REQUIRED
      IF(IDPROP.GT.0.OR.IVPROP.GT.0)
     1  CALL RPROPX_compak(NCHAN,NVCHAN,NDIS,CRV,CRD,RVIB,IPRNT(5),
     2  IWRITE,IBACK)
C
C----- COMPUTE K-MATRIX
       if (smooth .gt. 1d-10) then
! !     Assumes no propagation
!          call KMATREG(EPOLE,ENRYD,E0,NSTAT,NCHAN,BLOCH,NOPEN,WAMP,FX,
!      1             FXP,AKMAT,fkmat)
       else
!          call KMATREG(EPOLE,ENRYD,E0,NSTAT,NCHAN,BLOCH,NOPEN,WAMP,FX,
!      1             FXP,AKMAT,fkmat)
          CALL KMAT_compak(NCHAN,BLOCH,NOPEN,FX,FXP,RVIB,AKMAT,fkmat)
c~          CALL KMAT_MKL(NCHAN,BLOCH,NOPEN,FX,FXP,RVIB,AKMAT,fkmat)
       end if
C

      IF(IPRNT(6).GT.0) THEN
        WRITE(IWRITE,15)
        CALL WRECMT(AKMAT,NOPEN,NOPEN,NOPEN,NOPEN,NCOL,IWRITE)
      ENDIF
      IF(LUKMT.GT.0) THEN
        IF(IKTYPE.EQ.0) THEN
C         Write the asymptotic (open-open) block of the K-matrix
          CALL WRITKM(NOPEN,NDOPEN,ENRYD,AKMAT)
        END IF
        IF(IKTYPE.EQ.1) THEN
C         Write the full K-matrix, but symmetrize it first: it
C         contains lower triangle, but WRITKM uses the upper one
          DO I=1,NCHAN
            DO J=1,I
              FKMAT(J+(I-1)*NCHAN) = FKMAT(I+(J-1)*NCHAN)
            END DO
          END DO
          CALL WRITKM(NCHAN,NDIS,ENRYD,FKMAT)
        END IF
      END IF
      IF(LUWFN.GT.0) CALL WRITWF(NCHAN,NOPEN,ENRYD,FX,FXP)
!
!     Calculate wavefunction coefficients if requested
!     ------------------------------------------------
      if (CALCAK.ne.0) then
      
        if((RAFINV .gt. RMATR) .and. (ifprop2 .eq. 1)) then

c         Back propagate the reduced radial functions
          write(6,*) "Use arbitrary precion version of rsolve "
          write(6,*) "for back propapagation (rsolve_multi_prec)"
          
        else
        
c         Calculate wave function coefficients 
          ar_temp=0;ai_temp=0;    
          call compak(NCHAN,NOPEN,FX,FXP,NOCSF,EPOLE,WAMP,IFAIL,
     *                 AKMAT,fkmat,etarg,EVCHL,nrk,ENRYD,NTARG,
     *                 RVIB2,RMATR,ar_temp,ai_temp)

        end if

           NRK=NRK+1

           ar(:,:,NRK)=ar_temp(:,1:last_chan_kept) !AlexH -
           ai(:,:,NRK)=ai_temp(:,1:last_chan_kept) !AlexH
           escat(NRK)=half*enryd !AlexH

      end if
!
!     Calculate partial wave dipoles if requested
!     -------------------------------------------
      if (CALCDIP(1).ne.0) then
      
        if((RAFINV .gt. RMATR) .and. (ifprop2 .eq. 1)) then
c         Back propagate the reduced radial functions
          
          write(6,*) "Use arbitrary precion version of rsolve "
          write(6,*) "for back propapagation (rsolve_multi_prec)"
          
        else if (nbound_dip > 0) then
c       Calculate partial wave dipoles
          re_pw_dipoles_temp=0;im_pw_dipoles_temp=0;    

          call compak(NCHAN,NOPEN,FX,FXP,NOCSF,EPOLE,WAMP,IFAIL,
     *                 AKMAT,fkmat,etarg,EVCHL,nrdip,ENRYD,NTARG,
     *                 RVIB2,RMATR,inner_dipoles=inner_dipoles,
     *                 re_pw_dipoles=re_pw_dipoles_temp, 
     *                 im_pw_dipoles=im_pw_dipoles_temp)

        end if

           NRDIP=NRDIP+1

        re_pw_dipoles(:,:,:,NRDIP)=
     *     re_pw_dipoles_temp(:,1:last_chan_kept,:) 
        im_pw_dipoles(:,:,:,NRDIP)=
     *     im_pw_dipoles_temp(:,1:last_chan_kept,:)
     
      print *, NRDIP  
      escat(NRDIP)=half*enryd !AlexH

      end if


 41   ENRYD = ENRYD+DE
 40   continue
 50   CONTINUE
C
      IF(IEN.LE.0) IFAIL=1
C
C     END OF ENERGY LOOP
C
C-----------------------------------------------------------------------
C
C     AlexH -17/11/10 Write A_k coefficients to file
C     ZM - only if requested since the A_k are not needed for dipelm
! DO NOT REMOVE. This is for Quantemol-N
! open a file fort.448 to write a number of energy points for which
! K-matrices have been calculated - this is the number of energy points
! for cross sections and eigenphases output
      IF(qmoln) THEN
        nen=448
        open (unit=nen, file='fort.448', status='unknown')
        write(nen,*) NRK
        close (nen)
      ENDIF

      if (calcak.ne.0) then
!        Only keep channels corresponding to the first calcak target
!        states. Wavefunction files can get very large with large 
!        target lists.

         call WRITSH(LUSCT,NSSET,SFORM,NAME,MGVN,STOT,GUTOT,
     *   last_chan_kept,ICHL(1:last_chan_kept),LVCHL(1:last_chan_kept),
     *   MVCHL(1:last_chan_kept),EVCHL(1:last_chan_kept),NOCSF,NOCSF,
     *   NESC,0d0,0,IWRITE,IFAIL)

!          call  WRITSC(LUSCT,SFORM,ESCAT,last_chan_kept,NOCSF,NESC,
!      *   ar_temp2,ai_temp2)
         call  WRITSC(LUSCT,SFORM,ESCAT,last_chan_kept,NOCSF,NESC,ar,ai)

!          deallocate(ar_temp2,ai_temp2)
      end if
      
      if (calcdip(1).ne.0) then
        call write_pw_dipoles( lu_pw_dipoles, nset_pw_dipoles,
     *    form_pw_dipoles, name, mgvn, stot, gutot,
     *    starg(1:ichl(last_chan_kept)),mtarg(1:ichl(last_chan_kept)),
     *    gtarg(1:ichl(last_chan_kept)),
     *    ichl(1:last_chan_kept), lvchl(1:last_chan_kept),
     *    mvchl(1:last_chan_kept), evchl(1:last_chan_kept), escat,
     *    lmax_property,dip_comp_present, bound_state_energies,
     *    etarg(1),
     *    re_pw_dipoles(:,:,:,1:NRDIP),
     *    im_pw_dipoles(:,:,:,1:NRDIP), 1, iwrite,
     *    ifail )
        deallocate(re_pw_dipoles, im_pw_dipoles)
        close(unit=lu_pw_dipoles)
        close(unit=lu_pw_dipoles_cmplx)
      end if


      write(IWRITE,48) NRK
      IF(IFAIL.EQ.0) WRITE(IWRITE,18)
c
      deallocate (rvib,fx,fxp,akmat,fkmat,bloch,fv,fvp,fd,fdp,rres,crv,
     *            crd)
      deallocate (etarg,starg,mtarg,gtarg,evchl,lvchl,mvchl,ivchl)
      deallocate (epole,wamp,ichl,butc,amc,adc,adm)
      
      if (abs(nfbut).gt.1) deallocate(sfac,ecex,rcex)
c
      CLOSE(UNIT=LUCHAN)
      CLOSE(UNIT=LURMT)
      CLOSE(UNIT=LUKMT)
      IF(NGEOM.GT.1) THEN
        deallocate (ichord,rquad,qwts,evib,ivtarg,ivnu,vibfn,rmn,ampn,
     *              eign)     
        CLOSE(UNIT=LUVCHN)
        CLOSE(UNIT=LUNRMT)
      ENDIF
      RETURN
C
 89   WRITE(IWRITE,91) NGEOM,NCHSET(NGEOM),NRMSET(NGEOM),R(NGEOM)
 91   FORMAT(/' ERROR IN GEOMETRY RELATED DATA'/' NGEOM =',I3,'  NCHSET(
     1NGEOM) =',I3,'  NRMSET(NGEOM) =',I3,'  R(NGEOM) =',F6.3)
      GO TO 90
 92   WRITE(IWRITE,93) NCHAN0,NCHAN,NTARG0,NTARG
 93   FORMAT(' INCONSISTENT DATA ON INPUT FILES'/' NCHAN0 =',I5,5X,'NCHA
     1N =',I5,5X,'NTARG0 =',I5,5X,'NTARG =',I5)
      GO TO 90
 94   WRITE(IWRITE,95)IVPROP,IDPROP
 95   FORMAT(/' INCONSISTENT PROPAGATION FLAGS',2I5)
      GO TO 90
 96   WRITE(IWRITE,98) NTARG,NGEOM,MAXTGT,MAXPTS
 98   FORMAT(/' INPUT DATA WILL EXCEED FIXED DIMENSIONS'/' INPUT  ',
     12I5/' MAXIMA ',2I5)
      GO TO 90
 90   IFAIL = 1
      RETURN
C
 10   FORMAT(/' Vibrationally resolved calculation '//
     * ' Number of dissociating channels',I3//
     * ' Input geometries'/' R =',7F10.5,(/4X,7F10.5))
 11   FORMAT(/' Input datasets:',33X,'Unit  Set numbers'/
     1' Target and channel data     LUCHAN (',A11,')',I3,5X,30I3/(35X,30
     2I3))
 12   FORMAT(//' Program RSOLVE  (last modified ',A,' )'//A//
     1' Symmetry data  MGVN =',I2,' STOT =',I2,' GUTOT =',I2)
 13   FORMAT(/' K-matrices will be calculated for',I5,' energies in the 
     1range [',F8.4,',',F8.4,'] ',A)
 14   FORMAT(/' SUPER R-MATRIX')
 15   FORMAT(/' K-MATRIX')
 16   FORMAT(I3,12F10.5/(3X,12F10.5))
 17   FORMAT(/' *** FIXED NUCLEI DATA ***')
 18   FORMAT(/' *** Task successfully completed ***')
 19   FORMAT(/' *** NON-ADIABATIC DATA ***')
 20   FORMAT(/' Fixed nuclei calculation for R =',F6.3)
 21   FORMAT(/' Vibrational channel data    LUVCHN (',A11,')',I3,5X,I3
     1/' Non-adiabatic R-matrix data LUNRMT (',A11,')',I3,5X,I3)
 22   FORMAT(/' *** END OF FIXED NUCLEI DATA *** ')
 23   FORMAT(/' NDIS =',I2,' IS INCOMPATIBLE WITH DATA FROM VIBRMT',2X,
     1'CHANGED TO ',I2)
 24   FORMAT(/' CONTRIBUTION TO ELECTRONIC R-MATRIX FROM FIRST',I3,
     1' POLES')
 25   FORMAT(/' COUPLING R-MATRIX')
 26   FORMAT(/' NUCLEAR MOTION R-MATRIX')
 27   FORMAT(10A8)
 28   FORMAT(/100('-')//' INCIDENT ENERGY',F10.5,' RYD')
 31   FORMAT(/' Output datasets:',32X,'Unit  Set number'/
     1' K-matrices',18X,'LUKMT  (',A11,')',I3,5X,I3)
 32   FORMAT(' Wavefunction data           LUWFN  (',A11,')',I3,5X,30I3/
     1(35X,30I3))
 33   FORMAT(' Fixed nuclei R-matrix data  LURMT  (',A11,')',I3,5X,30I3/
     1(35X,30I3))
 34   FORMAT(/' Maximum multipole USED in asymptotic scattering potentia
     1ls   ISMAX =',I3)
 35   FORMAT(/' Maximum multipole USED in asymptotic dissociating potent
     1ials MDMAX =',I3)
 38   FORMAT(/' Adiabatic approx. to contribution from higher',
     * ' poles failed at E =',F7.4,1x,a/
     * ' If higher energies are required, increase NPOLE')
 39   FORMAT(/' Adiabatic approx. to contribution from lower',
     * ' poles failed at E =',F7.4,1x,a/
     * ' If lower energies are required, decrease NPOLE')
 47   FORMAT(/' Base energy used in nuclear motion code  EBASE =',F11.5,
     1' au')
 48   FORMAT(/'Number of energy points for which the K matrices have
     1 actually been calculated: ', I6)
C
      END

!       subroutine cfunc_compak_multi_prec(nchan,nopen,rmatr,rafinv,
!      *                          rvib2, crv, fx,fxp,akmat,fkmat,
!      *                          wamp,nocsf,eig,etarg,echl,nrk,
!      *                          en,ntarg,akr,aki)
!       use, intrinsic :: iso_c_binding
!       implicit none
!       interface
!         subroutine compak_multi_prec(nchan,nopen,rmatr,rafinv, 
!      *                          rvib2,crv,fx,fxp,akmat,fkmat,
!      *                          wamp,nocsf,eig,etarg,echl,nrk,
!      *                          en,ntarg,akr,aki) 
!      *                        bind(C,name="compak_multi_prec")
!           use, intrinsic :: iso_c_binding
!           implicit none
!           integer(c_int) :: nchan,nopen,nocsf,nrk,ntarg
!           real(c_double) :: rmatr,rafinv,rvib2(nchan*nchan), 
!      *                      crv(2*nchan*nchan+nchan), 
!      *                      fx(2*nchan*nchan),fxp(2*nchan*nchan),
!      *                     akmat(nopen*nopen),fkmat(nchan*nchan),
!      *                  wamp(nchan*nocsf),eig(nocsf),echl(nchan),
!      *                  etarg(ntarg),akr(nocsf*nchan), 
!      *                  aki(nocsf*nchan),en 
!         end subroutine compak_multi_prec
! 
!       end interface
!       integer :: nchan,nopen,nocsf,nrk,ntarg
!       integer(c_int) :: c_nchan,c_nopen,c_nocsf,c_nrk,c_ntarg
! !       double precision :: rmatr,rafinv,rvib2, crv, fx,fxp,akmat,fkmat
!       real(c_double)  ::rmatr,rafinv,rvib2(nchan*nchan), 
!      *                  crv(2*nchan*nchan+nchan), 
!      *                  fx(2*nchan*nchan),fxp(2*nchan*nchan),
!      *                  akmat(nopen*nopen),fkmat(nchan*nchan),
!      *                  wamp(nchan*nocsf),eig(nocsf),echl(nchan),
!      *                  etarg(ntarg),akr(nocsf*nchan), 
!      *                  aki(nocsf*nchan),en 
!       c_nchan=nchan
!       c_nopen=nopen
!       c_nocsf=nocsf
!       c_nrk=nrk
!       c_ntarg=ntarg
! 
!       call compak_multi_prec(c_nchan,c_nopen,rmatr,rafinv,
!      *                       rvib2, crv, fx,fxp,akmat,fkmat,
!      *                       wamp,c_nocsf,eig,etarg,echl,c_nrk,
!      *                       en,c_ntarg,akr,aki)
! 
!       end subroutine

      SUBROUTINE reordi_compak(nchan,echl,ntarg,etarg,ichord)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
c---- Determine consistent ordering of channels to match target states
C
C***********************************************************************
c
      dimension istart(ntarg),ichord(nchan),itgord(ntarg),
     1 etarg(ntarg),echl(nchan),iend(ntarg)
      data tol/1.d-10/,two/2.d0/
c
c---- Determine energy ordering of target states
      call SORT_OUTER(ntarg,istart,etarg)
      do 1 i=1,ntarg
      itgord(istart(i)) = i
 1    continue
c
c---- Set pointer to first channel corresponding to each target state
      do 5 it = 1,ntarg
      et = two*(etarg(it)-etarg(1))
      ifound = 0
      do 4 i=1,nchan
      if(abs(et-echl(i)).gt.tol) go to 4
      ic = i
      if(ifound.gt.0) go to 4
      ifound = 1
      istart(it) = i
 4    continue
      iend(it) = ic
 5    continue
c
      j = 0
      do 21 it=1,ntarg
      do 2 i=istart(it),iend(it)
      j = j+1
      ichord(j) = i
 2    continue
 21   continue
c
      return
      END
      SUBROUTINE reordv_compak(nchan,ichord,rm)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      dimension work(nchan*nchan),ichord(nchan),rm(nchan*nchan)
C
C***********************************************************************
C
c---- Reorder R-matrix elements
      do 6 i=1,nchan
      do 5 j=1,i
      work(nchan*(max(ichord(i),ichord(j))-1)+min(ichord(i),ichord(j)))
     1 = rm(i*(i-1)/2+j)
 5    continue
 6    continue
      do 8 i=1,nchan
      do 7 j=1,i
      rm(i*(i-1)/2+j) = work(nchan*(i-1)+j)
 7    continue
 8    continue
c
      return
      END
      SUBROUTINE ASYM2_compak(NCHAN,NOPEN,LCHL,ION,ISMAX,CF,CR,RAFIN,
     1ETHR,E,FX,FXP,IPROP,ifail)
C
C***********************************************************************
C
C     ASYM2 CONTAINS CALLS TO ENERGY DEPENDANT PARTS OF PROPAGATOR AND
C           ASYMPTOTIC PACKAGES
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION LCHL(NCHAN),ETHR(NCHAN),CF(NCHAN,NCHAN,*),
     1 FX(*),FXP(*),CR(*),y(nchan),dy(nchan),en(nchan),nleg0(1)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      COMMON/ASYMS/DEGENY,EPS,EWRON,NLEG,IASY,IWRITE,IPFLG(10),IWRON,
     1 RMATR,HX,TOL,MAXPTS,neigen,nampx,nrange,peigen,pampa,igail
      double precision, pointer :: cfnag(:),ennag(:),elnag(:),pampa,
     * peigen
      DATA ZERO/0.D0/,ICOL/6/
C
      NCHSQ = NCHAN*NCHAN
C
C---  CALCULATE CHANNEL ENERGIES
      NOPEN = 0
      ZZNAG = 2*ION
      LAMAX = ISMAX
      DO 31 I=1,NCHAN
      EN(I) = E-ETHR(I)
      IF(EN(I).GT.ZERO) NOPEN=NOPEN+1
   31 CONTINUE
      NSOL = 2-(NCHAN-NOPEN)/NCHAN
C
      IF(IPROP.GT.0) THEN
        NMX = NCHAN
C
C       CALL CURLYR TO GENERATE GLOBAL PROPAGATOR UP TO RADIUS RAFIN
        NHD =    NLEG*NCHAN
        IF(NEIGEN.NE.NHD*NRANGE) GO TO 90
        IF(NAMPX.NE.2*NEIGEN*NCHAN) GO TO 90
C
        nleg0(1)=nleg
        CALL CURLYR(CR,E,NCHAN,NRANGE,NLEG0,pampa,peigen,dummy,ifail)
        if(ifail.gt.1) return
C
      ENDIF
C
      IRAD = 0
      FX(1:2*NCHSQ)=0d0 !AlexH - Testing
      FXP(1:2*NCHSQ)=0d0 !AlexH - Testing
      CALL GAILIT(EN,LCHL,NCHAN,ION,CF,LAMAX,RAFIN,IWRITE,IRAD,
     1 IASY,IGAIL,DEGENY,EPS,IPFLG,FX,FXP,dummy,idum,idum,ifail)

      if(ifail.gt.1) return
C
C     CHECK WRONSKIAN
C
      IF(IWRON.NE.0) CALL WRONSK_compak(NCHAN,NOPEN,FX,FXP,IWRITE,
     1 IPFLG(10),EWRON)
C
      IF(IPFLG(9).NE.0) THEN
C
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 14 K=1,NSOL
         WRITE(IWRITE,17) RAFIN
 17      FORMAT(/' SOLUTIONS AT RAFIN=',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FX(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 14      CONTINUE
         DO 15 K=1,NSOL
         WRITE(IWRITE,18)RAFIN
 18      FORMAT(/' DERIVATIVES AT RAFIN',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FXP(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 15      CONTINUE
      ENDIF
C
      IF(IPROP.GE.0) RETURN
c
c      if(igail.eq.1) then
        allocate (ennag(nchan),elnag(nchan))
        DO 32 I=1,NCHAN
        ennag(i) = en(i)
        elnag(i) = dble(LCHL(I)*(LCHL(I)+1))
 32     CONTINUE
        allocate (cfnag(lamax*nchan*nchan),stat=ierror)
        if(ierror.ne.0) then
          print *,' unable to allocate cfnag ',ierror
          stop
        endif
        ijk = 0
        do 42 k=1,lamax
        do 41 i=1,nchan
        do 40 j=1,nchan
        ijk = ijk+1
        cfnag(ijk) = cf(i,j,k)
 40     continue
 41     continue
 42     continue
c      endif
C
C     FUNCTION PROPAGATION
C
      CALL INTIN_compak(RMATR,RAFIN,FX,FXP,NCHAN,NOPEN,Y,DY,HX,MAXPTS,
     * TOL,IPFLG(10),IWRITE)
C
      IF(IPFLG(9).NE.0) THEN
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 24 K=1,NSOL
         WRITE(IWRITE,27) RMATR
 27      FORMAT(/' SOLUTIONS AT RMATR =',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FX(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 24      CONTINUE
         DO 25 K=1,NSOL
         WRITE(IWRITE,28)RMATR
 28      FORMAT(/' DERIVATIVES AT RMATR',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FXP(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 25      CONTINUE
      ENDIF
C
      RETURN
 90   WRITE(IWRITE,91) NEIGEN,NAMPX,NLEG,NRANGE,NCHAN
 91   FORMAT(' INCONSISTENT DATA IN ASYM2',5I8)
      STOP
      END
      SUBROUTINE NAGRHS_compak(NCHAN,R,Y,YDP)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     NAGRHS calculates the right hand sides of the asymptotic equations
C     in the form required by the NAG routine D02LAF
C
C     THE POTENTIALS ARE EXPANDED IN INVERSE POWERS OF THE RADIAL
C     DISTANCE R, WITH EXPANSION COEFFICIENTS GIVEN IN THE MATRIX CF
C
C***********************************************************************
C
      DIMENSION Y(*),YDP(NCHAN)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
C
      DATA ZERO/0.0D0/,ONE/1.0D0/
C
      DO 1 I=1,NCHAN
      YDP(I) = (-ENnag(I)+ELnag(I)/(R*R)-ZZNAG/R)*Y(I)
 1    continue
      DO 4 I=1,NCHAN
      DO 3 K=1,LAMAX
      INC = (I-1+(K-1)*NCHAN)*NCHAN
      RK = ONE/R**(K+1)
      DO 2 J=1,NCHAN
      YDP(I) = YDP(I)+Y(J)*cfnag(INC+J)*RK
 2    continue
 3    continue
 4    continue
C
      RETURN
      END
      SUBROUTINE NAGPOT_compak(R,Y,DY)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     NAGPOT CALCULATES THE ASYMPTOTIC POTENTIAL IN THE DISSOCIATING
C     CHANNEL. CALLING SEQUENCE IS AS REQUIRED BY NAG ROUTINE D02BAF
C
C***********************************************************************
C
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      COMMON/DISPAR/DE,D,BETA,RE,TWOM,BIGKSQ,EPSD,RA
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
      DIMENSION Y(*),DY(*)
      DATA ZERO/0.D0/,ONE/1.D0/
C
C----- GAILIT SHOULD BE USED FOR ENTIRE RANGE WHERE MULTIPOLE EXPANSION
C      IS VALID
      IF(R.LE.RA) THEN
C
C---- MORSE POTENTIAL
        V = D*(ONE-EXP(-BETA*(R-RE)))**2+DE
C
      ELSE
C
C---- MULTIPOLE EXPANSION
        V = ZERO
        DO 1 K=1,LAMAX
        V = V+cfnag(ICF1+(K-1)*INC)/R**(K+1)
 1      continue
C
      ENDIF
C
      DY(1) = Y(2)
      DY(2) = (V-BIGKSQ)*Y(1)
C
      RETURN
      END
      SUBROUTINE ASYM1_compak(NCHAN,LCHL,ION,LAMAX,CF,RMTR,RAFIN,SCALE,
     1BLOCH,ETHR,EMIN,EMAX,IPROP,POTL,IWR)
C
C***********************************************************************
C
C     ASYM1 CARRIES OUT THE ENERGY INDEPENDANT INITIALIZATION OF THE
C      ASYMPTOTIC ROUTINES.  SINCE A MODIFIED VERSION OF CFASYM IS
C      USED IN THIS CODE, WHICH DOES NOT REQUIRE SEPARATE INITIALIZATION
C      THIS ROUTINE IS LARGELY CONCERNED WITH SETTING UP THE CALL TO
C      THE PROPAGATOR PACKAGE VIA RPROP1
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      CHARACTER(LEN=14) METHOD(3)
      EXTERNAL POTL
      COMMON/ASYMS/DEGENY,EPS,EWRON,NLEG,IASY,IWRITE,IPFLG(10),IWRON,
     1 RMATR,HX,TOL,MAXPTS,neigen,nampx,nrange,peigen,pampa,igail
      DIMENSION LCHL(NCHAN),CF(NCHAN,NCHAN,*),ETHR(NCHAN),LBUG(6),
     1          nleg0(1)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,nAMAX,ICF1,INC
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
      double precision, allocatable :: work(:),vc(:)
      double precision, allocatable, target :: eigen(:),ampa(:)
      double precision, pointer :: peigen,pampa
      save eigen,ampa
C
C***********************************************************************
C
C     DATA RELATING TO THE ASYMPTOTIC PACKAGES RPROP AND CFASYM ARE
C     INPUT VIA NAMELIST /BPROP/
C
C     EBIG   = LARGEST VALUE OF |K**2| IN ANY CHANNEL IF DIFFERENT
C              FROM VALUE INPUT FROM CALLING PROGRAM
C     ESMALL = SMALLEST VALUE OF |K**2| IF DIFFERENT FROM INPUT
C     IDISC  = LOGICAL UNIT OF SCRATCH DISC IF REQUIRED
C     IGAIL  = TYPE OF ASYMPTOTIC EXPANSION, 0=BURKE+SCHEY, 1=GAILITIS,
C              2=BESSEL/COULOMB FUNCTIONS (DEFAULT =1)
C     IPFLG  = DEBUG PRINT SWITCHES FOR CFASYM (SEE CFASYM WRITE UP)
C     IWRON  = 0 WRONSKIAN OF SOLUTIONS IN NOT CHECKED
C     LBUG   = DEBUG PRINT SWITCHES FOR RPROP (SEE COMMENTS IN RPROP1)
C     NLEG   = NUMBER OF LEGENDRE POLYNOMIALS TO BE USED IN PROPAGATION
C              (MAXIMUM AND DEFAULT = 10)
C     NRANGE = NUMBER OF SUBRANGES IN PROPAGATION (DEFAULT= 0, CODE
C               DECIDES HOW MANY)
C     RAF    = RADIUS AT WHICH CONTINUED FRACTION METHOD CAN BE USED
C              (DEFAULT RAF=RMATR)
C
      NAMELIST/BPROP/LBUG,RAF,IDISC,IGAIL,NLEG,NRANGE,ESMALL,EBIG,
     2 IPFLG,IWRON,IFPROP,HX,TOL,MAXPTS
C
C***** SOME CONVERGENCE CRITERIA HAVE BEEN RELAXED
C      FINAL EIGENPHASES ETC APPEAR GOOD TO 4 FIGURES
      DATA TINY/1.D-8/,DELTA/6.D0/,IREAD,IDISC/5,0/,MLEG/10/
      DATA ZERO/0.0D0/,HALF/0.5D0/,IFPROP/0/
      DATA METHOD/'BURKE/SCHEY','GAILITIS','COULOMB/BESSEL'/
C
C     *******     ENERGY INDEPENDANT PART OF CALCULATION     *******
C
      HX = 0.2
      TOL = 1.D-10
      MAXPTS = 200
      RAF = ZERO
      RMATR = RMTR
      NLEG = 0
      NRANGE = 0
      IWRITE = IWR
      DEGENY = 1.D-5
      IWRON = 0
      IASY = 20
      ESMALL = 0.D0
      EBIG = 0.D0
      EPS = 5.D-5
      EWRON = 5.D-5
      IGAIL = 1
      DO 8 I=1,6
      LBUG(I) = 0
 8    continue
      DO 9 I=1,10
      IPFLG(I) = 0
 9    continue
      ISPROP = IPROP
C
      READ(IREAD,BPROP)
C
      print *, 'IWRON', iwron
      IF(RAF.GT.TINY) RAFIN = RAF
      IF(IPROP.EQ.0) RETURN
C
      IF(NLEG.GT.MLEG) GO TO 95
      IF(NLEG.EQ.0) NLEG=MLEG
      IF(ESMALL.LT.TINY) ESMALL = EMIN
      IF(EBIG.LT.TINY) EBIG = EMAX
C
C     IF THERE ARE NO LONG RANGE POTENTIALS NO PROPAGATION IS REQUIRED
C     AND SIMPLE COULOMB WAVE FUNCTIONS MAY BE USED IN ASYMPTOTIC REGION
C
      CFMAX = ZERO
      DO 32 I=1,NCHAN
      E1 = ABS(EMIN-ETHR(I))
      E2 = EMAX-ETHR(I)
      ESMALL = MIN(ESMALL,E1,ABS(E2))
      EBIG = MAX(EBIG,E2)
      DO 31 J=1,NCHAN
      DO 30 K=1,LAMAX
      COEF = ABS(CF(I,J,K))
      IF(COEF.GT.CFMAX) CFMAX=COEF
   30 CONTINUE
 31   continue
 32   continue
      IF(CFMAX .LE. TINY) IGAIL=2
      namax = lamax
C
C     DETERMINE WHETHER PROPAGATION IS REQUIRED
C
      IF(NRANGE.EQ.0) THEN
        IF(RAFIN.eq.RMATR) THEN
          IPROP = 0
          RAFIN = RMATR
        ELSE
          IPROP = 1
          NRANGE = MAX(INT(SQRT(EBIG)*ABS(RAFIN-RMATR)/DELTA+HALF),1)
        ENDIF
      ELSE
        IF(RAFIN.LE.RMATR) RAFIN=RMATR+NRANGE*DELTA/SQRT(EBIG)
        IPROP = 1
      ENDIF
      IF(IFPROP.NE.0.OR.ISPROP.LT.0) IPROP=-IPROP
C
C     PRINT DETAILS OF OPTIONS SELECTED
C
      WRITE(IWRITE,51) METHOD(IGAIL+1),RAFIN
      IF(IPROP.EQ.1) WRITE(IWRITE,52) NRANGE
      IF(IPROP.EQ.-1) WRITE(IWRITE,520) 
      IF(IPFLG(1).NE.0) WRITE(IWRITE,53)EMIN,IASY,DEGENY
C
C     ALLOCATE SPACE FROM DYNAMIC STORAGE TO PROPAGATOR PACKAGE
C
      IF(IPROP.GT.0) THEN
        NMX = NCHAN
        NHD = NCHAN*NLEG
        NBIGVC = NHD*NHD
        LPR = 10*NHD+NBIGVC
        NAMPX = 2*NHD*NCHAN*NRANGE
        NEIGEN= NHD*NRANGE
C
        allocate (vc(nbigvc),work(nbigvc))
        if(allocated(eigen)) deallocate (eigen,ampa)
        allocate (eigen(neigen),ampa(nampx))
        peigen => eigen(1)
        pampa => ampa(1)
C
        IF(IPFLG(1).NE.0) WRITE(IWRITE,8844)NRANGE,NCHAN,NLEG,IDISC,
     1  LAMAX
 8844   FORMAT(' NRANGE  =',I10,' NCHAN  =',I10,' NLEG   =',I10,/,
     1  ' IDISC  =',I2,' LAMAX  =',I10)
C
C     INITIALIZE PROPAGATOR PACKAGE
C
        nleg0(1)=nleg
        CALL RPROP1(NCHAN,RMATR,RAFIN,ETHR,NMX,NRANGE,NLEG0,EMAX,SCALE,
     1  LAMAX,ION,LCHL,CF,BLOCH,LBUG,IWRITE,IDISC,AMPA,EIGEN,
     2  NAMPX,VC,WORK,POTL)
        deallocate (work,vc)
C
      ENDIF
C
      RETURN
C
C     STORAGE OVERFLOW ... TERMINATE THE CALCULATION
C
 95   WRITE(IWRITE,96)NLEG,MLEG
 96   FORMAT(' TOO MANY BASIS FUNCTIONS, GIVEN',I3,' MAXIMUM',I3)
      STOP
 51   FORMAT(/' ASYMPTOTIC METHOD SELECTED : ',A/' EXPANSION USED AT RAD
     1IUS =',F10.4)
 52   FORMAT(/' R-MATRIX WILL BE PROPAGATED ACROSS',I3,' SUBRANGES')
 520  FORMAT(/' SOLUTIONS WILL BE PROPAGATED USING NAG ROUTINE D02LAF')
 53   FORMAT(' CONVERGENCE RADIUS FOR ENERGY,     EMIN  =',D16.8,/,
     2       ' TERMS RETAINED IN ASYMPTOTIC SERIES, IASY =',I16,/,
     4       ' MINIMUM SEPARATION FOR NONDEGENERATE',/,
     5       ' CHANNELS (RYDBERGS),               DEGENY =',D16.8,//)
      END
      SUBROUTINE RESIDR_compak(ETOTR,NCHAN,NTARG,ETARG,NLPOLE,NUPOLE,
     1 nstat,NGEOM,nocsf,ichl,AMPAE,WAMP,EPOLE,IBUTTL,BCOEF,RTEMP,ezero,
     2 sfac,iex,ecex,rcex,IWRITE,IFAIL)
      use lapack95_compak
      use blas95_compak
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C      RESIDR SETS UP ELECTRONIC R-MATRIX, EXCLUDING POLES ALREADY DEALT
C      WITH, BUT INCLUDING BUTTLE TERM, AT EACH INTERNUCLEAR SEPARATION
C
C***********************************************************************
C
      DIMENSION EPOLE(nstat,NGEOM),WAMP(NCHAN,nstat,NGEOM),RTEMP(*),
     1 BCOEF(3,NCHAN,NGEOM),ETARG(NTARG,NGEOM),nocsf(ngeom),ichl(nchan),
     2 ezero(ngeom),sfac(nchan,ngeom),ecex(iex,ngeom),
     3 rcex(NCHAN,iex,NGEOM),AMPAE(NSTAT,NCHAN)

      DATA ZERO/0.D0/,ONE/1.D0/,TWO/2.D0/
      DOUBLE PRECISION WEN
      double precision, allocatable :: r2dtemp(:,:)
C
      DO 1 K=1,NCHAN*(NCHAN+1)*NGEOM/2
      RTEMP(K) = ZERO
 1    continue
 
      allocate(r2dtemp(NCHAN, NCHAN))
      r2dtemp=0.d0
C
C----- CONSTRUCT CONTRIBUTION TO R-MATRIX FROM REMAINING POLES
      NP1 = 1
      ipass = 1
C
C----- If non-adiabatic calculation, check that this energy is low
C      enough for R-matrix contribution from remaining poles to be
C      treated adiabatically
C
 20   if(ipass.eq.2.or.nlpole.gt.1) then
        EDIFF = EPOLE(NP1,1)-ETOTR
        DO 5 IG=2,NGEOM
        ENEXT = EPOLE(NP1,IG)-ETOTR
        IF(EDIFF*ENEXT.LT.ZERO) GO TO 90
        EDIFF = ENEXT
 5      CONTINUE
      endif
C
      K = 0
      DO 23 IR=1,NGEOM
      if(ipass.eq.1) then
        np2 = nlpole-1
      else
        np2 = nocsf(ir)
      endif
      if (abs(ibuttl).gt.1) eps=one/(ezero(ir)-etotr)
      if (abs(ibuttl).gt.2) stop "Buttle correction not implemented"
C
C---- ZM: Compute the energy-dependent amplitude in the transposed form. 
C         This removes the floating point division in the R-matrix formula.
C
      AMPAE(1:NP1-1,:) = 0.0D0
C     $OMP PARALLEL DEFAULT(NONE) PRIVATE(M,K,WEN)
C     $OMP & SHARED(NP1,NP2,NCHAN,EPOLE,ETOTR,IR,AMPAE,WAMP)
C     $OMP DO
      DO K=NP1,NP2
         WEN = 1.0D0/(EPOLE(K,IR)-ETOTR) ! for gemm
c~          WEN = sqrt(1.0D0/(EPOLE(K,IR)-ETOTR)) ! for syrk
         DO M=1,NCHAN
            AMPAE(K,M) = WAMP(M,K,IR)*WEN 
         ENDDO
      ENDDO
C     $OMP END DO
C     $OMP END PARALLEL
c~ C
c~ C---- ZM: parallelize the loop over the R-matrix poles (that is usually the longest)
c~ C
c~       DO 22 I=1,NCHAN
c~       DO 2 J=1,I
c~       K = K+1
c~       SUM = ZERO
c~       if (abs(ibuttl).lt.2) then
c~       !$OMP PARALLEL DEFAULT(NONE) REDUCTION(+:SUM) PRIVATE(KL)
c~      & SHARED(I,J,IR,NP1,NP2,AMPAE,WAMP)
c~       !$OMP DO
c~          DO KL=NP1,NP2
c~             SUM = SUM+AMPAE(KL,I)*WAMP(J,KL,IR)
c~          ENDDO
c~       !$OMP END DO
c~       !$OMP END PARALLEL
c~       else
c~          DO 221 KL=NP1,NP2
c~          SUM = SUM+WAMP(I,KL,IR)*WAMP(J,KL,IR)
c~      1       *(one/(EPOLE(KL,IR)-ETOTR) - eps)
c~ 221      continue
c~       endif
c~       RTEMP(K) = RTEMP(K) + SUM
c~  2    continue
c~  22   continue
 
C----- AH: use mkl lapack functions for constructing R-matrix
C      Try first with gemm then with syrk.

      if ((abs(ibuttl).lt.2) .and. (np2 .ne. 0)) then
        call gemm(WAMP(1:NCHAN,NP1:NP2,IR), AMPAE(NP1:NP2,1:NCHAN)
     1            , r2dtemp(1:NCHAN,1:NCHAN))
c~         call syrk(AMPAE(NP1:NP2,1:NCHAN), 
c~      1             r2dtemp(1:NCHAN,1:NCHAN), trans='T', uplo='L')
                 
      end if
      
      K = 0      
      do I=1,NCHAN
        do J=1,I
          K = K+1
          if (abs(ibuttl).lt.2) then
            RTEMP(K) = RTEMP(K) + r2dtemp(I,J)
          else
            DO 221 KL=NP1,NP2
              SUM = SUM+WAMP(I,KL,IR)*WAMP(J,KL,IR)
     1        *(one/(EPOLE(KL,IR)-ETOTR) - eps)
221         continue
            RTEMP(K) = RTEMP(K) + SUM         
          end if
          
        end do
      end do
c       deallocate(r2dtemp)
      
C      DO 22 I=1,NCHAN
C      DO 2 J=1,I
C      K = K+1
C      SUM = ZERO
C      if (abs(ibuttl).lt.2) then
C         DO 21 KL=NP1,NP2
C         SUM = SUM+WAMP(I,KL,IR)*WAMP(J,KL,IR)/(EPOLE(KL,IR)-ETOTR)
C 21      continue
C      else
C         DO 221 KL=NP1,NP2
C         SUM = SUM+WAMP(I,KL,IR)*WAMP(J,KL,IR)
C     1       *(one/(EPOLE(KL,IR)-ETOTR) - eps)
C221      continue
C      endif
C      RTEMP(K) = RTEMP(K) + SUM
C 2    continue
C 22   continue
 23   continue
C
      IF(ipass.eq.1) THEN
        NP1 = NUPOLE+1
        ipass = 2
        GO TO 20
      ENDIF
C
C----- ADD BUTTLE CORRECTION
      IF(abs(IBUTTL).eq.1) THEN
        K = 0
        DO 3 IR=1,NGEOM
        DO 4 I=1,NCHAN
        if(ibuttl.lt.0) then
          itgt = 1
        else
          itgt = ichl(i)
        endif
        E = TWO*(ETOTR-ETARG(itgt,IR))
        BUTTL = BCOEF(1,I,IR)+E*BCOEF(2,I,IR)+E*E*BCOEF(3,I,IR)
        K = K+I
        RTEMP(K) = RTEMP(K)+BUTTL
 4      CONTINUE
 3      CONTINUE
      ENDIF
c-----add higher poles contribution for partitioned R-matrix
      if (abs(IBUTTL).GT.1) THEN
        K = 0
        DO 33 IR=1,NGEOM
        eps=one/(ezero(ir)-etotr)
        DO 34 I=1,NCHAN
        K = K+I
        RTEMP(K) = RTEMP(K)+sfac(i,ir)*eps
        DO 35 KL=1,iex
        RTEMP(K) = RTEMP(K)+rcex(i,kl,ir)
     1       *(one/(ecex(KL,IR)-ETOTR) - eps)
      
35      continue
34      CONTINUE
33      CONTINUE
      ENDIF
      RETURN
 90   IF(ipass.eq.1) THEN
        IFAIL = 1
      ELSE
        IFAIL = 2
      ENDIF
      RETURN
      END
      SUBROUTINE VRMAT2_compak(NCHAN,NHD,RMATRX,ETOTR,AMPA,EIGEN,NPOLE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C      VRMAT2 IS ENERGY DEPENDANT ENTRY TO NUCLEAR R-MATRIX CODE
C
C***********************************************************************
C
C     INPUT PARAMETERS ARE
C
C      ETOTR  = ENERGY OF INCIDENT PARTICLE ON LOWEST ENERGY STATE IN
C               RYDBERGS
C      AMPA,EIGEN ARE AS DEFINED IN VRMAT1
C
C***********************************************************************
C
      DIMENSION RMATRX(*),AMPA(NHD,NCHAN),EIGEN(NHD)
      DATA ZERO/0.D0/
C
      K = 0
      DO 40 M=1,NCHAN
      DO 4 N=1,M
      K = K+1
      SUM = ZERO
      DO 2 KL=NPOLE,NHD
      SUM=SUM+AMPA(KL,M)*AMPA(KL,N)/(EIGEN(KL)-ETOTR)
 2    continue
      RMATRX(K) = SUM
 4    continue
 40   continue
C
      RETURN
C
      END
      SUBROUTINE REGRMAT(NCHAN,NSTAT,RMATRX,ETOTR,AMPA,EIGEN,NPOLE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C      REGRMAT creates regular part of the R-matrix
C
C***********************************************************************
C
C     INPUT PARAMETERS ARE
C
C      ETOTR  = ENERGY OF INCIDENT PARTICLE ON LOWEST ENERGY STATE IN
C               RYDBERGS
C      NPOLE= index of closest pole
C      AMPA,EIGEN ARE AS DEFINED IN VRMAT1
C
C***********************************************************************
C
      DIMENSION RMATRX(*),AMPA(NCHAN,NSTAT,1),EIGEN(NSTAT,1)
      DATA ZERO/0.D0/
      print*, 'NPOLE=',NPOLE
      K = 0
      DO 40 M=1,NCHAN
      DO 4 N=1,M
      K = K+1
      SUM = ZERO
      DO 2 KL=1,NSTAT
      if (KL .ne. NPOLE) then 
         SUM=SUM+AMPA(M,KL,1)*AMPA(N,KL,1)/(EIGEN(KL,1)-ETOTR)
      end if
 2    continue
      RMATRX(K) = SUM
 4    continue
 40   continue
C
      RETURN
C
      END
      SUBROUTINE SINGRMAT(NCHAN,NSTAT,RMATRX,WAMP,NPOLE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C      SINGRMAT creates singular part of the R-matrix
C      (without dividing by the energy difference with the pole)
C
C***********************************************************************
C
C     INPUT PARAMETERS ARE
C
C   
C            
C      NPOLE= index of closets pole
C      
C
C***********************************************************************
C
      DIMENSION RMATRX(*),WAMP(NCHAN,nstat,1)
      DATA ZERO/0.D0/
C
      K = 0
      DO 40 M=1,NCHAN
      DO 4 N=1,M
      K = K+1
      RMATRX(K) = WAMP(M,NPOLE,1)*WAMP(N,NPOLE,1)
 4    continue
 40   continue
C
      RETURN
C
      END
      SUBROUTINE DISPOT_compak(NDIS,LAMAX,ION,LCHL,CF,NPTS,RR,VM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     DISPOT CALCULATES THE ASYMPTOTIC POTENTIAL IN THE DISSOCIATING
C     CHANNEL
C
C***********************************************************************
C
      DIMENSION RR(NPTS),VM(NDIS,NDIS,NPTS),CF(NDIS,NDIS,*),LCHL(*)
      DATA ZERO/0.D0/,ONE/1.D0/
C
      DO 10 IR=1,NPTS
      R = RR(IR)
C
      INC = -5
      DO 1 I=1,NDIS
C
C----- GAILIT SHOULD BE USED FOR ENTIRE RANGE WHERE MULTIPOLE EXPANSION
C      IS VALID
      INC = INC+5
      RA = CF(INC+1,1,LAMAX+1)
      IF(R.LE.RA) THEN
C
C---- MORSE POTENTIAL
        RE = CF(INC+2,1,LAMAX+1)
        D  = CF(INC+3,1,LAMAX+1)
        DE = CF(INC+4,1,LAMAX+1)
        BETA = CF(INC+5,1,LAMAX+1)
        V = D*(ONE-EXP(-BETA*(R-RE)))**2+DE
C
      ELSE
C
C---- MULTIPOLE EXPANSION
        V = ZERO
        DO 2 K=1,LAMAX
        V = V+CF(I,I,K)/R**(K+1)
 2      continue
C
      ENDIF
C
      DO 3 J=1,NDIS
      VM(I,J,IR) = ZERO
 3    continue
      VM(I,I,IR) = V
 1    CONTINUE
 10   continue
C
      RETURN
      END
      SUBROUTINE ASYMD_compak(ETOT,NDIS,TWORM,AO,RAF,ETHR,F,DF,VM,
     1 IWRITE,LBUG)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     ASYMD solves radial equation(s) in dissociating channel(s) for
C     R .ge. AO (assumed uncoupled)
C
C***********************************************************************
C
      EXTERNAL NAGPOT_compak
      parameter (neq=2)
      COMMON/DISPAR/DE,D,BETA,RE,TWOM,BIGKSQ,EPSD,RA
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
      DIMENSION F(NDIS,NDIS,2),DF(NDIS,NDIS,2),G(2),ETHR(NDIS),
     1 VM(5,NDIS),work(14*neq),thres(neq),gp(neq),gmax(neq)
      DATA ZERO/0.D0/
C
      EPSD = 1.D-8
      do 10 i=1,neq
      thres(i) = epsd
 10   continue
c
      TWOM = TWORM
      INC = NDIS*NDIS
      ICF1 = -NDIS
      DO 3 I=1,NDIS
      RA = VM(1,NDIS)
      RE = VM(2,NDIS)
      D  = VM(3,NDIS)
      DE = VM(4,NDIS)
      BETA = VM(5,NDIS)
      ICF1 = ICF1+NDIS+1
      BIGKSQ = ETOT-ETHR(I)
      IF(BIGKSQ.LT.ZERO) THEN
        NK = 1
      ELSE
        NK = 2
      ENDIF
      DO 4 K=1,NK
      RAFIN = RAF
      G(1) = F(I,I,K)
      G(2) = DF(I,I,K)
      DO 5 J=1,NDIS
      F(I,J,K) = ZERO
      DF(I,J,K) = ZERO
 5    continue
      IFAIL = 1
C
c      CALL D02BAF(RAFIN,AO,NEQ,G,EPSD,NAGPOT_compak,work,IFAIL)
c
C    The following line is a warning that should be removed once D02PVF
C    and D02PCF are replaced.
      WRITE(IWRITE,*) 'NAG routine not replaced. This part of the program
     1 does not work in this version of the code'
!NV-03      CALL D02PVF(neq,RAFIN,G,AO,EPSD,thres,2,'usualtask',.false.,
!NV-03     * zero,work,14*neq,IFAIL)
!NV-03      CALL D02PCF(nagpot_compak,AO,rafin,G,gp,gmax,work,IFAIL)
c   
C      RAFIN SHOULD EQUAL A0 ON EXIT IF NO ERRORS
      IF(IFAIL.NE.0) WRITE(IWRITE,1) IFAIL,RAFIN
 1    FORMAT(/' D02BAF failed IFAIL=',I1,' at R=',F8.4)
C
      F(I,I,K) = G(1)
      DF(I,I,K) = G(2)
 4    CONTINUE
 3    CONTINUE
C
      IF(LBUG.GE.1) WRITE(IWRITE,2) RAFIN,BIGKSQ,((F(I,I,K),DF(I,I,K),
     1K=1,2),I=1,NDIS)
 2    FORMAT(/' SOLUTIONS AT R=',F6.3,'  KSQ=',F10.4,/(8D15.6))
      RETURN
      END
      SUBROUTINE SPLITM_compak(NDIS,ND2,MDMAX,TRIANG,SQUARC,DISM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     SPLITM unpacks data describing the potentials in the dissociating
C     channels. It must match DISINI in VIBRMT.
C
C***********************************************************************
C
      DIMENSION SQUARC(NDIS,NDIS,*),DISM(5,NDIS),TRIANG(ND2,*)
      DATA EPS/1.D-4/,ZERO/0.D0/
C
      NDSQ = NDIS*(NDIS+1)/2
      DO 11 K=1,MDMAX
      DO 10 J=1,NDIS
      DO 1 I=1,NDIS
      SQUARC(I,J,K) = ZERO
 1    continue
 10   continue
 11   continue
      LAST = NDSQ+6*(NDIS-1)+1
      MDMIN = INT(TRIANG(LAST,1)+EPS)
      II = 0
      IPT = NDSQ-5
      DO 20 I=1,NDIS
      II = II+I
      IPT = IPT+6
      KK = 0
      DO 3 K=MDMIN,MDMAX
      KK = KK+1
      SQUARC(I,I,K) = TRIANG(II,KK)
 3    continue
      DO 2 K=1,5
      DISM(K,I) = TRIANG(IPT+K,1)
 2    continue
 20   continue
C
      RETURN
      END
      SUBROUTINE INTIN_compak(RMATR,RAFIN,FX,FX1,NP,NA,Y,DY,HX,MAXPTS,
     1 TOL,IBUG,IWRITE)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C     PERFORMS INWARD INTEGRATION FROM POINT RAFIN TO RMATR
C
      EXTERNAL NAGRHS_compak
      LOGICAL START,ONESTP,HIGH
      DIMENSION FX(NP,NP,2),FX1(NP,NP,2),Y(NP),DY(NP)
      double precision, allocatable :: fr(:),frm(:),yr(:),wk(:)
      DATA ONESTP,HIGH/.FALSE.,.TRUE./,IFAIL/0/,ZERO/0.D0/
C
C      LRWORK = 16+20*NP
      lrwork = 16+1000*np
      allocate (fr(np),frm(np),yr(np),wk(lrwork))
C
C     GENERATE (NP BY NP+NA)-DIMENSIONAL SOLUTION MATRIX IN REGION 2.
C     NP EQUATIONS ARE INTEGRATED INWARD NP+NA TIMES 
C
      DO 90 J=1,NP+NA
      JA = J - NP
C
C     SET THE BOUNDARY CONDITIONS-
C
      IF(J.LE.NP) THEN
        DO 30 I=1,NP
        Y(I) = FX(I,J,1)
        DY(I) = FX1(I,J,1)
   30   CONTINUE
      ELSE
        DO 40 I=1,NP
        Y(I) = FX(I,JA,2)
        DY(I) = FX1(I,JA,2)
   40   CONTINUE
      ENDIF
C
      START = .TRUE.
      FR(1) = ZERO
      FRM(1) = ZERO
C    The following line is a warning that should be removed once D02LXF
C    is replaced.
C      WRITE(IWRITE,*) 'NAG routine D02LXF not replaced. This part of the
C     1 program does not work in this version of the code'
!NV-03      CALL D02LXF(NP,HX,TOL,FR,FRM,MAXPTS,START,ONESTP,HIGH,WK,LRWORK,
!NV-03      * IFAIL)
C
C      X = RAFIN
c
!NV-03 10   CALL D02LAF(NAGRHS_compak,NP,X,RMATR,Y,DY,YR,WK,LRWORK,IFAIL)
C
C      IF(X.LT.RMATR) GO TO 10
C    The following line is a warning that should be removed once D02LAF
C    is replaced.
C  10  write(IWRITE,*)'Replacement for NAG integration routines not
C     1  implemented. This part of the  program does not work in
C     2  this version of the code (NV, November 2003)'
C
C     OPTIONAL DIAGNOSTICS
C      IF(IBUG.NE.0) THEN
!NV-03        CALL D02LYF(NP,HNEXT,HUSED,HSTART,NSUCC,NFAIL,NATT,FR,
!NV-03     1  FRM,WK,LRWORK,IFAIL)
C    The following line is a warning that should be removed once D02LYF
C    is replaced.
C        write(IWRITE,*)'Replacement for NAG integration routines
C     1  (diagnostics) not implemented. This part of the  program does
C     2  not work in this version of the code (NV, November 2003)'
!NV-03        WRITE(IWRITE,1001) HSTART,HUSED,HNEXT,NSUCC,NFAIL,NATT
C      ENDIF
C
C  If Runge-Kutta-Nystrom integration is used to propagate wavefunction,
C  following tens of statements labeled with 'CCC' have to be activated.
C
C      setup Runge-Kutta-Nystrom integration
      high = .FALSE. !AlexH
      call rknset(np,hx,tol,fr,frm,maxpts,start,onestp,high,lrwork,wk,
     * ifail)

      X = RAFIN
C      do Runge-Kutta-Nystrom intergration
   10 call rknint(nagrhs_compak,np,x,rmatr,y,dy,yr,wk,ifail)
      !print *, 'x=',X
C      if rmat radius not reached, keep trying
C      IF(X.LT.RMATR) GO TO 10
      if(x.gt.rmatr) then
      ifail=0
      go to 10
      end if
C      OPTIONAL DIAGNOSTICS
      IF(IBUG.NE.0) THEN !recomment to turn off de bug AlexH
         call rkndia(np,hnext,hused,hstart,nsucc,nfail,natt,fr,frm,wk)
         WRITE(IWRITE,1001) HSTART,HUSED,HNEXT,NSUCC,NFAIL,NATT
      
      ENDIF
C
C     STORE THE VALUES OF THE FUNCTION AND DERIVATIVE AT THE BOUNDARY
C
      IF(J.LE.NP) THEN
        DO 80 I=1,NP
        FX(I,J,1) = Y(I)
        FX1(I,J,1) = DY(I)
   80   CONTINUE
      ELSE
        DO 81 I=1,NP
        FX(I,JA,2) = Y(I)
        FX1(I,JA,2) = DY(I)
   81   CONTINUE
      ENDIF
C
   90 CONTINUE
      deallocate (fr,frm,yr,wk)
C
      RETURN
 1001 FORMAT(/'  D02LAF DIAGNOSTICS'//'   START MESH ',D12.4,
     1 '   FINAL MESH ',D12.4,'    NEXT MESH ',D12.4/
     2 '   SUCCESSES',I5,'   FAILURES',I5,'    ATTEMPTS',I5)
      END
      SUBROUTINE MERGE_compak(NCHAN,NVCHAN,NDIS,NVOPEN,NDOPEN,FX,FXP,FV,
     1FVP,FD,FDP)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MERGE MERGES SOLUTIONS AND DERIVATIVES IN BOTH VIBRATIONAL AND
C      DISSOCIATING CHANNELS
C
C***********************************************************************
C
      DIMENSION FX(NCHAN,NCHAN,2),FXP(NCHAN,NCHAN,2),
     1FV(NVCHAN,NVCHAN,2),FVP(NVCHAN,NVCHAN,2),FD(*),FDP(*)
      DATA ZERO/0.D0/
C
      NOPEN = NVOPEN+NDOPEN
      DO 12 K=1,2
      DO 11 J=1,NCHAN
      DO 1 I=1,NCHAN
      FX(I,J,K) = ZERO
      FXP(I,J,K) = ZERO
 1    continue
 11   continue
 12   continue
C
C---- OPEN VIBRATIONAL CHANNELS
      DO 22 K=1,2
      DO 21 J=1,NVOPEN
      DO 2 I=1,NVCHAN
      FX(I,J,K) = FV(I,J,K)
      FXP(I,J,K) = FVP(I,J,K)
 2    continue
 21   continue
 22   continue
C
C---- PUT CLOSED CHANNEL FUNCTIONS IN CORRECT PLACES
      DO 31 J=1,NVCHAN-NVOPEN
      DO 3 I=1,NVCHAN
      FX(I,J+NOPEN,2) = FV(I,J+NVOPEN,1)
      FX(I,J+NOPEN,1) = ZERO
      FXP(I,J+NOPEN,2) = FVP(I,J+NVOPEN,1)
      FXP(I,J+NOPEN,1) = ZERO
 3    continue
 31   continue
C
C---- DISSOCIATING CHANNELS
      KJ = 0
      DO 41 K=1,2
      DO 4 J=1,NDIS
      DO 5 I=1,NDIS
      KJ = KJ+1
      IF(J.GT.NDOPEN) THEN
        IF(K.EQ.1) THEN
          FX(NVCHAN+I,NVCHAN+J,2) = FD(KJ)
          FXP(NVCHAN+I,NVCHAN+J,2) = FDP(KJ)
        ELSE
          FX(NVCHAN+I,NVCHAN+J,1) = ZERO
          FXP(NVCHAN+I,NVCHAN+J,1) = ZERO
        ENDIF
      ELSE
        FX(NVCHAN+I,NVOPEN+J,K) = FD(KJ)
        FXP(NVCHAN+I,NVOPEN+J,K) = FDP(KJ)
      ENDIF
 5    CONTINUE
 4    CONTINUE
 41   continue
C
      RETURN
      END
      SUBROUTINE POTL_compak(NCHAN,LAMAX,ION,LCHL,CF,NBASIS,R,V)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     POTL CALCULATES THE VALUES OF THE ASYMPTOTIC POTENTIAL IN THE FORM
C     REQUIRED BY THE R-MATRIX PROPAGATOR ROUTINE RPROP.
C
C     THE POTENTIALS ARE EXPANDED IN INVERSE POWERS OF THE RADIAL
C     DISTANCE R, WITH EXPANSION COEFFICIENTS GIVEN IN THE MATRIX CF
C
C***********************************************************************
C
      DIMENSION R(NBASIS),V(NCHAN,NCHAN,NBASIS)
      DIMENSION CF(NCHAN,NCHAN,*),LCHL(NCHAN)
C
      DATA ZERO/0.0D0/,ONE/1.0D0/,TWO/2.0D0/
C
      DO 4 I=1,NCHAN
      EL2 = LCHL(I)*(LCHL(I)+1)
      DO 3 J=1,NCHAN
      DO 1 IR=1,NBASIS
      VP = ZERO
      RR = ONE/R(IR)
      IF(I.EQ.J) VP=-TWO*Dble(ION)*RR+EL2*RR*RR
      DO 2 K=1,LAMAX
      VP = VP+CF(I,J,K)*RR**(K+1)
 2    CONTINUE
      V(I,J,IR) = VP
 1    continue
 3    continue
 4    continue
C
      RETURN
      END
      SUBROUTINE SQUARM_compak(NDIM,NMAT,TRIANG,SQUARE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     SQUARM PUTS LOWER TRIANGLES BACK INTO SQUARE MATRICES)
C
C***********************************************************************
C
      DIMENSION SQUARE(NDIM,NDIM,NMAT),TRIANG(*)
C
      K = 0
      DO 3 L=1,NMAT
      DO 2 I=1,NDIM
      DO 1 J=1,I
      K = K+1
      SQUARE(I,J,L) = TRIANG(K)
      SQUARE(J,I,L) = TRIANG(K)
 1    continue
 2    continue
 3    continue
C
      RETURN
      END
      SUBROUTINE KMAT_compak(NCHAN,BSTO,NOPEN,F,FP,RMAT,AKMAT,fkmat)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     K-MATRIX CALCULATION
C
C     NCHAN        NUMBER OF CHANNELS
C     BSTO         LOGARITHMIC DERIVATIVE/MATCHING RADIUS
C     NOPEN        NUMBER OF OPEN CHANNELS
C     F, FP        EXTERNAL REGION SOLUTIONS AND DERIVATIVES
C                  (ASSUMED IN CORRECT LOCATIONS)
C     RMAT         INTERNAL REGION R-MATRIX
C
C     OUTPUT :
C     AKMAT        K-MATRIX
C     fkmat          The full K-matrix including closed channels
C               needed for compak - AlexH 11.11.10
C
C     AA,BB        WORK SPACE, EACH OF LENGTH NCHAN*NCHAN
C     X            WORK SPACE, OF LENGTH 2*NCHAN
C
C***********************************************************************
C
      DIMENSION RMAT(NCHAN,NCHAN),AKMAT(NOPEN,NOPEN),F(NCHAN,NCHAN,2),
     X          FP(NCHAN,NCHAN,2),AA(NCHAN,NCHAN),BB(NCHAN,NCHAN),
     X          X(2*nchan),BSTO(NCHAN), fkmat(nchan,nchan)
C
      DATA ZERO/0.0D0/
C
      AKMAT=0d0;fkmat=0d0;AA=0d0;BB=0d0;X=0d0
      DO 11 J=1,NCHAN
      DO 10 I=1,NCHAN
      AA(I,J) = F(I,J,2)
 10   continue
 11   continue
C
      DO 22 J=1,NCHAN
      DO 21 K=1,NCHAN
      DF = FP(K,J,2)-BSTO(K)*F(K,J,2)
      DO 20 I=1,NCHAN
      AA(I,J) = AA(I,J)-RMAT(I,K)*DF
 20   continue
 21   continue
 22   continue
C
      DO 41 J=1,NOPEN
      DO 40 I=1,NCHAN
      BB(I,J)=-F(I,J,1)
 40   continue
 41   continue
C
      DO 52 J=1,NOPEN
      DO 51 K=1,NCHAN
      DF = FP(K,J,1)-BSTO(K)*F(K,J,1)
      DO 50 I=1,NCHAN
      BB(I,J)=BB(I,J)+RMAT(I,K)*DF
   50 CONTINUE
 51   continue
 52   continue
C
!c     <test> AlexH
!       print *, 'F prime'
!        do i=1,nchan
!         write(6001,'(100E20.10)')  (FP(i,j,2),j=1,nchan) 
!        end do
!       print *, 'AA followed by BB'
!       do j=1,nchan
!       do i=1,nchan
!         write(6,931) i,j, AA(i,j) 
!       end do
!       end do
!        print *, ' BB'
!       do j=1,nopen
!       do i=1,nchan
!         write(6,931) i,j, BB(i,j) 
!       end do
!       end do
!       print *, ' RMAT'
!       do j=1,nchan
!       do i=1,nchan
!         write(6,931) i,j, RMAT(i,j) 
!       end do
!       end do
!     </test>

931   FORMAT(i5,3x,i5,3x,2(D15.5,3x))
      IF(NCHAN.EQ.1) THEN
        BB(1,1)=BB(1,1)/AA(1,1)
      ELSE
        CALL MA01A(AA,BB,NCHAN,NOPEN,0,NCHAN,NCHAN,X,X(NCHAN+1))
      ENDIF
C
      fkmat=BB
      DO 91 J=1,NOPEN
      DO 90 I=1,NOPEN
      AKMAT(I,J) = BB(I,J)
 90   continue
 91   continue
C
      RETURN
      END
      SUBROUTINE KMAT_MKL(NCHAN,BSTO,NOPEN,F,FP,RMAT,AKMAT,fkmat)
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      use blas95_compak
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     K-MATRIX CALCULATION
C
C     NCHAN        NUMBER OF CHANNELS
C     BSTO         LOGARITHMIC DERIVATIVE/MATCHING RADIUS
C     NOPEN        NUMBER OF OPEN CHANNELS
C     F, FP        EXTERNAL REGION SOLUTIONS AND DERIVATIVES
C                  (ASSUMED IN CORRECT LOCATIONS)
C     RMAT         INTERNAL REGION R-MATRIX
C
C     OUTPUT :
C     AKMAT        K-MATRIX
C     fkmat          The full K-matrix including closed channels
C              needed for compak - AlexH 11.11.10
C
C     AA,BB        WORK SPACE, EACH OF LENGTH NCHAN*NCHAN
C     X            WORK SPACE, OF LENGTH 2*NCHAN
C
C***********************************************************************
C
      DIMENSION RMAT(NCHAN,NCHAN),AKMAT(NOPEN,NOPEN),F(NCHAN,NCHAN,2),
     X          FP(NCHAN,NCHAN,2),AA(NCHAN,NCHAN),BB(NCHAN,NCHAN),
     X          X(2*nchan),BSTO(NCHAN), fkmat(nchan,nchan)
C
      integer, parameter :: idp = kind(1d0) 
      integer(blasint),allocatable :: ipiv(:)
      real(kind=idp),allocatable  :: temp_matrix(:,:)!,temp_matrix2
      DATA ZERO/0.0D0/
C
      AKMAT=0d0;fkmat=0d0;AA=0d0;BB=0d0;X=0d0
      DO 11 J=1,NCHAN
      DO 10 I=1,NCHAN
      AA(I,J) = F(I,J,2)
 10   continue
 11   continue
C
      DO 22 J=1,NCHAN
      DO 21 K=1,NCHAN
      DF = FP(K,J,2)-BSTO(K)*F(K,J,2)
      DO 20 I=1,NCHAN
      AA(I,J) = AA(I,J)-RMAT(I,K)*DF
 20   continue
 21   continue
 22   continue
C
      DO 41 J=1,NOPEN
      DO 40 I=1,NCHAN
      BB(I,J)=-F(I,J,1)
 40   continue
 41   continue
C
      DO 52 J=1,NOPEN
      DO 51 K=1,NCHAN
      DF = FP(K,J,1)-BSTO(K)*F(K,J,1)
      DO 50 I=1,NCHAN
      BB(I,J)=BB(I,J)+RMAT(I,K)*DF
   50 CONTINUE
 51   continue
 52   continue
C


931   FORMAT(i5,3x,i5,3x,2(D15.5,3x))
      IF(NCHAN.EQ.1) THEN
        BB(1,1)=BB(1,1)/AA(1,1)
      ELSE
        allocate(ipiv(nchan),temp_matrix(nchan,nchan))
!         allocate(temp_matrix2(nchan,nchan))
        ipiv=0
        temp_matrix=AA
!         temp_matrix2=BB
        call getrf(temp_matrix,ipiv)
        call getrs(temp_matrix,ipiv,BB)
!         CALL MA01A(AA,BB,NCHAN,NOPEN,0,NCHAN,NCHAN,X,X(NCHAN+1))
      ENDIF
C
      fkmat=BB
      DO 91 J=1,NOPEN
      DO 90 I=1,NOPEN
      AKMAT(I,J) = BB(I,J)
 90   continue
 91   continue
C
      RETURN
      END
      SUBROUTINE RPROPX_compak(NCHAN,NVCHAN,NDIS,CRV,CRD,RMAT,IPFLG,
     1IWRITE,IBACK)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     RPROPX MERGES GLOBAL R-MATRICES INTO A SUPER GLOBAL R-MATRIX
C      THEN PROPAGATES THE INPUT SUPER R-MATRIX IN ONE STEP TO THE
C      REQUIRED RADII
C
C***********************************************************************
C
      DIMENSION RMAT(NCHAN,NCHAN),CRV(*),CRD(*),wk(nchan),
     * r11(nchan*(nchan+1)/2),r22(nchan*(nchan+1)/2),
     * r12(nchan*nchan)
      DATA ICOL/6/,ZERO/0.D0/
C
C     SIGN is set to 1 for propagating forward and -1 for 
C          propagating backwards
      SIGN=REAL(IBACK)
C
      NCHSQ = NCHAN*NCHAN
      NCH2 = (NCHSQ+NCHAN)/2
      NVCHSQ = NVCHAN*NVCHAN
      NVCH2 = (NVCHSQ+NVCHAN)/2
      NDSQ = NDIS*NDIS
      ND2 = (NDSQ+NDIS)/2
C
      IV11 = 1
      IV12 = IV11+NVCH2
      IV22 = IV12+NVCHSQ
      ID11 = 1
      ID12 = ID11+ND2
      ID22 = ID12+NDSQ
C
      DO 7 I=1,nch2
      r11(I) = ZERO
      r22(i) = zero
 7    continue
      do 8 i=1,nchsq
      r12(i) = zero
 8    continue
C
      K = 0
      DO 11 I=1,NVCHAN
      DO 1 J=1,I
      K = K+1
      R11(K) = CRV(IV11+K-1)
      R22(K) = CRV(IV22+K-1)
 1    continue
 11   continue
      KD = -1
      DO 21 I=1,NDIS
      K = K+NVCHAN
      DO 2 J=1,I
      KD = KD+1
      K = K+1
      R11(K) = CRD(ID11+KD)
      R22(K) = CRD(ID22+KD)
 2    continue
 21   continue
C
      KR = IV12-1
      K = -NCHAN
      DO 31 I=1,NVCHAN
      K = K+NCHAN
      DO 3 J=1,NVCHAN
      KR = KR+1
      R12(K+J) = CRV(KR)
 3    continue
 31   continue
      K = K+NCHAN
      KD = ID12-1
      DO 41 I=1,NDIS
      K = K+NVCHAN
      DO 4 J=1,NDIS
      K = K+1
      KD = KD+1
      R12(K) = CRD(KD)
 4    continue
 41   continue
C
C----- ADD LOWER TRIANGLE OF R-MULTIPLIED R-MATRIX TO R11
      K = 0
      DO 51 J=1,NCHAN
      DO 5 I=1,J
      K = K+1
      R11(K) = R11(K)+ SIGN*RMAT(I,J)
 5    continue
 51   continue
C
C----- EVALUATE MATRIX EXPRESSION TO GET LOWER TRIANGLE OF NEW
C      R-MULTIPLIED R-MATRIX
      CALL FACTOR(NCHAN,R11,WK)
      CALL MULTC(NCHAN,NCHAN,R11,R12)
      CALL MULTD(NCHAN,NCHAN,R12,R22,R11,WK)
C
C      UNPACK FINAL R-MATRIX
      K = 0
      DO 61 J=1,NCHAN
      DO 6 I=1,J
      K = K+1
      RMAT(I,J) = SIGN*R11(K)
      RMAT(J,I) = RMAT(I,J)
 6    continue
 61   continue
C
      IF(IPFLG.GT.0) THEN
        WRITE(IWRITE,1013)
 1013   FORMAT(/' FINAL R-MATRIX IS'/)
        CALL WRECMT(RMAT,NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
      ENDIF
C
      RETURN
      END
      SUBROUTINE WRONSK_compak(NCHAN,NOPEN,F,FP,IWRITE,IDIAG,EPS)
C
C***********************************************************************
C
C     WRONSK  PRINTS THE ASYMPTOTIC WAVEFUNCTIONS, F AND THEIR
C                    DERIVATIVES, FP, IF IDIAG IS NONZERO.
C
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             NOPEN     IS THE NUMBER OF OPEN CHANNELS ( ORDERED FIRST )
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C             F,FP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DIMENSION F(NCHAN,NCHAN,2),FP(NCHAN,NCHAN,2)
C
      DATA  ZERO/0.0D0/,ONE/1.0D0/
C
 1000 FORMAT(1X,4D30.15)
 1010 FORMAT(/,' REGULAR FUNCTIONS')
 1020 FORMAT(/,' REGULAR DERIVATIVES')
 1030 FORMAT(/,' IRREGULAR FUNCTIONS')
 1040 FORMAT(/,' IRREGULAR DERIVATIVES')
 1050 FORMAT(/,' MULTICHANNEL WRONSKIAN RELATIONS :',/,' I0 =',I3,/)
 1060 FORMAT(' I1 =',I3,5X,' I2 =',I3,5X,'WRONSKIAN =',D30.17)
 1070 FORMAT(' I0 =',I3,5X,' I1 =',I3,5X,' I2 =',I3,5X,'WRONSKIAN =',
     X       D30.17)
C
C     PRINT VALUES OF ASYMPTOTIC FUNCTIONS AND THEIR DERIVATIVES
C
      IF(IDIAG .EQ. 0) GO TO 50
      WRITE(IWRITE,1010)
      DO 10 I=1,NCHAN
      WRITE(IWRITE,1000) (F(I,J,1),J=1,NCHAN)
   10 CONTINUE
      WRITE(IWRITE,1020)
      DO 20 I=1,NCHAN
      WRITE(IWRITE,1000) (FP(I,J,1),J=1,NCHAN)
   20 CONTINUE
      WRITE(IWRITE,1030)
      DO 30 I=1,NCHAN
      WRITE(IWRITE,1000) (F(I,J,2),J=1,NCHAN)
   30 CONTINUE
      WRITE(IWRITE,1040)
      DO  40  I=1,NCHAN
      WRITE(IWRITE,1000) ( FP(I,J,2),J=1,NCHAN)
   40 CONTINUE
C
C     CHECK MULTICHANNEL WRONSKIAN RELATIONS FOR SOLUTIONS
C
   50 DO 82 I0=1,2
      IF(IDIAG .NE. 0) WRITE(IWRITE,1050) I0
C
      DO 81 J1=1,NCHAN
      DO 80 J2=1,NCHAN
      SUM=ZERO
      TSUM=ZERO
      DO 60 I=1,NCHAN
      SUM=SUM+FP(I,J1,1)*F(I,J2,I0)-F(I,J1,1)*FP(I,J2,I0)
   60 CONTINUE
C
      IF(IDIAG .eq. 0) then
        IF(I0.EQ.2 .AND. J1.EQ.J2 .AND. J1.LE.NOPEN) TSUM=ONE
        IF(DABS(SUM-TSUM) .gt. EPS) WRITE(IWRITE,1070)I0,J1,J2,SUM
      else
        WRITE(IWRITE,1060)J1,J2,SUM
      endif
C
   80 CONTINUE
 81   continue
 82   continue
C
      RETURN
      END
      subroutine curlyr_back_prop_test(nchan,rmatr,rafinv,rmat,cr,rvib2)
C
C***********************************************************************
C
C     CURLYR_BACK_PROP PROPAGATES THE RADIAL FUNCTIONS FROM THE MATCHING  
C                      RADIUS TO THE R-MATRIX BOUNDARY USING THE GLOBAL
C                      R-MATRIX PROPAGATOR USED FOR THE FOWARD
C                      PROPAGATION.
c
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             INPUTS
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             CR        THE CURLY R MATRIX
C             RMAT      THE
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C
C             F,FP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      implicit none

!     Argument variables
      integer :: nchan
      real(kind=8) :: rmatr,rafinv
      real(kind=16) :: rmat(nchan*nchan)
      real(kind=8) ::  cr(2*nchan*nchan+nchan),rvib2(nchan*nchan)

!     Local variables
      integer :: ir11,ir12,ir22, i,j,k,m,info
      integer(blasint), allocatable :: ipiv(:)
      real(kind=16), allocatable ::r11(:,:),r12(:,:),r21(:,:),
     * r22(:,:), rmat_test(:,:),matrix_identity(:,:),rmat_inverse(:,:), 
     * temp_matrix(:,:), r22_minus_rmat(:,:)
      real(kind=16) :: total_error

c         Test back propagation of the R-matrix
c         Expand and extract curly R-matrices
      print *, 'Before any allocation'
      allocate(r11(nchan,nchan),r12(nchan,nchan),
     *         r21(nchan,nchan),r22(nchan,nchan),
     *         r22_minus_rmat(nchan,nchan))
      r11=0.0d0;r12=0.0d0;r21=0.0d0;r22=0.0d0;r22_minus_rmat=0.0d0
      print *, 'After first allocation'
c         should be declared 
      ir11=1
      ir12=ir11+(nchan**2+nchan)/2
      ir22=ir12+nchan**2

      k=0;m=0
      do j=1,nchan
        do i=1,nchan
          r12(i,j)=cr(ir12+m)
          r21(j,i)=cr(ir12+m)
          m=m+1
        end do
      end do
      call quad_squarm(nchan,1,cr(ir11:ir12-1),r11)
      call quad_squarm(nchan,1,cr(ir22:),r22)


    
      k=1
      do j=1,nchan
        do i=1,nchan
          r22_minus_rmat(i,j)=r22(i,j)-rmat(k) ! Back propagation
!               r11(i,j)=r11(i,j)+rvib2(k) ! Forward propagation
          k=k+1
        end do
      end do

!       Invert R-matrix
      allocate(matrix_identity(nchan,nchan))
      print *, 'After 2nd allocation'
      matrix_identity=0.0d0

      do i=1,nchan
        matrix_identity(i,i)=1.0d0
      end do

      info=0
      allocate(ipiv(nchan),temp_matrix(nchan,nchan))
      print *, 'After 3rd allocation'
      ipiv=0 
      temp_matrix=r22_minus_rmat  ! Back propagation
!           temp_matrix=r11  ! Forward propagation
      


      allocate(rmat_inverse(nchan,nchan))
      print *, 'After 4th allocation'
      rmat_inverse=matrix_identity

!     MKL LAPACK f95 routines
!       call getrf(temp_matrix,ipiv)
!       call getrs(temp_matrix,ipiv,rmat_inverse)

!     Quad precision version of MA01A

      call quad_MA01A_f95(temp_matrix,rmat_inverse,nchan,nchan)
      rmat_inverse=temp_matrix


      allocate(rmat_test(nchan,nchan))
      rmat_test=0.0d0        

      rmat_test=matmul(matmul(r12,rmat_inverse),r21)-r11!Back prop
!           rvib_test=r22-matmul(matmul(r21,rmat_inverse),r12) !Forward

      total_error=0.d0
      k=1
      do j=1,nchan
        do i=1,nchan
           total_error=total_error+rmat_test(i,j)-rvib2(k)
           write(11236,'(i5,i5,2d20.5)') i,j,rmat_test(i,j),rvib2(k)
           k=k+1
        end do
      end do
      write(11236,*) ""
      write(11235,'(/,"TOTAL ERROR", d20.5)')  total_error

!       write(11235,'(/,"R-matrix at r=a")') 
!        write(11235,*) rmat_test

      end subroutine curlyr_back_prop_test
      subroutine curlyr_forward_prop_test(nchan,rmatr,rafinv,rmat,cr,
     *                                    rvib2,rmat_quad)
C
C***********************************************************************
C
C CURLYR_FORWARD_PROP PROPAGATES THE RADIAL FUNCTIONS FROM THE MATCHING  
C                      RADIUS TO THE R-MATRIX BOUNDARY USING THE GLOBAL
C                      R-MATRIX PROPAGATOR USED FOR THE FOWARD
C                      PROPAGATION.
c
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             INPUTS
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             CR        THE CURLY R MATRIX
C             RMAT      THE
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C
C             F,FP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      implicit none

!     Argument variables
      integer :: nchan
      real(kind=8) :: rmatr,rafinv
      real(kind=8) :: rmat(nchan*nchan), cr(2*nchan*nchan+nchan),
     * rvib2(nchan*nchan)
      real(kind=16) :: rmat_quad(nchan*nchan)
!     Local variables
      integer :: ir11,ir12,ir22, i,j,k,m,info
      integer(blasint), allocatable :: ipiv(:)
      real(kind=16), allocatable ::r11(:,:),r12(:,:),r21(:,:),
     * r22(:,:), rmat_test(:,:),matrix_identity(:,:),rmat_inverse(:,:), 
     * temp_matrix(:,:), r11_plus_rmat(:,:)
      real(kind=16) :: total_error

c         Test back propagation of the R-matrix
c         Expand and extract curly R-matrices

      allocate(r11(nchan,nchan),r12(nchan,nchan),
     *         r21(nchan,nchan),r22(nchan,nchan),
     *         r11_plus_rmat(nchan,nchan))
      r11=0.0d0;r12=0.0d0;r21=0.0d0;r22=0.0d0;r11_plus_rmat=0.0d0

      ir11=1
      ir12=ir11+(nchan**2+nchan)/2
      ir22=ir12+nchan**2

      k=0;m=0
      do j=1,nchan
        do i=1,nchan
          r12(i,j)=cr(ir12+m)
          r21(j,i)=cr(ir12+m)
          m=m+1
        end do
      end do
!       call squarm(nchan,1,cr(ir11:ir12-1),r11)
!       call squarm(nchan,1,cr(ir22:),r22)
      call quad_squarm(nchan,1,cr(ir11:ir12-1),r11)
      call quad_squarm(nchan,1,cr(ir22:),r22)


      write(11237,*) 'R11,  RMAT'
      k=1
      do j=1,nchan
        do i=1,nchan
           write(11237,'(i5,i5,2d40.20)') i,j,r11(i,j),rvib2(k)
           k=k+1
        end do
      end do
      write(11237,*) ""
    
      k=1
      do j=1,nchan
        do i=1,nchan
            r11_plus_rmat(i,j)=r11(i,j)+rvib2(k) ! Forward propagation
          k=k+1
        end do
      end do

      write(11237,*) 'R11 + RMAT'
      do j=1,nchan
        do i=1,nchan
           write(11237,'(i5,i5,2d40.20)') i,j,r11_plus_rmat(i,j)

        end do
      end do
      write(11237,*) ""

!       Invert R-matrix
      allocate(matrix_identity(nchan,nchan))
      matrix_identity=0.0d0

      do i=1,nchan
        matrix_identity(i,i)=1.0d0
      end do

      info=0
      allocate(ipiv(nchan),temp_matrix(nchan,nchan))
      ipiv=0 
      temp_matrix=r11_plus_rmat

      allocate(rmat_inverse(nchan,nchan))
      rmat_inverse=matrix_identity

!     MKL LAPACK f95 routines

!       call getrf(temp_matrix,ipiv)
!       call getrs(temp_matrix,ipiv,rmat_inverse)

!     Quad precision version of MA01A

      call quad_MA01A_f95(temp_matrix,rmat_inverse,nchan,nchan)
      rmat_inverse=temp_matrix

      write(11237,*) 'R11 + RMAT INVERTED'
      do j=1,nchan
        do i=1,nchan
           write(11237,'(i5,i5,2d40.20)') i,j,rmat_inverse(i,j)

        end do
      end do
      write(11237,*) ""

      allocate(rmat_test(nchan,nchan))
      rmat_test=0.0d0
        
!       rmat_test=matmul(matmul(r12,rmat_inverse),r21)-r11!Back prop
      rmat_test=r22-matmul(matmul(r21,rmat_inverse),r12) !Forward

      total_error=0.d0
      k=1
      write(11237,*) 'RMATRIX COMPARISON'
      do j=1,nchan
        do i=1,nchan
           write(11237,'(i5,i5,2d40.20)') i,j,rmat_test(i,j),rmat(k)
           rmat_quad(k)=rmat_test(i,j)
           k=k+1
        end do
      end do
      write(11237,*) ""

 

!       write(11235,'(/,"R-matrix at r=a")') 
!        write(11235,*) rmat_test

      end subroutine curlyr_forward_prop_test
      subroutine curlyr_back_prop(nchan,rmatr,rafinv,rmat_at_a,rmat,cr,
     *                            fx,fxp)
C
C***********************************************************************
C
C     CURLYR_BACK_PROP PROPAGATES THE RADIAL FUNCTIONS FROM THE MATCHING  
C                      RADIUS TO THE R-MATRIX BOUNDARY USING THE GLOBAL
C                      R-MATRIX PROPAGATOR USED FOR THE FOWARD
C                      PROPAGATION.
c
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             INPUTS
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             CR        THE CURLY R MATRIX
C             RMAT      THE R-MATRIX
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C
C             FX,FXP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      implicit none

!     Argument variables
      integer :: nchan
      double precision :: rmatr,rafinv
      double precision :: rmat_at_a(nchan*nchan),rmat(nchan*nchan),
     * cr(2*nchan*nchan+nchan),fx(nchan,nchan,2),fxp(nchan,nchan,2)

!     Local variables
      integer :: ir11,ir12,ir22, i,j,k,m,info
      integer(blasint), allocatable :: ipiv(:)
      double precision, allocatable ::r11(:,:),r12(:,:),r21(:,:),
     * r22(:,:), rmat_prop(:,:),matrix_identity(:,:),rmat_inverse(:,:), 
     * temp_matrix(:,:),fx_prop(:,:,:),fxp_prop(:,:,:),
     * curlyr_inverse(:,:), r22_minus_rmat(:,:)

c     Expand and extract curly R-matrices
c     -----------------------------------
      allocate(r11(nchan,nchan),r12(nchan,nchan),
     *         r21(nchan,nchan),r22(nchan,nchan),
     *         r22_minus_rmat(nchan,nchan))
      r11=0.0d0;r12=0.0d0;r21=0.0d0;r22=0.0d0;r22_minus_rmat=0.0d0

c     Determine first index of each matrix
      ir11=1
      ir12=ir11+(nchan**2+nchan)/2
      ir22=ir12+nchan**2

      k=0;m=0
      do j=1,nchan
        do i=1,nchan
          r12(i,j)=cr(ir12+m)
          r21(j,i)=cr(ir12+m)
          m=m+1
        end do
      end do
      call squarm_compak(nchan,1,cr(ir11:ir12-1),r11)
      call squarm_compak(nchan,1,cr(ir22:),r22)
    
      k=1
      do j=1,nchan
        do i=1,nchan
          r22_minus_rmat(i,j)=r22(i,j)-rmat(k) ! Back propagation
!               r11(i,j)=r11(i,j)+rvib2(k) ! Forward propagation
          k=k+1
        end do
      end do

!     Invert R-matrices
      allocate(matrix_identity(nchan,nchan))
      matrix_identity=0.0d0

      do i=1,nchan
        matrix_identity(i,i)=1.0d0
      end do

      info=0
      allocate(ipiv(nchan),temp_matrix(nchan,nchan))
      ipiv=0 
      temp_matrix=r21  ! Back propagation
      
      call getrf(temp_matrix,ipiv)

      allocate(curlyr_inverse(nchan,nchan))

      curlyr_inverse=matrix_identity

      call getrs(temp_matrix,ipiv,curlyr_inverse)

      ipiv=0; info=0;

      k=1
      do j=1,nchan
        do i=1,nchan
          temp_matrix(i,j)=rmat_at_a(k)
          k=k+1
        end do
      end do

      call getrf(temp_matrix,ipiv)

      allocate(rmat_inverse(nchan,nchan))

      rmat_inverse=matrix_identity

      call getrs(temp_matrix,ipiv,rmat_inverse)


      allocate(rmat_prop(nchan,nchan))
      rmat_prop=0.0d0        

      rmat_prop=r12-matmul(matmul(r11,curlyr_inverse),r22_minus_rmat)
 
      allocate(fx_prop(nchan,nchan,2),fxp_prop(nchan,nchan,2))

      fx_prop(:,:,1)=matmul(rmat_prop,fxp(:,:,1))
      fx_prop(:,:,2)=matmul(rmat_prop,fxp(:,:,2))
    

      fxp_prop(:,:,1)=matmul(curlyr_inverse,
     *                       matmul(r22,fxp(:,:,1))-fx(:,:,1))
      fxp_prop(:,:,2)=matmul(curlyr_inverse,
     *                       matmul(r22,fxp(:,:,2))-fx(:,:,2))

!       fxp_prop(:,:,1)=matmul(rmat_inverse,fx_prop(:,:,1))
!       fxp_prop(:,:,2)=matmul(rmat_inverse,fx_prop(:,:,2))

      fx=fx_prop    
      fxp=fxp_prop

      return
      end subroutine curlyr_back_prop
!
!
!     QUAD PRECISION VERSIONS OF SUBROUTINES - Alex H
!     Needed for back propagation
!
!
      subroutine quad_curlyr_back_prop(nchan,rmatr,rafinv,rmat_at_a,
     *                                 rmat,cr,fx,fxp)
C
C***********************************************************************
C
C     CURLYR_BACK_PROP PROPAGATES THE RADIAL FUNCTIONS FROM THE MATCHING  
C                      RADIUS TO THE R-MATRIX BOUNDARY USING THE GLOBAL
C                      R-MATRIX PROPAGATOR USED FOR THE FOWARD
C                      PROPAGATION.
c
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             INPUTS
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             CR        THE CURLY R MATRIX
C             RMAT      THE R-MATRIX
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C
C             FX,FXP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      implicit none

!     Argument variables
      integer :: nchan
      double precision :: rmatr,rafinv
      double precision :: rmat_at_a(nchan*nchan),
     * cr(2*nchan*nchan+nchan),fx(nchan,nchan,2),fxp(nchan,nchan,2)
      real(kind=16) :: rmat(nchan*nchan)
!     Local variables
      integer :: ir11,ir12,ir22, i,j,k,m,info
      integer(blasint), allocatable :: ipiv(:)
      real(kind=16), allocatable ::r11(:,:),r12(:,:),r21(:,:),
     * r22(:,:), rmat_prop(:,:),matrix_identity(:,:),rmat_inverse(:,:), 
     * temp_matrix(:,:),fx_prop(:,:,:),fxp_prop(:,:,:),
     * curlyr_inverse(:,:), r22_minus_rmat(:,:)

c     Expand and extract curly R-matrices
c     -----------------------------------
      allocate(r11(nchan,nchan),r12(nchan,nchan),
     *         r21(nchan,nchan),r22(nchan,nchan),
     *         r22_minus_rmat(nchan,nchan))
      r11=0.0d0;r12=0.0d0;r21=0.0d0;r22=0.0d0;r22_minus_rmat=0.0d0

c     Determine first index of each matrix
      ir11=1
      ir12=ir11+(nchan**2+nchan)/2
      ir22=ir12+nchan**2

      k=0;m=0
      do j=1,nchan
        do i=1,nchan
          r12(i,j)=cr(ir12+m)
          r21(j,i)=cr(ir12+m)
          m=m+1
        end do
      end do
      call quad_squarm(nchan,1,cr(ir11:ir12-1),r11)
      call quad_squarm(nchan,1,cr(ir22:),r22)
    
      k=1
      do j=1,nchan
        do i=1,nchan
          r22_minus_rmat(i,j)=r22(i,j)-rmat(k) ! Back propagation
!               r11(i,j)=r11(i,j)+rvib2(k) ! Forward propagation
          k=k+1
        end do
      end do

!     Invert R-matrices
      allocate(matrix_identity(nchan,nchan))
      matrix_identity=0.0d0

      do i=1,nchan
        matrix_identity(i,i)=1.0d0
      end do

      info=0
      allocate(ipiv(nchan),temp_matrix(nchan,nchan))
      ipiv=0 
      temp_matrix=r21  ! Back propagation

      allocate(curlyr_inverse(nchan,nchan))      
      curlyr_inverse=matrix_identity


      call quad_MA01A_f95(temp_matrix,curlyr_inverse,nchan,nchan)
      curlyr_inverse=temp_matrix

!     LAPACK inversion (not quad prec.)
!       call getrf(temp_matrix,ipiv)
!       call getrs(temp_matrix,ipiv,curlyr_inverse)


      ipiv=0; info=0;

      k=1
      do j=1,nchan
        do i=1,nchan
          temp_matrix(i,j)=rmat_at_a(k)
          k=k+1
        end do
      end do

      allocate(rmat_inverse(nchan,nchan))
      rmat_inverse=matrix_identity

      call quad_MA01A_f95(temp_matrix,rmat_inverse,nchan,nchan)
      rmat_inverse=temp_matrix

!     LAPACK inversion (not quad prec.)
!       call getrf(temp_matrix,ipiv)
!       call getrs(temp_matrix,ipiv,rmat_inverse)


      allocate(rmat_prop(nchan,nchan))
      rmat_prop=0.0d0        

      rmat_prop=r12-matmul(matmul(r11,curlyr_inverse),r22_minus_rmat)
 
      allocate(fx_prop(nchan,nchan,2),fxp_prop(nchan,nchan,2))

      fx_prop(:,:,1)=matmul(rmat_prop,fxp(:,:,1))
      fx_prop(:,:,2)=matmul(rmat_prop,fxp(:,:,2))
    

      fxp_prop(:,:,1)=matmul(curlyr_inverse,
     *                       matmul(r22,fxp(:,:,1))-fx(:,:,1))
      fxp_prop(:,:,2)=matmul(curlyr_inverse,
     *                       matmul(r22,fxp(:,:,2))-fx(:,:,2))

!     Method 2 for propagating fxp (needs rmat_invers)
!       fxp_prop(:,:,1)=matmul(rmat_inverse,fx_prop(:,:,1))
!       fxp_prop(:,:,2)=matmul(rmat_inverse,fx_prop(:,:,2))

      fx=fx_prop    
      fxp=fxp_prop

      return
      end subroutine quad_curlyr_back_prop
!
      subroutine quad_curlyr_back_prop_no_inversion(nchan,rmatr,
     *                           rafinv,rmat_at_a,rmat,cr,fx,fxp)
C
C***********************************************************************
C
C     CURLYR_BACK_PROP PROPAGATES THE RADIAL FUNCTIONS FROM THE MATCHING  
C                      RADIUS TO THE R-MATRIX BOUNDARY USING THE GLOBAL
C                      R-MATRIX PROPAGATOR USED FOR THE FOWARD
C                      PROPAGATION.
c
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             INPUTS
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             CR        THE CURLY R MATRIX
C             RMAT      THE R-MATRIX
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C
C             FX,FXP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      implicit none

!     Argument variables
      integer :: nchan
      double precision :: rmatr,rafinv
      double precision :: rmat_at_a(nchan*nchan),
     * cr(2*nchan*nchan+nchan),fx(nchan,nchan,2),fxp(nchan,nchan,2)
      real(kind=16) :: rmat(nchan*nchan)
!     Local variables
      integer :: ir11,ir12,ir22, i,j,k,m,info
      integer(blasint), allocatable :: ipiv(:)
      real(kind=16), allocatable ::r11(:,:),r12(:,:),r21(:,:),
     * r22(:,:), rmat_prop(:,:),matrix_identity(:,:),rmat_inverse(:,:), 
     * temp_matrix(:,:),fx_prop(:,:,:),fxp_prop(:,:,:),
     * curlyr_inverse(:,:), r22_minus_rmat(:,:)

      real(kind=8), allocatable :: lhs_a(:,:),lhs_af(:,:), rhs(:,:),
     *                             sol_mat(:,:)

      real(kind=8) :: ferr(nchan),berr(nchan),anorm,anorm_temp(nchan)
      real(kind=8) :: rcond
c     Expand and extract curly R-matrices
c     -----------------------------------
      allocate(r11(nchan,nchan),r12(nchan,nchan),
     *         r21(nchan,nchan),r22(nchan,nchan),
     *         r22_minus_rmat(nchan,nchan))
      r11=0.0d0;r12=0.0d0;r21=0.0d0;r22=0.0d0;r22_minus_rmat=0.0d0

c     Determine first index of each matrix
      ir11=1
      ir12=ir11+(nchan**2+nchan)/2
      ir22=ir12+nchan**2

      k=0;m=0
      do j=1,nchan
        do i=1,nchan
          r12(i,j)=cr(ir12+m)
          r21(j,i)=cr(ir12+m)
          m=m+1
        end do
      end do
      call quad_squarm(nchan,1,cr(ir11:ir12-1),r11)
      call quad_squarm(nchan,1,cr(ir22:),r22)
    
      k=1
      do j=1,nchan
        do i=1,nchan
          r22_minus_rmat(i,j)=r22(i,j)-rmat(k) ! Back propagation
!               r11(i,j)=r11(i,j)+rvib2(k) ! Forward propagation
          k=k+1
        end do
      end do

!     Invert R-matrices
      allocate(matrix_identity(nchan,nchan))
      matrix_identity=0.0d0

      do i=1,nchan
        matrix_identity(i,i)=1.0d0
      end do

      info=0
      allocate(ipiv(nchan),temp_matrix(nchan,nchan))
      ipiv=0 
      temp_matrix=r21  ! Back propagation


      allocate(fx_prop(nchan,nchan,2),fxp_prop(nchan,nchan,2))
      fxp_prop(:,:,1)=matmul(r22,fxp(:,:,1))-fx(:,:,1)
      fxp_prop(:,:,2)=matmul(r22,fxp(:,:,2))-fx(:,:,2)

!     TESTING ITERATIVE REFINEMENT
!     -----------------------------
      allocate(lhs_a(nchan,nchan),sol_mat(nchan,nchan),
     *         lhs_af(nchan,nchan),rhs(nchan,nchan))
!     LAPACK inversion (not quad prec.)

      lhs_a=r21
      lhs_af=r21
      call getrf(lhs_af,ipiv)

!     compute the 1-norm for gettinf the condition
      anorm_temp=0
      do i=1,nchan
        anorm_temp=anorm_temp+abs(r21(i,:))
      end do
      anorm=maxval(anorm_temp) 

      call gecon( lhs_af, anorm, rcond)
      write(1003,*) 'anorm,rcond', anorm,rcond

      sol_mat=fxp_prop(:,:,1)
      call getrs(lhs_af,ipiv,sol_mat)
      rhs=fxp_prop(:,:,1)
      call gerfs( lhs_a, lhs_af, ipiv, rhs, sol_mat,'N',ferr,berr)
!       call gerfsx( lhs_a, lhs_af, ipiv, rhs, sol_mat) 
      fxp_prop(:,:,1)=sol_mat
      write(1001,*) 'FERR 1'
      write(1001,*) FERR
      write(1001,*) 'BERR 1'
      write(1001,*) BERR
      write(1001,*) ''

      sol_mat=fxp_prop(:,:,2)
      call getrs(lhs_af,ipiv,sol_mat)
      rhs=fxp_prop(:,:,2)
      call gerfs( lhs_a, lhs_af, ipiv, rhs, sol_mat,'N',ferr,berr)
!       call gerfsx( lhs_a, lhs_af, ipiv, rhs, sol_mat)
      fxp_prop(:,:,2)=sol_mat
      write(1002,*) 'FERR 2'
      write(1002,*) FERR
      write(1002,*) 'BERR 2'
      write(1002,*) BERR
      write(1002,*) ''
!     -----------------------------

!       call quad_MA01A_f95(temp_matrix,fxp_prop(:,:,1),nchan,nchan)
!       fxp_prop(:,:,1)=temp_matrix
! 
!       temp_matrix=r21
! 
!       call quad_MA01A_f95(temp_matrix,fxp_prop(:,:,2),nchan,nchan)
!       fxp_prop(:,:,2)=temp_matrix
! 
! !       allocate(rmat_prop(nchan,nchan))
! !       rmat_prop=0.0d0        
! ! 
! !       rmat_prop=r12-matmul(matmul(r11,curlyr_inverse),r22_minus_rmat)
 

      fx_prop(:,:,1)=matmul(r12,fxp(:,:,1))-matmul(r11,fxp_prop(:,:,1))
      fx_prop(:,:,2)=matmul(r12,fxp(:,:,2))-matmul(r11,fxp_prop(:,:,2))



      fx=fx_prop    
      fxp=fxp_prop

      return
      end subroutine quad_curlyr_back_prop_no_inversion
!
      subroutine quad_curlyr_back_prop_with_K(nchan,rmatr,
     *                      rafinv,rmat_at_a,rmat,cr,fx,fxp,fkmat)
C
C***********************************************************************
C
C     CURLYR_BACK_PROP PROPAGATES THE RADIAL FUNCTIONS FROM THE MATCHING  
C                      RADIUS TO THE R-MATRIX BOUNDARY USING THE GLOBAL
C                      R-MATRIX PROPAGATOR USED FOR THE FOWARD
C                      PROPAGATION.
c
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             INPUTS
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             CR        THE CURLY R MATRIX
C             RMAT      THE R-MATRIX
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C
C             FX,FXP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      implicit none

!     Argument variables
      integer :: nchan
      double precision :: rmatr,rafinv
      double precision :: rmat_at_a(nchan*nchan),fkmat(nchan,nchan),
     * cr(2*nchan*nchan+nchan),fx(nchan,nchan,2),fxp(nchan,nchan,2)
      real(kind=16) :: rmat(nchan*nchan)
!     Local variables
      integer :: ir11,ir12,ir22, i,j,k,m,info
      integer(blasint), allocatable :: ipiv(:)
      real(kind=16), allocatable ::r11(:,:),r12(:,:),r21(:,:),
     * r22(:,:), rmat_prop(:,:),matrix_identity(:,:),rmat_inverse(:,:), 
     * temp_matrix(:,:),fx_prop(:,:,:),fxp_prop(:,:,:),
     * curlyr_inverse(:,:), r22_minus_rmat(:,:),
     * fkmat_long(:,:), fx_with_K(:,:), fxp_with_K(:,:),
     * fx_with_K_prop(:,:),fxp_with_K_prop(:,:)

      real(kind=8), allocatable :: lhs_a(:,:),lhs_af(:,:), rhs(:,:),
     *                             sol_mat(:,:)

      real(kind=8) :: ferr(nchan),berr(nchan),anorm,anorm_temp(nchan)
      real(kind=8) :: rcond
c     Expand and extract curly R-matrices
c     -----------------------------------
      allocate(r11(nchan,nchan),r12(nchan,nchan),
     *         r21(nchan,nchan),r22(nchan,nchan),
     *         r22_minus_rmat(nchan,nchan))
      r11=0.0d0;r12=0.0d0;r21=0.0d0;r22=0.0d0;r22_minus_rmat=0.0d0

c     Determine first index of each matrix
      ir11=1
      ir12=ir11+(nchan**2+nchan)/2
      ir22=ir12+nchan**2

      k=0;m=0
      do j=1,nchan
        do i=1,nchan
          r12(i,j)=cr(ir12+m)
          r21(j,i)=cr(ir12+m)
          m=m+1
        end do
      end do
      call quad_squarm(nchan,1,cr(ir11:ir12-1),r11)
      call quad_squarm(nchan,1,cr(ir22:),r22)
    
      k=1
      do j=1,nchan
        do i=1,nchan
          r22_minus_rmat(i,j)=r22(i,j)-rmat(k) ! Back propagation
!               r11(i,j)=r11(i,j)+rvib2(k) ! Forward propagation
          k=k+1
        end do
      end do

!     Invert R-matrices
      allocate(matrix_identity(nchan,nchan))
      matrix_identity=0.0d0

      do i=1,nchan
        matrix_identity(i,i)=1.0d0
      end do

      info=0
      allocate(ipiv(nchan),temp_matrix(nchan,nchan))
      ipiv=0 
      temp_matrix=r21  ! Back propagation

      allocate(fkmat_long(nchan,nchan), fx_with_K(nchan,nchan),
     *         fxp_with_K(nchan,nchan))

      fkmat_long=fkmat
      fx_with_K=fx(:,:,1)+matmul(fx(:,:,2),fkmat_long)
      fxp_with_K=fxp(:,:,1)+matmul(fxp(:,:,2),fkmat_long)

      allocate(fx_with_K_prop(nchan,nchan),
     *         fxp_with_K_prop(nchan,nchan))

      fxp_with_K_prop(:,:)=matmul(r22,fxp_with_K(:,:))-fx_with_K(:,:)


!     TESTING ITERATIVE REFINEMENT
!     -----------------------------
      allocate(lhs_a(nchan,nchan),sol_mat(nchan,nchan),
     *         lhs_af(nchan,nchan),rhs(nchan,nchan))
!     LAPACK inversion (not quad prec.)

      lhs_a=r21
      lhs_af=r21
      call getrf(lhs_af,ipiv)

!     compute the 1-norm for gettinf the condition
      anorm_temp=0
      do i=1,nchan
        anorm_temp=anorm_temp+abs(r21(i,:))
      end do
      anorm=maxval(anorm_temp) 

      call gecon( lhs_af, anorm, rcond)
      write(1003,*) 'anorm,rcond', anorm,rcond

      sol_mat=fxp_with_K_prop(:,:)
      call getrs(lhs_af,ipiv,sol_mat)
      rhs=fxp_with_K_prop(:,:)
      call gerfs( lhs_a, lhs_af, ipiv, rhs, sol_mat,'N',ferr,berr)
!       call gerfsx( lhs_a, lhs_af, ipiv, rhs, sol_mat) 
      fxp_with_K_prop(:,:)=sol_mat
      write(1001,*) 'FERR 1'
      write(1001,*) FERR
      write(1001,*) 'BERR 1'
      write(1001,*) BERR
      write(1001,*) ''

!     -----------------------------

!       call quad_MA01A_f95(temp_matrix,fxp_prop(:,:,1),nchan,nchan)
!       fxp_prop(:,:,1)=temp_matrix
! 
!       temp_matrix=r21
! 
!       call quad_MA01A_f95(temp_matrix,fxp_prop(:,:,2),nchan,nchan)
!       fxp_prop(:,:,2)=temp_matrix
! 
! !       allocate(rmat_prop(nchan,nchan))
! !       rmat_prop=0.0d0        
! ! 
! !       rmat_prop=r12-matmul(matmul(r11,curlyr_inverse),r22_minus_rmat)
 

      fx_with_K_prop(:,:)=matmul(r12,fxp_with_K(:,:))
     *                   -matmul(r11,fxp_with_K_prop(:,:))
 

      fx(:,:,1)=fx_with_K_prop
      fxp(:,:,1)=fxp_with_K_prop
      return
      end subroutine quad_curlyr_back_prop_with_K

      subroutine quad_MA01A_f95(A,B,M,N)
      implicit none

!     Arguments
      integer :: M, N
      real(kind=16), dimension(:,:) :: A(M,M),B(M,N)

!     Local
      integer :: M1,IAC,IBC
      integer,allocatable :: IND(:)
      real(kind=16), allocatable :: C(:)

!       M=size(A,1)
!       N=size(B,2)
      M1=1
      IAC=M
      IBC=N
      print*, 'M=',M
      print*, 'N=',N
      allocate(IND(2*2*M), C(2*2*M))

      call quad_MA01A(A,B,M,N,M1,IAC,IBC,C,IND)

!       CALL MA01A(CRCP_temp,CRCPINV,NCHAN,NCHAN,1,
!      X           NCHAN,NCHAN,X,X(NCHAN+1))
      deallocate(IND,C)
      end subroutine quad_MA01A_f95
c
      subroutine quad_MA01A(A,B,M,N,M1,IAC,IBC,C,IND)
      IMPLICIT real(kind=16) (A-H,O-Z)
C
C      SOLUTION OF SIMULTANEOUS EQUATIONS AND OR MATRIX INVERSION
C
C
C      A           THE M*M MATRIX OF LEFT HAND SIDES OR THE MATRIX BEING
C                  INVERTED. OVERWRITTEN ON EXIT BY THE INVERSE MATRIX
C
C      B           THE M*N MATRIX OF THE RIGHT HAND SIDES. OVERWRITTEN
C                  ON EXIT BY SOLUTIONS
C
C      M           THE ORDER OF THE A-MATRIX. THIS MUST BE GREATER
C                  THAN 1 AND NOT GREATER THAN 100.THE UPPER LIMIT
C                  CAN BE EXTENDED BY RECOMPILING WITH LARGER
C                  DIMENSIONS FOR THE PRIVATE ARRAYS C AND IND
C
C      N           THE NUMBER OF THE RIGHT HAND SIDES IN THE
C                  SIMULTANEOUS EQUATIONS
C
C      IAR,IAC     DEFINE THE DIMENSIONS OF THE ARRAY WHERE THE A-MATRIX
C                  IS STORED
C
C      IBR,IBC     DEFINE THE DIMENSIONS OF THE ARRAY WHERE THE B-MATRIX
C                  IS STORED
C
C
C      M1          =0 ONLY SIMULTANEOUS EQUATIONS ARE SOLVED IF N.GT.0
C                       IF N=0 A FURTHER ENTRY TO MA01A WITH M1.LT.0
C                       REQUIRED TO OBTAIN THE INVERSE OF A
C                  .GT.0 MATRIX INVERSION. IN ADDITION SIMULTANEOUS
C                       EQUATIONS ARE SOLVED IF N.GT.0
C                  .LT.0 ONLY USED IF PREVIOUS ENTRY TO MA01A
C                       WITH M1=0. IN THIS CASE THE MATRIX INVERSION IS
C                       COMPLETED
C
C
      DIMENSION A(IAC,IAC),B(IAC,IBC),C(*),IND(*)
C
      IF(M1<0)GO TO 65
      AMAX=0.0
C
C      FIND THE FIRST PIVOTAL ELEMENT AND STORE THE CORRESPONDING ROW
C      NUMBER IN I4. IND DEFINES THE ORDER OF THE ROWS OF THE ORIGINAL
C      A-MATRIX BEFORE ROW INTERCHANGE
C
      DO 2 I=1,M
      IND(I)=I
      IF(ABS (A(I,1)) <= AMAX) CYCLE
      AMAX=ABS (A(I,1))
      I4=I
    2 CONTINUE
      MM=M-1
C
C      EACH TIME THROUGH THE FOLLOWING LOOP THE A-MATRIX IS
C      REDUCED BY ONE
C
      DO 111 J=1,MM
C
C      INTERCHANGE THE I4TH AND THE JTH ROWS OF THE A-MATRIX AND STORE
C      ORDER IN IND IF I4 .NE.J
C
      IF(I4 <= J)GO TO 6
      ISTO=IND(J)
      IND(J)=IND(I4)
      IND(I4)=ISTO
      DO 5 K=1,M
      STO=A(I4,K)
      A(I4,K)=A(J,K)
      A(J,K)=STO
    5 CONTINUE
C
C      INTERCHANGE THE I4TH AND THE JTH ROWS OF THE B-MATRIX IF N.GT. 0
C
      IF(N <= 0)GO TO 6
      DO 8 K=1,N
      STO=B(I4,K)
      B(I4,K)=B(J,K)
      B(J,K)=STO
    8 CONTINUE
C
C      THE JTH ROW NOW CONTAINS THE PIVOTAL ELEMENT IN THE JTH POSITION
C      ELIMINATE THE JTH ELEMENT FROM EACH OF THE REMAINING ROWS OF THE
C      A-MATRIX AND THE B-MATRIX AND STORE THE MULTIPLIERS IN THE LOWER
C      TRIANGLE
C
    6 AMAX=0.0
      J1=J+1
      DO 11 I=J1,M
      A(I,J)=A(I,J)/A(J,J)
      DO 10 K=J1,M
      A(I,K)=A(I,K)-A(I,J)*A(J,K)
      IF (K > J1) GO TO 10
C
C      FIND THE NEXT PIVOTAL ELEMENT AND STORE THE CORRESPONDING ROW
C      NUMBER IN I4
C
      IF(ABS (A(I,K)) <= AMAX) GO TO 10
      AMAX=ABS (A(I,K))
      I4=I
   10 CONTINUE
    9 IF(N <= 0) GO TO 11
      DO 13 K=1,N
      B(I,K)=B(I,K)-A(I,J)*B(J,K)
   13 CONTINUE
   11 CONTINUE
  111 CONTINUE
C
C      THE ELIMINATION IS NOW COMPLETE AND THE A-MATRIX HAS BEEN
C      REDUCED TO THE PRODUCT OF AN UPPER AND LOWER TRIANGLE MATRIX
C
      IF(N <= 0) GO TO 18
C
C      NOW CARRY OUT THE BACK SUBSTITUTION AND STORE RESULT IN THE
C      B-MATRIX IF THERE IS AT LEAST ONE RIGHT HAND SIDE
C
      DO 127 I1=1,M
      DO 227 J=1,N
      I=M+1-I1
      IF(M <= I) GO TO 327
      I2=I+1
      DO 32 K=I2,M
      B(I,J)=B(I,J)-A(I,K)*B(K,J)
   32 CONTINUE
  327 B(I,J)=B(I,J)/A(I,I)
  227 CONTINUE
  127 CONTINUE
   18 IF(M1 <= 0) GO TO 64
C
C      REPLACE THE A-MATRIX BY ITS INVERSE WHEN M1.NE. ZERO
C
C      FIRST INVERT THE LOWER TRIANGLE MATRIX AND STORE ON ITSELF
C
   65 DO 140 I1=1,MM
      I=M+1-I1
      I2=I-1
      DO 41 J1=1,I2
      J=I2+1-J1
      J2=J+1
      W1=-A(I,J)
      IF(I2 < J2) GO TO 141
      DO 42 K=J2,I2
      W1=W1-A(K,J)*C(K)
   42 CONTINUE
  141 C(J)=W1
   41 CONTINUE
      DO 40 K=1,I2
      A(I,K)=C(K)
   40 CONTINUE
  140 CONTINUE
C
C      NOW INVERT THE UPPER TRIANGLE MATRIX AND FORM THE ORIGINAL
C      A-MATRIX APART 6ROM COLUMN INTERCHANGE. THIS OVERWRITES THE
C      ORIGINAL A-MATRIX
C
      DO 150 I1=1,M
      I=M+1-I1
      I2=I+1
      W=1.0/A(I,I)
      DO 56 J=1,M
      IF (I < J) THEN
        GO TO 52
      ELSE IF (I == J) THEN
        GO TO 53
      ELSE
        GO TO 54
      END IF
   52 W1=0.0
      GO TO 55
   53 W1=1.0
      GO TO 55
   54 W1=A(I,J)
   55 IF(I1 <= 1) GO TO 156
      DO 58 K=I2,M
      W1=W1-A(I,K)*A(K,J)
   58 CONTINUE
  156 C(J)=W1
   56 CONTINUE
      DO 50 J=1,M
      A(I,J)=C(J)*W
   50 CONTINUE
  150 CONTINUE
C
C      RE-ORDER THE COLUMNS OF THE INVERSE A-MATRIX TO COINCIDE WITH
C      THE ORDER OF THE ROWS OF THE A-MATRIX ON INPUT
C
      DO 60 I=1,M
   63 IF(IND(I) == I) GO TO 60
      J=IND(I)
      DO 62 K=1,M
      STO=A(K,I)
      A(K,I)=A(K,J)
      A(K,J)=STO
   62 CONTINUE
      ISTO=IND(J)
      IND(J)=J
      IND(I)=ISTO
      GO TO 63
   60 CONTINUE
   64 RETURN
      END
      SUBROUTINE quad_SQUARM(NDIM,NMAT,TRIANG,SQUARE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     SQUARM PUTS LOWER TRIANGLES BACK INTO SQUARE MATRICES)
C
C***********************************************************************
C
      real(kind=16) :: square
      DIMENSION SQUARE(NDIM,NDIM,NMAT),TRIANG(*)
C
      K = 0
      DO 3 L=1,NMAT
      DO 2 I=1,NDIM
      DO 1 J=1,I
      K = K+1
      SQUARE(I,J,L) = TRIANG(K)
      SQUARE(J,I,L) = TRIANG(K)
 1    continue
 2    continue
 3    continue
C
      RETURN
      END
      SUBROUTINE quad_KMAT(NCHAN,BSTO,NOPEN,F,FP,rmat_quad,AKMAT,fkmat)
      use blas_lapack_gbl, only: blasint
      use lapack95_compak
      implicit none
C
C***********************************************************************
C
C     K-MATRIX CALCULATION
C
C     NCHAN        NUMBER OF CHANNELS
C     BSTO         LOGARITHMIC DERIVATIVE/MATCHING RADIUS
C     NOPEN        NUMBER OF OPEN CHANNELS
C     F, FP        EXTERNAL REGION SOLUTIONS AND DERIVATIVES
C                  (ASSUMED IN CORRECT LOCATIONS)
C     RMAT         INTERNAL REGION R-MATRIX
C
C     OUTPUT :
C     AKMAT        K-MATRIX
C     fkmat          The full K-matrix including closed channels
C              needed for compak - AlexH 11.11.10
C
C     AA,BB        WORK SPACE, EACH OF LENGTH NCHAN*NCHAN
C     X            WORK SPACE, OF LENGTH 2*NCHAN
C
C***********************************************************************

      integer, parameter :: iqp=selected_real_kind(16)

!     Arguments
      integer ::       nchan,nopen
      real(kind=8)  :: akmat(nopen,nopen),fkmat(nchan,nchan),bsto(nchan)
     *                 ,f(nchan,nchan,2),fp(nchan,nchan,2)
      real(kind=16) :: rmat_quad(nchan,nchan)

!     Local variables
      integer :: i,j,k
      real(kind=16) :: df
      real(kind=16), allocatable :: quad_akmat(:,:),quad_fkmat(:,:),
     *                              X(:), AA(:,:),BB(:,:),
     *                              quad_f(:,:,:), quad_fp(:,:,:),   
     *                              quad_bsto(:)
      real(kind=8), allocatable :: rhs(:,:), lhs_a(:,:),lhs_af(:,:),
     *                             sol_mat(:,:)
      integer :: ninfo
      integer(blasint), allocatable :: ipiv(:)
      integer, allocatable :: ind(:)
C
      allocate(quad_akmat(NOPEN,NOPEN),quad_fkmat(nchan,nchan),
     *         X(nchan),ind(nchan),AA(nchan,nchan),BB(nchan,nchan),
     *         quad_f(nchan,nchan,2), quad_fp(nchan,nchan,2),
     *         quad_bsto(nchan))

      AKMAT=0.d0;fkmat=0.d0;AA=0._iqp;BB=0._iqp;X=0._iqp
      quad_f=real(f,kind=16)
      quad_fp=real(fp,kind=16)
      quad_bsto=real(bsto,kind=16)
      df=0._iqp

      do j=1,nchan
         do i=1,nchan
            AA(i,j) = quad_f(i,j,2)
         end do
      end do
c
      do j=1,nchan
         do k=1,nchan
            df =  quad_fp(k,j,2)- quad_bsto(k)* quad_f(k,j,2)
            do i=1,nchan
               AA(i,j) = AA(i,j)-rmat_quad(i,k)*df
            end do
         end do
      end do
c
      do j=1,nopen
         do i=1,nchan
            BB(i,j)=- quad_f(i,j,1)
         end do
      end do
c
      do j=1,nopen
         do k=1,nchan
            df =  quad_fp(k,j,1)- quad_bsto(k)* quad_f(k,j,1)
            do i=1,nchan
               BB(i,j)=BB(i,j)+rmat_quad(i,k)*df
            end do
         end do
      end do
c

931   format(i5,3x,i5,3x,2(d15.5,3x))
      if(nchan.eq.1) then
        BB(1,1)=BB(1,1)/AA(1,1)
      else
        call quad_ma01a(aa,bb,nchan,nopen,0,nchan,nchan,x,ind)

! !       Try with iterative refinement (lapack)
! !       ------------------------------------
!         allocate(rhs(nchan,nchan), lhs_a(nchan,nchan), 
!      *           lhs_af(nchan,nchan))
!         allocate(sol_mat(nchan,nchan), ipiv(nchan))
!         ipiv=0;lhs_af=0;sol_mat=0;rhs=0;lhs_a=0;lhs_af=0
!         lhs_a=AA
!         lhs_af=AA
!         call getrf(lhs_af,ipiv)
! 
! ! !       compute the 1-norm for gettinf the condition
! !         anorm_temp=0
! !         do i=1,nchan
! !           anorm_temp=anorm_temp+abs(r21(i,:))
! !         end do
! !         anorm=maxval(anorm_temp) 
! 
! !         call gecon( lhs_af, anorm, rcond)
! !         write(1003,*) 'anorm,rcond', anorm,rcond
! 
!         sol_mat=BB
!         call getrs(lhs_af,ipiv,sol_mat)
!         rhs=BB
!         call gerfs( lhs_a, lhs_af, ipiv, rhs, sol_mat)
! !       ---------------------------------------
! 
      endif
! c
!       fkmat=sol_mat
!       do j=1,nopen
!          do i=1,nopen
!             akmat(i,j) = sol_mat(i,j)
!          end do
!       end do

      fkmat=bb
      do j=1,nopen
         do i=1,nopen
            akmat(i,j) = bb(i,j)
         end do
      end do



c
      
      end subroutine quad_KMAT

!     Does svd decomposition of A
!     returns singular values in B

      subroutine rsvd_decomposition(m,n,A)
      use lapack95_compak
      implicit none

!     Arguments
      integer :: m,n
      real(kind=8)  :: A(m,n)
 
!     Local
      integer :: min_dim,i,j,k
      real(kind=8), allocatable  ::AA(:,:), d(:), e(:)

      min_dim=min(m,n)
      allocate(AA(m,n))
      allocate(d(min_dim), e(min_dim-1))
      d=0;e=0


      AA=A
    
     
      call gebrd(AA,d,e)
      call bdsqr(d, e) 

      A=0
      do i=1,min_dim
         A(i,i)=d(i)
         print *, i, d(i)
      end do
      end subroutine rsvd_decomposition

      subroutine svd_truncate(m,n,A, svd_thresh)
      use lapack95_compak
      implicit none

!     Arguments
      integer :: m,n
      real(kind=8)  :: A(m,n),svd_thresh
 
!     Local
      integer :: min_dim,i,j,k
      real(kind=8)  :: u(m,m), vt(n,n)
      real(kind=8), allocatable  ::AA(:,:), s(:), sigma(:,:)

      min_dim=min(m,n)
      allocate(AA(m,n))
      allocate(s(min_dim))
      s=0
      AA=A

      call gesvd(AA,s, u, vt)

      allocate(sigma(m,n))
      sigma=0

      do i=1,min_dim
         if (s(i).gt.svd_thresh) then
            sigma(i,i)=s(i)
         end if
      end do

      A=matmul(u,matmul(sigma,vt))
   

      end subroutine svd_truncate

      subroutine tri_rsvd_decomposition(m,A,n,AAA)
      use lapack95_compak
      implicit none

!     Arguments
      integer :: m,n
      real(kind=8)  :: A(m,n)

      real(kind=8) ::AAA((m**2+m)/2)
!     Local
      integer :: min_dim,i,j,k
      real(kind=8), allocatable  ::AA(:,:), d(:), e(:)

      min_dim=min(m,n)
      allocate(AA(m,n))
      allocate(d(min_dim), e(min_dim-1))
      d=0;e=0


      k=1
      do i=1, m
        do j=1,i
          AA(i,j)=AAA(k)
          AA(j,i)=AAA(k)
          k=k+1
        end do
      end do
 
     
      call gebrd(AA,d,e)
      call bdsqr(d, e) 

      A=0
      do i=1,min_dim
         A(i,i)=d(i)
      end do     

      end subroutine tri_rsvd_decomposition

      subroutine transform_f(nchan,nopen,fx, fxp)
      use lapack95_compak
      implicit none

!     Arguments
      integer :: nchan,nopen
      real(kind=8)  :: fx(nchan,nchan,2), fxp(nchan,nchan,2)
 
!     Local
      integer :: i,j,k

      do i=nopen+1,nchan
         do j=1,nopen
           fx(i,j,1)=0
           fx(i,j,2)=0
           fxp(i,j,1)=0
           fxp(i,j,2)=0
         end do
      end do
      do i=nopen+1,nchan
         do j=1,nopen+1,nchan
           fx(i,j,2)=0
           fxp(i,j,2)=0
         end do
      end do     
      do i=nopen+1,nchan  
         fx(i,i,2)=1
         fxp(i,i,2)=1
      end do     

      end subroutine transform_f
