! Copyright 2019
!
! Alex G. Harvey with ontributions from Danilo S. Brambila and Zdenek Masin.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      module read_inner_dipoles
      
      integer, parameter :: idp=selected_real_kind(8)
      integer, parameter :: maxprop_par=8  
      real(kind=idp), parameter :: pi=3.1415926535897932_idp 
      integer, parameter ::        maxnuc=100
      real(kind=idp), parameter :: zero=0.0_idp, two=2.0_idp, amu=1822.832_idp
       
      contains
 
      subroutine read_transdip2(iutdip, ntset, nstat, ismax,prop, ifail)
      implicit none
      integer :: iutdip, ntset, nstat
      real(kind=idp),allocatable, dimension(:,:,:) :: prop,prop_temp
      integer :: iwrite, nnuc, iprnt, nold, ifail, iposit, nuccen, ismax
      real(kind=idp) :: R,rmass
      real(kind=idp), allocatable, dimension(:) :: charg
      real(kind=idp), allocatable, dimension(:,:) :: geonuc
      integer :: i,k
      iwrite=6
      nold=0

      call readm(iwrite, iutdip, ntset, R, nstat, nnuc, nuccen, charg, geonuc, rmass, ismax, & 
     &           maxprop_par, prop, iprnt,nold,ifail,iposit)



!     Unpack triangular to symmetric matrix
      allocate(prop_temp(nstat,nstat,maxprop_par))
      prop_temp=0_idp

      do k=1, ismax**2+2*ismax
         prop_temp(:,:,k)=transpose(prop(:,:,k))
         do i=1, nstat
            prop_temp(i,i,k)=0_idp
         end do
      end do

      prop(:,:,1:maxprop_par)= prop(:,:,1:maxprop_par)+prop_temp

      end subroutine read_transdip2
            
      subroutine readm(iwrite, lutarg, ntset, r, nstat, nnuc, nuccen, charg, geonuc, rmass, ismax, &
     &                 maxprop, prop, iprnt, nold, ifail, iposit)
 
!     ******************************************************************
!
!     READM READS MOMENTS ATTACHED TO UNIT
!            LUTARG
!
!	   Definition of input variables - alex
!
!	   IWRITE = Write messages to this unit. I 
!	   LUTARG = Properties file. I
!	   NTSET = Set no? I
!	   R =  Internuclear sep? Doesnt look like its used, leftover from diatomic code?
!	   nstat = number of CI states. I
!	   NNUC  = No. of nuclei (no. of geometry records). I
!	   NUCCEN = Seems to be set to NNUC+1. I
!	   CHARG = Charge on each nuclear centre. I(NNUC)
!	   GEONUC = x,y,z coord of each nuclei. D(3,NNUC)
!	   RMASS = Reduced mass. D
!	   ISMAX = Maximum L value for property operator? I 
!	   maxprop = Maximum number of properties fro each CI state pair. I
!	   prop = Matrix containing properties D(nstat, nstat, maxprop)
!	   eshift = CI vector energy shift. D(nstat)
!	   IPRNT = Print flag. I
!	   NOLD = Indicates whether target prop. file is new or old style. I [0:1]
!	   IFAIL = Error Flag. I
!	   IPOSIT = Positron run Flag. I
!
!     THE DUMPFILE IS DIVIDED INTO DATASETS BY HEADER CARDS BEGINNING
!     WITH KEY = 6
!     Old style files with KEY=9 can also be read
!
!     KEY = RECORD KEY = FIRST FIELD (I1)
!     GTARG is retained for compatiblity with other modules
!
!     ******************************************************************
      implicit none


!     Arguments
      integer :: iwrite, lutarg, ntset, nstat, nnuc, nuccen, ismax, maxprop, iprnt, nold, ifail, &
     &           iposit
      real(kind=idp) :: r,rmass
      real(kind=idp),allocatable :: geonuc(:,:),charg(:),prop(:,:,:)     

!     Local variables
      integer :: ipass, key ,keyh, iset, nrecs, nstat1, nmom, isw, i, j, k, it, iseq, icharg, itg, &
     &           im, ikmax, it1, it2, iq, lop, mop
      real(kind=idp) :: trpi, chargesign, x, y, z, dnx
      character(len=3) :: catom
      character(len=26) :: head
      integer,dimension(:) :: inx(8)
      integer,allocatable,dimension(:) :: ip, irp
      real(kind=idp) ,dimension(:) :: rmoi(3), amnuc(maxnuc)    
      equivalence (inx(1),key)
      
!~ stop "BEFORE 1st READ"
      rewind lutarg
      trpi = two*sqrt(pi)
!~ return
!~ stop "BEFORE 1st READ"      

!     chargesign is +1 for electrons and -1 for positrons
      chargesign = 1.0
      if (iposit .ne. 0) chargesign = -1.0
!     ----- SEARCH DUMPFILE FOR REQUIRED DATASET
      IPASS = 1
   17 read(lutarg,11,end=40) key     !read the key 
      if(key .ne. 6) go to 21      !and check its a properties file
!~ return
!~ stop "AFTER 1st READ"
!     NOLD indicates if the property file is in the NEW (NOLD=0) or OLD 
!     (NOLD=1) FORMAT. THE ONLY DIFFERENCE IS IN THE FORMAT OF THE FIRST LINE 
!     OF THE FILE.

      backspace lutarg
      if (nold.eq.0) then
         read(lutarg,*) keyh,iset,nrecs,nnuc,nstat1,nmom,isw,rmoi !Read first line -trying list directed input
!          write(6,*)  keyh,iset,nrecs,nnuc,nstat1,nmom,isw,rmoi 

      else
!          read(lutarg,1100) keyh,iset,nrecs,nnuc,nstat1,nmom,isw,rmoi
         read(lutarg,*) keyh,iset,nrecs,nnuc,nstat1,nmom,isw,rmoi 
      end if
!~ stop "AFTER 2nd READ"
!~ return
      nstat=nstat1
!     allocate arrays
      allocate( prop(nstat,nstat,maxprop_par), geonuc(3,nnuc), charg(nnuc), ip(nstat), irp(nstat) )

!     ****************************************
!     SET HEADER    ...    KEY = 6 :
!     FIELD
!       2   SET NUMBER
!       3   NUMBER OF RECORDS IN SET
!       4   NUMBER OF GEOMETRY RECORDS ( NNUC )
!       5   NUMBER OF RECORDS OF TARGET DATA
!       6   NUMBER OF RECORDS OF MOMENT DATA
!       7   MOMENT TYPE SWITCH, ISW
!       8   Rotational constant AX (a.u.)
!       9   Rotational constant BY (a.u.)
!      10   Rotational constant CZ (a.u.)
!     ****************************************

      if(nstat.gt.nstat1 .or. (ntset.ne.0.and.iset.ne.ntset)) then

!     ---THIS IS NOT THE REQUIRED DATA SET SO SKIP REMAINING RECORDS
         if(iprnt.ne.0) write(iwrite,98) ntset, nstat, iset, nstat1

         do 19 j=1,inx(3)
            read(lutarg,11,end=21)
   19    continue
         go to 17
      endif

!     *****************************************
!     READ DATA DEFINING MOLECULAR GEOMETRY   ...   KEY = 8 :
!     FIELD
!       2   NUCLEAR SEQUENCE NUMBER (I)
!       3   Name of atom
!       4   NUCLEAR CHARGE
!       5   NUCLEAR MASS ( IN ATOMIC UNITS )
!       6
!       7
!       8
!       9   NUCLEAR POSITION, GEONUC(I)
!      10   26-CHARACTER HEADER FIELD
!     *****************************************
      do 8 it=1,nnuc
         read(lutarg,1102,err=21) key, iseq, catom, icharg, rmass, x, y, z
         if(key .ne. 8) go to 21
         write(iwrite,120) it, catom, icharg, x, y, z, rmass
         charg(iseq) = icharg
         amnuc(iseq) = rmass
         geonuc(1,iseq) = x
         geonuc(2,iseq) = y
         geonuc(3,iseq) = z
    8 continue

      nuccen=nnuc+1
      ikmax = 0

      do 10 itg=1,nstat1
         read(lutarg,11,end=21) (inx(i),i=1,8),dnx,head
         if(key .ne. 5) go to 21
   10 continue

!     ****************************************
!     RDTMOM DATA    ...    KEY = 1
!
!     FIELD
!       2   STATE INDEX          (I)
!       3   |M(I)|
!       4   STATE INDEX          (J)
!       5   |M(J)|
!       6   OPERATOR CENTER INDEX  KOP
!       7   OPERATOR L-VALUE       LOP
!       8   OPERATOR |M|-VALUE     MOP
!       9   TRANSITION MOMENT IN AU, ISW CONVENTION DETERMINED BY HEADER
!     ****************************************

      do i=1,nstat1
         do j=1,nstat1
            do k=1,maxprop
               prop(i,j,k) = zero
            end do
         end do
      end do

      write(iwrite,20)
      do 60 im=1,nmom
         read(lutarg,11,end=21)(inx(i),i=1,8),dnx,head
         if(key .ne. 1) go to 21
         it1=inx(2)
         it2=inx(4)
         lop=inx(7)
         mop = inx(8)
         if(lop .lt. 1 .or. lop .gt. ismax) go to 60
         if(inx(6).ne.nuccen) go to 21
         iq = lop*lop+lop+mop
         prop(it1,it2,iq) = chargesign * dnx

   60 continue
      return

   40 if(ipass.eq.1) then
         rewind lutarg
         ipass = ipass+1
         go to 17
      else
         write(iwrite,23)ntset,r
   23    FORMAT(' UNABLE TO FIND REQUIRED TARGET DATA SET',I5,F10.3)
         stop
      endif
      return

   21 write(iwrite,66)
   66 format(' ERROR in target properties data')
      write(iwrite,111) (inx(i),i=1,8),dnx,head
      ifail = 1
      return

   98 format(' Required',2i5,5x,'Skipped',2i5,f10.6)
   96 format(6i5,f10.5)
   18 format(/' Reduced mass',f9.1,' au')
  188 format(/' Target rotational constants (a.u.)',3d15.6)
  189 format(/' Nuclear centres '/4x,'Atom',2x,'Charge ', &
     & 5x,'X',9x,'Y',9x,'Z',9x,'Mass')
  120 format(i3,2x,a3,3x,i3,3x,3f10.6,2x,f10.6)
   20 format(/' Transition moments')
   95 format('Target states on properties file are not in energy order')
  196 format(3i5,f20.10)
   97 format(/' Target states '/6x,' Irrep ','Spin',5x,' Energy (au)')
   11 format(i1,i8,i3,i8,4i3,d20.12,2x,a26)
  111 format(i1,i8,i3,i8,4i3,d20.12,2x,a26)
 1100 format(i1,6i3,1x,3d20.12)
! 1101 format(i1,i3,i6,i3,i4,i6,i3,1x,3d20.12)
 1101 format(i1,i3,i9,i3,i4,i9,i3,1x,3d20.12)
 1103 format(i1,i3,i9,i9,i9,i9,i3,1x,3d20.12)
 1102 format(i1,i3,a3,i3,f10.4,3f20.10)
      end  subroutine readm
      
      end module
