UKRmol-out
==========

UKRmol-out is licensed with the Gnu Public License.  For a comprehensive list of the developers that 
contributed to these codes see the UK-AMOR website.

Before compiling and using the code, check [Zenodo](https://doi.org/10.5281/zenodo.2630570) for the latest
version of UKRmol-out, that may contain bug fixes, new functionality, etc.

Table of contents
-----------------

 * Downloading
 * Building
    * Note on the integer and floating point precision
    * Known issues and compatible software
 * Notes for developers
    * Git-flow
    * Working on your own developments


Downloading
-----------

You can obtain a release version from Zenodo following the link above. If you are planning to develop the code,
you can request access and download the current development version from the 
[Gitlab repository](https://gitlab.com/Uk-amor/UKRMol/UKRmol-out/).

UKRmol-out uses Git as its version control system. To download it, request permission from the
project managers and then just issue the following command:

    git clone https://gitlab.com/UK-AMOR/UKRMol/UKRmol-out.git

You will be prompted for your user name and password, and then the master branch of the repository 
will be downloaded to your computer.

Some versions of Git will not prompt you for your user name and automatically infer it from
the environment (username). In such cases you may need to force your username. This can
be done by inserting `username@` between `https://` and `gitlab.com`, where `username` is your
Gitlab username.


Building
--------

UKRmol-out uses CMake configuration / build system. It is recommended to create a subdirectory
"build" in the same directory as this "README.md" file and carry out the compilation in that
subdirectory. (This way, one can have different builds with various combinations of precision,
integer width, compilers etc.).  

Note that UKRmol-out depends on the GBTOlib library (see https://gitlab.com/UK-AMOR/UKRMol/GBTOlib),
which is also needed by UKRmol-in (https://gitlab.com/UK-AMOR/UKRMol/UKRmol-in). Therefore, in order
to compile UKRmol-out you need to download and compile GBTOLib.

In an ideal world, you would just type the following two commands:

    mkdir build; cd build
    cmake ../source
    make

However, this would work only when your system environment was perfectly set up. In reality,
in most cases you will want to customize the build by specifying which compiler to use, and
where the needed external libraries are located. For that purpose, customize and use the sample
build scripts included below.  These example use the Intel Fortran compiler, with
Intel MPI and the BLAS and LAPACK routines from Intel MKL. You will need to adjust
the paths to your system (see below for an explanation of the libraries and flags used).
If you have CMake 3.13 or newer (recommended), you can use:

------------------------------------------------------------

    export BLA_VENDOR=Intel10_64ilp

    cmake -D CMAKE_C_COMPILER=$(which icx) \
     -D CMAKE_Fortran_COMPILER=$(which mpiifx) \
     -D CMAKE_Fortran_FLAGS="-mkl -i8" \
     -D GBTOLIB_INCLUDE_DIRS="/scratch/jdgorfinkiel/BINTEMP/LATEST/GBTOlib/mod" \
     -D GBTOLIB_LIBRARIES="/scratch/jdgorfinkiel/BINTEMP/LATEST/GBTOlib/lib/libGBTO.a" \
    ..

    make


------------------------------------------------------------

(BLA_VENDOR is required when using the Intel MKL; for other BLAS vendors it is normally safe not to specify this.)

For CMake version older than 3.13 you need to give the BLAS/LAPACK libraries explicitly:


------------------------------------------------------------

    MKL_LIB="$MKLROOT/lib/intel64/libmkl"
    MKL_BLAS_LAPACK="${MKL_LIB}_intel_ilp64.so;${MKL_LIB}_intel_thread.so;${MKL_LIB}_core.so"
    
    export CC=$(which icx)
    export FC=$(which mpiifx)
    export FFLAGS="-mkl -i8"
    
    cmake -D BLAS_LIBRARIES="$MKL_BLAS_LAPACK" \
          -D LAPACK_LIBRARIES="$MKL_BLAS_LAPACK" \
          -D GBTOLIB_INCLUDE_DIRS="...path/to/gbtolib/mod..." \
          -D GBTOLIB_LIBRARIES="...path/to/libGBTO.a..." \
          ..
    
    make

------------------------------------------------------------

The scripts will compile all components, placing the resulting programs into the "bin" subdirectory
of your "build" directory and the library generated into the "lib" subdirectory. Several programs are
provided (outer.f, outer-run.f90, outerswinterf.f and rmt_interface.f90) the latter for interfacing 
with the RMT suite.

Here are details on the individual libraries required:

* **BLAS**, **LAPACK**: Intel MKL provides ILP64 version of both. When using open-source tools,
  it is possible to use OpenBLAS instead, compiled with option `INTERFACE64=1`. In spite
  of its name, that library provides also LAPACK.

* **GBTOlib**: UKRmol-out uses routines in the library to read information related to boundary
  amplitudes. UKRmol-out can be linked to a double or quadruple precision library, so choose 
  consistently with your other UKRmol= executables.


### Note on the integer and floating point precision ###                                                       
                                                      
                                                                                                        
1. The kind value for default integer precision must be the same in UKRmol-in, UKRmol-out, GBTOlib.    
2. The GBTOlib library used for linking of UKRmol-out must be the same (including its integer and      
   floating point precision) as the one used for linking of the UKRmol-in codes.                       


### Known issues and compatible software

* For a list of known issues related to compilers, external libraries and the CMake system, see: 
  [Git-lab](https://gitlab.com/Uk-amor/UKRMol/UKRmol-in/wikis/Compatible-software). This includes a
  list of compatible software that has been used to compile and run the code.

Notes for the developers                                                                                                        
========================

A commmit.template is available to ensure that developers do not forget to provide sufficient 
information on thei work they've done. We ask that you do:

    git config commit.template commit.template

This way, when you commit some changes, the commit log will be pre-filled with the information in the
template.

Git-flow
--------

From version 1.0 the UKRmol-out repository has switched to using an adapted version of
[Git-flow](https://www.atlassian.com/git/tutorials/comparing-workflows/gitflow-workflow).
Git-flow defines a set of branches and prefixes which have a well-defined meaning. 

In the case of UKRmol-out the set of permanent branches and the naming convention is the following
(the flow chart [here](https://gitlab.com/Uk-amor/UKRMol/UKRmol-out/wikis/home) helps understanding
the structure):

    master : main development branch from which feature branches are created
    release: branch that contains code ready for (or already) release 
    release-X.Y.Z: hotfix of the tagged version X.Y of the release branch

* Release is the branch which contains versions of the code that have been thoroughly tested. It usually 
  correspond to a code that has undergone a major upgrade and is ready for release. Each version will
  be tagged, either by going to the Tags area of the GitLab interface, or automatically when a release file 
  is generated using the Release facility of GitLab.

* Fixes of important bugs in the release versions (i.e. hotfixes) should be implemented in a branch 
  originating from `release` and equipped with an incremented version number `release-X.Y.Z`, where X and Y
  correspond to the latest release tag. Implementation of each hotfix must be followed by its merge into 
  the `master` branch.

* The Master branch is an integration branch for the Feature branches and it is based on the latest
  `release` version. We can see that it has the meaning of the `develop` branch in the usual 
  Git-flow system, i.e. the `master` branch is the one into which all features are merged. This branch will
  eventually be merged into the `release` branch to create a new release.

* New features and your own developments should be implemented branching from the `master`. The names of
  such branches must be functional, i.e. referring to a particular feature that you're developing.
  If you wish you can prefix the name of your development branch with the string `feature-`.
  If it is possible to split the development of a major feature into a series of smaller upgrades
  (branches) then please do that since it helps to visualize the progress of the development and to
  see what was done by who and when. Implementation of each feature is followed by its merge into 
  the `master` branch.

Working on your own developments
--------------------------------

To create a branch for your own developments use the following commands:

    git checkout master
    git branch name_of_feature

You'll then checkout the branch, work on it and commit it when needed. Once you're satisfied 
with your implementation, you should create a merge request by using the facility in the GitLab
interface. One of the managers/maintaners of the project will check it and merge it to `master`.

(When the development of one or several new features has finished and the code in the `master` 
branch been thoroughly tested, the codes will be merged into the  `release` branch  and tagged.) 

