(* ::Package:: *)

(* ::Chapter:: *)
(*Conservative Black Hole Scattering at Fifth Post-Minkowskian and Second Self-Force Order*)


(* ::Text:: *)
(*Mathias Driesse, Gustav Uhre Jakobsen, Gustav Mogull, Christoph Nega, Jan Plefka, Benjamin Sauer, Johann Usovitsch*)


(* ::Section:: *)
(*Notation*)


(* ::Subsection:: *)
(*Scalars/Constants*)


(* ::Text:: *)
(*-- \[Gamma] := v_1.v_2 = 1/Sqrt[1-v^2] (Lorentz factor)*)
(*-- x := \[Gamma] - Sqrt[\[Gamma]^2-1]*)
(*-- \[Delta]:=1-x*)
(*-- m[i] := m_i  (masses)*)
(*-- M := m[1] + m[2] (total mass)*)
(*-- \[Nu] := m_1 m_2/(m_1+m_2)^2  (symmetric mass ratio)*)
(*-- mB := |b|  (modulus of impact parameter)*)
(*-- Gn := G_N (Newton's constant)*)
(*-- \[CapitalGamma]:= E/M (dimensionless total energy)*)


(* ::Subsection:: *)
(*Vectors:*)


(* ::Text:: *)
(*v[i] := v_i  (velocities)*)
(*b := b_2-b_1  (impact parameter)*)


(* ::Subsection:: *)
(*Flags*)


(* ::Text:: *)
(*tailpot := coefficient for all terms belonging to PPP and Tail regions*)
(*mem := coefficient for all terms belonging to the Memory region*)


cM = 1; 


(* ::Text:: *)
(*cM coefficient  as in Eq. (9), takes value 1 in \[Gamma]-3 prescription*)


(* ::Subsection:: *)
(*Results*)


(* ::Text:: *)
(*thetaC[n,m] := scattering angle at nth PM and mth SF order, as in Eq. (12)*)
(*\[CapitalDelta]p[n,m] := impulse at nth PM and mth SF order, as in Eq. (3). Note that m=bar0, bar1 -> \bar{0}, \bar{1}.*)
(*functionBasis:= Basis functions  basis[n]:=- f_n of Table I*)


(* ::Section:: *)
(*Results*)


(* ::Subsection::Closed:: *)
(*Scattering angle*)


thetaCTotal = \[CapitalGamma] ((Gn M/mB) thetaC[1,0]
					+ (Gn M/mB)^2 thetaC[2,0]
					+ (Gn M/mB)^3 (thetaC[3,0] + \[Nu] thetaC[3,1])
					+ (Gn M/mB)^4 (thetaC[4,0] + \[Nu] thetaC[4,1])
					+ (Gn M/mB)^5 (thetaC[5,0] + \[Nu] thetaC[5,1] + \[Nu]^2 thetaC[5,2]));


(* ::Subsubsection::Closed:: *)
(*1PM*)


thetaC[1, 0] = (-2 + 4*\[Gamma]^2)/(-1 + \[Gamma]^2)


(* ::Subsubsection::Closed:: *)
(*2PM*)


thetaC[2, 0] = (3*Pi*(-1 + 5*\[Gamma]^2))/(4*(-1 + \[Gamma]^2))


(* ::Subsubsection::Closed:: *)
(*3PM*)


thetaC[3, 0] = (2*(-5 + 60*\[Gamma]^2 - 120*\[Gamma]^4 + 64*\[Gamma]^6))/
     (3*(-1 + \[Gamma]^2)^3)


thetaC[3, 1] = (4*(-5 + 50*\[Gamma] + 110*\[Gamma]^2 - 22*\[Gamma]^3 - 
       142*\[Gamma]^4 - 28*\[Gamma]^5 + 36*\[Gamma]^6 + 
       (6*(1 + \[Gamma])^2*(3 - 3*\[Gamma] + 12*\[Gamma]^2 - 12*\[Gamma]^3 - 
          4*\[Gamma]^4 + 4*\[Gamma]^5)*G[1,1-x])/Sqrt[-1 + \[Gamma]^2]))/
     (3*(-1 + \[Gamma])^2*(1 + \[Gamma])^3)


(* ::Subsubsection::Closed:: *)
(*4PM*)


thetaC[4, 0] = (105*Pi*(1 - 18*\[Gamma]^2 + 33*\[Gamma]^4))/
     (64*(-1 + \[Gamma]^2)^2)


thetaC[4, 1] = (3*Pi*(148 + 1215*\[Gamma]^2 - 4778*\[Gamma]^4 + 
        5671*\[Gamma]^6 - 2520*\[Gamma]^8 + 280*\[Gamma]^10 + 
        60*\[Gamma]*Sqrt[-1 + \[Gamma]^2] + 1700*\[Gamma]^3*
         Sqrt[-1 + \[Gamma]^2] - 3380*\[Gamma]^5*Sqrt[-1 + \[Gamma]^2] + 
        1900*\[Gamma]^7*Sqrt[-1 + \[Gamma]^2] - 280*\[Gamma]^9*
         Sqrt[-1 + \[Gamma]^2])*G[1, 1 - x]^2)/(32*(-1 + \[Gamma]^2)^4) + 
     (Pi*\[Gamma]*(852 + 283*\[Gamma]^2 + 140*\[Gamma]^4 - 75*\[Gamma]^6)*
       G[1 - I, 1 - x])/(2*(-1 + \[Gamma]^2)^2) + 
     (Pi*\[Gamma]*(852 + 283*\[Gamma]^2 + 140*\[Gamma]^4 - 75*\[Gamma]^6)*
       G[1 + I, 1 - x])/(2*(-1 + \[Gamma]^2)^2) - 
     (3*Pi*(12 + 64*\[Gamma] + 65*\[Gamma]^2 - 5*\[Gamma]^3 - 25*\[Gamma]^4 + 
        25*\[Gamma]^5)*G[2, 1 - x]^2)/(4*(-1 + \[Gamma])) + 
     G[0, 1 - x]*(-1/8*(Pi*(1151 - 3336*\[Gamma] + 3148*\[Gamma]^2 - 
           912*\[Gamma]^3 + 339*\[Gamma]^4 - 552*\[Gamma]^5 + 
           210*\[Gamma]^6))/(-1 + \[Gamma]^2)^2 - 
       (3*Pi*(-70*\[Gamma]^7 + 10*Sqrt[-1 + \[Gamma]^2] + 
          290*\[Gamma]^2*Sqrt[-1 + \[Gamma]^2] - 370*\[Gamma]^4*
           Sqrt[-1 + \[Gamma]^2] + 70*\[Gamma]^6*Sqrt[-1 + \[Gamma]^2] + 
          \[Gamma]*(33 - 152*Sqrt[-1 + \[Gamma]^2]) + 16*\[Gamma]^3*
           (-7 + 2*Sqrt[-1 + \[Gamma]^2]) + 15*\[Gamma]^5*
           (11 + 8*Sqrt[-1 + \[Gamma]^2]))*G[1, 1 - x])/
        (8*(-1 + \[Gamma]^2)^(5/2)) + 
       (3*Pi*(-5 + 76*\[Gamma] - 150*\[Gamma]^2 + 60*\[Gamma]^3 + 
          35*\[Gamma]^4)*G[2, 1 - x])/(2*(-1 + \[Gamma]^2))) + 
     (3*Pi*(-12 + 5*\[Gamma]^6 - 55*\[Gamma]^7 + 25*\[Gamma]^8 + 
        25*\[Gamma]^9 + \[Gamma]^5*(219 - 60*Sqrt[-1 + \[Gamma]^2]) + 
        8*\[Gamma]*(-11 + 3*Sqrt[-1 + \[Gamma]^2]) + 
        5*\[Gamma]^4*(35 + 12*Sqrt[-1 + \[Gamma]^2]) + 
        \[Gamma]^3*(-101 + 74*Sqrt[-1 + \[Gamma]^2]) - 
        \[Gamma]^2*(193 + 90*Sqrt[-1 + \[Gamma]^2]))*G[0, 1, 1 - x])/
      (4*(-1 + \[Gamma])^2*(1 + \[Gamma])^3) + 
     (3*Pi*(20 + 111*\[Gamma]^2 + 30*\[Gamma]^4 - 25*\[Gamma]^6)*
       G[0, 1 - I, 1 - x])/(2*(-1 + \[Gamma]^2)) + 
     (3*Pi*(20 + 111*\[Gamma]^2 + 30*\[Gamma]^4 - 25*\[Gamma]^6)*
       G[0, 1 + I, 1 - x])/(2*(-1 + \[Gamma]^2)) + 
     (3*Pi*(-52 - 76*\[Gamma] - 351*\[Gamma]^2 - 60*\[Gamma]^3 - 
        30*\[Gamma]^4 + 25*\[Gamma]^6)*G[0, 2, 1 - x])/
      (2*(-1 + \[Gamma]^2)) + (3*Pi*(-12 + 5*\[Gamma]^6 - 55*\[Gamma]^7 + 
        25*\[Gamma]^8 + 25*\[Gamma]^9 + \[Gamma]^5*
         (219 - 60*Sqrt[-1 + \[Gamma]^2]) + 8*\[Gamma]*
         (-11 + 3*Sqrt[-1 + \[Gamma]^2]) + 5*\[Gamma]^4*
         (35 + 12*Sqrt[-1 + \[Gamma]^2]) + \[Gamma]^3*
         (-101 + 74*Sqrt[-1 + \[Gamma]^2]) - \[Gamma]^2*
         (193 + 90*Sqrt[-1 + \[Gamma]^2]))*G[1, 2, 1 - x])/
      (4*(-1 + \[Gamma])^2*(1 + \[Gamma])^3) + 
     (3*Pi*(-20 - 111*\[Gamma]^2 - 30*\[Gamma]^4 + 25*\[Gamma]^6)*
       G[2, 1 - I, 1 - x])/(2*(-1 + \[Gamma]^2)) + 
     (3*Pi*(-20 - 111*\[Gamma]^2 - 30*\[Gamma]^4 + 25*\[Gamma]^6)*
       G[2, 1 + I, 1 - x])/(2*(-1 + \[Gamma]^2)) + 
     (Pi*(45 - 207*\[Gamma]^2 + 1471*\[Gamma]^4 - 13349*\[Gamma]^6 + 
        38135*\[Gamma]^7 + 288*Pi^2*\[Gamma]^7 - 64424*\[Gamma]^8 - 
        1824*Pi^2*\[Gamma]^8 + 32177*\[Gamma]^9 + 2520*Pi^2*\[Gamma]^9 + 
        15056*\[Gamma]^10 + 2208*Pi^2*\[Gamma]^10 + 25145*\[Gamma]^11 - 
        6624*Pi^2*\[Gamma]^11 - 27952*\[Gamma]^12 + 1056*Pi^2*\[Gamma]^12 - 
        33249*\[Gamma]^13 + 5136*Pi^2*\[Gamma]^13 + 35360*\[Gamma]^14 - 
        1440*Pi^2*\[Gamma]^14 - 4320*\[Gamma]^15 - 1920*Pi^2*\[Gamma]^15 - 
        3600*\[Gamma]^16 + 600*Pi^2*\[Gamma]^17 - 126*\[Gamma]^7*
         (1 + \[Gamma])^2*(-169 + 169*\[Gamma] - 380*\[Gamma]^2 + 
          380*\[Gamma]^3)*EllipticE[(-1 + \[Gamma])/(1 + \[Gamma])]^2 + 
        36*\[Gamma]^7*(-1183 - 2929*\[Gamma] - 1477*\[Gamma]^2 + 
          1729*\[Gamma]^3 + 2660*\[Gamma]^4 + 1200*\[Gamma]^5)*
         EllipticE[(-1 + \[Gamma])/(1 + \[Gamma])]*
         EllipticK[(-1 + \[Gamma])/(1 + \[Gamma])] - 
        36*\[Gamma]^7*(-834 - 2095*\[Gamma] - 366*\[Gamma]^2 + 
          2095*\[Gamma]^3 + 1200*\[Gamma]^4)*
         EllipticK[(-1 + \[Gamma])/(1 + \[Gamma])]^2 - 
        27624*\[Gamma]^7*Log[2] + 80064*\[Gamma]^8*Log[2] - 
        47928*\[Gamma]^9*Log[2] - 58176*\[Gamma]^10*Log[2] + 
        67416*\[Gamma]^11*Log[2] - 8640*\[Gamma]^12*Log[2] + 
        3096*\[Gamma]^13*Log[2] - 13248*\[Gamma]^14*Log[2] + 
        5040*\[Gamma]^15*Log[2]))/(192*\[Gamma]^7*(-1 + \[Gamma]^2)^3) + 
     (Pi*G[2, 1 - x]*(-1759 + 300*\[Gamma]^7 - 60*Log[2] - 
        210*\[Gamma]^6*(1 + 2*Log[2]) + 24*\[Gamma]*(-281 + 38*Log[2]) - 
        4*\[Gamma]^3*(511 + 48*Log[2]) - 8*\[Gamma]^5*(139 + 90*Log[2]) - 
        4*\[Gamma]^2*(923 + 435*Log[2]) + 3*\[Gamma]^4*(-929 + 740*Log[2])))/
      (8*(-1 + \[Gamma]^2)^2) + G[1, 1 - x]*
      ((-3*Pi*(-111*\[Gamma] - 1096*\[Gamma]^3 + 885*\[Gamma]^5 - 
          70*\[Gamma]^7 + 114*Sqrt[-1 + \[Gamma]^2] + 50*\[Gamma]^8*
           Sqrt[-1 + \[Gamma]^2] - 40*\[Gamma]^6*
           (3 + Sqrt[-1 + \[Gamma]^2]) + 12*\[Gamma]^2*
           (19 + 74*Sqrt[-1 + \[Gamma]^2]) - 4*\[Gamma]^4*
           (-7 + 253*Sqrt[-1 + \[Gamma]^2]))*G[2, 1 - x])/
        (8*(-1 + \[Gamma]^2)^(5/2)) + 
       (Pi*(300*\[Gamma]^11 + 12*\[Gamma]^4*(-637 + 
            440*Sqrt[-1 + \[Gamma]^2] - 470*Log[2]) - 24*\[Gamma]^6*
           (42*(-1 + Sqrt[-1 + \[Gamma]^2]) - 275*Log[2]) + 
          18*\[Gamma]^8*(127 + 80*Sqrt[-1 + \[Gamma]^2] - 170*Log[2]) - 
          12*\[Gamma]^2*(-85 + 876*Sqrt[-1 + \[Gamma]^2] - 135*Log[2]) + 
          420*\[Gamma]^10*(1 + Log[2]) + 30*(97 + 2*Log[2]) - 
          20*\[Gamma]^9*(58 + 21*Sqrt[-1 + \[Gamma]^2] + 
            3*(-12 + 7*Sqrt[-1 + \[Gamma]^2])*Log[2]) - 
          3*\[Gamma]*(1136 - 1151*Sqrt[-1 + \[Gamma]^2] + 
            (304 + 66*Sqrt[-1 + \[Gamma]^2])*Log[2]) + 
          \[Gamma]^3*(5684 + 7142*Sqrt[-1 + \[Gamma]^2] + 
            6*(336 + 145*Sqrt[-1 + \[Gamma]^2])*Log[2]) + 
          6*\[Gamma]^7*(-8*(-6 + Sqrt[-1 + \[Gamma]^2]) + 
            (-208 + 235*Sqrt[-1 + \[Gamma]^2])*Log[2]) - 
          \[Gamma]^5*(1704 + 5279*Sqrt[-1 + \[Gamma]^2] + 
            6*(96 + 277*Sqrt[-1 + \[Gamma]^2])*Log[2])))/
        (16*(-1 + \[Gamma]^2)^4))


(* ::Subsubsection::Closed:: *)
(*5PM*)


thetaC[5, 2] = tailpot*thetaC[5,2,tailpot] + mem*thetaC[5,2,mem]


thetaC[5, 0] = (2*(-21 + 630*\[Gamma]^2 - 3360*\[Gamma]^4 + 6720*\[Gamma]^6 - 
       5760*\[Gamma]^8 + 1792*\[Gamma]^10))/(5*(-1 + \[Gamma]^2)^5)


thetaC[5, 1] = ((10395 + 10395*\[Gamma] + 393120*\[Gamma]^2 + 
        393120*\[Gamma]^3 - 536235*\[Gamma]^4 - 536235*\[Gamma]^5 + 
        16955505*\[Gamma]^6 + 16701489*\[Gamma]^7 + 70236432*\[Gamma]^8 + 
        77856912*\[Gamma]^9 - 362536115*\[Gamma]^10 - 403178675*\[Gamma]^11 + 
        516398286*\[Gamma]^12 + 597683406*\[Gamma]^13 - 
        236079666*\[Gamma]^14 - 305752626*\[Gamma]^15 + 
        20978054*\[Gamma]^16 + 42654086*\[Gamma]^17 + 1880064*\[Gamma]^18 + 
        1880064*\[Gamma]^19)*basis[1])/(7560*(-1 + \[Gamma])^4*\[Gamma]^7*
       (1 + \[Gamma])^5) - ((-18585 + 240905*\[Gamma]^2 - 988015*\[Gamma]^4 + 
        6510035*\[Gamma]^6 - 134264214*\[Gamma]^8 + 277369170*\[Gamma]^10 - 
        315460542*\[Gamma]^12 + 169295016*\[Gamma]^14 - 
        23185512*\[Gamma]^16 - 7809042*\[Gamma]^18 + 651264*\[Gamma]^20)*
       basis[2])/(2520*\[Gamma]^8*(-1 + \[Gamma]^2)^(9/2)) + 
     ((1575 - 8250*\[Gamma]^2 + 35710*\[Gamma]^4 - 142640*\[Gamma]^6 - 
        5560073*\[Gamma]^8 - 417302*\[Gamma]^10 + 4034092*\[Gamma]^12 - 
        587336*\[Gamma]^14 + 6144*\[Gamma]^16)*basis[3])/
      (360*(-1 + \[Gamma])^3*\[Gamma]^7*(1 + \[Gamma])^3) - 
     (\[Gamma]*(-7817455 - 1872978*\[Gamma]^2 + 1564672*\[Gamma]^4 - 
        90112*\[Gamma]^6 + 32768*\[Gamma]^8)*basis[4])/
      (336*(-1 + \[Gamma])^2*(1 + \[Gamma])^2) - 
     ((-11025 + 72450*\[Gamma]^2 - 330890*\[Gamma]^4 + 1352120*\[Gamma]^6 - 
        5433687*\[Gamma]^8 - 59068870*\[Gamma]^10 + 61205662*\[Gamma]^12 + 
        17085516*\[Gamma]^14 - 32742084*\[Gamma]^16 + 10655064*\[Gamma]^18 - 
        2482176*\[Gamma]^20 + 491520*\[Gamma]^22)*basis[5])/
      (840*(-1 + \[Gamma])^5*\[Gamma]^7*(1 + \[Gamma])^5) - 
     ((525 - 3100*\[Gamma]^2 + 13690*\[Gamma]^4 - 55260*\[Gamma]^6 + 
        816595*\[Gamma]^8 + 3752006*\[Gamma]^10 - 1978290*\[Gamma]^12 - 
        1029342*\[Gamma]^14 + 213480*\[Gamma]^16 + 24576*\[Gamma]^18)*
       basis[6])/(120*\[Gamma]^8*(-1 + \[Gamma]^2)^(7/2)) + 
     ((-105 + 155*\[Gamma]^2 - 1935*\[Gamma]^4 - 5091*\[Gamma]^6 + 
        666260*\[Gamma]^8 - 154716*\[Gamma]^10 - 689664*\[Gamma]^12 + 
        198856*\[Gamma]^14)*basis[7])/(12*\[Gamma]^8*(-1 + \[Gamma]^2)^
        (5/2)) - ((1260 - 2268*\[Gamma]^2 + 49728*\[Gamma]^4 - 
        2828161*\[Gamma]^6 + 1882567*\[Gamma]^8 + 3040161*\[Gamma]^10 - 
        3741239*\[Gamma]^12 + 1182464*\[Gamma]^14 - 208896*\[Gamma]^16 + 
        49152*\[Gamma]^18)*basis[8])/(42*\[Gamma]^6*(-1 + \[Gamma]^2)^
        (7/2)) - (\[Gamma]*(-5369 - 12598*\[Gamma]^2 + 17700*\[Gamma]^4 - 
        450*\[Gamma]^6 + 525*\[Gamma]^8)*basis[9])/
      (4*(-1 + \[Gamma]^2)^(7/2)) - 
     ((-199207 - 1240416*\[Gamma]^2 + 189180*\[Gamma]^4 + 81920*\[Gamma]^6)*
       basis[10])/(48*(-1 + \[Gamma]^2)^(5/2)) - 
     (128*\[Gamma]*(-3 + 2*\[Gamma]^2)*(-8 - 51*\[Gamma]^2 - 6*\[Gamma]^4 + 
        8*\[Gamma]^6)*basis[11])/((-1 + \[Gamma])^4*(1 + \[Gamma])^4) - 
     (\[Gamma]*(-3 + 2*\[Gamma]^2)*(-2057 - 12957*\[Gamma]^2 - 
        1851*\[Gamma]^4 + 2273*\[Gamma]^6)*basis[12])/
      (2*(-1 + \[Gamma])^4*(1 + \[Gamma])^4) - 
     (\[Gamma]*(-1182 - 5177*\[Gamma]^2 + 1920*\[Gamma]^4 + 1575*\[Gamma]^6)*
       basis[13])/(2*(-1 + \[Gamma]^2)^(5/2)) - 
     ((-9 - 1053*\[Gamma]^2 - 1083*\[Gamma]^4 + 1249*\[Gamma]^6)*basis[14])/
      (-1 + \[Gamma]^2)^(5/2) - (3*(-9 + 56*\[Gamma] + 99*\[Gamma]^2 - 
        1200*\[Gamma]^3 - 315*\[Gamma]^4 + 600*\[Gamma]^5 + 225*\[Gamma]^6)*
       basis[15])/(-1 + \[Gamma]^2)^(5/2) + 
     (\[Gamma]*(-1209 - 6422*\[Gamma]^2 + 1755*\[Gamma]^4 + 2100*\[Gamma]^6)*
       basis[16])/(4*(-1 + \[Gamma]^2)^(5/2)) + 
     (9*\[Gamma]*(-3 + 2*\[Gamma]^2)*(-1 + 5*\[Gamma]^2)^2*basis[17])/
      ((-1 + \[Gamma])^3*(1 + \[Gamma])^3) + 
     ((-2039 - 13155*\[Gamma]^2 - 1221*\[Gamma]^4 + 1823*\[Gamma]^6)*
       basis[18])/(-1 + \[Gamma]^2)^(5/2) + 
     (\[Gamma]*(-3 + 2*\[Gamma]^2)*(-2039 - 12003*\[Gamma]^2 - 
        453*\[Gamma]^4 + 799*\[Gamma]^6)*basis[19])/((-1 + \[Gamma])^4*
       (1 + \[Gamma])^4) + (768*(-19 - 116*\[Gamma]^2 + 14*\[Gamma]^4 + 
        8*\[Gamma]^6)*basis[20])/(-1 + \[Gamma]^2)^(5/2) - 
     (3*\[Gamma]^2*(-3 + 2*\[Gamma]^2)*(-37 + 185*\[Gamma]^2 - 
        355*\[Gamma]^4 + 175*\[Gamma]^6)*basis[21])/(4*(-1 + \[Gamma])^4*
       (1 + \[Gamma])^4) - (4*(-6263 - 38115*\[Gamma]^2 + 6459*\[Gamma]^4 + 
        1823*\[Gamma]^6)*basis[22])/(-1 + \[Gamma]^2)^(5/2) - 
     ((-75 - 3747*\[Gamma]^2 - 2817*\[Gamma]^4 + 3871*\[Gamma]^6)*basis[23])/
      (2*(-1 + \[Gamma]^2)^(5/2)) - 
     (3*\[Gamma]*(-121 + 1985*\[Gamma]^2 - 1255*\[Gamma]^4 + 175*\[Gamma]^6)*
       basis[24])/(4*(-1 + \[Gamma]^2)^(5/2)) + 
     ((111 - 5865*\[Gamma]^2 - 2067*\[Gamma]^4 + 3421*\[Gamma]^6)*basis[25])/
      (2*(-1 + \[Gamma]^2)^(5/2)) + 
     (48*\[Gamma]*(7 - 150*\[Gamma]^2 + 75*\[Gamma]^4)*basis[26])/
      (-1 + \[Gamma]^2)^(5/2) - (2*(-12553 - 75933*\[Gamma]^2 + 
        11973*\[Gamma]^4 + 4321*\[Gamma]^6)*basis[27])/
      (-1 + \[Gamma]^2)^(5/2) - (64*(32 - 72*\[Gamma]^2 - 1665*\[Gamma]^4 + 
        2058*\[Gamma]^6 - 84*\[Gamma]^8 - 600*\[Gamma]^10 + 160*\[Gamma]^12)*
       basis[28])/(3*(-1 + \[Gamma]^2)^(11/2)) - 
     (\[Gamma]*(-3 + 2*\[Gamma]^2)*(-2039 - 13155*\[Gamma]^2 - 
        1221*\[Gamma]^4 + 1823*\[Gamma]^6)*basis[29])/
      ((-1 + \[Gamma])^4*(1 + \[Gamma])^4) + 
     ((258 - 1935*\[Gamma] - 7518*\[Gamma]^2 + 5488*\[Gamma]^3 + 
        198*\[Gamma]^4 - 5775*\[Gamma]^5 + 1846*\[Gamma]^6 + 3150*\[Gamma]^7)*
       basis[30])/(8*(-1 + \[Gamma]^2)^(5/2)) + 
     ((-114 - 1041*\[Gamma] - 2241*\[Gamma]^2 - 1691*\[Gamma]^3 + 
        389*\[Gamma]^4 + 1696*\[Gamma]^5 + 1050*\[Gamma]^6)*basis[31])/
      (8*(-1 + \[Gamma])^2*(1 + \[Gamma])*Sqrt[-1 + \[Gamma]^2])


thetaC[5, 2, tailpot] = functionEven[II[{kern[z^(-1)], kern[(1 - z^2)/(z - z^2 + z^3)], 
      kern[z^(-1)]}] - II[{kern[z^(-1)], kern[(1 - z^2)/(z + z^2 + z^3)], 
      kern[z^(-1)]}]]*polynomialEven[(-243*\[Gamma]*(-3 + 2*\[Gamma]^2)*
     (-1 + 5*\[Gamma]^2)^2)/(8*(-1 + \[Gamma]^2)^3)] + 
 functionEven[II[{kern[z^(-1)], kern[z^(-1)], kern[(-1 + z)/(z*(1 + z))]}] + 
    II[{kern[z^(-1)], kern[z^(-1)], kern[(1 + z)/((-1 + z)*z)]}] + 
    2*II[{kern[z^(-1)], kern[z^(-1)]}]*Log[2]]*
  polynomialEven[(512*\[Gamma]*(24 + 60*\[Gamma] + 137*\[Gamma]^2 + 
      35*\[Gamma]^3 - 84*\[Gamma]^4 - 59*\[Gamma]^5 - 36*\[Gamma]^6 + 
      16*\[Gamma]^8 + 4*\[Gamma]^9))/(-1 + \[Gamma]^2)^4] + 
 functionEven[II[{kern[z^(-1)], kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)]}]]*
  polynomialEven[(64*\[Gamma]*(96 + 429*\[Gamma] + 602*\[Gamma]^2 + 
      314*\[Gamma]^3 - 336*\[Gamma]^4 - 490*\[Gamma]^5 - 216*\[Gamma]^6 + 
      96*\[Gamma]^8 + 40*\[Gamma]^9))/(-1 + \[Gamma]^2)^4] + 
 functionEven[II[{kern[z^(-1)], kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]]*
  polynomialEven[-((\[Gamma]*(108 - 23859*\[Gamma] - 1260*\[Gamma]^2 + 
       4257*\[Gamma]^3 + 4572*\[Gamma]^4 + 10961*\[Gamma]^5 - 
       5220*\[Gamma]^6 - 3705*\[Gamma]^7 + 1800*\[Gamma]^8 + 
       1050*\[Gamma]^9))/(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[(\[Gamma]*(54 + 2637*\[Gamma] + 13194*\[Gamma]^2 + 
      8865*\[Gamma]^3 + 2286*\[Gamma]^4 - 8495*\[Gamma]^5 - 
      21042*\[Gamma]^6 - 3705*\[Gamma]^7 + 9092*\[Gamma]^8 + 
      3098*\[Gamma]^9))/(2*(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[-((\[Gamma]*(-24468 - 9369*\[Gamma] - 141548*\[Gamma]^2 + 
       31203*\[Gamma]^3 + 90588*\[Gamma]^4 - 7053*\[Gamma]^5 + 
       31644*\[Gamma]^6 - 11115*\[Gamma]^7 - 14584*\[Gamma]^8 + 
       3150*\[Gamma]^9))/(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[z^(-1)], kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)]}]]*
  polynomialEven[(\[Gamma]*(6252 + 27789*\[Gamma] + 37268*\[Gamma]^2 + 
      18209*\[Gamma]^3 - 16932*\[Gamma]^4 - 27055*\[Gamma]^5 - 
      19044*\[Gamma]^6 - 3705*\[Gamma]^7 + 7944*\[Gamma]^8 + 
      3610*\[Gamma]^9))/(-1 + \[Gamma]^2)^4] + 
 functionEven[II[{kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[(\[Gamma]*(162 + 3969*\[Gamma] + 11934*\[Gamma]^2 + 
      1317*\[Gamma]^3 + 6858*\[Gamma]^4 + 8725*\[Gamma]^5 - 
      26262*\[Gamma]^6 - 18525*\[Gamma]^7 + 10892*\[Gamma]^8 + 
      7298*\[Gamma]^9))/(2*(-1 + \[Gamma]^2)^4)] + 
 functionEven[-II[{kern[(-1 + z)/(z*(1 + z))]}] - 
    II[{kern[(1 + z)/((-1 + z)*z)]}] - 2*Log[2]]*
  polynomialEven[(-385875 + 771750*\[Gamma] + 1837500*\[Gamma]^2 - 
     4042500*\[Gamma]^3 - 7188300*\[Gamma]^4 + 17497900*\[Gamma]^5 + 
     21241500*\[Gamma]^6 - 69893600*\[Gamma]^7 - 752357266*\[Gamma]^8 - 
     2724435770*\[Gamma]^9 - 4066583215*\[Gamma]^10 - 204477980*\[Gamma]^11 + 
     3666321886*\[Gamma]^12 + 1976705080*\[Gamma]^13 + 
     558224042*\[Gamma]^14 - 287794640*\[Gamma]^15 - 318633472*\[Gamma]^16 + 
     3010560*\[Gamma]^17)/(88200*\[Gamma]^8*(-1 + \[Gamma]^2)^3)] + 
 functionEven[(Pi^2*(1 + x^2)*(2*x*\[Omega]0K3[x] + 
      (-1 + x^2)*Derivative[1][\[Omega]0K3][x]))/
    (2*Sqrt[2]*x*\[Omega]0K3[x])]*polynomialEven[
   (-4*(-71441023140 - 74590066944*\[Gamma]^2 + 500006049795*\[Gamma]^4 - 
      430621956207*\[Gamma]^6 + 163543923450*\[Gamma]^8 - 
      32928266424*\[Gamma]^10 + 3425665911*\[Gamma]^12 - 
      94322815*\[Gamma]^14 - 18483752*\[Gamma]^16 + 2293470*\[Gamma]^18 - 
      108424*\[Gamma]^20 + 1960*\[Gamma]^22))/
    (135*\[Gamma]*(9 - \[Gamma]^2)^(13/2)*(-1 + \[Gamma]^2)^4)] + 
 functionEven[Sqrt[2]*Pi^2]*polynomialEven[
   (-8*\[Gamma]*(100010169369 - 1065466942146*\[Gamma]^2 + 
      289379234907*\[Gamma]^4 + 506567453742*\[Gamma]^6 - 
      401937710301*\[Gamma]^8 + 137327274588*\[Gamma]^10 - 
      27325236891*\[Gamma]^12 + 3441459262*\[Gamma]^14 - 
      279127708*\[Gamma]^16 + 14176194*\[Gamma]^18 - 411296*\[Gamma]^20 + 
      5240*\[Gamma]^22))/(135*(9 - \[Gamma]^2)^(15/2)*(-1 + \[Gamma]^2)^4)] + 
 functionEven[Pi^2]*polynomialEven[-1/227082240*
    (465696000 - 3667910400*\[Gamma]^2 + 16238376000*\[Gamma]^4 - 
      57010504320*\[Gamma]^6 + 293689020260*\[Gamma]^8 + 
      10566697574400*\[Gamma]^9 + 774048860236*\[Gamma]^10 - 
      18601728245760*\[Gamma]^11 + 475434870121*\[Gamma]^12 + 
      3388427919360*\[Gamma]^13 - 428007546182*\[Gamma]^14 + 
      6883341189120*\[Gamma]^15 - 1084682889107*\[Gamma]^16 - 
      2402832875520*\[Gamma]^17 + 1316642357248*\[Gamma]^18 + 
      210386288640*\[Gamma]^19 - 714843619328*\[Gamma]^20 - 
      44291850240*\[Gamma]^21 + 146834194432*\[Gamma]^22)/
     (\[Gamma]^8*(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[-1/9461760*(-217324800 + 496742400*\[Gamma] + 
      892953600*\[Gamma]^2 - 3264307200*\[Gamma]^3 - 2802676800*\[Gamma]^4 + 
      14908579840*\[Gamma]^5 + 5970148800*\[Gamma]^6 - 
      60921118720*\[Gamma]^7 + 45891699532*\[Gamma]^8 + 
      244820201472*\[Gamma]^9 + 464863952632*\[Gamma]^10 + 
      2661407006720*\[Gamma]^11 + 2701551832159*\[Gamma]^12 - 
      2757682307072*\[Gamma]^13 - 5076415555813*\[Gamma]^14 - 
      769805008896*\[Gamma]^15 + 2509774527633*\[Gamma]^16 + 
      1475227336704*\[Gamma]^17 - 754884629199*\[Gamma]^18 - 
      480074563584*\[Gamma]^19 + 660045037568*\[Gamma]^20 + 
      111836921856*\[Gamma]^21 - 316015640576*\[Gamma]^22 - 
      22145925120*\[Gamma]^23 + 51405389824*\[Gamma]^24)/
     (\[Gamma]^8*(-1 + \[Gamma]^2)^5)] + 
 functionEven[1]*polynomialEven[(-1111616352000 - 1398485088000*\[Gamma] + 
     33790927632000*\[Gamma]^2 + 30113792016000*\[Gamma]^3 - 
     474678292704000*\[Gamma]^4 - 264391918560000*\[Gamma]^5 + 
     4101598614036000*\[Gamma]^6 + 835664700948000*\[Gamma]^7 - 
     24155477264423096*\[Gamma]^8 + 4525413818482504*\[Gamma]^9 + 
     97775342157032390*\[Gamma]^10 - 42089585662692410*\[Gamma]^11 - 
     242261633640337013*\[Gamma]^12 - 133816173437380213*\[Gamma]^13 + 
     104904905200980752*\[Gamma]^14 + 3490391559567905552*\[Gamma]^15 + 
     2063120438437015567*\[Gamma]^16 - 22747420589169102833*\[Gamma]^17 - 
     10821993955531193448*\[Gamma]^18 + 81169888516313977752*\[Gamma]^19 + 
     32680047986503494672*\[Gamma]^20 - 177133957430083769328*\[Gamma]^21 - 
     66523109410467748608*\[Gamma]^22 + 239341519525539931392*\[Gamma]^23 + 
     87184106149041299712*\[Gamma]^24 - 194182183670931103488*\[Gamma]^25 - 
     61015010851591579648*\[Gamma]^26 + 92883859585696765952*\[Gamma]^27 + 
     8491875724641169408*\[Gamma]^28 - 35154809498313428992*\[Gamma]^29 + 
     12254654051240640512*\[Gamma]^30 + 16544832734271373312*\[Gamma]^31 - 
     6186424937008332800*\[Gamma]^32 - 5973909096208793600*\[Gamma]^33 + 
     988499608076288000*\[Gamma]^34 + 988499608076288000*\[Gamma]^35)/
    (104315904000*(-1 + \[Gamma])^4*\[Gamma]^8*(1 + \[Gamma])^5*
     (-1 + 2*\[Gamma])^6*(1 + 2*\[Gamma])^6)] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[(1 + z)/((-1 + z)*z)], 
     kern[z^(-1)]}]]*polynomialOdd[(27*(-1 + 5*\[Gamma]^2)^2)/
    (-1 + \[Gamma]^2)^(3/2)] + 
 functionOdd[II[{kern[(-1 + z^2)/(z + z^3)], kern[(1 - z^2)/(z - z^2 + z^3)], 
      kern[z^(-1)]}] + II[{kern[(-1 + z^2)/(z + z^3)], 
      kern[(1 - z^2)/(z + z^2 + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(-270*\[Gamma]*(-37 - 30*\[Gamma]^2 + 15*\[Gamma]^4))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[-II[{kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)], 
       kern[(-1 + z)/(z*(1 + z))]}] - II[{kern[(1 + z)/((-1 + z)*z)], 
      kern[z^(-1)], kern[(1 + z)/((-1 + z)*z)]}] - 
    2*II[{kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)]}]*Log[2]]*
  polynomialOdd[(\[Gamma]*Sqrt[-1 + \[Gamma]^2]*(987 - 3621*\[Gamma] + 
      3911*\[Gamma]^2 + 839*\[Gamma]^3 - 3046*\[Gamma]^4 + 1050*\[Gamma]^5))/
    (4*(-1 + \[Gamma])^2*(1 + \[Gamma])^3)] + 
 functionOdd[II[{kern[(1 + z)/((-1 + z)*z)], kern[(1 - z^2)/(z - z^2 + z^3)], 
     kern[z^(-1)]}]]*polynomialOdd[
   (-27*(-9 - 56*\[Gamma] + 99*\[Gamma]^2 + 1200*\[Gamma]^3 - 
      315*\[Gamma]^4 - 600*\[Gamma]^5 + 225*\[Gamma]^6))/
    (4*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[(1 - z^2)/(z + z^2 + z^3)], 
     kern[z^(-1)]}]]*polynomialOdd[
   (27*(-9 + 56*\[Gamma] + 99*\[Gamma]^2 - 1200*\[Gamma]^3 - 315*\[Gamma]^4 + 
      600*\[Gamma]^5 + 225*\[Gamma]^6))/(4*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[(-1 + z^2)/(z + z^3)], kern[(-1 + z)/(z*(1 + z))], 
      kern[z^(-1)]}] + II[{kern[(-1 + z^2)/(z + z^3)], 
      kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)]}]]*
  polynomialOdd[(-2*(-12553 - 75933*\[Gamma]^2 + 11973*\[Gamma]^4 + 
      4321*\[Gamma]^6))/(-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[Pi^2*II[{kern[z^(-1)]}]]*polynomialOdd[
   (-199207 + 57344*\[Gamma] - 1240416*\[Gamma]^2 + 43008*\[Gamma]^3 + 
     189180*\[Gamma]^4 + 81920*\[Gamma]^6)/(24*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[Pi^2*II[{kern[(1 + z^2)^(-1)]}] - 
    8*II[{kern[(1 + z^2)^(-1)], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialOdd[(-40612528 - 254195160*\[Gamma]^2 + 6702790*\[Gamma]^4 + 
     24329925*\[Gamma]^6)/(32768*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[(-1 + z^2)/(z + z^3)], 
     kern[z^(-1)]}]]*polynomialOdd[
   (-6*(22 - 9*\[Gamma] - 254*\[Gamma]^2 - 415*\[Gamma]^3 - 190*\[Gamma]^4 - 
      55*\[Gamma]^5 + 150*\[Gamma]^6 + 175*\[Gamma]^7))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[(1 + z)/((-1 + z)*z)], kern[(-1 + z)/(z*(1 + z))], 
      kern[z^(-1)]}] - 2*II[{kern[(1 + z)/((-1 + z)*z)], 
       kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(3*(-40 - 121*\[Gamma] + 452*\[Gamma]^2 + 1985*\[Gamma]^3 - 
      440*\[Gamma]^4 - 1255*\[Gamma]^5 + 300*\[Gamma]^6 + 175*\[Gamma]^7))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[(-1 + z)/(z*(1 + z))], 
     kern[z^(-1)]}]]*polynomialOdd[
   (3*(13 - 9*\[Gamma] - 155*\[Gamma]^2 - 415*\[Gamma]^3 - 505*\[Gamma]^4 - 
      55*\[Gamma]^5 + 375*\[Gamma]^6 + 175*\[Gamma]^7))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[-II[{kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)], 
       kern[(-1 + z)/(z*(1 + z))]}] - II[{kern[(-1 + z^2)/(z + z^3)], 
      kern[z^(-1)], kern[(1 + z)/((-1 + z)*z)]}] - 
    2*II[{kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]*Log[2]]*
  polynomialOdd[(4078 + 1041*\[Gamma] + 26310*\[Gamma]^2 - 2773*\[Gamma]^3 + 
     2442*\[Gamma]^4 - 1065*\[Gamma]^5 - 3646*\[Gamma]^6 + 525*\[Gamma]^7)/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[(-1 + z^2)/(z + z^3)], kern[(-1 + z^2)/(z + z^3)], 
     kern[z^(-1)]}]]*polynomialOdd[
   (2*(-25106 + 3261*\[Gamma] - 151866*\[Gamma]^2 - 973*\[Gamma]^3 + 
      23946*\[Gamma]^4 - 1965*\[Gamma]^5 + 8642*\[Gamma]^6 + 525*\[Gamma]^7))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)], 
      kern[(-1 + z)/(z*(1 + z))]}] + II[{kern[(-1 + z)/(z*(1 + z))], 
      kern[z^(-1)], kern[(1 + z)/((-1 + z)*z)]}] + 
    2*II[{kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)]}]*Log[2]]*
  polynomialOdd[(-72 - 1431*\[Gamma] - 3816*\[Gamma]^2 - 5312*\[Gamma]^3 - 
     5592*\[Gamma]^4 - 375*\[Gamma]^5 + 5896*\[Gamma]^6 + 3150*\[Gamma]^7)/
    (4*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[z^(-1)], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialOdd[(128*(64 + 239*\[Gamma] - 144*\[Gamma]^2 - 1395*\[Gamma]^3 - 
      3330*\[Gamma]^4 - 495*\[Gamma]^5 + 4116*\[Gamma]^6 + 2673*\[Gamma]^7 - 
      168*\[Gamma]^8 - 1206*\[Gamma]^9 - 1200*\[Gamma]^10 - 168*\[Gamma]^11 + 
      320*\[Gamma]^12 + 112*\[Gamma]^13))/(-1 + \[Gamma]^2)^(11/2)] + 
 functionOdd[II[{kern[(1 - z^2)/(z - z^2 + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(3*(-3150 + 15120*\[Gamma]^2 - 54810*\[Gamma]^4 + 
      204120*\[Gamma]^6 + 575161*\[Gamma]^7 - 2776550*\[Gamma]^8 + 
      4328730*\[Gamma]^9 - 1783320*\[Gamma]^10 - 168595*\[Gamma]^11 - 
      98742*\[Gamma]^12 + 409600*\[Gamma]^14))/
    (280*\[Gamma]^7*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[(1 - z^2)/(z + z^2 + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(3*(-3150 + 15120*\[Gamma]^2 - 54810*\[Gamma]^4 + 
      204120*\[Gamma]^6 - 575161*\[Gamma]^7 - 2776550*\[Gamma]^8 - 
      4328730*\[Gamma]^9 - 1783320*\[Gamma]^10 + 168595*\[Gamma]^11 - 
      98742*\[Gamma]^12 + 409600*\[Gamma]^14))/
    (280*\[Gamma]^7*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[z^(-1)], kern[(-1 + z)/(z*(1 + z))]}] + 
    II[{kern[z^(-1)], kern[(1 + z)/((-1 + z)*z)]}] + 
    2*II[{kern[z^(-1)]}]*Log[2]]*polynomialOdd[
   (-3675 + 7350*\[Gamma] + 19950*\[Gamma]^2 - 43400*\[Gamma]^3 - 
     79800*\[Gamma]^4 + 191660*\[Gamma]^5 + 246540*\[Gamma]^6 - 
     773640*\[Gamma]^7 - 222810*\[Gamma]^8 + 11432330*\[Gamma]^9 + 
     25264989*\[Gamma]^10 + 52528084*\[Gamma]^11 + 38260656*\[Gamma]^12 - 
     27696060*\[Gamma]^13 - 48986718*\[Gamma]^14 - 14410788*\[Gamma]^15 - 
     81724*\[Gamma]^16 + 2988720*\[Gamma]^17 + 2732032*\[Gamma]^18 + 
     344064*\[Gamma]^19)/(840*\[Gamma]^9*(-1 + \[Gamma]^2)^(7/2))] + 
 functionOdd[II[{kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)]}]]*
  polynomialOdd[-1/295680*(-2587200 + 6406400*\[Gamma]^2 - 
      51497600*\[Gamma]^4 - 77763840*\[Gamma]^6 + 16710001785*\[Gamma]^8 - 
      6411302656*\[Gamma]^9 - 25529762944*\[Gamma]^10 - 
      13871466752*\[Gamma]^11 - 18663931902*\[Gamma]^12 + 
      16976484096*\[Gamma]^13 + 31119157784*\[Gamma]^14 - 
      4149221120*\[Gamma]^15 - 9111925075*\[Gamma]^16 + 
      4565434368*\[Gamma]^17 + 1349517312*\[Gamma]^18 - 
      3389521920*\[Gamma]^19 - 346030080*\[Gamma]^20 + 753926144*\[Gamma]^21)/
     (\[Gamma]^8*(-1 + \[Gamma]^2)^(7/2))] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)]}]]*
  polynomialOdd[-1/295680*(-2587200 + 6406400*\[Gamma]^2 - 
      51497600*\[Gamma]^4 - 77763840*\[Gamma]^6 + 15062144775*\[Gamma]^8 - 
      7205055616*\[Gamma]^9 - 37956551552*\[Gamma]^10 - 
      15733955072*\[Gamma]^11 - 4643508738*\[Gamma]^12 + 
      19593252096*\[Gamma]^13 + 31702682088*\[Gamma]^14 - 
      4215749120*\[Gamma]^15 - 9641226925*\[Gamma]^16 + 
      4643050368*\[Gamma]^17 + 1349517312*\[Gamma]^18 - 
      3389521920*\[Gamma]^19 - 346030080*\[Gamma]^20 + 753926144*\[Gamma]^21)/
     (\[Gamma]^8*(-1 + \[Gamma]^2)^(7/2))] + 
 functionOdd[(Pi^2*(1 + x^2)^3*
     II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])]}]*
     (2*x*\[Omega]0K3[x] + (-1 + x^2)*Derivative[1][\[Omega]0K3][x])^2)/
    (8*Sqrt[2]*x^2*\[Omega]0K3[x])]*polynomialOdd[
   (2*(-71441023140 - 74590066944*\[Gamma]^2 + 500006049795*\[Gamma]^4 - 
      430621956207*\[Gamma]^6 + 163543923450*\[Gamma]^8 - 
      32928266424*\[Gamma]^10 + 3425665911*\[Gamma]^12 - 
      94322815*\[Gamma]^14 - 18483752*\[Gamma]^16 + 2293470*\[Gamma]^18 - 
      108424*\[Gamma]^20 + 1960*\[Gamma]^22))/(135*\[Gamma]^3*
     (-9 + \[Gamma]^2)^6*(-1 + \[Gamma]^2)^(9/2))] + 
 functionOdd[(Pi^2*(1 + x^2)^2*
     II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])]}]*
     (2*x*\[Omega]0K3[x] + (-1 + x^2)*Derivative[1][\[Omega]0K3][x]))/
    (2*Sqrt[2]*x)]*polynomialOdd[
   (-8*(100010169369 - 1065466942146*\[Gamma]^2 + 289379234907*\[Gamma]^4 + 
      506567453742*\[Gamma]^6 - 401937710301*\[Gamma]^8 + 
      137327274588*\[Gamma]^10 - 27325236891*\[Gamma]^12 + 
      3441459262*\[Gamma]^14 - 279127708*\[Gamma]^16 + 14176194*\[Gamma]^18 - 
      411296*\[Gamma]^20 + 5240*\[Gamma]^22))/
    (135*\[Gamma]*(-9 + \[Gamma]^2)^7*(-1 + \[Gamma]^2)^(9/2))] + 
 functionOdd[Sqrt[2]*Pi^2*(1 + x^2)*
    II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])]}]*\[Omega]0K3[x]]*
  polynomialOdd[(-8*(9051089769 + 290398415544*\[Gamma]^2 + 
      565663163607*\[Gamma]^4 - 809584505478*\[Gamma]^6 + 
      350326745469*\[Gamma]^8 - 66127781742*\[Gamma]^10 + 
      3216222549*\[Gamma]^12 + 942064462*\[Gamma]^14 - 
      199760578*\[Gamma]^16 + 17312214*\[Gamma]^18 - 736976*\[Gamma]^20 + 
      12440*\[Gamma]^22))/(135*\[Gamma]*(-9 + \[Gamma]^2)^7*
     (-1 + \[Gamma]^2)^(9/2))] + 
 functionOdd[II[{kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[-1/4620*(-40425 + 80850*\[Gamma] + 150150*\[Gamma]^2 - 
      200200*\[Gamma]^3 - 475860*\[Gamma]^4 + 1609300*\[Gamma]^5 + 
      1173480*\[Gamma]^6 + 2430120*\[Gamma]^7 + 3245550*\[Gamma]^8 - 
      516940270*\[Gamma]^9 - 119120155*\[Gamma]^10 + 632151520*\[Gamma]^11 - 
      4285820*\[Gamma]^12 + 411909960*\[Gamma]^13 + 78446214*\[Gamma]^14 - 
      684160400*\[Gamma]^15 - 9301952*\[Gamma]^16 + 153119120*\[Gamma]^17 + 
      7212722*\[Gamma]^18 - 10731520*\[Gamma]^20 + 1540096*\[Gamma]^22)/
     (\[Gamma]^9*(-1 + \[Gamma]^2)^(7/2))] + functionOdd[II[{kern[z^(-1)]}]]*
  polynomialOdd[-1/993484800*(19279814400 - 14653900800*\[Gamma] - 
      673613740800*\[Gamma]^2 + 600257996800*\[Gamma]^3 + 
      10805399404800*\[Gamma]^4 - 11021306419200*\[Gamma]^5 - 
      106153073857600*\[Gamma]^6 + 123593400268800*\[Gamma]^7 + 
      719929849531200*\[Gamma]^8 - 1068127862968320*\[Gamma]^9 - 
      3630415455431556*\[Gamma]^10 + 8669694909173760*\[Gamma]^11 + 
      14393129496834872*\[Gamma]^12 - 64925774140846080*\[Gamma]^13 - 
      45854855000657931*\[Gamma]^14 + 386148605334159360*\[Gamma]^15 + 
      105918200011713282*\[Gamma]^16 - 1661595153474600960*\[Gamma]^17 - 
      80759157360852255*\[Gamma]^18 + 4998525520339169280*\[Gamma]^19 - 
      577071516609805596*\[Gamma]^20 - 10356013731516006400*\[Gamma]^21 + 
      2730043862192898384*\[Gamma]^22 + 14588736110557593600*\[Gamma]^23 - 
      5632361918979826880*\[Gamma]^24 - 13735205121243217920*\[Gamma]^25 + 
      5609594666286465792*\[Gamma]^26 + 8239368118641623040*\[Gamma]^27 - 
      1404070510469207040*\[Gamma]^28 - 2574185016066048000*\[Gamma]^29 - 
      1796820672899747840*\[Gamma]^30 + 111937190300221440*\[Gamma]^31 + 
      1409315793216847872*\[Gamma]^32 + 115604087667425280*\[Gamma]^33 - 
      315481514148102144*\[Gamma]^34 - 8413325536788480*\[Gamma]^35 + 
      19395385113968640*\[Gamma]^36)/(\[Gamma]^9*(-1 + \[Gamma]^2)^(9/2)*
      (-1 + 4*\[Gamma]^2)^7)];


thetaC[5, 2, mem] = functionEven[II[{kern[z^(-1)], kern[(1 - z^2)/(z - z^2 + z^3)], 
      kern[z^(-1)]}] - II[{kern[z^(-1)], kern[(1 - z^2)/(z + z^2 + z^3)], 
      kern[z^(-1)]}]]*polynomialEven[(81*\[Gamma]*(-3 + 2*\[Gamma]^2)*
     (-1 + 5*\[Gamma]^2)^2)/(8*(-1 + \[Gamma]^2)^3)] + 
 functionEven[II[{kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[(\[Gamma]^2*(-3123 + 10401*\[Gamma]^2 - 2351*\[Gamma]^4 - 
      3705*\[Gamma]^6 + 1050*\[Gamma]^8))/(-1 + \[Gamma]^2)^4] + 
 functionEven[II[{kern[z^(-1)], kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]]*
  polynomialEven[(\[Gamma]^2*(-23859 + 4257*\[Gamma]^2 + 10961*\[Gamma]^4 - 
      3705*\[Gamma]^6 + 1050*\[Gamma]^8))/(-1 + \[Gamma]^2)^4] + 
 functionEven[II[{kern[z^(-1)], kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)]}]]*
  polynomialEven[(3*\[Gamma]*(-18 + 1041*\[Gamma] + 210*\[Gamma]^2 + 
      6005*\[Gamma]^3 - 762*\[Gamma]^4 - 7835*\[Gamma]^5 + 870*\[Gamma]^6 + 
      1235*\[Gamma]^7 - 300*\[Gamma]^8 + 674*\[Gamma]^9))/
    (2*(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[z^(-1)], kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)]}]]*
  polynomialEven[(3*\[Gamma]*(18 + 1041*\[Gamma] - 210*\[Gamma]^2 + 
      6005*\[Gamma]^3 + 762*\[Gamma]^4 - 7835*\[Gamma]^5 - 870*\[Gamma]^6 + 
      1235*\[Gamma]^7 + 300*\[Gamma]^8 + 674*\[Gamma]^9))/
    (2*(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[(-3*\[Gamma]*(-18 + 2415*\[Gamma] + 210*\[Gamma]^2 + 
      10123*\[Gamma]^3 - 762*\[Gamma]^4 - 11365*\[Gamma]^5 + 870*\[Gamma]^6 - 
      1235*\[Gamma]^7 - 300*\[Gamma]^8 + 2398*\[Gamma]^9))/
    (2*(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[(-3*\[Gamma]*(18 + 2415*\[Gamma] - 210*\[Gamma]^2 + 
      10123*\[Gamma]^3 + 762*\[Gamma]^4 - 11365*\[Gamma]^5 - 870*\[Gamma]^6 - 
      1235*\[Gamma]^7 + 300*\[Gamma]^8 + 2398*\[Gamma]^9))/
    (2*(-1 + \[Gamma]^2)^4)] + 
 functionEven[
   ((1 + x^2)*II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
       kern[((1 + z^2)*\[Omega]0K3[z])/z]}]*(2*x*\[Omega]0K3[x] + 
      (-1 + x^2)*Derivative[1][\[Omega]0K3][x]))/(4*x*\[Omega]0K3[x])]*
  polynomialEven[(64*(-71441023140 - 74590066944*\[Gamma]^2 + 
      500006049795*\[Gamma]^4 - 430621956207*\[Gamma]^6 + 
      163543923450*\[Gamma]^8 - 32928266424*\[Gamma]^10 + 
      3425665911*\[Gamma]^12 - 94322815*\[Gamma]^14 - 18483752*\[Gamma]^16 + 
      2293470*\[Gamma]^18 - 108424*\[Gamma]^20 + 1960*\[Gamma]^22))/
    (135*\[Gamma]*(9 - \[Gamma]^2)^(13/2)*(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
     kern[((1 + z^2)*\[Omega]0K3[z])/z]}]]*
  polynomialEven[(128*\[Gamma]*(100010169369 - 1065466942146*\[Gamma]^2 + 
      289379234907*\[Gamma]^4 + 506567453742*\[Gamma]^6 - 
      401937710301*\[Gamma]^8 + 137327274588*\[Gamma]^10 - 
      27325236891*\[Gamma]^12 + 3441459262*\[Gamma]^14 - 
      279127708*\[Gamma]^16 + 14176194*\[Gamma]^18 - 411296*\[Gamma]^20 + 
      5240*\[Gamma]^22))/(135*(9 - \[Gamma]^2)^(15/2)*(-1 + \[Gamma]^2)^4)] + 
 functionEven[II[{kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialEven[-1/27720*(363825 - 2217600*\[Gamma]^2 + 9216900*\[Gamma]^4 - 
      29674260*\[Gamma]^6 - 32942106*\[Gamma]^8 - 4421304555*\[Gamma]^10 + 
      9979200*cM*\[Gamma]^10 + 1745281258*\[Gamma]^12 - 
      73180800*cM*\[Gamma]^12 + 3870076858*\[Gamma]^14 + 
      204019200*cM*\[Gamma]^14 - 1491177992*\[Gamma]^16 - 
      266112000*cM*\[Gamma]^16 - 1003385208*\[Gamma]^18 + 
      159667200*cM*\[Gamma]^18 + 777222144*\[Gamma]^20 - 
      35481600*cM*\[Gamma]^20 - 336396288*\[Gamma]^22 + 64487424*\[Gamma]^24)/
     (\[Gamma]^8*(-1 + \[Gamma]^2)^5)] + 
 functionEven[1]*polynomialEven[-1/1629936000*
    (-9230601651925500 + 287390827319904000*\[Gamma]^2 - 
      4042897251818040000*\[Gamma]^4 + 34175529509874984000*\[Gamma]^6 - 
      192998018743295828409*\[Gamma]^8 + 123194996305920000*cM*\[Gamma]^8 + 
      734832211800575035296*\[Gamma]^10 - 3931973632097280000*cM*
       \[Gamma]^10 - 1628724092027234935707*\[Gamma]^12 + 
      56042530255293120000*cM*\[Gamma]^12 + 608480765471073649776*
       \[Gamma]^14 - 470333073197433600000*cM*\[Gamma]^14 + 
      3486066506324208237666*\[Gamma]^16 + 2580488764140006720000*cM*
       \[Gamma]^16 + 30461328485090180762472*\[Gamma]^18 - 
      9718965849532705920000*cM*\[Gamma]^18 - 258779478203685372811918*
       \[Gamma]^20 + 25687151314714021440000*cM*\[Gamma]^20 + 
      825141692510301652508904*\[Gamma]^22 - 47906077751528156160000*cM*
       \[Gamma]^22 - 1430962238326759128075053*\[Gamma]^24 + 
      62637602781220420800000*cM*\[Gamma]^24 + 1485427436367300051229592*
       \[Gamma]^26 - 56519580547140332160000*cM*\[Gamma]^26 - 
      1031543015353775175181319*\[Gamma]^28 + 34443128618531001600000*cM*
       \[Gamma]^28 + 553939640418664485757896*\[Gamma]^30 - 
      13879005893108590080000*cM*\[Gamma]^30 - 244841539697650769118096*
       \[Gamma]^32 + 3645399671051550720000*cM*\[Gamma]^32 + 
      83965419199354388234496*\[Gamma]^34 - 622062957366681600000*cM*
       \[Gamma]^34 - 20466322784587820730624*\[Gamma]^36 + 
      68262142970757120000*cM*\[Gamma]^36 + 3369914247592255129600*
       \[Gamma]^38 - 4646343488962560000*cM*\[Gamma]^38 - 
      363013494668341309440*\[Gamma]^40 + 178625917747200000*cM*\[Gamma]^40 + 
      24450222993449811968*\[Gamma]^42 - 2967207936000000*cM*\[Gamma]^42 - 
      933864261917081600*\[Gamma]^44 + 15445306376192000*\[Gamma]^46)/
     (\[Gamma]^8*(-1 + \[Gamma]^2)^4*(9 - 37*\[Gamma]^2 + 4*\[Gamma]^4)^6)] + 
 functionOdd[II[{kern[(-1 + z^2)/(z + z^3)], kern[(1 - z^2)/(z - z^2 + z^3)], 
      kern[z^(-1)]}] + II[{kern[(-1 + z^2)/(z + z^3)], 
      kern[(1 - z^2)/(z + z^2 + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(90*\[Gamma]*(-37 - 30*\[Gamma]^2 + 15*\[Gamma]^4))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[(1 + z)/((-1 + z)*z)], kern[(1 - z^2)/(z - z^2 + z^3)], 
     kern[z^(-1)]}]]*polynomialOdd[
   (9*(-9 - 56*\[Gamma] + 99*\[Gamma]^2 + 1200*\[Gamma]^3 - 315*\[Gamma]^4 - 
      600*\[Gamma]^5 + 225*\[Gamma]^6))/(4*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[(1 - z^2)/(z + z^2 + z^3)], 
     kern[z^(-1)]}]]*polynomialOdd[
   (-9*(-9 + 56*\[Gamma] + 99*\[Gamma]^2 - 1200*\[Gamma]^3 - 315*\[Gamma]^4 + 
      600*\[Gamma]^5 + 225*\[Gamma]^6))/(4*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[(-1 + z^2)/(z + z^3)], kern[(-1 + z^2)/(z + z^3)], 
     kern[z^(-1)]}]]*polynomialOdd[
   (-2*\[Gamma]*(3261 - 973*\[Gamma]^2 - 1965*\[Gamma]^4 + 525*\[Gamma]^6))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[(1 + z)/((-1 + z)*z)], 
      kern[z^(-1)]}] - 2*II[{kern[(-1 + z)/(z*(1 + z))], 
       kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(-3*(31 - 65*\[Gamma] - 353*\[Gamma]^2 + 785*\[Gamma]^3 + 
      125*\[Gamma]^4 - 655*\[Gamma]^5 - 75*\[Gamma]^6 + 175*\[Gamma]^7))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[(1 + z)/((-1 + z)*z)], kern[(-1 + z)/(z*(1 + z))], 
      kern[z^(-1)]}] - 2*II[{kern[(1 + z)/((-1 + z)*z)], 
       kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(-3*(-31 - 65*\[Gamma] + 353*\[Gamma]^2 + 785*\[Gamma]^3 - 
      125*\[Gamma]^4 - 655*\[Gamma]^5 + 75*\[Gamma]^6 + 175*\[Gamma]^7))/
    (-1 + \[Gamma]^2)^(5/2)] + 
 functionOdd[II[{kern[z^(-1)], kern[z^(-1)], kern[z^(-1)]}]]*
  polynomialOdd[(-128*\[Gamma]*(-59 - 945*\[Gamma]^2 + 39*\[Gamma]^4 + 
      1415*\[Gamma]^6 - 666*\[Gamma]^8 - 72*\[Gamma]^10 + 48*\[Gamma]^12))/
    (-1 + \[Gamma]^2)^(11/2)] + 
 functionOdd[II[{kern[(-1 + z)/(z*(1 + z))], kern[z^(-1)]}]]*
  polynomialOdd[-1/98560*(-16393337 - 153926080*\[Gamma] - 
      526687872*\[Gamma]^2 - 1451838080*\[Gamma]^3 + 527476862*\[Gamma]^4 + 
      2130847488*\[Gamma]^5 + 242186472*\[Gamma]^6 - 986992512*\[Gamma]^7 - 
      226582125*\[Gamma]^8 + 705797312*\[Gamma]^9 - 540540928*\[Gamma]^11 + 
      131072000*\[Gamma]^13)/(-1 + \[Gamma]^2)^(7/2)] + 
 functionOdd[II[{kern[(1 + z)/((-1 + z)*z)], kern[z^(-1)]}]]*
  polynomialOdd[-1/98560*(16393337 - 153926080*\[Gamma] + 
      526687872*\[Gamma]^2 - 1451838080*\[Gamma]^3 - 527476862*\[Gamma]^4 + 
      2130847488*\[Gamma]^5 - 242186472*\[Gamma]^6 - 986992512*\[Gamma]^7 + 
      226582125*\[Gamma]^8 + 705797312*\[Gamma]^9 - 540540928*\[Gamma]^11 + 
      131072000*\[Gamma]^13)/(-1 + \[Gamma]^2)^(7/2)] + 
 functionOdd[II[{kern[(1 - z^2)/(z - z^2 + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[-1/280*(-3150 + 15120*\[Gamma]^2 - 54810*\[Gamma]^4 + 
      204120*\[Gamma]^6 + 575161*\[Gamma]^7 - 2776550*\[Gamma]^8 + 
      4328730*\[Gamma]^9 - 1783320*\[Gamma]^10 - 168595*\[Gamma]^11 - 
      98742*\[Gamma]^12 + 409600*\[Gamma]^14)/
     (\[Gamma]^7*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[II[{kern[(1 - z^2)/(z + z^2 + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[-1/280*(-3150 + 15120*\[Gamma]^2 - 54810*\[Gamma]^4 + 
      204120*\[Gamma]^6 - 575161*\[Gamma]^7 - 2776550*\[Gamma]^8 - 
      4328730*\[Gamma]^9 - 1783320*\[Gamma]^10 + 168595*\[Gamma]^11 - 
      98742*\[Gamma]^12 + 409600*\[Gamma]^14)/
     (\[Gamma]^7*(-1 + \[Gamma]^2)^(5/2))] + 
 functionOdd[
   ((1 + x^2)^3*II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
       kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
       kern[((1 + z^2)*\[Omega]0K3[z])/z]}]*
     (2*x*\[Omega]0K3[x] + (-1 + x^2)*Derivative[1][\[Omega]0K3][x])^2)/
    (16*x^2*\[Omega]0K3[x])]*polynomialOdd[
   (-32*(-71441023140 - 74590066944*\[Gamma]^2 + 500006049795*\[Gamma]^4 - 
      430621956207*\[Gamma]^6 + 163543923450*\[Gamma]^8 - 
      32928266424*\[Gamma]^10 + 3425665911*\[Gamma]^12 - 
      94322815*\[Gamma]^14 - 18483752*\[Gamma]^16 + 2293470*\[Gamma]^18 - 
      108424*\[Gamma]^20 + 1960*\[Gamma]^22))/(135*\[Gamma]^3*
     (-9 + \[Gamma]^2)^6*(-1 + \[Gamma]^2)^(9/2))] + 
 functionOdd[II[{kern[((1 + z^2)*\[Omega]0K3[z])/z]}]/
    ((1 + x^2)*\[Omega]0K3[x])]*polynomialOdd[
   (64*\[Gamma]*(-71441023140 - 74590066944*\[Gamma]^2 + 
      500006049795*\[Gamma]^4 - 430621956207*\[Gamma]^6 + 
      163543923450*\[Gamma]^8 - 32928266424*\[Gamma]^10 + 
      3425665911*\[Gamma]^12 - 94322815*\[Gamma]^14 - 18483752*\[Gamma]^16 + 
      2293470*\[Gamma]^18 - 108424*\[Gamma]^20 + 1960*\[Gamma]^22))/
    (135*(-9 + \[Gamma]^2)^7*(-1 + \[Gamma]^2)^(7/2))] + 
 functionOdd[
   ((1 + x^2)^2*II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
       kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
       kern[((1 + z^2)*\[Omega]0K3[z])/z]}]*(2*x*\[Omega]0K3[x] + 
      (-1 + x^2)*Derivative[1][\[Omega]0K3][x]))/(4*x)]*
  polynomialOdd[(128*(100010169369 - 1065466942146*\[Gamma]^2 + 
      289379234907*\[Gamma]^4 + 506567453742*\[Gamma]^6 - 
      401937710301*\[Gamma]^8 + 137327274588*\[Gamma]^10 - 
      27325236891*\[Gamma]^12 + 3441459262*\[Gamma]^14 - 
      279127708*\[Gamma]^16 + 14176194*\[Gamma]^18 - 411296*\[Gamma]^20 + 
      5240*\[Gamma]^22))/(135*\[Gamma]*(-9 + \[Gamma]^2)^7*
     (-1 + \[Gamma]^2)^(9/2))] + 
 functionOdd[(1 + x^2)*
    II[{kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
      kern[1/(z*Sqrt[-1 + 34*z^2 - z^4]*\[Omega]0K3[z])], 
      kern[((1 + z^2)*\[Omega]0K3[z])/z]}]*\[Omega]0K3[x]]*
  polynomialOdd[(128*(9051089769 + 290398415544*\[Gamma]^2 + 
      565663163607*\[Gamma]^4 - 809584505478*\[Gamma]^6 + 
      350326745469*\[Gamma]^8 - 66127781742*\[Gamma]^10 + 
      3216222549*\[Gamma]^12 + 942064462*\[Gamma]^14 - 
      199760578*\[Gamma]^16 + 17312214*\[Gamma]^18 - 736976*\[Gamma]^20 + 
      12440*\[Gamma]^22))/(135*\[Gamma]*(-9 + \[Gamma]^2)^7*
     (-1 + \[Gamma]^2)^(9/2))] + 
 functionOdd[II[{kern[(-1 + z^2)/(z + z^3)], kern[z^(-1)]}]]*
  polynomialOdd[(-40425 + 150150*\[Gamma]^2 - 475860*\[Gamma]^4 + 
     1173480*\[Gamma]^6 + 3245550*\[Gamma]^8 - 119120155*\[Gamma]^10 - 
     4285820*\[Gamma]^12 + 78446214*\[Gamma]^14 - 9301952*\[Gamma]^16 + 
     7212722*\[Gamma]^18 - 10731520*\[Gamma]^20 + 1540096*\[Gamma]^22)/
    (4620*\[Gamma]^9*(-1 + \[Gamma]^2)^(7/2))] + 
 functionOdd[II[{kern[z^(-1)]}]]*polynomialOdd[
   -1/46569600*(-903741300 + 31117224600*\[Gamma]^2 - 
      489112262100*\[Gamma]^4 + 4676127594600*\[Gamma]^6 - 
      30615492461400*\[Gamma]^8 + 149070313750417*\[Gamma]^10 - 
      14902272000*cM*\[Gamma]^10 - 597564906967434*\[Gamma]^12 + 
      525926016000*cM*\[Gamma]^12 + 2193236823731196*\[Gamma]^14 - 
      8350239744000*cM*\[Gamma]^14 - 7092472586403002*\[Gamma]^16 + 
      78693931008000*cM*\[Gamma]^16 + 15234066565852827*\[Gamma]^18 - 
      488983283712000*cM*\[Gamma]^18 - 3404245321632372*\[Gamma]^20 + 
      2103892826112000*cM*\[Gamma]^20 - 91201529648163984*\[Gamma]^22 - 
      6402771099648000*cM*\[Gamma]^22 + 275806181597870016*\[Gamma]^24 + 
      13822473240576000*cM*\[Gamma]^24 - 363061726497722112*\[Gamma]^26 - 
      20887660265472000*cM*\[Gamma]^26 + 208035715525747712*\[Gamma]^28 + 
      21391873671168000*cM*\[Gamma]^28 - 27602212047826944*\[Gamma]^30 - 
      13967919415296000*cM*\[Gamma]^30 - 10839249804902400*\[Gamma]^32 + 
      5168028450816000*cM*\[Gamma]^32 + 275891250790400*\[Gamma]^34 - 
      813862748160000*cM*\[Gamma]^34 + 570930002657280*\[Gamma]^36)/
     (\[Gamma]^9*(-1 + \[Gamma]^2)^(9/2)*(-1 + 4*\[Gamma]^2)^7)];


(* ::Subsection::Closed:: *)
(*Post-Newtonian expansion of the 5PM-2SF scattering angle*)


thetaCPN[5, 2] = (-11456*mem)/135 + (64*cM*mem)/5 + (46629199*tailpot)/15120 - 
 (221597*Pi^2*tailpot)/720 + (2*tailpot)/(5*v^6) + (53*tailpot)/(5*v^4) - 
 ((-45341 + 1230*Pi^2)*tailpot)/(360*v^2) + 
 ((15126546217728868669751648887733814789660462364635480463660892488107496041\
29295742589385449832018104141509075044608857930500122370859398805268393817790\
65206267720911132573534840375354891241156129743734217536975708704436030671143\
28594209737087807102593384542571182657884003406213833954757091144108812673314\
1720683439674933579366991048678923*mem)/1171167311549878337493563806933370410\
54113018896727566000417533732216088420720142443441950917438492420395627160818\
77144098139205232305785276110928141991800226434226518196719232289495653354122\
13674974804930177016305189556952896585603305493977826167972690008646316065105\
25774397261933720925585370873709436333122380484264123205796967280000 + 
   (3983370586512325613884168588201147590119842516702505402693169914974384733\
61179830593300359833861465398149174805484820770334203848063142254173316352233\
11182683454764684347971701479569106282283194574262523697514216902678541744055\
70002535740275351974461224461160525104293390992775460824939417238041825153694\
93244656789474791074536186581899562964256026562947485326660627660335025137265\
30510561656418207392944980258934486945079550836797558925717869814152485292964\
43368504423715332203152144478290268558550563223390163811755026386870192087303\
18296498694284329934991529956602826030940702925261557056088157320052981170993\
45091885239826109177723935277811420040025074994202477696905956887961802106383\
465484709935042135557595567083567562718049728075901774407*tailpot)/3278947168\
72620604357244196928286399964926382831630973356929459028566730002755391128594\
75497951570321183424825937447825013951256404403950104196319951469897981330622\
05020279225224896592568488325333461709263742179223970889697450165826125345070\
20348620518370960951420691367054139378268891882628167224584044406668092951632\
50520453109240208828459328967235590212086483313187109393614772911819159166794\
48382140661981139828778536566882684851105843388922430172918320166225194169603\
44001343759415602411595390453558376991538774039216074028802899850916298518985\
48372836168865322269330529626068569022460798878456218137839104595310642800931\
39376951306641775352638988591266364277038063335885012456640931626891916709373\
98205852999014035281378122137600000)*v^531 + 
 ((25930941876075238924473203764157021019780019786125799786931426790308173178\
37860409884015676954664302802313267489259199964700280113418098186201851278456\
90547837519687880934859367628820987768924845155568122327346880170436310349454\
22909533039001520060001416918385336313404184531259515550878644344935857668182\
58844612586601524745705059146898197975864034638971586801999657333849554440444\
33059156144790285423291774521542848751909594491448794417910533598834498159572\
80189394735510828417275384470088047203809848707477311165457211461677826232343\
53361839567705718038343493993629982553357010712940842194047464120683767393920\
30134668941777040867107306041094860715544949524149451967827184092848929900817\
14993235300825725485899314876843835215424778518042751951121904224*mem + 
    1015966959390718686557455632422323950511428345292162409482951458569078900\
80925007456543655341418306597066690325900348488741926166364635192180502893279\
96616404000110762338738595674027961693058979949440179817016775704922572488061\
00934617563602965814932067664491418337470490261039464795622523123181225079389\
81012227289134778666151164090696806074953666205565588542089050290049364892251\
10153955435313951817085243904239652981497109883571670377063648863847951768078\
23076558567619869788101139815796212636710680293066531034917683060759708873113\
35804166115466289947072004265601358482235090693231178421347561619699590227597\
09289136349876525089116881824322390288828571325496682960915844107970819234765\
0983997345252550647058924883599001682190040957813523217433898400*cM*mem + 
    1505028251846710129612631131402395129729548942155802953988921758793177074\
13028138069633510459750587543921833504111297628043527562358417632849735746730\
12546135096346927407234287076742798098598165406423479269277749508245081398783\
31763262300896936442714487067533981545430306927111765761792290364840019591585\
24163882451829249032828045471581615612537614864727168365864804048377189209971\
09469060709818515370929162170934542140617627323545651781122591457163703264040\
11631093225518717799031578741761035306026219473776181477030829610013817941612\
25495098855208620779893406134754931091660052152754795846153654076908817544722\
75864211542219688014442835164617220354635581540966789091744798840330316692142\
16863530111357357175800533561863937158637005228958421360901407190323*tailpot)*
   v^533)/5017681041780988774709687917218426858471278257085255928608551571265\
62867054776497893136952892013454185380018752369501580797492170404800415338487\
10924775743723686773666007927305433529585029657665846871167584452720854243813\
19096460159076484051270429242178885671570524442196446719746622937190131707150\
98674802280795937280577004348203832328443441142573495411050300069926374642659\
85665773315328336488928346351550912028080645887092766999124714411744531050655\
72063637409760332307395356243174084327335969013401476846755960228265392600362\
04271160661385967244954155967498018744397329682319432012551391316213329538422\
27322267275207980266885806460299173228524335703495343617949515912571314297820\
4883172254714716668714227267080507205798105061719749427200000 + 
 (2816*tailpot*Log[2])/45 + (2816*tailpot*Log[v])/45 + 
 (v^550*((2879356355342216943901100663803780052064295577086713588145019695819\
16505144725861230035461059070753681985183153656798474702306677123883103873950\
84913595739145314813249839023105195052291443036159002147433496481870564636111\
73927522327283036904145890176162481142542736536728591885774560183270797263864\
53028716591095338861059871993871191041982730930128579825493223296782713289986\
61237013207601662634904150064253313039945794361436249226872574826015974797269\
77741226865518903551881834436649885840832411525614394428624893428683566293525\
54729349327581550988046753005092948353955601405336290737430836271479882067985\
19301246650069654283389812967373381592394242377505040411791500812651507615142\
63305883251162422265025005226182569700431003010848703672689498165682730474843\
68371301079894776411934241111278676382990263781789749642223345459446171520015\
24277794067514540549695627730910971767885055383875547935166442114809135066747\
96695679161115937722900590812521209843435020629537638991146046910567059641808\
78777409807522030977082161579851764947072773094143685564755183342370811830896\
97687878464390662822687016701542168025515485903278299713929648186213742920684\
26521667979708419513382370167453092215277677605255146345182277937760949472874\
06231338522432049337379652748448883323986201256419704416009179475645965874353\
24046488195051259730343789711578536342842174294792003947665336961962570433956\
74374137836755526963418302605633080629239068642315702408791368042437937711640\
939837259592905001777504*mem)/3 + 
    50222731*(-74478495379700172137010824779095812708751262603159960746473026\
90132636103924790135020089506221994437608232218039024999457519187955752214627\
42008424377068340194419793282665110400873835273653377494202894527017361347034\
59469402908316562422494590538819522544796708252043531730427659719394447174182\
19896713219567578726173223903429947354774579576832896625442690635491818406638\
39850906104908360810227027531989292374345241801987487766112262662861529153272\
52023786035282557566281906606500276572901181996090187357975485463254209387652\
46624662143960133376267965080736940786643949637645204122804350821990425712420\
59202433851616081143944420755332879279608175763949759816643205996483259189279\
99622958084927336309047731002976992286442438686219651843072958069921665574607\
20362041032976368835742329512592699184451810748304478258144877631961605348255\
22817636874400955583203186862997870174867580132101522795778317150610678509592\
42462442394561253103206322814532453568844211814626653475141205250627662509781\
66522407399651144620737918097048611801980731359193423014385615300685337830978\
10957395758452356942812998225595949644141498361290922035487985875789434267036\
19629821561530188094352702636408955479710365983197737870148659721532966896435\
84786478030657278956981129586707582339996881946735528096071135115451416768302\
43879342287461544010665894095906010086118062170050024446236175280495087844248\
2900866503320660982900847102428087964653968811035156250000000*cM*mem - 
      62218089562921614300527493165380427043946399195603120747874605963521290\
32821546360215476722517672396903277757904247747190274542642699351138754096877\
33929418378214881181488247549746837370260229685927981906200917933830979716611\
10169964440706970240449025797520369591081140851764854991331237796805840691104\
78292437732150163966626178910105119720733471105328468600621264818011104258459\
66428851900082501500776081451921436505434817099122018915194889460559918968463\
01617754738104695418388517108558192522728647877020795558760953059547931421942\
05836470752579464830436109458254597977044892006509394091466295621259311695782\
16357129658147485803150314734247634876158394854556323395028674266665324909546\
75807348827139480528760117113553197600636297465735357935225708882047447210084\
74475012842161565293512914012023549266304193494231792069058724289183892574057\
35904935124610037034365533675825175753612485136220583282268293764990640504346\
36978636833043320884218702291610837650336309169902618236264958793441905110483\
81083515215329844356382280173494468815029259618261097796363784205972073811966\
22140344885847097433854281117529375200562867312089430061012737280505519202247\
51873320650738691816486401616541315938589995630792541464373279762227092559891\
83113884988741847521592992005520203400880085873563640659556149356625108600617\
42735927493813886516534006057569883308558702964652586168095316790477296536629\
73066969090990919202443426056327708392921767628577655069736312385295032036159\
220233*Pi^2*tailpot - 6148660298668241374463581459731371036025783844534103921\
00395484806269102389180911198626735291795697878470575684990794440243425776178\
94761096802885818658296043843510077879533513681427341542392985766521641823616\
81919071107816875649476361144428449533039238161791217862628400325775146484375\
000*tailpot*(-177079381895077506585453630946161212207644070416507393938072304\
29683576758414399068917040636353133756030891512833005407713677947106584977834\
98701445130134352968458168585510485729284461204748022451913234404130136178759\
65569483513764539380682759593580593562473009063645056341955281088690493905109\
27311320929066414020845318351099631545802369177576149136098107040086890156116\
32038316608250461731361306410089559937768286835549792069600674156069001926827\
37276206781188953435817037656045567460783897640171719063072787677934308692568\
99531405436290035173345022380394536764618834378084540632782305769386648342504\
18460724649819741313108138672686176003102068048736012088523963262486980906629\
97748180085054923754091481255217564222291940103463348072941781877335710200889\
85608009289038232820771472707572812284940285311554867785346651416635691493778\
95214899657972433202276074667947301834030607219601971553165650588160778170129\
62698897082600098343416100086351993377444788314453878173607794632724560263778\
99277537578142104128472558457591094903055337069400933776121524990770853490972\
74639073097371822199361390148361197419827143603471043513781375951092738846698\
57369 + 534080504948560534912797035989607337657650716208442434941929011424893\
88395952736691358360237229587778481897015028642020211122061070842112119501488\
27216196124198386719785732729447186055369013279369125329137336909603636163011\
12127931708912055156488852084469714222270237324481611260361989314591694069337\
18685288815094604563950832593208663674219905340787884011721680385146129681905\
20200288798539372819689149823934689876748436217743744092045410383403283962928\
82916187883185488550297260822842669966148829249073266662076390333567989896466\
99229313010938317239850643188282084972009713413942090849049386042867960591942\
13748448970117190964542805201796202866017789568388300504834534580456958171685\
42060047772107619095222877774636995345036773873063373089539742472884355676386\
37415819319830925400033627941065694480946302807387869066247934035831955670496\
72086554320687450419377552176055963552474782307649473597648586744169609342479\
87104884652361626120839692144447918215866781565509806068244214246304247894831\
31882508361202302138524695192855570444834855455515470646757992628511494120418\
21113324981483822235123842628121036090100639739320999442403823543175526400*
         Log[2])) - 267301790319065894017111230127660977156843379900538092774\
77881189034952114427451088399121738226800857138041535527642273276394072803942\
18099079510164083631250932284977636662406247765947958016784434388523545749661\
00399770639813725240094913381440632897578755949981507622008881555468598189339\
97634623555982171141467847886079674639459477131676317153161918544023893880488\
86240597485722263376161310886315823465261737424336904544900488512630974111091\
09266191108063842058542752048328493357742893527906699804830850945225623893031\
74117316879872228013206468491560045597397905423461798813744375560246144430516\
94609790252077141380172958928232168733287511222276879090678075619141740895153\
17304884209754078888029470714655855361602469033713837885964375723285353277364\
73306136536082718098102300911579393599434541725202687942486049966921276815171\
85934588335198231696029633247762914010714605206723542096313702057917405616634\
73520105864321567133904664420300023686628638132621407518095723135993193906769\
08550582930777447665070962254708277751831679597346085574657691146184788424263\
56000669397259807941798976416945074035273355066527199486167443216512402308098\
73549243814170901308995674453488109920273335961205737929094686151456122840406\
78218688314683139522191262171272392318940833051237836157451211435765724854694\
25464677101504825320528305455590636650392877096385585872896000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000*tailpot*
     Log[v]))/296954553202526366002517249302285529092883943957509036866822135\
28150183497094064707721513234066315788382723302872821684314782846669617755340\
96836077109835994845289373446339929301884972736963658611814558399870201128546\
29733960650857016779460166293788378460058812916294386689858675718316222085828\
23799178994034211861900073511836426234369687533707612040749515751770850021338\
24386936131737484174986533640953542343965650898207047474507023363687890566911\
92882247196583718916834870127809241209038901296152284648582365571595855365476\
53686995040171941374527820928420804920879471523159859218826978042790765558157\
32901030820255934710058583569348924371349437337632178248574304443852879229361\
37560769739182441166887452249986203180077694666925749146686554035311769208954\
45113828193473540513687162976095801026110897762816053317710332342078605060493\
69680412994010668203122938613415897825641710141052610223177307870910771120575\
28940535878729091386820036239929752936408533431677856616819712815921746098228\
02276315523023485378954634845175487490929683946466118177754582968638681796509\
07604169896318571288176034957073552858806881215393451945114434909886299641980\
22296849379783886594987026076568276444292262662734999492369892554369346650827\
62242498090810608774646792123924657258022054122626307511474834502917395585370\
18164075708599500800000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000 + 
 (v^548*((2626337374255553741333695542695455448427732912576581551863877823338\
96321513162847750835501492794400681848001947536461605441120848771861669600558\
92434172675539723753542273500904572113960705935731873852992753437510163928155\
63513125180947620992797091759154865639432618249130003366131166449425864542359\
09706524522114438802377923229381244807321975429266334626306201762072505306861\
35199163447539190356012280913477488859962146470080396152577139680074783690126\
22341847939633798094521046640204746463730380597326850125561835731129228182714\
46735988570679286916663211343470434839861672610849287860754559790240454936686\
65935060076989955982918946453638558971166217320195582666511838915120696659554\
62910860559268513840300515816356408833792201839251832062594536768868348929316\
43305532240658212756702141101099579725283096865488765530651463155470501896693\
89656014604928902124560942331825879214923215583626542421363449360299952824310\
16679092624620783627937647225722861121074760412299069752208035067672891383345\
03079217828089399612709611676616501799843688740885775695063039498482971581143\
80341879741116616180821626602696514054536234537648167580985798899935729616393\
44399063830404299596957058409030827102647534253755028961559163647422823854684\
20086624206172810565980715321422715482617465931027853430792812537490199384595\
57854952837295121460441112692207757155219652149518008069229446109236869239706\
35269266130751352805180408473479407357892426092363759805614742572482990610011\
7781308392730741568*mem)/3 + 102694241*
     (-5161669706159423279272373390986713728472614490730615631817177441762671\
23603092962055717812691408315863108148708504630047479069821851906460184175981\
74457787667610457557504211929740737476481931081036700596674162099196128957070\
67253808534638147808872453151221513948786449122032188067025481040771905312134\
48440054589259279093468008381121116640745828615818897784425099358183532053928\
01510488198110269169253126297368176940468539544093762232968209706233577973278\
98090798833792370005280262473431559644912419677960424371964419834209327515174\
39528172652339324541080830250348209350805583672407516302017565257120694173801\
03732505874832268011053175834828583246008624835479649797982855190701369250240\
20752904371391630374253911067195619183978906774969054130268552602862716997852\
26151006984052520979315091814041159311712617270492724312424137697850468857918\
11004200632028949690513180444857433143868425630371430471410602328451372702029\
90743317975136248782769190857088804737002732064320592989551762639370438062376\
39627685627281867641785778097486438826162857182522165692870029413550875961702\
95320139885842363201409879106477702618834796069380351353598538976352019051599\
77500747809625317054330963158513349536145460686113032644597617730744907080219\
77538167855248333435598354102033748655384570710127271729769899078148078171412\
68810714815725301412406167308138953629756736365677869211703415721789430566784\
906417865386174526065587997436523437500000000000*cM*mem - 
      18537803316978550463600033332344385480859801393501556406728922445214842\
11805771662693272952684970635473955552257079509970345529097638326165886013996\
03294947377153998816367232028103989333588784804895829043436224766604192330762\
28203320038393009098233950438490114204035715294985490029043117694962783288574\
85562703940384345019493806213695990140260601167904433064490114641632444826509\
38762385093345901622156034487473144591843042129952881919257952619579392262369\
70689824376086944798992884906584774113821133308108099491750220788958327168605\
67334138348744721932590393241598063490537580015932040037199607841427862580726\
58032497235938405165901996849561362218371651724287145811565226841251141524439\
05392850324511413694241370498411819811804311790521683986400507948837057259263\
77658451351880534713655474409871874802900937657791346907062370788013659407617\
22781160870654063647978315874671848495009822989105876702738622995995362942136\
35257611616919965312289408906896649100811446749047512609696028690261412334540\
41792735124574985174098728567777070928045541357221611799325836603327445930461\
40076487123468720280274519537032755050842313207732749581823991942088500054909\
77237348961294671514641898546435041741506823266184801426302395454773856211061\
11306023210807039290611629026806450227151146943225568189430704117627456750374\
17504346157915479116539094600101288225712961174162432369672447431627949956791\
77384093915742555728055385215755041474306670210505066673264613954511724098670\
1*Pi^2*tailpot - 113999485537470637375189645442587041370640208577037710535370\
62231813529844296705542763728119193833749854886889727126621243432164390777244\
89524507558691880840164233727389874594334742139359407610492860374224081111836\
88723782766937717318479596700442693646415648345282534137368202209472656250000*
       tailpot*(-550932542403197824502268134156288701105548295949442455657198\
39055988919670124801380942563701197021265939658290653365816851364591226138252\
60637829841677544664221213971405804131208638252688466545130290973426794587916\
73042040315532549336719013365590845662550225551545448095361555874050533980790\
71268904071186839501107102551018590021548033923909740416138445699004517783088\
57199463636203498706632293911649745800477544882061412570963645845469310842673\
34295047443609004890191018823889857513487839211607667381966173581242119942653\
44230907829310867845619995434019465552418554361282614671489763826879562705701\
32395370038922955389063298910981319083277285316869133777805568705188951952558\
11032983643641058888431129273827427771833709982777172126082329621661211662207\
39613020746991776816385345686278102984424984694282768081587247602582215198953\
10709023064129769367574318334740018234273786176517511843614540347348467103332\
37664126975192918469302929926065396368211476526964580349593653206215716325153\
28374015207404717253781570083734716425958145747595305736280949924662216595654\
97218141463080380083328319828679014166663494865432996440213462807105591857367\
1 + 1587328389081379181059115728750787776682194131261776504561448462183002563\
57086800190159739732608153497423415871467918051170083058476169217845342970490\
93289487007900934717979425230485174522188209186592190054016620847882494216353\
12522715163985921681205684778570906094940014140126067126137724708023253021279\
40921262846630970796974545213695638867505485684255129174374436193527042505375\
06886848497630044790604211953157024847583912948061224321039205693797887539994\
47568509301761457457414792579475746228396017285854164907484166199922172908817\
37666743577039179231421603478647786681011798535073166697143231891470619227742\
97719841436911245060565487005264692057361388488902331709747868476882943562941\
62908428382795955633869271550829920822435583782832911370443256486668940071897\
06268862999221463177741966046246333912222231010197957505380415958405392030872\
24237578197249095950757770072944734902327812176857734464187587811914277150644\
15878848173320345988255485949505495002136359567231715662972251675934014285840\
00010212877593711944542386394375391667334293093665734313119785605758933063627\
5441297698410148441314319893825435051977674834755058876176691200*Log[2])) - 
    2433045181104740910835010996905276546489412471060606685541808693838415640\
34139766270954848366673298942195448440822306544937462630320040527594655487610\
57486473574046869216412748960486384368939360382177954564203570102487111969041\
53939914899169781915143738400534603229389203062991893441150174441939725780291\
31001747156497614568890525073501104702535721215116483808625755302921818629586\
36075426922153269811224233821125648508412143658441131813360330608725553573586\
39575070095974147381572835125336690112036014356106804810247759662703526481138\
17407817201299579420743751360270940060737327266115705642688420314998988085654\
66293892157994489055743822667410549745467116759306836167180600331254048880243\
15035714935204849395165738699836122913198106546801380215315342528342168395506\
27230202150521531639281318276215940952748855323451969861999723986506925324868\
37302500320699379301804976146052891522258118262036184499222535954594478255439\
36394973175663956671014561483741977774254488183088829968960410433008131899247\
61042417836229205845844220412318698146564948828591091214200131031393521753312\
09921999525303918240089188147341999724321807690025634972746150747391326769386\
12729545625296746327321555022813199838948152387435701417959500000445801031779\
85703821116967669563066067584590942277308697410651898333970622463506936550021\
58363322162542059091333071969363951616000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000*tailpot*Log[v]))/95177741411\
06614294952475939175818240156536665304776822654555617996853684966046380679972\
19040587044499446259707462233471627655341974928055800267973432639741937592747\
89946792605829646562082168545250466615380455164376483889089952197761788288514\
83775268540386500413983794445187778067894750707879110192044549369939699326946\
63840911097255438703003449103870176786915732372478789867607734531244927880299\
24389536613588642656993815624182917415502817005349741308412563007602216934253\
24609270551571759656927957841300716845243456902739632591985589798699158502506\
70782718106438444600101277539064967244961242485838375929817570594850868608520\
37479132191389405042872826225915843091149130744530813320759531789243963745978\
28525198819874285085478389395727133142157428500287001639047497908186062079218\
90259480802118939030859488888388151677630724521169669769363139105983398436839\
29917176212360311222469634943050554739452268305146643891197397028554931673088\
53843902337705401712553777455667298487689799554430385344972924045988903511100\
91191522034965694998284170454415210992584573134503496026977530871336951338472\
74265177976243810295365174741830590862496355757755776377195314033296985572764\
76813085783470905854574839727319547838281068802911141744390413721348966232946\
19356559527500706862904689343316501105862737037992634026947342499840000000000\
00000000000000000000000000000000000000000000000000000000000000000000000000000\
000000 + (v^546*((10714091241540353542655682687376544299228682408289737084135\
44139943499882157504162716604178880161631744711414110334530062839435211695364\
82411639600308355293091236478794054852131665491930363751814751940355810630528\
74337774201718989748310019494663625350135273602273326185542091063310976727913\
64629299256469826605820003746904597662636357710057647532506837404747777863380\
36887751196431216836460042400092396590383494168465570163040946635800901037746\
39680627078453310429739345775185035001818940300392911005768667962746812985606\
81487106438605528729631331634419558592472967763044119529656625236234869478548\
21841704144116398316210164176435494437192428961797019064625493097114105223317\
08166054401911532226852116413627429676276710979190541738769612724130047857117\
94638338346800468615439902291182354913691945006546846554245785110633647758700\
02144014592843387630703793571838344115654738174940262739282871098296695205461\
25114607050961702081852495160119987221957661829593994246965808556359136448069\
69061919689085144096207433788738047521599001409315191261406923899028226816767\
92122063910738477506612263922146609773197635664524311120457034760645918694101\
75957694822966727259539276895650447533454596160182835796971500702523792540743\
32456544188035660404220569321937082947651672865984459930493605092565519503656\
60492436510915277722669446691870933264716467331195352239136719769366279151168\
67925511038066194123816172214232997092638316544048227788741732749234642510433\
97423842089047053952*mem)/3 + 
    403627*(-8520938639894134830638427142100890371808865495664285708313157652\
75774767508918356043510794356642852441173959510689755180908013051226852241685\
33426058426880197853816278292998411785296358355484677042026972493459323471023\
76415035603270441981520320182441902464487781955962244103550371718787176554782\
19104697606397234110737560429427348475557671799009407459662222332791572126381\
21968851755824107098891946981735630392827671043120733551281165305284630815705\
34128082231985358760678469659138802087771455812281273452834746648617358265917\
38088694102889053924571852399575053853734518416255888420572537899684935406848\
84898921447474405763124895898491854021903084835237484832722486166761275999368\
03868039094013336770210052664149652773662460208719064125035506121106583482154\
75882251583656780629525901907550803663992390903862067908555290531609755271747\
57855058395120354667351154673235430768910679413195896988783450631006558858796\
98458237150661383806425489208951367056599888481090685166549202545937260221182\
61838340889346064555930952059407131338802433322607153110536467724390591030096\
56720231124201570824027417405610133770494232772870711344126236288608286756021\
15796495947425733511129745126799944824699707501361472772168714736089146202103\
60915824509861297014685243440007797528811307547346243992398304344812503974046\
46072561405544450696594025694829176067327463403727035409437252252314156991327\
9758097246485704090446233749389648437500000000000*cM*mem - 
      11959157005001881819132660524291655694324600115576668849383938646534370\
43355040596837994547045718316604519800393974491425646800143488918468664483058\
49235021145015685394769575616347706346857472663290726233887503492374513023487\
00875862433690272988437295234154706403958578955508460646054165974584337765203\
21260113733260815283872881354864069681113504645928154816790357338028612330838\
56082657743983417447993284784428324972018416825327853577112165067959658286572\
47254280226172903593178266097602127370268484469926615883887018482159423243810\
36317101468136489063318886549030859108702067236501003101393029822386423236252\
22657462054456185762035593038945451635681238209742397346707538826365844711014\
56863219251182808486031801618374269137103872164122190505684172838212261979167\
34610138040209456842581793262138686744100751861023255192722672690521870217186\
99833362765463791076966500622138949244852780886291361929941514294722894505807\
66048280895839690840719336980967004285261064154105192852404070978489667201688\
28882293832167782737079257446857153143429341960479566982270222665095656080108\
96979209359609244401846642081248913673396555172700048082022073299799133572621\
48840989507022976023815657159136911910636635279092920472701009097104576819232\
40946906920043588458587587628319498198326023951488198948978662107274586774791\
70681002430176050025161825341038172971513737514762154797827519104643717966186\
4208542643596206073885597501190752810442668669286332034303282727092723681*
       Pi^2*tailpot - 1661800080721146317422589583711181361088049687711919978\
64971752650343000645724570594223441970755594021208263698646160659525250209778\
09394891027806978015755687525272994021495544238223605822268374531492335628004\
54572721921031588013371989498494175549470064368051680503413081169128417968750\
000*tailpot*(-443348910415133294174135458824891184312885412997997487315179161\
49269535449407604296346493801228999285039226769316351646734656996243438336304\
01783874158573235171168517097919574214965286119583643757745140220968709312578\
92287156569626650899787498184727134743022555361804132542015309320015923827435\
34130254050840036094479019481161537946043312264844232363663679628473181020541\
29134632489184205486537724514340234964307895869453616374057811640509581004745\
56258894275518781796431762920269949092275604609896169970828028605724054598407\
35157752113417653207878065981512785202970212292251863889280279453327551227816\
55505179788725374912570925695232241109359322207304425154918939925090136142206\
10312074340635624716808170482281670473803082329503961127829411866110962489780\
41125682840687746412819813264875170811648138901784050497631810374315521174160\
96949712799644213383829504257387100954011635864414953757552205329406193266880\
04930636986511203468599105881417773968472661050765587745012702944789853406110\
37043772919310926700234284107561714764177696714230528382461584370414520159754\
329797263531292824793896416546781342920076214500831874851660883051965869 + 
        137530182753236664513866685714934604369506867668817448775075665733854\
87301504488109432948600643081061405828034163351923240126913857056503948092581\
21372549960172804270521403920426431780262636139176638129533917225498076201288\
45626851475727964076466371907296155943726328900892774005142395793811508659347\
46227478508659875038606792083404241413980050746009396957813530017242153384576\
99956928829477251861181936631764293102411200683722946026345432263798797522461\
31325096622382880114071147415291785045676557347751343438305045270435491580083\
73706503832334747092846878115316196208823006358297107181477938547252840413101\
54134478106780945357798403162613772942096681373013770070779590373297478263808\
62502129713194147367320723703708360063000809649631991237653475529666757055980\
15235112075547687273989998496637733651900136027634903608384516627953924044294\
27430484611685399811824258129223132473975537292969661361171058452148888431631\
09657041137898247709849151832945805210790310961165167066610281035208042010121\
71252815861619802021288621563592154945110654661023651469838927291078357608211\
24718894803276231552428449501966096245355846776938299860345497600*Log[2])) - 
    9904235860330475675882507860870086226131968250976161931427123379474183125\
59815647699113330754309762859265346194831213415661531774398462629990811295478\
61979148399176626611789779659397086580194626345565248378778086397327339847297\
81759070966582466667337456251235143700099276450553077628088770200843078998887\
03366436362008894722122949741968195035345213170224692554480992269018460545729\
81274554985339327966268356779711314328351752432807471091792451688880396793636\
18218634042092718655330774151990100614979734403859615362947897956847569797053\
02031504262949594330841029365071075438406013474188410416397556046178720596383\
36716008496726203281329653974511987464511856704526606491658700754182972164859\
91660279525253716536977031372151782603501971676634845486416878306355034976895\
63361470421139888850528404509112720589684525098222912825163939146685255775334\
37565234294436597540449827461835780057654779455649598543329653144008913071031\
48878636145838065426607502175660574154310597217525150498349554186776062914957\
01161163186867697954080642054079471907531045482373145655669851645887725365683\
33126828200668305981489427546677837616678632885974772581553007852827751336721\
03046892913275011125570203397676158772653877657732751884536844471060102557947\
74292205054273846120844363719220938291594255161076244267527443669286246732769\
85761188458103696109604291215360000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000*tailpot*Log[v]))/1765165827356567933\
04014761483231050448006985632506988550715052262552924424444480353857051009010\
95038936317872912875249844726545659772404595702299210545989279258025739975295\
36458264958495589179251677793311952061653866540969769143133564322858212866333\
18627346075926999155140722887015852201555621479822784669323807480099158724204\
58035152794937007587237948382546656757649829188939312584036441540806736719127\
71023528239187570764543451732483360849505744460467592043909536664210928154538\
30704224029245696547501867894014159067187307726112492392409109022672602148130\
21261840589764489568602836929617233725627566319173174528836254981612024755031\
93460485998569599892913869493530213849119636745563047696388055707455086892655\
56748410331703976064460814783793720854975649140190050035389207382774831279577\
30009624240186563221223815869392261211446025032814598277188119407211411334787\
87321222389140757324611471712526933759368446659703215820262517278803570816747\
46619165462028074507708963250884454739510949283104097256045788269864631155697\
70678147162431086247299985367073156029942572255693203465714706070817372823660\
60390278380848760659158579207390511048919802974354512500617525696824272405987\
71948644396412738125506668172074945638036185863211988385039854715002711304999\
91237030913629538007108985554633952838241703153318756352000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000000000 + 
 (v^544*((4370017731356750330164796938726588642577985891260839365784469045494\
21946343357297613748802043637251967978042482656631323887397536268303915430722\
59811474098062381689813914337480687693538477916477134778542574369575182510248\
52524263966576247657573725007682022848754163310270290265729827406877461151534\
84905236989263124987917048082048349419026191837818682281320727053266618331785\
20624276948241396040689468943389150000494675487141499451746459303792460738733\
82136050573511174806023651680941023723652572491366385072282096679357255175597\
95260127797015514034764990677223157090424793948231226556459911217328710012116\
26820564795587933783826584914322465023739650548595062342384635064571305507329\
58402830543904905397611610456972798284270899674474949080962803698179243143518\
69729547440727752143287428633664776624707736678233958430449668394417508863213\
39068992430910716997136490895265933169038026276726942859023055567457650167467\
87349515967495415127720772207455652388741929759647727974188278270178530272173\
66216528317404513680297893413552588442201395655354584900202892265332783708462\
55371845512479197139284570331437016747140983871085328420462962419552643633778\
81072493888912672912739402511241197225048004493458318621983736568073851759539\
98000417549613660655379814801940231753531284132072760281860829133144169643991\
66872192258909541674277053844237568145396906710932127458046164082598134334973\
60501308323334848713019874823365747419118095689472700050590352045890188900676\
58831136*mem)/15 + 172983*(-2657440208939085990100792334598291185209928199193\
89361180150205855480473991680689597665299742268601684814046746525873556278226\
61869197480809436363264598944963948117881576986542482956640629684609786646218\
21172007114358476668259221898403422985010958197002461416237123439235702148684\
49185623314692973466629466037786253834880693870598379494409779182951210727026\
75665758619885941921500695715727410755175884147037800812951865173199610791224\
34013920463193959156945772804492855418668855262219446965401631409283112104289\
03674982360544995564396258204376439136159451846033648988206100865261399176325\
01323626079063701985004870968368780360619288200341066563615286914997680343277\
97478504080242162114338208607392500762937877763731849436242916016814782664368\
80343183439134004131312542764972217015494848326318495468866747229966472940615\
88811477307452853075927559433563976020985827169524938655319289441018077500856\
76590015944582876047748008209642787350044279154826774023072094969130215031507\
89840597431630499631603008691370976237572775619692526001329762145910908058072\
15935966939959649344547771902445168744528515054553992877864620537206773311173\
42286462751805076692267253196038505962310077877752587935199513508621007592790\
27310435823015564965045248096347257408223559493466423227228377403744560173190\
30289195907233564967843725831475029075424268882738131672831633190298044925602\
3180639590952623052544367965310811996459960937500000000000000*cM*mem - 
      12779028453271561911884731392121248113312438452159596079594842969441365\
76679012109039796063418430927838454067892528376932860602756485622132145201642\
47065924166863935766127388110956990911591932382181043235558187999920983130554\
72254202956748740656223514614333696587201120059326085980113179183308781263867\
63910842059133338979053533284380235355208933644376635150380927308160434808659\
71138454481541683437239988028194321842873982119951500680063297930503164754455\
10483854912936293908530380143905418127886644322509601895852852646123097882985\
58585301585058952466039521120979923356005919292809573923424634799096448674860\
43338763846032441633174942693374386847192568427757793089019054104695984846724\
72875806125270546383139937727313839372495985785765872057324328333626644354626\
45654597661196585223944553021138963080484040585183658450110207450439620601962\
08197293341995662780134853476047093656446080639266759696985473636436053360091\
81568732063080146513850364325885997741154336553623406599046169548667225931725\
35044143460824402807570974207116660488328333573396766400060423231678129032521\
24688945039078087962226010105757357399714197302099549232064218072348151433478\
90592899689201014540219299508709703303483035200826283588196662201496320216988\
74874597817348869868540454792782937215592822738519904703403191061320538519270\
32877044127361678651675150051169948879993930953007710086005764845096720035284\
225066755700068337465991635988101421284739462670630287249805144757033*Pi^2*
       tailpot - 149087207241839983905912322652945984966185029126155106656003\
22952059343486502147190453188793947787577902684228964255556311693875962948999\
98795066111741984938823695920035071314540229203493769219886539598110626693530\
956237725481817710870578649060350096000604480650508776307106018066406250000*
       tailpot*(-594760536336023925423517195994956145282070402304563727040984\
23176056576350120605006023249101306112534070216943532134299242018681830270220\
91457056516229331431002129523879376192096911957281626537741928189035432985059\
88107122658785055708789680321654520551816381503466549342939165464465049224375\
18841287139294639208640217518779754930232493428962936809735327565142276883666\
29862878376345687200848731975446260821424207069887592743595571425056484011182\
14505057847880785130116825580533556692339287799499927970823428827642560183131\
67631270211893987890155415220620674183849084777708807852610287354484436682299\
12074489040312150212788430610587162289823731914044160108631815263650830496707\
65317613105173937490673271409017347648660167893655005684069108994647897894033\
87569112404171597682752298027750226944648927909611586907194926599039783385176\
72004590376097073523348880153123836179424581638773197305736807599689440029855\
76484696342362136175073422533230189595763340317343931811118253464517013327170\
03637694453939128345467553181028119378442765295323758295022205007421886840390\
93896883689713857648455754402403075020045718886206591148239463790679681 + 
        347231659265668849666884353338390742353775947785625793145204484798742\
75713251284993297551990204039590147037877284182802160362097671365482244871705\
98949357928148437215657510068308182269165917689960645423705312414075633209043\
69482840618931643005971803041188136563820896195914403438503365107688879986212\
65277279876395880349386064193921620295272038616227844570891647591877098442952\
95244645801865665225161541853191933536183829104264874777723076245464714690889\
55762704981023267029279936074233161080452558595344182292323687283249011235072\
81145570710672269717790540965775814561895642130734186671175372091296234949707\
38899141716558792925471644072842609274264283529082329820362593057260151877773\
53080656889174065250227900218251607810874825360215686636226593993442449262543\
05140160807904888151301620601813229955899577361077978966378133217370278178072\
56293518437362523619080428937251878995952414471413561333055060282805721300488\
03691462163524327311391345965512450855444518481609456161962306883158114702742\
00498218012200882270898835898456537665968082202779443217870168975487327169832\
2974974292324664194358904905079020804093661583724048775936000*Log[2])) - 
    8061520880262195485242231135523916604570692453436293780041633843921683167\
72031583453469293320997623965924304236118758865873902439879403411298850490895\
78280170479658144217814393612551216527654491587862683504487436445520894504784\
30570995502134120838635666194887352302999008545759896980288466011392992923538\
29488296554042039959570977609995679705926366406471318914813501025923880340146\
26296219721591828313088165965266268852694605798661901392441705433393428207785\
82126073183880586186118390440641532466716141947884801540834508603280175274974\
35686317907255502911268809590504834662345712607975933155829355100442907222220\
30726085286252979187881322287793521212059703401880012440494891736508281512700\
47988244098432728544784093554519108648656546293430221903696239448096079479805\
33543655442526796870507732129828915040061050968684556681847999486929104025162\
91726189356896539590465856164116905908032772509767689425047234863136651814572\
53110524758749799340227910442593656942873876220581323396612505650087452395301\
73920005452639400774764357616898984626802956262827059156224851630217657008118\
43375067684686441120629085967590026835767728062351565903899569091324874874674\
65307169931812883856184205671196637220776656591318101170382703272307304096935\
17182530049029936184218305809635591884817696805862290746741464612869996279154\
07190878013471539700086865920000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000*tailpot*Log[v]))/88520964854042171642043\
11699382271428717016987820662967498656638761954692118718732031224135422126529\
94276655233874845118701316352283229218564237326481249759986600397971975377658\
38584972174635923782056003888072139487057188513720422025472738574067850339847\
34468390981951678932085256598540464917327187541433565792131070448882448949937\
27156531811243586188780493783233233332207838176836431589404650575933682446182\
93008423543355305229647893882828315987482615711089106772895214149224416578790\
65996704732103647043077423031488934839688050581835750278235214384958916649055\
41708147415622711183935309673774633406227613297591699080048929055408102047910\
98777011600470820234229065428879040672259412908790726603388900649446848947357\
46172884559513946918836627750584542677642893459354453298048808797342443087817\
32644187927352016730051783510718490671195842041610031606583367596074378498998\
88682312564764641974102250234624539756923261902340986379214725714786494627396\
81363199919807901476282075604352264165164941381067751105751033389985040197497\
82082401677985913704623318996068763489114608424042849085706229978369281789213\
57710468159574722684701323006283256841309874623617962515797593717232264562718\
29339522484039924962377081734625002707535104529774666433190320820492527525367\
38008615052724463650019629708646798728268254229299200000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000 + 
 (v^542*((1089057577403847930220421391812234130747171640280174520432651613459\
73589039017922557781897603811322962158175140307064363230373684653378702950039\
47034116628608580452739087482380652858307132072629132459987876892560422772464\
99171699082306804322760366111044346836451899503486833159956698990242497334140\
28214150427572311950206166057082907899368995494213608642637168596863258825917\
18843337305112078392737492326179337122363251256067507227941360193084445176280\
08135363497655722871723669193002857920449500426335399439366034269853263940471\
76599495020330754724640468022602705350138534185184845003518280988131753725896\
45726095071194740074850134441927779574128336984469194298439186629241994299785\
26400478154968453435597208958672766660474073982015236803094575955218004650752\
18438293242491036119243603794007279640466003682494868266298272689903809438978\
68851568277654092188632138914651224589951778686683431753553854691832586312233\
10350484762837384489391921983430439569582375065461333468696739147239958284275\
85968797065423222471270119584692332089512868042969682200391606600666246082347\
46149613820783281704530382571794914293152853734777035584794124048531661928903\
43898639793369978834663311214943545409567778592421265263256916905208960067865\
76465196223955887223957520204121446650295222011418953858554902275900829206862\
67121518729090607958826741943161726050662404455813337746135893369233594567118\
93486349687549360264166678752346408619767383349093399975502200333206511109100\
48*mem)/3 + 403627*(-24194413953205381709251778521653705347038317228255078421\
65199693159416827088157965272274456564916347912643685310804126145643828258793\
41188090654362131865121442036634729440650825050622166404789956287673633014715\
67380863518053595981733752339181633063331423901905078452688951292802815378100\
51733202170596736857156848483125985979626132157851402427183898146812155365742\
66324028922006511962373516191015087017124019688930085934215524140577806226751\
17776167877462189146172498208696368501587754689071244342138702812839489604946\
28281154484490310800099828046166188270408618496825042467990558507475613146041\
95120025436843620273313214785384777386955757114819930991540386885366539361585\
22127400756170500816110139364019478407820590927516280706793990979866185441235\
32733899787472650812509153276955121122688238543115043897864655174389257521086\
67495099705099530328442157533241824195383301362957859200851062829022927307197\
04951235049867555001592171518995705025555675846844661880355878222603396002196\
20773711009089718052703112216321847735262583368383216795760044427064929435250\
16498444602438122799767243708575813734754415758901767657189966175563137375510\
95088102390046596041800785670058371796377082329196620277814853100470302520138\
55017432235559406226943768596322499534791203479434452326014419059182148874293\
45809665897918558104639879787413880553018122434753060913623751175921879226753\
813396655345968611072748899459838867187500000000*cM*mem - 
      32805415752201468519764013454885363563466866077583648615895840079899217\
15556626727798957277541436924112898678090622012119477960946044559646227215536\
18379292151582483500270577659098348587924663179180567357620393143529111019296\
50374870681085409766738737959214906913702973000907342509358744520287251089422\
43863506960146047099896375026748989854137489326236056746249525377075899016923\
82793482526079202197354921675683391401262965660273818361063386865713545109843\
06313192650892032472866744219737565256676918135162663134271876238116338916207\
89571517028142221253523747102967300630270216476691638556894226773000326564970\
54312866123089137901841676850624035119603932805471111131825037445961518429998\
91526073303006614243924952230091145480825684188176819468585827457786598335592\
22748241247689682022252930987435779904403648515500176668562157300206257472802\
29421596445413464909522108723305575300989447797638908615270962855969824592912\
80781170662682874219326200556952632684992061137000044654705895665340602353807\
81935880746878200899947552694504781061556971141314110173103613559116090626578\
61608368788623286273864648744074601516041380205955913511095068595007203067113\
22170432612723009908724152894309659614729462764791765351318603709309319821257\
14295542810482026318969017561750719016436933940882954676632082891029802269899\
02568948912603729018302809499231583110552066456291549925912196132521695951271\
89400436377785321915072768755638596231213657281009533076123449*Pi^2*tailpot - 
      47480002306318466212073988106033753173944276791769142247134786471526571\
61306416302692098342021588400605950391389890304557864291707945541397436516279\
43307305357864942686328444121092103023493382129471209589371558449349120294739\
4323919969995697644427057326765861944295465946197509765625000*tailpot*
       (265786118777455714392224454548235935434275948953620090154892831267304\
42763368485672001538131750454432463476599416905023580993143796417460813947701\
44153803638035157835747628909063948180776488604530125935695770445827989120862\
55172420377690796397878922110354607528255914526901227496470549800883357677519\
87156693156501893539029343730710385041223607206507132720811449126281930973146\
24113429958935963596671290003813500918088186484504299133552387600491494275627\
41990764192404484334731771028357293706608638521586493794358021782999965052838\
01540463342912089222627873210463614503476812732694476771330498931787855029631\
30216625001945823810045939590524226059558387494699466526861794571133734615586\
04411406296886404995998884245054087147294871431653094096480577362306378826419\
62206860059133428137131493504062050897369216596380525362238420375305754710007\
94866879654904292067472694577242806043019073699664010815970235342652899971037\
58601261803338822951381943629728507056258245403923857425253438436954989094971\
19281934638976754742026231596468225696984059123580368481892936162286662089524\
53336197347464057719547082527792069542848185205632832511639 + 
        669292050707859046941479792903215098870752148560383412597787540138720\
97516296756443687095402130829824591322852238589501022659126593301881164784084\
04550248222086139735299022067309704213041526411932821972971996982889430971625\
80815709941357694536111286380935986132953392093196616928590299273076041676876\
84800623619322911156752302658991006995483157050696368685426895370204587923490\
68652108966462278278394205517211287618212744432790099571014308750468045944993\
44019166698669574666689706182396543664120641186959149498838753312783177092955\
26919258606693305138195292360415888541336611346167558401007003767992841637931\
44987281625591834706516478651403464072884483373800285114784872049716322646640\
56439628546073059369462995029286682879364696308424808163264298487513726922750\
46514634951150143634794369274118345008303406031357649384599521504344401263295\
88015135086410855724326216646570613591470692913544401736940307390934421776473\
92593059893628373740818237807253308920698196162896092914444890011216337381062\
62166613411361485690815601143898303263418336875925685365246425660202147326878\
299791110735136000524310729494535571544116896755982592000*Log[2])) - 
    1002222993730706665856319371839667844042993822261132245924661613863274473\
59343158394140214288976701292286497996734412593988827216283339768347702206769\
34653533778118267629879094847545704831302222104333671214581921949635648439605\
80309245893888396483558179125729239167257397250327218379018249992473035865308\
20404972016391762040514562889866355056426476482789988228942341553484948836709\
19397270021081045172141044214235640366447080228471408511324955060292004363790\
05017973129768317780011657240231169874102384591771770322112671968237996922556\
70624362387512732707601769885903340641214601287539566836640624966177235781341\
24993279895418637148165362645853568312650057520456256998337651592091086826153\
89264834644058140384970400457429938457515059590373490416117758518214222137504\
50083090519218931489491346687211435964485637343385830145970685341758536671947\
10196717815805461331339399909626293605138479360659072713466380531284045259919\
21770267938910326655005671501839401784691364525981357560688539996713653831705\
63155555192581116343728796064106112732480095784862919271340504772088563117937\
58379581769676877751189347206832972817783504988555567433610687563347962429621\
76808475892172955331038426653066815728171694851326150888469334947423669078587\
60515418565419723936488707154436695597851951003708895301087267270229624695306\
18971063612021072199680000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000*tailpot*Log[v]))/9750232156002882702264316134\
13832766884112520687698904400972376500089420393237523983801752076329394977331\
41154285056580924427468309142191118291498070379347934072929031404639407236608\
57332931323427655967195627281224971681766050524832866143788055056526607052693\
65824421918311376460161596539124202075667013389988433369416260340235548226664\
10540639241932928365062982008958419166465852451868168311839620087127443361508\
52291092131429499233024606593213626295159516989983167587157675146589431247164\
04410950489824105330457269992193444995500894547015792524243056275436546260063\
73236237395806387637961298187843712130115230707036133284607689084754773680047\
69026990428965879963777727739248266236945517608985141652576569233739795792927\
08206139816660873873273132109119201602690953568307627480828005367283716032305\
72058966895095518040102200236573174265078853068687784547664471938719363548082\
85938339509280883618952076595202329790302687356883410484013146800453042826274\
92438297068704902670714225608150115725542350740460414420218559530484996298240\
30899828508873558082089823787519256707247109452788266987818614441284688051355\
31173165644807290238875943838083603491980823982527860384504352748173763658952\
77212177106538529701223287623032363194418876237805770585437806012284075586301\
02992338104946345314198774666274828137267200000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000 + 
 (v^540*(33504318665639610399160210725773853840045259301835118952156109655442\
45923601870950690368303931714284459171160470250412616890667832686795066184047\
79458236748288828405979433325403677051111752435024343839700887466781129606136\
77576586611012929538713732249229225807623300239941085059207515419376405078915\
98166338388174074857531960929418431037717839002160277757370933198512237477823\
05415722825307544877503570422189492696576006618790519255011409115611281599304\
02521556613243431469670602560049211845357359697909105857393522368463108869557\
78079503414445369085759327833752320005504771113300102336609567996829676158858\
87585034370671068472350948913022772029702709969878891329516110370981366857695\
25744617295298836795962047595391261905890433005999042208465193717623953766288\
25886791797557841329464946577828101271412332788512696089670632693931418020487\
85072261053807025111778080861482696425532523851769938783694378941720649850315\
28951676021899412464875659981175568197615215375538208430419872276402602086192\
83756146363496730792620603334301876722366365758212403691111594782963974209364\
81841261782103639116036868301355468758805632957217543532303518489200337213449\
20276075537068122995669998687696983877024767232957988384626846397868936792707\
05652383636101599635569812994772883506559968023256071459665897478523485868410\
19557229752312715982639743593150795438002209041610086346368274827801630169278\
401721517738361263797407916513830389714418484552786644477435243030324480*
     mem + 423683*(-383982522763263405780952773809168574462249908462728545140\
91867511769840361157045152751921286330213804671551288184984458170794017363732\
75417995676613936152031038192714823409777569048118981370014832032893784007241\
55432968067706310269476625323752135239342198065655145889940208146424242491800\
81827815693557368541484889793498603911526673127910176484550301090979641937269\
33085761000024981979942441893703447274559522080280439721461241829754978626724\
83800219443452010719317097919964540693849718753656039655240248340949358297685\
05337126227716198689643198999784817764379125865419218209076309208005888384683\
95005106579074637678023411294321491559656742398899519229787877272021652888178\
54464631691873452149460030199571140963553794516187929189779184511312972913393\
75711392544588990423930124083891159509102247958743761465219081079463818433474\
58777815115717652716877817540886033781637431565657830486307955326546008972744\
84587856827811868803239843688571966935911972239795408201385986327211051519706\
20074330230820833522549180603036478106839679962227566031289964029307020825533\
97508406899197971370382050880428191131365240276097182150001963175859068162523\
26050655169175683311456032684672228242538916232845357962267206379024373994304\
06275224991459069197975592286217926446893537835319593236827534044094185291165\
42320359937881995900593253117063285831857651447230560532689613376382438414413\
655891621601767838001251220703125000000000*cM*mem - 1062127723438326827234591\
10521284273296972253394512839168607745608210893092331705471322493894068566129\
73568960043058214007155912712004254942517162261643408202995234263478145472877\
46557034751061797512398595235527788267311805970591587211972667567773191849200\
32160499168495080319234969585697626332150786761937152882529006758436850862599\
20165680351772326815554480750177770669085760981464071706385769958206688241915\
92483465645617353075432734996033846016684832285561161949270485762043438101042\
37022113395403016757884263179092854107229125321119461698054584081833278514197\
33201784131119862167268928455976496583790964652289287562809357524258158076340\
46311093460792281104214539922400692246647678535855141047285520155091365294642\
76318663880368372120224822200999070290645848654341245376715326627311683779055\
15943428698289683261207433171172986822389996440944817781211056354445398073410\
84259763980555906311256942407939343356939260640075163334636383071007005762202\
33407702023137320189772132031969920622907557292968045322805935082062862906049\
20545478854472451693043009502312344188631907577394323751950994348030278287446\
36179106274810222523999029231038091488479249485796100018555230465376258305016\
69202889325929154801262273176989723471258768946460307698343365030803178925669\
56669979374806844431163874935890432607488811819891354191180296624072764636845\
22972087311467695791941125227586993821871806075136512864019799535534177859242\
48181926757667423690579531*Pi^2*tailpot - 29218462957734440745891684988328463\
49165801648724254907515986859786250560803948493964368210474823631142123317778\
39403357407033335873571778303785617195881418681763041653125196382210524937534\
38900275151359345942058421484325830118916430584588908581089583549328381195664\
40582275390625000000*tailpot*(26740066866460480635462813998289836807043434156\
73615592283244337489199553191687894200785466366102480826774513107796799980121\
72771975625280046717421100718434669380710709390211098920737171253958497638286\
02197645340584497562930133980557699915901189774701181114729341386332008527485\
40743544153425382930335049874565292690050863564911346621177419355933085524277\
55736617267364484271468795964825599160835024816170372247366421113638351659949\
86945241588070087781243507710410297822311941362408865030979233240289490826509\
31469269867805302971502514709363509589490088486404518262856217532859848425899\
71643859335194816872675350977024830972511579809501830887929792642612337722832\
13817074510023900315822820930212436433624684322144855114804485438170415852722\
88314331723931262848670545698003629378363423049674287021157201035385705305753\
29475948901537453097995988418241869425239566821488264360571270153074529383037\
92046584754569230809861304687573673820231893217246054494082747515816020690847\
86514203346197275949304959550841593599331168164113275205990783688332110328107\
46769427425325891291251869939566436121438913448863873600747404652641117506449 \
+ 103728109294910039563425571718093870105045918188998088107943671974032109762\
15263031278718003336552404598315807712243083422367951919084464843127744429122\
64717504712115489290529666626531813357058948616363549250435882930119962836824\
61440941245059103545591483723009702534438060718127331818987731305052653254076\
50055099044197590228587704259300518014257553904762077612692190194729889030092\
21827845054190880730862412884163807854557488880909553750006122636234552431252\
33056386091421932429737233336150905210253865670222682101421424527765926459454\
01141368241127291537809551880903436058073700089045061663320787420409286963079\
97541607098378390200290149418585559511469050498289637677870309628853259393683\
85714075199164936135102751288666055851074940407244218469068780614059702060599\
42041394307949009104922112185961532877718240103240461941789049046022514613626\
99328163765864112348700048883128856183650847263141382955890001546171460292777\
52778433798292818411269766050589620947025830013395928448781944267076284174782\
21021259954524854211267093626939344797120272740561992064640776696117025698591\
17312252914993777488157249860983588394245472000*Log[2])) - 
    9228184001097542493676577772366667774270368975506291125329314568773660270\
11127032791721958745510011064097984888156654797223538278984553980913043728391\
36858536821402919345924976298325467780618666411547000760674392314533151477456\
91532612792535422242269777738133366873441269094984510568597390147966981327228\
10871503205499978000710728571718420096167841061711223582898599039285387080234\
91067727717701107635487138953419007514653113813657095555266764465890325148526\
16510206086684266881953405331551448997603099886551273178375545565306628173365\
48619819946914880504554009772480201746586232013813117865409135656687750385741\
70999697552632269292482621153366341636901537718314225980569392718135259560505\
89732880194284628704349839790576756468434174265208576366426859421937416058841\
86980977009977388772338967943907589743165969843941018221211071821533662310300\
35287038970101941211451756864065489808606387521528756478312505249357711810748\
89280990409400001932217772805790214098484168498399857554432350303984313553918\
98759869026747318972992254234226571675607155980463729621420464043850590114694\
75722379619939588870005830891106146965612817530991403111894047657706814885063\
93007438645423362944821799782310371217665020175327315580821138798858182277023\
22615274034108030690546491055099245067103853422306038709697910360925658826588\
73905877855764480000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000*tailpot*Log[v]))/1252844271598196496292503354192463\
68726180607277806031582578360489724222884379511039844091590553194773872941467\
65665267191764554351834652663103449480316600996187165958616046445572716396650\
62215859687160381115151430693178053013479704844213351648378769529089457143198\
30611397929195773869741634359816399759872704259101427322271979024248069029072\
01703835325810883480995716318611840138649677159825783740003431360152429860669\
06636453091710454636949671471391187034209504824717138660898106017757302522748\
54274895876888346799832071440331331830782244653464877504513652754973633965610\
22739911457417765989790441098103675520715849751598293922782241393667739047158\
12822976594048140694053451543526564039723825342347438992397658335561901732982\
26816504172846294024350977661386060056533815925736084654416370694878374686923\
59488461419437606299797478928836079619707195518899564029585293520704353814617\
97506821417887373112326479802469173210215500158722906968785306660394214673901\
69382663556981368947467506866578087934043125930579616592858924896651676064549\
08088679016974057349252200649833112885570214641449133525380460105491070888269\
86734639446067184758311492885386586045317630714979530644704831333762078170641\
42322307551758969296662742124307978512435836067571343134235274079588146599730\
06177304829308617932614338885137203200000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000 + 
 (v^538*(41223618751094352777771287254215707751149783580504079691532184625289\
29361823194549455266476922628507231914355388558624429930104089813930924039063\
06340701588812523108140717842950573034143633796255112690067673288056558934084\
04571228314196055763168958244430850596901575361220115805646858728383907344065\
66247590745686047256922578602267224525899277998479958494496490517401167875949\
90005039126649300652810314028948400122251739219100743904508736775912098947272\
48561169357758777756879430423477519233875519358482438615999708798583458882581\
76751517470091639236503050764498918575606313701178166770464673524971380545538\
98113207587530974511675656618672913638337727166341914229327542480440732227555\
81622385350879981674295810496585038805231021295028461983841567159812093161748\
58693206570469423041192656576128800887787042733229706725562009010319162824714\
02923539527568778268561778857275223382226014125521683313262382770453401532835\
03286994884000706217978060917134999198924465685231627779220858553163698499623\
17973184335690444241726578799948801824551483639654429223814913820714457750212\
01094775954885873612821057451203533379099036182115213671421265237879947817294\
87547756384926787144095062538073438701771165196221513088043975245956047668714\
24164792291233110670210265626904316243420242898314970792687165215713950142910\
86973019739129919622925602779944526413931747556327040005897987782653651687338\
327703567462537099652581695779884248047027531831256072824576*mem + 
    246233*(-1608750085406566908320671678204653026906009158123963310802222332\
58527474175101190913476120416862467435653916409033901696179222415675366544583\
63315183687651275871120475924498702614923565025075860926330487119529490667073\
67131755118992125867944009216137327907784603913861589804776282381398382273810\
93480413078302369827126734276170875049232948635326801167101647919494445882521\
25980458397850510861529634895028368759221832595700179659796838972694354666347\
64901641314354701900145504295084166945657619306442180646595242681097756030746\
33906144616293669465823551865412595537784932628006547609691824077077418764717\
61932902452811893877261425184235581935349380081177932628948733334604775031760\
87484404490496137530622784759085130333383206570723280133486867125493087082618\
85924127034458935932136185309289068446864758921734670485864089800523371023776\
03536342557069039447949423961119497390725244273073840734204919460591538883590\
72332658824172784768551540886172050350112950706840528235797017327950675105151\
62554515967226571249475873444701082111490686962047190701442297169223356063066\
74811897626820240411160006434210780519943289511517752810374725454771852533154\
91071063100203065998656761643472956894435039308040280252129434754153121271460\
35765853568654439099863430596734936139685680168283139872176528060727588581602\
62172031573340189175223719949385793150389240292719682245969892164794146083295\
345306396484375000000000*cM*mem - 4641397663114013494780707824762609186790598\
60877829919102881703528961568337361406147431877266417290874067561728800685039\
24050046114122605063481177609828294837299214868989213098145707639997975087895\
84205448099023101667339392202473266160169968154198946969868610912792578853780\
21623053671569366328671561420669490110608515632529106596794326303329102110384\
63321693323733076640944342851303801920575428680042927787574317342763267251622\
50332466760701961873281593812937567760738458326910281897218406031331981097853\
39857243843372087669144618481499702061247801045063870787322205387398879836522\
25481853718185958482972982531328256524345824091797239620595306208459535464306\
16886363337701252954259736936958726220153858098016904070861094788881946879294\
28260429370580600519936100856499386985349883312459123653864382559164505393135\
98822012778371735728452655454501317009239047012211094407246213110361878164491\
91918251077997652597201109181419583816100558277262119382037286553310932075102\
83860462169142982536086306778815733296080420436832464507305311267401333027684\
03990088203851521282213490814077874913530748857086599522912205385257030120484\
74158657627871498502827411506692437104773196814078423915069311813738931313350\
40112856963394403812820570012382924640031401170097180267694342366519497789738\
33111143923521513763515119229341410004488504888510056072675066250162421405381\
265921387966151930398361387002990190341575570245835221118255590504005723*Pi^2*
       tailpot - 110186002239037163318770637348791599069509139234021997160957\
96947612701700784950613425027380040364557392969588943086552882523676373761069\
27163996535089720027912853604249003282305997288337221556422392518095512458175\
4427027472572317207035602626419290572812315076589584350585937500000*tailpot*
       (747907442773383213027131458186438950789829190329209479799873861908691\
16873802202989690919992090621857943539416590923041164618876027915337700152116\
53948845911092011928127715828225680638026847816882240756587018720889208423575\
47654262898566702523403582975991467529733874818899123578813168787458652164628\
40511483246351865488876761238054985062438697159680064305413871595876355856895\
04635960850886568313678802294930527134740521863344468785593563340424982224179\
48424466107077662223432265456304866009880919271799363083593574958509398631769\
43318103892245531414257904865134350725572832041603389043269580705063904214469\
93708142254081952170902425848595272836780506531147736880734307144982636311529\
77052171600823434977415035784496733557806554176830639931377630706592926094486\
52957565911046315715948636203684307743870370244745774056615599466207940813244\
23886075135141353810310760123008680275075876784316430985620937106770796385243\
16600046062586249249410431692121193259433528353753735081508939889807878365632\
67721709602977323298678492619688414642045812319192464639665567009483235217363\
3885321769889321994186543909519415801289760823527 + 5653808176554864488171716\
75607135408365688711575288008628039274300079480860408854005565286060113886952\
90716940640867392138140948684818591954077386603767744930325363482053379399501\
43744384177049143682021099765483975759252836418686754033846985941635288324767\
83908995973507784446832527965850687799864834265485488195794852342100029504477\
01324811950528036398882929434980461672168608467116247185247783661891053101601\
59044626605068727832157994756588872977489493785394873694619923308837668086463\
14018909849614780898799298687689511601109679932769816796541217400563874638014\
72891763373924799779564124916213179305196928188651948466694518372946623001475\
03470400897607956459791194434546328244198949464762591446103183779019854091630\
80487008315141687480179229457114014857040774950791703979474074434556783170609\
83007900020559668116693027798264638811764706037470337757316175148282517313396\
04378854792543099591304190532235490750344804993226872831176803074088033672747\
78072749174399247922685315661097711035281586533100605703722825366017259041694\
68532823410442592721038348474420580940931204710541426025351607310700154712506\
9825410048000*Log[2])) - 1132693957382333513915289271740897664044771913953733\
19491489444963483989664786832381957802110214726090505145756422630503185020471\
10827278214505737212281671312806554786208012240469410934643243780559553263747\
40953191639024513493080825955578694784225842441984256670327318001456462313043\
96879113832988425892794385814093339058993055496297696422368088514244646447830\
82092524403087566893767526156524341124821241682363555432658205408561860557914\
65687793121827659284518401657571744046851463451017139129210874668212983346048\
99625306944239856162013886223722942331186997575879773067397049033855171602460\
96495583225358497872225899172229901558064128495775363628200846316426385772067\
79636765344433791647282644109881754671259962991437244268571411475453848405756\
89859090686178980457466647479661328023688525179501758397543070191167036900720\
43451447513836324879881889806869199143089672170006964203124494335147588769610\
79292104807832024873527373512037663661850960705750971922046261354494999778925\
97514356462163342150321999542025472651732110154060000837902198174217742916825\
46889730887319349595420347791272933499728513863555112681922869169309086771994\
31919535929381809509256188323798884777499200874809809890173897365248826274346\
11805213227863974126786273495907940031981366009778991923539467281758676123834\
45019106697891839578472448000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000*tailpot*Log[v]))/392431870370387370787258\
47128995706332540468318876147785878632832756127698700552337060982230829564508\
56841372729565304592725415435547476947416767377363172348542051209564609483436\
55116993270148979166651124406364851707459988089850399295408385997902558828836\
69447847769746217667173381384035003021761582883879623879090746977150991617317\
49324941803139623216888328799788947624190850910405280705864822290777001478456\
26098559573662539051890557249147565692612759607377989958533601411993805840241\
52605232943647627037838576047825001742930866519712340517998554137782738535321\
86582106169674249786681525298015425228164906173480634970793392373317971832928\
52980844429924323652175761334168791369442155769513105903779581448986955865066\
03652409961122709965572428743791469092404460141498832771235917197400855533541\
88329434825699644657303314477409439938581595737146191542841860866463365298831\
93304964781081504711135799630467559222939800851313864889429996490034370235383\
33609288316555416274618707068464207639948165219695170751002487855232552301429\
99903842212056486534579060446697294017833466496589488695833452213116147041547\
60404009553102625453751228172597908443801314744810030944320699955912122816310\
98653467533750801046352462538446421550099468476717207169708502314337568741306\
27063662944339247778449458845492183040000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000 + 
 (v^536*((4371702813639793106661243320347844833792271598030679274965683420707\
75775536855755106721627310836685737659324710027595008665957657324585157495955\
07533388170164657325179573411167125388802458759116758408995161984792451789100\
22859580319947026310883159361437626740762728134845066131242541742683913518557\
86416688253379945796568874176616856394861908153907832098015720777269955477487\
21185803302564143510946301544088834034867202655740613941777778129484423596908\
73294461801370859097434024701726879653782762823296216226861894789746503175412\
60863644535830549891561796206648720868386521806131622750092305706085441150135\
87771589560474675453324803438324798836211996999470062653203539435887957455666\
47415340406214264862974798605122297761407983428562715283649246166376405520002\
21901521046127632283158833615760372543435813415474736266050193026872844695110\
73552072578500694865015411828030789203202578718666723367636425102324154280353\
61406270885493762304819006325373163326214002272880835548884658261616056401932\
69312468363315269009400388139248999178670513867142132194157413705674164658812\
30806020382514147449774231961356745900568790805951776500057747292676234887564\
92302655490112760889983005650204892863912468927633154807371454628075473388383\
06955311329620098166306724477055183102322645446990701486182193269897406133751\
25933458788138799001090441740946771241703374378073807392112414288253622595210\
807856552004010755603669979219296070465725440645600030624*mem)/5 + 
    2730100132613311807194254316096940807501795915526725679210250222112777867\
75118937404795654666241333034842147504918692512077196773206868630352599686067\
40170058077234204463885536962795923850869472444594551388864610837574416947517\
36253982747526145545557962890370617969892919063568115234375*
     (-7302983240959389169674818324209662490255057868674926272482589716237297\
26383782239471533007256831961958158619286523140156834558616671887704001324130\
96347648635290781807707546342978827704438954499085334242650503310768399994573\
24940061339391962309197567387884606832777711827608823314596353377649986369868\
44825416314139922926960903348027696718058160771485276384491767428617226335458\
74790931664404311664494155708634469195691129171408103625209574608379671534594\
27779416024922211642488505673743578072555014731042909393209219875449455847316\
72382465070525703461238325781684669861615142261671733885167598764646499384673\
09004462254308412540735056130844184329448267332903375566687251350081884891080\
86762860684663036585460167064210460020958356650901302129614539171303297730778\
41962971320613140296968344424005807765655199448180268675251713547614900942436\
48768127937700612514988507401642378391659970146919499747128936072739758407268\
41690825568627059697900441094026386301648937780085783344448732925744376862157\
10410427195106776768455942939784816243901537504231118499643310463789610581316\
05403339198238009899510134734034710300000*cM*mem - 
      tailpot*(96093946537246784805234393437862493591170171724781974251800621\
54339687543193533148544525361129363893057830118557448143451764168937667442741\
42878706045552527006219198280601763158796525997041540986881318410503877986849\
12799092761626197903003664251404990957564463082390879813345211271754664387451\
56657283158406109559622353063756527444901531128915995303069473163771668296953\
70623657787183843805882641563359144400782690007664614667558728929472788001434\
47164715976274051873694656158696071648150966089445093658612814894791330680389\
28781848172774635982499269144090133821108998891404411946631355846173267791596\
35169620010226211763131910493362395321754995436680275136724871519207775941204\
41653929998956611386977060662868078035649484031003098435439377178987884645926\
43426666231898074808016876060511704027536889834604809707350947938731488778193\
34675299152382538149570204916887610042161149499320547559733468611799602818926\
48851158123094065135575192839384519639399826494235465891841451402788872643379\
45385455871217451252473988476591666977736991105689104508204007473502200571533\
5504982885047115734895543652007563340183526839469339 + 6179935978896322674579\
07786034098278535314651777219471685254139793212700531756741067426409682795684\
00450021313821323768602884143499867954615175765265254291033560743099626431011\
07868576112508805934455531081948869229579503805277223699178311969843952650136\
00034434154653435686561787688825973147404333397168055646666413655811100624033\
32719169655384087230494477265833427936003553219958403412312699536340358076519\
67449105062364825599831373119337349753581325307736548122662118054131811485545\
91065386524427905187739165986577940177854939535021512730217252901334854472121\
84336802961443892105203789714427529328034560545820726596140495480523005698425\
09741966071730735604242094449666648381608819926220947059536659849281271469192\
20008135541968782007691106710529350849054374555026827179990970048419682429694\
51758033856479521322985554719120148104402564837592533548092873508704161550603\
29081587473480313262961548564696113623614875866253077855256614506385407891593\
89022145399335002262508375249269555745798963605605394461570843549238358642579\
26135846294427841418893255491960697197882223268856392623167920764499218314458\
057705116085760000*Pi^2 + 874179383440844882153300088839172865206509696054553\
02349526355208578816526890367083560935600237829849779295916902783170923570101\
28503986985648824851835316009209673807864596222973808040331892131711003593948\
35983105557536351421954039031977813621881728256112396091749906155923601559722\
81276762202933414788551804140089878605012861879835114588574075881673777380206\
17922390521293520925532863585627328036658589050149724620987504250218937157710\
12207071817831679804357872060361272921011725041881041477541070989080444366704\
29238031383716787061714668192990560179722777409020160267357227999583460898092\
99715355093529280916331249731150558876899177087466718996031886123097081073029\
75795282501706330056342965565769892241337356373708801623725363491259484800576\
26356118723165781279018492467330481918275898273236068744097326641093933765559\
92140738387053567844459335949103854548637740643847261932126557060944158115922\
33888071169053416481701951096034917722440153360611103823528746680185066709462\
30355599865312405441667963735157472103802605096064985704431972256161279616391\
74169297171771975160026361567231951880173616929073430528000*Log[2])) - 
    2398480230209617023985826928938540506269216515662781989314252503745713253\
15604123502913354481384085602541379410177423597301886853380300919191833396084\
44885479498580977653924004973883225854776002932903846860199631052245809690286\
91423011959861867917279141084587599304886776223390592565599597012347149397625\
53239742766540296989211413793450606646485816586207620122115700045319353902527\
38411189673857922649048584354471607020089742202292480313274768703484745244160\
33875699185301903270010001887426303045847309112511940045991419683694209001128\
27892119714852376770005501718637717032819973742722659068880845752985043957580\
77668452761190784238580168603764366747879193147721361468660132054704886443760\
12227587515825637975965425920752719023932227338205273500614505828324623092756\
85194260421436289644449237131605810329884234554187962885496253234165103342324\
64170721686919690883456036624621061064864076760147858066043446619828442498744\
02109022638934763784220035199475689668576109218426149222625951127863404423239\
61573250544508707981084443201711979860745582819148700440296027934835986213094\
00678981718066333254107416088113487965936148898208182760725666832002315678871\
33091238195594163212778303967199414595197680505164601451085647762321760548039\
36421081301027885136336559336313396852634955189978412511012336380437180553625\
60000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000*tailpot*Log[v]))/51869657531186460933314445167315785395360591706969\
95570442167925763804346797760952782298567632976829832636402262563799408145624\
23019447845109801861279726664024276707102926234843926718110537875907458046838\
03471530339513417744746234218908540979969131752202488722523893732911907201346\
43612303278184647988371037653386895556114493611722568422018481814131868168949\
32057940579685698211577272607276381104207172452375352188684293235497135093647\
02487585152634454378067086925138116244278065876052083117607201401510965411392\
49932634403921915169029417397039092338262545321208132214364379491531475281307\
59356811529569217327142187930227967614719896581721059006140529752894775273930\
96225837888253792678994166349517804731766408545944571285807606380255878637593\
06082655786194751660786125108742587002082809908880817157328376906913210720691\
12675557306230455154556644513385225944888072046491073509898754696431722983956\
74210446502912496479637651748111416118498889290794367602786299703131043372203\
23931270547846862927898090105249438553687691577116213705793985475567926585887\
44939252073000332772402222470102518673302046650433644114463787851687468860751\
03678990964357770096783076648115840437145769889661391131930209723171695515702\
51054461204436632394395810559774527284654930338116120309560908632088151135213\
92588423168000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000 + 
 (v^530*(27382328781274636453439195509661116801729831808422077485603100348860\
45630451785329882366041798148215088795463091966840125514471812546660037630352\
86326401585776384390687855644135178218102061912237046833070083279540897548417\
67166729141214491791869632225367544514452206589195232751177861720504086293318\
75731355115629226306149917008088761875763639742800909422171065280764496175052\
82859862729636561698720185802721140426061478640048079803357483904818587269557\
76161154616588561718849973240447087635955684765592236244661057975607245542039\
46774731782115991615262623025802242190110421632989222383428232397917982986046\
21516755205045973464450499453696765634921318524722865065221943955463187275794\
43546260916761155401829424821103711156586544519733095451470674964364216269447\
92530733509257854246384579838414764137427940335364197462968955222344893911668\
4366807839399728184819712*mem + 682657887136150655745766776445243079911845004\
05009054947299552797581923082490066786433866696720972865460348332634665801780\
28366198539671972533782387248560201534707764945002448813555423065009872273349\
87627720226759144591405407843953985254401729810679492965973080013008600124582\
41759828335222883472963836037121242134035760017620432557480193129088102314086\
84514551941588540043160723965070962564176971307285102980062311413534790984859\
78628087839994624257080735191829304633748645383378561830778917901929477074002\
11971484828702167192006555261945898784152516443471639842248231983806640953176\
50876028936025314611799847424304699643443689378844994221398281416802071692789\
21952091388899048525996239360873355686139498114270100470925954073307568916696\
39178990973541845459342787267668621230720382461939060498019951015158506018513\
485279909367856551165952000000*cM*mem + 2830137897362782741180532347268619122\
04609050685244790022220525077819624383807087109321803771938985299134254667197\
78422110622418181010494330339003580121919029026345416941558578348374350725705\
73395123093207827586026381303269147321712540558480707323346811405416397182827\
78648361110877243776345893514582747464750662665242849004408587188403979091292\
41731748139851707202909412880119372114850045527576283790294324133117452497276\
15286149483999309608534427954224603932424279939956694783164220025913264460163\
11869123471879511200976222868306948467044256461754122602708742049171668145414\
42556417949733240828560382391136263339725086307995370341076834160569817255812\
01122541283234408940415177434157815390765171478858854090914526045814217924534\
73132801118750356062384587241395887311417668784111742499448942951506500127857\
1020528262554760236604110505035279450066989*tailpot - 
    2774409963002685172349766955267735303670553454484007041898668736591829200\
00353101197826310404113640365483733713389154331137443760743184985657490488144\
44072007035189640999901736607181123590825676558862798029359561480332451029215\
90383506853913308115537484445879924027590025520826807716507492610057366000456\
83442180210991806012153348883633528727858360490655806926201444997389810196122\
10663973430519758413046972295770738156509014785871138679695552534480454988770\
98600496168286606399921607885878067029985774768867246133194051965684481806436\
32223455765404633327198268356629179997404010525208543062339345647027499328146\
26208995913743540645966417982638226310691407702875432378162929579365625018431\
99386737255868867656614519454195407047089486592602790549798844360669113901381\
10463259320633478049452188616491452348906956079703260535929816458464124888871\
4652648983539968750*Pi^2*tailpot - 503756004022720477576067558917836195343068\
41008289489284938943047428016403582332209296488251021964657323463342693560921\
17536074269085853947051737915949825037564971656626401600392878539464088229551\
44960986413830309401762431362992611091634707951653810666773543131698297794878\
24830210112461717972545298476149525669837724050378761186881705217794891439161\
02675924540899866588554853968077904918556766852144112557854581469967637158328\
53012116262077895796855373527722811151324173844018587327488255168844281874330\
14624928471371342290768380740519583024916354075807097326185591669156095074254\
45251567999958812280624190691560539838196233906007031857949804192826080316848\
52907340091843761727929145103688150104490161832168325786985821122475716422444\
01031907453075441736982258173291006355418322163003342377463717719907188259000\
8063682965724527200034325691904000*tailpot*Log[2] - 
    5037560040227204775760675589178361953430684100828948928493894304742801640\
35823322092964882510219646573234633426935609211753607426908585394705173791594\
98250375649716566264016003928785394640882295514496098641383030940176243136299\
26110916347079516538106667735431316982977948782483021011246171797254529847614\
95256698377240503787611868817052177948914391610267592454089986658855485396807\
79049185567668521441125578545814699676371583285301211626207789579685537352772\
28111513241738440185873274882551688442818743301462492847137134229076838074051\
95830249163540758070973261855916691560950742544525156799995881228062419069156\
05398381962339060070318579498041928260803168485290734009184376172792914510368\
81501044901618321683257869858211224757164224440103190745307544173698225817329\
10063554183221630033423774637177199071882590008063682965724527200034325691904\
000*tailpot*Log[v]))/12952268333987405203248864247023067480095403959121207844\
76719517122626581607835369115903452489632981655889116667129758171154999563244\
83039909470294298106267993870054780388508197410924141625437673750264878450066\
36629976757455590111980661936306443088532525227858337084954386177459618820213\
28171402402688135979435643445140254648673159884391128478800617108218524790309\
97187022199779798929106784247490385048865766217897798297673393292037509504266\
65253765316232345274621218118482090412432070117709463878042381890919756750854\
80850159909771373652800368752912009559409262836048370148385179340790141302105\
99471607092674329854047348210366921556749580288738236691582428419390285448635\
83985529772604479623520092254905396619280897826604977833667032471299196230591\
82286817085142159778661249147897650863970207900015354177316646697105993073440\
3570892800000000 + 
 (v^526*((2589882160731930536046617486065148235482868013193211524304199500993\
38016874593207080647533542845569382586788026244889666424557216856571962360812\
55148987628014000309057238117789822738145790671526116884062628042226374523515\
09459897857903120762382782836797560236545252728006143540133365701898324748276\
79019296563169084213537722176669542957191641280668098726373350884187080729159\
17189436040279767649450141161118757194977655081827744126695341884205946497509\
71069621474787949808867629817221119389051541246966912793597185214692228720705\
18683469609230968186795343595201135009606435853056839299215141398508208491350\
10436765259819406757884436093800922792485312263435684782004001091639004716245\
53590039896584322040115249219010029008082169608145513548704894449661704280644\
69842184928960935267313626728262734012346594757775267752988850745070790816077\
1154481213965601337245696*mem)/5 - 
    53*(-32114190098803505276343732534310167550018928728155476311607611723743\
85303724335998004262726129849170143007020812658590473872086636329541973358812\
33474083387313095499604144567232942970380871584984356627763008057516909512415\
79216747869781701058060272592832697587924977062072709427979601249910479531861\
78557790860327151582341190484024350851127641749695638053486822900237928099296\
25534841815532838837562842339610270794610729268084213177846125001502960304001\
20919969966476284982202004175425487003765926995330239052304447362146501161136\
52683911721201418448090288236039013558549229035740634562566043669551889485480\
06083157650003647788715936615195852592021537252944997381044501230775143586914\
24789785821359896575364106108122737182450858716025651309728708666248882947788\
92036243671307137496611456022964003283707725882410772630690259787785818865664\
0000*cM*mem + tailpot*(-13148020137287784200766719321478971907386048739478286\
87330606959425650305190301084341837865886532534226188270400327152497269977748\
69039357099791544746056630522454067151712013955355631365045404570846960390156\
38144554415593898304595004275784075546555057517293388384106050857057884296555\
82124141924118552020407804360419592152618658637761060212400548831423281145791\
99710127402823789911755211832888386840094001649201973168715574970814859403012\
32852336378931882859353741304438296241372307259810208316706261450194511792649\
91497893668602056964543669988151991326416913941630825981253511943853498905281\
22765386643378199979880558345734370830195869051635887738013690272751224493872\
16589991099907752776272430568101118206706447642685774591854551020877083560839\
47268033666961827188507611815916950555209581453815238141050797103444363251739\
139333009359803445670273 + 99022613592290483318093622188080637397156551860668\
69137140422961501535773953569533284865581134512460024579165530408885034801271\
20030276548024354847913834943755759162132287589444337977033836908605631123133\
04771297634353870017425443487138660262726912588328115268562728571820160693202\
68633896514490083018431097414590585217246161431177874924549576215472666628014\
23558525257188330660801953047494081111147553366245343763886790886145743146620\
03898750769972000327922730299596713646345126122210845510266525401782810045688\
75137434600542561779493970539511310231917332863305252097942583462544224550865\
07160887813655945011071199995146528062347930377065583486219955831485127955907\
31617665477572839253010839964311197998547183285202072242139070572589225607674\
64823242461868796713973190045314431761445179379367063618471997488979380552081\
93830811653354257530985519569174068750*Pi^2 + 2362592999108473356745630315026\
02777600339522846932783965840741037597129746217873746009103293933750360338938\
27724059643283166047845151482591812761860821827531782749910666040923889149750\
79107863013299737724941661763511568215710756109430372155207278517860007057001\
73400829822544988824030788580886731875224475986839162131741508110265998745505\
52529649564595801118204886779563187251198939304660296841290189214702190613872\
12131801272540160063378342541369385222636721416176337967893878555762951741034\
17199045495122670741435162247035060729742970941081360518048131200419894351931\
88943448716351877586242895905832434885913065700440945364702693294863529305670\
12788409932085460631995750867520929640062338037418416573882112743431711079210\
59199711792956430102423459182090426422423217107971081064189950224841047944749\
464967225050905746624757337130202465587200*Log[2])) - 
    1252174289527490879075184066963794721281799471088743755018955927499264787\
65495473085384824745784887690979637286937516109400780053579302857736607637862\
35568591844857452653001689661249367919271673970488609942190807346611311543267\
00737998097242259857614465803740210919024398059488440767363179478699678938689\
72273024755929822999298440979335117928407142692357745926485899931684892431354\
37831469957325883800283792161025352224298546744462848335905215469257741679974\
62350573459122983755634554364422748111154941124150154929606359909285821867637\
74598773121074565509536222544006523901400278196664951207087348300911904895339\
24821233701043292427446277670532005167778572640052941349577479597860927092330\
39159831760784157519754018806871981613758472502669079542844333665079260038843\
05067224672964020673619165755410717216432629276980045711121388679007306761216\
00*tailpot*Log[v]))/323806708349685130081221606175576687002385098978030196119\
17987928065664540195884227897586312240824541397227916678243954278874989081120\
75997736757357452656699846751369509712704935273103540635941843756621961251659\
15749418936389752799516548407661077213313130696458427123859654436490470505332\
04285060067203399485891086128506366216828997109778211970015427705463119757749\
29675554994494973227669606187259626221644155447444957441834832300937737606666\
31344132905808631865530452962052260310801752942736596951059547272993918771370\
21253997744284341320009218822800238985231570901209253709629483519753532552649\
86790177316858246351183705259173038918739507218455917289560710484757136215895\
99638244315111990588002306372634915482022445665124445841675811782479905764795\
57170427128553994466531228697441271599255197500383854432916167427649826836008\
9272320000000 + (v^528*(18045190134395183431079451539079098708701226377358377\
86952458203252983021024387502426283751375727304771650480588541463465644629188\
98450162815171125402596106435573203382010914275670472915872235529533896508802\
48051968061844250972605968573102168551782440207310858453268697948816333899881\
49964131450530316291697332483408825519446193996553207408197735636579654399414\
84206041774367928711436681969807413118611288800693582132896008782852540278491\
95260293971328928751562784247640611848751859679584680757786009606426429381462\
66472322540935017150245004069429895501672573353738172344794490441979379117154\
30646213722617960887545958625668923820657637518703225113470432253854654753557\
95838947706206596521750974145541164742637164248198883961089480782620931672418\
82330724752560628256050855897718415932859853888576056736976539318658544356577\
58465798188269838859961370964807122944*mem - 
    7*(-737814713685310076285962635745483795019748011158207174813467733346949\
81928403222032859420980519737151760643920723917171018111139437953463950065559\
05169889936291393552042991591881456150313002363791945369961363237740584291007\
27832103837472967366134620453448729252195356656798297264818035667056884113786\
87322564345253648858136028135437400828742834390515153157489570413865072527540\
69893352283636637882492232700291090295516217684388946747934453753441471840082\
10847746786586305239292923403352656261310797755815635023121035405890356721715\
09030023344568145910571467678327663193280353893834756857933678394486509099321\
81532017426822161533106145720277546626983289592437019611943961895186431621969\
01243073197327615832929940116283207718114760187094754787582437495240837833522\
65741034523502642786913946792643900125448049000326246533442749868606593433600\
000*cM*mem + tailpot*(-303973837538292339643644617658664240763728914013428200\
31841149517698079179995932050883817009950088160765528411184918734022643327567\
45584848769454996269169493115443084021361808091890114491697244234782412987294\
76288400335132437217471361563931265041864555623634427526094515403435005322368\
19300876155509885468610315110913176412254443531292142827414852027006372894633\
78117656220528356297339699241919032439075830245040008332231778315608870671297\
58650342994626842798705872002956984981152182866665037766424242390507797488928\
25304317837456552158124025162665889356247259627696907743523139308028914061785\
86285580563709814987581304198203263947672946674830470288560404632124229942846\
10572761718558551496191992771954730836467361625191068983745994129846677748323\
02355140838088995887474943899803157766714285923192836481445573493303677066961\
78232478518552980267209 + 261194289066881679066763728405004273809050980938993\
42245349093635096979454716742103594542221023337623137631672014225683579973400\
07368652176506583051941020223820957204352499385241141945797740312713341389149\
96794292950478831412995422203418010369833086911303220719400894404077090304085\
02233165044272597372776155898324373714022181356668136372411961759437220386537\
22105876204737991311250461850626071851893493005574507933172714556600821891073\
21130749731866480750379011705760475520880187131652369313967556423445214894328\
45586274726991012503609264783778905453345446992329110423074100672762393017233\
67002022449136509224214522779793709535825654547287491253517242306387774026024\
84759740548251366464489501067861044003078478604729407375584729755594917328725\
70346814832804774614619404832070995795274847271852534459200979925439889712060\
87643792757861127877806061681623234375*Pi^2 + 5436295907060452395131975928379\
77562492861860384751468497533538433278926664480968942812164730923290320249156\
12861307546352042053936892576229191595842747016508932087016702443875027220782\
88644212914626539385868239077108843672906163407930592563995834640087367108039\
71646849638409726257385474959436193633455607011181800898065459800267462484558\
26958760587273927499125131050094293520526790518441775916585781445526840772093\
65653857072275876219743690247042239639688932547161498113966973506227425806465\
32830494984997187600509983755265454504402160246114590470924329064952997933027\
79285864657810833255814079836165127315532367230774407602370020701431760994346\
18851303118732074530956287074387628818181960022373986234985712884589506629180\
03258895143510421129745512244261278955766864376673037658010717212559542646571\
302629115392617580030475281439391944192000*Log[2])) - 
    3805407134942316676592383149865842937450033022693260279482734769032952486\
65136678259968515311646303224174409290029152824464294377558248033604341170899\
22911556252460911691710712519054548020509490402385775701077673539761905710343\
14385551414794797084248061156975627801527947468868083801698324716053355434189\
24907827260628645821860187223739190788711324110917492493875917350660054643687\
53362909243141610047011868788540465559576999505931133538205831729295677477822\
52783013048679776881454359198064525729813464894980313203569886286858181530815\
12172280213329647030345467098553119455001052604675832790698558853155891208726\
57061542085321659014491002232696042331959121831124521716694009520713401727273\
72015661790364489999019212654640426022812266004572947908218585709828952690368\
05063671126360607502048791679852599911840380774832306021332697007574360934400\
0*tailpot*Log[v]))/9812324495445003941855200187138687484920760575091824124823\
63270547444380005935885693866251886085592163552361111461938008450757244882447\
27204144162347050203025659132409385233482887063743655634601325958241250050277\
49982392011810690894440860838214461009488808983588700723019831408802136525213\
41971517187981802602760185712314127782696882114491271818649324407973325992402\
93198636196817370535442611735140188534671377195301740661661584876901139595948\
89216148660867632288801604910674554872780392204139301547259008272542993071824\
62242355887404282424521782509098151067623360642704657867560106659197956140905\
08793252026007465187385007853728452083015370256239917865476075295670794421090\
79946797427636078424312314322270166121892292882558964899267023711512295902896\
11225064501636195955491778710341563613793863647995588876247497807570510182088\
70400000000 + (v^524*(1224238888427098121430052003088521478385339728089464191\
06521800691845440946619214086809797852545783573360878347103086848465316372642\
71730557364885607277983603089288287142694245425724317855238540228005445819674\
67795280918172750611620397630077189827146595672315446787963693290436061338092\
31474587590323523386412357779649145066682034099431229687004943417300207228944\
76790845190483787928067153340122254748031193259096060161841180796602300773361\
51158490710033729140219340238451446421615311268470132200781479722428664008623\
41936617097022837029453460087215965922963053688501149610704348912458978018033\
74362020780825776003685322885363101222433776345629629866560085866571204636847\
87248568478560786731569180684566764889084613645779936417925258757845009847419\
87036463631797403769658175363756785443878995301907071895876683921222350311090\
782995392420283055913328471091183616*mem + 4618872089258270681522032151861992\
02722502869911485734266227395405842906210044393146705815133631272049264292650\
89016979090140158743848128755288054840963758979740039853884232975900548944508\
94148147748338351428669394085048338106776224301161573707424613066123430019435\
28695390012710186737312493034614474436190460987824250090555168165591378072412\
58982790993013030292850924998275239690161253456208572820740117106670825389550\
69847454077522935184953405174138548069964975909890158545572886433025958718062\
98210921472835710281698577054160585148123474946995860183355017539388243524217\
73907702196209146713817754012021108657253996991123262302175764593045875763988\
99294385761662184561060829234389228448646026227901102135433062958802947939367\
42971052242966230170755446772221913705418423261774577481849374631131676827640\
983154238681979052895162161168384000000*cM*mem + 1879160276136954252760861255\
56848746629491463380510177334116373154535102565473531447728742359934739873755\
11676062761551238356236092810457425072508178640223598703283713792316631108127\
71377115883241073169836849864546133753544142915183320728754236054545125740432\
99950561811838252640095669600432748038090995631121098720413643406024317350345\
04148740655196163446233635044943044631652500466509289851890305308483641981404\
06047396181306197997520058760583604782218925971572977722041912906444348064583\
38005230899375539879147905573891739340110289332962327312458320641076593014011\
77034479515082801321853092795862895472183286801383376895382016681223813061655\
04939568235685961594244297542648156633499570422384503256376838276803520251305\
27042795070122893337149956746444973533018324105904442731410052336337785531639\
14793103000599921316787518955402957244636031705122*tailpot - 
    1240413332364325073897686476208046950783321226354144913874972616393131186\
96643726620388835718052803971188563642538396931685977367721860448846762236327\
88753571436864371053995709504990612613331419386330346056983268791635459443711\
10637050621163052618353972914748939745349007465070102830456759103570417517319\
65663519855046365021872662870160637972628898385243918963456045433363017970927\
59448238430953996703530585745553845027909734823058091713398751683550379290533\
49727666070344484373324165582202925154417579817489990257871658691787899139864\
10551157581633623086109195263763526747658691602701822172051419495767708625374\
68429989767453006181354992988900366493545122523894034222033576075040283848169\
40378338837626308311972563941772619117514859267795112706871692271598334447894\
41243228340283906092591908872982424453204226310774047157776808620710838013063\
03780101018828125*Pi^2*tailpot - 33928255300642362672142243808362956200298323\
00387233479575939266044081802123632105797423468964521815506007413849062972872\
29307655911950998252974056904398455048635099759633538234006442803880115980811\
03527428170622665225749304006305351146217679717978736037336428224473661454984\
72798787351239943330391800125753631116712957359917298319436733053664293218210\
45515879196298317078452090738377852466001478079453951738166428877106893001637\
05471817346030700780500388995768981351384852841622738650400653976758840492492\
70858377575975700944532936890795328653583045898788956652900821567562263934611\
02814696453082513178414695814726628070306407565437307908567717788184552508481\
49926894128656772286316386698732351466601098772713596218547831710611108544805\
55198415667979912150892401182698064181336622432250139444943623528005034085530\
905163214164059999287158784000*tailpot*Log[2] - 33928255300642362672142243808\
36295620029832300387233479575939266044081802123632105797423468964521815506007\
41384906297287229307655911950998252974056904398455048635099759633538234006442\
80388011598081103527428170622665225749304006305351146217679717978736037336428\
22447366145498472798787351239943330391800125753631116712957359917298319436733\
05366429321821045515879196298317078452090738377852466001478079453951738166428\
87710689300163705471817346030700780500388995768981351384852841622738650400653\
97675884049249270858377575975700944532936890795328653583045898788956652900821\
56756226393461102814696453082513178414695814726628070306407565437307908567717\
78818455250848149926894128656772286316386698732351466601098772713596218547831\
71061110854480555198415667979912150892401182698064181336622432250139444943623\
528005034085530905163214164059999287158784000*tailpot*Log[v]))/87990953355892\
69839163630602597192581586551602663864024977714110887408842444533757580865845\
71761536451011628170604455279317255138073933695037162325394743668436617219975\
46540894980247378821628854449908205468795085801472537062432825955583806429640\
54709595942838544215322273218382893220253588120940235653097686383447317528903\
86326874921461364455706940970257149993417100455313857199720985779784290016202\
77762069441506656452223772616873308087137671560905680926258659111536130992462\
04097873721270016221496183349809617357917668819021126164223184785113810543543\
20250857904924164502979062052167215558495920323417749146262595430354689992673\
61922269217892823839390236697955356962388478162566389976084398913670209955140\
07663653414813164289175973146263040917521618796311719715759365905225189522084\
6737106514946695256611185237575135399010893824000000000 + 
 (v^520*(10939712098742346206312654072966646158953199213868919382657586588747\
33808646054458701474824318298312350538562774377108685701983968731730972504934\
51602702688153134381010584264643411599763868680871104606104927143359396756275\
97074718779817050172511554089276855139067067495307132879165441884481575086762\
41820539648318687721746466097934577049646452032860746459019769816653463971040\
94826692845066063641711861632597162046599848776581651708204390871411122608232\
76590421776431956842921087318312634557395303545557537004157475945283297418917\
19837953454364792162049160462456784361884601152852164382527607250817845479216\
66721749950602730082894406805568707616312784024409721803207715104570866182037\
44835028157980967355579113530136057312524196224889516556717823516032030489132\
14034909398593041180073322315103173848946831469036198822654652302808583326552\
0834410172892839936*mem - 7*(-77745641156786411145444550873898040346237277317\
66217672422495607147967604715648806434215175006379608947674108182169653339492\
47457539455604525487137752223309283981270603619159274852923758601187013985641\
80092030856838567434483609768641554446888790945157755926857600074721172685671\
33841252012063894890331579450425953779111100962848362001592239003646664269463\
97937440758063462561831529952318524251212011415165037692168200521249555102247\
95703642855468974772372437206251726606387174591339612378507274119580922132940\
08813462284196994183459592454472389769709081100257182937834734672168864043319\
23433443579786629512057320879466316447610829773037651800213253930849767344892\
51092627038051534411584207522256485783647590838347655877602977294819204281282\
69238045680543648302239379301166100291976969353223097657530501644127984801370\
372157359521792000000*cM*mem + tailpot*(-312322065167046350870177043783376597\
25694747743073975026307673099438285257603811606930202230420263297384126075443\
02663617916652758266194592831845297914410032880285373993906226990453064790514\
75708400262325724861526656912385099497719211918193012719466914143243250066230\
61223733695215810879292269850663458152631279661335879528089489160755650091803\
13486145425186760519268202641566683246610950132429657923238825847222742104570\
02636141269437956956395936128724298759695928317976756508542788642978447450263\
20772700198144383927119335026617008740645190663142573188822639452411550026055\
93437643782581194342160078960687242558233076443132694604308076979714432816976\
62760149143357504450939077550451795500217453056806783939156386522281589748903\
55298940084187017580959879900964620660850001969021793286870879501668090822679\
1816867940456113434037434923319962691 + 1583463683644570145110910568908762631\
89075869242724181785202985272769435652489120622731731190881035397146805466872\
50019307758479553360384550714446956874316104379072979057147284312782620029529\
64695646520059217221096599272566521519763316448323318141909058864715333654065\
16718350661578163045976691083166855038468987790260075148715595433859109198418\
68042442145595696019541629306680725997757187907997527174708228396033182622281\
72169574205692673373449938645871227665202636014626627548329265922676211134471\
37683227912832773671051762941086466408899718130759975140082122155049346444477\
16232417447942369564851244383014597816776495873572375997956738715778559342848\
37234978006800553866499600639813226357106894251240012210469470306327241906221\
59257664308148474057460428404402547370941904130777576972679896007741366038860\
024564431361290360933555739526523957352471718750*Pi^2 + 
        569326426089723962556119064005439997028381868481981736053997629908890\
71418932572757964215911353228819712739032992152065128675304050182255293671252\
46096921371199360164270950267929910564230761751106497050074731910891558975696\
48145975374702251442198086638879486831084755274623146855298289254700746127979\
51625654123613998596234037292885689411568488528364065899223450709845740032213\
30877209895012615875690081164328816437508678589414484386345335721287613907782\
90522639427015623844762437516600774219518646827163601360177465075907374202916\
36659460803019216538747769147951515626229396910482423881851537987242387492437\
38567183535788724283076555456087419176207306865139019872252800595559373603175\
74897880979102516637141632441353452191701615721528414170708374948009545498063\
61489610600151975047949573032350215824896092076722074551284488800328942592000*
         Log[2])) - 398528498262806773789283344803807997919867307937387215237\
79834093622349993252800930574951137947260173798917323094506445590072712835127\
57870556987672267844959839552114989665187550937394961533225774547935052312337\
62409128298753702182762291576009538660647215640781759328692236202798708802478\
29052228958566137957886529799017363826105019982588097941969854846129456415496\
89201802254931614046926508831112983056815030171506256075012590139070441735004\
90132973544803365847598910936691333706261620541953663052779014520952124225553\
13516194204145661622562113451577123438403566060938360577837337696717296076591\
06967124470616997028475052106998153588819261193423345114805597313910576960416\
89156152222302428516685371761645999142708947416534191131005069889919495862463\
60668184864453042727420106382533564701122645151077427264453705452185899142160\
2302598144000*tailpot*Log[v]))/1039590658741643411999483766847494397635462145\
87238469104179041952828554376707629461021571901200559599599672515430583090656\
57551253236456699399365848236574532568728969464383376060993310352271840081510\
89384083117743401140560756531497584874839669666199148859031018929031459501226\
71233698648252846647396657581360863035415039034301379362176437199398268073045\
50448882527179292460505667781022918056356524134896274744979519902200351207097\
50804432155854925634226444454857177884345374078934058804497875262464104838115\
50299597325954856109713660481861827904188841483961585291224499586835900526012\
19465483174862044160552295162989489067698401153346203830091307164389205659021\
19056738994307213686081948067094915763350131617162529940313464589930998717658\
67685698506838330715024997156969579692692841265048566298377475492215483503751\
34144495616000000000 + 
 (v^522*((5031803756933291663263468368121402324614874505927187516144413609989\
73186579192429903283732055486277615422746733713718499044297935948329838053699\
26150615366644478875208230942434507470927651266064338043175339863701888814207\
80282797096192385998330609221072271786546873437122623239542532493005209488507\
99092200352471616344976331941411895882009949052468773406087780168744203008980\
07007852633724313997475649432885961400691437010945988647134320949634598577706\
46166973639624491755167708757311423243240545313334320637577038430394559365114\
42444785108138879008627173081494171773472897145923272369265196012629808542773\
19911481269940653027076016929664472702667290308784355063084471975142623001409\
96946301182525364052398493212977577662473471823735155870123625349469522273510\
12192666924116871536650567323571905438444507333673773880739579395256880063567\
38701406270111350784*mem)/5 - 
    5*(-871943833764238271731688318355150082560457885534392585194413901429187\
07977599136629335706292354943597820446690443468922285005588826633997152283207\
94805055379700674143427328626044121821299411741460263460484718621262825247962\
38694850283246132790790876546499067520410321841069949348387898238709295797590\
87899157906919059908447923286425341310586064020302722649393321640553139690634\
69783167744238653732485612229007460600565576143791682143238579370419967886575\
43154997083748890320932781490142320729131899322020793279730739037104869493549\
39918753543225955661861458802412174214101780259269471592620690067060922256277\
34817923369188193063335900127084316107467735405933469437612553741775367573997\
27748909523072231476708314435829033410213300463035095648545870145796399429080\
0166707364977207079171414704392716790684560492313624625384429921060782080000*
       cM*mem + tailpot*(-352509506927991788060265455421481675946827001109537\
37573165606453523642696305546371197003167931265732327100801919361307648071346\
18620064422519399306583858839037200866630528303011700691810916119320759014764\
47963019617381964269333681165680903455474542030137853742834441744323218834234\
03786011095202146450237542338630368051314509608263850800286544699398474226883\
79258772424479577671262249917749887035901983571774684855467046811164951344171\
12611146010412217002812048744825013906305528830403163683109653975163050335889\
32236860551341875106271693871542573554847845577492983361824527158865413676292\
75597355457780319985234810658313165484427789479905383108976615376881377216605\
06695912192456028318794297952273999717241839076284222520428260815768908395128\
92523654521943515660648330004158773017957490349651174351251078684839288403684\
4386425130057188615797 + 2039313250034129815579983776455487955657786904262964\
67509257561753228490245919512457431643781803724798954572773880793178851986928\
09140506574988246322592183593725977668622035201319736825341624570935999931330\
72668302213819317880178584631176570915063901899545773323866818587252849374833\
78046837017240405815383260195807336595012354360001193424988394415395069994581\
95406564467247914672635002840703814951813732338308287463999675090349853643779\
45187784512554643192960495327072148283016259889223019807003284615665538429441\
15694379612775522616243401539177348225288454879783986043234094101889765665104\
07290716051915016646922399574099565258990018000554354662975122511602425655306\
25321131202503150405863961073524709675276379789836332422645531550601906867849\
40833079117062676763539932745845703206227804520920423412274512940332922949470\
890411915403977558564844929487500*Pi^2 + 639506889021783286922351585797526343\
69620112261527174116327231417865206623713623236828401375299088614686116848721\
51861026246351348916777294752735121899778106397342368327685443030783459147948\
03098227208441512904509956197244045533615294007720367560651222819239332071212\
44093940961373348340662762644243208770311916650914013347399741651990664959258\
34869314859441773751249937212155061643714160807068476504342609163238216402697\
40027103529491960691188713407327507117835174222002070052547135174295550733742\
16699983136431845285502634993028715586513705032544704338084885306858024429822\
95940925917697081324118078657765578612607148728166439534541735973079923016162\
79208375240465912945348279087662096019735739646713250949578876802355793220674\
01537551266274077585829367446897923918444689608883863519567367948770909138427\
768108261184963678436646718300160*Log[2])) - 31975344451089164346117579289876\
31718481005613076358705816361570893260331185681161841420068764954430734305842\
43607593051312317567445838864737636756094988905319867118416384272151539172957\
39740154911360422075645225497809862202276680764700386018378032561140961966603\
56062204697048068667417033138132212160438515595832545700667369987082599533247\
96291743465742972088687562496860607753082185708040353423825217130458161910820\
13487001355176474598034559435670366375355891758711100103502627356758714777536\
68710834999156821592264275131749651435779325685251627235216904244265342901221\
49114797046295884854066205903932888278930630357436408321976727086798653996150\
80813960418762023295647267413954383104800986786982335662547478943840117789661\
03370076877563313703879291468372344896195922234480444193175978368397438545456\
92138840541305924818392183233591500800*tailpot*Log[v]))/831672526993314729599\
58701347799551810836971669790775283343233562262843501366103568817257520960447\
67967973801234446647252526041002589165359519492678589259626054983175571506700\
84879464828181747206520871507266494194720912448605225198067899871735732959319\
08722481514322516760098136986958918602277317917326065088690428332031227441103\
48974114975951861445843640359106021743433968404534224818334445085219307917019\
79598361592176028096567800643545724683940507381155563885742307476299263147247\
04359830020997128387049240239677860763884887770928385489462323351073187169268\
23297959966946872042080975572386539889635328441836130391591254158720922676963\
06407304573151136452721695245391195445770948865558453675932610680105293730023\
95225077167194479897412694148558805470664572019997725575663754154273012038853\
03870198039377238680300107315596492800000000 + 
 (v^518*(90946334692137790054796048134611795600847006737920894913012015425260\
80577857558752065019758702381077805233412313534176277566936286724929529003375\
86753421901353937679379059003864560554290291424476778444133104234416261031852\
68522137952444574537066786539417914726469210483707736766835823885711953103633\
15593442794998486582342288417274194276079564016545766456577877706049198102457\
33613857553208063374611496129311725768883585846776390863985553200466675824486\
50618494272116242552982061619089432700560093894945261379062747852079651222432\
52754617496285336533883514271869116492783650619571654554677087854936924671157\
59240720231949831532770384363240998949692627242227492433681384063676452929416\
86359355398727752990795017415595869014895258456107504116248888754175799668679\
12819316089585256684589788631076125315965331838084386804362471770360658285252\
215513993445376*mem + 5195714243285045377769242871132004943233211706016510983\
78407994248696029233871399856054147995866842789437166478252406345059589407765\
47750287348818860349174901502807261891328797305776876637874846054511125356308\
84411179541961850924870136484017596327014669359735284952817187472317942524315\
22620850642539876556908363420769283901121034117116988467770853158431329072404\
02332845911491709400972394131767024529045336248735103759104848814519313534319\
22539673840592511769524685914524051659440893946282715256919241769552246726712\
90942072399762007498509542794889338307990406492066292180637338147262788568402\
38449093231386298476601236453082130495071785841680352090789279222905126513295\
92015686148820227546078014526067776151820403149309618444279691008425667971151\
05586274176595493728783337619784501379300202664242470257651795071543830818009\
90720000000*cM*mem + 20739866373198177428086733197186013713780179007244215121\
62641757753306056862914620590949316217486226992609911894836332573484247011835\
11782856444373904275260631770803252780651597704395772585344288368689789298518\
77289832987662736705958224303518627639577048462843917398095717805652620397612\
29106739840065447866075311872327993219743562545404650272430275540410343111538\
30774174589390846700182642584485215524642610377615335426223094982742600089939\
75900321678927755636606480725700758674494540620759522603899994185694361257514\
18306559513215865225180764991064806202992246089749141714293370236538643499031\
71458404416479728567000778990837594390030904973265041730244061821156389582890\
02653586719041751547369682661301759047310099869910437879947099159147115496451\
52483980841133134955198499988784846948298984819149387050681018937953164622993\
921484735968973*tailpot - 921479027894170871838382029330340147052404531930795\
82528527617149178733736679896877255549142844192016464398427187765407328758111\
91635456013257749832331942934705234336905708070164342966157855121935130823612\
98349511653496369032342734405278911332672888474456238276921348588559540333731\
36494621198778201659084378379332228099629951598243287668319366402042815197084\
67122765770233289837979253872720901306897548919844182323678354268904578077526\
51382322615927785254867985501123668559504321050260081005776268405239497603328\
00361710522773749730154735630023624104966424543637771254507438629689501633258\
99265049139665914271942724157531065863350286698105319878569246253770305754625\
90686223300701441762390095653539269656450053653329092352413401934443173324131\
16663302587980149977375039913209233711722199396097108017329571697197942561258\
1196070591112668670897892187500*Pi^2*tailpot - 379888861604810726716549079362\
10432022447783623553595294945206466654179590917870715908774330340035064075167\
30559643405269757793513970536494706867892250375571028663475333999864283986271\
18409193705625527259328110866862879364145004789895012057814235309150953228103\
52258034680138488743701948202492380181719129252804881750689568451870859161968\
09993765619092843693990830322056695770147291355835086557200562212324975740719\
85825570247092766887624116295887796792416529851814004773263637679270971326279\
33548945296624748295688939770763627356780870078051192611566433632940478971239\
59036190579012166556417899702710227263055558844405956387256910170772602481717\
32919897310353965867809645901269222901540688724762281365012185915211924222704\
30585408289861771859517146656587260224580634264689016661698371978139791488140\
8674063748477778416496821773902848000*tailpot*Log[2] - 
    3798888616048107267165490793621043202244778362355359529494520646665417959\
09178707159087743303400350640751673055964340526975779351397053649470686789225\
03755710286634753339998642839862711840919370562552725932811086686287936414500\
47898950120578142353091509532281035225803468013848874370194820249238018171912\
92528048817506895684518708591619680999376561909284369399083032205669577014729\
13558350865572005622123249757407198582557024709276688762411629588779679241652\
98518140047732636376792709713262793354894529662474829568893977076362735678087\
00780511926115664336329404789712395903619057901216655641789970271022726305555\
88444059563872569101707726024817173291989731035396586780964590126922290154068\
87247622813650121859152119242227043058540828986177185951714665658726022458063\
42646890166616983719781397914881408674063748477778416496821773902848000*
     tailpot*Log[v]))/9938725226975558432117435629517154853111492790366966453\
55440171633160175685541390640741605174001525808792280262242668170712959010825\
66507642441356101688093045590143111514181415497067976599157170951346977445804\
75558328303640119803992207216440436579341767294751615000300760049968569187251\
26700254755226171905935593072801520404410892563828271504763557103685511365442\
36895721419748257944769771093274609320232072131735371913961292610874837899823\
69549958262203101862879329678254054291912608073593453752046891377777275296111\
46795947511602872675543287802952595448963530508838428172427347285011421174299\
70000422185012382055348843859449341810193153251350928913854738613969317087857\
96436077304798738691155982441205847200406595987700426289971307052186203221654\
57345417925669188881162329758057755880005413942423283864392767722288159129600\
0000000 + (v^516*((3627733688074182764521160601947312973631180422384261683131\
65437821153658404790785096872446558899631314751580995399233462702682221306648\
85840445431114865651417767746675039596875269754992329492576185712222293206223\
42153891075218800799329524441293829914496720457902759076425944432704259770767\
10451834732267694138672205928522923391665890274878234572656183258838126755127\
66727249808496327968535292701561966297705024428664667503452238209557652065477\
75133307396362675802341724868135363256326241572146122076937698002329710267900\
93988313365761104037606306535267912066440421517099515272626942934160156693287\
15342594202270053578877849652047235465327999590218928792191936369876630579294\
24326949895930435899876723623090431236680023226440718600587985968437930824679\
95710860369661767043330310002318726130428200766685343998571272857134329044463\
2501792456650522624*mem)/5 + 476042771027695227346152712673678620825121469468\
48328080671278193076129230390936823194559949424336474897240857300662807374256\
73241960579489179314059400173347671431488004788874976529061151124107545647920\
94210274483336318076019247717954806812558419338307503795324425142445913379368\
97172512097173156594459853706308354674181585088631491605726012345863352547332\
19565622036188669410481592837200772050272776901454800363877744676935743039415\
88500979967689033972955480513784572266472319141090867458905674230911172446125\
50127325322393232813967396892834954037622502776608039256034521641201637382316\
77006795401570002050672921145910497728131321378021477852658874313264010262831\
12187067649106847141443567015576746823147413750680781928315262716782906729028\
83768213040061403989972738201710079888013718190629167668041519075035637343873\
66297600000*cM*mem + 18881237521871967530992555954476281733295584077124314143\
37355138407452919839596135581399502218836163571377216898375972434436701340766\
36018218293579773196208770989693498274576745059625780973310933926236543583556\
92845077261455070903314856824792006915307982836027806091244323780543942151032\
84374514086783457587823341555730431519389686213383017253771351889272548247633\
88317873924586954636697217254883131568428572127335135391416673039584561418128\
08164780256959900784677740101283775651808298797106766364042064509817349665588\
83856243922144851823780437988428440523535958073226146970358840364465544102358\
00720235211316272419687529328326635425338936054432665081333981614573965808508\
45981267054270487270848117047891659026895201622563167169674116969685826983325\
77738438106060508529105956687895165040742147121452556308416734058167125448670\
41087222*tailpot - 7351325424299104032212412985849945841728958214446736643751\
40504623702288442152710322401510634010914960364161638714588950214633011323111\
31945976623379135089814385180468324710546356265964022060124254643503600484688\
80937336873348981254303321587321322489870777462970173057535712327875172677168\
65557998206931197953536714695577087743043645505439221398475762197065458319555\
73241340597228224103649115267238691307981825781054161672016479215469710128467\
88334761137620846784205941076992455243856126681444589898548025090060028231616\
56483460065738614034228964817603609086890808700240830821617875421230522283340\
37638953203799216467585711629753365704363818054979780838779991020078924870194\
13417417802099447929990892185379954584904156560233086987687664056298386009262\
73237984506300762023249866358620488882898274733548570638254944817135619198835\
46869340011015625*Pi^2*tailpot - 34752071710037886855228222112128643094501296\
93239747812470521386466780439882181923177162112566208102488736194777249268838\
37525383447577746451507622213001423652296767336391042048796178300405541609948\
49141362126579673977966272574624147826333768459762385264861385160662514406167\
61095650983082342690541359556380831499112148918038823117855867964849553933527\
92122027437644720104138509851405595560737554399518957899594089152024854182260\
77876796153173560270424305228757455811585925616657134372224449180807731675062\
76441493403538585744120429551096316559701859962948097663937391702222786084085\
71253773890119326597418110839153234392795341835766227554213707187880089597914\
06412578861682385874353349744144200028211982330917705360883717511792635140898\
89216090170772924380210730514389428253747716102518747574026028738464206696788\
9570346545356800*tailpot*Log[2] - 3475207171003788685522822211212864309450129\
69323974781247052138646678043988218192317716211256620810248873619477724926883\
83752538344757774645150762221300142365229676733639104204879617830040554160994\
84914136212657967397796627257462414782633376845976238526486138516066251440616\
76109565098308234269054135955638083149911214891803882311785586796484955393352\
79212202743764472010413850985140559556073755439951895789959408915202485418226\
07787679615317356027042430522875745581158592561665713437222444918080773167506\
27644149340353858574412042955109631655970185996294809766393739170222278608408\
57125377389011932659741811083915323439279534183576622755421370718788008959791\
40641257886168238587435334974414420002821198233091770536088371751179263514089\
88921609017077292438021073051438942825374771610251874757402602873846420669678\
89570346545356800*tailpot*Log[v]))/911866540937926258896650032251292268977467\
65764900621814520554643148396017874637192113049729157555316184154631870856913\
15723907645850062906900738404018607862287752181926412052815869978732540853094\
62856191448684464565523687727289775160947328864239176551132983673752151580103\
15951538144134377213877125010725984336001952554875387720753572541360815496480\
85252211747543598657661188795075726721583848773072102853401105332434863944962\
70178670777843897597121857427973752429479844068647577335840547250080926781797\
19260240970184084506878557824953808429131629550783807020117662242063947782731\
85954914382729381321237014087305937328554391406235452592753616824619687718005\
70763286956048307240938407050962000930557246309604673190252942424508131819879\
78940000125279131672244293147543256123295587041749394036870412400394189065714\
4012800000000 + (v^514*(96463438375090509076181768167666416028166078554845029\
86580216064609654538985929613350413249500764026321345096991069559748923366171\
30187701948354628842181711047261689020439343001031964552889499028840885200503\
62945585717404095678412632732597867965870048865754114583641800085598393716133\
36714497966536345506912780890856014024011389699461670127251507465683588499997\
30062618632108874534207045975014832749294175860333487986870844141390736795865\
85287064810662154072043156221546808442032324145558436972303009320929742001960\
93363744052236727666709532345112717404762144109631967800818975800297867250093\
54798698296592301913294334175169608884591813836996336061682910826416518569056\
81136065811973305833902210212213335368823305360724455131202631782443770227781\
24972092613883658529920768371620899786221598811680461433716826329440939386334\
52756040811544576*mem + 72693015639843256305820665896240847010476615863623609\
88551589750515955909807254401582742994055768840355046206178560016986175672585\
05963774268500659540798312441343049424847086129443492157657567960513061568746\
80704478412887720556382069935194612489292644362723460790144257708288473308970\
34558278578926538745608876442803630182076551223538056687229822504167840477177\
22315124796748578620868380139619220301699463383457633209211680744463264118282\
46855038172988914536143058444993157192739774563845783668358491740083213333527\
48678962464262552001673374478143546822408149555446533999879662351056043048509\
32705221974875321537758338161854923373879341594392341924128908781342268088930\
87212427819733057182407183700256052408246916058698932829084259138936919621027\
89973995306633814667665147318601703763792304208770981265730028729008128000000*
     cM*mem + 286477540963162764822095194589611570230640187671564688918664150\
82092069485955515276318197611000694783164800905881145128248284509409457703403\
50012386900650130986769386002333793026049678272634037828681968350585326157033\
53844569629011683072849319261626618671058824196643933811919142185328991394343\
23094100988010953741957989049066469082700554699768889645951117592180269739730\
24493381137158761102677053788574692365868536340371131503562842143899255485336\
01121632553669308631228788409152140741256199740025728518349624900559255613290\
72648416044236762048271976431139971279184139647813621291870913145926462056580\
30340090174891280420873065162856898338570654258138940313470155919665139429746\
50587892041399688156839497271702241617107787351820183137933537000918734321875\
744384028019900533537483566417636984455539824652223634011540627075326151*
     tailpot - 97737897543767803435737923312719313836802199412230539001428232\
01593686774248142994383793307064430011148067331428845291657649311309241625234\
10959254981434628556073087099575703255012930311349432753243230470482858767117\
13936897141065777898126627686300925946174506188019154678793196440610301898530\
20156642218259023422901911133792702757331030647104634970577591320953791612430\
16417576818122573658194259019195338316874658319652918691609427438984614427253\
03922348143676174042240769546180507641409405936274667052751599638749649949095\
42435882581479206530230195449325713498495668799537578149732644106230714953501\
25318197814876803043298615405932628526147604189493704051656960903936571858684\
43776430530307392863574004207940026690440091538781384800107458716248043921396\
78078638829125990288176125150563653655610940884063759287201891106489740338789\
6093750*Pi^2*tailpot - 529844251165972951857291262315169491336074213888240624\
22008540305804224236826416077094205411089838946324369440059011969046519308241\
59403375989374604629725411029808168269260837442168370690005078915192188128960\
81327435476881704179234289466273484399458959344397851525752751057553234594749\
99705518851393443362265790166839522601009071845246526916425186430613872884641\
13597996482955176445643009152500530481709900972285888071174431307540867982158\
36212038530498781763982720567395912152075168962662108491522105202154209620319\
84282190275001225371261697548167246860724189618913878768226912499649695232001\
49000405956285815755251877839465330580433575561694553530210435732216594763231\
67233182249740754285780377625741574014205074929372221126116783361666718618898\
05531790162784276973450805218777406232928658529897588331024691608708175360000*
     tailpot*Log[2] - 5298442511659729518572912623151694913360742138882406242\
20085403058042242368264160770942054110898389463243694400590119690465193082415\
94033759893746046297254110298081682692608374421683706900050789151921881289608\
13274354768817041792342894662734843994589593443978515257527510575532345947499\
97055188513934433622657901668395226010090718452465269164251864306138728846411\
35979964829551764456430091525005304817099009722858880711744313075408679821583\
62120385304987817639827205673959121520751689626621084915221052021542096203198\
42821902750012253712616975481672468607241896189138787682269124996496952320014\
90004059562858157552518778394653305804335755616945535302104357322165947632316\
72331822497407542857803776257415740142050749293722211261167833616667186188980\
5531790162784276973450805218777406232928658529897588331024691608708175360000*
     tailpot*Log[v]))/1394378335740098554920016466243295100026832954791378755\
96093081408057866634301707495074692318966619501926350499956047583942911234307\
12593242668255762773285951612504544513498782211290824767876731598284054898970\
52391900784770253694382097457041454939660686986257971066316644988188124551870\
12243598495326636166268990484349107521367878536722996420595499659386276877021\
43495584527580306348969051255565749471989771534837849876359174949602034358991\
26272093307743706295060042705789701632116095072211309330806542361041181788866\
70734973800441717088479570486399687906840396339194007919680283925754923462851\
03690446188407606018750601802668127056630738972120622539888907451271628061139\
72105967678728353331524245789716406779923258596166893145829005662416554429164\
374959053168655591101954423083076769153091459993412439096950784000000000 + 
 (v^510*(15742653000158679677752957085024321908462822536066835481682828839287\
75455713132331151481672312494651912934079685583335178006158145438746010964334\
53456823567027383531272332425359368318804902723059247180709383347289621149955\
21338933550434541746353308526001689248298248406324337344019461673534561512523\
02498381786299605797896044331045186650307716733179340432831433541940634450643\
21867994306129048612046927805433670414116968345527541478110611366304647245721\
20326776244986229962376111224027372699452934334336917414663609675461302759573\
70932321020745235186790077919077400963688561538807496122962908198892581977288\
36714139660889936612052958043458508141431058020080141406694481546585495387342\
44748526777012477131181389166482747257883248828138560154003815380401554914027\
22318832390434653798069117874254141050770837493795518816132012248287145885696*
     mem - 3277*(-47765839178653489072568440541001357226993087343802471534014\
99879410582811256838302614284356496461204637690778275688493124145176205561838\
23792896474609293484974879980726790508195488190803310844105465698840502602068\
33454158180408162400706041513463615891399453808222855602273137539692604943126\
95324482843198245614686214796200161983949097364835772273383334718434525001519\
94395253441743237420860814980231419507624055032959775301575666033186404202826\
70923425802205505435252058052770445608654094613811414798116228113994450684701\
81077245764303370023342499909071549782014872445389378635261473031012720727820\
82665869969792307338599629171992281187423434719043078648840005165925791208995\
87785409755689616469260390047423924867744177722007789675892799888828264231346\
82689544817160930200106232334994424180921685546785333837824000000*cM*mem + 
      tailpot*(-1858278079072193945119279852114116598302310365789567511086572\
02813990917953691624497038976076632123106788228229183347116012534431649083860\
14205369833760258731228870384641222561554465305816063563053510633886041063509\
69887380458766927294275886485889034664943392988813434086429348450408001451476\
69564647281241270232174157380935216682365831668731161720529641630336880740633\
01211712079180924186972802789737232820045063774846928795127948325606062718192\
84476472403264036564437500103985230762642384400532300722388764857365587212186\
97464511070875926479162105406752681809692326933416143908737466808404959547596\
95426581531489639203079283334355165881130217829607939262604260257601157532816\
84823857050190075780260620038867289687148853115824310049460649600781209557617\
15138333006368838697772920294462610150868754332669771533243478810571 + 
        486745265684252111532456817934045195813417664090839522278032946663070\
64866917811270724022285912681910564137220300396163693152721374796456630843144\
03923351777241342613253584210838021112672915456081617058394045377761300831664\
32644944303066191279971915793636618824563709924186928386085466544710833155190\
01476663736962708834343698219900989056735579946575878535998978970796378231063\
25302871658188858102371378166712433649091545065342190668628805103280241675599\
69359152418763100849044488886130578655698804663411002097644337151622984631893\
66737625013539789125652660754440557418513996954427696367658243428381165668745\
41961744853685171219191133786546174179312661922745348019786061191859283921720\
26987220729137881976608349243435395610694290780383513086333015398415385377934\
92553569879070915581188902711856903322800508708720016214829738071093750*
         Pi^2 + 3470616943677524395867602185594381955582110316511004641583958\
26764160410824377946668660634685203467064901172891931114353119006564775452026\
82633621143165133064466082391475995529321534465925065673151468114383681973748\
52012837937817515992046292308398635757459805885584175946239412348775542477705\
46517602677906237065029369115373361308290610247868705259596347211788461751602\
73747406688539187229761982979062569336416882231886617780576115604329401698635\
86206419800950587773674082359539943743359376690876127937100833693837496940248\
35685894146204596353871615707056460843644665063913707171392162347408033967895\
06660228943626907912392243132106057667689363281951424154595071355310638148493\
92296321950380754082379617288005864709570842561778744052015247989830345405223\
5476500256570021105043062326359604735209283652228164108401152000*Log[2])) - 
    1137321172443124744525813236219278966844257550720656221047063124306153666\
27148653123320089986341176157168114356685826173517098451276915629190990376486\
15214105225535199686683734958666844483644021091736101083532582797390046069922\
22799990593569989462232937719578388705934457582655426693745269944080938183975\
49873886210124259107850500726832978226574713569722981303078916000217070251718\
34291655193001822238803971543812307389244646694793083538744936642971998437687\
71507613432996789221239564698867741600107124987943201470547747319386542675117\
11246225163728467202402218462356741444521840065211601245612731279213325570248\
26537722890938074391155097701804347495481695460804883135296121261458555047031\
39773112795800585279521865326365107494894425845396766267404189291756564913407\
79959161226115243480424717280822528351693783230575104000*tailpot*Log[v]))/301\
08937192084661694530106036923358685800135780044166995317603950876218802992211\
31131651225697455795387085303501930010209899714752313179922841034113842600133\
50557919627210866218573938154776608887678878344747444134527520703749598115136\
20713467117219160707476779605558660760301566988883951780047659739436792140616\
94719630440720515611397569500444720482088475268457756512962110082119893011551\
37476227795700354951567995798673782568489487306216222083705368754639075228895\
97773769948870069231405714452920486759235534155709693776745782245092461523899\
57719762934648664988130388846634171198012942205291888992658725903753698866492\
71170856870224752041144639162329654911375826901512134091979585138080133966367\
85286582679988745986961377251229513078123198152261226906505466693618809783084\
95141000701146310734150842598817792000000000 + 
 (v^508*(34211325882669632675083491499747735343686479039262969114744462225426\
97126820726515585253873413339403365192876055421901424422949861941779180685487\
51094446678853496949526552404172135123294849167069220094675435857841739070954\
30524052901881196834079522059297583787353992129780927016731547439079665569574\
13710853141526195932651314055766702322418893024641749977253907583213421110647\
59923679115825664954060474391685237108062255439698919013708978895398262739543\
70110300221923001175135213216641781123836941646528746455419435084222830378685\
37723035814181444629004127907893581957630313043272724379381065851318847909431\
04792383738585258856790544285450792635011998264537187565266649417076337150904\
18313241593052124757267597984189529580871268537849849870936954780223872600875\
4689228123368986841220179766334714534073145903758723768776567785443792257024*
     mem - 29*(-1347487730187933127143558115519367822731127675499367253174770\
27445898718830065905778557891841946122425172810524608340590649768030094522263\
62459996002969007622506772658079835213764667467883728650919310022408897714222\
68847596043035466949893084020478802176722042474172502343581808769868227680918\
88644520192056055333973293000876617650851814757007604232148888695126371144144\
22487996231015015394645111221420741678551759149903062249256006558155306538334\
20040070847662503055592792438714704768711433329526399244171271112153755952985\
38502405072336146617616571300594227530931285617610982620400784810314145888157\
70492039312981766145035955149389905132097899684887770550214783578811731296236\
40817588222422640063461649490811950067893157177021466165614577019199757080682\
12421842304722271492879318374789111617761606665129158508544000000*cM*mem + 
      tailpot*(-5208347289769779354096389660937815347459678876626113611149418\
51567798227255002822777473062101203108083122750347920102398667615768230579501\
27549707344189629439923087489940396921493134500943202229559164180853558077421\
49327000871463514557359386356757624227313142867908328280505448303149148248159\
53965948823847194893652977487689084128083197176630903314935768186998000304401\
24297411999316668283521691330064802820310894242566751517739699633761776124443\
99079595536533711377965817590542820433986138898616099464878940736146905524546\
99129010810919936958202267572953473539797193909519850179151568602824679104802\
88292303174538298977171512954106591665358865703398254040565759398078264841250\
36656395346233631731665325023295805060659013885449214551961593615363815442513\
824063079548053444932708159560314828161849413184499633809489160004758 + 
        119528690772667701912729326583443396460481878006006122656399809631012\
84612660792506991706014441506446822347408101651341211707170198117468457624373\
68821260013342345803211600882125965967141262651215349112038981425771660998492\
61559351722902079148006745090229412202775995270152891774747357072819591447484\
59638025781054585444834903144566361064839218844317176937244916195722666087579\
55599901821945758048748900924908431849057859810507101973694588544628278054499\
01096934540187040856768257831766895521644872507607527935171118685539336765353\
71411191567739433949392355268729596931826358871392353424166048843819863238559\
94521215542353679306116793974186285334412365577783179284481796268992966785417\
08611347612562082392090724758650662796919983106084668454211778755812007475610\
3723127580840003092968436799577490218231571321828238295477932715588671875*
         Pi^2 + 9775229513995730113483491163677644185681377069639106656309454\
05476896458383954329453609639620550992978493676631614006742470731732662731831\
41700448676662057045504556024028626683297716301746279369263979633843056278075\
34717534914388409999602842953411596963795626249824559145908031738804132351116\
42396774578804063925861735007520538377174985998162167244919144732630200912690\
42859955004504794483085348493150033135497058554454060632759887133629172764816\
20344548921221138802861402377330970988973733531284253199934447057324093418145\
19862185649285817968307677385102871977078227316498739888893102069860319813616\
60879753136059130493276317011803578749703979648450520174428068478449653240554\
39031690901203670487333523507454475924467162638881202734941294154542155225624\
16730517708486506142310389779517058470755572581019516631973888000*Log[2])) - 
    2834816559058761732910212437466516813847599350195340930329741675882999729\
31346755541546795489959787963763166223168061955316512202472192231110931301162\
31996543196321246968301738156337727506421017086554093814486320641850680851251\
72638899884824456489363119500731612449122152313329204253198381823762950646278\
53178538499903152180956129380745939467028501026551972462758264680224293869513\
06390400094751063013509609294146980791677583500367268752460101796698999191871\
54130252829806689425981586802382724072433427980989646623987091262107600338382\
92887210809226441679832873352685921784634567778999600259492745948816551284094\
57147843050131933423037837414154098050650850584139858750399439760773191903613\
49064441326721817161798018095477165275548793132975304817225015431008518501354\
6108678127001303605994695651911604849565982327242752000*tailpot*Log[v]))/7527\
23429802116542363252650923083967145003394501104174882940098771905470074805282\
78291280642436394884677132587548250255247492868807829498071025852846065003337\
63947990680271655464348453869415222191971958618686103363188017593739952878405\
17836677930479017686919490138966519007539174722098794501191493485919803515423\
67990761018012890284939237511118012052211881711443912824052752052997325288784\
36905694892508873789199894966844564212237182655405552092634218865976880722399\
44344248721751730785142861323012168980888353892742344418644556127311538097489\
42994073366216624703259721165854279950323555132297224816468147593842471662317\
79271421755618801028615979058241372784395672537803352299489628452003349159196\
32164566999718649674034431280737826953079953806530672662636667340470244577123\
785250175286577683537710649704448000000000 + 
 (v^512*(63540243327687014277456042927669199077654346670559434172056688855085\
89804070069871865905434948833996632523681914057444483879754858984354818822342\
18498655919651144497775801727262129637099859066073242087171111634034673540732\
04083266291502814299249608654940185054943514641394823808199803778158300181944\
78189895990752249235530512467332861965501233478676112842726525325980741298240\
67121331023792199714960876249904300802477728306817745153102734822659994542704\
29238232010883566885307861902954865394744371368089393969525915988797744538381\
37212433929936024907977254963010262294738244811827423994485584164744456810686\
03506770210062858346973349803987610482210097484841010282182323968071251614621\
26836044101916539529827853650255354943624440820050028708659038476213674167877\
839988875969183794919666515855512464830696908547353334926619975326583750656*
     mem + 549993061707563170080319692011339615754471664769634038401370901054\
65588196135481731726407394763217354807461010250022770559797095992029121762666\
39139163390306569980404383789142225616429836645695627032002736436083451781474\
38512115863687509952358587411240542731992636333355863924053303189015832785555\
54286188552516358276614118900500446404852147636084583553115927080609951919280\
55935643530153767300266962306759467080494984089611104760077001899601943218092\
60311537140629997579759319238636554321074171466864043585411359842293104479315\
72059486068740728353593921949614707125324346875052986279973260334454606986031\
78056148780224288264097376027679175754511626554718814181330662198438744638137\
17346822739961535651381671080784861531978204965868827945475119180931377152687\
823823802358639483665415031416496298445242364644556800000000*cM*mem + 
    2153565417626600844985405128562043402286446738362845326629348642929166801\
56833597879932764463029172955005158194627260276470194439551635114941687015287\
07588289823817633626635139108564891471738134020289741654253538553363831489921\
38715570236673293147082693471404648984409445450368784841513381636264762034227\
21194065504038532379278127190206879224560783492496459241412866338278906073560\
31063149473906422511134243254555800829644663359908756976899785427866343771097\
73056450884276734100156522387047460426476650280420778030904153925768906236719\
18542921356055089666149158495695099283372141907005967207124824225379577882414\
43258242170299786390597488455097879557306064662271033457029571532204072928453\
74943386677033569495449182870434748542661956846522391986305620800628097371346\
1440673945072255638703243504960845773528054150751783652809*tailpot - 
    6437972662885584933936313703814441653971740754609115898319607902665125584\
05373212798739658502369016203935734063527245083585346375863451190199838724232\
48697091732832374470116312972801347828871165415509639182416547651677125428481\
91859741086319375405009073368092784287168955324048529210005332886359583273624\
86953343688134713889106468005395333530885457020573698599352803551270551550839\
81309312279164305680076037540538737917454304025909178726692037520511734196557\
86809244768818748464472260222186992818289503425874439911416963496955212914401\
83520870262238993381285836099331624778001633869637711125067037026724781603672\
16511177927395066633846667968752343188775841593889400364889717346043255741692\
35126076793039309618632576206852543458605205452660889359744759082591425110522\
303968528717357866702674586782430237076445044022716006353522792578125*Pi^2*
     tailpot - 40024963101887955142587370331552669769146607657817630550875806\
32917069593828137729994650049237255088550259025616074379375875121030599627548\
24800169366339736064822498203318407617395977729721114812843560529156903400429\
00817833222616123445294437818175515593587686343905353653653751782480789152698\
15158779409057370161907262114016464336215197521415918010083157394146428423727\
12269669894036937174970926927806578264783725908480854140805826636233035056634\
79948942731192540899471955784684932735263931396935477871138090192200329130712\
84082051534129660530508144014426845343833141267479192287108187180532050372496\
02060000430199519917618028454762548299908715964640098281979633068887572158672\
95416685010476794752598685513368222435066506604593871838853966506157586149776\
59603233430906773125373647662515681865617953439190222793748992000*tailpot*
     Log[2] - 400249631018879551425873703315526697691466076578176305508758063\
29170695938281377299946500492372550885502590256160743793758751210305996275482\
48001693663397360648224982033184076173959777297211148128435605291569034004290\
08178332226161234452944378181755155935876863439053536536537517824807891526981\
51587794090573701619072621140164643362151975214159180100831573941464284237271\
22696698940369371749709269278065782647837259084808541408058266362330350566347\
99489427311925408994719557846849327352639313969354778711380901922003291307128\
40820515341296605305081440144268453438331412674791922871081871805320503724960\
20600004301995199176180284547625482999087159646400982819796330688875721586729\
54166850104767947525986855133682224350665066045938718388539665061575861497765\
9603233430906773125373647662515681865617953439190222793748992000*tailpot*
     Log[v]))/105645393656437409454491600129555644511579423789628656123921417\
37149550457190249582918074476131423843463457205269929860385613034218642736571\
37204952225473731054589191674424091994996274227286346974311853841219102226412\
35334648981794784634082340762172493710444840721258458808075673645206848351044\
42013837470926532262174141897264967057535331580507791165222720240202654431446\
00028813997547912763074483493685455970414020346223798485928025635846393276159\
18861276868501367009732526136386207829493734922528023716615909318279627286827\
30612313144394350728841273454907596449580311742576039291273481422076803483013\
07334650420654909723406515334121936986472418113437385653950269829867137164840\
64960729871567146615040640982416652585829393863963203782888414569337638268440\
234012697578186262987403533373554762601783950835712000000000 + 
 (v^506*((2478039415341824952645822692950710790664672099067378722331138240221\
06904349723186251354262906531845567133754015974198335499228236705056097814654\
90871966968380986695359976303723203957384661564014052947688708037747586695200\
22214116551030017023539492357221172084097682488656816565764551326429798655147\
15352401018708952481172149801873611067838969820391731499869084442795827806514\
60340281928327100792329790992358286166604964263620720900534612024543891641073\
06138960356051008132965155211769745328718448964885745355698411435372802702812\
89807014510667779305611542026624454583453224323126604752842479243568031502595\
58130318984303938594851204483562443764515982839817041777223327820362498229799\
13899154501183623473735560775063849936465546521447698018741000762956278051089\
7972880542972365618069593356607945777810253900123224785728499174572369641472*
      mem)/5 - 227*(-28650474068714525474701044849734963351068782015768084097\
57768696540840091030336396621242380514582350861554646181985096087671999002846\
70413204132900227147488053168074072938922209288819330453052439542899901312980\
68701723167407856488263062843199809676754606719036043297869453381275108965087\
66221950059278435831379345527838643780820173516207031022358603655453171631751\
96182027427252698908650016217756902005677634563372547279880149805175532694858\
81733216598660487111607301707985221586429413176707955342745514658297137553314\
27274945148302707920822050658564208128085827565235314423055098318158992784904\
52606193101275562705787239387198079978750496064794976149492569847622855521393\
81370649039089790430665901064730312593549079677516915775681602858040578604387\
4907532761016116780526396026103667996237940257355342539023974400000*cM*mem + 
      tailpot*(-1100216264547176234652502513030980396167741207712392876641683\
80097051122704524931832300364132172081275696568222330569535460700884883351310\
73688009338276320994845715425101774601188866364539536033575782419629197856172\
76574567798163088682206899930473364754358759033863526453323545537062122091894\
31642685853305703839331867826708206242705204732600555894198505931777676954225\
87443077960195611261364926000852075560904941448207308231689918982563381125620\
35646629772804714405288946303743614828933585611290943752304879354652086699487\
83908059359362905158652383566658878144020376751481657601686691012140474991648\
75030976766773534458200504614025794964427830699459266687938231720375795434629\
33431654539457898973619052889194082175557401530036529095317392788169121300425\
0492504782736107423935598475499804636941152386403620844464913969159 + 
        221213997070420153899411224178938726586170026897022609833168729300059\
10369299095152998531703824135186058119561789619071514008980068907131058842250\
57852361011454699780963253450141401610297738324416853858308715565654478632171\
93792470718301138214725847394135296140813970794183527121906549702910783589805\
88476013876705948856189776735401604647357192377975918460146351618150317611806\
13614603335417682310017021036456599019588603462951272894167045787426663170146\
87089843145371152421280868067265856885247054405335921730674049935736204598780\
89856796928677655726329048580016534922931748056870985661499162197748743188738\
45250719958129167048259141525368608162678912189995180504589599602275276932442\
99399433736114754243583065095835497144402442971745295849069950354326015828831\
8196350841411934056572918810471526090491878479306381708000362490000000*Pi^2 + 
        207512441622489948314760374759469980938609293289193024756884425362011\
37570681776424246521024186876062625619511220208904409227672948970815333901068\
52329143864571259823743040031082146332358068861203896894533040975799149335517\
80840547725141525403619321884816191238686835750462449137824711166937967765289\
26926185478453084803012186326080217419066257459399870450428022925951223333426\
00271664675815594191139575280399742372746376078110261405418807438379536708932\
77291717454527415215150377757449505222998091526316859421715594069947585284766\
75377831988469413494364661624565530933397956000801533610555845953848440537605\
58874104080464070312329248442198976317498562809382942344705508310512225370642\
71513550321613302413304475361824236774445741462506527903098993214466998125279\
6570820544732939958307524454584189443332020004696883200*Log[2])) - 
    4710532424830521826745060507039968567306430957664681661981276455717658228\
54476324830396027249042086621601562904698742130089468175941637508079554255478\
71565725767597998967008705564721744528163149328459505900030150640689916254250\
80433360712626662158606785327541118191171535497595428620943489491868272066412\
24410360885025028376629602020935412804044328377059224716120419092769668770261\
66788141013988138868358865074151861342736973102933903006928851215483292773945\
21986217772325383913575094103768562056677647392708872943985387810185964205310\
76786138255686322077818877637552188133601218194812959617703152359600203646864\
42162626534396089873939637916762407217375772992791224815038648627515913589633\
57592300621964782011590713410174779918331198898183400347145968400857443848215\
76263654377370535808051190611003636368541066192486400*tailpot*Log[v]))/125453\
90496701942372720877515384732785750056575018402914715668312865091167913421379\
71521344040606581411285543125804170920791547813463824967850430880767750055627\
32466511337860924405807564490253703199532643644768389386466959895665881306752\
97277965507983628115324835649441983458986245368313241686524891431996725257061\
33179350300214838082320625185300200870198028524065213734212534216622088146406\
15094914875147896486664916114076070203953044256759201543903647766281345373324\
05737478695862179752381022050202816348139231545705740310742602121858968291490\
49901222770277078387662019430904665838725918871620413607802459897374527705296\
54523695926980017143599650970689546406594542296722538324827140866722485986605\
36076116661977494567240521345630449217999230108844544377277789007837409618729\
754169588109628058961844161740800000000 + 
 (v^504*((3526111944452986342545621848612389778834792212739368759722683939264\
79807444368594787851292233458692915759328804306647468494792030732402573294948\
80686650552272030907450470487365247712663683233619309906326126518320942300770\
76195344876814467923607270564560804589244612303889271350225318581211596928377\
73158970869197718085435526035358170195632453225745444122645218735026695123135\
65485304797244865789418224885627024788188900390322222855390131033531078373292\
50369802926383872558769817957500557747797935022864959129644754856023995509674\
78180072896970717929147456782738323747828460870394439880102655222383876199690\
31680547889072368386255760053370308396762003355241373959450995268463586180547\
45344457199318003714080177567599995714996516208009115164210840909118199101644\
657324701043267677417145796499794120763324355812555413632604263793295360*mem)/
     3 - 9*(-1969010839953175959065848432475510839623269812161320814977343871\
14465932927195101959485967548118176715131548461660578987097869417570380195064\
89321567797754344752670392972050355227220333815514285239041719317699996034081\
69150968462577466546322963567585016934645857488809124173142358636816898204689\
02160836265918854090137855265474915805128639146008471329297755592734925264646\
47096288248019900458996267121218080934928319466702068960381516152002246516664\
49375615571147969369537778759796921377907137808933801508612251722160188966851\
90321170040985218662345543480567149470004892972184974691925834470510331772943\
71566367611595963831412544601510414109091680934146143870674646870424766358696\
73965802497697311123201775865606404036706409143057930146479309847918712918740\
403771066140843710759816003452107986298969169854464000000*cM*mem + 
      tailpot*(-7511985041416416761657167018809936877592527705706756264304935\
05072804655254046931645961734301701348385744691615088466019933598541592876451\
09518688255634479916698475975823127566604458066734891903586142838348330790600\
12320126166694068459191174307521601880513629372303708292303478087174343951773\
50702001944786664596437995649386726686190787496371209092749223013185588375427\
72613603546128038827258587429408796852963427171383739065540536977878453715031\
87709473154981070519955979429317509407621221115470024568345207388057310451395\
40577648508731595065613184905557478739250169023635395145861057725873553017296\
41767205275036454601474078495504021252314545050094368094551853566873609279197\
00367078248033250585366366367160178191885288175484933421596159659975071004200\
6632861348052825955071555699180440415789607696223608849985612897 + 
        132322161432432305490098536649917826271714804401414819443518849240974\
92464360217526341426500850497227660960305809911531665013056060123759904215023\
74612059878503773837602305912042613862129083029639061654272130135796542165401\
16436247992931871147572627504925841014788036387173704879588222096071988684640\
09613615941443754167475600319017000102626336510746012920578984987932516513660\
70426500396359505753412971999297608752036694999718079596662971873655862218077\
65729450106093616237690487736490108389412413971629161479666499164589390466690\
11549790064990934463467083378724264265240943406980510498651239437582398391062\
04545101857111612740255429235671794698962813296596543813299516477194249767259\
22862253866035133155011032744552717351615742518710057549902804914751973225314\
91465149551594136723744224180920583382079358745097941753050525000000*Pi^2 + 
        142386203089694424165915243004689250591284138147336887563600506304689\
68604085503841204312952640216219615830281550976451587437956639776443286605388\
27642095755652170786395920470474642568948069922480084205394256806463662905550\
83325658568003047420029638496481913484036186712240180808731417092733097804159\
21800148318360283391341872642784259404620039615215204043720183289442317199049\
17748257339440103372786675337974715135360519190703975467627407188274179128585\
46600979684241992269925874881495813648419417979960394738115386306054898855141\
80818103392819630439570210400949961561184232560509649371823264613968759042542\
31222505742934699363140652502844327600854113643835095624377182180205300690044\
16692514668814887703309363242347693127666786525565640171672445612269225591365\
75286044435059263720315740535507883053795098984448000*Log[2])) - 
    1281475827807249817493237187042203255321557243326031988072404556742207174\
36769534570838816573761945976542472533958788064286941609757987989579448494487\
78861800869537077563284234271783120532629302320757848548311258172966149957499\
30927112027426780266746468337221356325680410161627278582753834597880237432962\
01334865242550522076853785058334641580356536936836393481649604980854791442597\
34316054960930355080078041772436218244672716335779208646664694467612157269194\
08817158177930429332873933462322835774761819643552643038476754494089696276273\
62930535376673956131893608549654050658093044586844346409381525718831382880810\
02551686412294268265872525598948407687022794515860619394639621847706210397502\
32632019333989329784269181129238149001078730090761545052010510423030322291775\
74399915533373482841664819570947484155890860032000*tailpot*Log[v]))/342321286\
20120995341412566894195407077466864699351677894334392907839694302317783725483\
55555666357185688947672794706862368455434985439382688961009825277641496472726\
11087475062552951887045651205258675869470761756137815070290044929822382539218\
45572767909921729220791446851079073854631544185881048146942348823197055941202\
23068926584910724516004107455252319902937470162665723129595657667780360200149\
93764666961079695112737704857209681164167913008081051909102178239864039849534\
42148809927362345505954077174242381955990901838409492312273853577189182194114\
30972413984605947560629313754272644416936453886743090489139645750184744860688\
81510387961190634140064862174051535130272584377151071892438514304971585367170\
81741601117372209235214324466408038635751224744991206280803885170840478961346\
23878004155222375530496000000000 + 
 (v^502*(90307462118526320420632197021310677227851016437124391070666850420998\
31963991172571252045930317786587415988205508156577980022867088726383690731678\
63172884197628943279073501178594795718801129825186849807696158213469677932630\
51705193231832705875153491865635296909905734028179768210779832692846479466319\
77240068580950973936480861367243170069275172158717329996225666639234048238444\
97637056593088662154951073115661379296407141913635105357579228544729987386642\
45042422321524020961252188785595329053385590068536339593583194539750910031880\
48570870387481975376264987439132819047672758390224289034376455981271457267975\
92980202762900871258939695304888106481394529535314584709591275496998112399814\
66007364195443280057138029115314698926606376047745992426461859967683991880347\
85647845763185154738337470959213038491753350406782820079313163911168*mem + 
    1564464349411234577858676424200025790644836725082750903393065838921022644\
49799401707888691300381152989286232256898672869880989181076198537285454651983\
25867896779165243440772834405855676409464797863183650357999915946816298531175\
29173908660364960518710998001167972667921880437438561615762661248460258519000\
01566310546371319185895978367479713398188206750951269842740162937576001969811\
82196692948046425574742281157938893388267925626322789529665136391850341714562\
08648199348327131716260481519488651671869497879149162728356936434874526801807\
87128517665787442599954321999022490770412756571973761881551112206608365822310\
23989344206422303431248168871973548263067128273054593695049724687801517140872\
36148741379380994583592606444994557596713772644420445458367373062027986035799\
36931678592757163228855078471020121686016000000*cM*mem + 
    5929550613517178080420658985327800539936932535339479205494375788798820814\
56197632484931885458097785555302192678329184929999753527972110205902945973634\
33427527192670940306746281803223200439942480879336996184752045605872908549634\
64565153618317196562044497384034147527094581284574032074901084186585025977718\
19334298840213709740659989310322799984184580956338291450978770370166075294766\
26798492402990926637563529942511801488449972411913705745656621372767540809140\
13253295369657581770905224908262866201353667329250683971836111081311986419146\
62792179715431503574944026940973481025152098957819057108534088301196432483018\
11474733771957554947038659693985663321008298511406087635937466053734329247558\
98749979417362554884165896219446911087498513059515925485350546374470537056777\
208213871984189242118033539368704517191694449884983*tailpot - 
    9150058953590673948838862996348226716786064277151566319762370673815024200\
81478634211333377398334634130627855887030152476953951707862081609970778728608\
19102099860772128522688460148802159973649197446163283685410466933094840075788\
61103685813846886796660247539918918480091406106279510789513773551211347594282\
65416184771652149545240537435384726496787790848578838522484710234997614864274\
34530151685868818942853221138061349293048574020280235989417420165624780972634\
84978162731477523514098355657658679336426876218485958162381905330167410597737\
07023893694985837795378340090179649571523406704789876747132259295520957455379\
22899402039147853539396709531639226050537781750983983370679900553223358459868\
15126517194363114445199466402719464442420007017326419888389949229920167197459\
57387971128293292124227291184044555408929073720188407850000000*Pi^2*tailpot - 
    1129510352744422469927541920908845574230964188045492589734835638407954886\
27387174690361025692001831752636128554508337482312059552545817525998601370648\
09445277877184803661805070332994146454777494802408743155418891116778616147132\
65956290527876560388925713377964591883409421305411652570355009186855989401033\
91937209370263121791242093402425557302464108797808825351438328411266115490096\
44912644639215748532939494665871173125508496866856285409320768713025201367096\
22129937885812598041201549723278653300390926525051133396156981754166544512067\
82614547900973357317316440546120950268810349535299332652596721197716141137888\
32413748445908570864979849016181457767614520655549269738472853810359701661981\
59563963481202640822625662316522717805039443066417356236970900528152839059229\
575769677788185140353362693082035736429690880000*tailpot*Log[2] - 
    1129510352744422469927541920908845574230964188045492589734835638407954886\
27387174690361025692001831752636128554508337482312059552545817525998601370648\
09445277877184803661805070332994146454777494802408743155418891116778616147132\
65956290527876560388925713377964591883409421305411652570355009186855989401033\
91937209370263121791242093402425557302464108797808825351438328411266115490096\
44912644639215748532939494665871173125508496866856285409320768713025201367096\
22129937885812598041201549723278653300390926525051133396156981754166544512067\
82614547900973357317316440546120950268810349535299332652596721197716141137888\
32413748445908570864979849016181457767614520655549269738472853810359701661981\
59563963481202640822625662316522717805039443066417356236970900528152839059229\
575769677788185140353362693082035736429690880000*tailpot*Log[v]))/30264160862\
58241238435295697915114574628701201317928301070820591066377688810020172194027\
50500954957477411876769669565435325136688300141888022093206556962411279514096\
24629425962441718894016314806759163312739251524954181066899846447951305038959\
74016809325103762152485477993238356499841823899110346979186045272824199123969\
31437517330024760746925020601875040534746870962588488864056178880385479384572\
09057000488381689731231274213036645162192702089680424183886091932970124222100\
13156083951484376754289730532234161138684838366261599316941868317314732289084\
35675106694042515183338151163593317803812229672768314364015832531067816760307\
81861411107226986842669543874890139218597832950487691865880439535798313404099\
77155305072199244763545385045897325361110242680951439363801243001614053557133\
0945026912575029248000000000 + 
 (v^500*(70854585945520746889718368730402560560346600806481543727266749463155\
17425668786345552315305418488174505944485126615118720181081957636199009451818\
23747037410101030119850731931690293368739169791814242199151993703603091042373\
06802763058493426699111904920227118539409669147235442882189847072787035654825\
26315127468027051037376202536265313576304190856303557235804485075953460698885\
25428329615450056900554465240339575221776126061735478896716741766795519091172\
35806480916249964066927555792146870362145882341987958417961247162794528579315\
26005492820704002821205158660737895000367740716279085964463261361846226058641\
37611945830495490775603225997447903222200834038269773830021800029292765809448\
37179712096692127347381591158315323506698235653017926387909171582263909521996\
7901618195986407626250387001769858410625015197081734129647616*mem - 
    19339*(-72934394058766955411276781821864939044171796074189231922499241232\
27790177689409405024590222121932526200888207326582313818236080545994253700017\
70979508111953336719945232528838758966542927994048145706954575435150854955762\
35609237070682104412552153636080428705407399172725999200244930545984585620511\
67717378799243653943133904012336867387180977512158188344126257684403692311395\
25523536907144592462395902234480634932658567596336309027869460264901554184547\
37857552423242231250029284064773985632711059942171543066501976146427342743098\
04667882605699437417672361617982381486016205136225294997552859916898938544128\
31313853757652844939423552932292076573846200141548402239463520340864425105960\
05392095603042927926439054732347672061745441840669772543176776212275312053736\
0450938508059190062503188332135055360000000*cM*mem + 
      tailpot*(-2746167666844492712465129980307309775471577092372337249225156\
30388796013229459180012004991248418447945858541120224909885325972842941398826\
34201701673390131343298647490400915437169272745443975442709668591693367620810\
60938180949905304915621880634183173323044322026911134143138494563619614148039\
34247914631528898775714783840789476079479096215502429152358936896159574820894\
99407485601376915352503405163397995018925649058833349123896669703896219811920\
81768840658383367730118060243997610334341874322010071424917755269987129035123\
22487104114603844219679741973801189323719847860122159089447466155190908889301\
82156840693420592747240750595768179785331121867496172808654126723242692212117\
57615560427284358987062609728924289793422538077625713740234171528937555291469\
6917637222756933171252514785202978156424107043395578 + 3712224269348618140832\
83849430264158370526704108716044715674952763887097359391005041226954722925114\
47030725562219669638765869368630667939778937862080015189929782795410502198032\
28927663027635558351367137172964878391259097884318363741333174943889940170393\
40618629790638171953086208444411090183736165216365004185142936383672151301749\
68171744146456720202613255264484125382082289211313159667110166782825337261675\
80023919476949836971551491513926650821997550443979780527064807654877948310457\
21273345256399848842656926080497288884151207150617872353906548432665569927360\
14686247528715497416062941064854985406840899389412973687363376268188447605256\
74031702961263867032263998037856920234781142779422993018995823836045737508185\
16514412536041704157464231580504993493750407601110896644236007569823586351650\
0538810461695384534596875*Pi^2 + 52572534394127788110733111539252811116929850\
99258542640029022935090790720101474101847208008732582282445029842509879005652\
50413728628494737791597234756747793365141940439119975651232560525104046015742\
22749971155366457433432074401888828248113897988499558450226599247364333298058\
50793650371092866974589023666318554972871025550516484489226349050030699453184\
22780944004328797120761573032128043164020622901840552288855641930319844244862\
16621442704303061137269284278466354510329000167405765775627268639857088973991\
36165597009793066912694061545205726464619996369973694602126327611193438126389\
90821660220732686845050814722648239205126606836230248273029345830129261113956\
39740658454420864198320982022406965742176702078550498900377196120356585139215\
73380154954446485384370968900639873510435299341753974877724876800*Log[2])) - 
    1016700242648037294273467644057610114190306388345609561155212745417208017\
36042407655623155680879408760204432124298550090313777510979464597341516989229\
60745575888479986152141209119186487994987145898438937616921736319203051428868\
58128049490274673199592960868932202844778841651153484984045265649544215771286\
82934534620352763121438293537148364278543696725129781606760997146075184080608\
68324226748994826298694440714179259290455467851389432420804585168993336506886\
61260829875252534237460104334855748226196243668018943064805723881210245904562\
22733544099286109798921279910521049672869899926254435000870087494308964377059\
21294297987943449605856771352114519008869780682802769445938500450927313294713\
31328310487955241497088098234394595771576000007293075988166640405808483501675\
69474513818308253970180120160321392435200*tailpot*Log[v]))/273244836171183516\
41368019923681766571462762204202374727973865558426066906076831844754235389907\
66907768727940902627389302528175635438412689440197822981935557750148939008637\
35503959238252054153967185904750693866333877891581133769068091494992341349893\
94259069850706451862732202311516253610553333625072103292146006073796383067786\
94257273134560674590838031612363006967982459920548294114761367800406760034182\
55305075639691718860267362522049728978476399299591598397349276661834227756638\
22802463531021482167783519454404224314961769033472331383599932215426408802863\
41207913035790857859662051075167321211508728135870650285044455470287651488411\
81411314959792390860421332731590541511528585568822594399483906533536957662380\
91848557263047727170543248416021811823581339558568932406044273423569978389925\
19987200000000 + (v^498*(7803112823887494818647191904377560784161360145434070\
54054171708599875808093657149401529965133396378867454211793564384061083302553\
55050479208983829608678269910760276952752238542211597082620254291560918666714\
24940004607519340494512756505694498477684536939734067323636997650254262201497\
09553857236729895454666457403364312276152533813468753018251386819612035404523\
99641867282077958554814201427486196665409996006424393048058023481688783983881\
03125965995123085552681920935612502382553157680767549347890236016088094784749\
11675907406443093584821016850657092423241128502205504044401990596816158868671\
81087317856831528153238060598527524718367088624883982326953055194804478130237\
56998355595478419641701675622519288335335197671309291397569641575948284545201\
0306707781122822118143416591228607945212392896004121679804073235996003532800*
     mem + 178506090062018993073339663822799718081269822856148515810322453547\
31279620266903525803021784155349573109801605457860756114088193943780466436266\
74609124615071021796975621885834897485878391796003229890615346798341473238239\
26386202600681074503354440308867216998685079722787251866087490174222365651947\
44539570303955836830944895914490995294494371896114064689793822651908717874069\
26054587748396053051256408427960575870126068129659693966545568955942308869512\
96308362896648339927724862837366166057175758827039825085126033471574153861101\
91414190179498724469648328004935191600635940985294322730668565700702344913623\
29725390833029620455217737649476476482768400541181555975338335906618723465626\
95899601863544843132129167149287025482275312351256502018938406666585435752286\
2745381672754554088834054558515062594600960000*cM*mem + 
    6676905693403053562058100366311616937769039818117524170729964263153049048\
01603176168435764038089536433948385496684761154146382263956820112322600650116\
99330640094595885923163320010710357372881538174335427538105943544669936297892\
09355696127746891382629380449716841849818202740004041072196316392602131311617\
73905462318492746209750992567604610793469811145662894327603737317172864304003\
96582151000928268777130739369168542740531077735865460314693322301347627314117\
62852446815287018879832063583815716477666758579606059215367535867272276649625\
27380883000800868290749752211122101253511678815801884982910689968293682953056\
40596057449610852694730446272208489866019170170147276501133674809718753697117\
02691719343476849434287779735795370706324534337586712171529787729249670976700\
8599043132024982906631957955942063732664551*tailpot - 
    7906206274116621444790758458246492040980018931824588979280803458069604343\
52627493581046842105980251686763943042702069922608725567571476542992993868553\
80557636816178630000736835499716233947951532141688347532384861917785446598486\
73562697625776905873126473691265151690778512092754244881798558588586024998108\
23077795506537337604766957871483770188878540341220207591347972001960031624825\
29040008854717133612975160151602572106610049346376513674906424809389239825129\
92248793461537956803075646195780008318971506028704238233259969714539593062670\
33686371192295731076548154402557958337956151963486594594064983843984167062840\
42511101415060965651405034793595205407721550074734954376920347224526324594437\
14168317900634391130454772295994682735008101791511342739577403566204479715242\
861133302558109220493522830473723867476827437090781250*Pi^2*tailpot - 
    1284632150630066012551864665843718255463243891869897982211283129589075015\
97438326347927433203171451807609669072255032510595270836753000352886223350398\
64187341111995401385057713273361030233057031709106738351100045499995577392617\
61326752432373949789892537376933698044612440115717285321388255128386962171201\
66239789908683288564069737848953769294518223763318464754379394336717663954549\
77081198072897273185970564189826158943616914043658955644294500938546896669997\
71367075397839243155480307627366970308941490398920697586047631812628601374609\
05310585272799460222684486618117503318138765257117543483389186552031248687626\
21724797595432775171128634256020186048496821526142716872270765818899738396645\
72727788432053335802851610427330965378434886344398072546780946380156730749556\
5990862906083434921620599822068552192000*tailpot*Log[2] - 
    1284632150630066012551864665843718255463243891869897982211283129589075015\
97438326347927433203171451807609669072255032510595270836753000352886223350398\
64187341111995401385057713273361030233057031709106738351100045499995577392617\
61326752432373949789892537376933698044612440115717285321388255128386962171201\
66239789908683288564069737848953769294518223763318464754379394336717663954549\
77081198072897273185970564189826158943616914043658955644294500938546896669997\
71367075397839243155480307627366970308941490398920697586047631812628601374609\
05310585272799460222684486618117503318138765257117543483389186552031248687626\
21724797595432775171128634256020186048496821526142716872270765818899738396645\
72727788432053335802851610427330965378434886344398072546780946380156730749556\
5990862906083434921620599822068552192000*tailpot*Log[v]))/3463093102567186713\
99047966229565132988220892747097691631875532673889018938846526859459742764734\
37449355150344441848124858085725001828789056026364058667672327350297189224777\
61108827323771064078609960522436726437134138287931864369401756025002338182055\
43541889260941611580353458719515142678484099124919798185747094871673841067876\
26024087938020478164199704828656400439141514897605119247721112778515099836806\
71113036188935800664422338127369825522439454343730496586683178368177339857989\
47049115328552582146361702826693697828789816279097639305068723406249216934899\
10935279529158486789951442553064955712461514644483887807471975393804728108599\
03572828764764397087844922791033205041739031811618368383121081811725855064966\
90923563721529345352312542051966302933063697188622155245590940507472390130761\
728000000000 + (v^496*(336972240616641627213673153958347979968531552863700932\
70810225552716420956261769439446429243121448161365262976606793992555335822438\
92633986304757768515431413507851497718837112422349292105813707569867039042023\
68291452609877879899787741079252698818053017462848042668349134469324047355780\
87260447753983494341415797813210750160068335663438761743911303898716683490592\
95449858372118206802747646170138587267076771691792561271423356528167820001077\
12831621716119669574389319295790723537018573706557677725033201597014805230566\
35239639749331559912030857653002085482444015769098617000079582868231014809828\
54280277099781993976342773014821471298350244390420657804555256385880655310221\
06965427401599759662010462939109305457671468527844027399884137483141348287770\
03254293826622467917696891090922068774897641537568239496298670499823616*mem - 
    37*(-23943894894544710618366507553766438626334400328075079660595285466792\
16885577412905371475045036182394658741287529921518824660009198269413974478522\
06594585398638093520334027136835180084190181238950806805936028009284074304865\
63565495782018354307745391735147635436930672086230742907569895831369360011430\
84995555657411329371623499811565624637928598588081148367908868454799619678231\
10541296443943591135340267220796449762009604299378258700024947958907996321956\
01329488398519741714025493674552939469958717333747930243405799277136906877752\
35626640209753000697926229698819429307665480500056192526639274570500982007269\
41365266670620210575498387455645800191223374148218430577319730600478533658479\
21475591175439445870218484327926923610935831533217847826314506436276520095682\
169413926760791194388427839425740800000*cM*mem + 
      tailpot*(-8896791725798944598580055341868271644673523890641559075455360\
77912662736986439548156901265179796867080032162766864257803656085021389321616\
58346459783795097118664190175958106681630360236487867357767397231194415490226\
17429626543386752762386106154219354598258268454912382001128919431188993260034\
08290309027965990228727125775278304203394873126705030284692594104933160178589\
07680083275714977227916595202771539048690543334330928369600138195728641460741\
07686023850926616809479440962833668112532802968463663139328534530808845919874\
64928975528172271229577819644055423162267289900881514445362091097969856918553\
02536287236368400303806249793318335744042949094938989416910496803738782820217\
41961173810529180670068946845800027585766107000747819439715713756675909102001\
22077797062809965978308489673785097983190126896359 + 922768277673570950342607\
06367962892707545715417708845989358321386366632172598205582544227442508260370\
16737507492974517807962283874643486089598083233190424217315001725888025514019\
68572232917146872359195901149129653332293874848009692470411326926334662984158\
05935771365787245880008750897800427843000216417621932782836548174140038775438\
67831068946266283963587854525711714461054278538924080462481039756305316997364\
15099997048176293622391683835716372723813311948761403696705164165645925067219\
88753831041266475239735478232123668003717209525972119257966856715362400873402\
68990803073230372522678993772780710194204353970144226382843142225467373889634\
92286135658607548326803090766123779952014310329961477583679439364174510128601\
56627103368333577646566234725320934624215978178072931837883408389139616734723\
460102257318526328125*Pi^2 + 172035060597835250931402440544117267534904302617\
12920610597051860699523364031995294186480578699558061952355801685533598996176\
70180973444378992202862481302968683158519623313890560982049634869415745469517\
07712987642570953633375991292115042329041892004389536550861882839270893425424\
69254318685758552131523089890641716923206884485429632251931297198341141801293\
90179372290925896157278409850808217486152852051996731435858267236435996340180\
82552831081653039209227213999581768143178845864258075094936860186709077733043\
19517557191216937581161690231459430171578980626790674578898308378891260808655\
83235666031326507341807710080557099828171925966414706578202423260257762269537\
70478969779525056080875153142702559418592048022020248531103898829355946739127\
178591007525985688656605919239891666724419650025207245312000*Log[2])) - 
    6365297242119904284461890300132338898791459196833780625920909188458823644\
69183825884899781411883648292237164662364743162858537966960174420227115059118\
08209841276865226062613950756335836490168382582372131853805427751252844349116\
77808256566174550004162412852381889665053023056740713624097913730664288663543\
25953743526158654725960896393321457996338622246647874366367747642581578193011\
64479904046987655525923879063126755887748131864586690544547500211624507414069\
17984525421297617296977548778512663826908235876122598221496160750266905029825\
38563998916348422283191254959419237410018976649920265797196431590807716468852\
72980612693642361260757344143393489660629537203972895077218818424270749923806\
66279994698487905776814749195650844256686170029347705607867278461470480294419\
011875991668803527050932668076544000*tailpot*Log[v]))/17212192358683830586433\
79553824876406502091912261916956420852548080959338662259079818388383522536652\
55244286006172207380010366426450441297495160855162364176577287759389785176993\
48048328882028223707557268572198991720369224313441199809920601403271282581686\
97262728338029723426733198385400986501486704372754402321545087842152424832307\
36023548809533619282827180200797411240133685910135426049268282878229805202341\
60219626917498332118976776191975757651363537427915440771264255354571858794584\
94608988829931144938880848378219824999086874242740084834609374996108026337521\
63417142934824999758660800521648670285858073975585524214589432429066146118467\
83443164832987514139775303345949511625406618381552600005376797842221992877282\
48328635831736343501700059474666665326526782416278556615012462586432061440000\
00000 + (v^494*(6479978749529190143169275048904556527538357023201450951270242\
12292710359493359966347254687540029029298176993582346556693720128338229334883\
72468089160502809174755197952815476875178401092639925564149761425894782808918\
38577477237491181443020055928196708934446738935963039812298919020522813114547\
58413012203240602604300878371197123536731110828180794353089358052679128005776\
93547145202804766307299363077781452238498683952211709089800329244089464801649\
84505823005295478703497696077720901110554544101239024720073935189716414550311\
58888085966103851281005733525707083372582945213769213932462980086266135601422\
29749876085293982718484957051189283860283274455409542614581571200545631020641\
82341287611497156900173717930961935203478379845147285270833650348784380606109\
157894960655923987180167191046173460430887401668122509312*mem - 
    3977*(-492343658108554092522431575785827683636115508926871858980123437285\
34334216649839157699122872201922626485903882818982933633811481166631063188326\
99031421742782477761591985286114248257212553666983766873547669706164962107365\
95648640819522468977742386649573656586850247432614590391724971296198327122256\
66867903013747574752956207852746788295158681474150590467213329914183836109945\
99770379626203717002757419923677923451366188148794780579478578334596345192557\
71396175423011088598428323928039883800298699227709906131853627264705223997986\
89479473718065858488078830194659595093454044013374376967181589574417871982458\
30099308409742829796132797332038210826009447449772586235641477693252753100445\
13839298367544282415121716478406064304096403723414674014574551077249231463427\
78453668196545996817589862400000*cM*mem + 
      tailpot*(-1817239617343411398577014406583487568917181427267507782596992\
19114237209196657400534639416535386163523243913393042895020483579035442342627\
88949729808667908749524820830894534404374227646064198284320147545415997131278\
85707054003536439107062830780209087453711441927603258830185095462561477959767\
02869172598345809697741108399399614677216520878075566181366101571456045231549\
71575769487183796552265041713310240071929881507834188554954034401691182114264\
85421200952107973422545871207884515067658045847858494584920563456600171889689\
50131980469281682695073817849190780243724922967272566754978965194503832595792\
45132008534574561461748920595412092278415605959189110339444935437905596176798\
13458451566123238978613410063901688247585248532670463442244040503076806564190\
063564812025308991107629957119071568164593 + 16508904120699660527286711432406\
27454329764606284966943532527888774433329595581450502984571111332273579144301\
17382760035388885930395660491168080400950556256144502276662247293017869852896\
31086862536264373407735414005666951732561211110110022718498030564514240304119\
91489817736290208494314821305871809609463451490820691613553748520390870991986\
58957482768517840798683265353867005192379502632949584358121244530515110041878\
17964634766752234847648127362281609433862172302690072006333567931081542465715\
13444967281989425375893085254325601535698528864847790397481357949351353714410\
49978699666620120301088975294205171896963806334249019460916948216811782905167\
66617164278996793986185150379671825519198267713441483700014639725917856415371\
87057572710712415608950968271755771464832099360092294238704326895165891595560\
93750*Pi^2 + 3531702508924217814485822570399779134211871417371394348804655922\
50729381891759728022247397704437681761620257014407237872746223003864092353319\
89554029054993780486565070676618929128657615912010498010913146915016326654793\
23726510623949926835441203897607663524965166608867066598148518738974299191833\
72008953655186321087268577494229672600834432118274410729839422352889115982998\
62530156011256762260498179925092696691391705384404890927775149213483460979078\
90766876569231096708613142796491015936210620885559309156568565623126833494049\
24557542683690183177860539737565748335787854778391946770283595543228100074718\
01244721872098555089103173851308144074846236016192191139256948091641655685829\
21165095158028673726505521807838449730250779772422575856854652323868752250295\
01857896363080411104963629959680000*Log[2])) - 140455808779916142482101163624\
79921616760612626886035325196116603811507517835284383444779006705486603659637\
62146297585019911728886367495289153224563735517102649950692860809134811446713\
38482065750589401585281019931106112704603327514488590245496679007856778387864\
67603464323860836659024900787885922704796086866759989640671326945514079335185\
36534377331472571382697440014264385532824304567681435100012615620936547416648\
12313778251219761768422023724313796815798681158320716101544689016447703783096\
39261869372515673185483175416805833849653472530358584983513665362989811314282\
98453664772305417859475418153997153535502588853359535893633224066524889856634\
80636396344160824882560458864662542774735834434800354103124602297735145772073\
5115492458418271095229202602769942328888853835970794964440356349647360000*
     tailpot*Log[v]))/3809738398529736873002420909468321238239881380304051789\
06709497652464048632334047334427720809973526144943489820755288752920832666991\
68449002082108808375349456874375964162736118023651298359980893325323650553147\
36324951476691718139130020722116481977115637719580376432187820365124325048154\
59614056189333107213393330749823515470267308940884970315124659043793750967358\
64315362265487488213902793057481924264965172581123428472802313526936302895111\
53442596157065160902934931992404196920192181346587561759107224696534328604679\
70400506529790913854400785085743855288739068956152072058464177656529760474447\
17198005039010113340047576804244465548308560534904943159983572490187583795710\
51009774490084997164641936135987951602980045021185812826749906930494652823797\
9500563459200625207928890970865664000000000 + 
 (v^492*(81095687591632135328315295175951580629214853195536737351900730592928\
77407135214736207415921310053265859858319255334100228895269736969278737952759\
90803035907148662953007289493493860131064075634971149330578580055645760630517\
05725999248100431912576393827845863340400070550610948409990667003577878628419\
40190739799180492339544651051488656032851148170188768315431182026509493718504\
00104448296717110798375883553300261524042428327448460605228883625329214820579\
96171473946964944348068612111315436709819737309454349453859068914790612855904\
16240862146666582149782523471948819306339971592141125505382798362533734126922\
73604616280255085703052623880571893168855311562554198668264776040738561210918\
72147778426581808682667996098615281607019049988240154355489258139663450463966\
436640716187423718170013395414812764974088192*mem + 
    2816611793824140108677685060336644566637103060376601762950559884244874549\
33507921450690498132460635096424777453037429697080254761374344669834548314281\
80299405825521924191053515901430405419021343948087851283151463992381878259049\
64940333759289241146591666103214555799661703987562585935176047613065979645197\
09036913421004922322431784651894786608405905848356574577995339807853067546787\
87296483378058719310078362422711307772097301792755022902452252861971783484304\
63746604164483251159918895052557468350954386062209968428585249138026332885354\
54141757549834292805242359323789172374094810277140955969180875996351295911234\
24357690469354699364226799413362015519995060031567417808256879065569643387876\
58843603509086828613426463952654890642750259154910639758186385446699335943268\
618961120533508259840000*cM*mem + 1032677643185241357823812383920238994308038\
88117984254149527993651690445337010683787623904710809625345750351878521520775\
08354396957009511746746142949532035006807766137004341635664638241039296370935\
08001083141976175831507493133630076125462412486375149405717095422864054890302\
28749178339216355789836012479712746492098592921914821706111428449001752082748\
10007059151889795785490229899834758752713315182753205648132375638159976483299\
91669874257499154234713435744303658164002723009696399379373408927987700774292\
62813196917978478815125270046060577774279686669011377490605961453638100967163\
10756328826729947631486406128525231741975411668601011164513705846209368714106\
19102079431555547887598113258265579405766696421002774439963922365562576454234\
49435168933930191209111090748298801458349939728080487984026*tailpot - 
    8216711055083873686033968670269984810577404130290951951897715417037138927\
76989599559766774610097535924100939012860525659733454993642635848947578334052\
06744337907228360631954498267364207707614768650350368512160376516668174191206\
12899083525230238908389759923119582336097795938668722269471224996560988812544\
61240123982978472217381730774920472404187632483219100466140902725947059206514\
79436262639002788255362916852651201610498502221894481063398805996454920828865\
02326740614759572081338934649605652328261655609000228985141232469481522490543\
15159531363037665250341441497440357389034170670088158313652310162802817166071\
50064157694324231576976062492315995591545403975076231516221754916110797726865\
21433939346531732725495936640460845124391554989111794056011226599394173916003\
666376889516238151063493240542477890625*Pi^2*tailpot - 
    2017128267470979416135585920095023691872128283442676480593152978923474383\
06608112091799425503795431804828902670544160379290208425750914690538695028201\
95082240516319979027959412060561116539450589793377382775679337449070331752770\
13091066444051656933409883179435599541994588293881784411666420606801474939164\
84013620170976795938892863411403877802398697460834653424626169009133804746092\
15435315141967932451703020275903656346541752553757487252907381558291699562379\
93593117743245752831872190241121259389425616028424528451179548229548295329959\
19351310055230250035012353966645435876376505711334324326347350343306888275688\
90868840426734565499452753031347140253946714171308599406311104864371408724269\
63789068317873750897598922685568430310371272225463048163894090900483203509654\
6499667367939809228800000*tailpot*Log[2] - 2017128267470979416135585920095023\
69187212828344267648059315297892347438306608112091799425503795431804828902670\
54416037929020842575091469053869502820195082240516319979027959412060561116539\
45058979337738277567933744907033175277013091066444051656933409883179435599541\
99458829388178441166642060680147493916484013620170976795938892863411403877802\
39869746083465342462616900913380474609215435315141967932451703020275903656346\
54175255375748725290738155829169956237993593117743245752831872190241121259389\
42561602842452845117954822954829532995919351310055230250035012353966645435876\
37650571133432432634735034330688827568890868840426734565499452753031347140253\
94671417130859940631110486437140872426963789068317873750897598922685568430310\
3712722254630481638940909004832035096546499667367939809228800000*tailpot*
     Log[v]))/548823615069878284636714134102308309016738467713965728607436194\
89332922037221510529202966432701853152062774244764250526232776959716960445014\
42805407546373019391328722580378409570144469213824262581519474331703763265278\
68680259292581491841495264295268504092469657972329489382697006239850169432556\
11926696282669812096211778816937481680100852389061220386366082943942642287491\
97906794322272742570081654017054661291114351006409317384648317818640536821785\
00988981927535812646565299485260130998727295738953386361681973490785362034701\
79466252387996553262622604595751432907434175836115963539039226124293707988188\
09361390833751019470861854538706439153292919520188174310468993164626290774515\
55039231409812875354925370940392292655449434258945193299929761686538917299568\
998709282576911040512000000000 + 
 (v^490*(11046734872437352531323806804486831642380467000368154806116616752294\
99551502432147637040696412701992211811556892372743738183814345613169173522992\
23150300583433474681224285666967459290771191644666213314952159924824225300819\
40940085829398879445333707902288170021172810653625490315301497937384735571690\
90064791696535667869797481765399200685318041216500947634512390320247757337810\
84169040196757813291881739546593078052961576677487539940545906405914592228707\
88805595719395625161972503823941160101609187549326338210450703405498622472326\
99280179273831069530880978007358782169130969485669334360701283919095804599496\
85017247059569692364334173911396192647098608439350480463018896207036173754413\
32084299917069683532551961282976945969339099022646229794394364332352322729960\
787791506071556393131899690246016995837345792*mem - 
    73*(-60415766801465059774565927293755087792511047699720212638603568133424\
97014405220570636824747346339552586023920939620975728603205254774672304066405\
65637611349959334370594653761575618560639886009067243850698092991053550138297\
26675964692008193927964506938824222274060684754873315851540919986618316975944\
47581605554377481312269804300178365472498848627830835905179519623681363427876\
73234866880031958280184235545642511898306004618084185322972268560581201018902\
73387993860076901776459513990920963697907980502150506496437895361375391409881\
96771930340806254637294572560825236819145429318851742656459988809719212118657\
30564024990601483774146479404678158863039709915013945746749542511241106523787\
93783476796948699882661130059141203790005200378326826902063129620327381672888\
16014085792393760604160000*cM*mem + tailpot*(-2200242904543115949000046979891\
66260558044565493873413575436018314516284155433372332932098225378810756654172\
60762807710847840740077807550222230929961994888624306928101130578721362945578\
14915006799186536971286650960575882512126683579479034116189040561542726807871\
64333913167055165394418089545443434866510307239067925531682984649440255876466\
97110285745621847130234148722557207465908170063961124351909945032040361351236\
28020309198457421778797534599402460919343908157013603661349376667211097096543\
54526188961815808280663470104172688942352747930472249637874856144404588961151\
55809497011855888658733346272772179511599461977701532319074951863090605848372\
71755116163707712921772875311380874442157267915808789986025490580568157469608\
21660481881410934413660478785947127468404800694736000293220582912563 + 
        153324418172612172075810516054964857780771881297650368585119177234724\
98224935605456731155131859180755164389612546874516995900107261645584172012332\
44022196871436288015836108207715340590376056038237544995584354669976688421552\
62886351615706408194686013467250272603493381618845147157377805962410610272000\
97038418198768465429090183706852422375572992649431652305496272093654091173027\
74067919787096816516547210754578132873596238892935155323044320432359896772396\
95961551235527028257085895393875494863320415082732811914643526564930681652247\
93300313712927486888596068546108256768352122981872446197143424388949587597571\
12209440619552262035290581653639255242998174212595611865629163471430015943200\
48506748532536745189255913046396233801407453342472047084592868480798778493742\
93190324057791488829191276109207528687500*Pi^2 + 4319611664749745348922431053\
74479945836912306529986603340438582528375149785122134390316878742017616688239\
71469325770525707841820696941058266177997586819639524891356562796027001883510\
17708690344369004127978495117760795621082263256278534040701549955573629624851\
36446043243833891678082863827716431562050106852946488615205306233229668881886\
08770446486011047109293378385802199448630229924265085912743051351090979397486\
90043805606109819961770382733118713246645339837527478411361966203387301333150\
40238213369120068569399885509878172067401905129396433692987106841333269772562\
26146648638911159282664836865430130246523216349961298003687660184279432723559\
09563153519590959166807945360147765421147845735964140686471387588250283166067\
2025457088764809204022562297988214480655881701876166767308291072000*
         Log[2])) - 315331651526731410471337466923370360460945983766890220438\
52016524571385934313915810493132148167286018241499172607812483766724529108766\
97253430993823837833685317069029084109971137496242927343951389373013424301435\
96538080339005217708332984971213146756874962614149605611567998740925000490594\
23299504029657800265093668909987355025765828377684402425934788064389784166221\
63560559750006784471351271630242748629641496016543731978092460168572092379395\
17666067005109808139505924029423532847272997319979373895759457650055661916422\
21106560920339074445939659588058799417328693397045087053506405146276345330911\
76399507996194793547174754269199193452398588819813981102069301400191769800112\
90786875743792738725382270112411293942270671122905785836747983107189364704775\
3139657087879364236960174013505248256000*tailpot*Log[v]))/8606302180204003160\
88634889649411326263723148268894153577793231471002234351219077937902229130044\
09000980202097250553179914124190337718533514609122873848434622719733976335593\
29636549192705045061062202382093302995501163471789637203306961241884655532016\
12128972960647991634152225265295957430021994315283363550884327961637613712496\
58145649132253387585074812544897064363907740428097526195960341905589063493893\
23567729418161353288283541700787747935998089719917401969875218355457852649620\
29071150518869200450557146581676431955495298906459769410967994549142046015541\
00701537560304129742423443275435390433869252872250267082368191101190404339434\
64203310039127349191178240455213066277617351539442857278127754814210476169478\
3367312461384293509770980969643229800157697944186375474235047936000000000 + 
 (v^488*(55971725065790643581739843118361635846611731445837227739806078810351\
85518549899440506293653945689754828944771412436299737838973429854804524352785\
46962654991565287131097018874118313419021818082299108944608729929289643156378\
80789051931949085471756570087017569907567454296510192066362196233058818628858\
67252656417191592313119239916686700268912127662773457357231129624062028575691\
56147037282875275636747548576469304599135282618024378417855602159905408347542\
05046458901919249317207318833695534295439593089738769066355589995439495209662\
42736009519808111453761506339584359742302467304217716725188416316983491249867\
55424065935884187751967722038894497479823414083566344147954632845241381195530\
48228879170877691235125697971828137886518810693765571199714623636717666905495\
04744839062970596055326133864126410355900416*mem - 
    44321*(-57961506430891563021995574112385723321934630807138751594737349555\
27964158553121615790608333143310661980578576731057759972430252903886297476770\
35241757881412784344943832948540716950991400744245817468061666909031292493302\
00874507533804584921477485345532187305671346452140315657958222982286976612532\
29070971795098673760954771032144883495124504106889021267017988589893422676322\
83418047228490347595851201572588828251311787728187374214215530060086992708717\
13630999434000764925490064274024923859381948261350247106226926033841173400185\
46393809095062612659746017956807207524966020487573519154945402781781447605604\
37220157731915883870453740239888134874157656745328197810406012396077908903379\
89851841519801280244831060656049404782393315583339034683102156018851622999603\
98056755948286231183360000*cM*mem + tailpot*(-2096674866035437084647582076874\
22337243114610213118873286326314144731735891717221114091006864067586984128113\
61464813296121598518453722324131224511784400748440603885522144383398036062470\
77934412008846930117641015485424209569569273658443565237841319968329472755287\
33239344779288380352917044079691778391024962576621956225467295260617483893706\
58442664424805782933658498474847724167284571885002973913160102188961027663265\
34041616580441171207982396051372276140587319633103810447860309801977218500656\
18539038661703611443570484657628295197537978042196474812402346133827517024255\
28406568059494845598553869265095043651800072310796174019350967623087272914299\
63610304580448460698902065247036807365681608791282295647576457429865398371584\
68368628281406771823399502395602441649239716651364423111746255119 + 
        127955629028650706287105431100278765220702788818955427053692182759877\
30822509656365168464661921705115801510472860665228694958278707696364879203942\
01726107035005446031543075036974715406995441948573813503311219611421751024376\
39572868521568040004931363177557308235594020729982503334913580069900460537752\
17854499391020694232371791188662209843913500316700016223660383329562910273511\
71878651364127690351669861315078827136562905219300652150328193843021551434773\
57903423666145059336850019063760612681513106294591965417737755043114305152452\
21110795298993243794223270558465639128563240955988229031642038837373122110392\
69052612496705183316463517413024125575763952214876532089887431731149795875278\
26595373660945312948955120110043773025259864745526468316119107423359926298385\
67666061876145482106455937672631406250*Pi^2 + 4137319695785846479665845091677\
82318228631014573970955402720854293004584913408426506765304165667854630485265\
04090360627804975822170185498635111656317306896021024777109101524848533193201\
47156657886081027137086657261949682094447970888525833331056900411525578583837\
37502717516189146463776222520420412434503154923254717491835492301174378514523\
05328938863340712437554529777890093415730266036516725417936125382362108814459\
40255476387890230208396693613863800948254936914770607323702837286951470682453\
22231918681248654566711319396395356268985912410431609943984277864928280092457\
14687048444683809899182156123102469297964357742413481470579806261799345478550\
00273391052472306714581939663065020508300888075888294240733094683395691391684\
4841913863538459527235663922658435934611667550192497150976000*Log[2])) - 
    1833701462369245018252699203082528012621115519693296671440399098312025620\
79471748712063450459265649850777374318778887338494433341440479148500678371963\
93589385478391462524886828118396558824213023416899720374281773650687186010802\
85177503534590657728831392251684142562985794303501916042102595832755309950961\
43293535723339556408542803496301421762448389936212371594485431428586683027858\
11210044577872483470130716710247656551806296898768289306634985766005752182760\
70589995480871938334513949761321170092664086787162161905121238696763858519772\
46239427393843273271792514863019777932064467411683113854165234153202454175507\
82995015079122575675933292087909548146711696483662510589698614780670477394840\
36604114450890435314894627804381708480238464345888064706611860716144539057923\
717492081666228407296000*tailpot*Log[v]))/50203429384523351771837035229548994\
03205051698235215895870460516914179700382111287971096336591923858390511789006\
28226882832391110303358112168553216764115868632531781528624294228798702907794\
29522862847228877600807090120252106217019290607244327157270094040856756037799\
51199221314047559751675128300172486287380158579776219413322896725162866048114\
27579603073178566208789461819163902236143101994449269537047710541450882726078\
94181653993254595196293322190032851511490938773740170807122785029150446934036\
69294916688393112519740389243621015321563979968203328601757322540923024351074\
23497470085773373110864237308421459891313814448090277358646702078526418949095\
36948539735988742886619434550646750000789078569749561110988623630932269140837\
880699738898958550716758657134108719026637111296000000000 + 
 (v^486*(49504028135391431862144373358520538237638858850218180662663063981199\
98418255652924383978236293264819095753768418822896090797645596797874689604252\
25832417604205972938180908373551483789745126831274011715945147043202104106902\
61581557511154803126164752822216291477941510912659316975762357696472477705599\
01475691617416465163374623502565759080350609611505042748841966838809997588975\
78643824828917752142829503208312939567810097025183622667019422395701203790956\
26855972561955674851922565508720772741917114840016755792801310313618672130878\
66255080197035012138146822236157708842527256507886458173820578602128811537513\
38066730191785120706523708943971333179119839586698653398235410379535350942732\
56674115062759831484540360520227148103407068410105629920233275836677345040701\
09178105028825489940247183184765468540928*mem - 
    199*(-1312625396497721992034657808399678173125917657413440224744279491231\
38444409782438998760220872736750326147775693635776298553035973351927483587706\
16125532023352905508194972707730022597608630086849289935174829591353998075212\
48822293226624931077441807374908393411467050670681268033794109814853859673735\
89466318069485169768929063005605364259798119082551047547544548696578078210227\
56515003418266588417542542406680315480022839090764464676224875558650201067864\
98130308160364455071453532162128823166836640486312709034820817786717248559083\
17104655617676377959869540946114477467509611961906452900116153712859750668874\
95087015025477274590192919696117585935552591954204824632369796050329018040645\
53650552042872202302264919688671183072355541915012618537735327661143685355734\
170545812156627025920000*cM*mem + tailpot*(-471619502007785444035276525546301\
85344780129274723478073692162646947131923258294373004069642577271593177633707\
09686425002029961837696773936129183531878127725778143499747386986870060329554\
77963858912974951036447945483535613921981555387789499359603195231021059072708\
32136570364577839535391915411864570541833744279648256114840712982532003684093\
73115970630181930548826331051597478413519650587542619146943021416498758111318\
51994191526310227328728234968281064077338457902119714660149837047682138002545\
78362058432971462857207720869582907045116594170854795406279608461712107779327\
70107766426711666057450459464480530431300623862063306466266259485901968163374\
91723833940761121896755863014581478096143637996002140604193624505782170139598\
24820142873693432109229879843934128814124438016183090323437089 + 
        252050589233716526758792646583529642082631930641143248381580899739605\
85299571652467791565606043428361129726723359006522678816518753668332437285188\
73376790426217666278204946514050511731765948492248613070086878816585460421459\
44079399221400140746570348622179558321229255615795414422680474960973694073622\
13901495733266540774755060934762469089587186364374213141119385735868813245929\
63899109087179825983648796056729825206607674913890018515897981163267794800804\
18680759212798970986594254863723748682493052988421905056381573212587914765156\
21381260025883733793723989303763326641555184130246360604160022116385276022422\
45819589440952172681655856655872153601847092691308003774249864946708949454002\
93547596794030147167180767282886870546330226187506935267398863237841440244377\
2972740279876178900927438095896562500*Pi^2 + 93541064999183005326386943534258\
34353659289900423638603225908799510611487551277860497573237920221834868230527\
64029871990239483870220689745850118516008550906252624558510514601925445551780\
03261081712359907478916419468570473271747312428401495183963058839628555307988\
36038674749321162579363832148208542477941875596812968075889109067512535218002\
26667419903914608828810176910846789906954881986680163246013427979387934565940\
24993590008671616752664403440383276065023732689212219425667471116783412546794\
06294390057470075310040156540981177478935818826852989734827274197264009544317\
52119643024429452226457624774967984354386713964817268847928035384703933013778\
69581754400144202807656872815275170798162210380651589285647718861626935678939\
36730848828545767485922864901424717289871726609727466496000*Log[2])) - 
    1861467193483741805995100176331741036378198690184304082041955851102611686\
02270429423901707434612414513877787500041944526057657290173917259424173584685\
70163034427228714359240578316366480422648955260759621588304367474245524181077\
71517325189754160864870908608250628968371696275114911353293402597493499953110\
43324376578064710193270443499450838245106816560879007156933225205258511191484\
02151534935248595667216789819897862210973724411725651733780216284636271936939\
72280515323166570782675223989909681201852583621436544986697991151655254318308\
22794654374495723062756525553789931918671808961861460993065067330218628886522\
95607899863650073767904155608266974196046769125628696358723717690239758988834\
27986574966626784389605346376020010893409438916880607729698650115383518740684\
473595335765832704000*tailpot*Log[v]))/51123655177722354146473559296893069279\
07384621420790117994358978527677902629441230113132725653690283493392860495195\
79310419950214158205816872253784892175018974064950640146939133196235140320056\
24096585772787780862617230399293500019644202896463500275044848122969488594207\
73137794345783861176301731336544080835192036431995329249385667171961352458529\
32386021566768033390490650879737511347354373166262257686059614512100535721936\
67672090890626472803790417548728626772850075091823632507927728259110930790929\
68346933190542280794693730774964685910366566398501631117436396051959624311848\
24307622987141660757879132812077282396959723106188756259370752063563084618502\
53095454163689293909811151371435846017391618889573432778639135368909512054868\
329673013196080159632033741454907359100928000000000 + 
 (v^484*((1094504441729680038644785852363868003362717276739232503292832833853\
12790486822215536985349478148816552772749508593817943029965264397307793996036\
21499731180550529344958491223096892949172848700933516866620366001399364988253\
84597898971719946425293011116564537960790224913982900689880199714007485038904\
11227385909014263132416244390858337272059541790504768451380520918728107815197\
38603227732622190463767644053656332791711470239442341270581795187993766460559\
01596396030668500426939128982036328935287437649687841466178900008655987237413\
33730418542060924478092337380149905220553207913118689948563837356451174686256\
70773367452316563850388812694190313591998506873746156428834575552873179659309\
09036219951875873124925120445158238225976519863351475540795782125562884520654\
971439744665234430407619169052887351296*mem)/5 + 1328022404578539250367160505\
83529087213607168743734262673549603174334813346752266914960771016177715760713\
30216396008141592712102218962992580711290083580114515670875140070739885780764\
16981871823453586442159151719485018222457706615487546596798471529178271365182\
49337867100585224451439878681004221031253040034523629637394486844578222392768\
10914243028557104406230631001744394404736392971028517619289639175277103637117\
28778152316607940582835635320648798634773228510326622489355980532963079624518\
23537842313167083411353108644349859495067883357421996530175916965302940809948\
10522664568594220273424003849108723056073314757738776069230517107416908250068\
25950214526386196123656420464506498800727867602968558262337839212206152742267\
0017993932879596169096245312723345133601673690145380892672000*cM*mem + 
    4739191198403997517526457037813800641226527427119860772743217342447408464\
35906416899844555947226506636608916212639929337121381507662136972455272910741\
66284656484446151173123311063115588009230152577505106919538229665853571975342\
86188276267480856347028952715387033785958074539622059783472037520667473776882\
37871786155924365929885647701089674261201846756095786843160073105127001762877\
44976892282486942167184843293407538212405442346374578433674032949458237269805\
89978645605952489071532594393828149547674643782625105682226297981096671763241\
59886724527951186391883214481647377904170577854344293918857149915120643506021\
38071407476280435872304313433247417423997752774946596480931238721595227285921\
36865168099535435531164955087506665306034968651436084242700773911627749583343\
13002908576020575246*tailpot - 2217929710761746878333364788630704855472813784\
30532233560928724131454195076836659023163526637683391179170434311527613540043\
47500025132455862083794739861324282605090824151702025942019174648591699907856\
34032832342424746911744465775217984622957619062879401773913377801566524057028\
73911294281766660806897834338258607581030785568816642693538582931961688491638\
03929207490750811580189292895453552172382934916587892751348400833192711935325\
54491362647562120171298456091159576598441991327940754827514290657768402969417\
17142990704431705016930154586490641946949727857086783394104573593810909101942\
24611277774699542655543434049541148833343583315814972171489173170304962230814\
13394325582181951303504783686579117899540060118884985575159906859827016798478\
3057252785080679885954407371135578643347227583605153703125*Pi^2*tailpot - 
    9448134456120008022367073836249732129855683962703439513306980270114514021\
84208763229513174743479437114004439981728662409617992604305062298760230192551\
96117515812990817748688553014048901753115037659428670958742256903587644308924\
09300442056295580511810849492996014566404982813599455640229085765190524033164\
13349727490811467689372124228703068848999330848899767001003102760685980774368\
92886787363478123001813905899720575902575832147952441684114837563899786165356\
29072411161884622242275979675663902762332585312440081639765862795309240817141\
41163632979024699324502559332040288910149374937812575924947845906321023444040\
52930538007968622427672019872386264740315782621460463833235945732345447602140\
36798974634818840228809788058165522258698802465754121824833089260098738616668\
9776192878387200*tailpot*Log[2] - 9448134456120008022367073836249732129855683\
96270343951330698027011451402184208763229513174743479437114004439981728662409\
61799260430506229876023019255196117515812990817748688553014048901753115037659\
42867095874225690358764430892409300442056295580511810849492996014566404982813\
59945564022908576519052403316413349727490811467689372124228703068848999330848\
89976700100310276068598077436892886787363478123001813905899720575902575832147\
95244168411483756389978616535629072411161884622242275979675663902762332585312\
44008163976586279530924081714141163632979024699324502559332040288910149374937\
81257592494784590632102344404052930538007968622427672019872386264740315782621\
46046383323594573234544760214036798974634818840228809788058165522258698802465\
7541218248330892600987386166689776192878387200*tailpot*Log[v]))/2603037432674\
25428444366391532042104272270092740366095620894041676562011335511264262379466\
68297812034080411713315660861019345733918442251368241027744000764713547095246\
44332683977577571997556294505936139143980695652608472469119145603065320593864\
57612244644210638943962361157728836343373786980739884752753606679838922199354\
84976505433665791000298010813952218267211476094228659864435404651444662233312\
50947350379389513929337763119760228646969083696049773356854723668537428300592\
28655436498264312274902900628662586076490875493570813389240626800741669984808\
10170246415743175276536905514644754946113073211768473120024561963326023736698\
38387834786474353791336570931540436033059771375313206284920876649267764234899\
835979589377235718536398591123880508965384909981351397907706675200000000 + 
 (v^482*(29811354306198179319605662028099903246708980712059517121249987890321\
09603729862437458637318597271565417082371234403936786787180042875084525888165\
37767232209976799649421866027319539521695332425481275697093594513991322100177\
94565128443565427274686478091157276119125567932762608242421065782124557604500\
73364944067362184238680986504920525620600885904762817915104471903580163879687\
56410827589773983578941527127702970732999495663916579572970212204678120676500\
65136336248583935232078639734200430885873441205021258372901769235963333687483\
64702089360848833177007636593044462133217775405365248109001451838873708143360\
44480712808468190270751910199936206593193494513691831002678381546940884032442\
52617395337733316041296039488702393609341847551076843373695585543043394730154\
15858933302763290016594584928256*mem + 20795819928019751194915602826019032505\
19114831747558731525670390569807474947249063230089355040554552926940634722722\
85547670467383020057447252602366234243789190304231070329872273163847238157015\
87596013993152319190312299035198945586204168091613910473756224640642586942015\
32143376902985878838332419826415741831899858221556090715137466346407746164778\
11673617595932633012730961232184243889347730089549474189474974357437639772559\
22206731511269208729151285704004625903481992789500088406668784979605688147802\
20110806160518572665545188471952324142207794208555461927863596328216199307687\
97978287067270120436230093469745074300465044631695144820270450153183920279909\
13036006972725721495494054603265993464387411068316030648365347452040875494565\
5658309353172840984286442233413163873730560000*cM*mem + 
    7370738545244698086380455171437214666797100052967102743625454179080160478\
32269811145110977372959663112109872858328204621756891805522393747003868383233\
79564260631069502696869420625731832534052958615091784602753970603635775558564\
72839727372959704612024803088956189181820581976836926721990593592544195259022\
82578755274845516253840321258941995565531930720898820724014092503786127961655\
39148845110494390722216427657685074158912041871692845918482894316052305098074\
78014546135914112066958466496127323345308326734449879073096679098995145465720\
60745566815972263140910117684957521658024169531514013401263419636480533193546\
63897261800195874994000477150234513194261550513451203435375756962822820154586\
03044721542926516212675612625375095934679662446566778932019494899321994480841\
705248845908773*tailpot - 302052170429256958164934816267657835899855489746074\
89248094473116533114582229855789329434836819662943696188075604659549770154632\
04366563245857404546948987010131045845691195300040118889545568544861208889847\
75768829486649975011016704452898260485405158170411385212870492876669503629699\
09124432551342269981276377962117325158378752780343367869405631310775361475765\
57091349178366699669692627072828964419236963771605270223533006240209823419293\
23051997718343774329250323154579419726666184431025738218462529966284143405674\
01567984825124391705060436188623164483166021828875558614402056682096194342189\
63727237501838936969672272933707963737290768634984132034140092423791294411323\
05644915829560457507900285457155976462722666783125148757296367015375094957449\
026123093517603599075884665485422401722501406250*Pi^2*tailpot - 
    1477042212882239097728792579966012127954479565811145902299280959067726893\
12174829854447011666458269897767697424405013925611203815769166231514925017495\
24804606661999475200451904027061691002436056945996796482471926480826343228958\
06938199106004230800706600676596235949638051722332044192005214547975013210465\
39062538284303853226475642805515118304250058926613525370677891416024535215602\
21038005802285516406677681808266931635198497086583010505202963253740092208237\
16740754172071221981499907323373002953663040549790786128715174741394295454317\
90936227022040459951298967501248940567546748443856768300766153270541909368080\
75168356151924354728831220653476798905871431283550216579163566741280424216010\
60366796917947133310253150433572503065862074544525915631797508600314457616623\
587289600000*tailpot*Log[2] - 14770422128822390977287925799660121279544795658\
11145902299280959067726893121748298544470116664582698977676974244050139256112\
03815769166231514925017495248046066619994752004519040270616910024360569459967\
96482471926480826343228958069381991060042308007066006765962359496380517223320\
44192005214547975013210465390625382843038532264756428055151183042500589266135\
25370677891416024535215602210380058022855164066776818082669316351984970865830\
10505202963253740092208237167407541720712219814999073233730029536630405497907\
86128715174741394295454317909362270220404599512989675012489405675467484438567\
68300766153270541909368080751683561519243547288312206534767989058714312835502\
16579163566741280424216010603667969179471333102531504335725030658620745445259\
15631797508600314457616623587289600000*tailpot*Log[v]))/408226532305459401325\
03082936184290160089531391593774536245965627166096200109872613989093207976344\
26987689872528248858459354479279773434872087883924606065970876249165645373421\
76253294202872907589057261582820443912280673133202440479409450278608052144313\
20892696714991357968755175762812836443154379145892012071471119085952930432338\
71964214850935631534032328044515573353352437279308153223857671490313190217577\
13701270810315310567592469687480775681368813178828992240493789907334947936736\
77258044013218879350171033334595230916283265104934084590505119353414035028218\
01002727003392205308694815970755907130991597176281573763574843654471197762760\
67752557397320648092493492103195261844930495262505521875682369546325622390857\
20231660419424360111219829240999984996591909994496000000000 + 
 (v^480*(13288341571649169260170508767481919767628556132422919483238695829594\
53312680259687875771783896800327144785438625741824581711329355540489113363105\
73492476417332202528801059192964523231712184122449694462132105778436914671789\
17853719251523158848865715635299000283975199323187999073285075294025089401634\
39923926517796375675304705223638473605528723147868942859653287814115089137414\
21461390590676579559106261610654850478698584272085809549513468384882332221654\
34593737978790770232647458983196869748743081197563454153910671608928800355232\
89702190391540671750090732928180093134155247463208863638503164228426743494096\
22923181933414936747988340271414370716163209801836810660437955282128380752232\
65638535864744095032508598334569189572762659354181011258840974263176723027669\
10335010616214654685760454656*mem - 
    16987069*(-62750222936021891259464396473814426907174619076319240278218037\
20145219716033475024502668317530251451670656212764637160554062344117521721011\
18835230995272930859146607235597006053046628560412635513174364643055256043509\
04705898118818178145832117469983517986412236966027698262215193927582338036288\
97732937842235881476855749618494851879411276992185444253453141133398583321505\
67755261840076721779586329277810854389163327852063119126835020062758409109963\
82136611304856782897279888361141774539148392136042864525165702281665771738693\
54094915160228562623023122338366537675072318883833139708492822330816054812786\
94290044967155753449593122177956533944928568354869452410837990468705976799278\
15572877811832014368981037937142925304347540604486215803494545730279148626482\
35130880000*cM*mem + tailpot*(-2208892190585249840417735185694160361879099611\
06708081776636791595901851167577114699004984031765362219913068078581200427808\
71915869635996231939370773414639781381910762988332446524855989267623206265790\
66586526256237113836960555222714767778965000140193151262889279629327936748747\
11926515250358061045500312646718739316304515899803128169562282381533737617946\
38627030352768426465494947520353264223163390755197954996822089819440987549894\
60078716705931573312933075914956769068183400953112726973572415335049915372948\
43702500423240087322070749879486328676113124181828749573574704930079990345726\
56507560173742521351747897458009269158949822916641445318182572396275571314216\
39278562817065571988710343529054142168632194480904795991978928200120179673907\
85060164706250201965581550870081 + 792597296618373674940102543401413809743569\
58748341043019151457747707560971940253673785590379566104831307774128728382719\
21442695638957801512869616252161942592906849081216194474025224640426641302514\
97607258975301498209895431647838182683425062079047189022835102360189996284058\
75739859200930253858478412669185886293205444661931490549290959987717602587870\
32693291977762160197046721849305901509657717185213882695285244381245341136714\
82944686315503804890697333909754125978583394926406336070028566556713342051228\
34375846611753407577596635883229628458805236990706631675555747122123757628213\
03817149707882984347607831440050290680483723006830888709187330824306710006975\
51419102577510964121640682337001406709518982859556852102598813159217556200269\
3163690555005774551698285818849620926108140625*Pi^2 + 44494398913632614108522\
74894719298803004342404164008772991288813351602465230379148748810258645331417\
46013540085446143008975232273225635052234564708658934313867946699059586314952\
29584470371216921498967475404875285993044379238849507393830673336999526642884\
26396467244542339910195187230794730611845012803499255987580776860529092164504\
75059622034242971627330147796729739774963565778909846304086360488015615998036\
29071027750221671330864604282444723049993783120228308787279041713557161121491\
43750647657628135704883122452298357473606734792105094410198136532748759455244\
32236106835036889028764481926689766987107396994575418610568729976183988134222\
32698608337282400286565056288631790821471875481315542471870153826094882463451\
430774232260367203692124693023149159657420425728000*Log[2])) - 
    7558294244594022565118494244356446439825217171915990434340835947133179233\
74385514959573035315160913162631248036573952707732988991631071520112715489095\
42146561424674652474278435503812223952431745947054393345841941955857839019250\
40627150118222920712120500133509821043928060147593944895742901373982344979892\
53029096977996034110651058015492057860960572179849950640324606390935056437238\
03039469099875687949420361463347995429393029619271886260358399913613484343435\
35771228154038420737314148924318317055481751756021323803264140699082328277818\
98939975500489532239365306377158057109814325147696523923793201340391546315724\
52616416151453478057631312159298531602939140615350038416387214627790943036051\
53307420888620844877689535394327106068288836544551769169880533723926171338509\
11232000*tailpot*Log[v]))/209561874900133162897859768666243789322841536917832\
51815321337590947687987736074237160725466106952910614424396962263133774920324\
84483282788546141645074982531250641255464770750391444015415158663188178960897\
43554369753938980083388336452489876082162291741893699675128292392036730881739\
28560802440646378794667387818849633446062850276550124306216302009928297371891\
76372357983797371308086870563486391331206477195655550671510858883817209803323\
82328378526084794060057618323300773785907565059944856488774224226643588466810\
03711969344591942984643013606324103395295189023619110508230966146348536016276\
98104276689731610000807886845402286689526572259074705120109448912179124702788\
47670351607030422230760716469388884150730180111500162527820453594000101792818\
27507698455805952000000000 + 
 (v^478*((1692217715579485547255832242703914878687869594202784075001623215490\
53951100974514936417763000251026350081493910207919206440478916415622613907447\
49522761061156723902238845667485853374829434138997636879731771811403401608689\
86179910914287937382269098407602061991936475862659405796316546983629875366581\
02677951867544472110476877204251543289030170129841390233232601114558776824635\
96843688935191564626626559436898774403633332865650724958639849841982186076803\
94738941418399637224876913829589454798491288845230799780401155140131732158031\
19576378793801630743949989661315997060894481581391499315035129979323160618038\
95318937017482741368660062507868248698787891747793132689579353634578683652045\
91743876751088153111387308127591435275276120753309984095024069389097133550553\
58478738568339467446255616*mem)/5 - 
    5*(-624424756958861444030464983359822638571103140623540147277705083426246\
27316139325200342326809079334607148364606826276584782920288636417729320583342\
82704520205811168192747689966325548113278262649982269927459795665963877149478\
23153744778323198112265508910823002992953540176885860100512786720637059669064\
16708596167054056616061200639618265875394644826647761859619193510845641233322\
36287748066687945910602045945349923781723208257798258192930354543526541096883\
58244658410978890847316127318099785738587006490718307567000225439526083919186\
00051630284280605627438733405154482964492447367370237956809286624966971727440\
87465597938708927352911331550144574822873728469068386887198224734719625096552\
21319229164130877905396370153205563883027614437088792132151781517408597758810\
521600*cM*mem + tailpot*(-218298982708088808254170549463204068577012045553186\
05576575459095215064044601038857984449941300251474359807247346825292927316992\
70295132806720183799485655976628712271067812803208651907757266532939025824263\
91280852993011536416211015264510892675640502900116016114516517948195389702715\
78329845323716351199398625633113993784458932205273999325211177883550016789981\
05343558081520570717498195711575621770766330294375781623852713031933585961747\
27900838663136178827461203825342840561801099871322856601609975839285820867404\
83438043798485154765950698561373645156574839950733806432944994353679927580433\
33432912355520084451799225957182258383136429657438428034856076825701112285774\
93389778684740040279077774888562148784350329616577683492776869370769395929091\
33480309556001272113981697739 + 685830007694396925078321173070195394234216827\
08970173876315859332844434200019980990619493380012111493249917402409103996487\
68330467981184184393178270752364089222616506762087342327593958267865007966391\
51302000401153173970069484310327273797915938912575490852772304075529371083414\
26986967105293676166510300527705394113471541078890797943514664528401835425198\
71918563403166041325968304796295841706555078876267889587056008800814437536836\
04277467913642041212480314982120978004613948274885374110612252125103469476018\
34345995460364846636848677082973349300915871412281593675475679052630530911758\
65091289304607346091296547254605593826107162587358511381408272478593693084601\
77611274763887893278006960794878569342994825216135140805752956892641127392949\
683561547057878526052469472207730303609268750*Pi^2 + 442018440209166965521937\
02718155432775332897045689777721572141021830599884419677444448905077805651559\
78238187554957076920488195714344284944576826341857146610399383198516621985676\
03993466322655004577404916653315515442500742696514366638954928284812603093524\
62537260923965624945132286076646407501900304276482301315105524127761010293399\
64472219447981920553024240084506160365987257668257783876713427743451719861204\
59678074808934795511053163147015540868459412961671055628945727978495104602854\
20936101257553590621800161428424352568135634109974431705331157606010451493024\
97417630681542716063003300759425832348400070388794852475818319533974482729240\
08627739254577299391668615739447654705515536647120207529836903059583022929184\
3045368687092595965138759983552558880952965473751040*Log[2])) - 
    2210092201045834827609685135907771638766644852284488886078607051091529994\
22098387222244525389028257798911909377747853846024409785717214247228841317092\
85733051996915992583109928380199673316132750228870245832665775772125037134825\
71833194774641424063015467623126863046198281247256614303832320375095015213824\
11506575527620638805051466998223610972399096027651212004225308018299362883412\
88919383567138717258599306022983903740446739775552658157350777043422970648083\
55278144728639892475523014271046805062877679531090008071421217628406781705498\
72158526655788030052257465124870881534077135803150165037971291617420003519439\
74262379091597669872413646200431386962728864969583430786972382735275776832356\
01037649184515297915114645921522684343546297982569379991776279440476482736875\
5200*tailpot*Log[v]))/6147312258730805599819881744389668211288986122553021946\
41283003547893458132475043624544601528511379014796843560054653381487835871071\
65819552541556030360297191277244220145812566484130695663205138990289260705061\
41676560251689157768743106185863366450329771009084046004470285618389021392948\
31400429638568338732408883826149781837790453215732068533353180648206861008029\
43912695728111120178074610923770349265978165313894734844789786365790651916200\
75638782188150779044245330031498559916839540770210876333946220111131323263042\
52547509297242142652203177591768709157788900531255741594782820432268004604900\
05183037008213576060042399597732165637203258278237609546756004081100111131613\
47949751552426833696581677585337363748316559113010496346541331771833171553977\
03093452800000000 + 
 (v^476*(12242824450935994366388697510695962070373790250870449246940958287248\
40648541586417968487694301372320063686460831739659938067167709136148086034251\
39316811862734705533544465987910859232235153770666667180031102349950649946965\
25309299320752446562839844674751664846018459955644328232220514738637923596140\
48627797399329003708077327836643574950393434751919203645760897171625489670042\
05384593831893999155002749353104252566679749984452039557586965386046255594167\
50550435150466273223849954869005623148993144721539513571696957664757986540863\
56393620929266220572766941459462052583986556546879546831687953443241516549289\
50042123625870273930692713579648115857223091400895130571000946732422854446570\
38435901541233735476087265746648837324072814913334762934720787813948076938105\
618981667273128603025408*mem + 1298909843383064946195331338414250349876214269\
32111325840919912050559690716419691366209197079033941153971368369548716509483\
37138558141352841447825781714919353770238414771968932571851215472208973032183\
24148499899317698108473354489267382941749639323357351397768873915956447719430\
42698475548076924401966180492374856204366226031825546438117196095441859870119\
15156190644804388940340071205437953840184171621654759849422040743234765034807\
70783752173742119715656672911777186632070938698519234745260810292265659421002\
75853537369392078580193172732562150119067018542904802773718728977806151636847\
27187496479925042267743400134060631276413189228350299525601385480305433394996\
70632658667833798198010415809418241611167411499893822290715580940586725286592\
156451593387996719528017920000*cM*mem + 4509733973394023601028984108488441350\
14033145633060737016434777147326393196344712662305976213910782745167716335556\
23299406573278995306232679765085952909892399189298927184926308459470918475191\
61527737616912894458995217320915657805698023956815669875618635196174898359634\
69878958359879033481041666928889800219713197767434587939669862587097767376885\
17392798453055227183607361765458492519810112626617247336674756175172356559192\
89544455686878316699714573596061464535411138858297970581195807289171918989579\
98419334235227718124508175356431546574093596529259265166074736907097411000745\
24601741532258169420031854688340376464857261055331016120786444680889675393741\
73665272690653385366724666884453551008954159634748757223366402619319090406833\
0836597840294507298927003527079688957922106*tailpot - 
    1240457464498757557500095850967486696733284356427778625450430993708448941\
56530892689558282372104595094600451086938106728063353070426220958098596075458\
43467176874629081775264519961093199757313502165045925342953813986093861211935\
50401873091526290008229276687598132819921641239294810891673877351675060750440\
10185990818881087090256363409249709868344765849442151975735382285835753376017\
68543250381085195575419408208229295192176389826120019031197922575598929770067\
82827696200392586796105238186642507532211822193513060579808944535866103160358\
10240357484041471788339616870100727897432049889929543952510734671708546972024\
30038733020229322496445091712683108227237618512393313918629157411005305243290\
75985895367382798584874805061260186531443243516732789009507110290008879526934\
733605385551328125*Pi^2*tailpot - 9179234221395518293476371132864418358577526\
71671992260275972764199764493391230514318635349503271047692500819244602084915\
24181332453512184510300803439152606865292774178601387248176790102008250340070\
91708540850952690894593460954203947494389078636716738308582258519571222687206\
05508609741082571119983424299182967409632852219224755960580442095564372269635\
65370900261309720946315272856090305481500740195983629756039351999113322067721\
89758715600771135314206554870203531096490990549741295823604364717739033567241\
27086695664165069796416801199883231203654209865661263736076594803654004618068\
41342010051983127552399334976365438335620126789243215219872498279236136599909\
85767312552192842834842259193304467528436023254074695915058460070715584038633\
749128466594132684681742299136000*tailpot*Log[2] - 
    9179234221395518293476371132864418358577526716719922602759727641997644933\
91230514318635349503271047692500819244602084915241813324535121845103008034391\
52606865292774178601387248176790102008250340070917085408509526908945934609542\
03947494389078636716738308582258519571222687206055086097410825711199834242991\
82967409632852219224755960580442095564372269635653709002613097209463152728560\
90305481500740195983629756039351999113322067721897587156007711353142065548702\
03531096490990549741295823604364717739033567241270866956641650697964168011998\
83231203654209865661263736076594803654004618068413420100519831275523993349763\
65438335620126789243215219872498279236136599909857673125521928428348422591933\
04467528436023254074695915058460070715584038633749128466594132684681742299136\
000*tailpot*Log[v]))/25613801078045023332582840601623617547037442177304258110\
05345848116222742218646015102269173035464079228320181500227722422865982796131\
90914802256483459834571630321850917274219027017211231930021412459538586271089\
23652334382038157369762942441097360209707379204516858351959523409954255803951\
30835123494034744718370349275624090990793555065550285555638252700861920866789\
32969565533796334075310878849043121941575688807894728519957443190794382984169\
81828259117294912684355541797910666320164753209211984724775917129713846929343\
85614622071842261050846573299036288157453752213565589978261751801116685853750\
21595987534223233583509998323884023488346909492656706444816683671250463048389\
49790631468445140402423656605572348951318996304210401443922215715971548141570\
9622272000000000 + 
 (v^474*(11648660242252248070438463259708497059257230915091059140160428449660\
96151565243805479681713796081613782580615198516241838275587499925165240577835\
48115635816868979382612508210563930453563655342469925162090288152197568104874\
55999809465811042287417216334609955882728085352600038979796978823666542193044\
27799410644014214408698803573967869206205435059658148406905949754612848598027\
97637804497087331470143950798879731537976363320758723944699997080539248761169\
47846773119037946311470722260581088574457671758013076262311911035980365399371\
29198082659706876886387005418908369224009477823355639584008136755133370233525\
84384756158244468545101170903419577411377069603716814124898464149182581972726\
65558768391182199788148017702740062188489386339431591645673274507917974260030\
1537462502507799379968*mem - 
    43*(-33057589364862817803961444927825008772507389886347044348209801110788\
92525660880598316597906377928487446338397095893403529106638810188027753885022\
64719248247866278060539380114071423055891305977137158541708323105903484034530\
73441460375706780043406715762906535424618849222823907410289679542006565558128\
61660522029775906612258208927673384974098419206978020815557759860250478927476\
45963926531920545380871906025019711039864471234731398938820296675739902110349\
62452682037239696902673698988721610363653184880846343376365480771770817597068\
70280963509432768167694057963061883462897225905942025442493716976707276267521\
46598052705647981946728737767999963300839988672730760058521060111714256677324\
29256813151730531909869613537889383351455347204131709108412854964788777713664\
0000*cM*mem + tailpot*(-11398068990278340750770545431669860015456405931721617\
02161456536946735289631572611160800621253990925774932964598113792271890839099\
16851931388804425802374427097619996394326120328102311324421378444384429917202\
77801586434733139858572040709559402521489997099281599230249484320255711867838\
65135634681767027282485143226819211830042160602286411961373480579462552830744\
64440505707196139949363760435068292005192115625966836948933836327722459286966\
69218558304608787015237372126561107705320661069559272323074724020639931517301\
73365703959460429827169398428757225763182889656546554880794773059581190746210\
95588226276068171783128673172689319851573476449517289226572421164236597903379\
76513727415218058991643159383808910968583783888092457108693780604312636226140\
047015855670132465273921 + 27447814967381486858798890340285054356944926166295\
42655421880759000545801639134227484090142069682143660780694970627304179156708\
92530958625626802913304062975383022186678369918948046551356761887366731962296\
37363754045196159933454634527627267624934957545261192546521159321910421273236\
94398529969970134394064393134463838373620552400928307378430766562889523976059\
21894627389960383167344612169244805879223200856781767637225471822981204463328\
58235516398844815634959525384216818542950724570451188255460445804404085532044\
31207496755747381845602794831406083827453812130859817432080936334757663090735\
90150631171591115330301567831665185755282334771935493937887760976774296628391\
12762587364775384342955515479858126100909023350675187954751161912490139663238\
9549099412999568706811145067275625000*Pi^2 + 23321835874086579018403401352609\
90565344056751048022641078272013669274958959633382947593198623298946814251979\
00085845296701262542622266371459026178003740432282865508304888738670571689999\
19185113915552676703403775620084541310511352913995197661212458127200206621880\
15943422720830208437077127674067265613241201305196600557779409011745081543057\
52579648805370086772933644206401178624286295800838639360219410963338799447598\
03535500707949492633114434153827684655607512068831867019296150846037861311327\
49306554755831026051726243040547525288342821571600166677838068937113881581027\
80704814780479926444913967912224362438851853897279370651929724072574055853093\
06214773533851775203791135381236019728386119126164671813226260819683880995239\
66079916976754272671444326958194067456000*Log[2])) - 
    1002838942585722897791346258162225943097944402950649735663656965877788232\
35264235466746507540801854713012835097036913477581542893327574539727381256541\
60838588163216857110215762834582669965249598983687650982463623516636352763519\
88175301793499432135699469608884740846855671769956989627943164899848924213693\
71656123453823984514587505038506351473609248986309137312361467008752506808443\
10719436061492489434671423568376246715520265304418281832239206686145904401911\
23018959770281829734486379628036387082201818545007341202242284507435435873987\
41327578807167147036964295896907984195703070355606368371313006202256475848706\
29717583012938032978135120684401683001672352619556263337630188213931488483206\
03122425080887968729215246406882795305414364300004337248721060592023449006080\
00*tailpot*Log[v]))/280735815573562364292400653775624200672122278561267964671\
77590193340645922020650478678315570847988342272820360910637876242268078663241\
17542195921791574387267346951393143402191841002837093178731556184921874578744\
24164416504593582862746237611192361379882548692512539348199369315782553174831\
66773274203929874261887961789199327143353160948098119346765817702557587788400\
79520290297350216900588964420618768670714752069827400270932310546284990953844\
56364009114401443826443829726578284302432055007020709405164018645089136490720\
76151912060901608594873715699249504857269726766637468446501455022677663323984\
62168965667373645748282862631296708379585124919515049760516887837296306897797\
21087296887968657855374106846043490593788581622347823759063950957934504683189\
0432000000000 + (v^472*(52773357808281469464532374099008026207915031288934492\
79214031427032397676490037746471347616081383283067403841702888588365995331680\
31778747544350969995526808834193041595832830492927692323042253304889030472283\
00280140718109330698282162313938204148483980442658752299414636669533728378484\
60887062420363443008446429407928066233526312942920517617519147390791566155024\
64092906986566004235625161989136023579167687131093050284100598444490257724761\
15144784257804770080904532800170461771832838157222857041242436960853881640246\
04031295401408245808424794855037974487644574070210258518393405887195811582734\
95865102601223292846783498082494816979699842029234087806495512012969456056043\
01968987755579931586447829005897414875808751619172884524010409385089376592491\
074109745754325433503100759441408*mem - 
    131*(-5654658080415155907822567930066259175020152593442405596098872289444\
75676572795107822835652094468944616679166403195277879822355984718445573079825\
03398727666888180425536297077621801443302871408440971547037031552487605442728\
28646063481418864726231742651884195087283914297961515857262125877897230015059\
41681536944297339778631594094288607376659113246728129057038186164298012379953\
91762255218740471264541358412614793116255455874301796527561673504566035593481\
24530945163715617852023652471279679616726553084450532469533793517872187327823\
02341780525442126013258227792030542374010756571684585623075362769272432915021\
61713217832456724449153698313774681175639885583471059152390802988038148828467\
55850993244623729308819111360957857401134006453364678176872171657349824512000\
0*cM*mem + tailpot*(-19361651681281853295185946059904741004892430713138460446\
71120095571635396523144342410338886779703322724924514127760605516947732951263\
30771481337220537538655381587510330830548481813071910559388655560254384240822\
77244580912109290271271227395936398349640421143390293993586767974419408100299\
03932425537181274186005546745611009948911659722138711675068863463912365390731\
35229548701003552858382240846254685553421960324660871557933351481722551857263\
65874191078008391620489786810894664864955021051417122545719485027010344868569\
03650618042993759660708197384822732154753040369955068578588939464484634596055\
36137802652668910980210456295172956568314570774957457446195083336853270265848\
72803543595139137277873106649460640921495147517376552399557751179000542123770\
45645918248646731 + 408172448697815373525734785116690336226596844833868449136\
69015511848097257175071407145328982250204512377505586003317956657403234186601\
38016446516196962955628650839346209469576434219401889767442296198618285689873\
63762552319770884297636756053400743985989390979430229008934932597895925264045\
63120048749547014702236729072239077812994008218116410752394621274258962736858\
96798427883688566305462046412283232330692732464207024602565096914717544336126\
59251977174968778788878953998377671828521517943140094689732756100909547624798\
62900943578250771739920199539753765028624731392495622379872348041262721351534\
78817484787059692901981929757244805609176792243530642751076932415482504914247\
88374606095661236184844582409587676559781173051444994292423643568346643901138\
18908430401278657349062500*Pi^2 + 3982528839278066762935106499756114340370951\
63783898490415385797098492437934283159405040375553610601174035420090678051748\
63313972032666086464568805446710178061495311468267557580469828915955850889519\
79397939251213364971171676414611001783377149109312588655975833079137697556343\
25898543760552173728566093267265537261585590991532254036707631321776304566587\
32473075337957058335356927805600589873003889371016758553909050276796352871910\
33689167831688913335961071798133021503942798222925725783143815077694937982622\
94936943638724571407383525476874002754289381441064984045053775206204362460942\
10427753214720919738198460194050745195220258119461723504928676355281966909554\
31306986013068863176809802410354267111932059868417241954203077522319621658523\
77898931777968378763264000*Log[2])) - 521711277945426745944498951468050978588\
59466455690702244415539419902509369391093882060289197522988753798640031878824\
77907094130336279257326858513513519033326055885802343050043041547587990216466\
52709301130041908950811223489610314041233622406533319949113932834133367038379\
88096692709232632334758442158218011785381267712419890725278808699703152695898\
22293953972869272374641931757542533677273363509507603195370562085586260322226\
22025413280985951247647010900405555425817016506567203270077591839775178036875\
72360636739616672918854367241837470494360811908968779512909902044552012771482\
38341566035671128440485703998285420647620573853813649485779145656602541937665\
15161501215167712021076162084115756408991663099842762658696000603155423870437\
26661504760062913857617987584000*tailpot*Log[v]))/146521824412088916645303055\
20648444711488636668124632811679326823246683675376122379268431926329847777804\
18599212455003979241548990774591619100167949673479784627845194751253753570460\
77092545862816084808031032293540795624480476817778051272239661984018727843785\
23618963893495267003264779479732136364407061521013511462311690671786718768762\
05538588035794243348517107954112484493892145207150620545104707081769684108595\
94331955685402429346815811787294553240665136452936557322404268415606697314721\
82709259142172163104860985945759995778737422551458702356836769052639493594345\
84419021216151097216997041961619086098991322362081567256070614148423583050584\
29804267250359490464316643935136266856413344810989234920065784702815129739886\
4028307719540453851432696676352000000000 + 
 (v^470*(10625133563176042606501179829982035531530548338072015806028613681451\
43877054838006343992163725865256503622979693338591268082876149881508897320647\
82676617821308912056048417188764198270931847085259559572924101673230179843963\
88480981297608429408344459578695753364087099356848407789112303724346268109858\
02313051138267840130580741907963883957711809239221286025231541634178386027667\
40716963620767244629710454079074331652624968985142880667578638422220573110431\
04214095242221760566071809353538813891868203424184263481902191637782789783512\
05764588411496996012020192129021404158260495595127663944875661599737064657676\
97556102279797381921240439182420316269978319377795848696381142506772054326186\
27134350690762054957006471955416662432120456340672356733350416921037555734156\
68075695439872*mem - 13*(-131973406908076129005688126138951937208854834152029\
23026428793351303653047453162780353707224370499803225394583760961184274899011\
02883973008312551727422509014951104146727986480173818537628536082096979881126\
32578625480304135286206345028500908560125221906085576917726194204889487539895\
74252187049270374863671830890324292180655982634805669299154060894843781337267\
11182506658751606851945367009895344255279072833765643330548936219592230293988\
87191295758021438903215381800411419608630357072574447174046953244623423356278\
92511219849210907750735669370349112491104297604199305378388628461154193665147\
21555345096791547286818834859982966276039979456220304796183298007374621103172\
15729029085376887799322622747508341590868823778855544223045718155001576263513\
26492360704000*cM*mem + tailpot*(-4487310284146445187877059239141488148502115\
23133604651250724742275617559944360549397208381001586159183214970833551437824\
08323825795685563729933731863389350701430739147463298675991254767279641720649\
32518608823177085435682555500393055741378692188059307133485129592943114167920\
32398302590901175631711427280089911275565545969102893617391002691543811509983\
95047589543364718821061778718645961632172030869442288702641373398387792649731\
16434775673947388760393875994670764169968313499063803901578831311077912063062\
42191831285079283824692668812156365689055079724883787440744968058865788583675\
97826493920647212098860524596911477875303819389045647396461313006669892808181\
88007050693550654101193314149095396654319675298425368067371892712694620235618\
33881138607328985459076573 + 828116237680643147144286369972182599445268520605\
74399826388414553119677942658834472834492983684816042615632531600619423222613\
09355545809986170154617580488876875728488823048829436727357281040680034755658\
02520222139345695873206733390555837312884323823974727048875811867536527635214\
51962044150638045743667017283362058542507392807607865321790124424453927572166\
22012385165933016471325495635434535281342305182296593128950038395314739031522\
84833827056211717110570616984124903847190500336053884791207389758640394266372\
39474741354502067904329500834065146429640234144208324194784691019623561013981\
90827158597248692492089350505316720265490058713212914646725861464428120087204\
13259403250614860579529920710224510491475856485081733817934356985450640824961\
3872482265198099457873405725000*Pi^2 + 92789091613515376099603519011828150765\
66730003136727038600870904372113990728412499431425144986878221767955858930983\
78161417817252851545428292789655305512048947830503828026624345192197468765957\
34822418445547668895428414288793274766235498047456775250610898675733625135639\
07174925947749681045048879511644321717195832028684272225078136517641065869020\
83420306030350619204123521750566863941558445109203174675575082682310507546327\
27211770571555582601565132873125709078269857752695663720518350261253658884191\
18782653706876289068375239592930123771679196092222838674608514505954526550022\
92512548754531459180173506999530637961211519406712432860603085261111895754957\
97060169280610354625922352466500596777329334729255778530802983237822923890042\
313847913086948825454592000*Log[2])) - 12062581909756998892948457471537659599\
53674900407774515018113217568374818794693624926085268848294168829834261661027\
89160984316242870700905678062655189716566363217965497643461164874985670939574\
45526914397921196956405693857543125719610614746169380782579416827845371267633\
07932740373207458535856354336513761823235458163728955389260157747293338562972\
70844639783945580496536057827573692312402597864196412707824760748700365981022\
54537530174302225738203467273506342180175081507850436283667385533962975654944\
85441744981893917578888781147080916090318295491988969027699106885774088451502\
98026631338089089693422555909938982934957497522872616271878401083944546448144\
53617822006479346101369905820645077581052813514803251209004387820916980105705\
50080022870130334730909696000*tailpot*Log[v]))/339878971032449354315247170509\
12653007396512800103532386173339882270201056312044489140412726350841516595189\
03299594070933058568756146118346323748433480584051560763615753314204524381282\
59211001661064272862519818002309497751048057940272030247418195357754218940469\
00867301079255400753373880148773751814106984489704157531177619547016397035619\
08114209682772787096051853659207826240188371956902215506163492854753209454751\
37916226867152277466508437240902901102149044158100956632494585030613116960860\
80396989497014857019220472651347201896132107303879278211016127672218961600195\
29160789030612890273815730965173043357277573838012656160088490892097078599624\
31610416050778158934455892220521587597645119436870610219867090733309533487364\
48798875909391125787443200000000 + 
 (v^468*(86450309856748501276826087535522788896555881900122948299676957644183\
22274508792242862105910081792600595821958465270174447190974579448593928549467\
90476925618390135723034520184694939413242557391497054190651922604388951554151\
16024090181333298587481458188473627970300136183982789453792379543078116446215\
87216159210488690769080401724056757442118820037356856077007835239594542178324\
08359509696437907944915509982539321696446538651894054794791969748292016311737\
54091593256830833209824806692148944031559890822763194668577892613691435088028\
10285458913528539990070340290896861546108497550294371424055757549329344864795\
94132812499358485848603282097945758274227835388590907745872498897189665819292\
38852133792475987949052780518555028270066361213803230760859017964683896540424\
5385390587904*mem + 160593449825956385811429490126691750801524054001358767590\
69372900913840612837439275131559346308928140075985354970019282845645585888010\
72876068271946037628621594493081109846212974214168441770196454481565641167458\
04829468563289576630726615974531987084162776846119210857275962097032057211653\
30760709846222172233485248431620039295975439788999412426568975417583114497231\
42534770966791094978931848207128604820925246793873370395932567457211387757889\
48035889030273402731915830070110892469398864026098515488594965456716402542011\
54074799264335921685478431099798040955535270344023042137415902551795405420527\
79831317012599625463932336050498263830759433779598712060670140996117193274739\
63973094411610717807482560671100003006382293812693077186814202657907112692238\
254080000*cM*mem + 5422239346168645394869405537084187120178098672092316388989\
70291944665049059413581011679605782021758992547041749000277242052018264792170\
01949956835654435729967981300049191052822625639645561880680609657208357229004\
11968533011683060464112693737915704995832125796140652153956034031177316811451\
61563186920266586541375716035373122402667169112312880879270281475771615500421\
12875036335419146954788237353256398990789735478916978054708745800284637301910\
34883016201058830889531382891969459111984327445835597487609514441153734337532\
13628209814499651505479080062963398793722793454848227058464770665142375649439\
64167780106659212559354236924885975266846493234523159832115959744815674982721\
07529913795142641944089559616478431770746600127618378141276684511648723503388\
975826159394*tailpot - 875924772098754774409723916392367231448431573364216614\
70729594148920546510812030380049688266654968810698074042946106419348093879715\
77235444755420880461768293374626941889360732391833504013805029659268930046980\
28299242056647858683764037157701664737567709701046083372347022061129287196119\
55851207060367034189883313769243168446515859630247531995292028664130182511529\
36943665817523808217016542082584788977216611684258904622536774721640306484375\
44097921532387989424037120397486696281712925959865918612752584107530404035259\
85685493044379968621838417087877569339880633828540811515900300547036325098497\
50754392976397095453726575159269598369060996621636609350626718675551979054219\
38568128771954039358346268145240207474265903942553560876033710703678255846037\
82944137351234168168359375*Pi^2*tailpot - 11271795493780768743652302119335145\
43423315782750310363778720944213504353679555766170884177937920051522170054070\
38157954075669614382839811033393824236026669658298600426719041986002455747616\
31975600675295524821535623741475697185154731791786854616369884174351518082062\
69327475914717270828548473328621500465065939483909748576422456436021459261138\
35953487837901687969727138001751533153783872447400926265264744899074631142046\
34224759469314887927067694648463760382476214291213243056123892562350680523290\
97308802427287614514876367909425835709513321685020490471974230350237466569684\
71374953660709244391009187961146859415976425496379401015755501177108647855000\
84692521626890617180159193678305891556414222672453377955000432045494907702647\
10239078962878211940716565504000*tailpot*Log[2] - 112717954937807687436523021\
19335145434233157827503103637787209442135043536795557661708841779379200515221\
70054070381579540756696143828398110333938242360266696582986004267190419860024\
55747616319756006752955248215356237414756971851547317917868546163698841743515\
18082062693274759147172708285484733286215004650659394839097485764224564360214\
59261138359534878379016879697271380017515331537838724474009262652647448990746\
31142046342247594693148879270676946484637603824762142912132430561238925623506\
80523290973088024272876145148763679094258357095133216850204904719742303502374\
66569684713749536607092443910091879611468594159764254963794010157555011771086\
47855000846925216268906171801591936783058915564142226724533779550004320454949\
0770264710239078962878211940716565504000*tailpot*Log[v]))/3186365353429212696\
70544222352306121944342307500970616120375061396283134902925417085691369309539\
13921807989718433694414997424082088869859496785141563880475483382158897687320\
66741607452430103140572477558086123293771651541416075543190050283569545581478\
94580256689695630947618019382062880126394753923257252979590976476854790183253\
27872220892888570715775994879025486128055073371001765987095958270370282745513\
31133863829417964626879552601248516599133464697832647288982196468429636734661\
99797150807003721776534514284555191931106380017776238505973868233228276196927\
05276500183085882397161995846317022477798497281474477254731368651500829602113\
41011187147796347650476045240010523989567389883727922994720661970811253975624\
7768764440420748946165054180425728000000000 + 
 (v^466*((1875557464683902864962570267875884097790043856582149752614770076736\
03355965908383400279583513419874777245878097001241227971864959057746404297848\
96169677875631824313588735568500143238516571028695524080729338699470179811325\
10212911880048328148205957587357446565431358774239800146559624220565425857028\
10361009874216985172350535217949947251627165668117652047405117448250272323607\
22690075836434238514757121226637141772434248867229286657697368736567100122818\
27591026127137187071343269850634169675913278749895406457374177394342847023570\
93582294041641091254159103805366989790060991480589382799311862939079665065639\
32417594358897614476770856377445223403280540008599530277781082498067406482113\
60981678785253441044478865263430561047053135657000202309170551322443278273360\
60747095474176*mem)/5 - 115*(-69714536255189094629426242908319419696509875771\
91671916548337510806855635231674967556207316794691792044380468608842733699496\
43082838996730221504225920764358744130190779196547114412319906369293963688203\
89301467940634091055185336722027730837589020660785106448238525208592800354740\
84966974329849921264117869430504479922414200927271111922347933962664943422460\
04553957669990989857719416151851979031686912627541786609170404887293043334315\
17745485222680603167027913108996478580959151843680129291043682011234233600598\
56451549012057108600186285252058409026679958348665075089761936508905443370209\
45665202232738381082003579059803886540059442712790732946784985776016802123089\
10066120589279979273557964639648621041999441903452181494715599577991166060032\
419115407769600*cM*mem + tailpot*(-233729131042629603251138215904103157147751\
31501821243934833316397173786295373928049773245084877912896548205902067523295\
65292147814779162754119680731551647834657637333759543765392567274107661988894\
70117752312974339076570208192203794411354725243234743942187750818165974725078\
39545806895208979153454085314154419203316976473143457386245744761065222884061\
90179869972784368422273852287733556787871092988479751909362269334857939838876\
42313060883681274511790517451675174260119994814613087991273416814490107338979\
98285407003874915217398086936368550286777821713258680597112497559098114505238\
67964755388463260587164127006589519129444182836040371095432933793289693212867\
54698105662633182169176236262455093198375969335524027006322217478443027375937\
2183964661828265839185663 + 3304933953258376233910369014906805915977004343837\
26018086431871737622281234974235900620428887868326348320773346009475846567755\
54804420608534527161840979684607326713777957137094063923563292109079848118559\
96288630792131084663868805372916291822325353800490545080280199052291904588985\
10930567637965952971586828796435001507686518705997314541904871874613019139824\
08924166804339036707373869215308229649621135638459049250289218832081504076402\
78947860582138440742270301760297339976496927815281483947722323955330925853970\
63549603219565928140150810382779831289147365677068325252663149371255540769115\
30553875917812028108990100463046086218997681964872891329687188608769664372508\
61462819212428647999949220763566749674450464332561857111361609359781078386172\
2172782081155878166456906250*Pi^2 + 48847262561736931530711835132015141356870\
77959642561942712736184265852353092538292225787065763575816829968496616843720\
24204590772184852390845688725199730126725891969514885664464319934578318046197\
71243627633468417503123844432686921920627675703296275123799439620319282387862\
79282146957298310273434818870351279543961049077573319627408569254045546323520\
48695852925101902434796982817427308161944747462550081877034176227748513960507\
62012912440831359597355283389803299789075398328294702432824017125040589708845\
07362256019680543792164532981109614235106392600601721217589884552379505893391\
87150639803530251209405264658191322904485102767938784053887175987445044584473\
16961455346368970634048970280126540295129312291638061984841128993354768990294\
8061196587126669742080*Log[2])) - 5617435194599747126031861040181741256040139\
65358894623411964661190573020605641903605965512562811218935446377110937027827\
83527938801258024947254203397968964573477576494211851413396792476506575312736\
93017177848868012859242109758996020872182705879071639236935556336717474604221\
17446900089305681445004170090397147555520643920931757151985464215237827204856\
00023086386718780001653024004140438623645958193259415858930266191079105458376\
31484930695606353695857589827379475743670807753890779774761969379667816517183\
46659442263262536098921292827605637037235149069197940022836723523643177740065\
22323577405978889081605435692002134015786818312960166197025238556180127214414\
50567364832431622915631582214552133939870913538377128256729834235798433883902\
7037607519567020339200*tailpot*Log[v]))/1593182676714606348352721111761530609\
72171153750485308060187530698141567451462708542845684654769569609039948592168\
47207498712041044434929748392570781940237741691079448843660333708037262150515\
70286238779043061646885825770708037771595025141784772790739472901283448478154\
73809009691031440063197376961628626489795488238427395091626639361104464442853\
57887997439512743064027536685500882993547979135185141372756655669319147089823\
13439776300624258299566732348916323644491098234214818367330998985754035018608\
88267257142277595965553190008888119252986934116614138098463526382500915429411\
98580997923158511238899248640737238627365684325750414801056705055935738981738\
25238022620005261994783694941863961497360330985405626987812388438222021037447\
308252709021286400000000 + 
 (v^464*((8303492367367875044803142592248536251521674713876897895581984877827\
91609814228765168774918768872447740010845182096137888062299047123155120671910\
22467825280823526300939368371097029389937239677047320425239181742240852410152\
24258820227984370736154266485815595830029970047737696437487591801278734267014\
91926801322525308849336978623123268450762571276973562065780615484276007330061\
86986670365047227262923466405937652069330344579107501146635075594682191005840\
85551884583939623750085058785054471488072138161755919966809205012532667341146\
90886353873078714610542762994419817641154774527876925574004144929040969618397\
14401978787825694679021558745410905694533141510744151656044850340435736121356\
81126777472097603765462461081984435489693964571257308218370682001236344449295\
81434535936*mem)/5 + 40839932052282265798790216911103791352665741100234160855\
13013309524960624100554365592202345600404807005760617858623431998018791039772\
63451781859665377631301241497842847756687813978972953841685402050546671247262\
78783410074195938061737471061397311105781941700225452011612026921135467788529\
79838292834756828568803667003707701721233749769354462797049169250074844347306\
29727471821772270775717465676060008127924568096552586963805411451110950827639\
06601506538770441313305712141792014399078089048636935607945320093698278840829\
53504075878309116888082771036423447738105296848168107249773830132971246550764\
39930735439600140939614663471951579032723617105957670108525569546960042486322\
39898688677028545986174388396262749764813275398984489564325291256737155801677\
824000*cM*mem + 1359566685560010019087688067188992036070656028842407448017067\
40192678618167307059308307677983577768357473630001851551542103458597272952173\
87844571950599336623963736820706281177730401507374719966025774004944569512499\
51463427651014127045814350742322330362496372101793398403771823417328671062655\
44382194958238489880914528168392140785896968101916756667516737734963203647741\
72918259801415649777318393172104819824917921566665511467164590519598972143377\
06125242770774624781216411848706639300001766171120662477227100056692003473573\
40258517140766861551685905770801402832231944889519337884211615424825640933232\
67243487140080431445970030508313159798366473901307645097201140535490604860475\
88347646353323953938923078903703010909515594408541140414853765496428919465316\
780511*tailpot - 168263935006743394346638221868638068534902621058777797492465\
81631499175528499091285564020647118144028407359136874965866645844667725099603\
29609728142774296909780288674004497929593530986430259471949652705542423171173\
59107558577855985579223144683771021932888479646155758663795736035002743472732\
18539419011527143400863432604092260594252682924525778600133096271015482659630\
10892614568463874823748141088144949798871267504586925537520954409705941337862\
04413558041294135300197942754627021196656354790243807912590688057940493947001\
22729128943911186273120962219709935039695236138826478242332037371588347681111\
90057571828745759290236235220168415559220241546362830224659336602031253491634\
83095835836366193509117194609258575519745842911264479422217883803042922861475\
33131862134765625*Pi^2*tailpot - 28566058605886847378375700366161834474915257\
21183579185957779983535991207241844083222492183416573781538460565946791082140\
53332928070940902182725292566578713126682611025711604137016044193796459664434\
63405835083331525000650561263062585804278560053548531055042110584385735483143\
90077609699297762467054487465508417699618444396513762300342525633350614308988\
48468100386300869874618069836187985140459977042837589432371533210030451545185\
59472716125647003431047073017402478786407696695187098976945836857834407161635\
26954180054182317646238675976093167649923853154564304051509889450712993623700\
60762099141803918132386436358122017335770138463812627842347412035465796017604\
22637159618589925984008204512812738028202463627951486122476248450978644221101\
5837019958412595200*tailpot*Log[2] - 2856605860588684737837570036616183447491\
52572118357918595777998353599120724184408322249218341657378153846056594679108\
21405333292807094090218272529256657871312668261102571160413701604419379645966\
44346340583508333152500065056126306258580427856005354853105504211058438573548\
31439007760969929776246705448746550841769961844439651376230034252563335061430\
89884846810038630086987461806983618798514045997704283758943237153321003045154\
51855947271612564700343104707301740247878640769669518709897694583685783440716\
16352695418005418231764623867597609316764992385315456430405150988945071299362\
37006076209914180391813238643635812201733577013846381262784234741203546579601\
76042263715961858992598400820451281273802820246362795148612247624845097864422\
11015837019958412595200*tailpot*Log[v]))/812848304446227728751388322327311535\
57230180484941483704177311580684473189521790072880451354474270208693851322534\
93473213628592369609658034894168766296039664128101759614112415157161868444140\
66472570805634215125962156005463284577344400582543251423846669847593596162323\
84596433515832367379182335184504401270303820529809895454911550694441053287170\
19330610938526909726544661574235144384463254660808745598345232484346503617256\
70122334847257274642636087933120573288005662364395315493536223972323487254392\
28707784256264079574261831637187815945401496998272519437991595093112711953781\
62541325470999240428009820735070019707839634860076742245437094416293744378437\
88386746234696562242236579051971408927224658666023279075414483897052051549718\
0144146474598400000000 + 
 (v^462*(16198772722866910173706999460704750854418564829677151650948842074574\
59358343110810581579544513920990369379530159581443470266976199441885312646060\
68917895467558008587475922020389592866184146166213837108772338520531304190100\
06352473037361843550158805164948989956261343916196125519417913128624597713671\
88117819737280611825871429821950211398172252532600365970582433489043050911507\
14876247447879542461161937202505309066959182973391491532911434719766723371136\
74026139167654668152136708507351111510886959033603257933533599889466496804524\
68086376033871835832713406958962959867865017247423456671239413926567264495726\
87947735704038238039528313887223370012983410500746016727173104316502395238836\
74183101579201411688142563206457664125694697925453716959609785704146248278014\
703960064*mem - 2183*(-209985889357013434461678297102310786886496405477658257\
81140166485641683705418098688592501328479733759199340700215278939168565425836\
25246073215846037289189232252741006365312647272729783041459456977647460499224\
62498175965144459103109494706907184107117626998668702364684764626313085687461\
58609053340806852506680481090420948895408965902948169789424876663241933784546\
72150675806751233638425361142568445328357666361760044887037046195830918351591\
43126025191842039860450934102825570172626515440054788523672320755659094857949\
44398383324394513354904899523454281240754352229681575057754222243799715030353\
57789641358287621754366177952386702031075416224051469492082175274606706646133\
74829261826893850797304432158492393857822332128300581360976796253309177430016\
0000*cM*mem + tailpot*(-69409492249080675874983268691450575557532389753191326\
33978199757640934551354744905081039800076413035216059794972478512361598345322\
70527770269647757491557688322442525891675540823387385431909909433383718720556\
47350633092022907577431407166071186350028353534073306598285974864427373402280\
05625302753170251327501453618623369884361413001235562175749811995433181326663\
61755847573877359775564115656955630704591982866078828107516265250000613060170\
75343423213622391776991471077472464663355603649322161526239071560219214225735\
41289949993671161002500521914452787977868674592839950021009668190670430129609\
53943050963346152918567332096142970338169990925567211372830932082567564124161\
59490613952244670649591922575356309995932269480649771421672662368365196040460\
927102493 + 75184554551050836397970049109812502754255338577484641364932466429\
79070663238341960634371440451875353501970249177339791666254441938488515497334\
29958028505927344311446038494726811010035282639589675937907918279170994228790\
39213990224582852479424816222421321131363495776872677525380819823283609820210\
79360041715275543961584468056448143331305451336897048708466149920292593697392\
66313661828857439536845387800356806489614758375473469149500016506482031181299\
04069878445901990760109226341970713866887346841210024553373316782523987158660\
02059912500181834773747181060628223094293515324100397774452739303320473948133\
56876612511301135773339914067551397982963925343554332705466679339388649836816\
66179696939127241094705630476139437691306821451469370833254796203307278865676\
4843750*Pi^2 + 14662250345084232960153890468932494689099774545661349591355528\
75546683804211978967804284940209348860908787726846094786861125389010828254501\
22916084940745499139384315973649462155288668663909067072034427112651590253261\
39369015168628944607120982411830954195751457831555286515152383596861416090841\
21733468808463222458669694995586165538338873044855484764891501117039774519531\
67403452297783283444842876505376820176668106224239812383371520569091439331794\
19925003501959903448772651231793549612794009819869918863227215729948641433673\
36991716523226960142338700573039279881214219452329767609857396226004880773480\
61299084883016262693522922637342172300352936657635474572124615228742000302987\
90272942160790702050100752784919044200313251141576617154701470899583488000*
         Log[2])) - 320076925033188805520159428936796359063048078331787261579\
29119273184107445947500867167540244770085633638836077050249197178367242106380\
79576183258134256474246212759617704767758849951636933134934182511543869184215\
22869622425601131169860773451046050269730093254324462851904625776533919484713\
26306377441624088752146272759441753645993701937598569195232417581469384978277\
76137644417363660609077600919994112375984456664758875155104329000294023266120\
61306736962826447784692286706976390053188047293234367760328784250119384778842\
49708966529171702044539907253833509447479806906410644358826923186959613686547\
28508178159022996245014599605401173179621316704607236182409909480350443437866\
61422591658327370061025753699433294782734892838272420617552487133109737907543\
04000*tailpot*Log[v]))/913801627054110401701239548654900548555585540783603403\
52661859914045713971089806827113997775372573575084094099209509067176766830707\
60322201968819276885269429694332813270683121964689466666325158417551883468157\
19764736408711401291447131275878387574988226274061323308822310773610188693637\
56040098440824005710726993100964015233037610523729235494142080269180786437421\
97935647380028802573540061449517326422122584698676476229250038848518090151374\
46218300138947111298079170752264540972390829947472871110398181404426863782479\
15390710084632983664530590843882382665836375640008937421274846556656793888677\
18854723524436317658706227626424603166711936977632153744496550386333473569489\
87525062103393982198700098072081844784994869477413976581588774234882048000000\
000 + (v^460*(309788587787408300516052226944133899183064662345335050377509351\
07298309871556973121147473739544998367975774740662577465709312267355219178700\
19074143042474193675076926799828328173281837924338365480036146473563946619769\
41355222814779495154534136840006267814408889256777937189215030524472939901029\
90599005309182555682972698041093804022051371224763429767252302041326478914432\
13661390857838880793508874516398028672671947363232011807267179429715454877991\
49281748907144552766554321645507686931276780791170390282741457610765711331965\
11929920098565734438725535414531242886626346422894732855288459066978521709208\
60776084350924019445346484127227406855841993736004146706290396636952030886152\
48078635027269537097452620500992423641243431621317764867320825035855599868593\
3902757888*mem - 31*(-3254372759120248649920787219707571800018098800729507820\
05211947509394969730152600333365025975782539605293173955349338883198676915333\
51915023372440077259978329488819302309429429668162691837260874854101115798026\
09931213937430662929834649784271579802405799124983445710336351241809675599029\
76317438098845526187555140956542618222225780749182778976457123092860477998978\
11436524880724819172372637326429634274513782624150264112810653304673728174303\
99951674345920146069106307215640066651585837283957567775032319055844795153970\
76513656344451511624028017099757477633766970036004069749865097296326533657881\
96669790630803971868762889704946732194621655179195733311199220234230176319198\
56515643282756213468887618111680886811296857196796068920459051451061108736000\
0*cM*mem + tailpot*(-10680619575347089635448657360052102266310460965450553160\
44724169744998156489526878693077419967537149232198621803049232647031998662026\
77996310292014872517146100998218199998303746051208133134498582488299694948934\
41891552707569156819017339541330101020749912796978464722251975870234904485407\
04274630901793323024883521674805110074964989191240686803576544896198075823944\
22515682847325614957464831996856065531170598315463240865119410299417943584324\
14137978760849765081015415029581195230794442647058188714203071811279943188958\
93360863612271263116238319861033838517841184520805561586020375918020405488384\
86724657731248431629078868474678185255525650104028027413105050420166264735145\
86295677360409226247577335502468412293848109766614122064526769581516194294649\
10358 + 101252085141431901629506238520630937477656365930411607103683299159169\
67517895950328973357373804705480218656311867325190803661997082692002192209496\
40018421710730384866193427981735879003603571083392386437112905568015309234172\
00189195261990666314581704684930754013889030980991202394726367095060307118277\
09957792959079931244365458364496080367440176440969301578188039752917078602817\
80511239786664339922347875179234792307685095682377320814004696180790659792541\
49988065320058412937263898528521799746592657479665103361080011478685169010868\
45693960963855666727687620509059361426428054136744530184442574301701204528980\
49226847277408689650894975208941947789137125796120879445442208751403136030618\
16357021027269159650105751301600523764895906038653450651913367278261571146093\
75*Pi^2 + 2268400714911737207912576709676705549153636426788291834824323562832\
12931397788565816024996375654871870602133641521776616276228347012623818733794\
86772560599892348838688373438468855367992595917561760585778902345192274858687\
71662562715217443112995262673957208584630781071395360415121717159047650396365\
30638772569572170202929936124163954351507235949425153237061649034062880215772\
89108481299183799986261853498665739178494443037334268871471506971202771751248\
70687678575954358655266747916776183151771490976443355952039885852557089454706\
31803992319646530178724502061291839428514789279140493111653331865884204093829\
44327412585904309486921999476149571986768393703174208743240000002566010061459\
6805854910363097484484060143667146337120989542476885359332907008000*
         Log[2])) - 703204221622638534452898779999778720237627292304370468795\
54030447796008733314455402967748876453010279886661428871750751045630787573913\
38380747640899493785966628139993395765925345164077704734444145781591459727009\
60520619319215394441717407365028531428926734661235542132132561728687732319304\
77162287324498019496567372762908280198490825848967243144321797503489111200559\
49286688959623629202746977995741174584586379145333277341573623350156167161072\
85924288709913180358545851183132691854200616777049162202697440345132364614292\
69773095895859237619090424355404595639000470222839584676533552864612532878424\
10326908712741497901630335940945819837606367315898202047984004710404400000795\
46311905250098150222125602201900586445368153645075067581678344613932011724800\
0*tailpot*Log[v]))/2014300097423722386921739778493608716428107691612679123531\
40514988764327307478475812381277373601213951879537314040358820455147945255454\
89171741319731136442249609626430562659608814972372674227266948879954741497790\
50621885936455800519561321057032694582939891179387568256762632343910081705165\
26227826479418054883786278734131071691420098911905926122484533400146448530625\
86450327560655628788395939860588535980001540098039301155772748339410208975070\
94124251363452288246062245198320571462340859147908355204455797640775436879354\
24792351817258361164547142957765039946665033399219658938130084581671879563017\
95901458324166649119408422021735157760284306406687306800558226582162421724753\
3550658891481149732355665215169211958813652282964985234960941056000000000 + 
 (v^458*(17607924321865505962281929813528487246400415547693322470657253580744\
10557403291654938217713653929762956069435291536007079454088580825049353864876\
76524369481643476421747795793240107643051063697074470038381731645270898131492\
53436566907531827980825287019983999335122644156770027389647016643343748745137\
68283096587149652359038312016967396394912684306536643935341364883016880061620\
55416132140184740343329281607587258223128098551984463426319500542549030767847\
15114324428042224546357787330496108573908573675003191459109756800007222893200\
50988664702749077859367242593394493187355751825910049701356471747258797141622\
95126751197801016504782288677824188124421009429154691292413313813582442128910\
78000077163798574640875950472143944207316441293047634720102523505680735797248*
     mem - 41*(-1609623409872633643245903574242852104256705370862627127611056\
11798147928894567504875343766334672074515632232314219580383337070235852104347\
89979468867962524667162951037106818340383654224279215659646469648807250000043\
47189765220694301695273345632186999068791535659971281267686623279582430208043\
30619388304921886997975304204268251130684989265726127026964562826993365231967\
47257076477593164045368329634662952144802163437748333742555622205098875315520\
11982291419231858971440052402284485447915449413332220339124619530386299627029\
84161511341597888904427527302520892458318541624363842099361607403260367762979\
26835225883053309123883253820321999379373874457116183107710607251400248421911\
0238539457842313754220395686961059591161674129257554619882536960000*cM*mem + 
      tailpot*(-5244944048248220565776110737046692096088009145154644975732670\
47618624468025310493842145022449587596663476040808608659252962184670365773265\
53224786096476222586776168644835782213702579894248481598130629598584806804583\
95891662668734705919856701930552271429595750897673890119243838899600821891773\
47988840010244598286581143678500201781030792775875533415557025334081356644731\
45651207358044934471215744577607358000898191806810539553884704410106246078987\
08291947709345038497521102964595151778643490605738423612529371846850888283141\
17938257630246106104677548698821764108421276646541734439549990437481310242819\
43450707633951347012321806175107484482918530619219597389563612337831855307271\
00695904644874362286950975255207353924706240396812891964024822493662703 + 
        435135544828757408479492201077297126104511151797600892278543929376012\
87880493227097807422002832386549277431748576293829363553633236280851856253161\
83376749887475211755893817596543672693868949384074938444118828342231887460947\
04737172300608356941000774721514992447037312301507939373574163138101786445183\
83055935803401497876484256585461669300151921064559611075506698726648277092033\
00145784573023683216235521636046479148858218082227796223783408676608829565389\
49552679875147158534378474520433515359045429949998841989375284417149555210712\
04909705191914058342098955508947082884043559759269813511391178507368228214411\
27320837695429346475623545019962574752839028134412886892279212249865997670356\
6247906023503324498498338262992748571999683942805992748331802682957812500*
         Pi^2 + 1119993357151684376182850947550423499236709248385675785443080\
64327408637870479272678620519178966416536665080571631388929699412455325508396\
83106030404609408627574636033828939348263404782270089725448020059193868834704\
58517546162225344382517480358873767983553939999743008399810974148095948759073\
83190435442985120516537741227883368148040656568794027709025106324632357963398\
69579836999563031495773735384307910589381094981918817369361973611094972604722\
31125322785356571551174187966005942813966953749800778616289991689881737591596\
82596950280603225919457420239989809495187455549213478181419117613166555856102\
23269144246277290365105312792702597045633640413520422315834179526073461607472\
02189127981650411406363230781874319016847127057239249571124487168000*
         Log[2])) - 459197276432190594234968888495673634687050791838127072031\
66306374237541526896501798234412863376230780032683034368869461176759106683458\
44270073472465889857537305600773869865132787995960730736787433688224269486222\
22887992193926512391196832166947138244873257115399894633443922499400719338991\
22027108078531623899411780473903432180940696669193205551360700293593099266764\
99346527733169820842913267231507566243341646248942586715121438409180548938767\
93614761382341996194335981417066062436553726451037418319232678896592851512412\
55469864749615047322626977542298395821893026856775177526054381838221398287901\
00191540349140973689049693178245008064788709792569543373149492013605690119259\
0635289754247247666867660892462056847079690732209346809232416103973888000*
     tailpot*Log[v]))/1319757010042320919247343236564724216553041824391692801\
19391300059082819747200552860671940412480002604663443665612425093913847216094\
59508092784791002004103758167324532136302415501367055599820844495946247535525\
47465346877381619909291594497372655593424859216189669699842790661323617633077\
10665857041720820631553841005980001488398218400059137053604191894242560837639\
13772238264265541031683737587068709218487104481898407498178874728548181935480\
21877311958335017139107019290770841319562692592513926416277625999937301126584\
56788096052221777415229375709354549499474045288839764800903867317770877248762\
89017961745602525234020976345743841473998240735517274926102209076666033100751\
88530238814744782554828179774651042453207533067559890401099776000000000 + 
 (v^456*(53668823493464237198016015300635732186738962563286350795325252532411\
47427133546663443354275520207049817669896850832901552892265360670551406274994\
13219504083416528981272496871202505201559952968355895157067712509982427742393\
10111094116314671015505134328426684090351264544550588407616901939824819784786\
97281906116389331243326418122596785939163468058382390666040524497326501662614\
46211559706194663251845111319141614048481288736067700709274965495173434825331\
38571622801200023056478059992109224900954101657797132205761104829136522262445\
68014773802060350975130804639353151061736137651824266652220413108993706848907\
68640972153536077357740238693136806046728303873264328182227375271656809129397\
55285237053147880382304908371935763896957758890908105494721016954355712*mem - 
    473*(-4894767846001116111872135482632574776032806290273906427385433629443\
40849181368819833945889320282772225607637038410043480158411891900567817914691\
48856657838024965944016655145289344680344280679848203303564192571957013413207\
20506265188941758349163609217461804313787907266181907045584896757664289612106\
91658959769108876877161967350248759362905135342245142504630438470616303064057\
12966117002374893717255726941794023056138202913456487985686765128524182914736\
23715101918390463510975238362149361162293440046614652267609485517483048213405\
26525755911327765825610507015341218006207475756307327366953019873227454451265\
96201231146759465643495776786791577902619285572109048611108025276585081806765\
599442657878227744790602118091393466645905858887680000*cM*mem + 
      tailpot*(-1583518100145073547726938265362107254333715380330955992601155\
57314647060063016809482651870419466136128768449273608441664676888443038760074\
50237781806113538173719125891435663821679316986948522001782713538253716781690\
64916421745772404428531278068789078667098662208581623033919469278639791252687\
75078297629937465067879852352109233530529061123511809319488981707375338063015\
31899643023443335537449740675737402661111451351861407757209051503454753549636\
74685444900661572121295124878264625511070709486118330069219358158937573682821\
05786399260614133176335066619766590120129988262671170971934885778388437970305\
99933951200230129998799069730621005154205243366316673575392946037919124775966\
44330963678660714901101976007924963822623681194210266088230774119 + 
        114963820742608430314550824307083553111633699385035717388730783083987\
96224468366270075072658545949928240469547913091337625919707294240038819856552\
59595375724998919291531440081515076936026295877299956681249129161722608116661\
59777059598029104377897551030067332134615491583999579129704867083574733878871\
90795737883815530425908682389644636342930746531342933367382819752986683772888\
65396124564329818063399592313060496937346090892997849659837481491561424546918\
67851844646132753789039405104445057769519402366973443308687708630224150807119\
26889680878779547037063439106812855110252279936955484781717810758355487150035\
79046397905412849066646584592380008242779749018968166573003235055648471823929\
4594313375603457214584798496818974212951753424828114786264642968750*Pi^2 + 
        339984134870940044279768044028074020255700702569018989284708293086073\
38433952000502043612725362749618590039891447839968176835097290408565910908951\
64319300090563904064535541631781554084709077919878950324907557481142067542371\
09422206180159974198791850670817013285224891772822625824505840754407400561067\
97914631512342047146918499415452803834945312564382962608515160220040054587876\
02608039944924317026057317196483357321416994816888441363927982880786710402133\
81677579666364895138229777695449478998286804138951136968063866484473474966244\
09671025048738346082906375480292521387124826396897709542657281086676907594643\
30635894597277779652692846351478069793174222478200450498368492828115174672700\
98367125505962519750772872334539006713094547743744000*Log[2])) - 
    1608124957939546409443302848252790115809464323151459819316670226297127107\
92592962374666288190965805695930888686548283049476430010183632516758599341272\
30289428367266225253111918326750820673938561027435036812746885801979475415275\
67035232156677960285453672964472839113738085451020149912626768347004653851541\
36207053377883004924502235091762139291328429531413138276707840789458200653603\
36028939492019533251110339366280130302385483882327651379359026121140202092953\
34951821905954003826848499476035661896583577238877858942088471559536590334577\
43948480532376972147156021783626161100428857326166136768939539981772922662839\
07781445123897757237163242491270121714072321888130857282971076984776201875652\
7650364320271842115568614236950175293721082790912000*tailpot*Log[v]))/4637386\
83176183191501013117049302700212600726326827115855490576145913029756892541078\
90141775256158296827529012059106562611744312097818298419665171739073559772986\
19959006492043133775898811329316666257354727793418378724802575933302889745145\
21203176055735916447132149980131930301163882070543420926342351894761905430276\
39698240888042147104544440531263110376972132245776760908993029313558012224295\
48653230073288119743353318513212448480922987219147069634369603420371388447820\
15868868818382164973995311257909371566636453263131567078982052974618151130662\
59334869077708787184317874410451731060825577119965346585782629994544284573676\
84993701128020385600819045167401511176063316934223177518639911296768322853553\
352800700447659565644775424000000000 + 
 (v^454*(10904508068113273674015488466856546719567188279550905035849618669387\
90342163705664237323177356961074821286238006554303394060857823213664522097695\
46261291399021286483345025111052921735496501581469062278274306345424222117212\
78640086320268979774249878627527391062143369040558663039776688645534007840744\
38936159294216098646777843589521320850957345093423662895064842825937265706771\
51333157205614962176788135792267543094308541419237024270114420666294081353469\
04725957944828786148199644708471921569469370233743936539125913807729342510034\
54557280167372622474101231815774453669635595228273362997735723972661252120403\
42325431031006101428536247100102271288052410106345615263316005696471552711928\
923503422964152095821278259535185722760985729238539775064504532992*mem - 
    121*(-4475052046942368878680802302718692717593179809558432484599043144729\
26821052569011578030374346762676952771770037878576576586373756886786679180954\
76991897636169526998140399883145163706154516020851436591360074497020523419173\
73028391527798607004197496963548124496164998968739206513107183477486109890046\
97882307447081715174592171118121949394662530253358212293612142338972446614348\
46672044678204627852060476914335092106727524905102547255108437526042828959229\
80235174668417864194749479220928414384559108007564266104344274592170103394219\
76272648533448220258253217886017496789267955361025615343566684741084590818869\
29576788019577500802537085792754958907401614879261395775952484185837918977473\
6608173556977473004239468246847517422455357440000*cM*mem + 
      tailpot*(-1437309149198137400460030934182396536806333426251178092986705\
35568362439637690924267860372926356789954925030419328150530806321440130280168\
51016249851732005331309234811532909826003841614825293548351468064190667335882\
55517419816544468842630849011332521809118724863470267728792894543417478537117\
86046148450652397119129901592927444416975263215538324238025725944744874060561\
97336443597039627297618130911092677244807214933277241582792288927611777109607\
93106481536271371358634049635571731189998269622393967531607628701316739672836\
02359697223867961644818112648045927740538423133991386267955879724429814233571\
86060233104257504280424123053795204250129412706069946638784168843650135713291\
398672333457892133804536534155934480967457552285357841329527 + 
        913105507864691784365801764699527753412934949905540746386605728685889\
75401470165186183993280559849040317237019840639455051417522501589702888391428\
54492629534308397885178072638412696146437329643047083579457682393178322989469\
97007556449058326187385366955876018191972080211110258299650575518947516362495\
42818739813378006996907869414142256906558199925121230823359847103322511646147\
89832902889048891285928353588750436667714440328888331299073978458110375016531\
77075138623633049908466351347798636223188021726748541698644276910569773315286\
26918080948656075631254550209976511289930035835546294637389594961151210247273\
04201056400674278910691946982756727683812683732965920954983214345159155713772\
1912144269342664475861641797319101865265899843013574320312500*Pi^2 + 
        310282083517102196085321888900707151514996213869456126138622407600982\
31675072681818138942090522720623864930447995975354894009322890034874668863412\
68662478478197537822436371260174680636437519850570320285057716643422064900469\
60021063262958593606610950956174292464411101648828301989328413859648081948486\
25557248118466749270303916209219420796725854809339173247216135594754621550050\
64053682006156259958019336998777542923452323949748895839291342500848303644555\
81654690883889758013224623897617984222690314550319505230070524438890326245943\
42053909619277915420223952492919032744386291058297103687617497187642055135830\
00432001059182577632767936277866284320608156614934924830124311281637923457627\
841128237274867956292844406102529988205427712000*Log[2])) - 
    3754413210556936572632394855698556533331454187820419126277331131971886032\
68379449999481199295324919548765658420751301794217512806969421983493247293508\
15989586190207651480092248113635700893990191900875449198371385406985295682162\
54865481798982639992506569708938819374329950822454070873807701741791576683692\
42702233447666170677386131554991640382843193003996291315240696530920755612750\
49552274490745492033977685208269373773119791961639655425244260264474099125380\
21759695066071960017949161177609094552806058866013283853345710572947575915388\
52306393262776584709825164320296207074121805394954620171715970468867143543052\
27212816109189356492028962182040279358695040712590444504166507818873837296877\
6516710259022711434173138406128572856753152000*tailpot*Log[v]))/1086329097642\
42254723980902875545860068636761647565653559847494681463676428107865115956348\
47536850188768788157039375046877092317878266867130724636492898235072826515648\
22105209150399848861599892398967723169134948997794446895876956117030107619371\
86053357551301080885758758059599322508133446264559236506208861828551481284694\
83864085996520041519405945172804208180227455751865601830304474265313056761414\
59329490336938515978156513085104904585116201297216205170331276122535716832758\
32146845332237176977286186328801281010214233206776277988262584894124113368287\
71399790292299189449738443455878343533664717359338507852212193485983067341148\
92764817863692137724162282555805546051389416185473086470696337739549564369129\
1587092712259584000000000 + 
 (v^452*(62346696746107846335803984543921069399735824224003506831834196949609\
76147095609358235384197177529364637371322488050044903212591929248754453856956\
10743125050735971644756041302311468303080677515806464521337889743032560385239\
70935807378220682055114981697800379331496170822569422946645508025067973108314\
85942973141105593781193306120673465944164493047674008979300647767275216452932\
08997638072316094651508755808607067352096643393092479195492086294932075405743\
56904168301961260190020657121293169084941375697464244289815435604947784085496\
95107423462708667800922230562561159051078483952936659274733938811493954569846\
36171584152653707369252077697815858917171146281084817873170807980147729258788\
0295160175927335519068073581056860314323290647961175851008*mem + 
    3563955852592010941651645521065938794927534171659504011049126127836315735\
67657631836787350490785645478523561704897238413205609645900317319216190949659\
61049706088934624870453048542330963729486111192687271662484817815041274300405\
19699297597233269532211585372523248969095632685585546928924162617575971003601\
56914474132513038510178008727074152258426313136886278490358621709462556016478\
11660756937236618830668406241392200115669182312222969164673660033395813826893\
04711088093773058218841617694756079718822763128120891728735879163965450391980\
71046266989563107286831531520320067220922795589201728369977789940345945410458\
97858099041440844405594949470615499817547450675418966757590720359285592676287\
25223173634869261533486754257960960000*cM*mem + 11364027617918760559132583561\
42577206719541275683680381104174708297122183151109276855848567842366381752130\
11469798765067286028562005884781869716298644848682696930801283442945279302937\
86339504053507240063380264929300699504075656669249132301434980253415680600228\
37165146751752853115745930243046363725557774844032389875840322105880240523227\
78117730626406116238727235576313652445522281545074496811855630607334004180325\
52654276040325827338941801327063939732059710384984618120238611815168990708140\
36210881791000908164508859486533460565517190478621212115146604368651622603090\
49742792853084878485417601841185066818492093659569433525952876727447672085650\
79919900943852592801630315237656146670235719381416131311548921431365749771553\
6246200558*tailpot - 63170411106206576247153208557256951184211277910598446720\
61145523113150682436277507296676387599885880682667056629419529238052101154696\
87993471452419269301272594344471386791994587604271153117382515240590493797533\
56666149360710500249532220626779552895075090574606878885089580781542556535508\
14557649049695599905202203711119524405727082283739267999494855906231149505476\
79667014515908833507097551217500800608126006459741694385539607087228349547322\
38416134624615896044522311084825719217603863442785926333411771326805823758760\
28270939623036579754153256765085140003725248691319411500315950585422502520882\
10075287165101668929043804166418518863366340415515617037276234238808655637856\
913248796479518380091074239142423285308547111917259959825580730078125*Pi^2*
     tailpot - 24667186630770973089907079626328013747251198068788480103911832\
63253007643487742058475912395988569747569523153037043148877877356233742272055\
35731211881808443160612377939226871763046946835686630995026498443955455678255\
96046167264987090168020766658682484330559106302748153508861253445871425276045\
73029816267306844895339512290568282129507766617815211716661834537703066891756\
05647881004163952599354670974941045285771297525154004971031392841203678102892\
22204796989240446928815019870955726861398350835276478990660075696954394529031\
30284731918119612721422890555428256208092940577765958626273602303114797997055\
91408291085127324341814979453242414580665183475602287899939784691761476288437\
23237507623080078627971468306400241443220804608000*tailpot*Log[2] - 
    2466718663077097308990707962632801374725119806878848010391183263253007643\
48774205847591239598856974756952315303704314887787735623374227205535731211881\
80844316061237793922687176304694683568663099502649844395545567825596046167264\
98709016802076665868248433055910630274815350886125344587142527604573029816267\
30684489533951229056828212950776661781521171666183453770306689175605647881004\
16395259935467097494104528577129752515400497103139284120367810289222204796989\
24044692881501987095572686139835083527647899066007569695439452903130284731918\
11961272142289055542825620809294057776595862627360230311479799705591408291085\
12732434181497945324241458066518347560228789993978469176147628843723237507623\
080078627971468306400241443220804608000*tailpot*Log[v]))/71616285279942923899\
28981784882509723193743769923577954763261525243202497722149250851378893029541\
66064691193749421510896162023558329342701724324472276559949381868113023797625\
66393094171910336966525885278908718414510420038460465554500102817963824858114\
52240283103581862681550913016142499752422431053369274465212906308175208088478\
51642828273679478351853271976916971883226824965224838277006524519196486755587\
89636011787011272197955539666640573622787503379998454461525339001881653581104\
23133067377054170492217502056216007944149909708296387947092001379170728571719\
77607321308193904746225418764642920821878100642493023383213736571805083377251\
18420624523966010801936241131855703820004681104163689343003584500412767115673\
6000000000 + (v^450*(42252947561973876759791231881706015851251092837776639326\
44195406732360535062606861068122243666324966479329820034090171619890922850532\
29924926259681567866453977839455677597773993221824081715830885858666641573649\
57663642391413830937888416505150876470315293732516587586635159611480844564604\
80559570035026838346310414248487096205566554835768571264077730571334846417965\
42194211331228673953757736362839355744420243990896123105861310223542099857009\
15815426404411904093623226843937350735953808868152169825437167774120512732943\
45302740478780181609602509218217191068500849629389123562125812297111399320603\
72915253513283992276597294310897476371776612105832077681595477555871598162296\
630490242892935471211083759056324988841633777287039201602678292480*mem - 
    61*(-45585112669163636719649797699212025980722891033468384260209753017106\
17990959672542654088585813584959311880535102563079360624044859003489434580520\
96914089472018155539135710151528692372238069014740280342592853276754237703393\
61047707093296595574274887980641969935933344422885893059868017390006487142582\
51220300175091630684406668311569013707123812005009315425086740788178527617706\
24935689467886808979455860333954328350865908531785724971850989961464527452423\
90004890097627814170856341316357420634450407488438085926968657306672507469647\
25793504545523644183055029886139441712952413125751318983200735918748036422734\
41455549937135873049985256213920777483913539524181698977294314847010871873240\
9582565670845048569451992223580160000*cM*mem + 
      tailpot*(-1442970484378465663889924719235416062811269398542219181593790\
02200546852638924826630703998765842257845184417985765158215674159794276435219\
53805319328483858792156153305953604282791823806431759367298557924044166853418\
52186874724578792416929356731775504016699300548832184637508741526559885252253\
50826887259636315734552567293310849400904754605081685963909947747001953886305\
07726518515148732967493341870157241519030338700777727859713638905164032602910\
56903746695195973825063176751689188782993207159894449613209382508862930809363\
44785381786869120236180166884265547659297676610566355563576183652504951463257\
60769269525738762612338858231207803086211233156454733554494804189220761491687\
6401279232773595301493712617768339966749803860677 + 7018227310567199634089519\
24302651043985209613051993583284888907301116247219122984079377477655717568971\
08737902403755301289344311230008473058186456807490974020279042351591039967965\
82609099370341289580740880142126345082561444217766960983100094728454261245330\
02764118333200430728197277551353187810476009330594600872409167606749482844081\
64088027614872111780259604046503818568375587733895150988547059702180655001793\
91969287709937065461808360479070870294112229134512821669658824730690633873079\
36829038124769538679318714347961760943736815558663778880954755466919255884397\
52827986227418762328644409064343859451868536872357789568352112952541076541479\
94013331861044066909491593974823117241107574304557359939152060525384019927902\
90981469325031250*Pi^2 + 3149456708486959437144130590823419376676625326561842\
25927648113018392322373902702881169726538284273083944755978327487045214640981\
64783457828144627774933829003334812919982442644296842876786008599651789114833\
18403129871125621466806197939063440354842434641310222705693903144902243404464\
30036607457794526860896202122404250040030916050398655474412618142284350884279\
65733835843114784001524078644614754439038094071148816090158447449020077435138\
16801326322041343881523503168371238056619874828405882035910005597593771049837\
30479384728840748681304530641780666076283685797457037104538694640783441436444\
67862845624416161750412659769607789776422733819880807197104385920940515227398\
789349708948348661019785311492318094915334034747904000*Log[2])) - 
    1921168592177045256657919660402285819772741449202723778158653489412193166\
48080648757513533188353406581206301146779767097580930998805179092751682229427\
09635692034235881189290013021074154839465245787591360048242259092213866290947\
51780742828698616453885131199235850473280918390368476723223223305492546613851\
46683294666592524418858790743179839391697066793454039410590976398643000182409\
29687973215000207813237383400777814996652943902247235434282488090564452197677\
29336932706455214538123645327588041905103414532200340400755924246845928566955\
95763691486206306533048336448792633768603730877899276231253963358308938586677\
51722459460751763617867630127292390233675411773714288713261503322458492683222\
06904001031403789835376119622144000*tailpot*Log[v]))/559677127852007845414893\
85627403170703295903172269286923751653057543001701486005398963573718580350583\
36129991789789863208518471071657882945641798001536104637244983690401669472209\
52595904269591798420485143081575605739450128637586390279015457672904486671791\
20686961408742431626391185858860209615747525549190881626338763482401441688937\
38889291024369739397248959963831535064277627577667060069744601410493557267086\
27788269859895263797590392627177420971423726152348089444662409203294631949291\
42445897578700314297452768177617569161532574995216841919360574950989150670335\
05168085291534434396833109119418739278685858807622563408382086629285536505034\
43455173226092544046898498403437167901540357640585675239016102006620160000000\
00 + (v^446*((608227056867899382016113368602356996849725119720508688141298453\
56910482295599642412356354627166338786980125327023950419525055483674255352029\
96314200051349337808859802976321375428429964999977668301177473729108846634978\
00156524249991682885457368648779502724261250037510688008317445506618070377393\
68806439629253441116882374165306033182497573640385177943922085715134138623756\
00946770817936085882493240619386349951143510383206932056245459659272875973142\
18445654287457323501482046170817753687583619204364650743473917852723042885277\
58501819719520468623849463441647480811404636298556476220316969066874427544048\
63702593690001877421178048922499833840854619153321656424525289999608565096781\
27593322076241663135107388090654662587570383475013844992*mem)/15 - 
    1705*(-207494896054410999380607177953171189752336613626398230485154501506\
97080601780351387061047547792786999648460697246733938530248378082486899259124\
41089611587503342642678869249942403458287802318517538631174164176731060657890\
58319176520787725886015265845687779222592525479027168774381155549827311906937\
96461992909856739414896835867239929495995523306967882949758780672742070811620\
18215281409512220800742857021063742045520580265890760651337254991310063531911\
86009635759493587856831603773847825797032710412377040542485416760328065807627\
23701982515188664395183550298070470068402504103758305488652824162059735880710\
08054564608599379534115632939987365286635087548398712268065910204293017192310\
9736661775032746385845220120985600*cM*mem + 
      tailpot*(-6472469671248211355822592076036174534937377682710252095729520\
14360883486571959629327479675876408885920813684397051527253997131068116104386\
03514169030977629654210793924708423477002232201215876607308461247108950949003\
50994273086244882690295710869275596018461397396255042433625779403457709381716\
25894683697589827474734311269826510601201943650558707489525356518454906935594\
49586327337323711945321597409443364402092006748250089431605441115162150728208\
74612023654476571307131380616645234176197269909089213617218825754094617645471\
81359106628148991316068886544688773994463075342566992769253552989555105251446\
88038247216845068125482848662162167201385201417214891555303586307502114892200\
6743463092405774169326195960896167784503857 + 2409629924802657322697408466721\
35392935797946715119381319555567596930575308432325459969314882849451329209943\
78395021537589680239683601580491209222635871559573809406399359190863721872978\
01593759348126353955647770652390822879779515973338608095342225251185112541910\
11773822448291625644997061967802510428116258688755819162275733215330726167860\
55199144099233641415081554256156241651498734842459149742016157625904491907599\
58320309034371937608566729653663464547564445880778816321630898474935086542501\
73512265759373527308636641734279738654306475358702638545386313360921716261256\
92571642224065046126521575777163999361818810859303053735915458278073845180788\
61651480659042118602555511253223025224756218135175784993967357316258415582291\
631250*Pi^2 + 142843457797086834523376603099007689145683549057230469892004060\
27712170649900804474444023043073398299755180026635624148185736274556417595001\
15563965750858020283564412173727066821277864783264719615257448922088696128808\
50591009924942611200812650579576270963967357608051703197025650410247678952150\
69343996369607353437116556331737091181973089802285916942286054306457239236791\
96649430899306906624790651713655576401224681585510473380671328913337334311652\
82388035694113773149110575655461251530532516147070509515277696197806222939602\
63044581744063666803890160940852429050786608283650774138663305659506735099237\
45010622367690852982000908286252021153371792535305888553604086592940355211682\
23396998999869107639992416338380206080*Log[2])) - 243548095544033052862357108\
28380810999339045114257795116586692277249250958080871628927059288440144101082\
58194541373917265668034811869199947697036561605212924583477322756204648930278\
75945546634694401395041216122689961850257671922027152097385569238177541993564\
34472172815395092873394947229261341693231513810180537610283728545611740465264\
11811289748838659772259250959289873030287279683318275795268061171782757764088\
08210329535711404461579724015500136806471600858463983219233531492561433859557\
94003075521872354847201725961011202248491011873628551900632724404153391531591\
16712362456990642093614945898334419985243111136912904334311548628059696066498\
90627269653998389496764096330563591820891883294776828526187069856938251366400*
     tailpot*Log[v]))/7143945833267787961167499988909959790719754234242979731\
33226789574764791959157618148696236378669682865662106902416649206047215490547\
14041975734110158192437018079660526644212810843693860865921637289266885513694\
91685222740518714632990432363609975075504563345091333513150930368065979230707\
90421791088035821181931773106025486524602156385343272012592782198773572570146\
25721097635654711286324741451877960348105159744611923578031853511727438883848\
32142231885636517936954982926448619734543481108627302754392819111636932480731\
63720150853437211010017205550737886440654070651644358078788129846422898684097\
94265045224310090003544600063104312543317897959594934583928661712769684333042\
67278101353945084062229527922527436800000000 + 
 (v^448*(28632620363062437762164404648654426387282161119927785957938492924805\
45896158786332275475192645360439206016218410128995784916899634883524849294601\
50445818537240949360290364920418951823299961148798024130831435512722704411977\
76984417952939896712282119779823944092378312554211962259625660735202805872678\
37653596356343112718215110966193475512267416558193525815518177669886673827766\
27130547094831666739839849091232578628185597259282037579163801622685728535550\
30328389284525776931983764558376103820204751243587814819726270585778009261464\
89293361998652966193710796421916393716463149212834412061167487267342253335588\
34357695416016737184124029462450832114990852387291236805344495821040597879591\
78834705485850095250249536983325980578843979677696*mem + 
    2169550130997463957664405778535873938384563418695775891885005941501957856\
63866186710640378279971938160226108044829677255462301753313134913182782972099\
34147770371358331968095429370358990488613877619795647082830012811187631161772\
56788437978476135480042416267140285589141770860700906292190072724227843486470\
52508444659160815423531016280720481366025145000893270146337913195959254796618\
76279954940747979299565810335521483060612797595962694461529805595307159031549\
49691888332013353249842672120720452304871934719603184665354833318127021067022\
43212349024401513826244749468939901456244117978539145321220596752362262940500\
10668586428342701365619000237018536715910098515831551077108390386766367561240\
455243039331766433596047360000*cM*mem + 6817498080854002068230754336095496661\
42671787445040816408548490288771355695591943728047065990181366030069833180190\
34401066416768713703399610207018895853832918010712840978165785263095078433800\
52723930572775842174766388172381002031701208483143339258502411025951357931310\
98471302565055238878007277098186002499507582266220524098666807374150456202269\
80354763522819895821919677067846227368872999081974613700128343541951163979781\
82094016609257544648675334132406813815677641971985330059586475030952301840412\
10455588631635088080325891477879926588842682901709376962305231699947639790994\
87166422275816482734053925058565409812113336465548710789268239103055447301941\
2918034315239854773362459324092041828340787217541542016179301138599369*
     tailpot - 29010909860362528524851529062363783425846777918540325180868891\
54748842343494755481405336464842528010076683085754456748759964273337385293697\
73153335021481427943641082023688631700752363426986281779594918927777877286012\
54752481552689629832618184105190869170833010823377435058083087710587774563747\
28299885259240746895697194378620488754772082287666331207236664799351567885147\
72274931179773304255677073515177203552282957055586051719471122646625433776691\
54580576934239073370745883373612445110698411044405591983063566800570220344268\
53356635619596879485217498667040104670779755628173094941111401315378877258677\
09668263022636084981874166799037140165127733938909025857136909452998887064336\
1533951835979850597670575369094129487963992066541953125*Pi^2*tailpot - 
    1496250083468345215653668775764942432174863907805851189598575996906646818\
60174772371264498813166071138342800394577616764976705155345503364646603446847\
98030719896313832310616662363145073967996728372348465729406622103561823479926\
57997439213027685153853607693505366854520431320648751462696059561305761149216\
13658282891226285451636257439776477607858723790048695254297956821499063281149\
04312640756038476157747055695791130652815340111197525964976096035817908053982\
20176123108312807475226669648859443973124607819001777627000223057225460668802\
80395800448078468616077811677056949845551263763542451018424355161755189638504\
74368670845944019460073890918317298070732148825218393647031343711485750854579\
2827153545035521791155831296000*tailpot*Log[2] - 1496250083468345215653668775\
76494243217486390780585118959857599690664681860174772371264498813166071138342\
80039457761676497670515534550336464660344684798030719896313832310616662363145\
07396799672837234846572940662210356182347992657997439213027685153853607693505\
36685452043132064875146269605956130576114921613658282891226285451636257439776\
47760785872379004869525429795682149906328114904312640756038476157747055695791\
13065281534011119752596497609603581790805398220176123108312807475226669648859\
44397312460781900177762700022305722546066880280395800448078468616077811677056\
94984555126376354245101842435516175518963850474368670845944019460073890918317\
2980707321488252183936470313437114857508545792827153545035521791155831296000*
     tailpot*Log[v]))/4373844387714972221122959176883648851461074020965089631\
42791911984549872628055684580834430435920213999384963409642846452681968667681\
92270597388230709097410419232445220394416006638996241346482635075061358477772\
39807279228889008958973734100169372495206875517402857252949549204938354631045\
65564361890634176233835779452668665219144177378781595109750682978840962798048\
72890467940196762012035555990945690009043975353844034843692971537792309520723\
46209529725899908940992846689662420245638865984873858829220093333655264784121\
41053153583737067965316656459635440677951471827537362089053957048830346133121\
18937782790393932655231387793737334210194631403833633418731833701695725101862\
86088633482007194323813996687261696000000000 + 
 (v^444*(88080378134582859543137293005094961443417269180539635146722894019754\
34872173336309554189232987716857035140710279623137937485298153633917028125626\
17406634714401542065874737212392586057257148039746389746018761910158766814858\
95485299271579697376965843259613675709171162749473712478032977762219767383460\
46586911317046903904478575238559561394551841355898147790083153544027543460289\
58178531297275076651929419540574377215019645858431232057475191999180379169122\
55653123841378794478514319386297573417864686641214370459926479163264673901409\
41186523013619959637169610213989461149376941136887774274519029124208873234539\
42629624392124071824326291406742009257795438388665134819853173833055861936037\
358432469544825368819972413193823370137720324096*mem + 
    8849555672493219419491086670868165612077530536845894213073826966759831488\
37469005208016238759188417103977190942617855925712679226331970135538990651418\
23588552180891547376681881199247142707794403854851957223316395119252259884100\
46922948456400546615799416631943707637758453157844774041230185764723565938652\
89310255754140484150772470241391536960379880234302233042838868804594805683987\
28225964346128970656489199107119233982699780215575104910961012418683216309970\
93576412475977023879029363499650513251915900946826032375067172255674121464202\
48529877282212582317189502077055024506061048925474057722104016381199542563061\
30785300255010791013571020864561723933194752681318804865691704288659250814224\
9900136018161368521768960000*cM*mem + 274017042636628817754997417638784075237\
68462101855152610907401729638183566136612031724241828543264026352318549447231\
49789045658560661303442787982755707170286187326944933215292398286847979408738\
75872298795386502861258296187059243899226007605371371115997712120082076627506\
89930251292516355968752212057079462966550619112256615844476770757497332032700\
55403390624077029146496628316363414563477444043099316889022823345756222713322\
56239105688704252697843039430690518739495982061566765668487179718928935486882\
75147625332036931665800046139860529304161675673188259810921731602509509878027\
97632239412526386890755827366092068962039700722653190331649149553127072241386\
5658673538652394688795330571899673797027534728242738369204318650778*tailpot - 
    8924408168538210453741725645828437579439457742255820291077951453076959629\
10024121784792729241467509613348843741404962660040823661719976842300186757752\
07458821853366083064719232924950423959161092927427580240564184515078805463920\
55223063671682689639261165110881650162809067429605459625454923768290710934724\
16483039058275942013933916892997865280350910995033255708985950915969943145415\
75117707755335504786409008587856218064822034028435519904100522880871254047015\
43907649665272563362462684625556774779142995496034731620595368038813302489253\
41854678592846248929663730900873914752235496636455542540591559576945463431977\
27286895079912475955876599334534119975849188224624971880422786973841096525045\
284070251450992121274696610107481904453125*Pi^2*tailpot - 
    6081201024933618211972975814666763293070087840424054586863195513356056367\
18281134871692922597751194380703883393207719831951053151821058616615114276199\
96004609104331464283766826392995253670344223078539732962073637672584733377729\
23657564635280467081973543813461550225940234751601649917106094749982359036518\
52402561171855136661688781482290998644724160763859357122326318094014335107979\
29815646042862032967263144226404436228587941598171822553154343073889264638495\
99670536796149072537729248144858588247912278566789434077957467162512313696231\
78540478886839966676296555894539700068653785990269653601957932265917301745797\
09328991113330696051486486795797232197550676888387823951184680215221719589200\
54004974265733394231156736000*tailpot*Log[2] - 608120102493361821197297581466\
67632930700878404240545868631955133560563671828113487169292259775119438070388\
33932077198319510531518210586166151142761999600460910433146428376682639299525\
36703442230785397329620736376725847333777292365756463528046708197354381346155\
02259402347516016499171060947499823590365185240256117185513666168878148229099\
86447241607638593571223263180940143351079792981564604286203296726314422640443\
62285879415981718225531543430738892646384959967053679614907253772924814485858\
82479122785667894340779574671625123136962317854047888683996667629655589453970\
00686537859902696536019579322659173017457970932899111333069605148648679579723\
219755067688838782395118468021522171958920054004974265733394231156736000*
     tailpot*Log[v]))/1789964156442374489156667591876103511037800337087606280\
12222747944679374377294503433693377711804764637832933243923993397951696531595\
88707621982377266807681880921963940417536617416293005228098405779604731893743\
15845406588660034290003170692441252106891455181119766192047838900684682992103\
87355125829407638937566424219215739942133057000782000225872356341563534329936\
42302056757263151491562435219011738394569778332447308246166110289686719096732\
59723833156200686565495402180903050601639513640803054699040517037993663483479\
53047921984435826812086716312824080678337601221180379251366736320094824280536\
78963958992728029232513958813138608376666511181412984723144709226473473246029\
6229128374681252106236263227457536000000000 + 
 (v^442*(42513907052992662943750354035538206523061725844806925418081329201037\
42363933896883581148769260988621282680509162665446345798797469893823308822047\
90224093543914283980225579971134157992580694518489990403530198572589932904009\
75038263802384699492081851788417597183359480847370410158153092502868188888172\
07582559414550225254653359125653197997296346157112250942780075987959992148350\
43283746381729302019434097851566660907819586924566608981016959123779069307333\
31179771241369413522741894832531791283548091031539336951369877306782512030294\
93683682981732108428719503474216777274085798116493191678584899119332497684894\
48778393481784591791291466140055143495775461511625769126053849702328033576847\
397212653785091349854777234897079142581272576*mem + 
    4919203325584926258641215242626909190215400070993203068662585157896669899\
48064042121582206613709459035485127901928039525886534364023801934618277442949\
04636240854445608363793819245278159739896100996669649578047364791329300497136\
52742312957935527060509632572194447890237578350185292582121912802974405722701\
51739702761624283872558745037153343713811507836650060222837278824538523380260\
64281833923932185474362107868216118624684047348573840954641647357896147122403\
48222930496285884956786691401069194094610219392239001555339247156535672291679\
08490704861689446803287894785453821391219404223862029718137082363744653408789\
86203877528288468598838832078741788265710924857905544990516455023503226224850\
3381603984242963906560000*cM*mem + 151192586955183122649506117839683441546022\
88225412942525413564077616081612304154228243520652417549067090596633962305802\
34871353253603882568347256868301046177288130830048190520557248457209222161607\
52551550572616542333807657933724183122284552542739374430268897962529160007405\
08946590426930622696889321737499289978933820069034363074268603652668089564148\
01321094182394254544262547446669205279279140902163739797072067246838100620912\
14272862518209079762063248072799251109930608062482994392254957796582794604516\
18632590188368407203270485007667925484807920414915126277252982121850302043639\
26140442031089473304848172156393738948042892720664640222710204158767038336341\
3391542505712639122627301634614024886840738456854349468598913*tailpot - 
    4307559384022711423824134696073724917183867671711612634713493783420650425\
98270572436993019675031719967731196897911652837103101431758802865746048513561\
72913532952718467313434650432370374492453399020893215618004340023844592402425\
10758265392600541016241932670227508026683533298621650316449547298168045278463\
40935525409375066157871892112587830281038781503033577885647665323595956511573\
70500077545946740063446741071519852384237659124235664691752312853356434615889\
42680246769175828818463421808366817576895501062324070155763324603212260672073\
95486092573840164972011693874570720604723785998024549666880356646329690637476\
19352246504310835637146991068972197031819510499421643281604635447177974204943\
825583007180890358575901861155491250000*Pi^2*tailpot - 
    3374225591356463176760173472951939782034344863107663869004951221718016273\
44664866333657162911664965765844433941681643337856327546824375609973220472243\
88757974281554191552375340542827704769987391247156664705230350437911209071194\
35038725211674551593379742446872339971229205555541898889634773467365147521325\
68779716634220393994451126402196281089809629107328007020257918480630240497199\
80670551450847577051205093851347713647769966391543762286046633407910314601397\
97899783898341557520019661913633846688299718261076892808446260044890345323649\
20757819645919583144639980487468527994002624528495569800182696395064332124350\
57195739418854064223911230957310420023785999764648757063352002513481672025181\
12735304720562881105920000*tailpot*Log[2] - 337422559135646317676017347295193\
97820343448631076638690049512217180162734466486633365716291166496576584443394\
16816433378563275468243756099732204722438875797428155419155237534054282770476\
99873912471566647052303504379112090711943503872521167455159337974244687233997\
12292055555418988896347734673651475213256877971663422039399445112640219628108\
98096291073280070202579184806302404971998067055145084757705120509385134771364\
77699663915437622860466334079103146013979789978389834155752001966191363384668\
82997182610768928084462600448903453236492075781964591958314463998048746852799\
40026245284955698001826963950643321243505719573941885406422391123095731042002\
378599976464875706335200251348167202518112735304720562881105920000*tailpot*
     Log[v]))/996639285324261965009280396367540930421937826886195033475627772\
52048649430564868281566468659134056034428136550069038640284908981957620866492\
10677765483119087373031147225799898338693210037916707004234260519901535887564\
52483315306237845597127645939249139855857330841897460412407952668209283714509\
07242560655660592549674688163771189866805122620196189499756979025577072951318\
24756765863898906023948629395640188381095383210560195038801068539383406034705\
76949157330454010122997244210266989777729985912606078528949701271425128329186\
99574513815193049171951047148294878185512460607665220668204245145065027638969\
89269504027012226510656240744246387072056227574134025181778103143669055073962\
9555262865387674402816000000000 + 
 (v^440*((6839447024522091811474555531406745080900194150053984596788385144303\
55064452557389194085351887750280905185746754882861565291225492093535221023860\
56652016435784563132195426604362899473986267837598589420546085133650547970066\
27471210410272123637649937091159656640131985545234951769826174539341501629689\
53523570187578961298053779816138001734032228174226017967455948192201472260055\
14656336398419623683074653493557058616177704114816118645240860762726475448547\
33463548248309156032326093261403369870951429545858988421390754265448835842673\
13350393842394413953133188196778053949856015816579297232872940950627348238937\
72599165968974836444188963488542648261368929150951659110290615196619711315784\
676731109383376013087338781521460418576384*mem)/3 + 
    3038237299604246941660631504074706113444209744553001432334015049627570175\
40258097340806894474465943327285761013525955515941413134611322038260672324037\
20981107354362944160674625956234293316943245202628499664860088846357276913642\
90175756208042181329807548795499925887417329746560248015071005045646288684083\
88124548362065444336983415770566988915418844091240185987387149359949177999933\
94496351885799092759121710153795273018958356126536789215497179722827537255929\
12248361290006891947554565850623118940267535756030593421951435694829800401657\
94849090319827086336275302637720146580144295954392520407134253282465984990426\
79662108652736004024621718374879689973450835798771013380249464943263445418117\
502950265470320640000*cM*mem + 9268789527570690792778710178694600748265998975\
02669950752343655929786509818551438317317859156598437002881025827590817285751\
51983008467155294962409084980254197473025390251664702536419360200776209381920\
78124457351062412691357502965439476498758783970512409054696090370085543176879\
75182715015776028589101879821335342324684300626641298003114212690909104895707\
06218300562394200210523471338001982175838909566580529275492757745485920079538\
67740568170673908626881696612203004221705008826381853382762394151791638214077\
37470785554418556285247758711232225745838518223537608265637072597907194886690\
36129188927825116890842913720214902834231789310615897899953593915352713554015\
4175302064816153628457628525445952241169626184807949*tailpot - 
    2309936226706040671147931661740487375413770145805873191595075620754271050\
36845272426478551573556569153058176160192303293416844906096378661182835626470\
40932784607930644269999038810708300432216052348736089186401080660447378114425\
17121143121200816433776255619644165794392960639937845305824711414140019015969\
95500418222159812982772184189326289313021314091087827018621723341248269868188\
58414907659861759399535423052837991247454459193571931697772410503280637764823\
67689918419340550974796139054486107723429884971844646243286213543050484573002\
43388040180086827757227966426923955645716077434867623523750952707578852987659\
76198661003711810220320137828414515505238113625336335521179238812379420563683\
27284217906462936974720399285875000*Pi^2*tailpot - 
    2080218416078227013231523199777305135860517698443582158902764951662547310\
57210209853840413076917521784273140428723335914798839095349855153579675507014\
88783920904933189492264321692096838865584159171857785163249050294031005250836\
24785847784831836630006980633618639677510234048839201043227831752567047959314\
86164081070659120743711301979118143238677890903403644796760352005400970570623\
99553663509625554318365874788263851174816594636215891959470995562535032656787\
14217495274287533932112386485460258904404808402307312035517216521429542702694\
81921259992953919792799712693392465143875286861532364566517486238306683452419\
99827626919974615745008034712484112514243494490903332910081153775247262362297\
9061205955968749568000*tailpot*Log[2] - 2080218416078227013231523199777305135\
86051769844358215890276495166254731057210209853840413076917521784273140428723\
33591479883909534985515357967550701488783920904933189492264321692096838865584\
15917185778516324905029403100525083624785847784831836630006980633618639677510\
23404883920104322783175256704795931486164081070659120743711301979118143238677\
89090340364479676035200540097057062399553663509625554318365874788263851174816\
59463621589195947099556253503265678714217495274287533932112386485460258904404\
80840230731203551721652142954270269481921259992953919792799712693392465143875\
28686153236456651748623830668345241999827626919974615745008034712484112514243\
4944909033329100811537752472623622979061205955968749568000*tailpot*Log[v]))/6\
16579612301572608889681017302363852030399546452731399081680136426928046464766\
56942320260244453140333103276757033555209282918202151460570707811666453124963\
42101603035898168707212752542710911103071166951571332303815617746122960320699\
36647567214760733197139233686489666827773080891281990400714247137110620240414\
45526895996141902493112351597760576707188664302787414670224770012105703191653\
71210064729890893459775485884193615562384806402214416855997714531979444014192\
09430213588350820953834279872502230932027313598905855684440229519763139168479\
64100439895538415539585197018440772841294360458515877893862267936584409966668\
06799465627780404842286597517677637976479694446389302805663179259791070612946\
944000000000 + (v^438*(200717465924286942868744789764384460097220811092030250\
02940114110173824218569861521207117605846333136715537106891860162105984126814\
34426528895555892608985101653015339403632610775166668936260001886606932364467\
51391182195342896785456281430906983293496247787733278974298528879862038373057\
77697727062411179808223839409288276815288216605274701457668202724497352533108\
93966925202000116701082236374505251590517448878123582279168779700206307979024\
24129357849955593208977929668366536962086482102814929299584009365033975499786\
06057141251284793584065848296004344682885880872541440537289524501450467898308\
30463990175398402326331442380715136743936211973776727133365252843062576325629\
67829223384636895156511644991136692985492863098814464*mem + 
    3081075338635215326229180967491820286443192510775088429094181244852628066\
64653447376729845686858699261841107534727728484537380243863009828354887568726\
66961586014031076781995974866940317393607132220561402662453530762979711682562\
44809961428909935783144301270724384928643458413889308445508848899273074928643\
24477261641702835899246212528485177558558013269907999975218920573023753914769\
04445858694790030982219439590571540615581764912804925046387181673087002522867\
11813658209751754321690577778261941777472922077515418404002365237748435128978\
96138275055374427674981206457647236533084467463319756454866651853522343672090\
96494999074891647039728239475213084704004671090858322891615106281504839254003\
0850886386319360000*cM*mem + 932943015925621945474511666338092705883500038223\
00330064612497630736294375389437414294800632044932948596869005769058978767536\
78786484680413136632014360633859824600778307559939356004427134600289173839108\
08506838194962175036126798638155435775667866917474108796350690955984015832985\
08902029924583808845704828983153124224547781227997898072035563136912773992586\
01725302631453256127895189697213689552508711260380385559456888309200842718298\
47926624683647745722239742806385409103369849947915113619175790605070930412479\
51708270670940798873314589467094578011199980385740663977613804020316127400458\
21800225722187526180735172753830627544772410244464752960699142776135401675378\
832457808862142683260548767960493197396099410821*tailpot - 
    2033693122608444962000152700817903169790390657335986428421490670801640797\
66953573325302598440947705409658910575656873164977521674269741008394093013183\
92434264472048194062885757999752514649737848983134892051708728937302873039377\
46941821730948738584173057158227514545757536358292803553505056415685111818700\
65471714837836384109328923719942336903622499295302465119781432601837812859505\
75084484550484769549017829838392920983555387803279523345543616996630868111604\
95517147513523589837084324271772830812709368564962348531057970426555039617083\
06321842745172544635322668964959253181329540867996612213727481402496632430804\
17645031210582223543350811642917573197129274442017635421961479970290726253353\
002047468649067466118831186250000*Pi^2*tailpot - 2105687375433188931863341542\
64663143658395807058573043172214659696771833904232700258243284349166471372211\
89158883660652672870219380438832316340994076670459290579425197620908697763799\
18868710071007720634947516555577560384031055176191859300180834952298956335599\
92989346250993680763232990152835462166600242938325739981601009424088315613945\
05128838286329056408095582338866859951857356472489847316872509864434541427198\
83203762706152535740381308565117076324978100975611810326164170746819054489683\
81382878562620003193123737321839630801851395950836083237128424586432379010393\
75757017822845015449449738319215918961741874041533655612012593181483851598206\
39293942329460966361328552023870759976591980915048744360947712000*tailpot*
     Log[2] - 210568737543318893186334154264663143658395807058573043172214659\
69677183390423270025824328434916647137221189158883660652672870219380438832316\
34099407667045929057942519762090869776379918868710071007720634947516555577560\
38403105517619185930018083495229895633559992989346250993680763232990152835462\
16660024293832573998160100942408831561394505128838286329056408095582338866859\
95185735647248984731687250986443454142719883203762706152535740381308565117076\
32497810097561181032616417074681905448968381382878562620003193123737321839630\
80185139595083608323712842458643237901039375757017822845015449449738319215918\
96174187404153365561201259318148385159820639293942329460966361328552023870759\
976591980915048744360947712000*tailpot*Log[v]))/62632240527247781941389719590\
53357413401349794666571773967405449032000471989728131838401153499754661376179\
35455194127408065760518468561101998086905280050418497905500260536324660437617\
20539729037968964519347619338984830378224201903266702348814140480798806468433\
16486457618462446976905094363914474304735420049356769097787418477679887259191\
64610824339388237838698343151267415472857030163525292218764887336807426403757\
98806478624676363002178049327290553936585774410529174626662473559690570073576\
21354490280187158453896953905149058327165070560176940225271555820991605719787\
42626360690349034002982958289797304096229898081278343060842551056925288706294\
12075329332186512435105784707639518440315615707136000000000 + 
 (v^436*((1752947262842531009874383533469302303424495529778833064756151877041\
80272240483648960700142629404120058549053828471122326671123866721314215731512\
40821653420660041457135922572674979461010356849008114731694544898964470642379\
05611435463147512977550363545180105846479743741786517849680849552282565660896\
60699831404925471438173353489754332514260181744949357331965018954185335704796\
95564560284759482674720022020091932400102358175300005048596616785887636257308\
08233423520090937227377396846621900419564109780943101425589243296183391926595\
96921506719166323459605196869837720804003392210523673732579361602167210890913\
43381804770649433561715182813964950822451674756284678524464293097911283242013\
32234908734701585132566617520078848*mem)/5 - 
    815*(-7606604559972224116402997668676219919771579833892436453382772315672\
51055753540755455140607805453776163968834613672962845539499954032273078061082\
87334368538524796716376211000845026584752602752174839997593586524402497062054\
11732253516166854084782426943716584998070919431708932076192683060968980858212\
79808715903083149386970387265448999920643570890905811703482329862186540647460\
95711830363103856337060061191587348029785440656654559033758955055930317706002\
68661716318817204261360823901210817328051118957208359094999859881830254886380\
08200169117244532399398095284039272099092593706717346486550074023590002319469\
65574531456869239011968381920885679321963202283262781456187297963462464198492\
4518856418918400*cM*mem + tailpot*(-22860243419143969783918091764561053217256\
30977243803098491252695960701468790378875218014627382817536044471355065584145\
54616293460000737444988753735816292787729451703435148066666814799128996946303\
97176243068675532627779173362169760616085958811990278625273850794945082757446\
22587407245693362574455520858213870055751041746195316055642907747701127464961\
25434656580945105344608106451135231046077126785795672497107212973017681946550\
72554761364487070528363761118925333563638826862321413186949858507827525133454\
56786101500727326465425003978171330341435367031735729980397456875459001202985\
42721718190044514536385726276358236385911074592832567491320643384714687335658\
45978319152160258904314773935934187028819219178 + 435854457774817999192062461\
73032517944326325863158238732781918173120480457232380677909240207723514925985\
16592660008826130010893618183303644048279346998642510006810963817493524032503\
50091339337272798577710175179468431720265089086722291032855214532367687608250\
73062740374138139629598169510579610813243488127668438896438078891971049957499\
20544808448221808509307859243137926390471635614714928093690091273390937942267\
03687678200372788551489034731228067335503888686888190623823404836707756318613\
72128157146634809893843015496633688648002177554130948508483814482053389001980\
26211634335238357551047193652935222850178247994134057292988102025962856591971\
9493216031426365011172051022290559784832100555162762152998728600671875*Pi^2 + 
        518899363261978844228853704731684433553613850343824117706388853144818\
34854600485618209559787023324183151478755214479808759801055989548102865875406\
60515382081724044422183493151538480325990737059697711331639401014932935046568\
46252127718003226444465207925914766748056473061538617884218586974941613744150\
12676383173402553293169815494602980809276304943243000814219513210133731802648\
49170189871251927056394997158930350843497418802980583346994418905703572860045\
36319460384832404909129508196282557780748374149409814424803956100887302756942\
34420146904116506103676924438527248341571039063083046206740752177832026373367\
74729660888698571990199910741066652848016862464335281937330498810581321447130\
354842756587520*Log[2])) - 42290298105851275804651576935632281334619528803021\
66559307069153130269540649939577884079122642400920926845518549980104413923786\
06314817038356884563832003639660509620407954691850386146568245070365363473528\
61118271703420629532969548409017262955223914445962053489966602554515397357563\
81483845774152014823533125228632308093393339962810142935956018852874304566358\
89032662589914191585207370474507032055096192268452823593745039632442917542780\
04514081484118809369710036021363841000094054917997028459130992493176899875621\
52242222231517469080105241972685495247449669341739970739838039683641268265849\
37130249331014942947140467362428933617201292725396932207113374290843325477892\
4356530623776979411239196846618828800*tailpot*Log[v]))/1262339578507896282275\
67154930936742450043328657420424338265991797645930183604646320509536308847038\
48307359227974728462755275727960104827112183305894873637909099997989772176811\
11813965667118047363128114304813353333296323327640315689831956401445914237318\
73727090383877330265689434394249725167576473410501049043791702228866060901319\
88187664556006617611017370176925652032961453419401607617004438462691215269417\
65567071082039636904957332356055492729977304429735859612406776577363623824785\
75607820488441032735149114275575497927060994984784556598213080967259670690736\
97435882429586437648118228051091548891432281849199816214091080716755704952541\
2912426257810644413468462663466995944129954934528409600000000 + 
 (v^434*(65089850706927537822104628726624284966291118783219704457733744838688\
50887647148112532813171693519153748429020601343678300231831187829690369912705\
64250930853682770014543590990810643242007342749829561354217712009474751449823\
68782100743106326837877592122030244573463832628691375961262235366562611251115\
45524363887154517263385686769863807769625432431598295103224481580190084401738\
16560102544737349179275137102143317078760232658597171401727033903574855053175\
18913862136101696174975593203426750256679955380267132838184649134069272689534\
04832568344841316504496270082176377000045814149574852842668400602948238900746\
23769307788051118932966153818882053121035614794243626525651224468881966859246\
168151904137886013371449344*mem - 
    91*(-14571070068776649722388134679467508797117678292301202485981523490069\
44701093319028545810946647320156733001159956475391853483919210147728985551483\
33457860663452257039851531358298232283083519102166880038972340693685665313255\
32463798005730205654986254637858104734222909850441458777323150875336692145414\
83906315863635983107761645355237178512473216903687473720538834124719548387848\
89642322150709890434512380421102940603626703009668538783613154524755764375913\
14787026274831785275767834363212498620567847747902053497670598668796173719211\
30805323237971364350954434805365372943992827791275095168381305518960902192417\
04011740423580462775443018572560778729471599078076898775832564049454748283706\
74974720000*cM*mem + tailpot*(-4346145703451766740489635874516136328241764559\
20905469529618982780153744484175037617288872634539015013747887317940794260769\
93823697736962116074294202989932702380235279407633652942828302449544208589172\
17223841903732498910059842165055353571027099594666079979654389751488972218384\
52265154419278163089383749880331401111786751658237650632584209447409442182917\
76480230099689209530396468226161428036988445639663052369099254547913600926860\
11787001144799140739185601305156916799939248171195888832818199468397856885844\
10628520157332783554448220998982828364679442149935304734971378825749822823616\
03591885421503486181837576686705251364938307881615597894544455686270208561243\
9717216134861956792700959944185549843 + 7247231557285280702976113169020621708\
84982782621438211236869117231051435754629820712557470743834095775882080740108\
47256021501760006753953671931041912244379629095901087045347104278324350820576\
68845383403088188728496978313107462463587911050182263075371289152431943585956\
99343351459025720326310185876019526638126556902761234388953714951603458296279\
04713520368095396806461655736293913382903914667154912704628921179668982515637\
32421531568553757647014578270373975504749502815984366071687129061554984919367\
89489485498433436328742792165253740106442219542859951814355126595718283798291\
06191842052716510070884274287621012828112331749473484784237226243238939774468\
9161341264683273925563119014792067256228765913450156250*Pi^2 + 
        992157975923567230585083950637273689332909614062090158953390939954437\
38431922351801871482343392109484905017314576077051277227694318918429548793417\
61872070977269828527667702125766840662015123921919448169205955650128774534318\
97823624458535128115154718565415942885889581934943129463686744696722632693684\
29786976176366769260909406787450008161534015720849168499050228213164742738262\
15155499913230694408886207023546188626059044089313018326854963201289373619682\
13995867542080524033047920082007929621484364428003561106531362225179565055024\
77934412485456755338329419559539264375037563385358559978527106952562640515277\
18183488329200189397250888638369269434413702194696897393529126809321214488902\
4489984000*Log[2])) - 9028637580904461798324263950799190572929477487965020446\
47585755358538019730493401397030489324868196312635657562642301166622772018302\
15770889402010033035845893155439601776089344478250024337627689466978339774196\
41617184826230270194982572669665847907938945285080261595195607982478119549376\
74017595751252711061483204937600274275601765795074269959543059727433341357076\
73979915891818557915049210399319120864483914270316497137301212748466774380165\
13173329993910747362394632932768700736072746272159555507716294832406069435396\
24913404200072549203153617656473578797717991807305812841826806762895804596673\
26832002868902235469743795721723514983086609160351853164689971741766281115053\
96482305184901228588544000*tailpot*Log[v]))/270456056180571541938050846910210\
33860482929570382021254069888255347661116654035850106854175739513002195973534\
09128170845240424308981016416719223416066689529074560228581481102974931837841\
83144057122460561920208502225696639285604400912866388965857624406043146255478\
10565916468578631031288440187544330542311139575995753753670292913789693349676\
32551580867611203579697520564011301122499408028635447613174323402779349809750\
50956519485023155277893343423923400911131653187518442061619931231318715967458\
96479775489542524217837654979979420185196835232675536451540690059530252682899\
91969412003781949170413658905740749377350580893687667598161769031233179807419\
61441056158446036178648255170609152000000000 + 
 (v^432*(50711740852156564411864569131503199969242642624487050047733120461472\
11277074425310972543951872240195544077012604695201807379601744401837425363338\
85973433337492042425716836951419066873652023115780891232623702846851940269554\
80355057444926320527175438036774525128872926677147173859694603967803438078883\
89797924439539491091871872431579963242140736053804708916108409242991063511071\
48302824975769179787166243622515078457804786505568872763066834319948688453283\
30777044574048360497406703151522553302882588067461021017787337842404147398880\
71413929544132804198433444672920998422355688597762503513218900233374519297847\
03582310270858850799014164450607448333694248800471020680053762348844431005766\
86465267635942512918528*mem + 11902435010300504306971813216823231639335111152\
34135898535105098714964719904482446940153313598289206330768579499441689065124\
44135284512656889393963698003703132702376003206759433576203865613972432186930\
30951679830200370980587882084347431930827939198687093255001354349401468458136\
35989523097156610534743676459088559450496854156964664648573907122501987420739\
32814574019470472960908479339292076727223887887302381277456648366014088697749\
10716907016459635471650791108373195643424032022415176907079763664064212279829\
83883914734868948900056243350200588368182369364361172237032101679769571810152\
64821970017596479327510773544996444451430445463752651602065019816686818357883\
744189643877283276039127040000*cM*mem + 3523359536181207977395812566273398814\
22303767021779273224106766996582567387491044331684160318214097411339550199200\
21275411026410446975322047841287489727575298008194287650809003951238423128529\
40614329866586890978747277656524218893606336579158029737197840801099006538739\
13463220431046225070331788742613059213046006963553680743074306032743981414743\
76052557009658216742990781773935419806379513853457080761036866907072659083123\
88927950895782498975239388001599647701615901863403232345426833485047745509014\
42081073178166633098663081335305073816920812061341015139775982346999576692440\
78507793040063178977702202403175080724855141280211651711556129804191221356816\
34596810991496652410385021254509257921345477*tailpot - 
    5138173608060923194411647514918890507430550250755364492925214228317600215\
23590765966861898105697044165717225536140708605442663188496346165192884622721\
82892061529677935560819842752898836045182741153076770987683662475732143010291\
85896166347040812544496937033371198586179737734896849587908752208526731184520\
19076404073449180144162625112974105114748833286393109649281106621961889856371\
98220833884099610053705649284409767525561242153469939219970611967816675291820\
75885320010019185785360982918691407535405723383072422008987359962882786322433\
13633229783914066204651861290068782797033453995116048466149657056206419710024\
98882680734734678790288877330328463279545129908045722454374087256574379343703\
85669185619609375*Pi^2*tailpot - 80894428321124121291275338741995307034760769\
92220192490685810862476762208778002825646071415400652690344226952524797573901\
16260724169400149054387131158194208045158833033406250532533830337884890569931\
52514378909766082811793722525860607149853305152183395805726705194205502327139\
48702620277939270644206992218995142705840655663263262307001662145957047431133\
99822775514929150194193092752715930744878128829330353211174511631211181506740\
24464307133412765439604524575735893688637838987474707435390289123121342277456\
72566874504248411166231804784502424755116519053009800211002686798696361663937\
20309817938317463269192063134899290231116607614334989827307762625826693302905\
039286082743758220506403892736000*tailpot*Log[2] - 
    8089442832112412129127533874199530703476076992220192490685810862476762208\
77800282564607141540065269034422695252479757390116260724169400149054387131158\
19420804515883303340625053253383033788489056993152514378909766082811793722525\
86060714985330515218339580572670519420550232713948702620277939270644206992218\
99514270584065566326326230700166214595704743113399822775514929150194193092752\
71593074487812882933035321117451163121118150674024464307133412765439604524575\
73589368863783898747470743539028912312134227745672566874504248411166231804784\
50242475511651905300980021100268679869636166393720309817938317463269192063134\
89929023111660761433498982730776262582669330290503928608274375822050640389273\
6000*tailpot*Log[v]))/2431867187812356509453760162842078335374918736097172514\
15326893556057377262804542471887551034703689625308478007055044734915515913168\
17675489023109483875040724204773665461105709521626644063944136535408874408363\
07117483185223165127690740316409595890400485941250348981887595893949643121144\
50667074190719418934836134717843367134872141736842252214891941691728617993618\
64769488172591318481669122126671980346991392932650249525023065533361391494835\
15256779073860248756023146371316942991828599556851403839151160726190731706435\
46831734618932249102342938576337833059795523890295074630617079367322438781658\
10384597836734600322930946718027797881869960734742303856981272283759084897972\
208533504000000000 + 
 (v^430*(40458494876309346910180503388242992587665976935844566723911038510961\
89057856498762153092855963035834437701422576398728352845812980235401216906026\
43011998998546480063997694992318129140881892890478846692185066548696179057677\
78519460477471139195973039315281653810751234447816594477271497116401734185066\
60788101807507707941819928921411964666490523916051656502105735688886513013657\
37038491910551537222148084162118284129155618740058218301626386701000331702466\
46608756082146024103383282549598363902197349830247309246750490446992266348607\
70095799130635269161127439822972150916912428565217325447925334600699695681513\
94022250673074336858589975405946491335066567552287669723474547353085936226548\
7824012507418198016*mem - 11*(-9946954039764128274179997056466477018023724898\
76226716190277610118749005032247344901562976840642849551589589669595380754466\
78977318153726899879019772079563906367407619443766313604348458901806933838617\
74128745080444528148793643380662285590801073849734138230464251109697988429362\
15846413660225286548875637813500121747194658383708309169485374850863741010452\
22154141876117353287335294319781738302682527285065619652203510553078925350287\
90163412970958812987976770154473230172852546112336165524338460771598547573708\
19267099398265070188476075758458003101303753266397862751462381218657857404379\
80980141446227877680850987736840993367094268215748623235957883775935450571628\
1598640452875218583552000*cM*mem + tailpot*(-29221662249367418425107894589039\
59509555759616288262790511229438733928549770564913116116824926472309415496401\
35275288244811638617664872327903143291310486348605567693509255714766653126608\
85495209094977411158136561127729300179788701564487580771354703667661899609910\
03917648199896291786419163861408546510296723746160955758481981695257306759843\
39948995341359735839708055007900225987037223797068894816458659040972013323887\
19004221752241278188534355212742346794198378651035195814749928710176772235127\
07599237315908090337725139435932274520581774499448758475492594797219805859523\
37374135452396710163395995903465294979312765311456036279277071440606314061124\
65094398178744474584704633345135987662999079 + 372663871780067820075376019366\
30441863378301555896927557503465434239161280040399648826372895317223488171339\
30840454823471723816428535438111589785508699002049876587779043006233229903033\
39203291818345647569990212253637020172976206644558125056859597230942565524751\
49222450640057935054958816229588761254694740120128210752214390796704432443279\
80353290837767727361108858399897666700983762491814919319320686616980137074749\
36549177380838573035797859945812045689464235578346337423946576981689895174587\
32864862728569943872419774869176440002131477970540260370941128206314156066547\
21666417232993331827513717478438790143273557619043112045980218917432183817835\
3552868331290837411774744390521243839467432322996706250*Pi^2 + 
        674780627620210386615959686922298533463629680437744384400458098286212\
58285071811065082100788842685420361358787600440170191889604685840012246790800\
69189792397720555878321012653495015922251976512208035679985749338869345041438\
69542307864830643100660959317714374799552079741792705766201673118595850702932\
52328715604777351556814710600650633222712780949977870657026439016364630229223\
87751454775975472940147994533876955232810047160122636546587706794195077854460\
71483607182915562496783196037756744124846155320909397170991572536570594634084\
06897054434840383712472569589915879201430273340620367851193803631265935828543\
79134542962684254810118724230938456996827342453017536372187023622111527689318\
400*Log[2])) - 74225869038223142527755565561452838680999264848151882284050390\
81148338411357899217159031086772695396239749466636048418721107856515442401347\
14698807610877163749261146615311391884451751447717416342883924798432427275627\
95455825649653865131370741072705524948581227950728771597197634282184043045543\
57732257756158716525508671249618166071569654498405904497565772272908291800109\
32521462652660025357302023416279398726465075609105187613490020124647747361458\
56399067863196790120711874646151564153241853733077085300033688809072979022765\
40974924758675987832442208371982654890746712157330067468240463631318399439252\
94113981704799725895268029113059665403230269651007669831929000940572598432268\
04582502400*tailpot*Log[v]))/223939691602940792321143038307563070673791770396\
19191474294629852978675752402880371084493140403092632583051820549827218356006\
40890900672874964566859853757445644795713874671683618043455809697758901627337\
82658313552232736486405939156322716094520050005376013588700773788902835191408\
03228684935173797429694953530201907812843384687494271312958813953118267546375\
91178575246548128140527558531058597425326547728572993361870503443213517830012\
30263106624721574193499376554256681311597522632401451946768152686822341867997\
39457312992792893712561105726340488297478932467963717906297765626542470698038\
75758010940277026597961547693927144101818251129400736490591640976320328558244\
622989734707200000000 + 
 (v^428*(47555116028152390921134781087317592473358303727086938804970286653975\
74584036268640719550323186137445818561970565184976845670094867481418299630690\
24570503587610867715264754934902244097862092768905821460189925217045742272220\
36934024239083966594690542161606553891804201481869990181976425716447399265695\
21026492423276028827484965606999015502800723616431070789397374426729144067381\
54280852405860704297906787082586141215124671283694464923719888017300827837300\
56102052653358755383583406885858264447294152012173983021750674784778938856176\
72906977391328997637512038796417417864087289776436537122081522605236851428454\
88483046962775821270634755387770569540627818234836318576980902614571547622118\
075158783565234176*mem - 13*(-11400162673330764848257875453228118868619739833\
44469651311934712763785920375981620773365282034329257231542880382927714944810\
10909525551073931127270211310476056656866146412960717554572113524574821316129\
39264250743157390234368495416974326325501287989213843747769737458740245556533\
78617046189270607993283934763496196064406950642188212521309773073114880735251\
43664999222552600702943775192902589977476245873192158070476275278287730107910\
38924781497706728814809393393618999003459120740119645472075196539692176217320\
69812016814329401617960305914912515499754741358030512134658322713273240177299\
97800133186828718944438725283625839342786448906733426646395302618074203876544\
863875569955236741120000*cM*mem + tailpot*(-332356928716415426741788751570626\
33240765806938662878138601625625340722534498470387682439436222651925009504594\
61454832822068078071949083716772543513836667451175246744098118982167578171145\
53881192418004319336328446154366538028211974460180940822705681976769297585785\
71222851939613941882983879526338300364572547702193769197601018809324892759407\
83710534788319949986306768239726733506312051041705900590572119622840904250841\
23213195665155024309079399793564360251388636000679447034185945344862581987488\
04783965745062223260511830514189019393019486187238052292681331924889797792744\
74471894954959085945767887161323191622500324630745084368447411897443804229326\
321921264000232381336672222835347443092378 + 37064158805067690500405220959193\
43315145852682843663374009154498279919074559924949889129177746823094575428272\
26995263242769796054481563238107935377191602025015938948951189342564979529180\
21102030116601649458028331724239474744788014543993913102972671086125833657109\
14116467374900930320011366241536728146607107198156695137972627543355850770532\
02862414922210808963472469779220065786544066594269669909211246522079347161585\
96498658964772455997944722829054828894204605883581880183010387323377442044012\
95869441565121100707247869120266301664049139199388635237308916225980902429143\
93246489023664132774270751365489347386619345444801679904736216329624922288259\
2761571128045183996774630038241893570540049986640625*Pi^2 + 
        771915044451991222414836125769519722156442072349400919539023789430914\
62121879225507748473720887804708813028720215506857618001497891791410968561127\
65092673350114242885160371920611049554900993783091744038850938566299850120819\
24723157796287026130819885908222371161673045502243921202263231106671111209294\
39933215248594821682810490521331545139158514762864687280556705549241328502565\
10290103047153453085473794069639930288449164211509356281080398958108700309548\
21493094805258083736986511001289953164938235889021884995245122515848721071298\
50452379988245149599585773287591049883318379163098662542565104983907021256427\
79676425029026080220777769060646066095445819858983804940699735523166857195520\
00*Log[2])) - 100348955778758858913928696350037563880337469405422119540073092\
62601890075844299316007301583715414612145693733628015891490340194725932883425\
91294659462047535514851575070848349679436442137129191801926725050622013618980\
51570650214010513517313397006585168068908251017495915291709756294220043867244\
45720827191317982317326818765363767773100868090606919172409346472371721401372\
70533346337713396129948901111593229053190937498391347496216316540451864554131\
04024126794102324683550885808246430167693911441970665572845049381865927060333\
73926880558809398471869447946150527386836484831389291202826130533463647907912\
76333561357935253773390428701109977883988592407956581667894642290965618011691\
4354176000*tailpot*Log[v]))/3038442697845905669484331062487143279927313281934\
47459379863626758082494331101436905592141339187457774654571468199156831042812\
13011643078846228245500325230931092782491948489933616640422360217860385821269\
58701136534335627846731853448951401975300909426291177444843062378300592955016\
60435390286711454733159011524102097922528602861498484904464277077528456893668\
54905611024180722460968605935263879616151196086296387993046669119813896654323\
96756931686464776874847199206138574377910959504292217522547106316584892550772\
96331902615838915845950337510970828516602143762787165587758367334727518131588\
22351765067269125318762338803283999072014377333093133677196052507810462539693\
2103110656000000000 + 
 (v^426*(16554579250413956310696510302258223699976387286756903431825995558887\
12003955589417060404469678924521551845319115739663985812889036814688306064139\
06353424863442710506720612878116922169925848481699204453716772398966552991870\
38474707805179755704698246664856137027505952379227494777385152197278548955965\
25928024185414549394995511140899785667646855202205888163619779771450317376034\
24690559993053534655326464951497175806537700966872185485666213697656543593751\
25908211400069380159501794307721601812864274489910114220317421218902129791530\
36358386811431331234928102624114477560215310150772864179540035793889117757234\
61536052252728310828632334458169787738473471847909716612136441706646394948811\
1696304144384*mem - 7*(-84937587120593916885250306553274248329920783808191915\
41491426451321604980655382839055547668769454798772894069476746885094658114261\
84137396753539608622899568313574755796197816568751158336775384401454448648790\
65232184021631535575364217500614911226250655252061512787520561032191391573655\
93512427879250704547275602868567738426619928759892791450339760582648628604337\
10570793332417702958760284027986583479883114916276854525104087220291614373224\
67878064840549795668182813830155677790351799049152757193562684994967550305441\
48650513771823902391612245258682702273359617258231631848857508122687184938352\
81273493273466050164539877575467410197052545444161414884891438207608699717816\
124702720000*cM*mem + tailpot*(-245729659005989506159281921325856254084236482\
03564643547028817168138687083117446435537953934899116241804578963875207545202\
21226221727870842205967036762347995037746339354692906774280489865200594404782\
75269629704372806244185259893484979395018463692670042500116906638078126981791\
05279321682888895512968915815535402896106003530600982680595203424205601865952\
02829683433779982429359561753651021700770332700186790735897729545956290501640\
50452194991725491121513935187627295087455578764676415623217823881604952052981\
38417713391624306942991632115003765524301388863134326443738374543456078815192\
72475575789952672220408893161341203150571949574434047159221702221219604284355\
8037361438898200758465351 + 2396185092181539381988342645813101837423801995466\
49740461859809088992450477242817837192205029073504553056471195095752238702882\
46878736790335381605011863331102690477018717748173806231300640683876012058831\
44370277460572719966017022042254357036864451044667398619222353067429282866915\
42021931861252135052370155499017242215907794373422362570856800037269360271758\
77602404290959978033486044133712480674988887720821331221746190601423641765192\
38819134878123741961402039796110037669222430821536792286105273433972364041763\
14943968607620586676098134345976371857795626851595060427864250709405013645292\
71873744403695537015256402751913381956343941165363649781254557090944019591743\
010826536373826095792774687500*Pi^2 + 574037894616894990461287547405720852695\
37577296806289815816619166536326538970618806043285981984452426921083491739052\
42040189677716658475252890673819538981089926889160644683746549939687868625202\
87223701313343495959804789004862325850662554292638490785151240135570842716136\
71344802023564933881126957170011004377392874682590674431254318089351772250315\
39410696611949738403421059344008186770866944469374376955402173128730056317106\
68961287788881519033728081215251928391571789995231050596741531564042754340018\
64162118098216295012697874429995151718035538725372234602563792730539830726420\
62478303781095549266158109409924304821149006808880508617645838504679255422782\
430476627975061992487936000*Log[2])) - 40182652623182649332290128318400459688\
67630410776440287107163341657542857727943316423030018738911669884475844421733\
66942813277440166093267702347167367728676294882241245127862258495778150803764\
20105659091934044717186335230340362809546378800484694354960586809489958990129\
56994136141649545371678887001900770306417501227781347210187802266254624057522\
07758748762836481688239474154080573073960686112856206386878152119011103942197\
46827290145221706332360965685067634987410025299666173541771907209482992803801\
30491348266875140650888851210099660620262487710776056422179465491137788150849\
44373481264676688448631067658694701337480430476621635603235208695327547879594\
77013336395825433947415552000*tailpot*Log[v]))/122108851716263764493832394552\
94135556418474472336506997256378906595750295961702345326894648804841489580112\
23703130737493674997709753476749096905747161063920219886448560004257257276987\
12217483350333913570086530191924453089118109240914225549984497198615303745177\
83428536276046983825430227930910637544668623837526809312994456853984978468803\
32048076316116825104150035540535493580412192197716675313981309756285253746579\
19987567772581572169430761415519447370159915948441721051715663108417459966987\
47366280890723078504377752311444955170823679457153090529433757244395941239333\
77855361052167196386124101734537106572559210499373764182550424277812480254732\
644924840874217259925504000000000 + 
 (v^424*(19207672135021204253323553961886170573403967828270270574678980090053\
59256909013764066181713722340769694817311817503718158710925086073508194348031\
61497465737069314742297507272425164624643925227265326980855057212856083203141\
56223673260675642090884898726842678650808129344503915357600495403978381053425\
83675378837625255473247565850635620171584407628280950727765716562700892974233\
09766921417559055212921674855717931950422755728831179545497973337068172742462\
19701548556441694288071297372172771245752817603369122438685033601967258735289\
18356522280367643044078977742104713238697771987523832425932907907727827703535\
19881386253166089413876093967030348316304934019101525161572389224123925459742\
4381952*mem - 89*(-8933590586475700624770649697288890845719481643025398723506\
27230582068783913979974239545452453506057748530157094774125273297384761190125\
72829400999530661651800321404434878465042388425063631804029231094977221657135\
78539189970279731494788045779189533266091594891169546112705010989306578184926\
77253672640204590717281210934064319038396076377645259933092285267213920370206\
60628885350097951401688335172921660020711862720893656312496739734960457802723\
82803309183827755419751088897749852831460172507779525539282252269320516168092\
01119391953281471413009520896649315711800503981466788604566002110855733569453\
83743611196191522165785822776088337845630507270779754310939733326383022080000*
       cM*mem + tailpot*(-256467669055893512939479789350683043122890632659712\
59287470787623665438353852346485797835426431291836315898653185702694818453959\
79423607270507981000044134693394763131758001436509666958415287040526662145247\
11808127016886716933580460768725114735184123172287280599168428458081088413898\
85920958573959256481052689121842995070626583676004567316645743006571973482706\
96189945479842778235028325735294693410777945044722494567076579722430839766940\
20770554630192882522846547575818622027395469157781557097299998743905878854063\
38180548620491536878728303600374831450581046838567105155335141119027130235537\
36149369979783055271420597226706956809278858686343826060019906869707296806438\
515360127543 + 21866787370399166626154360826256738745699094463165747899099412\
04101876037028016338552713398424566958067978419224899373498920165754219380281\
14214324713960260472855649662712723064522049694967809906018040115562368873281\
47444449014907465375158431847689608585784375552060858538077716863874086550003\
30001308696279102882093302939560777486272801109089039010260588260608148667019\
15032038736291205738482948341504885392669391422800487978209740798766704168337\
89572332806341313332936401377692188959994297385853462262123438019749898478022\
42200852080439974137500879274582173993347612805504137906537484814803294321122\
16314080649807907938508079837674137317957846266624466621026600918982190260539\
0655781250*Pi^2 + 60262211403104115369953758338295280500890645740913086092423\
32397446514608629770566658500180380611920854558864758313491680805434653169571\
99636701434339551039027176104722851730300334404344702804838442847535712182363\
88192280321521054647475669469326104824052883014496493680610904720330864751869\
68823466871841125906375989781576591530459259572576940019814877295344939726912\
29529848035995364834624586317846247644581459403757229016956065203162347997847\
30156800978787769222070720060567184225040176083706925721276780571675092021660\
57413741926957820595714946335873466066502231334809112074652186468885796670227\
11066121161219437130227378420392267624350443139019643507295578414994480128000*
         Log[2])) - 536333681487626626792588449210827996457926747094126466222\
56758337273980016804958043260651605387446095605573896348990075959168368413209\
19076766642765622004247341867332033380399672976198667854963062141343067838423\
03854911294861537386362533458277002332934070658829018793757437052010944696291\
64022528855159386020566746309056031664621087410195934766176352407928569963569\
51942815647520358747028158818228831604036774988693439338250908980308144897180\
84098395528711211146076429408539047939602857567144991638919363347087908318992\
77910982303149924603301863022389273847991869858879801097464404459573083590365\
02128488478334852990459023667941491181856718943937274827214930647893450873139\
2000*tailpot*Log[v]))/1635769060033647574171356083560726110449740181051706782\
82639049133758302781030504617958325726261520412544437676911572728666214468440\
85090651968215964284465476118785580555508394695147263764043466016235079556985\
23117788979508395391255555659671965636585727693601241999718185331789734575886\
67137901511934067931572298287362683817830398429839882014552910964461120032101\
55507835229050173239602255286245282062718492009915433787310215324688297989899\
61252356989360367103042520496558779774042018668210610075698184404264011453271\
07476636791430098104964997488646010369091643865431026435026906137935354447750\
50965544259986164761301846023568242181802517378012525853255505406853120000000\
00 + (v^422*(6432570847651999291578533321048595442797290801118955870215603954\
88929684438456087149605796632123318581211248265953523055377847834072372922932\
47020314429647466404875263216671341821967358278560582694023068526426492071122\
86927902114234659391403794630189181176997364171283413008547717097441030266932\
91147301285479627811685147051103124957734900841852445837856016569688178387829\
68703400503575593744954350992755741412345302823582184088089241612069979161361\
36711242966261433616992700505303961594888338965536534313243975387851910788006\
75080706118558944091223091761719772213041770482616969698214609973934126477115\
22361069902486052795168430878371770328769449708840186033451998285374842828009\
7144832*mem - 1813*(-16928899328074530878506144698587128933784980893240679491\
27074772886903228644666060960018260764639442417789226300087877281069596322638\
89461862663734148469771669635859416018470290589628787185802132245626024555514\
37728394840172705647387469100005768372066736198608743539846792912234741774414\
13224057529129662254318702641765432533151406911484570992847095622323176468544\
02072760838285892040868096300209419900705755142993902426327579925615926958456\
43797597913060126505876502213984187136657914286166246423620599482874197933863\
26052450804905445640363364014795178408751072678173434581387793059615247640537\
287802590086681911499841909342279671199045018568614457186580309045411840000*
       cM*mem + tailpot*(-482246445252073353421131753022834995289865648460311\
11126322989688700445970392738306316766383143270615581019544393393358226068881\
88347771308378047259661863952644445977941283925993004874729897483439318361527\
50929094286177332575540718815455454073867069703402081438791909761169655051714\
96535665954531633550946634887729237128121198314319982007241223206483948625138\
73376883259942383142821579227339893066575244519328144931890536230194052401469\
81103205550144815170668242912262298539486451692717336066608035395009344942625\
62480886885185729998913995622152682862388645880450942005974767067323170722160\
08594142755731139072850913879591551454094864194677486409210164576152856946794\
2620717 + 3594901777362747881767128100156158905842441472345081464512598731907\
87013247397375206806458384589966689482696016090533429408331358450491508261421\
43341020573624960152010526637284610519406562631803973070076765671188397625540\
37436007393739080798433293744078732100286829678574207599325754755508888471547\
27112571569242104245218671089917029583427050516619340351620557879763293281314\
32758091057912790611775692877261410876876414760642401546774579914878614208862\
09245394249010282461117189337320582400778247274766487820864042937561319560513\
12228617465426191578137729146993569821676667598335473582436657502187478894163\
74510879541878190164209136091911985772485400725304789278456761918677371562500*
         Pi^2 + 1139783251095794919968316342704702006837289031924853443501142\
22340219464337493156612311492344486276700116578372456817556495004117068918815\
83244395130949017585341994419657360833264931875239985464168968874765904818107\
67330633688102283257166200750011833840815751980295646020536471215801285402610\
79350397450044263076891880262235948995660465284590085043107155817626695323689\
90364349319411975053137879447050359873693913878416165239413951243048261020315\
33291614203788039073996373793712110630733862604963185628489353473592408080335\
73579390222031112684041873257364510825189469520995816924856529028117828137956\
60622715664415916961706604023613841914838094654106572154904725253120000*
         Log[2])) - 206642703423667618990255752932362473839600501487975929306\
75708510281788884387509293812073562055361965731135658926421022992544246424594\
98131042208837241056888222503588283879519070932148981009364653834056995058543\
52292117043887652943954524232195977145475339895834027600623523262231424773043\
49333686227057693024895840497891543377552913242356096182418315327349735719862\
18497953056531609391077133897543750230245100706586156850757905749360364649722\
98316985769655146771484115542568800005657352049290279825554445119784762303584\
96486889943447254240729616791621560185812606850824156541608476488712797762241\
41153270898349958605745157407309481189539160146560789521531684226688390656000\
0*tailpot*Log[v]))/6325479737175744679703619812686489212876025448769167760349\
53786286768378890295841523427400333571231293675319709634852005669816196600351\
53333210425229251606636190199460771494179022224531183462745615758234945805224\
97250500805859981653347485197082894763061460174949728221907702203149945424096\
59325258832435930287309695911383672971378305645328749237861424830317216169973\
23415425561381436977011934436512230156581631536866926953655547905251314383652\
44999958856794675338439661866897811454055174828345226984471787563849393933003\
73692155568824845185605137842267475219040469570867884868159852804928258896015\
682299303409310181819258451981522884861460866687001285982420992000000000 + 
 (v^420*(20888656486624546752061106536387179909851561409879813169693571518296\
43674213545742697293742165899794100246306556076088996793284923018770876095241\
82154585605422944473702106886377381447923999718004555882924742636540971152069\
23133896649860635522569299597565110501826903248719696272011635912805327630284\
76784676837411562689986602429775319455800472767915758408476241750452137238768\
54324573417664023724085679962196990274351118989900693691494601918825884940284\
32229461469755758328057228434473265245613719242753634639769482536730558526685\
12706546860344153004922926370509792198896946163294379498404452798412055195342\
20615829553795406242176138241862355889670311857457554990159692850461941839167\
488*mem - 2041*(-562923635598721672990257457380951190935433088181815941794411\
70494917779821875303253861329188258807874824580490758562300001975819962784446\
92723428394027670318298389877859942322494906260896973680780788768408596899096\
34081239119339366224875969527548108972923775837467945705075686657398531305959\
39120831020827792001644299723746661688679691554828015392562630409307166971959\
32007385206448737198219058652942648816860528628353954940774995487342876346269\
65193929377176553331026929967091602532034228969248464286424291650121814057944\
66252935862670963994071881505720201065825644017219288560541572511486911808190\
3842083904242418426777736229280565323133660244226308086343579729920000*cM*
       mem + tailpot*(-159113930133774048540798534743762870933532770754366251\
04684054894349319824115267330612210254153312916047331982516970823749321875740\
51974311504015622216937846623015968282217934459255270926401869433054299120215\
85272691019648676428857962868772948095926607176965508742255783103045261730570\
81454218175606791483760068457172777014195832811411673810697373522713648493344\
39385804210246438548341781827362171531953224568158938973203519318226997580559\
74973071685703634411580282702648850560862091519157548767830738508374366269717\
82797323010437659378858385158852145248745478244845247194142449506397465376647\
65222393162760249516360607790780299035380572257963485430088018319592373975405\
5138 + 1036973738487004010545585731456286023184941624747094184017000655573802\
68913512077386394028244050342732455883960539463935159474795865054225449327411\
75483548668974962143046629765263908320351050094735247753316856258565993091572\
28545692888473224149707921154246928668971359550050945894586845521227594576954\
89765441976070984749542235082599535526041388734412439372471532912131384539362\
78855308956939313261459550845887385285857771670217001096882194252710299411731\
43470186471383261019267785415839492402366897227235873940297672076747057784310\
19561925706028139245337872604759727998630325552351132832500523975422438642269\
02176728133746484402379025349807791489319541731957106233135453452832671875*
         Pi^2 + 3782802601271959425083875680778764349663998601121025502608308\
38916493082065950259047275316933748289350436646601281680120659055428081350458\
96382380313423757804334376869448994470402978812329669589973219596183278778348\
68843121260178601536961840419721223081099703751352270995958319130778243044105\
86862453381937107293590476284097800175148179618284623604607602424636941399727\
41551126742346497318699624550462179997260949585076087858167213270472256712361\
16488559653964290324552583272875603036546941265819562196631094493680607068228\
77167436179470743789239608486020577575531254409542242256924514132221025194810\
2854096606307237176619092833153057457111648350275229820184871123968000*
         Log[2])) - 772070010919606918659619026446945803766422114488801305082\
35574222856238049660447871548892186178025856424119571321590912626513212871403\
62867451643821969788967864646319054539771409247975596485563313534119581007198\
66096730881049202452573693911629665101630852449535650998510275092934591839405\
30200778626735253363598621816209584361015747743460091891677700411654868399739\
68436550584968112920102746593370749330937440959810314029531851928228503387594\
99291375315025374111655241182245993910579759230712353772644332406386160211902\
62549229873724229978807383804091996799883165929024987571644638293334386311242\
26077925211173473071077479568472465390269964874282911744062997321964018688000*
     tailpot*Log[v]))/2372054901440904254888857429757433454828509543288437910\
13107669857538142083860940571285275125089211735128244891113069502126181073725\
13182499953909460969352488571324797789310317133334199193798529605909338104676\
95936468937802197493120005306948906085536148047565606148083215388326181229534\
03622246972062163473857741135966768877364266864616998280964198034311368956063\
73996280784585518038866379475413692086308718111826325097607620830464469242893\
86966874984571298003251914873200086679295270690560629460119176920336443522724\
87640134558338309316944601926690850303207140176089075456825559944801848097086\
005880862238778491318182221919493071081823047825007625482243407872000000000 + 
 (v^418*(45216938012255916556095142006703534334429155540661951631486816023668\
55604597321710370102930666814366531571810282099078957271681028925384364404415\
56912355190112725724888495093546657533342844548609963073097600573870420697116\
67929394783075713998163821170417348749748480713546115306724063168773478497837\
54137401976251904205229252642861371989217018031690763622518708697423898751853\
42153056330017542631184281523095450561520430457371242118051716558020714648715\
36957758874793102532751516844563923549575801106539030605181870360939420377175\
63881749203485019693385137086970445895641307469936214101575123148343346771326\
16976091818048831628282722006322079437775565888177149298308965911487663927459\
84*mem - 137*(-20928701243517510528652851715825571067013454645609900686081425\
19950620113900799736755071883754060935418735247059829264249432855308917615500\
08306059037090981808752789288078973944173943254058537575662517126845160749325\
45398258743018875856259478602941545309225659969465107627549083269424615417592\
19898980742103908846805743428011670788417038862592705824840350122340876382896\
31237221628130010629731689122896281572360006871342798284402058070282829232460\
43194844413562754817459344183548025863664647906868601234575431374359252238813\
80614347728343254303634161416409011178496557692129598292650435597545824418158\
755061986579760233459585344088433404793488686229654086634585456640000*cM*
       mem + tailpot*(-586953822350010303154858926877991482023554611459276857\
57201027529365212040257638908577482658047234622582927611205008267050253752911\
67229273666624259180925553593010085609433678937898593187362428403584703345432\
38544717580880124980248289197215498049748914509189980686322117916518250839768\
47359445299643174729921000052577633858708123854800599917753014456268088982685\
12123596951721636877316154537114330179913495576128030277577825733027066666944\
46728084040021261967254433479237065795958283489382964230874586903084248201695\
55702675547641850668670988064119625875474905865629433843365027376483014903220\
08989433965143123730818055529719797404780507907131911062641259570889602214093\
9897 + 3344112175838379275860450439249882345496390159599472469530557842667251\
44306697850783911141027591882383305670496248453793682083190554301259980318653\
52664934179553199498633762175734148025544135971216533072526681258861029749659\
84026047832801067648391057086235992305099923679514241383619119366250080885957\
18349391936216360271004017552767874374183128390960380027527427836737346472107\
36738585685638669157331851463538120696433254950495043046896586975851285067272\
88483743199674183646955750491775403604815895758515377696278536515823676849733\
47218081716650546108420455747947228129819159897596251498279239283658368254498\
28116136612578571811859594986169444893579693057684345434477593613613281250*
         Pi^2 + 1403696448406865428460208703384829019825038209707289900024757\
38482456340939070910060943827552773056980638125441933965424646573459797597805\
43986381421657405121480013534653009887778595574445147761047167269414543967633\
34985438399132667184056341442568252082298594405459098084164957261683827516078\
92824135850783784447910099409910260468075519924234966258102551843057194623781\
28950676826260385663259659923009870471263640080645724803050745739436613086567\
35050078348963305182678567343827795343311527035549673402357829107238744035721\
45225202391467646544263569689795139451142501580701537455755378179625015244317\
42247753466391073859621670515146500224835738937489151133776071516672000*
         Log[2])) - 192306413431740563699048592363721575716030234729898716303\
39176172096518708652714678349304374729908806347423185544953263176580563992270\
89934526134254767064501642761854247462354625667593698985243263461915909792523\
56576893005060681175404215718777631850535274907433547896437530599144850684369\
70281316906611557378469363683619157705684126346229620190377360049602498835663\
45803666242725197672835866573409452352254563118691048464298017952166302815992\
85972701860733807972810026963726104407962033679203870305256123022587691707932\
89383895852727631067576564109047501934104806522716556110631438486810608627088\
47148687942224895577118768168860575070530802496234436013705327321797784064000*
     tailpot*Log[v]))/5930137253602260637222143574393583637071273858221094775\
32769174643845355209652351428213187812723029337820612227782673755315452684312\
82956249884773652423381221428311994473275792833335497984496324014773345261692\
39841172344505493732800013267372265213840370118914015370208038470815453073835\
09055617430155408684644352839916922193410667161542495702410495085778422390159\
34990701961463795097165948688534230215771795279565812744019052076161173107234\
67417187461428245008129787183000216698238176726401573650297942300841108806812\
19100336395845773292361504816727125758017850440222688642063899862004620242715\
01470215559694622829545555479873267770455761956251906370560851968000000000 + 
 (v^416*((1359468740019080454459669362655722928442119014378566237727253013553\
91834800448577484159384946186615229746543341682846856453831037161327877251803\
34751361582696126174157907477344248678436587271392934363294032509420303710902\
75149868880670386721233136777792071300373139189455880132996880446373011741635\
63037339185062319128666316111801113474103534179977509592261707620551554971780\
83229073757524172275584621229552193501953109346102495322928048834800598635963\
54225538146435398529669446367981078293415868900290073295042699146763953296540\
57821496229060236396226441433676520265139133484715132323147328462547178016714\
691466175523319657651383069668781363531448579332940992610610076832849985536*
      mem)/3 - 3*(-1104353456490917137087601111740008508145374795325323799140\
42440943296391143094107088272664834410761788441762949018552493638878695689575\
27194742755496914926279139635945475466542130316523869826646248053161875716398\
81147200416317783505291762339244995683170098419290128681102262178975006722113\
52212532717043748322604133441399839787736876142834752302933622067804240444966\
27684116231539092956139669790525912712137670179625102416441496052441151354046\
94411882132035455214097081028512072204961405490062679449324917909629275534762\
70604473689046346415774886597400714778548862798701225118244239071717447286383\
956067238819579897483491986012172303855715683519272968095719751680000*cM*
       mem - 3072961196498440266662675117573098216663009087156133193363832272\
27249406464387788738587189125442949725406862263518101655099271769845026048320\
34980772515029927130346067170628588210596855514252529106670703330041436416840\
24355849548503341972980438449010515710469447399496202371584378258267977027013\
70261300783461872999454583733725152433505230415185297186575336814400536917417\
71828167157955193665342547612605683562691615343750143526782394248020282475552\
11377896543286539788322957904412470169079273983835366032432256248387797698152\
81446707479248745669665519892353244906183415788952634314736123008554966887507\
2712186441087742436543021537170738772362963233094455091180007298577*tailpot + 
      15304775765723048009037479358712256549699072390055535973394897183624209\
25098501372278948556602399535116085554307131309769951528123918115475395223738\
91341676115819006030780336491329899505497591997802765871665052170338525339159\
95426067202636026253210057616036061900928220344442135055821943288755379751835\
47325997168627486489753409555551438323182096831707831866057842132898366292407\
16895996548179078406333071720871098690738945742907083315722387547958666214757\
86757888137249250353854193266114492893659356273693711007949506900470681135868\
83072448246127549153325177571317622565273813051392466269308278318978327494423\
597368286267737462871139283266370988945666754211262361936013909765625*Pi^2*
       tailpot + 739267796855477835756491709192283654847825017192229969843727\
12774271792685810454716026833410026589382849241573243996990770460629533288218\
83370068081444236319029882543042469730187048533977607468106116145745041914458\
10712257342528645217880116499648935910108512307271915482380856654709781454376\
50894486479401106147028472251366370184402071315867175857209036254846706425282\
82834889720899058906326620764673101669282633918491626906057143283613487030928\
78771684193481782685466929606499396971596919972019690045384838835067102598544\
45509011481399494122961939263347112466851183424110240265170912906340837735261\
8030276014845652066206747719579566518147779390502119980810729984000*tailpot*
       Log[2]) - 221780339056643350726947512757685096454347505157668990953118\
13832281537805743136414808050023007976814854772471973199097231138188859986465\
65011020424433270895708964762912740919056114560193282240431834843723512574337\
43213677202758593565364034949894680773032553692181574644714256996412934436312\
95268345943820331844108541675409911055320621394760152757162710876454011927584\
84850466916269717671897986229401930500784790175547488071817142985084046109278\
63631505258044534805640078881949819091479075991605907013615451650520130779563\
33652703444419848236888581779004133740055355027233072079551273871902251320578\
54090828044536956198620243158738699554443338171506359942432189952000*tailpot*
     Log[v]))/686444283961682784100575485638665902343264419420609841893163930\
95878345349841456041752115752052690537453826662103905783977100457500802132963\
24630121869791735706351256230324599930701464764634505703811743280605955190200\
09967159521421660724647556085001408754672345081353692182682031211521242302993\
23313030874767257115463150740302105721727078813371404653102288525667485045239\
40662003479273560663663308632997156505624060964104199607840004665772419952016\
52686706788363567110587922645219330278136801087438932447671828053369193256027\
83200420109499972776310826556793887481331310932623973814088406912289385096997\
726214182825567959281800581288466338334250006216704000000000 + 
 (v^414*(10007508024025261490960499173760399713346546591198495323117007631271\
49825231791816105165774759390081788121717893139123850711976932381871634287364\
25872693785956946866092654156311700013844300308257506142115598547988658070724\
44316395966654975860005009938757609178571633793940183328093917926024059604859\
02239231775297829543895254040308200950009184042426311041029312566068440844715\
47469589443538197837854237595437725419908046601709297795065004568547590688276\
90707796339113320069041631900293323350815026768734736592518428993287346315327\
59770444760919355886673856089263279622960537305080235836790431988690165383671\
388287221320748209151092344238494173541043420393530934692130341257216*mem + 
    8436596169051774719589852708243979181951758640517691146069349457282050401\
68169211616952260811755169871430922068920725864852548096300489206433500631212\
88731202078118123351053421722641794801891572893191784833296597709413167127142\
76348494649708018090644887942165680119131290897210051477266964100814506465095\
69284701957866118278478099053622879547237244913884779102712322313956650209775\
00206823941721093157245112215278808042475461739115249542863909997027075239349\
61286104242565808344116726620902073475264440141876561945631854577550776869137\
39040878146160454952892393386990925087092199408975960372887098740122770889179\
5037447753617548798947911958441536998678200320000*cM*mem + 
    2329098250197594645265432662611189967910875133425776685576843103188052323\
31037421187733062299237143525573174069420081863486000728266186376824041542249\
10149977926185286139865979601162618378669875567351644332756134743400153606476\
82083363000901861881725218300619959188462137206321997857932130552074244980687\
24879964278205835762236060149277372320945434325047980617664702009196588306070\
85784692225745655820782579288542855521001084377775214095438158736560077155020\
29697426701002543175075792954093600343254855273099995694126671192095099046653\
02302139657652501849663358194286896331742620485244874551584777667661550787347\
935439161782806198054204044740042233423154392801371803*tailpot - 
    1013972558540373470063740260990498083773599907397471279622348093760633655\
55943557572167607619538658508144662707621338262908712716571666619234319415591\
05108454673114894328558178081906797343391985675238036075748595379199721038339\
65706439899318538212843077564791703756878582055006011467524411897223150049247\
88828781845725095962828520040348852143922638822203548930368089111883521988370\
37227302682204572214881993542389327255208132073915051581302198565068139593243\
15425336374455679871389981104424937441191100120610147151523850219623197387233\
76305645929620655321421123189622795279341132371497574113038191362122536652004\
932895820804897708226564018685005318525575095402851183661718750*Pi^2*
     tailpot - 56366326480579983303806065857530870240676319293013986311715624\
86407486470293242718678094089640226539887468085993684509219413437571034320804\
84778780927876993144110593089769044000903090875900984555606072025303184125019\
42648967701427254207519506807062338536856485417219092623619445279939912463613\
63519463015528804458380732175628580143570797066361972101395437887916211631921\
68678511700146829228074157996920852972859356044458879812981895942369005325529\
21924457422974250093622792981941697261202793009409290095889121576261294265206\
35336632752242550110819142278115567518236684043625858083375562470617273265946\
3091661041609137273152742206903870384261183317846611554816000*tailpot*
     Log[2] - 563663264805799833038060658575308702406763192930139863117156248\
64074864702932427186780940896402265398874680859936845092194134375710343208048\
47787809278769931441105930897690440009030908759009845556060720253031841250194\
26489677014272542075195068070623385368564854172190926236194452799399124636136\
35194630155288044583807321756285801435707970663619721013954378879162116319216\
86785117001468292280741579969208529728593560444588798129818959423690053255292\
19244574229742500936227929819416972612027930094092900958891215762612942652063\
53366327522425501108191422781155675182366840436258580833755624706172732659463\
091661041609137273152742206903870384261183317846611554816000*tailpot*Log[v]))/
  175114330456951146460727650688155633566215788490453136838600994864739910132\
30605172811893541586806468207995509014652919115014941057126718311022644997088\
45447575019169781940980373367002729088899351308842156856149884971028663551293\
60000524998101031327067579522874441810419266666428973624883948518390075135877\
44412214331383870167034719458265333713417929747917979438867720541348295067237\
75702979409457471328477161169183177822374176456783825077006660132674839528879\
20909528832116503125697212093923712349570916758214402585126313194816524974910\
71371010799308358073032934766687974240663618467101916978113987975542262927948\
29085293953495290778850914711109632000000000 + 
 (v^412*(23325984829111980375004212104586726538311096627793780079680744419873\
07020976451882655505988624530689928043302185090347050382348064920390837470917\
75910283866313652566927189798296416340339768935239212348346961117806407740667\
10266388933623144990728291161757268721926275075985433359320704003732619719294\
30550121126198039575389341742532177123234957780831870562746834240830684874000\
83290168692696470059222386056963883743910345986954119507153005023736112656618\
49907659414332804935510346034432867732477075831805766511858947725729578456838\
63888790733818744154593334671780035694843915542776247952253832384921569950355\
0752846396457991401981524920532824700200433261053498604990234624*mem + 
    2267680064946953598700824292070241314602221063952048379968430831502361604\
26692995316556842441441202987349831154699594322368651228495352647045569212523\
14862633196684577858278891819491122389578475217084535119358432095895835005681\
30003963252854125367946041366053648561573849089903222712289223966030537960066\
63906066161306628286775708822773804594226088769278246170233248426979894896865\
41242041484864809396988179487682948575864585789156662917310108279930937913426\
34206664126667640683331449546404096057180994911005793566257299969726129443169\
93440551410232855517895665433078777085954559092200002303837903166187285175797\
989398268271760267285337746967236161044480000*cM*mem + 
    6210949378801748241092120586272548262037494417958029630894343733857178761\
60207323549977550092938015413135504720592888322246317864671988454829888017698\
27582302446676060412287885799261040978603072921325204572042852315016865442931\
80637703853783243499726542844739210308030227671436390647456608108218303670014\
45664131466846415173457092821188753374251653724768978173169104564013095170293\
94418349950868379025035598793599068855221644658683174654162818773742660489485\
45314839627540485742377771737761144145128348177907011141418146541619212481372\
06883912205434893039340161236727992433084448046873858844529926057800031393046\
4188398958204336322924678617306202217402136399894*tailpot - 
    2363416393138017527691770294150314476322540219614218009576562194870832916\
55314569736222857616388230746091751157764589497068927797047006546118918660722\
88078202596311342330216589413547657249262586502320363280957690626882997460215\
71000226304257363908192989954768429101381820892770301059267104317119602196918\
79403081170861942244196802098117044093379516395378347445779173873812759544747\
65623162080047356422524684847911998270946766307906981283842426799674385405288\
68532991676434153172755586898619387692481079562592080790399534279131296063784\
07288797542729394834056626818266616683339125572618116758317088292852034203346\
8344600845216535187445441741089568825269134651371235546875*Pi^2*tailpot - 
    1512129538010255766937482810810402888852953895740862637408341505668420137\
54435620060685028067918516143314583808827942342926510058174360905290566744442\
46078081616802766434255299293955657126128684402262286721631363400421488916464\
33605248598270313836353622300476765659724029502719297906230438582144828041069\
46991969317360405330332906090386137767974804711423654894219891060653015042163\
57850180703948775190051814900238121494975547826925754965448828212052223585378\
72905541139970752023108014114826936699938736793452385799585523152920426518441\
26103957916565713288697923034228858613557039302262181155684993884703182742230\
7207757034666038159314484008471009450225664000*tailpot*Log[2] - 
    1512129538010255766937482810810402888852953895740862637408341505668420137\
54435620060685028067918516143314583808827942342926510058174360905290566744442\
46078081616802766434255299293955657126128684402262286721631363400421488916464\
33605248598270313836353622300476765659724029502719297906230438582144828041069\
46991969317360405330332906090386137767974804711423654894219891060653015042163\
57850180703948775190051814900238121494975547826925754965448828212052223585378\
72905541139970752023108014114826936699938736793452385799585523152920426518441\
26103957916565713288697923034228858613557039302262181155684993884703182742230\
7207757034666038159314484008471009450225664000*tailpot*Log[v]))/4715406944883\
57612961783423244315024143858522627482241953386768409976571935472279156097791\
49846275049171468470807431655392786223290014065826539585675752220114520723226\
68620375837444238892041492252630117089703859972909362384066034728102164643676\
54467185756570986002528070746810093948785536627453870405668636363913730089588\
84853890848262609388453866045897431619416562266549926247637106415507753416532\
91010871102190840137787786403647256032696206688036896744177787993810973716140\
05661631731158417923945408905153384323198742616270714966428849307605492642898\
77406848360898739719410627150788119040156713724501740797231137581024531199738\
270622519656448000000000 + 
 (v^410*(12045841785152605850743861369634239408285327159684708645381111306541\
39986946946106626573655496796297420156549390283229421791540158633971361461178\
12442108862771927922538262923624366450554025497239491529907987843867857112794\
50103755387234337529213701963180668962477458636230596746938223153656044448154\
94014035408540315118902034174449055509167384515732465700218573417149414168641\
71333709139724140017556782813062439546356860995810450042429771986440376867051\
81349262177389688704790501499572533392708053532700717701635615599991577302931\
46062781323432590383693729598349535424945663463027139502816660189519978763625\
0318597004479309393139404122684391923452416934601935032418304*mem - 
    169*(-7991596681698277035167711500748227075722149750944359515558972501412\
32648469729770354321834003831486717925047242416988895313816018470618512010714\
17428500689367075559410312756628269119499130397832587852232527611880906302502\
39106309942872823199890579658410819168808972705978977524948352705542141736107\
32335638688140682456766174312880387266716121959162042241851516664641675203566\
44278225517792814546164370615235875329405583634601204533089942653101346418407\
39278441782123409392969033095729476488514984323047499688418101583711583001579\
12395995880957571255580095418062815479535098192723962088868135114488975489864\
294325102053362447010016482083293018193920000*cM*mem + 
      tailpot*(-2171447673871187579754958248817125859216374083466828366468054\
60341282691832885106688052543697186855920420102945184565597568453864062133122\
32907920919387918965906130720647587267413698195598013054846778373664690204967\
20662730172636897015516337808280021636535664091185554465145648745458051764397\
82014025127651501537112720076777085935085940102119274539286265603661389711233\
14200120578458482648426831310643285152417809838739175407554878912894593776631\
09199763410888158713557994160435974735136001073641684328048748582863689049394\
26737865912719198301717786236637106419133328630741896917022259692622471042508\
92482394822713639669161827964150219239534415769882160581 + 
        722188726634167422045964532828915432225183865519931071558599190440878\
45661641284558826571228577854761719370872433497228304077913378310702720558835\
09478143083090361077420801254797048853489984694434406620489499135514405531767\
29904279782738063499867275273209430673865069336345774641538890743213831121200\
48435073821493486339823374278147380952607292667018737712205384645009735268962\
87796865970094220390462934068821062266643171207494720481256403293702771720431\
98155866245313285101439687719644790833539914940595128757997150169747029626807\
37026081996650051863035058657363765487640131106044393162816333614976332521084\
85677812377635126528472096232643358595415123778704375000*Pi^2 + 
        531852794950862389064368025126136542264462320239312899666991151705911\
38854556469062813488947934545757748061121125066650273387157851590340166824390\
24532416593388992877926419129979440223131341085213260096607583737799098707605\
06765572263526463472084381816422901636525293196451317520405000689459375621637\
52511900746146931853662461302804266612922600476808028661679750716924971960710\
03568369719379739761156735056536631842802088007511767150612684599872807040475\
10494312703141353330636231845450450439449824844934231913906831583608121354466\
13735276389137854477732389119381961742232027226762308067536846462047432463126\
91136614703311668005552841450571373377536000*Log[2])) - 
    8988312234669574375187819624631707564269413212044388004372150463829902466\
42004327161547963220093823305942232947013626389620242967691876748819332195145\
97840428273979636956483296652539770919664340104095632668165168804768158525643\
38171253597232678226052697547037657277455020027266094844511651863448005674174\
51122609883148326895596017392105758391948058055684382387787116032026135999603\
05448257517601963548822455469078143355287326948864845354369737850438984029273\
53884683088871287752318188112612426702039879388519345025453762977250890477721\
26170976429740673677376117555153443721260132283006341372705208601608626844802\
087884859671892938430205146562100803584000*tailpot*Log[v]))/28134886305987924\
40106106343939827113030182115915765166786317233949740882669882333866931930181\
75865448517114980951262860338819948031110177962646692576087232186877823548247\
03913111242475489507710337888526788209188382514095370322402912304084986136901\
38339836342398583103047415334689431894609949008773303512150142683353756496709\
65935848822251721085119605593267418953235480608151835543594364604733988859845\
51736886580191752910420069494367736850875226950457900822124068084568712052843\
77277632210130811130124732418760878274120622140304095637525701703416723739702\
07925781018733409371283715919564678739342031633298312834949767449470165502808\
01026048000000000 + 
 (v^408*(78185079607172672016575385437318039059532343420770595214883426170020\
33221583767634632944512667937482366698533374169316967085622916549915202282019\
47120168571280185329490566644292752091432847959704097764073123992082795051384\
21517991423880909569358513136292390165657807770064679339462671929041953316459\
15409490999284072688639233955224470770600938175899584841247570970984742586916\
41939294254365926974099434202783924973007615627014347189112024835973421103813\
71556384299433824379301247941523785995247614059437743707584684318409626449242\
86897394409296731206842436353768130702888501585683275077332345882664621036525\
263861287462763581816854092739140580522257572702959223963648*mem + 
    1011089116998917883384264625420139372125880790309144828419352375515117740\
04568984544856219396040879033741753921852322966378169061103855061638430834600\
81406247329532842412914430465721723836412019068738308433721576317248814298592\
29307589591608824192501895509798291372663338312203892654019661127609683606231\
89722790986931377969140960785160025750625666286137452149137495920194861921674\
33148603184593235319920351260516128741825103541952537009073163487216786698374\
95102939585004106569605602666592355239534599972250713388279920378206374873711\
46356777942682493113991121328274727004965993024134598302956494355009608221070\
295930319477410609126800112563372687360000*cM*mem + 
    2725389892426046630909179208338848333091590310102426497577671289817269833\
32326206699877758946283383831474679379014610419095681422882391097066541046812\
56087161619051350703979976211073190252642262162327131163652585192204835919234\
26361131883889852234217977469383274345164897268364893826549830832806322303696\
93020823274488805085424508698601025069923498027125526549385612534100167438603\
47846534611673472074570244543943762715585624260562790022286904758025139302939\
17735472214804266392671408641532806828763582774917302980818198619573687395111\
02331611761102266793431008256376139736646720743306269915479149065355795068237\
2030780163242076350301245096291677286386021723*tailpot - 
    7921804811729990749702154981360513010465964283666766541192976010952634975\
39005827990232510137766553508128047390545478000120073413018312528626235163646\
33467201682427514144887920787311782998738194677125994038690820774067265752632\
11587800938657280112815004506981117721672660912372532157994071764883013903747\
75662262600282624711843905676944527795646745216732008501259862815568688844859\
64320174988345579490458454186746006490825079775874908405553856903402759054576\
94774919316837094589284656672659110183729575040102245267050936722052233388319\
30327091832768718385633676617920970421648332460476024556383323114536778923978\
929540228123788953464603545379404947538279968642187500*Pi^2*tailpot - 
    6715740190338332658172928959327250100160949957589754412256245445784932469\
06750338844097227486080042604073762170401926297967189511136080654639520893104\
85217969246801064207243018449063889200731195366425131938708243840147044975519\
56313844408539317779604086485891657416091643918081078689637960652229743795803\
85170144784480389962758734666130891125755934921127365712981802153923985282570\
34875768120384773736161388292894545291545680028429631040090019021948866443364\
65583010828292639775542852082898850128259203370345977622136596816698823950651\
49964382599560596676463932966430984924326248640468759405935120673224090944840\
585368823827751591014895166727537297408000*tailpot*Log[2] - 
    6715740190338332658172928959327250100160949957589754412256245445784932469\
06750338844097227486080042604073762170401926297967189511136080654639520893104\
85217969246801064207243018449063889200731195366425131938708243840147044975519\
56313844408539317779604086485891657416091643918081078689637960652229743795803\
85170144784480389962758734666130891125755934921127365712981802153923985282570\
34875768120384773736161388292894545291545680028429631040090019021948866443364\
65583010828292639775542852082898850128259203370345977622136596816698823950651\
49964382599560596676463932966430984924326248640468759405935120673224090944840\
585368823827751591014895166727537297408000*tailpot*Log[v]))/21101164729490943\
30079579757954870334772636586936823875089737925462305662002411750400198947636\
31899086387836235713447145254114961023332633471985019432065424140158367661185\
27934833431856617130782753416395091156891286885571527741802184228063739602676\
03754877256798937327285561501017073920957461756579977634112607012515317372532\
24451886616688790813839704194950564214926610456113876657695773453550491644884\
13802664935143814682815052120775802638156420212843425616593051063426534039632\
82958224157598108347593549314070658705590466605228071728144276277562542804776\
55944335764050057028462786939673509054506523724973734626212325587102624127106\
00769536000000000 + 
 (v^406*(33827763661050073169241702013528348845599286881047641106227523286978\
20024946960619275973295176441976450991178796353333093248053026045744945025447\
15833724696017801557903855433467531749495390399714620364329310694045235141957\
56423832152533717174672915630055536741061919346928645618704481742142252125885\
07531130731016536461134252109803678328382782285854809927690208842942825715931\
90801450305155107471747496635806144909163896034991982746139834367865650978060\
35571724041725492639661856767522954058086547420490308070998023699641435925632\
38717140315695176616054493252343414677994876933363173213097572652012067503149\
612515741468279159014186764900989607720810442608750240989184*mem - 
    109*(-4629522695491626306816072086418684985697850752310550921113331671933\
22604423901491292050040000492426796552241079263786564815056542761210997836729\
15448227636892609284444722587114354480491795136804787191255061743578957658277\
34794433339566289969677577518011743735278593375337334930445131435896044300318\
76630553753703498877209536560508244092206783979469545346242445272556428909300\
04867799086299940599740663437616331950352875698913341241345260692779906989754\
01942559630445812190122662794645984177544754464154327468958720465325417563892\
87226548957802308074317438153008503555332869168700146137258576840368412825530\
583497775652701583457258869424890860011520000*cM*mem + 
      tailpot*(-1237891138675855957606954051610233309180193997956651322189306\
59231009660196334907959935755168876992737699627409325610083809736082730978222\
76213363030056772229252136695038384822233123610983676404410692338017526930080\
18419601921412344181709742979910828215531446970149424049086412272315204261257\
02339105233778010407983024224328547760212592670298309524225316077052988079361\
04537456631225941795651957121988694616841987969324309998008903318833132459327\
07979669102302777258888507499964314891390019114802484883483460810591944162300\
82759211509390316777727136560283358931491956667750039638387618068153490707893\
64206653519886838989433684577446688198343345371093384541 + 
        314446702337404624537291249570072091359658730403224719111619682575076\
94384105005086377356148695515844414556229450324716552517834808106645392204602\
16063136843144648581988078458255625227808698865324700095098463352105588169872\
12923485125962087706385436765739128390118503586639469486280828615840913610036\
44193043602163374986495947565123355498864925094821786077154373136172203932397\
34917657560977767120227084663098744648260888519075786839794688762595448566787\
76324439430119948135572709298240160427110678399830163798569812805654276267786\
21295151828169846239232813978834750905343328099398939971895660304094682753782\
66012813101723681093456822227940539186241986627634375000*Pi^2 + 
        306890242319230487372607921075427058958170384916086888607560199606964\
05513272862271373359990834963789212199055826432361300796494909179220224883565\
24112278670509434355077630700781667441833444735838828990928066978385717370928\
42981900579993074579811385399221652286257749101946092942622724577595311420762\
47761331696472851832514241913951302599337041285041412449725475865487631494967\
20849583823850182279892264698791223885408759900214605993916020922244327692777\
81523035418865108150356851733454886348318361407380004963924499158178090229881\
22435434879154477766363825234779741700080078477552568982331126752798320425234\
84396780262258022589646888965523607750656000*Log[2])) - 
    3345103641279612312361426339722154942644057195585347085822406175715908200\
94674198757969623900101105302412969708508112738178681794510053500451230861128\
23837508552834470346174638520175115984547620643236001115930064404319343119885\
02716321924512919944100851516009920209465211212413074587697895788894486311005\
98515491554084974405236862069198332773750006951395702007686933815183295142572\
60463679966986850825685216824340350955482912339205333684628052463171851278186\
01086065629678838889683894658261196670139340442054106777040824141183505705345\
46240182783807653365695059099184530872855405323001907409281605501692635059799\
249048586124462271510897242073244821504000*tailpot*Log[v]))/10550582364745471\
65039789878977435167386318293468411937544868962731152831001205875200099473818\
15949543193918117856723572627057480511666316735992509716032712070079183830592\
63967416715928308565391376708197545578445643442785763870901092114031869801338\
01877438628399468663642780750508536960478730878289988817056303506257658686266\
12225943308344395406919852097475282107463305228056938328847886726775245822442\
06901332467571907341407526060387901319078210106421712808296525531713267019816\
41479112078799054173796774657035329352795233302614035864072138138781271402388\
27972167882025028514231393469836754527253261862486867313106162793551312063553\
00384768000000000 + 
 (v^404*(14908766976834853854242268201272864835832733152216390054336044231644\
70452680885389206731215118508602644725371826033361346771757736997727763523644\
70730120847487257258086297496433201199896319024057717690430378101729492045991\
64714264290550290919655165169026634039143122515220326230267172241287251762598\
58189148119494239259813962486862630165464266256358997415514738488640715439055\
58810926984623946164427184263476720097629090158073239995302332393518736406413\
44120072200270265895840246433900089948537875045933824127975797104986041366121\
57763126838018909415165618999505694774807698213109212987390630892149570637071\
53244441582222187689344874884628335106587739198064689152*mem - 
    29*(-88470557084760763836547007053961353452259129019547831431771103509834\
33934955701716262836051220329757678993961769906890950355986404715934614924151\
09221609923239977737382005791507586154236226341688694988810080024721127145685\
56965502778441087435906715769519109223937398291997430062090440682327825876566\
19118025180040241760918566798280497577691235980323388529846120678795836708083\
40319473518871873121333366811687602194198334789621472373025305642834035475457\
81503364995354095799076374562220708320539296823097954004580818273098808970532\
84572562277965709155108256598586546503903621410536541069201763691867859875538\
6985205941445378875531777867838914560000*cM*mem + 
      tailpot*(-2346580786780198067028709340327961879758880934894089990875920\
49118372534556517296735834742858626619137016085181940206606261119742265444666\
58173930864342765266788839878747815541986176052770746319769893337874594407649\
34639070616551358973671534887195619458929796124253402433892370832825567591536\
04788651703595763334661261244193139929495693153579493650257706975987675509273\
01645510980031833508427773940347146444034522870150114056835751350893566808985\
12485612994685085938244090719782750839370513020562289801394541703367908200451\
54047592168809276893959357218128011501075290305307455848720131435725549996486\
9695975279794277889632564472589735281615719566342598 + 5208875577345055316232\
41706489421086182510884408406774482650171426386435677720213393625085034565391\
26080934483552670343157006488047671664221242981848450649036084921905081870996\
10002573727272046852974001950573165317314321610721716276113594433124732098200\
61582504633950828067182987530081591272371886111814978470325544354418549554841\
30931789983437365437009857683428180531230413456593166780878269655962452808436\
94758289395857654909702991399671329111714734407478362051003889754440355865088\
28958667652818554684219384620606283735346555001323957044687323456275692124032\
15365319504912861046828398111729831250360634361899595467664637582417153653040\
1478055247900317578125*Pi^2 + 58530717178092688821668877310320556791722015997\
79486414842719344716321150989866859194565492908283977909972865950634645925087\
59691658749603777148029488105564337640512467716840583006795409831048913324980\
06492760286738397919682889267394940958449519268688193253151957944693021580824\
71545080111840028320023186896132857689157344655222833755854091157810693668994\
70055941180464494164854995903008857773984303545385724318201807995136251018395\
41656463444929053681866300091648636598600349233959133305675323436865431937355\
93299835969451484512886510005903302267719885186811822139875712118171405423306\
92876073391241163506917488013451965533771390710914478332928000*Log[2])) - 
    1697390798164687975828397441999296146959938463936051060304388609967733133\
78706138916642399294340235359389213112568404731827540310581037385095372928551\
55061365791574861563788376907197066885100418486424421882900483154135396708037\
88754453287795036058791957604341406780396097625843916748073232433608212806724\
19987852872985562995001462178919768643576510116400846316222942334703307807948\
81187256875445544802816186005227852431858951279533467080374399029425567741227\
02657810461359410127784814865864584379669097526183322056952431140930508737087\
90171195765763876670417542842056395651426970757275900934061283459937417006071\
52390107000479370330616519871654912000*tailpot*Log[v]))/537417602116211881132\
73730591760145038015397996557250282440350587365160503321407660966762113801930\
28891295747649588609037645552185802073998369626615527338634376486543938092892\
93842498385725620995146098081987492137502179388950229273233192332406343623613\
20223532980270152953379712130040774181483205480277967415622771885629903531084\
93444801568633196813982145236456166631276897765807296652746881379677182256979\
08133026278898808451816441926513807977287409418949077858879977244652598635635\
24453891557364190952254331465431580849292105441924616551453686902577546265266\
99667992309928394019634771635825552835261944115083185929237650331706578698240\
00000000 + (v^402*(2365189238240193162398757045706582966142646201418214741297\
72953676421601056578255940915409502299005038677882537300933195708914872937218\
67009594177532476502613503240748428583130981383963467963378508374851513801673\
43670899320486143910167132526208354712737386352535787618225531406420575901446\
44940147259945583856950385202421387154983839468596555385679929415273233459862\
57404276262663183988929897465116030440274217378309767491009331621805326567028\
98695228660051063729452562260709217262409100528798996275796590371553861864196\
70500152062458114836790525386580078124795464962079230945402351473246211123704\
102843979414494374041054229758425819286962667004624786209898496*mem + 
    4696005187022648515219839200815759487617769296958206129469299177570767040\
76570091973824021835923966465522421720235797850394636844018500048341982375092\
60473029506680314066293480639681881389941207971438839772332289343881932230810\
37719867296917670853180074002642364968430382291881382368883442830183658903316\
27521466090726016612613827427719197403981626700126765617222451964994367666694\
53163356614612865031813377373163995141440964187914589680623349488837111952346\
13056218964280754456878921291424028727099930543968022426136716384736758440311\
05036384254850675891735439844158521273273481761586975619182114600944925767391\
0309417891867714981356655083520000*cM*mem + 123548975907820765373898666401814\
25443942921244641210315723406763396406988879480952074621908357332009614556209\
40208994759392783389020431842794956326628151944676486325244998673316682988249\
89138064951611649761386033202213045160846004873196282740350367249315395632394\
37769816829248952006861693194775560134418486011923777351843700160855026060781\
38077319537622268355385111057590414426854611426524144983904692404944540979769\
13880180898908958225316449092444779389804106526947095141974760261360695868709\
63943124723985652923305700298025952319658080024738572453849525790906378164943\
70126367740215756481675158155945779729950117654712906478552813400633410184679\
01*tailpot - 2396437732817716065415169011786880404404545191984559782825147233\
22451883607797614620590051818599830458124801101335324021600983459186139825906\
50431473379446634158151413381355017496606793443378483865867024129376417020929\
89688709292570818804861295697473052381336764430378514539947363158868508026002\
76893767867743085092454979110623386168695251412391754327374147695175548371135\
99033508648457657603028095211919006423538095477781297253424285836033531898235\
55534830045735226944532672206868168265628310952417406393046873689273394812787\
54487671395199639124328324216456783853989591409027357451220756979095664372235\
46008669599420899229951872381360246401427375099367968750*Pi^2*tailpot - 
    3100613548173799172708996234289261457664377139494329117608581296161658764\
84006867210951947799964712266849097432337029057612366722976176284835987964411\
01133702218264040803820940857492551179612578471017752368270320020166375060175\
36318007483934046681003072295608451764904801070735950138329106720279564582679\
28216314805839139571754880257196096246131155646971852540554882669820356391206\
71848785570174672785627259486109571241305180699337996186504046749767081883958\
68463616707547144387088792963857424825424453299711046785036845757507890477655\
12067241821672549649366421643247036220344827468214493419684981646008395913827\
38721629286738954954302790565376000*tailpot*Log[2] - 
    3100613548173799172708996234289261457664377139494329117608581296161658764\
84006867210951947799964712266849097432337029057612366722976176284835987964411\
01133702218264040803820940857492551179612578471017752368270320020166375060175\
36318007483934046681003072295608451764904801070735950138329106720279564582679\
28216314805839139571754880257196096246131155646971852540554882669820356391206\
71848785570174672785627259486109571241305180699337996186504046749767081883958\
68463616707547144387088792963857424825424453299711046785036845757507890477655\
12067241821672549649366421643247036220344827468214493419684981646008395913827\
38721629286738954954302790565376000*tailpot*Log[v]))/985484600457601249020911\
93016675082588047795837207671667066657556293081607557593510330248374942414955\
21935967572595248846538298629221407087474865431896097740299180704042957627637\
69862565511529942199446360612760643341404747463745611063311122994517647212473\
53666834236221797151061363155453878025437922270111397841268738930140949422251\
43279160085324231018603734332823895984531355392353275208217688894588490792936\
42468726587057063233084217323608760306985487070436171540300570878848353854360\
40143442599372161835571146879426985254472081768856756944413635533397796944370\
43995678352800769501414980120206910627036885849362950924786671833579520000000\
00 + (v^400*(1250609359216900449144389469002533003337829332048044266818276425\
39383168621227029402423339673302350556182137822913586598728385540174973186576\
44677412028108711303837433352557793456049321690473158746743105388250984372532\
44214811934377623509247120049339589919237533713240503205592647507781283766456\
63114223612898347167947832342638775094781156848363938072280156423478610175891\
90794704908257825722719256232678627973728782667901257392209739502537945575335\
30801495614427652164976389453262332079083247578878222997052070914584151979920\
09060979787084738345841033370694788254142882572561658819999283818892624375616\
598790985814435871457681720282713354076783824940826624*mem + 
    2865064026524650309873306838963034867264070814004514987440218013873587596\
44852229679732533157637978034775811693009564229010909991823411300170175065068\
30659401105655680652955789146117453795233838400783892794025824134158878155407\
24639469606999473166817260024584577069106200259777181069899050555348987238587\
13944931388979822835396318459424724916619835969028815103705964843429675274159\
80342266541183093109260137027620975579863412501945501562469531911123643198234\
58160807685285900668170084615431876765262879080994615186162771400628950359925\
48064424532443948806199019077393606703157699893777453100104743329646346272581\
1234527673476707372048056320000*cM*mem + 747656145760718232463078900962167899\
68628172684983732062734097204769064180190793922396859999702940831356558668085\
15896249817837241096532295500823969798329863229664114940255417069252520394053\
42057935693651217910711647493531005756766937452565936988945400687025917441597\
64179219149826486809136056288084904900464706977856853369976699494690669044077\
02161526992357867807390209137880320521589461602691259950429239502437765618605\
02575758762211256793210797979020000186593286597409753422780258027899010172171\
25943666964357615278476503004046170295432991153640154148899747248457826300845\
300641900534687296251992029613571239627802250839842435408248632658431047*
     tailpot - 12671322062577994792673710494090391650424039916191069206465182\
72306982523239894055515425248893054618625216152331084002064086394500398494227\
22335549703433284991589001876021185678718231962613207246333275762576353789922\
60057709472987427876466278459778286002860980326006999967435751494363303406476\
88866890650550985806337897187939113852067372218031759579757647749933369911473\
47137751793425371417130535742248873653706582826875523885042639316689424033510\
56066910464422278879392343380646985367431403311582618907702264430097466633666\
04631717693178027200379346259565935978699172475653527504585193998017731345577\
4622570347530567764036338179651926029197277054971765625*Pi^2*tailpot - 
    1887917964588547905715825638677986342411755330715699145442419137850299103\
16647483379061471983874921403652955073285239892655569155361929052359988723366\
29499913449615462860291914990610164060651636727110168336696995835100234834113\
34728889608148351222445385440405837807982697618538193130638272606019809415091\
26998688550742526671762947240349987790483330463538022257367332480602145510144\
22655665294551339551650273897717390356254225610660633457217537564086081072720\
17866652986555835312427523728490409180486882506521266653882793765570231003272\
00006206690548250998366899621119464555893261902941638549078303780474667014715\
00145543359050023232157790720000*tailpot*Log[2] - 188791796458854790571582563\
86779863424117553307156991454424191378502991031664748337906147198387492140365\
29550732852398926555691553619290523599887233662949991344961546286029191499061\
01640606516367271101683366969958351002348341133472888960814835122244538544040\
58378079826976185381931306382726060198094150912699868855074252667176294724034\
99877904833304635380222573673324806021455101442265566529455133955165027389771\
73903562542256106606334572175375640860810727201786665298655583531242752372849\
04091804868825065212666538827937655702310032720000620669054825099836689962111\
94645558932619029416385490783037804746670147150014554335905002323215779072000\
0*tailpot*Log[v]))/6023744501574579761741515465566936588511478963154503158133\
65877483454044055975510454341371484978086523345719289278438193553685735282482\
09581142209241418690344127021418355486721501825340190191316760357357005669965\
97441349312125584419702390727350352366824410370833388522114740284924398255127\
01866979964976231038149564418888392111382954968163819396346639278956866309529\
09440900705332232733546562890553719381374917021315806054832715958692990440633\
27059813490650587845600859235200784559011982893853459619325295572808488962529\
66103130084161716118242137136512211472765100488733395647968795930011009792598\
449085384220621207269241239109632000000000 + 
 (v^398*((6009533387009223031357637137837527008114294652088005432808904763206\
13684005150240152031484881839343618357169835606832074556007710918835400111798\
13018406447484962794655583975690430062237391655301250883998200112434499739027\
31438791033202921216564392075589231133493828734122379524485035709505289465347\
09950102870348645836146322523615453982866579389800094354357011163289846589225\
40366187713555720608952796922685338222373505739222864293918952508176867772546\
72657421793564767945697605076948112529038197103647060850274717960781157829474\
14075414069743949620926647727131146951236204918624993637043741123721767255274\
2936993654035571101898384572509212005281673773056*mem)/5 + 
    3177430372134897014762785729309908817773566563877218518582644560924508141\
69282864800278208052650481694451020714898156780934244085346248216929281045028\
13955568392852671779635866732799637122168739683905892268507022990115377072485\
00327727898028123150519783088899703960034948614578494018350451230027256302257\
12220879058561835521790794969667388605957739084656249191304060014438530850160\
78642329961249976381338912903885908590033632344424463072416205700750106979366\
80227426267819753285365565448627010493837826222525154028345422464035394448368\
30154258344212293615157009896269755876730471142364885241329869123509965690312\
22823072858059390811373568000*cM*mem + 82240096104733115593065351897575449104\
26907862953384883488966975561546879425541208061091282553241164122925381364181\
40017740047821327124252972411349405173890682940471738060052382972694553857522\
78773078988657273981952963635459995065138211062502097796147170616571770951136\
82981978241064752303409909798210259840176544374710168681551906914353109162728\
06373659131812917522125770319220175277934049519246641754967384497239041253392\
43789869183175723871448535963402730649058459176280061092376006468204978749454\
56795428724894343021182007871937668475021659666653727099546259814549828555688\
46517743564480812558099358635531105072738335314195336035548355776453*
     tailpot - 12177860726529391328369478355340427519280640787901391328050534\
03432485068204654596396897725602151557830997389255534247656790411371618661479\
69863681390013242795506596471889022368470979386759257421758057460417965173104\
01516079971742348559017632609712126320479397150979324182181144651471968544439\
03289903875113042201289807051106804375662141727841414827252159853905544238928\
15304688093746838999714269764499712923098402595403543531796648016350201533696\
57659333325959817244239352436188833929510896850758109280090068899294420646204\
19694295398228622925861777487249680710494757847258600611269444731603281248469\
87246543191012451689287712302452315659325568838843750*Pi^2*tailpot - 
    2089537782999481603961326590653292259236183933868900343551434786879276204\
72579226135524284399851209669351767195170830445968442385171362088654240662758\
65759176460132486821498501308688845921038310443325696278881907448260619492052\
49688185547105994268081432323523887380669279846825577650030229906947944155029\
18267744566598429551943737283770494560066686179077016971505843162775598773352\
24685039523789547705879208674811224181745272025575048802344642809553695712102\
48265137083740012465327252249533811615964306344682272337773332275676414629216\
39750515354353132596155510798062669406614586082184798751547987136586113460863\
721378836570817425508478259200*tailpot*Log[2] - 20895377829994816039613265906\
53292259236183933868900343551434786879276204725792261355242843998512096693517\
67195170830445968442385171362088654240662758657591764601324868214985013086888\
45921038310443325696278881907448260619492052496881855471059942680814323235238\
87380669279846825577650030229906947944155029182677445665984295519437372837704\
94560066686179077016971505843162775598773352246850395237895477058792086748112\
24181745272025575048802344642809553695712102482651370837400124653272522495338\
11615964306344682272337773332275676414629216397505153543531325961555107980626\
69406614586082184798751547987136586113460863721378836570817425508478259200*
     tailpot*Log[v]))/6693049446193977513046128295074373987234976625727225731\
25962086092726715617750567171490412761086762803717465876976042437281873039202\
75788423491343601576322604585579353728318579446472600211323685289285952228522\
18441601499235695093799669323030389280407582678189814876135683044761027109172\
36335407755516640256709055071576542657901536616631293132662607376976618740343\
92121601000783702480815051736545059688201527685579239784505369684398547767156\
25918955348322945097606223176928000871732235536548726066243694772858676098847\
25517892366760179684575824596818346901636405667209703772942187551033345566436\
2204989837602451346747436013767884800000000 + 
 (v^396*(32402618416958979532626368172321423553271022757256352775635268387982\
03918111258628600638978544746454764646929367772714825109325127964211320712278\
05239224857206218187461696800841543798484638831336456883523485073561625433873\
67563567684873065434763585613461974551162795757496914148378050243533219616554\
42143395623477151797482641295977807127089963022776954099740224055610323558617\
06977465442825485343631126083428178916106634844628830426663204487159822878321\
58622379842223462465496253121487216057713812938665915807071207070335453687779\
50707431570276051437626004977994069288347855730940683026478688228005473026671\
682051681670450064324978482568888244234092544*mem + 
    9886009103638840814302375114420660734354005090024580081985432058632682413\
49991859995908876284512629661991935920822849709655250314564694990962597451076\
23632151746884205076910725985977459523989145654890781526077051423348744628242\
99358839613153947558060692777371681530650204709281283733531304310579830928999\
82624615287164146045702994015202566291222482573378440512389364089184521901424\
58469007653547333181500656128460017036773452488797871345543362381929660849713\
88157686051227492357966520417089565824340007627162091221129638080165197511781\
94065500263129560948498052542517895415678022767421573935917583269475660562787\
58142676971305891266560000*cM*mem + 25377649476180616290803546716524917508424\
90655304879732422523668463424271647472860520867369134346302767529380939685706\
80187767386307667964032685620046611476912980396446754323782753495136624849574\
31589749475498049193443561153675233803938201424743339589646532860873096935001\
01917105622198021983193761116461538444592548153499804906905249789359351672265\
74153360415620828950296538869610063590245028288658518400586337576296196115968\
96646835395187645825190975945640492769581789636452902179698059469513137367731\
23366981484158891997072925683712385211868248204668633776737277391245387736049\
925947150132807467499332999017988394815702572863517349147314582*tailpot - 
    3283071653688060827056431342017433053636617382836852932257582377114289704\
68434488204513564376789169966547667286746188473430502942693893320697153205248\
34637798630426807245882591406814393852407538581835853518660217358938961421528\
11967426851739185192352733455509263179994225881840185597665929259538612477408\
02001488156014532348491371529310652589165760142698960594203436165885710923739\
74377097336180306047500454706708115852800864041295785778309006949142547240785\
71743104480428351881376953005504305428457991056411074807161809450080690777447\
24683068938729344960876388497473243381596107146798160675642759053306510862858\
290692314791491902638834486852250859375*Pi^2*tailpot - 
    6488080525141426276525655077604617672622195881343724371017618507841362894\
80891429402705533350127143262334967280935721385696444648490078727863197307646\
20919057485847870584601128231695238518842828092963828211370692363411926334735\
90303206545130215415072389462858767973413867359555760934363260146131793004139\
47132430390481946799897458787111506153062559085833814078707454283583034216783\
55646294786841479389428434211263716238868656175213626768919026399871268246566\
27445506522459459194290162715428074180562686779444208769378695980391945477007\
88015681138159768982644523487815313975260415670311279034367606026275158876324\
555270757417535804602368000*tailpot*Log[2] - 64880805251414262765256550776046\
17672622195881343724371017618507841362894808914294027055333501271432623349672\
80935721385696444648490078727863197307646209190574858478705846011282316952385\
18842828092963828211370692363411926334735903032065451302154150723894628587679\
73413867359555760934363260146131793004139471324303904819467998974587871115061\
53062559085833814078707454283583034216783556462947868414793894284342112637162\
38868656175213626768919026399871268246566274455065224594591942901627154280741\
80562686779444208769378695980391945477007880156811381597689826445234878153139\
75260415670311279034367606026275158876324555270757417535804602368000*tailpot*
     Log[v]))/208636204681857154396699759821520386135753635465312522794875961\
99897964950678010198612544038687243229542315021102744465002552152094849061229\
26787518752379133559400852672329132775762861602597371735950310231562412232419\
41996125158784278968922393680810710183235343356488020045036191618116345491087\
20558498761119359572056625394572990542912446793412176040429445721332416496758\
41670314915237376924455893381801793257031771813731464142281750242118337256532\
21581139186334358577834413992260979910740296947202110186186367708816934388370\
43851626548771066851521768918380187209077609219854806345107024487731802384631\
663349287240484526227456000000000 + 
 (v^394*((1746912785485185598265352689683404718573368964463110564667022818186\
70538087252442634265297286339990540327114321698555242544204003311868763264681\
17217551552711686228382963381471854163312760688887579799818373492285366430509\
09323224068957020955935864255185488877886046681673973955142080873540235509527\
84548807951910611930181199011523985222855667741864487755323874475047647936378\
05828680390222649039431854859161763935548674879170440210747362251568561056707\
09621063317431121303806077916250252702534451439581670252569671247409668656946\
70792754282295346697348284813142108087918377749345864703031980370612246452953\
4385334213848795934874651996011125377335296*mem)/3 - 
    8791*(-233255277324148621004333382764237414404247661168734014030664158059\
01992912763352142418449784492180596748184853566381723447929319086331455796468\
67659024111540042856310771959280688531543372060100045743191523802038592922674\
99467147736568774947939144286735775896369037577579194296841036501265037136752\
73426956287426808088993661913559280856748314701741899170554104964093321070227\
04044373443297025491156900135610027972475650795616583001632767649311878175420\
16549986678859451052195072228696041579529126501427654189656500322864262140336\
15690318646666527884982839469089264619614288094271840689563734828540825052304\
53881890953999606087680000*cM*mem + tailpot*(-5938371334639395718044967526671\
85553213927850617562718645289132241937502326614026827396861169855946667218539\
82512431867080059639483893114905323685743916703351643648840458848415713729231\
03866884722788513328962652221441801301233114173028953891007369624753738100375\
54925023460846361975288272538887974202457219967200865110302444419094483414126\
81036687378430324703714166257552466378094981177837712243522828536669742874327\
55577764973134563271700951680741040088284237891075228283095284743556082062368\
71799773207010281305476384165390009218442109328253094852873776836051340133987\
36383720585336798806331032549332150171924439666712251451562782579 + 
        671138176559137062994708024984156355400014089090086257541977363411140\
68995178922869433287683774134086049077360558115794213512715994994165150985506\
84164456857694425209803976154215861474590066184609933499711601497466823943987\
88427437613792896784317608040242610492181592190064858405173019347485095309383\
26706617893743134146679119516377487033638466885854268678261080091941819625788\
18097273857236750041927688405964400840377541526016039379189502129522250581403\
55079921128798498013459838503627150766601828677647031953851120355467944297070\
22552718848536150942393457151394560884435425621649623599686436218668233721612\
03430034210520100017395189360312500*Pi^2 + 1527718508291831278591945124548176\
38122776845800349226866021801568389514419489068110257372610308368936141782801\
79287565762603761980949911926423640090365366333328701893049026765189725322818\
83958830897909698156967335184687361155700956925592132575101083493975602341330\
03374754846963607708642842975908891966433223854091431362546049893803516798786\
82530827553241849777710773027524885891565184406539710441402046001161117697200\
32618472910465984879140608039721945675610934346786061389197239504807332631854\
82974663953274074893930032275911705957410173069868558237061228283747580028562\
60583628173117419254143588914177446966171229364598981632000*Log[2])) - 
    1343017340639348877010178958990301856737331251430870053379197657587712221\
26172839775727256261722087131762241261056116990619049671574530675745190220034\
40193543629261834179399429278287531290041882082423524156497899843608586591919\
76711233288043746771362499553952018263232667469859657075366679232601215069276\
91447090131777310814232461642671617813498128505020549101395855405684971271872\
74953611789059449036538639620738567608806748995355906473072525085277195624434\
29572384259626567243293248676126116663580830270813232392392538913737539807071\
59283145721449546200525784242497603109386790675269875232663176290144533936279\
611277344189647526912000*tailpot*Log[v]))/43357482269712625601974181176542058\
63170275051232596068056441438050283655585621404532947638962436248865817751683\
86210827151956610449897365529257589100660667821986877113950360094713811638112\
50451703040528502959522701982958463249955170193042891454865068616632448744074\
81713321616617167837603721679251558346034779628440695219154819314819710472446\
42062353064125547223950472951303057962435032611067309514090148224653319163285\
84042857060478847014489952872315282457675469363639736906122398152689172266667\
10519247430750391041861769959237661377550097018188231279796381381770076728980\
633072549256959212760262807910089211812237017088000000000 + 
 (v^392*(13953215397125699743849740389730407402569370861807417154722332228828\
43204705502826313769248034041208253565868235070217070342991653688299316092704\
76074669107063571553724508711875509936341808318943415330801040028284006829398\
34823572459678375848703965717427705242047067309499732938129751444874800617516\
10390212442533698065128634107733256544248310468357394615584613443507915831806\
17446587115836741702187276213848977331369888620367334584769802361801672209733\
31082033029566716263991449326304945872083613822412123031778064311096741842215\
96757991615369952830854126988694712939645047792432006579660177008485237493962\
00271918706979928387097667783622656*mem - 
    43*(-13190101217344365006193459426312708243276284922421778711906458106656\
92426583106044895020485443040865602280084351197210796933311742689872624781888\
01871464267766129549217988528487331708301276830602225301832654792888692257326\
43654457674063642246924635534738626586226798516790646978134409708908937773991\
41919314478557251350168204806365448865286318437308931031266288198897277225935\
53518753810010808310842415500767974871010168800572132548949251321853492889399\
27270588247708473663330465415886985789082684803055711967615472080544070656629\
72627711563234366889215537312108837310094835211066611486125731050805970185366\
19724373051310080000*cM*mem + tailpot*(-3330212734933263632549302984875213493\
63698396960189525588826528676417611247533799708845471340999038647522307732103\
29737861627216334514744927252529207760290346295869840661088634840351304533558\
41852788798547685655205719206043862795582661448636928655248117770485050973230\
96107474728616490712986001756829727674108191763302948961856204188448466992689\
38394961186910656303125996717986202772452218356447477385660050627569793069026\
65105950069429271174713440064319498536965527244740810314922847736284486578350\
83391736445428349409922317507080364250828332008971764263752224178907695274403\
1107827104094173806538183244056846471900390646039183929 + 
        328780535140436268317044999708388716854798510520857283894460128437646\
21112584982816449715238791991133474891040841611076783736329861928785265984378\
26171708632321750771935863949777184661968552111966820067178348086684946257852\
53015327765093999841675213637293556596033954869942187668466975168885852218174\
54544373417184915450306208561974510712771938610393391996788512365108064426400\
03718250169073882309947614824095517728441395886832530990063358120787743368512\
97528753163941530389935187541009713271278677144749867187366569803301986525934\
73467616476790953535339979112828055768802588482825238459514969945539658328603\
6853283053018530746364351406250*Pi^2 + 86212885194221294314309482695126904878\
85159506321621642582839698612571827958318933659529138424590069744494073664910\
80018093917454505083719139974202077134100805821635012952870952849713660251921\
83422728929654351431389434076112625662932106626123658957905523718297969521616\
70376344009476703069130489619949204738156457519299576953260233638109852472820\
21301501203461543122953218156027758609431418730387949746522791233134678181081\
49907944109726328451466681510891711774389621965797456526976489664773403339053\
03831477215836446127108082141962957534795332236140487333916000334172172043015\
05784973803182513132655333112711420286861536256000*Log[2])) - 
    3707154063351515655515307755890456909790618587718297306310621070403405886\
02207714147359752952257372999013245167591164407780384505437185999230188906893\
16766334650330305556973450972537687390832638871773439751371115497456652728429\
03506080584923317335189937519886812689429518261827924074982319726110536578158\
03740727673329881808990190046438723656331269159645517488463542869883807091936\
20205551005406681839100480023024791161786504460415967182321234130673049683436\
06298753744529290630659989055585256343579280647535202809671834656475321044071\
73996199286154040955358388014369403397849647487538735368480647041793238465910\
72335046059008000*tailpot*Log[v]))/120154908706469377014866286212186765172477\
98744450353783057288910401846700810634745924161034743956476601367058582971306\
37489723083894290884682438191916473081877060784974379764291432327200166639216\
79282296471074654549310598327996375846739582251184709737962377862419281891766\
03654823808304852002677550710420297177937252443843591918433708227779694398126\
95251403867047313021023812130186558623659773673445544573772599134008453382477\
38171829040751460601179805198232957397670181497950160155303387993196739699478\
35896489304525751584401820482255476188635099070592326732569700203287659776342\
26754464930269598306032432220995584000000000 + 
 (v^390*(54240025495026944836819177201870208896826582864586145621955892813667\
29913296839003660481390089469691032125971847510784707827338428323120463573087\
72639800478229063104380168342651296789739771502810761283145828321696795854992\
56364647723027940819011101157752661371413821899677893847180817573868952233094\
96583876665035769189237721130191354113659047326258301683302354007949219910297\
15408124389523330929454311820198442916916042935809389360961402229421684562491\
38425411233836442160987347162783258382475057439871509221669826084651087624242\
07342823093796955969540213919866655228124209526998960301587646089988618324398\
9414188902699114652932419264446464*mem - 
    167*(-1524095300945075877834582432365824535864007962098575274311394243472\
93147077060091104433379387200632421446666850993767836849217811101498058616183\
09476532623337991817889277659016065794971992446066533689691182576884189535559\
54906817586211017873297418235951330455111172610274711088759685738774458140516\
35592128343517244489525482626300945769543185374829631679552709313099158082625\
73356023939243569783654878355756842669654746265156953552866454590104445117019\
09603937253751474864268048602466892988837367099347561808855127897276785262930\
16364444446525446518076682446103754180777988225379135111601040583947448703885\
52216831233884160000*cM*mem + tailpot*(-3815981562042384510943117302772681406\
62221435240738667739653505631837271472810843129480557958409973423582719322334\
68203448352675866554580433649721022830947740897438003703983269936535569783594\
49918378405888318618738211339513460407890885830647489359867100222391288859525\
90430823040828810288212203241909241561522274147925001324367139053227917163952\
63505858027842512552189463780622805385535818551808803431931903631764619940259\
19803010381226862653746904354950339471291871386579769285824354555456618334329\
50293730239176126183516042316528544932123721691109316891402949980807667297902\
837829057908594796867540128905315210457983933642893559 + 
        329081652119894346664561063893209349707876093932669358841470900595880\
40290676656301295514782437252042629824309485356104402941983096176907962616699\
25168016222841893904439747641318462883470466758647668218857911819352893956303\
68058288312651544150533135514858447662136456864531648310712104110365183533650\
32936230440627159779447369394970886746401853297508453142859550369503266253433\
27130280459720121134604110134936319371369414115249312498833700935312603409460\
35186100213257383918438730153693741649368792290646112653206500634158345543928\
01771366582716295326377895927140196161336079311843775273322876126956488307252\
125117216729890482818181062500*Pi^2 + 994131585732414364034517863499012641816\
27447975190020833313095370007873525231352257329190703440345402876911766097867\
96974375379449444318120762221284541425683645571978057070022216771995400893987\
16678982321366281604221694311844962733838312562196669699246579870107629378760\
58869134078362953140467551247358941791504295529095752019414950401465575898412\
10032670956857042442724791695009623481971403505044433317443752802979189803535\
06421283733897666280530440056787006994532954977169238169510459636684809463099\
72707053168905693158002807880903791789283116678751431663113670664519849521812\
449014333692702893309385097271313376234064896000*Log[2])) - 
    1660199748173131987937644832043351111833178381185673347916328692679131487\
87136358269739748474745376822804442649383439509472068836805720112616729095451\
84180891688105203355306937102009232319492958568539004766816902790502295007810\
87765509981978868438397741788383079741062530183114539108661317445808105830894\
32791812173533589905872422967170447511750348207545604979512608793504021306660\
71214892243853424203640131067180975246971903557235438356091026884858348948343\
01680870034811872627743082467593263631803376544207787920725075738646891611093\
32288102804853514890877399830009748148701426789853937266813831826673112443093\
33831088837632000*tailpot*Log[v]))/540243103377954251817471841029605480687338\
05437893908067398641574476817030093156225376895332538947885978438789850387359\
89720795226073826773698116303705048995341444587353319595113870791063721539047\
79644582369945235190225234295903100469597366041220924136682227920449416062474\
49682268256484032304230297274811663633798477612747636207567176792409960958832\
77137924188109455270850137663433267363306539060706037945048084267519116593758\
50470314452749010511601894908931559080204720337131072738580724352282570185312\
01700839820096893143972920808126007548397107911857186946188702425361392193377\
7016806020284945334072516754276352000000000 + 
 (v^388*(14763450917030463669850414447194430920715966552505725454293765349822\
16908913740778294868683124030103982886336172814521077984848373354576535132228\
25190908949258985916229979845119371935424409193194000635292051915541801064439\
25461957811396194582918193381059934708105113903570204230202132234753411491966\
73120925278658579596561009286837342819402908726576045177142225861770765998389\
70746050915184086191833773979464331589792425886204853018640085249312601875915\
92862074924084277937464654900271170126994809889513666950028652387511082787810\
90572162990184181937393154290771029483067172736422740797339364696042344859202\
9214756748608077812821542305792*mem + 799847655725441837530710929655181399332\
35208744719277457974468942186405049404543508540093149626959084116305788983673\
27685893701509129997768112638506012836640625188737788657124858272185628336761\
24166558874136702764179001576913499339982930152691813718539616735617478830421\
17854848869849840201543701581738404163959417672509558877601049256687008137097\
60052859556489596416694605307271260432156653862603420540811239072653865474957\
47551963474175924445153339928220663758843509211227397832737643821795948867306\
10105962532623338412566884453895270943362476576955771820009473421909186235676\
1888960135727036458817403017366234642513920000*cM*mem + 
    1985883908024802957959740585659153069277380985151135922256670648825315329\
98981424816814080805332922451777852658906725761159666726376795288187759079173\
53312364643100822872722595922411334351492890990141421259789402300234732482621\
92326757249050985581007271314154294367488946553054386240707864751671226929395\
10063160218156023522742348879510639246669345914476709702923598049457782148724\
24565930239550351271372041461496589266191186649198407201771809900838248366885\
58137818033099805371551636985992434363604318572811474738566472709173522178939\
25176878329473212143482637847180670329730900610570261510484373948744564284476\
76090174011982218*tailpot - 1495850323570779153949761765119036536098316167494\
17444091330693632493779273089541487130458238259968248641574577288273042606437\
91653327196184730323188563226024696165475331943853555840470214565876936752013\
33547873753124353948981458603660984771266948742753389835124461823421969686206\
92521545745225050659202236915375168840862021343582824059476429681772275077212\
88451571346639712302402719223825272321294711907978552535715765594398191791068\
55255529856680869754890408495636933954971244627018857384110760877515386915930\
39185969192176783111243171983324346013073665337091870200501598261328981647713\
0257204803167334443897197319445444159170501484375*Pi^2*tailpot - 
    5206455780370849692752415445601270935220934007747614188541109445573132493\
47116084446021281531094601851324942206325623782100258886904176651044580380480\
24703209189404337024093042396008349469524528319471582176930230474031899846332\
58202131665375470014537681585178096284828596029000007147041740308734759491142\
27759153327174855088874907491384293009086365505405008378521454544577927949118\
61397215328650093984935076269573917713976984865209974451384652289847004264252\
14203535893095520530923197268138911517813471270777960474080094134802597709954\
73761083549360601445582024025054975921497299770193590266230245653232605078968\
2250898432000*tailpot*Log[2] - 5206455780370849692752415445601270935220934007\
74761418854110944557313249347116084446021281531094601851324942206325623782100\
25888690417665104458038048024703209189404337024093042396008349469524528319471\
58217693023047403189984633258202131665375470014537681585178096284828596029000\
00714704174030873475949114227759153327174855088874907491384293009086365505405\
00837852145454457792794911861397215328650093984935076269573917713976984865209\
97445138465228984700426425214203535893095520530923197268138911517813471270777\
96047408009413480259770995473761083549360601445582024025054975921497299770193\
5902662302456532326050789682250898432000*tailpot*Log[v]))/1701017328016228752\
57390378157936234473343216114275529179466755587143630447396587611388209485324\
14321781624304109064030194334997563204744249679207505368542176767772630205666\
23146684757891599980808500140372701338901732447211259140744551628986275884521\
84093900478730924452920181619232545604635718609248346384331340675307344923287\
80720143826325554458070771844849458782919618545773499475023184214543642021530\
05367784718992165174357211808294876413761056681029310237906423818388970815720\
20963704141146904970186403340175755972585465909700277474834850116838513404241\
014448055495470378442625005291568099793870929633738752000000000 + 
 (v^386*((1063421319541945832616542619970543182879479553357497192764224927764\
68850557179291667640500886354290887163492911619994404899654648899671363131283\
48779206186374803969871078867298420820709977494476966621777695014092083512707\
26636512767737466086698678660215352721539945220512443762582441894987474533814\
05231956669832510593459072612443690195415419238043342857261516507911885671925\
97089963224387849899373926642095919736366463749820474882041934649922523780755\
37553843294660257889790615201446927240462637228515864592257958441523694431253\
55840256706326170468290454432801002569512749918402652026158098199901058701829\
0176892233946789990767301492736*mem)/3 - 
    141*(-1572677436289419562319206364369716558318714435007260204406677857368\
97729550744331160208885468858904781637715767483976658090711606117238812914746\
49314119969917458424951047141812490637382834837108285511262954303617787939786\
55544039278079845304731354884804928255666144373203655154156323848951743756379\
17930239353018427097901948024035221085322780040002565500634534497839669109243\
99727526448876437529133778002531531302481925796875880894679341577703535548600\
76496163958692628367840868132672469585048844907852383268021067763813202218909\
23878541172572963518950975035376076230966884338827769503046098743000991192944\
767580241920000*cM*mem + tailpot*(-387186883674552567197660386715429959893074\
26235978892438979794806008884379644819034777194678739023399653516454669035111\
09594840080792159074048064756652147836802988267242911573319152266131863467634\
48455014234365779158987749736453300379227480480393321976685497450556975903954\
61423259362475996060678393035658460365786357341310390089352878931201918569236\
55192518095233063968089201003244414826242499215459875537857526543707578044703\
75047782889267035835415285115716841537918978926673275047767719707305767169125\
95571518796769385479801899037675120355573889014844255637259180187919689700446\
88095245093587442554449137507699268916440729 + 254721293078948478001822220607\
53405427763295580719680689502562022250329543734965679177271526050231844293257\
05377453954737585000589856971648162535247978271375178427851639870016320628913\
86860158346158435290268747335891631405712075469700301374895020567038295205901\
09001786200346185104786967329872977344685122445866448915976622734794173816745\
50840837210752114363843458504667823693191611219398120080651605537198391798403\
05693719835166793130625070789079655901312445578938240942298962223683066892433\
41710346033433893209786428127742963407129490757753116700396458307107832288717\
0151944792066777515185195349033808205884470468562699545911406250*Pi^2 + 
        102158178124675117101561681941510966097036513582052329421239778919519\
95691524269232143198583860807868030295187886998537581760871108402467399735762\
18114281080242492506365913230193947336867789377652575518021576184771994726026\
28231774801146626223023457356651781892290282557341771615495140654086236353823\
61883013722097162430789570111216514968494974790154323519947934084726660182820\
55962560455839646286222156346266290825494649027840475143818244289702625788671\
74253419375656489621272102720987012912531402022876203147873501493179003852103\
10592640297780629216116583700207161404372347981418842644131760113991981613890\
81246992896000*Log[2])) - 144043031155791915113201971537530462196821484150693\
78448394808827652313925049219617321910003243739093922716214920667937990282828\
26284747903362742467541136323141914433975937654573465744983583022490131480410\
42242052851256369705806802469616742974463074872879012468129298405851897977848\
14832226159325889130255049348156999027413293856815286105577914454117596163126\
58705946459085777698907210242733901263573240448235470063947455129255069952783\
72444848070236202715697321319675650365993664836591688206669276852255446438501\
63710538239543146537935622819870687194724383017292097580165010653800568128225\
7817607286940755860455825998336000*tailpot*Log[v]))/4725048133378413201594177\
17105378429092620044761876469942963209964287862353879410031633915237011508938\
37845289191844528317597215453346511804664465292690394935466035083904628420741\
24327476666613356944834368614830282590131142386502068198969406321901449558163\
90218697012369222726720090404457321440581245406623142612986964847009132797781\
77295348762383529921791248496619221162627148609652842178373732338948694593549\
57552756014373214477245263545593780713002859195105295621717747141154778360102\
89280963624917184453722710433257181849749167437430096805880106981678447262355\
7097096399401184027924765780549829748045381632000000000 + 
 (v^384*((1772007625514982714827183208469773681366604602384708428993779823839\
47720518276748090781207646930150534103631940851914617447868373233836004070658\
23480113259154229840756223852578096880395022790328667297817784632606778992007\
66393447901548431234116297366515221331541307343804500341143635417486262585662\
71262543369132952407862668727281010835623579819065686069667859198215683884141\
17470767085438146846810638072012870991667595855532003101508643023926436834931\
81154716186180626205189214134018739060663594071215902052435761021884780128962\
20162265032150630503742894478184475715231901015807563288124973020869762514001\
6427990814227070384485695488*mem)/5 - 
    3139*(-815603567408502811504530963996587112534952126628950233109005060739\
61075933542196447103737018708753572005600233960688847713575900562928901850769\
07507015214838621569431366346087749864565031744497754972896461019733786998764\
93179708857234659473338102316238534639323477160170111490752158677975594522491\
25005160741197177334060814938190240002826752087821607519081532795963928285813\
94919034883272040090999277368329762828584816439993540330724328460268572598274\
76135508048683137010615830116770816824884356921430087020545413551476938633190\
65068714466576655030902440469950864064482511271971767567041363092423022965895\
39999744000*cM*mem + tailpot*(-1991023015394071276899920923026867965239806519\
30161427814469015345040673786302826461645747649774557528147351286935182277048\
26361158718515486566686443037476487091037637209803390403192267523718665704723\
30246853941193162495924135611645303305693445207652824610772503547356422599156\
25002899798773795559274255564817940890719275282018124021114828636273645621648\
51080009686087990250291604299209089650186261916432178496115925280268788226521\
38595933176745742839114644262172445598178337460245509589499907259183269202887\
63543132735994194815054763691554143541002735997185094690791856455150170873103\
389222476924536546242183082514450753 + 11439433600317185955855016904077824797\
16545222762973925875206311420189307050599987409771354519677371550616608098220\
35376975463737637623973610838917670147449523236314619509724361887383865647199\
13494081930208440008468608430345869441413256124546136117199381395991082139765\
10037366727846208879623209356011459948037007348405673983472041862719339552918\
02467322943908255290789603224205380497473044007756502358040560197261365784283\
00052948374400252772692639730810008910775904515288656260871263366945193738538\
48850100087646729411215838348836413147853050064888749837602651600512967968784\
1464933644717466847450709060883112193139080051703125*Pi^2 + 
        528696632558846490422781827426332462811654205971547372136408238198330\
83184179837559071563661676722622252436443755649989700007070850377658710871941\
79041963649247649594980159624367029488426831791152829762119639727695014657607\
08190448219751135589344391084073682469726454149137288282299629970801859648350\
36502874461544047178203554670484111914610544920442565181848575241975987284591\
28917631228526480065771951417199892270464933379663991048983467329319208998114\
93531133895296312811444061009735927779465905459973098056778337684856036412695\
72520555400330914372516091378975218817269956291160660432496505728062547251718\
334566400*Log[2])) - 16595787296022191334371121562912576007657825525446872011\
36185459704560481151405100979256383340032323112503979969489853176683221953993\
35470693427025280127238949883720786427210608881055641718249924287326232935491\
05234651010228630098169617988146149520436129072892724713395741419479181385384\
78347037436171795825229347867640923809581106496272999625005052692121058226776\
84562624086332056724444263446209264581554985904618369894258787652679027591039\
46732997045082781942292973351259151229075095610772997434772388555548002272019\
92763098299451881420234016387402153280108386032118674103927979533130976065314\
80388335823143852203929600*tailpot*Log[v]))/546599398462798442343799415674602\
29586549876643404733026820936885328930092351088564070761402739120571277713059\
47642683224400706157842141468405915008151845172483217426158633107797830198880\
46266326638862587628964942716082008759363992465176409471685257660970117219572\
37934742988952195548073469061249758466061803130037052488728562920051876048603\
96676757960104386072873688823440158579522822359966112995508203744755092284679\
19400500389398552338179229131324238210230689724877374347948496211322956751757\
40671653728579747993564455483904145333378802972402583069859974619038578244045\
75142757872920680208862270916762009600000000 + 
 (v^382*(19682669036736289475779217363860259074397106334922261337046094309142\
63805583242800221522305768647665331351910789753301534116942011772682160253740\
47616285526311004856537821464964825420085076209284638821343173988631619424137\
97722258057578563408905094852134645857948268848386864193750791565248859587177\
72984455627320293556776563670814045561453778671957176869555577570474783461200\
00451714077598304368825188809430375841705549934617270184691739520190558001563\
33321228195465996110790376508467902042927026046982338871981431317693214322165\
32924177060745794198338133031697387933849342506900747897632248203453637698332\
034689105343875368615936*mem - 
    13*(-12631674802591706979369330249619220486126186890623539106844515303908\
19151093064282443648360173838114305875956585407647211048761575246759802655723\
92421902210809449571695778106809696947149212104136052138785950803062980394848\
16614672745914697463427142297150340867733557739975874630704567578734648806951\
59499033890062214597642491715637207555020091225336652931264182584068337413170\
93269075779953287832861389093521611249087658804818764694027973963998733493136\
03756244966561177675144476920788348446470327371668000168378219928165302034908\
25253471871341849235931332438576766506523250893468917246880018325407615843536\
2078720000*cM*mem + tailpot*(-30574254822273873871232032858785328352541906652\
69552366758847709289353793876648274736491987918622977130861297646743100303545\
36581331419222536591395915664003661768968125691046510086411907782694047014542\
97223634745572250617682441940469797271517697690639734825872497121276062522596\
90523127375015018526262979794271422524789798589731590192455780613396667548692\
12948159861425436621999261590042176602261538731308549342621834483622391943060\
59566628936352322930533066765843013589945441640265366871806330663348918911258\
52877257467820771997867861788807348761367159192210756164325467542154404287945\
80566548994656050959103815470143521 + 153405486774523805713352021313584075557\
55888991054569690265406378734505353083500652301254334266325123982003210571366\
88722835742997472810710487660643928339434149806494881933590076839067834244897\
64830259793044162442631288910014892723637540118798580816681725651790016175304\
66482971581732658508962390400158378025778460257919590074663247129241448236456\
06680706420211508814394090616949687071862057392278279638864118765272030914359\
73783944949126461098247894480507223606073608854960632980515116596102184505810\
83583523988702498840062797552228366699562248868264652502008002740907666457185\
148020645853342624459182729214451956537574495781250*Pi^2 + 
        817104550841496848250993334973707349828645680763388229188798666314505\
59086079082686850270799029599097635848563429046466515787291934630907894909400\
59985197908577250591622899049624267851300417336826117475551817949569223729096\
78749873900019819471966559183475647901623202484114315022164878077476662773549\
68142522178815062701348482120454514265631680400963005771282883205518524243648\
82111024785393061307095019349792009974402278317506751211443348728684556782393\
34198674805962310901020858571544302386016240512518391516051348918786101914174\
44319937902629234506394753234688451430854798496879093043389811629277694411177\
725440000*Log[2])) - 10622359160939459027262913354658195547772393849924046979\
45438266208857268119028074929053520387384788269266031324577604064705234795150\
20180263382220779807572811504257691097687645115482066905425378739527182173633\
34439990847825823748360700257653135565269385183422721101632293486095288143415\
00719661605614585852788324595815117530267565908685453211845212519075026677481\
67174081516743467443322210109796992235251547296129667229618127587765748763533\
47289923817111344582772477510041713271161430075931018211126662739089708667535\
94421932488426776159192734180048583131792050949868601112380459428209564067551\
180610027345310430720000*tailpot*Log[v]))/35128496045166995009241607691169813\
35896521635180252765219854555612399106192229342163930681409969188385457137498\
48501492570739470298338140643053663762972054786839166205567680449732017922908\
91152097613276839907772668128663802015680749690000608720132240422244037247582\
22027184379961153475158680028904785736619738434257872026257257072742676645499\
14958737795911701341496711018005050097867760923272043413123633981689735519228\
40649125282683312222315496871737674179350239388006063492833946743120613866157\
24399339883017223236790198194353813199151861979600454361180888113019167355125\
4130834658873266123793514889216000000000 + 
 (v^380*(52047771447395753208356134877838694173029594050811599609400743328885\
96627917133454877642808617124889173322991757211252459536051376870781675577133\
97908667906902749398149506047554713406736123449423625346205738678921196614041\
85079081901172721681514519164174495682207602486504353174606262201042824311640\
90850815146344284740304944995067703896923772786060504881304073685771811535419\
33128807683109569610461488183691750233881525226381344664853342903609136090049\
01163420253596091459362643483348719090388682880587946643458553315296451245912\
73881728760852019670341095116060693378642787154964422253177746836090464434203\
6093274624169607168*mem + 501549135279786883918352562962828739859946764098025\
94888123184099164733366545620121346462951707942219608035086349304182632805175\
75439426556312755363449765400133078182395576445159135003645285788196089329919\
09800623934751060611193112780815897942314088764751378608072270134640446853232\
81778274292717839722932323615784289156534581168981165719366596428070581835554\
14658522539679619419280541527782699615986336476335993876030465380870099324187\
80275636486335710504187932016830935119270594035416393993661192279037596965705\
78301484285377528517737897449849368768982920269549346964683750943327671330619\
22022846727832207360000*cM*mem + 12036150859474446409703000333044928478005995\
88471630466867796791583347277604115499537693584445034376488755687271739278701\
24528213318758643097841424998343778776364144043694578398132021327059825580426\
77854753519859294680242351074671986715848652424497090202998846915586641641684\
65026576992123960942243194032945674871391061332314402563587272846758716878367\
21422091216385854070405813777314663603478327914113689201413828956017405729008\
29950949221623587811937574287676772328468873129821768932650427092613526580952\
43499076431102738703281286027040741379328455119554191801559213911567883661400\
61049686369385118026338387405417802*tailpot - 5273541821188529769145609851103\
45953069964371134134587957860302919051932889070910050944377173691025807230735\
95178316699265826657953972870471670368918993991557633896047846120921912145242\
55140455268563445793647167501630580332498999833543200908578942259080136893220\
80902677665049951288718215470942225394669583564435572882807330067598096576089\
56920474384860539587908665531588236770646314685182911355071363674854674947119\
31407415852989908568352015585553014015677401794127300515445862714053238808637\
89997591759498065770367636690239968338093688979917651830181376965684146524804\
9229844767058654523112647814891052027603818417540578125*Pi^2*tailpot - 
    3237536823579773886904506357450583013572251185842400781292932468160096021\
02500367021881090098546491209995911588626868466598111299162297355104209210374\
41185820390444175727990601376740236618676342201422300700716706425487634933310\
23025188187486093068676754458752037012823712766235143544233790559336862323099\
71526614046248282919949617504000121419351669054393209186501312370891146534220\
26459328939546411603448387391509753234950772234893871914696189452081393151671\
65378419183678795066184736335933769047489847671550065220217817546838690371946\
74736593121715787199561936097286202159342328057292730958350589781882437468160\
00*tailpot*Log[2] - 323753682357977388690450635745058301357225118584240078129\
29324681600960210250036702188109009854649120999591158862686846659811129916229\
73551042092103744118582039044417572799060137674023661867634220142230070071670\
64254876349333102302518818748609306867675445875203701282371276623514354423379\
05593368623230997152661404624828291994961750400012141935166905439320918650131\
23708911465342202645932893954641160344838739150975323495077223489387191469618\
94520813931516716537841918367879506618473633593376904748984767155006522021781\
75468386903719467473659312171578719956193609728620215934232805729273095835058\
978188243746816000*tailpot*Log[v]))/10750549652701369509499818732760990745184\
60532250046751505647740118863724504905539895926882546813927159216898487723410\
12538480680101095036308928162493258677557485361184223185350022040005786788934\
07275455025066646060756721692378406399097196905594360460405877107738885487903\
00030591612643885016534736438283945323305869100265105048681828460229372980042\
65453516862939618285903416896222875431791918240731155476184872608495295754220\
60620236048543981973580529340855475039597259781947862023118839703105079337738\
21729409114713180988552562680009533560405068078822738673066782705152137780965\
683035661223031996416000000000 + 
 (v^378*((2935209053534465723742360942729926545163761929618896752340711258539\
65920069016410936700742995491558097730704429131548342860439289001268492009548\
22928453316415042807668799666130861109740920626320545223246274119811154465500\
83751293439591020302467639546817538795154252078062267124569662992626261499137\
88325655932597697531242637131579245614392611842339156197999733682146531200728\
65468270050754950465946022943927013232629447064508653812963621457489147655445\
05515825725077871726158298386624421815871359355449434524874650846469492071477\
28002110462474774747323797607593489851627494482674043758665216761008971847222\
65904943477030912*mem)/5 - 
    151*(-4327533380102846419182669168853440761202640461661221496439223811322\
50643792184087758530095918452793862479247585861145570248634970692934444610329\
16707669589492180745794224691291420601824058887436471256600372249739996244333\
80748866128732481838650874226981876896896088331713593925357948332560587187088\
18107068290444014252238573733256546937039787438349949874966818504567204501403\
94790212343391309230814161333301844476732878370930999989195755339628645455612\
82114680473477064193186835132704478098022022623212795580275382630152080543308\
93654981799834099887386913352792457065218409910285717573989149154161039769600\
0*cM*mem + tailpot*(-10296152733527429830603607475607272851120541932249790006\
06885191164110360528405298361896708640137792450999906426008838503200480291264\
02601833704376664571848951542393054379273532032897005205840791258198634164903\
76449059095806713786399177131097046172011355813987129245178338461906408275839\
71652981905209962697273093739490984082837973686872019532095924853353392414784\
15459261209542270838718052170907604901456666822349251029313213669454585913017\
38762988218823521441926777101186938567441524987389487003716329855215041634347\
02772415479824104289898488555177482654287405562925570693616643903236569573060\
22817944669603709 + 393905769972550418503182653279707743547688861880975824314\
96429637587117861629688689863353028292115567914280962666670019084434969509740\
22973437225988551774546812354196148328750988715841756308284622980022643042139\
02716869869642488163887910887091200003444159815494880038555079538295155839612\
38397774293796380931969918499366826113382166686688813090722245384285536205312\
16495776269161975695958645249818805477483772026141052987137843731874111715436\
67355434717447672685900870866700865993016214582395348096176490593565186503713\
32315929162674917052692286175354599826025990159063507035432889593406255103294\
54082172125683190500000*Pi^2 + 2787541992089503210320145954385064303278779640\
00763739199532691069765469699734823097045258698917223424820349529784432076647\
49565647069963571002773640321341158688038231710622773630873054868271793607561\
94016349690861454342505493420204800357922461566614268630152827224331970006769\
71031327699070613877522745049682652791692395903469676797111021810410772060379\
73698524818542684854265364339544715778488575551967813704967079530446162781145\
72987958382187681919817355137579841461070464511682325573126298763236403834377\
10425471796375408700635584189031955927136032559606847614633640912304156757116\
26617492001181435494400*Log[2])) - 420918840805514984758342039112144709795095\
72564115324619129436351534585924659958287653834063536500737147872778997449243\
57377184412707564499221418819688522514961893772988304038818261831285109040834\
74185296468803320079605718329506450924854046291696558754563153076910874127471\
02222625730482559662695505934502502080571545551781423921196363764293372026581\
11734028477247599945412994070015271252082551774908347139869450029009097370579\
95300521181715710339969892420625774556060621640141264031161542071113248696978\
99094274246241252686713795973212543825344997540916500633989809679777757927670\
32455619241292178396759654400*tailpot*Log[v]))/140346601210200646338117738025\
60040137316717131201654719394879113823286220690672844594345725154228814088993\
45284234216873870504962155287680273213609572567592134273644702652550261384334\
27920089992262081658290687285388468951597629326358971238976427682250729466158\
47108992040470373258650703459745884287706056727458301163188839491497151807574\
79599190656206964972101039403210227374624319522608249585388135188984136718126\
57044065562149089243453576788166847641525528394772810179920990365837060570536\
61983469632137459649017143354941939460574536991650196711211785100170584630615\
5631564094736688728619194777600000000 + 
 (v^376*(11585697738596206333607664151677371283316598877165353548708476063592\
51058588436647164565145958982260518461189096810252225767025449604761222645917\
23592774209980956894789166327085261786907081563110124668538728266752738907951\
61084695908363603871402964791536567753877982252399629868178422981578363733413\
42389019670995884786480090682145297341698921486687052320155415278436638913756\
35845826248136070339114980939098166877535380421088407282593303129559247989476\
83175047983216505067852763933946103484566930707864355455443814917601193270967\
34683312713319437439500330695244470483101106948658390352900618638025296978911\
43602218729472*mem + 14898886748161269679454689741723426351701163111569260508\
50063357653800167499336040354563088728435936572000031286988586187539557409962\
30017619927007947618290558711734733912201860460061243486320929260347997153664\
97363530298419943604779776588655243370026953173690311635961504520348766479761\
54942237822530831121630055945100649648798725070485737569123998260562891171126\
33283839346961833033142840200248334041373625016952088050426306384190027587257\
01975582886984024763657391623006618363151515914046657275818857149473649024795\
62740377650901393947352507872489942334028277894423961743384573014735996008315\
2219668480000*cM*mem + 351422699571335974043617659706118406500056882575974439\
46641091727098136130412479211909353812056090976909691192068821303876886430088\
57156092252892834859426737287865478999899645571051558312153755450872647611018\
38472908785273437442279458932416984573297934573218295725145548908879106963558\
49445127636047250774970743844909151638328946511353341394993947845603999538231\
04108942171719127442427339639036502564892139248014842224102222168063621275599\
87334791509428026482581480309546904490037643227983940170307186204632172200597\
30575903832070650869479392139633995160092839265714470082233930319386213484256\
1055571023648324619*tailpot - 11738766117567954550875334927559565929581250816\
78245205709477528711870577623219853247701803535225345762130117605077670091231\
11752771726963343758956180967433213602158014814308410875990005232245634062167\
17166571980051584109159494076404261524870459521210219974721321570512732535107\
14411150515668123209634633384624730260970688560815877922709863594965257130336\
99546403834905467394234331679415057843072494455126623141381039434934352058948\
09307844222672923438721097323428991278314091336607959165466117866235481598559\
53918759863621379939626194034437863805196292133687128376241084427424195597471\
0336021391964838982192232791250000*Pi^2*tailpot - 957656465891470788964715804\
74668030023280416590043378593597983272793809634251212904580283951823424230490\
18115003051857012577705082480758024305059347923632969739040612772116846339477\
92125420706767952979812782528357560720649501252714700627046441867770862284803\
14072782138791052866896440247196916925675382416753990767934928219197360060986\
86966035969246670842484546665870454734713839170696302336953152668416608758136\
07592974576458533435537604179897824163448738872064274874294920920196818913912\
71739353121255512985318526588915958875312053740648037644551195124235430895737\
827662341018826812152928251241856425984000*tailpot*Log[2] - 
    9576564658914707889647158047466803002328041659004337859359798327279380963\
42512129045802839518234242304901811500305185701257770508248075802430505934792\
36329697390406127721168463394779212542070676795297981278252835756072064950125\
27147006270464418677708622848031407278213879105286689644024719691692567538241\
67539907679349282191973600609868696603596924667084248454666587045473471383917\
06963023369531526684166087581360759297457645853343553760417989782416344873887\
20642748742949209201968189139127173935312125551298531852658891595887531205374\
0648037644551195124235430895737827662341018826812152928251241856425984000*
     tailpot*Log[v]))/3206351855324427298847337356981732407350424932063041221\
79386924924161238723350880914361684321408621731798153296006511687894697608847\
48739431829292646892862744581969689682009960279668211339446147057264086424112\
63047386692758431479388096601412646846526615882059756193307581047409034287040\
60764429471324877275105117846417499596737859212314045600337290908901919213683\
93676473862997291895098752438308475673377574925022473867769547488368952486130\
46727049391288115857582929736486445602352674360292938442698675749419632608355\
20511075640417825584012896138963715717040450693258188453312226878858061466828\
8000000000 + (v^374*((3447036597263832877438389509742251370837400975532064019\
72023540075112708042190711923388531800713812793941345621550239710164888380553\
25919873392643049830137895361667328487433705528735644790022463439829542238114\
82597803829232427109673273760839729781455586026263948207938184207086926494681\
95246823866795103202249030949309504497094222504003408652760424948807745162370\
73490924305213757701718593434343451522456225400491747423339275673840398388840\
49006131042829128085931092480530998050524689139399023875305348581233749128929\
17328780063193697139685644986171932691947400677340402071662720031453558807507\
878993370713176408064*mem)/15 - 
    37*(-92281461912638144510140719396383485383789532404276547357335904300053\
94000302051860145196902633445267500571282126701950285663674512081688788657367\
29204846749399524641919026027615693587461359604577561316637966504216561730326\
67014320792241616265299972143917852437789461363018768080920951763342024233491\
78407185974938434031380156362883841122683251227997367553608812007963542839209\
18860109986715855353240122533204314090282760594144087853332051440696582034692\
53227166547660441837720943879107874058957679401028648664542785482973585091498\
775370278029407194868140483195859495313359976242226460804276813824000*cM*
       mem + 37*tailpot*(-583191261780978638029799672867869802064984766582932\
77253145252714125327661370735908874119353619028858969915549148705563579391847\
82735455543331147002368071709819250294034794602428676599779502252131731379204\
15792582847962019940048112247974223977153911684704104121008823814371340479750\
10134982908260046456220726380232568506111854350548578319242929488772750700009\
59080453077686704959921870252229816923968454859270667073180170176186675122886\
53517833648933310256050530724880624451633783974973619178268405111806318641982\
58137196995957710064849446273037371083204243689321283606902195943430317531632\
372234810691 + 17007929355070085408961508117385688292401020408784751705387168\
34014432473540398447493832405960408165948519824959282544803332761344647160000\
03537958739982678813452025522685967975481890614053107834347527086946543680832\
62368488735071889769883333028947556418038132395416677083219902443378778128691\
30486008645885011676998598371978444915426314727349822746712828563397735750794\
43337399507840091131321888440963920711425268022700527146654394466405717252527\
93019957283833150227780187798623759963276161260208657958740622865332305368518\
19906426855480416939274757757437209733086275045031409398554418259796150056052\
792700000*Pi^2 + 159970066371051004952832695976852312227756880917838532961948\
58984789853532802291072812778157500950003698628917723477611017300417265515199\
61392657984892152946058645100009289365515129831627245641986217179615193700104\
44179427013460054603191292121909287139780534727739547566236774912659137779103\
28736098574919742712040547552340715421608563606344375533978360643658312182940\
86392277902308764713084169816909598022911416371236787561118610718298452436814\
92245376609136267229826739267965506223648268648046292244352100203151856099065\
24185061379015853392375901426642639389260744381507093138842463056347183513600*
         Log[2])) - 218999020861968825780427960792310815439799169976520951624\
90761950177309486406336478680693297618800555063422988363440849482684271236490\
30827146548781317357383154285141912717141390212739497699283879131318893200175\
44298081635581426814751768878914893814094359552042275440618178144855430359619\
59240039718949065127772783509599154439412182123577085450106016375721168229378\
44604271028448260698892212228479349239693365729012223162171171378073350581385\
99962883920577907549837632806057844778020174479779175374082518025178114890999\
62031609349027872703294162609053073773323897959058283210507075331924139294230\
118400*tailpot*Log[v]))/73629515061265326482069698257329016337492621370034772\
04667748826538649846335367473709194970994822197845508731833038518934548973613\
56984493383699319745582662096487933517547895503481706275261639628293596736042\
41454594833932877998291231714658671802405363752857475152037852831701974053083\
68657486479497483811209130294472364396176504502304723979331282471367827460696\
21023592245247038078198060317180902417689756032549181779447300681064157027359\
58232053325968620547811058135593103687785241137992953341157015639374829382630\
65060843905573914809115024792442291581231366742980776870407265394913968128000\
00000 + (v^372*(1227342484817860012007295563272591295762327731153294365257001\
96952856693197828620664988513305025257444837836948479047840386101437998583519\
76233595230570453356398861268093991552469485201348547309346992033438823683895\
11536144454124216377562519594943072563919263422188385450031279960923704110380\
92520328352313400073398465684524300732380031319732444810262654505840839011997\
12179489082235830733463810131695219462043799369896776877088063383427741232187\
44012968412288126867391841102732818515491102577265826169736535754938173643643\
04497003958150999089372505341978171987308052958985878369377605365118537508271\
72195467264*mem + 21071926957205676860396464393688402932089399138119315988517\
30388214113362264094344006926852362841112924138158834691813841336486512291583\
53503888574964257636665236116106683355314853707782177562614619003734451971579\
74769823304303484795837690510333941968852660575143259433569142836138506183731\
90032657669739728975103877034469706268081956784927201323413094124196834256862\
68266623436313936103716912981708719246895147694835002819701332960021129265136\
05933815934050519575530555473416589146945955470609384603424078001353355311856\
66961005263300077502558626062982730874771298941723511112845798239077662720000*
     cM*mem + 488433481826530758420333615655290827990844203013307286182887966\
95996537750724181489155409348894897026173192080421900576530747899035557501613\
87382634968353827459817456119323192586376754092959045708064664954480259799456\
71484561067794943309383880467902335351415871543907952156044096255743288584183\
30064785156880767450676037079934682286748581499581268317775769213932521938348\
23959133036907934132788126384522882461558757767675791778371489409275394903738\
84672680835588299338869371269615066443645458563118664424393405415491380042046\
50536391216467241489837404845504422791037913930706468884713543600110541794858*
     tailpot - 12435579379104955479301192602241277768253475322645181311184923\
34296915345893037287361111366904785527679400721190509776006648267139736767034\
71379362842801381530337875021324199691977671772894395897523497405008862211907\
09545669821894781644915585038775463900034946288464830309930792238004331183786\
10564512082437971394133989018266360582888903578105729702453362930140466516392\
21839542206763759595301127071529078674946518255507238006991814700983188695177\
90325696473569109288623849878583825068566273997380773582607814137264442754484\
18292798763962750082384002718928410986719966885506184004893511955564404287959\
476921875*Pi^2*tailpot - 1348637907997846714761386113813433611773135281631446\
21239918161145986961338877986525419939111095024826094412476319353576861098369\
51962155913904886436177343241630320557000596064539680078092746085910281233173\
65804613614035976588152463120315885557504845793191896940094207632895175636025\
26573375809269546481494294467739789747802938123681270246778948890894908802195\
50176756277310626367712599382557018868249660831983660430710619926210063647010\
87979964859200130769408353921524654847033302629830307027021250209284858739499\
05441073770683469194564415684521862202214851279923471954210696648904462841750\
78400000*tailpot*Log[2] - 134863790799784671476138611381343361177313528163144\
62123991816114598696133887798652541993911109502482609441247631935357686109836\
95196215591390488643617734324163032055700059606453968007809274608591028123317\
36580461361403597658815246312031588555750484579319189694009420763289517563602\
52657337580926954648149429446773978974780293812368127024677894889089490880219\
55017675627731062636771259938255701886824966083198366043071061992621006364701\
08797996485920013076940835392152465484703330262983030702702125020928485873949\
90544107377068346919456441568452186220221485127992347195421069664890446284175\
078400000*tailpot*Log[v]))/45532764096264012913549038335254586290500878980479\
94643387872377889171656292484832851167734371798028021216646499652778035052547\
99651829130967821973787258407464022056512335852265510619810724134004963883205\
83097865226026920892561608199031987140379126008257456387173506257935171900181\
24403440892859187922871377677870097520858453478213001766972706515380545737628\
23396906080296780407782526834793771171514897194116434602848437892076845413728\
99050687697884627692456182629948627001785817060400308966858400199315246637563\
46717344684143453525813684258405616522663195518681757571448553305611960320000\
00000 + (v^370*((699121364970902742740738211923443730029564396688735559070526\
94771053414790167400715072995728496485151089186758504937400571921414665665770\
19731551170535596520365779623956179849650946332708205604802759909263301849288\
53290764171390583555810427179088454992125335586941427917043728331954277441243\
09035310202660260250354842805311793675753597653316259316919435484945862266482\
74937501838051373250489998246761628715821422335567945644729993651625726522561\
45131946128635322728462881789965110897349120155060151842559879172755674490125\
83497410556842274237467041076677792304663785551342075287186494781252871390753\
67632896*mem)/15 - 5183*(-178419730903807031862393695713507589966253543289436\
67994598379919800550370383126174779537433599055742767952122857894217495725416\
01559955243964171090495837493334968808190758997492993430738733170263300809185\
35169439032672600729299396464251072607851625670215005915422607159512454317721\
83606426354700244537779451000366349858309319762163611106741856076240599127603\
47205484037292500188521441172262754369366029567046861457568596606628647410683\
76602525230353245022753393124354799507552666170247511502042716013714755516853\
31093194886403482019961330853107941804667221728088834443755782937159663616000*
       cM*mem + tailpot*(-409946700360011723570647565861874301853624462067613\
12890077802963123627765122646939745619191349868680842798436609382396652481087\
18262474601142970530187535214158989929231301738144609742522386534191035827627\
93191714291868344408278403681200207679106103213429137604630842392012046536047\
99586087299286289788379295671173039906764852414159750690058450224844742661579\
21323122942983941158080254077933612803832096961583399886743801023760694641174\
21925444964731826499933045008631378762733133926392617681990278521474717777697\
63920300896902705569084096971718152578247872051944052714213350940808151946880\
4703 + 9111300344890329322073048672183479298845648998880031232985566302638104\
69902770311746700020233709326328958761846361270579501055155259319420002857773\
36299458625022287908056206534285263330843412975413550388059847014986101609780\
07487444043521398832643815871071549834357381181929855173163276659785475122183\
83043972073428796173488242736535860592125697551938577171488336629318418141909\
74397562280040039306116336349287839653936813838682125514080564874038598475461\
27230487058977239088756209255083321409944907636492601437940479227195282992567\
307218455540490624606218060170873232156533686775453493653394665731250*Pi^2 + 
        113944701861801869523562249579819765571856072061576693050369495324819\
85921402444684891793969923387048212125436898567450721049169982146001587287943\
08011455202321354885387197337851274326986390201548093094634066087152174088058\
33753444460563427017090701044858496068096272443508202396969406363214246826027\
43472838406992602425880331373840957661520354678478630831989594739277071928500\
37045352093365224537067634247815763612343320248985330706609492680384203540430\
28463865943250554799355086000726570217219984269870147055588546606829545908835\
693084496486591558415853388301799974926419683709559249817600*Log[2])) - 
    5905753897497190897406231395722058449589300214951520000800650942685413303\
06288708017941681461129150708834461394452750970871978480174627262269134089842\
33723136315823709618438020831548367704604146237665094883645297097182984063634\
41026391002422295811035155015851209429800747030130234924331805394412993001941\
97214634426583733377575106176835596599982985547436022020695336730638054174200\
60598999119587756215483064291028027754288504909690523570005624313269500501652\
82171838676255250574107417658134358511784707369721891154370631975364454953972\
56945290004047269368111568229270043633220666645591804620800*tailpot*Log[v]))/
  200232032085593724333988734983529403212404920758487011582580139748864188931\
06793460207421874985919208536572763850715822493634775710282723437459189700407\
14192893676589764009904421770535667212550593508721221772113686280867233621882\
50655373734126557282358212209266374257950462497362274599975413054493752105161\
72725901924014329170968394906626968806136238107905137352546441525803887765282\
62246234701721701394872983441525278970501657191793003476283539924565861585584\
10861691411617351878014073478306325418642547258740384640164673884936390756978\
19957808340029301651357439567156765845671116800000000 + 
 (v^368*(40459105587262634517726687908042170613471696217266524679791682295622\
73282153662616627328650604786507569748034992347647758995399507437397554915940\
61018905372905753210488532600016679297526993539930543190577283927609902365365\
75453238570295386344958995579193095814389835928233297651480130285841832953442\
49709218609236650445274234800458450670910959182751752710317840773211341720179\
49778518537897394804440457738365229131305497548707684307262487843022720058836\
26111955386745431898307067016432440107690895074629033834374105459298023957350\
55650574034289110575641117980366381842322642719681868844590990196813594624*
     mem + 927792939297522430729301230703137473609930621869205187213571852858\
30846252277201291860912807637295952453701080410270867231163469833542662656326\
53392620191624054460161143246794782827867756186833849570162665271177146814269\
51584571508544197355886875664867616871575715044643948390112596571837089112720\
57060793235375100620549579695424796259692333292938982164135790438785847846121\
27569009059539211816858419466697103970045215632760782709158118695718801775758\
05705077964830437645179421934075973058051865439187522573708239769277358257633\
211813014317566450199498277869135561820166946851288525045760000*cM*mem + 
    2112998289177486979990968522386383572549211523083624989179571925527330356\
99929352627039892267323068982489729058830245134093753936401746703494712460012\
16584799515553230942380173476702648450482442557347228630480512254397283813247\
73277557529445694377214431868621418638898459544847519936644840126459955032646\
73372786639894476830202870488642142821692970756818885379697199370920241885205\
95004339451722875297664388650410053931951933080652066708899658538333442008270\
85811135651434053623995857773270068453195941266315672516948040722384008231525\
5711816171666669482076489062468927551422686454320306971407337*tailpot - 
    4099364488616068392060998580810115601380450339130594801151647290625598112\
63177145020538491099115409240323838920068512033806117720568505775902078919213\
60956318501189604651462936069677444315362835134150406333538220952723735200093\
75522497067775333598640858591089820681825806193701847900620442141376088738138\
29065448428983388204257416134562575706510222090735187848211114913084415615348\
80948666053658775004981502837463478204829596463888023320324925718666841591670\
47502305269033727543969361578845396996493049239191003582642337633752487938843\
34596725937815100498712897427153408206323992410531835294350726171875*Pi^2*
     tailpot - 59123131701322419854365746274493511368116111977812106465507139\
51299084820551504821878682740043184777267252631888822530786824667207806073513\
99283879979901132763151475214295416099007018451700903696381421911413264046458\
81509042694909704039509756045708410532384737524913759410975458965522428141825\
59725073305457824413553218004655175001893441755810795561429884645002757525315\
20179371045194622362286693919468105770686902076422545540918066424854329935965\
94823400317056834855676173198356363303527864685593698441467238074645774626068\
60643240955230988755820769188416419703765237010591326018184893952000*tailpot*
     Log[2] - 591231317013224198543657462744935113681161119778121064655071395\
12990848205515048218786827400431847772672526318888225307868246672078060735139\
92838799799011327631514752142954160990070184517009036963814219114132640464588\
15090426949097040395097560457084105323847375249137594109754589655224281418255\
97250733054578244135532180046551750018934417558107955614298846450027575253152\
01793710451946223622866939194681057706869020764225455409180664248543299359659\
48234003170568348556761731983563633035278646855936984414672380746457746260686\
0643240955230988755820769188416419703765237010591326018184893952000*tailpot*
     Log[v]))/201305662284444092829077146431162268645179209877835467408760194\
11749080656608706561870732448042143976410763502530880518592796356277093890855\
35441323767474054517771370406176177367731771783390633974707159405266870328030\
36250029009635377386461923482522478095384651180554239741116651080361905576127\
17200278669074456335714491617799230960026769740756839381475775942378565457298\
06020887930558558546952133077809858897561855173227716143289336129500285060245\
87720668791968024488684601895319719242773096171667536072981307357211961803503\
622376766398994213890817988957620885786533077404614656000000000 + 
 (v^366*(20066853203743053557953893519805486659429973463034444183908264719951\
90114324966900043434563293379598434114332490061936540961674106157261638376116\
48646923239846429914833892517016752297543201430182637439967791574049772252007\
37366522547720535347265295824943793843788619909071749157370208864763322847051\
84768354865815007631684559752402604162190291984754400058529326818628818168419\
98132860133496027003835437156485492505153521015837865403317929381488316337351\
75457213368341250482518951427758376506902771020689456282921313524763869860885\
00558879653161050598049372234710827995650581179269224471366321353785344*mem - 
    871*(-6106832457792831935600517468313608277325682740083358710688922649678\
10396036591058908003871371519078597299078892810392672267068849490318544220318\
91589126618370498708041478209104891140086078043487188483145427813432847192733\
93603791215214899097752236237780245053801359500377856729677007639169233175736\
07381699108177197864884658530036401407550393079555483188343004802344459620104\
70505357595482744481497157440252230795709960597982273806992991396991498011389\
62842529381572555421735783426409453258421593605641661116549402192602242334025\
91003950618065028878535443082219071089272975460925440000*cM*mem + 
      tailpot*(-1378502864879310131433397811615023001312180165397015469372506\
15220824476196337719059379334769767097537892435301572107075566629785654916001\
55131616548568481103139428538571645167720748387649487215395086147979171469990\
54347699573247283529485678572252865568520021417977102637257042917751476873288\
06398476124390819832829429772328419199742758387650777269977018065763387122958\
63470178368741279409972258094864565620360732949037625865725692617432064273793\
48119727459835168065838562339737162654890710999218137451294995488183206039576\
8827086039339909781270581324494882640463513878604240988393679209337 + 
        233432529361986055139846579062616700509772030224438773534094786297524\
94699270368318306406581522280876441656239208303338071547282306161072568393969\
74592105345507770670988386810204163475469406112178579971150939280961223430111\
69074628267128279652468856873863468565700131548521172288917542700124299929125\
10118346571140739007177626409972477405098407153651295923710990027609413494367\
38756287566141566394699494825904145879796867903226428781934614092416321190698\
28981794312789568978606802182259904637608122388037582956835157428480489365813\
002478604870706622848491903345435553765784776520864411415977343750*Pi^2 + 
        388304473355696250760411463537365020751581190120078089620264954064228\
30848974897879650144145283821247903586328152455445759830573700303826861048416\
37636961741682041325306747486446319175138547591774686755949266224098347752537\
72269442683475782206091177700172498446954644936501560820064722307061943081806\
03835773697480054718116832257758007464614810829160635439969138854196665084842\
37908163334698852557748405228254571404469784277730467530321499962177219178333\
21343429186118197741072702163078029087857160752321861823921987446486167215914\
5944704242112054457458427924856381571939818769938944000*Log[2])) - 
    3382131962928114344123183847410449330746272165945880160592507749899428566\
94571360531752755505422083069240236918207886932568124296929646331959731706638\
17936770050579943421770606947440015456749524357521644318108811896608924603564\
66845773074063015054157768502461472974957396928594742763731294509524242530594\
09588905051276594797608965072245016795002321989134682131199420052952888977121\
80102645227005777988609538097316932931821059032372189100264670563579043282289\
01268211089502324743235840409633355235870152723416486360510658894516450616117\
837394879599432446290722549908349159582148616820224000*tailpot*Log[v]))/11564\
85995506189732836521331469718127030903159007097667993643397840812753156379159\
05040592386301095230241843178078593557599366275050328748690278130434745732737\
52037746492777732867091756702742056537957637333972828387765391614075620569363\
45051264740650008207878118616742089665549508313071077610841662214400751117751\
95602211515506880275910205327978778522457540840933926411134011157866558323930\
31130599834219794509164238835088373094347009552854950556755326733174567293632\
05771362860894595419990977623520888967721030393787601322311120509956332789432\
54012632491930803783914062086144000000000 + 
 (v^364*(68294507562832754924379687042444455701805033282341466542472825533944\
49745078110821952811895268205057642578306618414989125631592787362232457312616\
22655589029728338367313373652449253017559471198547907145100893311309654548443\
41947319239969117958409150720429149966168285320824747004773025240836344812227\
49996194559933056617272843515571673884780562258184760032249314793055615134443\
75731170879869979116729594374961883265060310134878956199475219394774674708858\
82548169398984045842017554780863241923813203694587471950160892448803049438743\
945422502985341235021654650066699358887192917970353175492334452736*mem - 
    407*(-5141795700466890425871617246988631747688141031153477211694531911778\
50905395970544430682718238101053090242154523891621946192509774450796014029943\
81392467531621691159298835851535707035786229417437007013528409754450618034090\
82245555895846591381318318838248008392535873897768780072573580126362020735314\
29270683098091138898899466147604655229567441703367396947365573672448928123306\
64817821989874404034774172688995609001217501248627624847280408065200508078041\
67981561527927072004427562891276367618545379258760360923524054287371144154827\
5840205558270463247922521114901111348250154106880000*cM*mem + 
      tailpot*(-1150349681848127449895655198955094446053411483123909520807897\
91177375754614589176368131305827331480174102394643670770903216933262726456774\
69273520211275939052584062059269724760880121000402979212797848779642106450355\
70605944166575299060774780392631410693081043892943206293082681509513351092813\
82600610329484089368298634490865698086599929808051076069283391237670725404089\
22806290256448621677977729393087238833977899280148720731268973815876526903128\
05859064909655015592691354070677207220782907033001029979146255754357046446263\
602459768807832812478238779494809054427649582080166987831168758 + 
        170016717198125258290808549949182249780024759474535642352168033663314\
23236253949982974556678288695497913647954581723176649208181878574899802775215\
84627839495476430015174283664550552107012417770952479412733884773532888633245\
45650101583472535188180894464156691002488441023271925884385137830439184016125\
71389639266949376411473509935418714582433243857031966387188882186383663571315\
87890223434482462123767776706055431238063410995529101520561361227304325385574\
11429403591827998273729193566511148368168584631258955851548655395364345448644\
62968373214737022335747949593441563969496877006033640465234375*Pi^2 + 
        326224130683290045654505574652242595547701433396145374592487649681407\
99077817465583444904972927043023891273860274107253519669729651829004298604335\
45522584214116157330052961331529846620368880501650856051228953776503755582732\
36338854067445879830271135282333629622244224749292584411696585983479919313846\
34993648670753285627516271518663702799690675966112900365079394641166967880567\
24997684292722366074276320794410603156569120451014428796880685300850714626561\
62116953075469143984951181776697071044582049208947922518020757863171381982062\
862353413639092714677878165697194413126288001024000*Log[2])) - 
    1327732211880990485813837688834627363879144833922311674591424734203330522\
46717084924620763239813065107237484611315616521825055799682944047495319645302\
76917751452760333315552619326475744901343641718984128501841870370285221720718\
99136054504730909203520599097872562533994729620818555605104952763271607354644\
24150089965872503991225080961270394741051182079504485873136189549559273908707\
40575071380029922304625633251154847236320235628725203304389174462408530105798\
15999017159416018751309831157079151448940280418044648344484503107524666995849\
77839351110734873896413438758126142399216416768000*tailpot*Log[v]))/455955683\
45142317175387215402527918586615011788641289543985309802902253317945874430310\
91010341471977221331145642587665888636109251314017847747915566738122249547404\
88349344651193309089918890634621430280607710646127888558256350560659571181616\
17439703911378642095829393711152245288925763723293283459320864246614010091311\
39075678397739942840456078646054347009179976893487270699067886238697521302290\
88465313822524411143306855715703136217061695905636207038587493083397478002590\
82276490088133574790160208204106912199589725106502220119875017991357413363039\
20221255748453868240896000000000 + 
 (v^362*((1592776614659700768801926428038334383946052833756847757494447902813\
73078687129555106638513632185086097508273880184885765197988026790148495220204\
94263142733935595121765368522243603057542947217546124936209244717441227342802\
25568024657261042540125696394989544665809156666845916208475603316856164550105\
27688337384954880613003388888793693974762622540567290027700764860954160949417\
63516032209199982436604184718376005532939813384212180746043334684707596010020\
82552954387213480105612810830045434191653073026082455456190531118072280416173\
087656586523975498428475423760717946440905417016176996179909804032*mem)/15 - 
    9*(-417986203327244697640571426285242900499467779689159432664011460950227\
55666649388131760496772789000301836412775999064475302519661605250147488363104\
84395187065900647257153379767787167285186226074029089194808902570694778507924\
12521688176143062613265188998356334235392957354042637431074266321123164694736\
37007353918020504043743974985393113116077406921072767781825586189407017490854\
19833551741326014347443646394312956656683580748077753751602852835815360821732\
11332448794761644027238949513141734385617550542250466122713375318605731058703\
0232829799359829083784229140939684679595851776000*cM*mem + 
      tailpot*(-9267871220880285353936337592504355984211454383421461033701104\
52772383035079181366929736740778273064520250988125268865180536726430602679783\
80999269640694767275482423268800654252130708360071670467070353467507553591122\
51345264301054973335237097869697579563815579705097693867402867833576790632304\
69524829648036311683549071736913144270891569820307804333014797588680408386130\
60623413437675828326659601257438458160108873139492072925292174534096982145645\
71993726262277543026304251966385735892684872664577512955530736832103203218224\
3006933468285520836621341525082835110181554482971640223164589 + 
        119542231957448772547318570327896550581016426686948806738401599862089\
45915779821709149972376144253425707225119398587284256646230575008327284648439\
93449334644750244691613813293700968868185326913620857527416962787866597597924\
65888760650770957853383661935574297913371536391994412699953974274719938570649\
88645860498558286236145803664436457084158519767989631704157807368668669547928\
82699307997737577164398891119755774248953290876001962025581350457873128946352\
55894467902392586158858648057995321129177496778290448139967366252098594186421\
9037939495231737936540040573956011577037314900029267337812500*Pi^2 + 
        264607950923209059330676857714150279742786842686050523949328334950668\
03141721923196643129345512652207496209367610776665267073618030238774240351467\
12756613480267815645493476935892962884751213763198788359865238374332174570440\
35910008494283196745877120463708942515190069992535033858205248940541560548216\
63097842882174135246802607673062731995891765497958741010995018298893596581448\
88594582609199061413670061674303637617577604552851981580432623579393133538445\
85108753625947712783407750387528532835354932149852699490876250060852747426991\
92432956471430874145767932832907635157968551321600*Log[2])) - 
    2381471558308881533976091719427352517685081584174454715543955014556012282\
75497308769788164109613869867465884308496989987403662562272148968163163204148\
09521322410340809441292423036665962760923868789095238787145368989571133963231\
90076448548770712894084173380482636710629932815304723847240464874044933949678\
80585939567217221223469057564587963025889481628669098955164690042369233039973\
51243482791552723030555068732738558198440975667834223893612214538201846012659\
78782633529415050669753487756795518194389348674295417886250547674726842927318\
96608242877867311911395496168716421716961894400*tailpot*Log[v]))/821355227531\
32542292931859414181385283184777518139773777388008878979233194604284850242178\
35764988878131068821245351683935024175006151500512897395586464374019015155633\
29882129760880740241416674537544707725061563566738395890186447449121565430286\
90959210627587184433815495415034656103025780682723761113878978914126564729874\
35751276582700545175194654563537603578826072131171861778360012185967831859147\
34670676360958614191883593228477290801420114603521610534539462977594343147258\
68942181167051166046999338309454310493146952373057739405497138533638967630412\
70503089100973670400000000 + 
 (v^360*(93636031137693820312716594293407504930455899886220664983555247570920\
47231748743366233460070409309121679846163097826020587207599743397491726385759\
87083801632436889594325465858783394393397458619434682629342565671369631182102\
70680793076180384210311048397336607451947524134921098628415705398788567437366\
27568906099376702645706599683724363832535812814511970031308847494162741905739\
09637656888919832350105777162822932454225437548518273187932041161617515104606\
51606195877651926552541718918614579478183931027741726861905770835686394665186\
7022666920369350862671921821638053461689954870471817611444224*mem + 
    3835751405987542732230858099181790553772131147315183941464741731671602324\
87919845806333417987669983428157757527944997798810301482005223494674139467473\
08770885096710036230726650668355888203718006410755154086682180399860867117147\
60258842720710407562331767800142939571396795493501170294967266576299185268034\
41541420824082450030537755990451063737773918431236399682035660117020742418932\
83062194514994541552952314798751290754299136945388931722538068115511368714108\
05498014182545527248969618159573876133616072862296927557496274557622335445566\
54734046522459393934716448606563671736320000*cM*mem + 
    8428510899935216500076265940362534222028824581063969833586466274044249894\
64467469717255866534197294422893765055446344075172458847698202724021255352990\
54545381698570551946688483923404975005739100906944354640798842596209699679268\
08848975245799463930703857053144938247814494116904214984534046573590031067944\
22654009800529309244363424612824026541326079882918120974147431575588773755755\
15757405983165029302812622566977425984709362781726715961592121306122956771149\
16543823873420042149816095345318188777306515595698874369956114489213802410314\
859017246371442614139272872557371032261079614549*tailpot - 
    9487313591820685857673416423549561054366363497138174168637076378088255478\
33027977734708019653406155705290627159366873317819510074454087359255778671839\
18889377268625061379132754687000810507040305614545286934095624173577056337344\
57333656918835588011495124752578885660311029640672545872668926668914412558978\
39929611132570287572607971443745556963636692235928846868642292237527464192490\
72807826617881577371822651670973443020094885322095452083501784044957623360755\
35440322356834184768538227631152910414179789540716182992676620140665738238413\
5478586381701617767360577829619080967882127920161718750*Pi^2*tailpot - 
    2422846026937303145392601765763788630607970057910890627860972037667524434\
04953500490464832824502186115962292134646560304174283864171993327510223918857\
85920242377806078722248813115427050702569874848910457926876351056321591762387\
03693027615528387586486790561912478030634824116683012692410286927705469446581\
97154545977174903633793316742124310058852514507359719138446760252077677727549\
68953880258630278746079197987118133122752288083708726574521174227679543999658\
97347450591907307370377412056592108163704637786786319673451493340221568139363\
078157316326966009846938715556264056890368000*tailpot*Log[2] - 
    2422846026937303145392601765763788630607970057910890627860972037667524434\
04953500490464832824502186115962292134646560304174283864171993327510223918857\
85920242377806078722248813115427050702569874848910457926876351056321591762387\
03693027615528387586486790561912478030634824116683012692410286927705469446581\
97154545977174903633793316742124310058852514507359719138446760252077677727549\
68953880258630278746079197987118133122752288083708726574521174227679543999658\
97347450591907307370377412056592108163704637786786319673451493340221568139363\
078157316326966009846938715556264056890368000*tailpot*Log[v]))/83925942867642\
24348732819422429978060270924133324908764719483196080984318249756626387143565\
15496138773610574377931030374832170470655807273116218895074697617746780207762\
14114076384271823033038951383996020953157040198064975155290951885718538517054\
79483374753458899913027460664304097720617917172046435341857518473422826622039\
25539160357685133705175875020872300288767588334999500513625223361835680430587\
19755758953536872467669607814437070989793726517875735818065018146560948289375\
62211972110132770469959636524623006792944724767480184485402438723327755151161\
9581973102592000000000 + 
 (v^358*(11007923493557283118578436411019348013402110514542824057205291844127\
50325335175867542051612909950839273583509091518177299224560732621229122361720\
96562993599008357227120740700259661353919416072067278423859180173830337626579\
43660202107934037639832599392284825795432002207786400387562137891492153888879\
32743032172925611979425319480299099520838393294208933353063486080337525995580\
21541482378432136175491997453986908497917033539505871693474780098388493274395\
66205389558731008867456617676125198690535335038277519474224880373992010068280\
77621948116579370908167657330799365231122831589090510503936*mem - 
    43*(-12127201953142381790336984452323111614959767053332276124668617359631\
17235202997326626391787473422560853266471175714319649697355136951011837778634\
33577562515242228034329830642466368227952293462613616656554406274297211249212\
44093454734331891969768255356212367446956445061298761025820631654416966087569\
80448929253116989836951645801200267017249170622178914770294110617383843952188\
80373000718521295600572698987996140929169971338201155372117345780146497683022\
39119244018971311910347678726272466273665113365831407856360354048589505549561\
311724011013957096457028031771764441743360000*cM*mem + 
      tailpot*(-2640720985956338177227172997384053012197484846989429346404174\
78713834393765634092933098682229753220040127594715028230502828154828712158063\
09640629554541250438548868612221197802092238898336855615884907309337442762721\
66955389067539891232499877063283426242458211073333621002834424366772391218299\
93999786360901616254147914596801777811265872986564448063916515995845234415282\
00329458942688891245201266791333922617413345306167179862112876902497329101527\
44276831021679479208238732032462139004721972442038666529795788753601315577462\
58622510725755316793018854146369468786853939569486591251 + 
        259380430073009508461695476262138505887792846250366568925125500432804\
97642574473582327439260685797959706959339187323537132537555233792519945277377\
23802756916671709960312005661015250445720674154233265181352268958421034934735\
51886529275570737987780977251763351473710370166213682885427499962072187302274\
66993526081981303929073287979029721349667719311077591216951925094810387505363\
59111242331589018619317372894435862866278131880731894602316756661116869674420\
04410799144778752056509565912719283046169748610004798758901824046424638527664\
5596137421183389988143034366190322344820606974092187500*Pi^2 + 
        764302142995455086257756470702020100436551665249113746223064874344909\
31676095976018267036125507271579857472076748594619470093256388729706458388717\
40050042345535303215641256285355031165445390907499709087758208615915639061025\
51865608751456826776623229629023501968737705188676989072501941908522120379589\
04133046408930244164813920953386366748605798325088886493344847761418699356900\
40609007545820070203332429849643269922889166317489818630843918141715831063891\
51365521021588451043294904529232436518219354050872728104421398019794168695195\
89079134319385384323909510819437469230080000*Log[2])) - 
    3286499214880456870908352824018686431877172160571189108759178959683110062\
07212696878548255339681267793387129930018956863721401002471537737771071484822\
15182085801803827257402027026634011415180902248749077360297048437247962409730\
22117631264355139479887404801058465572132311311053011758350206645117632232877\
72099558400049908699860099561377019004932797882211921382845374100407234671746\
18732447026301874329448353466060668423415165206220112628848009378073574733508\
71740392830339486168089475699477028343222418752730849012011485114925389342330\
402775733571525928108965235811176893440000*tailpot*Log[v]))/11434052161804120\
36612100738750678209846174950044265499280583541700406582867814254276177597432\
55604737549124574650004138260513688100246222495397669628705397513185314409011\
05459997857196598506669125885016478631749345785418958486505706501163285702288\
12448876493038135289844777153146828422059560224309992078680990929540411721969\
39940103226857453021236378865436006644085604223365192591992283628839295720326\
64272336994124314396404334391971524495058108702416323987059692991954807816842\
25064320181576358305127591910491388684567407013649112452648327428849475635144\
16857088000000000 + 
 (v^356*(62483320255277167623966701012013307075047098407218895448091647111768\
47491509794692299949587591838186133015693547158103633471418012394183569690257\
12956883164526016286174926588686136817621939668969223695546726437034714349304\
06678689417463389354881659559161111448942137418619478830803263702729554908350\
08555863587295368252363985802784940916649353368758143853788313835196821768800\
91119118618515331072992182991753740065520117673141483078719010151641885150529\
27167665868483720461117967579443594282368198780073993605386593132816543724189\
79824110327607340581583860372210080835702247885790773248*mem + 
    3423370888702435105600240317232802523549021614263621016813355161821909695\
70881625058318693986797129351185820280373752340568222547269091883398228783536\
34219138681051736379815542878357438919891946554326082880932952809230005743427\
54565180459694432196370172200827183779648399625839145603744542891727262705779\
57786785245844870533309314583671286376466612953575117742479485072147387747686\
81187178561135008066788227729031056073031183946815461126071833861305475611212\
90586380007793110328303760965015001002902223665893501766635694423566216917717\
802834231641850107542418969843466240000*cM*mem + 7386799175745465501941041057\
25007930415145878335464351955533820329870951288704603367518381610900169874455\
14055228886441695007491327856884713069573114163325939887320761509776576088173\
12160327934703852287532685912946916042659320032925922684565512270209783492061\
99677598070745400606565254426751463808394133361167970859881159474790112981454\
54433483879951777908781743051499149178854843004341565086025452543523456095266\
85791782570995811416885943680058534871628493559224252999021890181750561587591\
64812857116278281399013278781056920054072821623871282741376232642360078049247\
36571450826*tailpot - 6330884040994152552544930210788255610730853514514108254\
10262179639632571791772869226026640626422746694363662101236920278588921434143\
60516378455800930795747374487445235424055415140514952019652405639525663504428\
66341148476823698640064322747900907767933073794834171281769063648068632833443\
01411446039218508681820033825647328207350672801113842369374250637942596180394\
42016732157180920548357180094906486390865096992500464843050094120786366207299\
15658408909168031640583314407298887347979464112928382120126030581699758020989\
78266080980769028945722843330534576629580111228137340193547518359375*Pi^2*
     tailpot - 21526932639778643895693283702008982592445702270931294496604852\
44470016124597876973046830549287901813929329658896169404971817001508484746253\
48883747777836628928975866354184215976765544564826069339833155808273498685592\
64161889124692021259863640188709631050859732467982784082523062505028001856403\
24133188483563728914418097663007004698655857058502625446744748170171842043452\
51504292627867794802485227567427024242188764108846865028974359723544964383986\
54283298078034358159837428815967117817191949966764544909198332996551776389950\
483996385938907706597338357205774565006613040128000*tailpot*Log[2] - 
    2152693263977864389569328370200898259244570227093129449660485244470016124\
59787697304683054928790181392932965889616940497181700150848474625348883747777\
83662892897586635418421597676554456482606933983315580827349868559264161889124\
69202125986364018870963105085973246798278408252306250502800185640324133188483\
56372891441809766300700469865585705850262544674474817017184204345251504292627\
86779480248522756742702424218876410884686502897435972354496438398654283298078\
03435815983742881596711781719194996676454490919833299655177638995048399638593\
8907706597338357205774565006613040128000*tailpot*Log[v]))/7522402738029026556\
65855749178077769635641414502806249526699698487109593991983062023801050942471\
08379966529325427634301487180057960688304273287940545200919416569285795402009\
60524906050393754387582819089788573519306437775630583227438487607424804136924\
00576640156667953845248127070281856618131726519731630711178243118691922348289\
07962649248324356076565043050004371108950146950784599994923440025852447583317\
58116443502838418687062099981266115169808356852844728328745389443952511080428\
05473803668656779689205204270650450373294087927047666216004887400970812594847\
744000000000 + (v^354*(311938764297338716162058667234956090287190958158336042\
72741089608273317143588854465944364502256221995793011898381713495757109959958\
66224358023603511550237911666563378127175250311552723773181885088066049022913\
39939315204846359781811142433225508626823678892586211524278802269466754845083\
69870266990475750389286804013878580407010924358360408283994278045736056365527\
44020506455166855892977874996784314499742994251327726310221364357131680681106\
32677146782815073322456403092105958391993942173785002694954636636338899450927\
83616891134145270090017813744946800555770609414444019059712327680*mem - 
    3131*(-631382731653700923365813487122579002641196022258458915967082213746\
48190917760368350682722779036033930806079326330455849381321823139567824714071\
02326174751298542117341786312280256661374196228524240688622379866440441793316\
47419399002583132813959085696673563199779440481203170335448830377922024862335\
25170446221031514543952663645295446877732289760080636199189532099042543637365\
08359836631703982453410546663149735698126499986421200004134211206102060743366\
44989530993395962067210699456307110534861691834321756003018119494822881977995\
9156430139471959408943808873758720000*cM*mem + 
      tailpot*(-1349939066572747506905118057077907514512820059709900573123835\
76464491353247872043551674446678442837680891990999684774829092377348918486917\
26835774934547430092048727478414382992455565356196913552142823780020214236130\
27499884028860266819003480092256500865115289563290490227747354149185347662432\
52103374160678441752026386336629307663488270867045198282480616949905051494283\
28559375274259229173578340376826853105090371223857763295315867418651769030116\
15535447141688459508513293838135482091598936221394984208549723951832627933999\
42518095803513090927602183536009856222766067723 + 100945401631052672310627024\
41020944239066115709432993689292895723649663018264079680859329196752587894217\
76557569578047228498953194936533023876428054612427801340363383091471538527672\
30087371843902085485011534910188474924261045078953097073585089900616035490872\
35300652582522333258107697192623028698145266557496349686675910821358298200466\
89791285005353421050563504170350299237770029787441506788871996386813151718367\
77634547422645242273506861812927602495824630779474841098928414039312244664758\
04616823807217153078348103629957896110685658749621742690312165040843967540941\
83233593750*Pi^2 + 3961313337299207880718569701803572877979277144941568307869\
75818070043338146568089979739252598919404761527252430967835926999365639404940\
72507854784452500577169902473124283204596483062921202030922117059023192434320\
50693791497939254590602393508444229604931592308568292322025431278645117885110\
38952758602616629621304524638408673801731564739943318471588185391031786062152\
03096713774421110061366593204422657607443687899148984533300030676345557386241\
31363962552954473233817644558371979500666940387113717733459207347925787994105\
8436749491331204785001980344400433870427648000*Log[2])) - 
    1240287205908381987452984173634698668095311674081205037194021286377305691\
73690468972656359988721665630834182736136029428743501381697686941022093330120\
77930711896464335213071359158847000628355881714851180161551185750722261180047\
80612317609407493888289304081551812732326026162533343786409828062961087184792\
66734430446664285755767322152920076253013454260845932052216059800895810827712\
49560213880332304734096890618681223547057376239604763794017632155300566753300\
45569508304511226266781658819035205305022346077820635564220954539654626573580\
02181841200458317758448308965888000*tailpot*Log[v]))/435327591534021861086421\
81797973620724444714918873192474095075877540119560643777846885453453101745603\
72757273904175628370233184165812716780605248143033564268430077727957122138591\
87149422087808600923951368562268187241285173723363650866573474224577557929021\
42772513751293137763046220371489255225340457775371213024972339211086599187472\
11547638736954561669633832304132880084739318085015794302426669136003170409175\
48177619334563946988401604147129017682824684877680117828230384831928511874401\
30923193279636949660352548078131773436982174688821827611752461678673920000000\
00 + (v^352*(2676735010304375518081878898700525886928410047213362335461325480\
71484131842448834732667587454687638888175480827383054349631637564927508003824\
30487676485078262360249749848503833582562065491512591756293238461951658590705\
82621221215952486320751875361960113181573866003781373479078149298302686072463\
70108329657001158108070566740905636928270717443445743130954810677153928309805\
99547639392802703780194467978439698411965362687393642878564796353749989232623\
18636182378061612116412098891512044221632087133844522750729177424395798454463\
118824000123148960860640915225995081893869229441024*mem + 
    1962362043344568462579167282936567062050234664393772926736554657319419155\
15286829643637846328648649698842817743635890226742704619076951629553355615031\
52246079981910913100815688467392876742945876911473913313943493837058126507809\
48822918617233775850494484130038025192361238681439465656670537701851658023161\
00957060452297155048995131587403307685387968615783418393899567797297252575861\
66605577545633922816184357319946522320601158446381079314653707732617096371072\
27979508047623216605951149392173110250756089173634195373616634239667388592836\
562433691251994632818524160000*cM*mem + 4157173884184769356966685853522778337\
34386680177795549589453221693377932367083924736656201769646763884399063275402\
46238871202939975204763731113346563059392325463311248848346754646937892733215\
55748419959327487623568318573124967950169172778384403142902088295530106763237\
12041587503624208924891693341493130916106413837122765473311898257993609716591\
69670527292081062776328088443964441729893655548315193482949383236573058502887\
70521429293635426775841289014995553248230371996286981967520883951191575575812\
6675368868941594680046253843587961356617976009083293939945182416399831*
     tailpot - 27120996375201067571258384809870397911867061606494319164963192\
74128636932405729621522409144398213479753919897455845363173956125596762696572\
90917878740306884451914287852830609413087797154669436597460449986833114958305\
65129078604735767157725523106332396358118313058717909831094487907806581721570\
76159839660452290943901286160357897111230906767087464614596202839771528290482\
80179477800415335532184897502381143966712452284611160286624294038851524318500\
25034932931591593559456459254038964484166897507681515889952313193636250491041\
4244722158915726073009075993321045813177056396484375*Pi^2*tailpot - 
    1228396117354794513596847045706085759021765144575379094132721077299677787\
73245103325408484028805170761577473409484884615433189769408032179305582022029\
98583128346935326514805705409136388060441498943681002845173258281587912800140\
63147641359215179176769144077499421669647210471687353802748322736032913456578\
08974466613774531124205711426080263612025858653372370258774535078491778589580\
38199515435253064030519039209446627718704865611184977167605069118431351895909\
98985800429445188511088635845316924847653768920112142843059960604731463848006\
9362942484024955343800780288000*tailpot*Log[2] - 1228396117354794513596847045\
70608575902176514457537909413272107729967778773245103325408484028805170761577\
47340948488461543318976940803217930558202202998583128346935326514805705409136\
38806044149894368100284517325828158791280014063147641359215179176769144077499\
42166964721047168735380274832273603291345657808974466613774531124205711426080\
26361202585865337237025877453507849177858958038199515435253064030519039209446\
62771870486561118497716760506911843135189590998985800429445188511088635845316\
9248476537689201121428430599606047314638480069362942484024955343800780288000*
     tailpot*Log[v]))/4330755984222262844075028034020455702789963680747432597\
90042537579985272191044347859982624881632964621245252079603623992263547967152\
08085760099961629860368766713865180631935322243051076610406745018299976975951\
86900530095241975364612679799783372239931645656861571204864020867792103101023\
60278803625723988969488907404886700025857416157137648103556959975092900149635\
18504623351751741104201178140361480333967460957837009484138872561520255088253\
98106673544417804219238243437970870757181400729299959538364201120210161965592\
09843185258403191621842536335671296000000000 + 
 (v^350*(10717428343744858968086344466043050181886774985925469989417103618045\
00974234237609656097999282952257539584609032557085554974989693799473272238170\
91616902014150255650732799726019381882413726526391236317380279672565181972172\
64943602070730110986677444162536495947043174765026211966596932963714072585418\
22832851489822344771980607280317168984923519598583541527532474246572534883102\
38408559121223825292369426311582171654799679190063663366586706858494039323116\
21585438293674690948664665382400862671914112444715005413016342044373998449296\
07308261790441033019276201312775240004141056*mem - 
    122303*(-7432685199474391603927051268656686343594262384672615446977976828\
67293435178580804537715363252762619858235035879254962541871988256198682037755\
67466187936086324880936438920347987848310681516892027369856496122899483419728\
36083927016390345027368674041415229653854166758283026215428963886502816514310\
11417611178615810579393698696257450222460914242040349681334072119701853892004\
36170617337666263920326969955483690919109757255095850782649265786563390860246\
68824626882230349916010917353750751389697274699837840725146876355484564321275\
872381013937958220915015680000*cM*mem + 
      tailpot*(-1560057510985141249873423856363884264697673608451228987034577\
58430364368168950996566348999745806740797483424583250588372137159720279352072\
03284001559998251218652491669931029378537542341140398519190137636906195034718\
68838394615727317214319285015498013948087214152625475915596500524233522311732\
98609353194681945185071887839617911214974732413925416072498523089380400385814\
61927549522967409000625503838208539439413549038801282834967905739754499815866\
40797972745209647555196916058232488565087556229160804269134034077910199209515\
76385288615428257676243462330802740507 + 887878911161250316457563941629495306\
61509719772934511120575667350008278410250544414821534485574416233785242349619\
05651753554982406839881803872224043763808636261810479010118910272762819851706\
76516502297249628217813696098313492450571442045062879037899622895423799662803\
49987582276612592110870369867520129270904631958830407760793156803963181853122\
03259436832806306001665191248247784991538605088563594145823796879795670412549\
69961912932506661544202524795612945410219346902838595856535124216771473154262\
029892771131630881159427003059294913554207563595389728111912590468750*Pi^2 + 
        464207643412794696536846786213492990690584145097644509306512102831257\
07621054491063878262382200983238980977315816355978231520041757386743293391934\
92490317073071130370644407673844642114663430312661972240198874701209428729524\
34093263101553822685347859232570350533439231185629156610765095243531793938990\
17962734163568991124990940719144277541819494701158997055128108207988058672181\
47421479094105740970522090662858419421882361706979457037896248525694851770257\
07954941299346328211563288672275081008081265462469558655179339056055822405504\
47998912788477691855360000*Log[2])) - 567739874123150297705459724942688332404\
30512697877216421714349712571234191778274205855031241303268530770904686562877\
85205649595667053670865011713817120432489878184577209229917342212645496815175\
29497190893042972582016761907015469083571093371758860992277210515812912182916\
96002740966403443569668994120315938962764069783215597670227735025761971496604\
35848816833333018161563539783810840891576464144379177632543395732705544784838\
48708534105824883438057456057751600131857339539792588248944852592325313630098\
5641443220439870457279524766041441611030769187146986094080000*tailpot*
     Log[v]))/201056452378006631572656826091943161689413355652155645213575922\
73908322757244398693592508118924464467095879855134801485249004083897496790046\
47166278080797064378545273009839151450466623798069022517098420472421163834972\
18906312691021944280398485247907690141915578978870195954865000143965812571403\
72596285467478593658536987002128942254277513839533749302464851446129767179490\
87825057618579441882096633255987347305377762742996233637953586587198420662336\
83584856277587662183749808298847790191703804992496016765097964808059057494514\
976046049963715197927424000000000 + 
 (v^348*(13745103209337356232172802608633929236251693053294644980069713682663\
06196305403973612477517494305255443820298100380536136692184489194474768034635\
81301366361246694106043744919225044749228556756709524102909971271799365636094\
20572824877096290040574926931431869898551660191986128132594297145630344245790\
04651433245361082525332891369522626518378395386593708932746678820084470235499\
26770968078594329334112217163982762730559823633831833900269084253942707236842\
47505880923327241370396951589673051673349478649849464438211934709237311318580\
440619186048679942589441850308905012297728*mem - 
    649*(-2078574751192669324050823901436463364804141145419808544864138552083\
02307335707836823493204762875871793069730600389882805785703198394007628010420\
03869003287003200682201539515120147404969444382531992845313236633224150955692\
61097856884943138627739077308163987397848599257116610416464300150594120401813\
97520797379721136375676893117080552561326897270558953607239894934582774852966\
82779184253335115462047771509681283547878630703517713463045089261594030597894\
83622180585265385538641390214463383350572872801656557822652621399889577459732\
1265945179380839119585280000*cM*mem + 
      tailpot*(-4322294108536203928544112437861235619509107135783705847833535\
75009387682533829108041560855764946554204687035196547352914722158092520188080\
04855119890672600857287830353062663548039978466652853127778053139707432662151\
95764283146506854692798251970451274136327788438459637257609487794135323748253\
85364357485506829939831085835710708856446357023351311584775503474094264513299\
50817683655355112105491616190926197715526043215580001703744166164763945040456\
26918446317924412988251589691602367765477705379798919529428963346133800535985\
45950752257715075751607579943563478266 + 214587080873887652028749901115887604\
72861869279225602388177097199471306637500395574157502244386804676166103698362\
30393206058904506522106856530211888923780835392653849153590773308241731720527\
11040462134832494810289922612935331719290872212002896055051667962721431246515\
91799468601600671083668051571905104849458702179960640673852063610369403502693\
58978432107829824145885656173488240528361063735339537161801619080768356405573\
00616103099502972910399372216212281783147698556617917487241645982899000219930\
0070353809137165203109701256452545704128464160986492870909513496328125*Pi^2 + 
        129519101885377567529598320889495970548888301232575259312199958398827\
68754812031161721416215038335769626740081666152097172024626010076241486442585\
85709537191125695626790641073611269566236916148636385798441128968795569334063\
15241098858499862500649913680950912183103371477418709263325019251786635562355\
13125621250931666787496814451406410019263354134648669179863747282906672064437\
19681624897719842912508971742083086020802057760516777172712577505790072313540\
73815718121788996926362035776036161177938785170908767655205729631494425286135\
646731251867582347964416000*Log[2])) - 84057897123610041326709310257282884886\
22850749994134329361777300083916921873008223957199123559879914487754313001332\
71106464398228053948072470123822125489637040576461787126056773713948487758580\
46501438318829270074832449780698591473159166410762921793978937142006834088088\
84474231189793749440952647996848018528191854651745085432578962760102501916833\
38698629773157198660643016981974073374558620178050218322660611922827500535486\
57538838509046280125775693148793906401061041059005208961218647468604482271575\
919790208228518530839882010702034728582462060943828905984000*tailpot*Log[v]))/
  299021635972956038457917375915779489764708248491166327867216315688438227976\
01442816249480913414571799505203750554591444067215705513274262816990433314232\
81752970924272889987406548144412164266959834211531864082467459944473819098095\
93543193227208938106338029761130209367855173666076701365585269084861559486414\
34169038900618062656358876758342112621015251541209657841721725871702780601976\
03985801985077788649737493833783116354171841149101864813515149367815355511210\
58137808693057668258044902675630654562064593984225281107663412522273156306603\
2591470592000000000 + 
 (v^346*(83931994981688547336627527963713825752446655149626994949921202779815\
08934702983727859233268302539223802426031221156828371342750469969199285317999\
72918247425687617657588208586055121283186818884559789422363039270047861555109\
10194374658934723846579189693497304342272671538955410272354538457745430599890\
52886788980447341083767382139471788891312728628818758558619214528288805474457\
71002057833320200147432405314575446060003018266825166681296550214570895140408\
70365867956115351206212563799341721858296243068148720143532311235353118651677\
39304156221013050451332035907959128064*mem + 95326126142884181239715488360594\
50776266662986373051175209243682437678253699872377373080587688123365440905468\
27648705385345218985792272402274922800326788866057877995081595132330289212005\
25428759070899554560617921360930566447915761279940048862563455804214551513333\
80609578230817692330389026322693009147794716891424157049465228675359003807694\
84587162099603624801130426185573868202262968927496249451963690278208925186784\
42787155696867279675086205359557703363679403138622887906513960673783271441769\
46474538236432734860337196103327443553315031600554427023360000*cM*mem + 
    1963776906012931962126619815007516364714182336168883329719296040716141478\
13480419643096259545631368666222346741467875839811781563413189198788055033473\
43954382081579866861979756756009870243632591840103947111010329804001075933170\
36972849470024345670880814130026489307596937671842141857430837791368230233356\
21426359882452242816463828026528193498686697520176389649497684363918549160908\
54672010717505573386729958830892033590578555993230198356587193167014009016069\
50705790520585680368631019222806646096608352750717599560018525665666216529027\
37347463997966662440770153*tailpot - 8504089275930766854475517916979573751612\
33636882130259341494995904582078107110126430544638205384800348593142595308924\
44031990506151686092084982056687199052928523402801573512580733596992256575759\
65962928612451582111110227968724078596028304778116559743102110495378164890639\
51903414285928842962533471417571559142016260818703252819489146444462971424986\
94601553080074702159806498928029719985292638603380510750462949856998503318969\
09773619055934805705033125039445352512488978923639563076160546956634635377334\
76597650487076784718452342303819644089448454282826780829323125000*Pi^2*
     tailpot - 59261967720925340031410556095855040114828063074709698298257051\
89153078723660997541738706546964306383408937677206159200453439754340165319656\
69995006681543722232646305977151623370106075739282797649560989737964513209419\
26392105361726896326490468282815038956076789851635703897419062607120058859100\
63189224098814101470844988998268529815898095785895936452692307853730048638362\
48773200113760896621869020021123562868038879016003550824501602919855721411354\
02945182063141187274968887012288540856199915307292913945656675520812428883325\
987423468723633019262634223616000*tailpot*Log[2] - 
    5926196772092534003141055609585504011482806307470969829825705189153078723\
66099754173870654696430638340893767720615920045343975434016531965669995006681\
54372223264630597715162337010607573928279764956098973796451320941926392105361\
72689632649046828281503895607678985163570389741906260712005885910063189224098\
81410147084498899826852981589809578589593645269230785373004863836248773200113\
76089662186902002112356286803887901600355082450160291985572141135402945182063\
14118727496888701228854085619991530729291394565667552081242888332598742346872\
3633019262634223616000*tailpot*Log[v]))/2117716968646997439503664135380874573\
40444935192044141549020053603709793184146195582503405902369488665051018063417\
78643107093275859259392929879910279201712131522126578540987298499606318443816\
99599299951745100897634521582024857008452855476113377748628456301424434910537\
21794381074151108771437028938781505959165503108361317724195176181008088616296\
14200808222137281672610390724348868254985735141537378106584543157463053231970\
05553221743530321186366407801243279894179446237202957990496068715833078290099\
607606120575645238409437126580427100589654016000000000 + 
 (v^344*((4894421035592292603409463208457756448233469586510320230991249536012\
09282416605939957629359114279407769393250875076107247224141612012646141585135\
23727731781932325279409356818744689159230895171607014735989939933642949702997\
29321703692566714393734046751624962449635698183178833793764964137544805967808\
38801407842530462405254031440624834316572089816184262512432593393751556716503\
82475501592691332710581184000060245303178053364647554086613549430040080977603\
76259394228892445817978748828005422115144085202286088100407338843755604694119\
913938918381473780435370924572672*mem)/3 - 
    13*(-16496642801805139443929067250591274774642064017675101750369766645324\
19385534324158302538123677765547477703631951291752562568551883787697041806180\
73257981596127502521982702721437896794724786947454014470830719970005944624381\
48672626671550387340115741922969335664126599516071661891306087817620649640253\
14005564073872771004463510644818664834001494898521420772864123311485391206070\
20884265282496833022886778277786456516932530371904674060359867192652224899184\
66683543748719730426329830248340463651601731955955266944896773848135127240330\
3900756741980160000*cM*mem + tailpot*(-33665479182671716859554637060646260728\
30855066463920933652383379934468222753402915182347697193344790545911010118864\
79562369944102077516831914211042490959472209884921350829203973600082138270332\
92407420461383355745051594169286859334893931080868388336923218088201748396848\
39922269784602648310474203979391956545541046159056621098059514342211137876718\
88593742603681920805690930642788702513305341914450930114783355099915368729689\
15464912117244849148548507042788596895944713213719543391643758765930594512922\
97170228020997738253917100980764567797928272522712581 + 
        127156037402532722251473253871651774802420705717602172017304321160499\
29642953621200081065851514953668660699222388776075073628127601992860368264384\
96660740926153493100419392937910135642397412116811366488007740816093590447669\
23353638424635524144186994127596168478034378023725006652894040699135770308193\
53879049814546060156902502025976912002442469638588864993676450057629381684272\
79151761858401916760736951591928401378665404795847527989017286136571273721101\
58197036300712376535375906601676350569269406793802066480487248440864998134930\
36913263961971149003949687500*Pi^2 + 1023174935023268744232255451597361125070\
41425212453703764892652741054140472899361841403674383590250216164964698358600\
12862976859574288204680803308384334095546330188574924155451039687215898324545\
40350930833790257205908288756822293743610659672854721408734523281025753014257\
61527145813066611520946825029009291926105226975514363593362541466849665137975\
08116299928658134956386262232754937067007033515065803346073651519509674962225\
36473912252505748314483998856234862101498828719096002977175509728621197287244\
164685609651049331921277797286493122307672064000*Log[2])) - 
    1330127415530249367501932087076569462591538527761898148943604485633703826\
14769170393824776698667325281014454107866180167218699174465746660850443008996\
34324210229245147401402086351593380667821909024562100839273343676807753838689\
81866693857574711137831354880265333478918534899852895569865949772308725377120\
79503936795068168672671371303906904564679367605511899072555754433021409025814\
18187109143569585544349895746975362577450892974160859282574728088291985131053\
20731948477334824803870328162647207556473417414091292546364131497661136472441\
0589999736832000*tailpot*Log[v]))/4774911024725073210439973140085650023504471\
50120097038683797435551979064209144242289682842886617659036274823754316227106\
61003821023914256862946496440663941427871454703850534100531863416686321266826\
03093115319586683932558839494216699124789549749472228436978138074498876726669\
50480736608781592420041752247662879379071192475205013055379703709903416077971\
05949859172419896567476726228576511457127692904919637615538669892827409342426\
75785598858346943891583857290658636723290526911257976314168529262279338529180\
72629754972029765589209970638848000000000 + 
 (v^342*((1741855020907121775555399362044622707507036496156624370166602947368\
55829395327829407635572954266227965750568935389364240961450228891012363995760\
69000068167238179493350783142006907544228142469930089315765234577157725226024\
67119860916425936443602550403747407271988257448687261068573787269836803576106\
19696507337946662274148686884044338306685549029986623857043472593589820068843\
70320793037032409228697536211630418330352692256367711837778798252529139657532\
24280669457250617245027367929559172398509135835715454213022937711069828687926\
6257789124831643306494525440*mem)/3 + 883439605709043052698817442750645263331\
33175441434269959052789450880447625228550308609004097737140139265112656214447\
25918906930215235346205982443803248291430455640311388185147019132597170758412\
17972497616284164267298411223533985103502559785036050360630509323097376123308\
07202984916773009458374608761467327286109395778883304349702043850188675143293\
14219427867699419395067413096693935031880478870914528796973721917823787652487\
19938496143005980213125347326071657549552014250729942096143401629642318988046\
1262491493128444954680395575323818721280000*cM*mem + 
    1785880340330640373198782731240248725819291820291875457048524625216932186\
43425822670764554005478558141320122751064764296986001253899566923110228343220\
03361366112280879836053756137331416903283941677664536441344903861895429767804\
93127005055739544358375143002603363013541851369529513387591485829799721497687\
58691212651364805421373440029242458209179630579207494547128069605337767586072\
43801555107465862572654733673653660650184762301964334854421344113149985662178\
69405776426964168332864283499890947002955912063041429589251308706177743669818\
13476104792213*tailpot - 5882893929291006517816043585944232656483777390109449\
68420658155645615596597482048351118226691152456154608344205048140215146191345\
22203659701542085597208712567486953973086185339023811294416254282228732048709\
06733678054402735133369584568157463167205097744804916531181580281950150822652\
00116950002052670792670194136613555755423790871079377147307654775829960515778\
32414260688221626223663242899299737104464927601337790662028912640501777370302\
50010639274505537287461203356247349725158868656874635913919070172322199391908\
80505579400425156242321931135363975625000*Pi^2*tailpot - 
    5466578287675854832951499494840721700667481280468379920977153226187715463\
69423528084887232133994916757306809419420762355917732690300961114908134871441\
09407673672341737646162655345133699148631284871878249186254846511137949192404\
81157518719399272574874638651193346928477947507870051556060568162762996961667\
88862388533299361426750917709449550515883405429877489458862265708717589463120\
50009051888744269333754047010535323553790451713784142609271156971284282851269\
25006723546272515137708091770993653379253561025139679044158979835854140295842\
5552896000*tailpot*Log[2] - 5466578287675854832951499494840721700667481280468\
37992097715322618771546369423528084887232133994916757306809419420762355917732\
69030096111490813487144109407673672341737646162655345133699148631284871878249\
18625484651113794919240481157518719399272574874638651193346928477947507870051\
55606056816276299696166788862388533299361426750917709449550515883405429877489\
45886226570871758946312050009051888744269333754047010535323553790451713784142\
60927115697128428285126925006723546272515137708091770993653379253561025139679\
0441589798358541402958425552896000*tailpot*Log[v]))/1971425573571700622792157\
56012883661986262582314268448627943748524800815920804704379611918320197542189\
81975002861870767305931240771869506479173305550095349177093653627016066530363\
35326816277105720999105354664866553236731889174593816472254836688386013739122\
12665024767211657411658149099849546427438524333692344276802057948690376396695\
25268156173508417258841589049164717871347830453653712730951212152019205806436\
94619160029451889166984136998400924787818574804364316624398457061863858167910\
179459748866059957526360845610883981359710208000000000 + 
 (v^340*(15495393140883841962951823360708012639079180941108649584600351023836\
29597296482871126047602547714178954439004843336423790647880544496323294103632\
35118306046899114455074119284612888457951286291623090820632854492805116047168\
24339245263533389328727849183169775977853278383744371443333991042894852008180\
13164498910654108082396551095853843084140741549501573549655482785902504295208\
89087494106467468758280811918597094722835505604805737657686799013029351634115\
43940133711396117238243907392851850524493661602036705117912510042174877040665\
54171175217280319488*mem + 27294127147720707112565150319244972393814982062613\
92294688073785021399010138308063085715306072874710008637778891634794690297507\
65411183177862363513002968106791870790424678632173128435608607845259900943376\
77748861950564348392275079256060636323617981565509872707166583326937910842888\
39127493590992566930456627715508170715851075085210217982255320371989571497612\
82769908090822834870231423920033396560706644431873130448057334940130648252841\
30928497060706705474871806465690143847597904821997343227923211629555431189654\
97624862074652407627776000*cM*mem + 54652236716570991556447358765859988292488\
96603719504622348977841988557633702883950818882317262985459653229360184828973\
85586833230200240098481545541480228875651000614269751844734367870260058075862\
63695086113380169398834177469927900810239727768019036852254634531176224517303\
00131971626000088770506358698173238657936326013730594306978176065786791035040\
04384018613653945193722213883676688273311826874031905190923790424883357403288\
92559339044112963607305419700065374739499859760543147225279580771515976838255\
547756196843447034042038792771794848142*tailpot - 157001162939809132639724896\
43374175993903070427418697688781178151488422373204850142694054008005110007752\
92912117477473316131099216425777855694012602676964358762278702432069343065633\
69153541377046673379730303219335670830744278433449363528856877863442346814736\
08837229947953902494270911193469236149024164458311553317568545828989202239571\
83169792260912551634727964507559526131488338226836683120678271534419638175498\
15863241242086644070731936440824009373740108295556250458717719345590804986170\
143971612783948244508730881777238118094706327223318937765625*Pi^2*tailpot - 
    1684947684568255208493203313326573643267667392529290981476484813770397311\
13712319010829493757959669169988699055241323428083811945968150351018965566767\
94786498771136249998240414736810684389993756400643185318984983527673819764706\
64475158958500479035823696504949652729383645341309992752945827240309508264837\
83894077153846773464224781310969137598077049943741381098718740454004975418117\
27603390869987303798606611477962707461519647099749385639715917818466954151640\
10183908910764578339742248257125498773346920098227396994142264130234532587745\
2800*tailpot*Log[2] - 1684947684568255208493203313326573643267667392529290981\
47648481377039731113712319010829493757959669169988699055241323428083811945968\
15035101896556676794786498771136249998240414736810684389993756400643185318984\
98352767381976470664475158958500479035823696504949652729383645341309992752945\
82724030950826483783894077153846773464224781310969137598077049943741381098718\
74045400497541811727603390869987303798606611477962707461519647099749385639715\
91781846695415164010183908910764578339742248257125498773346920098227396994142\
2641302345325877452800*tailpot*Log[v]))/6104593528561536324839674368498829363\
83479091086518651358586539530815140585301471824434319299060125027310688097999\
35077906610201972296845905468812343920100587187106100848244460387087649034616\
37163197150425665135937704057359772034393673943368522206346268637420161704309\
91565273955277015793001909857283676990901165130275309107876342953682035834377\
81528715767535844997805188603390668440437265028154191119973720005737445398631\
28563599737837827306894093721588661194344765607965105727742607254298385719798\
62170278511116243265231257600000000 + 
 (v^338*(19633237852888255161493733559312836824426052969177672349241153980693\
19776914731647001079563127783588489634556944814119688907000946089213108690231\
17111045384970936482287752057519278943490146297655198301836469259981047882225\
71465759827574205868506494288870233666721632464624125236944986701886595926932\
99032103870676074479957979134285014174342997731717551412862256562212674813271\
86393561101333777530470090631181124284423683287073759800597738078760768371558\
88581388915094875993253469636662408875328945959968997230054520990883963954494\
818939792523264*mem - 19*(-21073617425999888671311331701842261497570173341217\
00580204033586825110541344104833066634711551979477858478463962121489616597963\
49084119550134996082243849596974885461832432786589864198971676118165370770246\
91479871049027788700735157437043908649341895523785068360189590118714168650484\
17695135105457152175760460046940927872419140835392407568047632397906195456384\
29088400527654221128981828500071465970832530579745951172015638346623510149563\
32202369330912609050883035400207797023246597138144039574169078097878503667543\
27884849953636352000*cM*mem + tailpot*(-4179436938489149713679351663996013529\
83487989428091710215093873451709596756723285227188404162238948056866117651590\
08738537054146289411563474579288675071634258557650692020717913900475919336779\
41985295990579924367395383832513390047679664354539204450767507378221458229594\
54526489046634065661160232994514508904008884072867030703827695463665231210165\
61806069212531985127220138108822008362698287813625822387632732369917660887147\
20560202862479227397237373056753026626682941700826499607825107227505808499086\
9517782333430211041545140532090305223 + 1046980514960136259821608924565172378\
13153640069927944435988002368577192247013768628276662511304046994175122607710\
79582199695008567909628243372086649826781365287560407236355211623760125284288\
94308176220580617889665937408274092165462564161339373862746811921381217351059\
55856807199699508467885874413562392865085812178360790968778957091298676030201\
78942094623838094166348850232834458587681384076193415169525956558867518359825\
59966312843610032206360606621241091905300313203289019218277293389546559750681\
29770848418764661741862362525601688551156250*Pi^2 + 1297863016180941315952462\
47409030982896961818237055164824940706300983529256729669814808346494811335673\
83593689131962843585463927054900346596044857777743856487445630240948456974476\
02943887380137204110098938204652882145880191178903120053500462282726299024065\
25331960800249744211246556968030778566966927551651294551303137592977373912968\
27010632964982101254876487582984930619829562689901189022498676482123563204894\
31955386075391256725068923130144918203332324949291792947607802797029084138781\
4995481348351777475680747013448593899922329600*Log[2])) - 
    2465939730743788500309678700771588675042274546504048131673873419718687055\
87786372648135858340141537780288280093507294028123814614043106585324852297777\
13327326146697457802068251504455933860222606878091879825888404760771723632399\
15928101650878337179968145723981307255204745140013684582392584792772371623481\
37459647475961426657010434639713202026334659923842653264076713681776761691108\
12259142747485316034770089299207152335432433877776309539472753445863314174036\
5440660045482531435525986368484914145618683772037934193255523284098524262400*
     tailpot*Log[v]))/8975759466802235377344695595628461688870774144070438324\
98068781289794654745194189002579426129300895470373887105215771891822181408755\
76142306458878350761778196769843705299424308044297549012845338516690443240386\
04860471765805699044865132540387758346095201784126568406031164577926766997232\
73836837407051221829825861804204124430800951234608651170937210032285001703302\
32613639656811545669054380150788377227509439519110517847778753214134826763325\
69096767808017204602635954843211647544172509636973454272479300274635521911475\
404800000000 + (v^336*(181246193761806147948205789874426516654392624330933469\
49592365379156577209299183994155089820041752411957020334877544629090960660150\
23787797782282715062941281313154912096981558981442187420010062916459180821287\
40436105947152218213513168383797307484748263074426301979324194565557778636105\
35126996520527429874389448017254359549603076283850167294353907649869834965046\
83144055342171886536672634048158588954936913378398455171165720264228727392216\
56498730233531336608079303155806934600510402441960648255035352380081748407992\
3019151093778181041227300864*mem - 
    37*(-11567943995726741419195085606895467395020361154980386269173392513079\
76039891188883863275094796600475318821150731014103149062390398713294240332459\
91203114441635299955104490153784604251116983290410918204089347231303208729944\
52978595197326482187475689183468390671545700296171166292919824359556263498893\
18635384740914000263183499397211458576928359474636827595066279627259990682862\
32310288376091419638985945815184345349403912381026234556339886185550453863795\
57695730194016934237380096377054869661606621199283368212082862963737126502400\
0*cM*mem + tailpot*(-22722246459024419680114302261056149739829813542872879695\
26127648426407510012614509591099351237330273874810353627112346127924940762418\
15422425930531694722855074856630402612884429557567773458661769519043501489946\
53111066454549743729734035398754330604727114769409437960673714719722504581809\
83134043145861815324560249437630883418293297455791846626945607527235157819982\
18235983065673398254517591120002221433128254706441465478406563484885295112796\
86974628310236888364024804995729065948510017777255616884980490917124991536439\
69214433323026807 + 496326479303457677446019921328847578623369047208000523237\
63349462085924075606412449229221958052232880179553995053112641335655366147495\
17684267948958153861038563642467649573228598546043113451068345510826450021854\
12560022488201473741679917292761991761953836914888211404280035526026149107471\
50477366525430561332282084095890552919633549451059533950842354257635229377921\
76236922122984498383984719500930337702463239230045809489412403433498832403588\
28426584478058517036907371900805443532808717214808090284636786666505950736263\
3187974408241751640625*Pi^2 + 71074281576328269014422853511904541375919799569\
30573948718715477027037628253897919275403434299092818833872033685491873796442\
86719524071260951595529368693784431094414179013306277787835245989834315858945\
80177310458009699235109151880224539219692615797812589095602289381333412207318\
90865924307649659575035306434753922059516594683847602047293453849666186875249\
79503179811911861931947284326823219201516492207536706180609427963991133936521\
79293716136074923661965391257186859538414996678704350162434141555223689450280\
1644526180961137971200*Log[2])) - 2629748418324145953533645579940468030909032\
58406431236102592472650000392245394223013189927069066434296853265246363199330\
46838608622390636655209034586641670023950493324623492332278149904101623869686\
78099466560486946358871699038619568307951128626784519065796537284707109336251\
67079962039199383037404276306338085895116202114003302361275749857792437648914\
38424241617653040738891482049520092459110456110211678858128682548834667671955\
65130633867497034772175492719476515913802921354877112060956010063237543276509\
6603660847468695562104934400*tailpot*Log[v]))/9616885143002395047155030995316\
20895236154372578975534819359408524779987226993773931335099424250959432543450\
46987404131266662293795260152471205941090101905210824832541392240330047461659\
65662000555359690347184219493362606220391833784070578986883942244859054421323\
29217624776206439321132079110897221840594817670566218790133318715304894223554\
82600415360601964468210963514613918012370359701121590130404172331542341904126\
26547723558657302867499181175108365732719217109951617726765225899117468185843\
86337067886568091633372364800000000 + 
 (v^334*(78071223025253975900720066443016551773041717495376950591094144168954\
96220935237853383008586681900432788865844057992607976005229671420571548200672\
14329116432395865225549278084922896680799573840175903128060643341757339765315\
54613961837707778643582048786715786026405195844672478345133074773754697214706\
76347013588324112859393471610206007335551971444647042979399812182622839932735\
53793818017321489407668330838125315828826755070369748722243581319597919956140\
43327101055420017465858846199826477356597780843285355461459817867007910124305\
1980575735808*mem + 213512229258228497274736185664100427434833662841378396885\
19329311923092851324903805395463795993361865476794852990905079856966693007005\
81129671889181841608101892357387964583433289902527888810828257844910785370736\
27793595850309055739708580447367384676618769626871358423854503319293227572641\
17263478183349179347745841205552037266800348619208069626924630185156479478053\
66586024192998301923658596811926770430004918636132189727166859696930270912975\
83310559093680628252625949575405859812554492781176719893826182254066499373537\
1804114944000*cM*mem + 415346375052213006169062350831661237240884408855463903\
49497878751434840918612981871084464404873545886428826228838444565830453141706\
55124711813015146663801817952139780332483045415595294993744758741326678398711\
24997386427867278140683577403377490670282967812499863020472131763605233637584\
55406246305905245500880816401671694419687083943590982464670646739051589634942\
22031321349630513242221663319047690228026535112048654302985909145251809983272\
70463436386764215454126631953412291537996114144604270048297562567435331051050\
94153437174310703477*tailpot - 7910269146049300713366590602837570336576267925\
30047516581701759033591384959005781392463707579649441587913647674187611417801\
74665505297936381774425158722056060101573324237203588789172252777470601539656\
82067246001066088293281913446328144086895470869439164630286388632612690112268\
33022291389044267489870529780328155169216627975629309435882753999672640465206\
61647610264836073088585425904767615064936329789154471904684801693434541958626\
46225849500633054835214787204296201423078151272140204393525650956647897782679\
8863126017808520994069013862593750*Pi^2*tailpot - 130869819051351182533393113\
67702056640444578076201697988502259151571449717938483577913380733393332997399\
93483705815448419953593177144624481553060063593071713074543912823699963554594\
11411485434522782494981877588676204747767464469032200512142226564967869069695\
36086868342519040691952121170015218923530967310045949714434013625807774767426\
98840921159074394946797819675864340535452247699263204822160880088606420753155\
42036276794354807211235576673405452240041535780576496124598521830373110223125\
27052053369468404344448420195749442092339200*tailpot*Log[2] - 
    1308698190513511825333931136770205664044457807620169798850225915157144971\
79384835779133807333933329973999348370581544841995359317714462448155306006359\
30717130745439128236999635545941141148543452278249498187758867620474776746446\
90322005121422265649678690696953608686834251904069195212117001521892353096731\
00459497144340136258077747674269884092115907439494679781967586434053545224769\
92632048221608800886064207531554203627679435480721123557667340545224004153578\
057649612459852183037311022312527052053369468404344448420195749442092339200*
     tailpot*Log[v]))/4808442571501197523577515497658104476180771862894877674\
09679704262389993613496886965667549712125479716271725234937020656333311468976\
30076235602970545050952605412416270696120165023730829828310002776798451735921\
09746681303110195916892035289493441971122429527210661646088123881032196605660\
39555448610920297408835283109395066659357652447111777413002076803009822341054\
81757306959006185179850560795065202086165771170952063132738617793286514337495\
90587554182866359608554975808863382612949558734092921931685339432840458166861\
82400000000 + (v^332*(1662913748464820381041746826124850328403504695249565089\
96740374824626510351900365082649783917829330851741548769931925823416141158440\
98616802304985320101027584166485816877204065780783653460495636995293218761093\
56846026647857436530135764759043017305200979414018229610760847939469800057374\
63484584248161627304411342986439334756968960862968889326199892785534680620260\
91758594513974871572400491184815182839655455348834949908616825421320789110939\
86304525584466797348207227706168344249052470301868029934068207865993949692380\
84895649214862913961984*mem - 
    127*(-4147586998101733075507161100105061209026867205773793721733822246068\
50787886857980734581214038062866316934151877079075011901838972934979988191646\
32631909598119011830882349047848047579152016559547152913656969818004463494616\
40333950384607618246217126513042097668221386995194083896304461625686911114131\
79394392025956404981144431157567872964207105149301614843563908312656376419204\
38383950006317502821723292369034533892710776103373307173626101261060101392191\
79834241485545651663970033699913023577170716618383744999102926330789888000*cM*
       mem + tailpot*(-799008971343737306119238102304157780514558020177940591\
31004022188060175245303143942271303165327849511739458311068824837402544347894\
69333912786197577734615669697828362079093217032295635906862669628286722007782\
47600466115816403385518571384320465896783998201624059090441830058277823100323\
12626731783873709644078893141611803344553304262173897461411047009400066037213\
26104509922556957716569897930562768826920141915740525298980143001881609085625\
81177090911660800233913020722653838637636205068872439642464822532445650793776\
45200971993862 + 132668031156210480111129958068809039598081040661414031026051\
87112497689754014629578430085277067317435610398787022816657082658713056854954\
18418314050720657447038019301568150417279250917119291097806417699318701660455\
64382393838148723396134104903830814444735799938546479152092300831573102885090\
65827116945608901048723011921232754013417911296935802816597877421159852601246\
62264245390512665132980620571474186990054793196142473419808674300596456482602\
97380850060555717333757223239707983152334727874831051036718219453716565408683\
799028824484375*Pi^2 + 253610094101833760476896369692993823314189323849555274\
24923592426353805261560497913518485888386541559760495517905982531181759386001\
19449656306392113632494569820077458757275773866833191889879129707800568282630\
32948128691368363219623571487643280326791756287802301580147020419330296424053\
22506436895929265212831799906750207433863424602778850113537933287107444186182\
96863587588709334928049869409430645856930441149952030450436809123374470481513\
20827776508597931648151797405230599356569091680883995627436512857594506761214\
90603622400*Log[2])) - 322084819509328875805658389510102155609020441288935198\
29652962381469332682181832350168477078250907780895829307740597814600834420221\
51701063509117984313268103671498372621740232810878153700146494728906721718940\
51844123438037821288921935789306966015025530485508923006786715932549476458547\
59583174857830166820296385881572763441006549245529139644193175274626454116452\
37016756237660855358623334149976920238301660260439078672054747586685577511521\
77451276165919373193152782704642861182842746434722674446844371329145023586742\
9306660044800*tailpot*Log[v]))/1189031298590800574574064168560362135554097888\
94532088874797157334913450448441366707632925250278308535180940958194119845779\
75061052826428347082831489874122800547086120350178082350081807573766073881503\
07906427326841414763380364964612273810458318983957079507223210100417439139721\
11686589030552781555618273345409318276309363664529587647653753069486171316273\
44766099278377177784126158550902710384536400120219033425062330151517956922177\
67416852025367842280629663602511121614456820626347566452545232920792616081315\
64247449600000000 + 
 (v^330*(31873388536631175801725185182002917942400795694351350691503212207397\
49425109379373361823731231133831213464898082112772890502727515873435601852494\
57418666760015210598979130546335301968964383475482544759742225152777692287482\
37446063218725688125372770212188226093760662700379852432292811792218717830252\
02922121493550812363116158942537158405127530316331610069544433656988111298012\
19650915932203044498189121589769361684704626037455103502089222827685846162245\
14900538513425627497126292863316959983367925445480220318915010753779410664572\
7412224*mem - 9563*(-12229725801608901218671072636680175288919152773631222030\
90320485070683564294052295438839145565212459677919320729587728709684296857704\
21220826436808641231834984674716340835124963972694961665752255851154980006169\
95801008691989700321388775473766457478472174190808632619283330897966023459373\
67532094777897220560328438399810171365072048019908683309020343598769131676606\
74149137402183908440511613486322028450088569002297194785878032394615421575384\
06928649178142319132052783455892480558800010287294589375967687603842310157107\
2000*cM*mem + tailpot*(-23330120016193481541845049802382081800065550382514009\
62052112831221828714559111166340998973266278388324218096819123868371079607362\
34727571303975236819419006155138508685793134365273034209004345715278329078580\
50332303112485370143700172480205362889916379405289897597309774185942115714190\
61649573396794312255006545633615010909738057608106076468317980548657353771633\
39593263000772009178830172073848001354487867071964857930506702561694158336878\
17246060620481409494070627989470061925679670608465490166422684399126886401976\
81274163521 + 337702570241358601337554222998966428035243128941356620156420111\
96478571015366988757229322072807151741721028588106219105403879249344551852503\
50704729198316126430234967287155842608977990376565853877295538460986494371985\
22034564321452446283756412303133945169610501456042351606126883171049828736127\
14544673902865372652131985421737204210333405162241095993376938307556675994838\
70300117154306730270238624571974755507564749902241988418582646362223005564320\
79880279730757231563667820900254753658529987117019134307659707094451605083685\
7687500*Pi^2 + 74599479850843076665462314614018908028639939920355362971246063\
99264853471393183819396945222840711444614664637525849013948811915429063501214\
73874630720418678425634911258729421050615834032714271561184080279478978107396\
77223299873231204187111417195451238614483994351859947941295703484781109217876\
75628325335570814039379865604480554462549460228254058130225879009433526638362\
95791376166811345197510674586683204154925454924317067613252353504937795074376\
399955010956113651423848864216916069405173879337227301492328268395632025600*
         Log[2])) - 713394825813612342151816114653862817477883745458358336094\
02610996169793746933016864892987166025723544850037928659694120392488347248134\
26211654663093579363821784346656367229453507039220854846578939603359712657467\
64103533286416687710005641346482640100194870310437986836682162610812424961747\
45055542033675184063694658589654775647542325360488162793557899350080967212815\
24266496652930283216894123794581072451481333552125441244117585532256567720134\
29626151276976977331484856626668850636837172167780810190468417113523066742906\
0812800*tailpot*Log[v]))/2646212088851930062108451413710004752716835064418369\
93044800795255742100404543100981378913761746977452183103022687210339272442011\
56141902849590871268265851930000933502263007601669321530208678205967736822843\
33813445285081707043689789926877874597145305073087292010609237624198192396585\
80928529929278082210709367919012557931004145966574897076564138363463516574913\
18868791938688708067991623242695555786617698145604738123482606729055291559722\
22608385405669057114842383801812589363411752744330590280980992469023699501056\
00000000 + (v^328*((203611455517846580831959198178941628967476778752623377883\
33133548822033924467558025893468549269674173194085913115453624275998100018660\
74823360335663976070494242175383094253610381298062509386032228046770639029845\
64754159313516985755631599991824612896654627141911871536253623689770553549331\
47824696816424540506054907521123832480229143544964973970345231769666706930880\
00154478854135419229109336671416159727386961379611662450652802808837100439145\
80296542639396334808673286106728402423598473866030993716052828734398935436566\
469860873207808*mem)/5 + 1731106704691613401787136056873257804825042045526661\
37891517821499016525537941467714655476609728027517461077265460464616458223558\
99383961971402911094763519650216262707163163410460428201879721266163881606706\
71067950711979227223130382874482580426349568582210765466412660286246501428046\
81492526333497411787287665388269885125719633084717559000359365455825690915764\
75690123888348507744926271881717620586424822225362259537566806748687049659984\
90951407250208881617237683773855871436004529146637858967224033928195387226863\
96006400*cM*mem - 7*tailpot*(-46713831181752205670788937368985238737964607003\
42694490251844761596486419193586170126149865500873806979198755494540535308682\
80860841404436179872892548064689266263517088316108094212141031434013427241934\
77881889213988576926885485776134630347156824883908211632782703519595848932383\
72880611427520072442528647737413767172377460447545863824738967188704447811780\
09339030570707097239816572869219410288354391081706409395783313827502035472249\
80746941883956706975071692262656575038661045836273058799236203012821630553138\
9420606423633649 + 5894330094958983476227589992919387299668547167870721452320\
43046101732176787496653745972988135419873804235384692014953394566907539442640\
17686611224066506542116526429756491954571513438814043612929049674724133383514\
58749456799575016984491310389567949079014573328617610469393409873725985911028\
77086712520228679776340156544583760810686194539028829593433316009363635819028\
61324058985480225282641344046899110550103525009668003263455205675191377411236\
87039435562663863650880367140397337731505773537466147985117717353769897204871\
54096931250*Pi^2 + 1504827143569811911268342805468711408946965162269985786768\
02987189744052653764478888783036467851205422508961266639347384023488392491838\
83582182127858192999142482296692402389676800508060924340975415861218090245652\
87668352423084884920434595041539880839323402322045726082878023965460425956992\
38873000969863484669492661394634718428796772444715700210174617252179327113169\
03473366089791045547796913092388041942972390896259343682775009661619225049733\
75967092035957219398087128361157967934538180901197615220368482706585936114073\
60*Log[2]) - 1053379000498868337887839963828097986262875613588990050737620910\
32820836857635135222148125527495843795756272886647543168816441874744287185075\
27489500735099399737607684681672773760355642647038682791102852663171957013678\
46696159419444304216529077916587526381625432008258014616775822298169894672111\
00678904439268644862976244302900157740711300990147122232076525528979218324313\
56262853731883457839164671629360080673627381540577942506763133457534813631769\
64425170053578660989852810577554176726630838330654257937894610155279851520*
     tailpot*Log[v]))/3926130695626008994226189041112766695425571312193427196\
51039755572317656386562464364063670269654269216888876888259955992985819008251\
36354376247583484073964287835212911369447480221545297045516626064891428550946\
78702203385322023278620069551742725734873995678474793188779857860819579504168\
07907906940774793337341126131391589026922799072547591341451577839045363372683\
51323351170190011857007778480053095871955705645012052644817105423281245878673\
71491699805722722318076857288708254320107929273872820446576363536646144000000\
0 + (v^326*((8827200393382615631520155258971199243225223731119672193497181722\
43054895988020589396802216788334027102057747863679591856023411699379815873957\
26754260449100410019021013501478693332134683841637036781097026421280064666792\
23471535687968692067116126055654424950276929783118500806767370865910183018042\
03107562166938463938467587533229873038514421846205608148420329591808558519926\
93343039655067109755022785651898084585568626215144412039974078226977336203323\
95760226545107707892032825458946138229734507196864359467524852028566454441659\
5968*mem)/3 - 291991*(-496351350225829234220438864300551561388254190436169408\
19194184233354097165859676101472989317885389648095344885462208258640856142440\
09032445170420875051741218388774662786493504801887527745094793507378808955833\
36975792463942779972435162393965329237420169135141467306086277422735877378313\
26996187843314304025256978872325353877061239238878453167806919965745832542520\
84339391001205884934997372724065021760997973340050151335062987978614632972740\
76424763393574571707442240361976180138066410499971819200973095508639744000*cM*
       mem + tailpot*(-928332114152111538594321639344435387818161455655045846\
26476172841490812656926805345756776009104432123414637763487885566837154602610\
42600384970959754245914722284435858540066251843768174979849645141873106391509\
99269774792028026782593937042664774217338336994172230488711504344886490189263\
96830206938737030702826772859974280065355248592801118219541724867477541756455\
95591814651435641024338012596989072662680179148562013890985824314627502398779\
45947434522755208588060157373183656278971437897788336057174032345214142648178\
1 + 1021016029578002973529791205044682056080405737912194202637153010081285859\
29502625200900845255106003878583964928295022273698111098621245083178010150398\
50223452137276311448751573915927211593881863687353317542587943080504167354235\
01959153643715558620218290389528435250578045334415454223408064647474709710258\
15705428241876912780941827406622433501149521442656423586141731932685983208877\
71581268480539679937577083595632226778767827304252787016453331142779086344500\
772700179670398710576676573557959239280036819706370436980576437500*Pi^2 + 
        301290458196408578108845718761170635305503429924586485616075868689629\
74052428775650356617581644498836814567264875499687664200137611858965255833431\
55539890105007361073450493803710587376602246041002887286625373407788556138768\
87959165762266414437683528420444474179005283831861269618583139481898463569964\
12364442809039945102114129289617175310842261521249865706968909745502448265693\
00122484417851851534607663756555412831072135677418654018270028957237079118478\
489294795516265167520681944827790023919429129436980938547200*Log[2])) - 
    8797410217922753713057997026679297497348925200710993252152360897455367756\
54273063092327912428195885986032231023826202930075746238142431112401605951329\
24805165120436719788313623925811868146642375847406170902940671358829551526392\
08477008993261807365114701400246000193183134900397719970948045901427625739442\
70602025438261031140672540460863618814278385126953764355892549900537154796512\
06434765297998144162634794037154795758396858515020544868402525261196888365256\
7676637589782529531441752211236874258030933433501227335475200*tailpot*
     Log[v]))/329483945587949730968965176327019695822891180949431621056595968\
08687282341940455216856635638608112555965833911401473312603710893609547125189\
86873404168677768364821493065579681119632871521107471136697837239925040871268\
36633268150270230744523558722295568620214400234036577531119467900651903245977\
62737058856775858184910338119077106333714970740303086424894709917143631523456\
83970293039359498026187738827790844716768383068547927611890000493342876377727\
2622715024488728241764923248742094069099301950709771429478400000000 + 
 (v^324*(47303196460883146127165541750529895734342615604298334340079212621136\
07506831388578665854947276652753847040763628054328357149878490737325875008251\
22678365972910967015724421738739020639146970271586498007799857892995948423660\
98728652955975267609904098215021842101873768669988282820418727304925705733117\
17655502516356227106606435603502509102902415061840047676567188097005575680794\
52391637581948653426265296520460846902990820688798485795495717950258550540839\
8735413738441152932953229290791142048610097970642160007754340981306032128*
     mem + 270003571958320151202054901509399322270688250202824611482921986335\
90735288545442704066022742940052974459354701879587379303870774124506215703881\
59577192358127814936432187576583439698417724469528951357887086070340975665683\
50225856631035963948496632619523744004539156640300804333199652415204820354948\
21368233309970826775353864341110508391062882297746634320428286693426254567771\
30049236890458419401700918690952607933857351983809967511724981703657061402345\
3646858032141695337477037986682044905640504171203552618741760000*cM*mem + 
    4999803095625127139325704773253429916426041773896968807741516278633250972\
26194236949305362453868238000428686015836259290013165707903861024549937433253\
95090465518221105782278398423876121303868865549394877643720802254902405329145\
40898849675787005486189478493250334483667469087104439298678662861406543608452\
59236997687199036600440158245898240745710390968686638917530469692137782145292\
16322021136053270944145053524599002281307295983362269519795409437691604522151\
7847593715208892773706068871611942907345307140817944965129958*tailpot - 
    4792816361933149667015902341752792519145990996135615077411364880272264675\
36240794704549550404126287042154979468921554680392248313654270343688932582777\
93968391016611071126274616499212190482974258854406795251912437925518760330256\
28914093782706182793659886831010595812243152252721254365862101682335457909932\
01734103621140618697712037105242430862149650419363562136373979244314218900664\
41001351529090053758264302586478721574573783745257898901738414478975933201824\
1701520961817095411491223844302122701291320096468450386708950390625*Pi^2*
     tailpot - 16349127047613891490492215782202180231494322198140898447876540\
01227494521484363215799900066667283132191588994835430518811185583961409917633\
88424122445476645887245861629171007514424741506143670324643710380929373804670\
91664465191969526996570898147369054906322666878547409410540375922132933212459\
98300113176572895128290212206696517219303705676451019637615047218707015723589\
06638247676554147141615161336682290883747216543219161465313856353899049823828\
749967248078189996404198419064931786338667400045537570576872891392000*tailpot*
     Log[2] - 163491270476138914904922157822021802314943221981408984478765400\
12274945214843632157999000666672831321915889948354305188111855839614099176338\
84241224454766458872458616291710075144247415061436703246437103809293738046709\
16644651919695269965708981473690549063226668785474094105403759221329332124599\
83001131765728951282902122066965172193037056764510196376150472187070157235890\
66382476765541471416151613366822908837472165432191614653138563538990498238287\
49967248078189996404198419064931786338667400045537570576872891392000*tailpot*
     Log[v]))/615300685213710446764858111231196105376236809149946173249013087\
37713211106342771021818191782201996323929423243462463856909091257446201181631\
75579462318253858454938713354100363964654195513505370055418257851524967597650\
99452917680445552251899013250859059622424886729011569540369511948861908887030\
36219234444196474980950384090770134831893599287608267036297846447306838192438\
73819892548852022309121885364471133605066948229003715951290213729641671798650\
725499552230971626437624689557925671082752015960375296000000000 + 
 (v^322*(27984305806457630910354875921345079139265633579087531884418556585931\
71010969112448661365837461601598517566839075728810364169696757012563380541926\
18597603194920217729030420108178957648367201830447786366214484699568684208159\
22519774225265963332114244051977908984107536868616262918691871061165199818550\
07461245085239043083918177760725666181755815565545430838139854338473997041944\
06404187521416525396058626683352266445293306449361372496677032242431462178545\
760808537288389714119235434672567881883102808269157985030913961186295808*
     mem - 29*(-6383735376207333183821262970118156879191241254416564115292100\
37560431065898868295477310122657527358946537145776970550452506270777088225768\
12473538563926137682412441859863896019809558305576706977071910957750295797387\
94413227158815156057993377618590525801796849080913744346777261043826867660866\
11246200639150276269669438003310220869087573130525527962043459849626713449665\
54180995471371818339220464765660129003469199420448889226502086044322043389700\
303360740273421823417379926343724747046344114901310833122344960000*cM*mem + 
      tailpot*(-1170312751055216947497097521499662248337245855192857076135612\
30934032233213318230595401561520071594345355201712422904015480321337437756696\
01716572366266943748339291634966351430670535903603575637079865283487869100651\
05755582549957513075355207157834668175760626768231885618259091105143206524042\
11548648194123126110412610375052336315369285872065249181744541291940103076054\
07784318013889227597159584655124448419623897124702337847357675923558417445085\
98365939573716089165263451008544970283541550993770674985175397642115639 + 
        977725286724604982057452866302332500590808801448758920111898391867544\
44270261819653037069582211026547032754516009671283563996518279469707603155264\
59918684119570296414939973028364757970590923709308800071034990133118991805979\
71807597931212936909102986269972588205070011336763805478332235843610284850715\
49225445891361599616540610504023436787048770063814770901816506562985650275312\
96356820892471246712361114908612751395469715794572661546721327039892642798896\
24977291222151178525454277387493000699584588704843144030237764843750*Pi^2 + 
        385586909634419269725464362991677430303885607222112033267928383597916\
78655499322399563787427912960898218241529724602863947241249281705860472221823\
90617239097741723445165108363057415595564821504066888812615960757046888355256\
39313208823924692042507636268770818113309437394131757563537112518438428122587\
73332315822142765833505435109531275004442149960466601796928033718818929862714\
71116701745774155472350131209653984610592540801783108855737172972725001939534\
01458310930845629422121006477854194309597521238237332992000*Log[2])) - 
    1118202037939815882203846652675864547881268260944124896476992312433958681\
00948034958734983540947586604832900436201348305446999622916946995369443289327\
89993383450997990978814252866505227137982361793977556586286195435976230243540\
08305589381606923272145179435372528597368442982096934257626303471441555504426\
63715884214020917165761817640697512882234885353145211091297784574896601872662\
38435062745050869815380507996555370718368325171015681637801620902505624648642\
291016994523253241509187857771634978328115908882656768000*tailpot*Log[v]))/42\
29030389308734943776592758462148458401627615758693486832340706292977500511474\
44334248901222083207362354797217151375451565506376707273982514333633739396602\
05392705658249481353533499380039953827420170805474982783337329343063073202828\
74238882946059529790456243556823266829922479273968763875280948864010826602627\
81213480736575534914630084405979784916941322056397652739842290421155756756445\
64209221417535262323116396698552820102082130623066268288042085802149490409246\
0729474204493784921501911203513892864000000000 + 
 (v^318*(77712315812557624994730963354117574471258920809729021656099502993949\
32366852946995140603921880705195758606847146426504887651814215324525298292783\
85424047804963269009691648924763791864986334072000471353005606866041437554813\
01117869223389845506310608173658281819093502871548775134430509112683896132563\
31267252113853540680811714710653136604204279925618492531077813080132859009110\
20935397828276115332416480907644334155048310740193732357606261583013616291160\
93688654086629533108815097731123153759403443907555479376811536225927168*mem - 
    7*(-986920947347949975624300691396309395990820685679268868876573543827304\
97475188241590903684960168738114849331262521024711867618303044004337508813469\
19165062981886468791429997837343689347222115098600886792227566542572752430675\
65155401916903064236223127255433163052417680000236446234314815139969729402106\
52818720401519283637026747151275080534677009318080937793355595388536348747134\
89167012083223811008213840186499696761506703771328048364992209438215039023361\
1662137544434185523635963417489224617407149789591633920000*cM*mem + 
      tailpot*(-1773041359920674223260255945320177516885650573092665499000721\
23115287116065631083071273426813274817588886088146892870638350911187361084656\
61332144224318823853241714060452175293519905644344364479315794840670739005758\
37841506464512807659222306861339134715744038183980935967283100353823144639043\
64057579608828369116007986386763825678914577942585496026751550009651872791248\
43105775904350287363091494373034352554990556521340940077200386175849270072349\
76067792099970982235404136966518113859308815039101892121786952167501887 + 
        112484358269961495205971242890216521845999011892566298828516705759237\
42860178697650526158082023756496549558857304517660650405027090920207697465718\
50655401224235611069420554419235841895552397822010987026107689752535484806988\
23657547316232769842985610735958352988472784838082156045365523462318564629034\
55597473669931633584629289701046723789573252221480726424773390690710664657087\
46428781430628306852503264939950546268719093929879356411534875260807021471254\
075492942883815641274926924687547257024995781387682544985469292968750*Pi^2 + 
        593136316048656740602403831926611681240604791859454204197728200899535\
08258061897785543124566489045425728143233639406603097057473466597489231827321\
48762723182310222527570458732925505129020195480181910064068668321821230983440\
31653034164085974978143250122563823187020499478996531122104833129661571415455\
00104393274294947984085813447300631557895371154112299167387967391680115194104\
65249721362562061037981475138182386762672577557675200509993264794937747585831\
30335451679366101418185137072306508484485230253605716480000*Log[2])) - 
    4151954212340597184216826823486281768684233543016179429384097406296745578\
06433284498801871965423317980097002635475846221679402314266182424622791250413\
39062276171557692993211130478535903141368361273370448480678252748616884082215\
71239148601824847002750857946762309143496352975717854733831907630999908185007\
30752920064635888600694131104420905267598078786094171715771741760806358732567\
48049537934427265870325967276707338708042903726403569952853564564233100819123\
48161755562709927295959506145559391396611775240015360000*tailpot*Log[v]))/158\
58863959907756039162222844233056719006103559095100575621277648598665626918029\
16253433379582812027608830489564317657943370648912652277434428751126522737257\
70222646218435555075750622675149826852825640520531185437514985036486524510607\
78395811047723236714210913338087250612209297277382864532303558240040599759854\
29550552762158255929862816522424193438529957711491197774408589079334087836671\
15784580315757233711686487619573075382807989836498506080157821758060589034672\
773552826685169345563216701317709824000000000 + 
 (v^320*(60208753658451110893468773567801483300770964093771492119276932391520\
04324675257627458044331620301834759837511329540769717841618744346261172031865\
24090691595425474855678938524981230724197513722375689751489069569447262681497\
18306698831923925334538153238703599437777196355131319766917108037506922302992\
99806625570315703907284711189423827789491666327684091510184910045425231148119\
15628124640879417426271039811211937308589634623353955124973642632494344987317\
98311788062922715411291787469467876747808709928295921751312552094072832*mem + 
    4616948107318769615385659490585762298216318637685417940100512977574301736\
87729555270414520980317714084967227447104769721785327285535517317804710825362\
52884894456487598802445085388138386373933041707578474436734844797540085086892\
12452431082100350404577819114351734128303196621015905680428294858334904734093\
12620875345487359555224451784178834508781128690715582577481628161748252968957\
00036107086586434259221844829859786856545234303539155825278321518994115797864\
4773815981792173321858463253008167726545372142632960000*cM*mem + 
    8379147994983226776935159844008089968619515186237413761134749065926611650\
98319938308774449029844059666210449021073378244804757516214609368130968294237\
55741735447716984034341025404033002292981587000914767083467205860695978489045\
66042174871504818830818925979446531906916455067033716865928844117246904170702\
22805720324739162367997470230815057448713566222889427026895631756130792928171\
78130902115098276395402248706845692826419631866644309311847580619418902883026\
47660802016208571272571185494458647377585270317268996107677*tailpot - 
    6100423035058541040273445520530008520657153915511918064051279292691525287\
64358575401707672527128730434119377592270152448390636802151686349366665090629\
42324254546290576134937823376786700648790095435311145711192425620444157470257\
70999296244116966621923419751643923194818697361880250264413969493925879055128\
75289727939408764121324328739867676292164297233431444170238205011934568795538\
50411694594939435271856801120635284805673458648927060640885382197940776213323\
92833171060705727210140230406771781590031801782831736071737265625*Pi^2*
     tailpot - 27817501655144401030510358090962365716973905737671232373189670\
06734781086300557298472396758884709774093274234734405298843866474229476797977\
30228175615313221410347740265131085838540728273721923472109311432597242657149\
10360304616265941204237213196635648884864017645659707294915958658625132316026\
48725505266346491953153179029862390508823892726384779094732696884593414588226\
41675668106028728447451552452409032788889360117967114087850004241921771553201\
6529707708737307584429407010466342830868390538500095338452847104000*tailpot*
     Log[2] - 278175016551444010305103580909623657169739057376712323731896700\
67347810863005572984723967588847097740932742347344052988438664742294767979773\
02281756153132214103477402651310858385407282737219234721093114325972426571491\
03603046162659412042372131966356488848640176456597072949159586586251323160264\
87255052663464919531531790298623905088238927263847790947326968845934145882264\
16756681060287284474515524524090327888893601179671140878500042419217715532016\
529707708737307584429407010466342830868390538500095338452847104000*tailpot*
     Log[v]))/105725759732718373594414818961553711460040690393967337170808517\
65732443751278686108356222530552080184058869930428784386289137659417681849562\
85834084348491505134817641456237033838337484500998845685504270136874569583433\
23357657683007071855972073651488244761406088920581670748061981849219096882023\
72160027066506569530337018414388372865752110149494622923533051409941318496057\
26052889391891114105230535438381558077909917463820502552053265576656707201052\
14505373726023115182368551123446230375477800878473216000000000 + 
 (v^316*(16714834736655487659110801237641903222481300374597146771449648321904\
97093156870028361074879070967264537758552302671851670357236302161747565519492\
09158152658001342025578912933920805817423395438119012211122403881767238385612\
29607004702826592191936530826851978462130821707615842678093520394705943982348\
44891245484902746840836083780889116759439760305868749457063323107333564473090\
90054484423379081374171781013095788213920460033096021830855950030607457261135\
99330592225960544043918975743575457066507855865026276776208266608771072*mem - 
    583*(-2955139230879011029912481117156914304085229602869836805582234774177\
62137524113122675647201362393297195043132693047298765620276194631869679557905\
72318865067281845502655084693217230291146021981153175920536341451583055462789\
19988091638482467718940834667481117933278570205574179429675049115335653645583\
67233008740574504790759381250139429187341342589197425084499238419144277615225\
00887947528456281481649580380365137936637469057550286555241768456704424711773\
8236622713399602912863237499010673087275815996930129920000*cM*mem + 
      tailpot*(-5255083064303546157706723500699246254669244282202794731480486\
37270344124299448526222551629267945405533173975154158939400448212472319533988\
16687864519564066836374921586127950536649546923858961970774511889927651288471\
41809882522167508071491498651987123466792070976477292416418124899908420443785\
36087776218625117911870723707060750356225143945897282243946696455496749626550\
31004292563658313021681024011821803525530115446411170104963593055616792674421\
68633591928496888724149265610629327455124893620827524492055212185998 + 
        290491792493528010647370061618487224044293658022766984461059895675302\
23778029426692739626137250827446402180990682683579969287236917220087332928494\
44218397886852879707006186557631573192019824695399940380703662265371306568698\
18063443813893604670584047405097391707329438454630316331507968412038156433979\
67044276631227615052827684435067141975207671446612687623285474752363483443385\
02519340430590796543401279413262411481641577398814152886344076719631245245097\
757109270809839021677511075741339222544807747735135320456143359375*Pi^2 + 
        177154556604039468850912917956984279956218789956625711270655007080084\
39781625962689990167223832902859742026326749004683102013570752785715019186351\
77389950725658777414365853036875911360212353959807989956707122689371048926889\
54177296117004073112837523510214895260936268141253321334788783874971132993688\
33364188996140937241718724752848812095181881754803084133498942898457054627247\
80248280987797492782601639358295630070738438546139432632933238985741054764991\
827885262897749053634584452753210647397315899207737344000*Log[2])) - 
    1032811065001550103400822311689218352144755545447127896707918691276892039\
26879362482642674914945823672296013484946697302484739117488740718561856430841\
83412730590672325752923204986563230038023585680581447602525279033215243766028\
53636362133746247842762064552839371258443263506863381818609991081705353202985\
13221847501664119220165309108574514910370630501980498298837098004628476854688\
47478158859382922567557458863523312405096723992892250000783286870349279902356\
57108269387698268962735955121807432635169238110871552000*tailpot*Log[v]))/396\
47159899769390097905557110582641797515258897737751439053194121496664067295072\
90633583448957030069022076223910794144858426622281630693586071877816306843144\
25556615546088887689376556687874567132064101301327963593787462591216311276519\
45989527619308091785527283345218126530523243193457161330758895600101499399635\
73876381905395639824657041306060483596324894278727994436021472698335219591677\
89461450789393084279216219048932688457019974591246265200394554395151472586681\
93388206671292336390804175329427456000000000 + 
 (v^314*(11981901402850171599396782254191803043762963319061687296269156144233\
91515182468406158085433170964072408427729733362414229501862733775968260883674\
41156344710698943886492826343543103146065406793838117908399702665131650776256\
08371244422096309755865245307202927578659071312348867874763762261182717244034\
33577802217869880380443436967248483444368094064358237937876146975753785551135\
11897900553701556895772121195124065683135589728303632523276488392855807394850\
8146716972489880292839258622863887609893345082866700045511370624466944*mem + 
    1432132367289692467500000396176321826287305575032522299002427713063749484\
16254521260805001273925059523643821518057014320735055393758570227196398055919\
95942555264701515885144519720046057624513508098717196448049512908728619162080\
71481419800339473828275375869594629981580511144899132339943615478120011260655\
53550696058652106839447635451843371734790384996376059153440757268890688267725\
60337900757873338716196450355316033236094151147539708997494979148941176402540\
478795166745548497875440317254020361490707806945280000*cM*mem + 
    2520711356025988580700527945682634284992971734515716279937684675550128451\
79348222710581930175446465469998350636551434176308673513720574998450351641801\
09629347439786684108378850473922385169878346431834430474421715806573940564128\
51610426253572305886645290540065299208106668308488865782315401735157086116547\
20544029220727369535000736069895365233899530143846723800193112981878452567217\
21788780285133025323903192273909480921657595807221556315815028822577845199612\
1903772818332839440784491637022764817449292945288887741351*tailpot - 
    1214020687752847393547011762382622474969342029010438497032408388696057503\
09335205851069774326646085201904004241099452354657081764939149166143384676116\
07590423093080938856310340719688290687061293078248482471166818068535117597847\
77168551778409900570147356596629164922632746452171583009266469692062997659040\
37622894409762453542952340241613142267598493947388130085510333274857554407373\
16007923358539122777454504205984174870033231082246681588852972412300072719315\
9746040654743526234723093362456888716041693389950140589456250000*Pi^2*
     tailpot - 85635314860709590327107919996284513408188097857121918891991342\
95428033950445540982798427833547551821578183413188673486009971166551229319709\
07042642591504868113206299775169150790310076428408955838292249387703819885998\
45920420434565652199070250302689757797780485619254861997730050587835975891523\
99127853256870306833526458374923735385269739424767572706892617091278456852795\
21385822746125962051426727332495026740475501016336566179266696074795959910408\
94030808840438187231406651160990049666874969850346118637768704000*tailpot*
     Log[2] - 856353148607095903271079199962845134081880978571219188919913429\
54280339504455409827984278335475518215781834131886734860099711665512293197090\
70426425915048681132062997751691507903100764284089558382922493877038198859984\
59204204345656521990702503026897577977804856192548619977300505878359758915239\
91278532568703068335264583749237353852697394247675727068926170912784568527952\
13858227461259620514267273324950267404755010163365661792666960747959599104089\
4030808840438187231406651160990049666874969850346118637768704000*tailpot*
     Log[v]))/330392999164744917482546309254855348312627157481147928658776617\
67913886722745894088613195407975250575183968532589951207153555185680255779883\
93231513589035953546305129550740730744804639065621392767200844177733029948228\
85492680259397099549912730160900764879394027876817721087693693278809677756324\
13000084582833029782303182544963665205475344217170696636040785656066620300178\
93915279349659731578845423244942368993468492074439070475166454927052210003287\
953292928938222349449017222607694699233681277452288000000000 + 
 (v^312*((8802072486160663710891809820521733630432597342209239376268418732467\
69200698187698432583369226800387860012487663750294837856724688893370691819192\
18909857655267244454879654936058775946897854652973041558733394845637403176210\
81014518184413085228211173579112552484410009709197704751348928618519379198358\
68676820899145015606706522206130373067736420193502178118900451829029909964256\
50328431996580457641532322492114647571478845340629832712625690840547491847443\
43458513921113299360235322784240898418716990274716566426478444544*mem)/5 - 
    1891*(-129048649555156174877626694877856953711800505451230755181737631033\
73186070256952804469521964000901882417300849543089164904064031071616956324449\
67559252602924313320035173933280518232330192983633406842836288172873882963477\
30784029312164871658231566400684488211972245671482646291923389342976697835357\
21889098231475585583934470914412055518550113372870853410937311299497695325912\
49226402931906327436867605122385625862743389604403903182159045521534432170864\
6881585984469513410304707514802331151775215648768000*cM*mem + 
      94324338244695717755346801666627332110196023804784815815184493985803759\
06723305610768058484335059735519109143239882617641638647959605881869049667445\
59406837112600071343976934228376400377430698857077097429518917600197290268625\
17766721173397245949010464629731387744028833129028762417709091914407273655913\
13562280027386160300099317761610702063242692115108798368911586208063700615732\
64625483876368256761503075029149470857129423191492313428924865145115888460590\
59162523385315630034569965492708583701237101902856875000*Pi^2*tailpot + 
      397*tailpot*(-566257655733610448663505476154405032293504593007063681985\
24980767488216178345017312115969318241786399702112442725456974804566726478225\
07583172525446201566885042058970398512189539160361763017091076718297209728106\
98126944387510685245375321811405199952970343238017961092568581406101134969747\
21080414746291389463994138330943235859386049516140608923332331842722718411111\
43401956925693646789999750992817962153882982446697610968324262973781599945119\
04855043049171659872301280674236619627878868778300192833121427 + 
        193874680696037427397992742330422653307522023885005468242733697866866\
73262671374161546460457477904754702075152871186608490419349109102422909452978\
04242903744026378731785469027995020397840346326549282104230447484042442430051\
72068108579908273579050368259510752484499430575533809176119607199039033481677\
70297266748455579305052042414562610849022312272547040903029394358941132977612\
58251619020209603536925694583359356870699784049668945276122954044303914250569\
38938896054859900899725534380289155496434892800*Log[2])) - 
    1455469574148940897582128974714912072495960864251185001574627407984992615\
84654927101752896198610150027832247732895273090321870466986291346435449058468\
58623990416912261771098069796176782094896766913629062626111483527306781854381\
11749498687984991797458123577286804308040176787699613607443537129764885994569\
19561742678116849438046457573451548539734254324223760085481389047999368841612\
34631921848950344656159174816199054698367802558182803079569208181446335872059\
8780618576808822748251248711336838372077767065600*tailpot*Log[v]))/5643948783\
69093573806579580546735553837238479223908589083311421971219693700176987927431\
05048415169131610601189951971677994662026125321629702989981327467047003376165\
24873431078952279331957352992461821984382693738594384724105961679277173465921\
43449249105808164358796053458792994499331747903557136734276974732083780403543\
75767228299841944466200225540609802159783279539056666638646596869222942617136\
45375090883041832543488319654833501898883461051834016934413776956044965975612\
789021104953763876044800000000 + 
 (v^310*(25439028302566643421919261774862528778982938332114702976286223174804\
16531778368992768560018495647831982111416392032556118040215133883344448051158\
53747161703985100606091644994873716285967516380940788593811053275893908385741\
50416878003693463662529471410541254422986166400139789660105101202699772233772\
54096750842784995862565060224867434256231402258061979146763874081235305084889\
85805180653116099205255171240127928272285374167550623034991838003922892666085\
225990369237946406341162419506558438538330908240053713045028864*mem + 
    4090377049858995324603652371226804306480756500088386124277671033029099550\
80365925875320828983312107058606798318091988163809020532075418092882029779506\
95092099722513531220921697213053274178640569285589756312274640824312261519734\
81539515746764585025789983769392119457948592101953364659963080638466288527152\
40204692075853224077833034570315386521254323022635608048198967814222590115092\
95989546767091260372456095590564515569579670809688634936696147558839391994533\
07748654233581565894252532264905334209904640000*cM*mem + 
    7051770322594440576807520595244162683053307523374810399993555826638263559\
20609883718998696735106925378069206402613010727076663731545662351021105943657\
60547431420650235437131344137624371033638897180619490892105784778300713798866\
25587622459603108201078371480842765001411951402894876537135081936514250820902\
60989334843144045226842995984591276480286000291129865685311455077058416178540\
09546712584381886548476098535954514779348822538078025073085081614511593841612\
802782620805977716225031939356271862024868810412359*tailpot - 
    2577513172618233057382751219801845988725072611790770384092331978667140596\
63991789740131466335534268309113981692855674047737970350966337657287123297736\
65748737527907275655659833276726853486414904341126344859604898364724636090029\
11442451191626211731746731378472877918984089822754669847534984138784439244051\
68793766872652285687571962020022213220288358489492396419533190842303060135623\
54109744682391792150187450759697516327241911514867603389796935277556296958477\
489092816992428060196982370488932348148996429266106250000*Pi^2*tailpot - 
    2433340213504734477224922981291833495806742461136368026021735812966124008\
85603848756142894510264326780078963872883217029212274152121725398345498218786\
38439232283857310642094898289999943201877468585228596961904297533048085446870\
18417803029950534176315356406645507321514385549758921730215452308621433517409\
16704333699052469759449685120644667660865173893394557062135504875354466527430\
47577687061112143239216532873799018483038276397312475994933636562098137661906\
147695641254751540306009165192119148053213184000*tailpot*Log[2] - 
    2433340213504734477224922981291833495806742461136368026021735812966124008\
85603848756142894510264326780078963872883217029212274152121725398345498218786\
38439232283857310642094898289999943201877468585228596961904297533048085446870\
18417803029950534176315356406645507321514385549758921730215452308621433517409\
16704333699052469759449685120644667660865173893394557062135504875354466527430\
47577687061112143239216532873799018483038276397312475994933636562098137661906\
147695641254751540306009165192119148053213184000*tailpot*Log[v]))/94841895964\
71664641132161114501683354338452969244278037859576794833041443517897698125357\
98253518675652519808882352351055843325724139413457154102452542366659787381568\
42389008060530294525126594207226685857437889201082538739222966825999578382688\
50730526711287401564335525848438454035118549459192360798029725842465856089639\
70366551750559246368445915721239698996600851269030372415985642609485264799004\
95565407340608324104966303348027179446173180742418265641386569814635742249741\
7228127925377695744000000000 + 
 (v^308*(29851646231552381647619067134142329836373294681873917494489449883301\
05780067411377032263172743560713330581052609423448151186364522236608913712420\
69090118445539363570354234764330352889849153141302531455738420839448539104451\
93967154715370779562394130646582811717674704662180035107133154027067972240716\
15931800496669190760187772454480845870376931793583536124555761599656584615350\
76325991305429202941837515855117890888930035389408385687360192344285875201555\
885523799632710562669791247008126974155439268975872049152*mem + 
    5568324154757400460452088640926301922139647997326769756053928967673005680\
31097413300222330434492349760728606349367577579894999814027453864503673627714\
03852428847930248405332175105952015061808677192089755117849086426980867888307\
50824060775555087518771273420373669207522685436871957345896198147660488589570\
82416136150607677087267326878561365958486084470234013689913239706945684305754\
43221289997897596524545462038663506107122001358897670193609805972014570541035\
01649186894457388614960194656948715520000*cM*mem + 
    9499815786199175102192062588715014923484933242709554992652387193866582473\
80236578312674146776515828841428021479928139124595971579005817522376582562620\
38018412921011139534795269526971731036167319927652408237502292243460051150234\
98294150755729015949075701322098484520957423429652164798526050908444933917483\
91987667654190739165229763628440201085794092951983886016978041389449990488695\
48955530622754328989239805883228202931587202470056253900090690242847659062693\
509792110574485877222132686787687407301350306*tailpot - 
    3024605092110744302486567221877662368482244311132540498403364432301582824\
94686647458980996879004748316663901793547393186133253850680839012198793568760\
18341440247655324089146438513323366866876524998143595292163509060370525023723\
09145698745070001656722625319050281326567799494816978860624730478426142997594\
18432932362982964315731321996780238413987739878591353261151348110626825850230\
55222266229726909211150523103902920527779719610026973059989006045236695277583\
675212577423926675269938156210658575895334652734375*Pi^2*tailpot - 
    3303986124889564951595491625972308985654357280599208768769716398032059156\
42966246996354050971861123237038089507394928618107296323497463786134559860088\
34763396917498526247892047431369468052102569291716011221481503213687227592694\
40964816749118202102256004942199916419478654261569461375235824043912873762170\
44764018584605806257115706843957900010329118519378329638817796648767054548405\
44574266688316554208448027558442334487634137334538762346138931660205604376135\
747992092281012812000833695233976255488000*tailpot*Log[2] - 
    3303986124889564951595491625972308985654357280599208768769716398032059156\
42966246996354050971861123237038089507394928618107296323497463786134559860088\
34763396917498526247892047431369468052102569291716011221481503213687227592694\
40964816749118202102256004942199916419478654261569461375235824043912873762170\
44764018584605806257115706843957900010329118519378329638817796648767054548405\
44574266688316554208448027558442334487634137334538762346138931660205604376135\
747992092281012812000833695233976255488000*tailpot*Log[v]))/12944007228196362\
19637623907830771329557249815649068897673023880328063308650771489860488767634\
84867781295012265029796318802253244585869495694410834180041340555804302910407\
18706923746703766567862544502047477900339625610627726432332222119886572132274\
67463695691733776555156646315447928331945118102207597039646681567422358885590\
11919071128705005712252363789828554135323518068686398432895624712787479721441\
51853647289608598502580144674228912513371365410016298059882214373398426265573\
04635392000000000 + 
 (v^306*(65907223331021427990893991155497323787828958649402925739689366646186\
93531656610310052618082164390307278325123163848778068705649563313594028175882\
47753404813874464626535506765748440877162884390340580700890274787865391777570\
57546921367780890192762200595890898572841516161373271111172195325824129480570\
44012103382403828814306350898656666486274147125744195508013504991564025329620\
52908226891230257085864692396257743802832679297536831631707337757321034871780\
149311748357128212141844502712930143322933638987776*mem + 
    1426408027388248586000830035554220338786553806641239365744236741499282735\
56232603239615061230128612131874275169057958966244942710927208264364136886078\
87675683337375802612726682181226511437337242118329604354520641962142006169973\
77432224620815263233139916879643512903324222653321149622062689374478764480946\
78256211141829145444292945671840314905991369682327986648222844924131861572033\
86330464811098754122070917999952956427913288784459592067716934433137414798454\
848954422551801802407914147676160000*cM*mem + 2408031313249851930022417787074\
62700055292685016409116595681846903095022552458166387791341620788971807593959\
05213192353013153798535749498291975067229298580846738750810170246609630996999\
12510575800740821865196829876524208977110806099363123490171865961399278090042\
14197385528902728849085943025793748107881270732273869408381720518600210780325\
42167976728100682465329953930972516669533877338989348005700569773210403203305\
95142476729296766589297798506363008228702133009881413296638693332460412446982\
07247*tailpot - 6677800317621683818610965941715819116024420914546096817046521\
10306728458560351600506963154899458024611025001196247632575209020739190668335\
91719125117694409987543344114092070965674760400920866211908384897398781695573\
84080995262237166042945428931089817083936858993888994787435820182716112649272\
25507828094866572254000090009385235446122117667840261834495292555099228037560\
79931714515556626207844905173950755457879071281842142051794831398602221561128\
914076579025313399721740228987407435214802875494200781250*Pi^2*tailpot - 
    8441594102944107947579207232320951083620087720601380434495375408729070540\
79145503470438276197780663137713506403980757308075661756389452679581163657175\
13203126137153997242384653014279762252537088350416987781339080128858133857505\
57425385493572588205800645941347705709703534110861691280276720011825827321009\
35699341812481458182912464491171778569658058695094800748118912664353253565147\
36419249902288284503894424048720125674379235573278164377355836371325646452023\
121443567529028827251613258600960000*tailpot*Log[2] - 
    8441594102944107947579207232320951083620087720601380434495375408729070540\
79145503470438276197780663137713506403980757308075661756389452679581163657175\
13203126137153997242384653014279762252537088350416987781339080128858133857505\
57425385493572588205800645941347705709703534110861691280276720011825827321009\
35699341812481458182912464491171778569658058695094800748118912664353253565147\
36419249902288284503894424048720125674379235573278164377355836371325646452023\
121443567529028827251613258600960000*tailpot*Log[v]))/33243292348182103994062\
84755531397556982139998893266330586235991103785861979730154866011854049209182\
51171148066706892942487526695771317649174596103931565034352250040861713700700\
71157411849254344289014226698119894665283142409912197646774515301902228908696\
45716008795072980713342119947844080000878870584016433337701278876975206535628\
42548270049495732522600054842503630250939169735966879037816760012844892592524\
55979393994695510064088401098469770207950279676144874860990000375644815360000\
00000 + (v^304*(4849601456518459271046410936006931480505809241708035958538997\
13531859091761432995189444709069137201709154389518499158347988021291917574337\
49951425665281728829072450272403580439907532743908981377776074424359057749498\
33060212468408497492488090202555659694883106004476026872569807320073986192599\
02082776215306686029181174574345557484150249003923746289954690922560820688192\
92474254253405060549888568379424927134119102457586783214226883292690196905070\
3248978551084825000957748638535520546891729417011200*mem + 
    1217959909965016327808817076617452880142533584621491989487330744381986764\
74750835009694608805599824237163329032394764227983115701164590638537232487869\
67743380720447320984962502744607041825566237314396579032044666836468922874039\
67356048849988974983294550035135192298462521035005710074326334350754782500376\
63942982886070667399574162218291503747245214013144552028133342971917529978291\
87417037326735189982480870850345796875417808426994084232967853549210438187018\
812410731490148259473653760000*cM*mem + 2034466285235028271378470705760906944\
02395858773799298832382661952444279714284736989133849329596831682643570872943\
36125265058324228202913293570848236130016938129307935580659436350829665972520\
92409169347111146514097547455847771164962827027965453383826399622096890689423\
97854589346629790628517723753996944130384333891991284802740970689815260978285\
92683763358353402354610939665502022474426558658527257575171217890053226513028\
2752209193627685807160941873003484855250674809642609826206640480821937*
     tailpot - 49136756584267423031019787721017623824208285737480106144695860\
44164392548191736655490203945043534803668515694245047270614862893714044188910\
49602912896049002149544628680949462844832736005635002191022254250277584274379\
76882943844554614313330240312406738352231948460668397636170651810590386406527\
04939603347186223211028892354854787209579641693785911676157530276257182834730\
41329682292576400413263892427688881591398352383087388779701124472058063104346\
84377848724414063855141100727237347234768869921875*Pi^2*tailpot - 
    7189080551925352495496426262296423546979730971825885444959397898496459358\
42908349042636529540583738132652284908468034294984803638461191487267283387930\
18949881694634168350352089996273781620188931735817578013561827879928163499161\
21113299756759074551331343147204992962823708368749173837102207328581499682877\
46640420624483811326854780449429118073261560287803205607200764707829626215406\
75368226964149944354523746825292349839588358835001487163188664261854222475515\
473639726561361405912864256000*tailpot*Log[2] - 71890805519253524954964262622\
96423546979730971825885444959397898496459358429083490426365295405837381326522\
84908468034294984803638461191487267283387930189498816946341683503520899962737\
81620188931735817578013561827879928163499161211132997567590745513313431472049\
92962823708368749173837102207328581499682877466404206244838113268547804494291\
18073261560287803205607200764707829626215406753682269641499443545237468252923\
49839588358835001487163188664261854222475515473639726561361405912864256000*
     tailpot*Log[v]))/2845889650358534939514812531915835034347736011571852736\
01785780787506194759743908555829374312928611757026826159993436390296448893578\
47820693715016653445807980735649615424641105909993024536308332639065149949251\
52524687885656040341682399223647471846024598281091953877074691822851600310109\
68088860941086674305748547342804736447967122137311936528132251011543421066489\
65535181366382787914816492262755826038903030568864217247855101774214548125759\
57371352697820776778578582092906496000000000 + 
 (v^302*((2425061180316883425044139929616386783636345428994753772667142999722\
88801481854159539110100839041300453432631005799370559636595292544747053081396\
96696951988711983664261295113466889405906432940428279504703536558917360186929\
72061296328518521345792400400434508089066844749060697152367101237115353415446\
71422059587023424536912851518094198419663348131175300410683085456120755571327\
21520089833253901475956182391178404600701574110287090172223288219663960537872\
2806606979397630858403818222359467261952*mem)/3 - 
    184667*(-1275902376503010726381682431722252406628298053436658629870721017\
38891368005273890327472275392336778732492593265390725826408615573273909201488\
65751555902748302722950538733949575152240996559867176923519629792384545545535\
21246179966027763400773493880599024208115702889676821796744140837336149283904\
89648465056886958509867017076246900395029927438465613087390621263910882822824\
73516746894911886426726795246630513625885293508819828730515817555785273342861\
396086287265368805212160000*cM*mem + 
      tailpot*(-2108653407009454596365301128001561509207823368660162645947309\
96532500087259816406654696477328154810670081374749610596599274948578241959961\
11329028838702632295543817318952824261459503887904242633122076462341442983941\
54471370834341703481522673234246655682808012128557765840863447935346670227553\
07974228291737409604182559318869640164761816898112456745216439753520971435462\
35974216163117519903871255396823299438675391377480663164728228733482840655431\
0719809014000113055371855752093043 + 4435193935085029397838958349495415190083\
50397230692953970837390623072158408775771120981385737007709198358791380307513\
55288804167359645129663287603728769146608378218239107240428914686806785087715\
04114513322571270506739880323233866680075627396802745822788708191978287280816\
84663814754505371834141462592801082179654945052914136639434782901324284532134\
39553578260540842873811300270528906972502263835788696180859938208832201330258\
389758641631970002740222998780360906737077637584770069531250*Pi^2 + 
        751121252375395029874856111141604414870809815190354471941817946337429\
52546102049426423929284227916929340227557594768204088338770711978584436120624\
75554312416858949581641793473275724552436763010631794578630370079482021584804\
02259090463378094449472106701440188174366571435876746173939354992897548875488\
98906692945805244977292713684486592935158055316327640103391374403474726268511\
53481754750931127137570833512268654329997716560021022270698018619925195577321\
1339196661446430208000*Log[2])) - 1387073083124070739819000534761866624809478\
36141757189270079694696294098178310271614294277491305167355904718023783530599\
44381255771068949252065087411731882110840916423930450753294082259248397148843\
41609451934551467706480001004439794586006425677006655282348552295957516473490\
51085702858868473411658189925144022662230171742217135579730856575568326011002\
76314972974936966467275827219600152045901984551137931122101155891576883239894\
021196629910044857260916771618375429879327927220736000*tailpot*Log[v]))/55198\
27832024961100801885061160424974073135340277516392386643841458543918464441282\
07393315033266906160116177213890637206588146483171782319762002340944741936699\
42711848431677952902353106054062918855123048733574239223173113556538954745339\
55332022655106384514346782523684571352750847324699260300055609411347579706947\
89795673978427851224421193795620839867859238285601564991633943695338586809005\
82912980087317966764274462160278084763122218160277448463498438460004883444531\
2000000000 + (v^300*(13744391866982602499160884964815692868560087707265436136\
64243507113666115092953447588293757704075135258977513156096720607824060180233\
78921542841557094438439181370482271195418387940773120356135722443661121173023\
28965698321418737529918704660666333487256264408357706384677490860777191476378\
72224082932871234492934118678757973337671619241785349993818731084959448775345\
84102780166392634975916800099979784677567020716751440110842342689317557830684\
32599412712953693703892579394009494270691407560704*mem - 
    2033*(-228735981303856279613515311667698525420556573482505075356872433149\
71490020885369223538707672596717349685878342332862910718973647026702381139106\
40304674752419083688640407361929584360959683671544516601816103047816061788010\
53676874567598151633901849793334689152238130435202328635110395829096504065045\
96466305308682364123552014888096282107796343151471328495559348541423790700497\
66336302583654209294372685224353803927311611675690968861048518654957572291110\
31743435777713939415040000*cM*mem + tailpot*(-3739927884273638597600723395378\
36586655546456430016535058874429545405705490675156895436850649989683599739705\
10140262741330672592557944169728073340161645294328985353600104812343145969030\
07967121575137787276125134748598455212046947434965621173748140607747086977646\
33156918142453226211287929340801128846101478769258532374794463353470640541452\
86458003032250396527083253989421516012123772810124000515556850218750715431497\
64057897032899952178424651503334239212301483259199635673487705518 + 
        684996961412526104095420953311875786115772389433577729667694420412562\
32094753927891011139226316820929175177282510891563451974714738595783798880851\
97136429116401486864686858651009972729450525165009323787935878619678854547730\
09902086374450761708814263855623198474848191925404591755673655492733978942055\
62618355048853293763991485027147571401490935155425250441919384376765889002104\
20985920771749064938012318483689612758735867239094380574242026759398925774179\
43994146155966559494201511171875*Pi^2 + 1342987046643312583934303527385254415\
38210196007640084611497707432599334072064118112207877304029430744410439835432\
67404062123009450254412593409432164038353514219339146787199889062788211708068\
70013158938709427776358416583598317457938752641567232324547194910567524991140\
86036301260798644205502501524357009346879090524630033342327952019107998236923\
83881207649314537047808522245130567966015170228511465152231921701899339702087\
55972820472857853032467579308243191931286788292970496000*Log[2])) - 
    2730292665825854483138439071174222226471813284835322920151748392104744461\
68506352122118614559091832703386424185434626324582960782123672208024013755894\
89972694407916485418377374464648434402503667367521223962666693366609144553793\
91989484120306183315804447253183778306989369118004632036436697865855990178000\
02205191036572857784952726454846560415666164304951510564538181947257243504446\
74908841074563808654487496819961357614344008927440213200152150065887336584091\
96306040599609018368000*tailpot*Log[v]))/109227863451308269339972155526220135\
88760357391591502307410052552723340164388104491400372602042659462288943897636\
43524765479801265559797261418294534605637545748866366381832063725999332636086\
09847571619713699173779570285558585007866474898301765594885248488353930631372\
58557318554201139266451570956946962194314892413185696154459117902893676717616\
92704298776831460921663623510165455759581389156485981609219728495416831783790\
51910402595268835076709907411405095938002255872000000000 + 
 (v^298*(96154791954953909739363037506515114887863674731739319332259506588925\
07485463161314730976420275750788614519669002033748306788239395506483422591398\
50964715167983614449269364858382969110882820967220275047100841094393825631154\
54366857410139911128593752303872519713983421048963511772805279773760842329560\
58464665852016636389282478812844305792816653498663724639400672417180830644080\
10865516501816449411517510833483586137937802693449438293923563512248707649877\
2886008791755144676523169743372288*mem + 377677861566497885800787650570982320\
12289494883523891297141355997969795980964904583755247199742508746370696037226\
85731267547704085257598849604276277561100498837826801872601478881194057517859\
12613799207723965722308719167890475952222201120085247504570335457997372886702\
27452263551203361731712634999378137049248546367142796618782628245361335765525\
60862534972162878220069627813572606590925303174329557595533958798439208665559\
43201350841445990692729992562399389037124417266647040000*cM*mem + 
    6108880254881291541661058169954221815534109952629415613477663957826690998\
63983733567829867864378939284216302861804863117943890445173000474447836269535\
97457793423773299630149290129226497557734648340541291188360210719436312499030\
74029490828908575675345235503982602502824056310749476830497211027061143415729\
10096488283043536826666711403261124572167428765225593968716703820150747606394\
00849142085444674780317642161559867798875671229276870786136646908518849164946\
80321745738490915897609*tailpot - 9742523521502300142814036365716023225489352\
19636886534686436421796385639742109184925222831790333575355078301800043671895\
94181489503381542578099249233674337391842601481217904435332654591316246299962\
61216962202417191213270251767960303000157217897624627379795376006258497907683\
17377954212434364802701418877799268479463693565181121593083385940640013958222\
18972344288210141877942588920866657797043380280677109836010124692287146415726\
5030468609841542939300158176553256516476026829944932812500*Pi^2*tailpot - 
    2211546045479984352704308565177301633377066849047874793034909008171602351\
20245940066900377765802951587762964058835232393143755484740606456579019734736\
28421634228595405181847606416748120424169340539032274290199084577116310805909\
97060813914173261056522804526020917204905710835740834538250272280156329088409\
31485097515503466660248177646836896673474177763760405367100526898741845240954\
37925439036837785468813785965212063196004077360693192185321855156718432352828\
88221250364810240000*tailpot*Log[2] - 221154604547998435270430856517730163337\
70668490478747930349090081716023512024594006690037776580295158776296405883523\
23931437554847406064565790197347362842163422859540518184760641674812042416934\
05390322742901990845771163108059099706081391417326105652280452602091720490571\
08357408345382502722801563290884093148509751550346666024817764683689667347417\
77637604053671005268987418452409543792543903683778546881378596521206319600407\
736069319218532185515671843235282888221250364810240000*tailpot*Log[v]))/88947\
77154015331379476559896271998036449802436149431846425124228602068537775329390\
39118290068620477385093151273325345900227851193452603633076787080297750444420\
90094982233881410911997771668249061540406932979783208119125047707661129051220\
11544429550916000680287510698093287718692346204614374243450282542503513756036\
79616950688853249421309178959033146823108168942118618585920330175699984844589\
97229772737762906792901611057859861891364225435730219794308961804509773824000\
000000 + (v^296*(229424145490271656447969394917056710018198283453111775900878\
50693710988774822491461868591125178835794037389213775941076076037687648306958\
08606228170259976693859891663523199909194794796469200572580591730066691247357\
58543793002183152380599924814247482087013272096842238848380597867938722870399\
61817360305461413172593125068827924462248428326929401644370990351280388079832\
04566660053437320159265894268990902654275004591797199962210267893579119278992\
18938591540383660485540271528334829027328*mem - 
    61*(-17152518486535436245540737393212526838134221224793495646791417631239\
74003785350590971327651904008926263583731754561367659118756396816026714310027\
64037339167257406788557492194499292917568903369708454672259984282305304568528\
01563155141580570273535851844801317946067752834728903207781403935825010073020\
84730271304111098707068904050641867329508605749741499079348390235788199656509\
74580370494237258446230659443382133947361092111326863552046564919926138483234\
082670330396016640000*cM*mem + tailpot*(-274441190678918232116710288733961256\
86940020825076558822159468044795542496993219096088229940211543769522848671688\
58354044477412937554608968022022353245222439021814979323018187540896017438297\
06236893634000884050403272374907545891784954819204442563214663414227353793975\
01703348476567257148886446833008394485434950519900698234139599886037018979532\
04516546405742654323777393675734859716169631054791371176100827318431728719537\
462880910692273089614024418187156044841865096685050571301 + 
        381074474331040413432781028699209251722015939018044055719604832933266\
60003461398045139067038831922402745205897274389847545473440190292606954159621\
66219688751583224890655314471585678222644712368059264259667252370444163594649\
25042757715992435984207165633949565058569446848882804583052458819610627493021\
68653189793869387251229068768514802694246706352118775616106935953828936779953\
92035976902505230722750961576330640642118352496969920527217374595644856773215\
57508777695990746496271093750*Pi^2 + 1001686360570592760394928561397434821323\
96760827838131024771379038959473685850766978350095019849255883789637486878386\
05024004419733246133713620623634842294564371255592387720838001561677778386475\
20847467081670656599810090684450240772341638564388084271455597061554482222155\
43150975262767556805073074329199968819227909904505372449040324306279805635435\
00100647182961724402490535063657366644866950993069694948696672917918909780594\
64812514371981518445535345585952663993693713408000*Log[2])) - 
    6110286799480615838409064224524352410076202410498125992511054121376527894\
83689678567935579621080460891116788669958154906464269603728014156530858041725\
37996842664659113565097111809526234448157498771695491981910052588415531751464\
68711283995242767314055879142075482341555148132209491028820965109457534081198\
09797290250417482771939145978268306814376153506139478160665188551922638883099\
36533688401057725139187049704799305349661627353563376690872625177656080743112\
503615316517888000*tailpot*Log[v]))/24707714316709253831879333045199994545693\
89565597064401784756730167241260493147052886439694635056881625258753537014849\
72285514220403501009187996411193819567894694708283983003919199993810189580726\
50113036938828668921979179918794758069783365401193196988890778576418605814688\
10747873945726215067625078484028753821121332269307469036803948081052663980963\
39752269150588505162755647271027773567941658971590938230296646948919605166283\
0315672928770283883175248939014160384000000000 + 
 (v^294*(12666322062338199175879404385646481092065301176205667078365980939692\
11129924015473475450227124950099672595187615164339720242435720641864752182459\
22002582898190493763848014125874140762577413729457809000173926227185766660732\
73716800265684831057517336425907669520999090344219768764268631161286734025544\
41018735628605651678897302762318180691918846379544883393005540980113880265159\
37217343488945937858269258949054422706392371441098573383598447968906746817370\
817482899815935497343900347006976*mem + 6708129536928291791714953980533763169\
02223012107463966096134576904869999186287445096341545631659492186907559367331\
84058348711957162275689579182654863827342850771435112468235114454818095749245\
20139237784582995131325570619261467418290982736931712902299122233773016291035\
49580300556278434004395755054274809637543063456961149403274858664502309162109\
78951669125796233168650017894506644332988078678085666361509505673994815890913\
73360877944237453212726554498374167045670688522240000*cM*mem + 
    1061631349655754073219092339234872063436606251345323393327880035151564144\
34438818274380585088761530907378511568039372051068309666657477115628642828416\
65393812648133903152555622326544513142817997923229690642757641349811070246289\
43743556172220713282265650649716795817144670640860624763170707789375489838002\
15888132283253157397057014948608673712306576021238777351687045745415745045900\
96642554806793295332087040695966585357108016849041435312857758481675208108135\
9236396659948157051837*tailpot - 12833678190821088187448067406640607521626361\
58953565130268188625029006977733638340959979688552530740913910573529332732890\
45690086611600492136324596284011815892270199442052868181996935694891627391713\
81160062679110707053082018189860294993339428752978400235739058447055706826805\
63416613017832619474186529575934148880931624248664300544893828652632441978016\
21266157577989321731677850632176830835737665576965672023082354162294204902852\
98405235837840432405039967507946110591486287026889062500*Pi^2*tailpot - 
    3906851415193466969226735928189698095033114960121981812622615210772157205\
92101289234456017843188962070680389888067349480387626626467803295691454720497\
05478953839738604405497925871970968256075994359984932943906031068822307477537\
60021652104251136521287521218421838579783222084687145173776319477179973474303\
24268685516003519879160274104820296386053339417289564101371620128086953391122\
78237241176341045448227359586431116131594170638691995059198458871753519343449\
687722973236224000*tailpot*Log[2] - 39068514151934669692267359281896980950331\
14960121981812622615210772157205921012892344560178431889620706803898880673494\
80387626626467803295691454720497054789538397386044054979258719709682560759943\
59984932943906031068822307477537600216521042511365212875212184218385797832220\
84687145173776319477179973474303242686855160035198791602741048202963860533394\
17289564101371620128086953391122782372411763410454482273595864311161315941706\
38691995059198458871753519343449687722973236224000*tailpot*Log[v]))/158835306\
32170234606208142671914282207946075778838271154330578979646550960313088197127\
11232265393709616237770130938117678978305702593935059065691214817411507894465\
98182560502519485710306550444752750726666035327157355580442335109159020035920\
43624198064286929084840532309442354807761079668525434732647397327703135779993\
15983372952231109480676712559190755550301682354676046286303885178544365339236\
24594174576619273038591174749753377436116849518249632694574650910310400000000\
0 + (v^292*(95165833932268530087447072019165356287987691290633783987820871941\
89972844099020484847233531140273651693710614414583858625533555905719283931318\
14230140167245520744240754602778687773729123008451873295432780172975010200085\
73708917186240554412409602567423801723116491216637965676312751394189063419892\
41216662784998505947705721504585686233963144014437761226033426835761559607266\
52422728488408730328486062260827285879513489817730457646586398378238962768959\
52654630952597941583340466927042560*mem + 58536818785258086364288149545748979\
14780013356937856846849884241459462616380131511185767592244928505347814286936\
90090397815525817780203963552000567020796883748531637702828980339695512905095\
20055578222344625283027063322906319012421031651567296334584065293763257355931\
29787032955145468374837230972977485331324914225605182208662139619511780181807\
25628027978710094011478785459391466009124131417918345301440856468762455820982\
4959960738779643339985420676741761601619287720591360000*cM*mem + 
    9162658219148427788965720404965980613629121751177159553997452817230055427\
78493935133828991301757795993823023982734606450301793931916668966347265948558\
56764768445997119486598392784621898663331753858272036126895468910430437337849\
84126216801086984609269864228826044642492673494711068538730975598102541584936\
22166485570513744766771499077388652070439597330726727966621567812162167972263\
15364721062209525937413848225543045512748370221600692691972241209316299614577\
309102500077341489458*tailpot - 964232421719835229380235362289472542195343656\
77415732346422842291933091637225659958871439160495416765046410090586251815532\
22503013993966251554904629220561296971693912522431645465015301473730659124578\
78214790467093479089084379796772939741062327663057881894592149642964771275093\
68529532853579415657837876625997590261225115391190843157143473725506794375184\
98965365261023764440858935404834439507085549650066839733457209465245237456366\
633799575405526975110343317918838413264994441023046875*Pi^2*tailpot - 
    3399916405664681899374008192730726447062059747140357040314384320177815360\
74431172785628120232392273658320198487220907715022461316632031414559774682010\
12160490819722680992123766202468655741414384323909352436991602149634657421616\
73588395139140670316222621327270930534960774738687756845780949652040073627908\
55061149074878569157062279449280545817623481207910939274672018372770512988804\
46034702046763020183667321034823795262453456283143322605228415785178221784032\
425282412436480000*tailpot*Log[2] - 33999164056646818993740081927307264470620\
59747140357040314384320177815360744311727856281202323922736583201984872209077\
15022461316632031414559774682010121604908197226809921237662024686557414143843\
23909352436991602149634657421616735883951391406703162226213272709305349607747\
38687756845780949652040073627908550611490748785691570622794492805458176234812\
07910939274672018372770512988804460347020467630201836673210348237952624534562\
83143322605228415785178221784032425282412436480000*tailpot*Log[v]))/138980893\
03148955280432124837924996931952816306483487260039256607190732090273952172486\
22328232219495914208048864570852969106017489769693176682479812965235069407657\
73409740439704549996518231639158656885832780911262686132887043220514142531430\
38171173306251062949235465770762060456790944709959755391066472661740243807494\
01485451333202220795592123489291911106513972060341540500515899531226319671831\
71519902754541863908767277906034205256602243328468428607752819546521600000000\
0 + (v^290*((1361686506202862119577801379762289663392878288919741279099116391\
25403601383481056040022534116550767716819790226165582682700899079729906121520\
02224150876831574419874107446651855937009841118536852807201103127376134287553\
17867788114682508763676634001688859312650798914361300449208565812589084192440\
12387993553607142294845651389993582196835687272117051357195257015442221911691\
87157149397862829047639904744173320915549893099708460889756321591332475728674\
77317050418511504212081008105750528*mem)/5 + 19458874873099458905542958396863\
75644696672298935674819298759104078307598154594246688002564746865669510152512\
92729988713949074633746239481805259278493261172882617869940666863645427337240\
62861961582448002236733477306844182936346785042113726250752721064289816821738\
13237194370041144433370608571759934726289293075481075111489610974391560892895\
86121617654798310914692102742052282443247479769502709297396328433108176818332\
74230921389053807148912494079219402814964308592767795200*cM*mem - 
    5*tailpot*(-6024610027776621893522879449896387391043200067449629051501776\
66694709096489380784331332809699546405783060527811675032400625656326885821747\
99748022016697568370542095237129890123081285826516505821322175352009039595693\
26259238956059101471834897301467371362385112363218234033820630014540459658083\
98346883357692957358246713461621541017526188370889345042566072724090995784385\
46207175952245674371325949885306678967667236652292057342059166365869974501212\
581939972404747301101259038615 + 55187136446510812449916876340301245698952743\
64500519953897510691921320410771278948901206404244579517105086211569799580536\
60160928228819400321599964471167593209780853982794049689916435285847536972083\
93343447811850467063130826331004809980584592129278448857344241820788726679914\
46096561197667179806948092223510485897654866519617137870751621721690117566520\
53213920745312239143680537707413458633148298810280881988262933311765176003334\
4782506048549506670396977282377836917201124078878750*Pi^2 + 
      22542001945594675999752024100804179555821142417166019404927547307784303\
52222149143642366540436318930269441266385762503013219301043666099198812066559\
84470648897839327045123676485048184059775450470286111618650372453699804244332\
20957382067909262460122630602446426741358619353835548743327932530614857620722\
11940342721092978748021109321183139422092346050003227167290455382344544312169\
66404059656464717701478359728995555994247179614898563447010671723941052667199\
15153245071552512*Log[2]) - 1127100097279733799987601205040208977791057120858\
30097024637736538921517611107457182118327021815946513472063319288125150660965\
05218330495994060332799223532444891966352256183824252409202988772523514305580\
93251862268499021221661047869103395463123006131530122321337067930967691777437\
16639662653074288103610597017136054648937401055466059156971104617302500161358\
36452276911722721560848320202982823235885073917986449777799712358980744928172\
3505335861970526333599575766225357762560*tailpot*Log[v]))/4632696434382985093\
47737494597499897731760543549449575334641886906357736342465072416207442744073\
16530473601628819028432303533916325656439222749327098841168980255257803246813\
23484999883941054638621896194426030375422871096234774017138084381012723724435\
41702098307848859025402015226364823665325179702215755391341460249800495150444\
40074026519737449643063703550465735344718016683863317707543989061057173300918\
18062130292242596867806841886741444282280953591760651550720000000 + 
 (v^288*(99728890593414721960632845342535508635260412893596497112977061037189\
24556797871118122059419070183802577735637463671608928486649666221348810403767\
13950746173725317412902656649123008615323252862727885185406493927680940634228\
17205301634450691757989381350552973853991285139443003314179431562054731536678\
53210947091042197810591955133129277755547315087735264301196711300977668535600\
45085809167588361174275493143490183834024770709085701202241633063646744943478\
676027653758865159208566784*mem + 8278660452990327371897065519900970685940505\
86312893409516227471025180945508020997964723267677349390271803817246494375782\
80231692134115574059033772146635518848247789908421525073673468408842271037439\
59986923468417865078956574183696195413106323876062018240880899685789168341877\
12358313662682157705140325626289166332418302469128375208100250731159386330995\
19258045046393679490605805327393128923917002310530661671579244175993955604862\
722785727564680208745797916689734565888000*cM*mem + 
    1267355622029514138667008956978919423857577416299705913387414030096938640\
28691380031769716423741842698652476498485578802336423193230071358865587834877\
77740738970359486831410875902853397600562167319436597145285941210751105930165\
58802700504811662200953769854714545615111923643194599039545742097823547818322\
19517383791560104857275684422989998100326538268837227196831666661939797288081\
57044401586740430549991596273192492475309876028197444391321567073918260370336\
36549060832131437*tailpot - 1010466207525587908622617371601149779368469809707\
96554437185582772604024367108778792145371720384488422899991667481502036170156\
52775739096724370838883031057862099602558590262868081395132020645228570008476\
02349137663056685445121620541631951335389211301944910138127198015483515661006\
01940326367324261694503247704026140727080683427898860925226815690092976469531\
27319552039980073869852037408849823558736959180302016262671996911505313898484\
7797372565841665998282401053593266442034953125*Pi^2*tailpot - 
    4781920304237337841741563997990197966266351912852825540310558181110801167\
25321725233286789227737445761392176494643746445441278280949599206233607870414\
58586075775556120875535113873116198153217057123636806549741355617861157678968\
06943246486945334620439749003897819848839625245753311355638277512189681300613\
23432653701756284375188554586708285814531502471598230197353492110990687290684\
61442952105946390898504395398249367625327892855382925835551297145902478427956\
7765624934400*tailpot*Log[2] - 4781920304237337841741563997990197966266351912\
85282554031055818111080116725321725233286789227737445761392176494643746445441\
27828094959920623360787041458586075775556120875535113873116198153217057123636\
80654974135561786115767896806943246486945334620439749003897819848839625245753\
31135563827751218968130061323432653701756284375188554586708285814531502471598\
23019735349211099068729068461442952105946390898504395398249367625327892855382\
9258355512971459024784279567765624934400*tailpot*Log[v]))/1976406328661683060\
35724187114974359100580436667853914391912067792814733934498751030805223013683\
09100031400012294807351665330169080911450180353808489266710315808557083296422\
02851962407824682013063948888407009545828869921601866048267100845141946981414\
42705673339525963748038402400326289959609718302993069706203694645819323869643\
51567417457225874421102262606853982655596423499941688441784978268369101237593\
080469839130727802337059905660159745231574034094542028800000000 + 
 (v^286*(14605561516847257551055184932717149546596832229492871551561990386540\
56386340010359298904270943037742457925449973976118118359871651535774411797995\
12653855170634127411799039532290537121893271510194208005808135537626711921522\
51808914780182523229617642511277445769399533382051742041560718596244998222697\
70548369747230067497821345383899138952198008867472799641192600143230315114974\
34934696308161498528322665333984938012714396154214030283866362130922716410431\
5691878475660677200478208*mem - 
    1397*(-100845363415529110577599253794322580916749687211112084785081275788\
58571413984586038615061549119792510896909122439655722224346968925200217031937\
77360020324836082050381268059010709359669205487790845907066854781005734692982\
86174936318468700838605070274259161136633783612551571889021909359427381737944\
84635315331526930090788224011443410404598791368489199713286364313025812624592\
63788620938194760410739887571900822158398594655638420101009604895358006661542\
25593483264000*cM*mem + tailpot*(-1526579757231465581697533266145846692368798\
33114584804279872649994982636673338333022622781203744729626788830279181399343\
12471035097830051227383321314736634802470766813428846008009545205612561371278\
58826599662500134106449887036798429041807358085960868306229102724943584638012\
41154603584282553958344457859318315873842493004872903124529002714695601321682\
38377630080421107023080782006134460331479163894058982791690767833787860943011\
18891747328064361299256633942930382628091 + 105930919167937884295527774854376\
69789146659439106037681145995697997109159788348646804887398740125307395753847\
99437009733099801659837358970074903731498988356992526912120760419798305874982\
95472532069980005072542993428259747325527847778461896073045796043507292534573\
08079872795795483154292361535808396415831552419569690078347576349465053919963\
44997887821821567501705633034840607568645986829751492859209691783545312868981\
18500099453486064383890998646278170618039717621582218750*Pi^2 + 
        580881373690906212438074940536281516848557521040604720345093502219648\
19479131874660674761382829167484106332800032764173766392577526116185219097012\
50199956160656366954453717370775570572122848712888511863398461079279645542334\
19235340304589155301085185738189343642960013599843060470843049585656919574041\
19736673088831848441852389547816696921717390782873270594496902464938122107286\
32145957662828208791533880919499429252235933050835354202939773279688643416503\
25570867200*Log[2])) - 811491279046195978775990691929185279037434856893724794\
32209562260084852812347228900962641651812346975296546921645771550751650430803\
98431075107852646529338756436944635371843166973472089255619651905251073167650\
12775366482264086671770405511049955616004476250513069215138998980755477767740\
27116271664493555272132305098092273267788198299925599639194923673959020512172\
74351855658387899107902854971007681772831644540702665373598472016989821506863\
27172503485285504822501478400*tailpot*Log[v]))/337270704549775266272566872209\
85385512044443117381214060053253889558828316467363657133997101311107679234471\
01074199206768827673904592397641698602131274182647748900526159798980976045064\
54723893014325748874916304748953911536154615745239052072004604336932944835050\
38560366559454334526670641571624283787213260444316492460635472635412231087810\
96565600870693277620133558975498890775032157301190830779710108804279943658554\
7317068834573217850101954320092208352460800000000 + 
 (v^284*(62901254052072686666045493294582854747779028441106006971761921732427\
04381107926613598821739908721834571954649375693498380828928388513574170205340\
53874692638399358796991817453836526725908852404836706684145183788019288446200\
48653850914937076411744830604351262910403248712808940434287275672402710410165\
21430400884987388998632375451478083124021473127704970860991767738384780136425\
47478101367574379522861603505567309346758532553296839656085769500005297044145\
01617382346983473152*mem - 
    79*(-89254142273335855074925981667635362240212590775031982498211789854681\
86225081402695312738023396380588230186081692529641111726088919937361153439838\
50139086111888659683424847935633986663756255316713006650768313713437741297361\
88850073749218033213215650904305407419324677156100901788345786636953354834681\
88158387659959951284891477149669032657866180633620801363077864507827211022873\
00958972373647377119307940084199631316113332663490160907403889541113232495193\
62048000*cM*mem + tailpot*(-1335932708232697147003955990276550763031316357136\
70942529752653104433093782023034651048737547769901229740120159352696049880778\
06969257858451666001009365958304527954964213364288593858326601839756600196894\
45043513382003827658391366714091897228494784522919349944102944276436970301304\
72485345374737167303057584279006418427780531629966493128871633769250653296910\
59874972658111906304734321628428308929927237098316568704810287738241423036348\
54662799842509090782950775693682 + 806739266209257613638185888768347562158052\
18807840743568960115684498621251318334279884890538267271924728284720926210232\
81922891300266762963570654988231055533861014559381722121416802692472661120964\
34752600071419877283711553990561975489217611842746727113925417115198188993552\
02583629990257985008529634032511440322042347007908753052932176743225552155782\
76432607777639289128223174059774045847194307010275760725908243966644100983813\
8527636176414001838482243954963000083515625*Pi^2 + 51267340027912081865269268\
53033587740818683881978841949347866911542034516639246540946192071359253464885\
46273848654543982890319639893879458628961651158643861817750562828871543993953\
46377287488201141035737605813573073423670363808496902544721516582875999362752\
75530335108812089015938702825500082155524810275401148795048687994458485493066\
62327063471488726701988643400928251810308744840766301714436958798174643288508\
741730568504897391392694083472700822744187139686400*Log[2])) - 
    4050119862205054467356272213896534315246760266763285139984814860118207268\
14500476734749173637381023725951556340437089746483352515516164772316879704415\
32865083602294463480851975522323638057115678901418232708592722728004699587408\
71255301032999810047203949657467668964735961550322591575232145064902864600117\
56690754808846351562220353952263238380142476094094571028286733318930143908424\
20537835440519745055796819792190596714911886893920022832594343364996790784035\
225600*tailpot*Log[v]))/16927861099667499812917429843899510897432464925407154\
21604760785462699674586798015314896461619710283037265158138024094945205618301\
84320299221973606267525730162060857566743574632405393723511289406909129128145\
10376879838964874252948466123874322656310827792854599999277437542388242585158\
92469967089128047242543882578421031694069233699612919642925918927270265820183\
47669920642982083525261051537381033432483651874305287830340638599544357810188\
4878543074099200000000 + 
 (v^280*(10010176872347841824926675839660810984733721875468835931968926236799\
57795002640760212600558428173259387457337126806250506344260199119945553037843\
44410082350867381951842740034640057317720258039938256513400871108947266093896\
44747460698586359129964411290903844712724643891994157176774286789399508946136\
94361329699261881952024844596167166723917880732864797131074014554137629422261\
59990543764578420703373635792824835791937614850860586109318932408252325961526\
53689739297161216*mem - 49*(-309435098915153374738549026893215189176103959489\
68769208429209514175009980715650508724251868730565585056200189157795259639398\
04363963273941800500044350131497555220233979905625912119348112598906209147326\
72502734727651632971191149380857614237634125462786397604897156174343646052302\
79379315210293628983056693719306819270054825907614147990318908687404062154872\
20253656812416137363964867494102016697122038298898990677604240983125047092548\
0080455040176113057792000*cM*mem + 7*tailpot*(-646716192764528538093533073037\
10242045377103818167039428923042089047338618470842348005334148691047978558973\
34567963736800174481561800809149316115494393449675110950535567713033542918676\
32270183367088081816641072184885100495399811301974686928730013333396858919647\
75988944693960251351040881956600902822721720288310352550927383846463565642109\
50949608270700013535733961468268535495827383375251860007171897686083632622883\
6882891615062556617535256297006604221883334417 + 2956983137003630161911113918\
56474575821270245639824021736805688252752936614719341682306637034346139411781\
51729286952554014787875030284493062726185955862391200033305192476050373289787\
68984314500388655655840065026484972343627675949885163744628423288824263306421\
71745762627669936665425110789474588766557946879891770467938332250494314077050\
42374109153316134820865588729704417026645837013585144210372742872665619292083\
74884713676948166162987516049335581631336507123312500*Pi^2 + 
        252476033266709472853985169785633445515471696821673693808186140706485\
21889313983253490312050218249715167703763069720055042683446975490979854562955\
47951576224642957349421511254128301143698042963009002620510036322545330089732\
94363411099725221284593350195719897120575892582354140925214435760974820818255\
92483975811634119472944585786960621386075694183886930307641151863663633087024\
00187997052872236808455117006658090580921251122599575849279198169658129344225\
2800*Log[2])) - 8659927941048134918891691323647227181180679200983407697620784\
62623244300803469625594717703322485965230252239073291397887964042231259340609\
01150937294739064505253437085157836016600729228842873631208789883494245863304\
82207783996665000720575090061551911713192471235753115574747033734855146601436\
35406617822200370339050297921999292492749313542396310507321709552091508923662\
61488492326448298913517722530010513328372506925598913505165451630276497219273\
83650692710400*tailpot*Log[v]))/366086961497999563428145109080871775463504864\
30378793719826141554124127910614143929820425208038717193712481793642389596565\
86544770422151799783166225508774441221039307239264157275203151460019234578484\
62647372629257781984534477788677900602818396546514441886993944621051849965143\
65452333314661918017475070124218913893188401688348479662909161827982675762765\
26427732432307972382830526065334159545437574231912886555045152040238724038589\
05298850536017100800000000 + 
 (v^282*((1728929318210788291399260291121153047635515450886666703943930146570\
64936894689771440145882645226450875193458136814148972418459358141939581175358\
84844707235283180091060480085736211919882013189050018094397170810261135640075\
48910111751044480548512481640967833301473873833521767625739077936816190820877\
52905681435593415832925141885362589185543345735822162196416436347994329304229\
88317317256393892433142728194994756131108874262077208421870812358858313025664\
88640082310856704*mem)/3 - 
    6083*(-123442321711318827438351344309332201570195230798138046495160921490\
99169805524429075378409190454583992399064809153927123722008317331285625430017\
17753197659077545878454177303273925957933463541840671451649728784838795462999\
59819842057179066845962483947310459285703129155959321050315189344081806789213\
53890228794025469147232018772089358936674551402946258322794503936413474787161\
26221629656248457365130366529828121316788811310697362639532318595275364394598\
4000*cM*mem + tailpot*(-18267536330404525203409361347141501363084250682759337\
90964982904843792253747711714859677682045618358003909722499464702974604718069\
72747314000900073028722278828296881654288578937503373875979885310129623012163\
12938838473671955246702414479291994244814708334037044895061531442900778984104\
26220156355781740123868356232139442316110499087522013231463534710254861702903\
05741959896336027625944765316423511950340251307912777382159615009296092579658\
143832488556144860241 + 95992932552726275714464146779549560673952189638039826\
77268850927045858695071391227202497828996314580906023191638905373818272517661\
05253470351820658778198212801272171967121579279897279403225958498358426045390\
50983285412445827155835264650246206761926671010825293425923662950734696533107\
20540954887226764513557360907305848001188362192963638440163365755482569828948\
07524792033159526648381709393400207666512857852945329858463226684112543443839\
2130126799970308989375000*Pi^2 + 70704799448627224944096155230761760154621642\
64648390386912048941797593715164407494772519741359783784060508239478353800598\
41017768809018762991136731506879170701970847387789259346964829904250910631127\
68881134301114134147179351652286179756442338414501906145445798355913048397777\
17422507673748399270368746227973988842440620891385313771181217969079762506714\
85242580860836341032297229365705319113083215807407841929876303177128012106884\
96870626250442100173619200*Log[2])) - 430097295045999409334936912268723787020\
56345221856158723585993712954762569345090790701237586691564758440071620746826\
16904012911087665261135275084737756345995380088664659922064607587060307558289\
36914973103939953677278017291996100856831458438744575415095082746791399019073\
40367855081114179411512761653083304765774128566296882296863670095348905912195\
32834644730619376467462499464046231585456164885201756461902459437552226469697\
64618126464019481439295356125593600*tailpot*Log[v]))/180783684690370154779330\
91806462803726592832805125330232012909409444013783019330335713790226191959108\
00616384871229115879795824577986247802362057395312975032701747806044081065321\
08797602963912818690598838208705806312091128137179594024989046121751365156487\
40441709681572837784871828312747981194082703738332947611799105383549801718352\
05390707554700037667420458139472744677719916309168066251627376579867611302002\
4914331062907279202908903646940050227200000000 + 
 (v^278*(15167238212598268224591033075528365287461115628288279219161008671118\
81297937736070317042932166225030141332608515851801493150293737071049280081231\
26254521311343785501007056527650792964686431882977058860543601201114323576460\
05000293516865303715650779723505691055849480829378602419889578013926548021974\
64788271133986835464287635701903354953420241782111506545669985689293336766123\
27356094705409680745802573305859333383321019378778679859445239926946737510558\
14592395476992*mem + 26711435707492031803232565616538106905015419331177323489\
43438294927480468297074707517539026167140291713255159880661507302278377594659\
48282036375516058440742263126660405580270460160453950698164193105002802264202\
47970103318868279110957571218799536122110540635458207199321878227165707440241\
21106895173568418117997873190988350121046787139947806642360962847793902282171\
60483151771732243693792454037107846229794401265114168579882563834570937767971\
9190010789888000*cM*mem + 386306381488146259280987059532863080555009538837472\
48449856199287109059964044742280514644086241981865866550891438980664002984466\
18615144333411670237326309896789683450972429149492141338105489732240129581515\
25563492866708815736938359858082489621233349125896485215471916516112264917005\
52548243388036816613999027356169476940177392491573148385448349859172649434705\
50443165059098093184097038888910134432522114971863874763091082533127610945481\
6664520658401663071259527*tailpot - 15367664411103723220471634686542109847308\
18816494206031557792215041382429232565001353092589385993383960284885984944140\
85333435792359370576341128281285668198677367070989658080686395317384284380118\
29429711934337040947727600684856893707742012270863653871707077546705048470822\
81653188028524929358725525967520862941054979195265252035730147131646855045502\
94513932310659307057140294222854214842643965451166477274201667924733949614958\
5016859871414010060236325652842670625000*Pi^2*tailpot - 
    1521251249162198289702044902435589775222936885582970118545613652876680857\
73678895986050593415392600135269287422954907688282866061708785414891935133940\
33668842077069920604781578342692089613440310528614357852200360407029823983757\
46456392980649933152522371114915093809469587678522666766032863876793828504145\
88043072014757148976930876457114190347519764808601474343351782680087236135713\
49820706719401836620430501980829204182256956670338001199957172364710616678400*
     tailpot*Log[2] - 1521251249162198289702044902435589775222936885582970118\
54561365287668085773678895986050593415392600135269287422954907688282866061708\
78541489193513394033668842077069920604781578342692089613440310528614357852200\
36040702982398375746456392980649933152522371114915093809469587678522666766032\
86387679382850414588043072014757148976930876457114190347519764808601474343351\
78268008723613571349820706719401836620430501980829204182256956670338001199957\
172364710616678400*tailpot*Log[v]))/64679675176325011206386061675065684710866\
58379925581929297904868219810584914159704915269471384932366380297136685934557\
69714937238590486183707273184718864742265201291031672112592792076229685377134\
00788453599404462505650977822930861819894490882782069689379327552053189372785\
36106970376910717653359977927583784260405156961429036833862704798909537575223\
10340358256613481973919228008138751618294246921242387435787110450890501541349\
574037630477978828800000000 + 
 (v^276*(10221029391885045994190570613151253101480821200934861405383481966802\
85205532243581146328388232227737242670039971886537284961694240043103191133745\
42219563299415478012372863367008568177308152509151573232309247865542304822394\
44478354144663385442947969005306455677335400693219661688025847511766073731829\
27419772299282681285923722689010547360086030149056979619580181938604186160703\
87821141692922459830287983625892171329772371442798311014223550580984557136546\
45981184*mem - 137*(-15279215009959961083739779921886715267016004011765515059\
86049635715989526392431282626327432575184388744171625515306771399854082562707\
23499601648127590594858944101302822150932478574670679937370077580767523431387\
67346251045594975770434710041760256257208054426906456311230538031799172589186\
54354214983615950358625804232388806473211620899767427520519435618207776126943\
57237819582880642143016126744416300263654920766800707015394761442287914009157\
95968000*cM*mem + tailpot*(-2184207124803872770950481012148064659853721684422\
57162604249927757695275799242144020178463337798057993379346566845657632183705\
57814368095108238972957457152428990379286215372801037371587531339831351493573\
40464244662912876946454800098037409369931949507824866439175278039001842823077\
23888628568897054540236882870656940511777222660729169165253710422389941380046\
54988274296479848094625543979142941574739901575590458827682421832131951858911\
0201841333109547978 + 7559195816996787578701426635235523201357356096061777871\
32281979613911813838471900175781104938440000943529376443136131628624003369949\
51677914141513608410597539734712778257234251868434786574655010771694327102928\
88640718561625187807834890537856171372456715196198216084689513832879049313551\
18590594305093702023178969568082175147201742619494329382473877535174541510418\
21332455678930159503785539816471534560950382754341629540742130291365920990228\
46767440431796875*Pi^2 + 8676628593724983582335797381092072394414125461087861\
56563363756050490356832582808943495436583208207729276169536846944743897484681\
10887838038498724817445463492148585805062800183625690232425592434574170816664\
05613453034587321920293551181737945230309610495683064533013086653618212662709\
66532109418826860192311333566544287666282302129192525348108214587494349096301\
21868235554367954913802017117798215026209886361610158628544267532190079710011\
603249766400*Log[2])) - 11886981173403227507800042412096139180347351881690370\
34491808345789171788860638448252588748118995244589108352265480314299139554013\
11916338112743252999900284984243562552936036251567195618423061635366614018829\
75690430657384631030802165118980984965524166379085798410227928715456951347912\
24148989903792798463466526986165674102806753916993759726908253984867258261932\
66959482709484098231908763451383554585907544315405917321105646519100409202715\
89645217996800*tailpot*Log[v]))/508340945200798913572064541666134991691606389\
02625513446565025748995656798301746860305111975347795342073182732400803523014\
95614779611607520051378097522609357239425158693649263363995921224719398271631\
19896125998630157713631771082436998529441818578191917584594645992270890067661\
79048647173755182148387318635679775074168490790689752199872984148749223676667\
47028034448225465582504496645244286984951847597451647535229201697162623938782\
15760281600000000 + 
 (v^274*(10270767195062127393023376322667496382787614143997643487677239972275\
01538496743669871429710271875284150120264469555351242579009065201997680835079\
57869453986502133435063885324774862823160331536072377932157849422442914423657\
41079519153315109099518770432084164563306665335125732322136108992643940961085\
83667302480531995164658213092847249655893484118245274703864217872820861701195\
55530355098777425685907189355946209307802139478246696537087448929343346049024*
     mem - 47*(-5205210263179232413329981634006978827790941205215824140665125\
48830496497447814448316150276688905466612341906309956813477794686934131759262\
83073854903978473176470919940302259940857959833061655152826220413442969957195\
98510522866859445059021663656140466909111413544280888106555608304924050960232\
20157901860137027867299638346062670681111656248206674296681114032234702289034\
747727228619492490838984800766223479377331146388707021330591116165120000*cM*
       mem + tailpot*(-735452074371834690636621381719162827272235133493500473\
25601275990677908641057346417018795815637157779184222681779562967605591542760\
22766476472499577471650721037681239299648374577566219990151647316355489147803\
63540573578401611372726545156036257560670780626763637827295478884725672856250\
59462934771274133913097338464950956422739169560191589316146507198728135729926\
97787124402678835632524284125875293168073093462613342474250461492760121883387\
293657 + 22141484898874642607429170626174123809211433493308894480319779415375\
44634226112390307029752142144919629537972447872784785769004124592439711311496\
81671928818696434900435496598214003707055654411838242224387373790780273747209\
25317529073786793701405301960336814347600455780536263621528482836459173732872\
30789070236399800599624373505542058012075283473632347237591317959052862000469\
72103366212888276798160004744670805421788270548675596493410003444126093750*
         Pi^2 + 2947307996774262381285354194291425994479736711356164848306462\
52453234288686244971813357122397233875531769366151292057601932141559520786089\
78914581540689587993180030241149662629623532959781644609321369020463518761837\
76321485619212634910871707194626037916752971431361591162351314249493959772002\
41814305822970360568311308381394374615969689580218159852684144808773284043596\
7918235701548203395535162408201796348488009522265700899472838443402752000*
         Log[2])) - 138523475848390331920411647131697021740547625433739747870\
40373865302011568253513675227784752669992149993160209110726707290810653297476\
94622008985332412410635679461421334034143592306049109737296638104343961785381\
80637487109824102993840810970238147423782087389657273994784630511769726216109\
28411365272373679606946710631493925535606950575410270253513076154806012344350\
04904921570779727655595901526331854844283789364475464879422752234068399293440\
00*tailpot*Log[v]))/595859093871255310914632633057705693627136951615786642848\
72266573865550111628188944761167890452813132447893960263241467414161622440716\
54383242393192511826126205615681831651253414474577909880923619627703843352213\
22100531915687717776984421179396640481451734212170988927344864764020974772813\
64312271092515423173122054484214748223559492715838494570980136320771071066981\
48778439441648088618168389790165525644042066740635034766607908864000000000 + 
 (v^272*(37916082761975357113255420712447886956056472316950994452333180123864\
29815383165326083247542979544283390492035879394353879892877221456298308306143\
86705537012631953606190874989976391990674103091036940624162135735395322231469\
07436296213109790923141283868744118506199788144380145204146825714468974825120\
86086546922145313643526819108017172027205879035567667677433871190993802896163\
47290776744395422944222828992383542620840712979249260644392170483039076352*
     mem - 73*(-1439165592399083010792275331099746075094100303424773160241452\
78769509161614992012611655394595079878709140790729013263833368059784870592651\
17762139267510078216688415782428803592822164531629506727911574467839652629147\
82417372293565960392059722344276821691856240441849840069136022341384696340144\
78063596376035761275336662976561093340237901623800779843357539494141791759976\
1315222718794535028442927412242252519850861099286716150910088642560000*cM*
       mem + tailpot*(-200962440649560804209121729874041215625971105355593570\
53681923092217645395640824028591789918483607049647563074777234735661471870112\
73627188466108687519232313897679759404778046352893913609650470860621310227240\
42805188778499151286382832771145009785873314646312204844446843708664030617758\
42922048265122664285539369930092655332395297950765061495407548640653551863499\
09677476776092310618099839097212667836437085587865889522847443111860695060204\
8533 + 5262626361114712380023929323572423627095728421139452850675082990271791\
43881328888630340853197039791461120796245055713902481572375199958429655629809\
82269717369688148000176050907043836449161696966114685185488274940194304541723\
32088250809495689191135454256884290461220732935702252339052433230002728095505\
82211650630400664702511673914844174497661346149069929738804577213160816519483\
134202445357447308699778323407215602255847083777816635020675938046875*Pi^2 + 
        812505283347267011851974199523494559951884209851849242447870615099989\
64009862554200346534831312057644847515633472943913410671775887788652995896325\
93533787440962879444655518768299970750787061776352033443814171634410266398438\
21452327838786176876453781928689841378476704098238523771435870645289143894022\
18118986018779513329087738410360847766254186188897424612987224745985994833123\
78433006389590879806650141270228349105361881772680227862016000*Log[2])) - 
    5931288568435049186519411656521510287648754731918499469869455490229924372\
71996645662529704268578020807386864124352490567897903963980857166870043179327\
96648319029019945985287008589786480745550967369844139843452931194944708598966\
01993223139091198112608079435842062879939917141223531481855710610750426361922\
68597937090447302340490395634188693655559178951199674806740645697762281803625\
609466440134225885460312726669484691417369405656633927168000*tailpot*Log[v]))/
  256641136246692887680833781148548677092510840640302776333921237571957111334\
24143201473825475383565145950070596475007646685506486533718181995477887351639\
83335445138760915838332293385667798460346163752698219977426522530458840067158\
09620138495050841786562552378213862350671744687151395599246854139919110009322\
28617712355092044068949625413344367466527603455347073467895144699459419203228\
660417959031732883746355883124964931915481088000000000 + 
 (v^270*(15038491733931544136956296924639657927471641398076424279945995786564\
52974126423683129636496959001263820464136928270992419578894169022783777191676\
29132347868502853257390735806424647003194614688943963072134193129158840949048\
17249174300104710781643744228023087918184078040401488427450888212288348826972\
83173232894381906910070609658324250391828351779071472051735138487496646520759\
6162847586426785757289066326540885029812215295194393342301956904845312*mem - 
    2597*(-186676935624675028760900473099534359321973038701879244200621225071\
31551757793025836753778804647195111503474492432797066475097177378483640452292\
10629582644746169056065315073997273802742886121855158333910314138421493092497\
03064495429105026206054610027236366725103611545138818010539518127945924589384\
99271960042263260477074430110120544986588938316530825222989386070984321328909\
62919466144193246137730419277425324791107365755515043840000*cM*mem + 
      7*tailpot*(-36800099055894832233974846439930567227236012674853109897287\
64800899035299697298656053466474483735705323261877233756892112687538218337235\
90222749717982859057685872343257611238759327450547557204084964194117276025883\
05200878750526642223752406337362674881025424356869012687138172050109587554292\
94061889908398376648863504161894051107240240534089398579799575042846537292376\
798965191575937697879961090011845982735747661211773190176031452418803 + 
        838178424916674661034546153388769676458868477389294575035946636587709\
61984079536357727865692672657119755828135317035536673172752184702960846557732\
09867010282863525903389533345743218556624354033976658929598902228373925336789\
85836028334016921227357473167044422468497099230450645858786127560307336183782\
84967287570429635272768376297640674066264013379424332503650885645345908070393\
082939975683531334129281832097876998916105956698353855388906250*Pi^2 + 
        150116005834149550378335781592111925433984540974760272038652913142492\
87022634743491108798117275172969047448368360762446730999616669417190976677248\
54480240497731487765132418186379414995775011326357370714026970785653035599580\
37144762845472442472601576138003492123558726395248369617596356697503960530613\
58327308947118429925514421471982157984834154307324849395545738389220641783163\
11938349841701351197073850721776994715055513063790080000*Log[2])) - 
    2728958870059004676327766173563002692464404970380166985390671308017377887\
84477001924866840973945369404313563888430300519122842031433335114765015701295\
96292008260716082342230210191385208193930901850642210296301912386534164771572\
54643767843531709424052612765483314174087139220111278284168403924498486024330\
32149349665937615926667939163650006300091152858437161625978177642046976122347\
27261772288863411605532271183986924994171986639864320000*tailpot*Log[v]))/118\
78234575890627033270100025388719665486940694265610308892031730628395414895928\
53905110870840672273717951985396418015675530245604633813847795884816793475578\
74902284592975947990992579274204403691740845053224910974846360216609606502647\
47685598946671598748143025727221636200346531120781229605393868328705420822279\
78911186339168237972110216808639568990255269234169577670309148357826679101194\
943952223127082586128072061692674048000000000 + 
 (v^268*(22790179288933577259628772912272927472141175791320377089684936396190\
69179970370787880914512887172146773941644347524304929238456682554621854140999\
86497061954071436102829967136858317734599663940992935403493316828295785338758\
08975889894186699651339090353360649241625973697617308959388057903944434176420\
34003904083667974135459659994771238157598187318901486382535123897549806809312\
614860205135481476531991579833145379570553021973483191368882847744*mem + 
    8549212502501638284209750770779417774907627948017743027881607879761494049\
43880054058090690281459432807629434824449440174785268835364535507900055114262\
62577706256141038350358359217877340280623063017212953297979967805391338093561\
59894917706475398534555005641231662445554908238130602665405992588987364317710\
63291847302890641107878826905737561071795660751502773315974514971781858704638\
092138414785092166760661202458173992792657756160000*cM*mem + 
    1165731163949013570257990783927050221365436661187524756812941791745292248\
07920405041021090807079882614526252670988105768469941567636449707733867849345\
30958161112261427207240864698320973713417543296095362897588881127108827070086\
82718753729382579104275130347040089806440457409631703176598070619747060705965\
93091382913898210370061726863364384451149901946901799081201174318908429089552\
52620795375617914939710179944833163318642218229808745662*tailpot - 
    2309139748260459619162644830102104798692294148665746520399287829133311305\
42294945772825965464405222153644865011293780766611201969359525325881485146966\
92755235874094265692154719074861641350172528175824393762098918945486860742853\
94464541266447707654935173543197968317167266558955966481306951772070477110182\
50280259122084651362448090155168807479024569467744212183973355854617472467272\
262386867213808108795181709849051556820779606141401294921875*Pi^2*tailpot - 
    4798108623300951903991068183387246922220156443566566026531746380318684569\
07770336428854433839367345614165012776822543123563213703385969146735579496409\
92927821734812899952046432166569639608218306806926523870207145968125110203525\
27919051177780939204281862346413358282142477510476937629166075233508946005195\
63909748041868488749751198835615162250853766796979274635135260756077270433386\
9113837755533235991364765746594827646824607209472000*tailpot*Log[2] - 
    4798108623300951903991068183387246922220156443566566026531746380318684569\
07770336428854433839367345614165012776822543123563213703385969146735579496409\
92927821734812899952046432166569639608218306806926523870207145968125110203525\
27919051177780939204281862346413358282142477510476937629166075233508946005195\
63909748041868488749751198835615162250853766796979274635135260756077270433386\
9113837755533235991364765746594827646824607209472000*tailpot*Log[v]))/2100988\
46425146696613724716085009917345749817261559966822736987053728670963545712780\
05244617848365779710886304473768940072963907343903062271664961928299234244875\
95513273072026036641053504876251282537668974734470193480057529422679100943162\
28415960757012126325673204308460993376047072214844352793237314510917434152611\
14356633148268831657590995112380775699571926697353709910920103786298344884537\
3694746096098085167763030016000000000 + 
 (v^266*(11946416396338558643256520572139090293911637707787645793405192180862\
79838099191412281456613311506759733947981772913714940951788024366297238536899\
28836707695440323175590823940457870180612492845660383665480131196224640020357\
00338710181930500653724463525676125076574641761047574226156723511844065018862\
54939970265373277630339278088449298800359763301465592726961167596806007878489\
22795134153702582257356453942882654131315963043143647531020320768*mem + 
    5215651415706091776202077163439501182826245127477015178963377262975932907\
88219488095751324780277778657227426959019640634315999181839195397680225613780\
73668197208500638981125036794433597924759573964931139711414730622671549798782\
98472224658006158612188261730608140926257558204181537532423442494553322638994\
17432458937136166819631848344280609600702890920667425138217806652653840050026\
95185831900840512196721625668978121346299985920000*cM*mem + 
    7026838219997898503317345968137326078396555015067313351572208364100172764\
54316040880397737144592800769881031043980805686257029113369254432982784211065\
11921528177135290319482573570521396635499377813831346231562361003044739355543\
01188270821727307122275961570925783205656383354873146640404329644039793217677\
27585393960666102337321855380011414467370362482924065757122230659402027867600\
900522827969264117708908886516864648790458333548182681*tailpot - 
    1210432166777070615095650308449027066194748777680799887471447703560676055\
66069094635121479930352929483982290732307169143800485300626743291037534548275\
96976177035933829748411546896427721107073240718047085440333670238134917416190\
84865187943547260828748970830465112080794441923400243598544032105301173778980\
21373472085532987416271285472656781198021755109837556542640339090191061297215\
55930369693098495204421266078932333731917411606532023437500*Pi^2*tailpot - 
    2918452334753964277250463208044703520464483467067745718692681617483486481\
68606830830569953637091390075074444537779831659889006271947927075292421281818\
54242413372691863882179859918198662223347962122746561072719993869255997658894\
71440825130777362944693113434294272471921993862515628935818104807259699266827\
76215579933947169956213564642361926776396139236131327972919611584631770001561\
472460671815959978876442509361499810672364055552000*tailpot*Log[2] - 
    2918452334753964277250463208044703520464483467067745718692681617483486481\
68606830830569953637091390075074444537779831659889006271947927075292421281818\
54242413372691863882179859918198662223347962122746561072719993869255997658894\
71440825130777362944693113434294272471921993862515628935818104807259699266827\
76215579933947169956213564642361926776396139236131327972919611584631770001561\
472460671815959978876442509361499810672364055552000*tailpot*Log[v]))/12856602\
22589304816301697985883055767275652325801058837568408992118450354297220075130\
08723215000762305118892207573186318404668436698545799263878457064315732310280\
29124887494870273418500844722447885147482348467391405366895705876787856325009\
05743425296599420012575881223362167338049427144957755407571512536056869507060\
81087638268926737388087577717213233831943831881100500377401619110497251907224\
37040120886690943537774592000000000 + 
 (v^264*(31579176821810470870468160898874433340178762326117622634916919142912\
12862681006636411105563924803042337094057703841850455316811713981325749485373\
57706351592051804620080273164752571958678241594105659013606697835522482288018\
15056931104257489168380845597130797791248635840535996618631935551148788292992\
21074126083402724207457192888278640595011762887909370990156711700081369109035\
034927029181671081004947604293931537903753831769287885324288*mem - 
    19*(-84466361667619554423116095819599806318617781263985483205433998392839\
28506340237651444180146838242335924801277902612968977000037158249282798889415\
21003874737313241910984127110449143772137114808213325601629729456232312807410\
22690103733945379553651357036567327474548986537817302778405210186237747184823\
01346695311111361944140505471013890500281233596139928527177752790195107346136\
6954193931640183048163385481711878811649310720000*cM*mem + 
      tailpot*(-1124286317155898472137622055178634121903592990134806926934634\
69560683096113517112623217747609561200195211595091019369761528288239797342425\
43401006873594993005153936437084793897087821577904077931717114111524680291131\
19631667869911585562167875542814856590855517965458897360059611825018739296392\
54587732745545773203226971644350497146019210774382389979657882691939393245404\
8290826008101597030176204736467715529715689004397183346980913 + 
        168403221586805911895294214948511090872970444206051104058993892907433\
17932941356490002532237429656809880931903339339519996512383074823515825736984\
29800676037658238706977417988375956719501327900953965056959928567944083174687\
44762665641084050381732094984429221268214345109408296273065034614210558673990\
24883641032494017453232601612735717528603824200681499873519227344834990114287\
389398221571751201383110729362107467531911601103278906250*Pi^2 + 
        471214096552852599778340358041598688769377037270314473798720317244231\
02080852793167852967894860126856460939488336456609371931618744263626184825347\
71258459140229234913770039081662820800578115472938243167828731065941128138057\
72659878521413096937285827850489674641986861662009015518911093429384502405255\
83472334680065115368838593809710573174855075996697033837059137938161637921797\
1613800000266446968567444330647822156269300736000*Log[2])) - 
    8953067834504199395788466802790375086618163708135975002175686027640389395\
36203070189206390002342410272757850278392675578066700756141008897511681606539\
10723664355463361630742551593595210984193985826620188745890252881434623096805\
37691906848841808430729159303818197750371578171294859310775158305545699860859\
74358921237192007933282384500890322246443937243642904123620825071120514146066\
2200005062492402781442282308620969116713984000*tailpot*Log[v]))/3968141539425\
69285817201946286900434350295303509291263875899564090935856070555860717252125\
86421173841413120545829115518239002453061321561111088839132870189947479479184\
89535310239535744921140963215075904372357869197393039045559304335687906607666\
36979567441944100156758332058946022745315594857222600571092350780722765308779\
52524051792085377995564236790096143105081342148156923091263065174665119526111\
8424053205434368000000000 + 
 (v^262*((1244741521270569828101935771111265358014486605038458516600696213572\
77531908115139524586228947459835548839512606821278492355218798309857370830542\
50614945958728221643628779031019569850760122897409201668091758166184748135159\
07477035270302805683994758926406309741242118957035998946583265823687395431646\
04001170269371516298789032226014673173798011669413756851371576538648095694593\
647570386889052004463621392837972453569613035217092608*mem)/5 - 
    5*(-294588100931299212919236991542425339337441807422632236591996516393147\
98969482493970031387625797677380710472358157527023171975957306357299965612052\
34298117214804961364589345066272326170352513200493586220280615838154441806920\
17604511308468453895014302419032834529991824273637218891440010854781991880978\
24313368957946726447359332637674582196068863325057440591961411029979279017623\
17405065918168589509969536909672290713600*cM*mem - 38735768073695349196327510\
31926986474058308843751085334197084956613730927124262624551416391550800122670\
98095734191801183763441142995483594256401150632858079558006689316130959729132\
46189784251910416333125009051669251419935639047849581388927950072241811631791\
47696100441280782219659120346153540559497727909104857584605142622686780908860\
43317588182660721483429796296667762212286944443311445597133961676713176171598\
49764533503*tailpot + 5044786604266834664359251258797407098461499790894790925\
57472079487631647439255619849054463443887553036628864234104073566378300662024\
74759511874358013089219099076369323052199936189902364265109147885723629706882\
70479134815548362628241614433331755649171223675956968334183631731076048281200\
08246792868005102310292360868481604160062553290091827839346597368465183466385\
383879363453316891568144563813094101041624582021383278982062500*Pi^2*
       tailpot + 163843923527444196752717319576660450895980979686124044201738\
91351446362181966780973995340742536345767037708009905718670756822781901061487\
34235089727083559937290454924538257520680389368286371530199193664456963389132\
98275346360154682135479036622073559856886068516124584559955157449775479649580\
40280962617774936354154387627091607349888504602765518598719853390087302740414\
456493811083169062482740728970763767963539040296960*tailpot*Log[2]) - 
    8192196176372209837635865978833022544799048984306202210086945675723181090\
98339048699767037126817288351885400495285933537841139095053074367117544863541\
77996864522746226912876034019468414318576509959683222848169456649137673180077\
34106773951831103677992844303425806229227997757872488773982479020140481308887\
46817707719381354580367494425230138275929935992669504365137020722824690554158\
45312413703644853818839817695201484800*tailpot*Log[v]))/365324934666497101503\
40573833089509826576763558341522980162547602261864012326686128233512180658128\
39830811292172936106804293487704126225676316238135567927893200722336612948548\
78238333511276285744161053973854040512371399856762316855939407810591888123567\
71075850015964749984505179847093362403975363226283413613329940938674785518781\
83954740542980191752853252892144453804676243070076735309767565654283640425676\
800000000 + (v^260*(819803965651877761144420043263570723673542854890392648858\
26679963547689570549677845942213271154166052218297921207610758687103092907045\
27550662677187806417199499739778084396681934234415433891368672763495459240040\
35704777463408980422811900756647169110279883473005595950071093371666976261721\
72762144983689023773184657246647461084733506675958598048779620366311364061514\
7724516394947195368371528825750552133495061926060152003231744*mem - 
    127*(-4447297666445722069846978648288574836265204202250810122561357510357\
64863683199417435594720214538541552390122446351809005203854251377332106990738\
37519787972435576532015818552095536809154397958699825389836329804626266507419\
21173874409301074753691764351767613901373248031427997282433545785314613297484\
08564576484574685672433094301161806544331635876198906280454632465283012695405\
8264379838890424015855626215814594560000*cM*mem + 
      tailpot*(-5776417010666829485473188125438853762083998548218572888227864\
48519466765738009942182136060225919520172458850048344414785602662072031544639\
05370811123602075604494104493110060279307998617979301503948955957645781881460\
48827350229372684159828671169645453425885027339076606532832445794616105017356\
94080370732167565216482679292249034113037414168468824447855399031003070140175\
89950474588664753161864977861537334851247896596002 + 654049221947064639084549\
02212186874409076183512730320755829216984601916324509511072871854680676827906\
90616230746970496887186005668356486243876240739131553100105477123874164174470\
17675026312888513314963041021839344678103787636737377407542209143202762830290\
36670052087015398156892084893354745570431845314342874421012026878906872213612\
08582852700104560566174663228754105392360392686634938191467862308641644369130\
62880335546875*Pi^2 + 2465937441166944734425281093143819202878962333800617233\
00754646215928399430541286238482440530065679609042910924277364409612218029045\
45835787589992812536004135950560849803111965074033006721978701611739599427174\
53176351723239805973041869555114570292257290202844884296644438271469413758691\
89668125589103740342570036336907673862728223849539095106505211287593636762948\
97062675544947231799159235413232461153873018072064000*Log[2])) - 
    3131740550282019812720106988292650387656282163926783885919584006942290672\
76787433522872699473183413103484496873832252800207516896887732114502392908719\
20725252657212279249952195644021918536912951046909291272511655339666885145535\
85763174334995504271166758557613003056738436604766155473538708785194981617502\
35063946147872745805664844288914650785261618335243918688945192695979420829843\
8493222897480522566541873295152128000*tailpot*Log[v]))/1405240997142401593453\
31100297664626294917848259832892504239456648518632224201678880286898877479892\
89931610969996062575223041348304285616113463431490076963447101084989553111673\
08382685181231066085295256146846655213324519275546912730663252885641040128345\
43842979460417899310493385925674075748459549791311147986012009496657967841245\
71697034823008275794484063427548627036781294337087813949694529184434697011200\
0000000 + (v^258*(60031390153585214376415382205304628921011693243676123473526\
05933352688779553602730936619542741797814926064458215541075411044890711184760\
04922999964135357468321701056379738228272211646443967485465089841743554332707\
75201725047002823799295300702010882795925639186478387262677058801442720222586\
26057536088557051691465596320774055951256246914608520587369696111568866033518\
096914390191981982739232629121273460925928677544975925248*mem - 
    185791*(-2592582482366386070944805334967169291262556742443137454308830290\
42577471417118695738317835252274520582041238915491314653966836545996372260298\
23325246168842841047394632073757806747266406010118890063928999151929346304709\
36901396397154545979908448254596595130563050048559144074404401856897866169180\
88729262767470726604535003161529234260161516516300958703308384268976111084228\
36020684568201902397758597696061440000*cM*mem + 
      tailpot*(-3325992421754034970714863826215410678685955717908704728003764\
61744461000135688375469073239599126545570214787443410156375028298491404365285\
10663498364451939312005314878562391389856637021442816195355020600061048364325\
46372469364768647734074154672058445260427945973780710894947981632176566849562\
13295409853193919654769278638850427324762708764809667499967933995192824111946\
809350867416631453668689374023317965925134039 + 32738475458511497922457077605\
84866363292363670135648447026666360804028114248081789759880924434531148884683\
48954001041480973500395635617749641656759031241804203952045853170802810432804\
44056271622668823774174088788013160141688773257558414289037413862747758613521\
54744296469822196285556556872053702488171033438587012863439407717626073060818\
93801948819525784845495384531368819413301357055272220223528747426987916623359\
3750*Pi^2 + 14331084955942544818037531125697773420358378186475730418923669732\
91911491826990398204722779680812539875658188072042686036334907167598767333980\
95280541972266762355695040068090876685903031509285740669564195471680052738389\
87114105196628096350942839723153944728253711723215382080745359613304261303120\
26227987325430584122784308010739345050274133538526240347852679526195415580436\
46033675572262108634566144094778880000*Log[2])) - 266258660504952134428801094\
53745150215418034416435124302622475233487752797802837307285364995967784259603\
84104200928826813766987375753425817476552026717356941404482693718929067207035\
06101271417070447390014408789086783181925491671858673064913802113500449454500\
69853547679090521637611079154120117680166492399317907365475621936962327365623\
54815442563287204678971818513724561048704024261824614942532467847751306289408\
0000*tailpot*Log[v]))/1202202373981142047631159603307016764880475888154463909\
25680143520595788024507139726481187252596866548844580541791409864075448797280\
01002378438296902157098006075072709693726716516581907443992010235415689469220\
43433452535501893746632696699236765148398774614626250136655032123992845371736\
38948301896209296609493736510025657957278632267370069778587910789312329703362\
7788317791340625383322692497743915515904000000000 + 
 (v^256*(48833254044763908359016021323065611295690886547108536743798525640400\
23527553029432738741290944165388317088492637982043258999414050694670162584164\
60762437831045692457062254505405835864377592871271723288334999553538566828828\
44865230940113567388411086802214320222924708144514258222581237745723621323497\
83458784745725103202262553244297665429247131831790244915638365559679994774658\
459553096786457275525539040631567388050980864*mem - 
    31*(-14723040701231234129155748663783595732723670983532612229622922243343\
50135059664269245057114651342957532922346561982966205311661087372791919599498\
29266416740469835384623004525950539562263351654778088070259806269795954191434\
48763182029925114267293405910944929357799590551374455710607672248658244894718\
17843938250223460309823209994368069026674113048120970140027735518315963285501\
07105711225806062654142199889920000*cM*mem + 
      tailpot*(-1865403988925771473070805584312144392702566070022227188294767\
88136009503927223244225232519432638595591520445609924853460174921688287157757\
31127421678991749258144578604328773691613494263162815659273961172576195751511\
27421269301702580282355717875804365758641793127520281278395378034141277092228\
82348950305457523267912369092098956616420201380909416372203001571091235201402\
9843220391472524902864224918735536755008135783 + 1596097313285359285144088345\
35064090741091310594909329606901923461282729454126364509949717484342301043232\
79601467413008908405571419828662775403398299721188231848199556853195988124053\
19585737939918010703768107192630072074852484366985683785959142870957434843197\
25497122349222414101848735380687773504424744553197288077644243855735028453334\
76757572184579704636121111206431516330235364700981543693086291812130308116263\
671875*Pi^2 + 811324132201202433022972985078914932748704478633262730756580708\
23149556788112806365845533735432851289367569365714534059174437287743899262057\
34701651289654055732120280054396019084420215641722700257641697953733046649311\
60059498797265906605757350897300121631598031893735480693882622455521743650881\
87901673444571830716717247033073285109694090436745476024678724302020157886896\
8436821484217917604535012511239171584000*Log[2])) - 
    2515104809823727542371216253744636291520983883763114465345400195517636260\
43149699734121154579841838997039465033715055583440755592006087712377775751189\
97927572769572868168627659161702668489340370798689263656572444612865961844462\
71524310477847787781630377057953898870579990151036129612117405317733824951876\
78172675221823465802527183840051680353910975676504045336262489449380215414660\
10755445740585387848414319104000*tailpot*Log[v]))/114277792203530612892695779\
78203581415213649126943573281908758889790474146816268034836614757851413170042\
26050777484884639500463852471578172855351416554857224912079154913852349478762\
53873041749146724483740201715155271153564818797208431245174597447566423442454\
96674302804487870654423685707124363298118754430560241113120309691756523979788\
02944663383182407911879309532118172805456868235097616442722353152000000000 + 
 (v^254*(19048350060281523042075118173070445657955104255779868805507528924675\
47375993630901836641727505322024551031509588488091137247464795124433042014616\
61574064600026847481515396186373166298419659885038192113974096710123933965484\
33921604732740760156262663526189415385033137360816987465893233624977152636115\
07214725865749692909517679971646103976346500047564770534990647628422070238384\
0200465963664537175953517153822902845440*mem - 
    43*(-48236250704202074467313575060483724213563896567697792371336485477016\
92926705936221528028143418461947909365936793706709008509224560583080683091543\
69040993674324055422733283135058745235089843415202727520615009384807727260928\
11324080582257227832984182630238346545727918930232204430551735992871546383803\
11811487678142253705090710132529369208574460287915217990391543391118383292375\
59380308242132967012433920000*cM*mem + 
      tailpot*(-6035252339938671822451386297850426143720127205809044898718178\
47217015873429128089248645218260927257286162957120937573739270650347481756391\
24496264740097789639376462220021440530523176078837677821477020093899321698863\
03803818851416272306501142444789552265547921957053073940286195414585315798508\
78590959736656367102519128931185376012597037335032105603893015270738489591735\
4040228307585642824222301285425983889843 + 4488436417098491411423878687327054\
16350327069830949874087116355179523852607162208209343938325295911823025275630\
05647192394409516149640779357984458963705225062035131353392907237471053623614\
34830894379114984348616600528595390823382207998918229625447271428377794363562\
86176176448520387467376661578032922256738156742681020990932527967341128545833\
63648948024861863077297513751688233653136892355113877158430792827343750*
         Pi^2 + 2649783680847889468102835631989163679342267762190061304373772\
51550537143906345444805102415722262165223027802344291890106660245632093654793\
92706426820763391381324569719768956346689349400782329969213240191861839366933\
48657267655978723786086462830712956041737671320989209230230128309898267028960\
38851289341954362464194586890422900141260486196293692202722704137557075179622\
0836859511430201123489797151369728000*Log[2])) - 1139406982764592471284219321\
75534038211717513774172636088072218166730971879728541266194038760572731045901\
95500804551274586390562180027156138863763532928258293969564979500651229076420\
24233640188676169328250059092778139922625092070851228017179017206571097947198\
66802535996899895517325625482245296706054417040375859603672362881847060742009\
064406287647170762779149542327237495984958991498648310061277508898304000*
     tailpot*Log[v]))/5210027819730403337832963125258081632890029783143936538\
33226600003212980041044033283029003011343617275408289692573645101941472154202\
83309756241459298942164515326711478597457371536802743223709616363707698571963\
03273935386967329431136364452526075606423915276370542031532715061709304960156\
79822528203388062047407296054577312678671844871845312189814619365152081821781\
5640291441934824315897623085056000000000 + 
 (v^252*((7343969752064297754776062521730480678788868268544149731910472791921\
29175036077584796448422905827733646072635880434850361114076680806929744085750\
84551778941286505618232616679839482775739741414874277483836687064447593814351\
56163226495696182794993147807249175875707117174162333068606760460227394755474\
36400008797101149022836844071845706924937721591583592821017580407225104020556\
758651886135717323501011832462035124224*mem)/3 + 3106078555644620258932002711\
78949657889823410202563752846525709732676511345402922225215587433909902016069\
63665992109657582160291302803503829273019556624113142363325026595600817256055\
33792884068383513664509288057685913128095421062591541975601743485693019124560\
66113082959848397954646589745686724264834933159747034264881153985614173482237\
781032327356820271154240432764760890509492525874356624671291473920000*cM*
     mem + 383742589045520691238873350285539253951591466843763768182726406027\
71455860959205824018612642294212891929837213954086485154840376925770591387515\
93661876199115346236629378938303370115695526674640069936555694378774776434378\
31061894460889383786643892547707818852009349768830912776663858646681314667264\
35324513181612019720622326303155362242944209086749988696483793231320291233408\
28310711491427581919544543772435942*tailpot - 2480371226558608162326160812396\
47506701392738336290342789911489185176483135129373806655217179638241776264986\
37855301098878032441399467511080758589647059386862606229647064621927639215455\
95825480527351674628086874209455182530201787135775141511650451700330374807537\
71088257999350666769723694741209744550338680297083198628964645193302515408839\
58760526271695163386682344293390522316911971751231437089188096718904296875*
     Pi^2*tailpot - 170089988096563951687096997161266673994064941203553990921\
90545930998972049390953373009811033701311612151175259325223794979377102567171\
57949951648570209019118608019234636714691119544777376982208818796365996298426\
61048133572046833943479614357846317541260142874403888117321572486588382512802\
03344178447668464065236948051172762529598909350115860418022119526783599022578\
17772119725326684091992280348006383616000*tailpot*Log[2] - 
    1700899880965639516870969971612666739940649412035539909219054593099897204\
93909533730098110337013116121511752593252237949793771025671715794995164857020\
90191186080192346367146911195447773769822088187963659962984266104813357204683\
39434796143578463175412601428744038881173215724865883825128020334417844766846\
40652369480511727625295989093501158604180221195267835990225781777211972532668\
4091992280348006383616000*tailpot*Log[v]))/7827430468466559273225052684942427\
01007040791025731926965180473415981455098412458131658359474457012551683444306\
82810926469806127793119109988300506296508439987358548373595401801163160195720\
87804447206409534698293937278629360773788672229343937791929236102717417913341\
79688060503235397170119923599440887814792365047034006122593335348434787055711\
02715187803868756190701902346566033352778833723392000000000 + 
 (v^250*(18329084414853451820340997580679505392946843319246202833022384012501\
53818658216497121121709376000595372371198540676006410936964655028245026867217\
87046663141973866086419136623618440464153019090808967599164011894101466259894\
44113491347790799352290083571882252118950159050838721353722522867975802885757\
54824282638271907561536726197046713201717474730394132722513280033638525274311\
248305164982592877322912504536367104*mem - 
    1243*(-218056175578710163595784179192518681133339597642620790399474614145\
97820552915310969759609186217607368643397256287605494826583699738683142012076\
30065146901036010156745878104566251444867441149807554383594805704205712056685\
69818765772650721969596858224638096417221768589176872795141317966985259474890\
99514011613143531127388489627201750075340902827122181725068650449932006220584\
82334925396472307384320000*cM*mem + tailpot*(-2659868617343674477170660367661\
87489294845621568738435749068505303225593764682730016953436857778755516248236\
48051185148052975143898408438159359999831133783698968232269160684896714453396\
45355945030752092785166274717290826297332411882049637971955733196080380361546\
42528628100156836056209144053986906527904641558546297443816738194636640504729\
73119358542268036002069100368746102251427399929817719434918103093 + 
        149409333421907629349886646348319028088150904358115900723686444669624\
61224085503659538034100906931387563157986512110168050153541292711737680095168\
24863064395863786455487167652159309704820024852683052472826913018482762151326\
71946382572646845261136086899185341672281397570126485932571937289281149522603\
31487973242085723991020232632692660867972566789537685389979994278492776477086\
5191676959904965580028951000000*Pi^2 + 11902917445230907575962271010161055029\
83165804202206579435529620712498154710972932027646424953308753600117914329333\
60813231187300084398210121865687971840852750272987020484382539269771874758218\
42834776228632157935187688076244521593917060588471302501139659974184225473350\
45486591897298396346980395156507156204710050144807327182596699115158160530758\
6597011338146814806190089837202824175063818680975360000*Log[2])) - 
    1479532638442201811692110286563019140208075094623342778238363318545635206\
30573935451036450621696278072494656751136167490846365814004906975181479050148\
99817996858932286646208749631232644032446550643626852189772313438296278771940\
34123890631146982900891659734791099226337461539833728341906659296631179538395\
16245459232999550768796769700014159353973301400850933164908040942816676431104\
49604326620452372480000*tailpot*Log[v]))/685280877589484761274566869304298084\
53923804661785869092282337166768804434685915595184097619359076974369173139702\
85003290158124028580466827769499578488092995002207542435395099323622974333539\
90661720405504010551025637234088005487335117355014009021042071249579389300351\
86697903979752670535790976604746987676374371822043337581128581088648672192599\
6533745364609733187078911594449708341448933376000000000 + 
 (v^248*(15245340987430996407886941930317567256738348912745806772353414423288\
39278093637380819277481258650492860307817867746874638064026001590707770692958\
99141398879913095999820503133141822137704057337211261562780220351363958877479\
05965734286915014763116785615708055460475140081620084241775030823715879161278\
75872624340567321410269364028829090200167355697071403321270692714127951642405\
354175245458007908240215456612352*mem + 2627908741126590531084817712718700864\
98522306617175493699280529801806283835637229216647842034338072818657716013009\
53223118409528442525751158024238690263010401444693769010004335699746902067556\
60542639796138339917788384938493295820570648724326951617648461121987322660201\
65268297017680946103578825232337790417683060513205883655110884095453297464014\
5469304733093120600266325941186913992392679966638080000*cM*mem + 
    3164639291712233569643506395351125460397649033251044193659473450724724002\
25085974477530721650127526138331332397303020708510732436814536128213083599876\
10244970597017006359495046885446246979387012032131469516995948230109537121024\
59367757365930239162495467669658615797864495412779268800721851568834517965817\
03523634099215502796823301413393889877233574488529202937433084532432518886893\
01561215037653453758259*tailpot - 1544708046251731754937629814307782391185314\
93486205163785995325152960574401255323094950075349383225290507944870665323843\
48887322195873189325848274619918633831199418270316827901072138804893568891431\
66054558874629792059870102313753103009070683946208115900092521449291605725575\
12738843902072484966992629606597386608676648584066380636631924520309555453218\
194851401013330788935225667704483358619511549609043500000*Pi^2*tailpot - 
    1429891660819255299687657954651591727006568737890121361441377033325828813\
24768763353745199682110065929757471448388901018860870232219034516113723052823\
98364734556887189401051508643338638417612849252585808816716832341694154163777\
42376322493211365694412083663768056846168548795155535503322969780193647138702\
66883102887551021779301875825185099410372374999802953227355823551000419838996\
65307839298355200000*tailpot*Log[2] - 142989166081925529968765795465159172700\
65687378901213614413770333258288132476876335374519968211006592975747144838890\
10188608702322190345161137230528239836473455688718940105150864333863841761284\
92525858088167168323416941541637774237632249321136569441208366376805684616854\
87951555355033229697801936471387026688310288755102177930187582518509941037237\
499980295322735582355100041983899665307839298355200000*tailpot*Log[v]))/66661\
56396784871218624191335644923001354455706399403608198670930619533505319641594\
86226630538512421929661217312284533393984253310173197162234387118529970135700\
60384654040808359179211812583073021568132831129431033622299035798199157112583\
17256897091848942116531024322488978395328769715032664491887621302303149257959\
34273711878682695414870352068090013370977246822166419174702772089826312192000\
000000 + (v^246*((77884485163192460394940845220764372617956137914013513926578\
32508619706360304211160752477796941724328736553298618697437415611806597598497\
69373204481384804377416459747354663776469062761278503703195154764237804586218\
54333122587136776865020915352142560028074783059247228394691862077023303156269\
71773818198283332879367887051225885257486853214152155473038679734071847875944\
707301258869296198316199868858638532608*mem)/5 - 
    37*(-84606922357397502429618969602179457926130314621495683323639290680558\
21400112404199818879167962385233246595151366321870446874417838277613673575750\
83734994880537306006582566982545552208576673164694058098852767252823522498290\
92738837610230746876421909691077649903451072077488814351101339944328444109138\
83943701535352776493928803131359735967602292142074314546375042877744657614382\
6219452573155328000*cM*mem + tailpot*(-10057712931806342101076811900938927267\
21947736775974508428104686596222479275333359526724597982157434088377829329246\
93114656267746621815310630073947351528672846908758306113220792748843342038129\
13943291041244478648275536122187117588112336162746051841649277275668552010756\
56496832353682320771354999012287200014022203291026883538843245231641176367575\
836860476477272086313601369178990216574618420900204753 + 
        426569550165010210694062335267278832132554053809527965486442152145904\
25152972634914540666578962168388156792019368455870775092320784672033876946367\
02087579226265269965765550379659409866778437547447827400630696591744097894768\
88589759011401079804633212840481187592717035565794017961876314712277151736832\
67051579703964610434901619596405942268024364623576755952331282076901118869709\
24158956071269110569400000*Pi^2 + 4588761752728001719956921153120148583485344\
46690150808008738387748955615821904874386559802181820535525141794307620255964\
79132007403041217057411515956591764064019820667689579916055191636289363544920\
15395183713035012960445823525609773986846380886006544484066723982358865568830\
14452664818832882721424195781696381878327566895456226794952284562394421509638\
928517021387726033853990206381284546959769600*Log[2])) - 
    1697841848509360636384060826654454975889577452753557989632332034671135778\
54104803523027126807273598144302463893819494706972788427391252503112422609039\
38952703687333647045144568940420905427064511620456962179738229547953649547044\
75616375133160927822421459104687873472780260467153474859829681666069269524392\
27661294981199751318803914132345288085935958566403551297913458632525976376361\
07528237511475200*tailpot*Log[v]))/796751760571896958401297769200588406536389\
12825490879779266983234496416398242728225445414008587142063306121591109705186\
53198246735137814688060403807131117159768173464626391437352097029392399165924\
47802762503159764409948635038236937600595688075349623379535840361472807447616\
97156610139832643329334119151033656469633578531300240959611339085904552591239\
5590334847210859571357894928079257600000000 + 
 (v^244*(16314194742534271581482401345850846614828107633126368684484207644863\
46600118520354350122171747248305082648643054330455744036944781086945481493161\
59481231985998968368738872987845227596496717426863770976625834899560799003698\
14415716515959199499783424209128827616021304526442081514182893679030816464431\
93367819725721147118466410816883042675233282313413803886459885373854206817699\
010270684328238528856064*mem + 3823188395600494884103348514203738890768235556\
98309486555892352401314722977800613433803439662425006498948706658949769541425\
86828766556811878553861836566148541572949686117683373918336528238656401079647\
31101079997947310037340954444569570634711137027604764164807022192795431426995\
32947151399117498990676966315966597991886031574606586547974042657699825731820\
5212302646975489044637274739834880000*cM*mem + 448595621711968259991473948574\
25772191947160702865012645609010169490820055206996476265311876713438045393950\
18546196819124616397704903969109737956259235047061334132457583901089420307509\
46944179859891174176876588351275272552873734079239754764412683783021544950491\
77014816538666747929697923723764969819402714823864929865237770450361498932801\
306113649889991813883368458144166922142044214248792962906*tailpot - 
    1653018956172517828334204102821370607978300801395924359577761282594290638\
89149100196910881163894755585313126372198272294983833562414284187769017052233\
68175055496935261144545383749634689481748393996633940192901580318055666089649\
49950333433230018040432726036892742724863871508729937388064432199884127298213\
42901597235825293944247581828116347708347071167611728591725994063713971099983\
034518800002046875*Pi^2*tailpot - 2066811304102972436293950510294385128020034\
29378289620968630405889007859335517838647164974496986361998197177537457577695\
56231587404203443414979752785248750361679917891440329117165550242844308831586\
69802088019179510567059135088062847914515113189961370166727128585171753157482\
77900757445160855243286438022993439030396411498548310933868110881179092942442\
47958547968785764808632976485764142080000*tailpot*Log[2] - 
    2066811304102972436293950510294385128020034293782896209686304058890078593\
35517838647164974496986361998197177537457577695562315874042034434149797527852\
48750361679917891440329117165550242844308831586698020880191795105670591350880\
62847914515113189961370166727128585171753157482779007574451608552432864380229\
93439030396411498548310933868110881179092942442479585479687857648086329764857\
64142080000*tailpot*Log[v]))/976350210099436111853395680565862051959961738007\
25836539750181403441862959386283881998352564872329166731354100220311160049740\
09884597700105165464871727554790395717161651611366237923587873406920943781502\
46581537732448587337459018426295550681226067216590743130285786979355727890071\
23743991361484835901412844753453746013156160104855689617374381108184436906695\
9091795783856892674048000000000 + 
 (v^242*(58778885869677405582356774299608034841538064182771149976564786084769\
06078340663662147805515489947111957341400041250728243081889000278383354260643\
34566640698807416009182424930758463782375122760424765894475285276892163517910\
49142640004014733156884241975111567392946320788554134512982280503761474711945\
22699259325470521174913013092830458122569102515087572150821951702834101540661\
3961127331608519507968*mem + 160655408299127495291162414319381821899910366273\
16103324527281669817978307916143922824863353335707845109055468005445799661993\
82361440217961983308634389118598349774940342031950547213204781327809845426976\
81336196868727917453686244649386245882938858543980286841310345649427340682619\
77272361631126996649683146944598526191523649120050976645708930110079104021709\
4126754737012021004599212113920000*cM*mem + 186044390905995422419907524261385\
62965500333243041924586594001551381653238993172435931286926492120250418723036\
30726632715628907085314331429022689293742789849998925405798911718103653712095\
45223265216527714071771032383964519245914222344183836165729569388399783822365\
38774347497260408672031368481217798100662969659571384153517827827885158923874\
15822508357991612619705189550377780138774865924491587*tailpot - 
    5955734718304855723288080448981849285287010754886365273526010943625741206\
78979749594782913916499315226955517137576533361209875248243445950850301948844\
02393985161813556887197423236941980709582115721789685915374072586275986560862\
92529764192421623394125794529231152944602938765454462021243653879828536277000\
26085428224670967501567898013560133317461142984019134759610658286942633662918\
3499434922906250*Pi^2*tailpot - 865654463075502463561362782137980421292271058\
90926278326798202354657696228502840588038489848499697192641260610637088347309\
44477122988149912355839601016966355615733052929798967933866963266619685592781\
43292710923767836294911135703854922179757878132556555624249790980340839566365\
65649205779603152218957447691523341237495637014019629893933674991807185580823\
5003850580118755957337972372642304000*tailpot*Log[2] - 
    8656544630755024635613627821379804212922710589092627832679820235465769622\
85028405880384898484996971926412606106370883473094447712298814991235583960101\
69663556157330529297989679338669632666196855927814329271092376783629491113570\
38549221797578781325565556242497909803408395663656564920577960315221895744769\
15233412374956370140196298939336749918071855808235003850580118755957337972372\
642304000*tailpot*Log[v]))/41167488938455639510418742175253811619825743933240\
97357419745364620556638725782886126756565650327292222736378063738219563850263\
13195188550251000676862350417788929641278138991869925728970757861540458250601\
97827122184917195171744800843139089148642276396754441416432585118916813425978\
47107205480934315896225525793036435481684041605800989842810890019728913396540\
6592982918268715008000000000 + 
 (v^240*(12553712499508207732661660466657676892727762925198490027037665974446\
40455540757070014506736908534862911486721116326922308440213818690099440118360\
75520905253367313416381845327916396981781493037562777575935753396749466362421\
73112678816755604888156782656792776186913423492899632672868290566053465283461\
44852657386733795046814878574808185367704118987365133059222054945757942669509\
2237504430779735736320*mem + 400259267837294009161547325961985495228878755955\
67786976730030386987200203700039766162801063962246948112165698967341712796824\
43840763802411713840183706708722211064884937721744711285053262190172461393149\
38962355751497243185673037180070344975803016115341718490761602030347709616615\
09401950353236191777219732559746261182459329158966750523418705265853645057104\
903366181327288481993625436160000*cM*mem + 4574142941223332282639514974277375\
05363898949498739575649562249096571066594619751080288634609218199480586923411\
26199869203458389982802384227623350655830745165992054728137137411501590276393\
02419413535919776729895758062848510702341405572391623425972270660646988626961\
18376409380770108192806472686677467517553787759618798990538254455853024502711\
132309143419299721353032169840770600837149188002073*tailpot - 
    1272003337031830267184504020366999971532936812949629943901350840042120214\
66368720808319791507178318291681643029814022117220443053342509350690012444187\
45006297540724330594654995664972457589475134219111021005288239603456470642971\
12696705256322117608279739251436123408678703048910727359017690090251982964513\
57179962542936286462834652777672563622914176814180303394194900435352673031290\
5615748919171875*Pi^2*tailpot - 214957747872041324360853698600704337453070761\
34775638573608141505196961244264630284774521714851608231173160444342100600937\
61680189902904635435852460997312443057949055306596637613536081044894240472505\
19262902371375581075609614741709335494680970004756307420323731766676011951100\
47857501118345882289490800387534691852390582029455470504174925606802388757988\
8539766386071472775939073316689408000*tailpot*Log[2] - 
    2149577478720413243608536986007043374530707613477563857360814150519696124\
42646302847745217148516082311731604443421006009376168018990290463543585246099\
73124430579490553065966376135360810448942404725051926290237137558107560961474\
17093354946809700047563074203237317666760119511004785750111834588228949080038\
75346918523905820294554705041749256068023887579888539766386071472775939073316\
689408000*tailpot*Log[v]))/10291872234613909877604685543813452904956435983310\
24339354936341155139159681445721531689141412581823055684094515934554890962565\
78298797137562750169215587604447232410319534747967481432242689465385114562650\
49456780546229298792936200210784772287160569099188610354108146279729203356494\
61776801370233578974056381448259108870421010401450247460702722504932228349135\
1648245729567178752000000000 + 
 (v^238*(53611241614598309541870454607404183675792553943706373795377642289725\
67346136525709173206782527182138787308394457241543289576527007273517629711099\
75160150774224282785193846432382690691790077573017532114149141268759124900873\
30674764613721904976962994610565243765707938942137473537828587735418384295022\
43854786957400942268295605425020579493024431874141162034207535097959140130268\
677564382096895508480*mem - 
    47*(-42433068833695258830393216707848974923043996628675767215974324354843\
91323302201066695408014344444705512492659252886144383513120220140487995739400\
56903429043970339354239724686568785655226313671489417650442202282622538795234\
66396924059136390228268204466687652517732420373794475973906174096420608156986\
26849827066916189998641440533854728203730226808692832830245856795089207482210\
32038400000*cM*mem + tailpot*(-4784916565489573002761596071244852417769044047\
87234398093149742184129140756324053932009314392003903246791599163413557168256\
86522519923906663311516921226946420739563516495837981578546738592854626677693\
39229426161758255878589694730588057397692573775869077953052397031082834748545\
44565358657354413101005570514164295491748365197780496344960359533574842588219\
9280107008874275044245419202068064897 + 1155783452845520854351540993274497347\
94858673841728594127033306305774920636068140320027099578572148117008027403774\
88921728674381076318345672503556235063114116199774189508384879826522711011892\
27560475246992242187138451594440762504709208344281505195724277748511649439137\
20126796237662629530859500868477076471516745722814547480969386363477787977672\
92773903501414851456843725385985306252215410593750*Pi^2 + 
        227125990186846100911402367864105337545168654409018992478564120515780\
57015231953005708417183442629445580638506565800961744409361568300684154535301\
72926322043403626380937485388587392024315875853746616851026840744892363530546\
50663417322094229312269216766244624308342258488331984693814820396091104150870\
50229543380701289200300197490339963101335343547670862030743860365821752082345\
97263872000*Log[2])) - 106749215387817667428359112896129508646229267572238926\
46492513664241686797159017912682956076218035839422900098085926452019872399937\
10132155263159181275371360399704399040618132636074251428461651260909919982615\
15009941085935685811806141384287776766531880134973424920861489516032806092965\
58616281895090913607885388929605924141092820459782657627611467405305154449614\
3719362234787026071401984000*tailpot*Log[v]))/5145936117306954938802342771906\
72645247821799165512169677468170577569579840722860765844570706290911527842047\
25796727744548128289149398568781375084607793802223616205159767373983740716121\
34473269255728132524728390273114649396468100105392386143580284549594305177054\
07313986460167824730888400685116789487028190724129554435210505200725123730351\
3612524661141745675824122864783589376000000000 + 
 (v^236*(17588572605088982208895665845533460868021546546700675239351734561477\
19076693857124853811609927134731866296554587548703213917389250077136332197883\
17171666742653998109107369034871094755798271484074167292488392867838118581785\
51919009033000979344138036867345760909572602729429261379663391782458556534210\
98376017091889704328133376294172110414989985817770352627445740343277989337079\
74235625000796160*mem + 76354910907728868890620095987157933761874155296313887\
81872466280256148352186679413156289283110781229162452690703501201596435310186\
71145252790290791811992379433117190332969081590059307805713065573930691829431\
88793445443950302730153314886643512258899392307687140582320680546862963282657\
72953497355894503453602826785313283450341182760235854020773334320295716711322\
14860284696304025600000*cM*mem + 84949777565500064187959727086627930783745504\
50630358092196225010989270560565320995048551442678519721913022241605812340742\
01508521248543520854812046120112183626537391426245160770224611673732827560645\
16229683480371918106990266948430780142645576415316263817211453318627765810938\
36077152361921249448217665812487370289615962523314748193376690828458207759670\
751804609685235366163911439328700646*tailpot - 178218103235330712136006552617\
71536113107087294133401186214087871659090237799711915896918903974381541854803\
62188194082402017379502517605360006535131026369973754895757266742155761573176\
61633745090925671227919116381244957879155261952178136095650658168744526832318\
20774772145659873259185177317608812629747521305829362505077164309057955495946\
006076050986803148637907169133487575011412324740109375*Pi^2*tailpot - 
    4073221780770694973333211032204914448770061092370241255834693074600880825\
28127408076800439168299557505191839730434516557661351436607801278377985433163\
24389648213290629608183036449452643191077664162059786663755637649994812073762\
20451361140651840205782477476630479483339425306598011864468634022677749832781\
75187221453759777960888309409932858216881387209120540903660372852223362755993\
6000*tailpot*Log[2] - 4073221780770694973333211032204914448770061092370241255\
83469307460088082528127408076800439168299557505191839730434516557661351436607\
80127837798543316324389648213290629608183036449452643191077664162059786663755\
63764999481207376220451361140651840205782477476630479483339425306598011864468\
63402267774983278175187221453759777960888309409932858216881387209120540903660\
3728522233627559936000*tailpot*Log[v]))/1977077039075977769633603339444723548\
66997771309940129736233352765317957522945620395667961697514565670755358559231\
31913534704275837328480398561197405791379369761873812727591049539233180169330\
21844063367344678188978451916934250845284075759237582712674655872589923956177\
91017430392166470109376485626819973947565748253586603083295191764150280990184\
595863752331175046982664192000000000 + 
 (v^234*(19552093161996178280263020972924369350575151692518699953805172769489\
47786048673288447088568088659198683266061402294555905901035614836099585485068\
03757958425076680956085495913789661298116610162651327142880580555887747719955\
86753979214670190805517934112886374349497975360575778427617826663346971736881\
08660621744055224517571487803312493384305761413483883544841015525146867391817\
935466004480*mem + 9907020165815220338792279072523971372308138041904121464995\
36515304558633002600736326220221582894184148648230416885037162059076146105366\
34606004206040637172811285036622705272847344374363312144231042310452486797869\
17767436559249833002291634531409516992340607041755911533624069154992267487304\
80976160214968228742017517353711579462363984261217080827968359648722026820385\
4580940800000*cM*mem + 108736828042261119176409193422458906908287048646705663\
98226361171286704676579830335113643354488163214526455212940940669138514742260\
02085326755207985569713173264438581584546290033745675956438064297571899768510\
48480898705703547902238192566648525163416075988265837365305541269149680836375\
00061574381518600145446398971299619540179364088984560209982265859241543237891\
8713264016582801563179*tailpot - 19811513504034398416523722288649662461415667\
55151146167917776628064581888707127686494268052830468777677690985329794021718\
07727462382982057362771626287838735609998189162405669214083145100065708106423\
44777394859056473343683623338165629899290491393174740154064326170976845223599\
61165912698387365586985019538139228969349045378997421487589697124527533522112\
00466358285538153006659836211187500*Pi^2*tailpot - 
    5267088628365811824347651638097984637901001053285924145621095892862449656\
63806094895112458757501924828983670919840674851875661157408463664685642978849\
79407331860514382154576484542057406470093110045332209368167201092790666539480\
32649918780336877658025066331220010529020313240700213815318456765050975948036\
5989431983749448963526274889312120500257746289238514066961266767054101504000*
     tailpot*Log[2] - 5267088628365811824347651638097984637901001053285924145\
62109589286244965663806094895112458757501924828983670919840674851875661157408\
46366468564297884979407331860514382154576484542057406470093110045332209368167\
20109279066653948032649918780336877658025066331220010529020313240700213815318\
45676505097594803659894319837494489635262748893121205002577462892385140669612\
66767054101504000*tailpot*Log[v]))/257436375511203897155367715513037146739089\
79059090452490872239895482294508968769474600422103358725716256622323204133639\
73511381600027146356520234388503886270129933741826367347897433095214673460273\
69837238234802988565589281183377135550412234272649613012709325238800523174470\
16926357202830263088633503182426895312625252166237690132436867430119036519192\
66206850488467456000000000 + 
 (v^232*(72432659521536891269868966822671250631871769537213404039033993039177\
97906681118694390502097582107303642859008050914397231060650468948682760763388\
29130397943567312639958651192163593688843936081154420453567678228841856318600\
31695461868256929839290105177631580796425869718565718262029334229597569865125\
24531863485678836277120117235998323745767537227189192363526846522280467167791\
022080*mem + 4284615363871017174555367429097024084038626235235290055901667194\
65731634454732558098641511793256563254119097784801930852594036924143871671178\
55035336835077331949493357437632354449085558707096266674597311257876755632407\
90161949434942629043617525982325627940874688403303607320112765318078551978972\
01161296674872602723176834334007683883295701938969728308867976339472252928000\
00*cM*mem + 46388039819350509206006090527917548400425596756470812755927157534\
81591686986526040231735715400310697810435994692519770299518277357695608073783\
16451199447630152421323167878966011538936259428480163633454337678074811646327\
94537019316045305635492940592898282021186542232724441260289753156454638835446\
40438554216477667548592403434812112971602524534352051719339050039796210707911\
12597*tailpot - 7339432612539525501828297463402164838827628813967224457126573\
93125516758315586168549469264612357585831953544202604369976450185073994728626\
46964934473923593213701979097132558710257804524727172555025345221094035905842\
35393552256478005030428649460311559660982865537495557594799936330116492898461\
14555588742327105834687686772135418757264079884561127556873605193421706106454\
530079468750*Pi^2*tailpot - 2270144580299120014521189211319479859806067262947\
93288434763472547307627869137870062873772497771900616865455228455226574472027\
66228225070421262024254968767370375805394317177380104778193085063578698573244\
37698698479009716278340482812174632049323820870367054118810906201903751146486\
15670279363269777992794639918880505012429103775086937468572206825637968131706\
288434142528512000*tailpot*Log[2] - 22701445802991200145211892113194798598060\
67262947932884347634725473076278691378700628737724977719006168654552284552265\
74472027662282250704212620242549687673703758053943171773801047781930850635786\
98573244376986984790097162783404828121746320493238208703670541188109062019037\
51146486156702793632697779927946399188805050124291037750869374685722068256379\
68131706288434142528512000*tailpot*Log[v]))/111736477851700505718574851782599\
15395193049818178463380819215566017767022417389830813218156286882461612450877\
27396900976367376864193452298008747716324886834029207860304157775264081448989\
85809661352557005431866433690510807992923981123983156943978894170345546467300\
00658625591124132885479896824872612016886966489272926685462286729125882146443\
096459657573077876736000000000 + 
 (v^230*(14367421650730875609219066521323826086481676738990042219509781572882\
59333016894898946352342179825673640171900128012102054119503066462874993988038\
04267228399121326924370147334342028276615340059614965151744554045833288734157\
00173358978334777045298337997664991584392926288340922733461097464152108555841\
95281470879222035094622812275127265328076480378517920668439020192970737618780\
160*mem - 1411*(-703301937895676935446479929460843542911698586821758401791761\
62632074594629781849071708533669784457721357272373419806048665306549295416796\
81107414602304964148417355234702756170815085045471402632859381054157408743497\
45287581743532478443522171418858634637865282537740575315425627817412575228361\
7322667366697343615126217618741913861817983387414098868368723467986534400000*
       cM*mem + tailpot*(-751013936309296957474758640568619561037625295624128\
73855595735188437366817439356383309563850972263168424263984117065725559393571\
55159979417026395511754036125082339836808492941209290939000969265800996653446\
16293895717891325141893706799451490661266758437839182794328860139360914087699\
37058513377453716886397770204858382553792793380628156793475946331486313480283\
748295393571 + 10317728496860977955851215020658466478415857565478948636642589\
51035892568498726239556038172577146096479843735996151781737109672080304131115\
09347464735805114675818419891789422739102024835507432841461625758224648711768\
99568894140444763683627999835343978114947926701344782741277150425570524265624\
54542004764608544152228803619890700175108028111692283710499363484208506547886\
87500*Pi^2 + 3713513255756426846231748968644366025450602323019728072114622398\
60469503293588002531662712026010313988887087625337739361137525064019454112179\
81205713018358559120794972536872829768934890500355594138887998440395996120650\
12520604532731639830746038695225612200745554369692875152099899607233818928513\
7357842743009867089185512320913603267575534813327946395524251575469056000*
         Log[2])) - 523976720387231828003299779475720046191079987778083630975\
37322044312246914725267157217608666870055303831968063935155023856504786533144\
97522857148126106890392691944170624952756280396713049600174332997096579939875\
05262373266657299568434380118266059896333881525197721563664683961295834580691\
85081328811916110386922462840757884809094210549079621605732364084718972986838\
016000*tailpot*Log[v]))/25973146873942469948529719149837088319835076285863466\
71506093808930210837382006004373132997742185602420374448459778942297460197266\
83740655046198911279611072531196620247363499596485692466261761183990137158140\
08933912252628543218033734073258238953717845268606803184566849431871511234043\
42142451155883778913753251806816988717407421926053497546047526652155527168000\
000000 + (v^228*(591817599001727972451280579044513793778385674264189613142197\
00093404717096988071778713283033281309048605274806338495235100256068292872334\
79340374708602722001999209553865083941734400501525535753899959748716515807147\
95021012749089191708418422695362082671939179063505994699002617168786245790294\
61485884844284092085733344487816550987157884897085944289781795494395066573316\
42368000*mem - 67*(-712527061900199987332697640494574243172630324096634000954\
21428284973849783011623774900401415062445828030779510377770529172572293185827\
50978379756353270188966117631326638043165967907608728602470454109269161952105\
36616226311169259212877058331127000389370444187177776086317776963561295210641\
97653520395018044728057076784639404398934473507435034121131373197021675520000\
0*cM*mem + tailpot*(-75036085509347519989350995906466063703521293280826077560\
72421908938155427160133734503817139457207951105061989147555583549952746883118\
84300556690131767659012858726017094723655640959127767137038354123027224848830\
83565700473155126956375695244716337587688313402873988310373564318984853906845\
69619261242370234973746939766919928500654156837374097708686094049589203258964\
461802 + 89505598991358849305443289057118681051720414644655737191930708660507\
56965606154302636837661356397744226020068817978553087252113113705715018268973\
64950410155158980849617014225120351240801179799109505314876272201250769586631\
73113705904956917261007119436314149703207403717134470260005418112445105364828\
50787447706094338547591008513721204097508970600777505437799067442136609375*
         Pi^2 + 3749153232379841898421459380974715814363586726142655193803005\
91710868324218588789029059927665765135547752746394732469658279871228866410143\
75798192568570191393366381397951726344307609109807443925369849247164856088680\
03108054737668449368657743365436527552393060309102304602751066712869797448760\
886087513353988594406401574976950937799688948172740572064724734197353472000*
         Log[2])) - 251193266569449407194237778525305959562360310651557897984\
80139644628177722645448864947015153606264081699434008447075467104751372334049\
47963178478902094202823355547553662765665068609810357098742999779899560045357\
94156208239667423786107700068805484247346010335040709854408384321469762276429\
06697936786339471723582522890552345571283257915952757361832833655719122268262\
4000*tailpot*Log[v]))/1254068250351299514682228928908443105571436086763793993\
75294228971952240002350075318445262766521837026734817790439970389898829267175\
62585275835784342899676248823871149282572405409716910924655851158322073086163\
11186750395154983703345529288219691971355190007839209555266335229847645420551\
46362984994388466865768595822708682707439899863098057480835514320814080000000\
00 + (v^226*(5416028365336354833476917408447009167076729292960915624839601129\
68183753023032250256511865241727607366528908568639467006786228287035572155453\
44881909713407976985461694136638589244065879193344068752972164946622937877117\
29431687701424181395998943730181493891050345516877656952809531105765974785223\
38300310280016982980295421871533449495657752310563365088129487508173634928640\
0*mem + 510333414411290507560931652490017217982176923960154856296968473189583\
30838014329216605060535089761119011469115744544326116499157191007328884799222\
30471360776330821264477810860230223654941148029848213032993291547411211714549\
38916736494084882015475453426193452498391427839853411187794220157803981363134\
25755042794757093759555257525906633398973004365063148221235200000*cM*mem + 
    5299504012741524727933772344166740907356282145588342609587069840321535221\
35512103474174113239682262778026245358420067447724451468482033556318028209008\
28755321096463644646883375326336471215743792833784226776575365363119885368881\
18456713747944994084853873965994233805951122271054057038537922044330038321172\
66604461625726797885929100641049420211364250688134024762483899599*tailpot - 
    5488120769380307431575351912777839475927264227560930276228485806702370838\
76641474631415126576423089799712791481348969416048356697701602707215647779401\
86966735399298301296363882450476420191532683855981399973272310844402958361932\
24199800963020954915202788435685005922039152030564764182021539290578270844684\
25739383511203104369581084162338529955293296617059173109187786218750*Pi^2*
     tailpot - 26758480563987582231654919990595083843326967800323206285082116\
40693093903168612445276082438500907100885062320252930286663538136831569438977\
94020727623489499236704213125758968032339702733122788959161299785608046095046\
23210286650517518086626644529000846417730591990091650470845602226474809443331\
6198046612793318960805987220927947400280320136706759975196843303714304000*
     tailpot*Log[2] - 2675848056398758223165491999059508384332696780032320628\
50821164069309390316861244527608243850090710088506232025293028666353813683156\
94389779402072762348949923670421312575896803233970273312278895916129978560804\
60950462321028665051751808662664452900084641773059199009165047084560222647480\
94433316198046612793318960805987220927947400280320136706759975196843303714304\
000*tailpot*Log[v]))/13455667922224243719766404816614196411710687626220965598\
20753529741976824059550164361000673460534732046510920498282944097626923467549\
63361328710132434545882498110205464405283319846747971294590677664399925817200\
77111055742006262911432717684760643469476287637759759176677416629266581765573\
644097102402196015640407277114665526549345478873182133136857759744000000000 + 
 (v^224*(72129457613599874855170614667234029594264573876718747392086432967949\
22380283320554083760295965590545003243813299410251484016361086343310534398522\
04074565730208655398012948378892999930470022347457545439097370577701010034247\
12788052829336094339717096658711313626771390216818873359193584195640855113234\
04462106206192833945530036141736505140883827969735103975499235328000*mem - 
    3403*(-233343566840570379290791654747989552365222377323908704953371153149\
53485910577228109628510245961735178964678693174535399751249940895203983453155\
49084145795424333730419577504192385123203765737757611042427142321485744850124\
58891646157537692051256479826333654244414987675090617307203192554107219500667\
28526770344440017707804823337293423488163691183577497600000*cM*mem + 
      tailpot*(-2389122418238969137437019779339523888117817214774006015576189\
33519572890515031509711857677670014347233286244802208903634516898475667475788\
91623441375886193668059374122457687734832639610135549346187942400492449786351\
62061106399660479469203635548640421972430672391032472577297812064519276790999\
48620754474552520960769900415698669150628587197366202799936436408261 + 
        214782998109765534699999131004211978717758179633190115015804884231577\
78632423449672558505128559583640323359301321943749757534114432769806735965358\
48018029843438500858073189373600027481499742389863226146549372855344997386604\
90018833138656853542188510770009281911191626533616200877724055797015526172736\
807940428796051730967998052609050303269568720301026942574203125*Pi^2 + 
        121917379675219128236383061191925822625060207629666772272030200832714\
69980702985990279702429981768557454018949022766792620221514301322005426359771\
01379711839055294717732584965050996167837100654013786777063498660598031050952\
99277033645020985763083291773178325182133580122327256792210454160787459170761\
212609879098695748884702263102780877111905022429917696000*Log[2])) - 
    4148848430347706933884115572361235743930798865637560260417187734337281234\
43322613249218273692279584010160264835244753952866138131673987844659023007599\
51593883051679244439866360685399591496535256089164023470859420150996663930343\
97454940064145517724419041258405948005731562796548638921755091597235581004065\
11418572861633454641801338763324811812791329009919488000*tailpot*Log[v]))/210\
15155653154293594352513598050546963083081298643985478643126015049209789086564\
15529672260216614396184366500643906366702317914343556349390718964278891021523\
23203774363259558758061653846253522933049084352907773380422683403087737807484\
14273604593382743107180188415104355905550141158869460495806708276633518314384\
362430836201668861753336304098082816000000000 + 
 (v^222*(11908443325934315920735707705998369343000761559843749433322586789673\
86417914442594478312160149140165358731313053232326302009290561989482306703186\
70127730949302765858132646513448732953765038876811892020331832190739768972774\
91486297091932562781897130418941923431650443594038543963626928894092198028363\
89304664573087282904718674167937529840706239737416029673881600*mem - 
    17*(-90117941270211546502663408655432453025788283666749197088704178851025\
03198727390109440654194350979747297265766318843394427898536977489541136856489\
09613365910176818784563144857993945063721295634099062212008838111769825629347\
52099567611516554343561871218574607415523906564512376317697430144451406514371\
7714804776883154316415017719757065188012772556800000*cM*mem + 
      tailpot*(-9096267957478274074574861609660125350247253624936950312985515\
61556352347593259265174750433517657071578174704693538232054139522737679554636\
63802446159444556648847545341624303037044015603398081772207014354482949690205\
17205956817451451945131096453219455139947564595871388730434601216967088989557\
787123181920256869289305243088066999856426697409178463277010449 + 
        709843637882435209481636364270996519332627735321266438062677869264845\
61588616194819508211017880766218637793799117053587621013172142905238286535118\
97170027796466611581647083468049133550288758473604850942434502544602085258837\
50351851726395136840833655805910053031546421104676222481699544193651388720324\
4726916761052659575137823199023034945151196737848221906250*Pi^2 + 
        469169625173135128065923122548648143525557920873663217141786419213034\
82073097260500227269986828204893749529233080070611958567053044132027495321226\
61378599074011980856290656395477063184511934406613712386888156434380318831496\
06853324706828318664807493936787795867976298382131455607149184701849811730380\
9852551247752936053519948276363701035252097508864000*Log[2])) - 
    7975883627943297177120693083327018439934484654852274691410369126621591952\
42653428503863589776079483193741996962361200403295639901750244467420460852434\
36184258203674556941158723110074136702884912433110577098659384465420135433165\
06520016081417301727396925392529755597072496234745321536139931446799416476749\
3371211799912909839120698182917599285657650688000*tailpot*Log[v]))/4069829937\
91483978842447723256400426786720825845181164905417439937111793047854264086917\
98574894471750722709824544595568652953676199698792675489372278476330540793171\
22452259342620560913491469066998460215883195423473291218007017610574368389976\
60051667829206041193160548406678709130621874584756607476540152807720651881239\
1080163829066730831872000000000 + 
 (v^220*(72729692952828294475901912698945293887812808335754866109417290875227\
64841683387509839398651507791311089568634112862849834215977278130295720852503\
47784068270141765274589777175387583956749941785748806805964700876112160419462\
49153328305053245810379444030524729658679453181766196445648853337697202138986\
1997237109945676498976878749048473048777170433630881710080*mem - 
    7*(-156231210215761765426837369735706058813422969019458293376288263246854\
87215024159801705017500160628323240706176811978529409265276626659058166513049\
35963543801919372449998951881828588038626884518796383220424554425147480258543\
68573473495291325562273299069632188577527440332720330229948910881887724706387\
1013929025494284070792768556157573382379929600000*cM*mem + 
      tailpot*(-1554448561339699886935413430545350443254428755202050510618084\
88555205055400662775152380617145348757186374708251386043268735251114207289207\
60696995004600419157026314388438054455950113770643415115675912033904685988982\
40040826836438215886940998584235826790352230284702423875069568963067971984861\
5854504036299626287005489428698430667581987482801668655040658 + 
        105288008280436409152125102618832262447744911870807905256680059748108\
23764087855479113394470080436785410335028627948992212629099851507849657980885\
11733522463259640867499560081402841783117769952302808272375776531607546395399\
02199811124350568654459110808602200215672244079463438951684183215591487134694\
08960028569219705290275894832409537506457922252233515625*Pi^2 + 
        810441208203319921537642539361587286315633857809702797685740489973930\
85086281472741971483051090519457948355559443703874976342785318077832335024176\
10484459943613044752440367807095079654636426267424741253354312790625125102881\
39207963553492975992612139691199296765910416593071367638935781455976745662956\
6358259830178231741122524323559360648632168448000*Log[2])) - 
    5673088457423239450763497775531111004209437004667919583800183429817515956\
03970309193800381357633636205638488916105927124834399497226544826345169232733\
91219605291313267082574649665557582454983871973188773480189534375875720169744\
55744874450831948284977838395077361372916151499573472550470191837219640696450\
7818811247622187857670264915524540425179136000*tailpot*Log[v]))/2916360448364\
42264045576009297287880611071903559490571777827359668688115172894433511680645\
00217745661358923897510458898723092634869837832121308487724318398565772379972\
55769396006692457679572605384311083270473607225056227435150068174118895150883\
35121609717119720778531984471498665249501342403932602987913204078146366622872\
3546209967407104000000000 + 
 (v^218*(79671686566756691411210859700267415105298559562779609462895023124884\
52505163752447579925512220369245827015235815139637482851182008601230431388314\
14993487940645912017239070806997703237385801625110869081912061728109194545823\
87936317196788935885664598049361817865343318963712384372941903684446458281795\
166509057301935861682563693961475520545123467264*mem - 
    7*(-200077641375859345266627191412390436163032991796928766731561737920791\
36508376833113623400653242631399485587737035200272008751752709290948119695152\
26135052467996221253513845390184528925608251323509380833485874040203376111659\
45994721817262315535232321729171910222617883790786979389697235861647160714694\
262172390205065047769696297560309760000*cM*mem - 1962049377187015840934995296\
53920329123685571458417193271752319108518026642874749971772277406060243905302\
13433310527743660527661164226091649767657959473547632676204299839217879865940\
71430891380824489506683565097776871521255525761621196808763228178833628368231\
50398517314345624375720817757342061210427015017227978097094201403203638016260\
4464367*tailpot + 11534029349831693560027088550521461460402268218662611417350\
66643631266191705438521373961979786290300067988674643082284171799013044052649\
38986453956053258802285344669078667404275053556907471057256849597585080059736\
39159869379155397641334385256014955522461757641196218622675467617723549131158\
77573293721893786046591142692731485262147926138493375000*Pi^2*tailpot + 
      10341258150852186703603736175016746814421406296362970219033885404118188\
04572550882500520777683199415194060462576186141855678727129841728794370591065\
13693861750631656248742782523132027657450998270356959840286776504162343175610\
09232823726490496347550766748773831090362862001287727513483477544657623184851\
76893073560812874720510181324732416000*tailpot*Log[2]) - 
    7238880705596530692522615322511722770094984407454079153323719782882731632\
00785617750364544378239590635842323803330299298975108990889210156059413745595\
85703225442159374119947766192419360215698789249871888200743552913640222927064\
62976608543347443285536724141681763254003400901409259438434281260336229396238\
251514925690123043571269273126912000*tailpot*Log[v]))/37492953274134837154581\
74631782462397667486845263778469583323214555708985624554146593164838587567565\
25305746845324617627217718976901158496817804627869233616925943005013714232039\
92440926251888102986356327643437055632846212158104093792078760177912868266166\
37806713153313761493016403707079283215165843888219829670540264544994852864000\
00000 + (v^216*((194860289748919733165977870623367300425075035902202128446049\
55353843943483995067116480206085399996798825595647420360225908257193849378994\
74331634476777542948301925838368673223654096775976843597712751280432911333504\
38432245993838971582599698601698024787814830429370406071540220617748351832401\
816665148593168764878628933394552922504340825958034440192*mem)/5 + 
    8010780707856212547288618744141875253074862336243364533851892967581850889\
13374223335674498416803370213348685619877380134336457500981306258175581373758\
74203196819761620861842149138309031057018141805660796086663463761867323302636\
27488131984789654057082550777641164708669377827200313867305381845100958991349\
81716809715228275681083965571072000*cM*mem + 77416641393369553263196704818183\
57325137673298151124407286364596375993689180171545772094292975809369967495293\
99424804351752111273427380696860266244708559316881321252876681474694326628576\
59793809672642057877429093388878219896374570452387709074680496778351876561351\
53392466410101218293134738035658426138126167554436861939418188603099820958752\
191*tailpot - 394947908082904616947928221192649655948073521943665719949411930\
08380244868564320009500339196682736086926604063218053077310468406842167338195\
97711505439480008795590893975261306990143402860961463019008791874748885183655\
36655032734948532334065891187453363979929435764282683071496131623145139073668\
7762089173281180867558782958637353465647050701312500*Pi^2*tailpot - 
    4125309371796754576690727625451619052638463145393139390185154440344901835\
54235725773060459498822967614644488491452957601684935641906199493013524810999\
19004791925220875216983144769736841931731771649083317660521947669501549962163\
57940431048707822380821216665993998926586541766005622892311110361168464650433\
766554976248074489544585529427148800*tailpot*Log[2] - 
    4125309371796754576690727625451619052638463145393139390185154440344901835\
54235725773060459498822967614644488491452957601684935641906199493013524810999\
19004791925220875216983144769736841931731771649083317660521947669501549962163\
57940431048707822380821216665993998926586541766005622892311110361168464650433\
766554976248074489544585529427148800*tailpot*Log[v]))/21529025411448277567911\
17765021274932831038971013573242287643666474701953404592638884550482426627922\
55898658670600077520920309035839432042679461356944642890795367721040386131895\
57094442181857720122883084101982578357784562631592956098994104218752209782433\
20498428786017162148792603115208530115255543990522642104541169842989196902400\
00000 + (v^214*(1240313425338490179090559221915073847602563404923669030907660\
89690407744766446566219307597221325480575742104059744506138109939706354717430\
37102265128229600551409821683075637924544739851931164485813510612102988408056\
74181889762009576164258801474419481514583160195924982737703474752800554289536\
51539010641598868732617668650861160165273662488838144*mem - 
    1159*(-257270293841617857450948473150704695971896600187429938491752114558\
66627186537935982799177851890374121674977860405946688065001721270924001389708\
40012683092058027184534253532240582724750517627529134771979592529687029282576\
81886862620388202682746103821213438665803175085897782548129972856831969244947\
6459408666067442922337528268718080000*cM*mem + 
      tailpot*(-2449861635314957571713849653199088824528062303763033475644939\
82188487036012492617368809918865472195942987990705758728361915011347905362834\
75830139629217966297174370487953532025066310579906635636911690914111711844349\
31697434333536603535346056472678214929365693741984713496922831009948600350496\
8946213804776749862290348295640698554372440491 + 1084545127078243613286066672\
26773850105796868950983749819598837269717862227373655511146598670253951062215\
04582392617895981184555683804227916819212436540659165379053268937660707278443\
62881714778017388861715838806640151831249870194720583799547525006798132832916\
81951608392429344605664075286393241319139932946407221777627495340225598853758\
75000*Pi^2 + 1319968844639912020687888490308285378813810709671594102240074414\
07664779971603397844377180607908220192968239447447773766690337487827530317785\
55332899277094390575428935419415049964261429865539277957466134201979388329367\
59762405698316673695913970686785575581542868554636353658370424260025742768534\
3045604352037560428128313597780666368000*Log[2])) - 
    1529843890937658031977262760267302754045206612509377564496246245914834799\
87088338101633152324565627203650189519591969795594101148392107638313456308302\
62152398676922136151102042908578997214160023152703249540094111073737045646282\
04349024813564292025984482099008184654823533890051321717369835868731258985544\
4011532536200715459827792320512000*tailpot*Log[v]))/8045226237461987133001187\
46271029496573631902471439926116458769235688323394840298536827534539098625769\
42697560014976652062895753303225725963924273895606461433246532526302739871289\
59059111307070300031047870696030776451630280864333370326645821656281682523619\
20190129303872252912034049031588234400427500195307213954099343418982400000000 \
+ (v^212*(1980091770980852078882390505353332284668272237947712980644174205724\
15362212388450737331810473916903672265960898346843420909208812402369180007171\
04189511368552241224048170099737777941721208200698125290799485037710017890070\
76118000742171483070836007962316475961392326224192812953833072740077278484360\
0067446408349726313742398996782373702920568832*mem + 
    5568511353240027325324053716826780713534093469470062387072738337332730209\
81873895044434472261410488160375549647151498247156603009335960885308310259694\
10987855496543784005415339079878604963613407013812759812173061140440379111316\
62687988948484997198993753771464956489734612039506613841971951093712043697398\
89574134179705206546062376960000*cM*mem + 52242840098952787722854530541861569\
29360833417229711831146907700160457865359075727387989603920707570344449567049\
26256228197148836121628883432902919733997013892062123146185096620883228256461\
22934409497755411295272462364905503828824200879603453774029091737277634946076\
83532891385567743196653942291840537859647049081274894049130496424856987858*
     tailpot - 20067815053965647045325019006704225987251358169581256533515337\
49752434959917764582931997819868632898322832125154058790436015807431057432944\
60151397587606530667798233922414064280013813501836639833071505915488327678401\
70134033065562364172399372220493872278674801263564687487659127737793006137204\
78856536024431134617313944489820375032174466984375*Pi^2*tailpot - 
    2846365964363308061969675351948551718132579805916836629892777449548437758\
98461167253213762921432737316372235507190701233767053044899672664282527907984\
91733713454988100870788681563838787873008678416423933732452401331526643591981\
94727457710280455095973853796594469787685348843487355386559110070100169225793\
374235518660611511116164314112000*tailpot*Log[2] - 
    2846365964363308061969675351948551718132579805916836629892777449548437758\
98461167253213762921432737316372235507190701233767053044899672664282527907984\
91733713454988100870788681563838787873008678416423933732452401331526643591981\
94727457710280455095973853796594469787685348843487355386559110070100169225793\
374235518660611511116164314112000*tailpot*Log[v]))/15084799195241225874377226\
49258180306075559817133949861468360192316915606365325559756551627260809923317\
67557925028081222617929537443548236182358013554262115187337248486817637258667\
98235833700756812558214757555057705846806776620625069362460915605528154731786\
0035649244476047421006384193422793950080156286620102616393626891059200000000 \
+ (v^210*(1264114279472963773110238500829650672658916897482528400860668707821\
36957749136028718182014397629951549743501893027018036274687316788080210633308\
39705506618196604799204606488030209594604007130869359284649292816759314558770\
66270461036757384427651857885976137040713762595262347851901150628045261440405\
3908266903667196460487016112192197603364962304*mem + 
    4159538306988325442290955742208621064644378630221662867486837883698941519\
96293968262612591338466466305860564911803878095187123879732569220216282884845\
73267988444579987302498713218364035410645378304859987331377117315977479416688\
85973893867446584382124797281169306087808608330992663080006908784485093028536\
99139091890852487231354961920000*cM*mem + 38442431635994094024792441412214818\
43804590101755061086977053626654046341709496506184054761929144887545230474675\
25774848267208691829304896985934917478195566264013828084539569160066173055460\
21850209752431299279100516485520741665165435881256385948286065008540269951435\
42055826833765536936310476822175194625289542057593915512922145996257110731*
     tailpot - 12812048714870268063672884604829673238611102273771516623570393\
75814384346682133010701426956121521963421536636385424507264917137728246421942\
43317782104552971225406076548780239696841551368499017763693700298699626897150\
70476428697597708229038220891006768232285859566556921440913676912605198682409\
03992142660127885046841163865312676188550819031250*Pi^2*tailpot - 
    2118162647535429045091094967661125506132966825183720449123917416954982228\
29658029794848571740716464991425475841008968139677350536845905688921275348096\
23636587770056897319739910197835959915560934467119764210039102822662452149023\
21058045043656772471991010624099299760076887023996143824603574340467534048849\
189555022940550931766317679104000*tailpot*Log[2] - 
    2118162647535429045091094967661125506132966825183720449123917416954982228\
29658029794848571740716464991425475841008968139677350536845905688921275348096\
23636587770056897319739910197835959915560934467119764210039102822662452149023\
21058045043656772471991010624099299760076887023996143824603574340467534048849\
189555022940550931766317679104000*tailpot*Log[v]))/11313599396430919405782919\
86943635229556669862850462396101270144237686704773994169817413720445607442488\
25668443771060916963447153082661177136768510165696586390502936365113227944000\
98676875275567609418661068166293279385105082465468802021845686704146116048839\
5026736933357035565754788145067095462560117214965076962295220168294400000000 \
+ (v^208*(2689378932776536191406832680434129861255146736308804238584706612944\
64130563445399179405447349235903931305686792591267262340739519987614815751190\
42030042434971004541153207801767913169016142501629948280304140339534164521908\
30006043317883288918165817289591298858111557276899451659158825361021669274756\
859053128392296555739918028840994594048966656*mem - 
    31*(-33407791301723016076344803791403409354669476285255475844084429139888\
42291448152473445161785510033250009865626025046374847407855009886267299521373\
11805044710346807473313922314256256493500838205086861250084391469772535766729\
98008970331204718908774902431043851082862899728388147557413532295910378226059\
83624413829832751502514118983680000*cM*mem + 
      tailpot*(-3041114585966624619618074551952304818607831630391871804571442\
51283854709039774009361189989954912251582578096834688824443661259157790014467\
78449619050228992837481680498478917611212818243388368493429525599882341782104\
99900304389644712140481567590939887131257728441970007033993172691494492241435\
8060205488915939574152873320741459494679998343 + 8793113921248113148900543825\
00860079354686167178182842292648497449077943196138163717485012712385111273646\
95328975073134541828190825285358157206993815839959552061963994802082264639131\
22780790688065880311867831165608036478111966881278179001791057677891183505982\
83532931545780493992892781228240699274298270189994435682580312493149990509664\
0625*Pi^2 + 16947637541852537933092130874919289143308849295743745826622096945\
06293423151982531504048155576486558224265397445275242128824776564053285309306\
94311934536538985255911355728748645650500601257006399157478045755112814747633\
23215408805913063695406619330478623359816074838993162018175798172603543020048\
401422988693477295227733486875558400000*Log[2])) - 
    5253767637974286759258560571224979634425743281680561206252850052969509611\
77114584766254928228710833049522273208035325059935680734856518445885152366997\
06327085429332520275912080151655186389671983738818194184084972571766301967767\
29833049745576051992448373241542983200087880225634497433507098336215004441126\
49497796152059738093142310400000*tailpot*Log[v]))/282839984910772985144572996\
73590880738916746571261559902531753605942167619349854245435343011140186062206\
41711094276522924086178827066529428419212754142414659762573409127830698600024\
66921881889190235466526704157331984627627061636720050546142167603652901220987\
56684233339258891438697036266773865640029303741269240573805042073600000000 + 
 (v^206*(13902253923507644839033877878386317614710947361624052151690412147562\
24032212973277718061943540073365002367551013294443928922283489929808720378294\
39482133805236356389128414728673021731455994584846348428777126105540200150524\
09611281679512069661365363403274891557303264841857758860191534821664688992670\
6972672469584169009949157654676763574272*mem + 626665579889580819913512255314\
23180885296117615070531496835336971069413365303802527477299233997744734563882\
86139870590971360416440396598922585375971743131123302373633223213991487305852\
16445422405881536483461971260619953718355823192338753019251816117067503232418\
8623247566834880575720295029954449837642631433139653678095254159360000*cM*
     mem + 561798170947905469457084506555083722288146104009355078251965117706\
26926010389306572733622444803475093317933236978864407542807746065414687895785\
08654624449896943533082632550966752055481065566557254981925486233491738912949\
55624035809679768975321030072599489699957933598133164186977184225833732009539\
10479081040116244486533129827576154163*tailpot - 1409161770289895690518521558\
95933131603684412379689913038048780722183374582373285702151096024064375262722\
24023945269973023977422146319053220096072703719727474665947453689721629338897\
70653234192586625158967660297166989609190087284033869845578528400962589199675\
79635856503413925959307990706391886231483952657718838849124851492338160156562\
50*Pi^2*tailpot - 31668599601724560278596960093549361505063160524534829226465\
16322759793667015832191375047185009122842963312599372014758170540197135723473\
73786953726567409995931316200109130726995881858170977104055384573775126138360\
54303775404321192343382130699285435765061969892514462791621655839657981218002\
291557002331258133453253312591596201472000*tailpot*Log[2] - 
    3166859960172456027859696009354936150506316052453482922646516322759793667\
01583219137504718500912284296331259937201475817054019713572347373786953726567\
40999593131620010913072699588185817097710405538457377512613836054303775404321\
19234338213069928543576506196989251446279162165583965798121800229155700233125\
8133453253312591596201472000*tailpot*Log[v]))/1718556233508160075006519605881\
08401621805484088355571166191235909236648556020502159650887174262887727587903\
21389455115591725475920929210283261713173790343053606595024473391047515036269\
40587490522757725888347049045963225343672601288434476498770225136111441168834\
866529302399528417610661488265016407176068858259847721779200000000 + 
 (v^204*(20236584643792722842713167456939440153384807418624445422462656082568\
21375444618521880638686884998039096781416419644020652866132840055372988422744\
75317707491378503252009195928162127200762662401621031994375477628038915521086\
81103264859716628861065348361704022034409324351971540021843939637555892105335\
9479032521488566484797611024649814016*mem - 
    2201*(-485239669667636431243658814586888229518747024224751216967367034383\
18461627058867425049591299789670950077935822861869812939225760164066397535492\
04127511044931017466136061873543391177731820460502708355851007375206408107167\
59804539652672677568167756284876751514353776067936075412925552689139582882321\
4842875904197600036782080000*cM*mem + 
      tailpot*(-4283505070726016665195035418566466010793956358473713075024558\
03474424201219204101579772431793881775828524874715086985470990579344529155574\
42711487838695875545707477746682913782563341110986724857864573903760982527268\
63990545914799100199506503676344095175931285664597272786687856682797042449094\
5968718599362963769247406549808455998 + 9320079511682578503489404126334963830\
32002467831896675531866184192453819047139187184374696429521834390008935175104\
40775192262687644625817628338380924930182005518002578881390672556274457732006\
00084782354232078025228832857778747577160952827928819556905581304876583960092\
237964100962560954109086038687650701975432648241810082172171875*Pi^2 + 
        244267125346884391997722213417019100121905155249657543310227051683095\
18997539226425890494354307598222339052030033386630634346247122214031169703245\
25438903966760528323253083480316420320033380158212547051328129326052809476940\
12000762874429997814074913281247779326855022366975728424740825881804195224328\
53641952442707892008960000*Log[2])) - 537631942888492546786986591730859039368\
31324670449625282580974075449251313583837363384978073831023687368253518103483\
97402619608991599308260451684280491027630839922839480036740176441124393469728\
22581605997321264664223365874520413679086620425188778884132026362298407904229\
71357826285455776585103368874710865937326400070311720960000*tailpot*Log[v]))/
  294118365397657727423443323807979097035738716844210429852617965616123806112\
19938494937618921345675888081131408381110650696739229459199543665403142609172\
51970733092882018879457842225796501795336597663301283374359873291459908865694\
67478254271774788398755249278499911333345592336353724836747596698437247089193\
7516853657600000000 + 
 (v^198*(82848535062333237323372668231706819652312274782507932204481753291511\
58104347210195167450874172200851749135396883960468135894986822481150276579292\
79790789728976539504955016452407216297441292741601140125195703497044025667505\
17266074387659292216256099308123926452079060779262087389156992471215887978182\
3025671393470600908358105830522880*mem + 702699890758645603724200920064107238\
64143551536080962670426898782347061093710958080629581342963219345230625181913\
85604340490099073467584845793285429792158241248766159784636737024818236500671\
64586619927962429678473123069318516806027453122026326469557824286013719980917\
08274822002356817874192634259922632776555482860381798400000*cM*mem + 
    5917401929955089905109953992924954976471766525567491388743455523188472460\
99719900845109015915825085145651855553453928287321431736593332266504668572940\
66862472882810050270838939058885452712122191290385355726797376530956006220090\
65067545236776917787761045281813927035385737480972009668082508547199507714195\
47889579294833873831190439*tailpot - 8400304191622980929961497746185859952794\
83986613992599694532874168664650618821824698301079254527530680069760953438306\
18515112325628100785905455406435251630105013753243215391023562580950188868140\
52581789326422835853990072013021260333310445760112388486593888312701511781069\
3928897422658223931704061787598690682965189271513478284312500*Pi^2*tailpot - 
    3495643736026504620138732946855850619806646928301799038770817616415666750\
75304557417363708996863212445379839976887419256633124976923846626992510778957\
78151255148806112811201141406439572300118324278944727401018548717934762801573\
31547725605780249906393438733152163428718782915658330645063322445620412200229\
86296872813495204864000*tailpot*Log[2] - 349564373602650462013873294685585061\
98066469283017990387708176164156667507530455741736370899686321244537983997688\
74192566331249769238466269925107789577815125514880611281120114140643957230011\
83242789447274010185487179347628015733154772560578024990639343873315216342871\
878291565833064506332244562041220022986296872813495204864000*tailpot*Log[v]))/
  196020830019173544639439419007095073557586526332782425109120385851978247557\
00492184126078961204908396973502863998074337697767555178672681649039416727084\
76580020574343762582577057170628592724972554722283142059333446358348576702551\
24948481075679287291824440425540521475126653660188353342026686188235724511459\
10583296000000000 + 
 (v^202*((1834902108929750827565119896323610943089563700936105637627696291980\
77046437958916061477808779157074482141205814373212971011490911835969332216756\
57112846816752826318389605662785708923062114534506203410250760083270670895010\
58988199939873784530574002888086204645626469119331693906893124667798044887114\
486150004542301905333889050330791936*mem)/5 + 2268123460463772244388164772060\
94233526799377101211933806049772496197514740655472949731015259630777279602407\
46787443036117222655969002107193116906111883963415360388728646415770913007222\
41763872817179215819905840748620330733713404756691488276531662673129990043188\
9440246799122759383485119025037949386612872400621542379094016000*cM*mem + 
    1971269889332715660061698026360662068610576517963485981816121705108988862\
59434857255058733576137877594722242282502850771408066895540962762488047892514\
90662751014108409144733052706076930481817636935569345011350287309442907531411\
49940796095036441106879712713023831066433655587248821827358094439917602554801\
48337168753977794702296109*tailpot - 3720285402342019063826240456402256807189\
08115301366423628542532635177406311021670782337215780129918174875495515275962\
89775751097761096739541628376257954886105309326549608622534280213631195060441\
70243918353187729474285236366173204604068738444791497240619074580450795661888\
4904809978770385607851372447209155563847425860990399943637500*Pi^2*tailpot - 
    1137299645763966006009998671455608612215719054635987350419728031769889748\
97321539463460923046103566692334207667311381712558414402822663315095047240077\
75660193562381091518385394887616101381778292693059930384366867850822484762492\
60588177577367500953641175257208130755145033676906544580926039253014468546109\
08890312025018372710400*tailpot*Log[2] - 113729964576396600600999867145560861\
22157190546359873504197280317698897489732153946346092304610356669233420766731\
13817125584144028226633150950472400777566019356238109151838539488761610138177\
82926930599303843668678508224847624926058817757736750095364117525720813075514\
503367690654458092603925301446854610908890312025018372710400*tailpot*Log[v]))/
  627266656061355342846206140822704235384276884264903760349185234726330392182\
41574989203452675855706870315209164793837880632856176571752581276926133526671\
25056065837900040264246582946011496719912175111306054589867028346715445448163\
99835139442173719333838209361729668720405291712602730694485395802354318436669\
1386654720000000 + 
 (v^200*(12998341753547669234782766147143391542048751318899072300330110556027\
04875945838856005529576500530585339475738800840286434713984418022576968396835\
02308681873898898613250045965368404345026192369811787686432912693128988488320\
83774140512869931819794613974932940578907752676183624876337667513610107102492\
7653715590879161748325535313821696*mem + 941008267644250087378726425538452426\
00324204703367276625500955302822412685236671772888802985282678036265280103405\
32497585823489488697928823526516612446958321217215681417863810614280666546157\
83972237193289830905232591378763515661584441441156793044548304782375237622407\
7767106139838677835200028033696969647487480530353520640000*cM*mem + 
    8050928552221583503851620335014656185577221041450095604856567308941480309\
40786543372674050789633652702044508826642229958704221028397499542199252602151\
83602013171767164619596692673860031931957585151450292110749194283306482294428\
93057647221527406495087920180383811020022328529631535875740222357288802020706\
8689492470729961793895987*tailpot - 13178226950607667592346238244680279933019\
32747744294523617529026181795024014057452710496035732353623077415407971119824\
80378046646386567865148647541858134470788972779471278652463341065501151942432\
46034908671309854999545301965067741130934670051185330223377992442981060823348\
617233471668389552685005060768785002410101007221381428043750*Pi^2*tailpot - 
    4699856653916411955025590342133280772409576863371645569731379529203040886\
52123103952704697167555984085150133382597843111716534971410601206213939453886\
75998621227897882116807552820776028140935765188726801032552302327911978027347\
86195931519044258217543435327361228412058872969262218143264858105089862546039\
4051513254911882240000*tailpot*Log[2] - 4699856653916411955025590342133280772\
40957686337164556973137952920304088652123103952704697167555984085150133382597\
84311171653497141060120621393945388675998621227897882116807552820776028140935\
76518872680103255230232791197802734786195931519044258217543435327361228412058\
8729692622181432648581050898625460394051513254911882240000*tailpot*Log[v]))/2\
61361106692231392852585892009460098076782035110376566812160514469304330076006\
56245501438614939877862631337151997432450263690073571563575532052555636113021\
06694099125016776769409560838123633296739629710856079111261811131435603401665\
97974767572383055765920567387361966835538213584471122702248250980966015278807\
7772800000000 + (v^196*(87984953352542419619864953234067403914640154522996350\
89856567559489703639612417125010648502047278282831335524440515230225719176059\
64142177365784077393580217055844957253553427023298829633560986798012017458154\
69910076198999971962639711011955464362952487559664405458817786118063475566948\
168903475267427421640560123043672501527395696640*mem + 
    8745240427682013042137195371209649007955052282806815720971671615063965721\
33622438041675275584326897763381816793138036270678184670269893451727660660816\
22153867518061478211671891775731979230836474109157279001799096914934962204845\
21437564163796826411313927533394711383647188914179768689759021457279456402194\
273148983679385600000*cM*mem + 7247293555501584591741257131263342845911142717\
24830136032850899045614537430947580122003178969748326139453004751032309077976\
47484186752126094589199317645788605232585936907615442812344108817383379517974\
33507436035981429967086612119850918287087381397155953928464758080014479127141\
1810066811175726304858483595893750031728774543019046*tailpot - 
    8922078906161124171001243032577733410891947733199516638918264361602373763\
08976383403441917846988352073421827513998324503012388819989806531462867825116\
43624222413450523930594750091583005836621941749366690349076944391579953762089\
23259086820524786661519068877271592942541777615941409272999491871336845190942\
753521560034956167948390625*Pi^2*tailpot - 4332892849367195587488794083771682\
36406055035013532550757208972959332494721531044557242071718249718375173017299\
64744027339791903697213981558373008724931741803338103556893156358634080900771\
23643029861631262570671276394978229612393201826923198526871421793341440653319\
3850557626281805841098806447068027984401827696148735435776000*tailpot*
     Log[2] - 433289284936719558748879408377168236406055035013532550757208972\
95933249472153104455724207171824971837517301729964744027339791903697213981558\
37300872493174180333810355689315635863408090077123643029861631262570671276394\
97822961239320182692319852687142179334144065331938505576262818058410988064470\
68027984401827696148735435776000*tailpot*Log[v]))/245026037523966930799299273\
75886884194698315791597803138640048231497280944625615230157598701506135496216\
87857999759292212220944397334085206129927090885595725025717929703228221321463\
28574090621569340285392757416680794793572087818906185601344599109114780550531\
9256518439083170752354416775333577352946556393238822912000000000 + 
 (v^194*(73923364127030613068826680782817942465235677740267999479076481606249\
36839622172887591764726398204287673541996709191120338762470647654408070735582\
52911975455985377863066082047322178656823383450948026814673839017220668654499\
59134767715208368420530092661535210329030979185669880108564090402717512033588\
1000810277229450782268456960*mem - 
    47*(-18324202960337698991157746032558397077323889452329895086370896731046\
86092306547192020808713310435514313174830008436919252258664710001633427645980\
01256451207306681894428139468706268891005617128652122845461304172090694566961\
13868867991472401110781272252912878495305700614398942684098633575395860338116\
56893578765926400000*cM*mem + tailpot*(-1494187475094646014415424526759580263\
38159451222023264348619137246513588618995173400712342705892813921314704991985\
20845110306758512034843418589524957006271925143406769712369091299406600427988\
22477447393062519256797989553172633847068178690557858002071547547342009838352\
5386281582241248076332198360469774139165105135920850317 + 
        159513075116470745016163571430979636971173170938140087042515070031156\
61694020666439671296217303634528490917984352892801468454855301408520274497632\
69931205778860406697771308502758618031938054936805210328129843018159654172791\
96333734737813426445901740260903469783519192510690233058074308028031688696373\
5379293998795815195281250*Pi^2 + 90419619200031798838519651002943603880700043\
25297313048201503892351503159354642894476299778232074711542089694474203479981\
02592321366297416583793742631818754794181643495241278275503916202982400332884\
52356034589426176978157821358007884672358414427261069824353635085444884037601\
31911658120701131084332850902727637402112000*Log[2])) - 
    4249722102401494545410423597138349382392902032889737132654706829405206484\
89668216040386089576907511442478215640287563559108218391042159785794383059036\
95481475326537244276340078948684061540172815645572607336257030303179734176038\
26370579600845478081270281744620849015909549767261998479316729531609636439924\
28198957899264000*tailpot*Log[v]))/242379256047923605032346054840015868661202\
82308785861530724536295154197112160819085741303665479103683987732540653655009\
41935014043973890323794095567290780403024688333105713826337853920924411640578\
28794951882855894427643702852667774092511123134480586772989486730554192130254\
69397721053845344610384071503118336000000000 + 
 (v^192*(50836000005493167473781615486267404340937407893345388144796011252434\
47088974737711409665046866772997079411907391737077864124340300244489706515258\
14934868862353392134407330130585397550686344294027435123169408405827301100842\
39610813171807010564648408501992771496725899694556846840852671246424533900390\
2897087098782187572428800*mem + 694369982505671669358519564295015910490652424\
17917684509431885543916340336983306955320297435505339162412681291372959399877\
14909559239660388103804858680524384317183704748319269224756279754423221905437\
12152090513304840998138370518141605164929658056759728243813299441982588766049\
94141183903417268887550720509109862400000*cM*mem + 
    5570298852099637077131108168397923625051701760740624709251011959470887370\
45384366019215428252858276842534336658147775042503306361599670564074316156123\
35446312867303733792178697801786967986789490487452243060237678648409640373896\
23969567111465319599763043510404829554924099451936283187648988135271270862686\
29724420906045657*tailpot - 5156404622929480247718029955481674766479686571856\
68669008356154092318517235506091697451159903053971395713803522014450563666835\
16075490151502367205474983758152362144827330815924243364848031174849935180180\
35315474340193591114737907789475903756328775418396467727685301261182104108538\
2843103410403895341442911270598231324703125*Pi^2*tailpot - 
    3412259224945765546299318052203037637727939163099986484772141222340231594\
98161408020490131900100851345773227007102968114156747399028482247519982604279\
47959329671023552603074220603842488829517807021970239259331130810124103940415\
35960803904430293197201614166498659402902385176143991974811542041175285350494\
11763200512000*tailpot*Log[2] - 341225922494576554629931805220303763772793916\
30999864847721412223402315949816140802049013190010085134577322700710296811415\
67473990284822475199826042794795932967102355260307422060384248882951780702197\
02392593311308101241039404153596080390443029319720161416649865940290238517614\
399197481154204117528535049411763200512000*tailpot*Log[v]))/19629980816574176\
61856742402665740843811236291365331999082988616613896279139621982940811650585\
31628183202945735212495612342006213545318005715028274013423150769160152478398\
11745587547378861329385088039792164580962293900180000439256759526638674386548\
555065725081486354616064042378839462785748319763647430656000000000 + 
 (v^190*(55037787304646728786560091953649601467818901128867452760128244705134\
07195858832253094454106899391021576452684954784538878828972045471578093783080\
45461880334864953557697876815311571333329523087150458760776063085223228989488\
75375034480894888213806700439818875738387125076764173819612075265482607689141\
65865300896325304320*mem + 88157688765499670554586350232299638107570403849365\
46015486696353622911178725477849030378190735298414250773757939274366606857725\
80226126813636352480775869010501604637698580403824617067168127242733367782871\
08124753673582697045177189084051653885681836717938896607706178286288619757080\
9928543891479142427996979200000*cM*mem + 695641707780880978112309408135976354\
34993387388321348202715373244244722609234271148876330834145977400170984037575\
06065156686329250547463862563983646625395501467826638216147295938479442509324\
27373063338997812169534038738391375024234143988243180284987951447784101783855\
7029926722908057634137810962644747261278586848317*tailpot - 
    5583538330191137232651066351486601833054775066405493069016334633365811175\
66282927996483230942430178587491901112389830652486627010056281010258321659010\
41221208659831930054490190562893895059788179065605176458816631438407681766880\
96007489199884833283938871378349648392966214726558193398318460399326417940279\
50065365406250*Pi^2*tailpot - 43142620470583815104163060360238953876321966930\
13231258934916513112881893996471879484840585417185627253976113207221692060973\
35062245379876194345133320657748248963832596937898911374621312889015542691063\
84553700284325966432706080489885022937884423572287018136060330376314927284760\
94495537508754292880044348728832000*tailpot*Log[2] - 
    4314262047058381510416306036023895387632196693013231258934916513112881893\
99647187948484058541718562725397611320722169206097335062245379876194345133320\
65774824896383259693789891137462131288901554269106384553700284325966432706080\
48988502293788442357228701813606033037631492728476094495537508754292880044348\
728832000*tailpot*Log[v]))/25036324792202352649755661590512726625656662645273\
72903965243242371624976582942610183929355642828714424954030752907884758079818\
04383998680859919233239067355520189975867150622982776157167325579484835851748\
13893021317118817438001245771403513346410413176371355612435725092549093664820\
8846079997956325376000000000 + 
 (v^188*(30710616355958696487388343955727819324687900155444410554584343629267\
42024068662500267443740333752720393580482580967113515862298310849545957742571\
51467647966837541812695593325401831550184063820111676284644393200276565765959\
66981637154519337064040940474443720265133895405303102564536115306037656435230\
804119744675840*mem - 7*(-824273967407272242244183882291872303818894444949729\
60769307323436746075074398259494702722036185070787222203416000160672825299577\
00912501976364569043892695188404503967721903788072835241827879137195009640195\
17835301240214084224068598638032148561752568812429975115874518699350970770523\
709664810620891955200000*cM*mem + tailpot*(-639681448139790516687689647523982\
47307653799564114283803718813015612969019739591101594679783085826500210889751\
22524539105421369245218363052534082028648054279246885295945939117354726002244\
02362679675202718144831482574796446734719375387005300302070907259312576780941\
5793442026245104999646627027983406178933248494 + 4451672119399409053619761290\
69357307626473099871429544019659535450036976778983353661535072047582715812423\
01321515580178919521990438864446338228620732573153797053630052431559513193536\
06562750529514189551171794916858126884252484236156977135877513451608633025483\
76273421895568917637508149186405953239792853432609375*Pi^2 + 
        401693243217191693911019677534959070776874053683161099816826687080101\
68731802638936269645921812812188165254061056221759172825082835912001098898308\
03702225283404454476010048548677829783679343148121020978653063951031465445014\
39925925753946899538308816922694372793539877746321658377808386026155411907311\
2064000*Log[2])) - 2811852702520341857377137742744713495438118375782127698717\
78680956071181122618472553887521452689685317156778427393552314209775579851384\
00769228815625915576983831181332070339840744808485755402036847146850571447657\
22025811510079481480277628296768161718458860609554779144224251608644658702183\
0878833511784448000*tailpot*Log[v]))/1646216879632463155213938454440488586942\
52272726083802633100342072251188592024316179475116096553793589394941660720909\
81024169656530864435500113044977714115588766075055045279120931600771108438723\
65507559954623301683090845679887512543818121126904237998498945031195636956717\
938354121464756844888064000000000 + 
 (v^186*(20951754604492632424934327504025246162460360621215755995239273430379\
56071062349997289283292119819579552950940163606262651210929897495236051141148\
05031976085817315389928541673974011753460383799678037608786778467295845964772\
98327425713413607929420250131974788963994472486024681343598454621981580588230\
06289920*mem + 46183455616124948268870895205607417123589171502946475230571479\
27603586487577438601720658494322833712496012195117454769532971752815368658633\
66313512233026690938335359122331445402757238770928904503545350367109714634515\
07368307380668589363656367354463190682590482441934388890654548566417255138590\
7200000*cM*mem + 352429944529478228051876688854384343060429381850611585212917\
00843611162349768093364984867847451569072671969371614751559717754498759674379\
36217771069793789017952377805488097839519440929375555881227107361198138394426\
93080915180378648626250608224551156753062280251216394228077644421360590863778\
5756150831493*tailpot - 21264254865458788632825576787979565285163737782262625\
27034066400040369448821354701287021316101062954221431170665054306708432677684\
18586467068556075707406805734378942777482880028856279456435492875996407493476\
64467498715408220425892635385399279372443273561913590557121283595120755573560\
2964291564080393250000*Pi^2*tailpot - 224112958701693540329342314143597452167\
68692449004154728139035516924386235927980323207711680780410839761558885248731\
41481546311195831517652362337323169496441284405667661575657101003958071354778\
22936200472271219894967628444571840378933238843265695872019147549593629384758\
9410703723740614185132003328000*tailpot*Log[2] - 2241129587016935403293423141\
43597452167686924490041547281390355169243862359279803232077116807804108397615\
58885248731414815463111958315176523623373231694964412844056676615756571010039\
58071354778229362004722712198949676284445718403789332388432656958720191475495\
936293847589410703723740614185132003328000*tailpot*Log[v]))/13238449296388940\
68090870212663689836072752711911531973851961166693473092110615292180633119516\
83661929987968746944200031417764702721489392837691013947547764364715418250226\
15348529257384201163010202938902027553108055777666455354393700074497025876697\
1570967854953238105277800192078702968832000000000 + 
 (v^184*(30488863767402054301193531412451448252480252343112812116099113853168\
23341152125831219824608807247728274032921129143220023817768380020341487829263\
23636224411744080054468312961406037934790627241395898589399195267433378771323\
85710096428693047131410581332447827558932587676037937059054512490293248154979\
53280*mem + 78867151365883691060874668972755025188985086994352368253720445482\
02472099418018009702256576361029452628366865775094442413913432192631741587140\
82023163193819859510631005660230919785386806240413106869696241242048680177222\
91493639436350996016114059173094520115815310446529875871638560740296622080000\
0*cM*mem + 591701532787682271418436647553937237066992782680395266749642408499\
50549577300024580916815437704671223542644821635601210768489521557095491173067\
25302714325411651818331682776528005852765619022192077052638991552057908009247\
97534464096925778179911475501333903906290553689482922241761150302167427378948\
8731*tailpot - 30951596334320201465575615901893672037582981631798332097250864\
69272088910864451427650736857879765099344730141230115590112646644182672625165\
31843188446968052290752777926481043101235497063956968244551288414648248419786\
07730004682595513852224358835862764164935092848356464476203966428681869302757\
7441625000*Pi^2*tailpot - 381078881834553510766003255595313838925366251294118\
43116048699545190332437540389742347908171284664633297472039536252225456643799\
02303607288900436599874698918486426242674471961578851691391435549939412651350\
69222424177650517948161873133325547592419573257066490061891496126430313742440\
2497417998336000*tailpot*Log[2] - 3810788818345535107660032555953138389253662\
51294118431160486995451903324375403897423479081712846646332974720395362522254\
56643799023036072889004365998746989184864262426744719615788516913914355499394\
12651350692224241776505179481618731333255475924195732570664900618914961264303\
137424402497417998336000*tailpot*Log[v]))/22714698152526937527262442273005013\
73507354502574516380819155895975969754930320842862085147965166051887187430009\
55447250282766390340835094728696976159900064999274345667113479856353397593989\
51805206735359391333697325989132824272723368410382684173862550155214783908824\
9974794838970728448000000000 + 
 (v^182*(22556683834957326343175203387529153500682500086756964510258177520726\
71416283089701915401964141311719511418686788435864163916510390074888715628227\
41720083446689733964901610093979361105814849308534725616633863627257283174651\
32757231866593160260039847794778912044452264569015403727888301614553602247884\
80*mem + 68489483327470115902001616080636241647824301294721553382037452316697\
41060841890105373096428749341478652070804872064416495313074450277765938409404\
18796213721597578187295070625727964721176755234687923042363039829227889246937\
378891357517997212216353323138479700635547381014496256111409941708800000*cM*
     mem + 505097261907030156753274274160290806078410451104280085000992040186\
93300013268828072242245444294329812800285285774664212043132841612788833003978\
12471860510800745378792907886717576010453150247663910166214120705008128514412\
43220540647246586922805009359670029647770741609730235360563023930397874135065\
3*tailpot - 22905847355879308010412365352791281479290638217812615257058796584\
47781959886400468678249585875639405890646307946699517358952918188532131289456\
68170208216729840620564943723908611795664536260897894273918902326465338604680\
38976694128428626441256894849117245408398450785835847403714372689172250089725\
0000*Pi^2*tailpot - 329504212020224349157594602644631372838721906404438818215\
02116700516983111963268294878444613036195226525659495466172441860823488565395\
67304678785122812530751552738927933625951186514805170856172143307337742829162\
09768354118500934423846001195619469075810850917873719360272040913479525967766\
7328000*tailpot*Log[2] - 3295042120202243491575946026446313728387219064044388\
18215021167005169831119632682948784446130361952265256594954661724418608234885\
65395673046787851228125307515527389279336259511865148051708561721433073377428\
29162097683541185009344238460011956194690758108509178737193602720409134795259\
677667328000*tailpot*Log[v]))/19820853536236420180857279470335963119610423233\
63452339283731148321090536588412602846496638713059382100512591631373885255521\
52173072281932573034010610733041011583198662402687483728968232102546293252490\
04704479666078524548712279863323220229218301799781985353214580126524851207589\
0688000000000 + (v^180*(19915385717996655223032607884930176255810338300088257\
26851484938271424011153719725125433537221895997999037620260265109750379427847\
29592785143598223758550774299084496978539894865371476816534316640725448755767\
92727135353243090674127311207615527409754479400763779846777049543174257041757\
652923837317120*mem + 7099647720232716246160291905345588297159577438075939750\
62432177210839342352133912394194727894581436843398431616480664901551223977643\
43746774979025661607581944197848654561705861929477773582018675022181558609804\
26752784841224710009572140528144967398851793861305120000219115968950881275084\
800000*cM*mem + 5145828921576641866539501653978862462677510566173017244235852\
74323813691338778848204170832617988962929545868713189356274872535485424952379\
60999839876410060705507095865287707516909567164993798463911733258183149500925\
51608775058381020739099722494138057495677994417568478765125223166445138818548\
9898*tailpot - 20230612981913084728440311156029719807974029252182287125473516\
89824707921161149615843420883464205191775226945525055614942238484158731838115\
72974151903285393032734237251861417311954793884674638061995791568604266853595\
21622721744856776828895290891104546333110266163974755253962614800936066255416\
71875*Pi^2*tailpot - 34007286145256009731181024592252212069652247653841404308\
08565759075144419354775973601333002354789672575512852508748381469874399945001\
77910035228363795109278038237723200350923029056509490908274161171194155315479\
62347493309507804304639398319543242678016500698121980931992311478767552036574\
208000*tailpot*Log[2] - 34007286145256009731181024592252212069652247653841404\
30808565759075144419354775973601333002354789672575512852508748381469874399945\
00177910035228363795109278038237723200350923029056509490908274161171194155315\
47962347493309507804304639398319543242678016500698121980931992311478767552036\
574208000*tailpot*Log[v]))/20646722433579604355059666114933294916260857535035\
96186753886612834469308946263127965100665326103523021367282949347797141168251\
80283627013096910427719513584387065831940002799462217675241773485722138010465\
67166318831796404908624857628354405435731041439568076265187631796720007905280\
00000000 + (v^178*(1265607864195310420357975221606406439794964434119121855371\
16444853632844550462534191085904857663269679228628817285100122661093688254768\
41645937549706909457697992475221102463088059246458998023425086332139896252185\
07029353401833440739993862484740992914212968189303582531611310136709530932336\
7717273600*mem + 529850420850665197653083675936605791070242768698289210644228\
06538968528167429645298488809541575679719809962231197242667891259942016924282\
92652297466780114973718915720225452059585384512122141186684847791707203267683\
90186747118899412748705395829064926886978528729917899375732363386379304960000\
0*cM*mem + 377363980652727289869883672863799974041917212633953143926759882651\
34356152064441477847091251952134799383787036550800997878931582483357849113528\
21624245851987263968496523919110544605524439475370755487709310485417591237880\
6825991379031906909638659291433788775677485513384511324371873688130705410879*
     tailpot - 12861501555125797281036712518820053450417671609046078524133155\
35952141102222248994429165070927424527461684647426725390710903631150139278713\
91236298396720687792316777912939977219957366978119915547255556485483094144845\
94123968381156432440142816759921308331600901501873924171953932708102864700347\
81250*Pi^2*tailpot - 25267708401213961793729958761211780591144608694702421104\
07616937494276922025706608428887728396396809023676735456752996580100860443682\
80731576589821607322554447231226347831138934975081910619100702281951439280640\
59406434119435611542329421151633874578142463236596990625206590991460625682256\
384000*tailpot*Log[2] - 25267708401213961793729958761211780591144608694702421\
10407616937494276922025706608428887728396396809023676735456752996580100860443\
68280731576589821607322554447231226347831138934975081910619100702281951439280\
64059406434119435611542329421151633874578142463236596990625206590991460625682\
256384000*tailpot*Log[v]))/15485041825184703266294749586199971187195643151276\
97140065414959625851981709697345973825498994577642266025462212010847855876188\
85212720259822682820789635188290299373955002099596663256431330114291603507849\
25374739123847303681468643221265804076798281079676057198890723847540005928960\
00000000 + (v^176*(1480718937675787071231057467045088841238508576269533805516\
21267724581104350334665943623781823342311241574741816964851930216971666865805\
03992630690316435822775329275170282881971571665111581381040795076803304616237\
32285285544981336234808441373589116618987931713123088984882170344418195935288\
3609600*mem - 1127*(-64612472494584188347531125698386368853933359329413542249\
19209653723836580795195003092428527114757745427693327536248319469943387698420\
68453389026710592880655757541959920852181552946876019212830631280877729430753\
2426408989870839542797719049857543735578599266752735634915948743570227200000*
       cM*mem + tailpot*(-452097021551805330002150882834792908362251140192994\
39326084071929293972539945557086696038746025977847716291510192400107549085045\
88549388505296711671365738799192778858778372883066021051680300481150861554819\
55416731038073852923352952582416040178059174584530187394155580480426404192197\
18224911 + 133579536608263385450414552303796611936449798424557377195632127820\
90373148202302501085773071272186106639118853911765267950073009992725557441623\
58273100057650021905721632236496080317248294285861745106351193353876916837219\
949410932697683710217579321201201822122328337017147179311918717034328125*
         Pi^2 + 3067504271229164521655356927077958726221841417318349274468223\
73670382377205428488691377717850968256689093473257771376533497457591183772782\
10413747740876579461768419573494932106042724840709010440904089011405187787836\
506012329006440718323524736487492719904385946518152078185271460235776000*
         Log[2])) - 345707731367526841590558725681685948445201527731777963232\
56881512652093911051790675518268801804122528860834436150834135325163470526411\
19254313629370396790505341300885932878848351015089547905476689890831585364663\
68917422758947902586895506123780214042953322429617259573921148009356857195520\
00*tailpot*Log[v]))/213881793165534575501308695941988552309332087724820046970\
36118226876408587150515828367755510974829313066650030552636020108787138841535\
94748932083160077834092407449916505553861832365420322239147674081600127814190\
486719240839981856798517376253701420038629289668355072354632597504000000000 + 
 (v^174*(58050440382568958114679224871553140490683263554286188261110177844741\
10378794495487260186023634994201521932049328682340646094651623329722356344753\
80575445938694165575517002194308403355709577786853230624674285791091395995104\
753889288004799625728547483323019014077369369752446083452673521090560*mem - 
    1769*(-189612614853932478813755308822711954485536703901593827393551822356\
98798910332594940764033722416385634813786915471850992715173897408252635389766\
49902250962324528327311645395639883668981266621024852044098246104909181338504\
48195150860596982941649034064391489500481202702771657113600000*cM*mem + 
      tailpot*(-1303191984187342892609850885741259033540251372087451328116888\
09549690614002146774795795457928173042866308975347943137241134199432990330672\
83367918934706399436840693174627728141944151528608937499938286779861177996587\
61632139908891948567349619796886229417821083277593541238893277869743579 + 
        333809128556051719164931334741819212362403069357300525845879444586653\
62476403202023926613549565809632833434470152811344968796022606929549574751744\
99745311601820311565672301225365604975480064325937070737379833173574447176884\
3047443727594745252939870357137702007964422663214668473494781250*Pi^2 + 
        896129268374677340893669229881620680882215809462708216821187556688536\
55861616256619115481761734886292228343241218508795962071711781417187293944236\
64832987699244633978464816711903366230995202810818347152946267948779827983916\
51283754356812107711032989652722900484005289380746755584000*Log[2])) - 
    1585252675754804216040900867660586984480639766939530835556680787782021172\
19199157959215287236509013850951939193715542060056904858141327004322987354630\
89555239963757507904260763357054862630513772337656113561948001391515703548311\
20961457200618540817358695666810956205356914541010628096000*tailpot*Log[v]))/
  990224049348133779598021679412891843772950188546652891927348910161258461086\
01419002289062213223383343930291199817753727470541400235513198660394602923446\
74646165544846317265325314201458326981454708856446778361325133735180900561082\
7426033654759471899069228510217371169849344000000000 + 
 (v^172*(37918109821004296295507690833338982615722390312320307577022995741683\
04535995602480516581034482389076978019900354549355661101814221870724205920310\
39948259231283024433247934579124562882043399964930545610882206336939815084849\
1752166741381195659522266855066134408807800774487030541362135040*mem + 
    2574941518767771126535782743782501823013966814352575519402221432916554139\
36073172137960487489339019375926236224168534739985731259159026248562566874919\
33189332421915401591948942566469408878186153735832136120332236676775563928963\
62330318556853445592721274590996041210502997606400000*cM*mem + 
    1738002467575318893903240230714720506877604381462929869857547749811387317\
11743619495862297196978699883774077951100155678058405316119205857126395281387\
04119408280276569089781313687260218289211842061627378951168240090515140348687\
521952203229586391444804003095104872705104731940739242038*tailpot - 
    3859506788207535511466382718117017968142118418882707775485146883245521745\
22421494464143509057536090530430552329402090446260244629131731876636096628398\
99807557728204321165241308658162348278496978568313088848388468021576420355179\
2408476771326621895437307429438663269916139477905037484375*Pi^2*tailpot - 
    1211388126182125241798951115662169284673963278631967722306331865022815435\
46179324211930180178841407833549918152153339625891686294470341095553608630387\
19069267479944740753679108643584776102551670053120580001965559601973208007180\
090070776592641944912269976234636433259094157273088000*tailpot*Log[2] - 
    1211388126182125241798951115662169284673963278631967722306331865022815435\
46179324211930180178841407833549918152153339625891686294470341095553608630387\
19069267479944740753679108643584776102551670053120580001965559601973208007180\
090070776592641944912269976234636433259094157273088000*tailpot*Log[v]))/76408\
53493534783323544103825834839376006591164439125373679348978064588884579880474\
88264006707177562146441951910689787705411751907740309875770815479825355307738\
32100113562651048753059186448512721911605657415053899300404186090319784118362\
9546895520687901081130724491264000000000 + 
 (v^170*(51334577176677396958120104561367695656482149135162003553279197727787\
05250498294208836420553826979204281368187122046015465015768042499952175833093\
89641921755061981819723263383217724848259567491046363158793041560356671603199\
5548024868883859791139479523364838086204232475722802790400*mem + 
    4098000059008292507787046523008408100563833854587876915597362291875556139\
46768651341452866659933248321621325936681579091398785890805007247269140911344\
87877968898624706938116796630010887754207528365119004701349768355199574153872\
30514338291271421635744358388018363288780800000*cM*mem + 
    2715882152087832964088322885777229271875179853084983682746865390866659708\
23231216026284268736936347094586895268150690678135089942834055045896260471858\
91739512720626347541533228038901482941677551944002658954330576342016434885298\
989028258218359556717627969109359783462144335439501*tailpot - 
    5228780906729500072734459016938923664540160110358262134843759556170506708\
00348314108863192165113933648627642976008340191238984728338467279078424261442\
26380125607531388766548920626649382656243959706970434408330476585214759692298\
7217876356280625400896560055973296317914369946562500*Pi^2*tailpot - 
    1919012469952582076334544292546248273934094041987955960498382854906509373\
65493109583882079682962001665535721109830064284672489480822074367768098071993\
90565969968851162674974785733541548748527965326176420966424347117419805506390\
615653173669617753746919265603922666712749056000*tailpot*Log[2] - 
    1919012469952582076334544292546248273934094041987955960498382854906509373\
65493109583882079682962001665535721109830064284672489480822074367768098071993\
90565969968851162674974785733541548748527965326176420966424347117419805506390\
615653173669617753746919265603922666712749056000*tailpot*Log[v]))/12224035614\
58078692805279397735100721202587744763629776868972492283173812222011121171238\
97993046766455240382152132214047977460357551547971704009080584089300322256298\
69640207313244808434674069496744611091499653461591443520719396895076753721945\
38067358913080066048000000000 + 
 (v^168*(10957078922106341932373554425431416159674753578179354850954296165646\
73351680607301854335771801544320082588942429952008887782307568553855361740449\
73684743925107677498535944823670594860930697328724745674494611063254197647228\
0889766044695748589908379639858878268122861308316328394752*mem - 
    79*(-13019129933091399089413483612888263897410420789234893772297877343181\
52362723637165302678910721258552039060959590390894077890085096183178212783571\
48050036986137246173394680097566490538860909644621913990302035754917772563526\
96407273379930603227735244644923052015967272960000*cM*mem + 
      tailpot*(-8470109666579651683388824740349232062150612660834913684993511\
94569379355579501494895922941728761821125025820284220292793395794927982578055\
32574494205582176508198168570124965031835933608622102940290539763693685874021\
660526615423558784245789970339102477453054960355510851078667 + 
        141387314261212924896271407786213377480439242624980312116703804764772\
41244018962110742177894269576684381682396114301413673638900971266967899359781\
82478493792846017326312715638007019557925047187436211560225892169555069786450\
957438410724558487459382191481808308126746651043656250*Pi^2 + 
        606812554383150615793463156689247614280050841300043921366102514868454\
26924337748359783136251830011325786266841291850472365494454858397969852417393\
37117867639115751905568496052417822262256528107647979850571888286802379378626\
8708419704319182986836413530547461247416593408000*Log[2])) - 
    4793819179626889864768358937845056152812401646270346978792209867460788727\
02268212042286776389457089473711508046205618731687406193381343961834097407632\
31154349014440053991118814100795871826572050419040819517917465738797091152279\
65156641215455960076668913249438545910879232000*tailpot*Log[v]))/308427256980\
60771642167887694298928601441014484932046104237369530728634048260569617991087\
55720515234549851260659289678146945748327817958939236992119939594195992189270\
57684999550945600100302389325377037077433452947090468022775534375780520209777\
957457899167311462400000000 + 
 (v^166*(26780560434547138996719343257497411728207976212059876972750626291017\
70459003564394084131984085264519559565571715204692363315497979887263629092190\
60919200697663211662072462338884192926691945114352043530980046324776807310143\
5050915034011606518354948113326561410802607765409759232*mem + 
    2956637629118679250441003017087981992765656956964446069815711783463233699\
97645551018607276009691802725060246302896734711432652080878798735586752876843\
22629895147181139722634756887511904110313032376955867879012269047771304924393\
00702974849046463192968838436740545904640000*cM*mem + 
    1887919447581168424805397467670801252521785951944463485988651868323817138\
36793020214400805365038376370707844304142412598369934237807791680945978734453\
19607210240713974139585802285100403082534885863934311446977906711349055744771\
600788082759403248712463849243711332370216323499*tailpot - 
    2732554631052092309299601910884102681730198758554524587261380230618116184\
65792505966440555360813194923195111147779252283172944557743016905919883911135\
79150985115566087008502245649764847752476503861362633762500970425181960654759\
2470763536248393014176007958415594766872674937500*Pi^2*tailpot - 
    1371556750755929824715039322845344934746451647409638787435117896752670746\
59965166840255899920205928641656347025180882964968671221626910385284028262917\
39356102493905580733472817515946556321625952540978626726134201952138186910384\
280252666355361086393206194660342830298112000*tailpot*Log[2] - 
    1371556750755929824715039322845344934746451647409638787435117896752670746\
59965166840255899920205928641656347025180882964968671221626910385284028262917\
39356102493905580733472817515946556321625952540978626726134201952138186910384\
280252666355361086393206194660342830298112000*tailpot*Log[v]))/89140825716938\
64636464707426097956243191044648824290781571494084025616776953921854910718947\
16911917499957011751239791371949638245034092178970228936398726646240517130224\
52312008943815057890863966871976033940304319968343359183680455427896014386692\
9069072737894400000000 + 
 (v^164*(41944251878595724570441589783447688088871403554517203744851623373678\
27388558224025492758770754193071356713572485561521462768996385874900903251143\
67145178370802646159810564643806004544790160944649459730485597624018105987989\
39185377597492976095347226481073113850415943778304*mem - 
    49*(-11118129783415192554263315648288944545842299539995238632243327047378\
20307557689908256122830172494291572972707190696241393186394326160573048741748\
31588431130128647492960439206582538526755697832037703472457283976343382597146\
5783276645345040493249368217181602447360000*cM*mem + 
      tailpot*(-6966321340203664092198311074168315749697163025830977624006162\
34587804989028186508749164754793289172260423066441359761053789563694035437097\
27636648810237935999523134119683202067148063148227631652109261147783855481985\
98528634279981614882360124567240424508148966365157766 + 
        874368375474723518745085539785022416397926487498440215102586603356011\
33598987959961253275776854359733641030828991673594638548963508417793901119463\
54577617091186657304930619654583391237064851271615606667782619978845408629662\
5266936075211972438621020785076717557848265625*Pi^2 + 51329410498562486486068\
29431560508193978629548763080235281929532351279499434424538309177786418228615\
99761761597872303526205422252634651989591404134001701147192959382825819600292\
00709145485433528246355954740227259472158010177258527042088353816677524094088\
37284864000*Log[2])) - 251514111442956183781734642146464901504952847889390931\
52881454708521269547228680237714971153449320218388326318295742872784065690379\
09794748997880256608335621245500975846516041430834748128786242884071441782271\
13571413574249868566782506232933701719868061033026958336000*tailpot*Log[v]))/
  165149002736287695206475237625944053712595313636139965569354788869601615105\
86041675764634184024601999035812430547646942566133804747185641377097764495307\
66722692524696577225285477690363455811174723432192714174898472809088468646814\
4254464208979304303191654400000000 + 
 (v^162*(20932553347817615097574964113863722072981615874187975232703347570421\
92599822689064049412302502775762627531824343274523599779040009003456654843039\
88884797322243609337625754187101952335200389069098206352826578744597703774254\
57777250481701594331191879730275378492604416*mem - 
    7*(-457056695027285113576797708352211034008793782638085724494556763641163\
07688358079890788405076399193363431355535283839698866490203187224754763503267\
45223372977116710646943466551774385267348061571290413567050206512460096121227\
578570803394293947983024246226944000*cM*mem + 
      tailpot*(-2809533567468218979356707117619574643042717609738227752938755\
69285782740956535629020124551117824310438237296156101622393198067624124565271\
02932243691957447325086889518369141907151251696729568446416797952360410741047\
156235244667684751156541588522710855948700281181 + 30583209702958592247631771\
85017781528439860325716754041620890825216624338768227959405560280971597621083\
61075767203211788833786168340244142807299429279830180507624974407007742094223\
42590911828111196859729307492305913693577123771591719721525781166081802412469\
3806250*Pi^2 + 20999002158193053208388018011618035330964587529555681358653747\
07318803413453364726091115857567342126945226107991560287727472259225095083789\
66302578607642773709888262862868185480494907367228399572749849203931411265214\
91840594574928018734961263402813326476185600*Log[2])) - 
    1469930151073513724587161260813262473167521127068897695105762295123162389\
41735530826378110029713948886165827559409220140923058145756655865276411805025\
34994159692178400400772983634643515705987970092489444275198788565044288416202\
4496131144728843819693285333299200*tailpot*Log[v]))/9752625089246813781104963\
89622790240303979695261193385828076325866619513079523891611134782743660725828\
56845070495972212770516982290954430648157911958967669553940916780476047046598\
54040178879960336322578004788638538361669965671110001573308400538746880000000 \
+ (v^160*(3970909752007464309952936618051788687073708937197413022905310217622\
40765773718929149139911306726009333646334935069775521227255295177220479652131\
10632309662642284419478317014891811322341321457531900795486958199295105463978\
1162229016872692408002278600928351056035840*mem - 
    2911*(-245413657530727879228198517736550511199524716617571167677073268611\
80711663108986126165170678586041172322429269452153559612872322802248293697592\
26116091794354626037902793771834688627958550464471489037724401370204958181452\
65007432806162026221036780912640000*cM*mem + 
      tailpot*(-1479650132738341588439168904703205299830556946626114150465652\
40949994218880236048364298887581375814604826053467913451721201994350036877808\
53769562525291705454760047437107889189672438885839263031810995466269993513865\
46629102203951629156382171556774607450697299 + 139710944285972956902014374496\
97162038571027558435882327780069724979398895097626824905435710431800264984671\
97847736889558967076717804073039907584524910507232962558925791607038699519817\
2375779547929561730545939691408005567095530144312465378815118831386198296875*
         Pi^2 + 1122007989360681008885756216764662969727035290757131931112670\
14532903472928025480895037549626639432543068356089397638155765640617264512518\
52193046760736673403595270984402144606653816214207472632280946496171785897887\
71770222668241277314713599809548676608000*Log[2])) - 
    3266165257028942416866436347001933904875399731394011051468982793052820096\
93482174885454306963147388132871984576236524671433779836856995941417339591205\
04456277865833835594642949969258999557952832569835250356068748751146231181872\
50358263131289045596197605888000*tailpot*Log[v]))/218996072363326656761339009\
64583613180478585971433983214702312706585767509270746069112307995740884562018\
75263559041292202930770560425623442698156705665441681600469688184342373800865\
42818388023061444369266574595176759618337552494985065268901209702400000000 + 
 (v^158*(18478944341621960088870694090518922413296706205112512542630825710755\
57194334605452148737519333732460929691217346277169114516825422545562659834522\
22290280495633961289206696357188849369402996084119489386335258629854656443422\
33942486241504047818380540297430958080*mem - 
    37*(-10579049967711968077239083890868572157227186694736909174801498940480\
69538931061578423752115531414701863298897785091435424179872784224853118757038\
95831558700374635816723272415666435831371795094932141690917910419333789498145\
6855501104713854085056430080000*cM*mem + 
      tailpot*(-6254673175290356187261905190016374374908830318388991301869558\
48421473449996271426273527780003329414081714451805441715505402713225075368975\
70312145859519547190133431949186633988469014138943994201311515479972061191353\
34982485798768452963637050693127765056177 + 512362379283048159265501063606919\
93908687661776926499747302890890600421526660926021188849122701048536946395990\
11859901850552163186369333023373176957953517949081678619338260617688586173885\
4452660023287774588155852160977326163353628634479265177215705173156250*Pi^2 + 
        481267460442368972764616155939709426599520744202444271346892703437550\
74078831747616124251306787721659641619628426694250411445913106242986458416580\
77188110327991756511555600342575632121715668471047119236286164398091627351757\
871744622023750984628721152000*Log[2])) - 17806896036367651992290797769769248\
78418226753549043803983503002718937740916774661796597298351145701406739926251\
78768726522349878493099049896141348855960082135694990927557212675298388503479\
733428743411742588082729390212015041254551014878786431262682624000*tailpot*
     Log[v]))/120676723318390207979871611795582159989412141204037231630187976\
41482183337829660594272239077774999758652558301820513347431748120350605911480\
28079445464223401932590475102499379413430124637529975357872796369941929999410\
1153753673357980893551001600000000 + 
 (v^156*((7975414899201420517361155562375830794104488510325318699694587274705\
26866662146516169965569964238339448738896589201273630794429860362936096813933\
99902902134293057753542455419104824932217340423014737444236000959726659727991\
83334671923169752431918435092398080*mem)/3 - 
    2771*(-239333339222507563101114200667603783577856060557469013455311308908\
87434859177204311963488768079021515911264581861630234914137204639598566999223\
57361061390763362649389201904315862751531050952481330426060320623008641721321\
716270899787334596689920000*cM*mem + 
      tailpot*(-1387260146522535236544603880981816978197370541742694193390661\
19926935274978764842534630466770909714807525111212185078427676203314061202316\
13300313114149316621279244248652747580739359877985694757062876667948058688239\
364537425998916774945045799270848914 + 98611230247135476365227229946948433077\
16038074651496098073229744046466182519849943637036665860106401876770755449101\
15201251985438221008391349097028681254638657921796236498767185647178931924791\
07806229157704696392745407848357676338160237095426873265625*Pi^2 + 
        108332550331035183559465600491229799687317987632018150988928747219679\
21246285114445137909342534355822664923965760912305713870157966188562992740186\
19437797534171397670427797524318475110911447920344230082017436510515766798530\
3092249886772620840960000*Log[2])) - 3001894969672984936432791789611977749335\
58143728322296390321558545731097734560521274771467881626999846045043091234879\
99133134207724308508052883055944621369671889429447554269398864945323356221872\
738615572703165706391897987274868624436246932350300160000*tailpot*Log[v]))/20\
56522210606513428423169935166703476302183728766823988244512208841544536099124\
16398640747746676887502599834727684276541100002050964654251538527512860297103\
26049599098542934209499490876576857112438186713870857702784766792354589907942\
89971200000000 + 
 (v^154*((3096813056051346182050925230956558819882297579169161936616103389869\
63835722186604964233914787283853666291672807700711435216853879014026179140548\
45243576422904732131738127717309018692243084109310644555113154868209863561157\
827621657828207236437571144777728*mem)/5 - 
    19*(-95797130264806225946522299878594453127851399081898972717447956632248\
62371373022352279984641617245713106633129696711538288974775344624378371669243\
12134202755440634890027930627074597409564623101726530695225380873552011182617\
772117428199281917952000*cM*mem + tailpot*(-544252735034423952626776725280498\
62758447167332868082515022915678808506879649666744861983483479759403941250358\
26404720677500092908799447864242790812913736329953052366246353489931677712184\
375892601889225084218660135022071998095207633578226601564842443 + 
        335797727202402658768811961434655391183774143012853686387841297737071\
50363366143984720770529421554907329268629280758785162422562840085941016934289\
17848392664488369231615878987455128998897935530073968463270284867926625515418\
2427421665123394075073425000*Pi^2 + 43141660988627119472528846905804016392658\
75586827652025125468399474776087340956796987702509376176442959906319242175797\
27944911922581887839565206188859470645830788576762927018332979523798664846458\
6626568347145310970579548190500559972081103102361600*Log[2])) - 
    8196915587839152699780480912102763114605163614972538847738389959002074565\
94781791427663476781473524162382200656013401483095332652905586895173891758832\
99422707849829584956133483266109521746320827145904798595760908441011415619510\
639469540958944870400*tailpot*Log[v]))/56775153053554051704934139314418194131\
04188208251968065705708552016533995365680207324437821227276035347848198003553\
64684018410570147818485842560618325973597958424514990449103943237478187704644\
2084161976222015930216653408932248747591598080000000 + 
 (v^152*((1260580340076053270592725632387062847425011347608747915657792300174\
63113974261343444559470028252094256961947339642879614462728652501745130005897\
09688602841387540331146170667790697645025970276553120077343433791155427803933\
08065393199677714249231106048*mem)/5 - 
    11*(-79367031499721998175807999667895171291749889552664849338905561271004\
63284101997590860641160565805170005229505426127074234965431501891091201389055\
99845718823575709319618249455606258670456552262178111464340522907516359313427\
31419076245061632000*cM*mem + tailpot*(-4418509295740031432649045335762671448\
73646364881015640528411258565771306035358004014941013665247456563857530791503\
19760176098349328198524932670506791635556470083605308279252964841727765912988\
0283661506456331491847789176197604185807783125976488099 + 
        236698259158609822140443767506825870062822798133810940806536857109473\
95557801790805483420864463789827397606117723301870779718917883151768366191630\
58836302813372278640837317697356905424730722697674917844813516352524712784419\
254519875827941987987500*Pi^2 + 355586332428585989574693021433130038764282023\
82556584330289417012888051478616329560396801970571129067835616427931884667705\
29106511116272322783538245903714354461954643647129419036360893650147638852963\
31883377639929726777166567209495876962304000*Log[2])) - 
    3911449656714445885321623235764430426407102262081224276331835871417685662\
64779625164364821676282419746191780707250731344758201716222789955506189207049\
40857899081501080118423609399969830151624027382596507171540392269945488322393\
04454646585344000*tailpot*Log[v]))/273958468700801253160268960212402017617457\
45069735418190048777031540889767253813005811801878147442749217565132231005823\
39405571174231897731338354653184585977409884747106973093723400300075779985564\
64098447308238284918616528288397393920000000 + 
 (v^150*(11171796172541418217001129582793075739647273164004991389209310888056\
84749456731520131652835394723592936674011184636521950142784344422320716239535\
67166580234850270138132807313043375435718031815595437911817423544089993926842\
043440613039815304335589376*mem - 
    19*(-23998904959155543715387809444600469090557161843106445421732256774680\
27611415193785614904300530585646810355296612278256571017353479143102747885437\
17727594399818887053178367892918094124350645933214147768902103914956553123275\
40701329547591680000*cM*mem + tailpot*(-1308898694958470847152974278137380469\
69524644584443165240669818816270604045490768805007013491025025305413857074786\
30319340801868720471537344294806820956304650627214964951762444536247911968624\
1792007451435004754560826966886871565490714565685642689 + 
        609010094992050176299559034412536868876868780991212066415952817120508\
33522910609582904764970476045531475981925756006895060966722650095932851513976\
75908446654456769423724062560045710268156742898617684809892453675215543518121\
28483798468058337275000*Pi^2 + 1069616646337616281369311433658120670205161541\
33010632702080123263495498755631638096573901705987874323172359925264985264102\
50622521212474059096343881121163465016180640284418760871350576821588102569632\
2252394836530690418226170522431370618880000*Log[2])) - 
    2032271628041470934601691723950429273389806928527202021339522342006414476\
35700112383490413241376961214027483858003472001794761827903037007122830533741\
30210583530743216540395645655566095961017394882301227955018940831179462972399\
26196041758720000*tailpot*Log[v]))/143959067947873269972752797563841824544205\
34829638038220885503854153652266232099190952061496478751763123879766936675034\
58604838355886188298314740502469607281123028609148568663899239011186317508338\
10752368808469162457234799896769331200000000 + 
 (v^148*(18744702788484761223082617806372600858440067919647349893596828825747\
26080288795528882583598675909926207048104218001974103972229343468266779484321\
19518908839126693201630503855426182677419709234966553629238477299615964025896\
774517742308864452198400*mem - 
    7*(-128858055997004238943200178557216066058049335517945774431291968658538\
57276949626449101376469784577032160233019254244890314668697954497909309122245\
66347690989932575560575838428218968066165656244509400166662377362846583055993\
19343471001600000*cM*mem + tailpot*(-6883255130975568464663739291986054274339\
55530239269898003347054934128351866675496040546888048425673603704063103940360\
18594135221688353534531155587635812128922351431407271183173398780770954181189\
4679653068023378781103820780907579998948951043282 + 2782884617434534477512523\
46803080602693641964365028755729810686557114981461675117165140497184936467585\
11616056637477251126228470709794404799748789314501712691222134318718747868795\
19814082617390032515393154847162062688729982332827598608504734375*Pi^2 + 
        571282081499083171862458582561466717232315726693615721975753967225653\
50755203412360337330360509942727354121859534348356870527734711183129502126553\
59204501591953251985214634980362662781058714804527788938497449483670598123114\
22463940006912000*Log[2])) - 399897457049358220303721007793026702062621008685\
53100538302777705795745528642388652236131252356959909147885301674043849809369\
41429782819065148858751443151114367276389650244486253863946741100363169452256\
948214638569418686179957247580048384000*tailpot*Log[v]))/28654273078796431125\
14984027942711475800265690612666843329120990078354352355115284823260648184464\
92100395695997943372503703192347907282702690035928039332659459201554368743762\
718797573882626892583222038950653800084508827229093888000000000 + 
 (v^146*(26414751414798322150567088911983408059836820997313094066830984471465\
55623503055661545164079453671529416637827820259206244781579648091550483485118\
09773221112740089233944305704069386445790338212454901053017822839879341599152\
2389461972455260160*mem + 149901735631450069562401443513591409870494967183410\
83732781676849876363081564338571070667947690985802032683227897015304818913257\
36188048917195318319572171490401702288685822583960433967492377631742632588319\
3496406908754538598812876800000*cM*mem + 784047714442501952448593615568868250\
10008929707019463704025782778607190568118757953559231036181010652347586938818\
30861912604341825733828578663294734381001478560722255967249233491266649334163\
4943404354135246732191269628140519910855581113763*tailpot - 
    2755755576406264389416543631386947627485325735754075172710948980107609289\
27809838855103615990113009782367080270758258602250163216188751157575656393288\
69608067150735166831882933347713427075143480269428101328383548407976714484627\
5174496031250*Pi^2*tailpot - 661024726586454367359175279975520810165023919136\
54770575242873645069292726977310233956056328969037064903782842198147616879083\
13419826049052418182024820410275025608261652146662422386030452469184862599313\
1098752684762388083468591497728000*tailpot*Log[2] - 
    6610247265864543673591752799755208101650239191365477057524287364506929272\
69773102339560563289690370649037828421981476168790831341982604905241818202482\
04102750256082616521466624223860304524691848625993131098752684762388083468591\
497728000*tailpot*Log[v]))/47920049967884860400611813966531398016594181728086\
60852446854288043271042135118209952606609446225367924203893202611755028817853\
16588538869974640323833254163253731945897290391863665753365821948931737974029\
4564855249662640128000000000 + 
 (v^144*(81584970153281943333958773485284470264451010164682078049629593615533\
19182409210533902122956573994826316727634057930750584051549541159961068987883\
82535442572692840324115684944232796604425562427858600848410628691915334916971\
327946280140800*mem + 5461602922253685324735427860841722290689287778901982467\
57332175168716245099863740193441798208525216332372202749447242355136988981506\
81543847137461447225022989797602868482831095223655420548059248525628777089779\
28392150692030054400000*cM*mem + 27963555157630107301053050580859155966519808\
93046860163086140395433978017179443267247071024959572537872524208635514849142\
12549808016514708748290701298272775404209742833094024690938597492976999353749\
29013685227135483047094343540179489787*tailpot - 8549401892563145359722602754\
32148891112599213794999928841729469025910612236968926022302148307298035651064\
15972707737302927451827680703573519915568392823517972747483257386366954873912\
170850415061755546779761637488862385784568326803953125*Pi^2*tailpot - 
    2395367148222311393810822362335268981669577968530138424103076431486457810\
19711742888180177602576036134932034791106925676324015372738097393720633431959\
19009405279343851388838702321132055670714657515552423717199745528660709054188\
032000*tailpot*Log[2] - 23953671482223113938108223623352689816695779685301384\
24103076431486457810197117428881801776025760361349320347911069256763240153727\
38097393720633431959190094052793438513888387023211320556707146575155524237171\
99745528660709054188032000*tailpot*Log[v]))/175714659422663273169939759644377\
09837632872539077937700647383384309074224460965034938888185222169556591262775\
64404950397250868421643382229117197507277810945750161586582801783579377956917\
210133200070352345889153109458944000000000 + 
 (v^142*(15265832327265646681903625398249830199340748926185247145277755622120\
31952487996973044547602565911339235534796323969310285729733825443432751550951\
09043560092369426900576684316372213704340581343656613873294119877265599615906\
83140096000*mem - 31*(-388991415162430755860068016256504542499815695244237238\
96199803869093233353175597609925222256770299943878059265510131025749051618465\
05382619374002902197199322049492041034889955792226850330541042957843522766294\
654376948531200000*cM*mem + tailpot*(-194907485060176399268062969710119456901\
71347085438092632306188905912296850690193777495398951353738524227319113183649\
80605588460832541356760156599761024014333245924371941930500589967853059612457\
4203365125199371996586371845775626257 + 5186854070738491313929233136280203566\
16137429110626092854084541770056083560674920470004048267811782575278051478527\
53089975888877310686819055446498365471386009486615474565111633700670968847769\
233801091490470457152990679249969468750*Pi^2 + 169668402072238199793740548560\
04726949487343132884277929538518098646833251194411953339169718927673929077816\
08866618209346047912346310394186729784376831820281451568931058098369209625506\
6362624331948588432327529084073109197312000*Log[2])) - 
    5259720464239384193605957005361465354341076371194126158156940610580518307\
87026770553514261286757891801412298748651644897274852827356222197886233156817\
86428724998636862801049445498390705724135429040624140215340160626638511667200\
0*tailpot*Log[v]))/3904943762448626009376855852357373624968414716004697475587\
22240639785639905350571912949201858353028058830676377706775944986636833113334\
42133365871978261499305528280958771540592456952684946222792125657859146832150\
528000000000 + (v^140*(215578886762319773334340479614444318186217242970466117\
09422496930012503541189406393841993262164861883189998905869588443204979185850\
31942285602017144309345167890884471161333823839637877507392289998598837862579\
0884420577728974028800*mem + 200992927753388390096784682968786368027051953132\
30759979876814291392810727730278340449252613614723846672093820231083594545374\
71692750730050094483531762970983729842232510676415198286271859702308031795606\
04817108307961446400000*cM*mem + 98528555496145818308081665601874761996455797\
47292263967970542405623111658037994754798851970098996207625835607934947536130\
28453256525308964986231202104478322867772347253469360764237470729329241113497\
978258735033034667789142450002*tailpot - 228402302012259003151292784977468082\
82871243312856695954569830390855292492454765781479517942349288996266260295981\
06048721895486327682201235897635168119099507920593320531372701596813473852952\
186076211296771269466459230034985203125*Pi^2*tailpot - 
    8718020788884275503509941116349309893228873812925294857326109456307028447\
31493177949862696220787967136579268085614066912037454012228053052452887027255\
353083800801904592908419981807355982349449316607956299836342973152602112000*
     tailpot*Log[2] - 8718020788884275503509941116349309893228873812925294857\
32610945630702844731493177949862696220787967136579268085614066912037454012228\
05305245288702725535308380080190459290841998180735598234944931660795629983634\
2973152602112000*tailpot*Log[v]))/6551919064511117465397409148250626887530897\
17450452596575037316509707449505621764954612754795894342380588383184071771719\
77623629717002419686855489896411911586456847246260974148417705847225206027056\
472918031597568000000000 + 
 (v^138*(13602718915563762951407074278921993142170079044257316478281284943747\
77101659086664897228413511517118366747943090238001982551290803650287241821189\
71237187247683370949307737802317100093711282202431543000758399321346839184901\
40672000*mem - 49*(-305576668320911868474927302526417511198415842811994258152\
20648973462067757874637095184054906249930877062336179552188271537942034013419\
31538701275162262766908992368959064632567442673011147055867851290087192210396\
151808000000*cM*mem + tailpot*(-146510122331770611502446430324133925873771974\
02761771532733200784982516007995568804474041797160532668382961309407417198856\
51766836491335228814575251470315432343003203045310114726667804679783936716100\
3855223372283919402268086991 + 2961069584951411222090084524985022518420330789\
36415491345936306857671839411393994525296699950190971272644260926372922667962\
16814809846331814499718934115552431950037679870464331194013896991814760574056\
651180123559182663827562500*Pi^2 + 131795249375787197831658392300071312970525\
72835101151959400360527560850206613516302926842504638734292441240502724441786\
68737426852589488824896168823476927859195214695166089831372372845670030519872\
9523294719755984463287296000*Log[2])) - 6457967219413572693751261222703494335\
55576068919956446010617665850481660124062298843415282727297980329620784633497\
64754768133915776884952419912272350369465100565520063138401737246269437831495\
4737746641441268043238701077504000*tailpot*Log[v]))/4913939298383338099048056\
86118797016564817288087839447431277987382280587129216323715959566096920756785\
44128738805382878983217722287751814765141617422308933689842635434695730611313\
279385418904520292354688523698176000000000 + 
 (v^136*(28598809811744427994645118956626745926834343455740962372888834940073\
64985100425690309667283862108463887632649748972744463622145017461813659554064\
26338136901395394094118413929691770849531917010420672217482996884821621411330\
1299200*mem + 371772892814440796311149659356148940254876016480618717862291676\
67998906658076099145326680443655460430615381850974109877791377904794224705001\
87260489748786201880877950933184898338379038389230158610313858202860563044761\
6000000*cM*mem + 174285415184420182462072678834112380101602168926301592616201\
47464809326577086995641084205731702311654580740989410911835101712112340879707\
91116125647778610075331921242550211562939854319682957995958879683718440949226\
62199542539767*tailpot - 3074110097662006420899039338676321305910236516221687\
94043698183092928299289236332296645260639912503552772764608132572155921383883\
33258287400056158264002457327557449392128604899920816270244237403289375936432\
2694621223911314593750*Pi^2*tailpot - 159428162886805882576044350369343769828\
97853808224470258010673965354001327463244890413464866331307760980750255164692\
00384277594927486395648430626624781123425347597524909927017146382902023149879\
19852311973784075178275279872000*tailpot*Log[2] - 159428162886805882576044350\
36934376982897853808224470258010673965354001327463244890413464866331307760980\
75025516469200384277594927486395648430626624781123425347597524909927017146382\
90202314987919852311973784075178275279872000*tailpot*Log[v]))/122848482459583\
45247620142152969925414120432202195986185781949684557014678230408092898989152\
42301891963603218470134571974580443057193795369128540435557723342246065885867\
3932652828319846354726130073088672130924544000000000 + 
 (v^134*(28826097474891786001687271715281512332442238922038727230364318462823\
85294918995565839997240925047840322700588317205131422991674356457061056117077\
69224240773718133814172793151850876699675385074464653230462128140159360444661\
7600*mem + 442668418326758603334256375610559918141492026048889189682747315093\
04819511952131090091871509875995085119480607423159844260885952915414093541779\
66314183488270320942181640994335028888577089432813378092172775449323110400000\
0*cM*mem + 202844815026096561802454140711664760503223112181356208884625962960\
17706711438936621514252797827266290625711202982158419109143351086140103074515\
04456545521331251079291064924514655661832898290157288572385716718071415722621\
51669*tailpot - 3126049292921195527815263631058185001670040313320282749206240\
97694818525204172282458649401986151169294758101057778654420774245735709168179\
29565838247055710069354587633183736702095991021280446670461052776407153991883\
3071187500*Pi^2*tailpot - 188728694609079357605724670412725548698871463183472\
66533477431040186888538217426722859946250092420236363686082159535110954410814\
74555003263385450115136972334159723193848953040657326682292712961316914913583\
93098969867264000*tailpot*Log[2] - 188728694609079357605724670412725548698871\
46318347266533477431040186888538217426722859946250092420236363686082159535110\
95441081474555003263385450115136972334159723193848953040657326682292712961316\
91491358393098969867264000*tailpot*Log[v]))/147300338680555698412711536606354\
02175204355158508376721561090748869322156151568456713416249907696546326177679\
49801645053453768653709586773535420186520051969119983076579608231753995185414\
2357470111617112866816000000000 + 
 (v^132*(78194331275680016383032277338504611121165189055798696654598422140311\
31168248497983513736621364569191297823550369426362071966192435086274110727266\
00442356365819810199513399142556467455647201914898110359953382019642163200*
     mem + 141891059633813252834303114979905433290630941179533910666932868958\
15999268851313684629717658598613513322889707945173812612856145187918462692238\
581930090454897933748132465176682533675985294366087591655683129344000000*cM*
     mem + 635338008812445818443929360509968838430050107487215926079619928995\
00180864819473207674324548684944608879631263948989582785619350858039370006016\
893320033695890450897711466940665781927288704611474126899046453240231367314*
     tailpot - 85659323019800310210254732713774118427585925592904065833697818\
03120250829924423827557216082420057992417142122057738562294531805755579708537\
39400985378074809593866810264099238827226541709165165025000119317462459516718\
75*Pi^2*tailpot - 60138111510988157591731098051429717539051768008636876267719\
83436789294036022005214933683005847157426095412526553418895481641149697090242\
83659449094164648623595657036306213182790090249666700535627863281255816919040\
00*tailpot*Log[2] - 601381115109881575917310980514297175390517680086368762677\
19834367892940360220052149336830058471574260954125265534188954816411496970902\
42836594490941646486235956570363062131827900902496667005356278632812558169190\
4000*tailpot*Log[v]))/4755211200639827801684955121186715324766841896588343438\
95171585860988961871178357459135286897331251608509527601619128490952024232596\
19948991693739702555776566062625629602124519551368604989605502747934720000000\
00 + (v^130*(5259569332772761996187505079619375215345808946598002270499433133\
82583473767733299349697869828886104168396244516082297363246588633477651604881\
791242001042856233456530326608834435166582848965028014918813056754306252800*
     mem - 23*(-4904714086717265667708675274663340840824345741842590961393357\
15642979062195420333364066405979567997560362556159503562766036242382921643379\
541399118308083735085898030092393662866441690389971083661464829952000000*cM*
       mem + tailpot*(-214529183907231869756756074056532475815356048172697027\
98409298148132541808192749761757508532189662576499139586614791657802158054496\
82475333863121792562269063390230834064491002392661073652724693450173492518682\
883209 + 25341587120490639865671600663234397073717511923784813729953446750943\
38257441393663200242964145014022752519860830181536563373717724101024843134608\
173965199527471653739372411826598038639649840115766783422373389906250*Pi^2 + 
        206636007319285465828963985826976145469763463702485677913263206453648\
76975437470344927563002377846554404403598646289455220524264332206542139425919\
95371926221768069267733580757329527119552493231890451224472064000*Log[2])) - 
    4752628168343565714066171674020451345804559665157170592005053748433921704\
35061817933333949054690470751301282768864657470072058079640750469206796158935\
54303100665593157872357418579123749707344333480378162857472000*tailpot*
     Log[v]))/380806442313487234026653182786837203711045207808497807299341841\
32647595801793152083452256079316817660188889859395534892018160844126934003157\
24043115391354264729585889048114262055129817917825363214336000000000 + 
 (v^128*(89532825710386073777390817276387698811882144946492872843955228367941\
26641916368202892594679929122903964598738191342007560174283369470815021047223\
6426278168831079257795031866885102572762397325105247163189402009600*mem + 
    2270439947107940588855379610869005562145506326166590138884683190594503941\
97905862274155420136260947266178870178750103840220076373950584624017648986968\
0019408281889775930448003228032720474607970592751616000000*cM*mem + 
    9697502864372146585148211129169450315488496186503191065286027589682442846\
21800917548265524751956288396010140685920248238343368322524894066744289240970\
0939642631071141390648089648527442057352341181251712414334729*tailpot - 
    1005327487847618705892339705290454493315171789562259244592180654199256952\
29717508791183101762050489672455700414397695909395268181183726505198781578241\
82416477299113331415754937953376457284005559336748371657828125*Pi^2*tailpot - 
    9507381846137570101381595307540735414494334420458855332156481107279498832\
97207430524434711353728929942540796879480570783396572099565139942825507306876\
5028606154564158830720406647204900293967292732482753024000*tailpot*Log[2] - 
    9507381846137570101381595307540735414494334420458855332156481107279498832\
97207430524434711353728929942540796879480570783396572099565139942825507306876\
5028606154564158830720406647204900293967292732482753024000*tailpot*Log[v]))/7\
72113629994905178480643111895452562268948109911796040752923441456763905145846\
55481452262934543425912791747484581376504497487518505543396506975732266653573\
8996266400861337036102013345076606926848000000000 + 
 (v^126*(28677979260321480238493175460659298603759573705620582624240318402002\
50718539883214503698010844615038391415052067946805336462481151253905753351599\
23670728463737379443889913980545063995223741592740888759710515200*mem - 
    53*(-16227879494436141296733921621222060274549499012631426276643175534882\
32345734007990315420739831105666518024545707724854292494477178965466982503855\
06859638636150636335104012448107667521539606161915904000000*cM*mem + 
      tailpot*(-6766107931874352312393575533849978563232813614170214187013183\
99055143265714102121840079915810671216566339133617421463297942796377772399628\
343952394322963145874060783722754857839222190080033277320315314434073 + 
        616736645554563393152329693952828208559997385547247382289218588206470\
59800928209160490739093671254721884544772938525931591186599765842254678056588\
0522889599465283531063215317728698895053522094723713418531250*Pi^2 + 
        675353532816135985101562204330769530216850136587811961289773137088114\
92854618384793675736080641942686998574689739449681064329778322262428928983454\
7081048725151674824043300737588671451543533883553504768000*Log[2])) - 
    3579373723925520721038279682953078510149305723915403394835797626567009121\
29477439406481401227402296241092445855619083309640947825107990873323612309952\
95582433038765674294939092199586931807295828335752704000*tailpot*Log[v]))/294\
69985877668136583230653125780632147669775187473131326447459597586408593352921\
93948559653990207095908081965060357881851049141927692496049884569933841739461\
817810690310446702679440248383995904000000000 + 
 (v^124*(45908679438432774171750820004666527908602118706355975706562979232890\
87693278431589772846553875157653332964734801835111547799202627533378390097000\
18863126846994580324133849118060478346208180617186601284403200*mem - 
    1729*(-942053034413072345732673362043368914193616249322596214408675218337\
75716103691697126227234296228961878156040812399668403933534558898001122102541\
91959826864796734809453113477386517048722867617792000000*cM*mem + 
      tailpot*(-3832880666820538633976867712824412594267389779179619411844402\
27468499559415723269329415750731930536214561869121218247164389695364185296578\
03153883298909731201768996340701566381014753260798709924962969054 + 
        307829458977059882092973369861528568096866065294020002967738014882381\
75445177441170590152642186015635831401918801750607881919141231741004285408198\
297816607522242365849865650723979654260722509175066734375*Pi^2 + 
        389602620319616725375583999192767792259355483193799531393736066575232\
18073874132896547215425478116351847753783278410384945700753727327334500276091\
828980230907887640785335731871419424360312936054784000*Log[2])) - 
    6736229305326173181743847346042955128164256304420793897797696591085764404\
97283757781301354706516631723447662912883715555711166031945489613509773627723\
06819239737730917845480405684184718981066438721536000*tailpot*Log[v]))/562404\
31064252169051966895278207313258911784708918189554289045033561848460597179273\
82747431279021175397102986756408171471467828106283389408176660179087289049270\
631088378715081449313451114496000000000 + 
 (v^122*(23136887624213759860451681352893253917316216687361941681627876084214\
05388964679941228557487997804979161184597999257959388757007855039038217457852\
45232211777710446821681961775863113611033245004851052544*mem - 
    19*(-51125595806151096952707644083997319042204401950813272504646449657855\
93153666527877088614255439045725857164393223274518396003673875910126142904387\
20001940793601675773989453663309664214046474240000*cM*mem + 
      tailpot*(-2029093118530318562225007299208633436751001309410118533897736\
67507404167022432939214811189811487166006644746690849508995638635102917451993\
1797452372947459886477386053230227819803202283657482301810917 + 
        143921860483308822674654414215683848246913084960742687932853807188321\
84810126432922774978634918241846806377397030619674992741451979278966002205098\
56809187472754365298483185012922764314884059451820000*Pi^2 + 
        210096753124962423714832357415619320808808536157860804623629823483059\
14714706135495517741515702132158753407864462976378294792166725205146920096492\
13803157581395683506408495132344725386592726220800*Log[2])) - 
    3991838309374286050581814790896767095367362186999355287848966646178123795\
79416574414837088798340511016314749424796551187601051167778897791481833350622\
59994046517986621761407514549782345261798195200*tailpot*Log[v]))/338044305248\
85597795255692299216994205032027834897030446768675262103653579730227369013328\
31206961095989122429979207892932300191204113355417549233743515831609827872265\
660104034050197422080000000 + 
 (v^120*(57256245791819588078940337976055933828452418448981381838333334669912\
42047338981372683996716863423290047585430724068833519829396142977873401153699\
363970505571742853127943717769786559380365747431669760*mem - 
    43*(-66172546991131725305009006644055360947772398594229524892306414130960\
79756889083849506976951985536883814701162429721542375348962115141309869818571\
376648138969939248363206334614256171037491200000*cM*mem + 
      tailpot*(-2560890655084214847387508634853931557324292300295966783534620\
20660318589580828910246312055290209762988468480438158301118585645940527197593\
70010120316247549511915980633104906898606782386694984352961 + 
        160835923967433502785896469688797514782730635621776392117426087278493\
44385846769394096020069414991859908452032871076535291752668483347688523314322\
523479000996147229193825225790248323290876306450000*Pi^2 + 
        270177522416698102183997401660754210754437166360616395473965422998737\
42169076399785302208324141254347252219422269427896735325923729991225287802709\
042918000859354560543970959676905547077967872000*Log[2])) - 
    1161763346391801839391188827141243106244079815350650500538051318894570913\
27028519076799495793807393693184543515758539955961901472038962268737551648884\
5474036952246103390751266106938524352618496000*tailpot*Log[v]))/9981623186481\
96785292983040331210458810000821896565859648681356164477960031404351447243946\
22252788267395347341905744870048233992247441596974878949119561956983106464537\
207796281009766400000000 + 
 (v^118*(75533983403894927103315674519877652563622473127903550056500193683647\
72836545397527935593545252574794144278180097105033866958192906334767918522154\
55916607691386700069473107143765034589155049340928*mem + 
    4444539785333238485051966880453128209198588301354381726396367254339987629\
42528221976917429609280797606682177838539894302136047039409308098675621710074\
22776216187018055628074189262547845120000*cM*mem + 
    1676564870803370174937904880967114506200177307251256574439888967497555394\
78136197754086957651319670853731230096526563825506882029837683625576733509692\
433040217165551890456893844099662036483434239*tailpot - 
    9350264012339545569023233139614275514762629422399049266430501376482187999\
23782714111051673016853521328232219945751428528232234876900690323449241399427\
29164831559089235634542923319830081888100000*Pi^2*tailpot - 
    1802781521430876782267091326294372592489401354517248225799576407054105897\
27785215343194413920583302622043275791269824863310273563204358031543441962592\
021702520148110700589740813148048895180800*tailpot*Log[2] - 
    1802781521430876782267091326294372592489401354517248225799576407054105897\
27785215343194413920583302622043275791269824863310273563204358031543441962592\
021702520148110700589740813148048895180800*tailpot*Log[v]))/15719091632255067\
48492886677686945604425198144719001353777450954589729070915597403853927474366\
18564200622594239221645464642888176767624562165163699400884971626939314231823\
30122993664000000 + 
 (v^116*((2994623518620768099686028458231010457965933176878664636350395304703\
78946216525691559042694878793802268303803684611442350890638337801912813953270\
762155935644906715064059182009882620452197629952*mem)/3 + 
    6956494591998663836128019562491083594117144822794807542639902009847815925\
18545667184990997918752005160572764671389496288147646787445018514532912598510\
0375224605162104845926660634050560000*cM*mem + 255675899165819117509132711255\
26226434605241780318997475466754010408714768153032341389201295166261736037144\
08768047403356330764540490942054781304712352728439457487654509248002369999032\
9684058*tailpot - 12701937752750277267251463390024430697136042408825231556334\
48864475240831793032474008989676238432931908848776804036197675823660045844703\
6154369929113984772977421070500683178369146018147146875*Pi^2*tailpot - 
    2802881353919620869641740411668388497363577766166781365161273037418640535\
60522137487239323878975651578835826529640602873129972868783984008791333908761\
98659431239589151047691944488267161600*tailpot*Log[2] - 
    2802881353919620869641740411668388497363577766166781365161273037418640535\
60522137487239323878975651578835826529640602873129972868783984008791333908761\
98659431239589151047691944488267161600*tailpot*Log[v]))/248091723993924676214\
15509433190429362771435364883228437144112288347996700056777207290522007042071\
37004775792917008293318227401779792054327101699801150330991586794732194180890\
624000000 + (v^114*(517831924447818978173882917051661785049577323690103869826\
28168748777423891390530560927788734747162641337081866529732398220311560583529\
3858691390179690381542502078875047232306436926984945664*mem + 
    4275301769518695078438166240336952164273051847819968198360507995685395408\
38852209688167577782910267951828016871610743691720303254415658462663687578173\
29847707170470411876743795179520000*cM*mem + 15303530342835011664266354717331\
22300250248243599368527392799628547794427267563808942101602036918444393217759\
14582479017723724570554644761011086495552303136127698515135057992499800241762\
687*tailpot - 679574009958321419661947083511105943150078983484018857847808858\
68009702187172445854265051712695313474778395013662052971011977709975095549275\
155136953132775260583999661611214483717881331250*Pi^2*tailpot - 
    1710922928106953695613065624109146895872777805447245796867989147885136917\
57180224300963471068516458911489952759822566418197696226194804897042694804619\
540512781586308275487023376564736000*tailpot*Log[2] - 
    1710922928106953695613065624109146895872777805447245796867989147885136917\
57180224300963471068516458911489952759822566418197696226194804897042694804619\
540512781586308275487023376564736000*tailpot*Log[v]))/15377586197970537781869\
11741726679505956907150715902589079180513740578307854758917807263760767070539\
46577011957665803304848805895441656259944320235608491590387611243731044270080\
00000 + (v^110*((452760284672112991733310208442240436924752307055190216620800\
47281080718752630635355020236791364915882687518633987472441895724329121280065\
637073637546450466531049102534580333587073635188736*mem)/3 + 
    1750283216712379481098100001571154914024158144724565272669633658330687327\
18994601380636871427042706632201376641352218094419637034294239012469661668029\
8354399024741210337787143782400000*cM*mem - 
    7*tailpot*(-8478544943869914718235710579899253333824285740860779645181530\
12232888135689598114187270422356220564508252827501920384654043706407836118146\
659471634156074198155763465596948392795476192207 + 30426355218400665906573114\
05962533113535934443193803776470529040260798389798532777520808010064298958725\
26609573563728911354295529958652814739189986105808221533635268261686439633079\
606250*Pi^2 + 986780092012951634017660708074119818553007751658118389941836337\
16351727046971611267526318311857193015787255666903450424718525391131756642770\
9425604972899325367892544841544871830220800*Log[2]) - 
    6907460644090661438123624956518838729871054261606828729592854360144620893\
28801278872684228183000351110510789668324152973029677737922296499396597923481\
0295277575247813890814102811545600*tailpot*Log[v]))/6407327582487724075778798\
92386116460815377979464959412116325214058574294939482882419693233652946058110\
73754982360751377020335789767356774976800098170204829328171351554601779200000\
0 + (v^112*(16163741927596415296519617141693598639160739866342479217963953527\
94689512170968063539093507645133807390891347221869786599889190393272107310510\
449448826003917583882839853770145946115506176*mem - 
    43*(-36777515560749770585255961570705156920565356829895334765838803117063\
51627235857539782685889785472277098433904706964351705109829900792203552542404\
587120428992499085145576476508160000*cM*mem + 
      tailpot*(-1281582460335018639645110700563500204514190880929661341979524\
14064869632999950211910194713479906646414938215771697482457578527633169257537\
58390657851899540215363993694277370072268920813 + 510584719528481797671219611\
79327301708178327494711283474661058549102723678418345473796906522926662686666\
02617414359749165644292653127541232612895674391415875066411768431739291133259\
375*Pi^2 + 146165626559585710344313755808521493445989589250080697450999665445\
39239369747204762643522923819096649327917161487068918554015872712952765258138\
174452065720594022275132918696377036800*Log[2])) - 
    6285121942062185544805491499766424218177552337753469990392985614151872928\
99129804793671485724221155921100437943943963497822682526656968906099941501438\
825985542957830715503944212582400*tailpot*Log[v]))/57379052977502006648765363\
49726416067003384890730979809996942215449919059159548200773372241668173654723\
0228342412613173451046975911065768635940386421078951637168374526509056000000 \
+ (v^108*(2511449043485491480155979020116552982488223873113532756391929024683\
59496663981815602610829002599492439062561584398788773844633277610390060878724\
442847343256036283418325372859783487422464*mem + 3453487089660629645561074289\
91255585973153291629382984967897968833989431882631397593839175159793748789848\
36878485055913974001668528266698290101601293905415536664533691185821122560000*
     cM*mem + 113898169255741276417199960833537836919737056279717748871005326\
23025977434264723268016649525571500652436763483660254423192791598480303413831\
9628685439548352203330577539974036005089469022*tailpot - 
    3697413610188736998100798927689919157041131565830165058357132088851466821\
48617163409752196679658040019710415659252860523165441233954490580555815510158\
93794235036948067576506915944196875*Pi^2*tailpot - 
    1353197983735186960434869163773048791982076478187274629318436091560500173\
15665327629220314104615059042532503831907987637561523483765106272346099453766\
245911663370961757309884206694400*tailpot*Log[2] - 
    1353197983735186960434869163773048791982076478187274629318436091560500173\
15665327629220314104615059042532503831907987637561523483765106272346099453766\
245911663370961757309884206694400*tailpot*Log[v]))/12757953150971132009294068\
65370585873304956153801910333859939585514860321782156181809123695326662505087\
7517584983335451176615533360756879973256656715306271326405800088305664000000 \
+ (v^106*((464139768826777920461543499187554264989606970077715674834345050774\
73956467379938133463879110456450730545686866429957749798723778487679389420269\
8885901722552015588644193074415279276032*mem)/5 + 151391866270843713053941618\
62827378867341873024551585878690311690757245697673461533578446413310897272477\
158931551765219910590158468529260674651640333356379866112964337833345024000*
     cM*mem + 485404066744377814909618361801863100250621809830735132815399015\
22264524123384800126071099774876010246423342715855276463953166407639483042559\
400831820604743983630569586169176753728999*tailpot - 
    1431817572693784273059744377901168595456887550942158341645239310549557227\
48701687154145780555296842788574374339391302965630015343383677289627897476597\
23019942643096176711576960677500*Pi^2*tailpot - 58890291580649008253345481086\
02944522050239314877216956914254079871115196325191014082387522200331933400030\
9224257693588548413047482082977859781774835665957761750531563322127278080*
     tailpot*Log[2] - 5889029158064900825334548108602944522050239314877216956\
91425407987111519632519101408238752220033193340003092242576935885484130474820\
82977859781774835665957761750531563322127278080*tailpot*Log[v]))/564511201370\
40407120770215281884330677210449283270368754864583429861076185051158487129367\
04985232323397131674771387367777263510336618088483741883502347907666551238977\
126400000 + (v^104*((26218823685477891909957340407863498376212619271519110709\
28824333999251064197147711621024065877915266089596027121960761458975575708522\
905810113948916100122063512506230207634472960*mem)/3 + 
    1690915603466704524261860794228140639934324395896090211745367567361001149\
56540182070539841677035054781193055560362954011937047010711691719004480155487\
451475905548239503360000*cM*mem + 5268070530252899976620553653712219773764751\
13293996148112746631982794931086906411524226737687956504880025370012007161046\
987084004315181925209593796801130834653449130344414871111*tailpot - 
    1418670839594689974977789120176360474040626066219270886632561141110019766\
30218999904197083859276124320672440631074626296788490654108158724577928899671\
053043988487017138414006250*Pi^2*tailpot - 6528943905837271396995288887684258\
88109177483698995518003872371877981910768972517520880631276018338828140196222\
692944031290088279284215328369156047998338385058685624522956800*tailpot*
     Log[2] - 652894390583727139699528888768425888109177483698995518003872371\
87798191076897251752088063127601833882814019622269294403129008827928421532836\
9156047998338385058685624522956800*tailpot*Log[v]))/6365538160564036056846704\
11286617532646956434233516106407410979290829704485344989390559649376339873909\
26854424005071668981257953512964111072116716533922262664871936000000 + 
 (v^102*(84421319442476507023211489099953835051159298397092893843739798204992\
81985974133031572806517603073383256735656713618291676355727813465012969289202\
46690632046973647376806313984*mem + 19382136321176993461744507211787025565039\
96711141317482578121917667110024418444568581555006494505196882705627486960019\
24040245545906650668774763919043477872326664519680000*cM*mem + 
    5864611218284700784594307239715065507331283778497615260783938198713195746\
28860393049337857231923717249785027895241827853902023663871817631537508392806\
867667705397589957229529*tailpot - 144888784429893568746007630541920044316786\
30370697323831858356946476701931589693574190776385313481061166653264536405459\
5118994153545500815649004281611986073386795402737962500*Pi^2*tailpot - 
    7427497383078613499670727050544963889610579485630043060962802214019872253\
66243841965240420913277399355104123271340823916822920600631965716249694464797\
545143002069658624000*tailpot*Log[2] - 74274973830786134996707270505449638896\
10579485630043060962802214019872253662438419652404209132773993551041232713408\
23916822920600631965716249694464797545143002069658624000*tailpot*Log[v]))/736\
81527195073726114576443045265683706884265301830296120209622056299417050091377\
49097620909354872929585119906748422082922464051894238322039557366657017495892\
7872000000 + (v^100*(15093959790864847495430834675598222094328224149238185204\
42541428654364776881098747756216979130568068182825120829199146733733530304358\
235945700267693644094426907760656384*mem - 
    11*(-37392950224533099391483854834540936065167143525863629058814314536961\
07388572891846711193652414917103132943622609565864171741363409029989129407283\
5951657272475648000*cM*mem + tailpot*(-10982628919821618427118522312426083706\
55023834289553488925102243188793994632950961599851712460632878955747551655569\
63276773175568001069505201677119380431612710148565758 + 
        250175943051742006901762020723204125164263142365455677630589294542236\
48813277513250478210480000826637185319533913768092381935905042526131175326676\
296562865798997076125*Pi^2 + 142196258135581896532214527823361334344160072459\
23943810410854937332770059015776888070887397348359908642568508977236318161630\
8893108753463058566918326146042323312640*Log[2])) - 
    1564158839491400861854359806056974677785760797051633819145194043106604706\
49173545768779761370831958995068253598749599499777939782419628809364423610158\
7606465556439040*tailpot*Log[v]))/1579386247000637188428715661606483831494561\
11853361691074786980314454722305777624734151181286008594049239473264777974854\
721427846485430893414159449906059673600000 + 
 (v^98*(158582201195389842452122520557609302962944605889524769988027711211041\
38040584935335930022806994696341972981541441082273962682940100668562501234923\
813345849235210240*mem - 17*(-30180121087817520431731306724596070475153607894\
13612863149091700011784376959701524570362712851545413658230775986048995314258\
16379994295874627850647499702272000*cM*mem + 
      tailpot*(-8599616145077532356300534869988001177904150166847018017074191\
41439087588091420991728664522649103761620498971980034587105867817969935503407\
798879703843436205013261 + 18154242090557707721964405809843665368198104300438\
51475773618312228553618074559026194153373481677474939872232109689105243460995\
26381579809927044323989342633356250*Pi^2 + 1138707723416234603850721120643712\
09722515040175271921243108612962120512651778721671102013485614264959047050527\
7057261233422566308956989165226940966485524582400*Log[2])) - 
    1935803129807598826546225905094310565282755682979622661132846420356048715\
08023826840873422925544250430379985897099734409681836272522688158088579964302\
53917900800*tailpot*Log[v]))/199037474795672552958079482302281985841998749676\
57917091964202219305407140128646414187962032837385452172049479374977927834919\
67941069963572247923785728000000 + 
 (v^96*(285802268816330601580392123973384176558491375432759361000765429692382\
10696638886390424886833650228241994923053897259873644445481237199220265674163\
67896978259968*mem - 37*(-296768502176255048446291468602015959479350110895976\
96133943898019260158382188946378347340443013352246610583629079494672892816451\
795551640681281832878080000*cM*mem + 
      tailpot*(-8199188663664704344991228697765683133413168328365494996680182\
22755226880417047420246061915945391367554743735573441363809513486304860387597\
99739659703574346757 + 161235890050429636098609998901808717114809796731654561\
83926980801939512018037400364148194823420005865809131382177073072253263225350\
944044144388961170286953125*Pi^2 + 111079684771155018288907463304515865076422\
36056697841224067120153235266715503787469941408119948456982936495742190505786\
3242446447415879478830300228568371200*Log[2])) - 4109948336532735676689576142\
26708700782762734097820125290483445669704868473640136387832100438092908368650\
3424610487140939970518554387540716721108457029734400*tailpot*Log[v]))/4304857\
42853276212780619855022718896611071024485536032461015620431002269203974376928\
990815859695446192320593373004905677483122932558629052922986496000000 + 
 (v^94*(114405383157549060638090476958706982812848857764925553787236437202325\
87948813303723591825008644697854645761086846534295544908039185590789282636421\
4421487616*mem + 522078482867006077668494393328063863323690286441637090554662\
04362023474006183654585015092192554040352605160823755224732008849285017556760\
320781844480000*cM*mem + 1397744412516807186989805459890200911860621833940971\
48198912990236730070922760032884832073552481873549735208230930166907403536266\
976961976717644288614109453*tailpot - 257356708824039301680942281122727764813\
65342073462842208368186473622153266351824760042047573209221450818881108660944\
879144142264579424391315243797345181250*Pi^2*tailpot - 
    1938242542938753018001223883240616174177292368825327989161486553438487768\
75497553328075327176530801182303954275737196155067331329015725242204398235136\
000*tailpot*Log[2] - 19382425429387530180012238832406161741772923688253279891\
61486553438487768754975533280753271765308011823039542757371961550673313290157\
25242204398235136000*tailpot*Log[v]))/206904615425010195511208235616033306070\
87908511272519103192137865567733788521310051378968367763887637812198085792795\
620373119433459513075695616000000 + 
 (v^92*(810071833400805368996414807734487696198502577160304679978940712365720\
71602043106534958631408599338464096581637293302262731372497641783731061678460\
1088*mem - 11*(-3992517116143158202918530732379396339970151540004005036324073\
47390669636211858529237663414298345927149246381610181538698148359760828510314\
16832000*cM*mem + tailpot*(-1035169393254134116555847091514540182894881715770\
47287276465478583973854735600809404417056361760388335353552740442408143725245\
166313995465710924450634 + 17936260272963108026399560688037892623317282953646\
07013505864329757899478777656093215235084117155497291782554043054031292487585\
7332390000402903753125*Pi^2 + 14699468606055954586375627433407658925252677618\
61292012546728543107826148959718152480230498321564911808360426687343591196518\
79751181145559691264000*Log[2])) - 161694154666615500450131901767484248177779\
45380474212138014013974186087638556899677282535481537214029891964693560779503\
16170677262992601156603904000*tailpot*Log[v]))/175993174292309036364200125562\
27527650546007716029157823136451520506050992243637551783682392368316523606034\
2330924395396321318034938527744000000 + 
 (v^90*(579034632871317909095073868281036453897462013180606835246271312250227\
34980985718691824530939236067472864427320481464045111004065693952899388591308\
8*mem - 91*(-4099112964103333220123419490317371689866133230707492033240545814\
01968111822328124279357302843369488186318967178340738462691426480248009523200\
0*cM*mem + tailpot*(-10286087194494212794706045772751543901311133142178172469\
12015930208650261855340076750553896564732680843351834171027782062419073536672\
6871687728403 + 1685500255621299547898004103016117284857923476212070467237760\
74552090377259775982835960108448892836395559644096262639184439111833189246035\
6335000*Pi^2 + 14964119674001029510155060040944745661017873849807080385536898\
25483567250599093653984310728933163145634052026421703343711897369745992762122\
2400*Log[2])) - 1361734890334093685424110463725971855152626520332444315083857\
74119004619804517522512572276332917846252698734404375004277782660646885341353\
1238400*tailpot*Log[v]))/1511968851308496875981100735071093440768557363920030\
74081928277667577757665323346664808267975672822367749434992203088828454740579\
844096000000 + (v^88*(3723160733768660570244231160012408465054186951181354863\
41208789384507964944980573264730317758756284185305351711276617320293654660613\
6131737092096*mem - 13*(-2192714576916518848476038851876287145691700983716826\
48627638903500425593120884710121521678194118043359162788746015881168374221451\
881873408000*cM*mem + tailpot*(-532169135142882966711450914468718629504826053\
29909554692507559429524235451212557558949812185244372969771167785009185725337\
3589115493131292597971 + 8286328967723374501932490340925381676023326488732163\
53935653152615999427357230919688739895125321928598820112860894818369236850647\
31403710112500*Pi^2 + 7935429268027572473906123057982337955818218649802992495\
72927870771236778872177744634283453883708547362664072173035748080143946675494\
552780800*Log[2])) - 10316058048435844216077959975377039342563684244743890244\
44806232002607812533831068024568490048821111571463293824946472504187130678142\
9186150400*tailpot*Log[v]))/1169048080908631605140026341549814516058162910247\
44644908707431186271462112363412369697114414180017294651624993971460434372222\
0978176000000 + (v^86*(221048269073454358343456083505127520124081382175762411\
67806651347169976561561244934293355924442796318409781877403875840973968778379\
9033545359360*mem + 201165964415325800198669568718097850422299518289289174989\
71365754775633556286366613358026399249427496135999485248820185638508922001791\
3856000*cM*mem + 471876966186867317769175773539701431649154473095785838834170\
60773207150704875270755179742442181499895018028405859139460125773035590311648\
4070251*tailpot - 70139805205194394829037320480590684995379605466937697970836\
20265395229737536226057435977133907209621921930624483743164981913907198273281\
0575000*Pi^2*tailpot - 721584028289887856516451443244846534548084309388658449\
27093081918403964923220196398640621386009814027165118367176290859808825929374\
6894028800*tailpot*Log[2] - 7215840282898878565164514432448465345480843093886\
58449270930819184039649232201963986406213860098140271651183671762908598088259\
293746894028800*tailpot*Log[v]))/83503434350616543224287595824986751147011636\
44624617493479102227590818722311672312121222458155715521046544642426532888169\
4444355584000000 + 
 (v^84*((38689241892263999342407984177168223562647841340118775517367764594900\
8363278289802232168465585046103518899930305581038779913706471477787754496*
      mem)/5 - 12341*(-678339213890614068105565878956318287446691232694848529\
19481932676268739145817001871596570450505124704105731428624537625082046971904\
00*cM*mem + tailpot*(-1536789492867271660816734284006702279437600556658392748\
02497892059189075482710221815354569743966171045480974615258509851427545888442\
32982 + 219009521085586077958125612897848010710353220439095621729487522964156\
8257238005664764886301183679625632370384765409062936833493435403125*Pi^2 + 
        241121910376778186219178254045356161191014674769843831286662135295752\
28551725737747477051830083359607238419561792314184302518622576640*Log[2])) - 
    2975685495959819596130878833173740385258312101334642721908697411684878955\
56847329541614296635058740912929335812078949348477382321218314240*tailpot*
     Log[v]))/351840313275069704596717398138989120001453524352160849444344194\
98275921582773900191522004739420149667330946527078088011949906329600000 + 
 (v^82*(631716790474396852157063258076058791796450927617459325679994018135709\
1466123406452363672636531295631023045863757955808548110508570645102592*mem + 
    8125547073142967115138360644664018599531058986616755088266179936822140908\
272800699936244760015660564741826730514677074042935914266624000*cM*mem + 
    1776584778271993751473179555775525926700518348402427272043921159806196697\
7773234783378227737051116403930887660039234178007422883613268019181*tailpot - 
    2437399661060805420284280779373652730109440121736679778460603790825218924\
377032936227541116802771072528757758175063813144767693836335918750*Pi^2*
     tailpot - 28615997864191155196315918774809319958572349772384039652762249\
744935466642720537862268642166987267735877472150224742119792440801390080000*
     tailpot*Log[2] - 2861599786419115519631591877480931995857234977238403965\
27622497449354666427205378622686421669872677358774721502247421197924408013900\
80000*tailpot*Log[v]))/345910420354703361260817666709680314608170599784427801\
42000131529203855488682205244473881064036663998780424956396996640961986560000\
00 + (v^80*(49094485279414863541021062447528205249953105959247767360137298181\
52393862643290628542730113547648299266369698515966809479337352280145920*mem + 
    7508359494832803451850115824574239384860564525217590656851181219970157095\
800434685168374688449782438386300459103525715256318885888000*cM*mem + 
    1583077557911317326017794920593252523421527686561860854688007312329781149\
7394908311268611186734809513760766057445368765395928835312607533*tailpot - 
    2098927037113423527269627458001999083174759840609759470155376465317653963\
110287751871367143609584853372619804951647386419988911150176875*Pi^2*
     tailpot - 26192243077698728976467066698670813594073034381785892379697709\
601523111643520138213622313270991306060024503519764619329129979216588800*
     tailpot*Log[2] - 2619224307769872897646706669867081359407303438178589237\
96977096015231116435201382136223132709913060600245035197646193291299792165888\
00*tailpot*Log[v]))/323886161380808390693649500664494676599410673955456742902\
6229543932945270475861914276580623973470411870826306778745003835392000000 + 
 (v^78*((24536353128151629772274450916621449671163753025982441442092614645981\
872195520144855675137460081567407019667763154789041684809814900736*mem)/5 + 
    8923740266062575934111628259368292671602106491803522979686126950495154478\
814071206801052884180036460150600878824936952026470809600*cM*mem + 
    1812884079240602290233197029395419623998317376088177658464410841218172149\
2587583153662308429548744637177471961214694588546584486399093*tailpot - 
    2331098077575428565855899867135675425558066735945422740368087747614414151\
179923476269959183208289876956793862936550909845863058313750*Pi^2*tailpot - 
    3082804763390866057851250546331054382297974566391297984741522641448954168\
8598153920087406236487432480695002569109793344863573053440*tailpot*Log[2] - 
    3082804763390866057851250546331054382297974566391297984741522641448954168\
8598153920087406236487432480695002569109793344863573053440*tailpot*Log[v]))/3\
90224290820251073124878916463246598312542980669224991448943318546137984394682\
1583465759787919843869723887116600897594982400000 + 
 (v^76*(612871236480676226233878271592234043849577656212691933346325477799499\
07889950212250672010879665127666698933197107625488078379941888*mem + 
    1325146865843646756032406709156870847518102507982176818601701496753440624\
13191154299545162378467914922898420624309477707874304000*cM*mem + 
    2591662148959722596717793833430455828065647827199250367084214979845926445\
90059239320657934626710640350915334256832580788710048115426*tailpot - 
    3242523177121100536010623377945834228303125224163466378523617703588476729\
3112289518991834440415366438533910788024593901580312578125*Pi^2*tailpot - 
    4532414532214932900973973689538072667331939768367734503185319235733531139\
23119825981524924704169929065523459390591099653126963200*tailpot*Log[2] - 
    4532414532214932900973973689538072667331939768367734503185319235733531139\
23119825981524924704169929065523459390591099653126963200*tailpot*Log[v]))/587\
68718497025764024831162117958825047069726004401354133877005805141262710042493\
726893972709636202857287456575314722816000000 + 
 (v^74*((71739682339218810330940078144999653891281662039320205992672354086691\
917150983668042789658704109414920013729604624764092022784*mem)/5 + 
    3688446045057569742983694749401970194819794166025882596535985806315215167\
0324622729200946263069046606413592677504044236800*cM*mem + 
    6938350221921281827655698912025144507297093679429042544585482076050007667\
3237037158049307825107266911269986334633672106165783*tailpot - 
    8471750065677528999206160930119114983812480319768274141458891663841343313\
847552652224120091587767471296153190258233219508500*Pi^2*tailpot - 
    1248720140327438351516996840020194270748828536586521809632471697659496475\
32903177081979792611432643369549283979365618851840*tailpot*Log[2] - 
    1248720140327438351516996840020194270748828536586521809632471697659496475\
32903177081979792611432643369549283979365618851840*tailpot*Log[v]))/165976757\
93758935608772971525471456867433087061156398910374834303498455908032267954206\
127663858303214909555684147200000 + 
 (v^72*(806210773641991232839276558610241591055503012230484736206927693002330\
04517697148645330061402094433761820538405229088997376*mem + 
    2463814476580960027054088448546041568171567406070868011347195972827934546\
57725120911744515618048516394244443247476736000*cM*mem + 
    4453555445939303590661605665990608395100716190588103973689492846151618876\
46349523497538059614193468353806403864823879840457*tailpot - 
    5321286153457878523814900847876922594981923924496080854786089790877201605\
2885935514862206835704621211599545961984003901250*Pi^2*tailpot - 
    8254093423292267794970646000892164717221690266451708779252935173943770818\
00824895403554138373574434624013723008105472000*tailpot*Log[2] - 
    8254093423292267794970646000892164717221690266451708779252935173943770818\
00824895403554138373574434624013723008105472000*tailpot*Log[v]))/112552051042\
66909318788181414198546700338892672574411557668287276332587641070706117228386\
7521643104983563894784000000 + 
 (v^70*((42266161749530888643424593897356992668665698058591874028703388617304\
6958000812778229763273243515960031335191018270097408*mem)/5 + 
    3070471316106650684474189054745510628160438683189146533342009090049128367\
98315474063514447370455315022229428135526400*cM*mem + 
    5327907421438155377630668934803916971501534322130725702849792917235330062\
55193604010854639704392843606912434835368511873*tailpot - 
    6244928308087316668835084123784240306650386734620372284970577445277576993\
3689592756171494040240320155160164869809783500*Pi^2*tailpot - 
    1017614514193393290892651699106376965230483167154251462108612601218038367\
587625793700215404130568216442358164966973440*tailpot*Log[2] - 
    1017614514193393290892651699106376965230483167154251462108612601218038367\
587625793700215404130568216442358164966973440*tailpot*Log[v]))/14247095068692\
29027694706508126398316498594009186634374388390794472479448236798242687137563\
56510259472865689600000 + 
 (v^68*(208712586158830381431282668000915499630572792234389952887706302420226\
46626265309982877312827795566551698403756081152*mem - 
    23*(-39166108565432153671109243207113892924448772163694471659461268792075\
31495255363667327662482542684069787860992000*cM*mem + 
      tailpot*(-6517167181527651139438696351597066185865114299863805769139654\
776201325826370962229613502019415309909110487477754562 + 
        751021934698069661740195895191862911978991493530182779710638316836985\
234223905426584183226580584523903793227346875*Pi^2 + 128373591995869814008999\
10072687949175820277206699160811249361290542515305972163053843725213066448829\
967102566400*Log[2])) - 29525926159050057222069793167182283104386637575408069\
8658735309682477852037359750238405679900528323089243359027200*tailpot*
     Log[v]))/424800933180186532826575408781639244509053962392934327536918811\
81878944905854237795653423571166931451904000000 + 
 (v^66*(167515771084873427326998834309956335174143591950476716533930253126350\
232076077034859260615840204300435719595229184*mem + 
    8588153444189045905538268923352847593929564590691475057212912916530332129\
66353398795817639566240739206627328000*cM*mem + 13688776201506762629233864019\
80003623859831093106555693249642123374357916612152945048520391599123240393494\
946221817*tailpot - 155397471128568003423767376551322968546863269834718690910\
362917037481106754174654990117622938987260304055958056250*Pi^2*tailpot - 
    2783008722363062794897112106281774315681045558659720283282543671623943850\
956085788141256421634280051476309708800*tailpot*Log[2] - 
    2783008722363062794897112106281774315681045558659720283282543671623943850\
956085788141256421634280051476309708800*tailpot*Log[v]))/41185118449362093911\
89545493204200663048420144751099741217474492358512408873577945652295069363569\
95072000000 + (v^64*(66876828028070919289431882656035865747116783287420767011\
55574399331704872817359436344499424089471438418870272*mem + 
    4070790468442351465957806133201882195038664357210654061533242158117225525\
8146811557098116680039429832704000*cM*mem + 620801888259146144311580800872289\
34614785680824506746560470036538387588719942451979884934996299395291870322097*
     tailpot - 69548623062053008861908522820142678097469435890544339548820439\
24443547082996970294441581463900483272355528125*Pi^2*tailpot - 
    1303758341172123560182370582150431591655602073214567898577225157157856190\
25181584394373920938771789342003200*tailpot*Log[2] - 
    1303758341172123560182370582150431591655602073214567898577225157157856190\
25181584394373920938771789342003200*tailpot*Log[v]))/198654825628796517035961\
09845669499628827031375415298771066344261810304885556521057554963676266496000\
000 + (v^62*((193904771323560465275547130518309536216650584250876982423890201\
049262137209856408307060374029401076006912*mem)/5 - 
    19*(-14742909599908006716378542549147629372515800607665838957054110628874\
395129496954165697355250768281600*cM*mem + 
      tailpot*(-2148479476449740031090593938873999698741050744714276938694859\
0577460833169847211031640938835908011505311 + 2379080226190887894074987782507\
334947024261226950869232900670673301982529097089019030954407878165688750*
         Pi^2 + 4664981987380210219577503399881433452090755495833181733249489\
2942705726004333427662742239445756661760*Log[2])) - 
    8863465776022399417197256459774723558972435442083045293174029659114087940\
82335125592102549469376573440*tailpot*Log[v]))/139201755748578597880990188814\
165087441854329587382094955268336218977681210542506184254527897600000 + 
 (v^60*(179613637685509903208847878960893394106126178471309504724754547255788\
0685337101276889409443701312192512*mem - 
    31*(-49626407935420098553608004262122308612398736064140994225967640938275\
8829523676007494534826033152000*cM*mem + 
      tailpot*(-6901881759802024046403124922939671151967948547880395804674596\
81820470559815464877610124098715796657422 + 756479240971270778598409036600369\
20445644128946523174577033111260421911697946528020447107832335359375*Pi^2 + 
        155082457526611496196681638226231637183411714402342427837836110407207\
8047559216449001423868898508800*Log[2])) - 4807556183324956382097130785013180\
7526857631464726152629729194226234419474335709919044139935853772800*tailpot*
     Log[v]))/779114304562939913513004788138983698368587665601019188182472031\
0763676187157229823745589248000000 + 
 (v^58*(792269997465465512161451606663963386087436587158597656483143720323783\
804295308938765667977052291072*mem + 8040176679156091894449419624315503593515\
470385526471507811096565950957311708821335720908029952000*cM*mem + 
    1065677219958139697919376165269652937890419610954796613076831054114689673\
3408760649967601334531184841*tailpot - 11575676967023095152993070991337360025\
23699652370894689709246629977713007722119871594454713530350000*Pi^2*tailpot - 
    2480400721111151139599037752935399154675985206583183585909567732384272805\
2119842934092707131392000*tailpot*Log[2] - 2480400721111151139599037752935399\
1546759852065831835859095677323842728052119842934092707131392000*tailpot*
     Log[v]))/415306132496236627672177392398178943693277007250010228242255880\
1046735707439887965749248000000 + 
 (v^56*(895717162672191971625879275128606881039372439308034206799897291748592\
215924031888990625245167616*mem + 1075949166778331279088640818756235500577533\
0103947410565949434169763889644561622801208836096000*cM*mem + 
    1357121094545246588586631647831068776218818966773587516923445275907630961\
5295722975983890880899627*tailpot - 14625388776536963161495248858813790998405\
95959252104028120127291175905374779684614121059623875000*Pi^2*tailpot - 
    3275406718505648710554634936512724521005577126736870668920554643521759422\
4872095599105147699200*tailpot*Log[2] - 3275406718505648710554634936512724521\
0055771267368706689205546435217594224872095599105147699200*tailpot*Log[v]))/5\
67358104503055502284395344806255387559121594603839109620568142219499413584684\
1483264000000 + (v^54*(721027767626972031558499812437458560155772985488919296\
292850268718397689593985824636807413760*mem - 
    17*(-60234701514432833898870432922283201584085401341100630117993477017283\
8300785248611336192000*cM*mem + tailpot*(-72187277302173498423199573690714749\
8973901820060222143368174759130930096540216212578071816369 + 
        772570804390291957296429846906360024321084228980277810726008228733210\
15235969807575319950000*Pi^2 + 1808565485139588245615729746695273170810571216\
741422164010266416875111972979930069130444800*Log[2])) - 
    3074561324737300017546740569381964390377971068460417678817452908687690354\
0658811175217561600*tailpot*Log[v]))/5517514214394815943304761619399538361925\
328094230166389752677126335782015966642176000000 + 
 (v^52*(518381675922735570950367024885441041282071184917143181528927126456063\
5722010016754958336*mem + 869210650685275989303019864388659500930246890436133\
79922689829940944001903538208768000*cM*mem + 98810047105102452596987611209909\
025283522006992635131819363348128876167054274093638997934*tailpot - 
    1051085768667119073163808224404577818504761333231325292620413178989960918\
7068704021640625*Pi^2*tailpot - 257280880693663270497526214776090535322551657\
959313346419888193954730719397864292966400*tailpot*Log[2] - 
    2572808806936632704975262147760905353225516579593133464198881939547307193\
97864292966400*tailpot*Log[v]))/479083965545534865874614616855336409586458746\
72045762622887235398164264517632000000 + 
 (v^50*(545852626380184098823695133741917786383997041201492054930019287738797\
55203509661728768*mem + 10789391997766898408652640793592323013340042010334725\
08058451676306607132161081344000*cM*mem + 11613428104445318051813537372932753\
49805448291485281868191156045260373960313094861136863*tailpot - 
    1228805080121796585179209249099932614616595270738909373351226771077829763\
44157484321250*Pi^2*tailpot - 31465717683113690329166728062744871031110027802\
37032683947020099830336222855033344000*tailpot*Log[2] - 
    3146571768311369032916672806274487103111002780237032683947020099830336222\
855033344000*tailpot*Log[v]))/60900504094771381255247620786695306303363400006\
8378338426532653366494887936000000 + 
 (v^48*(213402221605871693248571980344365669359176209464743525760223803749794\
034289439932416*mem + 4963380398875990022139390415144061305939626215622016001\
571656090324201077997568000*cM*mem + 5048918507233759658308581498089776996390\
132944208913377835137125673534416265813094537*tailpot - 
    5317323999006366714266886572152621202279910204854379390440912226897879136\
77685666875*Pi^2*tailpot - 14253429771995090540072603774589219393582666968300\
243436910303040512514006558208000*tailpot*Log[2] - 
    1425342977199509054007260377458921939358266696830024343691030304051251400\
6558208000*tailpot*Log[v]))/2872665287489216096945642489938457844498273585228\
199709559116289464598528000000 + 
 (v^46*((16697576702444733459378345507394542906590333187395114040009004513510\
61880348082176*mem)/5 - 19*(-480024835812510663320423958683893590720640594541\
909345118834850511573326233600*cM*mem + 
      tailpot*(-4605218963481140562128164828615181816379260046321901416559216\
13490056458210753309 + 483024493436217660129001182211641702361956179713970408\
09728643752986982143624750*Pi^2 + 1356520814389155246035343485093618854655927\
905670005512005673772288400358789120*Log[2])) - 25773895473393949674671526216\
778758238462630207730104728107801673479606816993280*tailpot*Log[v]))/
  542012318394191716404838205648765631037410110420415039539455903672565760000\
0 + 
 (v^44*
   (7593374396651017871433343265453626772025922277549196656696905708334066171\
904*mem - 
    41*
     (-5925382746064222711782865697404370256517040836712637871028627765723136\
000*cM*mem + tailpot*
       (-53494419748771939143969589171070242208510379068867462359409189302385\
39949146 + 
        559078492172304051211015463307120546475430638569614663628807129356738\
000625*Pi^2 + 
        164661915993697741762834669024590313058435832025010555987320431732879\
36000*Log[2])) - 
    6751138555741607412276221430008202835395869113025432795480137701048053760\
00*tailpot*Log[v]))/
  148470492405219828962822465553646930685416833875817675678636048384000000 + 
 (v^42*
   (1959092748244970385332944832102806630594091736330651424362881719587569664*
     mem + 
    73231609645791131886038458835354354423769811046992815891519595610112000*
     cM*mem + 620667204937636498760153907140524590306300679322584184510656951\
29192966191*tailpot - 
    6466406531763796840278811542600852467294998663994985895196041422672967500*
     Pi^2*tailpot - 
    199963775192359006198872579789100994171740427325283658148362100695654400*
     tailpot*Log[2] - 
    199963775192359006198872579789100994171740427325283658148362100695654400*
     tailpot*Log[v]))/
  46102330039286570000775437657399783079467303938052424311242752000000 + 
 (v^40*
   (12022984080432635118742734187159820674927447914144708165415769871482880*
     mem + 
    523530443193224024578837223171735725967875036160948801917654401024000*cM*
     mem + 
    415475968936005862907528261371889198440440447500786973316301149929266501*
     tailpot - 
    43167920464890729622843330023169844001023071339216066739210241537753750*
     Pi^2*tailpot - 
    1403447527143074863436645273410516541352792213709424780092902483763200*
     tailpot*Log[2] - 
    1403447527143074863436645273410516541352792213709424780092902483763200*
     tailpot*Log[v]))/
  340151028086705990053765240094061542967929661862775265165312000000 + 
 (v^38*((8532109942959400430943159959512704513714981258391529342614739353600*
      mem)/3 - 
    11*(-13071476599735124561394657058466676160626349656003978964500480000*cM*
       mem + tailpot*
       (
        -9686113567302671301710601530315659027999697517959514566947666033109 \
+ 1003982853459163237500234898607615610636795117250938975669344602500*Pi^2 + 
        34368658410534858235016429658231278828607939017411504516479180800*
         Log[2])) - 
    378055242515883440585180726240544067114687329191526549681270988800*
     tailpot*Log[v]))/
  96621418354388968531041860858356770868893465993604497408000000 + 
 (v^36*(1513235355805711278064994669278915643391565391958056212554055680*
     mem + 88501942390629326140543140299727415933518447999480244469760000*cM*
     mem + 61046787277323569193530039767416641939221298810910443643413112878*
     tailpot - 
    6314433839970009132564202789343278977658296710007779705930923125*Pi^2*
     tailpot - 
    227984133822198955522883768148482652392839381676642115648921600*tailpot*
     Log[2] - 227984133822198955522883768148482652392839381676642115648921600*
     tailpot*Log[v]))/
  61655754763861366759740268556807355205618348974931968000000 + 
 (v^34*(179147170276290798489407238174432701263725946587162712473600*mem + 
    12072478880574291084935048900603324601777739285376532480000*cM*mem + 
    7725517245962646368881531923137114669854864800558948965199797*tailpot - 
    797647642123468013447888456398037080888193543896982506736250*Pi^2*
     tailpot - 30431900792700384194117046483171694658854288993585848422400*
     tailpot*Log[2] - 
    30431900792700384194117046483171694658854288993585848422400*tailpot*
     Log[v]))/8743016841160148434449839557119590925357111312384000000 + 
 (v^32*(24679963781731276814230896078570312852470658649974374400*mem + 
    1907908900841989389499937959626976302858001427988480000*cM*mem + 
    1128478888441772718225981189528177212999210318144818204247*tailpot - 
    116331068593586804332515579919054233160980174653550969375*Pi^2*tailpot - 
    4699587808626560261442522510089782484162436883586150400*tailpot*Log[2] - 
    4699587808626560261442522510089782484162436883586150400*tailpot*Log[v]))/
  1440839954047486558083361825497625399696293888000000 + 
 (v^30*(837199440995953641046196251329690308638247499784519680*mem + 
    73909004372739943014820112156443489183884147425280000*cM*mem + 
    40239481401336266403603120252220656982919204590557951359*tailpot - 
    4142510317605451211120370330364057506691464045213843750*Pi^2*tailpot - 
    177606717755077550999315472019427997125131309823692800*tailpot*Log[2] - 
    177606717755077550999315472019427997125131309823692800*tailpot*Log[v]))/
  58412430569492698300676830763417245933633536000000 + 
 (v^28*(4738919091772332616286805025864595199350412410880000*mem - 
    11*(-43199651101895724097191817851445689533878763520000*cM*mem + 
      tailpot*(-21550076075707092354413583480224856447600136512695642 + 
        2215970593742948350348650955572868960253025474508125*Pi^2 + 
        101080306528630495740141182142004210712977782374400*Log[2])) - 
    1111883371814935453141553003562046317842755606118400*tailpot*Log[v]))/
  394678584929004718247816424077143553605632000000 + 
 (v^26*(10668331581233885811959795000580438280049094819840*mem + 
    1209575357474728764094300500173126578407997440000*cM*mem + 
    550035749230194598994924165096714800982510103934967*tailpot - 
    56502756819085104129829162074602425342758242865000*Pi^2*tailpot - 
    2749430425812197070265791870543165153442606694400*tailpot*Log[2] - 
    2749430425812197070265791870543165153442606694400*tailpot*Log[v]))/
  1060963937981195479160796838917052563456000000 + 
 (v^24*(2488094569712997592101834165708708660432076800*mem + 
    316644561848033126435177334376047354839040000*cM*mem + 
    130476448357365855097776192859879504154284619417*tailpot - 
    13393441366732537622160010535716124055166192500*Pi^2*tailpot - 
    697240458170325341111316002225621324897894400*tailpot*Log[2] - 
    697240458170325341111316002225621324897894400*tailpot*Log[v]))/
  295040027247273492536372869554241536000000 + 
 (v^22*(46206226471942554165754258996357591203840*mem + 
    6584524671585351400331864907453353164800*cM*mem + 
    2442610263991830805391536572395601058340297*tailpot - 
    250543987163291833824045007715133190397400*Pi^2*tailpot - 
    13996064141376641501441687170862320926720*tailpot*Log[2] - 
    13996064141376641501441687170862320926720*tailpot*Log[v]))/
  6563738092264148888462132804321280000 + 
 (v^20*((15461291490242865612480008698451722240*mem)/3 + 
    811688233846707183496098303967232000*cM*mem + 
    268857168724309095738778649404467162482*tailpot - 
    27572195408036888261423624021930136375*Pi^2*tailpot - 
    1657955901694153747054926204788940800*tailpot*Log[2] - 
    1657955901694153747054926204788940800*tailpot*Log[v]))/
  873209090605596648635341209600000 + 
 (v^18*(16611036836839697743419367623753728*mem + 
    2911066987022404631421477558681600*cM*mem + 
    853676610063527802392317460499595759*tailpot - 
    87482481967802803002338982822507450*Pi^2*tailpot - 
    5679601427231374831832191359651840*tailpot*Log[2] - 
    5679601427231374831832191359651840*tailpot*Log[v]))/
  3416905137152334712051335168000 + 
 (v^16*(30219344712043456105262293712896*mem + 
    5719182406473221533684098662400*cM*mem + 
    1466165499808462094972613935348183*tailpot - 
    150384599943222686037511871501145*Pi^2*tailpot - 
    10569415887491356429228855480320*tailpot*Log[2] - 
    10569415887491356429228855480320*tailpot*Log[v]))/
  7428054645983336330546380800 + 
 (v^14*(137381439457748898698370220032*mem + 29022448146343287802822656000*cM*
     mem + 6428032273093320836432728742497*tailpot - 
    658516680644404929989666374350*Pi^2*tailpot - 
    50190591337878512323721318400*tailpot*Log[2] - 
    50190591337878512323721318400*tailpot*Log[v]))/
  42494591796243342852096000 + 
 (v^2*(2822291456*mem + 696729600*cM*mem + 63615167879*tailpot - 
    6542498550*Pi^2*tailpot - 653291520*tailpot*Log[2] - 
    653291520*tailpot*Log[v]))/10584000 + 
 v^534*(((1723029369540315337158005985706459093052331225637104608851098037670\
81965510751264491486681896973319996081554009058414935894373464323130963622770\
54101693780586117704148689045507023050980525535954624885104835991510612967795\
78082685939347867088890883038120935384569956304802069414009616024899669572866\
85101187395272049602872731862386995315229427647647898785101470202338236325543\
09906967055629196337212576471055369596301660338800621679119039172128999752728\
05974046057641641557254621410387698618346080126994611357993193986588139994860\
35502439744796859392912496381095594673870948994961505475039932409101581580907\
74891622374278125950769685009432168304908822610658027071953388166242606709325\
02136304671793732865704976987672599423736029564737128273616252659460607956703\
63344314168425657040301774364990883231575442446196758664666562616858295203250\
33218163582764217249882481771141431669529665511647220913790218213480413809311\
75250313147138419697435495090416026927589994967055344907729373923948887073065\
86545465461843735456632776516099516644508244192557777044551111160196100518124\
63669781068955950377365382565229289024022344715129533073624983377311724788030\
25733012866641675947689507338204016830058570320174268176693866262639633446712\
26716193573592970115534674461186945762033598203759421842799487083556554127037\
00785179506819744147760251530382683662829176984094968300221321297731192094351\
82162617237089325868840355536764121781571435827968*mem)/5 + 
     294010783512202810005535080195055163884808790902878150068796177765991462\
68089731720516455117902912788367615885145089962839082729422278160191818427730\
33556775485240606634572288595993407183939789340187105534185419628661860286655\
71596582757425892597213934465116835781373083591461181640625*
      (-115052587295229976187898821894132967614326779653599539810141082773399\
82045184049592740045607562688145236407922783413910760471573467794620509518537\
43243448774814676580214467651518585532736304617536023643159951027594153803951\
04193611834064498443312621312865249011194168264290625836319308220628132647535\
12468994826912107587757324503072686657168735368088938061189738488182263774850\
72292229668507932164460190600353876082263358115761469426519953859254679659241\
28473725321686301208395726604809666282866005194458916340598107869799071963142\
69466565408361098952003670670402660293020647778152476869222962280145087571330\
84157809554036579522496511180970766868032842230339196906776235429357389585015\
84681433470463678799013601114740597209431327490569950001182845538194111957071\
94450160149640774374812906913412604160220508258927974650594188626288791769553\
81059226776100531519489157149901241670653762230437707031458858184849349082363\
11303995526654261297598778956341478313604727759230484404730391346680348381011\
30132290846598236894548151166851811055832823374922899106466224968859012942230\
5787873803800097646533640169199200000*cM*mem - 
       tailpot*(5569288178514472584476973605172052678522219632874111108534083\
01580250546532924959375026197292764381267710171227273288926704207299991779373\
74221427220599385520331379817691181575742918871329137615660618517893486597276\
15895505887262107553787384940171772301612942216543854116854672359665082488266\
68258874886444372215021535134330785943564698369230088429847176466703001977779\
96256316504665829753692108159791443874027411756118509082073300823009785043564\
13984966815899859474306794033717985579674103551914319882016312155184312438095\
57135450465332097792368603305434675454708934747817954607190099059061070649948\
84552679117941352879814087523383749914557853629277858138455409378075026255927\
01881033005791546106117774804235885311684298457296337965917651395092181470889\
57115189696621444043130473692707801306564127396947884949508156720156098825004\
42617279028285794784465554071204070897808139325434087597312511347286125865547\
48272666674255159735372190839214026697137727252285297529395929317289851690075\
73550167101723192925733496411307080784749634488484276137118734393926969106433\
203574323483503035123154668331044353350318030369 + 72013237043244563026950376\
94417440064042616270769145748930696915288248801575930154155213769024792645540\
19470877130266534125642763957325697708549335701784536618156796785237352030412\
65339345500778701740113557587387373392097421659358932947843155409166987465640\
00780423054327976313320883146353352374534288946573796502250660775466766782283\
33350289538093057479902673774362564624279453120368534248965487029063674549212\
14445359709495339588275458210531215596039081338821832524950079542307115557610\
20093209289294688106589499583022533318862748665942442047612117766617317386481\
03879658287221415661473455470864470158871996689412044568565870358248869981471\
80112936692984348786078977691935025709669566411279411159780258509677128115347\
08304045917312864798345005834547959406330455159853415249322000960795680602627\
61048657131339576136480083003423578478200063483048350324489499903608111982752\
10973754985791991411570373370512573077639353014846559686166839699694289727886\
74543080979705612069286815475131897755216953113610683127571718138574998710183\
25523129593454464357418727351916158925202337618065485894429438483769832008503\
525376000000*Pi^2 + 102735149097567434450518232444774931267952192251172072634\
42305687277073017027282902692053571727660932967060566834936982331631829354860\
27803466293575547985025417387066337865378370888024582436952341515861812632540\
71271572279655605385274576860149639351211120226918162154811303447505700518781\
14619082038911648106843178334531808720380132052157812784873450685384412964370\
55740282548325604885508222221886730885748948682204869007950168105747302178947\
97124726709099104152380318913491855274749207237735095418240608301117472070104\
55307224200918852357076849576054529763641722062378351182240411286644546592845\
56942499686997467285347198136648173325069581208219575622886676737002594686890\
31390795321430740495672389244751553832791685986769553325845303951742160202442\
11792466755419586891823962922716531358943095832683278843561982572076151349046\
87115808923455871774923158178441889162014275186013265366272644308600256743418\
37845812047939088397912255112458332404165604222917497560765669705963762203311\
67654307315250188616388502262104827588869544134238802124893577076557808881346\
3610030531940700734318106085739036934144000*Log[2])))/74812006054595857115357\
37283747469047407777650043743611214665277543948577112155220359084472547562735\
33553327249408240299251772725508819007369906530691913457727322173706143607947\
97122804404501332806449063178083937989682814054922453200348857182647786181061\
28181133253903785371230963428286975881997088444765919692384945513626673478446\
01214714204107807480985906152006645066854372420544143183571703515683421806310\
60411829465370504394484660628587863200915078429904452295872283044631825782767\
42757347192509833312318950841248991928733531493792428938037152410955594213280\
95992456400888201655088650133687708936878678837224309514751876367384466223636\
14279731807175898284895278504171881569596816363933893773342987593893858479727\
74704683789381767674803498999157676614703968741518449676071038945311745060885\
79397691592823112482315484297128207653217002626764391125074845112819334682439\
04833158474235062267738070683957374763816100691785074636699157863219551861722\
64558094177841797746640221621054717136317590761391476113340536375511093620840\
69284489517135899220180656843662382797596633806349359331878632701877951899663\
90978047661709378000316454476460083121669860716514052857859385245883321956242\
39105566857171611302237841708251626737168219799609342153520952814406149526129\
01967725131052705021798348162387148800000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000 - 
   (6565738336400933425009769600304871557081539210001332567308912938000991446\
04588308470624537301608641048329214876808610605052265015499522977240417478780\
83409819834611078110472025370891630177066148998771585556953129150095609490120\
20341823553572786345592103677625385871835327952454173138164915705601447008313\
58448553128291785636534731406996130896123904978161761637190140452073275054727\
25844161200661320690855899042942070816626063033443565876114748967540325426707\
02242015341249440251710112307118429920827971303791379357100931099110467333391\
88258511098251434256035385127194073835111937031675970091498623909186412034277\
471483*tailpot*Log[v])/162619475577362317817207795456763849122578989329730265\
50227911590425371641576920687107916138004789774844698426827941913054156670411\
09740730521507460953365948905002406878545958426130449665356941241292083630983\
42553444042229450813050855360403867765894884643390363163802722684115518559759\
06633717377607137326343096206882483765446425678659603488068729455154466093107\
90385356306666991823516656911327722297648412338638672262988377768217129805512\
56075690782463986347598545022338642936547745249537481791170825678869729865777\
06065323298524477584814663537088502004186989863569974826817948574495146455107\
227022335252889600000) + 
 v^532*((88208497259041026351311158036891920348114515810790148302141787309375\
83093315154468763169610425086797273710134384930983856517645219843294032919907\
70624025501314068206731528771423623642668598176072919841401678534843275750977\
15735967386469157183515828542951340539394427586574850002576006011355385158012\
20556395658165482591359089515270802070550194415469906962344396979103629462298\
61367065204824175565628487990096255588491108886410723060401866983748996174257\
76079760991669016916872582645669328521539023508537591150368308963860240775299\
008814414894863639169547871942409368320025284699470035445241*mem)/36297867676\
84320294169458946227198065081481332476841554010658679708590389200298124899856\
37625286885043537209236561733997013260083727199919439317720053205008747500627\
83557892587766888766579204956938829014253995759926834195064451409370660290624\
12326626974182228015821367682884440851726357517006887617609689711882500853563\
12704207086897232117164877714864399401467300619256064419177317406239900845616\
73729542887393035707669523580328966838411955707918717092497352802181145561559\
86997376942121530689501234247519956903047886607710281257379333594340555724170\
0842958880282500000 + (436265950000874318259056058236332996067577594378222161\
63100545429498485869365512169932027369625444216533438706098699148183694836600\
93621981295590107950418655963424170345092972910110104114901855535833609381383\
92477723873254864830836629077882216022984332575871017919719358016524666180793\
3169524554888362676323375374012875058603904007648445685201*cM*mem)/8267125687\
87305156807398512553128116658616602320272255913844951574558069298865025125271\
27941022059169261158682722414080036221104878208142291141157609102337333043936\
97099893152890320699163918527499904044219737736164711373325938955265132440658\
17608091561059627754978395647823784689995426789846086663902067442485011741971\
334195474501354672000 - (6420473315680797943631517124423847051342204513633124\
20711479915914850903785717477899595777569117967283681178024958609847605371169\
81531752149537478041198591933622162862555170827490597878666612184705213870913\
24412953964026374327633346570181816410878083133057749782387149282065357941477\
44739059334315703424018219297590194606618322398908639161186556037855809071476\
43571792147192705960286175672114149834638870804753286973967837053246045951573\
77230580459339593137211142081960701981921899861800656743157926850108446905043\
55108620246692683094802173451443433957939378039964814090089438915109383270628\
49774901392999963899430189052692893222187227591560295159852031326923614526290\
44054717990172409610944951007534977038793670608323661561040119060244001080316\
40398387195025678596900829622923010821409225828614867150468583327557422148997\
34430968733207367583165467868247524320389803537806530483680176151522081571636\
86688153107647650355195426515707212977730147796872001332035153797053137975349\
71075848674103248576042045412710662495465419394059926045524466447883415425307\
1655451528862137509177977877340283918914192249*tailpot)/238605299524596067967\
27717743916922000019785538405182639444256882100471015358947316727773435975177\
61075797035512464344808254524236937014496900093701664097690610518659557048896\
58957648640272485193400416506692657831486667437275642224375496252141992683962\
33183136181085276738867821728847489584150499892761141683626529053088028600762\
60889657035501834845966693061491730661039068600633961446833684347310913560879\
16415649591480098025843556495940698522521106067726256290765534501456245280378\
00272557603191409707472152880466039064030197865368969407393509368448425898345\
00665936251228411237292405918264575071255358422359682270209359486693602660273\
86140113444845272540198964521990403503682832870901687519036385970030011016469\
53090552566245053977073949945040369331962244430525638126884680305402273845871\
42035939060678119479656367727454175534392405022779690837902760650554367973017\
29925001634471681099647727625686392292186303812409080565472751458754553519683\
89585305177151985932028390005376266395026798234688183130122751183041011957384\
7322838656208507248985829275309392251202430524411030693478400000000 - 
   (2122594725282739427705748998600630944974565440851269851412282679820606387\
71830745544378856992470109691200070600150382951091637068809628335556743121429\
27663819059691753403256508450596263314645329939886405124322131818903407398727\
78875789833918885056859090489375875652500215793425378362241027973863011452446\
534668502776359608612318248525031516942549*Pi^2*tailpot)/86206004299608141409\
46332214986475503741116636247223068114411887230837143295649867283260408610765\
53235194565769153140754460170373371335470606077795309068770219324592358290081\
25492871239634114231236502070165405880238977314348509954611102250641257529056\
84206250968780531184857520009126440732281541913944530573606643442070323200 - 
   (9006156037330958538904758302016764771597825636858352077856004931053700014\
33125168980116307895715312987596098344702680932407772247755075081958728590485\
73783355398898732137096009448899207341874737962497050537221295111471748234240\
16758791677317974117703209004211821132841639150540255740943506563854117406678\
43964233515073274688229165681499940194719611435645237470298356411083774317583\
81683728119724745336786266331807945545155184295965673920136605800768640492844\
99030724979393565153569665867310523953386599458228598653914247911626422114588\
34489877519596280701423719102627116149671909180953013551679610447354340362713\
9*tailpot*Log[2])/23090054515109944030675731756115851314402886267761864028504\
40260311949318680311232537860230873572211651448314923576258578616613328850869\
48901483158521967201204512470126498692968321582037181899256165038361879223258\
17651779292936517820931706783235897258995307856271773639101050076727317373807\
41374261383721818870215973256144475762379635989094899214469463479680503037804\
87708636718032748727604898400247758296447260729082457379715951068627575643185\
15765950493213266142711688021771987850940025613385398432997908474743176143743\
55325382455072762023808950597409696208248991492620418909663454891766310312700\
01868800000 - (90061560373309585389047583020167647715978256368583520778560049\
31053700014331251689801163078957153129875960983447026809324077722477550750819\
58728590485737833553988987321370960094488992073418747379624970505372212951114\
71748234240167587916773179741177032090042118211328416391505402557409435065638\
54117406678439642335150732746882291656814999401947196114356452374702983564110\
83774317583816837281197247453367862663318079455451551842959656739201366058007\
68640492844990307249793935651535696658673105239533865994582285986539142479116\
26422114588344898775195962807014237191026271161496719091809530135516796104473\
543403627139*tailpot*Log[v])/230900545151099440306757317561158513144028862677\
61864028504402603119493186803112325378602308735722116514483149235762585786166\
13328850869489014831585219672012045124701264986929683215820371818992561650383\
61879223258176517792929365178209317067832358972589953078562717736391010500767\
27317373807413742613837218188702159732561444757623796359890948992144694634796\
80503037804877086367180327487276048984002477582964472607290824573797159510686\
27575643185157659504932132661427116880217719878509400256133853984329979084747\
43176143743553253824550727620238089505974096962082489914926204189096634548917\
6631031270001868800000) + v^12*((3135973379440056128*mem)/1169860090273875 + 
   (313340346944*cM*mem)/530675145 + (605150650467653143688012491*tailpot)/
    5481758487647490048000 - (189835459184621*Pi^2*tailpot)/16728391680 - 
   (2536866831061*tailpot*Log[2])/2705402700 - (2536866831061*tailpot*Log[v])/
    2705402700) + v^10*((109059913956608*mem)/55720890225 + 
   (1395761408*cM*mem)/2837835 + (386835427469130997311907*tailpot)/
    5091416551994572800 - (287543941021*Pi^2*tailpot)/36900864 - 
   (936804301943*tailpot*Log[2])/1352701350 - (936804301943*tailpot*Log[v])/
    1352701350) + 
 v^8*((5063469908813938688*mem - 7*(-176790479981772800*cM*mem + 
       tailpot*(-21304526017617004397 + 2205757686412330050*Pi^2 + 
         211325635032145920*Log[2])))/3199733881344000 - 
   (2672529014*tailpot*Log[v])/5780775) + 
 v^6*((304221264128*mem)/364188825 + (6687488*cM*mem)/24255 + 
   (1606364255468131*tailpot)/67805337600 - (1863584179*Pi^2*tailpot)/
    760320 - (4165684*tailpot*Log[2])/17325 - (4165684*tailpot*Log[v])/
    17325) + v^4*((552020416*mem)/779625 + (358208*cM*mem)/2205 + 
   (15206277438221*tailpot)/2095632000 - (9123247*Pi^2*tailpot)/11520 - 
   (356192*tailpot*Log[2])/4725 - (356192*tailpot*Log[v])/4725) + 
 v^535*(((-292205666384985489071556413626015986997594955237951313681677331068\
21629287531053735868060349732616539594990745054720653556317513465400145180628\
43477958811706658408614738421362633688964829914606270173662240840683456205011\
07985190165869485431573488432374540378059982852663130745769027918528509897411\
57722911740360447815284458109057427265026773844036742945766800377245408763958\
48366878606475259235485350387835899501316000552660268454046868656429188239869\
19820344002668354938894672442426248712603508557589412218599587322854454149042\
52105170408490880597306875504834638370279431506594352150349516170847595944870\
25683769787034341612282951930421109264267551037958486387351781839049199372102\
12381129079506399251617282067954565512071324104942641784367586208887666421602\
40593964171038738453562855507830678108014593463098414129502933035496641087643\
72923037702674570734124343621283225859483382648031157978466633223092677099069\
85347716674508907402810404054591733586622503160304653315458590673150163231053\
10200373225671195856476906749353625010346644251628974173013878106867244373461\
01241983373392368115715553010617163437584393063480043689595774847381037788978\
36942285848705456485599626472465651021919265305707950888964596589100744959865\
87670147040476552*mem)/5 - 47555780820069056568021778195598869892145098947532\
58615055285426541436721701622661690018415527337355601897202758037333121351848\
89219640363341371187776532775196717492983823426143596855044081905262640951615\
09071930796225376767475323103600171067021898131158115185459955062383507470380\
80845729979273528442718088626861572265625*
      (-503014243667915195327523267265183941690888457129435665550067754474922\
07518955969662652346714906749553622004696178650755325812424515274319927254773\
69932901967970476509263153625231511747658397382106630578649058946048375163242\
83336831837255536515538506144504224852064238275618501022707396759827552562022\
28130759881965304626807262393522933314733671627777925495059745515896376120801\
30759872364178398607503947984299936172469391589032802735125039171609183482497\
012887288012642013875166599839035985988342479041097102275990296693690069