! Copyright 2024
!
! Zdenek Masin with contributions from others (see the UK-AMOR website)
!
! This file is part of GBTOlib.
!
!     GBTOlib is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     GBTOlib is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  GBTOlib (in trunk/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!

!Generated using the Mathematica notebook Laguerre_expansion_coefficients.nb
module lag_cfs_gbl
   use precisn_gbl
   implicit none

   !> Maximum value L of the angular momentum of the CGTO G that can be used when calculating the (BX|GG) integrals.
   integer, parameter :: l_max_gto = 7
   integer, parameter :: l_lag_lim = 12
   integer, parameter :: n_lag_lim = 6

contains

   !> Coefficients for L_{n}^{l+1/2}(x+y) = sum_{lp=0}^{n} P_{lp}^{n,l}(x,r1*r2) sum_{mp=-lp}^{lp}X_{lp,mp}(r1)*X_{lp,mp}(r2)
   !> y = r1.r2 = dot_product(r1,r2); r1*r2 = |r1|*|r2|; x = scalar
   !> P_{lp}^{n,l}(x,r1*r2) = sum_{p=0}^{n} x^p * (sum_{k=0}^{n} c_{k}^{p,lp,l,n}(r1*r2)^k)
   subroutine Laguerre_poly_factorization_cfs(c)
      implicit none
      real(kind=cfp), allocatable :: c(:,:,:,:,:)

      if (allocated(c)) deallocate(c)
      allocate(c(0:n_lag_lim,0:n_lag_lim,0:n_lag_lim,0:l_lag_lim,1:n_lag_lim)) !(k,p,lp,l,n)
      c = 0.0_cfp

      c( 0, 0, 0, 0, 1) = 1.88495559215387594307758602996770173E1_cfp
      c( 0, 1, 0, 0, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 0, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 0, 2) = 2.35619449019234492884698253745962716E1_cfp
      c( 2, 0, 0, 0, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 0, 2) = -3.14159265358979323846264338327950288E1_cfp
      c( 0, 2, 0, 0, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 0, 2) = -1.04719755119659774615421446109316763E1_cfp
      c( 1, 1, 1, 0, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 0, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 0, 3) = 2.74889357189106908365481296036956502E1_cfp
      c( 2, 0, 0, 0, 3) = 7.33038285837618422307950122765217340E0_cfp
      c( 0, 1, 0, 0, 3) = -5.49778714378213816730962592073913005E1_cfp
      c( 2, 1, 0, 0, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 0, 3) = 2.19911485751285526692385036829565202E1_cfp
      c( 0, 3, 0, 0, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 0, 3) = -1.83259571459404605576987530691304335E1_cfp
      c( 3, 0, 1, 0, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 0, 3) = 1.46607657167523684461590024553043468E1_cfp
      c( 1, 2, 1, 0, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 0, 3) = 2.93215314335047368923180049106086936E0_cfp
      c( 2, 1, 2, 0, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 0, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 0, 4) = 3.09250526837745271911166458041576065E1_cfp
      c( 2, 0, 0, 0, 4) = 1.64933614313464145019288777622173901E1_cfp
      c( 4, 0, 0, 0, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 0, 4) = -8.24668071567320725096443888110869507E1_cfp
      c( 2, 1, 0, 0, 4) = -9.42477796076937971538793014983850865E0_cfp
      c( 0, 2, 0, 0, 4) = 4.94800842940392435057866332866521704E1_cfp
      c( 2, 2, 0, 0, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 0, 4) = -9.42477796076937971538793014983850865E0_cfp
      c( 0, 4, 0, 0, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 0, 4) = -2.74889357189106908365481296036956502E1_cfp
      c( 3, 0, 1, 0, 4) = -1.88495559215387594307758602996770173E0_cfp
      c( 1, 1, 1, 0, 4) = 3.29867228626928290038577555244347803E1_cfp
      c( 3, 1, 1, 0, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 0, 4) = -9.42477796076937971538793014983850865E0_cfp
      c( 1, 3, 1, 0, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 0, 4) = 6.59734457253856580077155110488695606E0_cfp
      c( 4, 0, 2, 0, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 0, 4) = -3.76991118430775188615517205993540346E0_cfp
      c( 2, 2, 2, 0, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 0, 4) = -5.38558740615393126593596008562200494E-1_cfp
      c( 3, 1, 3, 0, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 0, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 0, 5) = 3.40175579521519799102283103845733672E1_cfp
      c( 2, 0, 0, 0, 5) = 3.02378292908017599202029425640652153E1_cfp
      c( 4, 0, 0, 0, 5) = 5.75958653158128760384817953601242195E-1_cfp
      c( 0, 1, 0, 0, 5) = -1.13391859840506599700761034615244557E2_cfp
      c( 2, 1, 0, 0, 5) = -2.59181393921157942173168079120558988E1_cfp
      c( 4, 1, 0, 0, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 0, 5) = 9.07134878724052797606088276921956458E1_cfp
      c( 2, 2, 0, 0, 5) = 5.75958653158128760384817953601242195E0_cfp
      c( 0, 3, 0, 0, 5) = -2.59181393921157942173168079120558988E1_cfp
      c( 2, 3, 0, 0, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 0, 5) = 2.87979326579064380192408976800621098E0_cfp
      c( 0, 5, 0, 0, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 0, 5) = -3.77972866135021999002536782050815191E1_cfp
      c( 3, 0, 1, 0, 5) = -5.18362787842315884346336158241117976E0_cfp
      c( 5, 0, 1, 0, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 0, 5) = 6.04756585816035198404058851281304305E1_cfp
      c( 3, 1, 1, 0, 5) = 2.30383461263251504153927181440496878E0_cfp
      c( 1, 2, 1, 0, 5) = -2.59181393921157942173168079120558988E1_cfp
      c( 3, 2, 1, 0, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 0, 5) = 3.83972435438752506923211969067494797E0_cfp
      c( 1, 4, 1, 0, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 0, 5) = 1.20951317163207039680811770256260861E1_cfp
      c( 4, 0, 2, 0, 5) = 3.29119230376073577362753116343566969E-1_cfp
      c( 2, 1, 2, 0, 5) = -1.03672557568463176869267231648223595E1_cfp
      c( 4, 1, 2, 0, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 0, 5) = 2.30383461263251504153927181440496878E0_cfp
      c( 2, 3, 2, 0, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 0, 5) = -1.48103653669233109813238902354605136E0_cfp
      c( 5, 0, 3, 0, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 0, 5) = 6.58238460752147154725506232687133938E-1_cfp
      c( 3, 2, 3, 0, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 0, 5) = 7.31376067502385727472784702985704375E-2_cfp
      c( 4, 1, 4, 0, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 0, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 0, 6) = 3.68523544481646449027473362499544811E1_cfp
      c( 2, 0, 0, 0, 6) = 4.91364725975528598703297816666059748E1_cfp
      c( 4, 0, 0, 0, 6) = 1.87186562276391847125065834920403714E0_cfp
      c( 6, 0, 0, 0, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 0, 6) = -1.47409417792658579610989344999817924E2_cfp
      c( 2, 1, 0, 0, 6) = -5.61559686829175541375197504761211141E1_cfp
      c( 4, 1, 0, 0, 6) = -6.80678408277788535000239399710558958E-1_cfp
      c( 0, 2, 0, 0, 6) = 1.47409417792658579610989344999817924E2_cfp
      c( 2, 2, 0, 0, 6) = 1.87186562276391847125065834920403714E1_cfp
      c( 4, 2, 0, 0, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 0, 6) = -5.61559686829175541375197504761211141E1_cfp
      c( 2, 3, 0, 0, 6) = -2.26892802759262845000079799903519653E0_cfp
      c( 0, 4, 0, 0, 6) = 9.35932811381959235625329174602018568E0_cfp
      c( 2, 4, 0, 0, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 0, 6) = -6.80678408277788535000239399710558958E-1_cfp
      c( 0, 6, 0, 0, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 0, 6) = -4.91364725975528598703297816666059748E1_cfp
      c( 3, 0, 1, 0, 6) = -1.12311937365835108275039500952242228E1_cfp
      c( 5, 0, 1, 0, 6) = -9.72397726111126478571770571015084226E-2_cfp
      c( 1, 1, 1, 0, 6) = 9.82729451951057197406595633332119496E1_cfp
      c( 3, 1, 1, 0, 6) = 7.48746249105567388500263339681614854E0_cfp
      c( 5, 1, 1, 0, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 0, 6) = -5.61559686829175541375197504761211141E1_cfp
      c( 3, 2, 1, 0, 6) = -1.36135681655557707000047879942111792E0_cfp
      c( 1, 3, 1, 0, 6) = 1.24791041517594564750043889946935809E1_cfp
      c( 3, 3, 1, 0, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 0, 6) = -1.13446401379631422500039899951759826E0_cfp
      c( 1, 5, 1, 0, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 0, 6) = 1.96545890390211439481319126666423899E1_cfp
      c( 4, 0, 2, 0, 6) = 1.06963749872223912642894762811659265E0_cfp
      c( 6, 0, 2, 0, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 0, 6) = -2.24623874731670216550079001904484456E1_cfp
      c( 4, 1, 2, 0, 6) = -3.88959090444450591428708228406033690E-1_cfp
      c( 2, 2, 2, 0, 6) = 7.48746249105567388500263339681614854E0_cfp
      c( 4, 2, 2, 0, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 0, 6) = -9.07571211037051380000319199614078611E-1_cfp
      c( 2, 4, 2, 0, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 0, 6) = -3.20891249616671737928684288434977795E0_cfp
      c( 5, 0, 3, 0, 6) = -4.32176767160500657143009142673370767E-2_cfp
      c( 3, 1, 3, 0, 6) = 2.13927499744447825285789525623318530E0_cfp
      c( 5, 1, 3, 0, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 0, 6) = -3.88959090444450591428708228406033690E-1_cfp
      c( 3, 3, 3, 0, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 0, 6) = 2.37697221938275361428655028470353922E-1_cfp
      c( 6, 0, 4, 0, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 0, 6) = -8.64353534321001314286018285346741534E-2_cfp
      c( 4, 2, 4, 0, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 0, 6) = -7.85775940291819376623652986678855940E-3_cfp
      c( 5, 1, 5, 0, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 0, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 1, 1) = 3.14159265358979323846264338327950288E1_cfp
      c( 0, 1, 0, 1, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 1, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 1, 2) = 5.49778714378213816730962592073913005E1_cfp
      c( 2, 0, 0, 1, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 1, 2) = -4.39822971502571053384770073659130404E1_cfp
      c( 0, 2, 0, 1, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 1, 2) = -1.46607657167523684461590024553043468E1_cfp
      c( 1, 1, 1, 1, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 1, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 1, 3) = 8.24668071567320725096443888110869507E1_cfp
      c( 2, 0, 0, 1, 3) = 9.42477796076937971538793014983850865E0_cfp
      c( 0, 1, 0, 1, 3) = -9.89601685880784870115732665733043409E1_cfp
      c( 2, 1, 0, 1, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 1, 3) = 2.82743338823081391461637904495155260E1_cfp
      c( 0, 3, 0, 1, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 1, 3) = -3.29867228626928290038577555244347803E1_cfp
      c( 3, 0, 1, 1, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 1, 3) = 1.88495559215387594307758602996770173E1_cfp
      c( 1, 2, 1, 1, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 1, 3) = 3.76991118430775188615517205993540346E0_cfp
      c( 2, 1, 2, 1, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 1, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 1, 4) = 1.13391859840506599700761034615244557E2_cfp
      c( 2, 0, 0, 1, 4) = 2.59181393921157942173168079120558988E1_cfp
      c( 4, 0, 0, 1, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 1, 4) = -1.81426975744810559521217655384391292E2_cfp
      c( 2, 1, 0, 1, 4) = -1.15191730631625752076963590720248439E1_cfp
      c( 0, 2, 0, 1, 4) = 7.77544181763473826519504237361676964E1_cfp
      c( 2, 2, 0, 1, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 1, 4) = -1.15191730631625752076963590720248439E1_cfp
      c( 0, 4, 0, 1, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 1, 4) = -6.04756585816035198404058851281304305E1_cfp
      c( 3, 0, 1, 1, 4) = -2.30383461263251504153927181440496878E0_cfp
      c( 1, 1, 1, 1, 4) = 5.18362787842315884346336158241117976E1_cfp
      c( 3, 1, 1, 1, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 1, 4) = -1.15191730631625752076963590720248439E1_cfp
      c( 1, 3, 1, 1, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 1, 4) = 1.03672557568463176869267231648223595E1_cfp
      c( 4, 0, 2, 1, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 1, 4) = -4.60766922526503008307854362880993756E0_cfp
      c( 2, 2, 2, 1, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 1, 4) = -6.58238460752147154725506232687133938E-1_cfp
      c( 3, 1, 3, 1, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 1, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 1, 5) = 1.47409417792658579610989344999817924E2_cfp
      c( 2, 0, 0, 1, 5) = 5.61559686829175541375197504761211141E1_cfp
      c( 4, 0, 0, 1, 5) = 6.80678408277788535000239399710558958E-1_cfp
      c( 0, 1, 0, 1, 5) = -2.94818835585317159221978689999635849E2_cfp
      c( 2, 1, 0, 1, 5) = -3.74373124552783694250131669840807427E1_cfp
      c( 4, 1, 0, 1, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 1, 5) = 1.68467906048752662412559251428363342E2_cfp
      c( 2, 2, 0, 1, 5) = 6.80678408277788535000239399710558958E0_cfp
      c( 0, 3, 0, 1, 5) = -3.74373124552783694250131669840807427E1_cfp
      c( 2, 3, 0, 1, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 1, 5) = 3.40339204138894267500119699855279479E0_cfp
      c( 0, 5, 0, 1, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 1, 5) = -9.82729451951057197406595633332119496E1_cfp
      c( 3, 0, 1, 1, 5) = -7.48746249105567388500263339681614854E0_cfp
      c( 5, 0, 1, 1, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 1, 5) = 1.12311937365835108275039500952242228E2_cfp
      c( 3, 1, 1, 1, 5) = 2.72271363311115414000095759884223583E0_cfp
      c( 1, 2, 1, 1, 5) = -3.74373124552783694250131669840807427E1_cfp
      c( 3, 2, 1, 1, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 1, 5) = 4.53785605518525690000159599807039305E0_cfp
      c( 1, 4, 1, 1, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 1, 5) = 2.24623874731670216550079001904484456E1_cfp
      c( 4, 0, 2, 1, 5) = 3.88959090444450591428708228406033690E-1_cfp
      c( 2, 1, 2, 1, 5) = -1.49749249821113477700052667936322971E1_cfp
      c( 4, 1, 2, 1, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 1, 5) = 2.72271363311115414000095759884223583E0_cfp
      c( 2, 3, 2, 1, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 1, 5) = -2.13927499744447825285789525623318530E0_cfp
      c( 5, 0, 3, 1, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 1, 5) = 7.77918180888901182857416456812067381E-1_cfp
      c( 3, 2, 3, 1, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 1, 5) = 8.64353534321001314286018285346741534E-2_cfp
      c( 4, 1, 4, 1, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 1, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 1, 6) = 1.84261772240823224513736681249772405E2_cfp
      c( 2, 0, 0, 1, 6) = 1.05292441280470414007849532142727089E2_cfp
      c( 4, 0, 0, 1, 6) = 2.55254403104170700625089774891459609E0_cfp
      c( 6, 0, 0, 1, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 1, 6) = -4.42228253377975738832968034999453773E2_cfp
      c( 2, 1, 0, 1, 6) = -9.35932811381959235625329174602018568E1_cfp
      c( 4, 1, 0, 1, 6) = -7.85398163397448309615660845819875721E-1_cfp
      c( 0, 2, 0, 1, 6) = 3.15877323841411242023548596428181267E2_cfp
      c( 2, 2, 0, 1, 6) = 2.55254403104170700625089774891459609E1_cfp
      c( 4, 2, 0, 1, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 1, 6) = -9.35932811381959235625329174602018568E1_cfp
      c( 2, 3, 0, 1, 6) = -2.61799387799149436538553615273291907E0_cfp
      c( 0, 4, 0, 1, 6) = 1.27627201552085350312544887445729805E1_cfp
      c( 2, 4, 0, 1, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 1, 6) = -7.85398163397448309615660845819875721E-1_cfp
      c( 0, 6, 0, 1, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 1, 6) = -1.47409417792658579610989344999817924E2_cfp
      c( 3, 0, 1, 1, 6) = -1.87186562276391847125065834920403714E1_cfp
      c( 5, 0, 1, 1, 6) = -1.12199737628206901373665835117125103E-1_cfp
      c( 1, 1, 1, 1, 6) = 2.10584882560940828015699064285454178E2_cfp
      c( 3, 1, 1, 1, 6) = 1.02101761241668280250035909956583844E1_cfp
      c( 5, 1, 1, 1, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 1, 6) = -9.35932811381959235625329174602018568E1_cfp
      c( 3, 2, 1, 1, 6) = -1.57079632679489661923132169163975144E0_cfp
      c( 1, 3, 1, 1, 6) = 1.70169602069447133750059849927639740E1_cfp
      c( 3, 3, 1, 1, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 1, 6) = -1.30899693899574718269276807636645954E0_cfp
      c( 1, 5, 1, 1, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 1, 6) = 4.21169765121881656031398128570908355E1_cfp
      c( 4, 0, 2, 1, 6) = 1.45859658916668971785765585652262634E0_cfp
      c( 6, 0, 2, 1, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 1, 6) = -3.74373124552783694250131669840807427E1_cfp
      c( 4, 1, 2, 1, 6) = -4.48798950512827605494663340468500412E-1_cfp
      c( 2, 2, 2, 1, 6) = 1.02101761241668280250035909956583844E1_cfp
      c( 4, 2, 2, 1, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 1, 6) = -1.04719755119659774615421446109316763E0_cfp
      c( 2, 4, 2, 1, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 1, 6) = -5.34818749361119563214473814058296324E0_cfp
      c( 5, 0, 3, 1, 6) = -4.98665500569808450549625933853889347E-2_cfp
      c( 3, 1, 3, 1, 6) = 2.91719317833337943571531171304525268E0_cfp
      c( 5, 1, 3, 1, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 1, 6) = -4.48798950512827605494663340468500412E-1_cfp
      c( 3, 3, 3, 1, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 1, 6) = 3.24132575370375492857256857005028075E-1_cfp
      c( 6, 0, 4, 1, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 1, 6) = -9.97331001139616901099251867707778693E-2_cfp
      c( 4, 2, 4, 1, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 1, 6) = -9.06664546490560819181138061552526085E-3_cfp
      c( 5, 1, 5, 1, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 1, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 2, 1) = 4.39822971502571053384770073659130404E1_cfp
      c( 0, 1, 0, 2, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 2, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 2, 2) = 9.89601685880784870115732665733043409E1_cfp
      c( 2, 0, 0, 2, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 2, 2) = -5.65486677646162782923275808990310519E1_cfp
      c( 0, 2, 0, 2, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 2, 2) = -1.88495559215387594307758602996770173E1_cfp
      c( 1, 1, 1, 2, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 2, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 2, 3) = 1.81426975744810559521217655384391292E2_cfp
      c( 2, 0, 0, 2, 3) = 1.15191730631625752076963590720248439E1_cfp
      c( 0, 1, 0, 2, 3) = -1.55508836352694765303900847472335393E2_cfp
      c( 2, 1, 0, 2, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 2, 3) = 3.45575191894877256230890772160745317E1_cfp
      c( 0, 3, 0, 2, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 2, 3) = -5.18362787842315884346336158241117976E1_cfp
      c( 3, 0, 1, 2, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 2, 3) = 2.30383461263251504153927181440496878E1_cfp
      c( 1, 2, 1, 2, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 2, 3) = 4.60766922526503008307854362880993756E0_cfp
      c( 2, 1, 2, 2, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 2, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 2, 4) = 2.94818835585317159221978689999635849E2_cfp
      c( 2, 0, 0, 2, 4) = 3.74373124552783694250131669840807427E1_cfp
      c( 4, 0, 0, 2, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 2, 4) = -3.36935812097505324825118502856726684E2_cfp
      c( 2, 1, 0, 2, 4) = -1.36135681655557707000047879942111792E1_cfp
      c( 0, 2, 0, 2, 4) = 1.12311937365835108275039500952242228E2_cfp
      c( 2, 2, 0, 2, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 2, 4) = -1.36135681655557707000047879942111792E1_cfp
      c( 0, 4, 0, 2, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 2, 4) = -1.12311937365835108275039500952242228E2_cfp
      c( 3, 0, 1, 2, 4) = -2.72271363311115414000095759884223583E0_cfp
      c( 1, 1, 1, 2, 4) = 7.48746249105567388500263339681614854E1_cfp
      c( 3, 1, 1, 2, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 2, 4) = -1.36135681655557707000047879942111792E1_cfp
      c( 1, 3, 1, 2, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 2, 4) = 1.49749249821113477700052667936322971E1_cfp
      c( 4, 0, 2, 2, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 2, 4) = -5.44542726622230828000191519768447167E0_cfp
      c( 2, 2, 2, 2, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 2, 4) = -7.77918180888901182857416456812067381E-1_cfp
      c( 3, 1, 3, 2, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 2, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 2, 5) = 4.42228253377975738832968034999453773E2_cfp
      c( 2, 0, 0, 2, 5) = 9.35932811381959235625329174602018568E1_cfp
      c( 4, 0, 0, 2, 5) = 7.85398163397448309615660845819875721E-1_cfp
      c( 0, 1, 0, 2, 5) = -6.31754647682822484047097192856362533E2_cfp
      c( 2, 1, 0, 2, 5) = -5.10508806208341401250179549782919219E1_cfp
      c( 4, 1, 0, 2, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 2, 5) = 2.80779843414587770687598752380605570E2_cfp
      c( 2, 2, 0, 2, 5) = 7.85398163397448309615660845819875721E0_cfp
      c( 0, 3, 0, 2, 5) = -5.10508806208341401250179549782919219E1_cfp
      c( 2, 3, 0, 2, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 2, 5) = 3.92699081698724154807830422909937861E0_cfp
      c( 0, 5, 0, 2, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 2, 5) = -2.10584882560940828015699064285454178E2_cfp
      c( 3, 0, 1, 2, 5) = -1.02101761241668280250035909956583844E1_cfp
      c( 5, 0, 1, 2, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 2, 5) = 1.87186562276391847125065834920403714E2_cfp
      c( 3, 1, 1, 2, 5) = 3.14159265358979323846264338327950288E0_cfp
      c( 1, 2, 1, 2, 5) = -5.10508806208341401250179549782919219E1_cfp
      c( 3, 2, 1, 2, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 2, 5) = 5.23598775598298873077107230546583814E0_cfp
      c( 1, 4, 1, 2, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 2, 5) = 3.74373124552783694250131669840807427E1_cfp
      c( 4, 0, 2, 2, 5) = 4.48798950512827605494663340468500412E-1_cfp
      c( 2, 1, 2, 2, 5) = -2.04203522483336560500071819913167687E1_cfp
      c( 4, 1, 2, 2, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 2, 5) = 3.14159265358979323846264338327950288E0_cfp
      c( 2, 3, 2, 2, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 2, 5) = -2.91719317833337943571531171304525268E0_cfp
      c( 5, 0, 3, 2, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 2, 5) = 8.97597901025655210989326680937000824E-1_cfp
      c( 3, 2, 3, 2, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 2, 5) = 9.97331001139616901099251867707778693E-2_cfp
      c( 4, 1, 4, 2, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 2, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 2, 6) = 6.26490025618798963346704716249226179E2_cfp
      c( 2, 0, 0, 2, 6) = 1.98885722418666337570382449602928946E2_cfp
      c( 4, 0, 0, 2, 6) = 3.33794219443915531586655859473447181E0_cfp
      c( 6, 0, 0, 2, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 2, 6) = -1.07398290106079822288006522785581631E3_cfp
      c( 2, 1, 0, 2, 6) = -1.44644161759030063687550872438493779E2_cfp
      c( 4, 1, 0, 2, 6) = -8.90117918517108084231082291929192484E-1_cfp
      c( 0, 2, 0, 2, 6) = 5.96657167255999012711147348808786837E2_cfp
      c( 2, 2, 0, 2, 6) = 3.33794219443915531586655859473447181E1_cfp
      c( 4, 2, 0, 2, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 2, 6) = -1.44644161759030063687550872438493779E2_cfp
      c( 2, 3, 0, 2, 6) = -2.96705972839036028077027430643064161E0_cfp
      c( 0, 4, 0, 2, 6) = 1.66897109721957765793327929736723591E1_cfp
      c( 2, 4, 0, 2, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 2, 6) = -8.90117918517108084231082291929192484E-1_cfp
      c( 0, 6, 0, 2, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 2, 6) = -3.57994300353599407626688409285272102E2_cfp
      c( 3, 0, 1, 2, 6) = -2.89288323518060127375101744876987557E1_cfp
      c( 5, 0, 1, 2, 6) = -1.27159702645301154890154613132741783E-1_cfp
      c( 1, 1, 1, 2, 6) = 3.97771444837332675140764899205857891E2_cfp
      c( 3, 1, 1, 2, 6) = 1.33517687777566212634662343789378873E1_cfp
      c( 5, 1, 1, 2, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 2, 6) = -1.44644161759030063687550872438493779E2_cfp
      c( 3, 2, 1, 2, 6) = -1.78023583703421616846216458385838497E0_cfp
      c( 1, 3, 1, 2, 6) = 2.22529479629277021057770572982298121E1_cfp
      c( 3, 3, 1, 2, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 2, 6) = -1.48352986419518014038513715321532081E0_cfp
      c( 1, 5, 1, 2, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 2, 6) = 7.95542889674665350281529798411715782E1_cfp
      c( 4, 0, 2, 2, 6) = 1.90739553967951732335231919699112675E0_cfp
      c( 6, 0, 2, 2, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 2, 6) = -5.78576647036120254750203489753975115E1_cfp
      c( 4, 1, 2, 2, 6) = -5.08638810581204619560618452530967134E-1_cfp
      c( 2, 2, 2, 2, 6) = 1.33517687777566212634662343789378873E1_cfp
      c( 4, 2, 2, 2, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 2, 6) = -1.18682389135614411230810972257225665E0_cfp
      c( 2, 4, 2, 2, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 2, 6) = -8.26538067194457506786004985362821592E0_cfp
      c( 5, 0, 3, 2, 6) = -5.65154233979116243956242725034407926E-2_cfp
      c( 3, 1, 3, 2, 6) = 3.81479107935903464670463839398225350E0_cfp
      c( 5, 1, 3, 2, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 2, 6) = -5.08638810581204619560618452530967134E-1_cfp
      c( 3, 3, 3, 2, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 2, 6) = 4.23865675484337182967182043775805945E-1_cfp
      c( 6, 0, 4, 2, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 2, 6) = -1.13030846795823248791248545006881585E-1_cfp
      c( 4, 2, 4, 2, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 2, 6) = -1.02755315268930226173862313642619623E-2_cfp
      c( 5, 1, 5, 2, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 2, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 3, 1) = 5.65486677646162782923275808990310519E1_cfp
      c( 0, 1, 0, 3, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 3, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 3, 2) = 1.55508836352694765303900847472335393E2_cfp
      c( 2, 0, 0, 3, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 3, 2) = -6.91150383789754512461781544321490635E1_cfp
      c( 0, 2, 0, 3, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 3, 2) = -2.30383461263251504153927181440496878E1_cfp
      c( 1, 1, 1, 3, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 3, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 3, 3) = 3.36935812097505324825118502856726684E2_cfp
      c( 2, 0, 0, 3, 3) = 1.36135681655557707000047879942111792E1_cfp
      c( 0, 1, 0, 3, 3) = -2.24623874731670216550079001904484456E2_cfp
      c( 2, 1, 0, 3, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 3, 3) = 4.08407044966673121000143639826335375E1_cfp
      c( 0, 3, 0, 3, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 3, 3) = -7.48746249105567388500263339681614854E1_cfp
      c( 3, 0, 1, 3, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 3, 3) = 2.72271363311115414000095759884223583E1_cfp
      c( 1, 2, 1, 3, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 3, 3) = 5.44542726622230828000191519768447167E0_cfp
      c( 2, 1, 2, 3, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 3, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 3, 4) = 6.31754647682822484047097192856362533E2_cfp
      c( 2, 0, 0, 3, 4) = 5.10508806208341401250179549782919219E1_cfp
      c( 4, 0, 0, 3, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 3, 4) = -5.61559686829175541375197504761211141E2_cfp
      c( 2, 1, 0, 3, 4) = -1.57079632679489661923132169163975144E1_cfp
      c( 0, 2, 0, 3, 4) = 1.53152641862502420375053864934875766E2_cfp
      c( 2, 2, 0, 3, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 3, 4) = -1.57079632679489661923132169163975144E1_cfp
      c( 0, 4, 0, 3, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 3, 4) = -1.87186562276391847125065834920403714E2_cfp
      c( 3, 0, 1, 3, 4) = -3.14159265358979323846264338327950288E0_cfp
      c( 1, 1, 1, 3, 4) = 1.02101761241668280250035909956583844E2_cfp
      c( 3, 1, 1, 3, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 3, 4) = -1.57079632679489661923132169163975144E1_cfp
      c( 1, 3, 1, 3, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 3, 4) = 2.04203522483336560500071819913167687E1_cfp
      c( 4, 0, 2, 3, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 3, 4) = -6.28318530717958647692528676655900577E0_cfp
      c( 2, 2, 2, 3, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 3, 4) = -8.97597901025655210989326680937000824E-1_cfp
      c( 3, 1, 3, 3, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 3, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 3, 5) = 1.07398290106079822288006522785581631E3_cfp
      c( 2, 0, 0, 3, 5) = 1.44644161759030063687550872438493779E2_cfp
      c( 4, 0, 0, 3, 5) = 8.90117918517108084231082291929192484E-1_cfp
      c( 0, 1, 0, 3, 5) = -1.19331433451199802542229469761757367E3_cfp
      c( 2, 1, 0, 3, 5) = -6.67588438887831063173311718946894363E1_cfp
      c( 4, 1, 0, 3, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 3, 5) = 4.33932485277090191062652617315481336E2_cfp
      c( 2, 2, 0, 3, 5) = 8.90117918517108084231082291929192484E0_cfp
      c( 0, 3, 0, 3, 5) = -6.67588438887831063173311718946894363E1_cfp
      c( 2, 3, 0, 3, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 3, 5) = 4.45058959258554042115541145964596242E0_cfp
      c( 0, 5, 0, 3, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 3, 5) = -3.97771444837332675140764899205857891E2_cfp
      c( 3, 0, 1, 3, 5) = -1.33517687777566212634662343789378873E1_cfp
      c( 5, 0, 1, 3, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 3, 5) = 2.89288323518060127375101744876987557E2_cfp
      c( 3, 1, 1, 3, 5) = 3.56047167406843233692432916771676994E0_cfp
      c( 1, 2, 1, 3, 5) = -6.67588438887831063173311718946894363E1_cfp
      c( 3, 2, 1, 3, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 3, 5) = 5.93411945678072056154054861286128323E0_cfp
      c( 1, 4, 1, 3, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 3, 5) = 5.78576647036120254750203489753975115E1_cfp
      c( 4, 0, 2, 3, 5) = 5.08638810581204619560618452530967134E-1_cfp
      c( 2, 1, 2, 3, 5) = -2.67035375555132425269324687578757745E1_cfp
      c( 4, 1, 2, 3, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 3, 5) = 3.56047167406843233692432916771676994E0_cfp
      c( 2, 3, 2, 3, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 3, 5) = -3.81479107935903464670463839398225350E0_cfp
      c( 5, 0, 3, 3, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 3, 5) = 1.01727762116240923912123690506193427E0_cfp
      c( 3, 2, 3, 3, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 3, 5) = 1.13030846795823248791248545006881585E-1_cfp
      c( 4, 1, 4, 3, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 3, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 3, 6) = 1.70047292667959718622676994410504248E3_cfp
      c( 2, 0, 0, 3, 6) = 3.43529884177696401257933322041422724E2_cfp
      c( 4, 0, 0, 3, 6) = 4.22806011295626340009764088666366430E0_cfp
      c( 6, 0, 0, 3, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 3, 6) = -2.26729723557279624830235992547338998E3_cfp
      c( 2, 1, 0, 3, 6) = -2.11403005647813170004882044333183215E2_cfp
      c( 4, 1, 0, 3, 6) = -9.94837673636767858846503738038509247E-1_cfp
      c( 0, 2, 0, 3, 6) = 1.03058965253308920377379996612426817E3_cfp
      c( 2, 2, 0, 3, 6) = 4.22806011295626340009764088666366430E1_cfp
      c( 4, 2, 0, 3, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 3, 6) = -2.11403005647813170004882044333183215E2_cfp
      c( 2, 3, 0, 3, 6) = -3.31612557878922619615501246012836416E0_cfp
      c( 0, 4, 0, 3, 6) = 2.11403005647813170004882044333183215E1_cfp
      c( 2, 4, 0, 3, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 3, 6) = -9.94837673636767858846503738038509247E-1_cfp
      c( 0, 6, 0, 3, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 3, 6) = -7.55765745190932082767453308491129993E2_cfp
      c( 3, 0, 1, 3, 6) = -4.22806011295626340009764088666366430E1_cfp
      c( 5, 0, 1, 3, 6) = -1.42119667662395408406643391148358464E-1_cfp
      c( 1, 1, 1, 3, 6) = 6.87059768355392802515866644082845448E2_cfp
      c( 3, 1, 1, 3, 6) = 1.69122404518250536003905635466546572E1_cfp
      c( 5, 1, 1, 3, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 3, 6) = -2.11403005647813170004882044333183215E2_cfp
      c( 3, 2, 1, 3, 6) = -1.98967534727353571769300747607701849E0_cfp
      c( 1, 3, 1, 3, 6) = 2.81870674197084226673176059110910953E1_cfp
      c( 3, 3, 1, 3, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 3, 6) = -1.65806278939461309807750623006418208E0_cfp
      c( 1, 5, 1, 3, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 3, 6) = 1.37411953671078560503173328816569090E2_cfp
      c( 4, 0, 2, 3, 6) = 2.41603435026072194291293764952209388E0_cfp
      c( 6, 0, 2, 3, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 3, 6) = -8.45612022591252680019528177332732860E1_cfp
      c( 4, 1, 2, 3, 6) = -5.68478670649581633626573564593433855E-1_cfp
      c( 2, 2, 2, 3, 6) = 1.69122404518250536003905635466546572E1_cfp
      c( 4, 2, 2, 3, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 3, 6) = -1.32645023151569047846200498405134566E0_cfp
      c( 2, 4, 2, 3, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 3, 6) = -1.20801717513036097145646882476104694E1_cfp
      c( 5, 0, 3, 3, 6) = -6.31642967388424037362859516214926506E-2_cfp
      c( 3, 1, 3, 3, 6) = 4.83206870052144388582587529904418777E0_cfp
      c( 5, 1, 3, 3, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 3, 6) = -5.68478670649581633626573564593433855E-1_cfp
      c( 3, 3, 3, 3, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 3, 6) = 5.36896522280160431758430588782687530E-1_cfp
      c( 6, 0, 4, 3, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 3, 6) = -1.26328593477684807472571903242985301E-1_cfp
      c( 4, 2, 4, 3, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 3, 6) = -1.14844175888804370429610821129986637E-2_cfp
      c( 5, 1, 5, 3, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 3, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 4, 1) = 6.91150383789754512461781544321490635E1_cfp
      c( 0, 1, 0, 4, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 4, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 4, 2) = 2.24623874731670216550079001904484456E2_cfp
      c( 2, 0, 0, 4, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 4, 2) = -8.16814089933346242000287279652670750E1_cfp
      c( 0, 2, 0, 4, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 4, 2) = -2.72271363311115414000095759884223583E1_cfp
      c( 1, 1, 1, 4, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 4, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 4, 3) = 5.61559686829175541375197504761211141E2_cfp
      c( 2, 0, 0, 4, 3) = 1.57079632679489661923132169163975144E1_cfp
      c( 0, 1, 0, 4, 3) = -3.06305283725004840750107729869751531E2_cfp
      c( 2, 1, 0, 4, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 4, 3) = 4.71238898038468985769396507491925433E1_cfp
      c( 0, 3, 0, 4, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 4, 3) = -1.02101761241668280250035909956583844E2_cfp
      c( 3, 0, 1, 4, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 4, 3) = 3.14159265358979323846264338327950288E1_cfp
      c( 1, 2, 1, 4, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 4, 3) = 6.28318530717958647692528676655900577E0_cfp
      c( 2, 1, 2, 4, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 4, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 4, 4) = 1.19331433451199802542229469761757367E3_cfp
      c( 2, 0, 0, 4, 4) = 6.67588438887831063173311718946894363E1_cfp
      c( 4, 0, 0, 4, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 4, 4) = -8.67864970554180382125305234630962672E2_cfp
      c( 2, 1, 0, 4, 4) = -1.78023583703421616846216458385838497E1_cfp
      c( 0, 2, 0, 4, 4) = 2.00276531666349318951993515684068309E2_cfp
      c( 2, 2, 0, 4, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 4, 4) = -1.78023583703421616846216458385838497E1_cfp
      c( 0, 4, 0, 4, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 4, 4) = -2.89288323518060127375101744876987557E2_cfp
      c( 3, 0, 1, 4, 4) = -3.56047167406843233692432916771676994E0_cfp
      c( 1, 1, 1, 4, 4) = 1.33517687777566212634662343789378873E2_cfp
      c( 3, 1, 1, 4, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 4, 4) = -1.78023583703421616846216458385838497E1_cfp
      c( 1, 3, 1, 4, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 4, 4) = 2.67035375555132425269324687578757745E1_cfp
      c( 4, 0, 2, 4, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 4, 4) = -7.12094334813686467384865833543353987E0_cfp
      c( 2, 2, 2, 4, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 4, 4) = -1.01727762116240923912123690506193427E0_cfp
      c( 3, 1, 3, 4, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 4, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 4, 5) = 2.26729723557279624830235992547338998E3_cfp
      c( 2, 0, 0, 4, 5) = 2.11403005647813170004882044333183215E2_cfp
      c( 4, 0, 0, 4, 5) = 9.94837673636767858846503738038509247E-1_cfp
      c( 0, 1, 0, 4, 5) = -2.06117930506617840754759993224853635E3_cfp
      c( 2, 1, 0, 4, 5) = -8.45612022591252680019528177332732860E1_cfp
      c( 4, 1, 0, 4, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 4, 5) = 6.34209016943439510014646132999549645E2_cfp
      c( 2, 2, 0, 4, 5) = 9.94837673636767858846503738038509247E0_cfp
      c( 0, 3, 0, 4, 5) = -8.45612022591252680019528177332732860E1_cfp
      c( 2, 3, 0, 4, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 4, 5) = 4.97418836818383929423251869019254623E0_cfp
      c( 0, 5, 0, 4, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 4, 5) = -6.87059768355392802515866644082845448E2_cfp
      c( 3, 0, 1, 4, 5) = -1.69122404518250536003905635466546572E1_cfp
      c( 5, 0, 1, 4, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 4, 5) = 4.22806011295626340009764088666366430E2_cfp
      c( 3, 1, 1, 4, 5) = 3.97935069454707143538601495215403699E0_cfp
      c( 1, 2, 1, 4, 5) = -8.45612022591252680019528177332732860E1_cfp
      c( 3, 2, 1, 4, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 4, 5) = 6.63225115757845239231002492025672831E0_cfp
      c( 1, 4, 1, 4, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 4, 5) = 8.45612022591252680019528177332732860E1_cfp
      c( 4, 0, 2, 4, 5) = 5.68478670649581633626573564593433855E-1_cfp
      c( 2, 1, 2, 4, 5) = -3.38244809036501072007811270933093144E1_cfp
      c( 4, 1, 2, 4, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 4, 5) = 3.97935069454707143538601495215403699E0_cfp
      c( 2, 3, 2, 4, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 4, 5) = -4.83206870052144388582587529904418777E0_cfp
      c( 5, 0, 3, 4, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 4, 5) = 1.13695734129916326725314712918686771E0_cfp
      c( 3, 2, 3, 4, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 4, 5) = 1.26328593477684807472571903242985301E-1_cfp
      c( 4, 1, 4, 4, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 4, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 4, 6) = 3.96777016225239343452912986957843246E3_cfp
      c( 2, 0, 0, 4, 6) = 5.54932889825509571262815366374605939E2_cfp
      c( 4, 0, 0, 4, 6) = 5.22289778659303125894414462470217354E0_cfp
      c( 6, 0, 0, 4, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 4, 6) = -4.32847654063897465584995985772192633E3_cfp
      c( 2, 1, 0, 4, 6) = -2.95964207906938438006834862066456501E2_cfp
      c( 4, 1, 0, 4, 6) = -1.09955742875642763346192518414782601E0_cfp
      c( 0, 2, 0, 4, 6) = 1.66479866947652871378844609912381782E3_cfp
      c( 2, 2, 0, 4, 6) = 5.22289778659303125894414462470217354E1_cfp
      c( 4, 2, 0, 4, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 4, 6) = -2.95964207906938438006834862066456501E2_cfp
      c( 2, 3, 0, 4, 6) = -3.66519142918809211153975061382608670E0_cfp
      c( 0, 4, 0, 4, 6) = 2.61144889329651562947207231235108677E1_cfp
      c( 2, 4, 0, 4, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 4, 6) = -1.09955742875642763346192518414782601E0_cfp
      c( 0, 6, 0, 4, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 4, 6) = -1.44282551354632488528331995257397544E3_cfp
      c( 3, 0, 1, 4, 6) = -5.91928415813876876013669724132913002E1_cfp
      c( 5, 0, 1, 4, 6) = -1.57079632679489661923132169163975144E-1_cfp
      c( 1, 1, 1, 4, 6) = 1.10986577965101914252563073274921188E3_cfp
      c( 3, 1, 1, 4, 6) = 2.08915911463721250357765784988086942E1_cfp
      c( 5, 1, 1, 4, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 4, 6) = -2.95964207906938438006834862066456501E2_cfp
      c( 3, 2, 1, 4, 6) = -2.19911485751285526692385036829565202E0_cfp
      c( 1, 3, 1, 4, 6) = 3.48193185772868750596276308313478236E1_cfp
      c( 3, 3, 1, 4, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 4, 6) = -1.83259571459404605576987530691304335E0_cfp
      c( 1, 5, 1, 4, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 4, 6) = 2.21973155930203828505126146549842376E2_cfp
      c( 4, 0, 2, 4, 6) = 2.98451302091030357653951121411552774E0_cfp
      c( 6, 0, 2, 4, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 4, 6) = -1.18385683162775375202733944826582600E2_cfp
      c( 4, 1, 2, 4, 6) = -6.28318530717958647692528676655900577E-1_cfp
      c( 2, 2, 2, 4, 6) = 2.08915911463721250357765784988086942E1_cfp
      c( 4, 2, 2, 4, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 4, 6) = -1.46607657167523684461590024553043468E0_cfp
      c( 2, 4, 2, 4, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 4, 6) = -1.69122404518250536003905635466546572E1_cfp
      c( 5, 0, 3, 4, 6) = -6.98131700797731830769476307395445085E-2_cfp
      c( 3, 1, 3, 4, 6) = 5.96902604182060715307902242823105548E0_cfp
      c( 5, 1, 3, 4, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 4, 6) = -6.28318530717958647692528676655900577E-1_cfp
      c( 3, 3, 3, 4, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 4, 6) = 6.63225115757845239231002492025672831E-1_cfp
      c( 6, 0, 4, 4, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 4, 6) = -1.39626340159546366153895261479089017E-1_cfp
      c( 4, 2, 4, 4, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 4, 6) = -1.26933036508678514685359328617353652E-2_cfp
      c( 5, 1, 5, 4, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 4, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 5, 1) = 8.16814089933346242000287279652670750E1_cfp
      c( 0, 1, 0, 5, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 5, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 5, 2) = 3.06305283725004840750107729869751531E2_cfp
      c( 2, 0, 0, 5, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 5, 2) = -9.42477796076937971538793014983850865E1_cfp
      c( 0, 2, 0, 5, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 5, 2) = -3.14159265358979323846264338327950288E1_cfp
      c( 1, 1, 1, 5, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 5, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 5, 3) = 8.67864970554180382125305234630962672E2_cfp
      c( 2, 0, 0, 5, 3) = 1.78023583703421616846216458385838497E1_cfp
      c( 0, 1, 0, 5, 3) = -4.00553063332698637903987031368136618E2_cfp
      c( 2, 1, 0, 5, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 5, 3) = 5.34070751110264850538649375157515490E1_cfp
      c( 0, 3, 0, 5, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 5, 3) = -1.33517687777566212634662343789378873E2_cfp
      c( 3, 0, 1, 5, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 5, 3) = 3.56047167406843233692432916771676994E1_cfp
      c( 1, 2, 1, 5, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 5, 3) = 7.12094334813686467384865833543353987E0_cfp
      c( 2, 1, 2, 5, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 5, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 5, 4) = 2.06117930506617840754759993224853635E3_cfp
      c( 2, 0, 0, 5, 4) = 8.45612022591252680019528177332732860E1_cfp
      c( 4, 0, 0, 5, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 5, 4) = -1.26841803388687902002929226599909929E3_cfp
      c( 2, 1, 0, 5, 4) = -1.98967534727353571769300747607701849E1_cfp
      c( 0, 2, 0, 5, 4) = 2.53683606777375804005858453199819858E2_cfp
      c( 2, 2, 0, 5, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 5, 4) = -1.98967534727353571769300747607701849E1_cfp
      c( 0, 4, 0, 5, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 5, 4) = -4.22806011295626340009764088666366430E2_cfp
      c( 3, 0, 1, 5, 4) = -3.97935069454707143538601495215403699E0_cfp
      c( 1, 1, 1, 5, 4) = 1.69122404518250536003905635466546572E2_cfp
      c( 3, 1, 1, 5, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 5, 4) = -1.98967534727353571769300747607701849E1_cfp
      c( 1, 3, 1, 5, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 5, 4) = 3.38244809036501072007811270933093144E1_cfp
      c( 4, 0, 2, 5, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 5, 4) = -7.95870138909414287077202990430807397E0_cfp
      c( 2, 2, 2, 5, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 5, 4) = -1.13695734129916326725314712918686771E0_cfp
      c( 3, 1, 3, 5, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 5, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 5, 5) = 4.32847654063897465584995985772192633E3_cfp
      c( 2, 0, 0, 5, 5) = 2.95964207906938438006834862066456501E2_cfp
      c( 4, 0, 0, 5, 5) = 1.09955742875642763346192518414782601E0_cfp
      c( 0, 1, 0, 5, 5) = -3.32959733895305742757689219824763563E3_cfp
      c( 2, 1, 0, 5, 5) = -1.04457955731860625178882892494043471E2_cfp
      c( 4, 1, 0, 5, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 5, 5) = 8.87892623720815314020504586199369503E2_cfp
      c( 2, 2, 0, 5, 5) = 1.09955742875642763346192518414782601E1_cfp
      c( 0, 3, 0, 5, 5) = -1.04457955731860625178882892494043471E2_cfp
      c( 2, 3, 0, 5, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 5, 5) = 5.49778714378213816730962592073913005E0_cfp
      c( 0, 5, 0, 5, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 5, 5) = -1.10986577965101914252563073274921188E3_cfp
      c( 3, 0, 1, 5, 5) = -2.08915911463721250357765784988086942E1_cfp
      c( 5, 0, 1, 5, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 5, 5) = 5.91928415813876876013669724132913002E2_cfp
      c( 3, 1, 1, 5, 5) = 4.39822971502571053384770073659130404E0_cfp
      c( 1, 2, 1, 5, 5) = -1.04457955731860625178882892494043471E2_cfp
      c( 3, 2, 1, 5, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 5, 5) = 7.33038285837618422307950122765217340E0_cfp
      c( 1, 4, 1, 5, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 5, 5) = 1.18385683162775375202733944826582600E2_cfp
      c( 4, 0, 2, 5, 5) = 6.28318530717958647692528676655900577E-1_cfp
      c( 2, 1, 2, 5, 5) = -4.17831822927442500715531569976173884E1_cfp
      c( 4, 1, 2, 5, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 5, 5) = 4.39822971502571053384770073659130404E0_cfp
      c( 2, 3, 2, 5, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 5, 5) = -5.96902604182060715307902242823105548E0_cfp
      c( 5, 0, 3, 5, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 5, 5) = 1.25663706143591729538505735331180115E0_cfp
      c( 3, 2, 3, 5, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 5, 5) = 1.39626340159546366153895261479089017E-1_cfp
      c( 4, 1, 4, 5, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 5, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 5, 6) = 8.29624670289136809037908972730035879E3_cfp
      c( 2, 0, 0, 5, 6) = 8.50897097732448009269650228441062440E2_cfp
      c( 4, 0, 0, 5, 6) = 6.32245521534945889240606980884999955E0_cfp
      c( 6, 0, 0, 5, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 5, 6) = -7.65807387959203208342685205596956196E3_cfp
      c( 2, 1, 0, 5, 6) = -4.00422163638799063185717754560499972E2_cfp
      c( 4, 1, 0, 5, 6) = -1.20427718387608740807734663025714277E0_cfp
      c( 0, 2, 0, 5, 6) = 2.55269129319734402780895068532318732E3_cfp
      c( 2, 2, 0, 5, 6) = 6.32245521534945889240606980884999955E1_cfp
      c( 4, 2, 0, 5, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 5, 6) = -4.00422163638799063185717754560499972E2_cfp
      c( 2, 3, 0, 5, 6) = -4.01425727958695802692448876752380924E0_cfp
      c( 0, 4, 0, 5, 6) = 3.16122760767472944620303490442499978E1_cfp
      c( 2, 4, 0, 5, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 5, 6) = -1.20427718387608740807734663025714277E0_cfp
      c( 0, 6, 0, 5, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 5, 6) = -2.55269129319734402780895068532318732E3_cfp
      c( 3, 0, 1, 5, 6) = -8.00844327277598126371435509120999944E1_cfp
      c( 5, 0, 1, 5, 6) = -1.72039597696583915439620947179591825E-1_cfp
      c( 1, 1, 1, 5, 6) = 1.70179419546489601853930045688212488E3_cfp
      c( 3, 1, 1, 5, 6) = 2.52898208613978355696242792353999982E1_cfp
      c( 5, 1, 1, 5, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 5, 6) = -4.00422163638799063185717754560499972E2_cfp
      c( 3, 2, 1, 5, 6) = -2.40855436775217481615469326051428554E0_cfp
      c( 1, 3, 1, 5, 6) = 4.21497014356630592827071320589999970E1_cfp
      c( 3, 3, 1, 5, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 5, 6) = -2.00712863979347901346224438376190462E0_cfp
      c( 1, 5, 1, 5, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 5, 6) = 3.40358839092979203707860091376424976E2_cfp
      c( 4, 0, 2, 5, 6) = 3.61283155162826222423203989077142832E0_cfp
      c( 6, 0, 2, 5, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 5, 6) = -1.60168865455519625274287101824199989E2_cfp
      c( 4, 1, 2, 5, 6) = -6.88158390786335661758483788718367298E-1_cfp
      c( 2, 2, 2, 5, 6) = 2.52898208613978355696242792353999982E1_cfp
      c( 4, 2, 2, 5, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 5, 6) = -1.60570291183478321076979550700952370E0_cfp
      c( 2, 4, 2, 5, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 5, 6) = -2.28812664936456607534695859748857127E1_cfp
      c( 5, 0, 3, 5, 6) = -7.64620434207039624176093098575963665E-2_cfp
      c( 3, 1, 3, 5, 6) = 7.22566310325652444846407978154285663E0_cfp
      c( 5, 1, 3, 5, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 5, 6) = -6.88158390786335661758483788718367298E-1_cfp
      c( 3, 3, 3, 5, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 5, 6) = 8.02851455917391605384897753504761848E-1_cfp
      c( 6, 0, 4, 5, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 5, 6) = -1.52924086841407924835218619715192733E-1_cfp
      c( 4, 2, 4, 5, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 5, 6) = -1.39021897128552658941107836104720666E-2_cfp
      c( 5, 1, 5, 5, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 5, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 6, 1) = 9.42477796076937971538793014983850865E1_cfp
      c( 0, 1, 0, 6, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 6, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 6, 2) = 4.00553063332698637903987031368136618E2_cfp
      c( 2, 0, 0, 6, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 6, 2) = -1.06814150222052970107729875031503098E2_cfp
      c( 0, 2, 0, 6, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 6, 2) = -3.56047167406843233692432916771676994E1_cfp
      c( 1, 1, 1, 6, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 6, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 6, 3) = 1.26841803388687902002929226599909929E3_cfp
      c( 2, 0, 0, 6, 3) = 1.98967534727353571769300747607701849E1_cfp
      c( 0, 1, 0, 6, 3) = -5.07367213554751608011716906399639716E2_cfp
      c( 2, 1, 0, 6, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 6, 3) = 5.96902604182060715307902242823105548E1_cfp
      c( 0, 3, 0, 6, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 6, 3) = -1.69122404518250536003905635466546572E2_cfp
      c( 3, 0, 1, 6, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 6, 3) = 3.97935069454707143538601495215403699E1_cfp
      c( 1, 2, 1, 6, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 6, 3) = 7.95870138909414287077202990430807397E0_cfp
      c( 2, 1, 2, 6, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 6, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 6, 4) = 3.32959733895305742757689219824763563E3_cfp
      c( 2, 0, 0, 6, 4) = 1.04457955731860625178882892494043471E2_cfp
      c( 4, 0, 0, 6, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 6, 4) = -1.77578524744163062804100917239873901E3_cfp
      c( 2, 1, 0, 6, 4) = -2.19911485751285526692385036829565202E1_cfp
      c( 0, 2, 0, 6, 4) = 3.13373867195581875536648677482130413E2_cfp
      c( 2, 2, 0, 6, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 6, 4) = -2.19911485751285526692385036829565202E1_cfp
      c( 0, 4, 0, 6, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 6, 4) = -5.91928415813876876013669724132913002E2_cfp
      c( 3, 0, 1, 6, 4) = -4.39822971502571053384770073659130404E0_cfp
      c( 1, 1, 1, 6, 4) = 2.08915911463721250357765784988086942E2_cfp
      c( 3, 1, 1, 6, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 6, 4) = -2.19911485751285526692385036829565202E1_cfp
      c( 1, 3, 1, 6, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 6, 4) = 4.17831822927442500715531569976173884E1_cfp
      c( 4, 0, 2, 6, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 6, 4) = -8.79645943005142106769540147318260808E0_cfp
      c( 2, 2, 2, 6, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 6, 4) = -1.25663706143591729538505735331180115E0_cfp
      c( 3, 1, 3, 6, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 6, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 6, 5) = 7.65807387959203208342685205596956196E3_cfp
      c( 2, 0, 0, 6, 5) = 4.00422163638799063185717754560499972E2_cfp
      c( 4, 0, 0, 6, 5) = 1.20427718387608740807734663025714277E0_cfp
      c( 0, 1, 0, 6, 5) = -5.10538258639468805561790137064637464E3_cfp
      c( 2, 1, 0, 6, 5) = -1.26449104306989177848121396176999991E2_cfp
      c( 4, 1, 0, 6, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 6, 5) = 1.20126649091639718955715326368149992E3_cfp
      c( 2, 2, 0, 6, 5) = 1.20427718387608740807734663025714277E1_cfp
      c( 0, 3, 0, 6, 5) = -1.26449104306989177848121396176999991E2_cfp
      c( 2, 3, 0, 6, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 6, 5) = 6.02138591938043704038673315128571386E0_cfp
      c( 0, 5, 0, 6, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 6, 5) = -1.70179419546489601853930045688212488E3_cfp
      c( 3, 0, 1, 6, 5) = -2.52898208613978355696242792353999982E1_cfp
      c( 5, 0, 1, 6, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 6, 5) = 8.00844327277598126371435509120999944E2_cfp
      c( 3, 1, 1, 6, 5) = 4.81710873550434963230938652102857109E0_cfp
      c( 1, 2, 1, 6, 5) = -1.26449104306989177848121396176999991E2_cfp
      c( 3, 2, 1, 6, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 6, 5) = 8.02851455917391605384897753504761848E0_cfp
      c( 1, 4, 1, 6, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 6, 5) = 1.60168865455519625274287101824199989E2_cfp
      c( 4, 0, 2, 6, 5) = 6.88158390786335661758483788718367298E-1_cfp
      c( 2, 1, 2, 6, 5) = -5.05796417227956711392485584707999964E1_cfp
      c( 4, 1, 2, 6, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 6, 5) = 4.81710873550434963230938652102857109E0_cfp
      c( 2, 3, 2, 6, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 6, 5) = -7.22566310325652444846407978154285663E0_cfp
      c( 5, 0, 3, 6, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 6, 5) = 1.37631678157267132351696757743673460E0_cfp
      c( 3, 2, 3, 6, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 6, 5) = 1.52924086841407924835218619715192733E-1_cfp
      c( 4, 1, 4, 6, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 6, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 6, 6) = 1.59543205824834001738059417832699208E4_cfp
      c( 2, 0, 0, 6, 6) = 1.25131926137124707245536798300156241E3_cfp
      c( 4, 0, 0, 6, 6) = 7.52673239922554630048341643910714233E0_cfp
      c( 6, 0, 0, 6, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 6, 6) = -1.27634564659867201390447534266159366E4_cfp
      c( 2, 1, 0, 6, 6) = -5.26871267945788241033839150737499963E2_cfp
      c( 4, 1, 0, 6, 6) = -1.30899693899574718269276807636645954E0_cfp
      c( 0, 2, 0, 6, 6) = 3.75395778411374121736610394900468724E3_cfp
      c( 2, 2, 0, 6, 6) = 7.52673239922554630048341643910714233E1_cfp
      c( 4, 2, 0, 6, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 6, 6) = -5.26871267945788241033839150737499963E2_cfp
      c( 2, 3, 0, 6, 6) = -4.36332312998582394230922692122153178E0_cfp
      c( 0, 4, 0, 6, 6) = 3.76336619961277315024170821955357116E1_cfp
      c( 2, 4, 0, 6, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 6, 6) = -1.30899693899574718269276807636645954E0_cfp
      c( 0, 6, 0, 6, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 6, 6) = -4.25448548866224004634825114220531220E3_cfp
      c( 3, 0, 1, 6, 6) = -1.05374253589157648206767830147499993E2_cfp
      c( 5, 0, 1, 6, 6) = -1.86999562713678168956109725195208505E-1_cfp
      c( 1, 1, 1, 6, 6) = 2.50263852274249414491073596600312482E3_cfp
      c( 3, 1, 1, 6, 6) = 3.01069295969021852019336657564285693E1_cfp
      c( 5, 1, 1, 6, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 6, 6) = -5.26871267945788241033839150737499963E2_cfp
      c( 3, 2, 1, 6, 6) = -2.61799387799149436538553615273291907E0_cfp
      c( 1, 3, 1, 6, 6) = 5.01782159948369753365561095940476155E1_cfp
      c( 3, 3, 1, 6, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 6, 6) = -2.18166156499291197115461346061076589E0_cfp
      c( 1, 5, 1, 6, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 6, 6) = 5.00527704548498828982147193200624965E2_cfp
      c( 4, 0, 2, 6, 6) = 4.30098994241459788599052367948979562E0_cfp
      c( 6, 0, 2, 6, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 6, 6) = -2.10748507178315296413535660294999985E2_cfp
      c( 4, 1, 2, 6, 6) = -7.47998250854712675824438900780834020E-1_cfp
      c( 2, 2, 2, 6, 6) = 3.01069295969021852019336657564285693E1_cfp
      c( 4, 2, 2, 6, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 6, 6) = -1.74532925199432957692369076848861271E0_cfp
      c( 2, 4, 2, 6, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 6, 6) = -3.01069295969021852019336657564285693E1_cfp
      c( 5, 0, 3, 6, 6) = -8.31109167616347417582709889756482244E-2_cfp
      c( 3, 1, 3, 6, 6) = 8.60197988482919577198104735897959123E0_cfp
      c( 5, 1, 3, 6, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 6, 6) = -7.47998250854712675824438900780834020E-1_cfp
      c( 3, 3, 3, 6, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 6, 6) = 9.55775542758799530220116373219954581E-1_cfp
      c( 6, 0, 4, 6, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 6, 6) = -1.66221833523269483516541977951296449E-1_cfp
      c( 4, 2, 4, 6, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 6, 6) = -1.51110757748426803196856343592087681E-2_cfp
      c( 5, 1, 5, 6, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 6, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 7, 1) = 1.06814150222052970107729875031503098E2_cfp
      c( 0, 1, 0, 7, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 7, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 7, 2) = 5.07367213554751608011716906399639716E2_cfp
      c( 2, 0, 0, 7, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 7, 2) = -1.19380520836412143061580448564621110E2_cfp
      c( 0, 2, 0, 7, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 7, 2) = -3.97935069454707143538601495215403699E1_cfp
      c( 1, 1, 1, 7, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 7, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 7, 3) = 1.77578524744163062804100917239873901E3_cfp
      c( 2, 0, 0, 7, 3) = 2.19911485751285526692385036829565202E1_cfp
      c( 0, 1, 0, 7, 3) = -6.26747734391163751073297354964260825E2_cfp
      c( 2, 1, 0, 7, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 7, 3) = 6.59734457253856580077155110488695606E1_cfp
      c( 0, 3, 0, 7, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 7, 3) = -2.08915911463721250357765784988086942E2_cfp
      c( 3, 0, 1, 7, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 7, 3) = 4.39822971502571053384770073659130404E1_cfp
      c( 1, 2, 1, 7, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 7, 3) = 8.79645943005142106769540147318260808E0_cfp
      c( 2, 1, 2, 7, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 7, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 7, 4) = 5.10538258639468805561790137064637464E3_cfp
      c( 2, 0, 0, 7, 4) = 1.26449104306989177848121396176999991E2_cfp
      c( 4, 0, 0, 7, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 7, 4) = -2.40253298183279437911430652736299983E3_cfp
      c( 2, 1, 0, 7, 4) = -2.40855436775217481615469326051428554E1_cfp
      c( 0, 2, 0, 7, 4) = 3.79347312920967533544364188530999973E2_cfp
      c( 2, 2, 0, 7, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 7, 4) = -2.40855436775217481615469326051428554E1_cfp
      c( 0, 4, 0, 7, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 7, 4) = -8.00844327277598126371435509120999944E2_cfp
      c( 3, 0, 1, 7, 4) = -4.81710873550434963230938652102857109E0_cfp
      c( 1, 1, 1, 7, 4) = 2.52898208613978355696242792353999982E2_cfp
      c( 3, 1, 1, 7, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 7, 4) = -2.40855436775217481615469326051428554E1_cfp
      c( 1, 3, 1, 7, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 7, 4) = 5.05796417227956711392485584707999964E1_cfp
      c( 4, 0, 2, 7, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 7, 4) = -9.63421747100869926461877304205714218E0_cfp
      c( 2, 2, 2, 7, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 7, 4) = -1.37631678157267132351696757743673460E0_cfp
      c( 3, 1, 3, 7, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 7, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 7, 5) = 1.27634564659867201390447534266159366E4_cfp
      c( 2, 0, 0, 7, 5) = 5.26871267945788241033839150737499963E2_cfp
      c( 4, 0, 0, 7, 5) = 1.30899693899574718269276807636645954E0_cfp
      c( 0, 1, 0, 7, 5) = -7.50791556822748243473220789800937447E3_cfp
      c( 2, 1, 0, 7, 5) = -1.50534647984510926009668328782142847E2_cfp
      c( 4, 1, 0, 7, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 7, 5) = 1.58061380383736472310151745221249989E3_cfp
      c( 2, 2, 0, 7, 5) = 1.30899693899574718269276807636645954E1_cfp
      c( 0, 3, 0, 7, 5) = -1.50534647984510926009668328782142847E2_cfp
      c( 2, 3, 0, 7, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 7, 5) = 6.54498469497873591346384038183229768E0_cfp
      c( 0, 5, 0, 7, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 7, 5) = -2.50263852274249414491073596600312482E3_cfp
      c( 3, 0, 1, 7, 5) = -3.01069295969021852019336657564285693E1_cfp
      c( 5, 0, 1, 7, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 7, 5) = 1.05374253589157648206767830147499993E3_cfp
      c( 3, 1, 1, 7, 5) = 5.23598775598298873077107230546583814E0_cfp
      c( 1, 2, 1, 7, 5) = -1.50534647984510926009668328782142847E2_cfp
      c( 3, 2, 1, 7, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 7, 5) = 8.72664625997164788461845384244306357E0_cfp
      c( 1, 4, 1, 7, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 7, 5) = 2.10748507178315296413535660294999985E2_cfp
      c( 4, 0, 2, 7, 5) = 7.47998250854712675824438900780834020E-1_cfp
      c( 2, 1, 2, 7, 5) = -6.02138591938043704038673315128571386E1_cfp
      c( 4, 1, 2, 7, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 7, 5) = 5.23598775598298873077107230546583814E0_cfp
      c( 2, 3, 2, 7, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 7, 5) = -8.60197988482919577198104735897959123E0_cfp
      c( 5, 0, 3, 7, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 7, 5) = 1.49599650170942535164887780156166804E0_cfp
      c( 3, 2, 3, 7, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 7, 5) = 1.66221833523269483516541977951296449E-1_cfp
      c( 4, 1, 4, 7, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 7, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 7, 6) = 2.87177770484701203128506952098858574E4_cfp
      c( 2, 0, 0, 7, 6) = 1.77819052931703531348920713373906237E3_cfp
      c( 4, 0, 0, 7, 6) = 8.83572933822129348317618451547360186E0_cfp
      c( 6, 0, 0, 7, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 7, 6) = -2.02713720342142025737769613246253111E4_cfp
      c( 2, 1, 0, 7, 6) = -6.77405915930299167043507479519642809E2_cfp
      c( 4, 1, 0, 7, 6) = -1.41371669411540695730818952247577630E0_cfp
      c( 0, 2, 0, 7, 6) = 5.33457158795110594046762140121718712E3_cfp
      c( 2, 2, 0, 7, 6) = 8.83572933822129348317618451547360186E1_cfp
      c( 4, 2, 0, 7, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 7, 6) = -6.77405915930299167043507479519642809E2_cfp
      c( 2, 3, 0, 7, 6) = -4.71238898038468985769396507491925433E0_cfp
      c( 0, 4, 0, 7, 6) = 4.41786466911064674158809225773680093E1_cfp
      c( 2, 4, 0, 7, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 7, 6) = -1.41371669411540695730818952247577630E0_cfp
      c( 0, 6, 0, 7, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 7, 6) = -6.75712401140473419125898710820843702E3_cfp
      c( 3, 0, 1, 7, 6) = -1.35481183186059833408701495903928562E2_cfp
      c( 5, 0, 1, 7, 6) = -2.01959527730772422472598503210825185E-1_cfp
      c( 1, 1, 1, 7, 6) = 3.55638105863407062697841426747812475E3_cfp
      c( 3, 1, 1, 7, 6) = 3.53429173528851739327047380618944074E1_cfp
      c( 5, 1, 1, 7, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 7, 6) = -6.77405915930299167043507479519642809E2_cfp
      c( 3, 2, 1, 7, 6) = -2.82743338823081391461637904495155260E0_cfp
      c( 1, 3, 1, 7, 6) = 5.89048622548086232211745634364906791E1_cfp
      c( 3, 3, 1, 7, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 7, 6) = -2.35619449019234492884698253745962716E0_cfp
      c( 1, 5, 1, 7, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 7, 6) = 7.11276211726814125395682853495624950E2_cfp
      c( 4, 0, 2, 7, 6) = 5.04898819326931056181496258027062964E0_cfp
      c( 6, 0, 2, 7, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 7, 6) = -2.70962366372119666817402991807857124E2_cfp
      c( 4, 1, 2, 7, 6) = -8.07838110923089689890394012843300742E-1_cfp
      c( 2, 2, 2, 7, 6) = 3.53429173528851739327047380618944074E1_cfp
      c( 4, 2, 2, 7, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 7, 6) = -1.88495559215387594307758602996770173E0_cfp
      c( 2, 4, 2, 7, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 7, 6) = -3.87089094817313809739147131154081605E1_cfp
      c( 5, 0, 3, 7, 6) = -8.97597901025655210989326680937000824E-2_cfp
      c( 3, 1, 3, 7, 6) = 1.00979763865386211236299251605412593E1_cfp
      c( 5, 1, 3, 7, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 7, 6) = -8.07838110923089689890394012843300742E-1_cfp
      c( 3, 3, 3, 7, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 7, 6) = 1.12199737628206901373665835117125103E0_cfp
      c( 6, 0, 4, 7, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 7, 6) = -1.79519580205131042197865336187400165E-1_cfp
      c( 4, 2, 4, 7, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 7, 6) = -1.63199618368300947452604851079454695E-2_cfp
      c( 5, 1, 5, 7, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 7, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 8, 1) = 1.19380520836412143061580448564621110E2_cfp
      c( 0, 1, 0, 8, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 8, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 8, 2) = 6.26747734391163751073297354964260825E2_cfp
      c( 2, 0, 0, 8, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 8, 2) = -1.31946891450771316015431022097739121E2_cfp
      c( 0, 2, 0, 8, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 8, 2) = -4.39822971502571053384770073659130404E1_cfp
      c( 1, 1, 1, 8, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 8, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 8, 3) = 2.40253298183279437911430652736299983E3_cfp
      c( 2, 0, 0, 8, 3) = 2.40855436775217481615469326051428554E1_cfp
      c( 0, 1, 0, 8, 3) = -7.58694625841935067088728377061999947E2_cfp
      c( 2, 1, 0, 8, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 8, 3) = 7.22566310325652444846407978154285663E1_cfp
      c( 0, 3, 0, 8, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 8, 3) = -2.52898208613978355696242792353999982E2_cfp
      c( 3, 0, 1, 8, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 8, 3) = 4.81710873550434963230938652102857109E1_cfp
      c( 1, 2, 1, 8, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 8, 3) = 9.63421747100869926461877304205714218E0_cfp
      c( 2, 1, 2, 8, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 8, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 8, 4) = 7.50791556822748243473220789800937447E3_cfp
      c( 2, 0, 0, 8, 4) = 1.50534647984510926009668328782142847E2_cfp
      c( 4, 0, 0, 8, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 8, 4) = -3.16122760767472944620303490442499978E3_cfp
      c( 2, 1, 0, 8, 4) = -2.61799387799149436538553615273291907E1_cfp
      c( 0, 2, 0, 8, 4) = 4.51603943953532778029004986346428540E2_cfp
      c( 2, 2, 0, 8, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 8, 4) = -2.61799387799149436538553615273291907E1_cfp
      c( 0, 4, 0, 8, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 8, 4) = -1.05374253589157648206767830147499993E3_cfp
      c( 3, 0, 1, 8, 4) = -5.23598775598298873077107230546583814E0_cfp
      c( 1, 1, 1, 8, 4) = 3.01069295969021852019336657564285693E2_cfp
      c( 3, 1, 1, 8, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 8, 4) = -2.61799387799149436538553615273291907E1_cfp
      c( 1, 3, 1, 8, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 8, 4) = 6.02138591938043704038673315128571386E1_cfp
      c( 4, 0, 2, 8, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 8, 4) = -1.04719755119659774615421446109316763E1_cfp
      c( 2, 2, 2, 8, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 8, 4) = -1.49599650170942535164887780156166804E0_cfp
      c( 3, 1, 3, 8, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 8, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 8, 5) = 2.02713720342142025737769613246253111E4_cfp
      c( 2, 0, 0, 8, 5) = 6.77405915930299167043507479519642809E2_cfp
      c( 4, 0, 0, 8, 5) = 1.41371669411540695730818952247577630E0_cfp
      c( 0, 1, 0, 8, 5) = -1.06691431759022118809352428024343742E4_cfp
      c( 2, 1, 0, 8, 5) = -1.76714586764425869663523690309472037E2_cfp
      c( 4, 1, 0, 8, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 8, 5) = 2.03221774779089750113052243855892843E3_cfp
      c( 2, 2, 0, 8, 5) = 1.41371669411540695730818952247577630E1_cfp
      c( 0, 3, 0, 8, 5) = -1.76714586764425869663523690309472037E2_cfp
      c( 2, 3, 0, 8, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 8, 5) = 7.06858347057703478654094761237888149E0_cfp
      c( 0, 5, 0, 8, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 8, 5) = -3.55638105863407062697841426747812475E3_cfp
      c( 3, 0, 1, 8, 5) = -3.53429173528851739327047380618944074E1_cfp
      c( 5, 0, 1, 8, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 8, 5) = 1.35481183186059833408701495903928562E3_cfp
      c( 3, 1, 1, 8, 5) = 5.65486677646162782923275808990310519E0_cfp
      c( 1, 2, 1, 8, 5) = -1.76714586764425869663523690309472037E2_cfp
      c( 3, 2, 1, 8, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 8, 5) = 9.42477796076937971538793014983850865E0_cfp
      c( 1, 4, 1, 8, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 8, 5) = 2.70962366372119666817402991807857124E2_cfp
      c( 4, 0, 2, 8, 5) = 8.07838110923089689890394012843300742E-1_cfp
      c( 2, 1, 2, 8, 5) = -7.06858347057703478654094761237888149E1_cfp
      c( 4, 1, 2, 8, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 8, 5) = 5.65486677646162782923275808990310519E0_cfp
      c( 2, 3, 2, 8, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 8, 5) = -1.00979763865386211236299251605412593E1_cfp
      c( 5, 0, 3, 8, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 8, 5) = 1.61567622184617937978078802568660148E0_cfp
      c( 3, 2, 3, 8, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 8, 5) = 1.79519580205131042197865336187400165E-1_cfp
      c( 4, 1, 4, 8, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 8, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 8, 6) = 4.89891490826843228866276565345111684E4_cfp
      c( 2, 0, 0, 8, 6) = 2.45559644524733448053271461325870518E3_cfp
      c( 4, 0, 0, 8, 6) = 1.02494460323367004404843740379493782E1_cfp
      c( 6, 0, 0, 8, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 8, 6) = -3.09405152101164144547122041270596853E4_cfp
      c( 2, 1, 0, 8, 6) = -8.54120502694725036707031169829114847E2_cfp
      c( 4, 1, 0, 8, 6) = -1.51843644923506673192361096858509306E0_cfp
      c( 0, 2, 0, 8, 6) = 7.36678933574200344159814383977611555E3_cfp
      c( 2, 2, 0, 8, 6) = 1.02494460323367004404843740379493782E2_cfp
      c( 4, 2, 0, 8, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 8, 6) = -8.54120502694725036707031169829114847E2_cfp
      c( 2, 3, 0, 8, 6) = -5.06145483078355577307870322861697687E0_cfp
      c( 0, 4, 0, 8, 6) = 5.12472301616835022024218701897468908E1_cfp
      c( 2, 4, 0, 8, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 8, 6) = -1.51843644923506673192361096858509306E0_cfp
      c( 0, 6, 0, 8, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 8, 6) = -1.03135050700388048182374013756865618E4_cfp
      c( 3, 0, 1, 8, 6) = -1.70824100538945007341406233965822969E2_cfp
      c( 5, 0, 1, 8, 6) = -2.16919492747866675989087281226441866E-1_cfp
      c( 1, 1, 1, 8, 6) = 4.91119289049466896106542922651741037E3_cfp
      c( 3, 1, 1, 8, 6) = 4.09977841293468017619374961517975126E1_cfp
      c( 5, 1, 1, 8, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 8, 6) = -8.54120502694725036707031169829114847E2_cfp
      c( 3, 2, 1, 8, 6) = -3.03687289847013346384722193717018612E0_cfp
      c( 1, 3, 1, 8, 6) = 6.83296402155780029365624935863291877E1_cfp
      c( 3, 3, 1, 8, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 8, 6) = -2.53072741539177788653935161430848843E0_cfp
      c( 1, 5, 1, 8, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 8, 6) = 9.82238578098933792213085845303482074E2_cfp
      c( 4, 0, 2, 8, 6) = 5.85682630419240025170535659311393038E0_cfp
      c( 6, 0, 2, 8, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 8, 6) = -3.41648201077890014682812467931645939E2_cfp
      c( 4, 1, 2, 8, 6) = -8.67677970991466703956349124905767463E-1_cfp
      c( 2, 2, 2, 8, 6) = 4.09977841293468017619374961517975126E1_cfp
      c( 4, 2, 2, 8, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 8, 6) = -2.02458193231342230923148129144679075E0_cfp
      c( 2, 4, 2, 8, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 8, 6) = -4.88068858682700020975446382759494198E1_cfp
      c( 5, 0, 3, 8, 6) = -9.64086634434963004395943472117519404E-2_cfp
      c( 3, 1, 3, 8, 6) = 1.17136526083848005034107131862278608E1_cfp
      c( 5, 1, 3, 8, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 8, 6) = -8.67677970991466703956349124905767463E-1_cfp
      c( 3, 3, 3, 8, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 8, 6) = 1.30151695648720005593452368735865119E0_cfp
      c( 6, 0, 4, 8, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 8, 6) = -1.92817326886992600879188694423503881E-1_cfp
      c( 4, 2, 4, 8, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 8, 6) = -1.75288478988175091708353358566821710E-2_cfp
      c( 5, 1, 5, 8, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 8, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 9, 1) = 1.31946891450771316015431022097739121E2_cfp
      c( 0, 1, 0, 9, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 9, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 9, 2) = 7.58694625841935067088728377061999947E2_cfp
      c( 2, 0, 0, 9, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 9, 2) = -1.44513262065130488969281595630857133E2_cfp
      c( 0, 2, 0, 9, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 9, 2) = -4.81710873550434963230938652102857109E1_cfp
      c( 1, 1, 1, 9, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 9, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 9, 3) = 3.16122760767472944620303490442499978E3_cfp
      c( 2, 0, 0, 9, 3) = 2.61799387799149436538553615273291907E1_cfp
      c( 0, 1, 0, 9, 3) = -9.03207887907065556058009972692857079E2_cfp
      c( 2, 1, 0, 9, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 9, 3) = 7.85398163397448309615660845819875721E1_cfp
      c( 0, 3, 0, 9, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 9, 3) = -3.01069295969021852019336657564285693E2_cfp
      c( 3, 0, 1, 9, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 9, 3) = 5.23598775598298873077107230546583814E1_cfp
      c( 1, 2, 1, 9, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 9, 3) = 1.04719755119659774615421446109316763E1_cfp
      c( 2, 1, 2, 9, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 9, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 9, 4) = 1.06691431759022118809352428024343742E4_cfp
      c( 2, 0, 0, 9, 4) = 1.76714586764425869663523690309472037E2_cfp
      c( 4, 0, 0, 9, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 9, 4) = -4.06443549558179500226104487711785686E3_cfp
      c( 2, 1, 0, 9, 4) = -2.82743338823081391461637904495155260E1_cfp
      c( 0, 2, 0, 9, 4) = 5.30143760293277608990571070928416112E2_cfp
      c( 2, 2, 0, 9, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 9, 4) = -2.82743338823081391461637904495155260E1_cfp
      c( 0, 4, 0, 9, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 9, 4) = -1.35481183186059833408701495903928562E3_cfp
      c( 3, 0, 1, 9, 4) = -5.65486677646162782923275808990310519E0_cfp
      c( 1, 1, 1, 9, 4) = 3.53429173528851739327047380618944074E2_cfp
      c( 3, 1, 1, 9, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 9, 4) = -2.82743338823081391461637904495155260E1_cfp
      c( 1, 3, 1, 9, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 9, 4) = 7.06858347057703478654094761237888149E1_cfp
      c( 4, 0, 2, 9, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 9, 4) = -1.13097335529232556584655161798062104E1_cfp
      c( 2, 2, 2, 9, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 9, 4) = -1.61567622184617937978078802568660148E0_cfp
      c( 3, 1, 3, 9, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 9, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 9, 5) = 3.09405152101164144547122041270596853E4_cfp
      c( 2, 0, 0, 9, 5) = 8.54120502694725036707031169829114847E2_cfp
      c( 4, 0, 0, 9, 5) = 1.51843644923506673192361096858509306E0_cfp
      c( 0, 1, 0, 9, 5) = -1.47335786714840068831962876795522311E4_cfp
      c( 2, 1, 0, 9, 5) = -2.04988920646734008809687480758987563E2_cfp
      c( 4, 1, 0, 9, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 9, 5) = 2.56236150808417511012109350948734454E3_cfp
      c( 2, 2, 0, 9, 5) = 1.51843644923506673192361096858509306E1_cfp
      c( 0, 3, 0, 9, 5) = -2.04988920646734008809687480758987563E2_cfp
      c( 2, 3, 0, 9, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 9, 5) = 7.59218224617533365961805484292546530E0_cfp
      c( 0, 5, 0, 9, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 9, 5) = -4.91119289049466896106542922651741037E3_cfp
      c( 3, 0, 1, 9, 5) = -4.09977841293468017619374961517975126E1_cfp
      c( 5, 0, 1, 9, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 9, 5) = 1.70824100538945007341406233965822969E3_cfp
      c( 3, 1, 1, 9, 5) = 6.07374579694026692769444387434037224E0_cfp
      c( 1, 2, 1, 9, 5) = -2.04988920646734008809687480758987563E2_cfp
      c( 3, 2, 1, 9, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 9, 5) = 1.01229096615671115461574064572339537E1_cfp
      c( 1, 4, 1, 9, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 9, 5) = 3.41648201077890014682812467931645939E2_cfp
      c( 4, 0, 2, 9, 5) = 8.67677970991466703956349124905767463E-1_cfp
      c( 2, 1, 2, 9, 5) = -8.19955682586936035238749923035950253E1_cfp
      c( 4, 1, 2, 9, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 9, 5) = 6.07374579694026692769444387434037224E0_cfp
      c( 2, 3, 2, 9, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 9, 5) = -1.17136526083848005034107131862278608E1_cfp
      c( 5, 0, 3, 9, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 9, 5) = 1.73535594198293340791269824981153493E0_cfp
      c( 3, 2, 3, 9, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 9, 5) = 1.92817326886992600879188694423503881E-1_cfp
      c( 4, 1, 4, 9, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 9, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 9, 6) = 7.99296642928007373413398606615708537E4_cfp
      c( 2, 0, 0, 9, 6) = 3.30971694794205951723974578308782003E3_cfp
      c( 4, 0, 0, 9, 6) = 1.17678824815717671724079850065344712E1_cfp
      c( 6, 0, 0, 9, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 9, 6) = -4.56740938816004213379084918066119164E4_cfp
      c( 2, 1, 0, 9, 6) = -1.05910942334145904551671865058810241E3_cfp
      c( 4, 1, 0, 9, 6) = -1.62315620435472650653903241469440982E0_cfp
      c( 0, 2, 0, 9, 6) = 9.92915084382617855171923734926346009E3_cfp
      c( 2, 2, 0, 9, 6) = 1.17678824815717671724079850065344712E2_cfp
      c( 4, 2, 0, 9, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 9, 6) = -1.05910942334145904551671865058810241E3_cfp
      c( 2, 3, 0, 9, 6) = -5.41052068118242168846344138231469941E0_cfp
      c( 0, 4, 0, 9, 6) = 5.88394124078588358620399250326723561E1_cfp
      c( 2, 4, 0, 9, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 9, 6) = -1.62315620435472650653903241469440982E0_cfp
      c( 0, 6, 0, 9, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 9, 6) = -1.52246979605334737793028306022039721E4_cfp
      c( 3, 0, 1, 9, 6) = -2.11821884668291809103343730117620482E2_cfp
      c( 5, 0, 1, 9, 6) = -2.31879457764960929505576059242058546E-1_cfp
      c( 1, 1, 1, 9, 6) = 6.61943389588411903447949156617564006E3_cfp
      c( 3, 1, 1, 9, 6) = 4.70715299262870686896319400261378849E1_cfp
      c( 5, 1, 1, 9, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 9, 6) = -1.05910942334145904551671865058810241E3_cfp
      c( 3, 2, 1, 9, 6) = -3.24631240870945301307806482938881965E0_cfp
      c( 1, 3, 1, 9, 6) = 7.84525498771451144827199000435631415E1_cfp
      c( 3, 3, 1, 9, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 9, 6) = -2.70526034059121084423172069115734971E0_cfp
      c( 1, 5, 1, 9, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 9, 6) = 1.32388677917682380689589831323512801E3_cfp
      c( 4, 0, 2, 9, 6) = 6.72450427518386695566170571801969784E0_cfp
      c( 6, 0, 2, 9, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 9, 6) = -4.23643769336583618206687460235240964E2_cfp
      c( 4, 1, 2, 9, 6) = -9.27517831059843718022304236968234185E-1_cfp
      c( 2, 2, 2, 9, 6) = 4.70715299262870686896319400261378849E1_cfp
      c( 4, 2, 2, 9, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 9, 6) = -2.16420827247296867538537655292587976E0_cfp
      c( 2, 4, 2, 9, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 9, 6) = -6.05205384766548026009553514621772806E1_cfp
      c( 5, 0, 3, 9, 6) = -1.03057536784427079780256026329803798E-1_cfp
      c( 3, 1, 3, 9, 6) = 1.34490085503677339113234114360393957E1_cfp
      c( 5, 1, 3, 9, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 9, 6) = -9.27517831059843718022304236968234185E-1_cfp
      c( 3, 3, 3, 9, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 9, 6) = 1.49433428337419265681371238178215508E0_cfp
      c( 6, 0, 4, 9, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 9, 6) = -2.06115073568854159560512052659607597E-1_cfp
      c( 4, 2, 4, 9, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 9, 6) = -1.87377339608049235964101866054188724E-2_cfp
      c( 5, 1, 5, 9, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 9, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 10, 1) = 1.44513262065130488969281595630857133E2_cfp
      c( 0, 1, 0, 10, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 10, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 10, 2) = 9.03207887907065556058009972692857079E2_cfp
      c( 2, 0, 0, 10, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 10, 2) = -1.57079632679489661923132169163975144E2_cfp
      c( 0, 2, 0, 10, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 10, 2) = -5.23598775598298873077107230546583814E1_cfp
      c( 1, 1, 1, 10, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 10, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 10, 3) = 4.06443549558179500226104487711785686E3_cfp
      c( 2, 0, 0, 10, 3) = 2.82743338823081391461637904495155260E1_cfp
      c( 0, 1, 0, 10, 3) = -1.06028752058655521798114214185683222E3_cfp
      c( 2, 1, 0, 10, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 10, 3) = 8.48230016469244174384913713485465779E1_cfp
      c( 0, 3, 0, 10, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 10, 3) = -3.53429173528851739327047380618944074E2_cfp
      c( 3, 0, 1, 10, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 10, 3) = 5.65486677646162782923275808990310519E1_cfp
      c( 1, 2, 1, 10, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 10, 3) = 1.13097335529232556584655161798062104E1_cfp
      c( 2, 1, 2, 10, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 10, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 10, 4) = 1.47335786714840068831962876795522311E4_cfp
      c( 2, 0, 0, 10, 4) = 2.04988920646734008809687480758987563E2_cfp
      c( 4, 0, 0, 10, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 10, 4) = -5.12472301616835022024218701897468908E3_cfp
      c( 2, 1, 0, 10, 4) = -3.03687289847013346384722193717018612E1_cfp
      c( 0, 2, 0, 10, 4) = 6.14966761940202026429062442276962690E2_cfp
      c( 2, 2, 0, 10, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 10, 4) = -3.03687289847013346384722193717018612E1_cfp
      c( 0, 4, 0, 10, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 10, 4) = -1.70824100538945007341406233965822969E3_cfp
      c( 3, 0, 1, 10, 4) = -6.07374579694026692769444387434037224E0_cfp
      c( 1, 1, 1, 10, 4) = 4.09977841293468017619374961517975126E2_cfp
      c( 3, 1, 1, 10, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 10, 4) = -3.03687289847013346384722193717018612E1_cfp
      c( 1, 3, 1, 10, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 10, 4) = 8.19955682586936035238749923035950253E1_cfp
      c( 4, 0, 2, 10, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 10, 4) = -1.21474915938805338553888877486807445E1_cfp
      c( 2, 2, 2, 10, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 10, 4) = -1.73535594198293340791269824981153493E0_cfp
      c( 3, 1, 3, 10, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 10, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 10, 5) = 4.56740938816004213379084918066119164E4_cfp
      c( 2, 0, 0, 10, 5) = 1.05910942334145904551671865058810241E3_cfp
      c( 4, 0, 0, 10, 5) = 1.62315620435472650653903241469440982E0_cfp
      c( 0, 1, 0, 10, 5) = -1.98583016876523571034384746985269202E4_cfp
      c( 2, 1, 0, 10, 5) = -2.35357649631435343448159700130689424E2_cfp
      c( 4, 1, 0, 10, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 10, 5) = 3.17732827002437713655015595176430723E3_cfp
      c( 2, 2, 0, 10, 5) = 1.62315620435472650653903241469440982E1_cfp
      c( 0, 3, 0, 10, 5) = -2.35357649631435343448159700130689424E2_cfp
      c( 2, 3, 0, 10, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 10, 5) = 8.11578102177363253269516207347204912E0_cfp
      c( 0, 5, 0, 10, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 10, 5) = -6.61943389588411903447949156617564006E3_cfp
      c( 3, 0, 1, 10, 5) = -4.70715299262870686896319400261378849E1_cfp
      c( 5, 0, 1, 10, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 10, 5) = 2.11821884668291809103343730117620482E3_cfp
      c( 3, 1, 1, 10, 5) = 6.49262481741890602615612965877763929E0_cfp
      c( 1, 2, 1, 10, 5) = -2.35357649631435343448159700130689424E2_cfp
      c( 3, 2, 1, 10, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 10, 5) = 1.08210413623648433769268827646293988E1_cfp
      c( 1, 4, 1, 10, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 10, 5) = 4.23643769336583618206687460235240964E2_cfp
      c( 4, 0, 2, 10, 5) = 9.27517831059843718022304236968234185E-1_cfp
      c( 2, 1, 2, 10, 5) = -9.41430598525741373792638800522757698E1_cfp
      c( 4, 1, 2, 10, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 10, 5) = 6.49262481741890602615612965877763929E0_cfp
      c( 2, 3, 2, 10, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 10, 5) = -1.34490085503677339113234114360393957E1_cfp
      c( 5, 0, 3, 10, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 10, 5) = 1.85503566211968743604460847393646837E0_cfp
      c( 3, 2, 3, 10, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 10, 5) = 2.06115073568854159560512052659607597E-1_cfp
      c( 4, 1, 4, 10, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 10, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 10, 6) = 1.25603758174401158679248352468182770E5_cfp
      c( 2, 0, 0, 10, 6) = 4.36882637128351856275646443367592244E3_cfp
      c( 4, 0, 0, 10, 6) = 1.33910386859264936789470174212288810E1_cfp
      c( 6, 0, 0, 10, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 10, 6) = -6.55323955692527784413469665051388366E4_cfp
      c( 2, 1, 0, 10, 6) = -1.29446707297289438896487835071879183E3_cfp
      c( 4, 1, 0, 10, 6) = -1.72787595947438628115445386080372659E0_cfp
      c( 0, 2, 0, 10, 6) = 1.31064791138505556882693933010277673E4_cfp
      c( 2, 2, 0, 10, 6) = 1.33910386859264936789470174212288810E2_cfp
      c( 4, 2, 0, 10, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 10, 6) = -1.29446707297289438896487835071879183E3_cfp
      c( 2, 3, 0, 10, 6) = -5.75958653158128760384817953601242195E0_cfp
      c( 0, 4, 0, 10, 6) = 6.69551934296324683947350871061444052E1_cfp
      c( 2, 4, 0, 10, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 10, 6) = -1.72787595947438628115445386080372659E0_cfp
      c( 0, 6, 0, 10, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 10, 6) = -2.18441318564175928137823221683796122E4_cfp
      c( 3, 0, 1, 10, 6) = -2.58893414594578877792975670143758367E2_cfp
      c( 5, 0, 1, 10, 6) = -2.46839422782055183022064837257675227E-1_cfp
      c( 1, 1, 1, 10, 6) = 8.73765274256703712551292886735184488E3_cfp
      c( 3, 1, 1, 10, 6) = 5.35641547437059747157880696849155242E1_cfp
      c( 5, 1, 1, 10, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 10, 6) = -1.29446707297289438896487835071879183E3_cfp
      c( 3, 2, 1, 10, 6) = -3.45575191894877256230890772160745317E0_cfp
      c( 1, 3, 1, 10, 6) = 8.92735912395099578596467828081925403E1_cfp
      c( 3, 3, 1, 10, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 10, 6) = -2.87979326579064380192408976800621098E0_cfp
      c( 1, 5, 1, 10, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 10, 6) = 1.74753054851340742510258577347036898E3_cfp
      c( 4, 0, 2, 10, 6) = 7.65202210624371067368400995498793203E0_cfp
      c( 6, 0, 2, 10, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 10, 6) = -5.17786829189157755585951340287516734E2_cfp
      c( 4, 1, 2, 10, 6) = -9.87357691128220732088259349030700906E-1_cfp
      c( 2, 2, 2, 10, 6) = 5.35641547437059747157880696849155242E1_cfp
      c( 4, 2, 2, 10, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 10, 6) = -2.30383461263251504153927181440496878E0_cfp
      c( 2, 4, 2, 10, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 10, 6) = -7.39695470270225365122787628982166762E1_cfp
      c( 5, 0, 3, 10, 6) = -1.09706410125357859120917705447855656E-1_cfp
      c( 3, 1, 3, 10, 6) = 1.53040442124874213473680199099758641E1_cfp
      c( 5, 1, 3, 10, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 10, 6) = -9.87357691128220732088259349030700906E-1_cfp
      c( 3, 3, 3, 10, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 10, 6) = 1.70044935694304681637422443444176267E0_cfp
      c( 6, 0, 4, 10, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 10, 6) = -2.19412820250715718241835410895711313E-1_cfp
      c( 4, 2, 4, 10, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 10, 6) = -1.99466200227923380219850373541555739E-2_cfp
      c( 5, 1, 5, 10, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 10, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 11, 1) = 1.57079632679489661923132169163975144E2_cfp
      c( 0, 1, 0, 11, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 11, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 11, 2) = 1.06028752058655521798114214185683222E3_cfp
      c( 2, 0, 0, 11, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 11, 2) = -1.69646003293848834876982742697093156E2_cfp
      c( 0, 2, 0, 11, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 11, 2) = -5.65486677646162782923275808990310519E1_cfp
      c( 1, 1, 1, 11, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 11, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 11, 3) = 5.12472301616835022024218701897468908E3_cfp
      c( 2, 0, 0, 11, 3) = 3.03687289847013346384722193717018612E1_cfp
      c( 0, 1, 0, 11, 3) = -1.22993352388040405285812488455392538E3_cfp
      c( 2, 1, 0, 11, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 11, 3) = 9.11061869541040039154166581151055836E1_cfp
      c( 0, 3, 0, 11, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 11, 3) = -4.09977841293468017619374961517975126E2_cfp
      c( 3, 0, 1, 11, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 11, 3) = 6.07374579694026692769444387434037224E1_cfp
      c( 1, 2, 1, 11, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 11, 3) = 1.21474915938805338553888877486807445E1_cfp
      c( 2, 1, 2, 11, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 11, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 11, 4) = 1.98583016876523571034384746985269202E4_cfp
      c( 2, 0, 0, 11, 4) = 2.35357649631435343448159700130689424E2_cfp
      c( 4, 0, 0, 11, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 11, 4) = -6.35465654004875427310031190352861446E3_cfp
      c( 2, 1, 0, 11, 4) = -3.24631240870945301307806482938881965E1_cfp
      c( 0, 2, 0, 11, 4) = 7.06072948894306030344479100392068273E2_cfp
      c( 2, 2, 0, 11, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 11, 4) = -3.24631240870945301307806482938881965E1_cfp
      c( 0, 4, 0, 11, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 11, 4) = -2.11821884668291809103343730117620482E3_cfp
      c( 3, 0, 1, 11, 4) = -6.49262481741890602615612965877763929E0_cfp
      c( 1, 1, 1, 11, 4) = 4.70715299262870686896319400261378849E2_cfp
      c( 3, 1, 1, 11, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 11, 4) = -3.24631240870945301307806482938881965E1_cfp
      c( 1, 3, 1, 11, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 11, 4) = 9.41430598525741373792638800522757698E1_cfp
      c( 4, 0, 2, 11, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 11, 4) = -1.29852496348378120523122593175552786E1_cfp
      c( 2, 2, 2, 11, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 11, 4) = -1.85503566211968743604460847393646837E0_cfp
      c( 3, 1, 3, 11, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 11, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 11, 5) = 6.55323955692527784413469665051388366E4_cfp
      c( 2, 0, 0, 11, 5) = 1.29446707297289438896487835071879183E3_cfp
      c( 4, 0, 0, 11, 5) = 1.72787595947438628115445386080372659E0_cfp
      c( 0, 1, 0, 11, 5) = -2.62129582277011113765387866020555346E4_cfp
      c( 2, 1, 0, 11, 5) = -2.67820773718529873578940348424577621E2_cfp
      c( 4, 1, 0, 11, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 11, 5) = 3.88340121891868316689463505215637550E3_cfp
      c( 2, 2, 0, 11, 5) = 1.72787595947438628115445386080372659E1_cfp
      c( 0, 3, 0, 11, 5) = -2.67820773718529873578940348424577621E2_cfp
      c( 2, 3, 0, 11, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 11, 5) = 8.63937979737193140577226930401863293E0_cfp
      c( 0, 5, 0, 11, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 11, 5) = -8.73765274256703712551292886735184488E3_cfp
      c( 3, 0, 1, 11, 5) = -5.35641547437059747157880696849155242E1_cfp
      c( 5, 0, 1, 11, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 11, 5) = 2.58893414594578877792975670143758367E3_cfp
      c( 3, 1, 1, 11, 5) = 6.91150383789754512461781544321490635E0_cfp
      c( 1, 2, 1, 11, 5) = -2.67820773718529873578940348424577621E2_cfp
      c( 3, 2, 1, 11, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 11, 5) = 1.15191730631625752076963590720248439E1_cfp
      c( 1, 4, 1, 11, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 11, 5) = 5.17786829189157755585951340287516734E2_cfp
      c( 4, 0, 2, 11, 5) = 9.87357691128220732088259349030700906E-1_cfp
      c( 2, 1, 2, 11, 5) = -1.07128309487411949431576139369831048E2_cfp
      c( 4, 1, 2, 11, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 11, 5) = 6.91150383789754512461781544321490635E0_cfp
      c( 2, 3, 2, 11, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 11, 5) = -1.53040442124874213473680199099758641E1_cfp
      c( 5, 0, 3, 11, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 11, 5) = 1.97471538225644146417651869806140181E0_cfp
      c( 3, 2, 3, 11, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 11, 5) = 2.19412820250715718241835410895711313E-1_cfp
      c( 4, 1, 4, 11, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 11, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 11, 6) = 1.91136153743653937120595318973321607E5_cfp
      c( 2, 0, 0, 11, 6) = 5.66329344425641295172134278439471427E3_cfp
      c( 4, 0, 0, 11, 6) = 1.51189146454008799601014712820326076E1_cfp
      c( 6, 0, 0, 11, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 11, 6) = -9.17453537969538898178857531071943713E4_cfp
      c( 2, 1, 0, 11, 6) = -1.56228784669142426254381869914336946E3_cfp
      c( 4, 1, 0, 11, 6) = -1.83259571459404605576987530691304335E0_cfp
      c( 0, 2, 0, 11, 6) = 1.69898803327692388551640283531841428E4_cfp
      c( 2, 2, 0, 11, 6) = 1.51189146454008799601014712820326076E2_cfp
      c( 4, 2, 0, 11, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 11, 6) = -1.56228784669142426254381869914336946E3_cfp
      c( 2, 3, 0, 11, 6) = -6.10865238198015351923291768971014450E0_cfp
      c( 0, 4, 0, 11, 6) = 7.55945732270043998005073564101630382E1_cfp
      c( 2, 4, 0, 11, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 11, 6) = -1.83259571459404605576987530691304335E0_cfp
      c( 0, 6, 0, 11, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 11, 6) = -3.05817845989846299392952510357314571E4_cfp
      c( 3, 0, 1, 11, 6) = -3.12457569338284852508763739828673891E2_cfp
      c( 5, 0, 1, 11, 6) = -2.61799387799149436538553615273291907E-1_cfp
      c( 1, 1, 1, 11, 6) = 1.13265868885128259034426855687894285E4_cfp
      c( 3, 1, 1, 11, 6) = 6.04756585816035198404058851281304305E1_cfp
      c( 5, 1, 1, 11, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 11, 6) = -1.56228784669142426254381869914336946E3_cfp
      c( 3, 2, 1, 11, 6) = -3.66519142918809211153975061382608670E0_cfp
      c( 1, 3, 1, 11, 6) = 1.00792764302672533067343141880217384E2_cfp
      c( 3, 3, 1, 11, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 11, 6) = -3.05432619099007675961645884485507225E0_cfp
      c( 1, 5, 1, 11, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 11, 6) = 2.26531737770256518068853711375788571E3_cfp
      c( 4, 0, 2, 11, 6) = 8.63937979737193140577226930401863293E0_cfp
      c( 6, 0, 2, 11, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 11, 6) = -6.24915138676569705017527479657347782E2_cfp
      c( 4, 1, 2, 11, 6) = -1.04719755119659774615421446109316763E0_cfp
      c( 2, 2, 2, 11, 6) = 6.04756585816035198404058851281304305E1_cfp
      c( 4, 2, 2, 11, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 11, 6) = -2.44346095279206140769316707588405780E0_cfp
      c( 2, 4, 2, 11, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 11, 6) = -8.92735912395099578596467828081925403E1_cfp
      c( 5, 0, 3, 11, 6) = -1.16355283466288638461579384565907514E-1_cfp
      c( 3, 1, 3, 11, 6) = 1.72787595947438628115445386080372659E1_cfp
      c( 5, 1, 3, 11, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 11, 6) = -1.04719755119659774615421446109316763E0_cfp
      c( 3, 3, 3, 11, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 11, 6) = 1.91986217719376253461605984533747398E0_cfp
      c( 6, 0, 4, 11, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 11, 6) = -2.32710566932577276923158769131815028E-1_cfp
      c( 4, 2, 4, 11, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 11, 6) = -2.11555060847797524475598881028922753E-2_cfp
      c( 5, 1, 5, 11, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 11, 6) = 9.29912355374934173519115960566693420E-5_cfp
      c( 0, 0, 0, 12, 1) = 1.69646003293848834876982742697093156E2_cfp
      c( 0, 1, 0, 12, 1) = -1.25663706143591729538505735331180115E1_cfp
      c( 1, 0, 1, 12, 1) = -4.18879020478639098461685784437267051E0_cfp
      c( 0, 0, 0, 12, 2) = 1.22993352388040405285812488455392538E3_cfp
      c( 2, 0, 0, 12, 2) = 2.09439510239319549230842892218633526E0_cfp
      c( 0, 1, 0, 12, 2) = -1.82212373908208007830833316230211167E2_cfp
      c( 0, 2, 0, 12, 2) = 6.28318530717958647692528676655900577E0_cfp
      c( 1, 0, 1, 12, 2) = -6.07374579694026692769444387434037224E1_cfp
      c( 1, 1, 1, 12, 2) = 4.18879020478639098461685784437267051E0_cfp
      c( 2, 0, 2, 12, 2) = 8.37758040957278196923371568874534102E-1_cfp
      c( 0, 0, 0, 12, 3) = 6.35465654004875427310031190352861446E3_cfp
      c( 2, 0, 0, 12, 3) = 3.24631240870945301307806482938881965E1_cfp
      c( 0, 1, 0, 12, 3) = -1.41214589778861206068895820078413655E3_cfp
      c( 2, 1, 0, 12, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 0, 2, 0, 12, 3) = 9.73893722612835903923419448816645894E1_cfp
      c( 0, 3, 0, 12, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 1, 0, 1, 12, 3) = -4.70715299262870686896319400261378849E2_cfp
      c( 3, 0, 1, 12, 3) = -4.18879020478639098461685784437267051E-1_cfp
      c( 1, 1, 1, 12, 3) = 6.49262481741890602615612965877763929E1_cfp
      c( 1, 2, 1, 12, 3) = -2.09439510239319549230842892218633526E0_cfp
      c( 2, 0, 2, 12, 3) = 1.29852496348378120523122593175552786E1_cfp
      c( 2, 1, 2, 12, 3) = -8.37758040957278196923371568874534102E-1_cfp
      c( 3, 0, 3, 12, 3) = -1.19679720136754028131910224124933443E-1_cfp
      c( 0, 0, 0, 12, 4) = 2.62129582277011113765387866020555346E4_cfp
      c( 2, 0, 0, 12, 4) = 2.67820773718529873578940348424577621E2_cfp
      c( 4, 0, 0, 12, 4) = 1.04719755119659774615421446109316763E-1_cfp
      c( 0, 1, 0, 12, 4) = -7.76680243783736633378927010431275101E3_cfp
      c( 2, 1, 0, 12, 4) = -3.45575191894877256230890772160745317E1_cfp
      c( 0, 2, 0, 12, 4) = 8.03462321155589620736821045273732863E2_cfp
      c( 2, 2, 0, 12, 4) = 1.04719755119659774615421446109316763E0_cfp
      c( 0, 3, 0, 12, 4) = -3.45575191894877256230890772160745317E1_cfp
      c( 0, 4, 0, 12, 4) = 5.23598775598298873077107230546583814E-1_cfp
      c( 1, 0, 1, 12, 4) = -2.58893414594578877792975670143758367E3_cfp
      c( 3, 0, 1, 12, 4) = -6.91150383789754512461781544321490635E0_cfp
      c( 1, 1, 1, 12, 4) = 5.35641547437059747157880696849155242E2_cfp
      c( 3, 1, 1, 12, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 1, 2, 1, 12, 4) = -3.45575191894877256230890772160745317E1_cfp
      c( 1, 3, 1, 12, 4) = 6.98131700797731830769476307395445085E-1_cfp
      c( 2, 0, 2, 12, 4) = 1.07128309487411949431576139369831048E2_cfp
      c( 4, 0, 2, 12, 4) = 5.98398600683770140659551120624667216E-2_cfp
      c( 2, 1, 2, 12, 4) = -1.38230076757950902492356308864298127E1_cfp
      c( 2, 2, 2, 12, 4) = 4.18879020478639098461685784437267051E-1_cfp
      c( 3, 0, 3, 12, 4) = -1.97471538225644146417651869806140181E0_cfp
      c( 3, 1, 3, 12, 4) = 1.19679720136754028131910224124933443E-1_cfp
      c( 4, 0, 4, 12, 4) = 1.32977466818615586813233582361037159E-2_cfp
      c( 0, 0, 0, 12, 5) = 9.17453537969538898178857531071943713E4_cfp
      c( 2, 0, 0, 12, 5) = 1.56228784669142426254381869914336946E3_cfp
      c( 4, 0, 0, 12, 5) = 1.83259571459404605576987530691304335E0_cfp
      c( 0, 1, 0, 12, 5) = -3.39797606655384777103280567063682856E4_cfp
      c( 2, 1, 0, 12, 5) = -3.02378292908017599202029425640652153E2_cfp
      c( 4, 1, 0, 12, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 0, 2, 0, 12, 5) = 4.68686354007427278763145609743010837E3_cfp
      c( 2, 2, 0, 12, 5) = 1.83259571459404605576987530691304335E1_cfp
      c( 0, 3, 0, 12, 5) = -3.02378292908017599202029425640652153E2_cfp
      c( 2, 3, 0, 12, 5) = -3.49065850398865915384738153697722543E-1_cfp
      c( 0, 4, 0, 12, 5) = 9.16297857297023027884937653456521675E0_cfp
      c( 0, 5, 0, 12, 5) = -1.04719755119659774615421446109316763E-1_cfp
      c( 1, 0, 1, 12, 5) = -1.13265868885128259034426855687894285E4_cfp
      c( 3, 0, 1, 12, 5) = -6.04756585816035198404058851281304305E1_cfp
      c( 5, 0, 1, 12, 5) = -1.49599650170942535164887780156166804E-2_cfp
      c( 1, 1, 1, 12, 5) = 3.12457569338284852508763739828673891E3_cfp
      c( 3, 1, 1, 12, 5) = 7.33038285837618422307950122765217340E0_cfp
      c( 1, 2, 1, 12, 5) = -3.02378292908017599202029425640652153E2_cfp
      c( 3, 2, 1, 12, 5) = -2.09439510239319549230842892218633526E-1_cfp
      c( 1, 3, 1, 12, 5) = 1.22173047639603070384658353794202890E1_cfp
      c( 1, 4, 1, 12, 5) = -1.74532925199432957692369076848861271E-1_cfp
      c( 2, 0, 2, 12, 5) = 6.24915138676569705017527479657347782E2_cfp
      c( 4, 0, 2, 12, 5) = 1.04719755119659774615421446109316763E0_cfp
      c( 2, 1, 2, 12, 5) = -1.20951317163207039680811770256260861E2_cfp
      c( 4, 1, 2, 12, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 2, 2, 2, 12, 5) = 7.33038285837618422307950122765217340E0_cfp
      c( 2, 3, 2, 12, 5) = -1.39626340159546366153895261479089017E-1_cfp
      c( 3, 0, 3, 12, 5) = -1.72787595947438628115445386080372659E1_cfp
      c( 5, 0, 3, 12, 5) = -6.64887334093077934066167911805185796E-3_cfp
      c( 3, 1, 3, 12, 5) = 2.09439510239319549230842892218633526E0_cfp
      c( 3, 2, 3, 12, 5) = -5.98398600683770140659551120624667216E-2_cfp
      c( 4, 0, 4, 12, 5) = 2.32710566932577276923158769131815028E-1_cfp
      c( 4, 1, 4, 12, 5) = -1.32977466818615586813233582361037159E-2_cfp
      c( 5, 0, 5, 12, 5) = -1.20888606198741442557485074873670145E-3_cfp
      c( 0, 0, 0, 12, 6) = 2.82881507540607826938481072080515978E5_cfp
      c( 2, 0, 0, 12, 6) = 7.22558129094783721426516148353808373E3_cfp
      c( 4, 0, 0, 12, 6) = 1.69515103599949260158713465889456510E1_cfp
      c( 6, 0, 0, 12, 6) = 2.49332750284904225274812966926944673E-3_cfp
      c( 0, 1, 0, 12, 6) = -1.25725114462492367528213809813562657E5_cfp
      c( 2, 1, 0, 12, 6) = -1.86466613959944186174584812478402161E3_cfp
      c( 4, 1, 0, 12, 6) = -1.93731546971370583038529675302236011E0_cfp
      c( 0, 2, 0, 12, 6) = 2.16767438728435116427954844506142512E4_cfp
      c( 2, 2, 0, 12, 6) = 1.69515103599949260158713465889456510E2_cfp
      c( 4, 2, 0, 12, 6) = 5.23598775598298873077107230546583814E-2_cfp
      c( 0, 3, 0, 12, 6) = -1.86466613959944186174584812478402161E3_cfp
      c( 2, 3, 0, 12, 6) = -6.45771823237901943461765584340786704E0_cfp
      c( 0, 4, 0, 12, 6) = 8.47575517999746300793567329447282549E1_cfp
      c( 2, 4, 0, 12, 6) = 8.72664625997164788461845384244306357E-2_cfp
      c( 0, 5, 0, 12, 6) = -1.93731546971370583038529675302236011E0_cfp
      c( 0, 6, 0, 12, 6) = 1.74532925199432957692369076848861271E-2_cfp
      c( 1, 0, 1, 12, 6) = -4.19083714874974558427379366045208856E4_cfp
      c( 3, 0, 1, 12, 6) = -3.72933227919888372349169624956804322E2_cfp
      c( 5, 0, 1, 12, 6) = -2.76759352816243690055042393288908587E-1_cfp
      c( 1, 1, 1, 12, 6) = 1.44511625818956744285303229670761675E4_cfp
      c( 3, 1, 1, 12, 6) = 6.78060414399797040634853863557826039E1_cfp
      c( 5, 1, 1, 12, 6) = 1.49599650170942535164887780156166804E-2_cfp
      c( 1, 2, 1, 12, 6) = -1.86466613959944186174584812478402161E3_cfp
      c( 3, 2, 1, 12, 6) = -3.87463093942741166077059350604472022E0_cfp
      c( 1, 3, 1, 12, 6) = 1.13010069066632840105808977259637673E2_cfp
      c( 3, 3, 1, 12, 6) = 6.98131700797731830769476307395445085E-2_cfp
      c( 1, 4, 1, 12, 6) = -3.22885911618950971730882792170393352E0_cfp
      c( 1, 5, 1, 12, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 2, 0, 2, 12, 6) = 2.89023251637913488570606459341523349E3_cfp
      c( 4, 0, 2, 12, 6) = 9.68657734856852915192648376511180056E0_cfp
      c( 6, 0, 2, 12, 6) = 1.66221833523269483516541977951296449E-3_cfp
      c( 2, 1, 2, 12, 6) = -7.45866455839776744698339249913608643E2_cfp
      c( 4, 1, 2, 12, 6) = -1.10703741126497476022016957315563435E0_cfp
      c( 2, 2, 2, 12, 6) = 6.78060414399797040634853863557826039E1_cfp
      c( 4, 2, 2, 12, 6) = 2.99199300341885070329775560312333608E-2_cfp
      c( 2, 3, 2, 12, 6) = -2.58308729295160777384706233736314682E0_cfp
      c( 2, 4, 2, 12, 6) = 3.49065850398865915384738153697722543E-2_cfp
      c( 3, 0, 3, 12, 6) = -1.06552350834253820671191321416229806E2_cfp
      c( 5, 0, 3, 12, 6) = -1.23004156807219417802241063683959372E-1_cfp
      c( 3, 1, 3, 12, 6) = 1.93731546971370583038529675302236011E1_cfp
      c( 5, 1, 3, 12, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 3, 2, 3, 12, 6) = -1.10703741126497476022016957315563435E0_cfp
      c( 3, 3, 3, 12, 6) = 1.99466200227923380219850373541555739E-2_cfp
      c( 4, 0, 4, 12, 6) = 2.15257274412633981153921861446928901E0_cfp
      c( 6, 0, 4, 12, 6) = 6.04443030993707212787425374368350723E-4_cfp
      c( 4, 1, 4, 12, 6) = -2.46008313614438835604482127367918744E-1_cfp
      c( 4, 2, 4, 12, 6) = 6.64887334093077934066167911805185796E-3_cfp
      c( 5, 0, 5, 12, 6) = -2.23643921467671668731347388516289768E-2_cfp
      c( 5, 1, 5, 12, 6) = 1.20888606198741442557485074873670145E-3_cfp
      c( 6, 0, 6, 12, 6) = 9.29912355374934173519115960566693420E-5_cfp

   end subroutine Laguerre_poly_factorization_cfs

end module lag_cfs_gbl
