import numba

@numba.njit
def get_phase(phi, phiidx, cnt, target):
    nph, nz, ny, nx = phi.shape
    out = np.zeros((nz, ny, nx), dtype=phi.dtype)
    for z in range(nz):
        for y in range(ny):
            for x in range(nx):
                nc = cnt[z,y,x]
                for a in range(nc):
                    if phiidx[a,z,y,x] == target:
                        out[z,y,x] = phi[a,z,y,x]
                        break
    return out
class lropview():
    ind = 0
    def __init__(self, phis, phiidxs, cnts, im, ax, fig, phase, time=None):
        self.phis = phis
        self.phiidxs = phiidxs
        self.cnts = cnts
        self.phase = phase
        self.ax = ax
        self.im = im
        self.fig = fig
        self.time = time
        
        
        self.update(0)
        
    def get_phi(self, frame, phase):
        return get_phase(self.phis[frame], self.phiidxs[frame], self.cnts[frame], phase)
    # apparently next/prev are not used with slider, only update
    def next(self, event):
        self.ind += 1
        #print("hello", self.ind)
        if self.ind < len(self.phis):
            #self.ax.clear()
            data = self.get_phi(self.ind, self.phase)
            self.im.set_data(data[0])
            title="frame %d" % (self.ind)
            if self.time is not None:
                title += " t=%.4e" % (self.time["time"][self.ind])
            self.ax.set_title(title)
            self.fig.canvas.draw()
            self.fig.canvas.flush_events()
        else:
            ind = len(self.phis-1)
        if event.inaxes is not None:
            event.inaxes.figure.canvas.draw_idle()
        
    def prev(self, event):
        self.ind -= 1
        if self.ind >= 0:
            #self.ax.clear()
            data = self.get_phi(self.ind, self.phase)
            self.im.set_data(data[0])
            title="frame %d" % (self.ind)
            if self.time is not None:
                title += " t=%.4e" % (self.time["time"][self.ind])
            self.ax.set_title(title)
            self.fig.canvas.draw()
            self.fig.canvas.flush_events()
        else:
            self.ind = 0
        if event.inaxes is not None:
            event.inaxes.figure.canvas.draw_idle()
            
    def update(self, val):
        self.ind = val
        data = self.get_phi(self.ind, self.phase)
        self.im.set_data(data[0])
        title="frame %d" % (self.ind)
        if self.time is not None:
            title += " t=%.4e" % (self.time["time"][self.ind])
        self.ax.set_title(title)
        #self.fig.canvas.draw_idle()
        self.fig.canvas.draw()
        self.fig.canvas.flush_events()
