import matplotlib as mpl
from matplotlib import pyplot as plt
import numpy as np

coloursen_cyc = ["orange", "purple", "green", "blue", "pink", "brown"]
cyc = mpl.cycler(color=coloursen_cyc)
mpl.rcParams['axes.prop_cycle'] = cyc

ints=["FEuler(MPF::Obstacle)",
"SSP(5)2(MPF::Obstacle)",
"STS1(RKL)(MPF::Obstacle)",
"STS2(RKL)(MPF::Obstacle)"]

colmap =  {k: v for k, v in zip(ints, coloursen_cyc)}


layoutdata = {
  "fontsize" : {
    "paper" : 16,
    "notebook" : mpl.rcParams["font.size"],
  },
  "figsize" : {"paper" : (10, 5),
               "notebook" : (6.4, 4.8),
              },
}

def setup_plot(kind="notebook", nh=1, figsize=None, fontsize=None, **kwargs):
  """
  Setup the environment for a plot.
  The number of horizontal plots changes the aspect ratio so they can be
  put together on a single figure.

  """
  if figsize is None:
    figsize = layoutdata["figsize"][kind]
  
  if fontsize is None:
    fontsize = layoutdata["fontsize"][kind] 
    if kind == "paper":
      fontsize /= (nh**(1.0/4.0))
  mpl.rcParams.update({'font.size' : fontsize})
  figsize = (figsize[0]/nh, figsize[1])
  if "layout" not in kwargs.keys() and kind != "notebook":
    # for some reason constrained layout does cut off axis labels in the notebook,
    # but it's fine if saved to PDF
    kwargs["layout"] = "constrained"
  fig, ax = plt.subplots(figsize=figsize, **kwargs)
  return fig, ax
     
    
