import pyvista as pv
import glob
from pathlib import Path
import re
import numpy as np

def makepvdpath(path, fmt, end = ".pvti"):
    p = path
    p = p.replace(fmt, "")
    p = p.replace(end, ".pvd")
    return p

def genPVD(path_with_format, fmts="%08d"):
  """assume path_with_format is something like a/b/c_step%08d.pvti; the part with the format specifier should be sticking to .pvti """
  print(path_with_format)
  pvdpath = makepvdpath(path_with_format, fmts) #.replace(".pvti", ".pvd").replace(fmts, "")
  dn = Path(path_with_format).parent

  pathglob = path_with_format.replace(fmts, "*") # get all matching ones, then reduce
  if "%0" in fmts:
    minlen = int(fmts[2:-1])
  else:
    minlen = int(fmts[1:-1])
  myre = re.compile("[0-9]{%d,}\\.pvti" % (minlen))

  allp = glob.glob(pathglob)
  matching = []
  for trial in allp:
    if myre.search(trial) is not None:
      matching.append(trial)

  steps, times, names = [], [], []
  for vtk in matching:
    reader = pv.get_reader(vtk)
    # don't read any big data
    for name in reader.cell_array_names:
      reader.disable_cell_array(name)
    for name in reader.point_array_names:
      reader.disable_point_array(name)
    data = reader.read()
    step = data["TimeValue"][0]
    time = data["RealTimeValue"][0]
    steps.append(step)
    times.append(time)
    bn = Path(vtk).name
    names.append(bn)
  # sort by step for output
  steps, times, names = [np.array(x) for x in [steps, times, names]]
  idx = np.argsort(times)
  frames = np.arange(0, len(times))
  steps = steps[idx]
  times = times[idx]
  names = names[idx]
  # TODO also write out an alternative time.dat?
  timedat = open(dn / "alt_time.dat", "w")
  with open(pvdpath, "w") as f:
    f.write("""<?xml version="1.0"?>\n
  <VTKFile type="Collection" version="0.1">\n
  <Collection>\n""")
    for frame, step, time, name in zip(frames, steps, times, names):
      f.write(f'<DataSet timestep="{time}" file="{name}"/>\n')
      timedat.write("%d %e\n" % ( frame, time))
    f.write(""" </Collection>\n
</VTKFile> """)
  timedat.close()
