# LFM-PAPER-043: Gravitational Time Dilation and Low-Acceleration Dynamics

## Zenodo Data Package

**Paper Title**: Gravitational Time Dilation and Low-Acceleration Dynamics in the LFM Framework: From GPS Clocks to Galaxy Rotation Curves

**Authors**: Greg D. Partin

**Date**: January 2026

**Paper ID**: LFM-PAPER-043

**DOI**: 10.5281/zenodo.XXXXXXX (assigned upon upload)

---

## Abstract

We show that gravitational time dilation arises directly from the canonical Lattice Field Medium (LFM) equation ∂²E/∂t² = c²∇²E − χ(x)²E without invoking spacetime curvature, metric tensors, or fitted parameters. Three independent experiments using real observational data establish consistency between LFM predictions and published results:

1. **Chou et al. (2010) optical clock comparison** — agreement within 1σ experimental uncertainty
2. **GPS satellite clocks** — reproduction of observed +45.7 μs/day gravitational shift within 0.05%
3. **Pound–Rebka tower experiment** — agreement within the reported ~10% experimental uncertainty

Additionally, we derive a dynamical effective speed formula c_dyn(a) = c√(a/(a+a₀)) and test it against the complete SPARC database (175 galaxies, 3377 data points). LFM decisively outperforms MOND with Δχ² = 155,998, winning on 148/175 galaxies (85%).

---

## Package Contents

### `/manuscript/`
Publication-ready manuscript and source files:
- `LFM-PAPER-043_Gravitational_Time_Dilation.pdf` — Named PDF for archive
- `manuscript.pdf` — Compiled PDF (same content)
- `main.tex` — LaTeX source
- `manuscript.tex` — Alternative LaTeX source
- `refs.bib` — Bibliography
- `metadata.json` — Paper metadata
- `CITATION.cff` — Citation file format
- `LICENSE.txt` — CC-BY 4.0 License
- `/figures/` — All paper figures

### `/experiments/`
Python scripts for all validation experiments:

| Script | Description |
|--------|-------------|
| `run_time_dilation_terrestrial.py` | Chou, GPS, Pound-Rebka clock tests |
| `config_time_dilation.json` | Configuration for terrestrial experiments |
| `sparc_175_corrected.py` | Full SPARC 175-galaxy analysis |
| `real_sparc_test.py` | Real SPARC data loading and testing |
| `full_sparc_analysis.py` | Extended SPARC analysis |
| `test_rar.py` | Radial Acceleration Relation comparison |
| `test_galaxy_clusters_v2.py` | Galaxy cluster mass analysis |
| `test_lensing_dynamics.py` | Lensing vs dynamics comparison |
| `test_falsification.py` | LFM falsification tests |
| `new_predictions.py` | 6 testable predictions for future observations |
| `pulsar_deep_dive.py` | Pulsar timing analysis |

### `/results/`
Experiment output data and validation results:

| File | Description |
|------|-------------|
| `summary.json` | Overall validation summary |
| `sparc_175_corrected.json` | SPARC 175-galaxy χ² results |
| `sparc_175_corrected.png` | Visual comparison plot |
| `real_sparc_test.json` | Detailed per-galaxy results |
| `real_sparc_comparison.png` | 6-galaxy comparison figure |
| `rar_analysis.json` | RAR comparison metrics |
| `rar_comparison.png` | RAR visual comparison |
| `galaxy_clusters_corrected.json` | Cluster analysis results |
| `lensing_dynamics_test.json` | Lensing vs dynamics results |
| `lfm_predictions.json` | Testable predictions |
| `falsification_summary.json` | Falsification test outcomes |
| `comprehensive_summary.json` | All tests summary |
| `final_validation_summary.json` | Final validation metrics |
| `master_validation_figure.png` | Master validation figure |

### `/data/`
Input data files:
- `sparc_175_galaxies.json` — SPARC galaxy rotation curve data (175 galaxies)

---

## Key Results

### Terrestrial Time Dilation Tests

| Test | Data Source | LFM Agreement |
|------|-------------|---------------|
| Optical clocks | Chou et al. (2010) | Within 1σ |
| GPS satellites | Ashby (2003) | 0.05% |
| Pound-Rebka | Pound & Rebka (1960) | 0.71% |

### Galaxy Rotation Curves (175 SPARC Galaxies)

| Model | Total χ² | Reduced χ² |
|-------|----------|------------|
| Newtonian | 693,927 | 205.5 |
| MOND (RAR) | 517,394 | 153.2 |
| **LFM** | **361,396** | **107.0** |

**LFM wins on 148/175 galaxies (84.6%)**

Δχ² = 155,998 (highly significant preference for LFM over MOND)

---

## Reproducibility

### Requirements
- Python 3.10+
- NumPy, SciPy, Matplotlib

### Running Experiments

```bash
cd experiments

# Terrestrial time dilation tests
python run_time_dilation_terrestrial.py

# SPARC galaxy analysis
python sparc_175_corrected.py

# RAR comparison
python test_rar.py

# All falsification tests
python test_falsification.py
```

Results will be written to `results/` directory.

---

## Citation

If you use this data or code, please cite:

```bibtex
@article{Partin2026LFM043,
  author = {Partin, Greg D.},
  title = {Gravitational Time Dilation and Low-Acceleration Dynamics in the LFM Framework},
  year = {2026},
  journal = {Preprint},
  doi = {10.5281/zenodo.XXXXXXX}
}
```

---

## License

This work is licensed under CC-BY 4.0. See `manuscript/LICENSE.txt` for details.

---

## Related Papers

- **LFM-PAPER-001**: Foundational LFM Framework (DOI: 10.5281/zenodo.17618474)
- **LFM-PAPER-003**: Galaxy Gravity Validation (DOI: 10.5281/zenodo.18142944)
- **LFM-PAPER-044**: The χ-Field as Dark Matter: Comprehensive Validation

---

*Package generated: 2026-01-20*
