clear
%% Plane Pauli variance estimation with full POVM
% Variance optimisation for sums of local Paulis, parametrized by a
% parameter theta which determines the balance between the X and Z Pauli

Ncycle = 30;     % should be enough for this case…
density = 2;   % how many different angles are considered
offset = 0;

N = 5;   % total number of qubits
d = 2^N; % dimension of vector space
D = d^2; % dimension of *full* Hilbert Space 
tic;     % start timer
%% POVM matrix
% Full Pauli POVM
dir = "data";
dir_states = dir+"paulisum_full_states/";
filename = "paulisum_full_"+N;
povm = pauli_povm(); % let's now consider the full case

full_povm = povm_tensor_cycle(povm, N);
[pcm, bm, em, DD] = coef_matrix (full_povm);

n = max(size(pcm)); % number of distinct effects in POVM
Ds = min(size(pcm)); % dimenstion of subspace

% relevant Paulis
X = [0,1;1,0];
Z = [1,0;0,-1];
%% aggregate containers
% rather than selecting different columns, I'd rather have keywords in the
% same file
variance_vec     = zeros(density,1);
purity_vec       = zeros(density,1);
mixture_vec = zeros(density,1); % saves number of non-zero elements 

% canonical solution (the same \forall \theta)
obs = sum_local_tensor(X,N); % equivalent to \theta = 0
can_coef = em*bm'*obs(:);
[var_can, rho_flat_can] = var_opt_fixcoef(pcm, can_coef , Ncycle, bm);
rho_can = reshape(bm*rho_flat_can, [d, d]); % obtains density matrix in proper basis
save(dir_states+filename+"_std.mat", "rho_can");

%% direct variance optimisation cycle

for j =1:density
    theta = (j-1)*pi/2;%(density*2); % for density = 2 we just consider first and last case
    obs = cos(theta/2)*X+sin(theta/2)*Z;
    if N >1
        full_obs = sum_local_tensor(obs, N);
    else
        full_obs = obs;
    end
    flat_obs = bm'*full_obs(:);

    [var, rho_flat, opt_coefs] = var_opt(pcm, flat_obs, Ncycle, bm);
    rho = reshape(bm*rho_flat, [d, d]); % obtains density matrix in proper basis
    s_eigs = schmidt_eig(rho); % calculate entanglement for the density matrix
    variance_vec(j) = var; % optimal variance
    purity_vec(j) = purity(rho);
    mixture_vec(j,:) = nnz(round(s_eigs, 8));

    % for each observable (determined by the index and the density to 
    % recover theta) saves the optimal state
    save(dir_states+filename+"_th_"+j+"_"+density+".mat", "rho", "s_eigs","opt_coefs");

    % in order not to loose results if cycle breaks, file overwritten each time
    save(dir+filename+".mat","density","variance_vec", "mixture_vec","purity_vec","var_can","t_total");
end

t_total = toc;


