% takes tensor product between all elements of two input POVMs

function POVM = povm_tensor(povm1,povm2)
    d1 = min(size(povm1));
    n1 = max(size(povm1))/d1;

    d2 = min(size(povm2));
    n2 = max(size(povm2))/d2;

    POVM = zeros((d1*n1)*(d2*n2),d1*d2);
    
    ind = 0; % internal index for inserting new tensor product in proper place
    for i=1:n1
        p1 = povm1(1+d1*(i-1):d1*i,:);
        for j=1:n2
            p2 = povm2(1+d2*(j-1):d2*j,:);
            ind = ind+1; % increment like this to avoid problems with inner loop
            POVM(1+d1*d2*(ind-1):d1*d2*ind,:)=kron(p1,p2);
        end
    end
end
