%% Sum of local observables
% Returns the sum of local observables, where each term is given by a fixed
% local observable in a particular position tensor identities all over

function sum_obs = sum_local_tensor(obs, n_qubits)

    tot_dim = 2^n_qubits;
    sum_obs = zeros(tot_dim); % Initialize the sum of observables

    for i=1:n_qubits % cycle of terms in the sum
        tens_obs = 1;
        for j=1:n_qubits % cycle to tensor in the right plane
            if j==i
                single_obs = obs; % in the corresponding position, returns 
                                  % the actual local observable 
            else
                single_obs = eye(2); % in other positions, simply identity
            end
            tens_obs = kron(tens_obs,single_obs); % tensor with other 
        end
        sum_obs = sum_obs + tens_obs; % Accumulate the tensor products
    end
end