%% Optimal inverse matrix for a given target state
% Builds optimal inverse matrix for fixed state
% Uses previous inverse_mat_weighted.m function, where weight is given by
% the inverse of the projection of the state onto the POVM effects

function Lmat = state_opt_invmat (povm_mat, flat_rho)
    n = max(size(povm_mat)); % dimensions of problem (no. of effects, dimension of observable)
    p = round(povm_mat*flat_rho,10);

    % Safety check:
    % we assume here that all probs !=0; if state were orthogonal to some 
    % effect, we can add a small noise parameter. 
    % Calculation done only if there are zero elements (there shouldn't)
    nz = n - nnz(p);
    if nz > 0
        % noise parameter, taken as the smallest element present divided by
        % all elements (in order not to perturb too much)
        eps = min(p(p>0))/n; 
        for i=1:n
            % this is just a safety check, if for any reason this were non-zero
            if p(i)== 0
                p(i) = eps;
            else
                p(i) = p(i)- eps/nz;
            end
        end
    end
    
    % definition of inverse probabilities matrix (should be well-defined
    % now)
    dmat = diag(1./p); % matrix of inverse probabilities

    Lmat = inverse_mat_weighted(povm_mat, dmat);
end
