%% Probabilities from random mat
% Takes in a random set of 2*D coefficients, generates a density matrix
% from this set and returns the expected set of probabilities for this
% state. A more compact way rahter then explicitly writing the inner
% product between the reconstructed density matrix and the POVM coefficient
% matrix

function probs = probs_rand_const (x, povm_cm, basis_mat)
    rf = rhoflat_construction(x, basis_mat);
    probs = real(povm_cm*rf); % reality just to be sure
    % no need to check whether some are zero, we don't invert these
end