%% Plane POVM storage function
% For ease of use, we store here the plane POVM to be generated fast and
% efficiently. Input decides which directions to take
% X = 1, Y = 2, Z = 3

function ppovm = plane_povm (A, B)
    if nargin < 2
        error('You need to indicate another Pauli to take');
    elseif nargin > 2
        error('You need to indicate only 2 Paulis for the plane');
    end

    if A == B
        error('You should choose two different Paulis…');
    end

    pm = zeros(8,2);

    if A == 1
        pm(1:2,:) = [0.5,     0.5;     0.5,  0.5 ];
        pm(3:4,:) = [0.5,    -0.5;    -0.5,  0.5 ];
    elseif A == 2
        pm(1:2,:) = [0.5,  0.5*1j; -0.5*1j,  0.5 ];
        pm(3:4,:) = [0.5, -0.5*1j;  0.5*1j,  0.5 ];
    else
        pm(1:2,:) = [1,         0;       0,    0 ];
        pm(3:4,:) = [0,         0;       0,    1 ];
    end

    if B == 1
        pm(5:6,:) = [0.5,     0.5;     0.5,  0.5 ];
        pm(7:8,:) = [0.5,    -0.5;    -0.5,  0.5 ];
    elseif B == 2
        pm(5:6,:) = [0.5,  0.5*1j; -0.5*1j,  0.5 ];
        pm(7:8,:) = [0.5, -0.5*1j;  0.5*1j,  0.5 ];
    else
        pm(5:6,:) = [1,         0;       0,    0 ];
        pm(7:8,:) = [0,         0;       0,    1 ];
    end

    ppovm = pm /2; 
end
% I know this is super dumb, but it's dumber to always rewrite them by hand