%% weighted inverse map
% determines the pseudo-inverse from the trace-distance minimisation
% problem. Weight metrix must be input from outside, otherwise simply
% reduces to Moore-Penrose pseudo-inverse
% NB: weight matrix, if diagonal, should *already* be inverted

function im = inverse_mat_weighted(pm, dmat)
    if nargin<2
        n = max(size(pm));
        dmat = eye(n); % this becomes simply identity
    end    
    
    im = dmat*pm*inv(pm.'*dmat*pm); % D R ( R^T D R)^{-1}
    % NB: we're using the *transpose* of the coefficient matrix

end