% Function to generate the coefficient matrix of an input POVM
% Receives as an iput the POVM matrix, es in the effects stacked one on top
% of each other. 
% Returns: - coefficient matrix (expressed in proper basis)
%          - adequate basis matrix (when POVM doesn't span the whole space)
%          - Moore-Penrose pseudo-inverse (standard estimators)
%          - Dimension of subspace spanned by the POVM

function [povm_mat, basis_mat, est_mat, D] = coef_matrix (povm)
    
    d = (min(size(povm)))^2; % dimension of observable space (depends on no of qubits)

    coef = round(can_coef_matrix(povm),10); % automatically reshaped povm elements
    basis_mat = eye(d);                     % for full span, identity matrix
    
    [U,S,V] = svd(coef);
    v = nnz(round(S,10)); % round just to avoid floating point errors for smallish eigvs
        
    % in case full rank, basis matrix is the canonical basis
    if v < d
        basis_mat = V(:,1:v); % new reduced basis of dimension D
        [U,S,V] = svd(coef*basis_mat); % overwrite of new coefficient matrix
    end
    D = v;
    
    povm_mat = coef*conj(basis_mat);    % the coefficients are found as *Tr(E_k B_j^\dagger)*
    est_mat = estimator_mat(U,S,V).';   % inverse of the *transpose*
end