% coefficient matrix in the *canonical* basis

function mat = can_coef_matrix (v)
    [n,d] = size(v);   % shape of POVM matrix: number of effects and dim of state
    vt = v';                        % transpose of POVM vector  
    fvt = vt(:);                    % flatten traspose  
    rfvt = reshape(fvt,d^2,n/d);    % reshape of flattened vector (col= povm)
    mat = rfvt';                    % final matrix: each row represents the
                                    % coeffs of POVM in canonical basis
end