!==========================================================================
elemental function gsw_gibbs_pt0_pt0 (sa, pt0)
!==========================================================================
!
! gibbs_tt at (sa,pt,0)
!
! sa     : Absolute Salinity                            [g/kg]
! pt0    : potential temperature                        [deg C]
! 
! gsw_gibbs_pt0_pt0 : gibbs_tt at (sa,pt,0)         
!--------------------------------------------------------------------------

use gsw_mod_teos10_constants, only : gsw_sfac

use gsw_mod_kinds

implicit none

real (r8), intent(in) :: sa, pt0

real (r8) :: gsw_gibbs_pt0_pt0

real (r8) :: x2, x, y, g03, g08

x2 = gsw_sfac*sa
x = sqrt(x2)
y = pt0*0.025_r8

g03 = -24715.571866078_r8 + &
    y*(4420.4472249096725_r8 + &
    y*(-1778.231237203896_r8 + &
    y*(1160.5182516851419_r8 + &
    y*(-569.531539542516_r8 + y*128.13429152494615_r8))))

g08 = x2*(1760.062705994408_r8 + x*(-86.1329351956084_r8 + &
    x*(-137.1145018408982_r8 + y*(296.20061691375236_r8 + &
    y*(-205.67709290374563_r8 + 49.9394019139016_r8*y))) + &
    y*(-60.136422517125_r8 + y*10.50720794170734_r8)) + &
    y*(-1351.605895580406_r8 + y*(1097.1125373015109_r8 + &
    y*(-433.20648175062206_r8 + 63.905091254154904_r8*y))))

gsw_gibbs_pt0_pt0 = (g03 + g08)*0.000625_r8

return
end function

!--------------------------------------------------------------------------
