!==========================================================================
elemental function gsw_chem_potential_water_t_exact (sa, t, p)
!==========================================================================
!
!  Calculates the chemical potential of water in seawater.
!
!  SA  =  Absolute Salinity                                        [ g/kg ]
!  t   =  in-situ temperature (ITS-90)                            [ deg C ]
!  p   =  sea pressure                                             [ dbar ]
!         ( i.e. absolute pressure - 10.1325 dbar ) 
!
!  chem_potential_water_t_exact  =  chemical potential of water in seawater
!                                                                   [ J/g ]
!--------------------------------------------------------------------------

use gsw_mod_teos10_constants, only : gsw_sfac

use gsw_mod_kinds

implicit none

real (r8), intent(in) :: sa, t, p

real (r8) :: gsw_chem_potential_water_t_exact

real (r8) :: g03_g, g08_g, g_sa_part, x, x2, y, z

real (r8), parameter :: kg2g = 1e-3_r8

x2 = gsw_sfac*sa
x = sqrt(x2)
y = t*0.025_r8
z = p*1e-4_r8

g03_g = 101.342743139674_r8 + z*(100015.695367145_r8 + &
    z*(-2544.5765420363_r8 + z*(284.517778446287_r8 + &
    z*(-33.3146754253611_r8 + (4.20263108803084_r8 - 0.546428511471039_r8*z)*z)))) + &
    y*(5.90578347909402_r8 + z*(-270.983805184062_r8 + &
    z*(776.153611613101_r8 + z*(-196.51255088122_r8 + (28.9796526294175_r8 - 2.13290083518327_r8*z)*z))) + &
    y*(-12357.785933039_r8 + z*(1455.0364540468_r8 + &
    z*(-756.558385769359_r8 + z*(273.479662323528_r8 + z*(-55.5604063817218_r8 + 4.34420671917197_r8*z)))) + &
    y*(736.741204151612_r8 + z*(-672.50778314507_r8 + &
    z*(499.360390819152_r8 + z*(-239.545330654412_r8 + (48.8012518593872_r8 - 1.66307106208905_r8*z)*z))) + &
    y*(-148.185936433658_r8 + z*(397.968445406972_r8 + &
    z*(-301.815380621876_r8 + (152.196371733841_r8 - 26.3748377232802_r8*z)*z)) + &
    y*(58.0259125842571_r8 + z*(-194.618310617595_r8 + &
    z*(120.520654902025_r8 + z*(-55.2723052340152_r8 + 6.48190668077221_r8*z))) + &
    y*(-18.9843846514172_r8 + y*(3.05081646487967_r8 - 9.63108119393062_r8*z) + &
    z*(63.5113936641785_r8 + z*(-22.2897317140459_r8 + 8.17060541818112_r8*z))))))))

g08_g = x2*(1416.27648484197_r8 + &
    x*(-2432.14662381794_r8 + x*(2025.80115603697_r8 + &
    y*(543.835333000098_r8 + y*(-68.5572509204491_r8 + &
    y*(49.3667694856254_r8 + y*(-17.1397577419788_r8 + 2.49697009569508_r8*y))) - 22.6683558512829_r8*z) + &
    x*(-1091.66841042967_r8 - 196.028306689776_r8*y + &
    x*(374.60123787784_r8 - 48.5891069025409_r8*x + 36.7571622995805_r8*y) + 36.0284195611086_r8*z) + &
    z*(-54.7919133532887_r8 + (-4.08193978912261_r8 - 30.1755111971161_r8*z)*z)) + &
    z*(199.459603073901_r8 + z*(-52.2940909281335_r8 + (68.0444942726459_r8 - 3.41251932441282_r8*z)*z)) + &
    y*(-493.407510141682_r8 + z*(-175.292041186547_r8 + (83.1923927801819_r8 - 29.483064349429_r8*z)*z) + &
    y*(-43.0664675978042_r8 + z*(383.058066002476_r8 + z*(-54.1917262517112_r8 + 25.6398487389914_r8*z)) + &
    y*(-10.0227370861875_r8 - 460.319931801257_r8*z + y*(0.875600661808945_r8 + 234.565187611355_r8*z))))) + &
    y*(168.072408311545_r8))

g_sa_part = 8645.36753595126_r8 + &
    x*(-7296.43987145382_r8 + x*(8103.20462414788_r8 + &
    y*(2175.341332000392_r8 + y*(-274.2290036817964_r8 + &
    y*(197.4670779425016_r8 + y*(-68.5590309679152_r8 + 9.98788038278032_r8*y))) - 90.6734234051316_r8*z) + &
    x*(-5458.34205214835_r8 - 980.14153344888_r8*y + &
    x*(2247.60742726704_r8 - 340.1237483177863_r8*x + 220.542973797483_r8*y) + 180.142097805543_r8*z) + &
    z*(-219.1676534131548_r8 + (-16.32775915649044_r8 - 120.7020447884644_r8*z)*z)) + &
    z*(598.378809221703_r8 + z*(-156.8822727844005_r8 + (204.1334828179377_r8 - 10.23755797323846_r8*z)*z)) + &
    y*(-1480.222530425046_r8 + z*(-525.876123559641_r8 + (249.57717834054571_r8 - 88.449193048287_r8*z)*z) + &
    y*(-129.1994027934126_r8 + z*(1149.174198007428_r8 + z*(-162.5751787551336_r8 + 76.9195462169742_r8*z)) + &
    y*(-30.0682112585625_r8 - 1380.9597954037708_r8*z + y*(2.626801985426835_r8 + 703.695562834065_r8*z))))) + &
    y*(1187.3715515697959_r8)

gsw_chem_potential_water_t_exact = kg2g*(g03_g + g08_g - 0.5_r8*x2*g_sa_part)

return
end function

!--------------------------------------------------------------------------
