# -*- coding: utf-8 -*-
#
# MOM6 documentation build configuration file, created by
# sphinx-quickstart on Sun Jan 22 11:40:59 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os, sys
import shutil
import subprocess
from subprocess import check_output

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#sys.path.insert(0, os.path.abspath('.'))

# -- Custom configuration values and roles -----------------------------------
from docutils import nodes

def setup(app):
    app.add_config_value('sphinx_build_mode', '', 'env')
    app.add_role('latex', latexPassthru)

def latexPassthru(name, rawtext, text, lineno, inliner, options={}, content=[]):
    node = nodes.raw('',rawtext[8:-1],format='latex')
    return [node],[]

# -- Auto detect runs on readthedocs.org -------------------------------------
running_on_rtd = False

# Get current doxygen version
# (there may not be one in the system $PATH)
try:
    out = check_output(["doxygen","-v"])
    doxygen_version = out.strip().decode('utf-8')
    print("Doxygen version found in $PATH: %s" % (doxygen_version))
except:
    print("No doxygen found in system $PATH")
    pass

# Detect if we are running on readthedocs.org
out = check_output(["pwd"])
out = out.strip().decode('utf-8')
# On RTD you would see something like:
# /home/docs/checkouts/readthedocs.org/user_builds/mom6devesmgnew/checkouts/latest/docsNew
if out.find('readthedocs.org') >= 0:
    running_on_rtd = True

# -- Clean out generated content ---------------------------------------------

# Running build-sphinx for html and latexpdf requires a rebuild of auto
# generated content.  Intermediate rendering for html and pdf are very
# different.  For each pass through build-sphinx, we remove intermediate
# content.

if os.path.isdir("api/generated"):
    shutil.rmtree("api/generated/")

if os.path.isdir("xml"):
    shutil.rmtree("xml")

if os.path.isfile("MOM6.tags"):
    os.unlink("MOM6.tags")

# Make sure there is a _build directory (this might be different
# so we can do better than blindly check here) TODO
if not(os.path.isdir("_build/html")):
    os.makedirs("_build/html")

# -- Determine how sphinx-build was called -----------------------------------

# Determine how sphinx-build called.  This is helps create proper content
# for html vs latex/pdf
sphinx_build_mode = "undefined"

# hunt for -M (or -b) and then we want the argument after it
#import pdb; pdb.set_trace()
if '-M' in sys.argv:
    idx = sys.argv.index('-M')
    sphinx_build_mode = sys.argv[idx+1]
elif '-b' in sys.argv:
    idx = sys.argv.index('-b')
    sphinx_build_mode = sys.argv[idx+1]

# RTD has a special mode: readthedocs => html
if sphinx_build_mode == 'readthedocs':
    sphinx_build_mode = 'html'

print("Sphinx-build mode: %s" % (sphinx_build_mode))

# -- Configure binary and doxygen configuration files ------------------------

# Default binary and configuration file
doxygen_bin = 'doxygen'
doxygen_conf = 'Doxyfile_rtd'

if os.environ.get('NCAR_FORK'):
    doxygen_conf = 'ncar/Doxyfile_ncar_rtd'

if os.path.exists('./doxygen/bin/doxygen'):
    doxygen_bin = './doxygen/bin/doxygen'

# User specified binary and configuration file
if os.environ.get('DOXYGEN_BIN'):
    if os.path.exists(os.environ.get('DOXYGEN_BIN')):
        doxygen_bin = os.environ.get('DOXYGEN_BIN')
if os.environ.get('DOXYGEN_CONF'):
    if os.path.exists(os.environ.get('DOXYGEN_CONF')):
        doxygen_conf = os.environ.get('DOXYGEN_CONF')

# -- Run the normal doxygen for the RTD sphinx run ------------------------

out = check_output([doxygen_bin,"-v"])
doxygen_version = out.strip().decode('utf-8')
print("Running Doxygen %s" % (doxygen_version))
doxygenize = "%s %s" % (doxygen_bin, doxygen_conf)
print("Running: %s" % (doxygenize))
return_code = subprocess.call(doxygenize, shell=True)
if return_code != 0: sys.exit(return_code)

# -- General configuration (sphinx) ---------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
        'sphinxcontrib.bibtex',
        'sphinx.ext.ifconfig',
        'sphinxcontrib.autodoc_doxygen',
        'sphinxfortran.fortran_domain',
]
bibtex_bibfiles = ['ocean.bib', 'references.bib', 'zotero.bib']

autosummary_generate = ['api/modules.rst', 'api/pages.rst']
doxygen_xml = 'xml'

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'MOM6'
copyright = u'2017-2022, MOM6 developers'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '0.2a3'
# The full version, including alpha/beta/rc tags.
release = '0.2a3'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build', 'details', 'src', 'Thumbs.db', '.DS_Store']

# The reST default role (used for this markup: `text`) to use for all
# documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'default'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
keep_warnings = True

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
#html_static_path = ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
#html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'MOM6doc'

# -- Options for LaTeX output ---------------------------------------------

# authors variable automatically adds \\and within sphinx
authors = u'Alistair Adcroft, Robert Hallberg, Stephen Griffies, Matthew Harrison, Brandon Reichl, Niki Zadeh, John Krasting, Nic Hannah'
latex_authors = authors.replace(', ', '\\and ').replace(' and ', '\\and and ')

latex_elements = {
# The paper size ('letterpaper' or 'a4paper').
#'papersize': 'letterpaper',

# The font size ('10pt', '11pt' or '12pt').
#'pointsize': '10pt',

# Additional stuff for the LaTeX preamble.
#'preamble': '',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
  ('index', 'MOM6.tex', u'MOM6 Documentation',
   latex_authors, 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('index', 'mom6', u'MOM6 Documentation',
     [authors], 1)
]

# If true, show URL addresses after external links.
#man_show_urls = False

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
  ('index', 'MOM6', u'MOM6 Documentation',
   authors, 'One line description of project.',
   'Miscellaneous'),
]

# Documents to append as an appendix to all manuals.
#texinfo_appendices = []

# If false, no module index is generated.
#texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
#texinfo_no_detailmenu = False
