# Autoconf Build Configuration

This directory contains the configuration files required to build MOM6 using
Autoconf.

Note that a top-level `./configure` is not contained in the repository, and the
instruction below will generate this script in the `ac` directory.


# Requirements

The following tools and libraries must be installed on your system.

* Autoconf
* Fortran compiler (e.g. GFortran)
* MPI (e.g. Open MPI, MPICH)
* netCDF, with Fortran support

On some platforms, such as macOS, the Autoconf package may also require an
installation of Automake.

Some packages such as netCDF may require an additional packages for Fortran
support.


# Quick start guide

The following instructions will allow a new user to quickly create a MOM6
executable for ocean-only simulations.

Before starting, ensure that all submodules have been updated.
```
$ git submodule update --init --recursive
```

Next, fetch the GFDL `mkmf` build tool and build the FMS framework library.

For new users, a separate Makefile in `./ac/deps/` is provided for this step.
```
$ cd ac/deps
$ make -j
```

To build MOM6, first generate the Autoconf `configure` script in `./ac`.
```
$ cd ../..          # Return to the root directory
$ cd ac
$ autoreconf
```
Then select your build directory, run the configure script, and build the
model.

The instructions below build the model in the `./build` directory.
```
$ cd ..             # Return to the root directory
$ mkdir -p build
$ cd build
$ ../ac/configure
$ make -j
```
This will create the MOM6 executable in the build directory.

The steps above will produce an executable for ocean-only simulations, and
cannot be used for coupled modeling.  It also requires the necessary experiment
configuration files, such as `input.nml` and `MOM_input`.  For more
information, consult the [MOM6-examples
wiki](https://github.com/NOAA-GFDL/MOM6-examples/wiki).


# Build rules

The Makefile produced by Autoconf provides the following rules.

`make`

  Build the MOM6 executable.

`make clean`

  Delete the executable and any object and module files, but preserve the
  Autoconf output.

`make distclean`

  Delete all of the files above, as well as any files generated by
  `./configure`.  Note that this will delete the Makefile containing this rule.

`make ac-clean`

  Delete all of the files above, including `./configure` and any other files
  created by `autoreconf`.  As with `make distclean`, this will also delete the
  Makefile containing this rule.


# Build configuration settings

Autoconf will resolve most model dependencies, and includes the standard set of
configuration options, such as `FC` or `FCFLAGS`.  The `configure` settings
specific to MOM6 are described below.

`--enable-asymmetric`
  
  The MOM6 executable is configured to use symmetric grids by default.

  Use the flag above to compile using uniform (asymmetric) grids.

  Symmetric grids are defined such that the fields for every C-grid cell are 
  fully specified by their local values.  In particular, quantities such as 
  velocities or vorticity are defined along the boundaries of the domain.

  Use of symmetric grids simplifies many calculations, but also results in
  nonuniform domain sizes for different fields, and slightly greater storage
  since the additional values can be considered redundant.

`--enable-openmp`

  Use this flag to enable OpenMP in the build.

`--disable-real-8`

  While MOM6 does not explicitly use double precision reals, most of the
  algorithms are designed and tested under this assumption, and the default
  configuration is to enforce 8-byte reals.

  This flag may be used to relax this requirement, causing the compiler to use
  the default size (usually single precision reals), although there is no
  guarantee that the model will be usable.

For the complete list of settings, run `./configure --help`.


# GFDL Dependencies

This section briefly describes the management of the `mkmf` and FMS
dependencies.

When building MOM6, the `configure` script will first check if the compiler and
its configured flags (`FCFLAGS`, `LDFLAGS`, etc.) can locate `mkmf` and the FMS
library.  If unavailable, then it will search in the local `ac/deps` library.
If still unavailable, then the build will abort.

The dependencies are not automatically provided in `ac/deps`.  However, running
`make -C ac/deps` will fetch and build them.  If the user wishes to target an
external FMS library or `mkmf` tools, then they should set `PATH`, `FCFLAGS`
and `LDFLAGS` so that `configure` can locate them.

Exported environment variables such as `FC` or `FCFLAGS` will be passed to the
corresponding `configure` scripts.

The following configuration options are also provided, which can be used to
specify the git URL and commit of the dependencies.

`MKMF_URL` (*default:* https://github.com/NOAA-GFDL/mkmf.git)

`MKMF_COMMIT`(*default:* `master`)

`FMS_URL` (*default:* https://github.com/NOAA-GFDL/FMS.git)

`FMS_COMMIT` (*default:* `2019.01.03`)


# Known issues / Future development

## MPI configuration

There are minor issues with the MPI configuration macro, where it may use an
MPI build wrapper (e.g. `mpifort`)  whose underlying compiler does not match
the `FC` compiler, which will often be auto-configured to `gfortran`.

This is usually not an issue, but can cause confusion if `FCFLAGS` is
configured for the MPI wrapper but is incompatible with the `FC` compiler.

To resolve this, ensure that `FC` and `FCFLAGS` are specified for the same
compiler.


## Coupled builds

The Autoconf build is currently only capable of building ocean-only
executables, and cannot yet be used as part of a coupled model, nor as a
standalone library.  This is planned to be addressed in a future release.
