import json
import numpy as np
import onnxruntime as ort

# 1. Load Configuration
with open("model/model_config.json", "r") as f:
    config = json.load(f)

# Extract scaling stats
feats_min = np.array(config["scaling"]["features_min"])
feats_max = np.array(config["scaling"]["features_max"])
target_min = config["scaling"]["target_min"]
target_max = config["scaling"]["target_max"]

# 2. Prepare Dummy Input (Batch=1, Steps=30, Feats=4)
# Simulating raw sensor data
raw_input = np.random.uniform(low=40, high=80, size=(1, 30, 4)).astype(np.float32)

# 3. Preprocessing (Normalize)
input_normalized = (raw_input - feats_min) / (feats_max - feats_min + 1e-8)
input_normalized = input_normalized.astype(np.float32)

# 4. Run Inference
session = ort.InferenceSession("model/noise_model.onnx")
outputs = session.run(None, {"input": input_normalized})

# 5. Post-processing (Denormalize)
pred_normalized = outputs[0][0][0]
pred_db = pred_normalized * (target_max - target_min) + target_min

print(f"Predicted Noise Level: {pred_db:.2f} dB")
