## Model Info
This repository contains a machine learning model developed in collaboration between [**University College Dublin (UCD)**](https://www.ucd.ie/cs/) and [**Ubiwhere**](https://www.ubiwhere.com/) as part of the [**MLSysOps**](https://mlsysops.eu/) project.

The model is deployed on edge devices within [**Smart Lampposts**](https://www.ubiwhere.com/en/products/smart-cities/smart-lamppost) in Aveiro, Portugal. It performs **Noise Level Prediction** to estimate future environmental noise levels based on real-time traffic and pedestrian activity.

By predicting noise levels in advance, this model enables proactive urban management, such as dynamic lighting adjustment or alerting city operators to potential noise pollution events before they escalate.

The model is exported in **ONNX format (Opset 18)** to ensure high-performance, low-latency inference on edge hardware (e.g., NVIDIA Jetson).

### Purpose
This model performs Time-Series Regression to predict a continuous value:

- **Input:** A sequence of past 30 readings (Noise Level, Cars, Motorcycles, People).
- **Output:** Predicted Noise Level (dB) for the next time step.

## Repository Structure

The repository provides the trained model and its configuration for easy deployment.

```Plaintext
.
├── inference_demo.py      # Full inference script (loads config and model)
├── model/                 # Directory containing the ONNX model and config
│   ├── noise_model.onnx
│   └── model_config.json
├── requirements.txt       # Python dependencies
└── README.md              # Project documentation
```

## Training Data

The model was trained on real-world sensor data collected by Ubiwhere from a **Smart Lamppost** installed in Aveiro, Portugal.

The Smart Lamppost is a modular urban infrastructure equipped with video and sound sensors (camera and microphone) to capture environmental and traffic-related data.

**Time Period:** 2025-08-22 to 2025-08-29

The complete training dataset is publicly available on Zenodo:
[Ubiwhere Smart Lamppost Dataset](https://zenodo.org/records/18245141)

### Features Used
The model uses a multivariate approach, correlating traffic density with noise levels:

**1. Noise Level (Target):** Measured environmental noise (dB).
**2. Car Detections:** Count of cars detected.
**3. Motorcycle Detections:** Count of motorcycles detected.
**4. Person Detections:** Count of pedestrians detected.

*Note:* Other metrics present in the raw dataset (CPU Usage, Jetson Energy, Temperature, etc.) were excluded to focus purely on the noise-traffic relationship

## Model Architecture

This model utilizes a Multivariate Long Short-Term Memory (LSTM) network, fully converted to ONNX:

**1. Input Layer:** Accepts a sequence of shape (Batch, 30, 4) (30 time steps, 4 features).
**2. LSTM Layers:** Two stacked LSTM layers with 64 hidden units each to capture temporal dependencies.
**3. Output Layer:** A Linear layer that maps the final hidden state to a single scalar prediction (Noise Level).

This architecture allows the model to understand "inertia" (e.g., noise tends to stay high) and "causality" (e.g., a spike in cars leads to a spike in noise).

## Model Specification

### Inputs
The model accepts a single tensor representing a history window.

| Input Name | Shape | Type | Description |
|----|----|----|----|
| `input` | `[batch_size, 30, 4]` | `float32` | Normalized history of the last 30 time steps. |

### Feature Order (Last Dimension):

1. Noise Level
2. Car Detections
3. Motorcycle Detections
4. Person Detections

### Outputs

| Output Name | Shape | Type | Description |
|----|----|----|----|
| `input` | `[batch_size, 1]` | `float32` | Normalized predicted noise level for the next step. |

### Limitations

- **Normalization Required:** The model expects input values normalized between 0 and 1. Raw sensor data must be scaled using the min/max values found in `model_config.json` before inference.

- **Location Specific:** This model is trained on data from a specific street in Aveiro. Deploying it in a different environment (e.g., a highway or a quiet park) may require fine-tuning.

## Usage Demo
To run this model, follow the steps below.

### 1. Setup Environment

```Python
python3.13 -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

### 2. Run Inference Script

Alternatively, you can directly run the script included in this Zenodo record to see a demonstration:

```bash
python inference_demo.py
```

## Citation
If you wish to cite **this specific model**, please use the citation generated by Zenodo (located in the right sidebar of this record).

## Acknowledgement & Funding
This work is part of the **MLSysOps** project, funded by the European Union’s Horizon Europe research and innovation programme under grant agreement No. 101092912.

More information about the project is available at https://mlsysops.eu/