# Release notes for MUSE v1.5.0 (July 31, 2025)

These are the main changes in MUSE v1.5.0.

This should be free of breaking changes, however there are several improvements designed to improve the user experience, so you should read carefully.

## Improvements to the input data format

The most significant change in this release is a substantial improvement to the code that reads MUSE input files.
From a developer perspective, these changes greatly improve maintainability and ease of future feature addition.
In addition, these changes have several implcations for users designed to improve the overall experience of working with MUSE.

Some of the main changes for users are as follows:

- Generally improved error messages.
- Standardised column names to use snake_case throughout (e.g. "commodity_type" instead of "CommodityType" or "commodity type").
The purpose of this is to make the format more consistent and less confusing for new users,
and to align column names with their internal data structures which will help with debugging and clarify error messages.

  There are also several other changes to column names, for example:
  - "year" instead of "Time"
  - "technology" instead of "ProcessName"
  - "region" instead of "RegionName"

  Whilst every effort has been made to ensure that existing files will still work (with appropriate conversion internally), this cannot be guaranteed for all future releases.
  Therefore, you are very much advised to read the new documentation now and modify your files to follow the new standard.

- Units rows and columns are no longer required. In general, users are advised to limit unit definitions to the global commodities file, and the currency unit in the settings file (see below). All other parameter units can be inferred based on these, and it's up to the user to ensure that units are consistent.
- Several previously mandatory parameters are now optional, with default values specified in the documentation. For example, capital costs, variable cost and fixed cost parameters are now optional, defaulting to a cost of zero and an exponent of 1. I cannot list all parameters here, so you are encouraged to look at the documentation yourself.
- Commodity input/output and price projections files no longer require columns for all commodities. Values for missing commodities will default to zero.

You are encouraged to look at the new documentation [here](https://muse-os.readthedocs.io/en/v1.4.3/inputs/index.html), as well as the [tutorials](https://muse-os.readthedocs.io/en/v1.4.3/user-guide/index.html).

The example models have been simplified in line with these changes (for example, compare the new default model [here](https://github.com/EnergySystemsModellingLab/MUSE_OS/tree/v1.5.0/src/muse/data/example/default) with the previous version [here](https://github.com/EnergySystemsModellingLab/MUSE_OS/tree/v1.4.3/src/muse/data/example/default)).

The core changes to the code can be found in: {github}`724`, {github}`746`, {github}`749`, {github}`750`

## Added a `currency` parameter to the settings file ({github}`740`)

Allows users to specify a single currency that all monetary parameters must be expressed in (e.g "USD").
This can be whatever you like, and will not be directly used in the model, but is useful for documentation purposes and will also be outputted along with the commodity prices results, as long as commodity units are also defined.
See documentation for the parameter [here](https://muse-os.readthedocs.io/en/latest/inputs/toml.html#main-section).

## Fixed an issue where commodity prices of zero were not included in the output ({github}`738`)

Prices output files will now include rows for commodities that have a price of zero, which were previously omitted.
This is to remove potential pitfalls when plotting prices (see {github}`734`).

## Fixed bugs with flexible inputs ({github}`755`)

Users trying to use flexible inputs in previous versions would have run into problems, as this was a poorly tested feature with some implementation bugs. These are now fixed.
