# Release notes for MUSE v1.4.0 (April 3, 2025)

These are the main changes in MUSE v1.4.0.

_Please read carefully if upgrading from an earlier version, as some of the changes may require you to modify your model input files._

## Main changes

### `GrowthSeed` parameter ({github}`680`)

- A new parameter has been added to address issues with growth initiation for new technologies.
- This is related to the `MaxCapacityGrowth` limit, which provides an upper limit on year-on-year percentage growth in technology uptake. Whilst this can provide an important and realistic limit for established technologies, a hard limit on percentage growth can be overly restrictive for new technologies and stunt their initial adoption. (At the extreme end, a percentage growth limit on a technology with zero existing capacity will prevent any investment in that technology*).
- To address this, a new `GrowthSeed` parameter has been added. Effectively this represents the point at which the `MaxCapacityGrowth` constraint comes into full force, with a relaxed limit below this.
- Please read the documentation [here](https://muse-os.readthedocs.io/en/latest/inputs/technodata.html) for more details (scroll down to the "GrowthSeed" section).
- Users can be manually set this parameter for each technology by adding a new "GrowthSeed" column to their technodata files. __If this parameter isn't set by the user, it will default to 1 for all technologies.__
- __If using the `MaxCapacityGrowth` constraint, it's crucial to understand the significance of this parameter, and set appropriate values for the technologies in your model.__ Any questions, please ask.
- (*The previous approach to deal with this was to completely relax the `MaxCapacityGrowth` in the first year that a technology was invested in, but this often led to unrealistic growth trajectories, hence the need for a more nuanced method.)

### Growth constraint parameters are no longer mandatory ({github}`668`)

- The `MaxCapacityGrowth`, `MaxCapacityAddition` and `TotalCapacityLimit` parameters were previously mandatory when using the `max_capacity_expansion` constraint (turned on by default). If a user did not wish to apply any of these limits (i.e. unbound limits in technology growth or capacity), a common behaviour was set these parameters to very high values to effectively remove the limit.
- To ease this scenario, all three of these parameters have now been made optional. Omitting any of these columns from a technodata file simply means that that limit will not apply in that sector.
- For example, a user may wish to remove limits on technology growth in absolute and percentage terms, but still maintain a fixed upper limit on total capacity. In this case, the user should remove the `MaxCapacityGrowth` and `MaxCapacityAddition` columns, but keep the `TotalCapacityLimit` column in place.
- See documentation [here](https://muse-os.readthedocs.io/en/latest/inputs/technodata.html) for more details.

### Changed default `dispatch_production` method ({github}`681`)

- The default option was previously "max_production" (although this was undocumented).
- This has been changed to "share", and the [documentation](https://muse-os.readthedocs.io/en/latest/inputs/toml.html#standard-sectors) has been updated.
- __Note: If you were not previously specifying this in your settings file (i.e. relying on the default value), your results may change.__

### New tutorial: Subsectors in MUSE ({github}`690`)

- A new tutorial has been added that demonstrates splitting a sector into multiple subsectors, and the potential benefits of doing so.
- You can find this tutorial [here](https://muse-os.readthedocs.io/en/latest/user-guide/subsectors.html).

### Changes to example models ({github}`672`)

- The example models have been updated to follow a simpler, less redundant folder structure.
- In short, we no longer follow the convention of splitting inputs into "technodata" and "input" folders, but maintain folders for each model sector. See {github}`672` for more details.
- These changes do not affect any results, and will not affect existing models, but represent a new standard which users are encouraged to follow. Users are still able to structure their model files any way they choose, so long as files are linked properly in the settings file.

## Bug fixes

### Fixed a major issue for sectors with multiple subsectors ({github}`685`)

- Fixed an error for sectors with multiple subsectors, in which commodity demands were not being appropriately distributed between subsectors.
- See {github}`685` for more details.

### Fixed a bug for technologies with 0% interest rates ({github}`673`)

- Fixed an error that was raised if technology interest rates were set to zero (related to the calculation of the capital recovery factor).
- See {github}`673` for more details.

### Fixed the `same_enduse` and `spend_limit` filters ({github}`670`)

- These were previously not working due to a bug introduced in v1.3.2

## Deprecated features

- Retrofit agents will be deprecated in a future release, so a warning is now raised if these are present in your model.
