# Release notes for MUSE v1.3.0 (December 3, 2024)

These are the main changes in MUSE v1.3.0.

Please read carefully if upgrading from an earlier version, as some of the changes may require you to modify your model input files.

## New `timeslice_level` parameter ({github}`550`)

- Users can now specify a timeslice level for each sector using the new `timeslice_level` parameter (for example `timeslice_level = "month"`).
- This is the level of timeslice granularity over which commodity flows out of a sector are balanced with demand. For example, a user modelling an oil sector may wish to specify that oil supply must match demand on a monthly basis, but not necessarily in every hour (as oil can be stored).
- See documentation for this parameter [here](https://muse-os.readthedocs.io/en/latest/inputs/toml.html#standard-sectors). More details can also be found at {github}`550`.
- Note: This supersedes the timeslice aggregation feature in previous versions of MUSE. If you have a `timeslices.aggregates` section in your settings file, this should be deleted, otherwise a warning will be raised.

## Default solver ({github}`587`)

- The default solver has changed to "scipy" (previously "adhoc")
- If the `lpsolver` field is left blank for any subsector, a warning will be raised and "scipy" will be used. If you wish to use the "adhoc" solver, you __must__ specify `lpsolver = "adhoc"`.
- Users are encouraged to use the "scipy" solver for all subsectors, unless memory limits are reached (see {github}`389`)

## Added support for Python 3.13 ({github}`564`)

- MUSE now works with Python versions 3.9 to 3.13
- Python 3.9 reaches its end of life [next year](https://devguide.python.org/versions/), so if you are currently using Python 3.9, now is a good opportunity to upgrade

## Bug fixes

- A major error with the "comfort", "efficiency", "capital_costs" and "ALCOE" objectives has been fixed ({github}`581`).
- Processing of the `AgentShare` parameter (agents file and technodata files) has changed to enforce consistency between files ({github}`586`). If you receive a new `AgentShareNotDefined` error, please double check that your `AgentShare` names are consistent between your agents and techodata files. See updated documentation [here](https://muse-os.readthedocs.io/en/latest/inputs/technodata.html).

## Deprecated features

### Outputs ({github}`548`)

- The following outputs have been deleted and can no longer be used: "timeslice_supply", "metric_supply", "yearly_supply", "metricy_supply", "timeslice_consumption", "metric_consumption", "yearly_consumption", "metricy_consumption"
- Any attempt to use these outputs will raise an error
- If you need detailed supply/consumption data for any sector, please use the "supply" and "consumption" outputs within each sector, for example (replacing `SECTOR_NAME` with the name of the sector):

  ```toml
  [[sectors.SECTOR_NAME.outputs]]
  filename = '{cwd}/{default_output_dir}/{Sector}/{Quantity}.csv'
  quantity = "supply"
  sink = "aggregate"
  ```

### Production methods ({github}`557` and {github}`559`)

- The "match" and "costed" options for the `dispatch_production` parameter have been removed
- Please see [here](https://muse-os.readthedocs.io/en/latest/inputs/toml.html#standard-sectors) for updated documentation on this parameter

### Legacy sectors ({github}`510`)

- Sectors with `type = "legacy"` are no longer supported

### Agent forecasting beyond the time interval

- Models will no longer work if the agent `forecast` parameter is set beyond the length of the time interval. For example, if the time interval is 5 years (2020, 2025, 2030 etc.), this parameter must be set to 5 years.
- Note: the parameter can still be configured in the input files (it will be removed in a future version), but models will not work if the value is different from the time interval.
