# Release notes for MUSE v1.2.3 (November 19, 2024)

These are the main changes in MUSE v1.2.0.

Please read carefully if upgrading from an earlier version, as some of the changes may require you to modify your model input files.

## Log files ({github}`560`)

- MUSE will now output two log files to the results folder whenever a simulation is run: one (`muse_info.log`) containing info and debug messages, and the other (`muse_warning.log`) containing warning messages.
- Users are particularly encouraged to consult the `muse_warnings.log` file after each run, and pay attention to any messages shown.

## `MaxCapacityGrowth` parameter ({github}`565`)

- The definition of this parameter has changed to compound growth rather than linear growth. It can now be properly interpreted as the maximum growth of the technology per year. See the documentation for this parameter [here](https://muse-os.readthedocs.io/en/latest/inputs/technodata.html)
- To give an example, if a 5 year time period is being used, a value of 0.5 previously meant that capacity was allowed to grow by 250% over the time period (0.5 x 5 x 100), but with compound growth the limit is now 660% (((1.5 ** 5) - 1) x 100)
- Users may see results change as a result of this.

## Material and Variable costs ({github}`563`)

- Fixes errors in the calculation of material and variable costs, particularly in the case of technologies with output quantities not equal to 1. See #563 for details
- This effects decision metrics, but doesn't directly effect commodity prices. There are known issues remaining in the calculation of commodity prices ({github}`551`, {github}`552`), which will be fixed separately

## Minor bug fixes

- Fixed an error introduced in v1.2.1 which caused carbon budget simulations to fail if no method options were specified ({github}`539`)
